# A New PHP Library Version

We are happy to announce the first `stable` version of the PHP wrapper library.

This version simplifies how you can interact with the API as it allows you to treat `invoices` and `payments` as PHP objects, in addition to we have supported Laravel framework integration so all you need to do is install the library:

```bash
composer require moyasar/moyasar
```

then publish configuration files using:

```bash
php artisan vendor:publish --provider="Moyasar\Providers\LaravelServiceProvider"
```

finally, set your secret API key in `.env`:

```bash
MOYASAR_API_KEY=<secret_api_key>
```

Now you can typehint `PaymentService` or `InvoiceService` in your controllers or use the `Payment` or `Invoice` facades.

Checkout our [API Documentation](https://moyasar.com/docs/api/) or our Github repository for more details [moyasar-php](https://github.com/moyasar/moyasar-php)

Happy coding friends 👋
