@extends('.site.layout.container')
@section('title',($item->name))
@section('content')

    <!--====== Page Banner Start ======-->

    <section class="page-banner">
        <div class="page-banner-bg bg_cover" style="background-image: url({{asset("/assets/site")}}/images/page-banner.jpg);">
            <div class="container">
                <div class="banner-content text-center">
                    <h2 class="title"> تفاصيل المدرب</h2>
                </div>
            </div>
        </div>
    </section>

    <!--====== Page Banner Ends ======-->

    <!--====== Teacher Details Start ======-->

    <section class="teacher-details">
        <div class="container">
            <div class="row teachers-row justify-content-center rtl-direction">
                <div class="col-lg-5 col-md-6 col-sm-8 teachers-col">
                    <div class="single-teacher-details mt-50 text-center">
                        <!--                        <div class="teacher-social">
                                                    <ul class="social">
                                                        <li><a href="#"><i class="fab fa-facebook-f"></i></a></li>
                                                        <li><a href="#"><i class="fab fa-twitter"></i></a></li>
                                                        <li><a href="#"><i class="fab fa-instagram"></i></a></li>
                                                        <li><a href="#"><i class="fab fa-linkedin-in"></i></a></li>
                                                    </ul>
                                                </div>-->
                        <div class="teacher-image">
                            <a href="#">
                                <img src="{{$item->dash_image}}" alt="teacher">
                            </a>
                        </div>
                    </div>
                </div>
                <div class="col-lg-5 teachers-col text-right">
                    <div class="teacher-details-content mt-45">
                        <h4 class="teacher-name">{{$item->dash_name}}</h4>
                        <span class="designation">{{$item->dash_currentPosition}}</span>

                        <br>
                        <br>
                        {!! $item->about !!}

                    </div>
                </div>
            </div>

            <div class="teacher-details-tab">
                <ul class="nav nav-justified" role="tablist">
                    <li class="nav-item"><a class="active" data-toggle="tab" href="#experience" role="tab">الخبرات</a></li>
                    <li class="nav-item"><a data-toggle="tab" href="#educational" role="tab">المؤهل العلمى</a></li>
                    <li class="nav-item"><a data-toggle="tab" href="#achievements" role="tab">الدورات المقدمة </a></li>
                   <!-- <li class="nav-item"><a data-toggle="tab" href="#blogs" role="tab"> المدونات</a></li>-->
                </ul>
                <div class="tab-content">
                    <div class="tab-pane fade show active" id="experience" role="tabpanel">
                        <div class="row">
                            <br>
                            {!! $item->experience !!}
                        </div>
                    </div>
                    <div class="tab-pane fade" id="educational" role="tabpanel">
                        <div class="row">
                            <br>
                            {!! $item->qualification !!}
                        </div>
                    </div>
                    <div class="tab-pane fade" id="achievements" role="tabpanel">
                        <div class="row">
                            @if($item->id == 53)
                              @foreach(\App\Course::where("id",447)->orderBy("date","ASC")->get() as $course)
                                       <?php
                                $exam = \App\question_trainer::where("course_id",$course->id)->first();
                               // dd($exam);
                                $result = \App\Result_exam::where("course_id",$course->id)->get();

                                ?>

                                <div class="col-lg-4 col-md-6 flo-right">
                                    <div class="single-blog mt-30">
                                        <div class="blog-image">
                                            <a href="{{url("courseDetails/$course->id")}}">
                                                <img src="{{$course->image}}" alt="blog">
                                            </a>
                                        </div>
                                        <div class="blog-content">
                                            <h4 class="blog-title text-right"><a href="{{url("courseDetails/$course->id")}}">{{$course->name}}</a></h4>
                                            <br>
                                        
                                          
                                        </div>
                                    </div>
                                </div>
                                @endforeach
                              @else

                            @foreach(\App\Course::where("end_date",">=",Carbon\Carbon::now()->format('Y-m-d'))->where("trainer_id",$item->id)->orderBy("date","ASC")->get() as $course)
                                     <?php
                                $exam = \App\question_trainer::where("course_id",$course->id)->first();
                               // dd($exam);
                                $result = \App\Result_exam::where("course_id",$course->id)->get();

                                ?>

                                <div class="col-lg-4 col-md-6 flo-right">
                                    <div class="single-blog mt-30">
                                        <div class="blog-image">
                                            <a href="#">
                                                <img src="{{$course->image}}" alt="blog">
                                            </a>
                                        </div>
                                        <div class="blog-content">
                                            <h4 class="blog-title text-right"><a href="#">{{$course->name}}</a></h4>
                                            <br>
                                            <p>{{$course->breif}}</p>

                                            <div class="single-form">

                                                <a href="{{url("trainees_course/$course->id")}}" class="main-btn main-btn-1 btn-block">قائمة المتدربين</a>
                                            </div>
                                            <div class="single-form">

                                                <a href="{{url("questiontrainer/$course->id")}}" class="main-btn main-btn-2 btn-block">انشاء اختبار للدورة</a>
                                            </div>
                                            <div class="single-form">

                                                <a href="{{url("course_content/$course->id")}}" class="main-btn main-btn-1 btn-block">محتوى الدورة</a>
                                            </div>
<!--                                            @if($exam ==null)
                                            <div class="single-form">

                                                <a href="{{url("questiontrainer/$course->id")}}" class="main-btn main-btn-2 btn-block">انشاء اختبار للدورة</a>
                                            </div>
                                            @else
                                                <h4 class="blog-title text-right"><a href="#">تم انشاء الاختبار</a></h4>
                                                <h8 class="blog-title text-right"><a href="#">  عدد المتدربين: {{count($result)}}</a></h8>
                                            @endif-->
                                            @if($course->meeting == 1)

                                                <div class="single-form">

                                                    <a href="{{route('zoom.join')}}#/meeting?nickname={{$item->name}}&hostId={{$course->hostId}}&meetingId={{$course->meeting_id}}&password={{$course->meeting_password}}" class="main-btn main-btn-1 btn-block">الدخول لغرفة البث</a>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                       

                            @endforeach
                            @endif
                        </div>
                    </div>
                    <div class="tab-pane fade" id="blogs" role="tabpanel">
                        <div class="row ">
                            <?php
                            $courseids=\App\Course::where("trainer_id",$item->id)->pluck('id');
                            ?>
                            @foreach (\App\Blog::whereIn('course_id',$courseids)->orderBy("id","desc")->take(6)->get() as $blog)
                                <div class="col-md-4 col-12 col-article-item text-right">
                                    <article class="article-item">
                                        <div class="article-item-container">
                                            <div class="meta-head-author">
                                                <a href="#" class="img-author">
                                                    <img src="{{$blog->course->TrainerImageicon}}" alt=" {{$blog->course->TrainerName}}">
                                                </a>
                                                <br>
                                                <br>
                                                <a href="#" class="article-author">
                                                    {{$blog->course->TrainerName}}


                                                    <span>{{$blog->course->CurrentPositiontrainer}}</span>


                                                </a>
                                            </div>
                                            <div class="article-headline1">
                                                <h2><a href="{{url("/blogDetails/$blog->id")}}">{{$blog->title_ar}}</a></h2>
                                            </div>
                                            <div class="article-excerpt">
                                                <p>{!! mb_substr(strip_tags($blog->text_ar),0,100)."....." !!}</p>
                                            </div>
                                            <a href="{{url("/blogDetails/$blog->id")}}" class="go-to-program"> إقرأ المقال</a>
                                        </div>
                                    </article>
                                </div>
                            @endforeach
                        </div>
                    </div>


                </div>
            </div>
        </div>
    </section>

    <!--====== Teacher Details Ends ======-->


@endsection
@section('extra_css')
    {{--   <style>
           .footer_sticky_part {
               padding-top: 100px !important;
           }
       </style>--}}
@endsection

