@extends('.site.layout.container')
@section('title',($user->name))
@section('content')

    <!--====== Page Banner Start ======-->

    <section class="page-banner">
        <div class="page-banner-bg bg_cover" style="background-image: url({{asset("/assets/site")}}/images/page-banner.jpg);">
            <div class="container">
                <div class="banner-content text-center">
                    <h2 class="title"> تفاصيل الحساب</h2>
                </div>
            </div>
        </div>
    </section>

    <!--====== Page Banner Ends ======-->

    <!--====== Teacher Details Start ======-->

    <section class="teacher-details">
        <div class="container">
            <div class="row teachers-row justify-content-center rtl-direction">
                <div class="col-lg-5 col-md-6 col-sm-8 teachers-col">
                    <div class="single-teacher-details mt-50 text-center">

                        <div class="teacher-image">
                            <a href="#">
                                <img src="{{$user->dash_image}}" alt="teacher">
                            </a>
                        </div>
                    </div>
                </div>
                <div class="col-lg-5 teachers-col text-right">
                    <div class="teacher-details-content mt-45">
                        <h4 class="teacher-name">{{$user->name}}</h4>
                        <p >{{$user->email}}</p>
                        <p >{{$user->mobile}}</p>

                    </div>
                </div>
            </div>

           <div class="teacher-details-tab">
                <ul class="nav nav-justified" role="tablist">
                    <li class="nav-item"><a class="active" data-toggle="tab" href="#achievements" role="tab">الدورات التى تم الاشتراك بها </a></li>
                  <!--  <li class="nav-item"><a data-toggle="tab" href="#blogs" role="tab"> المدونات</a></li-->>

                </ul>

                <div class="tab-content">

                    <div class="tab-pane fade show active" id="achievements" role="tabpanel">
                        <div class="row">
                            @foreach(\App\Order::where("trainee_id",$user->id)->where('paid',1)->orderBy("id","ASC")->get() as $course)
                               <?php
                                $exam = \App\question_trainer::where("course_id",$course->course_id)->first();
                                $result= \App\Result_exam::where("course_id",$course->course_id)->where("user_id",$user->id)->first();
                                ?>

                               {{-- <div class="col-lg-4 col-sm-6">
                                    <div class="single-content-tab">
                                        <h4 class="title">{{$course->dash_course}}</h4>
                                        <p>{{$course->dash_breif}}</p>
                                    </div>
                                </div>--}}
                                <div class="col-lg-4 col-md-6 flo-right">
                                    <div class="single-blog mt-30">
                                        <div class="blog-image">
                                            <a href="{{url("courseDetails/$course->course_id")}}">
                                                <img src="{{$course->dash_image}}" alt="blog">
                                            </a>
                                        </div>
                                        <div class="blog-content">
                                            <h4 class="blog-title text-right"><a href="{{url("courseDetails/$course->course_id")}}">{{$course->dash_course}}</a></h4>
                                            <br>
                                           <!-- <p>{{$course->dash_breif}}</p>-->
                                            @if($exam !=null and $result==null)
                                            <div class="single-form">

                                                <a href="{{url("questiontrainee/$course->course_id")}}" class="main-btn main-btn-2 btn-block"> اختبار للدورة</a>
                                            </div>
                                            @elseif($result!=null)
                                                <h4 class="blog-title text-right"><a href="#">نتيجة الاختبار :{{$result->total}}</a></h4>

                                            @endif
                                            @if($course->dashmeeting == 1)

                                            <div class="single-form">

                                                <a href="{{route('zoom.join')}}#/meeting?nickname={{$course->DashUser}}&hostId={{$course->DashhostId}}&meetingId={{$course->DashmeetingId}}&password={{$course->Dashmeetingpassword}}" class="main-btn main-btn-2 btn-block">الدخول لغرفة البث</a>
                                            </div>
                                                @endif
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>

                    <div class="tab-pane fade" id="blogs" role="tabpanel">
                        <div class="row ">
                            <?php
                            $courseids=\App\Order::where("trainee_id",$user->id)->where('paid',1)->pluck('course_id');
                            ?>
                            @foreach (\App\Blog::whereIn('course_id',$courseids)->orderBy("id","desc")->take(6)->get() as $blog)
                                <div class="col-md-4 col-12 col-article-item text-right">
                                    <article class="article-item">
                                        <div class="article-item-container">
                                            <div class="meta-head-author">
                                                <a href="#" class="img-author">
                                                    <img src="{{$blog->course->TrainerImageicon}}" alt=" {{$blog->course->TrainerName}}">
                                                </a>
                                                <br>
                                                <br>
                                                <a href="#" class="article-author">
                                                    {{$blog->course->TrainerName}}


                                                    <span>{{$blog->course->CurrentPositiontrainer}}</span>


                                                </a>
                                            </div>
                                            <div class="article-headline1">
                                                <h2><a href="{{url("/blogDetails/$blog->id")}}">{{$blog->title_ar}}</a></h2>
                                            </div>
                                            <div class="article-excerpt">
                                                <p>{!! mb_substr(strip_tags($blog->text_ar),0,100)."....." !!}</p>
                                            </div>
                                            <a href="{{url("/blogDetails/$blog->id")}}" class="go-to-program"> إقرأ المقال</a>
                                        </div>
                                    </article>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!--====== Teacher Details Ends ======-->


@endsection
@section('extra_css')
    {{--   <style>
           .footer_sticky_part {
               padding-top: 100px !important;
           }
       </style>--}}
@endsection

