@extends('.site.layout.container')
@section('title'," الاشتراك فى الدورة")

@section('content')

<!--====== Page Banner Start ======-->
<section class="page-banner">
    <div class="page-banner-bg" style="background-image: url({{asset("/assets/site/images/page-banner.jpg")}});">
        <div class="container">
            <div class="banner-content text-center">
                <h8 class="title font_baner"> {{$course->name}} </h8>
            </div>
        </div>
    </div>
</section>
<!--====== Page Banner Ends ======-->

<!--====== Blog Start ======-->
<section class="blog-area">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-12">
                <br>
                <div class="blog-wrapper margimg">
                    <div class="row blog-active2 styimg" >
                        @php
                        $cour = \App\CourseImages::where("course_id", $course->id)->first();
                        @endphp
                        <div class="col-lg-12 flo-right">
                            <div class="single-blog mt-30" style="height:52%!important">
                                <div class="blog-image">
                                    <a href="#">
                                        <img src="{{$cour->image}}" alt="blog" style="width:100%; height:100%;">
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="courses-details-tab">
                    <ul class="nav nav-tabs nav-justified" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link" data-toggle="tab" href="#breif" role="tab">{{trans('language.brief_course')}}</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-toggle="tab" href="#benefit" role="tab">مميزات الدورة</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link active" data-toggle="tab" href="#teachers" role="tab">محاور الدورة</a>
                        </li>
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane fade" id="breif" role="tabpanel">
                            <div class="breif-content">
                                {!! $course->breif !!}
                            </div>
                        </div>
                        <div class="tab-pane fade" id="benefit" role="tabpanel">
                            <div class="benefit-content">
                                {!! $course->features !!}
                            </div>
                        </div>
                        <div class="tab-pane fade show active" id="teachers" role="tabpanel">
                            <div class="courses-teachers">
                                {!! $course->description !!}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!--====== Blog Ends ======-->

<!--====== Login Start ======-->
<section class="login-register">
    <div class="container">
        <div class="row justify-content-center text-right">
            <div class="col-lg-6">
                <div class="login-register-content">
                    <h4 class="title">سجل الان</h4>
                    @if (\Session::has('error'))
                        <div class="alert alert-danger top-alert alert-icon-left mb-0 fade-message" role="alert">
                            <span class="alert-icon"><i class="fa fa-ban"></i></span>
                            <p class="mb-0">{{ \Session::get('error') }}</p>
                        </div>
                    @endif
                    <div class="login-register-form">
                        <form action="{{url("/sponsored_advertisement")}}" enctype="multipart/form-data" method="post">
                            @csrf
                            <input type="hidden" value="{{$item->id}}" name="user_id">
                            <input type="hidden" value="{{$course->id}}" name="course_id">
                            <div class="single-form">
                                <label>الاسم *</label>
                                <input type="text" name="name" class="form-control" placeholder="الاسم" required>
                            </div>
                            <div class="single-form">
                                <label> رقم الجوال*</label>
                                <input type="text" name="mobile" class="form-control" placeholder="رقم الجوال" required>
                            </div>
                            <div class="single-form">
                                <label>البريد الالكتروني *</label>
                                <input type="email" name="email" class="form-control" placeholder="البريد الالكتروني" required>
                            </div>
                            <div class="single-form">
                                <button class="main-btn btn-block" type="submit">سجل</button>
                            </div>
                            <span class="line"></span>
                            <div class="single-form">
                                <a class="main-btnw btn-block" target="_blank" href="https://api.whatsapp.com/send?phone={{$course->whatsapp}}">
                                    للاستفسار والتسجيل عبر الوتساب
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!--====== Login Ends ======-->
@endsection

@section('extra_css')
<style>
    .margimg {
        margin-bottom: 50% !important;
    }
    .styimg
    {
       height:700px !important 
    }

.nav-tabs .nav-item.show .nav-link, .nav-tabs .nav-link.active {
  
    background-color: #07294D !important;
}

    @media (max-width: 768px) {
        .courses-details-tab {
            margin-top: 0;
            padding: 20px;
            text-align: right;
        }
        .banner-content {
            padding-top: 150px;
            padding-bottom: 80px;
        }
        .nav-tabs .nav-item {
            flex-grow: 1;
            text-align: center;
        }
         .margimg {
        margin-bottom: 0 !important;
    }
 .styimg
    {
       height:403px !important 
    }
    }
</style>
@endsection

@section('extra_js')
<script>
    $(document).ready(function () {
        $('.nav-tabs a').on('click', function () {
            $(this).tab('show');
        });
    });
</script>
@endsection
