@extends('.site.layout.container')
@section('title',$item->name)
@section('content')

    <!--====== Page Banner Start ======-->

    <section class="page-banner">
        <div class="page-banner-bg bg_cover" style="background-image: url({{asset("/assets/site")}}/images/page-banner.jpg);">
            <div class="container">
                <div class="banner-content text-center">
                    <h2 class="title">{{$item->name}}</h2>
                </div>
            </div>
        </div>
    </section>

    <!--====== Page Banner Ends ======-->

    <!--====== Courses Details Start ======-->

    <section class="courses-details" style="padding-top: 0px;">
        <div class="container">
            <div class="row flex-row-reverse rtl-direction">
                <div class="col-lg-12">

                    <div class="courses-details-tab">
                        <div class="tab-content" id="myTabContent">
                            <div class="tab-pane fade show active" id="terms" role="tabpanel">
                                <div class="benefit-content">
                                    {!! $item->body !!}
                                </div>

                             
                                
                            </div>
                        </div>
                    </div>
                    @if(!empty($questions) && $questions->count())
              <div class="benefit-content">
                                    <div class="container">
                                        <div class="row text-right">
                                            <div class="col-lg-12">
                                                <div class="courses-details-tab">
                                                    <div class="login-register-content">
                                                        <div>
                                                            <h8 class="title">{{$item->title}}  </h8>
                                                        </div>
<br>
<br>

                                                        <div class="login-register-form">
                                                           


                <table class="table table-bordered" style="direction: rtl;">
    <thead>
        <tr>
            <th scope="col">م</th>
            <th scope="col">نص السؤال</th>
            <th scope="col">نعم</th>
            <th scope="col">لا </th>
        </tr>
    </thead>
    <tbody>
        @foreach($questions as $index => $question)
            <tr>
                <th scope="row">{{ $index + 1 }}</th>
                <td>{{ $question->name }}</td> <!-- Display question text -->
                <td>
                    <input class="form-check-input" type="radio" name="question_{{ $index }}" id="agree_{{ $index }}" value="أوافق">
                </td>
                
                <td>
                    <input class="form-check-input" type="radio" name="question_{{ $index }}" id="disagree_{{ $index }}" value="لا أوافق">
                </td>
            </tr>
        @endforeach
    </tbody>
</table>


                                                                <br>
                                                                <br>
                                                                <br>
                                                                <div class="single-form">
                                  
                                                                </div>
                                                            
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                       <!-- Display Questions -->
                                @if(!empty($questions) && is_array($questions))
                                    <div class="questions-section">
                                        @foreach($questions as $index => $question)
                                            <div class="question-item">
                                                <p>{{ $question->name }}</p> <!-- Adjust as per your question property -->
                                                <div class="form-group">
                                                    <label>
                                                        <input type="radio" name="question_{{ $index }}" value="yes"> نعم
                                                    </label>
                                                    <label>
                                                        <input type="radio" name="question_{{ $index }}" value="no"> لا
                                                    </label>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                @endif
                                   @endif

                    <div style="margin-top: 85px; display: flex; justify-content: space-between; width: 100%;">
                        @if($previousItem)
                            <a href="{{ url('/unit/' . $previousItem->id) }}" 
                               class="main-btn main-btn-2" 
                               style="flex: 1; background-color: #4CAF50; margin-right: 10px;">السابق</a> <!-- Change color to green -->
                        @endif

                        @if($nextItem)
                            <a href="{{ url('/unit/' . $nextItem->id) }}" 
                               class="main-btn main-btn-2" 
                               style="flex: 1; margin-left: 10px;">التالى</a>
                        @endif
                    </div>

                </div>
            </div>
        </div>
    </section>

    <!--====== Courses Details Ends ======-->

@endsection

@section('extra_css')
    <!-- Custom Styles -->
    <style>
        .questions-section {
            margin-top: 20px;
        }
        .question-item {
            margin-bottom: 15px;
        }
    </style>
@endsection
