@extends('.site.layout.container')
@section('title', 'الدورات العامة')
@section('content')

    <!--====== Page Banner Start ======-->

    <section class="page-banner">
        <div class="page-banner-bg " style="background-image: url({{ asset('/assets/site') }}/images/page-banner.jpg);">
            <div class="container">
                <div class="banner-content text-center">
                    <h2 class="title"> الدورات العامة</h2>
                </div>
            </div>
        </div>
    </section>

    <!--====== Page Banner Ends ======-->

    <section class="blog-page">

        <div class="container">
            <div class="row rtl-direction">
                <div class="col-lg-12">
                    <form method="get" action="{{ url('/courses/') }}">

                        <div style="display: flex">
                            <div class="col-md-3">
                                <select class="form-control" name="category_id">
                                    <option value="">{{ trans('language.category') }}</option>
                                    @foreach (\App\Category::all() as $selectItem)
                                        <option value="{{ $selectItem->id }}">{{ $selectItem->dash_name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3">
                                <input style="width: 45%" type="submit" class="btn btn-success "
                                    value="{{ trans('language.filter') }}">
                                <button style="width: 45%" type="submit" class="btn btn-info  reset_inputs ">اعادة
                                    البحث</button>
                            </div>

                        </div>
                    </form>
                    <br>
                    @foreach ($items as $course)
                        <div class="col-lg-4 flo-right">
                            <div class="single-blog mt-30">
                                <div class="blog-image">
                                    <a href="{{ url("/courseDetails/$course->id") }}">
                                        <img src="{{ $course->image }}" alt="blog">
                                    </a>
                                </div>
                                <!--
                                    <span class="thumbnail-author" style="background-image: url({{ $course->trainer->dash_image }})"></span>
    -->


                                <div class="article-text-container"><a href="#" rel="bookmark">
                                        <!--
            <em class="article-author">{{ $course->trainer->name }}</em>
    -->
                                        <div class="article-headline">
                                            <h2>{{ $course->name }} <span></span></h2>
                                            <div class="card_info">
                                                <span class="card_info_item">
                                                    <span class="material-icons"> <i class="fal fa-info-circle"></i> </span>
                                                    <span>
                                                        <span class="info_course_date">
                                                            {{ \Carbon\Carbon::parse($course->date)->translatedFormat('l j F Y ') }}<!--  | {{ $course->dash_city }}--></span>
                                                        @if ($course->counthour != null)
                                                            <span class="info_course_days"> {{ $course->counthour }} -
                                                                {{ $course->duration }} </span>
                                                        @endif
                                                        @if ($course->is_end == 1)
                                                            c
                                                            <span class="info_course_days">
                                                                {{ trans('language.coursedone') }} </span>
                                                        @endif
                                                    </span>
                                                </span>
                                            </div>

                                            <div class="trainer_wrap_card">
                                                <div class="thumb_trainer">
                                                    <img src="{{ $course->trainer->DashImage }}">

                                                </div>
                                                <div class="info_trainer">
                                                    <h4>{{ $course->trainer->name }}</h4>

                                                    <h5>{{ $course->trainer->current_position }}</h5>

                                                </div>
                                            </div>

                                        </div>

                                    </a>
                                    <a href="{{ url("/courseDetails/$course->id") }}" class="go-to-program"> <i
                                            class="fa fa-check-square-o" aria-hidden="true"></i> احجز مقعدك</a>
                                </div>


                                <!-- <div class="blog-content">
                                        <h4 class="blog-title text-right" ><a href="{{ url("/courseDetails/$course->id") }}">{{ $course->name }}
                                            </a></h4>
                                        <a href="{{ url("/courseDetails/$course->id") }}" class="more"><i class="fal fa-chevron-left"></i>المزيد </a>
                                    </div> -->
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
            <ul class="pagination-items text-center">
                {{ @$items->links() }}
            </ul>
        </div>
    </section>
    <!--    &lt;!&ndash;====== Counter Start ======&ndash;&gt;

        <div class="counter-area-2">
            <div class="container">
                <div class="counter-wrapper-2 " style="background-image: url({{ asset('/assets/site') }}/images/counter-bg-2.jpg);">
                    <div class="row">
                        <div class="col-sm-3 col-6 counter-col">
                            <div class="single-counter mt-30">
                                <span class="counter-count"><span class="count">3652</span> +</span>
                                <p>المتدربين</p>
                            </div>
                        </div>
                        <div class="col-sm-3 col-6 counter-col">
                            <div class="single-counter mt-30">
                                <span class="counter-count"><span class="count">105</span> +</span>
                                <p>المدربين</p>
                            </div>
                        </div>
                        <div class="col-sm-3 col-6 counter-col">
                            <div class="single-counter mt-30">
                                <span class="counter-count"><span class="count">120</span> +</span>
                                <p>الدورات</p>
                            </div>
                        </div>
                        <div class="col-sm-3 col-6 counter-col">
                            <div class="single-counter mt-30">
                                <span class="counter-count"><span class="count">30</span> +</span>
                                <p>الجوائز</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        &lt;!&ndash;====== Counter Ends ======&ndash;&gt;-->


@endsection
@section('extra_css')
    {{--   <style>
        .footer_sticky_part {
            padding-top: 100px !important;
        }
    </style> --}}
@endsection
