@extends('.site.layout.container')
@section('title',($item->name))
@section('content')

    <!--====== Page Banner Start ======-->

    <section class="page-banner">
        <div class="page-banner-bg " style="background-image: url({{asset("/assets/site")}}/images/page-banner.jpg);">
            <div class="container">
                <div class="banner-content text-center">
                    <h2 class="title">تفاصيل الدورة</h2>
                </div>
            </div>
        </div>
    </section>

    <!--====== Page Banner Ends ======-->
    <!--====== New Page content ======-->

    <div class="container">
        <div class="intro_course_wrapper content_product_wrapper">

            <div class="woocommerce-notices-wrapper"></div>
            <div id="product-189"
                 class="row rtl-direction product type-product post-189 status-publish first instock product_cat-documenting-business-process has-post-thumbnail shipping-taxable purchasable product-type-simple">

                <div class="col-md-6 woocommerce-product-gallery woocommerce-product-gallery--with-images woocommerce-product-gallery--columns-4 images"
                     data-columns="4" style="opacity: 1; transition: opacity 0.25s ease-in-out 0s;">
                    <figure class="woocommerce-product-gallery__wrapper">
                        <div data-thumb="https://es-learning.com/wp-content/uploads/2023/03/pdp-100x100.jpg"
                             data-thumb-alt="{{$item->name}}"
                             class="woocommerce-product-gallery__image"><a
                                href="{{url("/courseDetails/$item->id")}}"><img width="600"
                                                                                src="{{$item->image}}"
                                                                                class="wp-post-image" alt="{{$item->name}}" decoding="async"
                                                                                loading="lazy" title="{{$item->name}}"
                                                                                data-caption="الاحتراف في توثيق الإجراءات بمنهجية PDxel"
                                                                                data-src="{{$item->image}}"
                                                                                data-large_image="{{$item->image}}"
                                                                                data-large_image_width="1280" data-large_image_height="720"
                                                                                srcset="{{$item->image}} 600w, {{$item->image}} 300w, {{$item->image}} 1024w, {{$item->image}} 768w, {{$item->image}} 1280w"
                                                                                sizes="(max-width: 600px) 100vw, 600px"></a></div>
                    </figure>
                </div>

                <div class="col-md-6 summary entry-summary">
                    <h1 class="product_title entry-title">{{$item->name}}
                        <span>({{ \Carbon\Carbon::parse($item->date)->translatedFormat('l j F Y ') }})</span></h1>
                    <p class="price"><span class="woocommerce-Price-amount amount"><bdi class="price-cloo">{{$item->price}}&nbsp;<span
                                    class="woocommerce-Price-currencySymbol">ر.س</span></bdi></span></p>

                    <div class="woocommerce-product-details__short-description">
                        <div class="infos__wrapper">
                            <div class="article-timestamp-product">
                                <div class="article-timestamp">
                                    <div class="info-meta">
                                    <span><span class="material-icons"> <i class="far fa-calendar-alt"></i> </span><label>تاريخ البدء: </label>
                                        {{ \Carbon\Carbon::parse($item->date)->translatedFormat('l j F Y ') }}</span>
                                      <span><span
                                                class="material-icons"> <i class="fas fa-map-marker"></i> </span><label>  </label>{{ $item->dash_city}}
                                        </span>

                                        <span>
                                              @if($item->counthour !=null)
                                                <span class="material-icons">

                                                <i class="fal fa-clock"></i>
                                        </span>
                                                <label> عدد الساعات: </label> {{$item->counthour}}
                                            @endif
                                    </span>

                                        <span>
                                              @if($item->counthour !=null)
                                                <span class="material-icons">

                                                <i class="fal fa-clock"></i>
                                        </span>
                                                <label>عدد الايام: </label>  {{$item->duration}}
                                            @endif
                                    </span>

                                        <span>

                                            <span class="material-icons"> <i class="fas fa-people-arrows"></i>
                                        </span><label>النقاش ولغة المدرب: </label> {{$item->dash_lang}}</span>

                                        <span>

                                            <span
                                                class="material-icons"> <i class="fal fa-globe-americas"></i> </span>
                                              <span>
                                                <label>اللغة: </label>
                                        {{$item->dash_lang}}</span>




                                     @if($item->is_close == 0)
                                                <span class="material-icons">
                                        </span>
                                                <form  action="{{url("/confirm-enroll_course")}}"
                                                       enctype="multipart/form-data" method="post">
                                                    @csrf
                                                   <input type="hidden" name="course_id" value="{{$item->id}}">
                                                   <button type="submit" style="    text-align-last: start !important;
                                                   left: 0px!important;
                                                   width: 38%!important;
                                                   bottom: 1%!important;
                                                   "  class="go-to-program"> <i class="fa fa-check-square-o" aria-hidden="true"></i> اشترك الآن</button>

                                               </form>

                                        </span>
                                        @endif
                                        @if($item->link_youtube != null)
                                            <div>
                                                <iframe width="420" height="200" src="{{$item->link_youtube}}">
                                                </iframe>
                                            </div>
                                        @endif

                                    </div>


                                </div>
                            </div>
                        </div>

                    </div>




                </div>

            </div>

        </div>
    </div>

    <div class="container2">


        <div class="content_course_wrapper">
            <div class="container">
                <div class="row rtl-direction rtl-txt">
                    <div class="col-12 col-md-8">
                        <div class="content_program content_main">
                            @if($item->goal!=null)
                                <h3>الهدف </h3>

                                {!!$item->goal!!}
                                &nbsp;
                            @endif
                            @if($item->description!=null)
                                <h3>المحاور</h3>
                                {!! $item->description !!}
                                &nbsp;
                            @endif

                            @if($item->offer!=null)
                                <h3>عروض الدورات</h3>
                                {!! $item->offer !!}
                                &nbsp;
                            @endif
                            @if($item->breif!=null)
                                <h3>الفئة المستهدفة</h3>
                                {!!$item->breif!!}
                                &nbsp;
                            @endif
                            @if($item->features!=null)
                                <h3>المميزات</h3>
                                {!! $item->features !!}
                            @endif



                        </div>
                    </div>
                    <div class="col-12 col-md-4">
                        <div class="sidebar">
                            <div class="trainer_wrap_card">
                                <div class="thumb_trainer">
                                    <a href="{{url("/trainer-details/$item->trainer_id")}}"><img src="{{$item->trainer->dash_image}}" alt="{{$item->trainer->name}}"></a>

                                </div>
                                <div class="info_trainer">
                                    <h4><a href="{{url("/trainer-details/$item->trainer_id")}}">{{$item->trainer->name}}</a></h4>
                                    <h5>{{@$item->trainer->dash_currentPosition}}</h5>



                                </div>



                            </div>
                        </div>
<br>
                        <div>
                            @if($item->id==447)
                               <a href="{{ url('/unit/' . 1) }}" 
           class="main-btn main-btn-2" 
           style="flex: 1; margin-left: 10px;">المحتوى النصى للدورة</a>
                           
                            @endif
                              <br>
                                @if($item->pdf_instruction!=null)
                            <br>
                            <li> <a href="{{$item->pdf_instruction}}" target="_blank"><i class="fa fas fa-download" aria-hidden="true"></i> تعليمات كيفية البدء </a>
                            </li>
                                @endif
                                @if($item->pdf_contact!=null)
                            <br>
                            <li> <a href="{{$item->pdf_contact}}" target="_blank"><i class="fa fas fa-download" aria-hidden="true"></i> شرح اداب التواصل</a>
                            </li>
                                @endif
                                @if($item->pdf_policy_trainer!=null)
                            <br>
                            <li> <a href="{{$item->pdf_policy_trainer}}" target="_blank"><i class="fa fas fa-download" aria-hidden="true"></i> سياسة للإجابة على استفسارات المتدرب </a>
                            </li>
                                @endif
                                @if($item->pdf_self_evaluation!=null)
                            <br>
                            <li> <a href="{{$item->pdf_self_evaluation}}" target="_blank"><i class="fa fas fa-download" aria-hidden="true"></i> التقييم الذاتي</a>
                            </li>
                                @endif
                                @if($item->pdf_techniques!=null)
                            <br>
                            <li> <a href="{{$item->pdf_techniques}}" target="_blank"><i class="fa fas fa-download" aria-hidden="true"></i> التقنيــــات التي يحتاجها المتدرب والمدرب</a>
                            </li>
                                @endif
                                @if($item->pdf_skills!=null)  
                            <br>
                            <li> <a href="{{$item->pdf_skills}}" target="_blank"><i class="fa fas fa-download" aria-hidden="true"></i>دليل المعارف والمهارات</a>
                            </li>
                                @endif

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--====== Courses Details Start ======-->



    <!--====== Courses Details Ends ======-->


@endsection
@section('extra_css')


    {{--  <style>

          .select{
              height:50px;
              overflow:scroll;
              overflow-x: hidden;
          }
        </style>--}}
@endsection

