@extends('.site.layout.container')
@section('title'," التواصل مع القسم التقنى")
@section('content')

    <!--====== Page Banner Start ======-->

    <section class="page-banner">
        <div class="page-banner-bg bg_cover" style="background-image: url({{asset("/assets/site")}}/images/page-banner.jpg);">
            <div class="container">
                <div class="banner-content text-center">
                    <h2 class="title">التواصل مع القسم التقنى</h2>
                </div>
            </div>
        </div>
    </section>

    <!--====== Page Banner Ends ======-->

    <!--====== Courses Details Start ======-->

    <section class="courses-details" style="padding-top: 0px;">
        <div class="container">
            <div class="row rtl-direction text-right">
                <div class="col-md-4">
                    <div class="single-contact-info mt-30">
                        <div class="info-icon">
                            <i class="fas fa-phone"></i>
                        </div>
                        <div class="info-content">
                            <h5 class="title">رقم التواصل</h5>
                            <p><a href="tel:00966-5951-49449">00966-5951-49449</a></p>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="single-contact-info mt-30">
                        <!--                                                <div class="info-icon">
                                                                            <i class="fas fa-map-marker-alt"></i>
                                                                        </div>-->
                        <!--                                                <div class="info-content">
                                                                            <h5 class="title">العنوان</h5>
                                                                            <p>King Abdul Aziz Rd, King Abdul Aziz, Riyadh 12431, Saudi Arabia</p>
                                                                        </div>-->
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="single-contact-info mt-30">
                        <!--                                                <div class="info-icon">
                                                                            <i class="far fa-globe"></i>
                                                                        </div>
                                                                        <div class="info-content">
                                                                            <h5 class="title">البريد الالكتروني</h5>
                                                                            <p><a href="mailto:info@gmc-sa.net">info@gmc-sa.net</a></p>
                                                                        </div>-->
                    </div>
                </div>
            </div>
            <div class="row flex-row-reverse rtl-direction">
                <div class="col-lg-12">

                    <div class="courses-details-tab">
                        <ul class="nav nav-justified" role="tablist">
                            <li class="nav-item"><a  href="{{url("/manger")}}" role="tab">التواصل مع القسم الادارى</a></li>
                            <li class="nav-item"><a  href="{{url("/technical")}}" role="tab">التواصل مع القسم الفنى</a></li>
                            <li class="nav-item"><a class=" @if (str_contains(url()->full(), '/tech')) active @endif"  href="{{url("/tech")}}" role="tab"> التواصل مع القسم التقنى</a></li>

                        </ul>
                        <div class="tab-content" id="myTabContent">
                            <div class="tab-pane fade show active" id="terms" role="tabpanel">
                                <div class="benefit-content">
                                    <div class="row justify-content-center">
                                        <div class="col-lg-8">
                                            <div class="contact-title text-center">
                                                <h3 class="title">تواصل معنا </h3>
                                                <p>نرحب باستفساراتكم واقتراحاتكم عبر ارسال النموذج التالي</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row justify-content-center">
                                        <div class="col-lg-8">
                                            <div class="contact-form-wrapper">
                                                <form  action="{{url("/contact-us-tech")}}"
                                                       enctype="multipart/form-data" method="post">
                                                    @csrf
                                                    <div class="row rtl-direction">
                                                        <div class="col-md-6">
                                                            <div class="single-form">
                                                                <input type="text" name="name" class="form-control"  placeholder="الاسم بالكامل" required>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="single-form">
                                                                <input type="email" name="email" class="form-control"  placeholder="البريد الالكتروني" required>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-5">
                                                            <div class="single-form">
                                                                <input type="text" name="mobile" class="form-control"  placeholder="رقم الجوال" required>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-1">
                                                            <div class="single-form">
                                                                <select name="country_id">
                                                                    @foreach(\App\Country::get() as $country)

                                                                        <option value="{{$country->id}}" >{{$country->symbol}}</option>
                                                                    @endforeach
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="single-form">
                                                                <input type="text" name="title" class="form-control" placeholder="الموضوع " required>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-12">
                                                            <div class="single-form">
                                                                <textarea name="message" class="form-control" placeholder="الرسالة" required></textarea>
                                                            </div>
                                                        </div>
                                                        <p class="form-message"></p>
                                                        <div class="col-md-12">
                                                            <div class="single-form text-center">
                                                                <button class="main-btn" type="submit">ارسال</button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>


                </div>



            </div>
        </div>
    </section>

    <!--====== Courses Details Ends ======-->


@endsection
@section('extra_css')


    {{--  <style>

          .select{
              height:50px;
              overflow:scroll;
              overflow-x: hidden;
          }
        </style>--}}
@endsection

