@extends('.site.layout.container')
@section('title','المدونات')
@section('content')

    <!--====== Page Banner Start ======-->

    <section class="page-banner">
        <div class="page-banner-bg " style="background-image: url({{asset("/assets/site")}}/images/page-banner.jpg);">
            <div class="container">
                <div class="banner-content text-center">
                    <h2 class="title"> المدونات العامة</h2>
                </div>
            </div>
        </div>
    </section>

    <!--====== Page Banner Ends ======-->

    <section class="blog-page">

        <div class="container">
            <div class="row rtl-direction">
                <div class="col-lg-12">

                    <br>
                    @foreach ($items as $blog)
                        <div class=" col-lg-4 flo-right col-article-item text-right">
                            <article class="article-item">
                                <div class="article-item-container">
                                    <div class="meta-head-author">
                                        <a href="#" class="img-author">
                                            <img src="{{$blog->course->TrainerImageicon}}" alt="{{$blog->course->TrainerName}}">
                                        </a>
                                        <br>
                                        <br>
                                        <a href="#" class="article-author">
                                            {{$blog->course->TrainerName}}
                                            <span> {{$blog->course->CurrentPositiontrainer}}</span>
                                        </a>
                                    </div>
                                    <div class="article-headline1">
                                        <h2><a href="{{url("/blogDetails/$blog->id")}}">{{$blog->title_ar}}</a></h2>
                                    </div>
                                    <div class="article-excerpt">
                                        <p>{!! mb_substr(strip_tags($blog->text_ar),0,100)."....." !!}</p>
                                    </div>
                                    <a href="{{url("/blogDetails/$blog->id")}}" class="go-to-program"> إقرأ المقال</a>
                                </div>
                            </article>
                        </div>
                    @endforeach
                </div>
            </div>
    </section>


@endsection
@section('extra_css')
 {{--   <style>
        .footer_sticky_part {
            padding-top: 100px !important;
        }
    </style>--}}
@endsection

