@extends('.site.layout.container')
@section('title',($item->name))
@section('content')

    <!--====== Page Banner Start ======-->

    <section class="page-banner">
        <div class="page-banner-bg bg_cover" style="background-image: url({{asset("/assets/site")}}/images/page-banner.jpg);">
            <div class="container">
                <div class="banner-content text-center ">
                    <h2 class="title">المدونة</h2>
                </div>
            </div>
        </div>
    </section>
    <?php $comments= App\Comments::where('blog_id',$item->id)->get(); ?>
    <!--====== Page Banner Ends ======-->
    <section class="blog-details-page">
        <div class="container">
            <div class="row rtl-direction">
                <div class="col-lg-8">
                    <div class="blog-details-content mt-50 text-right">
                        <div class="details-content mt-50">
                            <img src="assets/images/blog-details.jpg" alt="">
                            <ul class="meta">
                                <li><a href="#">{{$item->created_at->diffForHumans()}}</a></li>
                                <li><a href="#">بواسطة:  {{$item->course->TrainerName}}</a></li>
                                <li><a href="#">{{$comments->count()}} تعليق</a></li>
                            </ul>
                            <h3 class="title">{{$item->title_ar}}</h3>

                          <br>

                            {!! $item->text_ar !!}
                        </div>
                        @auth
                        <div class="blog-comment">
                            <?php $comments= App\Comments::where('blog_id',$item->id)->get(); ?>
                            <h3 class="comment-title">التعليقات({{$comments->count()}})</h3>

                            <ul class="comment-items">
                                <li>
                                    @foreach ($comments as $comment)
                                    <div class="single-comment">
                                        <div class="comment-author">
                                            <img src="{{asset("assets/site/")}}/images/author-1.jpg" alt="">
                                        </div>
                                        <div class="comment-content">
                                            <div class="meta">
                                                <h5 class="name">{{$comment->user->name}}</h5>

                                               ( <span class="time">{{$comment->created_at->diffForHumans()}}</span>)
                                            </div>
                                            <p>{{$comment->comment}} </p>
                                        </div>
                                    </div>
                                        @endforeach

                                </li>
                            </ul>
                        </div>

                        <div class="blog-comment">
                            <h3 class="comment-title">أضف تعليق هنا</h3>

                            <div class="comment-form">
                                <form action="{{url("/add-comments")}}"
                                      enctype="multipart/form-data" method="post">
                                    @csrf
                                    <input type="hidden" name="blog_id" value="{{$item->id}}">
                                    <input type="hidden" name="user_id" value="{{auth()->user()->id}}">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="single-form">
                                                <textarea name="comment" placeholder="التعليق ..."></textarea>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="single-form">
                                                <button class="main-btn">اضف تعليق</button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                        @endauth
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="blog-sidebar right-sidebar pt-20">

                        <div class="blog-sidebar-post mt-30 text-right">
                            <div class="sidebar-title">
                                <h4 class="title">المدونات الحالية</h4>
                            </div>
                            <ul class="post-items">
                                @foreach (\App\Blog::orderBy("id","desc")->take(4)->get() as $blog)
                                <li>

                                    <div class="single-post">
                                        <div class="post-thumb">
                                            <a href="{{url("/blogDetails/$blog->id")}}"><img src="{{asset("/assets/site")}}/images/post-1.jpg" alt=""></a>
                                        </div>
                                        <div class="post-content">
                                            <h4 class="post-title"><a href="{{url("/blogDetails/$blog->id")}}">{{$blog->title_ar}}</a></h4>
                                            <a href="#" class="more">اقرأ المزيد <i class="fal fa-chevron-right"></i></a>
                                        </div>
                                    </div>

                                </li>
                                @endforeach

                            </ul>
                        </div>

<!--                        <div class="blog-sidebar-banner mt-30">
                            <a href="#">
                                <img src="{{asset("/assets/site")}}/images/product/banner.jpg" alt="">
                            </a>
                        </div>-->


                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--====== Courses Details Start ======-->

<!--    <section class="courses-details">
        <div class="container">
            <div class="row flex-row-reverse rtl-direction">
                <div class="col-lg-12">
                    <div class="courses-details-content mt-50 text-right">

                        <h2 class="sub-title">{{$item->title_ar}}</h2>

&lt;!&ndash;                        <h5 class="sub-title">المحاور</h5>&ndash;&gt;
                        {!! $item->text_ar !!}
                    </div>


                    <div class="blog-comment">
                        <h3 class="comment-title">Comments(03)</h3>

                        <ul class="comment-items">
                            <li>
                                <div class="single-comment">
                                    <div class="comment-author">
                                        <img src="assets/images/author-1.jpg" alt="">
                                    </div>
                                    <div class="comment-content">
                                        <div class="meta">
                                            <h5 class="name">Alex Smith,</h5>
                                            <span class="time">1 hour ago</span>
                                        </div>
                                        <p>Some of the people may be the right If you are going use a passage belongs to those who fail in their duty through weakness </p>
                                        <a href="#" class="reply">Reply</a>
                                    </div>
                                </div>
                                <ul class="comment-reply">
                                    <li>
                                        <div class="single-comment">
                                            <div class="comment-author">
                                                <img src="assets/images/author-2.jpg" alt="">
                                            </div>
                                            <div class="comment-content">
                                                <div class="meta">
                                                    <h5 class="name">Alex Smith,</h5>
                                                    <span class="time">1 hour ago</span>
                                                </div>
                                                <p>Some of the people may be the right If you are going use a passage belongs to those who fail in their duty through weakness </p>
                                                <a href="#" class="reply">Reply</a>
                                            </div>
                                        </div>
                                    </li>
                                </ul>
                            </li>
                            <li>
                                <div class="single-comment">
                                    <div class="comment-author">
                                        <img src="assets/images/author-3.jpg" alt="">
                                    </div>
                                    <div class="comment-content">
                                        <div class="meta">
                                            <h5 class="name">Alex Smith,</h5>
                                            <span class="time">1 hour ago</span>
                                        </div>
                                        <p>Some of the people may be the right If you are going use a passage belongs to those who fail in their duty through weakness </p>
                                        <a href="#" class="reply">Reply</a>
                                    </div>
                                </div>
                            </li>
                        </ul>
                    </div>

                    <div class="blog-comment">
                        <h3 class="comment-title">Leave a message here</h3>

                        <p>Here is our event schedule where you can get information about time schedule about this event so it's very easy for you to manage your time and schedule</p>

                        <div class="comment-form">
                            <form action="#">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="single-form">
                                            <input type="text" placeholder="Name">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="single-form">
                                            <input type="email" placeholder="Email">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="single-form">
                                            <input type="text" placeholder="Phone">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="single-form">
                                            <input type="text" placeholder="Title">
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="single-form">
                                            <textarea placeholder="Write here..."></textarea>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="single-form">
                                            <button class="main-btn">Submit now</button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>


                </div>


            </div>
        </div>
    </section>-->

    <!--====== Courses Details Ends ======-->


@endsection
@section('extra_css')


{{--  <style>

      .select{
          height:50px;
          overflow:scroll;
          overflow-x: hidden;
      }
    </style>--}}
@endsection

