@extends('admin.layout.table.index')
@section('page-title',trans('language.trainers'))
@section('root' , "users")

@section('nav')
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="{{url("admin/")}}">  {{trans('language.home')}}</a></li>
        <li class="breadcrumb-item active" aria-current="page">{{trans('language.trainers')}}</li>
    </ol>
@endsection
@section('buttons')
    <br>
    <a href="{{url("admin/allTrainers")}}" class="btn btn-info">
        {{ trans('استخراج ملف اكسيل') }}
    </a>
@stop
@section('thead')
    <th>#</th>
    <th>{{trans('language.image')}}</th>
    <th>{{trans('language.trainer_name')}}</th>
    <th>{{trans('language.current_position')}}</th>
    <th>{{trans('language.settings')}}</th>
@endsection
@section('tbody')
    @foreach($items as $item)
        <tr>
            <td>{{ $loop->iteration }}</td>
            <td> @includeIf("admin.components.image.index" , ["url" => $item->dash_image])</td>
            <td>{{$item->dash_name}}</td>
            <td>{{$item->postion()}}</td>
            <td>
                @includeIf("admin.components.buttons.edit" , ["href" => "trainers/$item->id/edit"])
                @includeIf("admin.components.buttons.delete",["message" => "($item->dash_name)" ,  "action" => url("admin/trainers/$item->id")])

            </td>
        </tr>
    @endforeach
@endsection

@section("filters")
    <form method="get" action="{{url("/admin/trainers/")}}">

        <div style="display: flex">
            <div class="col-md-3">
                <input type="text" class="form-control name_input " name="name" value="{{ request()->name ?? '' }}"
                       placeholder="{{trans('language.name')}}">
            </div>
             <div class="col-md-3">
                <input type="text" class="form-control email_input" name="email" value="{{ request()->email ?? '' }}"
                       placeholder="{{trans('language.email')}}">
            </div>
            <div class="col-md-3">
                <input type="text" class="form-control  mobile_input " name="mobile" value="{{ request()->mobile ?? '' }}"
                       placeholder="{{trans('language.mobile')}}">
            </div>
            <div class="col-md-3">
                <input style="width: 45%" type="submit" class="btn btn-success " value="{{trans('language.filter')}}">
                <button style="width: 45%" type="button"
                        class="btn btn-info  reset_inputs ">{{trans('language.reset')}}</button>
            </div>
        </div>
    </form>
@stop

@section("extra_js")

    <script>
        $('.reset_inputs').click(function () {
            $('.name_input').val('');
            $('.email_input').val('');
            $('.mobile_input').val('');
        });
    </script>

@endsection


