@extends('admin.layout.forms.edit.index')
@section('action' , "setting/$item->id")
@section('title' , trans('language.edit'))
@section('page-title',trans('language.settings'))
@section('form-groups')

    @includeIf('admin.components.form.edit.file', ['icon' => 'fa fa-check','label' => 'ملف السيره الذاتية','name'=>'logo', 'max'=>'3'])


    @includeIf('admin.components.form.edit.textarea', ['icon' => 'fa fa-user','label' => trans('language.address'),'name'=>'address', 'placeholder'=>trans('language.address')])
    @includeIf('admin.components.form.edit.text', ['icon' => 'fa fa-user','label' => trans('language.email'),'name'=>'email', 'placeholder'=>trans('language.email')])
    @includeIf('admin.components.form.edit.text', ['icon' => 'fa fa-user','label' => trans('language.mobile'),'name'=>'mobile', 'placeholder'=>trans('language.mobile')])
    @includeIf('admin.components.form.edit.text', ['icon' => 'fa fa-user','label' => trans('language.facebook'),'name'=>'facebook', 'placeholder'=>trans('language.facebook')])
    @includeIf('admin.components.form.edit.text', ['icon' => 'fa fa-user','label' => trans('language.twitter'),'name'=>'twitter', 'placeholder'=>trans('language.twitter')])
    @includeIf('admin.components.form.edit.text', ['icon' => 'fa fa-user','label' => trans('language.instagram'),'name'=>'instagram', 'placeholder'=>trans('language.instagram')])
    @includeIf('admin.components.form.edit.text', ['icon' => 'fa fa-user','label' => trans('language.linkedin'),'name'=>'linkedin', 'placeholder'=>trans('language.linkedin')])
  <!--  @includeIf('admin.components.form.edit.text', ['icon' => 'fa fa-user','label' => trans('language.whatsapp'),'name'=>'whatsapp', 'placeholder'=>trans('language.whatsapp')])-->
    @includeIf('admin.components.form.edit.text', ['icon' => 'fa fa-user','label' => trans('language.link_youtube'),'name'=>'youtube', 'placeholder'=>trans('language.link_youtube')])
        @includeIf('admin.components.form.edit.text', ['icon' => 'fa fa-user','label' => trans('language.link_tiktok'),'name'=>'tiktok', 'placeholder'=>trans('language.link_tiktok')])
            @includeIf('admin.components.form.edit.text', ['icon' => 'fa fa-user','label' => trans('language.link_snapchat'),'name'=>'snapchat', 'placeholder'=>trans('language.link_snapchat')])
    @includeIf('admin.components.form.edit.text', ['icon' => 'fa fa-user','label' => trans('language.live'),'name'=>'live', 'placeholder'=>trans('language.live')])
    <br>
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <h4 class="card-title">من نحن</h4>
                <textarea id="about" name="about">{{$item->about}}</textarea>
            </div>
        </div>
    </div>

    <br>
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <h4 class="card-title">البوابة الالكترونية</h4>
                <textarea id="electronic_gate" name="electronic_gate">{{$item->electronic_gate}}</textarea>
            </div>
        </div>
    </div> 


    <br>
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <h4 class="card-title">البوابة الالكترونية النص الثانى</h4>
                <textarea id="electronic_gate2" name="electronic_gate2">{{$item->electronic_gate2}}</textarea>
            </div>
        </div>
    </div>

    @includeIf('admin.components.form.edit.text', ['icon' => 'fa fa-user','label' => trans('language.electronic_gate_link'),'name'=>'electronic_gate_link', 'placeholder'=>trans('language.electronic_gate_link')])
        @includeIf('admin.components.form.edit.file', ['icon' => 'fa fa-check','label' => 'ملف الكادر الإداري والفني والتقني','name'=>'staff_pdf', 'max'=>'5'])


@endsection
@section('submit-button-title' , trans('web.edit'))
@section('extra_js')





    <script>
        $(document).ready(function () {


            $('#about').summernote();
            $('#electronic_gate').summernote();
            $('#electronic_gate2').summernote();

        });

    </script>




@endsection
