<!DOCTYPE html>
<html lang="en">
<head>
    <link rel="stylesheet" href="{{asset('assets/site/css/custom.css')}}">
    <title>ارسال ايميل الكترونى </title>
</head>
@includeIf("admin.layout.head")
<body class="{{(app()->getLocale() == 'ar')?'rtl':'ltr'}}">
<div class="main-wrapper">
    @includeIf("admin.layout.aside.index")
    <div class="page-wrapper">
        <div class="row page-tiles">
            <div class="col-md-5 align-self-center">
                <a href="{{url('admin/')}}/@yield('root')">
                    <h3 class="text-themecolor">@yield('page-title')</h3>
                </a>
            </div>
        </div>
        @includeIf("admin.layout.header")
        <div class="page-content">
            <div class="container-fluid">
                @if (Session::has('danger'))
                    <div class="alert alert-danger top-alert alert-icon-left mb-0 fade-message" role="alert">
                        <span style="display: inline" class="alert-icon"><i class="fa fa-ban"></i></span>
                        <p style="display: inline" class="mb-0">{{ Session::get('danger') }}</p>
                    </div>
                @endif
                @if (Session::has('error'))
                    <div class="alert alert-danger top-alert alert-icon-left mb-0 fade-message" role="alert">
                        <span style="display: inline" class="alert-icon"><i class="fa fa-ban"></i></span>
                        <p style="display: inline" class="mb-0">{{ Session::get('error') }}</p>
                    </div>
                @endif
                @if (Session::has('success'))
                    <div class="alert alert-success top-alert alert-icon-left mb-0 fade-message" role="alert">
                        <span style="display: inline" class="alert-icon"><i class="fa fa-check"></i></span>
                        <p style="display: inline" class="mb-0">{{ Session::get('success') }}</p>
                    </div>
                @endif
            </div>
            <div style="margin: auto;" class="col-lg-8 table-container">
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title">ارسال بريد الكترونى</h4>
                        <form class="form p-t-20" enctype="multipart/form-data" method="post" action="{{route('email.generate-email')}}">
                            @csrf
                            <div class="form-group">
                                <label>العميل</label>
                                <div class="input-group">
                                    <select name="useremail" required class="room_select" oninvalid="this.setCustomValidity('من فضلك اختر العميل')" oninput="setCustomValidity('')">
                                        @foreach($users as $user)
                                            <option value="{{$user->email}}">{{$user->email}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="exampleInputuname">الموضوع</label>
                                <div class="input-group">
                                    <input class="form-control" type="text" required name="title" oninvalid="this.setCustomValidity('من فضلك ضع العنوان ')" oninput="setCustomValidity('')">
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="message">نص الرسالة</label>
                                <div class="input-group">
                                    <textarea class="form-control" id="message" name="messageContent" rows="10" required oninvalid="this.setCustomValidity('من فضلك ادخل نص الرسالة')" oninput="setCustomValidity('')"></textarea>
                                </div>
                            </div>
                            <button type="submit" class="btn btn-success waves-effect waves-light m-r-10 addFormRequest">انشاء</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <footer class="footer d-flex flex-column flex-md-row align-items-center justify-content-between">
            <p class="text-muted text-center text-md-right">Copyright © 2021 <a href="#" target="_blank">Genius Training Foundation</a>. All rights reserved</p>
        </footer>
    </div>
</div>
@includeIf("admin.layout.scripts")
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet"/>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    $(document).ready(function () {
        $('.course_select').select2();
        $('.room_select').select2();
    });
</script>
</body>
</html>
