@extends('admin.layout.table.index')
@section('page-title',trans('language.courses_salama'))
@section('root' , "users")
@section('buttons')

@stop
@section('nav')
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="{{url("admin/")}}">  {{trans('language.home')}}</a></li>
        <li class="breadcrumb-item active" aria-current="page">{{trans('language.courses_salama')}}</li>
    </ol>
@endsection
@section('thead')
    <th>#</th>
    <th>{{trans('language.brochure')}}</th>
    <th>{{trans('language.whatsapp')}}</th>
    <th>{{trans('language.google_link')}}</th>
    <th>{{trans('language.settings')}}</th>
@endsection
@section('tbody')
    @foreach($items as $item)
        <tr>
            <td>{{ $loop->iteration }}</td>
            <td> @includeIf("admin.components.image.index" , ["url" => $item->image])</td>
            <td>{{$item->whatsapp}}</td>
            <td>{{$item->google_link}}</td>
            <td>
                @includeIf("admin.components.buttons.edit" , ["href" => "courses_salama/$item->id/edit"])
                @includeIf("admin.components.buttons.delete",["message" =>  "($item->dash_name)" ,  "action" => url("admin/courses_salama/$item->id")])
            </td>
        </tr>
    @endforeach
@endsection



@section("extra_js")

    <script>
        $('.reset_inputs').click(function () {
            $('.name_input').val('');
            $('.email_input').val('');
            $('.mobile_input').val('');
        });
    </script>

@endsection


