@extends('admin.layout.forms.edit.index')
@section('action' , "courses/$item->id")
@section('root' , "courses")
@section('title' , trans('language.edit'))
@section('page-title',trans('language.courses'))
@section('form-groups')
    @includeIf('admin.components.form.edit.file', ['icon' => 'fa fa-check','label' => trans('language.image'),'name'=>'image', 'max'=>'4'])
    @includeIf('admin.components.form.edit.select', ['label' => trans("language.category"),'name'=>'category_id', 'items'=> \App\Category::all() , 'icon' => 'fa fa-grid',])
    @includeIf('admin.components.form.edit.select', ['label' => trans("language.trainers"),'name'=>'trainer_id', 'items'=> \App\Trainer::all() , 'icon' => 'fa fa-list',])
    @includeIf('admin.components.form.edit.select', ['label' => trans("language.coordinators"),'name'=>'coordinator_id', 'items'=> \App\User::where("user_type_id",App\ModulesConst\UserTyps::coordinators)->get() , 'icon' => 'fa fa-list',])
    @includeIf('admin.components.form.edit.text', ['label' => trans('language.name_course'),'name'=>'name', 'placeholder'=>trans('language.name_course'),'valid'=>trans('language.vaildation')])
         @includeIf('admin.components.form.edit.textarea', ['label' => trans('language.price_before'),'name'=>'price_before', 'placeholder'=>trans('language.price_before'),'valid'=>trans('language.vaildation')])
    @includeIf('admin.components.form.edit.text', ['label' => trans('language.price'),'name'=>'price', 'placeholder'=>trans('language.price'),'valid'=>trans('language.vaildation')])
     @includeIf('admin.components.form.edit.text', ['label' => trans('وتساب'),'name'=>'whatsapp', 'placeholder'=>trans('وتساب'),'valid'=>trans('language.vaildation')])
    
    @includeIf('admin.components.form.edit.date', ['label' => trans('language.start_date_course'),'name'=>'date', 'placeholder'=>trans('language.start_date_course'),'valid'=>trans('language.vaildation')])
    @includeIf('admin.components.form.edit.date', ['label' => trans('language.end_date'),'name'=>'end_date', 'placeholder'=>trans('language.end_date'),'valid'=>trans('language.vaildation')])
    @includeIf('admin.components.form.edit.text', ['label' => trans('language.counthour'),'name'=>'counthour', 'placeholder'=>trans('language.counthour'),'valid'=>trans('language.vaildation')])
    @includeIf('admin.components.form.edit.text', ['label' => trans('language.duration'),'name'=>'duration', 'placeholder'=>trans('language.duration'),'valid'=>trans('language.vaildation')])
    
     @includeIf('admin.components.form.edit.text', ['label' => trans('المكان'),'name'=>'city', 'placeholder'=>trans('المكان'),'valid'=>trans('language.vaildation')])
     
     @includeIf('admin.components.form.edit.text', ['label' => trans('اللغة'),'name'=>'lang', 'placeholder'=>trans('اللغة'),'valid'=>trans('language.vaildation')])

    @includeIf('admin.components.form.edit.text', ['label' => trans('language.link_taby'),'name'=>'link_taby', 'placeholder'=>trans('language.link_taby'),'valid'=>trans('language.vaildation')])
    @includeIf('admin.components.form.edit.text', ['label' => trans('language.link_tamra'),'name'=>'link_tamra', 'placeholder'=>trans('language.link_tamra'),'valid'=>trans('language.vaildation')])
<br>
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <h4 class="card-title">{{trans('language.goal')}}</h4>
                <textarea id="goal" name="goal">{{$item->goal}}</textarea>
            </div>
        </div>
    </div>
    <br>
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <h4 class="card-title">{{trans('language.brief_course')}}</h4>
                <textarea id="breif" name="breif">{{$item->breif}}</textarea>
            </div>
        </div>
    </div>
    <br>
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <h4 class="card-title">{{trans('language.offer')}}</h4>
                <textarea id="offer" name="offer">{{$item->offer}}</textarea>
            </div>
        </div>
    </div>
    <br>
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <h4 class="card-title">{{trans('language.description_course')}}</h4>
                <textarea id="experience" name="description">{{$item->description}}</textarea>
            </div>
        </div>
    </div>

    <br>
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <h4 class="card-title">{{trans('language.features_course')}}</h4>
                <textarea id="qualification" name="features">{{$item->features}}</textarea>
            </div>
        </div>
    </div>
    <br>
    @includeIf('admin.components.form.edit.text', ['label' => trans('language.link_youtube'),'name'=>'link_youtube', 'placeholder'=>trans('language.link_youtube'),'valid'=>trans('language.price')])

    @includeIf('admin.components.form.edit.text', ['label' => trans('language.link_course'),'name'=>'link', 'placeholder'=>trans('language.link_course'),'valid'=>trans('language.price')])

@endsection
@section('submit-button-title' , trans('web.edit'))
@section('extra_js')

    <script type="text/javascript">
        CKEDITOR.replace('blogContent');
    </script>
    <script type="text/javascript">
    var x= { 
     'font_names':'cairo;sans serif;monospace;cursive;fantasy;Lobster',
     'contentsCss':[ 'https://fonts.googleapis.com/css2?family=Cairo&display=swap' ] 
  };
  
     var x2= { 
     'font_names':'cairo;sans serif;monospace;cursive;fantasy;Lobster',
     'contentsCss':[ 'https://fonts.googleapis.com/css2?family=Cairo&display=swap' ] 
  };
     var x3= { 
     'font_names':'cairo;sans serif;monospace;cursive;fantasy;Lobster',
     'contentsCss':[ 'https://fonts.googleapis.com/css2?family=Cairo&display=swap' ] 
  };
     var x4= { 
     'font_names':'cairo;sans serif;monospace;cursive;fantasy;Lobster',
     'contentsCss':[ 'https://fonts.googleapis.com/css2?family=Cairo&display=swap' ] 
  };
    var x5= { 
     'font_names':'cairo;sans serif;monospace;cursive;fantasy;Lobster',
     'contentsCss':[ 'https://fonts.googleapis.com/css2?family=Cairo&display=swap' ] 
  };
     var x6= { 
     'font_names':'cairo;sans serif;monospace;cursive;fantasy;Lobster',
     'contentsCss':[ 'https://fonts.googleapis.com/css2?family=Cairo&display=swap' ] 
  };
      CKEDITOR.replace("goal", x) ;
  

        CKEDITOR.replace('breif',x2) ;
  

        CKEDITOR.replace('offer',x3);
        CKEDITOR.replace('experience',x4);
        CKEDITOR.replace('qualification',x5);
        CKEDITOR.replace('achievements',x6);
    </script>



<!--    <script>
        $(document).ready(function () {


            $('#about').summernote();
            $('#experience').summernote();
            $('#qualification').summernote();
            $('#achievements').summernote();
            $('#offer').summernote();
            $('#goal').summernote();
            $('#breif').summernote();

        });

    </script>-->




@endsection
