@extends('admin.layout.table.index')
@section('page-title',trans('language.blogs'))
@section('root' , "users")
@section('buttons')

@stop
@section('nav')
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="{{url("admin/")}}">  {{trans('language.home')}}</a></li>
        <li class="breadcrumb-item active" aria-current="page">{{trans('language.address_site')}}</li>
    </ol>
@endsection
@section('thead')
    <th>#</th>
    <th>{{trans('language.country')}}</th>
    <th>{{trans('language.regin')}}</th>
      <th>{{trans('language.city')}}</th>
        <th>{{trans('language.created_at')}}</th>


    <th>{{trans('language.settings')}}</th>
@endsection
@section('tbody')
    @foreach($items as $item)
        <tr>
            <td>{{ $loop->iteration }}</td>
            <td>{{$item->countryName}}</td>
            <td>{{$item->regionName}}</td>
             <td>{{$item->cityName}}</td>

             <td>{{$item->created_at->diffForHumans()}}</td>


            <td>

                @includeIf("admin.components.buttons.delete",["message" => "($item->countryName)" ,  "action" => url("admin/address/$item->id")])


            </td>
        </tr>
    @endforeach
@endsection

@section("filters")
<?php 
$count1=App\Address::where('countryName','United States')->count();
$count2=App\Address::where('countryName','Saudi Arabia')->count();
$count3=App\Address::where('countryName','Egypt')->count();
$count4=App\Address::where('countryName','United Kingdom')->count();
$count5=App\Address::where('countryName','Singapore')->count();


//dd($count5);
?>
<div class="row">
        <div class="col-12 col-xl-12 stretch-card">
            <div class="row flex-grow">

                <div class="col-md-4 grid-margin stretch-card">
                    <div class="card">
                        <a href="#">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-baseline">
                                    <h6 class="card-title mb-0">{{trans('United States')}}</h6>
                                    <div class="dropdown mb-2"></div>
                                </div>
                                <div class="row">
                                    <div class="col-6 col-md-12 col-xl-5">
                                        <h3 class="mb-2"></h3>
                                        <div class="d-flex align-items-baseline">
                                             {{$count1}}
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-12 col-xl-7">
                                        <div id="" class="mt-md-3 mt-xl-0"></div>
                                    </div>
                                </div>
                            </div>
                        </a>
                    </div>
                </div>
              
                <div class="col-md-4 grid-margin stretch-card">
                    <div class="card">
                        <a href="#">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-baseline">
                                    <h6 class="card-title mb-0">{{trans('Saudi Arabia')}}</h6>
                                    <div class="dropdown mb-2"></div>
                                </div>
                                <div class="row">
                                    <div class="col-6 col-md-12 col-xl-5">
                                        <h3 class="mb-2"></h3>
                                        <div class="d-flex align-items-baseline">
                                            {{$count2}}
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-12 col-xl-7">
                                        <div id="" class="mt-md-3 mt-xl-0"></div>
                                    </div>
                                </div>
                            </div>
                        </a>
                    </div>
                </div>
                <div class="col-md-4 grid-margin stretch-card">
                    <div class="card">
                        <a href="#">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-baseline">
                                    <h6 class="card-title mb-0">{{trans('Egypt')}}</h6>
                                    <div class="dropdown mb-2"></div>
                                </div>
                                <div class="row">
                                    <div class="col-6 col-md-12 col-xl-5">
                                        <h3 class="mb-2"></h3>
                                        <div class="d-flex align-items-baseline">
                                            {{$count3}}
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-12 col-xl-7">
                                        <div id="" class="mt-md-3 mt-xl-0"></div>
                                    </div>
                                </div>
                            </div>
                        </a>
                    </div>
                </div>



            </div>
        </div>
          <div class="col-12 col-xl-12 stretch-card">
            <div class="row flex-grow">

                <div class="col-md-4 grid-margin stretch-card">
                    <div class="card">
                        <a href="#">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-baseline">
                                    <h6 class="card-title mb-0">{{trans('United Kingdom')}}</h6>
                                    <div class="dropdown mb-2"></div>
                                </div>
                                <div class="row">
                                    <div class="col-6 col-md-12 col-xl-5">
                                        <h3 class="mb-2"></h3>
                                        <div class="d-flex align-items-baseline">
                                             {{$count4}}
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-12 col-xl-7">
                                        <div id="" class="mt-md-3 mt-xl-0"></div>
                                    </div>
                                </div>
                            </div>
                        </a>
                    </div>
                </div>
              
                <div class="col-md-4 grid-margin stretch-card">
                    <div class="card">
                        <a href="#">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-baseline">
                                    <h6 class="card-title mb-0">{{trans(' Singapore')}}</h6>
                                    <div class="dropdown mb-2"></div>
                                </div>
                                <div class="row">
                                    <div class="col-6 col-md-12 col-xl-5">
                                        <h3 class="mb-2"></h3>
                                        <div class="d-flex align-items-baseline">
                                            {{$count5}}
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-12 col-xl-7">
                                        <div id="" class="mt-md-3 mt-xl-0"></div>
                                    </div>
                                </div>
                            </div>
                        </a>
                    </div>
                </div>
              


            </div>
        </div>

    </div>



<br>
<br>
    <form method="get" action="{{url("/admin/address/")}}">

        <div style="display: flex">
            <div class="col-md-3">
                <input type="text" class="form-control name_input " name="name" value="{{ request()->country ?? '' }}"
                       placeholder="{{trans('language.country')}}">
            </div>


            <div class="col-md-3">
                <input style="width: 45%" type="submit" class="btn btn-success " value="{{trans('language.filter')}}">
                <button style="width: 45%" type="button"
                        class="btn btn-info  reset_inputs ">{{trans('language.reset')}}</button>
            </div>
        </div>
    </form>
@stop

@section("extra_js")

    <script>
        $('.reset_inputs').click(function () {
            $('.name_input').val('');
            $('.email_input').val('');
            $('.mobile_input').val('');
        });
    </script>

@endsection


