@extends('admin.layout.forms.edit.index')
@section('action' , "blogs/$item->id")
@section('root' , "blogs")
@section('title' , trans('language.edit'))
@section('page-title',trans('language.blogs'))
@section('form-groups')

    @includeIf('admin.components.form.edit.select', ['label' => trans("language.courses"),'name'=>'course_id', 'items'=> \App\Course::where("end_date", '>=',Carbon\Carbon::now()->format('Y-m-d'))->get() , 'icon' => 'fa fa-list',])
   
    @includeIf('admin.components.form.edit.text', ['label' => trans('language.title_ar'),'name'=>'title_ar', 'placeholder'=>trans('language.title_ar'),'valid'=>trans('language.title_ar')])
{{--
    @includeIf('admin.components.form.edit.text', ['label' => trans('language.title_en'),'name'=>'title_en', 'placeholder'=>trans('language.title_en'),'valid'=>trans('language.title_en')])
--}}

    <br>
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <h4 class="card-title">{{trans('language.text_ar')}}</h4>
                <textarea id="text_ar" name="text_ar">{{$item->text_ar}}</textarea>
            </div>
        </div>
    </div>
    <br>
<!--    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <h4 class="card-title">{{trans('language.text_en')}}</h4>
                <textarea id="text_en" name="text_en">{{$item->text_ar}}</textarea>
            </div>
        </div>
    </div>-->

    <br>

@endsection
@section('submit-button-title' , trans('web.edit'))
@section('extra_js')





    <script>
        $(document).ready(function () {


            $('#text_ar').summernote();
            $('#text_en').summernote();


        });

    </script>




@endsection
