<?php
$directory = __DIR__ . '/resources/views';
$iterator = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($directory));
$regex = '/\{\{\s*\$([a-zA-Z0-9_]+)->links\(\)\s*\}\}/';

foreach ($iterator as $file) {
    if ($file->isFile() && str_ends_with($file->getFilename(), '.blade.php')) {
        $path = $file->getPathname();
        $content = file_get_contents($path);
        
        // Replace {{ $items->links() }} with {{ @$items->links() }}
        // Avoid double @@
        $newContent = preg_replace($regex, '{{ @$$1->links() }}', $content, -1, $count);
        
        if ($count > 0) {
            file_put_contents($path, $newContent);
            echo "Fixed $count occurrences in " . $path . "\n";
        }
    }
}
?>
