$(document).ready(function () {

    lat = 29.378586;
    lng = 47.990341;
    latLng = {lat: lat, lng: lng};
    var marker;
    var geocoder = new google.maps.Geocoder;
    markerUrl = window.location.host + 'abwab/assets/admin/images/marker.png';
    mapProp = {
        center: new google.maps.LatLng(lat, lng),
        zoom: 15,
        gestureHandling: 'greedy'
    };

    map = new google.maps.Map(document.getElementById("map"), mapProp);
    marker = new google.maps.Marker({
        map: map,
        animation: google.maps.Animation.DROP,
        icon: iconUrl
    });


    google.maps.event.addListener(map, 'click', function (event) {
        placeMarker(event.latLng);
    });

    function placeMarker(location) {
        marker.setPosition(location);
        geocodeLatLng(geocoder, map, location);
        latLngLocation = location.toString().slice(1, -1); // remove ()
        $('#location').val(latLngLocation);
    }

    function geocodeLatLng(geocoder, map, latlng) {
        geocoder.geocode({'location': latlng}, function (results, status) {
            if (status === 'OK') {
                if (results[0]) {
                    address = results[0].formatted_address;

                    $('#pac-input').val(address);
                } else {
                    window.alert('No results found');
                }
            } else {
                window.alert('Geocoder failed due to: ' + status);
            }
        });
    }

    // Create the search box and link it to the UI element.
    var input = document.getElementById('pac-input');
    var searchBox = new google.maps.places.SearchBox(input);
    // map.controls[google.maps.ControlPosition.TOP_LEFT].push(input);

    // Bias the SearchBox results towards current map's viewport.
    map.addListener('bounds_changed', function () {
        searchBox.setBounds(map.getBounds());
    });

    var markers = [];
    // Listen for the event fired when the user selects a prediction and retrieve
    // more details for that place.
    searchBox.addListener('places_changed', function () {
        var places = searchBox.getPlaces();

        if (places.length == 0) {
            return;
        }

        // Clear out the old markers.
        markers.forEach(function (marker) {
            marker.setMap(null);
        });
        markers = [];

        // For each place, get the icon, name and location.
        var bounds = new google.maps.LatLngBounds();
        places.forEach(function (place) {
            if (!place.geometry) {
                console.log("Returned place contains no geometry");
                return;
            }
            var icon = {
                url: place.icon,
                size: new google.maps.Size(71, 71),
                origin: new google.maps.Point(0, 0),
                anchor: new google.maps.Point(17, 34),
                scaledSize: new google.maps.Size(25, 25)
            };

            if (place.geometry.viewport) {
                // Only geocodes have viewport.
                bounds.union(place.geometry.viewport);
            } else {
                bounds.extend(place.geometry.location);
            }
        });
        map.fitBounds(bounds);
    });

});


;