"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

exports.__esModule = true;
exports["default"] = void 0;

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inheritsLoose2 = _interopRequireDefault(require("@babel/runtime/helpers/inheritsLoose"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _Context = require("./Context");

var _Subscription = _interopRequireDefault(require("../utils/Subscription"));

var Provider =
/*#__PURE__*/
function (_Component) {
  (0, _inheritsLoose2["default"])(Provider, _Component);

  function Provider(props) {
    var _this;

    _this = _Component.call(this, props) || this;
    var store = props.store;
    _this.notifySubscribers = _this.notifySubscribers.bind((0, _assertThisInitialized2["default"])(_this));
    var subscription = new _Subscription["default"](store);
    subscription.onStateChange = _this.notifySubscribers;
    _this.state = {
      store: store,
      subscription: subscription
    };
    _this.previousState = store.getState();
    return _this;
  }

  var _proto = Provider.prototype;

  _proto.componentDidMount = function componentDidMount() {
    this._isMounted = true;
    this.state.subscription.trySubscribe();

    if (this.previousState !== this.props.store.getState()) {
      this.state.subscription.notifyNestedSubs();
    }
  };

  _proto.componentWillUnmount = function componentWillUnmount() {
    if (this.unsubscribe) this.unsubscribe();
    this.state.subscription.tryUnsubscribe();
    this._isMounted = false;
  };

  _proto.componentDidUpdate = function componentDidUpdate(prevProps) {
    if (this.props.store !== prevProps.store) {
      this.state.subscription.tryUnsubscribe();
      var subscription = new _Subscription["default"](this.props.store);
      subscription.onStateChange = this.notifySubscribers;
      this.setState({
        store: this.props.store,
        subscription: subscription
      });
    }
  };

  _proto.notifySubscribers = function notifySubscribers() {
    this.state.subscription.notifyNestedSubs();
  };

  _proto.render = function render() {
    var Context = this.props.context || _Context.ReactReduxContext;
    return _react["default"].createElement(Context.Provider, {
      value: this.state
    }, this.props.children);
  };

  return Provider;
}(_react.Component);

Provider.propTypes = {
  store: _propTypes["default"].shape({
    subscribe: _propTypes["default"].func.isRequired,
    dispatch: _propTypes["default"].func.isRequired,
    getState: _propTypes["default"].func.isRequired
  }),
  context: _propTypes["default"].object,
  children: _propTypes["default"].any
};
var _default = Provider;
exports["default"] = _default;;