(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
    typeof define === 'function' && define.amd ? define(factory) :
    (global = typeof globalThis !== 'undefined' ? globalThis : global || self, (global.date = global.date || {}, global.date.locale = global.date.locale || {}, global.date.locale.ja = factory()));
}(this, (function () { 'use strict';

    /**
     * @preserve date-and-time.js locale configuration
     * @preserve Japanese (ja)
     * @preserve It is using moment.js locale configuration as a reference.
     */

    var ja = function (date) {
        var code = 'ja';

        date.locale(code, {
            res: {
                MMMM: ['1月', '2月', '3月', '4月', '5月', '6月', '7月', '8月', '9月', '10月', '11月', '12月'],
                MMM: ['1月', '2月', '3月', '4月', '5月', '6月', '7月', '8月', '9月', '10月', '11月', '12月'],
                dddd: ['日曜日', '月曜日', '火曜日', '水曜日', '木曜日', '金曜日', '土曜日'],
                ddd: ['日', '月', '火', '水', '木', '金', '土'],
                dd: ['日', '月', '火', '水', '木', '金', '土'],
                A: ['午前', '午後']
            },
            formatter: {
                hh: function (d) {
                    return ('0' + d.getHours() % 12).slice(-2);
                },
                h: function (d) {
                    return d.getHours() % 12;
                }
            }
        });
        return code;
    };

    return ja;

})));
;