"use strict";
// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// ** This file is automatically generated by gapic-generator-typescript. **
// ** https://github.com/googleapis/gapic-generator-typescript **
// ** All changes to this file may be overwritten. **
Object.defineProperty(exports, "__esModule", { value: true });
/* global window */
const gax = require("google-gax");
const jsonProtos = require("../../protos/protos.json");
/**
 * Client JSON configuration object, loaded from
 * `src/v1beta1/firestore_client_config.json`.
 * This file defines retry strategy and timeouts for all API methods in this library.
 */
const gapicConfig = require("./firestore_client_config.json");
// tslint:disable deprecation
const version = require('../../../package.json').version;
/**
 *  The Cloud Firestore service.
 *
 *  Cloud Firestore is a fast, fully managed, serverless, cloud-native NoSQL
 *  document database that simplifies storing, syncing, and querying data for
 *  your mobile, web, and IoT apps at global scale. Its client libraries provide
 *  live synchronization and offline support, while its security features and
 *  integrations with Firebase and Google Cloud Platform (GCP) accelerate
 *  building truly serverless apps.
 * @class
 * @deprecated Use v1/firestore_client instead.
 * @memberof v1beta1
 */
class FirestoreClient {
    /**
     * Construct an instance of FirestoreClient.
     *
     * @param {object} [options] - The configuration object.
     * The options accepted by the constructor are described in detail
     * in [this document](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#creating-the-client-instance).
     * The common options are:
     * @param {object} [options.credentials] - Credentials object.
     * @param {string} [options.credentials.client_email]
     * @param {string} [options.credentials.private_key]
     * @param {string} [options.email] - Account email address. Required when
     *     using a .pem or .p12 keyFilename.
     * @param {string} [options.keyFilename] - Full path to the a .json, .pem, or
     *     .p12 key downloaded from the Google Developers Console. If you provide
     *     a path to a JSON file, the projectId option below is not necessary.
     *     NOTE: .pem and .p12 require you to specify options.email as well.
     * @param {number} [options.port] - The port on which to connect to
     *     the remote host.
     * @param {string} [options.projectId] - The project ID from the Google
     *     Developer's Console, e.g. 'grape-spaceship-123'. We will also check
     *     the environment variable GCLOUD_PROJECT for your project ID. If your
     *     app is running in an environment which supports
     *     {@link https://developers.google.com/identity/protocols/application-default-credentials Application Default Credentials},
     *     your project ID will be detected automatically.
     * @param {string} [options.apiEndpoint] - The domain name of the
     *     API remote host.
     * @param {gax.ClientConfig} [options.clientConfig] - Client configuration override.
     *     Follows the structure of {@link gapicConfig}.
     * @param {boolean} [options.fallback] - Use HTTP fallback mode.
     *     In fallback mode, a special browser-compatible transport implementation is used
     *     instead of gRPC transport. In browser context (if the `window` object is defined)
     *     the fallback mode is enabled automatically; set `options.fallback` to `false`
     *     if you need to override this behavior.
     */
    constructor(opts) {
        var _a, _b;
        this._terminated = false;
        this.descriptors = {
            page: {},
            stream: {},
            longrunning: {},
            batching: {},
        };
        // Ensure that options include all the required fields.
        const staticMembers = this.constructor;
        const servicePath = (opts === null || opts === void 0 ? void 0 : opts.servicePath) || (opts === null || opts === void 0 ? void 0 : opts.apiEndpoint) || staticMembers.servicePath;
        this._providedCustomServicePath = !!((opts === null || opts === void 0 ? void 0 : opts.servicePath) || (opts === null || opts === void 0 ? void 0 : opts.apiEndpoint));
        const port = (opts === null || opts === void 0 ? void 0 : opts.port) || staticMembers.port;
        const clientConfig = (_a = opts === null || opts === void 0 ? void 0 : opts.clientConfig) !== null && _a !== void 0 ? _a : {};
        const fallback = (_b = opts === null || opts === void 0 ? void 0 : opts.fallback) !== null && _b !== void 0 ? _b : (typeof window !== 'undefined' && typeof (window === null || window === void 0 ? void 0 : window.fetch) === 'function');
        opts = Object.assign({ servicePath, port, clientConfig, fallback }, opts);
        // If scopes are unset in options and we're connecting to a non-default endpoint, set scopes just in case.
        if (servicePath !== staticMembers.servicePath && !('scopes' in opts)) {
            opts['scopes'] = staticMembers.scopes;
        }
        // Choose either gRPC or proto-over-HTTP implementation of google-gax.
        this._gaxModule = opts.fallback ? gax.fallback : gax;
        // Create a `gaxGrpc` object, with any grpc-specific options sent to the client.
        this._gaxGrpc = new this._gaxModule.GrpcClient(opts);
        // Save options to use in initialize() method.
        this._opts = opts;
        // Save the auth object to the client, for use by other methods.
        this.auth = this._gaxGrpc.auth;
        // Set useJWTAccessWithScope on the auth object.
        this.auth.useJWTAccessWithScope = true;
        // Set defaultServicePath on the auth object.
        this.auth.defaultServicePath = staticMembers.servicePath;
        // Set the default scopes in auth client if needed.
        if (servicePath === staticMembers.servicePath) {
            this.auth.defaultScopes = staticMembers.scopes;
        }
        // Determine the client header string.
        const clientHeader = [`gax/${this._gaxModule.version}`, `gapic/${version}`];
        if (typeof process !== 'undefined' && 'versions' in process) {
            clientHeader.push(`gl-node/${process.versions.node}`);
        }
        else {
            clientHeader.push(`gl-web/${this._gaxModule.version}`);
        }
        if (!opts.fallback) {
            clientHeader.push(`grpc/${this._gaxGrpc.grpcVersion}`);
        }
        else if (opts.fallback === 'rest') {
            clientHeader.push(`rest/${this._gaxGrpc.grpcVersion}`);
        }
        if (opts.libName && opts.libVersion) {
            clientHeader.push(`${opts.libName}/${opts.libVersion}`);
        }
        // Load the applicable protos.
        this._protos = this._gaxGrpc.loadProtoJSON(jsonProtos);
        // Some of the methods on this service return "paged" results,
        // (e.g. 50 results at a time, with tokens to get subsequent
        // pages). Denote the keys used for pagination and results.
        this.descriptors.page = {
            listDocuments: new this._gaxModule.PageDescriptor('pageToken', 'nextPageToken', 'documents'),
            partitionQuery: new this._gaxModule.PageDescriptor('pageToken', 'nextPageToken', 'partitions'),
            listCollectionIds: new this._gaxModule.PageDescriptor('pageToken', 'nextPageToken', 'collectionIds'),
        };
        // Some of the methods on this service provide streaming responses.
        // Provide descriptors for these.
        this.descriptors.stream = {
            batchGetDocuments: new this._gaxModule.StreamDescriptor(gax.StreamType.SERVER_STREAMING),
            runQuery: new this._gaxModule.StreamDescriptor(gax.StreamType.SERVER_STREAMING),
            write: new this._gaxModule.StreamDescriptor(gax.StreamType.BIDI_STREAMING),
            listen: new this._gaxModule.StreamDescriptor(gax.StreamType.BIDI_STREAMING),
        };
        // Put together the default options sent with requests.
        this._defaults = this._gaxGrpc.constructSettings('google.firestore.v1beta1.Firestore', gapicConfig, opts.clientConfig || {}, { 'x-goog-api-client': clientHeader.join(' ') });
        // Set up a dictionary of "inner API calls"; the core implementation
        // of calling the API is handled in `google-gax`, with this code
        // merely providing the destination and request information.
        this.innerApiCalls = {};
        // Add a warn function to the client constructor so it can be easily tested.
        this.warn = gax.warn;
    }
    /**
     * Initialize the client.
     * Performs asynchronous operations (such as authentication) and prepares the client.
     * This function will be called automatically when any class method is called for the
     * first time, but if you need to initialize it before calling an actual method,
     * feel free to call initialize() directly.
     *
     * You can await on this method if you want to make sure the client is initialized.
     *
     * @returns {Promise} A promise that resolves to an authenticated service stub.
     */
    initialize() {
        // If the client stub promise is already initialized, return immediately.
        if (this.firestoreStub) {
            return this.firestoreStub;
        }
        // Put together the "service stub" for
        // google.firestore.v1beta1.Firestore.
        this.firestoreStub = this._gaxGrpc.createStub(this._opts.fallback
            ? this._protos.lookupService('google.firestore.v1beta1.Firestore')
            : // eslint-disable-next-line @typescript-eslint/no-explicit-any
                this._protos.google.firestore.v1beta1.Firestore, this._opts, this._providedCustomServicePath);
        // Iterate over each of the methods that the service provides
        // and create an API call method for each.
        const firestoreStubMethods = [
            'getDocument',
            'listDocuments',
            'updateDocument',
            'deleteDocument',
            'batchGetDocuments',
            'beginTransaction',
            'commit',
            'rollback',
            'runQuery',
            'partitionQuery',
            'write',
            'listen',
            'listCollectionIds',
            'batchWrite',
            'createDocument',
        ];
        for (const methodName of firestoreStubMethods) {
            const callPromise = this.firestoreStub.then(stub => (...args) => {
                if (this._terminated) {
                    return Promise.reject('The client has already been closed.');
                }
                const func = stub[methodName];
                return func.apply(stub, args);
            }, (err) => () => {
                throw err;
            });
            const descriptor = this.descriptors.page[methodName] ||
                this.descriptors.stream[methodName] ||
                undefined;
            const apiCall = this._gaxModule.createApiCall(callPromise, this._defaults[methodName], descriptor);
            this.innerApiCalls[methodName] = apiCall;
        }
        return this.firestoreStub;
    }
    /**
     * The DNS address for this API service.
     * @returns {string} The DNS address for this service.
     */
    static get servicePath() {
        return 'firestore.googleapis.com';
    }
    /**
     * The DNS address for this API service - same as servicePath(),
     * exists for compatibility reasons.
     * @returns {string} The DNS address for this service.
     */
    static get apiEndpoint() {
        return 'firestore.googleapis.com';
    }
    /**
     * The port for this API service.
     * @returns {number} The default port for this service.
     */
    static get port() {
        return 443;
    }
    /**
     * The scopes needed to make gRPC calls for every method defined
     * in this service.
     * @returns {string[]} List of default scopes.
     */
    static get scopes() {
        return [
            'https://www.googleapis.com/auth/cloud-platform',
            'https://www.googleapis.com/auth/datastore',
        ];
    }
    /**
     * Return the project ID used by this class.
     * @returns {Promise} A promise that resolves to string containing the project ID.
     */
    getProjectId(callback) {
        if (callback) {
            this.auth.getProjectId(callback);
            return;
        }
        return this.auth.getProjectId();
    }
    /**
     * Gets a single document.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.name
     *   Required. The resource name of the Document to get. In the format:
     *   `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * @param {google.firestore.v1beta1.DocumentMask} request.mask
     *   The fields to return. If not set, returns all fields.
     *
     *   If the document has a field that is not present in this mask, that field
     *   will not be returned in the response.
     * @param {Buffer} request.transaction
     *   Reads the document in a transaction.
     * @param {google.protobuf.Timestamp} request.readTime
     *   Reads the version of the document at the given time.
     *   This may not be older than 270 seconds.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [Document]{@link google.firestore.v1beta1.Document}.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
     *   for more details and examples.
     * @example
     * const [response] = await client.getDocument(request);
     */
    getDocument(request, optionsOrCallback, callback) {
        request = request || {};
        let options;
        if (typeof optionsOrCallback === 'function' && callback === undefined) {
            callback = optionsOrCallback;
            options = {};
        }
        else {
            options = optionsOrCallback;
        }
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] =
            gax.routingHeader.fromParams({
                name: request.name || '',
            });
        this.initialize();
        return this.innerApiCalls.getDocument(request, options, callback);
    }
    /**
     * Updates or inserts a document.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {google.firestore.v1beta1.Document} request.document
     *   Required. The updated document.
     *   Creates the document if it does not already exist.
     * @param {google.firestore.v1beta1.DocumentMask} request.updateMask
     *   The fields to update.
     *   None of the field paths in the mask may contain a reserved name.
     *
     *   If the document exists on the server and has fields not referenced in the
     *   mask, they are left unchanged.
     *   Fields referenced in the mask, but not present in the input document, are
     *   deleted from the document on the server.
     * @param {google.firestore.v1beta1.DocumentMask} request.mask
     *   The fields to return. If not set, returns all fields.
     *
     *   If the document has a field that is not present in this mask, that field
     *   will not be returned in the response.
     * @param {google.firestore.v1beta1.Precondition} request.currentDocument
     *   An optional precondition on the document.
     *   The request will fail if this is set and not met by the target document.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [Document]{@link google.firestore.v1beta1.Document}.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
     *   for more details and examples.
     * @example
     * const [response] = await client.updateDocument(request);
     */
    updateDocument(request, optionsOrCallback, callback) {
        request = request || {};
        let options;
        if (typeof optionsOrCallback === 'function' && callback === undefined) {
            callback = optionsOrCallback;
            options = {};
        }
        else {
            options = optionsOrCallback;
        }
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] =
            gax.routingHeader.fromParams({
                'document.name': request.document.name || '',
            });
        this.initialize();
        return this.innerApiCalls.updateDocument(request, options, callback);
    }
    /**
     * Deletes a document.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.name
     *   Required. The resource name of the Document to delete. In the format:
     *   `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * @param {google.firestore.v1beta1.Precondition} request.currentDocument
     *   An optional precondition on the document.
     *   The request will fail if this is set and not met by the target document.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [Empty]{@link google.protobuf.Empty}.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
     *   for more details and examples.
     * @example
     * const [response] = await client.deleteDocument(request);
     */
    deleteDocument(request, optionsOrCallback, callback) {
        request = request || {};
        let options;
        if (typeof optionsOrCallback === 'function' && callback === undefined) {
            callback = optionsOrCallback;
            options = {};
        }
        else {
            options = optionsOrCallback;
        }
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] =
            gax.routingHeader.fromParams({
                name: request.name || '',
            });
        this.initialize();
        return this.innerApiCalls.deleteDocument(request, options, callback);
    }
    /**
     * Starts a new transaction.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.database
     *   Required. The database name. In the format:
     *   `projects/{project_id}/databases/{database_id}`.
     * @param {google.firestore.v1beta1.TransactionOptions} request.options
     *   The options for the transaction.
     *   Defaults to a read-write transaction.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [BeginTransactionResponse]{@link google.firestore.v1beta1.BeginTransactionResponse}.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
     *   for more details and examples.
     * @example
     * const [response] = await client.beginTransaction(request);
     */
    beginTransaction(request, optionsOrCallback, callback) {
        request = request || {};
        let options;
        if (typeof optionsOrCallback === 'function' && callback === undefined) {
            callback = optionsOrCallback;
            options = {};
        }
        else {
            options = optionsOrCallback;
        }
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] =
            gax.routingHeader.fromParams({
                database: request.database || '',
            });
        this.initialize();
        return this.innerApiCalls.beginTransaction(request, options, callback);
    }
    /**
     * Commits a transaction, while optionally updating documents.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.database
     *   Required. The database name. In the format:
     *   `projects/{project_id}/databases/{database_id}`.
     * @param {number[]} request.writes
     *   The writes to apply.
     *
     *   Always executed atomically and in order.
     * @param {Buffer} request.transaction
     *   If set, applies all writes in this transaction, and commits it.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [CommitResponse]{@link google.firestore.v1beta1.CommitResponse}.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
     *   for more details and examples.
     * @example
     * const [response] = await client.commit(request);
     */
    commit(request, optionsOrCallback, callback) {
        request = request || {};
        let options;
        if (typeof optionsOrCallback === 'function' && callback === undefined) {
            callback = optionsOrCallback;
            options = {};
        }
        else {
            options = optionsOrCallback;
        }
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] =
            gax.routingHeader.fromParams({
                database: request.database || '',
            });
        this.initialize();
        return this.innerApiCalls.commit(request, options, callback);
    }
    /**
     * Rolls back a transaction.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.database
     *   Required. The database name. In the format:
     *   `projects/{project_id}/databases/{database_id}`.
     * @param {Buffer} request.transaction
     *   Required. The transaction to roll back.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [Empty]{@link google.protobuf.Empty}.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
     *   for more details and examples.
     * @example
     * const [response] = await client.rollback(request);
     */
    rollback(request, optionsOrCallback, callback) {
        request = request || {};
        let options;
        if (typeof optionsOrCallback === 'function' && callback === undefined) {
            callback = optionsOrCallback;
            options = {};
        }
        else {
            options = optionsOrCallback;
        }
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] =
            gax.routingHeader.fromParams({
                database: request.database || '',
            });
        this.initialize();
        return this.innerApiCalls.rollback(request, options, callback);
    }
    /**
     * Applies a batch of write operations.
     *
     * The BatchWrite method does not apply the write operations atomically
     * and can apply them out of order. Method does not allow more than one write
     * per document. Each write succeeds or fails independently. See the
     * {@link google.firestore.v1beta1.BatchWriteResponse|BatchWriteResponse} for the success status of each write.
     *
     * If you require an atomically applied set of writes, use
     * {@link google.firestore.v1beta1.Firestore.Commit|Commit} instead.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.database
     *   Required. The database name. In the format:
     *   `projects/{project_id}/databases/{database_id}`.
     * @param {number[]} request.writes
     *   The writes to apply.
     *
     *   Method does not apply writes atomically and does not guarantee ordering.
     *   Each write succeeds or fails independently. You cannot write to the same
     *   document more than once per request.
     * @param {number[]} request.labels
     *   Labels associated with this batch write.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [BatchWriteResponse]{@link google.firestore.v1beta1.BatchWriteResponse}.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
     *   for more details and examples.
     * @example
     * const [response] = await client.batchWrite(request);
     */
    batchWrite(request, optionsOrCallback, callback) {
        request = request || {};
        let options;
        if (typeof optionsOrCallback === 'function' && callback === undefined) {
            callback = optionsOrCallback;
            options = {};
        }
        else {
            options = optionsOrCallback;
        }
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] =
            gax.routingHeader.fromParams({
                database: request.database || '',
            });
        this.initialize();
        return this.innerApiCalls.batchWrite(request, options, callback);
    }
    /**
     * Creates a new document.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The parent resource. For example:
     *   `projects/{project_id}/databases/{database_id}/documents` or
     *   `projects/{project_id}/databases/{database_id}/documents/chatrooms/{chatroom_id}`
     * @param {string} request.collectionId
     *   Required. The collection ID, relative to `parent`, to list. For example: `chatrooms`.
     * @param {string} request.documentId
     *   The client-assigned document ID to use for this document.
     *
     *   Optional. If not specified, an ID will be assigned by the service.
     * @param {google.firestore.v1beta1.Document} request.document
     *   Required. The document to create. `name` must not be set.
     * @param {google.firestore.v1beta1.DocumentMask} request.mask
     *   The fields to return. If not set, returns all fields.
     *
     *   If the document has a field that is not present in this mask, that field
     *   will not be returned in the response.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [Document]{@link google.firestore.v1beta1.Document}.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
     *   for more details and examples.
     * @example
     * const [response] = await client.createDocument(request);
     */
    createDocument(request, optionsOrCallback, callback) {
        request = request || {};
        let options;
        if (typeof optionsOrCallback === 'function' && callback === undefined) {
            callback = optionsOrCallback;
            options = {};
        }
        else {
            options = optionsOrCallback;
        }
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] =
            gax.routingHeader.fromParams({
                parent: request.parent || '',
            });
        this.initialize();
        return this.innerApiCalls.createDocument(request, options, callback);
    }
    /**
     * Gets multiple documents.
     *
     * Documents returned by this method are not guaranteed to be returned in the
     * same order that they were requested.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.database
     *   Required. The database name. In the format:
     *   `projects/{project_id}/databases/{database_id}`.
     * @param {string[]} request.documents
     *   The names of the documents to retrieve. In the format:
     *   `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     *   The request will fail if any of the document is not a child resource of the
     *   given `database`. Duplicate names will be elided.
     * @param {google.firestore.v1beta1.DocumentMask} request.mask
     *   The fields to return. If not set, returns all fields.
     *
     *   If a document has a field that is not present in this mask, that field will
     *   not be returned in the response.
     * @param {Buffer} request.transaction
     *   Reads documents in a transaction.
     * @param {google.firestore.v1beta1.TransactionOptions} request.newTransaction
     *   Starts a new transaction and reads the documents.
     *   Defaults to a read-only transaction.
     *   The new transaction ID will be returned as the first response in the
     *   stream.
     * @param {google.protobuf.Timestamp} request.readTime
     *   Reads documents as they were at the given time.
     *   This may not be older than 270 seconds.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Stream}
     *   An object stream which emits [BatchGetDocumentsResponse]{@link google.firestore.v1beta1.BatchGetDocumentsResponse} on 'data' event.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#server-streaming)
     *   for more details and examples.
     * @example
     * const stream = client.batchGetDocuments(request);
     * stream.on('data', (response) => { ... });
     * stream.on('end', () => { ... });
     */
    batchGetDocuments(request, options) {
        request = request || {};
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] =
            gax.routingHeader.fromParams({
                database: request.database || '',
            });
        this.initialize();
        return this.innerApiCalls.batchGetDocuments(request, options);
    }
    /**
     * Runs a query.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The parent resource name. In the format:
     *   `projects/{project_id}/databases/{database_id}/documents` or
     *   `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     *   For example:
     *   `projects/my-project/databases/my-database/documents` or
     *   `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
     * @param {google.firestore.v1beta1.StructuredQuery} request.structuredQuery
     *   A structured query.
     * @param {Buffer} request.transaction
     *   Reads documents in a transaction.
     * @param {google.firestore.v1beta1.TransactionOptions} request.newTransaction
     *   Starts a new transaction and reads the documents.
     *   Defaults to a read-only transaction.
     *   The new transaction ID will be returned as the first response in the
     *   stream.
     * @param {google.protobuf.Timestamp} request.readTime
     *   Reads documents as they were at the given time.
     *   This may not be older than 270 seconds.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Stream}
     *   An object stream which emits [RunQueryResponse]{@link google.firestore.v1beta1.RunQueryResponse} on 'data' event.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#server-streaming)
     *   for more details and examples.
     * @example
     * const stream = client.runQuery(request);
     * stream.on('data', (response) => { ... });
     * stream.on('end', () => { ... });
     */
    runQuery(request, options) {
        request = request || {};
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] =
            gax.routingHeader.fromParams({
                parent: request.parent || '',
            });
        this.initialize();
        return this.innerApiCalls.runQuery(request, options);
    }
    /**
     * Streams batches of document updates and deletes, in order.
     *
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Stream}
     *   An object stream which is both readable and writable. It accepts objects
     *   representing [WriteRequest]{@link google.firestore.v1beta1.WriteRequest} for write() method, and
     *   will emit objects representing [WriteResponse]{@link google.firestore.v1beta1.WriteResponse} on 'data' event asynchronously.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#bi-directional-streaming)
     *   for more details and examples.
     * @example
     * const stream = client.write();
     * stream.on('data', (response) => { ... });
     * stream.on('end', () => { ... });
     * stream.write(request);
     * stream.end();
     */
    write(options) {
        this.initialize();
        return this.innerApiCalls.write({}, options);
    }
    /**
     * Listens to changes.
     *
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Stream}
     *   An object stream which is both readable and writable. It accepts objects
     *   representing [ListenRequest]{@link google.firestore.v1beta1.ListenRequest} for write() method, and
     *   will emit objects representing [ListenResponse]{@link google.firestore.v1beta1.ListenResponse} on 'data' event asynchronously.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#bi-directional-streaming)
     *   for more details and examples.
     * @example
     * const stream = client.listen();
     * stream.on('data', (response) => { ... });
     * stream.on('end', () => { ... });
     * stream.write(request);
     * stream.end();
     */
    listen(options) {
        this.initialize();
        return this.innerApiCalls.listen({}, options);
    }
    /**
     * Lists documents.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The parent resource name. In the format:
     *   `projects/{project_id}/databases/{database_id}/documents` or
     *   `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     *   For example:
     *   `projects/my-project/databases/my-database/documents` or
     *   `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
     * @param {string} request.collectionId
     *   Required. The collection ID, relative to `parent`, to list. For example: `chatrooms`
     *   or `messages`.
     * @param {number} request.pageSize
     *   The maximum number of documents to return.
     * @param {string} request.pageToken
     *   The `next_page_token` value returned from a previous List request, if any.
     * @param {string} request.orderBy
     *   The order to sort results by. For example: `priority desc, name`.
     * @param {google.firestore.v1beta1.DocumentMask} request.mask
     *   The fields to return. If not set, returns all fields.
     *
     *   If a document has a field that is not present in this mask, that field
     *   will not be returned in the response.
     * @param {Buffer} request.transaction
     *   Reads documents in a transaction.
     * @param {google.protobuf.Timestamp} request.readTime
     *   Reads documents as they were at the given time.
     *   This may not be older than 270 seconds.
     * @param {boolean} request.showMissing
     *   If the list should show missing documents. A missing document is a
     *   document that does not exist but has sub-documents. These documents will
     *   be returned with a key but will not have fields, {@link google.firestore.v1beta1.Document.create_time|Document.create_time},
     *   or {@link google.firestore.v1beta1.Document.update_time|Document.update_time} set.
     *
     *   Requests with `show_missing` may not specify `where` or
     *   `order_by`.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is Array of [Document]{@link google.firestore.v1beta1.Document}.
     *   The client library will perform auto-pagination by default: it will call the API as many
     *   times as needed and will merge results from all the pages into this array.
     *   Note that it can affect your quota.
     *   We recommend using `listDocumentsAsync()`
     *   method described below for async iteration which you can stop as needed.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
     *   for more details and examples.
     */
    listDocuments(request, optionsOrCallback, callback) {
        request = request || {};
        let options;
        if (typeof optionsOrCallback === 'function' && callback === undefined) {
            callback = optionsOrCallback;
            options = {};
        }
        else {
            options = optionsOrCallback;
        }
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] =
            gax.routingHeader.fromParams({
                parent: request.parent || '',
            });
        this.initialize();
        return this.innerApiCalls.listDocuments(request, options, callback);
    }
    /**
     * Equivalent to `method.name.toCamelCase()`, but returns a NodeJS Stream object.
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The parent resource name. In the format:
     *   `projects/{project_id}/databases/{database_id}/documents` or
     *   `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     *   For example:
     *   `projects/my-project/databases/my-database/documents` or
     *   `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
     * @param {string} request.collectionId
     *   Required. The collection ID, relative to `parent`, to list. For example: `chatrooms`
     *   or `messages`.
     * @param {number} request.pageSize
     *   The maximum number of documents to return.
     * @param {string} request.pageToken
     *   The `next_page_token` value returned from a previous List request, if any.
     * @param {string} request.orderBy
     *   The order to sort results by. For example: `priority desc, name`.
     * @param {google.firestore.v1beta1.DocumentMask} request.mask
     *   The fields to return. If not set, returns all fields.
     *
     *   If a document has a field that is not present in this mask, that field
     *   will not be returned in the response.
     * @param {Buffer} request.transaction
     *   Reads documents in a transaction.
     * @param {google.protobuf.Timestamp} request.readTime
     *   Reads documents as they were at the given time.
     *   This may not be older than 270 seconds.
     * @param {boolean} request.showMissing
     *   If the list should show missing documents. A missing document is a
     *   document that does not exist but has sub-documents. These documents will
     *   be returned with a key but will not have fields, {@link google.firestore.v1beta1.Document.create_time|Document.create_time},
     *   or {@link google.firestore.v1beta1.Document.update_time|Document.update_time} set.
     *
     *   Requests with `show_missing` may not specify `where` or
     *   `order_by`.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Stream}
     *   An object stream which emits an object representing [Document]{@link google.firestore.v1beta1.Document} on 'data' event.
     *   The client library will perform auto-pagination by default: it will call the API as many
     *   times as needed. Note that it can affect your quota.
     *   We recommend using `listDocumentsAsync()`
     *   method described below for async iteration which you can stop as needed.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
     *   for more details and examples.
     */
    listDocumentsStream(request, options) {
        request = request || {};
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] =
            gax.routingHeader.fromParams({
                parent: request.parent || '',
            });
        const callSettings = new gax.CallSettings(options);
        this.initialize();
        return this.descriptors.page.listDocuments.createStream(this.innerApiCalls.listDocuments, request, callSettings);
    }
    /**
     * Equivalent to `listDocuments`, but returns an iterable object.
     *
     * `for`-`await`-`of` syntax is used with the iterable to get response elements on-demand.
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The parent resource name. In the format:
     *   `projects/{project_id}/databases/{database_id}/documents` or
     *   `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     *   For example:
     *   `projects/my-project/databases/my-database/documents` or
     *   `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
     * @param {string} request.collectionId
     *   Required. The collection ID, relative to `parent`, to list. For example: `chatrooms`
     *   or `messages`.
     * @param {number} request.pageSize
     *   The maximum number of documents to return.
     * @param {string} request.pageToken
     *   The `next_page_token` value returned from a previous List request, if any.
     * @param {string} request.orderBy
     *   The order to sort results by. For example: `priority desc, name`.
     * @param {google.firestore.v1beta1.DocumentMask} request.mask
     *   The fields to return. If not set, returns all fields.
     *
     *   If a document has a field that is not present in this mask, that field
     *   will not be returned in the response.
     * @param {Buffer} request.transaction
     *   Reads documents in a transaction.
     * @param {google.protobuf.Timestamp} request.readTime
     *   Reads documents as they were at the given time.
     *   This may not be older than 270 seconds.
     * @param {boolean} request.showMissing
     *   If the list should show missing documents. A missing document is a
     *   document that does not exist but has sub-documents. These documents will
     *   be returned with a key but will not have fields, {@link google.firestore.v1beta1.Document.create_time|Document.create_time},
     *   or {@link google.firestore.v1beta1.Document.update_time|Document.update_time} set.
     *
     *   Requests with `show_missing` may not specify `where` or
     *   `order_by`.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Object}
     *   An iterable Object that allows [async iteration](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols).
     *   When you iterate the returned iterable, each element will be an object representing
     *   [Document]{@link google.firestore.v1beta1.Document}. The API will be called under the hood as needed, once per the page,
     *   so you can stop the iteration when you don't need more results.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
     *   for more details and examples.
     * @example
     * const iterable = client.listDocumentsAsync(request);
     * for await (const response of iterable) {
     *   // process response
     * }
     */
    listDocumentsAsync(request, options) {
        request = request || {};
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] =
            gax.routingHeader.fromParams({
                parent: request.parent || '',
            });
        options = options || {};
        const callSettings = new gax.CallSettings(options);
        this.initialize();
        return this.descriptors.page.listDocuments.asyncIterate(this.innerApiCalls['listDocuments'], request, callSettings);
    }
    /**
     * Partitions a query by returning partition cursors that can be used to run
     * the query in parallel. The returned partition cursors are split points that
     * can be used by RunQuery as starting/end points for the query results.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The parent resource name. In the format:
     *   `projects/{project_id}/databases/{database_id}/documents`.
     *   Document resource names are not supported; only database resource names
     *   can be specified.
     * @param {google.firestore.v1beta1.StructuredQuery} request.structuredQuery
     *   A structured query.
     *   Query must specify collection with all descendants and be ordered by name
     *   ascending. Other filters, order bys, limits, offsets, and start/end
     *   cursors are not supported.
     * @param {number} request.partitionCount
     *   The desired maximum number of partition points.
     *   The partitions may be returned across multiple pages of results.
     *   The number must be positive. The actual number of partitions
     *   returned may be fewer.
     *
     *   For example, this may be set to one fewer than the number of parallel
     *   queries to be run, or in running a data pipeline job, one fewer than the
     *   number of workers or compute instances available.
     * @param {string} request.pageToken
     *   The `next_page_token` value returned from a previous call to
     *   PartitionQuery that may be used to get an additional set of results.
     *   There are no ordering guarantees between sets of results. Thus, using
     *   multiple sets of results will require merging the different result sets.
     *
     *   For example, two subsequent calls using a page_token may return:
     *
     *    * cursor B, cursor M, cursor Q
     *    * cursor A, cursor U, cursor W
     *
     *   To obtain a complete result set ordered with respect to the results of the
     *   query supplied to PartitionQuery, the results sets should be merged:
     *   cursor A, cursor B, cursor M, cursor Q, cursor U, cursor W
     * @param {number} request.pageSize
     *   The maximum number of partitions to return in this call, subject to
     *   `partition_count`.
     *
     *   For example, if `partition_count` = 10 and `page_size` = 8, the first call
     *   to PartitionQuery will return up to 8 partitions and a `next_page_token`
     *   if more results exist. A second call to PartitionQuery will return up to
     *   2 partitions, to complete the total of 10 specified in `partition_count`.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is Array of [Cursor]{@link google.firestore.v1beta1.Cursor}.
     *   The client library will perform auto-pagination by default: it will call the API as many
     *   times as needed and will merge results from all the pages into this array.
     *   Note that it can affect your quota.
     *   We recommend using `partitionQueryAsync()`
     *   method described below for async iteration which you can stop as needed.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
     *   for more details and examples.
     */
    partitionQuery(request, optionsOrCallback, callback) {
        request = request || {};
        let options;
        if (typeof optionsOrCallback === 'function' && callback === undefined) {
            callback = optionsOrCallback;
            options = {};
        }
        else {
            options = optionsOrCallback;
        }
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] =
            gax.routingHeader.fromParams({
                parent: request.parent || '',
            });
        this.initialize();
        return this.innerApiCalls.partitionQuery(request, options, callback);
    }
    /**
     * Equivalent to `method.name.toCamelCase()`, but returns a NodeJS Stream object.
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The parent resource name. In the format:
     *   `projects/{project_id}/databases/{database_id}/documents`.
     *   Document resource names are not supported; only database resource names
     *   can be specified.
     * @param {google.firestore.v1beta1.StructuredQuery} request.structuredQuery
     *   A structured query.
     *   Query must specify collection with all descendants and be ordered by name
     *   ascending. Other filters, order bys, limits, offsets, and start/end
     *   cursors are not supported.
     * @param {number} request.partitionCount
     *   The desired maximum number of partition points.
     *   The partitions may be returned across multiple pages of results.
     *   The number must be positive. The actual number of partitions
     *   returned may be fewer.
     *
     *   For example, this may be set to one fewer than the number of parallel
     *   queries to be run, or in running a data pipeline job, one fewer than the
     *   number of workers or compute instances available.
     * @param {string} request.pageToken
     *   The `next_page_token` value returned from a previous call to
     *   PartitionQuery that may be used to get an additional set of results.
     *   There are no ordering guarantees between sets of results. Thus, using
     *   multiple sets of results will require merging the different result sets.
     *
     *   For example, two subsequent calls using a page_token may return:
     *
     *    * cursor B, cursor M, cursor Q
     *    * cursor A, cursor U, cursor W
     *
     *   To obtain a complete result set ordered with respect to the results of the
     *   query supplied to PartitionQuery, the results sets should be merged:
     *   cursor A, cursor B, cursor M, cursor Q, cursor U, cursor W
     * @param {number} request.pageSize
     *   The maximum number of partitions to return in this call, subject to
     *   `partition_count`.
     *
     *   For example, if `partition_count` = 10 and `page_size` = 8, the first call
     *   to PartitionQuery will return up to 8 partitions and a `next_page_token`
     *   if more results exist. A second call to PartitionQuery will return up to
     *   2 partitions, to complete the total of 10 specified in `partition_count`.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Stream}
     *   An object stream which emits an object representing [Cursor]{@link google.firestore.v1beta1.Cursor} on 'data' event.
     *   The client library will perform auto-pagination by default: it will call the API as many
     *   times as needed. Note that it can affect your quota.
     *   We recommend using `partitionQueryAsync()`
     *   method described below for async iteration which you can stop as needed.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
     *   for more details and examples.
     */
    partitionQueryStream(request, options) {
        request = request || {};
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] =
            gax.routingHeader.fromParams({
                parent: request.parent || '',
            });
        const callSettings = new gax.CallSettings(options);
        this.initialize();
        return this.descriptors.page.partitionQuery.createStream(this.innerApiCalls.partitionQuery, request, callSettings);
    }
    /**
     * Equivalent to `partitionQuery`, but returns an iterable object.
     *
     * `for`-`await`-`of` syntax is used with the iterable to get response elements on-demand.
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The parent resource name. In the format:
     *   `projects/{project_id}/databases/{database_id}/documents`.
     *   Document resource names are not supported; only database resource names
     *   can be specified.
     * @param {google.firestore.v1beta1.StructuredQuery} request.structuredQuery
     *   A structured query.
     *   Query must specify collection with all descendants and be ordered by name
     *   ascending. Other filters, order bys, limits, offsets, and start/end
     *   cursors are not supported.
     * @param {number} request.partitionCount
     *   The desired maximum number of partition points.
     *   The partitions may be returned across multiple pages of results.
     *   The number must be positive. The actual number of partitions
     *   returned may be fewer.
     *
     *   For example, this may be set to one fewer than the number of parallel
     *   queries to be run, or in running a data pipeline job, one fewer than the
     *   number of workers or compute instances available.
     * @param {string} request.pageToken
     *   The `next_page_token` value returned from a previous call to
     *   PartitionQuery that may be used to get an additional set of results.
     *   There are no ordering guarantees between sets of results. Thus, using
     *   multiple sets of results will require merging the different result sets.
     *
     *   For example, two subsequent calls using a page_token may return:
     *
     *    * cursor B, cursor M, cursor Q
     *    * cursor A, cursor U, cursor W
     *
     *   To obtain a complete result set ordered with respect to the results of the
     *   query supplied to PartitionQuery, the results sets should be merged:
     *   cursor A, cursor B, cursor M, cursor Q, cursor U, cursor W
     * @param {number} request.pageSize
     *   The maximum number of partitions to return in this call, subject to
     *   `partition_count`.
     *
     *   For example, if `partition_count` = 10 and `page_size` = 8, the first call
     *   to PartitionQuery will return up to 8 partitions and a `next_page_token`
     *   if more results exist. A second call to PartitionQuery will return up to
     *   2 partitions, to complete the total of 10 specified in `partition_count`.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Object}
     *   An iterable Object that allows [async iteration](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols).
     *   When you iterate the returned iterable, each element will be an object representing
     *   [Cursor]{@link google.firestore.v1beta1.Cursor}. The API will be called under the hood as needed, once per the page,
     *   so you can stop the iteration when you don't need more results.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
     *   for more details and examples.
     * @example
     * const iterable = client.partitionQueryAsync(request);
     * for await (const response of iterable) {
     *   // process response
     * }
     */
    partitionQueryAsync(request, options) {
        request = request || {};
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] =
            gax.routingHeader.fromParams({
                parent: request.parent || '',
            });
        options = options || {};
        const callSettings = new gax.CallSettings(options);
        this.initialize();
        return this.descriptors.page.partitionQuery.asyncIterate(this.innerApiCalls['partitionQuery'], request, callSettings);
    }
    /**
     * Lists all the collection IDs underneath a document.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The parent document. In the format:
     *   `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     *   For example:
     *   `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
     * @param {number} request.pageSize
     *   The maximum number of results to return.
     * @param {string} request.pageToken
     *   A page token. Must be a value from
     *   {@link google.firestore.v1beta1.ListCollectionIdsResponse|ListCollectionIdsResponse}.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is Array of string.
     *   The client library will perform auto-pagination by default: it will call the API as many
     *   times as needed and will merge results from all the pages into this array.
     *   Note that it can affect your quota.
     *   We recommend using `listCollectionIdsAsync()`
     *   method described below for async iteration which you can stop as needed.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
     *   for more details and examples.
     */
    listCollectionIds(request, optionsOrCallback, callback) {
        request = request || {};
        let options;
        if (typeof optionsOrCallback === 'function' && callback === undefined) {
            callback = optionsOrCallback;
            options = {};
        }
        else {
            options = optionsOrCallback;
        }
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] =
            gax.routingHeader.fromParams({
                parent: request.parent || '',
            });
        this.initialize();
        return this.innerApiCalls.listCollectionIds(request, options, callback);
    }
    /**
     * Equivalent to `method.name.toCamelCase()`, but returns a NodeJS Stream object.
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The parent document. In the format:
     *   `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     *   For example:
     *   `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
     * @param {number} request.pageSize
     *   The maximum number of results to return.
     * @param {string} request.pageToken
     *   A page token. Must be a value from
     *   {@link google.firestore.v1beta1.ListCollectionIdsResponse|ListCollectionIdsResponse}.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Stream}
     *   An object stream which emits an object representing string on 'data' event.
     *   The client library will perform auto-pagination by default: it will call the API as many
     *   times as needed. Note that it can affect your quota.
     *   We recommend using `listCollectionIdsAsync()`
     *   method described below for async iteration which you can stop as needed.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
     *   for more details and examples.
     */
    listCollectionIdsStream(request, options) {
        request = request || {};
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] =
            gax.routingHeader.fromParams({
                parent: request.parent || '',
            });
        const callSettings = new gax.CallSettings(options);
        this.initialize();
        return this.descriptors.page.listCollectionIds.createStream(this.innerApiCalls.listCollectionIds, request, callSettings);
    }
    /**
     * Equivalent to `listCollectionIds`, but returns an iterable object.
     *
     * `for`-`await`-`of` syntax is used with the iterable to get response elements on-demand.
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The parent document. In the format:
     *   `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     *   For example:
     *   `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
     * @param {number} request.pageSize
     *   The maximum number of results to return.
     * @param {string} request.pageToken
     *   A page token. Must be a value from
     *   {@link google.firestore.v1beta1.ListCollectionIdsResponse|ListCollectionIdsResponse}.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Object}
     *   An iterable Object that allows [async iteration](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols).
     *   When you iterate the returned iterable, each element will be an object representing
     *   string. The API will be called under the hood as needed, once per the page,
     *   so you can stop the iteration when you don't need more results.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
     *   for more details and examples.
     * @example
     * const iterable = client.listCollectionIdsAsync(request);
     * for await (const response of iterable) {
     *   // process response
     * }
     */
    listCollectionIdsAsync(request, options) {
        request = request || {};
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] =
            gax.routingHeader.fromParams({
                parent: request.parent || '',
            });
        options = options || {};
        const callSettings = new gax.CallSettings(options);
        this.initialize();
        return this.descriptors.page.listCollectionIds.asyncIterate(this.innerApiCalls['listCollectionIds'], request, callSettings);
    }
    /**
     * Terminate the gRPC channel and close the client.
     *
     * The client will no longer be usable and all future behavior is undefined.
     * @returns {Promise} A promise that resolves when the client is closed.
     */
    close() {
        this.initialize();
        if (!this._terminated) {
            return this.firestoreStub.then(stub => {
                this._terminated = true;
                stub.close();
            });
        }
        return Promise.resolve();
    }
}
exports.FirestoreClient = FirestoreClient;
//# sourceMappingURL=firestore_client.js.map;