import t from "@firebase/app";

import { base64 as e, isMobileCordova as n, isReactNative as s, isElectron as i, isIE as r, isUWP as o, isBrowserExtension as u } from "@firebase/util";

import { Logger as c, LogLevel as a } from "@firebase/logger";

import { XhrIo as h, EventType as l, ErrorCode as _, createWebChannelTransport as f, WebChannel as d } from "@firebase/webchannel-wrapper";

import { Component as w } from "@firebase/component";

/** Converts a Base64 encoded string to a binary string. */
function m(t) {
    return String.fromCharCode.apply(null, 
    // We use `decodeStringToByteArray()` instead of `decodeString()` since
    // `decodeString()` returns Unicode strings, which doesn't match the values
    // returned by `atob()`'s Latin1 representation.
    e.decodeStringToByteArray(t, false));
}

/** Converts a binary string to a Base64 encoded string. */
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const T = {
    // Causes are copied from:
    // https://github.com/grpc/grpc/blob/bceec94ea4fc5f0085d81235d8e1c06798dc341a/include/grpc%2B%2B/impl/codegen/status_code_enum.h
    /** Not an error; returned on success. */
    OK: "ok",
    /** The operation was cancelled (typically by the caller). */
    CANCELLED: "cancelled",
    /** Unknown error or an error from a different error domain. */
    UNKNOWN: "unknown",
    /**
     * Client specified an invalid argument. Note that this differs from
     * FAILED_PRECONDITION. INVALID_ARGUMENT indicates arguments that are
     * problematic regardless of the state of the system (e.g., a malformed file
     * name).
     */
    INVALID_ARGUMENT: "invalid-argument",
    /**
     * Deadline expired before operation could complete. For operations that
     * change the state of the system, this error may be returned even if the
     * operation has completed successfully. For example, a successful response
     * from a server could have been delayed long enough for the deadline to
     * expire.
     */
    DEADLINE_EXCEEDED: "deadline-exceeded",
    /** Some requested entity (e.g., file or directory) was not found. */
    NOT_FOUND: "not-found",
    /**
     * Some entity that we attempted to create (e.g., file or directory) already
     * exists.
     */
    ALREADY_EXISTS: "already-exists",
    /**
     * The caller does not have permission to execute the specified operation.
     * PERMISSION_DENIED must not be used for rejections caused by exhausting
     * some resource (use RESOURCE_EXHAUSTED instead for those errors).
     * PERMISSION_DENIED must not be used if the caller can not be identified
     * (use UNAUTHENTICATED instead for those errors).
     */
    PERMISSION_DENIED: "permission-denied",
    /**
     * The request does not have valid authentication credentials for the
     * operation.
     */
    UNAUTHENTICATED: "unauthenticated",
    /**
     * Some resource has been exhausted, perhaps a per-user quota, or perhaps the
     * entire file system is out of space.
     */
    RESOURCE_EXHAUSTED: "resource-exhausted",
    /**
     * Operation was rejected because the system is not in a state required for
     * the operation's execution. For example, directory to be deleted may be
     * non-empty, an rmdir operation is applied to a non-directory, etc.
     *
     * A litmus test that may help a service implementor in deciding
     * between FAILED_PRECONDITION, ABORTED, and UNAVAILABLE:
     *  (a) Use UNAVAILABLE if the client can retry just the failing call.
     *  (b) Use ABORTED if the client should retry at a higher-level
     *      (e.g., restarting a read-modify-write sequence).
     *  (c) Use FAILED_PRECONDITION if the client should not retry until
     *      the system state has been explicitly fixed. E.g., if an "rmdir"
     *      fails because the directory is non-empty, FAILED_PRECONDITION
     *      should be returned since the client should not retry unless
     *      they have first fixed up the directory by deleting files from it.
     *  (d) Use FAILED_PRECONDITION if the client performs conditional
     *      REST Get/Update/Delete on a resource and the resource on the
     *      server does not match the condition. E.g., conflicting
     *      read-modify-write on the same resource.
     */
    FAILED_PRECONDITION: "failed-precondition",
    /**
     * The operation was aborted, typically due to a concurrency issue like
     * sequencer check failures, transaction aborts, etc.
     *
     * See litmus test above for deciding between FAILED_PRECONDITION, ABORTED,
     * and UNAVAILABLE.
     */
    ABORTED: "aborted",
    /**
     * Operation was attempted past the valid range. E.g., seeking or reading
     * past end of file.
     *
     * Unlike INVALID_ARGUMENT, this error indicates a problem that may be fixed
     * if the system state changes. For example, a 32-bit file system will
     * generate INVALID_ARGUMENT if asked to read at an offset that is not in the
     * range [0,2^32-1], but it will generate OUT_OF_RANGE if asked to read from
     * an offset past the current file size.
     *
     * There is a fair bit of overlap between FAILED_PRECONDITION and
     * OUT_OF_RANGE. We recommend using OUT_OF_RANGE (the more specific error)
     * when it applies so that callers who are iterating through a space can
     * easily look for an OUT_OF_RANGE error to detect when they are done.
     */
    OUT_OF_RANGE: "out-of-range",
    /** Operation is not implemented or not supported/enabled in this service. */
    UNIMPLEMENTED: "unimplemented",
    /**
     * Internal errors. Means some invariants expected by underlying System has
     * been broken. If you see one of these errors, Something is very broken.
     */
    INTERNAL: "internal",
    /**
     * The service is currently unavailable. This is a most likely a transient
     * condition and may be corrected by retrying with a backoff.
     *
     * See litmus test above for deciding between FAILED_PRECONDITION, ABORTED,
     * and UNAVAILABLE.
     */
    UNAVAILABLE: "unavailable",
    /** Unrecoverable data loss or corruption. */
    DATA_LOSS: "data-loss"
};

/** An error returned by a Firestore operation. */ class E extends Error {
    constructor(t, e) {
        super(e), this.code = t, this.message = e, this.name = "FirebaseError", 
        // HACK: We write a toString property directly because Error is not a real
        // class and so inheritance does not work correctly. We could alternatively
        // do the same "back-door inheritance" trick that FirebaseError does.
        this.toString = () => `${this.name}: [code=${this.code}]: ${this.message}`;
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const I = new c("@firebase/firestore");

// Helper methods are needed because variables can't be exported as read/write
function A() {
    return I.logLevel;
}

/**
 * Sets the verbosity of Cloud Firestore logs (debug, error, or silent).
 *
 * @param logLevel
 *   The verbosity you set for activity and error logging. Can be any of
 *   the following values:
 *
 *   <ul>
 *     <li>`debug` for the most verbose logging level, primarily for
 *     debugging.</li>
 *     <li>`error` to log errors only.</li>
 *     <li><code>`silent` to turn off logging.</li>
 *   </ul>
 */ function R(t, ...e) {
    if (I.logLevel <= a.DEBUG) {
        const n = e.map(g);
        I.debug("Firestore (7.24.0): " + t, ...n);
    }
}

function y(t, ...e) {
    if (I.logLevel <= a.ERROR) {
        const n = e.map(g);
        I.error("Firestore (7.24.0): " + t, ...n);
    }
}

function P(t, ...e) {
    if (I.logLevel <= a.WARN) {
        const n = e.map(g);
        I.warn("Firestore (7.24.0): " + t, ...n);
    }
}

/**
 * Converts an additional log parameter to a string representation.
 */ function g(t) {
    if ("string" == typeof t) return t;
    try {
        return e = t, JSON.stringify(e);
    } catch (e) {
        // Converting to JSON failed, just log the object directly
        return t;
    }
    /**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
    /** Formats an object as a JSON string, suitable for logging. */
    var e;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Unconditionally fails, throwing an Error with the given message.
 * Messages are stripped in production builds.
 *
 * Returns `never` and can be used in expressions:
 * @example
 * let futureVar = fail('not implemented yet');
 */ function p(t = "Unexpected state") {
    // Log the failure in addition to throw an exception, just in case the
    // exception is swallowed.
    const e = "FIRESTORE (7.24.0) INTERNAL ASSERTION FAILED: " + t;
    // NOTE: We don't use FirestoreError here because these are internal failures
    // that cannot be handled by the user. (Also it would create a circular
    // dependency between the error and assert modules which doesn't work.)
    throw y(e), new Error(e);
}

/**
 * Fails if the given assertion condition is false, throwing an Error with the
 * given message if it did.
 *
 * Messages are stripped in production builds.
 */ function V(t, e) {
    t || p();
}

/**
 * Casts `obj` to `T`. In non-production builds, verifies that `obj` is an
 * instance of `T` before casting.
 */ function v(t, 
// eslint-disable-next-line @typescript-eslint/no-explicit-any
e) {
    return t;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ function b(t) {
    let e = 0;
    for (const n in t) Object.prototype.hasOwnProperty.call(t, n) && e++;
    return e;
}

function S(t, e) {
    for (const n in t) Object.prototype.hasOwnProperty.call(t, n) && e(n, t[n]);
}

function D(t) {
    for (const e in t) if (Object.prototype.hasOwnProperty.call(t, e)) return !1;
    return !0;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Path represents an ordered sequence of string segments.
 */
class C {
    constructor(t, e, n) {
        void 0 === e ? e = 0 : e > t.length && p(), void 0 === n ? n = t.length - e : n > t.length - e && p(), 
        this.segments = t, this.offset = e, this.t = n;
    }
    get length() {
        return this.t;
    }
    isEqual(t) {
        return 0 === C.i(this, t);
    }
    child(t) {
        const e = this.segments.slice(this.offset, this.limit());
        return t instanceof C ? t.forEach((t => {
            e.push(t);
        })) : e.push(t), this.o(e);
    }
    /** The index of one past the last segment of the path. */    limit() {
        return this.offset + this.length;
    }
    u(t) {
        return t = void 0 === t ? 1 : t, this.o(this.segments, this.offset + t, this.length - t);
    }
    h() {
        return this.o(this.segments, this.offset, this.length - 1);
    }
    l() {
        return this.segments[this.offset];
    }
    _() {
        return this.get(this.length - 1);
    }
    get(t) {
        return this.segments[this.offset + t];
    }
    m() {
        return 0 === this.length;
    }
    T(t) {
        if (t.length < this.length) return !1;
        for (let e = 0; e < this.length; e++) if (this.get(e) !== t.get(e)) return !1;
        return !0;
    }
    I(t) {
        if (this.length + 1 !== t.length) return !1;
        for (let e = 0; e < this.length; e++) if (this.get(e) !== t.get(e)) return !1;
        return !0;
    }
    forEach(t) {
        for (let e = this.offset, n = this.limit(); e < n; e++) t(this.segments[e]);
    }
    A() {
        return this.segments.slice(this.offset, this.limit());
    }
    static i(t, e) {
        const n = Math.min(t.length, e.length);
        for (let s = 0; s < n; s++) {
            const n = t.get(s), i = e.get(s);
            if (n < i) return -1;
            if (n > i) return 1;
        }
        return t.length < e.length ? -1 : t.length > e.length ? 1 : 0;
    }
}

/**
 * A slash-separated path for navigating resources (documents and collections)
 * within Firestore.
 */ class F extends C {
    o(t, e, n) {
        return new F(t, e, n);
    }
    R() {
        // NOTE: The client is ignorant of any path segments containing escape
        // sequences (e.g. __id123__) and just passes them through raw (they exist
        // for legacy reasons and should not be used frequently).
        return this.A().join("/");
    }
    toString() {
        return this.R();
    }
    /**
     * Creates a resource path from the given slash-delimited string. If multiple
     * arguments are provided, all components are combined. Leading and trailing
     * slashes from all components are ignored.
     */    static P(...t) {
        // NOTE: The client is ignorant of any path segments containing escape
        // sequences (e.g. __id123__) and just passes them through raw (they exist
        // for legacy reasons and should not be used frequently).
        const e = [];
        for (const n of t) {
            if (n.indexOf("//") >= 0) throw new E(T.INVALID_ARGUMENT, `Invalid segment (${n}). Paths must not contain // in them.`);
            // Strip leading and traling slashed.
                        e.push(...n.split("/").filter((t => t.length > 0)));
        }
        return new F(e);
    }
    static g() {
        return new F([]);
    }
}

const N = /^[_a-zA-Z][_a-zA-Z0-9]*$/;

/** A dot-separated path for navigating sub-objects within a document. */ class $ extends C {
    o(t, e, n) {
        return new $(t, e, n);
    }
    /**
     * Returns true if the string could be used as a segment in a field path
     * without escaping.
     */    static p(t) {
        return N.test(t);
    }
    R() {
        return this.A().map((t => (t = t.replace("\\", "\\\\").replace("`", "\\`"), $.p(t) || (t = "`" + t + "`"), 
        t))).join(".");
    }
    toString() {
        return this.R();
    }
    /**
     * Returns true if this field references the key of a document.
     */    V() {
        return 1 === this.length && "__name__" === this.get(0);
    }
    /**
     * The field designating the key of a document.
     */    static v() {
        return new $([ "__name__" ]);
    }
    /**
     * Parses a field string from the given server-formatted string.
     *
     * - Splitting the empty string is not allowed (for now at least).
     * - Empty segments within the string (e.g. if there are two consecutive
     *   separators) are not allowed.
     *
     * TODO(b/37244157): we should make this more strict. Right now, it allows
     * non-identifier path components, even if they aren't escaped.
     */    static S(t) {
        const e = [];
        let n = "", s = 0;
        const i = () => {
            if (0 === n.length) throw new E(T.INVALID_ARGUMENT, `Invalid field path (${t}). Paths must not be empty, begin with '.', end with '.', or contain '..'`);
            e.push(n), n = "";
        };
        let r = !1;
        for (;s < t.length; ) {
            const e = t[s];
            if ("\\" === e) {
                if (s + 1 === t.length) throw new E(T.INVALID_ARGUMENT, "Path has trailing escape character: " + t);
                const e = t[s + 1];
                if ("\\" !== e && "." !== e && "`" !== e) throw new E(T.INVALID_ARGUMENT, "Path has invalid escape sequence: " + t);
                n += e, s += 2;
            } else "`" === e ? (r = !r, s++) : "." !== e || r ? (n += e, s++) : (i(), s++);
        }
        if (i(), r) throw new E(T.INVALID_ARGUMENT, "Unterminated ` in path: " + t);
        return new $(e);
    }
    static g() {
        return new $([]);
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ class x {
    constructor(t) {
        this.path = t;
    }
    static D(t) {
        return new x(F.P(t));
    }
    static C(t) {
        return new x(F.P(t).u(5));
    }
    /** Returns true if the document is in the specified collectionId. */    F(t) {
        return this.path.length >= 2 && this.path.get(this.path.length - 2) === t;
    }
    isEqual(t) {
        return null !== t && 0 === F.i(this.path, t.path);
    }
    toString() {
        return this.path.toString();
    }
    static i(t, e) {
        return F.i(t.path, e.path);
    }
    static N(t) {
        return t.length % 2 == 0;
    }
    /**
     * Creates and returns a new document key with the given segments.
     *
     * @param segments The segments of the path to the document
     * @return A new instance of DocumentKey
     */    static $(t) {
        return new x(new F(t.slice()));
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Validates that no arguments were passed in the invocation of functionName.
 *
 * Forward the magic "arguments" variable as second parameter on which the
 * parameter validation is performed:
 * validateNoArgs('myFunction', arguments);
 */ function k(t, e) {
    if (0 !== e.length) throw new E(T.INVALID_ARGUMENT, `Function ${t}() does not support arguments, but was called with ` + et(e.length, "argument") + ".");
}

/**
 * Validates the invocation of functionName has the exact number of arguments.
 *
 * Forward the magic "arguments" variable as second parameter on which the
 * parameter validation is performed:
 * validateExactNumberOfArgs('myFunction', arguments, 2);
 */ function O(t, e, n) {
    if (e.length !== n) throw new E(T.INVALID_ARGUMENT, `Function ${t}() requires ` + et(n, "argument") + ", but was called with " + et(e.length, "argument") + ".");
}

/**
 * Validates the invocation of functionName has at least the provided number of
 * arguments (but can have many more).
 *
 * Forward the magic "arguments" variable as second parameter on which the
 * parameter validation is performed:
 * validateAtLeastNumberOfArgs('myFunction', arguments, 2);
 */ function L(t, e, n) {
    if (e.length < n) throw new E(T.INVALID_ARGUMENT, `Function ${t}() requires at least ` + et(n, "argument") + ", but was called with " + et(e.length, "argument") + ".");
}

/**
 * Validates the invocation of functionName has number of arguments between
 * the values provided.
 *
 * Forward the magic "arguments" variable as second parameter on which the
 * parameter validation is performed:
 * validateBetweenNumberOfArgs('myFunction', arguments, 2, 3);
 */ function M(t, e, n, s) {
    if (e.length < n || e.length > s) throw new E(T.INVALID_ARGUMENT, `Function ${t}() requires between ${n} and ` + s + " arguments, but was called with " + et(e.length, "argument") + ".");
}

/**
 * Validates the provided argument is an array and has as least the expected
 * number of elements.
 */
/**
 * Validates the provided positional argument has the native JavaScript type
 * using typeof checks.
 */
function q(t, e, n, s) {
    z(t, e, tt(n) + " argument", s);
}

/**
 * Validates the provided argument has the native JavaScript type using
 * typeof checks or is undefined.
 */ function U(t, e, n, s) {
    void 0 !== s && q(t, e, n, s);
}

/**
 * Validates the provided named option has the native JavaScript type using
 * typeof checks.
 */ function B(t, e, n, s) {
    z(t, e, n + " option", s);
}

/**
 * Validates the provided named option has the native JavaScript type using
 * typeof checks or is undefined.
 */ function Q(t, e, n, s) {
    void 0 !== s && B(t, e, n, s);
}

/**
 * Validates that two boolean options are not set at the same time.
 */ function j(t, e, n, s, i) {
    void 0 !== s && function(t, e, n, s, i) {
        if (!(s instanceof Array)) throw new E(T.INVALID_ARGUMENT, `Function ${t}() requires its ${e} option to be an array, but it was: ` + H(s));
        for (let r = 0; r < s.length; ++r) if (!i(s[r])) throw new E(T.INVALID_ARGUMENT, `Function ${t}() requires all ${e} elements to be ${n}, but the value at index ${r} was: ` + H(s[r]));
    }(t, e, n, s, i);
}

/**
 * Validates that the provided named option equals one of the expected values.
 */
/**
 * Validates that the provided named option equals one of the expected values or
 * is undefined.
 */
function W(t, e, n, s, i) {
    void 0 !== s && function(t, e, n, s, i) {
        const r = [];
        for (const t of i) {
            if (t === s) return;
            r.push(H(t));
        }
        const o = H(s);
        throw new E(T.INVALID_ARGUMENT, `Invalid value ${o} provided to function ${t}() for option "${n}". Acceptable values: ${r.join(", ")}`);
    }(t, 0, n, s, i);
}

/**
 * Validates that the provided argument is a valid enum.
 *
 * @param functionName Function making the validation call.
 * @param enums Array containing all possible values for the enum.
 * @param position Position of the argument in `functionName`.
 * @param argument Argument to validate.
 * @return The value as T if the argument can be converted.
 */ function G(t, e, n, s) {
    if (!e.some((t => t === s))) throw new E(T.INVALID_ARGUMENT, `Invalid value ${H(s)} provided to function ${t}() for its ${tt(n)} argument. Acceptable values: ` + e.join(", "));
    return s;
}

/** Helper to validate the type of a provided input. */ function z(t, e, n, s) {
    let i = !1;
    if (i = "object" === e ? K(s) : "non-empty string" === e ? "string" == typeof s && "" !== s : typeof s === e, 
    !i) {
        const i = H(s);
        throw new E(T.INVALID_ARGUMENT, `Function ${t}() requires its ${n} to be of type ${e}, but it was: ${i}`);
    }
}

/**
 * Returns true if it's a non-null object without a custom prototype
 * (i.e. excludes Array, Date, etc.).
 */ function K(t) {
    return "object" == typeof t && null !== t && (Object.getPrototypeOf(t) === Object.prototype || null === Object.getPrototypeOf(t));
}

/** Returns a string describing the type / value of the provided input. */ function H(t) {
    if (void 0 === t) return "undefined";
    if (null === t) return "null";
    if ("string" == typeof t) return t.length > 20 && (t = t.substring(0, 20) + "..."), 
    JSON.stringify(t);
    if ("number" == typeof t || "boolean" == typeof t) return "" + t;
    if ("object" == typeof t) {
        if (t instanceof Array) return "an array";
        {
            const e = 
            /** Hacky method to try to get the constructor name for an object. */
            function(t) {
                if (t.constructor) {
                    const e = /function\s+([^\s(]+)\s*\(/.exec(t.constructor.toString());
                    if (e && e.length > 1) return e[1];
                }
                return null;
            }
            /** Validates the provided argument is defined. */ (t);
            return e ? `a custom ${e} object` : "an object";
        }
    }
    return "function" == typeof t ? "a function" : p();
}

function Y(t, e, n) {
    if (void 0 === n) throw new E(T.INVALID_ARGUMENT, `Function ${t}() requires a valid ${tt(e)} argument, but it was undefined.`);
}

/**
 * Validates the provided positional argument is an object, and its keys and
 * values match the expected keys and types provided in optionTypes.
 */ function J(t, e, n) {
    S(e, ((e, s) => {
        if (n.indexOf(e) < 0) throw new E(T.INVALID_ARGUMENT, `Unknown option '${e}' passed to function ${t}(). Available options: ` + n.join(", "));
    }));
}

/**
 * Helper method to throw an error that the provided argument did not pass
 * an instanceof check.
 */ function X(t, e, n, s) {
    const i = H(s);
    return new E(T.INVALID_ARGUMENT, `Function ${t}() requires its ${tt(n)} argument to be a ${e}, but it was: ${i}`);
}

function Z(t, e, n) {
    if (n <= 0) throw new E(T.INVALID_ARGUMENT, `Function ${t}() requires its ${tt(e)} argument to be a positive number, but it was: ${n}.`);
}

/** Converts a number to its english word representation */ function tt(t) {
    switch (t) {
      case 1:
        return "first";

      case 2:
        return "second";

      case 3:
        return "third";

      default:
        return t + "th";
    }
}

/**
 * Formats the given word as plural conditionally given the preceding number.
 */ function et(t, e) {
    return `${t} ${e}` + (1 === t ? "" : "s");
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Generates `nBytes` of random bytes.
 *
 * If `nBytes < 0` , an error will be thrown.
 */ function nt(t) {
    // Polyfills for IE and WebWorker by using `self` and `msCrypto` when `crypto` is not available.
    const e = 
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    "undefined" != typeof self && (self.crypto || self.msCrypto), n = new Uint8Array(t);
    if (e && "function" == typeof e.getRandomValues) e.getRandomValues(n); else 
    // Falls back to Math.random
    for (let e = 0; e < t; e++) n[e] = Math.floor(256 * Math.random());
    return n;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ class st {
    static k() {
        // Alphanumeric characters
        const t = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", e = Math.floor(256 / t.length) * t.length;
        // The largest byte value that is a multiple of `char.length`.
                let n = "";
        for (;n.length < 20; ) {
            const s = nt(40);
            for (let i = 0; i < s.length; ++i) 
            // Only accept values that are [0, maxMultiple), this ensures they can
            // be evenly mapped to indices of `chars` via a modulo operation.
            n.length < 20 && s[i] < e && (n += t.charAt(s[i] % t.length));
        }
        return n;
    }
}

function it(t, e) {
    return t < e ? -1 : t > e ? 1 : 0;
}

/** Helper to compare arrays using isEqual(). */ function rt(t, e, n) {
    return t.length === e.length && t.every(((t, s) => n(t, e[s])));
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Immutable class that represents a "proto" byte string.
 *
 * Proto byte strings can either be Base64-encoded strings or Uint8Arrays when
 * sent on the wire. This class abstracts away this differentiation by holding
 * the proto byte string in a common class that must be converted into a string
 * before being sent as a proto.
 */ class ot {
    constructor(t) {
        this.O = t;
    }
    static fromBase64String(t) {
        const e = m(t);
        return new ot(e);
    }
    static fromUint8Array(t) {
        const e = 
        /**
 * Helper function to convert an Uint8array to a binary string.
 */
        function(t) {
            let e = "";
            for (let n = 0; n < t.length; ++n) e += String.fromCharCode(t[n]);
            return e;
        }
        /**
 * Helper function to convert a binary string to an Uint8Array.
 */ (t);
        return new ot(e);
    }
    toBase64() {
        return function(t) {
            const n = [];
            for (let e = 0; e < t.length; e++) n[e] = t.charCodeAt(e);
            return e.encodeByteArray(n, !1);
        }(this.O);
    }
    toUint8Array() {
        return function(t) {
            const e = new Uint8Array(t.length);
            for (let n = 0; n < t.length; n++) e[n] = t.charCodeAt(n);
            return e;
        }
        /**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
        /**
 * An immutable object representing an array of bytes.
 */ (this.O);
    }
    L() {
        return 2 * this.O.length;
    }
    M(t) {
        return it(this.O, t.O);
    }
    isEqual(t) {
        return this.O === t.O;
    }
}

ot.q = new ot("");

class ut {
    constructor(t) {
        this.U = t;
    }
    /**
     * Creates a new `Bytes` object from the given Base64 string, converting it to
     * bytes.
     *
     * @param base64 The Base64 string used to create the `Bytes` object.
     */    static fromBase64String(t) {
        try {
            return new ut(ot.fromBase64String(t));
        } catch (t) {
            throw new E(T.INVALID_ARGUMENT, "Failed to construct Bytes from Base64 string: " + t);
        }
    }
    /**
     * Creates a new `Bytes` object from the given Uint8Array.
     *
     * @param array The Uint8Array used to create the `Bytes` object.
     */    static fromUint8Array(t) {
        return new ut(ot.fromUint8Array(t));
    }
    /**
     * Returns the underlying bytes as a Base64-encoded string.
     *
     * @return The Base64-encoded string created from the `Bytes` object.
     */    toBase64() {
        return this.U.toBase64();
    }
    /**
     * Returns the underlying bytes in a new `Uint8Array`.
     *
     * @return The Uint8Array created from the `Bytes` object.
     */    toUint8Array() {
        return this.U.toUint8Array();
    }
    /**
     * Returns a string representation of the `Bytes` object.
     *
     * @return A string representation of the `Bytes` object.
     */    toString() {
        return "Bytes(base64: " + this.toBase64() + ")";
    }
    /**
     * Returns true if this `Bytes` object is equal to the provided one.
     *
     * @param other The `Bytes` object to compare against.
     * @return true if this `Bytes` object is equal to the provided one.
     */    isEqual(t) {
        return this.U.isEqual(t.U);
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** Helper function to assert Uint8Array is available at runtime. */ function ct() {
    if ("undefined" == typeof Uint8Array) throw new E(T.UNIMPLEMENTED, "Uint8Arrays are not available in this environment.");
}

/**
 * Immutable class holding a blob (binary data).
 *
 * This class is directly exposed in the public API. It extends the Bytes class
 * of the firestore-exp API to support `instanceof Bytes` checks during user
 * data conversion.
 *
 * Note that while you can't hide the constructor in JavaScript code, we are
 * using the hack above to make sure no-one outside this module can call it.
 */ class at extends ut {
    static fromBase64String(t) {
        O("Blob.fromBase64String", arguments, 1), q("Blob.fromBase64String", "string", 1, t);
        try {
            return new at(ot.fromBase64String(t));
        } catch (t) {
            throw new E(T.INVALID_ARGUMENT, "Failed to construct Blob from Base64 string: " + t);
        }
    }
    static fromUint8Array(t) {
        if (O("Blob.fromUint8Array", arguments, 1), ct(), !(t instanceof Uint8Array)) throw X("Blob.fromUint8Array", "Uint8Array", 1, t);
        return new at(ot.fromUint8Array(t));
    }
    toBase64() {
        return O("Blob.toBase64", arguments, 0), super.toBase64();
    }
    toUint8Array() {
        return O("Blob.toUint8Array", arguments, 0), ct(), super.toUint8Array();
    }
    toString() {
        return "Blob(base64: " + this.toBase64() + ")";
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ class ht {
    /**
     * Constructs a DatabaseInfo using the provided host, databaseId and
     * persistenceKey.
     *
     * @param databaseId The database to use.
     * @param persistenceKey A unique identifier for this Firestore's local
     * storage (used in conjunction with the databaseId).
     * @param host The Firestore backend host to connect to.
     * @param ssl Whether to use SSL when connecting.
     * @param forceLongPolling Whether to use the forceLongPolling option
     * when using WebChannel as the network transport.
     * @param autoDetectLongPolling Whether to use the detectBufferingProxy
     * option when using WebChannel as the network transport.
     */
    constructor(t, e, n, s, i, r) {
        this.B = t, this.persistenceKey = e, this.host = n, this.ssl = s, this.forceLongPolling = i, 
        this.j = r;
    }
}

/** The default database name for a project. */
/** Represents the database ID a Firestore client is associated with. */
class lt {
    constructor(t, e) {
        this.projectId = t, this.database = e || "(default)";
    }
    get W() {
        return "(default)" === this.database;
    }
    isEqual(t) {
        return t instanceof lt && t.projectId === this.projectId && t.database === this.database;
    }
    M(t) {
        return it(this.projectId, t.projectId) || it(this.database, t.database);
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A map implementation that uses objects as keys. Objects must have an
 * associated equals function and must be immutable. Entries in the map are
 * stored together with the key being produced from the mapKeyFn. This map
 * automatically handles collisions of keys.
 */ class _t {
    constructor(t, e) {
        this.G = t, this.K = e, 
        /**
         * The inner map for a key -> value pair. Due to the possibility of
         * collisions we keep a list of entries that we do a linear search through
         * to find an actual match. Note that collisions should be rare, so we still
         * expect near constant time lookups in practice.
         */
        this.H = {};
    }
    /** Get a value for this key, or undefined if it does not exist. */    get(t) {
        const e = this.G(t), n = this.H[e];
        if (void 0 !== n) for (const [e, s] of n) if (this.K(e, t)) return s;
    }
    has(t) {
        return void 0 !== this.get(t);
    }
    /** Put this key and value in the map. */    set(t, e) {
        const n = this.G(t), s = this.H[n];
        if (void 0 !== s) {
            for (let n = 0; n < s.length; n++) if (this.K(s[n][0], t)) return void (s[n] = [ t, e ]);
            s.push([ t, e ]);
        } else this.H[n] = [ [ t, e ] ];
    }
    /**
     * Remove this key from the map. Returns a boolean if anything was deleted.
     */    delete(t) {
        const e = this.G(t), n = this.H[e];
        if (void 0 === n) return !1;
        for (let s = 0; s < n.length; s++) if (this.K(n[s][0], t)) return 1 === n.length ? delete this.H[e] : n.splice(s, 1), 
        !0;
        return !1;
    }
    forEach(t) {
        S(this.H, ((e, n) => {
            for (const [e, s] of n) t(e, s);
        }));
    }
    m() {
        return D(this.H);
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// The earlist date supported by Firestore timestamps (0001-01-01T00:00:00Z).
/**
 * A `Timestamp` represents a point in time independent of any time zone or
 * calendar, represented as seconds and fractions of seconds at nanosecond
 * resolution in UTC Epoch time.
 *
 * It is encoded using the Proleptic Gregorian Calendar which extends the
 * Gregorian calendar backwards to year one. It is encoded assuming all minutes
 * are 60 seconds long, i.e. leap seconds are "smeared" so that no leap second
 * table is needed for interpretation. Range is from 0001-01-01T00:00:00Z to
 * 9999-12-31T23:59:59.999999999Z.
 *
 * @see https://github.com/google/protobuf/blob/master/src/google/protobuf/timestamp.proto
 */
class ft {
    /**
     * Creates a new timestamp.
     *
     * @param seconds The number of seconds of UTC time since Unix epoch
     *     1970-01-01T00:00:00Z. Must be from 0001-01-01T00:00:00Z to
     *     9999-12-31T23:59:59Z inclusive.
     * @param nanoseconds The non-negative fractions of a second at nanosecond
     *     resolution. Negative second values with fractions must still have
     *     non-negative nanoseconds values that count forward in time. Must be
     *     from 0 to 999,999,999 inclusive.
     */
    constructor(t, e) {
        if (this.seconds = t, this.nanoseconds = e, e < 0) throw new E(T.INVALID_ARGUMENT, "Timestamp nanoseconds out of range: " + e);
        if (e >= 1e9) throw new E(T.INVALID_ARGUMENT, "Timestamp nanoseconds out of range: " + e);
        if (t < -62135596800) throw new E(T.INVALID_ARGUMENT, "Timestamp seconds out of range: " + t);
        // This will break in the year 10,000.
                if (t >= 253402300800) throw new E(T.INVALID_ARGUMENT, "Timestamp seconds out of range: " + t);
    }
    /**
     * Creates a new timestamp with the current date, with millisecond precision.
     *
     * @return a new timestamp representing the current date.
     */    static now() {
        return ft.fromMillis(Date.now());
    }
    /**
     * Creates a new timestamp from the given date.
     *
     * @param date The date to initialize the `Timestamp` from.
     * @return A new `Timestamp` representing the same point in time as the given
     *     date.
     */    static fromDate(t) {
        return ft.fromMillis(t.getTime());
    }
    /**
     * Creates a new timestamp from the given number of milliseconds.
     *
     * @param milliseconds Number of milliseconds since Unix epoch
     *     1970-01-01T00:00:00Z.
     * @return A new `Timestamp` representing the same point in time as the given
     *     number of milliseconds.
     */    static fromMillis(t) {
        const e = Math.floor(t / 1e3);
        return new ft(e, 1e6 * (t - 1e3 * e));
    }
    /**
     * Converts a `Timestamp` to a JavaScript `Date` object. This conversion causes
     * a loss of precision since `Date` objects only support millisecond precision.
     *
     * @return JavaScript `Date` object representing the same point in time as
     *     this `Timestamp`, with millisecond precision.
     */    toDate() {
        return new Date(this.toMillis());
    }
    /**
     * Converts a `Timestamp` to a numeric timestamp (in milliseconds since
     * epoch). This operation causes a loss of precision.
     *
     * @return The point in time corresponding to this timestamp, represented as
     *     the number of milliseconds since Unix epoch 1970-01-01T00:00:00Z.
     */    toMillis() {
        return 1e3 * this.seconds + this.nanoseconds / 1e6;
    }
    Y(t) {
        return this.seconds === t.seconds ? it(this.nanoseconds, t.nanoseconds) : it(this.seconds, t.seconds);
    }
    /**
     * Returns true if this `Timestamp` is equal to the provided one.
     *
     * @param other The `Timestamp` to compare against.
     * @return true if this `Timestamp` is equal to the provided one.
     */    isEqual(t) {
        return t.seconds === this.seconds && t.nanoseconds === this.nanoseconds;
    }
    toString() {
        return "Timestamp(seconds=" + this.seconds + ", nanoseconds=" + this.nanoseconds + ")";
    }
    toJSON() {
        return {
            seconds: this.seconds,
            nanoseconds: this.nanoseconds
        };
    }
    /**
     * Converts this object to a primitive string, which allows Timestamp objects to be compared
     * using the `>`, `<=`, `>=` and `>` operators.
     */    valueOf() {
        // This method returns a string of the form <seconds>.<nanoseconds> where <seconds> is
        // translated to have a non-negative value and both <seconds> and <nanoseconds> are left-padded
        // with zeroes to be a consistent length. Strings with this format then have a lexiographical
        // ordering that matches the expected ordering. The <seconds> translation is done to avoid
        // having a leading negative sign (i.e. a leading '-' character) in its string representation,
        // which would affect its lexiographical ordering.
        const t = this.seconds - -62135596800;
        // Note: Up to 12 decimal digits are required to represent all valid 'seconds' values.
                return String(t).padStart(12, "0") + "." + String(this.nanoseconds).padStart(9, "0");
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A version of a document in Firestore. This corresponds to the version
 * timestamp, such as update_time or read_time.
 */ class dt {
    constructor(t) {
        this.timestamp = t;
    }
    static J(t) {
        return new dt(t);
    }
    static min() {
        return new dt(new ft(0, 0));
    }
    M(t) {
        return this.timestamp.Y(t.timestamp);
    }
    isEqual(t) {
        return this.timestamp.isEqual(t.timestamp);
    }
    /** Returns a number representation of the version for use in spec tests. */    X() {
        // Convert to microseconds.
        return 1e6 * this.timestamp.seconds + this.timestamp.nanoseconds / 1e3;
    }
    toString() {
        return "SnapshotVersion(" + this.timestamp.toString() + ")";
    }
    Z() {
        return this.timestamp;
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Returns whether a variable is either undefined or null.
 */ function wt(t) {
    return null == t;
}

/** Returns whether the value represents -0. */ function mt(t) {
    // Detect if the value is -0.0. Based on polyfill from
    // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/is
    return 0 === t && 1 / t == -1 / 0;
}

/**
 * Returns whether a value is an integer and in the safe integer range
 * @param value The value to test for being an integer and in the safe range
 */
/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Visible for testing
class Tt {
    constructor(t, e = null, n = [], s = [], i = null, r = null, o = null) {
        this.path = t, this.collectionGroup = e, this.orderBy = n, this.filters = s, this.limit = i, 
        this.startAt = r, this.endAt = o, this.tt = null;
    }
}

/**
 * Initializes a Target with a path and optional additional query constraints.
 * Path must currently be empty if this is a collection group query.
 *
 * NOTE: you should always construct `Target` from `Query.toTarget` instead of
 * using this factory method, because `Query` provides an implicit `orderBy`
 * property.
 */ function Et(t, e = null, n = [], s = [], i = null, r = null, o = null) {
    return new Tt(t, e, n, s, i, r, o);
}

function It(t) {
    const e = v(t);
    if (null === e.tt) {
        let t = e.path.R();
        null !== e.collectionGroup && (t += "|cg:" + e.collectionGroup), t += "|f:", t += e.filters.map((t => es(t))).join(","), 
        t += "|ob:", t += e.orderBy.map((t => {
            return (e = t).field.R() + e.dir;
            var e;
        })).join(","), wt(e.limit) || (t += "|l:", t += e.limit), e.startAt && (t += "|lb:", 
        t += ls(e.startAt)), e.endAt && (t += "|ub:", t += ls(e.endAt)), e.tt = t;
    }
    return e.tt;
}

function At(t) {
    let e = t.path.R();
    return null !== t.collectionGroup && (e += " collectionGroup=" + t.collectionGroup), 
    t.filters.length > 0 && (e += `, filters: [${t.filters.map((t => {
        return `${(e = t).field.R()} ${e.op} ${le(e.value)}`;
        /** Returns a debug description for `filter`. */
        var e;
        /** Filter that matches on key fields (i.e. '__name__'). */    })).join(", ")}]`), 
    wt(t.limit) || (e += ", limit: " + t.limit), t.orderBy.length > 0 && (e += `, orderBy: [${t.orderBy.map((t => {
        return `${(e = t).field.R()} (${e.dir})`;
        var e;
    })).join(", ")}]`), t.startAt && (e += ", startAt: " + ls(t.startAt)), t.endAt && (e += ", endAt: " + ls(t.endAt)), 
    `Target(${e})`;
}

function Rt(t, e) {
    if (t.limit !== e.limit) return !1;
    if (t.orderBy.length !== e.orderBy.length) return !1;
    for (let n = 0; n < t.orderBy.length; n++) if (!ms(t.orderBy[n], e.orderBy[n])) return !1;
    if (t.filters.length !== e.filters.length) return !1;
    for (let i = 0; i < t.filters.length; i++) if (n = t.filters[i], s = e.filters[i], 
    n.op !== s.op || !n.field.isEqual(s.field) || !ue(n.value, s.value)) return !1;
    var n, s;
    return t.collectionGroup === e.collectionGroup && (!!t.path.isEqual(e.path) && (!!fs(t.startAt, e.startAt) && fs(t.endAt, e.endAt)));
}

function yt(t) {
    return x.N(t.path) && null === t.collectionGroup && 0 === t.filters.length;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * An immutable set of metadata that the local store tracks for each target.
 */ class Pt {
    constructor(
    /** The target being listened to. */
    t, 
    /**
     * The target ID to which the target corresponds; Assigned by the
     * LocalStore for user listens and by the SyncEngine for limbo watches.
     */
    e, 
    /** The purpose of the target. */
    n, 
    /**
     * The sequence number of the last transaction during which this target data
     * was modified.
     */
    s, 
    /** The latest snapshot version seen for this target. */
    i = dt.min()
    /**
     * The maximum snapshot version at which the associated view
     * contained no limbo documents.
     */ , r = dt.min()
    /**
     * An opaque, server-assigned token that allows watching a target to be
     * resumed after disconnecting without retransmitting all the data that
     * matches the target. The resume token essentially identifies a point in
     * time from which the server should resume sending results.
     */ , o = ot.q) {
        this.target = t, this.targetId = e, this.et = n, this.sequenceNumber = s, this.nt = i, 
        this.lastLimboFreeSnapshotVersion = r, this.resumeToken = o;
    }
    /** Creates a new target data instance with an updated sequence number. */    st(t) {
        return new Pt(this.target, this.targetId, this.et, t, this.nt, this.lastLimboFreeSnapshotVersion, this.resumeToken);
    }
    /**
     * Creates a new target data instance with an updated resume token and
     * snapshot version.
     */    it(t, e) {
        return new Pt(this.target, this.targetId, this.et, this.sequenceNumber, e, this.lastLimboFreeSnapshotVersion, t);
    }
    /**
     * Creates a new target data instance with an updated last limbo free
     * snapshot version number.
     */    rt(t) {
        return new Pt(this.target, this.targetId, this.et, this.sequenceNumber, this.nt, t, this.resumeToken);
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ class gt {
    // TODO(b/33078163): just use simplest form of existence filter for now
    constructor(t) {
        this.count = t;
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Error Codes describing the different ways GRPC can fail. These are copied
 * directly from GRPC's sources here:
 *
 * https://github.com/grpc/grpc/blob/bceec94ea4fc5f0085d81235d8e1c06798dc341a/include/grpc%2B%2B/impl/codegen/status_code_enum.h
 *
 * Important! The names of these identifiers matter because the string forms
 * are used for reverse lookups from the webchannel stream. Do NOT change the
 * names of these identifiers or change this into a const enum.
 */ var pt, Vt;

/**
 * Determines whether an error code represents a permanent error when received
 * in response to a non-write operation.
 *
 * See isPermanentWriteError for classifying write errors.
 */
function vt(t) {
    switch (t) {
      case T.OK:
        return p();

      case T.CANCELLED:
      case T.UNKNOWN:
      case T.DEADLINE_EXCEEDED:
      case T.RESOURCE_EXHAUSTED:
      case T.INTERNAL:
      case T.UNAVAILABLE:
 // Unauthenticated means something went wrong with our token and we need
        // to retry with new credentials which will happen automatically.
              case T.UNAUTHENTICATED:
        return !1;

      case T.INVALID_ARGUMENT:
      case T.NOT_FOUND:
      case T.ALREADY_EXISTS:
      case T.PERMISSION_DENIED:
      case T.FAILED_PRECONDITION:
 // Aborted might be retried in some scenarios, but that is dependant on
        // the context and should handled individually by the calling code.
        // See https://cloud.google.com/apis/design/errors.
              case T.ABORTED:
      case T.OUT_OF_RANGE:
      case T.UNIMPLEMENTED:
      case T.DATA_LOSS:
        return !0;

      default:
        return p();
    }
}

/**
 * Determines whether an error code represents a permanent error when received
 * in response to a write operation.
 *
 * Write operations must be handled specially because as of b/119437764, ABORTED
 * errors on the write stream should be retried too (even though ABORTED errors
 * are not generally retryable).
 *
 * Note that during the initial handshake on the write stream an ABORTED error
 * signals that we should discard our stream token (i.e. it is permanent). This
 * means a handshake error should be classified with isPermanentError, above.
 */
/**
 * Maps an error Code from GRPC status code number, like 0, 1, or 14. These
 * are not the same as HTTP status codes.
 *
 * @returns The Code equivalent to the given GRPC status code. Fails if there
 *     is no match.
 */
function bt(t) {
    if (void 0 === t) 
    // This shouldn't normally happen, but in certain error cases (like trying
    // to send invalid proto messages) we may get an error with no GRPC code.
    return y("GRPC error has no .code"), T.UNKNOWN;
    switch (t) {
      case pt.OK:
        return T.OK;

      case pt.CANCELLED:
        return T.CANCELLED;

      case pt.UNKNOWN:
        return T.UNKNOWN;

      case pt.DEADLINE_EXCEEDED:
        return T.DEADLINE_EXCEEDED;

      case pt.RESOURCE_EXHAUSTED:
        return T.RESOURCE_EXHAUSTED;

      case pt.INTERNAL:
        return T.INTERNAL;

      case pt.UNAVAILABLE:
        return T.UNAVAILABLE;

      case pt.UNAUTHENTICATED:
        return T.UNAUTHENTICATED;

      case pt.INVALID_ARGUMENT:
        return T.INVALID_ARGUMENT;

      case pt.NOT_FOUND:
        return T.NOT_FOUND;

      case pt.ALREADY_EXISTS:
        return T.ALREADY_EXISTS;

      case pt.PERMISSION_DENIED:
        return T.PERMISSION_DENIED;

      case pt.FAILED_PRECONDITION:
        return T.FAILED_PRECONDITION;

      case pt.ABORTED:
        return T.ABORTED;

      case pt.OUT_OF_RANGE:
        return T.OUT_OF_RANGE;

      case pt.UNIMPLEMENTED:
        return T.UNIMPLEMENTED;

      case pt.DATA_LOSS:
        return T.DATA_LOSS;

      default:
        return p();
    }
}

/**
 * Converts an HTTP response's error status to the equivalent error code.
 *
 * @param status An HTTP error response status ("FAILED_PRECONDITION",
 * "UNKNOWN", etc.)
 * @returns The equivalent Code. Non-matching responses are mapped to
 *     Code.UNKNOWN.
 */ (Vt = pt || (pt = {}))[Vt.OK = 0] = "OK", Vt[Vt.CANCELLED = 1] = "CANCELLED", 
Vt[Vt.UNKNOWN = 2] = "UNKNOWN", Vt[Vt.INVALID_ARGUMENT = 3] = "INVALID_ARGUMENT", 
Vt[Vt.DEADLINE_EXCEEDED = 4] = "DEADLINE_EXCEEDED", Vt[Vt.NOT_FOUND = 5] = "NOT_FOUND", 
Vt[Vt.ALREADY_EXISTS = 6] = "ALREADY_EXISTS", Vt[Vt.PERMISSION_DENIED = 7] = "PERMISSION_DENIED", 
Vt[Vt.UNAUTHENTICATED = 16] = "UNAUTHENTICATED", Vt[Vt.RESOURCE_EXHAUSTED = 8] = "RESOURCE_EXHAUSTED", 
Vt[Vt.FAILED_PRECONDITION = 9] = "FAILED_PRECONDITION", Vt[Vt.ABORTED = 10] = "ABORTED", 
Vt[Vt.OUT_OF_RANGE = 11] = "OUT_OF_RANGE", Vt[Vt.UNIMPLEMENTED = 12] = "UNIMPLEMENTED", 
Vt[Vt.INTERNAL = 13] = "INTERNAL", Vt[Vt.UNAVAILABLE = 14] = "UNAVAILABLE", Vt[Vt.DATA_LOSS = 15] = "DATA_LOSS";

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// An immutable sorted map implementation, based on a Left-leaning Red-Black
// tree.
class St {
    constructor(t, e) {
        this.i = t, this.root = e || Ct.EMPTY;
    }
    // Returns a copy of the map, with the specified key/value added or replaced.
    ot(t, e) {
        return new St(this.i, this.root.ot(t, e, this.i).copy(null, null, Ct.ut, null, null));
    }
    // Returns a copy of the map, with the specified key removed.
    remove(t) {
        return new St(this.i, this.root.remove(t, this.i).copy(null, null, Ct.ut, null, null));
    }
    // Returns the value of the node with the given key, or null.
    get(t) {
        let e = this.root;
        for (;!e.m(); ) {
            const n = this.i(t, e.key);
            if (0 === n) return e.value;
            n < 0 ? e = e.left : n > 0 && (e = e.right);
        }
        return null;
    }
    // Returns the index of the element in this sorted map, or -1 if it doesn't
    // exist.
    indexOf(t) {
        // Number of nodes that were pruned when descending right
        let e = 0, n = this.root;
        for (;!n.m(); ) {
            const s = this.i(t, n.key);
            if (0 === s) return e + n.left.size;
            s < 0 ? n = n.left : (
            // Count all nodes left of the node plus the node itself
            e += n.left.size + 1, n = n.right);
        }
        // Node not found
                return -1;
    }
    m() {
        return this.root.m();
    }
    // Returns the total number of nodes in the map.
    get size() {
        return this.root.size;
    }
    // Returns the minimum key in the map.
    ct() {
        return this.root.ct();
    }
    // Returns the maximum key in the map.
    at() {
        return this.root.at();
    }
    // Traverses the map in key order and calls the specified action function
    // for each key/value pair. If action returns true, traversal is aborted.
    // Returns the first truthy value returned by action, or the last falsey
    // value returned by action.
    ht(t) {
        return this.root.ht(t);
    }
    forEach(t) {
        this.ht(((e, n) => (t(e, n), !1)));
    }
    toString() {
        const t = [];
        return this.ht(((e, n) => (t.push(`${e}:${n}`), !1))), `{${t.join(", ")}}`;
    }
    // Traverses the map in reverse key order and calls the specified action
    // function for each key/value pair. If action returns true, traversal is
    // aborted.
    // Returns the first truthy value returned by action, or the last falsey
    // value returned by action.
    lt(t) {
        return this.root.lt(t);
    }
    // Returns an iterator over the SortedMap.
    _t() {
        return new Dt(this.root, null, this.i, !1);
    }
    ft(t) {
        return new Dt(this.root, t, this.i, !1);
    }
    dt() {
        return new Dt(this.root, null, this.i, !0);
    }
    wt(t) {
        return new Dt(this.root, t, this.i, !0);
    }
}

 // end SortedMap
// An iterator over an LLRBNode.
class Dt {
    constructor(t, e, n, s) {
        this.Tt = s, this.Et = [];
        let i = 1;
        for (;!t.m(); ) if (i = e ? n(t.key, e) : 1, 
        // flip the comparison if we're going in reverse
        s && (i *= -1), i < 0) 
        // This node is less than our start key. ignore it
        t = this.Tt ? t.left : t.right; else {
            if (0 === i) {
                // This node is exactly equal to our start key. Push it on the stack,
                // but stop iterating;
                this.Et.push(t);
                break;
            }
            // This node is greater than our start key, add it to the stack and move
            // to the next one
            this.Et.push(t), t = this.Tt ? t.right : t.left;
        }
    }
    It() {
        let t = this.Et.pop();
        const e = {
            key: t.key,
            value: t.value
        };
        if (this.Tt) for (t = t.left; !t.m(); ) this.Et.push(t), t = t.right; else for (t = t.right; !t.m(); ) this.Et.push(t), 
        t = t.left;
        return e;
    }
    At() {
        return this.Et.length > 0;
    }
    Rt() {
        if (0 === this.Et.length) return null;
        const t = this.Et[this.Et.length - 1];
        return {
            key: t.key,
            value: t.value
        };
    }
}

 // end SortedMapIterator
// Represents a node in a Left-leaning Red-Black tree.
class Ct {
    constructor(t, e, n, s, i) {
        this.key = t, this.value = e, this.color = null != n ? n : Ct.RED, this.left = null != s ? s : Ct.EMPTY, 
        this.right = null != i ? i : Ct.EMPTY, this.size = this.left.size + 1 + this.right.size;
    }
    // Returns a copy of the current node, optionally replacing pieces of it.
    copy(t, e, n, s, i) {
        return new Ct(null != t ? t : this.key, null != e ? e : this.value, null != n ? n : this.color, null != s ? s : this.left, null != i ? i : this.right);
    }
    m() {
        return !1;
    }
    // Traverses the tree in key order and calls the specified action function
    // for each node. If action returns true, traversal is aborted.
    // Returns the first truthy value returned by action, or the last falsey
    // value returned by action.
    ht(t) {
        return this.left.ht(t) || t(this.key, this.value) || this.right.ht(t);
    }
    // Traverses the tree in reverse key order and calls the specified action
    // function for each node. If action returns true, traversal is aborted.
    // Returns the first truthy value returned by action, or the last falsey
    // value returned by action.
    lt(t) {
        return this.right.lt(t) || t(this.key, this.value) || this.left.lt(t);
    }
    // Returns the minimum node in the tree.
    min() {
        return this.left.m() ? this : this.left.min();
    }
    // Returns the maximum key in the tree.
    ct() {
        return this.min().key;
    }
    // Returns the maximum key in the tree.
    at() {
        return this.right.m() ? this.key : this.right.at();
    }
    // Returns new tree, with the key/value added.
    ot(t, e, n) {
        let s = this;
        const i = n(t, s.key);
        return s = i < 0 ? s.copy(null, null, null, s.left.ot(t, e, n), null) : 0 === i ? s.copy(null, e, null, null, null) : s.copy(null, null, null, null, s.right.ot(t, e, n)), 
        s.yt();
    }
    Pt() {
        if (this.left.m()) return Ct.EMPTY;
        let t = this;
        return t.left.gt() || t.left.left.gt() || (t = t.Vt()), t = t.copy(null, null, null, t.left.Pt(), null), 
        t.yt();
    }
    // Returns new tree, with the specified item removed.
    remove(t, e) {
        let n, s = this;
        if (e(t, s.key) < 0) s.left.m() || s.left.gt() || s.left.left.gt() || (s = s.Vt()), 
        s = s.copy(null, null, null, s.left.remove(t, e), null); else {
            if (s.left.gt() && (s = s.vt()), s.right.m() || s.right.gt() || s.right.left.gt() || (s = s.bt()), 
            0 === e(t, s.key)) {
                if (s.right.m()) return Ct.EMPTY;
                n = s.right.min(), s = s.copy(n.key, n.value, null, null, s.right.Pt());
            }
            s = s.copy(null, null, null, null, s.right.remove(t, e));
        }
        return s.yt();
    }
    gt() {
        return this.color;
    }
    // Returns new tree after performing any needed rotations.
    yt() {
        let t = this;
        return t.right.gt() && !t.left.gt() && (t = t.St()), t.left.gt() && t.left.left.gt() && (t = t.vt()), 
        t.left.gt() && t.right.gt() && (t = t.Dt()), t;
    }
    Vt() {
        let t = this.Dt();
        return t.right.left.gt() && (t = t.copy(null, null, null, null, t.right.vt()), t = t.St(), 
        t = t.Dt()), t;
    }
    bt() {
        let t = this.Dt();
        return t.left.left.gt() && (t = t.vt(), t = t.Dt()), t;
    }
    St() {
        const t = this.copy(null, null, Ct.RED, null, this.right.left);
        return this.right.copy(null, null, this.color, t, null);
    }
    vt() {
        const t = this.copy(null, null, Ct.RED, this.left.right, null);
        return this.left.copy(null, null, this.color, null, t);
    }
    Dt() {
        const t = this.left.copy(null, null, !this.left.color, null, null), e = this.right.copy(null, null, !this.right.color, null, null);
        return this.copy(null, null, !this.color, t, e);
    }
    // For testing.
    Ct() {
        const t = this.Ft();
        return Math.pow(2, t) <= this.size + 1;
    }
    // In a balanced RB tree, the black-depth (number of black nodes) from root to
    // leaves is equal on both sides.  This function verifies that or asserts.
    Ft() {
        if (this.gt() && this.left.gt()) throw p();
        if (this.right.gt()) throw p();
        const t = this.left.Ft();
        if (t !== this.right.Ft()) throw p();
        return t + (this.gt() ? 0 : 1);
    }
}

 // end LLRBNode
// Empty node is shared between all LLRB trees.
// eslint-disable-next-line @typescript-eslint/no-explicit-any
Ct.EMPTY = null, Ct.RED = !0, Ct.ut = !1;

// end LLRBEmptyNode
Ct.EMPTY = new 
// Represents an empty node (a leaf node in the Red-Black Tree).
class {
    constructor() {
        this.size = 0;
    }
    get key() {
        throw p();
    }
    get value() {
        throw p();
    }
    get color() {
        throw p();
    }
    get left() {
        throw p();
    }
    get right() {
        throw p();
    }
    // Returns a copy of the current node.
    copy(t, e, n, s, i) {
        return this;
    }
    // Returns a copy of the tree, with the specified key/value added.
    ot(t, e, n) {
        return new Ct(t, e);
    }
    // Returns a copy of the tree, with the specified key removed.
    remove(t, e) {
        return this;
    }
    m() {
        return !0;
    }
    ht(t) {
        return !1;
    }
    lt(t) {
        return !1;
    }
    ct() {
        return null;
    }
    at() {
        return null;
    }
    gt() {
        return !1;
    }
    // For testing.
    Ct() {
        return !0;
    }
    Ft() {
        return 0;
    }
};

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * SortedSet is an immutable (copy-on-write) collection that holds elements
 * in order specified by the provided comparator.
 *
 * NOTE: if provided comparator returns 0 for two elements, we consider them to
 * be equal!
 */
class Ft {
    constructor(t) {
        this.i = t, this.data = new St(this.i);
    }
    has(t) {
        return null !== this.data.get(t);
    }
    first() {
        return this.data.ct();
    }
    last() {
        return this.data.at();
    }
    get size() {
        return this.data.size;
    }
    indexOf(t) {
        return this.data.indexOf(t);
    }
    /** Iterates elements in order defined by "comparator" */    forEach(t) {
        this.data.ht(((e, n) => (t(e), !1)));
    }
    /** Iterates over `elem`s such that: range[0] <= elem < range[1]. */    Nt(t, e) {
        const n = this.data.ft(t[0]);
        for (;n.At(); ) {
            const s = n.It();
            if (this.i(s.key, t[1]) >= 0) return;
            e(s.key);
        }
    }
    /**
     * Iterates over `elem`s such that: start <= elem until false is returned.
     */    $t(t, e) {
        let n;
        for (n = void 0 !== e ? this.data.ft(e) : this.data._t(); n.At(); ) {
            if (!t(n.It().key)) return;
        }
    }
    /** Finds the least element greater than or equal to `elem`. */    xt(t) {
        const e = this.data.ft(t);
        return e.At() ? e.It().key : null;
    }
    _t() {
        return new Nt(this.data._t());
    }
    ft(t) {
        return new Nt(this.data.ft(t));
    }
    /** Inserts or updates an element */    add(t) {
        return this.copy(this.data.remove(t).ot(t, !0));
    }
    /** Deletes an element */    delete(t) {
        return this.has(t) ? this.copy(this.data.remove(t)) : this;
    }
    m() {
        return this.data.m();
    }
    kt(t) {
        let e = this;
        // Make sure `result` always refers to the larger one of the two sets.
                return e.size < t.size && (e = t, t = this), t.forEach((t => {
            e = e.add(t);
        })), e;
    }
    isEqual(t) {
        if (!(t instanceof Ft)) return !1;
        if (this.size !== t.size) return !1;
        const e = this.data._t(), n = t.data._t();
        for (;e.At(); ) {
            const t = e.It().key, s = n.It().key;
            if (0 !== this.i(t, s)) return !1;
        }
        return !0;
    }
    A() {
        const t = [];
        return this.forEach((e => {
            t.push(e);
        })), t;
    }
    toString() {
        const t = [];
        return this.forEach((e => t.push(e))), "SortedSet(" + t.toString() + ")";
    }
    copy(t) {
        const e = new Ft(this.i);
        return e.data = t, e;
    }
}

class Nt {
    constructor(t) {
        this.Ot = t;
    }
    It() {
        return this.Ot.It().key;
    }
    At() {
        return this.Ot.At();
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ const $t = new St(x.i);

function xt() {
    return $t;
}

function kt() {
    return xt();
}

const Ot = new St(x.i);

function Lt() {
    return Ot;
}

const Mt = new St(x.i);

const qt = new Ft(x.i);

function Ut(...t) {
    let e = qt;
    for (const n of t) e = e.add(n);
    return e;
}

const Bt = new Ft(it);

function Qt() {
    return Bt;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * DocumentSet is an immutable (copy-on-write) collection that holds documents
 * in order specified by the provided comparator. We always add a document key
 * comparator on top of what is provided to guarantee document equality based on
 * the key.
 */ class jt {
    /** The default ordering is by key if the comparator is omitted */
    constructor(t) {
        // We are adding document key comparator to the end as it's the only
        // guaranteed unique property of a document.
        this.i = t ? (e, n) => t(e, n) || x.i(e.key, n.key) : (t, e) => x.i(t.key, e.key), 
        this.Lt = Lt(), this.Mt = new St(this.i);
    }
    /**
     * Returns an empty copy of the existing DocumentSet, using the same
     * comparator.
     */    static qt(t) {
        return new jt(t.i);
    }
    has(t) {
        return null != this.Lt.get(t);
    }
    get(t) {
        return this.Lt.get(t);
    }
    first() {
        return this.Mt.ct();
    }
    last() {
        return this.Mt.at();
    }
    m() {
        return this.Mt.m();
    }
    /**
     * Returns the index of the provided key in the document set, or -1 if the
     * document key is not present in the set;
     */    indexOf(t) {
        const e = this.Lt.get(t);
        return e ? this.Mt.indexOf(e) : -1;
    }
    get size() {
        return this.Mt.size;
    }
    /** Iterates documents in order defined by "comparator" */    forEach(t) {
        this.Mt.ht(((e, n) => (t(e), !1)));
    }
    /** Inserts or updates a document with the same key */    add(t) {
        // First remove the element if we have it.
        const e = this.delete(t.key);
        return e.copy(e.Lt.ot(t.key, t), e.Mt.ot(t, null));
    }
    /** Deletes a document with a given key */    delete(t) {
        const e = this.get(t);
        return e ? this.copy(this.Lt.remove(t), this.Mt.remove(e)) : this;
    }
    isEqual(t) {
        if (!(t instanceof jt)) return !1;
        if (this.size !== t.size) return !1;
        const e = this.Mt._t(), n = t.Mt._t();
        for (;e.At(); ) {
            const t = e.It().key, s = n.It().key;
            if (!t.isEqual(s)) return !1;
        }
        return !0;
    }
    toString() {
        const t = [];
        return this.forEach((e => {
            t.push(e.toString());
        })), 0 === t.length ? "DocumentSet ()" : "DocumentSet (\n  " + t.join("  \n") + "\n)";
    }
    copy(t, e) {
        const n = new jt;
        return n.i = this.i, n.Lt = t, n.Mt = e, n;
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * DocumentChangeSet keeps track of a set of changes to docs in a query, merging
 * duplicate events for the same doc.
 */ class Wt {
    constructor() {
        this.Ut = new St(x.i);
    }
    track(t) {
        const e = t.doc.key, n = this.Ut.get(e);
        n ? 
        // Merge the new change with the existing change.
        0 /* Added */ !== t.type && 3 /* Metadata */ === n.type ? this.Ut = this.Ut.ot(e, t) : 3 /* Metadata */ === t.type && 1 /* Removed */ !== n.type ? this.Ut = this.Ut.ot(e, {
            type: n.type,
            doc: t.doc
        }) : 2 /* Modified */ === t.type && 2 /* Modified */ === n.type ? this.Ut = this.Ut.ot(e, {
            type: 2 /* Modified */ ,
            doc: t.doc
        }) : 2 /* Modified */ === t.type && 0 /* Added */ === n.type ? this.Ut = this.Ut.ot(e, {
            type: 0 /* Added */ ,
            doc: t.doc
        }) : 1 /* Removed */ === t.type && 0 /* Added */ === n.type ? this.Ut = this.Ut.remove(e) : 1 /* Removed */ === t.type && 2 /* Modified */ === n.type ? this.Ut = this.Ut.ot(e, {
            type: 1 /* Removed */ ,
            doc: n.doc
        }) : 0 /* Added */ === t.type && 1 /* Removed */ === n.type ? this.Ut = this.Ut.ot(e, {
            type: 2 /* Modified */ ,
            doc: t.doc
        }) : 
        // This includes these cases, which don't make sense:
        // Added->Added
        // Removed->Removed
        // Modified->Added
        // Removed->Modified
        // Metadata->Added
        // Removed->Metadata
        p() : this.Ut = this.Ut.ot(e, t);
    }
    Bt() {
        const t = [];
        return this.Ut.ht(((e, n) => {
            t.push(n);
        })), t;
    }
}

class Gt {
    constructor(t, e, n, s, i, r, o, u) {
        this.query = t, this.docs = e, this.Qt = n, this.docChanges = s, this.jt = i, this.fromCache = r, 
        this.Wt = o, this.Gt = u;
    }
    /** Returns a view snapshot as if all documents in the snapshot were added. */    static zt(t, e, n, s) {
        const i = [];
        return e.forEach((t => {
            i.push({
                type: 0 /* Added */ ,
                doc: t
            });
        })), new Gt(t, e, jt.qt(e), i, n, s, 
        /* syncStateChanged= */ !0, 
        /* excludesMetadataChanges= */ !1);
    }
    get hasPendingWrites() {
        return !this.jt.m();
    }
    isEqual(t) {
        if (!(this.fromCache === t.fromCache && this.Wt === t.Wt && this.jt.isEqual(t.jt) && Hn(this.query, t.query) && this.docs.isEqual(t.docs) && this.Qt.isEqual(t.Qt))) return !1;
        const e = this.docChanges, n = t.docChanges;
        if (e.length !== n.length) return !1;
        for (let t = 0; t < e.length; t++) if (e[t].type !== n[t].type || !e[t].doc.isEqual(n[t].doc)) return !1;
        return !0;
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * An event from the RemoteStore. It is split into targetChanges (changes to the
 * state or the set of documents in our watched targets) and documentUpdates
 * (changes to the actual documents).
 */ class zt {
    constructor(
    /**
     * The snapshot version this event brings us up to, or MIN if not set.
     */
    t, 
    /**
     * A map from target to changes to the target. See TargetChange.
     */
    e, 
    /**
     * A set of targets that is known to be inconsistent. Listens for these
     * targets should be re-established without resume tokens.
     */
    n, 
    /**
     * A set of which documents have changed or been deleted, along with the
     * doc's new values (if not deleted).
     */
    s, 
    /**
     * A set of which document updates are due only to limbo resolution targets.
     */
    i) {
        this.nt = t, this.Kt = e, this.Ht = n, this.Yt = s, this.Jt = i;
    }
    /**
     * HACK: Views require RemoteEvents in order to determine whether the view is
     * CURRENT, but secondary tabs don't receive remote events. So this method is
     * used to create a synthesized RemoteEvent that can be used to apply a
     * CURRENT status change to a View, for queries executed in a different tab.
     */
    // PORTING NOTE: Multi-tab only
    static Xt(t, e) {
        const n = new Map;
        return n.set(t, Kt.Zt(t, e)), new zt(dt.min(), n, Qt(), xt(), Ut());
    }
}

/**
 * A TargetChange specifies the set of changes for a specific target as part of
 * a RemoteEvent. These changes track which documents are added, modified or
 * removed, as well as the target's resume token and whether the target is
 * marked CURRENT.
 * The actual changes *to* documents are not part of the TargetChange since
 * documents may be part of multiple targets.
 */ class Kt {
    constructor(
    /**
     * An opaque, server-assigned token that allows watching a query to be resumed
     * after disconnecting without retransmitting all the data that matches the
     * query. The resume token essentially identifies a point in time from which
     * the server should resume sending results.
     */
    t, 
    /**
     * The "current" (synced) status of this target. Note that "current"
     * has special meaning in the RPC protocol that implies that a target is
     * both up-to-date and consistent with the rest of the watch stream.
     */
    e, 
    /**
     * The set of documents that were newly assigned to this target as part of
     * this remote event.
     */
    n, 
    /**
     * The set of documents that were already assigned to this target but received
     * an update during this remote event.
     */
    s, 
    /**
     * The set of documents that were removed from this target as part of this
     * remote event.
     */
    i) {
        this.resumeToken = t, this.te = e, this.ee = n, this.ne = s, this.se = i;
    }
    /**
     * This method is used to create a synthesized TargetChanges that can be used to
     * apply a CURRENT status change to a View (for queries executed in a different
     * tab) or for new queries (to raise snapshots with correct CURRENT status).
     */    static Zt(t, e) {
        return new Kt(ot.q, e, Ut(), Ut(), Ut());
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Represents a changed document and a list of target ids to which this change
 * applies.
 *
 * If document has been deleted NoDocument will be provided.
 */ class Ht {
    constructor(
    /** The new document applies to all of these targets. */
    t, 
    /** The new document is removed from all of these targets. */
    e, 
    /** The key of the document for this change. */
    n, 
    /**
     * The new document or NoDocument if it was deleted. Is null if the
     * document went out of view without the server sending a new document.
     */
    s) {
        this.ie = t, this.removedTargetIds = e, this.key = n, this.re = s;
    }
}

class Yt {
    constructor(t, e) {
        this.targetId = t, this.oe = e;
    }
}

class Jt {
    constructor(
    /** What kind of change occurred to the watch target. */
    t, 
    /** The target IDs that were added/removed/set. */
    e, 
    /**
     * An opaque, server-assigned token that allows watching a target to be
     * resumed after disconnecting without retransmitting all the data that
     * matches the target. The resume token essentially identifies a point in
     * time from which the server should resume sending results.
     */
    n = ot.q
    /** An RPC error indicating why the watch failed. */ , s = null) {
        this.state = t, this.targetIds = e, this.resumeToken = n, this.cause = s;
    }
}

/** Tracks the internal state of a Watch target. */ class Xt {
    constructor() {
        /**
         * The number of pending responses (adds or removes) that we are waiting on.
         * We only consider targets active that have no pending responses.
         */
        this.ue = 0, 
        /**
         * Keeps track of the document changes since the last raised snapshot.
         *
         * These changes are continuously updated as we receive document updates and
         * always reflect the current set of changes against the last issued snapshot.
         */
        this.ce = ee(), 
        /** See public getters for explanations of these fields. */
        this.ae = ot.q, this.he = !1, 
        /**
         * Whether this target state should be included in the next snapshot. We
         * initialize to true so that newly-added targets are included in the next
         * RemoteEvent.
         */
        this.le = !0;
    }
    /**
     * Whether this target has been marked 'current'.
     *
     * 'Current' has special meaning in the RPC protocol: It implies that the
     * Watch backend has sent us all changes up to the point at which the target
     * was added and that the target is consistent with the rest of the watch
     * stream.
     */    get te() {
        return this.he;
    }
    /** The last resume token sent to us for this target. */    get resumeToken() {
        return this.ae;
    }
    /** Whether this target has pending target adds or target removes. */    get _e() {
        return 0 !== this.ue;
    }
    /** Whether we have modified any state that should trigger a snapshot. */    get fe() {
        return this.le;
    }
    /**
     * Applies the resume token to the TargetChange, but only when it has a new
     * value. Empty resumeTokens are discarded.
     */    de(t) {
        t.L() > 0 && (this.le = !0, this.ae = t);
    }
    /**
     * Creates a target change from the current set of changes.
     *
     * To reset the document changes after raising this snapshot, call
     * `clearPendingChanges()`.
     */    we() {
        let t = Ut(), e = Ut(), n = Ut();
        return this.ce.forEach(((s, i) => {
            switch (i) {
              case 0 /* Added */ :
                t = t.add(s);
                break;

              case 2 /* Modified */ :
                e = e.add(s);
                break;

              case 1 /* Removed */ :
                n = n.add(s);
                break;

              default:
                p();
            }
        })), new Kt(this.ae, this.he, t, e, n);
    }
    /**
     * Resets the document changes and sets `hasPendingChanges` to false.
     */    me() {
        this.le = !1, this.ce = ee();
    }
    Te(t, e) {
        this.le = !0, this.ce = this.ce.ot(t, e);
    }
    Ee(t) {
        this.le = !0, this.ce = this.ce.remove(t);
    }
    Ie() {
        this.ue += 1;
    }
    Ae() {
        this.ue -= 1;
    }
    Re() {
        this.le = !0, this.he = !0;
    }
}

/**
 * A helper class to accumulate watch changes into a RemoteEvent.
 */
class Zt {
    constructor(t) {
        this.ye = t, 
        /** The internal state of all tracked targets. */
        this.Pe = new Map, 
        /** Keeps track of the documents to update since the last raised snapshot. */
        this.ge = xt(), 
        /** A mapping of document keys to their set of target IDs. */
        this.pe = te(), 
        /**
         * A list of targets with existence filter mismatches. These targets are
         * known to be inconsistent and their listens needs to be re-established by
         * RemoteStore.
         */
        this.Ve = new Ft(it);
    }
    /**
     * Processes and adds the DocumentWatchChange to the current set of changes.
     */    ve(t) {
        for (const e of t.ie) t.re instanceof $n ? this.be(e, t.re) : t.re instanceof xn && this.Se(e, t.key, t.re);
        for (const e of t.removedTargetIds) this.Se(e, t.key, t.re);
    }
    /** Processes and adds the WatchTargetChange to the current set of changes. */    De(t) {
        this.Ce(t, (e => {
            const n = this.Fe(e);
            switch (t.state) {
              case 0 /* NoChange */ :
                this.Ne(e) && n.de(t.resumeToken);
                break;

              case 1 /* Added */ :
                // We need to decrement the number of pending acks needed from watch
                // for this targetId.
                n.Ae(), n._e || 
                // We have a freshly added target, so we need to reset any state
                // that we had previously. This can happen e.g. when remove and add
                // back a target for existence filter mismatches.
                n.me(), n.de(t.resumeToken);
                break;

              case 2 /* Removed */ :
                // We need to keep track of removed targets to we can post-filter and
                // remove any target changes.
                // We need to decrement the number of pending acks needed from watch
                // for this targetId.
                n.Ae(), n._e || this.removeTarget(e);
                break;

              case 3 /* Current */ :
                this.Ne(e) && (n.Re(), n.de(t.resumeToken));
                break;

              case 4 /* Reset */ :
                this.Ne(e) && (
                // Reset the target and synthesizes removes for all existing
                // documents. The backend will re-add any documents that still
                // match the target before it sends the next global snapshot.
                this.$e(e), n.de(t.resumeToken));
                break;

              default:
                p();
            }
        }));
    }
    /**
     * Iterates over all targetIds that the watch change applies to: either the
     * targetIds explicitly listed in the change or the targetIds of all currently
     * active targets.
     */    Ce(t, e) {
        t.targetIds.length > 0 ? t.targetIds.forEach(e) : this.Pe.forEach(((t, n) => {
            this.Ne(n) && e(n);
        }));
    }
    /**
     * Handles existence filters and synthesizes deletes for filter mismatches.
     * Targets that are invalidated by filter mismatches are added to
     * `pendingTargetResets`.
     */    xe(t) {
        const e = t.targetId, n = t.oe.count, s = this.ke(e);
        if (s) {
            const t = s.target;
            if (yt(t)) if (0 === n) {
                // The existence filter told us the document does not exist. We deduce
                // that this document does not exist and apply a deleted document to
                // our updates. Without applying this deleted document there might be
                // another query that will raise this document as part of a snapshot
                // until it is resolved, essentially exposing inconsistency between
                // queries.
                const n = new x(t.path);
                this.Se(e, n, new xn(n, dt.min()));
            } else V(1 === n); else {
                this.Oe(e) !== n && (
                // Existence filter mismatch: We reset the mapping and raise a new
                // snapshot with `isFromCache:true`.
                this.$e(e), this.Ve = this.Ve.add(e));
            }
        }
    }
    /**
     * Converts the currently accumulated state into a remote event at the
     * provided snapshot version. Resets the accumulated changes before returning.
     */    Le(t) {
        const e = new Map;
        this.Pe.forEach(((n, s) => {
            const i = this.ke(s);
            if (i) {
                if (n.te && yt(i.target)) {
                    // Document queries for document that don't exist can produce an empty
                    // result set. To update our local cache, we synthesize a document
                    // delete if we have not previously received the document. This
                    // resolves the limbo state of the document, removing it from
                    // limboDocumentRefs.
                    // TODO(dimond): Ideally we would have an explicit lookup target
                    // instead resulting in an explicit delete message and we could
                    // remove this special logic.
                    const e = new x(i.target.path);
                    null !== this.ge.get(e) || this.Me(s, e) || this.Se(s, e, new xn(e, t));
                }
                n.fe && (e.set(s, n.we()), n.me());
            }
        }));
        let n = Ut();
        // We extract the set of limbo-only document updates as the GC logic
        // special-cases documents that do not appear in the target cache.
        
        // TODO(gsoltis): Expand on this comment once GC is available in the JS
        // client.
                this.pe.forEach(((t, e) => {
            let s = !0;
            e.$t((t => {
                const e = this.ke(t);
                return !e || 2 /* LimboResolution */ === e.et || (s = !1, !1);
            })), s && (n = n.add(t));
        }));
        const s = new zt(t, e, this.Ve, this.ge, n);
        return this.ge = xt(), this.pe = te(), this.Ve = new Ft(it), s;
    }
    /**
     * Adds the provided document to the internal list of document updates and
     * its document key to the given target's mapping.
     */
    // Visible for testing.
    be(t, e) {
        if (!this.Ne(t)) return;
        const n = this.Me(t, e.key) ? 2 /* Modified */ : 0 /* Added */;
        this.Fe(t).Te(e.key, n), this.ge = this.ge.ot(e.key, e), this.pe = this.pe.ot(e.key, this.qe(e.key).add(t));
    }
    /**
     * Removes the provided document from the target mapping. If the
     * document no longer matches the target, but the document's state is still
     * known (e.g. we know that the document was deleted or we received the change
     * that caused the filter mismatch), the new document can be provided
     * to update the remote document cache.
     */
    // Visible for testing.
    Se(t, e, n) {
        if (!this.Ne(t)) return;
        const s = this.Fe(t);
        this.Me(t, e) ? s.Te(e, 1 /* Removed */) : 
        // The document may have entered and left the target before we raised a
        // snapshot, so we can just ignore the change.
        s.Ee(e), this.pe = this.pe.ot(e, this.qe(e).delete(t)), n && (this.ge = this.ge.ot(e, n));
    }
    removeTarget(t) {
        this.Pe.delete(t);
    }
    /**
     * Returns the current count of documents in the target. This includes both
     * the number of documents that the LocalStore considers to be part of the
     * target as well as any accumulated changes.
     */    Oe(t) {
        const e = this.Fe(t).we();
        return this.ye.Ue(t).size + e.ee.size - e.se.size;
    }
    /**
     * Increment the number of acks needed from watch before we can consider the
     * server to be 'in-sync' with the client's active targets.
     */    Ie(t) {
        this.Fe(t).Ie();
    }
    Fe(t) {
        let e = this.Pe.get(t);
        return e || (e = new Xt, this.Pe.set(t, e)), e;
    }
    qe(t) {
        let e = this.pe.get(t);
        return e || (e = new Ft(it), this.pe = this.pe.ot(t, e)), e;
    }
    /**
     * Verifies that the user is still interested in this target (by calling
     * `getTargetDataForTarget()`) and that we are not waiting for pending ADDs
     * from watch.
     */    Ne(t) {
        const e = null !== this.ke(t);
        return e || R("WatchChangeAggregator", "Detected inactive target", t), e;
    }
    /**
     * Returns the TargetData for an active target (i.e. a target that the user
     * is still interested in that has no outstanding target change requests).
     */    ke(t) {
        const e = this.Pe.get(t);
        return e && e._e ? null : this.ye.Be(t);
    }
    /**
     * Resets the state of a Watch target to its initial state (e.g. sets
     * 'current' to false, clears the resume token and removes its target mapping
     * from all documents).
     */    $e(t) {
        this.Pe.set(t, new Xt);
        this.ye.Ue(t).forEach((e => {
            this.Se(t, e, /*updatedDocument=*/ null);
        }));
    }
    /**
     * Returns whether the LocalStore considers the document to be part of the
     * specified target.
     */    Me(t, e) {
        return this.ye.Ue(t).has(e);
    }
}

function te() {
    return new St(x.i);
}

function ee() {
    return new St(x.i);
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Represents a locally-applied ServerTimestamp.
 *
 * Server Timestamps are backed by MapValues that contain an internal field
 * `__type__` with a value of `server_timestamp`. The previous value and local
 * write time are stored in its `__previous_value__` and `__local_write_time__`
 * fields respectively.
 *
 * Notes:
 * - ServerTimestampValue instances are created as the result of applying a
 *   TransformMutation (see TransformMutation.applyTo()). They can only exist in
 *   the local view of a document. Therefore they do not need to be parsed or
 *   serialized.
 * - When evaluated locally (e.g. for snapshot.data()), they by default
 *   evaluate to `null`. This behavior can be configured by passing custom
 *   FieldValueOptions to value().
 * - With respect to other ServerTimestampValues, they sort by their
 *   localWriteTime.
 */ function ne(t) {
    var e, n;
    return "server_timestamp" === (null === (n = ((null === (e = null == t ? void 0 : t.mapValue) || void 0 === e ? void 0 : e.fields) || {}).__type__) || void 0 === n ? void 0 : n.stringValue);
}

/**
 * Creates a new ServerTimestamp proto value (using the internal format).
 */
/**
 * Returns the value of the field before this ServerTimestamp was set.
 *
 * Preserving the previous values allows the user to display the last resoled
 * value until the backend responds with the timestamp.
 */
function se(t) {
    const e = t.mapValue.fields.__previous_value__;
    return ne(e) ? se(e) : e;
}

/**
 * Returns the local time at which this timestamp was first set.
 */ function ie(t) {
    const e = fe(t.mapValue.fields.__local_write_time__.timestampValue);
    return new ft(e.seconds, e.nanos);
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// A RegExp matching ISO 8601 UTC timestamps with optional fraction.
const re = new RegExp(/^\d{4}-\d\d-\d\dT\d\d:\d\d:\d\d(?:\.(\d+))?Z$/);

/** Extracts the backend's type order for the provided value. */ function oe(t) {
    return "nullValue" in t ? 0 /* NullValue */ : "booleanValue" in t ? 1 /* BooleanValue */ : "integerValue" in t || "doubleValue" in t ? 2 /* NumberValue */ : "timestampValue" in t ? 3 /* TimestampValue */ : "stringValue" in t ? 5 /* StringValue */ : "bytesValue" in t ? 6 /* BlobValue */ : "referenceValue" in t ? 7 /* RefValue */ : "geoPointValue" in t ? 8 /* GeoPointValue */ : "arrayValue" in t ? 9 /* ArrayValue */ : "mapValue" in t ? ne(t) ? 4 /* ServerTimestampValue */ : 10 /* ObjectValue */ : p();
}

/** Tests `left` and `right` for equality based on the backend semantics. */ function ue(t, e) {
    const n = oe(t);
    if (n !== oe(e)) return !1;
    switch (n) {
      case 0 /* NullValue */ :
        return !0;

      case 1 /* BooleanValue */ :
        return t.booleanValue === e.booleanValue;

      case 4 /* ServerTimestampValue */ :
        return ie(t).isEqual(ie(e));

      case 3 /* TimestampValue */ :
        return function(t, e) {
            if ("string" == typeof t.timestampValue && "string" == typeof e.timestampValue && t.timestampValue.length === e.timestampValue.length) 
            // Use string equality for ISO 8601 timestamps
            return t.timestampValue === e.timestampValue;
            const n = fe(t.timestampValue), s = fe(e.timestampValue);
            return n.seconds === s.seconds && n.nanos === s.nanos;
        }(t, e);

      case 5 /* StringValue */ :
        return t.stringValue === e.stringValue;

      case 6 /* BlobValue */ :
        return function(t, e) {
            return we(t.bytesValue).isEqual(we(e.bytesValue));
        }(t, e);

      case 7 /* RefValue */ :
        return t.referenceValue === e.referenceValue;

      case 8 /* GeoPointValue */ :
        return function(t, e) {
            return de(t.geoPointValue.latitude) === de(e.geoPointValue.latitude) && de(t.geoPointValue.longitude) === de(e.geoPointValue.longitude);
        }(t, e);

      case 2 /* NumberValue */ :
        return function(t, e) {
            if ("integerValue" in t && "integerValue" in e) return de(t.integerValue) === de(e.integerValue);
            if ("doubleValue" in t && "doubleValue" in e) {
                const n = de(t.doubleValue), s = de(e.doubleValue);
                return n === s ? mt(n) === mt(s) : isNaN(n) && isNaN(s);
            }
            return !1;
        }(t, e);

      case 9 /* ArrayValue */ :
        return rt(t.arrayValue.values || [], e.arrayValue.values || [], ue);

      case 10 /* ObjectValue */ :
        return function(t, e) {
            const n = t.mapValue.fields || {}, s = e.mapValue.fields || {};
            if (b(n) !== b(s)) return !1;
            for (const t in n) if (n.hasOwnProperty(t) && (void 0 === s[t] || !ue(n[t], s[t]))) return !1;
            return !0;
        }
        /** Returns true if the ArrayValue contains the specified element. */ (t, e);

      default:
        return p();
    }
}

function ce(t, e) {
    return void 0 !== (t.values || []).find((t => ue(t, e)));
}

function ae(t, e) {
    const n = oe(t), s = oe(e);
    if (n !== s) return it(n, s);
    switch (n) {
      case 0 /* NullValue */ :
        return 0;

      case 1 /* BooleanValue */ :
        return it(t.booleanValue, e.booleanValue);

      case 2 /* NumberValue */ :
        return function(t, e) {
            const n = de(t.integerValue || t.doubleValue), s = de(e.integerValue || e.doubleValue);
            return n < s ? -1 : n > s ? 1 : n === s ? 0 : 
            // one or both are NaN.
            isNaN(n) ? isNaN(s) ? 0 : -1 : 1;
        }(t, e);

      case 3 /* TimestampValue */ :
        return he(t.timestampValue, e.timestampValue);

      case 4 /* ServerTimestampValue */ :
        return he(ie(t), ie(e));

      case 5 /* StringValue */ :
        return it(t.stringValue, e.stringValue);

      case 6 /* BlobValue */ :
        return function(t, e) {
            const n = we(t), s = we(e);
            return n.M(s);
        }(t.bytesValue, e.bytesValue);

      case 7 /* RefValue */ :
        return function(t, e) {
            const n = t.split("/"), s = e.split("/");
            for (let t = 0; t < n.length && t < s.length; t++) {
                const e = it(n[t], s[t]);
                if (0 !== e) return e;
            }
            return it(n.length, s.length);
        }(t.referenceValue, e.referenceValue);

      case 8 /* GeoPointValue */ :
        return function(t, e) {
            const n = it(de(t.latitude), de(e.latitude));
            if (0 !== n) return n;
            return it(de(t.longitude), de(e.longitude));
        }(t.geoPointValue, e.geoPointValue);

      case 9 /* ArrayValue */ :
        return function(t, e) {
            const n = t.values || [], s = e.values || [];
            for (let t = 0; t < n.length && t < s.length; ++t) {
                const e = ae(n[t], s[t]);
                if (e) return e;
            }
            return it(n.length, s.length);
        }(t.arrayValue, e.arrayValue);

      case 10 /* ObjectValue */ :
        return function(t, e) {
            const n = t.fields || {}, s = Object.keys(n), i = e.fields || {}, r = Object.keys(i);
            // Even though MapValues are likely sorted correctly based on their insertion
            // order (e.g. when received from the backend), local modifications can bring
            // elements out of order. We need to re-sort the elements to ensure that
            // canonical IDs are independent of insertion order.
            s.sort(), r.sort();
            for (let t = 0; t < s.length && t < r.length; ++t) {
                const e = it(s[t], r[t]);
                if (0 !== e) return e;
                const o = ae(n[s[t]], i[r[t]]);
                if (0 !== o) return o;
            }
            return it(s.length, r.length);
        }
        /**
 * Generates the canonical ID for the provided field value (as used in Target
 * serialization).
 */ (t.mapValue, e.mapValue);

      default:
        throw p();
    }
}

function he(t, e) {
    if ("string" == typeof t && "string" == typeof e && t.length === e.length) return it(t, e);
    const n = fe(t), s = fe(e), i = it(n.seconds, s.seconds);
    return 0 !== i ? i : it(n.nanos, s.nanos);
}

function le(t) {
    return _e(t);
}

function _e(t) {
    return "nullValue" in t ? "null" : "booleanValue" in t ? "" + t.booleanValue : "integerValue" in t ? "" + t.integerValue : "doubleValue" in t ? "" + t.doubleValue : "timestampValue" in t ? function(t) {
        const e = fe(t);
        return `time(${e.seconds},${e.nanos})`;
    }(t.timestampValue) : "stringValue" in t ? t.stringValue : "bytesValue" in t ? we(t.bytesValue).toBase64() : "referenceValue" in t ? (n = t.referenceValue, 
    x.C(n).toString()) : "geoPointValue" in t ? `geo(${(e = t.geoPointValue).latitude},${e.longitude})` : "arrayValue" in t ? function(t) {
        let e = "[", n = !0;
        for (const s of t.values || []) n ? n = !1 : e += ",", e += _e(s);
        return e + "]";
    }
    /**
 * Converts the possible Proto values for a timestamp value into a "seconds and
 * nanos" representation.
 */ (t.arrayValue) : "mapValue" in t ? function(t) {
        // Iteration order in JavaScript is not guaranteed. To ensure that we generate
        // matching canonical IDs for identical maps, we need to sort the keys.
        const e = Object.keys(t.fields || {}).sort();
        let n = "{", s = !0;
        for (const i of e) s ? s = !1 : n += ",", n += `${i}:${_e(t.fields[i])}`;
        return n + "}";
    }(t.mapValue) : p();
    var e, n;
}

function fe(t) {
    // The json interface (for the browser) will return an iso timestamp string,
    // while the proto js library (for node) will return a
    // google.protobuf.Timestamp instance.
    if (V(!!t), "string" == typeof t) {
        // The date string can have higher precision (nanos) than the Date class
        // (millis), so we do some custom parsing here.
        // Parse the nanos right out of the string.
        let e = 0;
        const n = re.exec(t);
        if (V(!!n), n[1]) {
            // Pad the fraction out to 9 digits (nanos).
            let t = n[1];
            t = (t + "000000000").substr(0, 9), e = Number(t);
        }
        // Parse the date to get the seconds.
                const s = new Date(t);
        return {
            seconds: Math.floor(s.getTime() / 1e3),
            nanos: e
        };
    }
    return {
        seconds: de(t.seconds),
        nanos: de(t.nanos)
    };
}

/**
 * Converts the possible Proto types for numbers into a JavaScript number.
 * Returns 0 if the value is not numeric.
 */ function de(t) {
    // TODO(bjornick): Handle int64 greater than 53 bits.
    return "number" == typeof t ? t : "string" == typeof t ? Number(t) : 0;
}

/** Converts the possible Proto types for Blobs into a ByteString. */ function we(t) {
    return "string" == typeof t ? ot.fromBase64String(t) : ot.fromUint8Array(t);
}

/** Returns a reference value for the provided database and key. */ function me(t, e) {
    return {
        referenceValue: `projects/${t.projectId}/databases/${t.database}/documents/${e.path.R()}`
    };
}

/** Returns true if `value` is an IntegerValue . */ function Te(t) {
    return !!t && "integerValue" in t;
}

/** Returns true if `value` is a DoubleValue. */
/** Returns true if `value` is an ArrayValue. */
function Ee(t) {
    return !!t && "arrayValue" in t;
}

/** Returns true if `value` is a NullValue. */ function Ie(t) {
    return !!t && "nullValue" in t;
}

/** Returns true if `value` is NaN. */ function Ae(t) {
    return !!t && "doubleValue" in t && isNaN(Number(t.doubleValue));
}

/** Returns true if `value` is a MapValue. */ function Re(t) {
    return !!t && "mapValue" in t;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ const ye = (() => {
    const t = {
        asc: "ASCENDING",
        desc: "DESCENDING"
    };
    return t;
})(), Pe = (() => {
    const t = {
        "<": "LESS_THAN",
        "<=": "LESS_THAN_OR_EQUAL",
        ">": "GREATER_THAN",
        ">=": "GREATER_THAN_OR_EQUAL",
        "==": "EQUAL",
        "!=": "NOT_EQUAL",
        "array-contains": "ARRAY_CONTAINS",
        in: "IN",
        "not-in": "NOT_IN",
        "array-contains-any": "ARRAY_CONTAINS_ANY"
    };
    return t;
})();

/**
 * This class generates JsonObject values for the Datastore API suitable for
 * sending to either GRPC stub methods or via the JSON/HTTP REST API.
 *
 * The serializer supports both Protobuf.js and Proto3 JSON formats. By
 * setting `useProto3Json` to true, the serializer will use the Proto3 JSON
 * format.
 *
 * For a description of the Proto3 JSON format check
 * https://developers.google.com/protocol-buffers/docs/proto3#json
 *
 * TODO(klimt): We can remove the databaseId argument if we keep the full
 * resource name in documents.
 */
class ge {
    constructor(t, e) {
        this.B = t, this.Qe = e;
    }
}

/**
 * Returns an IntegerValue for `value`.
 */
function pe(t) {
    return {
        integerValue: "" + t
    };
}

/**
 * Returns an DoubleValue for `value` that is encoded based the serializer's
 * `useProto3Json` setting.
 */ function Ve(t, e) {
    if (t.Qe) {
        if (isNaN(e)) return {
            doubleValue: "NaN"
        };
        if (e === 1 / 0) return {
            doubleValue: "Infinity"
        };
        if (e === -1 / 0) return {
            doubleValue: "-Infinity"
        };
    }
    return {
        doubleValue: mt(e) ? "-0" : e
    };
}

/**
 * Returns a value for a number that's appropriate to put into a proto.
 * The return value is an IntegerValue if it can safely represent the value,
 * otherwise a DoubleValue is returned.
 */ function ve(t, e) {
    return function(t) {
        return "number" == typeof t && Number.isInteger(t) && !mt(t) && t <= Number.MAX_SAFE_INTEGER && t >= Number.MIN_SAFE_INTEGER;
    }(e) ? pe(e) : Ve(t, e);
}

/**
 * Returns a value for a Date that's appropriate to put into a proto.
 */ function be(t, e) {
    if (t.Qe) {
        return `${new Date(1e3 * e.seconds).toISOString().replace(/\.\d*/, "").replace("Z", "")}.${("000000000" + e.nanoseconds).slice(-9)}Z`;
    }
    return {
        seconds: "" + e.seconds,
        nanos: e.nanoseconds
    };
}

/**
 * Returns a value for bytes that's appropriate to put in a proto.
 *
 * Visible for testing.
 */
function Se(t, e) {
    return t.Qe ? e.toBase64() : e.toUint8Array();
}

/**
 * Returns a ByteString based on the proto string value.
 */ function De(t, e) {
    return be(t, e.Z());
}

function Ce(t) {
    return V(!!t), dt.J(function(t) {
        const e = fe(t);
        return new ft(e.seconds, e.nanos);
    }(t));
}

function Fe(t, e) {
    return function(t) {
        return new F([ "projects", t.projectId, "databases", t.database ]);
    }(t).child("documents").child(e).R();
}

function Ne(t, e) {
    return Fe(t.B, e.path);
}

function $e(t, e) {
    const n = function(t) {
        const e = F.P(t);
        return V(Ye(e)), e;
    }(e);
    return V(n.get(1) === t.B.projectId), V(!n.get(3) && !t.B.database || n.get(3) === t.B.database), 
    new x((V((s = n).length > 4 && "documents" === s.get(4)), s.u(5)));
    var s;
    /** Creates a Document proto from key and fields (but no create/update time) */}

function xe(t, e) {
    return Fe(t.B, e);
}

function ke(t) {
    return new F([ "projects", t.B.projectId, "databases", t.B.database ]).R();
}

function Oe(t, e, n) {
    return {
        name: Ne(t, e),
        fields: n.proto.mapValue.fields
    };
}

function Le(t, e) {
    return "found" in e ? function(t, e) {
        V(!!e.found), e.found.name, e.found.updateTime;
        const n = $e(t, e.found.name), s = Ce(e.found.updateTime), i = new Dn({
            mapValue: {
                fields: e.found.fields
            }
        });
        return new $n(n, s, i, {});
    }(t, e) : "missing" in e ? function(t, e) {
        V(!!e.missing), V(!!e.readTime);
        const n = $e(t, e.missing), s = Ce(e.readTime);
        return new xn(n, s);
    }(t, e) : p();
}

function Me(t, e) {
    let n;
    if ("targetChange" in e) {
        e.targetChange;
        // proto3 default value is unset in JSON (undefined), so use 'NO_CHANGE'
        // if unset
        const s = function(t) {
            return "NO_CHANGE" === t ? 0 /* NoChange */ : "ADD" === t ? 1 /* Added */ : "REMOVE" === t ? 2 /* Removed */ : "CURRENT" === t ? 3 /* Current */ : "RESET" === t ? 4 /* Reset */ : p();
        }(e.targetChange.targetChangeType || "NO_CHANGE"), i = e.targetChange.targetIds || [], r = function(t, e) {
            return t.Qe ? (V(void 0 === e || "string" == typeof e), ot.fromBase64String(e || "")) : (V(void 0 === e || e instanceof Uint8Array), 
            ot.fromUint8Array(e || new Uint8Array));
        }(t, e.targetChange.resumeToken), o = e.targetChange.cause, u = o && function(t) {
            const e = void 0 === t.code ? T.UNKNOWN : bt(t.code);
            return new E(e, t.message || "");
        }
        /**
 * Returns a value for a number (or null) that's appropriate to put into
 * a google.protobuf.Int32Value proto.
 * DO NOT USE THIS FOR ANYTHING ELSE.
 * This method cheats. It's typed as returning "number" because that's what
 * our generated proto interfaces say Int32Value must be. But GRPC actually
 * expects a { value: <number> } struct.
 */ (o);
        n = new Jt(s, i, r, u || null);
    } else if ("documentChange" in e) {
        e.documentChange;
        const s = e.documentChange;
        s.document, s.document.name, s.document.updateTime;
        const i = $e(t, s.document.name), r = Ce(s.document.updateTime), o = new Dn({
            mapValue: {
                fields: s.document.fields
            }
        }), u = new $n(i, r, o, {}), c = s.targetIds || [], a = s.removedTargetIds || [];
        n = new Ht(c, a, u.key, u);
    } else if ("documentDelete" in e) {
        e.documentDelete;
        const s = e.documentDelete;
        s.document;
        const i = $e(t, s.document), r = s.readTime ? Ce(s.readTime) : dt.min(), o = new xn(i, r), u = s.removedTargetIds || [];
        n = new Ht([], u, o.key, o);
    } else if ("documentRemove" in e) {
        e.documentRemove;
        const s = e.documentRemove;
        s.document;
        const i = $e(t, s.document), r = s.removedTargetIds || [];
        n = new Ht([], r, i, null);
    } else {
        if (!("filter" in e)) return p();
        {
            e.filter;
            const t = e.filter;
            t.targetId;
            const s = t.count || 0, i = new gt(s), r = t.targetId;
            n = new Yt(r, i);
        }
    }
    return n;
}

function qe(t, e) {
    let n;
    if (e instanceof yn) n = {
        update: Oe(t, e.key, e.value)
    }; else if (e instanceof bn) n = {
        delete: Ne(t, e.key)
    }; else if (e instanceof Pn) n = {
        update: Oe(t, e.key, e.data),
        updateMask: He(e.je)
    }; else if (e instanceof pn) n = {
        transform: {
            document: Ne(t, e.key),
            fieldTransforms: e.fieldTransforms.map((t => function(t, e) {
                const n = e.transform;
                if (n instanceof en) return {
                    fieldPath: e.field.R(),
                    setToServerValue: "REQUEST_TIME"
                };
                if (n instanceof nn) return {
                    fieldPath: e.field.R(),
                    appendMissingElements: {
                        values: n.elements
                    }
                };
                if (n instanceof rn) return {
                    fieldPath: e.field.R(),
                    removeAllFromArray: {
                        values: n.elements
                    }
                };
                if (n instanceof un) return {
                    fieldPath: e.field.R(),
                    increment: n.We
                };
                throw p();
            }(0, t)))
        }
    }; else {
        if (!(e instanceof Sn)) return p();
        n = {
            verify: Ne(t, e.key)
        };
    }
    return e.ze.Ge || (n.currentDocument = function(t, e) {
        return void 0 !== e.updateTime ? {
            updateTime: De(t, e.updateTime)
        } : void 0 !== e.exists ? {
            exists: e.exists
        } : p();
    }(t, e.ze)), n;
}

function Ue(t, e) {
    return t && t.length > 0 ? (V(void 0 !== e), t.map((t => function(t, e) {
        // NOTE: Deletes don't have an updateTime.
        let n = t.updateTime ? Ce(t.updateTime) : Ce(e);
        n.isEqual(dt.min()) && (
        // The Firestore Emulator currently returns an update time of 0 for
        // deletes of non-existing documents (rather than null). This breaks the
        // test "get deleted doc while offline with source=cache" as NoDocuments
        // with version 0 are filtered by IndexedDb's RemoteDocumentCache.
        // TODO(#2149): Remove this when Emulator is fixed
        n = Ce(e));
        let s = null;
        return t.transformResults && t.transformResults.length > 0 && (s = t.transformResults), 
        new fn(n, s);
    }(t, e)))) : [];
}

function Be(t, e) {
    return {
        documents: [ xe(t, e.path) ]
    };
}

function Qe(t, e) {
    // Dissect the path into parent, collectionId, and optional key filter.
    const n = {
        structuredQuery: {}
    }, s = e.path;
    null !== e.collectionGroup ? (n.parent = xe(t, s), n.structuredQuery.from = [ {
        collectionId: e.collectionGroup,
        allDescendants: !0
    } ]) : (n.parent = xe(t, s.h()), n.structuredQuery.from = [ {
        collectionId: s._()
    } ]);
    const i = function(t) {
        if (0 === t.length) return;
        const e = t.map((t => 
        // visible for testing
        function(t) {
            if ("==" /* EQUAL */ === t.op) {
                if (Ae(t.value)) return {
                    unaryFilter: {
                        field: Ke(t.field),
                        op: "IS_NAN"
                    }
                };
                if (Ie(t.value)) return {
                    unaryFilter: {
                        field: Ke(t.field),
                        op: "IS_NULL"
                    }
                };
            } else if ("!=" /* NOT_EQUAL */ === t.op) {
                if (Ae(t.value)) return {
                    unaryFilter: {
                        field: Ke(t.field),
                        op: "IS_NOT_NAN"
                    }
                };
                if (Ie(t.value)) return {
                    unaryFilter: {
                        field: Ke(t.field),
                        op: "IS_NOT_NULL"
                    }
                };
            }
            return {
                fieldFilter: {
                    field: Ke(t.field),
                    op: ze(t.op),
                    value: t.value
                }
            };
        }(t)));
        if (1 === e.length) return e[0];
        return {
            compositeFilter: {
                op: "AND",
                filters: e
            }
        };
    }(e.filters);
    i && (n.structuredQuery.where = i);
    const r = function(t) {
        if (0 === t.length) return;
        return t.map((t => 
        // visible for testing
        function(t) {
            return {
                field: Ke(t.field),
                direction: Ge(t.dir)
            };
        }(t)));
    }(e.orderBy);
    r && (n.structuredQuery.orderBy = r);
    const o = function(t, e) {
        return t.Qe || wt(e) ? e : {
            value: e
        };
    }(t, e.limit);
    return null !== o && (n.structuredQuery.limit = o), e.startAt && (n.structuredQuery.startAt = We(e.startAt)), 
    e.endAt && (n.structuredQuery.endAt = We(e.endAt)), n;
}

function je(t, e) {
    const n = function(t, e) {
        switch (e) {
          case 0 /* Listen */ :
            return null;

          case 1 /* ExistenceFilterMismatch */ :
            return "existence-filter-mismatch";

          case 2 /* LimboResolution */ :
            return "limbo-document";

          default:
            return p();
        }
    }(0, e.et);
    return null == n ? null : {
        "goog-listen-tags": n
    };
}

function We(t) {
    return {
        before: t.before,
        values: t.position
    };
}

// visible for testing
function Ge(t) {
    return ye[t];
}

// visible for testing
function ze(t) {
    return Pe[t];
}

function Ke(t) {
    return {
        fieldPath: t.R()
    };
}

function He(t) {
    const e = [];
    return t.fields.forEach((t => e.push(t.R()))), {
        fieldPaths: e
    };
}

function Ye(t) {
    // Resource names have at least 4 components (project ID, database ID)
    return t.length >= 4 && "projects" === t.get(0) && "databases" === t.get(2);
}

/**
 * @license
 * Copyright 2018 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** Represents a transform within a TransformMutation. */ class Je {
    constructor() {
        // Make sure that the structural type of `TransformOperation` is unique.
        // See https://github.com/microsoft/TypeScript/issues/5451
        this.Ke = void 0;
    }
}

/**
 * Computes the local transform result against the provided `previousValue`,
 * optionally using the provided localWriteTime.
 */ function Xe(t, e, n) {
    return t instanceof en ? function(t, e) {
        const n = {
            fields: {
                __type__: {
                    stringValue: "server_timestamp"
                },
                __local_write_time__: {
                    timestampValue: {
                        seconds: t.seconds,
                        nanos: t.nanoseconds
                    }
                }
            }
        };
        return e && (n.fields.__previous_value__ = e), {
            mapValue: n
        };
    }(n, e) : t instanceof nn ? sn(t, e) : t instanceof rn ? on(t, e) : function(t, e) {
        // PORTING NOTE: Since JavaScript's integer arithmetic is limited to 53 bit
        // precision and resolves overflows by reducing precision, we do not
        // manually cap overflows at 2^63.
        const n = tn(t, e), s = cn(n) + cn(t.We);
        return Te(n) && Te(t.We) ? pe(s) : Ve(t.serializer, s);
    }(t, e);
}

/**
 * Computes a final transform result after the transform has been acknowledged
 * by the server, potentially using the server-provided transformResult.
 */ function Ze(t, e, n) {
    // The server just sends null as the transform result for array operations,
    // so we have to calculate a result the same as we do for local
    // applications.
    return t instanceof nn ? sn(t, e) : t instanceof rn ? on(t, e) : n;
}

/**
 * If this transform operation is not idempotent, returns the base value to
 * persist for this transform. If a base value is returned, the transform
 * operation is always applied to this base value, even if document has
 * already been updated.
 *
 * Base values provide consistent behavior for non-idempotent transforms and
 * allow us to return the same latency-compensated value even if the backend
 * has already applied the transform operation. The base value is null for
 * idempotent transforms, as they can be re-played even if the backend has
 * already applied them.
 *
 * @return a base value to store along with the mutation, or null for
 * idempotent transforms.
 */ function tn(t, e) {
    return t instanceof un ? Te(n = e) || function(t) {
        return !!t && "doubleValue" in t;
    }
    /** Returns true if `value` is either an IntegerValue or a DoubleValue. */ (n) ? e : {
        integerValue: 0
    } : null;
    var n;
}

/** Transforms a value into a server-generated timestamp. */
class en extends Je {}

/** Transforms an array value via a union operation. */ class nn extends Je {
    constructor(t) {
        super(), this.elements = t;
    }
}

function sn(t, e) {
    const n = an(e);
    for (const e of t.elements) n.some((t => ue(t, e))) || n.push(e);
    return {
        arrayValue: {
            values: n
        }
    };
}

/** Transforms an array value via a remove operation. */ class rn extends Je {
    constructor(t) {
        super(), this.elements = t;
    }
}

function on(t, e) {
    let n = an(e);
    for (const e of t.elements) n = n.filter((t => !ue(t, e)));
    return {
        arrayValue: {
            values: n
        }
    };
}

/**
 * Implements the backend semantics for locally computed NUMERIC_ADD (increment)
 * transforms. Converts all field values to integers or doubles, but unlike the
 * backend does not cap integer values at 2^63. Instead, JavaScript number
 * arithmetic is used and precision loss can occur for values greater than 2^53.
 */ class un extends Je {
    constructor(t, e) {
        super(), this.serializer = t, this.We = e;
    }
}

function cn(t) {
    return de(t.integerValue || t.doubleValue);
}

function an(t) {
    return Ee(t) && t.arrayValue.values ? t.arrayValue.values.slice() : [];
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Provides a set of fields that can be used to partially patch a document.
 * FieldMask is used in conjunction with ObjectValue.
 * Examples:
 *   foo - Overwrites foo entirely with the provided value. If foo is not
 *         present in the companion ObjectValue, the field is deleted.
 *   foo.bar - Overwrites only the field bar of the object foo.
 *             If foo is not an object, foo is replaced with an object
 *             containing foo
 */ class hn {
    constructor(t) {
        this.fields = t, 
        // TODO(dimond): validation of FieldMask
        // Sort the field mask to support `FieldMask.isEqual()` and assert below.
        t.sort($.i);
    }
    /**
     * Verifies that `fieldPath` is included by at least one field in this field
     * mask.
     *
     * This is an O(n) operation, where `n` is the size of the field mask.
     */    He(t) {
        for (const e of this.fields) if (e.T(t)) return !0;
        return !1;
    }
    isEqual(t) {
        return rt(this.fields, t.fields, ((t, e) => t.isEqual(e)));
    }
}

/** A field path and the TransformOperation to perform upon it. */ class ln {
    constructor(t, e) {
        this.field = t, this.transform = e;
    }
}

function _n(t, e) {
    return t.field.isEqual(e.field) && function(t, e) {
        return t instanceof nn && e instanceof nn || t instanceof rn && e instanceof rn ? rt(t.elements, e.elements, ue) : t instanceof un && e instanceof un ? ue(t.We, e.We) : t instanceof en && e instanceof en;
    }(t.transform, e.transform);
}

/** The result of successfully applying a mutation to the backend. */ class fn {
    constructor(
    /**
     * The version at which the mutation was committed:
     *
     * - For most operations, this is the updateTime in the WriteResult.
     * - For deletes, the commitTime of the WriteResponse (because deletes are
     *   not stored and have no updateTime).
     *
     * Note that these versions can be different: No-op writes will not change
     * the updateTime even though the commitTime advances.
     */
    t, 
    /**
     * The resulting fields returned from the backend after a
     * TransformMutation has been committed. Contains one FieldValue for each
     * FieldTransform that was in the mutation.
     *
     * Will be null if the mutation was not a TransformMutation.
     */
    e) {
        this.version = t, this.transformResults = e;
    }
}

/**
 * Encodes a precondition for a mutation. This follows the model that the
 * backend accepts with the special case of an explicit "empty" precondition
 * (meaning no precondition).
 */ class dn {
    constructor(t, e) {
        this.updateTime = t, this.exists = e;
    }
    /** Creates a new empty Precondition. */    static Ye() {
        return new dn;
    }
    /** Creates a new Precondition with an exists flag. */    static exists(t) {
        return new dn(void 0, t);
    }
    /** Creates a new Precondition based on a version a document exists at. */    static updateTime(t) {
        return new dn(t);
    }
    /** Returns whether this Precondition is empty. */    get Ge() {
        return void 0 === this.updateTime && void 0 === this.exists;
    }
    isEqual(t) {
        return this.exists === t.exists && (this.updateTime ? !!t.updateTime && this.updateTime.isEqual(t.updateTime) : !t.updateTime);
    }
}

/**
 * Returns true if the preconditions is valid for the given document
 * (or null if no document is available).
 */ function wn(t, e) {
    return void 0 !== t.updateTime ? e instanceof $n && e.version.isEqual(t.updateTime) : void 0 === t.exists || t.exists === e instanceof $n;
}

/**
 * A mutation describes a self-contained change to a document. Mutations can
 * create, replace, delete, and update subsets of documents.
 *
 * Mutations not only act on the value of the document but also its version.
 *
 * For local mutations (mutations that haven't been committed yet), we preserve
 * the existing version for Set, Patch, and Transform mutations. For Delete
 * mutations, we reset the version to 0.
 *
 * Here's the expected transition table.
 *
 * MUTATION           APPLIED TO            RESULTS IN
 *
 * SetMutation        Document(v3)          Document(v3)
 * SetMutation        NoDocument(v3)        Document(v0)
 * SetMutation        null                  Document(v0)
 * PatchMutation      Document(v3)          Document(v3)
 * PatchMutation      NoDocument(v3)        NoDocument(v3)
 * PatchMutation      null                  null
 * TransformMutation  Document(v3)          Document(v3)
 * TransformMutation  NoDocument(v3)        NoDocument(v3)
 * TransformMutation  null                  null
 * DeleteMutation     Document(v3)          NoDocument(v0)
 * DeleteMutation     NoDocument(v3)        NoDocument(v0)
 * DeleteMutation     null                  NoDocument(v0)
 *
 * For acknowledged mutations, we use the updateTime of the WriteResponse as
 * the resulting version for Set, Patch, and Transform mutations. As deletes
 * have no explicit update time, we use the commitTime of the WriteResponse for
 * Delete mutations.
 *
 * If a mutation is acknowledged by the backend but fails the precondition check
 * locally, we return an `UnknownDocument` and rely on Watch to send us the
 * updated version.
 *
 * Note that TransformMutations don't create Documents (in the case of being
 * applied to a NoDocument), even though they would on the backend. This is
 * because the client always combines the TransformMutation with a SetMutation
 * or PatchMutation and we only want to apply the transform if the prior
 * mutation resulted in a Document (always true for a SetMutation, but not
 * necessarily for a PatchMutation).
 *
 * ## Subclassing Notes
 *
 * Subclasses of Mutation need to implement applyToRemoteDocument() and
 * applyToLocalView() to implement the actual behavior of applying the mutation
 * to some source document.
 */ class mn {}

/**
 * Applies this mutation to the given MaybeDocument or null for the purposes
 * of computing a new remote document. If the input document doesn't match the
 * expected state (e.g. it is null or outdated), an `UnknownDocument` can be
 * returned.
 *
 * @param mutation The mutation to apply.
 * @param maybeDoc The document to mutate. The input document can be null if
 *     the client has no knowledge of the pre-mutation state of the document.
 * @param mutationResult The result of applying the mutation from the backend.
 * @return The mutated document. The returned document may be an
 *     UnknownDocument if the mutation could not be applied to the locally
 *     cached base document.
 */ function Tn(t, e, n) {
    return t instanceof yn ? function(t, e, n) {
        // Unlike applySetMutationToLocalView, if we're applying a mutation to a
        // remote document the server has accepted the mutation so the precondition
        // must have held.
        return new $n(t.key, n.version, t.value, {
            hasCommittedMutations: !0
        });
    }(t, 0, n) : t instanceof Pn ? function(t, e, n) {
        if (!wn(t.ze, e)) 
        // Since the mutation was not rejected, we know that the  precondition
        // matched on the backend. We therefore must not have the expected version
        // of the document in our cache and return an UnknownDocument with the
        // known updateTime.
        return new kn(t.key, n.version);
        const s = gn(t, e);
        return new $n(t.key, n.version, s, {
            hasCommittedMutations: !0
        });
    }(t, e, n) : t instanceof pn ? function(t, e, n) {
        if (V(null != n.transformResults), !wn(t.ze, e)) 
        // Since the mutation was not rejected, we know that the  precondition
        // matched on the backend. We therefore must not have the expected version
        // of the document in our cache and return an UnknownDocument with the
        // known updateTime.
        return new kn(t.key, n.version);
        const s = Vn(t, e), i = 
        /**
 * Creates a list of "transform results" (a transform result is a field value
 * representing the result of applying a transform) for use after a
 * TransformMutation has been acknowledged by the server.
 *
 * @param fieldTransforms The field transforms to apply the result to.
 * @param baseDoc The document prior to applying this mutation batch.
 * @param serverTransformResults The transform results received by the server.
 * @return The transform results list.
 */
        function(t, e, n) {
            const s = [];
            V(t.length === n.length);
            for (let i = 0; i < n.length; i++) {
                const r = t[i], o = r.transform;
                let u = null;
                e instanceof $n && (u = e.field(r.field)), s.push(Ze(o, u, n[i]));
            }
            return s;
        }
        /**
 * Creates a list of "transform results" (a transform result is a field value
 * representing the result of applying a transform) for use when applying a
 * TransformMutation locally.
 *
 * @param fieldTransforms The field transforms to apply the result to.
 * @param localWriteTime The local time of the transform mutation (used to
 *     generate ServerTimestampValues).
 * @param maybeDoc The current state of the document after applying all
 *     previous mutations.
 * @param baseDoc The document prior to applying this mutation batch.
 * @return The transform results list.
 */ (t.fieldTransforms, e, n.transformResults), r = n.version, o = vn(t, s.data(), i);
        return new $n(t.key, r, o, {
            hasCommittedMutations: !0
        });
    }(t, e, n) : function(t, e, n) {
        // Unlike applyToLocalView, if we're applying a mutation to a remote
        // document the server has accepted the mutation so the precondition must
        // have held.
        return new xn(t.key, n.version, {
            hasCommittedMutations: !0
        });
    }(t, 0, n);
}

/**
 * Applies this mutation to the given MaybeDocument or null for the purposes
 * of computing the new local view of a document. Both the input and returned
 * documents can be null.
 *
 * @param mutation The mutation to apply.
 * @param maybeDoc The document to mutate. The input document can be null if
 *     the client has no knowledge of the pre-mutation state of the document.
 * @param baseDoc The state of the document prior to this mutation batch. The
 *     input document can be null if the client has no knowledge of the
 *     pre-mutation state of the document.
 * @param localWriteTime A timestamp indicating the local write time of the
 *     batch this mutation is a part of.
 * @return The mutated document. The returned document may be null, but only
 *     if maybeDoc was null and the mutation would not create a new document.
 */ function En(t, e, n, s) {
    return t instanceof yn ? function(t, e) {
        if (!wn(t.ze, e)) return e;
        const n = Rn(e);
        return new $n(t.key, n, t.value, {
            Je: !0
        });
    }
    /**
 * A mutation that modifies fields of the document at the given key with the
 * given values. The values are applied through a field mask:
 *
 *  * When a field is in both the mask and the values, the corresponding field
 *    is updated.
 *  * When a field is in neither the mask nor the values, the corresponding
 *    field is unmodified.
 *  * When a field is in the mask but not in the values, the corresponding field
 *    is deleted.
 *  * When a field is not in the mask but is in the values, the values map is
 *    ignored.
 */ (t, e) : t instanceof Pn ? function(t, e) {
        if (!wn(t.ze, e)) return e;
        const n = Rn(e), s = gn(t, e);
        return new $n(t.key, n, s, {
            Je: !0
        });
    }
    /**
 * Patches the data of document if available or creates a new document. Note
 * that this does not check whether or not the precondition of this patch
 * holds.
 */ (t, e) : t instanceof pn ? function(t, e, n, s) {
        if (!wn(t.ze, e)) return e;
        const i = Vn(t, e), r = function(t, e, n, s) {
            const i = [];
            for (const r of t) {
                const t = r.transform;
                let o = null;
                n instanceof $n && (o = n.field(r.field)), null === o && s instanceof $n && (
                // If the current document does not contain a value for the mutated
                // field, use the value that existed before applying this mutation
                // batch. This solves an edge case where a PatchMutation clears the
                // values in a nested map before the TransformMutation is applied.
                o = s.field(r.field)), i.push(Xe(t, o, e));
            }
            return i;
        }(t.fieldTransforms, n, e, s), o = vn(t, i.data(), r);
        return new $n(t.key, i.version, o, {
            Je: !0
        });
    }(t, e, s, n) : function(t, e) {
        if (!wn(t.ze, e)) return e;
        return new xn(t.key, dt.min());
    }
    /**
 * A mutation that verifies the existence of the document at the given key with
 * the provided precondition.
 *
 * The `verify` operation is only used in Transactions, and this class serves
 * primarily to facilitate serialization into protos.
 */ (t, e);
}

/**
 * If this mutation is not idempotent, returns the base value to persist with
 * this mutation. If a base value is returned, the mutation is always applied
 * to this base value, even if document has already been updated.
 *
 * The base value is a sparse object that consists of only the document
 * fields for which this mutation contains a non-idempotent transformation
 * (e.g. a numeric increment). The provided value guarantees consistent
 * behavior for non-idempotent transforms and allow us to return the same
 * latency-compensated value even if the backend has already applied the
 * mutation. The base value is null for idempotent mutations, as they can be
 * re-played even if the backend has already applied them.
 *
 * @return a base value to store along with the mutation, or null for
 * idempotent mutations.
 */ function In(t, e) {
    return t instanceof pn ? function(t, e) {
        let n = null;
        for (const s of t.fieldTransforms) {
            const t = e instanceof $n ? e.field(s.field) : void 0, i = tn(s.transform, t || null);
            null != i && (n = null == n ? (new Cn).set(s.field, i) : n.set(s.field, i));
        }
        return n ? n.Xe() : null;
    }
    /**
 * Asserts that the given MaybeDocument is actually a Document and verifies
 * that it matches the key for this mutation. Since we only support
 * transformations with precondition exists this method is guaranteed to be
 * safe.
 */ (t, e) : null;
}

function An(t, e) {
    return t.type === e.type && (!!t.key.isEqual(e.key) && (!!t.ze.isEqual(e.ze) && (0 /* Set */ === t.type ? t.value.isEqual(e.value) : 1 /* Patch */ === t.type ? t.data.isEqual(e.data) && t.je.isEqual(e.je) : 2 /* Transform */ !== t.type || rt(t.fieldTransforms, t.fieldTransforms, ((t, e) => _n(t, e))))));
}

/**
 * Returns the version from the given document for use as the result of a
 * mutation. Mutations are defined to return the version of the base document
 * only if it is an existing document. Deleted and unknown documents have a
 * post-mutation version of SnapshotVersion.min().
 */ function Rn(t) {
    return t instanceof $n ? t.version : dt.min();
}

/**
 * A mutation that creates or replaces the document at the given key with the
 * object value contents.
 */ class yn extends mn {
    constructor(t, e, n) {
        super(), this.key = t, this.value = e, this.ze = n, this.type = 0 /* Set */;
    }
}

class Pn extends mn {
    constructor(t, e, n, s) {
        super(), this.key = t, this.data = e, this.je = n, this.ze = s, this.type = 1 /* Patch */;
    }
}

function gn(t, e) {
    let n;
    return n = e instanceof $n ? e.data() : Dn.empty(), function(t, e) {
        const n = new Cn(e);
        return t.je.fields.forEach((e => {
            if (!e.m()) {
                const s = t.data.field(e);
                null !== s ? n.set(e, s) : n.delete(e);
            }
        })), n.Xe();
    }
    /**
 * A mutation that modifies specific fields of the document with transform
 * operations. Currently the only supported transform is a server timestamp, but
 * IP Address, increment(n), etc. could be supported in the future.
 *
 * It is somewhat similar to a PatchMutation in that it patches specific fields
 * and has no effect when applied to a null or NoDocument (see comment on
 * Mutation for rationale).
 */ (t, n);
}

class pn extends mn {
    constructor(t, e) {
        super(), this.key = t, this.fieldTransforms = e, this.type = 2 /* Transform */ , 
        // NOTE: We set a precondition of exists: true as a safety-check, since we
        // always combine TransformMutations with a SetMutation or PatchMutation which
        // (if successful) should end up with an existing document.
        this.ze = dn.exists(!0);
    }
}

function Vn(t, e) {
    return e;
}

function vn(t, e, n) {
    const s = new Cn(e);
    for (let e = 0; e < t.fieldTransforms.length; e++) {
        const i = t.fieldTransforms[e];
        s.set(i.field, n[e]);
    }
    return s.Xe();
}

/** A mutation that deletes the document at the given key. */ class bn extends mn {
    constructor(t, e) {
        super(), this.key = t, this.ze = e, this.type = 3 /* Delete */;
    }
}

class Sn extends mn {
    constructor(t, e) {
        super(), this.key = t, this.ze = e, this.type = 4 /* Verify */;
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * An ObjectValue represents a MapValue in the Firestore Proto and offers the
 * ability to add and remove fields (via the ObjectValueBuilder).
 */ class Dn {
    constructor(t) {
        this.proto = t;
    }
    static empty() {
        return new Dn({
            mapValue: {}
        });
    }
    /**
     * Returns the value at the given path or null.
     *
     * @param path the path to search
     * @return The value at the path or if there it doesn't exist.
     */    field(t) {
        if (t.m()) return this.proto;
        {
            let e = this.proto;
            for (let n = 0; n < t.length - 1; ++n) {
                if (!e.mapValue.fields) return null;
                if (e = e.mapValue.fields[t.get(n)], !Re(e)) return null;
            }
            return e = (e.mapValue.fields || {})[t._()], e || null;
        }
    }
    isEqual(t) {
        return ue(this.proto, t.proto);
    }
}

/**
 * An ObjectValueBuilder provides APIs to set and delete fields from an
 * ObjectValue.
 */ class Cn {
    /**
     * @param baseObject The object to mutate.
     */
    constructor(t = Dn.empty()) {
        this.Ze = t, 
        /** A map that contains the accumulated changes in this builder. */
        this.tn = new Map;
    }
    /**
     * Sets the field to the provided value.
     *
     * @param path The field path to set.
     * @param value The value to set.
     * @return The current Builder instance.
     */    set(t, e) {
        return this.en(t, e), this;
    }
    /**
     * Removes the field at the specified path. If there is no field at the
     * specified path, nothing is changed.
     *
     * @param path The field path to remove.
     * @return The current Builder instance.
     */    delete(t) {
        return this.en(t, null), this;
    }
    /**
     * Adds `value` to the overlay map at `path`. Creates nested map entries if
     * needed.
     */    en(t, e) {
        let n = this.tn;
        for (let e = 0; e < t.length - 1; ++e) {
            const s = t.get(e);
            let i = n.get(s);
            i instanceof Map ? 
            // Re-use a previously created map
            n = i : i && 10 /* ObjectValue */ === oe(i) ? (
            // Convert the existing Protobuf MapValue into a map
            i = new Map(Object.entries(i.mapValue.fields || {})), n.set(s, i), n = i) : (
            // Create an empty map to represent the current nesting level
            i = new Map, n.set(s, i), n = i);
        }
        n.set(t._(), e);
    }
    /** Returns an ObjectValue with all mutations applied. */    Xe() {
        const t = this.nn($.g(), this.tn);
        return null != t ? new Dn(t) : this.Ze;
    }
    /**
     * Applies any overlays from `currentOverlays` that exist at `currentPath`
     * and returns the merged data at `currentPath` (or null if there were no
     * changes).
     *
     * @param currentPath The path at the current nesting level. Can be set to
     * FieldValue.emptyPath() to represent the root.
     * @param currentOverlays The overlays at the current nesting level in the
     * same format as `overlayMap`.
     * @return The merged data at `currentPath` or null if no modifications
     * were applied.
     */    nn(t, e) {
        let n = !1;
        const s = this.Ze.field(t), i = Re(s) ? // If there is already data at the current path, base our
        Object.assign({}, s.mapValue.fields) : {};
        return e.forEach(((e, s) => {
            if (e instanceof Map) {
                const r = this.nn(t.child(s), e);
                null != r && (i[s] = r, n = !0);
            } else null !== e ? (i[s] = e, n = !0) : i.hasOwnProperty(s) && (delete i[s], n = !0);
        })), n ? {
            mapValue: {
                fields: i
            }
        } : null;
    }
}

/**
 * Returns a FieldMask built from all fields in a MapValue.
 */ function Fn(t) {
    const e = [];
    return S(t.fields || {}, ((t, n) => {
        const s = new $([ t ]);
        if (Re(n)) {
            const t = Fn(n.mapValue).fields;
            if (0 === t.length) 
            // Preserve the empty map by adding it to the FieldMask.
            e.push(s); else 
            // For nested and non-empty ObjectValues, add the FieldPath of the
            // leaf nodes.
            for (const n of t) e.push(s.child(n));
        } else 
        // For nested and non-empty ObjectValues, add the FieldPath of the leaf
        // nodes.
        e.push(s);
    })), new hn(e);
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * The result of a lookup for a given path may be an existing document or a
 * marker that this document does not exist at a given version.
 */ class Nn {
    constructor(t, e) {
        this.key = t, this.version = e;
    }
}

/**
 * Represents a document in Firestore with a key, version, data and whether the
 * data has local mutations applied to it.
 */ class $n extends Nn {
    constructor(t, e, n, s) {
        super(t, e), this.sn = n, this.Je = !!s.Je, this.hasCommittedMutations = !!s.hasCommittedMutations;
    }
    field(t) {
        return this.sn.field(t);
    }
    data() {
        return this.sn;
    }
    rn() {
        return this.sn.proto;
    }
    isEqual(t) {
        return t instanceof $n && this.key.isEqual(t.key) && this.version.isEqual(t.version) && this.Je === t.Je && this.hasCommittedMutations === t.hasCommittedMutations && this.sn.isEqual(t.sn);
    }
    toString() {
        return `Document(${this.key}, ${this.version}, ${this.sn.toString()}, {hasLocalMutations: ${this.Je}}), {hasCommittedMutations: ${this.hasCommittedMutations}})`;
    }
    get hasPendingWrites() {
        return this.Je || this.hasCommittedMutations;
    }
}

/**
 * Compares the value for field `field` in the provided documents. Throws if
 * the field does not exist in both documents.
 */
/**
 * A class representing a deleted document.
 * Version is set to 0 if we don't point to any specific time, otherwise it
 * denotes time we know it didn't exist at.
 */
class xn extends Nn {
    constructor(t, e, n) {
        super(t, e), this.hasCommittedMutations = !(!n || !n.hasCommittedMutations);
    }
    toString() {
        return `NoDocument(${this.key}, ${this.version})`;
    }
    get hasPendingWrites() {
        return this.hasCommittedMutations;
    }
    isEqual(t) {
        return t instanceof xn && t.hasCommittedMutations === this.hasCommittedMutations && t.version.isEqual(this.version) && t.key.isEqual(this.key);
    }
}

/**
 * A class representing an existing document whose data is unknown (e.g. a
 * document that was updated without a known base document).
 */ class kn extends Nn {
    toString() {
        return `UnknownDocument(${this.key}, ${this.version})`;
    }
    get hasPendingWrites() {
        return !0;
    }
    isEqual(t) {
        return t instanceof kn && t.version.isEqual(this.version) && t.key.isEqual(this.key);
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Query encapsulates all the query attributes we support in the SDK. It can
 * be run against the LocalStore, as well as be converted to a `Target` to
 * query the RemoteStore results.
 *
 * Visible for testing.
 */ class On {
    /**
     * Initializes a Query with a path and optional additional query constraints.
     * Path must currently be empty if this is a collection group query.
     */
    constructor(t, e = null, n = [], s = [], i = null, r = "F" /* First */ , o = null, u = null) {
        this.path = t, this.collectionGroup = e, this.on = n, this.filters = s, this.limit = i, 
        this.un = r, this.startAt = o, this.endAt = u, this.cn = null, 
        // The corresponding `Target` of this `Query` instance.
        this.an = null, this.startAt, this.endAt;
    }
}

/** Creates a new Query for a query that matches all documents at `path` */ function Ln(t) {
    return new On(t);
}

/**
 * Helper to convert a collection group query into a collection query at a
 * specific path. This is used when executing collection group queries, since
 * we have to split the query into a set of collection queries at multiple
 * paths.
 */ function Mn(t) {
    return !wt(t.limit) && "F" /* First */ === t.un;
}

function qn(t) {
    return !wt(t.limit) && "L" /* Last */ === t.un;
}

function Un(t) {
    return t.on.length > 0 ? t.on[0].field : null;
}

function Bn(t) {
    for (const e of t.filters) if (e.hn()) return e.field;
    return null;
}

/**
 * Checks if any of the provided Operators are included in the query and
 * returns the first one that is, or null if none are.
 */
/**
 * Returns whether the query matches a collection group rather than a specific
 * collection.
 */
function Qn(t) {
    return null !== t.collectionGroup;
}

/**
 * Returns the implicit order by constraint that is used to execute the Query,
 * which can be different from the order by constraints the user provided (e.g.
 * the SDK and backend always orders by `__name__`).
 */ function jn(t) {
    const e = v(t);
    if (null === e.cn) {
        e.cn = [];
        const t = Bn(e), n = Un(e);
        if (null !== t && null === n) 
        // In order to implicitly add key ordering, we must also add the
        // inequality filter field for it to be a valid query.
        // Note that the default inequality field and key ordering is ascending.
        t.V() || e.cn.push(new ds(t)), e.cn.push(new ds($.v(), "asc" /* ASCENDING */)); else {
            let t = !1;
            for (const n of e.on) e.cn.push(n), n.field.V() && (t = !0);
            if (!t) {
                // The order of the implicit key ordering always matches the last
                // explicit order by
                const t = e.on.length > 0 ? e.on[e.on.length - 1].dir : "asc" /* ASCENDING */;
                e.cn.push(new ds($.v(), t));
            }
        }
    }
    return e.cn;
}

/**
 * Converts this `Query` instance to it's corresponding `Target` representation.
 */ function Wn(t) {
    const e = v(t);
    if (!e.an) if ("F" /* First */ === e.un) e.an = Et(e.path, e.collectionGroup, jn(e), e.filters, e.limit, e.startAt, e.endAt); else {
        // Flip the orderBy directions since we want the last results
        const t = [];
        for (const n of jn(e)) {
            const e = "desc" /* DESCENDING */ === n.dir ? "asc" /* ASCENDING */ : "desc" /* DESCENDING */;
            t.push(new ds(n.field, e));
        }
        // We need to swap the cursors to match the now-flipped query ordering.
                const n = e.endAt ? new hs(e.endAt.position, !e.endAt.before) : null, s = e.startAt ? new hs(e.startAt.position, !e.startAt.before) : null;
        // Now return as a LimitType.First query.
        e.an = Et(e.path, e.collectionGroup, t, e.filters, e.limit, n, s);
    }
    return e.an;
}

function Gn(t, e, n) {
    return new On(t.path, t.collectionGroup, t.on.slice(), t.filters.slice(), e, n, t.startAt, t.endAt);
}

function zn(t, e) {
    return new On(t.path, t.collectionGroup, t.on.slice(), t.filters.slice(), t.limit, t.un, e, t.endAt);
}

function Kn(t, e) {
    return new On(t.path, t.collectionGroup, t.on.slice(), t.filters.slice(), t.limit, t.un, t.startAt, e);
}

function Hn(t, e) {
    return Rt(Wn(t), Wn(e)) && t.un === e.un;
}

// TODO(b/29183165): This is used to get a unique string from a query to, for
// example, use as a dictionary key, but the implementation is subject to
// collisions. Make it collision-free.
function Yn(t) {
    return `${It(Wn(t))}|lt:${t.un}`;
}

function Jn(t) {
    return `Query(target=${At(Wn(t))}; limitType=${t.un})`;
}

/** Returns whether `doc` matches the constraints of `query`. */ function Xn(t, e) {
    return function(t, e) {
        const n = e.key.path;
        return null !== t.collectionGroup ? e.key.F(t.collectionGroup) && t.path.T(n) : x.N(t.path) ? t.path.isEqual(n) : t.path.I(n);
    }
    /**
 * A document must have a value for every ordering clause in order to show up
 * in the results.
 */ (t, e) && function(t, e) {
        for (const n of t.on) 
        // order by key always matches
        if (!n.field.V() && null === e.field(n.field)) return !1;
        return !0;
    }(t, e) && function(t, e) {
        for (const n of t.filters) if (!n.matches(e)) return !1;
        return !0;
    }
    /** Makes sure a document is within the bounds, if provided. */ (t, e) && function(t, e) {
        if (t.startAt && !_s(t.startAt, jn(t), e)) return !1;
        if (t.endAt && _s(t.endAt, jn(t), e)) return !1;
        return !0;
    }
    /**
 * Returns a new comparator function that can be used to compare two documents
 * based on the Query's ordering constraint.
 */ (t, e);
}

function Zn(t) {
    return (e, n) => {
        let s = !1;
        for (const i of jn(t)) {
            const t = ws(i, e, n);
            if (0 !== t) return t;
            s = s || i.field.V();
        }
        return 0;
    };
}

class ts extends class {} {
    constructor(t, e, n) {
        super(), this.field = t, this.op = e, this.value = n;
    }
    /**
     * Creates a filter based on the provided arguments.
     */    static create(t, e, n) {
        if (t.V()) return "in" /* IN */ === e || "not-in" /* NOT_IN */ === e ? this.ln(t, e, n) : new ns(t, e, n);
        if (Ie(n)) {
            if ("==" /* EQUAL */ !== e && "!=" /* NOT_EQUAL */ !== e) throw new E(T.INVALID_ARGUMENT, "Invalid query. Null only supports '==' and '!=' comparisons.");
            return new ts(t, e, n);
        }
        if (Ae(n)) {
            if ("==" /* EQUAL */ !== e && "!=" /* NOT_EQUAL */ !== e) throw new E(T.INVALID_ARGUMENT, "Invalid query. NaN only supports '==' and '!=' comparisons.");
            return new ts(t, e, n);
        }
        return "array-contains" /* ARRAY_CONTAINS */ === e ? new os(t, n) : "in" /* IN */ === e ? new us(t, n) : "not-in" /* NOT_IN */ === e ? new cs(t, n) : "array-contains-any" /* ARRAY_CONTAINS_ANY */ === e ? new as(t, n) : new ts(t, e, n);
    }
    static ln(t, e, n) {
        return "in" /* IN */ === e ? new ss(t, n) : new is(t, n);
    }
    matches(t) {
        const e = t.field(this.field);
        // Types do not have to match in NOT_EQUAL filters.
                return "!=" /* NOT_EQUAL */ === this.op ? null !== e && this._n(ae(e, this.value)) : null !== e && oe(this.value) === oe(e) && this._n(ae(e, this.value));
        // Only compare types with matching backend order (such as double and int).
        }
    _n(t) {
        switch (this.op) {
          case "<" /* LESS_THAN */ :
            return t < 0;

          case "<=" /* LESS_THAN_OR_EQUAL */ :
            return t <= 0;

          case "==" /* EQUAL */ :
            return 0 === t;

          case "!=" /* NOT_EQUAL */ :
            return 0 !== t;

          case ">" /* GREATER_THAN */ :
            return t > 0;

          case ">=" /* GREATER_THAN_OR_EQUAL */ :
            return t >= 0;

          default:
            return p();
        }
    }
    hn() {
        return [ "<" /* LESS_THAN */ , "<=" /* LESS_THAN_OR_EQUAL */ , ">" /* GREATER_THAN */ , ">=" /* GREATER_THAN_OR_EQUAL */ , "!=" /* NOT_EQUAL */ , "not-in" /* NOT_IN */ ].indexOf(this.op) >= 0;
    }
}

function es(t) {
    // TODO(b/29183165): Technically, this won't be unique if two values have
    // the same description, such as the int 3 and the string "3". So we should
    // add the types in here somehow, too.
    return t.field.R() + t.op.toString() + le(t.value);
}

class ns extends ts {
    constructor(t, e, n) {
        super(t, e, n), this.key = x.C(n.referenceValue);
    }
    matches(t) {
        const e = x.i(t.key, this.key);
        return this._n(e);
    }
}

/** Filter that matches on key fields within an array. */ class ss extends ts {
    constructor(t, e) {
        super(t, "in" /* IN */ , e), this.keys = rs("in" /* IN */ , e);
    }
    matches(t) {
        return this.keys.some((e => e.isEqual(t.key)));
    }
}

/** Filter that matches on key fields not present within an array. */ class is extends ts {
    constructor(t, e) {
        super(t, "not-in" /* NOT_IN */ , e), this.keys = rs("not-in" /* NOT_IN */ , e);
    }
    matches(t) {
        return !this.keys.some((e => e.isEqual(t.key)));
    }
}

function rs(t, e) {
    var n;
    return ((null === (n = e.arrayValue) || void 0 === n ? void 0 : n.values) || []).map((t => x.C(t.referenceValue)));
}

/** A Filter that implements the array-contains operator. */ class os extends ts {
    constructor(t, e) {
        super(t, "array-contains" /* ARRAY_CONTAINS */ , e);
    }
    matches(t) {
        const e = t.field(this.field);
        return Ee(e) && ce(e.arrayValue, this.value);
    }
}

/** A Filter that implements the IN operator. */ class us extends ts {
    constructor(t, e) {
        super(t, "in" /* IN */ , e);
    }
    matches(t) {
        const e = t.field(this.field);
        return null !== e && ce(this.value.arrayValue, e);
    }
}

/** A Filter that implements the not-in operator. */ class cs extends ts {
    constructor(t, e) {
        super(t, "not-in" /* NOT_IN */ , e);
    }
    matches(t) {
        if (ce(this.value.arrayValue, {
            nullValue: "NULL_VALUE"
        })) return !1;
        const e = t.field(this.field);
        return null !== e && !ce(this.value.arrayValue, e);
    }
}

/** A Filter that implements the array-contains-any operator. */ class as extends ts {
    constructor(t, e) {
        super(t, "array-contains-any" /* ARRAY_CONTAINS_ANY */ , e);
    }
    matches(t) {
        const e = t.field(this.field);
        return !(!Ee(e) || !e.arrayValue.values) && e.arrayValue.values.some((t => ce(this.value.arrayValue, t)));
    }
}

/**
 * Represents a bound of a query.
 *
 * The bound is specified with the given components representing a position and
 * whether it's just before or just after the position (relative to whatever the
 * query order is).
 *
 * The position represents a logical index position for a query. It's a prefix
 * of values for the (potentially implicit) order by clauses of a query.
 *
 * Bound provides a function to determine whether a document comes before or
 * after a bound. This is influenced by whether the position is just before or
 * just after the provided values.
 */ class hs {
    constructor(t, e) {
        this.position = t, this.before = e;
    }
}

function ls(t) {
    // TODO(b/29183165): Make this collision robust.
    return `${t.before ? "b" : "a"}:${t.position.map((t => le(t))).join(",")}`;
}

/**
 * Returns true if a document sorts before a bound using the provided sort
 * order.
 */ function _s(t, e, n) {
    let s = 0;
    for (let i = 0; i < t.position.length; i++) {
        const r = e[i], o = t.position[i];
        if (r.field.V()) s = x.i(x.C(o.referenceValue), n.key); else {
            s = ae(o, n.field(r.field));
        }
        if ("desc" /* DESCENDING */ === r.dir && (s *= -1), 0 !== s) break;
    }
    return t.before ? s <= 0 : s < 0;
}

function fs(t, e) {
    if (null === t) return null === e;
    if (null === e) return !1;
    if (t.before !== e.before || t.position.length !== e.position.length) return !1;
    for (let n = 0; n < t.position.length; n++) {
        if (!ue(t.position[n], e.position[n])) return !1;
    }
    return !0;
}

/**
 * An ordering on a field, in some Direction. Direction defaults to ASCENDING.
 */ class ds {
    constructor(t, e = "asc" /* ASCENDING */) {
        this.field = t, this.dir = e;
    }
}

function ws(t, e, n) {
    const s = t.field.V() ? x.i(e.key, n.key) : function(t, e, n) {
        const s = e.field(t), i = n.field(t);
        return null !== s && null !== i ? ae(s, i) : p();
    }(t.field, e, n);
    switch (t.dir) {
      case "asc" /* ASCENDING */ :
        return s;

      case "desc" /* DESCENDING */ :
        return -1 * s;

      default:
        return p();
    }
}

function ms(t, e) {
    return t.dir === e.dir && t.field.isEqual(e.field);
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ class Ts {
    constructor() {
        this.promise = new Promise(((t, e) => {
            this.resolve = t, this.reject = e;
        }));
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A helper for running delayed tasks following an exponential backoff curve
 * between attempts.
 *
 * Each delay is made up of a "base" delay which follows the exponential
 * backoff curve, and a +/- 50% "jitter" that is calculated and added to the
 * base delay. This prevents clients from accidentally synchronizing their
 * delays causing spikes of load to the backend.
 */
class Es {
    constructor(
    /**
     * The AsyncQueue to run backoff operations on.
     */
    t, 
    /**
     * The ID to use when scheduling backoff operations on the AsyncQueue.
     */
    e, 
    /**
     * The initial delay (used as the base delay on the first retry attempt).
     * Note that jitter will still be applied, so the actual delay could be as
     * little as 0.5*initialDelayMs.
     */
    n = 1e3
    /**
     * The multiplier to use to determine the extended base delay after each
     * attempt.
     */ , s = 1.5
    /**
     * The maximum base delay after which no further backoff is performed.
     * Note that jitter will still be applied, so the actual delay could be as
     * much as 1.5*maxDelayMs.
     */ , i = 6e4) {
        this.fn = t, this.dn = e, this.wn = n, this.mn = s, this.Tn = i, this.En = 0, this.In = null, 
        /** The last backoff attempt, as epoch milliseconds. */
        this.An = Date.now(), this.reset();
    }
    /**
     * Resets the backoff delay.
     *
     * The very next backoffAndWait() will have no delay. If it is called again
     * (i.e. due to an error), initialDelayMs (plus jitter) will be used, and
     * subsequent ones will increase according to the backoffFactor.
     */    reset() {
        this.En = 0;
    }
    /**
     * Resets the backoff delay to the maximum delay (e.g. for use after a
     * RESOURCE_EXHAUSTED error).
     */    Rn() {
        this.En = this.Tn;
    }
    /**
     * Returns a promise that resolves after currentDelayMs, and increases the
     * delay for any subsequent attempts. If there was a pending backoff operation
     * already, it will be canceled.
     */    yn(t) {
        // Cancel any pending backoff operation.
        this.cancel();
        // First schedule using the current base (which may be 0 and should be
        // honored as such).
        const e = Math.floor(this.En + this.Pn()), n = Math.max(0, Date.now() - this.An), s = Math.max(0, e - n);
        // Guard against lastAttemptTime being in the future due to a clock change.
                s > 0 && R("ExponentialBackoff", `Backing off for ${s} ms (base delay: ${this.En} ms, delay with jitter: ${e} ms, last attempt: ${n} ms ago)`), 
        this.In = this.fn.gn(this.dn, s, (() => (this.An = Date.now(), t()))), 
        // Apply backoff factor to determine next delay and ensure it is within
        // bounds.
        this.En *= this.mn, this.En < this.wn && (this.En = this.wn), this.En > this.Tn && (this.En = this.Tn);
    }
    pn() {
        null !== this.In && (this.In.Vn(), this.In = null);
    }
    cancel() {
        null !== this.In && (this.In.cancel(), this.In = null);
    }
    /** Returns a random value in the range [-currentBaseMs/2, currentBaseMs/2] */    Pn() {
        return (Math.random() - .5) * this.En;
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * PersistencePromise<> is essentially a re-implementation of Promise<> except
 * it has a .next() method instead of .then() and .next() and .catch() callbacks
 * are executed synchronously when a PersistencePromise resolves rather than
 * asynchronously (Promise<> implementations use setImmediate() or similar).
 *
 * This is necessary to interoperate with IndexedDB which will automatically
 * commit transactions if control is returned to the event loop without
 * synchronously initiating another operation on the transaction.
 *
 * NOTE: .then() and .catch() only allow a single consumer, unlike normal
 * Promises.
 */ class Is {
    constructor(t) {
        // NOTE: next/catchCallback will always point to our own wrapper functions,
        // not the user's raw next() or catch() callbacks.
        this.vn = null, this.bn = null, 
        // When the operation resolves, we'll set result or error and mark isDone.
        this.result = void 0, this.error = void 0, this.Sn = !1, 
        // Set to true when .then() or .catch() are called and prevents additional
        // chaining.
        this.Dn = !1, t((t => {
            this.Sn = !0, this.result = t, this.vn && 
            // value should be defined unless T is Void, but we can't express
            // that in the type system.
            this.vn(t);
        }), (t => {
            this.Sn = !0, this.error = t, this.bn && this.bn(t);
        }));
    }
    catch(t) {
        return this.next(void 0, t);
    }
    next(t, e) {
        return this.Dn && p(), this.Dn = !0, this.Sn ? this.error ? this.Cn(e, this.error) : this.Fn(t, this.result) : new Is(((n, s) => {
            this.vn = e => {
                this.Fn(t, e).next(n, s);
            }, this.bn = t => {
                this.Cn(e, t).next(n, s);
            };
        }));
    }
    Nn() {
        return new Promise(((t, e) => {
            this.next(t, e);
        }));
    }
    $n(t) {
        try {
            const e = t();
            return e instanceof Is ? e : Is.resolve(e);
        } catch (t) {
            return Is.reject(t);
        }
    }
    Fn(t, e) {
        return t ? this.$n((() => t(e))) : Is.resolve(e);
    }
    Cn(t, e) {
        return t ? this.$n((() => t(e))) : Is.reject(e);
    }
    static resolve(t) {
        return new Is(((e, n) => {
            e(t);
        }));
    }
    static reject(t) {
        return new Is(((e, n) => {
            n(t);
        }));
    }
    static xn(
    // Accept all Promise types in waitFor().
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    t) {
        return new Is(((e, n) => {
            let s = 0, i = 0, r = !1;
            t.forEach((t => {
                ++s, t.next((() => {
                    ++i, r && i === s && e();
                }), (t => n(t)));
            })), r = !0, i === s && e();
        }));
    }
    /**
     * Given an array of predicate functions that asynchronously evaluate to a
     * boolean, implements a short-circuiting `or` between the results. Predicates
     * will be evaluated until one of them returns `true`, then stop. The final
     * result will be whether any of them returned `true`.
     */    static kn(t) {
        let e = Is.resolve(!1);
        for (const n of t) e = e.next((t => t ? Is.resolve(t) : n()));
        return e;
    }
    static forEach(t, e) {
        const n = [];
        return t.forEach(((t, s) => {
            n.push(e.call(this, t, s));
        })), this.xn(n);
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** Verifies whether `e` is an IndexedDbTransactionError. */ function As(t) {
    // Use name equality, as instanceof checks on errors don't work with errors
    // that wrap other errors.
    return "IndexedDbTransactionError" === t.name;
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** The Platform's 'document' implementation or null if not available. */ function Rs() {
    // `document` is not always available, e.g. in ReactNative and WebWorkers.
    // eslint-disable-next-line no-restricted-globals
    return "undefined" != typeof document ? document : null;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Represents an operation scheduled to be run in the future on an AsyncQueue.
 *
 * It is created via DelayedOperation.createAndSchedule().
 *
 * Supports cancellation (via cancel()) and early execution (via skipDelay()).
 *
 * Note: We implement `PromiseLike` instead of `Promise`, as the `Promise` type
 * in newer versions of TypeScript defines `finally`, which is not available in
 * IE.
 */
class ys {
    constructor(t, e, n, s, i) {
        this.On = t, this.dn = e, this.Ln = n, this.op = s, this.Mn = i, this.qn = new Ts, 
        this.then = this.qn.promise.then.bind(this.qn.promise), 
        // It's normal for the deferred promise to be canceled (due to cancellation)
        // and so we attach a dummy catch callback to avoid
        // 'UnhandledPromiseRejectionWarning' log spam.
        this.qn.promise.catch((t => {}));
    }
    /**
     * Creates and returns a DelayedOperation that has been scheduled to be
     * executed on the provided asyncQueue after the provided delayMs.
     *
     * @param asyncQueue The queue to schedule the operation on.
     * @param id A Timer ID identifying the type of operation this is.
     * @param delayMs The delay (ms) before the operation should be scheduled.
     * @param op The operation to run.
     * @param removalCallback A callback to be called synchronously once the
     *   operation is executed or canceled, notifying the AsyncQueue to remove it
     *   from its delayedOperations list.
     *   PORTING NOTE: This exists to prevent making removeDelayedOperation() and
     *   the DelayedOperation class public.
     */    static Un(t, e, n, s, i) {
        const r = Date.now() + n, o = new ys(t, e, r, s, i);
        return o.start(n), o;
    }
    /**
     * Starts the timer. This is called immediately after construction by
     * createAndSchedule().
     */    start(t) {
        this.Bn = setTimeout((() => this.Qn()), t);
    }
    /**
     * Queues the operation to run immediately (if it hasn't already been run or
     * canceled).
     */    Vn() {
        return this.Qn();
    }
    /**
     * Cancels the operation if it hasn't already been executed or canceled. The
     * promise will be rejected.
     *
     * As long as the operation has not yet been run, calling cancel() provides a
     * guarantee that the operation will not be run.
     */    cancel(t) {
        null !== this.Bn && (this.clearTimeout(), this.qn.reject(new E(T.CANCELLED, "Operation cancelled" + (t ? ": " + t : ""))));
    }
    Qn() {
        this.On.jn((() => null !== this.Bn ? (this.clearTimeout(), this.op().then((t => this.qn.resolve(t)))) : Promise.resolve()));
    }
    clearTimeout() {
        null !== this.Bn && (this.Mn(this), clearTimeout(this.Bn), this.Bn = null);
    }
}

class Ps {
    constructor() {
        // The last promise in the queue.
        this.Wn = Promise.resolve(), 
        // A list of retryable operations. Retryable operations are run in order and
        // retried with backoff.
        this.Gn = [], 
        // Is this AsyncQueue being shut down? Once it is set to true, it will not
        // be changed again.
        this.zn = !1, 
        // Operations scheduled to be queued in the future. Operations are
        // automatically removed after they are run or canceled.
        this.Kn = [], 
        // visible for testing
        this.Hn = null, 
        // Flag set while there's an outstanding AsyncQueue operation, used for
        // assertion sanity-checks.
        this.Yn = !1, 
        // List of TimerIds to fast-forward delays for.
        this.Jn = [], 
        // Backoff timer used to schedule retries for retryable operations
        this.Xn = new Es(this, "async_queue_retry" /* AsyncQueueRetry */), 
        // Visibility handler that triggers an immediate retry of all retryable
        // operations. Meant to speed up recovery when we regain file system access
        // after page comes into foreground.
        this.Zn = () => {
            const t = Rs();
            t && R("AsyncQueue", "Visibility state changed to  ", t.visibilityState), this.Xn.pn();
        };
        const t = Rs();
        t && "function" == typeof t.addEventListener && t.addEventListener("visibilitychange", this.Zn);
    }
    // Is this AsyncQueue being shut down? If true, this instance will not enqueue
    // any new operations, Promises from enqueue requests will not resolve.
    get ts() {
        return this.zn;
    }
    /**
     * Adds a new operation to the queue without waiting for it to complete (i.e.
     * we ignore the Promise result).
     */    jn(t) {
        // eslint-disable-next-line @typescript-eslint/no-floating-promises
        this.enqueue(t);
    }
    /**
     * Regardless if the queue has initialized shutdown, adds a new operation to the
     * queue without waiting for it to complete (i.e. we ignore the Promise result).
     */    es(t) {
        this.ns(), 
        // eslint-disable-next-line @typescript-eslint/no-floating-promises
        this.ss(t);
    }
    /**
     * Initialize the shutdown of this queue. Once this method is called, the
     * only possible way to request running an operation is through
     * `enqueueEvenWhileRestricted()`.
     */    rs() {
        if (!this.zn) {
            this.zn = !0;
            const t = Rs();
            t && "function" == typeof t.removeEventListener && t.removeEventListener("visibilitychange", this.Zn);
        }
    }
    /**
     * Adds a new operation to the queue. Returns a promise that will be resolved
     * when the promise returned by the new operation is (with its value).
     */    enqueue(t) {
        return this.ns(), this.zn ? new Promise((t => {})) : this.ss(t);
    }
    /**
     * Enqueue a retryable operation.
     *
     * A retryable operation is rescheduled with backoff if it fails with a
     * IndexedDbTransactionError (the error type used by SimpleDb). All
     * retryable operations are executed in order and only run if all prior
     * operations were retried successfully.
     */    os(t) {
        this.jn((() => (this.Gn.push(t), this.us())));
    }
    /**
     * Runs the next operation from the retryable queue. If the operation fails,
     * reschedules with backoff.
     */    async us() {
        if (0 !== this.Gn.length) {
            try {
                await this.Gn[0](), this.Gn.shift(), this.Xn.reset();
            } catch (t) {
                if (!As(t)) throw t;
 // Failure will be handled by AsyncQueue
                                R("AsyncQueue", "Operation failed with retryable error: " + t);
            }
            this.Gn.length > 0 && 
            // If there are additional operations, we re-schedule `retryNextOp()`.
            // This is necessary to run retryable operations that failed during
            // their initial attempt since we don't know whether they are already
            // enqueued. If, for example, `op1`, `op2`, `op3` are enqueued and `op1`
            // needs to  be re-run, we will run `op1`, `op1`, `op2` using the
            // already enqueued calls to `retryNextOp()`. `op3()` will then run in the
            // call scheduled here.
            // Since `backoffAndRun()` cancels an existing backoff and schedules a
            // new backoff on every call, there is only ever a single additional
            // operation in the queue.
            this.Xn.yn((() => this.us()));
        }
    }
    ss(t) {
        const e = this.Wn.then((() => (this.Yn = !0, t().catch((t => {
            this.Hn = t, this.Yn = !1;
            // Re-throw the error so that this.tail becomes a rejected Promise and
            // all further attempts to chain (via .then) will just short-circuit
            // and return the rejected Promise.
            throw y("INTERNAL UNHANDLED ERROR: ", 
            /**
 * Chrome includes Error.message in Error.stack. Other browsers do not.
 * This returns expected output of message + stack when available.
 * @param error Error or FirestoreError
 */
            function(t) {
                let e = t.message || "";
                t.stack && (e = t.stack.includes(t.message) ? t.stack : t.message + "\n" + t.stack);
                return e;
            }
            /**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
            /**
 * Holds the listeners and the last received ViewSnapshot for a query being
 * tracked by EventManager.
 */ (t)), t;
        })).then((t => (this.Yn = !1, t))))));
        return this.Wn = e, e;
    }
    /**
     * Schedules an operation to be queued on the AsyncQueue once the specified
     * `delayMs` has elapsed. The returned DelayedOperation can be used to cancel
     * or fast-forward the operation prior to its running.
     */    gn(t, e, n) {
        this.ns(), 
        // Fast-forward delays for timerIds that have been overriden.
        this.Jn.indexOf(t) > -1 && (e = 0);
        const s = ys.Un(this, t, e, n, (t => this.cs(t)));
        return this.Kn.push(s), s;
    }
    ns() {
        this.Hn && p();
    }
    /**
     * Verifies there's an operation currently in-progress on the AsyncQueue.
     * Unfortunately we can't verify that the running code is in the promise chain
     * of that operation, so this isn't a foolproof check, but it should be enough
     * to catch some bugs.
     */    hs() {}
    /**
     * Waits until all currently queued tasks are finished executing. Delayed
     * operations are not run.
     */    async ls() {
        // Operations in the queue prior to draining may have enqueued additional
        // operations. Keep draining the queue until the tail is no longer advanced,
        // which indicates that no more new operations were enqueued and that all
        // operations were executed.
        let t;
        do {
            t = this.Wn, await t;
        } while (t !== this.Wn);
    }
    /**
     * For Tests: Determine if a delayed operation with a particular TimerId
     * exists.
     */    _s(t) {
        for (const e of this.Kn) if (e.dn === t) return !0;
        return !1;
    }
    /**
     * For Tests: Runs some or all delayed operations early.
     *
     * @param lastTimerId Delayed operations up to and including this TimerId will
     *  be drained. Pass TimerId.All to run all delayed operations.
     * @returns a Promise that resolves once all operations have been run.
     */    fs(t) {
        // Note that draining may generate more delayed ops, so we do that first.
        return this.ls().then((() => {
            // Run ops in the same order they'd run if they ran naturally.
            this.Kn.sort(((t, e) => t.Ln - e.Ln));
            for (const e of this.Kn) if (e.Vn(), "all" /* All */ !== t && e.dn === t) break;
            return this.ls();
        }));
    }
    /**
     * For Tests: Skip all subsequent delays for a timer id.
     */    ds(t) {
        this.Jn.push(t);
    }
    /** Called once a DelayedOperation is run or canceled. */    cs(t) {
        // NOTE: indexOf / slice are O(n), but delayedOperations is expected to be small.
        const e = this.Kn.indexOf(t);
        this.Kn.splice(e, 1);
    }
}

/**
 * Returns a FirestoreError that can be surfaced to the user if the provided
 * error is an IndexedDbTransactionError. Re-throws the error otherwise.
 */ function gs(t, e) {
    if (y("AsyncQueue", `${e}: ${t}`), As(t)) return new E(T.UNAVAILABLE, `${e}: ${t}`);
    throw t;
}

class ps {
    constructor() {
        this.ws = void 0, this.listeners = [];
    }
}

class Vs {
    constructor() {
        this.Ts = new _t((t => Yn(t)), Hn), this.onlineState = "Unknown" /* Unknown */ , 
        this.Es = new Set;
    }
}

async function vs(t, e) {
    const n = v(t), s = e.query;
    let i = !1, r = n.Ts.get(s);
    if (r || (i = !0, r = new ps), i) try {
        r.ws = await n.Is(s);
    } catch (t) {
        const n = gs(t, `Initialization of query '${Jn(e.query)}' failed`);
        return void e.onError(n);
    }
    n.Ts.set(s, r), r.listeners.push(e);
    // Run global snapshot listeners if a consistent snapshot has been emitted.
    e.As(n.onlineState);
    if (r.ws) {
        e.Rs(r.ws) && Cs(n);
    }
}

async function bs(t, e) {
    const n = v(t), s = e.query;
    let i = !1;
    const r = n.Ts.get(s);
    if (r) {
        const t = r.listeners.indexOf(e);
        t >= 0 && (r.listeners.splice(t, 1), i = 0 === r.listeners.length);
    }
    if (i) return n.Ts.delete(s), n.ys(s);
}

function Ss(t, e) {
    const n = v(t);
    let s = !1;
    for (const t of e) {
        const e = t.query, i = n.Ts.get(e);
        if (i) {
            for (const e of i.listeners) e.Rs(t) && (s = !0);
            i.ws = t;
        }
    }
    s && Cs(n);
}

function Ds(t, e, n) {
    const s = v(t), i = s.Ts.get(e);
    if (i) for (const t of i.listeners) t.onError(n);
    // Remove all listeners. NOTE: We don't need to call syncEngine.unlisten()
    // after an error.
        s.Ts.delete(e);
}

// Call all global snapshot listeners that have been set.
function Cs(t) {
    t.Es.forEach((t => {
        t.next();
    }));
}

/**
 * QueryListener takes a series of internal view snapshots and determines
 * when to raise the event.
 *
 * It uses an Observer to dispatch events.
 */ class Fs {
    constructor(t, e, n) {
        this.query = t, this.Ps = e, 
        /**
         * Initial snapshots (e.g. from cache) may not be propagated to the wrapped
         * observer. This flag is set to true once we've actually raised an event.
         */
        this.gs = !1, this.ps = null, this.onlineState = "Unknown" /* Unknown */ , this.options = n || {};
    }
    /**
     * Applies the new ViewSnapshot to this listener, raising a user-facing event
     * if applicable (depending on what changed, whether the user has opted into
     * metadata-only changes, etc.). Returns true if a user-facing event was
     * indeed raised.
     */    Rs(t) {
        if (!this.options.includeMetadataChanges) {
            // Remove the metadata only changes.
            const e = [];
            for (const n of t.docChanges) 3 /* Metadata */ !== n.type && e.push(n);
            t = new Gt(t.query, t.docs, t.Qt, e, t.jt, t.fromCache, t.Wt, 
            /* excludesMetadataChanges= */ !0);
        }
        let e = !1;
        return this.gs ? this.Vs(t) && (this.Ps.next(t), e = !0) : this.vs(t, this.onlineState) && (this.bs(t), 
        e = !0), this.ps = t, e;
    }
    onError(t) {
        this.Ps.error(t);
    }
    /** Returns whether a snapshot was raised. */    As(t) {
        this.onlineState = t;
        let e = !1;
        return this.ps && !this.gs && this.vs(this.ps, t) && (this.bs(this.ps), e = !0), 
        e;
    }
    vs(t, e) {
        // Always raise the first event when we're synced
        if (!t.fromCache) return !0;
        // NOTE: We consider OnlineState.Unknown as online (it should become Offline
        // or Online if we wait long enough).
                const n = "Offline" /* Offline */ !== e;
        // Don't raise the event if we're online, aren't synced yet (checked
        // above) and are waiting for a sync.
                return (!this.options.Ss || !n) && (!t.docs.m() || "Offline" /* Offline */ === e);
        // Raise data from cache if we have any documents or we are offline
        }
    Vs(t) {
        // We don't need to handle includeDocumentMetadataChanges here because
        // the Metadata only changes have already been stripped out if needed.
        // At this point the only changes we will see are the ones we should
        // propagate.
        if (t.docChanges.length > 0) return !0;
        const e = this.ps && this.ps.hasPendingWrites !== t.hasPendingWrites;
        return !(!t.Wt && !e) && !0 === this.options.includeMetadataChanges;
        // Generally we should have hit one of the cases above, but it's possible
        // to get here if there were only metadata docChanges and they got
        // stripped out.
        }
    bs(t) {
        t = Gt.zt(t.query, t.docs, t.jt, t.fromCache), this.gs = !0, this.Ps.next(t);
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Simple wrapper around a nullable UID. Mostly exists to make code more
 * readable.
 */ class Ns {
    constructor(t) {
        this.uid = t;
    }
    Ds() {
        return null != this.uid;
    }
    /**
     * Returns a key representing this user, suitable for inclusion in a
     * dictionary.
     */    Cs() {
        return this.Ds() ? "uid:" + this.uid : "anonymous-user";
    }
    isEqual(t) {
        return t.uid === this.uid;
    }
}

/** A user with a null UID. */ Ns.UNAUTHENTICATED = new Ns(null), 
// TODO(mikelehen): Look into getting a proper uid-equivalent for
// non-FirebaseAuth providers.
Ns.Fs = new Ns("google-credentials-uid"), Ns.Ns = new Ns("first-party-uid");

/**
 * @license
 * Copyright 2018 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * `ListenSequence` is a monotonic sequence. It is initialized with a minimum value to
 * exceed. All subsequent calls to next will return increasing values. If provided with a
 * `SequenceNumberSyncer`, it will additionally bump its next value when told of a new value, as
 * well as write out sequence numbers that it produces via `next()`.
 */
class $s {
    constructor(t, e) {
        this.previousValue = t, e && (e.$s = t => this.xs(t), this.ks = t => e.Os(t));
    }
    xs(t) {
        return this.previousValue = Math.max(t, this.previousValue), this.previousValue;
    }
    next() {
        const t = ++this.previousValue;
        return this.ks && this.ks(t), t;
    }
}

$s.Ls = -1;

/**
 * @license
 * Copyright 2018 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Metadata state of the local client. Unlike `RemoteClientState`, this class is
 * mutable and keeps track of all pending mutations, which allows us to
 * update the range of pending mutation batch IDs as new mutations are added or
 * removed.
 *
 * The data in `LocalClientState` is not read from WebStorage and instead
 * updated via its instance methods. The updated state can be serialized via
 * `toWebStorageJSON()`.
 */
// Visible for testing.
class xs {
    constructor() {
        this.activeTargetIds = Qt();
    }
    Ms(t) {
        this.activeTargetIds = this.activeTargetIds.add(t);
    }
    qs(t) {
        this.activeTargetIds = this.activeTargetIds.delete(t);
    }
    /**
     * Converts this entry into a JSON-encoded format we can use for WebStorage.
     * Does not encode `clientId` as it is part of the key in WebStorage.
     */    Us() {
        const t = {
            activeTargetIds: this.activeTargetIds.A(),
            updateTimeMs: Date.now()
        };
        return JSON.stringify(t);
    }
}

/**
 * `MemorySharedClientState` is a simple implementation of SharedClientState for
 * clients using memory persistence. The state in this class remains fully
 * isolated and no synchronization is performed.
 */ class ks {
    constructor() {
        this.Bs = new xs, this.Qs = {}, this.js = null, this.$s = null;
    }
    Ws(t) {
        // No op.
    }
    Gs(t, e, n) {
        // No op.
    }
    zs(t) {
        return this.Bs.Ms(t), this.Qs[t] || "not-current";
    }
    Ks(t, e, n) {
        this.Qs[t] = e;
    }
    Hs(t) {
        this.Bs.qs(t);
    }
    Ys(t) {
        return this.Bs.activeTargetIds.has(t);
    }
    Js(t) {
        delete this.Qs[t];
    }
    Xs() {
        return this.Bs.activeTargetIds;
    }
    Zs(t) {
        return this.Bs.activeTargetIds.has(t);
    }
    start() {
        return this.Bs = new xs, Promise.resolve();
    }
    ti(t, e, n) {
        // No op.
    }
    ei(t) {
        // No op.
    }
    ni() {}
    Os(t) {}
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A batch of mutations that will be sent as one unit to the backend.
 */
class Os {
    /**
     * @param batchId The unique ID of this mutation batch.
     * @param localWriteTime The original write time of this mutation.
     * @param baseMutations Mutations that are used to populate the base
     * values when this mutation is applied locally. This can be used to locally
     * overwrite values that are persisted in the remote document cache. Base
     * mutations are never sent to the backend.
     * @param mutations The user-provided mutations in this mutation batch.
     * User-provided mutations are applied both locally and remotely on the
     * backend.
     */
    constructor(t, e, n, s) {
        this.batchId = t, this.si = e, this.baseMutations = n, this.mutations = s;
    }
    /**
     * Applies all the mutations in this MutationBatch to the specified document
     * to create a new remote document
     *
     * @param docKey The key of the document to apply mutations to.
     * @param maybeDoc The document to apply mutations to.
     * @param batchResult The result of applying the MutationBatch to the
     * backend.
     */    ii(t, e, n) {
        const s = n.ri;
        for (let n = 0; n < this.mutations.length; n++) {
            const i = this.mutations[n];
            if (i.key.isEqual(t)) {
                e = Tn(i, e, s[n]);
            }
        }
        return e;
    }
    /**
     * Computes the local view of a document given all the mutations in this
     * batch.
     *
     * @param docKey The key of the document to apply mutations to.
     * @param maybeDoc The document to apply mutations to.
     */    oi(t, e) {
        // First, apply the base state. This allows us to apply non-idempotent
        // transform against a consistent set of values.
        for (const n of this.baseMutations) n.key.isEqual(t) && (e = En(n, e, e, this.si));
        const n = e;
        // Second, apply all user-provided mutations.
                for (const s of this.mutations) s.key.isEqual(t) && (e = En(s, e, n, this.si));
        return e;
    }
    /**
     * Computes the local view for all provided documents given the mutations in
     * this batch.
     */    ui(t) {
        // TODO(mrschmidt): This implementation is O(n^2). If we apply the mutations
        // directly (as done in `applyToLocalView()`), we can reduce the complexity
        // to O(n).
        let e = t;
        return this.mutations.forEach((n => {
            const s = this.oi(n.key, t.get(n.key));
            s && (e = e.ot(n.key, s));
        })), e;
    }
    keys() {
        return this.mutations.reduce(((t, e) => t.add(e.key)), Ut());
    }
    isEqual(t) {
        return this.batchId === t.batchId && rt(this.mutations, t.mutations, ((t, e) => An(t, e))) && rt(this.baseMutations, t.baseMutations, ((t, e) => An(t, e)));
    }
}

/** The result of applying a mutation batch to the backend. */ class Ls {
    constructor(t, e, n, 
    /**
     * A pre-computed mapping from each mutated document to the resulting
     * version.
     */
    s) {
        this.batch = t, this.ci = e, this.ri = n, this.ai = s;
    }
    /**
     * Creates a new MutationBatchResult for the given batch and results. There
     * must be one result for each mutation in the batch. This static factory
     * caches a document=>version mapping (docVersions).
     */    static from(t, e, n) {
        V(t.mutations.length === n.length);
        let s = Mt;
        const i = t.mutations;
        for (let t = 0; t < i.length; t++) s = s.ot(i[t].key, n[t].version);
        return new Ls(t, e, n, s);
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * An in-memory buffer of entries to be written to a RemoteDocumentCache.
 * It can be used to batch up a set of changes to be written to the cache, but
 * additionally supports reading entries back with the `getEntry()` method,
 * falling back to the underlying RemoteDocumentCache if no entry is
 * buffered.
 *
 * Entries added to the cache *must* be read first. This is to facilitate
 * calculating the size delta of the pending changes.
 *
 * PORTING NOTE: This class was implemented then removed from other platforms.
 * If byte-counting ends up being needed on the other platforms, consider
 * porting this class as part of that implementation work.
 */
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A readonly view of the local state of all documents we're tracking (i.e. we
 * have a cached version in remoteDocumentCache or local mutations for the
 * document). The view is computed by applying the mutations in the
 * MutationQueue to the RemoteDocumentCache.
 */
class Ms {
    constructor(t, e, n) {
        this.hi = t, this.li = e, this._i = n;
    }
    /**
     * Get the local view of the document identified by `key`.
     *
     * @return Local view of the document or null if we don't have any cached
     * state for it.
     */    fi(t, e) {
        return this.li.di(t, e).next((n => this.wi(t, e, n)));
    }
    /** Internal version of `getDocument` that allows reusing batches. */    wi(t, e, n) {
        return this.hi.mi(t, e).next((t => {
            for (const s of n) t = s.oi(e, t);
            return t;
        }));
    }
    // Returns the view of the given `docs` as they would appear after applying
    // all mutations in the given `batches`.
    Ti(t, e, n) {
        let s = kt();
        return e.forEach(((t, e) => {
            for (const s of n) e = s.oi(t, e);
            s = s.ot(t, e);
        })), s;
    }
    /**
     * Gets the local view of the documents identified by `keys`.
     *
     * If we don't have cached state for a document in `keys`, a NoDocument will
     * be stored for that key in the resulting set.
     */    Ei(t, e) {
        return this.hi.getEntries(t, e).next((e => this.Ii(t, e)));
    }
    /**
     * Similar to `getDocuments`, but creates the local view from the given
     * `baseDocs` without retrieving documents from the local store.
     */    Ii(t, e) {
        return this.li.Ai(t, e).next((n => {
            const s = this.Ti(t, e, n);
            let i = xt();
            return s.forEach(((t, e) => {
                // TODO(http://b/32275378): Don't conflate missing / deleted.
                e || (e = new xn(t, dt.min())), i = i.ot(t, e);
            })), i;
        }));
    }
    /**
     * Performs a query against the local view of all documents.
     *
     * @param transaction The persistence transaction.
     * @param query The query to match documents against.
     * @param sinceReadTime If not set to SnapshotVersion.min(), return only
     *     documents that have been read since this snapshot version (exclusive).
     */    Ri(t, e, n) {
        /**
 * Returns whether the query matches a single document by path (rather than a
 * collection).
 */
        return function(t) {
            return x.N(t.path) && null === t.collectionGroup && 0 === t.filters.length;
        }(e) ? this.yi(t, e.path) : Qn(e) ? this.Pi(t, e, n) : this.gi(t, e, n);
    }
    yi(t, e) {
        // Just do a simple document lookup.
        return this.fi(t, new x(e)).next((t => {
            let e = Lt();
            return t instanceof $n && (e = e.ot(t.key, t)), e;
        }));
    }
    Pi(t, e, n) {
        const s = e.collectionGroup;
        let i = Lt();
        return this._i.pi(t, s).next((r => Is.forEach(r, (r => {
            const o = function(t, e) {
                return new On(e, 
                /*collectionGroup=*/ null, t.on.slice(), t.filters.slice(), t.limit, t.un, t.startAt, t.endAt);
            }
            /**
 * Returns true if this query does not specify any query constraints that
 * could remove results.
 */ (e, r.child(s));
            return this.gi(t, o, n).next((t => {
                t.forEach(((t, e) => {
                    i = i.ot(t, e);
                }));
            }));
        })).next((() => i))));
    }
    gi(t, e, n) {
        // Query the remote documents and overlay mutations.
        let s, i;
        return this.hi.Ri(t, e, n).next((n => (s = n, this.li.Vi(t, e)))).next((e => (i = e, 
        this.vi(t, i, s).next((t => {
            s = t;
            for (const t of i) for (const e of t.mutations) {
                const n = e.key, i = s.get(n), r = En(e, i, i, t.si);
                s = r instanceof $n ? s.ot(n, r) : s.remove(n);
            }
        }))))).next((() => (
        // Finally, filter out any documents that don't actually match
        // the query.
        s.forEach(((t, n) => {
            Xn(e, n) || (s = s.remove(t));
        })), s)));
    }
    vi(t, e, n) {
        let s = Ut();
        for (const t of e) for (const e of t.mutations) e instanceof Pn && null === n.get(e.key) && (s = s.add(e.key));
        let i = n;
        return this.hi.getEntries(t, s).next((t => (t.forEach(((t, e) => {
            null !== e && e instanceof $n && (i = i.ot(t, e));
        })), i)));
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A set of changes to what documents are currently in view and out of view for
 * a given query. These changes are sent to the LocalStore by the View (via
 * the SyncEngine) and are used to pin / unpin documents as appropriate.
 */ class qs {
    constructor(t, e, n, s) {
        this.targetId = t, this.fromCache = e, this.bi = n, this.Si = s;
    }
    static Di(t, e) {
        let n = Ut(), s = Ut();
        for (const t of e.docChanges) switch (t.type) {
          case 0 /* Added */ :
            n = n.add(t.doc.key);
            break;

          case 1 /* Removed */ :
            s = s.add(t.doc.key);
 // do nothing
                }
        return new qs(t, e.fromCache, n, s);
    }
}

/**
 * @license
 * Copyright 2018 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ class Us {
    constructor(
    // When we attempt to collect, we will only do so if the cache size is greater than this
    // threshold. Passing `COLLECTION_DISABLED` here will cause collection to always be skipped.
    t, 
    // The percentage of sequence numbers that we will attempt to collect
    e, 
    // A cap on the total number of sequence numbers that will be collected. This prevents
    // us from collecting a huge number of sequence numbers if the cache has grown very large.
    n) {
        this.Ci = t, this.Fi = e, this.Ni = n;
    }
    static $i(t) {
        return new Us(t, Us.xi, Us.ki);
    }
}

Us.Oi = -1, Us.Li = 1048576, Us.Mi = 41943040, Us.xi = 10, Us.ki = 1e3, Us.qi = new Us(Us.Mi, Us.xi, Us.ki), 
Us.Ui = new Us(Us.Oi, 0, 0);

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * An in-memory implementation of IndexManager.
 */
class Bs {
    constructor() {
        this.Bi = new Qs;
    }
    Qi(t, e) {
        return this.Bi.add(e), Is.resolve();
    }
    pi(t, e) {
        return Is.resolve(this.Bi.getEntries(e));
    }
}

/**
 * Internal implementation of the collection-parent index exposed by MemoryIndexManager.
 * Also used for in-memory caching by IndexedDbIndexManager and initial index population
 * in indexeddb_schema.ts
 */ class Qs {
    constructor() {
        this.index = {};
    }
    // Returns false if the entry already existed.
    add(t) {
        const e = t._(), n = t.h(), s = this.index[e] || new Ft(F.i), i = !s.has(n);
        return this.index[e] = s.add(n), i;
    }
    has(t) {
        const e = t._(), n = t.h(), s = this.index[e];
        return s && s.has(n);
    }
    getEntries(t) {
        return (this.index[t] || new Ft(F.i)).A();
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** Offset to ensure non-overlapping target ids. */
/**
 * Generates monotonically increasing target IDs for sending targets to the
 * watch stream.
 *
 * The client constructs two generators, one for the target cache, and one for
 * for the sync engine (to generate limbo documents targets). These
 * generators produce non-overlapping IDs (by using even and odd IDs
 * respectively).
 *
 * By separating the target ID space, the query cache can generate target IDs
 * that persist across client restarts, while sync engine can independently
 * generate in-memory target IDs that are transient and can be reused after a
 * restart.
 */
class js {
    constructor(t) {
        this.ji = t;
    }
    next() {
        return this.ji += 2, this.ji;
    }
    static Wi() {
        // The target cache generator must return '2' in its first call to `next()`
        // as there is no differentiation in the protocol layer between an unset
        // number and the number '0'. If we were to sent a target with target ID
        // '0', the backend would consider it unset and replace it with its own ID.
        return new js(0);
    }
    static Gi() {
        // Sync engine assigns target IDs for limbo document detection.
        return new js(-1);
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Implements `LocalStore` interface.
 *
 * Note: some field defined in this class might have public access level, but
 * the class is not exported so they are only accessible from this module.
 * This is useful to implement optional features (like bundles) in free
 * functions, such that they are tree-shakeable.
 */
class Ws {
    constructor(
    /** Manages our in-memory or durable persistence. */
    t, e, n) {
        this.persistence = t, this.zi = e, 
        /**
         * Maps a targetID to data about its target.
         *
         * PORTING NOTE: We are using an immutable data structure on Web to make re-runs
         * of `applyRemoteEvent()` idempotent.
         */
        this.Ki = new St(it), 
        /** Maps a target to its targetID. */
        // TODO(wuandy): Evaluate if TargetId can be part of Target.
        this.Hi = new _t((t => It(t)), Rt), 
        /**
         * The read time of the last entry processed by `getNewDocumentChanges()`.
         *
         * PORTING NOTE: This is only used for multi-tab synchronization.
         */
        this.Yi = dt.min(), this.li = t.Ji(n), this.Xi = t.Zi(), this.tr = t.er(), this.nr = new Ms(this.Xi, this.li, this.persistence.sr()), 
        this.zi.ir(this.nr);
    }
    rr(t) {
        return this.persistence.runTransaction("Collect garbage", "readwrite-primary", (e => t.ur(e, this.Ki)));
    }
}

/**
 * Acknowledges the given batch.
 *
 * On the happy path when a batch is acknowledged, the local store will
 *
 *  + remove the batch from the mutation queue;
 *  + apply the changes to the remote document cache;
 *  + recalculate the latency compensated view implied by those changes (there
 *    may be mutations in the queue that affect the documents but haven't been
 *    acknowledged yet); and
 *  + give the changed documents back the sync engine
 *
 * @returns The resulting (modified) documents.
 */
function Gs(t, e) {
    const n = v(t);
    return n.persistence.runTransaction("Acknowledge batch", "readwrite-primary", (t => {
        const s = e.batch.keys(), i = n.Xi.cr({
            ar: !0
        });
        return function(t, e, n, s) {
            const i = n.batch, r = i.keys();
            let o = Is.resolve();
            return r.forEach((t => {
                o = o.next((() => s.mi(e, t))).next((e => {
                    let r = e;
                    const o = n.ai.get(t);
                    V(null !== o), (!r || r.version.M(o) < 0) && (r = i.ii(t, r, n), r && 
                    // We use the commitVersion as the readTime rather than the
                    // document's updateTime since the updateTime is not advanced
                    // for updates that do not modify the underlying document.
                    s.hr(r, n.ci));
                }));
            })), o.next((() => t.li.lr(e, i)));
        }
        /**
 * Verifies the error thrown by a LocalStore operation. If a LocalStore
 * operation fails because the primary lease has been taken by another client,
 * we ignore the error (the persistence layer will immediately call
 * `applyPrimaryLease` to propagate the primary state change). All other errors
 * are re-thrown.
 *
 * @param err An error returned by a LocalStore operation.
 * @return A Promise that resolves after we recovered, or the original error.
 */ (n, t, e, i).next((() => i.apply(t))).next((() => n.li._r(t))).next((() => n.nr.Ei(t, s)));
    }));
}

/**
 * Removes mutations from the MutationQueue for the specified batch;
 * LocalDocuments will be recalculated.
 *
 * @returns The resulting modified documents.
 */
/**
 * Returns the last consistent snapshot processed (used by the RemoteStore to
 * determine whether to buffer incoming snapshots from the backend).
 */
function zs(t) {
    const e = v(t);
    return e.persistence.runTransaction("Get last remote snapshot version", "readonly", (t => e.tr.dr(t)));
}

/**
 * Updates the "ground-state" (remote) documents. We assume that the remote
 * event reflects any write batches that have been acknowledged or rejected
 * (i.e. we do not re-apply local mutations to updates from this event).
 *
 * LocalDocuments are re-calculated if there are remaining mutations in the
 * queue.
 */ function Ks(t, e) {
    const n = v(t), s = e.nt;
    let i = n.Ki;
    return n.persistence.runTransaction("Apply remote event", "readwrite-primary", (t => {
        const r = n.Xi.cr({
            ar: !0
        });
        // Reset newTargetDataByTargetMap in case this transaction gets re-run.
                i = n.Ki;
        const o = [];
        e.Kt.forEach(((e, r) => {
            const u = i.get(r);
            if (!u) return;
            // Only update the remote keys if the target is still active. This
            // ensures that we can persist the updated target data along with
            // the updated assignment.
                        o.push(n.tr.wr(t, e.se, r).next((() => n.tr.mr(t, e.ee, r))));
            const c = e.resumeToken;
            // Update the resume token if the change includes one.
                        if (c.L() > 0) {
                const a = u.it(c, s).st(t.Tr);
                i = i.ot(r, a), 
                // Update the target data if there are target changes (or if
                // sufficient time has passed since the last update).
                /**
 * Returns true if the newTargetData should be persisted during an update of
 * an active target. TargetData should always be persisted when a target is
 * being released and should not call this function.
 *
 * While the target is active, TargetData updates can be omitted when nothing
 * about the target has changed except metadata like the resume token or
 * snapshot version. Occasionally it's worth the extra write to prevent these
 * values from getting too stale after a crash, but this doesn't have to be
 * too frequent.
 */
                function(t, e, n) {
                    // Always persist target data if we don't already have a resume token.
                    if (V(e.resumeToken.L() > 0), 0 === t.resumeToken.L()) return !0;
                    // Don't allow resume token changes to be buffered indefinitely. This
                    // allows us to be reasonably up-to-date after a crash and avoids needing
                    // to loop over all active queries on shutdown. Especially in the browser
                    // we may not get time to do anything interesting while the current tab is
                    // closing.
                                        if (e.nt.X() - t.nt.X() >= 3e8) return !0;
                    // Otherwise if the only thing that has changed about a target is its resume
                    // token it's not worth persisting. Note that the RemoteStore keeps an
                    // in-memory view of the currently active targets which includes the current
                    // resume token, so stream failure or user changes will still use an
                    // up-to-date resume token regardless of what we do here.
                                        return n.ee.size + n.ne.size + n.se.size > 0;
                }
                /**
 * Notifies local store of the changed views to locally pin documents.
 */ (u, a, e) && o.push(n.tr.Er(t, a));
            }
        }));
        let u = xt(), c = Ut();
        // HACK: The only reason we allow a null snapshot version is so that we
        // can synthesize remote events when we get permission denied errors while
        // trying to resolve the state of a locally cached document that is in
        // limbo.
        if (e.Yt.forEach(((t, e) => {
            c = c.add(t);
        })), 
        // Each loop iteration only affects its "own" doc, so it's safe to get all the remote
        // documents in advance in a single call.
        o.push(r.getEntries(t, c).next((i => {
            e.Yt.forEach(((c, a) => {
                const h = i.get(c);
                // Note: The order of the steps below is important, since we want
                // to ensure that rejected limbo resolutions (which fabricate
                // NoDocuments with SnapshotVersion.min()) never add documents to
                // cache.
                                a instanceof xn && a.version.isEqual(dt.min()) ? (
                // NoDocuments with SnapshotVersion.min() are used in manufactured
                // events. We remove these documents from cache since we lost
                // access.
                r.Ir(c, s), u = u.ot(c, a)) : null == h || a.version.M(h.version) > 0 || 0 === a.version.M(h.version) && h.hasPendingWrites ? (r.hr(a, s), 
                u = u.ot(c, a)) : R("LocalStore", "Ignoring outdated watch update for ", c, ". Current version:", h.version, " Watch version:", a.version), 
                e.Jt.has(c) && o.push(n.persistence.Rr.Ar(t, c));
            }));
        }))), !s.isEqual(dt.min())) {
            const e = n.tr.dr(t).next((e => n.tr.yr(t, t.Tr, s)));
            o.push(e);
        }
        return Is.xn(o).next((() => r.apply(t))).next((() => n.nr.Ii(t, u)));
    })).then((t => (n.Ki = i, t)));
}

/**
 * Gets the mutation batch after the passed in batchId in the mutation queue
 * or null if empty.
 * @param afterBatchId If provided, the batch to search after.
 * @returns The next mutation or null if there wasn't one.
 */
function Hs(t, e) {
    const n = v(t);
    return n.persistence.runTransaction("Get next mutation batch", "readonly", (t => (void 0 === e && (e = -1), 
    n.li.Pr(t, e))));
}

/**
 * Reads the current value of a Document with a given key or null if not
 * found - used for testing.
 */
/**
 * Unpins all the documents associated with the given target. If
 * `keepPersistedTargetData` is set to false and Eager GC enabled, the method
 * directly removes the associated target data from the target cache.
 *
 * Releasing a non-existing `Target` is a no-op.
 */
// PORTING NOTE: `keepPersistedTargetData` is multi-tab only.
async function Ys(t, e, n) {
    const s = v(t), i = s.Ki.get(e), r = n ? "readwrite" : "readwrite-primary";
    try {
        n || await s.persistence.runTransaction("Release target", r, (t => s.persistence.Rr.removeTarget(t, i)));
    } catch (t) {
        if (!As(t)) throw t;
        // All `releaseTarget` does is record the final metadata state for the
        // target, but we've been recording this periodically during target
        // activity. If we lose this write this could cause a very slight
        // difference in the order of target deletion during GC, but we
        // don't define exact LRU semantics so this is acceptable.
        R("LocalStore", `Failed to update sequence numbers for target ${e}: ${t}`);
    }
    s.Ki = s.Ki.remove(e), s.Hi.delete(i.target);
}

/**
 * Runs the specified query against the local store and returns the results,
 * potentially taking advantage of query data from previous executions (such
 * as the set of remote keys).
 *
 * @param usePreviousResults Whether results from previous executions can
 * be used to optimize this query execution.
 */ function Js(t, e, n) {
    const s = v(t);
    let i = dt.min(), r = Ut();
    return s.persistence.runTransaction("Execute query", "readonly", (t => 
    /**
 * Returns the TargetData as seen by the LocalStore, including updates that may
 * have not yet been persisted to the TargetCache.
 */
    // Visible for testing.
    function(t, e, n) {
        const s = v(t), i = s.Hi.get(n);
        return void 0 !== i ? Is.resolve(s.Ki.get(i)) : s.tr.gr(e, n);
    }(s, t, Wn(e)).next((e => {
        if (e) return i = e.lastLimboFreeSnapshotVersion, s.tr.pr(t, e.targetId).next((t => {
            r = t;
        }));
    })).next((() => s.zi.Ri(t, e, n ? i : dt.min(), n ? r : Ut()))).next((t => ({
        documents: t,
        Vr: r
    })))));
}

async function Xs(t) {
    if (t.code !== T.FAILED_PRECONDITION || "The current tab is not in the required state to perform this operation. It might be necessary to refresh the browser tab." !== t.message) throw t;
    R("LocalStore", "Unexpectedly lost primary lease");
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A collection of references to a document from some kind of numbered entity
 * (either a target ID or batch ID). As references are added to or removed from
 * the set corresponding events are emitted to a registered garbage collector.
 *
 * Each reference is represented by a DocumentReference object. Each of them
 * contains enough information to uniquely identify the reference. They are all
 * stored primarily in a set sorted by key. A document is considered garbage if
 * there's no references in that set (this can be efficiently checked thanks to
 * sorting by key).
 *
 * ReferenceSet also keeps a secondary set that contains references sorted by
 * IDs. This one is used to efficiently implement removal of all references by
 * some target ID.
 */ class Zs {
    constructor() {
        // A set of outstanding references to a document sorted by key.
        this.vr = new Ft(ti.br), 
        // A set of outstanding references to a document sorted by target id.
        this.Sr = new Ft(ti.Dr);
    }
    /** Returns true if the reference set contains no references. */    m() {
        return this.vr.m();
    }
    /** Adds a reference to the given document key for the given ID. */    Cr(t, e) {
        const n = new ti(t, e);
        this.vr = this.vr.add(n), this.Sr = this.Sr.add(n);
    }
    /** Add references to the given document keys for the given ID. */    Fr(t, e) {
        t.forEach((t => this.Cr(t, e)));
    }
    /**
     * Removes a reference to the given document key for the given
     * ID.
     */    Nr(t, e) {
        this.$r(new ti(t, e));
    }
    kr(t, e) {
        t.forEach((t => this.Nr(t, e)));
    }
    /**
     * Clears all references with a given ID. Calls removeRef() for each key
     * removed.
     */    Or(t) {
        const e = new x(new F([])), n = new ti(e, t), s = new ti(e, t + 1), i = [];
        return this.Sr.Nt([ n, s ], (t => {
            this.$r(t), i.push(t.key);
        })), i;
    }
    Lr() {
        this.vr.forEach((t => this.$r(t)));
    }
    $r(t) {
        this.vr = this.vr.delete(t), this.Sr = this.Sr.delete(t);
    }
    Mr(t) {
        const e = new x(new F([])), n = new ti(e, t), s = new ti(e, t + 1);
        let i = Ut();
        return this.Sr.Nt([ n, s ], (t => {
            i = i.add(t.key);
        })), i;
    }
    qr(t) {
        const e = new ti(t, 0), n = this.vr.xt(e);
        return null !== n && t.isEqual(n.key);
    }
}

class ti {
    constructor(t, e) {
        this.key = t, this.Ur = e;
    }
    /** Compare by key then by ID */    static br(t, e) {
        return x.i(t.key, e.key) || it(t.Ur, e.Ur);
    }
    /** Compare by ID then by key */    static Dr(t, e) {
        return it(t.Ur, e.Ur) || x.i(t.key, e.key);
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ class ei {
    constructor(t, e) {
        this.user = e, this.type = "OAuth", this.Br = {}, 
        // Set the headers using Object Literal notation to avoid minification
        this.Br.Authorization = "Bearer " + t;
    }
}

/** A CredentialsProvider that always yields an empty token. */ class ni {
    constructor() {
        /**
         * Stores the listener registered with setChangeListener()
         * This isn't actually necessary since the UID never changes, but we use this
         * to verify the listen contract is adhered to in tests.
         */
        this.Qr = null;
    }
    getToken() {
        return Promise.resolve(null);
    }
    jr() {}
    Wr(t) {
        this.Qr = t, 
        // Fire with initial user.
        t(Ns.UNAUTHENTICATED);
    }
    Gr() {
        this.Qr = null;
    }
}

class si {
    constructor(t) {
        /**
         * The auth token listener registered with FirebaseApp, retained here so we
         * can unregister it.
         */
        this.zr = null, 
        /** Tracks the current User. */
        this.currentUser = Ns.UNAUTHENTICATED, this.Kr = !1, 
        /**
         * Counter used to detect if the token changed while a getToken request was
         * outstanding.
         */
        this.Hr = 0, 
        /** The listener registered with setChangeListener(). */
        this.Qr = null, this.forceRefresh = !1, this.zr = () => {
            this.Hr++, this.currentUser = this.Yr(), this.Kr = !0, this.Qr && this.Qr(this.currentUser);
        }, this.Hr = 0, this.auth = t.getImmediate({
            optional: !0
        }), this.auth ? this.auth.addAuthTokenListener(this.zr) : (
        // if auth is not available, invoke tokenListener once with null token
        this.zr(null), t.get().then((t => {
            this.auth = t, this.zr && 
            // tokenListener can be removed by removeChangeListener()
            this.auth.addAuthTokenListener(this.zr);
        }), (() => {})));
    }
    getToken() {
        // Take note of the current value of the tokenCounter so that this method
        // can fail (with an ABORTED error) if there is a token change while the
        // request is outstanding.
        const t = this.Hr, e = this.forceRefresh;
        return this.forceRefresh = !1, this.auth ? this.auth.getToken(e).then((e => 
        // Cancel the request since the token changed while the request was
        // outstanding so the response is potentially for a previous user (which
        // user, we can't be sure).
        this.Hr !== t ? (R("FirebaseCredentialsProvider", "getToken aborted due to token change."), 
        this.getToken()) : e ? (V("string" == typeof e.accessToken), new ei(e.accessToken, this.currentUser)) : null)) : Promise.resolve(null);
    }
    jr() {
        this.forceRefresh = !0;
    }
    Wr(t) {
        this.Qr = t, 
        // Fire the initial event
        this.Kr && t(this.currentUser);
    }
    Gr() {
        this.auth && this.auth.removeAuthTokenListener(this.zr), this.zr = null, this.Qr = null;
    }
    // Auth.getUid() can return null even with a user logged in. It is because
    // getUid() is synchronous, but the auth code populating Uid is asynchronous.
    // This method should only be called in the AuthTokenListener callback
    // to guarantee to get the actual user.
    Yr() {
        const t = this.auth && this.auth.getUid();
        return V(null === t || "string" == typeof t), new Ns(t);
    }
}

/*
 * FirstPartyToken provides a fresh token each time its value
 * is requested, because if the token is too old, requests will be rejected.
 * Technically this may no longer be necessary since the SDK should gracefully
 * recover from unauthenticated errors (see b/33147818 for context), but it's
 * safer to keep the implementation as-is.
 */ class ii {
    constructor(t, e) {
        this.Jr = t, this.Xr = e, this.type = "FirstParty", this.user = Ns.Ns;
    }
    get Br() {
        const t = {
            "X-Goog-AuthUser": this.Xr
        }, e = this.Jr.auth.getAuthHeaderValueForFirstParty([]);
        // Use array notation to prevent minification
                return e && (t.Authorization = e), t;
    }
}

/*
 * Provides user credentials required for the Firestore JavaScript SDK
 * to authenticate the user, using technique that is only available
 * to applications hosted by Google.
 */ class ri {
    constructor(t, e) {
        this.Jr = t, this.Xr = e;
    }
    getToken() {
        return Promise.resolve(new ii(this.Jr, this.Xr));
    }
    Wr(t) {
        // Fire with initial uid.
        t(Ns.Ns);
    }
    Gr() {}
    jr() {}
}

/**
 * Builds a CredentialsProvider depending on the type of
 * the credentials passed in.
 */
/**
 * A PersistentStream is an abstract base class that represents a streaming RPC
 * to the Firestore backend. It's built on top of the connections own support
 * for streaming RPCs, and adds several critical features for our clients:
 *
 *   - Exponential backoff on failure
 *   - Authentication via CredentialsProvider
 *   - Dispatching all callbacks into the shared worker queue
 *   - Closing idle streams after 60 seconds of inactivity
 *
 * Subclasses of PersistentStream implement serialization of models to and
 * from the JSON representation of the protocol buffers for a specific
 * streaming RPC.
 *
 * ## Starting and Stopping
 *
 * Streaming RPCs are stateful and need to be start()ed before messages can
 * be sent and received. The PersistentStream will call the onOpen() function
 * of the listener once the stream is ready to accept requests.
 *
 * Should a start() fail, PersistentStream will call the registered onClose()
 * listener with a FirestoreError indicating what went wrong.
 *
 * A PersistentStream can be started and stopped repeatedly.
 *
 * Generic types:
 *  SendType: The type of the outgoing message of the underlying
 *    connection stream
 *  ReceiveType: The type of the incoming message of the underlying
 *    connection stream
 *  ListenerType: The type of the listener that will be used for callbacks
 */
class oi {
    constructor(t, e, n, s, i, r) {
        this.fn = t, this.Zr = n, this.eo = s, this.no = i, this.listener = r, this.state = 0 /* Initial */ , 
        /**
         * A close count that's incremented every time the stream is closed; used by
         * getCloseGuardedDispatcher() to invalidate callbacks that happen after
         * close.
         */
        this.so = 0, this.io = null, this.stream = null, this.Xn = new Es(t, e);
    }
    /**
     * Returns true if start() has been called and no error has occurred. True
     * indicates the stream is open or in the process of opening (which
     * encompasses respecting backoff, getting auth tokens, and starting the
     * actual RPC). Use isOpen() to determine if the stream is open and ready for
     * outbound requests.
     */    ro() {
        return 1 /* Starting */ === this.state || 2 /* Open */ === this.state || 4 /* Backoff */ === this.state;
    }
    /**
     * Returns true if the underlying RPC is open (the onOpen() listener has been
     * called) and the stream is ready for outbound requests.
     */    oo() {
        return 2 /* Open */ === this.state;
    }
    /**
     * Starts the RPC. Only allowed if isStarted() returns false. The stream is
     * not immediately ready for use: onOpen() will be invoked when the RPC is
     * ready for outbound requests, at which point isOpen() will return true.
     *
     * When start returns, isStarted() will return true.
     */    start() {
        3 /* Error */ !== this.state ? this.auth() : this.uo();
    }
    /**
     * Stops the RPC. This call is idempotent and allowed regardless of the
     * current isStarted() state.
     *
     * When stop returns, isStarted() and isOpen() will both return false.
     */    async stop() {
        this.ro() && await this.close(0 /* Initial */);
    }
    /**
     * After an error the stream will usually back off on the next attempt to
     * start it. If the error warrants an immediate restart of the stream, the
     * sender can use this to indicate that the receiver should not back off.
     *
     * Each error will call the onClose() listener. That function can decide to
     * inhibit backoff if required.
     */    co() {
        this.state = 0 /* Initial */ , this.Xn.reset();
    }
    /**
     * Marks this stream as idle. If no further actions are performed on the
     * stream for one minute, the stream will automatically close itself and
     * notify the stream's onClose() handler with Status.OK. The stream will then
     * be in a !isStarted() state, requiring the caller to start the stream again
     * before further use.
     *
     * Only streams that are in state 'Open' can be marked idle, as all other
     * states imply pending network operations.
     */    ao() {
        // Starts the idle time if we are in state 'Open' and are not yet already
        // running a timer (in which case the previous idle timeout still applies).
        this.oo() && null === this.io && (this.io = this.fn.gn(this.Zr, 6e4, (() => this.ho())));
    }
    /** Sends a message to the underlying stream. */    lo(t) {
        this._o(), this.stream.send(t);
    }
    /** Called by the idle timer when the stream should close due to inactivity. */    async ho() {
        if (this.oo()) 
        // When timing out an idle stream there's no reason to force the stream into backoff when
        // it restarts so set the stream state to Initial instead of Error.
        return this.close(0 /* Initial */);
    }
    /** Marks the stream as active again. */    _o() {
        this.io && (this.io.cancel(), this.io = null);
    }
    /**
     * Closes the stream and cleans up as necessary:
     *
     * * closes the underlying GRPC stream;
     * * calls the onClose handler with the given 'error';
     * * sets internal stream state to 'finalState';
     * * adjusts the backoff timer based on the error
     *
     * A new stream can be opened by calling start().
     *
     * @param finalState the intended state of the stream after closing.
     * @param error the error the connection was closed with.
     */    async close(t, e) {
        // Cancel any outstanding timers (they're guaranteed not to execute).
        this._o(), this.Xn.cancel(), 
        // Invalidates any stream-related callbacks (e.g. from auth or the
        // underlying stream), guaranteeing they won't execute.
        this.so++, 3 /* Error */ !== t ? 
        // If this is an intentional close ensure we don't delay our next connection attempt.
        this.Xn.reset() : e && e.code === T.RESOURCE_EXHAUSTED ? (
        // Log the error. (Probably either 'quota exceeded' or 'max queue length reached'.)
        y(e.toString()), y("Using maximum backoff delay to prevent overloading the backend."), 
        this.Xn.Rn()) : e && e.code === T.UNAUTHENTICATED && 
        // "unauthenticated" error means the token was rejected. Try force refreshing it in case it
        // just expired.
        this.no.jr(), 
        // Clean up the underlying stream because we are no longer interested in events.
        null !== this.stream && (this.fo(), this.stream.close(), this.stream = null), 
        // This state must be assigned before calling onClose() to allow the callback to
        // inhibit backoff or otherwise manipulate the state in its non-started state.
        this.state = t, 
        // Notify the listener that the stream closed.
        await this.listener.do(e);
    }
    /**
     * Can be overridden to perform additional cleanup before the stream is closed.
     * Calling super.tearDown() is not required.
     */    fo() {}
    auth() {
        this.state = 1 /* Starting */;
        const t = this.wo(this.so), e = this.so;
        // TODO(mikelehen): Just use dispatchIfNotClosed, but see TODO below.
                this.no.getToken().then((t => {
            // Stream can be stopped while waiting for authentication.
            // TODO(mikelehen): We really should just use dispatchIfNotClosed
            // and let this dispatch onto the queue, but that opened a spec test can
            // of worms that I don't want to deal with in this PR.
            this.so === e && 
            // Normally we'd have to schedule the callback on the AsyncQueue.
            // However, the following calls are safe to be called outside the
            // AsyncQueue since they don't chain asynchronous calls
            this.mo(t);
        }), (e => {
            t((() => {
                const t = new E(T.UNKNOWN, "Fetching auth token failed: " + e.message);
                return this.To(t);
            }));
        }));
    }
    mo(t) {
        const e = this.wo(this.so);
        this.stream = this.Eo(t), this.stream.Io((() => {
            e((() => (this.state = 2 /* Open */ , this.listener.Io())));
        })), this.stream.do((t => {
            e((() => this.To(t)));
        })), this.stream.onMessage((t => {
            e((() => this.onMessage(t)));
        }));
    }
    uo() {
        this.state = 4 /* Backoff */ , this.Xn.yn((async () => {
            this.state = 0 /* Initial */ , this.start();
        }));
    }
    // Visible for tests
    To(t) {
        // In theory the stream could close cleanly, however, in our current model
        // we never expect this to happen because if we stop a stream ourselves,
        // this callback will never be called. To prevent cases where we retry
        // without a backoff accidentally, we set the stream to error in all cases.
        return R("PersistentStream", "close with error: " + t), this.stream = null, this.close(3 /* Error */ , t);
    }
    /**
     * Returns a "dispatcher" function that dispatches operations onto the
     * AsyncQueue but only runs them if closeCount remains unchanged. This allows
     * us to turn auth / stream callbacks into no-ops if the stream is closed /
     * re-opened, etc.
     */    wo(t) {
        return e => {
            this.fn.jn((() => this.so === t ? e() : (R("PersistentStream", "stream callback skipped by getCloseGuardedDispatcher."), 
            Promise.resolve())));
        };
    }
}

/**
 * A PersistentStream that implements the Listen RPC.
 *
 * Once the Listen stream has called the onOpen() listener, any number of
 * listen() and unlisten() calls can be made to control what changes will be
 * sent from the server for ListenResponses.
 */ class ui extends oi {
    constructor(t, e, n, s, i) {
        super(t, "listen_stream_connection_backoff" /* ListenStreamConnectionBackoff */ , "listen_stream_idle" /* ListenStreamIdle */ , e, n, i), 
        this.serializer = s;
    }
    Eo(t) {
        return this.eo.Ao("Listen", t);
    }
    onMessage(t) {
        // A successful response means the stream is healthy
        this.Xn.reset();
        const e = Me(this.serializer, t), n = function(t) {
            // We have only reached a consistent snapshot for the entire stream if there
            // is a read_time set and it applies to all targets (i.e. the list of
            // targets is empty). The backend is guaranteed to send such responses.
            if (!("targetChange" in t)) return dt.min();
            const e = t.targetChange;
            return e.targetIds && e.targetIds.length ? dt.min() : e.readTime ? Ce(e.readTime) : dt.min();
        }(t);
        return this.listener.Ro(e, n);
    }
    /**
     * Registers interest in the results of the given target. If the target
     * includes a resumeToken it will be included in the request. Results that
     * affect the target will be streamed back as WatchChange messages that
     * reference the targetId.
     */    yo(t) {
        const e = {};
        e.database = ke(this.serializer), e.addTarget = function(t, e) {
            let n;
            const s = e.target;
            return n = yt(s) ? {
                documents: Be(t, s)
            } : {
                query: Qe(t, s)
            }, n.targetId = e.targetId, e.resumeToken.L() > 0 && (n.resumeToken = Se(t, e.resumeToken)), 
            n;
        }(this.serializer, t);
        const n = je(this.serializer, t);
        n && (e.labels = n), this.lo(e);
    }
    /**
     * Unregisters interest in the results of the target associated with the
     * given targetId.
     */    Po(t) {
        const e = {};
        e.database = ke(this.serializer), e.removeTarget = t, this.lo(e);
    }
}

/**
 * A Stream that implements the Write RPC.
 *
 * The Write RPC requires the caller to maintain special streamToken
 * state in between calls, to help the server understand which responses the
 * client has processed by the time the next request is made. Every response
 * will contain a streamToken; this value must be passed to the next
 * request.
 *
 * After calling start() on this stream, the next request must be a handshake,
 * containing whatever streamToken is on hand. Once a response to this
 * request is received, all pending mutations may be submitted. When
 * submitting multiple batches of mutations at the same time, it's
 * okay to use the same streamToken for the calls to writeMutations.
 *
 * TODO(b/33271235): Use proto types
 */ class ci extends oi {
    constructor(t, e, n, s, i) {
        super(t, "write_stream_connection_backoff" /* WriteStreamConnectionBackoff */ , "write_stream_idle" /* WriteStreamIdle */ , e, n, i), 
        this.serializer = s, this.po = !1;
    }
    /**
     * Tracks whether or not a handshake has been successfully exchanged and
     * the stream is ready to accept mutations.
     */    get Vo() {
        return this.po;
    }
    // Override of PersistentStream.start
    start() {
        this.po = !1, this.lastStreamToken = void 0, super.start();
    }
    fo() {
        this.po && this.vo([]);
    }
    Eo(t) {
        return this.eo.Ao("Write", t);
    }
    onMessage(t) {
        if (
        // Always capture the last stream token.
        V(!!t.streamToken), this.lastStreamToken = t.streamToken, this.po) {
            // A successful first write response means the stream is healthy,
            // Note, that we could consider a successful handshake healthy, however,
            // the write itself might be causing an error we want to back off from.
            this.Xn.reset();
            const e = Ue(t.writeResults, t.commitTime), n = Ce(t.commitTime);
            return this.listener.bo(n, e);
        }
        // The first response is always the handshake response
        return V(!t.writeResults || 0 === t.writeResults.length), this.po = !0, this.listener.So();
    }
    /**
     * Sends an initial streamToken to the server, performing the handshake
     * required to make the StreamingWrite RPC work. Subsequent
     * calls should wait until onHandshakeComplete was called.
     */    Do() {
        // TODO(dimond): Support stream resumption. We intentionally do not set the
        // stream token on the handshake, ignoring any stream token we might have.
        const t = {};
        t.database = ke(this.serializer), this.lo(t);
    }
    /** Sends a group of mutations to the Firestore backend to apply. */    vo(t) {
        const e = {
            streamToken: this.lastStreamToken,
            writes: t.map((t => qe(this.serializer, t)))
        };
        this.lo(e);
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Datastore and its related methods are a wrapper around the external Google
 * Cloud Datastore grpc API, which provides an interface that is more convenient
 * for the rest of the client SDK architecture to consume.
 */
/**
 * An implementation of Datastore that exposes additional state for internal
 * consumption.
 */
class ai extends class {} {
    constructor(t, e, n) {
        super(), this.credentials = t, this.eo = e, this.serializer = n, this.Co = !1;
    }
    Fo() {
        if (this.Co) throw new E(T.FAILED_PRECONDITION, "The client has already been terminated.");
    }
    /** Gets an auth token and invokes the provided RPC. */    No(t, e, n) {
        return this.Fo(), this.credentials.getToken().then((s => this.eo.No(t, e, n, s))).catch((t => {
            throw t.code === T.UNAUTHENTICATED && this.credentials.jr(), t;
        }));
    }
    /** Gets an auth token and invokes the provided RPC with streamed results. */    $o(t, e, n) {
        return this.Fo(), this.credentials.getToken().then((s => this.eo.$o(t, e, n, s))).catch((t => {
            throw t.code === T.UNAUTHENTICATED && this.credentials.jr(), t;
        }));
    }
    terminate() {
        this.Co = !1;
    }
}

// TODO(firestorexp): Make sure there is only one Datastore instance per
// firestore-exp client.
/**
 * A component used by the RemoteStore to track the OnlineState (that is,
 * whether or not the client as a whole should be considered to be online or
 * offline), implementing the appropriate heuristics.
 *
 * In particular, when the client is trying to connect to the backend, we
 * allow up to MAX_WATCH_STREAM_FAILURES within ONLINE_STATE_TIMEOUT_MS for
 * a connection to succeed. If we have too many failures or the timeout elapses,
 * then we set the OnlineState to Offline, and the client will behave as if
 * it is offline (get()s will return cached data, etc.).
 */
class hi {
    constructor(t, e) {
        this.On = t, this.js = e, 
        /** The current OnlineState. */
        this.state = "Unknown" /* Unknown */ , 
        /**
         * A count of consecutive failures to open the stream. If it reaches the
         * maximum defined by MAX_WATCH_STREAM_FAILURES, we'll set the OnlineState to
         * Offline.
         */
        this.xo = 0, 
        /**
         * A timer that elapses after ONLINE_STATE_TIMEOUT_MS, at which point we
         * transition from OnlineState.Unknown to OnlineState.Offline without waiting
         * for the stream to actually fail (MAX_WATCH_STREAM_FAILURES times).
         */
        this.ko = null, 
        /**
         * Whether the client should log a warning message if it fails to connect to
         * the backend (initially true, cleared after a successful stream, or if we've
         * logged the message already).
         */
        this.Oo = !0;
    }
    /**
     * Called by RemoteStore when a watch stream is started (including on each
     * backoff attempt).
     *
     * If this is the first attempt, it sets the OnlineState to Unknown and starts
     * the onlineStateTimer.
     */    Lo() {
        0 === this.xo && (this.Mo("Unknown" /* Unknown */), this.ko = this.On.gn("online_state_timeout" /* OnlineStateTimeout */ , 1e4, (() => (this.ko = null, 
        this.qo("Backend didn't respond within 10 seconds."), this.Mo("Offline" /* Offline */), 
        Promise.resolve()))));
    }
    /**
     * Updates our OnlineState as appropriate after the watch stream reports a
     * failure. The first failure moves us to the 'Unknown' state. We then may
     * allow multiple failures (based on MAX_WATCH_STREAM_FAILURES) before we
     * actually transition to the 'Offline' state.
     */    Uo(t) {
        "Online" /* Online */ === this.state ? this.Mo("Unknown" /* Unknown */) : (this.xo++, 
        this.xo >= 1 && (this.Bo(), this.qo("Connection failed 1 times. Most recent error: " + t.toString()), 
        this.Mo("Offline" /* Offline */)));
    }
    /**
     * Explicitly sets the OnlineState to the specified state.
     *
     * Note that this resets our timers / failure counters, etc. used by our
     * Offline heuristics, so must not be used in place of
     * handleWatchStreamStart() and handleWatchStreamFailure().
     */    set(t) {
        this.Bo(), this.xo = 0, "Online" /* Online */ === t && (
        // We've connected to watch at least once. Don't warn the developer
        // about being offline going forward.
        this.Oo = !1), this.Mo(t);
    }
    Mo(t) {
        t !== this.state && (this.state = t, this.js(t));
    }
    qo(t) {
        const e = `Could not reach Cloud Firestore backend. ${t}\nThis typically indicates that your device does not have a healthy Internet connection at the moment. The client will operate in offline mode until it is able to successfully connect to the backend.`;
        this.Oo ? (y(e), this.Oo = !1) : R("OnlineStateTracker", e);
    }
    Bo() {
        null !== this.ko && (this.ko.cancel(), this.ko = null);
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ class li {
    constructor(
    /**
     * The local store, used to fill the write pipeline with outbound mutations.
     */
    t, 
    /** The client-side proxy for interacting with the backend. */
    e, n, s, i) {
        this.Qo = t, this.jo = e, this.On = n, this.Wo = {}, 
        /**
         * A list of up to MAX_PENDING_WRITES writes that we have fetched from the
         * LocalStore via fillWritePipeline() and have or will send to the write
         * stream.
         *
         * Whenever writePipeline.length > 0 the RemoteStore will attempt to start or
         * restart the write stream. When the stream is established the writes in the
         * pipeline will be sent in order.
         *
         * Writes remain in writePipeline until they are acknowledged by the backend
         * and thus will automatically be re-sent if the stream is interrupted /
         * restarted before they're acknowledged.
         *
         * Write responses from the backend are linked to their originating request
         * purely based on order, and so we can just shift() writes from the front of
         * the writePipeline as we receive responses.
         */
        this.Go = [], 
        /**
         * A mapping of watched targets that the client cares about tracking and the
         * user has explicitly called a 'listen' for this target.
         *
         * These targets may or may not have been sent to or acknowledged by the
         * server. On re-establishing the listen stream, these targets should be sent
         * to the server. The targets removed with unlistens are removed eagerly
         * without waiting for confirmation from the listen stream.
         */
        this.zo = new Map, 
        /**
         * A set of reasons for why the RemoteStore may be offline. If empty, the
         * RemoteStore may start its network connections.
         */
        this.Ko = new Set, 
        /**
         * Event handlers that get called when the network is disabled or enabled.
         *
         * PORTING NOTE: These functions are used on the Web client to create the
         * underlying streams (to support tree-shakeable streams). On Android and iOS,
         * the streams are created during construction of RemoteStore.
         */
        this.Ho = [], this.Yo = i, this.Yo.Jo((t => {
            n.jn((async () => {
                // Porting Note: Unlike iOS, `restartNetwork()` is called even when the
                // network becomes unreachable as we don't have any other way to tear
                // down our streams.
                Ri(this) && (R("RemoteStore", "Restarting streams for network reachability change."), 
                await async function(t) {
                    const e = v(t);
                    e.Ko.add(4 /* ConnectivityChange */), await fi(e), e.Xo.set("Unknown" /* Unknown */), 
                    e.Ko.delete(4 /* ConnectivityChange */), await _i(e);
                }(this));
            }));
        })), this.Xo = new hi(n, s);
    }
}

async function _i(t) {
    if (Ri(t)) for (const e of t.Ho) await e(/* enabled= */ !0);
}

/**
 * Temporarily disables the network. The network can be re-enabled using
 * enableNetwork().
 */ async function fi(t) {
    for (const e of t.Ho) await e(/* enabled= */ !1);
}

async function di(t) {
    const e = v(t);
    R("RemoteStore", "RemoteStore shutting down."), e.Ko.add(5 /* Shutdown */), await fi(e), 
    e.Yo.ni(), 
    // Set the OnlineState to Unknown (rather than Offline) to avoid potentially
    // triggering spurious listener events with cached data, etc.
    e.Xo.set("Unknown" /* Unknown */);
}

/**
 * Starts new listen for the given target. Uses resume token if provided. It
 * is a no-op if the target of given `TargetData` is already being listened to.
 */ function wi(t, e) {
    const n = v(t);
    n.zo.has(e.targetId) || (
    // Mark this as something the client is currently listening for.
    n.zo.set(e.targetId, e), Ai(n) ? 
    // The listen will be sent in onWatchStreamOpen
    Ii(n) : Oi(n).oo() && Ti(n, e));
}

/**
 * Removes the listen from server. It is a no-op if the given target id is
 * not being listened to.
 */ function mi(t, e) {
    const n = v(t), s = Oi(n);
    n.zo.delete(e), s.oo() && Ei(n, e), 0 === n.zo.size && (s.oo() ? s.ao() : Ri(n) && 
    // Revert to OnlineState.Unknown if the watch stream is not open and we
    // have no listeners, since without any listens to send we cannot
    // confirm if the stream is healthy and upgrade to OnlineState.Online.
    n.Xo.set("Unknown" /* Unknown */));
}

/**
 * We need to increment the the expected number of pending responses we're due
 * from watch so we wait for the ack to process any messages from this target.
 */ function Ti(t, e) {
    t.Zo.Ie(e.targetId), Oi(t).yo(e);
}

/**
 * We need to increment the expected number of pending responses we're due
 * from watch so we wait for the removal on the server before we process any
 * messages from this target.
 */ function Ei(t, e) {
    t.Zo.Ie(e), Oi(t).Po(e);
}

function Ii(t) {
    t.Zo = new Zt({
        Ue: e => t.Wo.Ue(e),
        Be: e => t.zo.get(e) || null
    }), Oi(t).start(), t.Xo.Lo();
}

/**
 * Returns whether the watch stream should be started because it's necessary
 * and has not yet been started.
 */ function Ai(t) {
    return Ri(t) && !Oi(t).ro() && t.zo.size > 0;
}

function Ri(t) {
    return 0 === v(t).Ko.size;
}

function yi(t) {
    t.Zo = void 0;
}

async function Pi(t) {
    t.zo.forEach(((e, n) => {
        Ti(t, e);
    }));
}

async function gi(t, e) {
    yi(t), 
    // If we still need the watch stream, retry the connection.
    Ai(t) ? (t.Xo.Uo(e), Ii(t)) : 
    // No need to restart watch stream because there are no active targets.
    // The online state is set to unknown because there is no active attempt
    // at establishing a connection
    t.Xo.set("Unknown" /* Unknown */);
}

async function pi(t, e, n) {
    if (
    // Mark the client as online since we got a message from the server
    t.Xo.set("Online" /* Online */), e instanceof Jt && 2 /* Removed */ === e.state && e.cause) 
    // There was an error on a target, don't wait for a consistent snapshot
    // to raise events
    try {
        await 
        /** Handles an error on a target */
        async function(t, e) {
            const n = e.cause;
            for (const s of e.targetIds) 
            // A watched target might have been removed already.
            t.zo.has(s) && (await t.Wo.tu(s, n), t.zo.delete(s), t.Zo.removeTarget(s));
        }
        /**
 * Attempts to fill our write pipeline with writes from the LocalStore.
 *
 * Called internally to bootstrap or refill the write pipeline and by
 * SyncEngine whenever there are new mutations to process.
 *
 * Starts the write stream if necessary.
 */ (t, e);
    } catch (n) {
        R("RemoteStore", "Failed to remove targets %s: %s ", e.targetIds.join(","), n), 
        await Vi(t, n);
    } else if (e instanceof Ht ? t.Zo.ve(e) : e instanceof Yt ? t.Zo.xe(e) : t.Zo.De(e), 
    !n.isEqual(dt.min())) try {
        const e = await zs(t.Qo);
        n.M(e) >= 0 && 
        // We have received a target change with a global snapshot if the snapshot
        // version is not equal to SnapshotVersion.min().
        await 
        /**
 * Takes a batch of changes from the Datastore, repackages them as a
 * RemoteEvent, and passes that on to the listener, which is typically the
 * SyncEngine.
 */
        function(t, e) {
            const n = t.Zo.Le(e);
            // Update in-memory resume tokens. LocalStore will update the
            // persistent view of these when applying the completed RemoteEvent.
                        return n.Kt.forEach(((n, s) => {
                if (n.resumeToken.L() > 0) {
                    const i = t.zo.get(s);
                    // A watched target might have been removed already.
                                        i && t.zo.set(s, i.it(n.resumeToken, e));
                }
            })), 
            // Re-establish listens for the targets that have been invalidated by
            // existence filter mismatches.
            n.Ht.forEach((e => {
                const n = t.zo.get(e);
                if (!n) 
                // A watched target might have been removed already.
                return;
                // Clear the resume token for the target, since we're in a known mismatch
                // state.
                                t.zo.set(e, n.it(ot.q, n.nt)), 
                // Cause a hard reset by unwatching and rewatching immediately, but
                // deliberately don't send a resume token so that we get a full update.
                Ei(t, e);
                // Mark the target we send as being on behalf of an existence filter
                // mismatch, but don't actually retain that in listenTargets. This ensures
                // that we flag the first re-listen this way without impacting future
                // listens of this target (that might happen e.g. on reconnect).
                const s = new Pt(n.target, e, 1 /* ExistenceFilterMismatch */ , n.sequenceNumber);
                Ti(t, s);
            })), t.Wo.eu(n);
        }(t, n);
    } catch (e) {
        R("RemoteStore", "Failed to raise snapshot:", e), await Vi(t, e);
    }
}

/**
 * Recovery logic for IndexedDB errors that takes the network offline until
 * `op` succeeds. Retries are scheduled with backoff using
 * `enqueueRetryable()`. If `op()` is not provided, IndexedDB access is
 * validated via a generic operation.
 *
 * The returned Promise is resolved once the network is disabled and before
 * any retry attempt.
 */ async function Vi(t, e, n) {
    if (!As(e)) throw e;
    t.Ko.add(1 /* IndexedDbFailed */), 
    // Disable network and raise offline snapshots
    await fi(t), t.Xo.set("Offline" /* Offline */), n || (
    // Use a simple read operation to determine if IndexedDB recovered.
    // Ideally, we would expose a health check directly on SimpleDb, but
    // RemoteStore only has access to persistence through LocalStore.
    n = () => zs(t.Qo)), 
    // Probe IndexedDB periodically and re-enable network
    t.On.os((async () => {
        R("RemoteStore", "Retrying IndexedDB access"), await n(), t.Ko.delete(1 /* IndexedDbFailed */), 
        await _i(t);
    }));
}

/**
 * Executes `op`. If `op` fails, takes the network offline until `op`
 * succeeds. Returns after the first attempt.
 */ function vi(t, e) {
    return e().catch((n => Vi(t, n, e)));
}

async function bi(t) {
    const e = v(t), n = Li(e);
    let s = e.Go.length > 0 ? e.Go[e.Go.length - 1].batchId : -1;
    for (;Si(e); ) try {
        const t = await Hs(e.Qo, s);
        if (null === t) {
            0 === e.Go.length && n.ao();
            break;
        }
        s = t.batchId, Di(e, t);
    } catch (t) {
        await Vi(e, t);
    }
    Ci(e) && Fi(e);
}

/**
 * Returns true if we can add to the write pipeline (i.e. the network is
 * enabled and the write pipeline is not full).
 */ function Si(t) {
    return Ri(t) && t.Go.length < 10;
}

/**
 * Queues additional writes to be sent to the write stream, sending them
 * immediately if the write stream is established.
 */ function Di(t, e) {
    t.Go.push(e);
    const n = Li(t);
    n.oo() && n.Vo && n.vo(e.mutations);
}

function Ci(t) {
    return Ri(t) && !Li(t).ro() && t.Go.length > 0;
}

function Fi(t) {
    Li(t).start();
}

async function Ni(t) {
    Li(t).Do();
}

async function $i(t) {
    const e = Li(t);
    // Send the write pipeline now that the stream is established.
        for (const n of t.Go) e.vo(n.mutations);
}

async function xi(t, e, n) {
    const s = t.Go.shift(), i = Ls.from(s, e, n);
    await vi(t, (() => t.Wo.nu(i))), 
    // It's possible that with the completion of this mutation another
    // slot has freed up.
    await bi(t);
}

async function ki(t, e) {
    // If the write stream closed after the write handshake completes, a write
    // operation failed and we fail the pending operation.
    e && Li(t).Vo && 
    // This error affects the actual write.
    await async function(t, e) {
        // Only handle permanent errors here. If it's transient, just let the retry
        // logic kick in.
        if (n = e.code, vt(n) && n !== T.ABORTED) {
            // This was a permanent error, the request itself was the problem
            // so it's not going to succeed if we resend it.
            const n = t.Go.shift();
            // In this case it's also unlikely that the server itself is melting
            // down -- this was just a bad request so inhibit backoff on the next
            // restart.
                        Li(t).co(), await vi(t, (() => t.Wo.su(n.batchId, e))), 
            // It's possible that with the completion of this mutation
            // another slot has freed up.
            await bi(t);
        }
        var n;
        /**
 * Maps an error Code from a GRPC status identifier like 'NOT_FOUND'.
 *
 * @returns The Code equivalent to the given status string or undefined if
 *     there is no match.
 */    }(t, e), 
    // The write stream might have been started by refilling the write
    // pipeline for failed writes
    Ci(t) && Fi(t);
}

/**
 * If not yet initialized, registers the WatchStream and its network state
 * callback with `remoteStoreImpl`. Returns the existing stream if one is
 * already available.
 *
 * PORTING NOTE: On iOS and Android, the WatchStream gets registered on startup.
 * This is not done on Web to allow it to be tree-shaken.
 */
function Oi(t) {
    return t.iu || (
    // Create stream (but note that it is not started yet).
    t.iu = function(t, e, n) {
        const s = v(t);
        return s.Fo(), new ui(e, s.eo, s.credentials, s.serializer, n);
    }
    /**
 * @license
 * Copyright 2018 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ (t.jo, t.On, {
        Io: Pi.bind(null, t),
        do: gi.bind(null, t),
        Ro: pi.bind(null, t)
    }), t.Ho.push((async e => {
        e ? (t.iu.co(), Ai(t) ? Ii(t) : t.Xo.set("Unknown" /* Unknown */)) : (await t.iu.stop(), 
        yi(t));
    }))), t.iu;
}

/**
 * If not yet initialized, registers the WriteStream and its network state
 * callback with `remoteStoreImpl`. Returns the existing stream if one is
 * already available.
 *
 * PORTING NOTE: On iOS and Android, the WriteStream gets registered on startup.
 * This is not done on Web to allow it to be tree-shaken.
 */ function Li(t) {
    return t.ru || (
    // Create stream (but note that it is not started yet).
    t.ru = function(t, e, n) {
        const s = v(t);
        return s.Fo(), new ci(e, s.eo, s.credentials, s.serializer, n);
    }(t.jo, t.On, {
        Io: Ni.bind(null, t),
        do: ki.bind(null, t),
        So: $i.bind(null, t),
        bo: xi.bind(null, t)
    }), t.Ho.push((async e => {
        e ? (t.ru.co(), 
        // This will start the write stream if necessary.
        await bi(t)) : (await t.ru.stop(), t.Go.length > 0 && (R("RemoteStore", `Stopping write stream with ${t.Go.length} pending writes`), 
        t.Go = []));
    }))), t.ru;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ class Mi {
    constructor(t) {
        this.key = t;
    }
}

class qi {
    constructor(t) {
        this.key = t;
    }
}

/**
 * View is responsible for computing the final merged truth of what docs are in
 * a query. It gets notified of local and remote changes to docs, and applies
 * the query filters and limits to determine the most correct possible results.
 */ class Ui {
    constructor(t, 
    /** Documents included in the remote target */
    e) {
        this.query = t, this.ou = e, this.uu = null, 
        /**
         * A flag whether the view is current with the backend. A view is considered
         * current after it has seen the current flag from the backend and did not
         * lose consistency within the watch stream (e.g. because of an existence
         * filter mismatch).
         */
        this.te = !1, 
        /** Documents in the view but not in the remote target */
        this.cu = Ut(), 
        /** Document Keys that have local changes */
        this.jt = Ut(), this.au = Zn(t), this.hu = new jt(this.au);
    }
    /**
     * The set of remote documents that the server has told us belongs to the target associated with
     * this view.
     */    get lu() {
        return this.ou;
    }
    /**
     * Iterates over a set of doc changes, applies the query limit, and computes
     * what the new results should be, what the changes were, and whether we may
     * need to go back to the local cache for more results. Does not make any
     * changes to the view.
     * @param docChanges The doc changes to apply to this view.
     * @param previousChanges If this is being called with a refill, then start
     *        with this set of docs and changes instead of the current view.
     * @return a new set of docs, changes, and refill flag.
     */    _u(t, e) {
        const n = e ? e.fu : new Wt, s = e ? e.hu : this.hu;
        let i = e ? e.jt : this.jt, r = s, o = !1;
        // Track the last doc in a (full) limit. This is necessary, because some
        // update (a delete, or an update moving a doc past the old limit) might
        // mean there is some other document in the local cache that either should
        // come (1) between the old last limit doc and the new last document, in the
        // case of updates, or (2) after the new last document, in the case of
        // deletes. So we keep this doc at the old limit to compare the updates to.
        // Note that this should never get used in a refill (when previousChanges is
        // set), because there will only be adds -- no deletes or updates.
        const u = Mn(this.query) && s.size === this.query.limit ? s.last() : null, c = qn(this.query) && s.size === this.query.limit ? s.first() : null;
        // Drop documents out to meet limit/limitToLast requirement.
        if (t.ht(((t, e) => {
            const a = s.get(t);
            let h = e instanceof $n ? e : null;
            h && (h = Xn(this.query, h) ? h : null);
            const l = !!a && this.jt.has(a.key), _ = !!h && (h.Je || 
            // We only consider committed mutations for documents that were
            // mutated during the lifetime of the view.
            this.jt.has(h.key) && h.hasCommittedMutations);
            let f = !1;
            // Calculate change
                        if (a && h) {
                a.data().isEqual(h.data()) ? l !== _ && (n.track({
                    type: 3 /* Metadata */ ,
                    doc: h
                }), f = !0) : this.du(a, h) || (n.track({
                    type: 2 /* Modified */ ,
                    doc: h
                }), f = !0, (u && this.au(h, u) > 0 || c && this.au(h, c) < 0) && (
                // This doc moved from inside the limit to outside the limit.
                // That means there may be some other doc in the local cache
                // that should be included instead.
                o = !0));
            } else !a && h ? (n.track({
                type: 0 /* Added */ ,
                doc: h
            }), f = !0) : a && !h && (n.track({
                type: 1 /* Removed */ ,
                doc: a
            }), f = !0, (u || c) && (
            // A doc was removed from a full limit query. We'll need to
            // requery from the local cache to see if we know about some other
            // doc that should be in the results.
            o = !0));
            f && (h ? (r = r.add(h), i = _ ? i.add(t) : i.delete(t)) : (r = r.delete(t), i = i.delete(t)));
        })), Mn(this.query) || qn(this.query)) for (;r.size > this.query.limit; ) {
            const t = Mn(this.query) ? r.last() : r.first();
            r = r.delete(t.key), i = i.delete(t.key), n.track({
                type: 1 /* Removed */ ,
                doc: t
            });
        }
        return {
            hu: r,
            fu: n,
            wu: o,
            jt: i
        };
    }
    du(t, e) {
        // We suppress the initial change event for documents that were modified as
        // part of a write acknowledgment (e.g. when the value of a server transform
        // is applied) as Watch will send us the same document again.
        // By suppressing the event, we only raise two user visible events (one with
        // `hasPendingWrites` and the final state of the document) instead of three
        // (one with `hasPendingWrites`, the modified document with
        // `hasPendingWrites` and the final state of the document).
        return t.Je && e.hasCommittedMutations && !e.Je;
    }
    /**
     * Updates the view with the given ViewDocumentChanges and optionally updates
     * limbo docs and sync state from the provided target change.
     * @param docChanges The set of changes to make to the view's docs.
     * @param updateLimboDocuments Whether to update limbo documents based on this
     *        change.
     * @param targetChange A target change to apply for computing limbo docs and
     *        sync state.
     * @return A new ViewChange with the given docs, changes, and sync state.
     */
    // PORTING NOTE: The iOS/Android clients always compute limbo document changes.
    mu(t, e, n) {
        const s = this.hu;
        this.hu = t.hu, this.jt = t.jt;
        // Sort changes based on type and query comparator
        const i = t.fu.Bt();
        i.sort(((t, e) => function(t, e) {
            const n = t => {
                switch (t) {
                  case 0 /* Added */ :
                    return 1;

                  case 2 /* Modified */ :
                  case 3 /* Metadata */ :
                    // A metadata change is converted to a modified change at the public
                    // api layer.  Since we sort by document key and then change type,
                    // metadata and modified changes must be sorted equivalently.
                    return 2;

                  case 1 /* Removed */ :
                    return 0;

                  default:
                    return p();
                }
            };
            return n(t) - n(e);
        }
        /**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ (t.type, e.type) || this.au(t.doc, e.doc))), this.Tu(n);
        const r = e ? this.Eu() : [], o = 0 === this.cu.size && this.te ? 1 /* Synced */ : 0 /* Local */ , u = o !== this.uu;
        if (this.uu = o, 0 !== i.length || u) {
            return {
                snapshot: new Gt(this.query, t.hu, s, i, t.jt, 0 /* Local */ === o, u, 
                /* excludesMetadataChanges= */ !1),
                Iu: r
            };
        }
        // no changes
        return {
            Iu: r
        };
    }
    /**
     * Applies an OnlineState change to the view, potentially generating a
     * ViewChange if the view's syncState changes as a result.
     */    As(t) {
        return this.te && "Offline" /* Offline */ === t ? (
        // If we're offline, set `current` to false and then call applyChanges()
        // to refresh our syncState and generate a ViewChange as appropriate. We
        // are guaranteed to get a new TargetChange that sets `current` back to
        // true once the client is back online.
        this.te = !1, this.mu({
            hu: this.hu,
            fu: new Wt,
            jt: this.jt,
            wu: !1
        }, 
        /* updateLimboDocuments= */ !1)) : {
            Iu: []
        };
    }
    /**
     * Returns whether the doc for the given key should be in limbo.
     */    Au(t) {
        // If the remote end says it's part of this query, it's not in limbo.
        return !this.ou.has(t) && (
        // The local store doesn't think it's a result, so it shouldn't be in limbo.
        !!this.hu.has(t) && !this.hu.get(t).Je);
    }
    /**
     * Updates syncedDocuments, current, and limbo docs based on the given change.
     * Returns the list of changes to which docs are in limbo.
     */    Tu(t) {
        t && (t.ee.forEach((t => this.ou = this.ou.add(t))), t.ne.forEach((t => {})), t.se.forEach((t => this.ou = this.ou.delete(t))), 
        this.te = t.te);
    }
    Eu() {
        // We can only determine limbo documents when we're in-sync with the server.
        if (!this.te) return [];
        // TODO(klimt): Do this incrementally so that it's not quadratic when
        // updating many documents.
                const t = this.cu;
        this.cu = Ut(), this.hu.forEach((t => {
            this.Au(t.key) && (this.cu = this.cu.add(t.key));
        }));
        // Diff the new limbo docs with the old limbo docs.
        const e = [];
        return t.forEach((t => {
            this.cu.has(t) || e.push(new qi(t));
        })), this.cu.forEach((n => {
            t.has(n) || e.push(new Mi(n));
        })), e;
    }
    /**
     * Update the in-memory state of the current view with the state read from
     * persistence.
     *
     * We update the query view whenever a client's primary status changes:
     * - When a client transitions from primary to secondary, it can miss
     *   LocalStorage updates and its query views may temporarily not be
     *   synchronized with the state on disk.
     * - For secondary to primary transitions, the client needs to update the list
     *   of `syncedDocuments` since secondary clients update their query views
     *   based purely on synthesized RemoteEvents.
     *
     * @param queryResult.documents - The documents that match the query according
     * to the LocalStore.
     * @param queryResult.remoteKeys - The keys of the documents that match the
     * query according to the backend.
     *
     * @return The ViewChange that resulted from this synchronization.
     */
    // PORTING NOTE: Multi-tab only.
    Ru(t) {
        this.ou = t.Vr, this.cu = Ut();
        const e = this._u(t.documents);
        return this.mu(e, /*updateLimboDocuments=*/ !0);
    }
    /**
     * Returns a view snapshot as if this query was just listened to. Contains
     * a document add for every existing document and the `fromCache` and
     * `hasPendingWrites` status of the already established view.
     */
    // PORTING NOTE: Multi-tab only.
    yu() {
        return Gt.zt(this.query, this.hu, this.jt, 0 /* Local */ === this.uu);
    }
}

/**
 * QueryView contains all of the data that SyncEngine needs to keep track of for
 * a particular query.
 */
class Bi {
    constructor(
    /**
     * The query itself.
     */
    t, 
    /**
     * The target number created by the client that is used in the watch
     * stream to identify this query.
     */
    e, 
    /**
     * The view is responsible for computing the final merged truth of what
     * docs are in the query. It gets notified of local and remote changes,
     * and applies the query filters and limits to determine the most correct
     * possible results.
     */
    n) {
        this.query = t, this.targetId = e, this.view = n;
    }
}

/** Tracks a limbo resolution. */ class Qi {
    constructor(t) {
        this.key = t, 
        /**
         * Set to true once we've received a document. This is used in
         * getRemoteKeysForTarget() and ultimately used by WatchChangeAggregator to
         * decide whether it needs to manufacture a delete event for the target once
         * the target is CURRENT.
         */
        this.Pu = !1;
    }
}

/**
 * An implementation of `SyncEngine` coordinating with other parts of SDK.
 *
 * The parts of SyncEngine that act as a callback to RemoteStore need to be
 * registered individually. This is done in `syncEngineWrite()` and
 * `syncEngineListen()` (as well as `applyPrimaryState()`) as these methods
 * serve as entry points to RemoteStore's functionality.
 *
 * Note: some field defined in this class might have public access level, but
 * the class is not exported so they are only accessible from this module.
 * This is useful to implement optional features (like bundles) in free
 * functions, such that they are tree-shakeable.
 */ class ji {
    constructor(t, e, n, 
    // PORTING NOTE: Manages state synchronization in multi-tab environments.
    s, i, r) {
        this.Qo = t, this.gu = e, this.pu = n, this.Vu = s, this.currentUser = i, this.vu = r, 
        this.bu = {}, this.Su = new _t((t => Yn(t)), Hn), this.Du = new Map, 
        /**
         * The keys of documents that are in limbo for which we haven't yet started a
         * limbo resolution query.
         */
        this.Cu = [], 
        /**
         * Keeps track of the target ID for each document that is in limbo with an
         * active target.
         */
        this.Fu = new St(x.i), 
        /**
         * Keeps track of the information about an active limbo resolution for each
         * active target ID that was started for the purpose of limbo resolution.
         */
        this.Nu = new Map, this.$u = new Zs, 
        /** Stores user completion handlers, indexed by User and BatchId. */
        this.xu = {}, 
        /** Stores user callbacks waiting for all pending writes to be acknowledged. */
        this.ku = new Map, this.Ou = js.Gi(), this.onlineState = "Unknown" /* Unknown */ , 
        // The primary state is set to `true` or `false` immediately after Firestore
        // startup. In the interim, a client should only be considered primary if
        // `isPrimary` is true.
        this.Lu = void 0;
    }
    get Mu() {
        return !0 === this.Lu;
    }
}

/**
 * Initiates the new listen, resolves promise when listen enqueued to the
 * server. All the subsequent view snapshots or errors are sent to the
 * subscribed handlers. Returns the initial snapshot.
 */
async function Wi(t, e) {
    const n = function(t) {
        const e = v(t);
        return e.gu.Wo.eu = Ki.bind(null, e), e.gu.Wo.Ue = ar.bind(null, e), e.gu.Wo.tu = Yi.bind(null, e), 
        e.bu.Ro = Ss.bind(null, e.pu), e.bu.qu = Ds.bind(null, e.pu), e;
    }(t);
    let s, i;
    const r = n.Su.get(e);
    if (r) 
    // PORTING NOTE: With Multi-Tab Web, it is possible that a query view
    // already exists when EventManager calls us for the first time. This
    // happens when the primary tab is already listening to this query on
    // behalf of another tab and the user of the primary also starts listening
    // to the query. EventManager will not have an assigned target ID in this
    // case and calls `listen` to obtain this ID.
    s = r.targetId, n.Vu.zs(s), i = r.view.yu(); else {
        const t = await 
        /**
 * Assigns the given target an internal ID so that its results can be pinned so
 * they don't get GC'd. A target must be allocated in the local store before
 * the store can be used to manage its view.
 *
 * Allocating an already allocated `Target` will return the existing `TargetData`
 * for that `Target`.
 */
        function(t, e) {
            const n = v(t);
            return n.persistence.runTransaction("Allocate target", "readwrite", (t => {
                let s;
                return n.tr.gr(t, e).next((i => i ? (
                // This target has been listened to previously, so reuse the
                // previous targetID.
                // TODO(mcg): freshen last accessed date?
                s = i, Is.resolve(s)) : n.tr.Uu(t).next((i => (s = new Pt(e, i, 0 /* Listen */ , t.Tr), 
                n.tr.Bu(t, s).next((() => s)))))));
            })).then((t => {
                // If Multi-Tab is enabled, the existing target data may be newer than
                // the in-memory data
                const s = n.Ki.get(t.targetId);
                return (null === s || t.nt.M(s.nt) > 0) && (n.Ki = n.Ki.ot(t.targetId, t), n.Hi.set(e, t.targetId)), 
                t;
            }));
        }(n.Qo, Wn(e)), r = n.Vu.zs(t.targetId);
        s = t.targetId, i = await 
        /**
 * Registers a view for a previously unknown query and computes its initial
 * snapshot.
 */
        async function(t, e, n, s) {
            // PORTING NOTE: On Web only, we inject the code that registers new Limbo
            // targets based on view changes. This allows us to only depend on Limbo
            // changes when user code includes queries.
            t.Qu = (e, n, s) => async function(t, e, n, s) {
                let i = e.view._u(n);
                i.wu && (
                // The query has a limit and some docs were removed, so we need
                // to re-run the query against the local store to make sure we
                // didn't lose any good docs that had been past the limit.
                i = await Js(t.Qo, e.query, 
                /* usePreviousResults= */ !1).then((({documents: t}) => e.view._u(t, i))));
                const r = s && s.Kt.get(e.targetId), o = e.view.mu(i, 
                /* updateLimboDocuments= */ t.Mu, r);
                return ir(t, e.targetId, o.Iu), o.snapshot;
            }(t, e, n, s);
            const i = await Js(t.Qo, e, 
            /* usePreviousResults= */ !0), r = new Ui(e, i.Vr), o = r._u(i.documents), u = Kt.Zt(n, s && "Offline" /* Offline */ !== t.onlineState), c = r.mu(o, 
            /* updateLimboDocuments= */ t.Mu, u);
            ir(t, n, c.Iu);
            const a = new Bi(e, n, r);
            t.Su.set(e, a), t.Du.has(n) ? t.Du.get(n).push(e) : t.Du.set(n, [ e ]);
            return c.snapshot;
        }
        /** Stops listening to the query. */ (n, e, s, "current" === r), n.Mu && wi(n.gu, t);
    }
    return i;
}

async function Gi(t, e) {
    const n = v(t), s = n.Su.get(e), i = n.Du.get(s.targetId);
    if (i.length > 1) return n.Du.set(s.targetId, i.filter((t => !Hn(t, e)))), void n.Su.delete(e);
    // No other queries are mapped to the target, clean up the query and the target.
        if (n.Mu) {
        // We need to remove the local query target first to allow us to verify
        // whether any other client is still interested in this target.
        n.Vu.Hs(s.targetId);
        n.Vu.Zs(s.targetId) || await Ys(n.Qo, s.targetId, 
        /*keepPersistedTargetData=*/ !1).then((() => {
            n.Vu.Js(s.targetId), mi(n.gu, s.targetId), nr(n, s.targetId);
        })).catch(Xs);
    } else nr(n, s.targetId), await Ys(n.Qo, s.targetId, 
    /*keepPersistedTargetData=*/ !0);
}

/**
 * Initiates the write of local mutation batch which involves adding the
 * writes to the mutation queue, notifying the remote store about new
 * mutations and raising events for any changes this write caused.
 *
 * The promise returned by this call is resolved when the above steps
 * have completed, *not* when the write was acked by the backend. The
 * userCallback is resolved once the write was acked/rejected by the
 * backend (or failed locally for any other reason).
 */ async function zi(t, e, n) {
    const s = function(t) {
        const e = v(t);
        return e.gu.Wo.nu = Ji.bind(null, e), e.gu.Wo.su = Xi.bind(null, e), e;
    }
    /**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
    // TOOD(b/140938512): Drop SimpleQueryEngine and rename IndexFreeQueryEngine.
    /**
 * A query engine that takes advantage of the target document mapping in the
 * QueryCache. The IndexFreeQueryEngine optimizes query execution by only
 * reading the documents that previously matched a query plus any documents that were
 * edited after the query was last listened to.
 *
 * There are some cases where Index-Free queries are not guaranteed to produce
 * the same results as full collection scans. In these cases, the
 * IndexFreeQueryEngine falls back to full query processing. These cases are:
 *
 * - Limit queries where a document that matched the query previously no longer
 *   matches the query.
 *
 * - Limit queries where a document edit may cause the document to sort below
 *   another document that is in the local cache.
 *
 * - Queries that have never been CURRENT or free of Limbo documents.
 */ (t);
    try {
        const t = await 
        /* Accepts locally generated Mutations and commit them to storage. */
        function(t, e) {
            const n = v(t), s = ft.now(), i = e.reduce(((t, e) => t.add(e.key)), Ut());
            let r;
            return n.persistence.runTransaction("Locally write mutations", "readwrite", (t => n.nr.Ei(t, i).next((i => {
                r = i;
                // For non-idempotent mutations (such as `FieldValue.increment()`),
                // we record the base state in a separate patch mutation. This is
                // later used to guarantee consistent values and prevents flicker
                // even if the backend sends us an update that already includes our
                // transform.
                const o = [];
                for (const t of e) {
                    const e = In(t, r.get(t.key));
                    null != e && 
                    // NOTE: The base state should only be applied if there's some
                    // existing document to override, so use a Precondition of
                    // exists=true
                    o.push(new Pn(t.key, e, Fn(e.proto.mapValue), dn.exists(!0)));
                }
                return n.li.ju(t, s, o, e);
            })))).then((t => {
                const e = t.ui(r);
                return {
                    batchId: t.batchId,
                    Wu: e
                };
            }));
        }(s.Qo, e);
        s.Vu.Ws(t.batchId), function(t, e, n) {
            let s = t.xu[t.currentUser.Cs()];
            s || (s = new St(it));
            s = s.ot(e, n), t.xu[t.currentUser.Cs()] = s;
        }
        /**
 * Resolves or rejects the user callback for the given batch and then discards
 * it.
 */ (s, t.batchId, n), await ur(s, t.Wu), await bi(s.gu);
    } catch (t) {
        // If we can't persist the mutation, we reject the user callback and
        // don't send the mutation. The user can then retry the write.
        const e = gs(t, "Failed to persist write");
        n.reject(e);
    }
}

/**
 * Applies one remote event to the sync engine, notifying any views of the
 * changes, and releasing any pending mutation batches that would become
 * visible because of the snapshot version the remote event contains.
 */ async function Ki(t, e) {
    const n = v(t);
    try {
        const t = await Ks(n.Qo, e);
        // Update `receivedDocument` as appropriate for any limbo targets.
                e.Kt.forEach(((t, e) => {
            const s = n.Nu.get(e);
            s && (
            // Since this is a limbo resolution lookup, it's for a single document
            // and it could be added, modified, or removed, but not a combination.
            V(t.ee.size + t.ne.size + t.se.size <= 1), t.ee.size > 0 ? s.Pu = !0 : t.ne.size > 0 ? V(s.Pu) : t.se.size > 0 && (V(s.Pu), 
            s.Pu = !1));
        })), await ur(n, t, e);
    } catch (t) {
        await Xs(t);
    }
}

/**
 * Applies an OnlineState change to the sync engine and notifies any views of
 * the change.
 */ function Hi(t, e, n) {
    const s = v(t);
    // If we are the secondary client, we explicitly ignore the remote store's
    // online state (the local client may go offline, even though the primary
    // tab remains online) and only apply the primary tab's online state from
    // SharedClientState.
        if (s.Mu && 0 /* RemoteStore */ === n || !s.Mu && 1 /* SharedClientState */ === n) {
        const t = [];
        s.Su.forEach(((n, s) => {
            const i = s.view.As(e);
            i.snapshot && t.push(i.snapshot);
        })), function(t, e) {
            const n = v(t);
            n.onlineState = e;
            let s = !1;
            n.Ts.forEach(((t, n) => {
                for (const t of n.listeners) 
                // Run global snapshot listeners if a consistent snapshot has been emitted.
                t.As(e) && (s = !0);
            })), s && Cs(n);
        }(s.pu, e), t.length && s.bu.Ro(t), s.onlineState = e, s.Mu && s.Vu.ei(e);
    }
}

/**
 * Rejects the listen for the given targetID. This can be triggered by the
 * backend for any active target.
 *
 * @param syncEngine The sync engine implementation.
 * @param targetId The targetID corresponds to one previously initiated by the
 * user as part of TargetData passed to listen() on RemoteStore.
 * @param err A description of the condition that has forced the rejection.
 * Nearly always this will be an indication that the user is no longer
 * authorized to see the data matching the target.
 */ async function Yi(t, e, n) {
    const s = v(t);
    // PORTING NOTE: Multi-tab only.
        s.Vu.Ks(e, "rejected", n);
    const i = s.Nu.get(e), r = i && i.key;
    if (r) {
        // TODO(klimt): We really only should do the following on permission
        // denied errors, but we don't have the cause code here.
        // It's a limbo doc. Create a synthetic event saying it was deleted.
        // This is kind of a hack. Ideally, we would have a method in the local
        // store to purge a document. However, it would be tricky to keep all of
        // the local store's invariants with another method.
        let t = new St(x.i);
        t = t.ot(r, new xn(r, dt.min()));
        const n = Ut().add(r), i = new zt(dt.min(), 
        /* targetChanges= */ new Map, 
        /* targetMismatches= */ new Ft(it), t, n);
        await Ki(s, i), 
        // Since this query failed, we won't want to manually unlisten to it.
        // We only remove it from bookkeeping after we successfully applied the
        // RemoteEvent. If `applyRemoteEvent()` throws, we want to re-listen to
        // this query when the RemoteStore restarts the Watch stream, which should
        // re-trigger the target failure.
        s.Fu = s.Fu.remove(r), s.Nu.delete(e), or(s);
    } else await Ys(s.Qo, e, 
    /* keepPersistedTargetData */ !1).then((() => nr(s, e, n))).catch(Xs);
}

async function Ji(t, e) {
    const n = v(t), s = e.batch.batchId;
    try {
        const t = await Gs(n.Qo, e);
        // The local store may or may not be able to apply the write result and
        // raise events immediately (depending on whether the watcher is caught
        // up), so we raise user callbacks first so that they consistently happen
        // before listen events.
                er(n, s, /*error=*/ null), tr(n, s), n.Vu.Gs(s, "acknowledged"), await ur(n, t);
    } catch (t) {
        await Xs(t);
    }
}

async function Xi(t, e, n) {
    const s = v(t);
    try {
        const t = await function(t, e) {
            const n = v(t);
            return n.persistence.runTransaction("Reject batch", "readwrite-primary", (t => {
                let s;
                return n.li.Gu(t, e).next((e => (V(null !== e), s = e.keys(), n.li.lr(t, e)))).next((() => n.li._r(t))).next((() => n.nr.Ei(t, s)));
            }));
        }
        /**
 * Returns the largest (latest) batch id in mutation queue that is pending
 * server response.
 *
 * Returns `BATCHID_UNKNOWN` if the queue is empty.
 */ (s.Qo, e);
        // The local store may or may not be able to apply the write result and
        // raise events immediately (depending on whether the watcher is caught up),
        // so we raise user callbacks first so that they consistently happen before
        // listen events.
                er(s, e, n), tr(s, e), s.Vu.Gs(e, "rejected", n), await ur(s, t);
    } catch (n) {
        await Xs(n);
    }
}

/**
 * Registers a user callback that resolves when all pending mutations at the moment of calling
 * are acknowledged .
 */ async function Zi(t, e) {
    const n = v(t);
    Ri(n.gu) || R("SyncEngine", "The network is disabled. The task returned by 'awaitPendingWrites()' will not complete until the network is enabled.");
    try {
        const t = await function(t) {
            const e = v(t);
            return e.persistence.runTransaction("Get highest unacknowledged batch id", "readonly", (t => e.li.zu(t)));
        }(n.Qo);
        if (-1 === t) 
        // Trigger the callback right away if there is no pending writes at the moment.
        return void e.resolve();
        const s = n.ku.get(t) || [];
        s.push(e), n.ku.set(t, s);
    } catch (t) {
        const n = gs(t, "Initialization of waitForPendingWrites() operation failed");
        e.reject(n);
    }
}

/**
 * Triggers the callbacks that are waiting for this batch id to get acknowledged by server,
 * if there are any.
 */ function tr(t, e) {
    (t.ku.get(e) || []).forEach((t => {
        t.resolve();
    })), t.ku.delete(e);
}

/** Reject all outstanding callbacks waiting for pending writes to complete. */ function er(t, e, n) {
    const s = v(t);
    let i = s.xu[s.currentUser.Cs()];
    // NOTE: Mutations restored from persistence won't have callbacks, so it's
    // okay for there to be no callback for this ID.
        if (i) {
        const t = i.get(e);
        t && (n ? t.reject(n) : t.resolve(), i = i.remove(e)), s.xu[s.currentUser.Cs()] = i;
    }
}

function nr(t, e, n = null) {
    t.Vu.Hs(e);
    for (const s of t.Du.get(e)) t.Su.delete(s), n && t.bu.qu(s, n);
    if (t.Du.delete(e), t.Mu) {
        t.$u.Or(e).forEach((e => {
            t.$u.qr(e) || 
            // We removed the last reference for this key
            sr(t, e);
        }));
    }
}

function sr(t, e) {
    // It's possible that the target already got removed because the query failed. In that case,
    // the key won't exist in `limboTargetsByKey`. Only do the cleanup if we still have the target.
    const n = t.Fu.get(e);
    null !== n && (mi(t.gu, n), t.Fu = t.Fu.remove(e), t.Nu.delete(n), or(t));
}

function ir(t, e, n) {
    for (const s of n) if (s instanceof Mi) t.$u.Cr(s.key, e), rr(t, s); else if (s instanceof qi) {
        R("SyncEngine", "Document no longer in limbo: " + s.key), t.$u.Nr(s.key, e);
        t.$u.qr(s.key) || 
        // We removed the last reference for this key
        sr(t, s.key);
    } else p();
}

function rr(t, e) {
    const n = e.key;
    t.Fu.get(n) || (R("SyncEngine", "New document in limbo: " + n), t.Cu.push(n), or(t));
}

/**
 * Starts listens for documents in limbo that are enqueued for resolution,
 * subject to a maximum number of concurrent resolutions.
 *
 * Without bounding the number of concurrent resolutions, the server can fail
 * with "resource exhausted" errors which can lead to pathological client
 * behavior as seen in https://github.com/firebase/firebase-js-sdk/issues/2683.
 */ function or(t) {
    for (;t.Cu.length > 0 && t.Fu.size < t.vu; ) {
        const e = t.Cu.shift(), n = t.Ou.next();
        t.Nu.set(n, new Qi(e)), t.Fu = t.Fu.ot(e, n), wi(t.gu, new Pt(Wn(Ln(e.path)), n, 2 /* LimboResolution */ , $s.Ls));
    }
}

async function ur(t, e, n) {
    const s = v(t), i = [], r = [], o = [];
    s.Su.m() || (s.Su.forEach(((t, u) => {
        o.push(s.Qu(u, e, n).then((t => {
            if (t) {
                s.Mu && s.Vu.Ks(u.targetId, t.fromCache ? "not-current" : "current"), i.push(t);
                const e = qs.Di(u.targetId, t);
                r.push(e);
            }
        })));
    })), await Promise.all(o), s.bu.Ro(i), await async function(t, e) {
        const n = v(t);
        try {
            await n.persistence.runTransaction("notifyLocalViewChanges", "readwrite", (t => Is.forEach(e, (e => Is.forEach(e.bi, (s => n.persistence.Rr.Cr(t, e.targetId, s))).next((() => Is.forEach(e.Si, (s => n.persistence.Rr.Nr(t, e.targetId, s)))))))));
        } catch (t) {
            if (!As(t)) throw t;
            // If `notifyLocalViewChanges` fails, we did not advance the sequence
            // number for the documents that were included in this transaction.
            // This might trigger them to be deleted earlier than they otherwise
            // would have, but it should not invalidate the integrity of the data.
            R("LocalStore", "Failed to update sequence numbers: " + t);
        }
        for (const t of e) {
            const e = t.targetId;
            if (!t.fromCache) {
                const t = n.Ki.get(e), s = t.nt, i = t.rt(s);
                // Advance the last limbo free snapshot version
                                n.Ki = n.Ki.ot(e, i);
            }
        }
    }(s.Qo, r));
}

async function cr(t, e) {
    const n = v(t);
    if (!n.currentUser.isEqual(e)) {
        R("SyncEngine", "User change. New user:", e.Cs());
        const t = await 
        /**
 * Tells the LocalStore that the currently authenticated user has changed.
 *
 * In response the local store switches the mutation queue to the new user and
 * returns any resulting document changes.
 */
        // PORTING NOTE: Android and iOS only return the documents affected by the
        // change.
        async function(t, e) {
            const n = v(t);
            let s = n.li, i = n.nr;
            const r = await n.persistence.runTransaction("Handle user change", "readonly", (t => {
                // Swap out the mutation queue, grabbing the pending mutation batches
                // before and after.
                let r;
                return n.li.Ku(t).next((o => (r = o, s = n.persistence.Ji(e), 
                // Recreate our LocalDocumentsView using the new
                // MutationQueue.
                i = new Ms(n.Xi, s, n.persistence.sr()), s.Ku(t)))).next((e => {
                    const n = [], s = [];
                    // Union the old/new changed keys.
                    let o = Ut();
                    for (const t of r) {
                        n.push(t.batchId);
                        for (const e of t.mutations) o = o.add(e.key);
                    }
                    for (const t of e) {
                        s.push(t.batchId);
                        for (const e of t.mutations) o = o.add(e.key);
                    }
                    // Return the set of all (potentially) changed documents and the list
                    // of mutation batch IDs that were affected by change.
                                        return i.Ei(t, o).next((t => ({
                        Hu: t,
                        Yu: n,
                        Ju: s
                    })));
                }));
            }));
            return n.li = s, n.nr = i, n.zi.ir(n.nr), r;
        }(n.Qo, e);
        n.currentUser = e, 
        // Fails tasks waiting for pending writes requested by previous user.
        function(t, e) {
            t.ku.forEach((t => {
                t.forEach((t => {
                    t.reject(new E(T.CANCELLED, e));
                }));
            })), t.ku.clear();
        }(n, "'waitForPendingWrites' promise is rejected due to a user change."), 
        // TODO(b/114226417): Consider calling this only in the primary tab.
        n.Vu.ti(e, t.Yu, t.Ju), await ur(n, t.Hu);
    }
}

function ar(t, e) {
    const n = v(t), s = n.Nu.get(e);
    if (s && s.Pu) return Ut().add(s.key);
    {
        let t = Ut();
        const s = n.Du.get(e);
        if (!s) return t;
        for (const e of s) {
            const s = n.Su.get(e);
            t = t.kt(s.view.lu);
        }
        return t;
    }
}

class hr {
    ir(t) {
        this.Xu = t;
    }
    Ri(t, e, n, s) {
        // Queries that match all documents don't benefit from using
        // IndexFreeQueries. It is more efficient to scan all documents in a
        // collection, rather than to perform individual lookups.
        return function(t) {
            return 0 === t.filters.length && null === t.limit && null == t.startAt && null == t.endAt && (0 === t.on.length || 1 === t.on.length && t.on[0].field.V());
        }(e) || n.isEqual(dt.min()) ? this.Zu(t, e) : this.Xu.Ei(t, s).next((i => {
            const r = this.tc(e, i);
            return (Mn(e) || qn(e)) && this.wu(e.un, r, s, n) ? this.Zu(t, e) : (A() <= a.DEBUG && R("IndexFreeQueryEngine", "Re-using previous result from %s to execute query: %s", n.toString(), Jn(e)), 
            this.Xu.Ri(t, e, n).next((t => (
            // We merge `previousResults` into `updateResults`, since
            // `updateResults` is already a DocumentMap. If a document is
            // contained in both lists, then its contents are the same.
            r.forEach((e => {
                t = t.ot(e.key, e);
            })), t))));
        }));
        // Queries that have never seen a snapshot without limbo free documents
        // should also be run as a full collection scan.
        }
    /** Applies the query filter and sorting to the provided documents.  */    tc(t, e) {
        // Sort the documents and re-apply the query filter since previously
        // matching documents do not necessarily still match the query.
        let n = new Ft(Zn(t));
        return e.forEach(((e, s) => {
            s instanceof $n && Xn(t, s) && (n = n.add(s));
        })), n;
    }
    /**
     * Determines if a limit query needs to be refilled from cache, making it
     * ineligible for index-free execution.
     *
     * @param sortedPreviousResults The documents that matched the query when it
     * was last synchronized, sorted by the query's comparator.
     * @param remoteKeys The document keys that matched the query at the last
     * snapshot.
     * @param limboFreeSnapshotVersion The version of the snapshot when the query
     * was last synchronized.
     */    wu(t, e, n, s) {
        // The query needs to be refilled if a previously matching document no
        // longer matches.
        if (n.size !== e.size) return !0;
        // Limit queries are not eligible for index-free query execution if there is
        // a potential that an older document from cache now sorts before a document
        // that was previously part of the limit. This, however, can only happen if
        // the document at the edge of the limit goes out of limit.
        // If a document that is not the limit boundary sorts differently,
        // the boundary of the limit itself did not change and documents from cache
        // will continue to be "rejected" by this boundary. Therefore, we can ignore
        // any modifications that don't affect the last document.
                const i = "F" /* First */ === t ? e.last() : e.first();
        return !!i && (i.hasPendingWrites || i.version.M(s) > 0);
    }
    Zu(t, e) {
        return A() <= a.DEBUG && R("IndexFreeQueryEngine", "Using full collection scan to execute query:", Jn(e)), 
        this.Xu.Ri(t, e, dt.min());
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ class lr {
    constructor(t, e) {
        this._i = t, this.Rr = e, 
        /**
         * The set of all mutations that have been sent but not yet been applied to
         * the backend.
         */
        this.li = [], 
        /** Next value to use when assigning sequential IDs to each mutation batch. */
        this.ec = 1, 
        /** An ordered mapping between documents and the mutations batch IDs. */
        this.nc = new Ft(ti.br);
    }
    sc(t) {
        return Is.resolve(0 === this.li.length);
    }
    ju(t, e, n, s) {
        const i = this.ec;
        if (this.ec++, this.li.length > 0) {
            this.li[this.li.length - 1];
        }
        const r = new Os(i, e, n, s);
        this.li.push(r);
        // Track references by document key and index collection parents.
        for (const e of s) this.nc = this.nc.add(new ti(e.key, i)), this._i.Qi(t, e.key.path.h());
        return Is.resolve(r);
    }
    Gu(t, e) {
        return Is.resolve(this.ic(e));
    }
    Pr(t, e) {
        const n = e + 1, s = this.rc(n), i = s < 0 ? 0 : s;
        // The requested batchId may still be out of range so normalize it to the
        // start of the queue.
                return Is.resolve(this.li.length > i ? this.li[i] : null);
    }
    zu() {
        return Is.resolve(0 === this.li.length ? -1 : this.ec - 1);
    }
    Ku(t) {
        return Is.resolve(this.li.slice());
    }
    di(t, e) {
        const n = new ti(e, 0), s = new ti(e, Number.POSITIVE_INFINITY), i = [];
        return this.nc.Nt([ n, s ], (t => {
            const e = this.ic(t.Ur);
            i.push(e);
        })), Is.resolve(i);
    }
    Ai(t, e) {
        let n = new Ft(it);
        return e.forEach((t => {
            const e = new ti(t, 0), s = new ti(t, Number.POSITIVE_INFINITY);
            this.nc.Nt([ e, s ], (t => {
                n = n.add(t.Ur);
            }));
        })), Is.resolve(this.oc(n));
    }
    Vi(t, e) {
        // Use the query path as a prefix for testing if a document matches the
        // query.
        const n = e.path, s = n.length + 1;
        // Construct a document reference for actually scanning the index. Unlike
        // the prefix the document key in this reference must have an even number of
        // segments. The empty segment can be used a suffix of the query path
        // because it precedes all other segments in an ordered traversal.
        let i = n;
        x.N(i) || (i = i.child(""));
        const r = new ti(new x(i), 0);
        // Find unique batchIDs referenced by all documents potentially matching the
        // query.
                let o = new Ft(it);
        return this.nc.$t((t => {
            const e = t.key.path;
            return !!n.T(e) && (
            // Rows with document keys more than one segment longer than the query
            // path can't be matches. For example, a query on 'rooms' can't match
            // the document /rooms/abc/messages/xyx.
            // TODO(mcg): we'll need a different scanner when we implement
            // ancestor queries.
            e.length === s && (o = o.add(t.Ur)), !0);
        }), r), Is.resolve(this.oc(o));
    }
    oc(t) {
        // Construct an array of matching batches, sorted by batchID to ensure that
        // multiple mutations affecting the same document key are applied in order.
        const e = [];
        return t.forEach((t => {
            const n = this.ic(t);
            null !== n && e.push(n);
        })), e;
    }
    lr(t, e) {
        V(0 === this.uc(e.batchId, "removed")), this.li.shift();
        let n = this.nc;
        return Is.forEach(e.mutations, (s => {
            const i = new ti(s.key, e.batchId);
            return n = n.delete(i), this.Rr.cc(t, s.key);
        })).next((() => {
            this.nc = n;
        }));
    }
    ac(t) {
        // No-op since the memory mutation queue does not maintain a separate cache.
    }
    qr(t, e) {
        const n = new ti(e, 0), s = this.nc.xt(n);
        return Is.resolve(e.isEqual(s && s.key));
    }
    _r(t) {
        return this.li.length, Is.resolve();
    }
    /**
     * Finds the index of the given batchId in the mutation queue and asserts that
     * the resulting index is within the bounds of the queue.
     *
     * @param batchId The batchId to search for
     * @param action A description of what the caller is doing, phrased in passive
     * form (e.g. "acknowledged" in a routine that acknowledges batches).
     */    uc(t, e) {
        return this.rc(t);
    }
    /**
     * Finds the index of the given batchId in the mutation queue. This operation
     * is O(1).
     *
     * @return The computed index of the batch with the given batchId, based on
     * the state of the queue. Note this index can be negative if the requested
     * batchId has already been remvoed from the queue or past the end of the
     * queue if the batchId is larger than the last added batch.
     */    rc(t) {
        if (0 === this.li.length) 
        // As an index this is past the end of the queue
        return 0;
        // Examine the front of the queue to figure out the difference between the
        // batchId and indexes in the array. Note that since the queue is ordered
        // by batchId, if the first batch has a larger batchId then the requested
        // batchId doesn't exist in the queue.
                return t - this.li[0].batchId;
    }
    /**
     * A version of lookupMutationBatch that doesn't return a promise, this makes
     * other functions that uses this code easier to read and more efficent.
     */    ic(t) {
        const e = this.rc(t);
        if (e < 0 || e >= this.li.length) return null;
        return this.li[e];
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * The memory-only RemoteDocumentCache for IndexedDb. To construct, invoke
 * `newMemoryRemoteDocumentCache()`.
 */
class _r {
    /**
     * @param sizer Used to assess the size of a document. For eager GC, this is expected to just
     * return 0 to avoid unnecessarily doing the work of calculating the size.
     */
    constructor(t, e) {
        this._i = t, this.hc = e, 
        /** Underlying cache of documents and their read times. */
        this.docs = new St(x.i), 
        /** Size of all cached documents. */
        this.size = 0;
    }
    /**
     * Adds the supplied entry to the cache and updates the cache size as appropriate.
     *
     * All calls of `addEntry`  are required to go through the RemoteDocumentChangeBuffer
     * returned by `newChangeBuffer()`.
     */    hr(t, e, n) {
        const s = e.key, i = this.docs.get(s), r = i ? i.size : 0, o = this.hc(e);
        return this.docs = this.docs.ot(s, {
            lc: e,
            size: o,
            readTime: n
        }), this.size += o - r, this._i.Qi(t, s.path.h());
    }
    /**
     * Removes the specified entry from the cache and updates the cache size as appropriate.
     *
     * All calls of `removeEntry` are required to go through the RemoteDocumentChangeBuffer
     * returned by `newChangeBuffer()`.
     */    Ir(t) {
        const e = this.docs.get(t);
        e && (this.docs = this.docs.remove(t), this.size -= e.size);
    }
    mi(t, e) {
        const n = this.docs.get(e);
        return Is.resolve(n ? n.lc : null);
    }
    getEntries(t, e) {
        let n = kt();
        return e.forEach((t => {
            const e = this.docs.get(t);
            n = n.ot(t, e ? e.lc : null);
        })), Is.resolve(n);
    }
    Ri(t, e, n) {
        let s = Lt();
        // Documents are ordered by key, so we can use a prefix scan to narrow down
        // the documents we need to match the query against.
                const i = new x(e.path.child("")), r = this.docs.ft(i);
        for (;r.At(); ) {
            const {key: t, value: {lc: i, readTime: o}} = r.It();
            if (!e.path.T(t.path)) break;
            o.M(n) <= 0 || i instanceof $n && Xn(e, i) && (s = s.ot(i.key, i));
        }
        return Is.resolve(s);
    }
    _c(t, e) {
        return Is.forEach(this.docs, (t => e(t)));
    }
    cr(t) {
        // `trackRemovals` is ignores since the MemoryRemoteDocumentCache keeps
        // a separate changelog and does not need special handling for removals.
        return new fr(this);
    }
    fc(t) {
        return Is.resolve(this.size);
    }
}

/**
 * Creates a new memory-only RemoteDocumentCache.
 *
 * @param indexManager A class that manages collection group indices.
 * @param sizer Used to assess the size of a document. For eager GC, this is expected to just
 * return 0 to avoid unnecessarily doing the work of calculating the size.
 */
/**
 * Handles the details of adding and updating documents in the MemoryRemoteDocumentCache.
 */
class fr extends class {
    constructor() {
        // A mapping of document key to the new cache entry that should be written (or null if any
        // existing cache entry should be removed).
        this.Wu = new _t((t => t.toString()), ((t, e) => t.isEqual(e))), this.dc = !1;
    }
    set readTime(t) {
        this.wc = t;
    }
    get readTime() {
        return this.wc;
    }
    /**
     * Buffers a `RemoteDocumentCache.addEntry()` call.
     *
     * You can only modify documents that have already been retrieved via
     * `getEntry()/getEntries()` (enforced via IndexedDbs `apply()`).
     */    hr(t, e) {
        this.mc(), this.readTime = e, this.Wu.set(t.key, t);
    }
    /**
     * Buffers a `RemoteDocumentCache.removeEntry()` call.
     *
     * You can only remove documents that have already been retrieved via
     * `getEntry()/getEntries()` (enforced via IndexedDbs `apply()`).
     */    Ir(t, e) {
        this.mc(), e && (this.readTime = e), this.Wu.set(t, null);
    }
    /**
     * Looks up an entry in the cache. The buffered changes will first be checked,
     * and if no buffered change applies, this will forward to
     * `RemoteDocumentCache.getEntry()`.
     *
     * @param transaction The transaction in which to perform any persistence
     *     operations.
     * @param documentKey The key of the entry to look up.
     * @return The cached Document or NoDocument entry, or null if we have nothing
     * cached.
     */    mi(t, e) {
        this.mc();
        const n = this.Wu.get(e);
        return void 0 !== n ? Is.resolve(n) : this.Tc(t, e);
    }
    /**
     * Looks up several entries in the cache, forwarding to
     * `RemoteDocumentCache.getEntry()`.
     *
     * @param transaction The transaction in which to perform any persistence
     *     operations.
     * @param documentKeys The keys of the entries to look up.
     * @return A map of cached `Document`s or `NoDocument`s, indexed by key. If an
     *     entry cannot be found, the corresponding key will be mapped to a null
     *     value.
     */    getEntries(t, e) {
        return this.Ec(t, e);
    }
    /**
     * Applies buffered changes to the underlying RemoteDocumentCache, using
     * the provided transaction.
     */    apply(t) {
        return this.mc(), this.dc = !0, this.mu(t);
    }
    /** Helper to assert this.changes is not null  */    mc() {}
}
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ {
    constructor(t) {
        super(), this.Ic = t;
    }
    mu(t) {
        const e = [];
        return this.Wu.forEach(((n, s) => {
            s ? e.push(this.Ic.hr(t, s, this.readTime)) : this.Ic.Ir(n);
        })), Is.xn(e);
    }
    Tc(t, e) {
        return this.Ic.mi(t, e);
    }
    Ec(t, e) {
        return this.Ic.getEntries(t, e);
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ class dr {
    constructor(t) {
        this.persistence = t, 
        /**
         * Maps a target to the data about that target
         */
        this.Ac = new _t((t => It(t)), Rt), 
        /** The last received snapshot version. */
        this.lastRemoteSnapshotVersion = dt.min(), 
        /** The highest numbered target ID encountered. */
        this.highestTargetId = 0, 
        /** The highest sequence number encountered. */
        this.Rc = 0, 
        /**
         * A ordered bidirectional mapping between documents and the remote target
         * IDs.
         */
        this.yc = new Zs, this.targetCount = 0, this.Pc = js.Wi();
    }
    Ce(t, e) {
        return this.Ac.forEach(((t, n) => e(n))), Is.resolve();
    }
    dr(t) {
        return Is.resolve(this.lastRemoteSnapshotVersion);
    }
    gc(t) {
        return Is.resolve(this.Rc);
    }
    Uu(t) {
        return this.highestTargetId = this.Pc.next(), Is.resolve(this.highestTargetId);
    }
    yr(t, e, n) {
        return n && (this.lastRemoteSnapshotVersion = n), e > this.Rc && (this.Rc = e), 
        Is.resolve();
    }
    Vc(t) {
        this.Ac.set(t.target, t);
        const e = t.targetId;
        e > this.highestTargetId && (this.Pc = new js(e), this.highestTargetId = e), t.sequenceNumber > this.Rc && (this.Rc = t.sequenceNumber);
    }
    Bu(t, e) {
        return this.Vc(e), this.targetCount += 1, Is.resolve();
    }
    Er(t, e) {
        return this.Vc(e), Is.resolve();
    }
    vc(t, e) {
        return this.Ac.delete(e.target), this.yc.Or(e.targetId), this.targetCount -= 1, 
        Is.resolve();
    }
    bc(t, e, n) {
        let s = 0;
        const i = [];
        return this.Ac.forEach(((r, o) => {
            o.sequenceNumber <= e && null === n.get(o.targetId) && (this.Ac.delete(r), i.push(this.Sc(t, o.targetId)), 
            s++);
        })), Is.xn(i).next((() => s));
    }
    Dc(t) {
        return Is.resolve(this.targetCount);
    }
    gr(t, e) {
        const n = this.Ac.get(e) || null;
        return Is.resolve(n);
    }
    mr(t, e, n) {
        return this.yc.Fr(e, n), Is.resolve();
    }
    wr(t, e, n) {
        this.yc.kr(e, n);
        const s = this.persistence.Rr, i = [];
        return s && e.forEach((e => {
            i.push(s.cc(t, e));
        })), Is.xn(i);
    }
    Sc(t, e) {
        return this.yc.Or(e), Is.resolve();
    }
    pr(t, e) {
        const n = this.yc.Mr(e);
        return Is.resolve(n);
    }
    qr(t, e) {
        return Is.resolve(this.yc.qr(e));
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A memory-backed instance of Persistence. Data is stored only in RAM and
 * not persisted across sessions.
 */
class wr {
    /**
     * The constructor accepts a factory for creating a reference delegate. This
     * allows both the delegate and this instance to have strong references to
     * each other without having nullable fields that would then need to be
     * checked or asserted on every access.
     */
    constructor(t) {
        this.Cc = {}, this.Fc = new $s(0), this.Nc = !1, this.Nc = !0, this.Rr = t(this), 
        this.tr = new dr(this);
        this._i = new Bs, this.hi = function(t, e) {
            return new _r(t, e);
        }(this._i, (t => this.Rr.$c(t)));
    }
    start() {
        return Promise.resolve();
    }
    ni() {
        // No durable state to ensure is closed on shutdown.
        return this.Nc = !1, Promise.resolve();
    }
    get xc() {
        return this.Nc;
    }
    kc() {
        // No op.
    }
    Oc() {
        // No op.
    }
    sr() {
        return this._i;
    }
    Ji(t) {
        let e = this.Cc[t.Cs()];
        return e || (e = new lr(this._i, this.Rr), this.Cc[t.Cs()] = e), e;
    }
    er() {
        return this.tr;
    }
    Zi() {
        return this.hi;
    }
    runTransaction(t, e, n) {
        R("MemoryPersistence", "Starting transaction:", t);
        const s = new mr(this.Fc.next());
        return this.Rr.Lc(), n(s).next((t => this.Rr.Mc(s).next((() => t)))).Nn().then((t => (s.qc(), 
        t)));
    }
    Uc(t, e) {
        return Is.kn(Object.values(this.Cc).map((n => () => n.qr(t, e))));
    }
}

/**
 * Memory persistence is not actually transactional, but future implementations
 * may have transaction-scoped state.
 */ class mr extends 
/**
 * A base class representing a persistence transaction, encapsulating both the
 * transaction's sequence numbers as well as a list of onCommitted listeners.
 *
 * When you call Persistence.runTransaction(), it will create a transaction and
 * pass it to your callback. You then pass it to any method that operates
 * on persistence.
 */
class {
    constructor() {
        this.Bc = [];
    }
    Qc(t) {
        this.Bc.push(t);
    }
    qc() {
        this.Bc.forEach((t => t()));
    }
} {
    constructor(t) {
        super(), this.Tr = t;
    }
}

class Tr {
    constructor(t) {
        this.persistence = t, 
        /** Tracks all documents that are active in Query views. */
        this.jc = new Zs, 
        /** The list of documents that are potentially GCed after each transaction. */
        this.Wc = null;
    }
    static Gc(t) {
        return new Tr(t);
    }
    get zc() {
        if (this.Wc) return this.Wc;
        throw p();
    }
    Cr(t, e, n) {
        return this.jc.Cr(n, e), this.zc.delete(n.toString()), Is.resolve();
    }
    Nr(t, e, n) {
        return this.jc.Nr(n, e), this.zc.add(n.toString()), Is.resolve();
    }
    cc(t, e) {
        return this.zc.add(e.toString()), Is.resolve();
    }
    removeTarget(t, e) {
        this.jc.Or(e.targetId).forEach((t => this.zc.add(t.toString())));
        const n = this.persistence.er();
        return n.pr(t, e.targetId).next((t => {
            t.forEach((t => this.zc.add(t.toString())));
        })).next((() => n.vc(t, e)));
    }
    Lc() {
        this.Wc = new Set;
    }
    Mc(t) {
        // Remove newly orphaned documents.
        const e = this.persistence.Zi().cr();
        return Is.forEach(this.zc, (n => {
            const s = x.D(n);
            return this.Kc(t, s).next((t => {
                t || e.Ir(s);
            }));
        })).next((() => (this.Wc = null, e.apply(t))));
    }
    Ar(t, e) {
        return this.Kc(t, e).next((t => {
            t ? this.zc.delete(e.toString()) : this.zc.add(e.toString());
        }));
    }
    $c(t) {
        // For eager GC, we don't care about the document size, there are no size thresholds.
        return 0;
    }
    Kc(t, e) {
        return Is.kn([ () => Is.resolve(this.jc.qr(e)), () => this.persistence.er().qr(t, e), () => this.persistence.Uc(t, e) ]);
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Provides a simple helper class that implements the Stream interface to
 * bridge to other implementations that are streams but do not implement the
 * interface. The stream callbacks are invoked with the callOn... methods.
 */ class Er {
    constructor(t) {
        this.Hc = t.Hc, this.Yc = t.Yc;
    }
    Io(t) {
        this.Jc = t;
    }
    do(t) {
        this.Xc = t;
    }
    onMessage(t) {
        this.Zc = t;
    }
    close() {
        this.Yc();
    }
    send(t) {
        this.Hc(t);
    }
    ta() {
        this.Jc();
    }
    ea(t) {
        this.Xc(t);
    }
    na(t) {
        this.Zc(t);
    }
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ const Ir = {
    BatchGetDocuments: "batchGet",
    Commit: "commit",
    RunQuery: "runQuery"
};

/**
 * Maps RPC names to the corresponding REST endpoint name.
 *
 * We use array notation to avoid mangling.
 */ class Ar extends 
/**
 * Base class for all Rest-based connections to the backend (WebChannel and
 * HTTP).
 */
class {
    constructor(t) {
        this.sa = t, this.B = t.B;
        const e = t.ssl ? "https" : "http";
        this.ia = e + "://" + t.host, this.ra = "projects/" + this.B.projectId + "/databases/" + this.B.database + "/documents";
    }
    No(t, e, n, s) {
        const i = this.oa(t, e);
        R("RestConnection", "Sending: ", i, n);
        const r = {};
        return this.ua(r, s), this.ca(t, i, r, n).then((t => (R("RestConnection", "Received: ", t), 
        t)), (e => {
            throw P("RestConnection", t + " failed with error: ", e, "url: ", i, "request:", n), 
            e;
        }));
    }
    $o(t, e, n, s) {
        // The REST API automatically aggregates all of the streamed results, so we
        // can just use the normal invoke() method.
        return this.No(t, e, n, s);
    }
    /**
     * Modifies the headers for a request, adding any authorization token if
     * present and any additional headers for the request.
     */    ua(t, e) {
        if (t["X-Goog-Api-Client"] = "gl-js/ fire/7.24.0", 
        // Content-Type: text/plain will avoid preflight requests which might
        // mess with CORS and redirects by proxies. If we add custom headers
        // we will need to change this code to potentially use the $httpOverwrite
        // parameter supported by ESF to avoid triggering preflight requests.
        t["Content-Type"] = "text/plain", e) for (const n in e.Br) e.Br.hasOwnProperty(n) && (t[n] = e.Br[n]);
    }
    oa(t, e) {
        const n = Ir[t];
        return `${this.ia}/v1/${e}:${n}`;
    }
}
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ {
    constructor(t) {
        super(t), this.forceLongPolling = t.forceLongPolling, this.j = t.j;
    }
    ca(t, e, n, s) {
        return new Promise(((i, r) => {
            const o = new h;
            o.listenOnce(l.COMPLETE, (() => {
                try {
                    switch (o.getLastErrorCode()) {
                      case _.NO_ERROR:
                        const e = o.getResponseJson();
                        R("Connection", "XHR received:", JSON.stringify(e)), i(e);
                        break;

                      case _.TIMEOUT:
                        R("Connection", 'RPC "' + t + '" timed out'), r(new E(T.DEADLINE_EXCEEDED, "Request time out"));
                        break;

                      case _.HTTP_ERROR:
                        const n = o.getStatus();
                        if (R("Connection", 'RPC "' + t + '" failed with status:', n, "response text:", o.getResponseText()), 
                        n > 0) {
                            const t = o.getResponseJson().error;
                            if (t && t.status && t.message) {
                                const e = function(t) {
                                    const e = t.toLowerCase().replace("_", "-");
                                    return Object.values(T).indexOf(e) >= 0 ? e : T.UNKNOWN;
                                }(t.status);
                                r(new E(e, t.message));
                            } else r(new E(T.UNKNOWN, "Server responded with status " + o.getStatus()));
                        } else 
                        // If we received an HTTP_ERROR but there's no status code,
                        // it's most probably a connection issue
                        r(new E(T.UNAVAILABLE, "Connection failed."));
                        break;

                      default:
                        p();
                    }
                } finally {
                    R("Connection", 'RPC "' + t + '" completed.');
                }
            }));
            const u = JSON.stringify(s);
            o.send(e, "POST", u, n, 15);
        }));
    }
    Ao(t, e) {
        const c = [ this.ia, "/", "google.firestore.v1.Firestore", "/", t, "/channel" ], a = f(), h = {
            // Required for backend stickiness, routing behavior is based on this
            // parameter.
            httpSessionIdParam: "gsessionid",
            initMessageHeaders: {},
            messageUrlParams: {
                // This param is used to improve routing and project isolation by the
                // backend and must be included in every request.
                database: `projects/${this.B.projectId}/databases/${this.B.database}`
            },
            sendRawJson: !0,
            supportsCrossDomainXhr: !0,
            internalChannelParams: {
                // Override the default timeout (randomized between 10-20 seconds) since
                // a large write batch on a slow internet connection may take a long
                // time to send to the backend. Rather than have WebChannel impose a
                // tight timeout which could lead to infinite timeouts and retries, we
                // set it very large (5-10 minutes) and rely on the browser's builtin
                // timeouts to kick in if the request isn't working.
                forwardChannelRequestTimeoutMs: 6e5
            },
            forceLongPolling: this.forceLongPolling,
            detectBufferingProxy: this.j
        };
        this.ua(h.initMessageHeaders, e), 
        // Sending the custom headers we just added to request.initMessageHeaders
        // (Authorization, etc.) will trigger the browser to make a CORS preflight
        // request because the XHR will no longer meet the criteria for a "simple"
        // CORS request:
        // https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS#Simple_requests
        // Therefore to avoid the CORS preflight request (an extra network
        // roundtrip), we use the httpHeadersOverwriteParam option to specify that
        // the headers should instead be encoded into a special "$httpHeaders" query
        // parameter, which is recognized by the webchannel backend. This is
        // formally defined here:
        // https://github.com/google/closure-library/blob/b0e1815b13fb92a46d7c9b3c30de5d6a396a3245/closure/goog/net/rpc/httpcors.js#L32
        // TODO(b/145624756): There is a backend bug where $httpHeaders isn't respected if the request
        // doesn't have an Origin header. So we have to exclude a few browser environments that are
        // known to (sometimes) not include an Origin. See
        // https://github.com/firebase/firebase-js-sdk/issues/1491.
        n() || s() || i() || r() || o() || u() || (h.httpHeadersOverwriteParam = "$httpHeaders");
        const l = c.join("");
        R("Connection", "Creating WebChannel: " + l, h);
        const _ = a.createWebChannel(l, h);
        // WebChannel supports sending the first message with the handshake - saving
        // a network round trip. However, it will have to call send in the same
        // JS event loop as open. In order to enforce this, we delay actually
        // opening the WebChannel until send is called. Whether we have called
        // open is tracked with this variable.
                let w = !1, m = !1;
        // A flag to determine whether the stream was closed (by us or through an
        // error/close event) to avoid delivering multiple close events or sending
        // on a closed stream
                const I = new Er({
            Hc: t => {
                m ? R("Connection", "Not sending because WebChannel is closed:", t) : (w || (R("Connection", "Opening WebChannel transport."), 
                _.open(), w = !0), R("Connection", "WebChannel sending:", t), _.send(t));
            },
            Yc: () => _.close()
        }), A = (t, e) => {
            // TODO(dimond): closure typing seems broken because WebChannel does
            // not implement goog.events.Listenable
            _.listen(t, (t => {
                try {
                    e(t);
                } catch (t) {
                    setTimeout((() => {
                        throw t;
                    }), 0);
                }
            }));
        };
        // Closure events are guarded and exceptions are swallowed, so catch any
        // exception and rethrow using a setTimeout so they become visible again.
        // Note that eventually this function could go away if we are confident
        // enough the code is exception free.
                return A(d.EventType.OPEN, (() => {
            m || R("Connection", "WebChannel transport opened.");
        })), A(d.EventType.CLOSE, (() => {
            m || (m = !0, R("Connection", "WebChannel transport closed"), I.ea());
        })), A(d.EventType.ERROR, (t => {
            m || (m = !0, P("Connection", "WebChannel transport errored:", t), I.ea(new E(T.UNAVAILABLE, "The operation could not be completed")));
        })), A(d.EventType.MESSAGE, (t => {
            var e;
            if (!m) {
                const n = t.data[0];
                V(!!n);
                // TODO(b/35143891): There is a bug in One Platform that caused errors
                // (and only errors) to be wrapped in an extra array. To be forward
                // compatible with the bug we need to check either condition. The latter
                // can be removed once the fix has been rolled out.
                // Use any because msgData.error is not typed.
                const s = n, i = s.error || (null === (e = s[0]) || void 0 === e ? void 0 : e.error);
                if (i) {
                    R("Connection", "WebChannel received error:", i);
                    // error.status will be a string like 'OK' or 'NOT_FOUND'.
                    const t = i.status;
                    let e = function(t) {
                        // lookup by string
                        // eslint-disable-next-line @typescript-eslint/no-explicit-any
                        const e = pt[t];
                        if (void 0 !== e) return bt(e);
                    }(t), n = i.message;
                    void 0 === e && (e = T.INTERNAL, n = "Unknown error status: " + t + " with message " + i.message), 
                    // Mark closed so no further events are propagated
                    m = !0, I.ea(new E(e, n)), _.close();
                } else R("Connection", "WebChannel received:", n), I.na(n);
            }
        })), setTimeout((() => {
            // Technically we could/should wait for the WebChannel opened event,
            // but because we want to send the first message with the WebChannel
            // handshake we pretend the channel opened here (asynchronously), and
            // then delay the actual open until the first message is sent.
            I.ta();
        }), 0), I;
    }
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// References to `window` are guarded by BrowserConnectivityMonitor.isAvailable()
/* eslint-disable no-restricted-globals */
/**
 * Browser implementation of ConnectivityMonitor.
 */
class Rr {
    constructor() {
        this.aa = () => this.ha(), this.la = () => this._a(), this.fa = [], this.da();
    }
    Jo(t) {
        this.fa.push(t);
    }
    ni() {
        window.removeEventListener("online", this.aa), window.removeEventListener("offline", this.la);
    }
    da() {
        window.addEventListener("online", this.aa), window.addEventListener("offline", this.la);
    }
    ha() {
        R("ConnectivityMonitor", "Network connectivity changed: AVAILABLE");
        for (const t of this.fa) t(0 /* AVAILABLE */);
    }
    _a() {
        R("ConnectivityMonitor", "Network connectivity changed: UNAVAILABLE");
        for (const t of this.fa) t(1 /* UNAVAILABLE */);
    }
    // TODO(chenbrian): Consider passing in window either into this component or
    // here for testing via FakeWindow.
    /** Checks that all used attributes of window are available. */
    static wa() {
        return "undefined" != typeof window && void 0 !== window.addEventListener && void 0 !== window.removeEventListener;
    }
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ class yr {
    Jo(t) {
        // No-op.
    }
    ni() {
        // No-op.
    }
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** Initializes the WebChannelConnection for the browser. */
/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
function Pr(t) {
    return new ge(t, /* useProto3Json= */ !0);
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ const gr = "You are using the memory-only build of Firestore. Persistence support is only available via the @firebase/firestore bundle or the firebase-firestore.js build.";

/**
 * Provides all components needed for Firestore with in-memory persistence.
 * Uses EagerGC garbage collection.
 */ class pr {
    async initialize(t) {
        this.Vu = this.ma(t), this.persistence = this.Ta(t), await this.persistence.start(), 
        this.Ea = this.Ia(t), this.Qo = this.Aa(t);
    }
    Ia(t) {
        return null;
    }
    Aa(t) {
        /** Manages our in-memory or durable persistence. */
        return e = this.persistence, n = new hr, s = t.Ra, new Ws(e, n, s);
        var e, n, s;
    }
    Ta(t) {
        if (t.persistenceSettings.ya) throw new E(T.FAILED_PRECONDITION, gr);
        return new wr(Tr.Gc);
    }
    ma(t) {
        return new ks;
    }
    async terminate() {
        this.Ea && this.Ea.stop(), await this.Vu.ni(), await this.persistence.ni();
    }
    clearPersistence(t, e) {
        throw new E(T.FAILED_PRECONDITION, gr);
    }
}

/**
 * Initializes and wires the components that are needed to interface with the
 * network.
 */ class Vr {
    async initialize(t, e) {
        this.Qo || (this.Qo = t.Qo, this.Vu = t.Vu, this.jo = this.Pa(e), this.gu = this.ga(e), 
        this.pu = this.pa(e), this.Va = this.va(e), this.Vu.js = t => Hi(this.Va, t, 1 /* SharedClientState */), 
        this.gu.Wo.ba = cr.bind(null, this.Va), await 
        /**
 * Toggles the network state when the client gains or loses its primary lease.
 */
        async function(t, e) {
            const n = v(t);
            e ? (n.Ko.delete(2 /* IsSecondary */), await _i(n)) : e || (n.Ko.add(2 /* IsSecondary */), 
            await fi(n), n.Xo.set("Unknown" /* Unknown */));
        }(this.gu, this.Va.Mu));
    }
    pa(t) {
        return new Vs;
    }
    Pa(t) {
        const e = Pr(t.sa.B), n = (s = t.sa, new Ar(s));
        var s;
        /** Return the Platform-specific connectivity monitor. */        return function(t, e, n) {
            return new ai(t, e, n);
        }(t.credentials, n, e);
    }
    ga(t) {
        return e = this.Qo, n = this.jo, s = t.On, i = t => Hi(this.Va, t, 0 /* RemoteStore */), 
        r = Rr.wa() ? new Rr : new yr, new li(e, n, s, i, r);
        var e, n, s, i, r;
        /** Re-enables the network. Idempotent. */    }
    va(t) {
        return function(t, e, n, 
        // PORTING NOTE: Manages state synchronization in multi-tab environments.
        s, i, r, o) {
            const u = new ji(t, e, n, s, i, r);
            return o && (u.Lu = !0), u;
        }(this.Qo, this.gu, this.pu, this.Vu, t.Ra, t.vu, !t.persistenceSettings.ya || !t.persistenceSettings.synchronizeTabs);
    }
    terminate() {
        return di(this.gu);
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * A wrapper implementation of Observer<T> that will dispatch events
 * asynchronously. To allow immediate silencing, a mute call is added which
 * causes events scheduled to no longer be raised.
 */ class vr {
    constructor(t) {
        this.observer = t, 
        /**
         * When set to true, will not raise future events. Necessary to deal with
         * async detachment of listener.
         */
        this.muted = !1;
    }
    next(t) {
        this.observer.next && this.Sa(this.observer.next, t);
    }
    error(t) {
        this.observer.error ? this.Sa(this.observer.error, t) : console.error("Uncaught Error in snapshot listener:", t);
    }
    Da() {
        this.muted = !0;
    }
    Sa(t, e) {
        this.muted || setTimeout((() => {
            this.muted || t(e);
        }), 0);
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// The objects that are a part of this API are exposed to third-parties as
// compiled javascript so we want to flag our private members with a leading
// underscore to discourage their use.
/**
 * A field class base class that is shared by the lite, full and legacy SDK,
 * which supports shared code that deals with FieldPaths.
 */
// Use underscore prefix to hide this class from our Public API.
// eslint-disable-next-line @typescript-eslint/naming-convention
class br {
    constructor(t) {
        !function(t, e, n, s) {
            if (!(e instanceof Array) || e.length < s) throw new E(T.INVALID_ARGUMENT, `Function ${t}() requires its ${n} argument to be an array with at least ` + et(s, "element") + ".");
        }("FieldPath", t, "fieldNames", 1);
        for (let e = 0; e < t.length; ++e) if (q("FieldPath", "string", e, t[e]), 0 === t[e].length) throw new E(T.INVALID_ARGUMENT, "Invalid field name at argument $(i + 1). Field names must not be empty.");
        this.Ca = new $(t);
    }
}

/**
 * A `FieldPath` refers to a field in a document. The path may consist of a
 * single field name (referring to a top-level field in the document), or a list
 * of field names (referring to a nested field in the document).
 */ class Sr extends br {
    /**
     * Creates a FieldPath from the provided field names. If more than one field
     * name is provided, the path will point to a nested field in a document.
     *
     * @param fieldNames A list of field names.
     */
    constructor(...t) {
        super(t);
    }
    static documentId() {
        /**
         * Internal Note: The backend doesn't technically support querying by
         * document ID. Instead it queries by the entire document name (full path
         * included), but in the cases we currently support documentId(), the net
         * effect is the same.
         */
        return new Sr($.v().R());
    }
    isEqual(t) {
        if (!(t instanceof Sr)) throw X("isEqual", "FieldPath", 1, t);
        return this.Ca.isEqual(t.Ca);
    }
}

/**
 * Matches any characters in a field path string that are reserved.
 */ const Dr = new RegExp("[~\\*/\\[\\]]");

/**
 * Parses a field path string into a FieldPath, treating dots as separators.
 */
/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Sentinel values that can be used when writing document fields with `set()`
 * or `update()`.
 */
class Cr {
    /**
     * @param _methodName The public API endpoint that returns this class.
     */
    constructor(t) {
        this.Fa = t;
    }
}

/**
 * Returns a sentinel for use with {@link updateDoc()} or
 * {@link setDoc `setDoc({}, { merge: true })`} to mark a field for deletion.
 */
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
class Fr extends Cr {
    Na(t) {
        if (2 /* MergeSet */ !== t.$a) throw 1 /* Update */ === t.$a ? t.xa(this.Fa + "() can only appear at the top level of your update data") : t.xa(this.Fa + "() cannot be used with set() unless you pass {merge:true}");
        // No transform to add for a delete, but we need to add it to our
        // fieldMask so it gets deleted.
        return t.je.push(t.path), null;
    }
    isEqual(t) {
        return t instanceof Fr;
    }
}

/**
 * Creates a child context for parsing SerializableFieldValues.
 *
 * This is different than calling `ParseContext.contextWith` because it keeps
 * the fieldTransforms and fieldMask separate.
 *
 * The created context has its `dataSource` set to `UserDataSource.Argument`.
 * Although these values are used with writes, any elements in these FieldValues
 * are not considered writes since they cannot contain any FieldValue sentinels,
 * etc.
 *
 * @param fieldValue The sentinel FieldValue for which to create a child
 *     context.
 * @param context The parent context.
 * @param arrayElement Whether or not the FieldValue has an array.
 */ function Nr(t, e, n) {
    return new Wr({
        $a: 3 /* Argument */ ,
        ka: e.settings.ka,
        methodName: t.Fa,
        Oa: n
    }, e.B, e.serializer, e.ignoreUndefinedProperties);
}

class $r extends Cr {
    Na(t) {
        return new ln(t.path, new en);
    }
    isEqual(t) {
        return t instanceof $r;
    }
}

class xr extends Cr {
    constructor(t, e) {
        super(t), this.La = e;
    }
    Na(t) {
        const e = Nr(this, t, 
        /*array=*/ !0), n = this.La.map((t => Jr(t, e))), s = new nn(n);
        return new ln(t.path, s);
    }
    isEqual(t) {
        // TODO(mrschmidt): Implement isEquals
        return this === t;
    }
}

class kr extends Cr {
    constructor(t, e) {
        super(t), this.La = e;
    }
    Na(t) {
        const e = Nr(this, t, 
        /*array=*/ !0), n = this.La.map((t => Jr(t, e))), s = new rn(n);
        return new ln(t.path, s);
    }
    isEqual(t) {
        // TODO(mrschmidt): Implement isEquals
        return this === t;
    }
}

class Or extends Cr {
    constructor(t, e) {
        super(t), this.Ma = e;
    }
    Na(t) {
        const e = new un(t.serializer, ve(t.serializer, this.Ma));
        return new ln(t.path, e);
    }
    isEqual(t) {
        // TODO(mrschmidt): Implement isEquals
        return this === t;
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * An immutable object representing a geographic location in Firestore. The
 * location is represented as latitude/longitude pair.
 *
 * Latitude values are in the range of [-90, 90].
 * Longitude values are in the range of [-180, 180].
 */ class Lr {
    /**
     * Creates a new immutable `GeoPoint` object with the provided latitude and
     * longitude values.
     * @param latitude The latitude as number between -90 and 90.
     * @param longitude The longitude as number between -180 and 180.
     */
    constructor(t, e) {
        if (O("GeoPoint", arguments, 2), q("GeoPoint", "number", 1, t), q("GeoPoint", "number", 2, e), 
        !isFinite(t) || t < -90 || t > 90) throw new E(T.INVALID_ARGUMENT, "Latitude must be a number between -90 and 90, but was: " + t);
        if (!isFinite(e) || e < -180 || e > 180) throw new E(T.INVALID_ARGUMENT, "Longitude must be a number between -180 and 180, but was: " + e);
        this.qa = t, this.Ua = e;
    }
    /**
     * The latitude of this `GeoPoint` instance.
     */    get latitude() {
        return this.qa;
    }
    /**
     * The longitude of this `GeoPoint` instance.
     */    get longitude() {
        return this.Ua;
    }
    /**
     * Returns true if this `GeoPoint` is equal to the provided one.
     *
     * @param other The `GeoPoint` to compare against.
     * @return true if this `GeoPoint` is equal to the provided one.
     */    isEqual(t) {
        return this.qa === t.qa && this.Ua === t.Ua;
    }
    toJSON() {
        return {
            latitude: this.qa,
            longitude: this.Ua
        };
    }
    /**
     * Actually private to JS consumers of our API, so this function is prefixed
     * with an underscore.
     */    Y(t) {
        return it(this.qa, t.qa) || it(this.Ua, t.Ua);
    }
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A class implemented by all API types of the legacy Firestore API which
 * contains a reference to the API type in the firestore-exp API. All internal
 * code unwraps these references, which allows us to only use firestore-exp
 * types in the SDK.
 */ class Mr {
    constructor(t) {
        this.Ba = t;
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ const qr = /^__.*__$/;

/**
 * A reference to a document in a Firebase project.
 *
 * This class serves as a common base class for the public DocumentReferences
 * exposed in the lite, full and legacy SDK.
 */
// Use underscore prefix to hide this class from our Public API.
// eslint-disable-next-line @typescript-eslint/naming-convention
class Ur {
    constructor(t, e, n) {
        this.Qa = t, this.ja = e, this.Wa = n;
    }
}

/** The result of parsing document data (e.g. for a setData call). */ class Br {
    constructor(t, e, n) {
        this.data = t, this.je = e, this.fieldTransforms = n;
    }
    Ga(t, e) {
        const n = [];
        return null !== this.je ? n.push(new Pn(t, this.data, this.je, e)) : n.push(new yn(t, this.data, e)), 
        this.fieldTransforms.length > 0 && n.push(new pn(t, this.fieldTransforms)), n;
    }
}

/** The result of parsing "update" data (i.e. for an updateData call). */ class Qr {
    constructor(t, e, n) {
        this.data = t, this.je = e, this.fieldTransforms = n;
    }
    Ga(t, e) {
        const n = [ new Pn(t, this.data, this.je, e) ];
        return this.fieldTransforms.length > 0 && n.push(new pn(t, this.fieldTransforms)), 
        n;
    }
}

function jr(t) {
    switch (t) {
      case 0 /* Set */ :
 // fall through
              case 2 /* MergeSet */ :
 // fall through
              case 1 /* Update */ :
        return !0;

      case 3 /* Argument */ :
      case 4 /* ArrayArgument */ :
        return !1;

      default:
        throw p();
    }
}

/** A "context" object passed around while parsing user data. */ class Wr {
    /**
     * Initializes a ParseContext with the given source and path.
     *
     * @param settings The settings for the parser.
     * @param databaseId The database ID of the Firestore instance.
     * @param serializer The serializer to use to generate the Value proto.
     * @param ignoreUndefinedProperties Whether to ignore undefined properties
     * rather than throw.
     * @param fieldTransforms A mutable list of field transforms encountered while
     *     parsing the data.
     * @param fieldMask A mutable list of field paths encountered while parsing
     *     the data.
     *
     * TODO(b/34871131): We don't support array paths right now, so path can be
     * null to indicate the context represents any location within an array (in
     * which case certain features will not work and errors will be somewhat
     * compromised).
     */
    constructor(t, e, n, s, i, r) {
        this.settings = t, this.B = e, this.serializer = n, this.ignoreUndefinedProperties = s, 
        // Minor hack: If fieldTransforms is undefined, we assume this is an
        // external call and we need to validate the entire path.
        void 0 === i && this.za(), this.fieldTransforms = i || [], this.je = r || [];
    }
    get path() {
        return this.settings.path;
    }
    get $a() {
        return this.settings.$a;
    }
    /** Returns a new context with the specified settings overwritten. */    Ka(t) {
        return new Wr(Object.assign(Object.assign({}, this.settings), t), this.B, this.serializer, this.ignoreUndefinedProperties, this.fieldTransforms, this.je);
    }
    Ha(t) {
        var e;
        const n = null === (e = this.path) || void 0 === e ? void 0 : e.child(t), s = this.Ka({
            path: n,
            Oa: !1
        });
        return s.Ya(t), s;
    }
    Ja(t) {
        var e;
        const n = null === (e = this.path) || void 0 === e ? void 0 : e.child(t), s = this.Ka({
            path: n,
            Oa: !1
        });
        return s.za(), s;
    }
    Xa(t) {
        // TODO(b/34871131): We don't support array paths right now; so make path
        // undefined.
        return this.Ka({
            path: void 0,
            Oa: !0
        });
    }
    xa(t) {
        return so(t, this.settings.methodName, this.settings.Za || !1, this.path, this.settings.ka);
    }
    /** Returns 'true' if 'fieldPath' was traversed when creating this context. */    contains(t) {
        return void 0 !== this.je.find((e => t.T(e))) || void 0 !== this.fieldTransforms.find((e => t.T(e.field)));
    }
    za() {
        // TODO(b/34871131): Remove null check once we have proper paths for fields
        // within arrays.
        if (this.path) for (let t = 0; t < this.path.length; t++) this.Ya(this.path.get(t));
    }
    Ya(t) {
        if (0 === t.length) throw this.xa("Document fields must not be empty");
        if (jr(this.$a) && qr.test(t)) throw this.xa('Document fields cannot begin and end with "__"');
    }
}

/**
 * Helper for parsing raw user input (provided via the API) into internal model
 * classes.
 */ class Gr {
    constructor(t, e, n) {
        this.B = t, this.ignoreUndefinedProperties = e, this.serializer = n || Pr(t);
    }
    /** Creates a new top-level parse context. */    th(t, e, n, s = !1) {
        return new Wr({
            $a: t,
            methodName: e,
            ka: n,
            path: $.g(),
            Oa: !1,
            Za: s
        }, this.B, this.serializer, this.ignoreUndefinedProperties);
    }
}

/** Parse document data from a set() call. */ function zr(t, e, n, s, i, r = {}) {
    const o = t.th(r.merge || r.mergeFields ? 2 /* MergeSet */ : 0 /* Set */ , e, n, i);
    to("Data must be an object, but it was:", o, s);
    const u = Xr(s, o);
    let c, a;
    if (r.merge) c = new hn(o.je), a = o.fieldTransforms; else if (r.mergeFields) {
        const t = [];
        for (const s of r.mergeFields) {
            let i;
            if (s instanceof br) i = s.Ca; else {
                if ("string" != typeof s) throw p();
                i = no(e, s, n);
            }
            if (!o.contains(i)) throw new E(T.INVALID_ARGUMENT, `Field '${i}' is specified in your field mask but missing from your input data.`);
            io(t, i) || t.push(i);
        }
        c = new hn(t), a = o.fieldTransforms.filter((t => c.He(t.field)));
    } else c = null, a = o.fieldTransforms;
    return new Br(new Dn(u), c, a);
}

/** Parse update data from an update() call. */ function Kr(t, e, n, s) {
    const i = t.th(1 /* Update */ , e, n);
    to("Data must be an object, but it was:", i, s);
    const r = [], o = new Cn;
    S(s, ((t, s) => {
        const u = no(e, t, n), c = i.Ja(u);
        if (s instanceof Fr || s instanceof Mr && s.Ba instanceof Fr) 
        // Add it to the field mask, but don't add anything to updateData.
        r.push(u); else {
            const t = Jr(s, c);
            null != t && (r.push(u), o.set(u, t));
        }
    }));
    const u = new hn(r);
    return new Qr(o.Xe(), u, i.fieldTransforms);
}

/** Parse update data from a list of field/value arguments. */ function Hr(t, e, n, s, i, r) {
    const o = t.th(1 /* Update */ , e, n), u = [ eo(e, s, n) ], c = [ i ];
    if (r.length % 2 != 0) throw new E(T.INVALID_ARGUMENT, `Function ${e}() needs to be called with an even number of arguments that alternate between field names and values.`);
    for (let t = 0; t < r.length; t += 2) u.push(eo(e, r[t])), c.push(r[t + 1]);
    const a = [], h = new Cn;
    // We iterate in reverse order to pick the last value for a field if the
    // user specified the field multiple times.
    for (let t = u.length - 1; t >= 0; --t) if (!io(a, u[t])) {
        const e = u[t], n = c[t], s = o.Ja(e);
        if (n instanceof Fr || n instanceof Mr && n.Ba instanceof Fr) 
        // Add it to the field mask, but don't add anything to updateData.
        a.push(e); else {
            const t = Jr(n, s);
            null != t && (a.push(e), h.set(e, t));
        }
    }
    const l = new hn(a);
    return new Qr(h.Xe(), l, o.fieldTransforms);
}

/**
 * Parse a "query value" (e.g. value in a where filter or a value in a cursor
 * bound).
 *
 * @param allowArrays Whether the query value is an array that may directly
 * contain additional arrays (e.g. the operand of an `in` query).
 */ function Yr(t, e, n, s = !1) {
    return Jr(n, t.th(s ? 4 /* ArrayArgument */ : 3 /* Argument */ , e));
}

/**
 * Parses user data to Protobuf Values.
 *
 * @param input Data to be parsed.
 * @param context A context object representing the current path being parsed,
 * the source of the data being parsed, etc.
 * @return The parsed value, or null if the value was a FieldValue sentinel
 * that should not be included in the resulting parsed data.
 */ function Jr(t, e) {
    if (
    // Unwrap the API type from the Compat SDK. This will return the API type
    // from firestore-exp.
    t instanceof Mr && (t = t.Ba), Zr(t)) return to("Unsupported field value:", e, t), 
    Xr(t, e);
    if (t instanceof Cr) 
    // FieldValues usually parse into transforms (except FieldValue.delete())
    // in which case we do not want to include this field in our parsed data
    // (as doing so will overwrite the field directly prior to the transform
    // trying to transform it). So we don't add this location to
    // context.fieldMask and we return null as our parsing result.
    /**
 * "Parses" the provided FieldValueImpl, adding any necessary transforms to
 * context.fieldTransforms.
 */
    return function(t, e) {
        // Sentinels are only supported with writes, and not within arrays.
        if (!jr(e.$a)) throw e.xa(t.Fa + "() can only be used with update() and set()");
        if (!e.path) throw e.xa(t.Fa + "() is not currently supported inside arrays");
        const n = t.Na(e);
        n && e.fieldTransforms.push(n);
    }
    /**
 * Helper to parse a scalar value (i.e. not an Object, Array, or FieldValue)
 *
 * @return The parsed value
 */ (t, e), null;
    if (
    // If context.path is null we are inside an array and we don't support
    // field mask paths more granular than the top-level array.
    e.path && e.je.push(e.path), t instanceof Array) {
        // TODO(b/34871131): Include the path containing the array in the error
        // message.
        // In the case of IN queries, the parsed data is an array (representing
        // the set of values to be included for the IN query) that may directly
        // contain additional arrays (each representing an individual field
        // value), so we disable this validation.
        if (e.settings.Oa && 4 /* ArrayArgument */ !== e.$a) throw e.xa("Nested arrays are not supported");
        return function(t, e) {
            const n = [];
            let s = 0;
            for (const i of t) {
                let t = Jr(i, e.Xa(s));
                null == t && (
                // Just include nulls in the array for fields being replaced with a
                // sentinel.
                t = {
                    nullValue: "NULL_VALUE"
                }), n.push(t), s++;
            }
            return {
                arrayValue: {
                    values: n
                }
            };
        }(t, e);
    }
    return function(t, e) {
        if (null === t) return {
            nullValue: "NULL_VALUE"
        };
        if ("number" == typeof t) return ve(e.serializer, t);
        if ("boolean" == typeof t) return {
            booleanValue: t
        };
        if ("string" == typeof t) return {
            stringValue: t
        };
        if (t instanceof Date) {
            const n = ft.fromDate(t);
            return {
                timestampValue: be(e.serializer, n)
            };
        }
        if (t instanceof ft) {
            // Firestore backend truncates precision down to microseconds. To ensure
            // offline mode works the same with regards to truncation, perform the
            // truncation immediately without waiting for the backend to do that.
            const n = new ft(t.seconds, 1e3 * Math.floor(t.nanoseconds / 1e3));
            return {
                timestampValue: be(e.serializer, n)
            };
        }
        if (t instanceof Lr) return {
            geoPointValue: {
                latitude: t.latitude,
                longitude: t.longitude
            }
        };
        if (t instanceof ut) return {
            bytesValue: Se(e.serializer, t.U)
        };
        if (t instanceof Ur) {
            const n = e.B, s = t.Qa;
            if (!s.isEqual(n)) throw e.xa(`Document reference is for database ${s.projectId}/${s.database} but should be for database ${n.projectId}/${n.database}`);
            return {
                referenceValue: Fe(t.Qa || e.B, t.ja.path)
            };
        }
        if (void 0 === t && e.ignoreUndefinedProperties) return null;
        throw e.xa("Unsupported field value: " + H(t));
    }
    /**
 * Checks whether an object looks like a JSON object that should be converted
 * into a struct. Normal class/prototype instances are considered to look like
 * JSON objects since they should be converted to a struct value. Arrays, Dates,
 * GeoPoints, etc. are not considered to look like JSON objects since they map
 * to specific FieldValue types other than ObjectValue.
 */ (t, e);
}

function Xr(t, e) {
    const n = {};
    return D(t) ? 
    // If we encounter an empty object, we explicitly add it to the update
    // mask to ensure that the server creates a map entry.
    e.path && e.path.length > 0 && e.je.push(e.path) : S(t, ((t, s) => {
        const i = Jr(s, e.Ha(t));
        null != i && (n[t] = i);
    })), {
        mapValue: {
            fields: n
        }
    };
}

function Zr(t) {
    return !("object" != typeof t || null === t || t instanceof Array || t instanceof Date || t instanceof ft || t instanceof Lr || t instanceof ut || t instanceof Ur || t instanceof Cr);
}

function to(t, e, n) {
    if (!Zr(n) || !K(n)) {
        const s = H(n);
        throw "an object" === s ? e.xa(t + " a custom object") : e.xa(t + " " + s);
    }
}

/**
 * Helper that calls fromDotSeparatedString() but wraps any error thrown.
 */ function eo(t, e, n) {
    if (e instanceof br) return e.Ca;
    if ("string" == typeof e) return no(t, e);
    throw so("Field path arguments must be of type string or FieldPath.", t, 
    /* hasConverter= */ !1, 
    /* path= */ void 0, n);
}

/**
 * Wraps fromDotSeparatedString with an error message about the method that
 * was thrown.
 * @param methodName The publicly visible method name
 * @param path The dot-separated string form of a field path which will be split
 * on dots.
 * @param targetDoc The document against which the field path will be evaluated.
 */ function no(t, e, n) {
    try {
        return function(t) {
            if (t.search(Dr) >= 0) throw new E(T.INVALID_ARGUMENT, `Invalid field path (${t}). Paths must not contain '~', '*', '/', '[', or ']'`);
            try {
                return new Sr(...t.split("."));
            } catch (e) {
                throw new E(T.INVALID_ARGUMENT, `Invalid field path (${t}). Paths must not be empty, begin with '.', end with '.', or contain '..'`);
            }
        }(e).Ca;
    } catch (e) {
        throw so((s = e) instanceof Error ? s.message : s.toString(), t, 
        /* hasConverter= */ !1, 
        /* path= */ void 0, n);
    }
    /**
 * Extracts the message from a caught exception, which should be an Error object
 * though JS doesn't guarantee that.
 */
    var s;
    /** Checks `haystack` if FieldPath `needle` is present. Runs in O(n). */}

function so(t, e, n, s, i) {
    const r = s && !s.m(), o = void 0 !== i;
    let u = `Function ${e}() called with invalid data`;
    n && (u += " (via `toFirestore()`)"), u += ". ";
    let c = "";
    return (r || o) && (c += " (found", r && (c += " in field " + s), o && (c += " in document " + i), 
    c += ")"), new E(T.INVALID_ARGUMENT, u + t + c);
}

function io(t, e) {
    return t.some((t => t.isEqual(e)));
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Internal transaction object responsible for accumulating the mutations to
 * perform and the base versions for any documents read.
 */ class ro {
    constructor(t) {
        this.jo = t, 
        // The version of each document that was read during this transaction.
        this.eh = new Map, this.mutations = [], this.nh = !1, 
        /**
         * A deferred usage error that occurred previously in this transaction that
         * will cause the transaction to fail once it actually commits.
         */
        this.sh = null, 
        /**
         * Set of documents that have been written in the transaction.
         *
         * When there's more than one write to the same key in a transaction, any
         * writes after the first are handled differently.
         */
        this.ih = new Set;
    }
    async rh(t) {
        if (this.oh(), this.mutations.length > 0) throw new E(T.INVALID_ARGUMENT, "Firestore transactions require all reads to be executed before all writes.");
        const e = await async function(t, e) {
            const n = v(t), s = ke(n.serializer) + "/documents", i = {
                documents: e.map((t => Ne(n.serializer, t)))
            }, r = await n.$o("BatchGetDocuments", s, i), o = new Map;
            r.forEach((t => {
                const e = Le(n.serializer, t);
                o.set(e.key.toString(), e);
            }));
            const u = [];
            return e.forEach((t => {
                const e = o.get(t.toString());
                V(!!e), u.push(e);
            })), u;
        }(this.jo, t);
        return e.forEach((t => {
            t instanceof xn || t instanceof $n ? this.uh(t) : p();
        })), e;
    }
    set(t, e) {
        this.write(e.Ga(t, this.ze(t))), this.ih.add(t.toString());
    }
    update(t, e) {
        try {
            this.write(e.Ga(t, this.ah(t)));
        } catch (t) {
            this.sh = t;
        }
        this.ih.add(t.toString());
    }
    delete(t) {
        this.write([ new bn(t, this.ze(t)) ]), this.ih.add(t.toString());
    }
    async commit() {
        if (this.oh(), this.sh) throw this.sh;
        const t = this.eh;
        // For each mutation, note that the doc was written.
                this.mutations.forEach((e => {
            t.delete(e.key.toString());
        })), 
        // For each document that was read but not written to, we want to perform
        // a `verify` operation.
        t.forEach(((t, e) => {
            const n = x.D(e);
            this.mutations.push(new Sn(n, this.ze(n)));
        })), await async function(t, e) {
            const n = v(t), s = ke(n.serializer) + "/documents", i = {
                writes: e.map((t => qe(n.serializer, t)))
            };
            await n.No("Commit", s, i);
        }(this.jo, this.mutations), this.nh = !0;
    }
    uh(t) {
        let e;
        if (t instanceof $n) e = t.version; else {
            if (!(t instanceof xn)) throw p();
            // For deleted docs, we must use baseVersion 0 when we overwrite them.
            e = dt.min();
        }
        const n = this.eh.get(t.key.toString());
        if (n) {
            if (!e.isEqual(n)) 
            // This transaction will fail no matter what.
            throw new E(T.ABORTED, "Document version changed between two reads.");
        } else this.eh.set(t.key.toString(), e);
    }
    /**
     * Returns the version of this document when it was read in this transaction,
     * as a precondition, or no precondition if it was not read.
     */    ze(t) {
        const e = this.eh.get(t.toString());
        return !this.ih.has(t.toString()) && e ? dn.updateTime(e) : dn.Ye();
    }
    /**
     * Returns the precondition for a document if the operation is an update.
     */    ah(t) {
        const e = this.eh.get(t.toString());
        // The first time a document is written, we want to take into account the
        // read time and existence
                if (!this.ih.has(t.toString()) && e) {
            if (e.isEqual(dt.min())) 
            // The document doesn't exist, so fail the transaction.
            // This has to be validated locally because you can't send a
            // precondition that a document does not exist without changing the
            // semantics of the backend write to be an insert. This is the reverse
            // of what we want, since we want to assert that the document doesn't
            // exist but then send the update and have it fail. Since we can't
            // express that to the backend, we have to validate locally.
            // Note: this can change once we can send separate verify writes in the
            // transaction.
            throw new E(T.INVALID_ARGUMENT, "Can't update a document that doesn't exist.");
            // Document exists, base precondition on document update time.
                        return dn.updateTime(e);
        }
        // Document was not read, so we just use the preconditions for a blind
        // update.
        return dn.exists(!0);
    }
    write(t) {
        this.oh(), this.mutations = this.mutations.concat(t);
    }
    oh() {}
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * TransactionRunner encapsulates the logic needed to run and retry transactions
 * with backoff.
 */
class oo {
    constructor(t, e, n, s) {
        this.On = t, this.jo = e, this.updateFunction = n, this.qn = s, this.hh = 5, this.Xn = new Es(this.On, "transaction_retry" /* TransactionRetry */);
    }
    /** Runs the transaction and sets the result on deferred. */    run() {
        this.lh();
    }
    lh() {
        this.Xn.yn((async () => {
            const t = new ro(this.jo), e = this._h(t);
            e && e.then((e => {
                this.On.jn((() => t.commit().then((() => {
                    this.qn.resolve(e);
                })).catch((t => {
                    this.fh(t);
                }))));
            })).catch((t => {
                this.fh(t);
            }));
        }));
    }
    _h(t) {
        try {
            const e = this.updateFunction(t);
            return !wt(e) && e.catch && e.then ? e : (this.qn.reject(Error("Transaction callback must return a Promise")), 
            null);
        } catch (t) {
            // Do not retry errors thrown by user provided updateFunction.
            return this.qn.reject(t), null;
        }
    }
    fh(t) {
        this.hh > 0 && this.dh(t) ? (this.hh -= 1, this.On.jn((() => (this.lh(), Promise.resolve())))) : this.qn.reject(t);
    }
    dh(t) {
        if ("FirebaseError" === t.name) {
            // In transactions, the backend will fail outdated reads with FAILED_PRECONDITION and
            // non-matching document versions with ABORTED. These errors should be retried.
            const e = t.code;
            return "aborted" === e || "failed-precondition" === e || !vt(e);
        }
        return !1;
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * FirestoreClient is a top-level class that constructs and owns all of the
 * pieces of the client SDK architecture. It is responsible for creating the
 * async queue that is shared by all of the other components in the system.
 */
class uo {
    constructor(t, 
    /**
     * Asynchronous queue responsible for all of our internal processing. When
     * we get incoming work from the user (via public API) or the network
     * (incoming GRPC messages), we should always schedule onto this queue.
     * This ensures all of our work is properly serialized (e.g. we don't
     * start processing a new operation while the previous one is waiting for
     * an async I/O to complete).
     */
    e) {
        this.credentials = t, this.On = e, this.clientId = st.k(), 
        // We defer our initialization until we get the current user from
        // setChangeListener(). We block the async queue until we got the initial
        // user and the initialization is completed. This will prevent any scheduled
        // work from happening before initialization is completed.
        // If initializationDone resolved then the FirestoreClient is in a usable
        // state.
        this.wh = new Ts;
    }
    /**
     * Starts up the FirestoreClient, returning only whether or not enabling
     * persistence succeeded.
     *
     * The intent here is to "do the right thing" as far as users are concerned.
     * Namely, in cases where offline persistence is requested and possible,
     * enable it, but otherwise fall back to persistence disabled. For the most
     * part we expect this to succeed one way or the other so we don't expect our
     * users to actually wait on the firestore.enablePersistence Promise since
     * they generally won't care.
     *
     * Of course some users actually do care about whether or not persistence
     * was successfully enabled, so the Promise returned from this method
     * indicates this outcome.
     *
     * This presents a problem though: even before enablePersistence resolves or
     * rejects, users may have made calls to e.g. firestore.collection() which
     * means that the FirestoreClient in there will be available and will be
     * enqueuing actions on the async queue.
     *
     * Meanwhile any failure of an operation on the async queue causes it to
     * panic and reject any further work, on the premise that unhandled errors
     * are fatal.
     *
     * Consequently the fallback is handled internally here in start, and if the
     * fallback succeeds we signal success to the async queue even though the
     * start() itself signals failure.
     *
     * @param databaseInfo The connection information for the current instance.
     * @param offlineComponentProvider Provider that returns all components
     * required for memory-only or IndexedDB persistence.
     * @param onlineComponentProvider Provider that returns all components
     * required for online support.
     * @param persistenceSettings Settings object to configure offline
     *     persistence.
     * @returns A deferred result indicating the user-visible result of enabling
     *     offline persistence. This method will reject this if IndexedDB fails to
     *     start for any reason. If usePersistence is false this is
     *     unconditionally resolved.
     */    start(t, e, n, s) {
        this.mh(), this.sa = t;
        // If usePersistence is true, certain classes of errors while starting are
        // recoverable but only by falling back to persistence disabled.
        // If there's an error in the first case but not in recovery we cannot
        // reject the promise blocking the async queue because this will cause the
        // async queue to panic.
        const i = new Ts;
        let r = !1;
        // Return only the result of enabling persistence. Note that this does not
        // need to await the completion of initializationDone because the result of
        // this method should not reflect any other kind of failure to start.
        return this.credentials.Wr((t => {
            if (!r) return r = !0, R("FirestoreClient", "Initializing. user=", t.uid), this.Th(e, n, s, t, i).then(this.wh.resolve, this.wh.reject);
            this.On.os((() => async function(t, e) {
                const n = v(t);
                n.On.hs(), R("RemoteStore", "RemoteStore received new credentials");
                const s = Ri(n);
                // Tear down and re-create our network streams. This will ensure we get a
                // fresh auth token for the new user and re-fill the write pipeline with
                // new mutations from the LocalStore (since mutations are per-user).
                                n.Ko.add(3 /* CredentialChange */), await fi(n), s && 
                // Don't set the network status to Unknown if we are offline.
                n.Xo.set("Unknown" /* Unknown */), await n.Wo.ba(e), n.Ko.delete(3 /* CredentialChange */), 
                await _i(n);
            }(this.gu, t)));
        })), 
        // Block the async queue until initialization is done
        this.On.jn((() => this.wh.promise)), i.promise;
    }
    /** Enables the network connection and requeues all pending operations. */    enableNetwork() {
        return this.mh(), this.On.enqueue((() => (this.persistence.Oc(!0), function(t) {
            const e = v(t);
            return e.Ko.delete(0 /* UserDisabled */), _i(e);
        }(this.gu))));
    }
    /**
     * Initializes persistent storage, attempting to use IndexedDB if
     * usePersistence is true or memory-only if false.
     *
     * If IndexedDB fails because it's already open in another tab or because the
     * platform can't possibly support our implementation then this method rejects
     * the persistenceResult and falls back on memory-only persistence.
     *
     * @param offlineComponentProvider Provider that returns all components
     * required for memory-only or IndexedDB persistence.
     * @param onlineComponentProvider Provider that returns all components
     * required for online support.
     * @param persistenceSettings Settings object to configure offline persistence
     * @param user The initial user
     * @param persistenceResult A deferred result indicating the user-visible
     *     result of enabling offline persistence. This method will reject this if
     *     IndexedDB fails to start for any reason. If usePersistence is false
     *     this is unconditionally resolved.
     * @returns a Promise indicating whether or not initialization should
     *     continue, i.e. that one of the persistence implementations actually
     *     succeeded.
     */    async Th(t, e, n, s, i) {
        try {
            const r = {
                On: this.On,
                sa: this.sa,
                clientId: this.clientId,
                credentials: this.credentials,
                Ra: s,
                vu: 100,
                persistenceSettings: n
            };
            await t.initialize(r), await e.initialize(t, r), this.persistence = t.persistence, 
            this.Vu = t.Vu, this.Qo = t.Qo, this.Ea = t.Ea, this.jo = e.jo, this.gu = e.gu, 
            this.Va = e.Va, this.Eh = e.pu, this.Eh.Is = Wi.bind(null, this.Va), this.Eh.ys = Gi.bind(null, this.Va), 
            // When a user calls clearPersistence() in one client, all other clients
            // need to be terminated to allow the delete to succeed.
            this.persistence.kc((async () => {
                await this.terminate();
            })), i.resolve();
        } catch (t) {
            // An unknown failure on the first stage shuts everything down.
            if (
            // Regardless of whether or not the retry succeeds, from an user
            // perspective, offline persistence has failed.
            i.reject(t), !this.Ih(t)) throw t;
            return console.warn("Error enabling offline persistence. Falling back to persistence disabled: " + t), 
            this.Th(new pr, new Vr, {
                ya: !1
            }, s, i);
        }
    }
    /**
     * Decides whether the provided error allows us to gracefully disable
     * persistence (as opposed to crashing the client).
     */    Ih(t) {
        return "FirebaseError" === t.name ? t.code === T.FAILED_PRECONDITION || t.code === T.UNIMPLEMENTED : !("undefined" != typeof DOMException && t instanceof DOMException) || (
        // When the browser is out of quota we could get either quota exceeded
        // or an aborted error depending on whether the error happened during
        // schema migration.
        22 === t.code || 20 === t.code || 
        // Firefox Private Browsing mode disables IndexedDb and returns
        // INVALID_STATE for any usage.
        11 === t.code);
    }
    /**
     * Checks that the client has not been terminated. Ensures that other methods on
     * this class cannot be called after the client is terminated.
     */    mh() {
        if (this.On.ts) throw new E(T.FAILED_PRECONDITION, "The client has already been terminated.");
    }
    /** Disables the network connection. Pending operations will not complete. */    disableNetwork() {
        return this.mh(), this.On.enqueue((() => (this.persistence.Oc(!1), async function(t) {
            const e = v(t);
            e.Ko.add(0 /* UserDisabled */), await fi(e), 
            // Set the OnlineState to Offline so get()s return from cache, etc.
            e.Xo.set("Offline" /* Offline */);
        }(this.gu))));
    }
    terminate() {
        this.On.rs();
        const t = new Ts;
        return this.On.es((async () => {
            try {
                // PORTING NOTE: LocalStore does not need an explicit shutdown on web.
                this.Ea && this.Ea.stop(), await di(this.gu), await this.Vu.ni(), await this.persistence.ni(), 
                // `removeChangeListener` must be called after shutting down the
                // RemoteStore as it will prevent the RemoteStore from retrieving
                // auth tokens.
                this.credentials.Gr(), t.resolve();
            } catch (e) {
                const n = gs(e, "Failed to shutdown persistence");
                t.reject(n);
            }
        })), t.promise;
    }
    /**
     * Returns a Promise that resolves when all writes that were pending at the time this
     * method was called received server acknowledgement. An acknowledgement can be either acceptance
     * or rejection.
     */    waitForPendingWrites() {
        this.mh();
        const t = new Ts;
        return this.On.jn((() => Zi(this.Va, t))), t.promise;
    }
    listen(t, e, n) {
        this.mh();
        const s = new vr(n), i = new Fs(t, s, e);
        return this.On.jn((() => vs(this.Eh, i))), () => {
            s.Da(), this.On.jn((() => bs(this.Eh, i)));
        };
    }
    async Ah(t) {
        this.mh(), await this.wh.promise;
        const e = new Ts;
        return this.On.jn((() => async function(t, e, n) {
            try {
                const s = await function(t, e) {
                    const n = v(t);
                    return n.persistence.runTransaction("read document", "readonly", (t => n.nr.fi(t, e)));
                }(t, e);
                s instanceof $n ? n.resolve(s) : s instanceof xn ? n.resolve(null) : n.reject(new E(T.UNAVAILABLE, "Failed to get document from cache. (However, this document may exist on the server. Run again without setting 'source' in the GetOptions to attempt to retrieve the document from the server.)"));
            } catch (t) {
                const s = gs(t, `Failed to get document '${e} from cache`);
                n.reject(s);
            }
        }
        /**
 * Retrieves a latency-compensated document from the backend via a
 * SnapshotListener.
 */ (this.Qo, t, e))), e.promise;
    }
    async Rh(t, e = {}) {
        this.mh(), await this.wh.promise;
        const n = new Ts;
        return this.On.jn((() => function(t, e, n, s, i) {
            const r = new vr({
                next: r => {
                    // Remove query first before passing event to user to avoid
                    // user actions affecting the now stale query.
                    e.jn((() => bs(t, o)));
                    const u = r.docs.has(n);
                    !u && r.fromCache ? 
                    // TODO(dimond): If we're online and the document doesn't
                    // exist then we resolve with a doc.exists set to false. If
                    // we're offline however, we reject the Promise in this
                    // case. Two options: 1) Cache the negative response from
                    // the server so we can deliver that even when you're
                    // offline 2) Actually reject the Promise in the online case
                    // if the document doesn't exist.
                    i.reject(new E(T.UNAVAILABLE, "Failed to get document because the client is offline.")) : u && r.fromCache && s && "server" === s.source ? i.reject(new E(T.UNAVAILABLE, 'Failed to get document from server. (However, this document does exist in the local cache. Run again without setting source to "server" to retrieve the cached document.)')) : i.resolve(r);
                },
                error: t => i.reject(t)
            }), o = new Fs(Ln(n.path), r, {
                includeMetadataChanges: !0,
                Ss: !0
            });
            return vs(t, o);
        }(this.Eh, this.On, t, e, n))), n.promise;
    }
    async yh(t) {
        this.mh(), await this.wh.promise;
        const e = new Ts;
        return this.On.jn((() => async function(t, e, n) {
            try {
                const s = await Js(t, e, 
                /* usePreviousResults= */ !0), i = new Ui(e, s.Vr), r = i._u(s.documents), o = i.mu(r, 
                /* updateLimboDocuments= */ !1);
                n.resolve(o.snapshot);
            } catch (t) {
                const s = gs(t, `Failed to execute query '${e} against cache`);
                n.reject(s);
            }
        }
        /**
 * Retrieves a latency-compensated query snapshot from the backend via a
 * SnapshotListener.
 */ (this.Qo, t, e))), e.promise;
    }
    async Ph(t, e = {}) {
        this.mh(), await this.wh.promise;
        const n = new Ts;
        return this.On.jn((() => function(t, e, n, s, i) {
            const r = new vr({
                next: n => {
                    // Remove query first before passing event to user to avoid
                    // user actions affecting the now stale query.
                    e.jn((() => bs(t, o))), n.fromCache && "server" === s.source ? i.reject(new E(T.UNAVAILABLE, 'Failed to get documents from server. (However, these documents may exist in the local cache. Run again without setting source to "server" to retrieve the cached documents.)')) : i.resolve(n);
                },
                error: t => i.reject(t)
            }), o = new Fs(n, r, {
                includeMetadataChanges: !0,
                Ss: !0
            });
            return vs(t, o);
        }
        /**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ (this.Eh, this.On, t, e, n))), n.promise;
    }
    write(t) {
        this.mh();
        const e = new Ts;
        return this.On.jn((() => zi(this.Va, t, e))), e.promise;
    }
    B() {
        return this.sa.B;
    }
    gh(t) {
        this.mh();
        const e = new vr(t);
        return this.On.jn((async () => function(t, e) {
            v(t).Es.add(e), 
            // Immediately fire an initial event, indicating all existing listeners
            // are in-sync.
            e.next();
        }(this.Eh, e))), () => {
            e.Da(), this.On.jn((async () => function(t, e) {
                v(t).Es.delete(e);
            }(this.Eh, e)));
        };
    }
    get ph() {
        // Technically, the asyncQueue is still running, but only accepting operations
        // related to termination or supposed to be run after termination. It is effectively
        // terminated to the eyes of users.
        return this.On.ts;
    }
    /**
     * Takes an updateFunction in which a set of reads and writes can be performed
     * atomically. In the updateFunction, the client can read and write values
     * using the supplied transaction object. After the updateFunction, all
     * changes will be committed. If a retryable error occurs (ex: some other
     * client has changed any of the data referenced), then the updateFunction
     * will be called again after a backoff. If the updateFunction still fails
     * after all retries, then the transaction will be rejected.
     *
     * The transaction object passed to the updateFunction contains methods for
     * accessing documents and collections. Unlike other datastore access, data
     * accessed with the transaction will not reflect local changes that have not
     * been committed. For this reason, it is required that all reads are
     * performed before any writes. Transactions must be performed while online.
     */    transaction(t) {
        this.mh();
        const e = new Ts;
        return this.On.jn((() => (new oo(this.On, this.jo, t, e).run(), Promise.resolve()))), 
        e.promise;
    }
}

function co(t) {
    /**
 * Returns true if obj is an object and contains at least one of the specified
 * methods.
 */
    return function(t, e) {
        if ("object" != typeof t || null === t) return !1;
        const n = t;
        for (const t of e) if (t in n && "function" == typeof n[t]) return !0;
        return !1;
    }
    /**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
    /**
 * Converts Firestore's internal types to the JavaScript types that we expose
 * to the user.
 */ (t, [ "next", "error", "complete" ]);
}

class ao {
    constructor(t, e, n, s, i) {
        this.B = t, this.timestampsInSnapshots = e, this.Vh = n, this.bh = s, this.Sh = i;
    }
    Dh(t) {
        switch (oe(t)) {
          case 0 /* NullValue */ :
            return null;

          case 1 /* BooleanValue */ :
            return t.booleanValue;

          case 2 /* NumberValue */ :
            return de(t.integerValue || t.doubleValue);

          case 3 /* TimestampValue */ :
            return this.Ch(t.timestampValue);

          case 4 /* ServerTimestampValue */ :
            return this.Fh(t);

          case 5 /* StringValue */ :
            return t.stringValue;

          case 6 /* BlobValue */ :
            return this.Sh(we(t.bytesValue));

          case 7 /* RefValue */ :
            return this.Nh(t.referenceValue);

          case 8 /* GeoPointValue */ :
            return this.$h(t.geoPointValue);

          case 9 /* ArrayValue */ :
            return this.xh(t.arrayValue);

          case 10 /* ObjectValue */ :
            return this.kh(t.mapValue);

          default:
            throw p();
        }
    }
    kh(t) {
        const e = {};
        return S(t.fields || {}, ((t, n) => {
            e[t] = this.Dh(n);
        })), e;
    }
    $h(t) {
        return new Lr(de(t.latitude), de(t.longitude));
    }
    xh(t) {
        return (t.values || []).map((t => this.Dh(t)));
    }
    Fh(t) {
        switch (this.Vh) {
          case "previous":
            const e = se(t);
            return null == e ? null : this.Dh(e);

          case "estimate":
            return this.Ch(ie(t));

          default:
            return null;
        }
    }
    Ch(t) {
        const e = fe(t), n = new ft(e.seconds, e.nanos);
        return this.timestampsInSnapshots ? n : n.toDate();
    }
    Nh(t) {
        const e = F.P(t);
        V(Ye(e));
        const n = new lt(e.get(1), e.get(3)), s = new x(e.u(5));
        return n.isEqual(this.B) || 
        // TODO(b/64130202): Somehow support foreign references.
        y(`Document ${s} contains a document reference within a different database (${n.projectId}/${n.database}) which is not supported. It will be treated as a reference in the current database (${this.B.projectId}/${this.B.database}) instead.`), 
        this.bh(s);
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// settings() defaults:
const ho = Us.Oi;

/**
 * A concrete type describing all the values that can be applied via a
 * user-supplied firestore.Settings object. This is a separate type so that
 * defaults can be supplied and the value can be checked for equality.
 */
class lo {
    constructor(t) {
        var e, n, s, i, r;
        if (void 0 === t.host) {
            if (void 0 !== t.ssl) throw new E(T.INVALID_ARGUMENT, "Can't provide ssl option if host option is not set");
            this.host = "firestore.googleapis.com", this.ssl = true;
        } else B("settings", "non-empty string", "host", t.host), this.host = t.host, Q("settings", "boolean", "ssl", t.ssl), 
        this.ssl = null === (e = t.ssl) || void 0 === e || e;
        if (J("settings", t, [ "host", "ssl", "credentials", "timestampsInSnapshots", "cacheSizeBytes", "experimentalForceLongPolling", "experimentalAutoDetectLongPolling", "ignoreUndefinedProperties" ]), 
        Q("settings", "object", "credentials", t.credentials), this.credentials = t.credentials, 
        Q("settings", "boolean", "timestampsInSnapshots", t.timestampsInSnapshots), Q("settings", "boolean", "ignoreUndefinedProperties", t.ignoreUndefinedProperties), 
        // Nobody should set timestampsInSnapshots anymore, but the error depends on
        // whether they set it to true or false...
        !0 === t.timestampsInSnapshots ? y("The setting 'timestampsInSnapshots: true' is no longer required and should be removed.") : !1 === t.timestampsInSnapshots && y("Support for 'timestampsInSnapshots: false' will be removed soon. You must update your code to handle Timestamp objects."), 
        this.timestampsInSnapshots = null === (n = t.timestampsInSnapshots) || void 0 === n || n, 
        this.ignoreUndefinedProperties = null !== (s = t.ignoreUndefinedProperties) && void 0 !== s && s, 
        Q("settings", "number", "cacheSizeBytes", t.cacheSizeBytes), void 0 === t.cacheSizeBytes) this.cacheSizeBytes = Us.Mi; else {
            if (t.cacheSizeBytes !== ho && t.cacheSizeBytes < Us.Li) throw new E(T.INVALID_ARGUMENT, "cacheSizeBytes must be at least " + Us.Li);
            this.cacheSizeBytes = t.cacheSizeBytes;
        }
        Q("settings", "boolean", "experimentalForceLongPolling", t.experimentalForceLongPolling), 
        this.experimentalForceLongPolling = null !== (i = t.experimentalForceLongPolling) && void 0 !== i && i, 
        Q("settings", "boolean", "experimentalAutoDetectLongPolling", t.experimentalAutoDetectLongPolling), 
        this.experimentalAutoDetectLongPolling = null !== (r = t.experimentalAutoDetectLongPolling) && void 0 !== r && r, 
        function(t, e, n, s) {
            if (!0 === e && !0 === s) throw new E(T.INVALID_ARGUMENT, `${t} and ${n} cannot be used together.`);
        }("experimentalForceLongPolling", t.experimentalForceLongPolling, "experimentalAutoDetectLongPolling", t.experimentalAutoDetectLongPolling);
    }
    isEqual(t) {
        return this.host === t.host && this.ssl === t.ssl && this.timestampsInSnapshots === t.timestampsInSnapshots && this.credentials === t.credentials && this.cacheSizeBytes === t.cacheSizeBytes && this.experimentalForceLongPolling === t.experimentalForceLongPolling && this.experimentalAutoDetectLongPolling === t.experimentalAutoDetectLongPolling && this.ignoreUndefinedProperties === t.ignoreUndefinedProperties;
    }
}

/**
 * The root reference to the database.
 */ class _o {
    // Note: We are using `MemoryComponentProvider` as a default
    // ComponentProvider to ensure backwards compatibility with the format
    // expected by the console build.
    constructor(t, e, n = new pr, s = new Vr) {
        if (this.Oh = n, this.Lh = s, this.Mh = null, 
        // Public for use in tests.
        // TODO(mikelehen): Use modularized initialization instead.
        this.qh = new Ps, this.INTERNAL = {
            delete: async () => {
                // The client must be initalized to ensure that all subsequent API usage
                // throws an exception.
                this.Uh(), await this.Bh.terminate();
            }
        }, "object" == typeof t.options) {
            // This is very likely a Firebase app object
            // TODO(b/34177605): Can we somehow use instanceof?
            const n = t;
            this.Mh = n, this.Qa = _o.Qh(n), this.jh = n.name, this.Wh = new si(e);
        } else {
            const e = t;
            if (!e.projectId) throw new E(T.INVALID_ARGUMENT, "Must provide projectId");
            this.Qa = new lt(e.projectId, e.database), 
            // Use a default persistenceKey that lines up with FirebaseApp.
            this.jh = "[DEFAULT]", this.Wh = new ni;
        }
        this.Gh = new lo({});
    }
    get zh() {
        return this.Kh || (
        // Lazy initialize UserDataReader once the settings are frozen
        this.Kh = new Gr(this.Qa, this.Gh.ignoreUndefinedProperties)), this.Kh;
    }
    settings(t) {
        O("Firestore.settings", arguments, 1), q("Firestore.settings", "object", 1, t), 
        t.merge && 
        // Remove the property from the settings once the merge is completed
        delete (t = Object.assign(Object.assign({}, this.Gh), t)).merge;
        const e = new lo(t);
        if (this.Bh && !this.Gh.isEqual(e)) throw new E(T.FAILED_PRECONDITION, "Firestore has already been started and its settings can no longer be changed. You can only call settings() before calling any other methods on a Firestore object.");
        this.Gh = e, void 0 !== e.credentials && (this.Wh = function(t) {
            if (!t) return new ni;
            switch (t.type) {
              case "gapi":
                const e = t.client;
                // Make sure this really is a Gapi client.
                                return V(!("object" != typeof e || null === e || !e.auth || !e.auth.getAuthHeaderValueForFirstParty)), 
                new ri(e, t.sessionIndex || "0");

              case "provider":
                return t.client;

              default:
                throw new E(T.INVALID_ARGUMENT, "makeCredentialsProvider failed due to invalid credential type");
            }
        }
        /**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ (e.credentials));
    }
    enableNetwork() {
        return this.Uh(), this.Bh.enableNetwork();
    }
    disableNetwork() {
        return this.Uh(), this.Bh.disableNetwork();
    }
    enablePersistence(t) {
        var e, n;
        if (this.Bh) throw new E(T.FAILED_PRECONDITION, "Firestore has already been started and persistence can no longer be enabled. You can only call enablePersistence() before calling any other methods on a Firestore object.");
        let s = !1, i = !1;
        if (t && (void 0 !== t.experimentalTabSynchronization && y("The 'experimentalTabSynchronization' setting will be removed. Use 'synchronizeTabs' instead."), 
        s = null !== (n = null !== (e = t.synchronizeTabs) && void 0 !== e ? e : t.experimentalTabSynchronization) && void 0 !== n && n, 
        i = !!t.experimentalForceOwningTab && t.experimentalForceOwningTab, s && i)) throw new E(T.INVALID_ARGUMENT, "The 'experimentalForceOwningTab' setting cannot be used with 'synchronizeTabs'.");
        return this.Hh(this.Oh, this.Lh, {
            ya: !0,
            cacheSizeBytes: this.Gh.cacheSizeBytes,
            synchronizeTabs: s,
            Yh: i
        });
    }
    async clearPersistence() {
        if (void 0 !== this.Bh && !this.Bh.ph) throw new E(T.FAILED_PRECONDITION, "Persistence can only be cleared before a Firestore instance is initialized or after it is terminated.");
        const t = new Ts;
        return this.qh.es((async () => {
            try {
                await this.Oh.clearPersistence(this.Qa, this.jh), t.resolve();
            } catch (e) {
                t.reject(e);
            }
        })), t.promise;
    }
    terminate() {
        return this.app._removeServiceInstance("firestore"), this.INTERNAL.delete();
    }
    get Jh() {
        return this.Uh(), this.Bh.ph;
    }
    waitForPendingWrites() {
        return this.Uh(), this.Bh.waitForPendingWrites();
    }
    onSnapshotsInSync(t) {
        if (this.Uh(), co(t)) return this.Bh.gh(t);
        {
            q("Firestore.onSnapshotsInSync", "function", 1, t);
            const e = {
                next: t
            };
            return this.Bh.gh(e);
        }
    }
    Uh() {
        return this.Bh || 
        // Kick off starting the client but don't actually wait for it.
        // eslint-disable-next-line @typescript-eslint/no-floating-promises
        this.Hh(new pr, new Vr, {
            ya: !1
        }), this.Bh;
    }
    Xh() {
        return new ht(this.Qa, this.jh, this.Gh.host, this.Gh.ssl, this.Gh.experimentalForceLongPolling, this.Gh.experimentalAutoDetectLongPolling);
    }
    Hh(t, e, n) {
        const s = this.Xh();
        return this.Bh = new uo(this.Wh, this.qh), this.Bh.start(s, t, e, n);
    }
    static Qh(t) {
        if (e = t.options, n = "projectId", !Object.prototype.hasOwnProperty.call(e, n)) throw new E(T.INVALID_ARGUMENT, '"projectId" not provided in firebase.initializeApp.');
        var e, n;
        const s = t.options.projectId;
        if (!s || "string" != typeof s) throw new E(T.INVALID_ARGUMENT, "projectId must be a string in FirebaseApp.options");
        return new lt(s);
    }
    get app() {
        if (!this.Mh) throw new E(T.FAILED_PRECONDITION, "Firestore was not initialized using the Firebase SDK. 'app' is not available");
        return this.Mh;
    }
    collection(t) {
        return O("Firestore.collection", arguments, 1), q("Firestore.collection", "non-empty string", 1, t), 
        this.Uh(), new bo(F.P(t), this, 
        /* converter= */ null);
    }
    doc(t) {
        return O("Firestore.doc", arguments, 1), q("Firestore.doc", "non-empty string", 1, t), 
        this.Uh(), mo.Zh(F.P(t), this, 
        /* converter= */ null);
    }
    collectionGroup(t) {
        if (O("Firestore.collectionGroup", arguments, 1), q("Firestore.collectionGroup", "non-empty string", 1, t), 
        t.indexOf("/") >= 0) throw new E(T.INVALID_ARGUMENT, `Invalid collection ID '${t}' passed to function Firestore.collectionGroup(). Collection IDs must not contain '/'.`);
        return this.Uh(), new Vo(
        /**
 * Creates a new Query for a collection group query that matches all documents
 * within the provided collection group.
 */
        function(t) {
            return new On(F.g(), t);
        }(t), this, 
        /* converter= */ null);
    }
    runTransaction(t) {
        return O("Firestore.runTransaction", arguments, 1), q("Firestore.runTransaction", "function", 1, t), 
        this.Uh().transaction((e => t(new fo(this, e))));
    }
    batch() {
        return this.Uh(), new wo(this);
    }
    static get logLevel() {
        switch (A()) {
          case a.DEBUG:
            return "debug";

          case a.ERROR:
            return "error";

          case a.SILENT:
            return "silent";

          case a.WARN:
            return "warn";

          case a.INFO:
            return "info";

          case a.VERBOSE:
            return "verbose";

          default:
            // The default log level is error
            return "error";
        }
    }
    static setLogLevel(t) {
        var e;
        O("Firestore.setLogLevel", arguments, 1), G("setLogLevel", [ "debug", "error", "silent", "warn", "info", "verbose" ], 1, t), 
        e = t, I.setLogLevel(e);
    }
    // Note: this is not a property because the minifier can't work correctly with
    // the way TypeScript compiler outputs properties.
    tl() {
        return this.Gh.timestampsInSnapshots;
    }
    // Visible for testing.
    el() {
        return this.Gh;
    }
}

/**
 * A reference to a transaction.
 */ class fo {
    constructor(t, e) {
        this.nl = t, this.sl = e;
    }
    get(t) {
        O("Transaction.get", arguments, 1);
        const e = Fo("Transaction.get", t, this.nl);
        return this.sl.rh([ e.ja ]).then((t => {
            if (!t || 1 !== t.length) return p();
            const n = t[0];
            if (n instanceof xn) return new Eo(this.nl, e.ja, null, 
            /* fromCache= */ !1, 
            /* hasPendingWrites= */ !1, e.Wa);
            if (n instanceof $n) return new Eo(this.nl, e.ja, n, 
            /* fromCache= */ !1, 
            /* hasPendingWrites= */ !1, e.Wa);
            throw p();
        }));
    }
    set(t, e, n) {
        M("Transaction.set", arguments, 2, 3);
        const s = Fo("Transaction.set", t, this.nl);
        n = So("Transaction.set", n);
        const i = $o(s.Wa, e, n), r = zr(this.nl.zh, "Transaction.set", s.ja, i, null !== s.Wa, n);
        return this.sl.set(s.ja, r), this;
    }
    update(t, e, n, ...s) {
        let i, r;
        return "string" == typeof e || e instanceof Sr ? (L("Transaction.update", arguments, 3), 
        i = Fo("Transaction.update", t, this.nl), r = Hr(this.nl.zh, "Transaction.update", i.ja, e, n, s)) : (O("Transaction.update", arguments, 2), 
        i = Fo("Transaction.update", t, this.nl), r = Kr(this.nl.zh, "Transaction.update", i.ja, e)), 
        this.sl.update(i.ja, r), this;
    }
    delete(t) {
        O("Transaction.delete", arguments, 1);
        const e = Fo("Transaction.delete", t, this.nl);
        return this.sl.delete(e.ja), this;
    }
}

class wo {
    constructor(t) {
        this.nl = t, this.il = [], this.rl = !1;
    }
    set(t, e, n) {
        M("WriteBatch.set", arguments, 2, 3), this.ol();
        const s = Fo("WriteBatch.set", t, this.nl);
        n = So("WriteBatch.set", n);
        const i = $o(s.Wa, e, n), r = zr(this.nl.zh, "WriteBatch.set", s.ja, i, null !== s.Wa, n);
        return this.il = this.il.concat(r.Ga(s.ja, dn.Ye())), this;
    }
    update(t, e, n, ...s) {
        let i, r;
        return this.ol(), "string" == typeof e || e instanceof Sr ? (L("WriteBatch.update", arguments, 3), 
        i = Fo("WriteBatch.update", t, this.nl), r = Hr(this.nl.zh, "WriteBatch.update", i.ja, e, n, s)) : (O("WriteBatch.update", arguments, 2), 
        i = Fo("WriteBatch.update", t, this.nl), r = Kr(this.nl.zh, "WriteBatch.update", i.ja, e)), 
        this.il = this.il.concat(r.Ga(i.ja, dn.exists(!0))), this;
    }
    delete(t) {
        O("WriteBatch.delete", arguments, 1), this.ol();
        const e = Fo("WriteBatch.delete", t, this.nl);
        return this.il = this.il.concat(new bn(e.ja, dn.Ye())), this;
    }
    commit() {
        return this.ol(), this.rl = !0, this.il.length > 0 ? this.nl.Uh().write(this.il) : Promise.resolve();
    }
    ol() {
        if (this.rl) throw new E(T.FAILED_PRECONDITION, "A write batch can no longer be used after commit() has been called.");
    }
}

/**
 * A reference to a particular document in a collection in the database.
 */ class mo extends Ur {
    constructor(t, e, n) {
        super(e.Qa, t, n), this.ja = t, this.firestore = e, this.Wa = n, this.Bh = this.firestore.Uh();
    }
    static Zh(t, e, n) {
        if (t.length % 2 != 0) throw new E(T.INVALID_ARGUMENT, `Invalid document reference. Document references must have an even number of segments, but ${t.R()} has ${t.length}`);
        return new mo(new x(t), e, n);
    }
    get id() {
        return this.ja.path._();
    }
    get parent() {
        return new bo(this.ja.path.h(), this.firestore, this.Wa);
    }
    get path() {
        return this.ja.path.R();
    }
    collection(t) {
        if (O("DocumentReference.collection", arguments, 1), q("DocumentReference.collection", "non-empty string", 1, t), 
        !t) throw new E(T.INVALID_ARGUMENT, "Must provide a non-empty collection name to collection()");
        const e = F.P(t);
        return new bo(this.ja.path.child(e), this.firestore, 
        /* converter= */ null);
    }
    isEqual(t) {
        if (!(t instanceof mo)) throw X("isEqual", "DocumentReference", 1, t);
        return this.firestore === t.firestore && this.ja.isEqual(t.ja) && this.Wa === t.Wa;
    }
    set(t, e) {
        M("DocumentReference.set", arguments, 1, 2), e = So("DocumentReference.set", e);
        const n = $o(this.Wa, t, e), s = zr(this.firestore.zh, "DocumentReference.set", this.ja, n, null !== this.Wa, e);
        return this.Bh.write(s.Ga(this.ja, dn.Ye()));
    }
    update(t, e, ...n) {
        let s;
        return "string" == typeof t || t instanceof Sr ? (L("DocumentReference.update", arguments, 2), 
        s = Hr(this.firestore.zh, "DocumentReference.update", this.ja, t, e, n)) : (O("DocumentReference.update", arguments, 1), 
        s = Kr(this.firestore.zh, "DocumentReference.update", this.ja, t)), this.Bh.write(s.Ga(this.ja, dn.exists(!0)));
    }
    delete() {
        return O("DocumentReference.delete", arguments, 0), this.Bh.write([ new bn(this.ja, dn.Ye()) ]);
    }
    onSnapshot(...t) {
        var e, n, s;
        M("DocumentReference.onSnapshot", arguments, 1, 4);
        let i = {
            includeMetadataChanges: !1
        }, r = 0;
        "object" != typeof t[r] || co(t[r]) || (i = t[r], J("DocumentReference.onSnapshot", i, [ "includeMetadataChanges" ]), 
        Q("DocumentReference.onSnapshot", "boolean", "includeMetadataChanges", i.includeMetadataChanges), 
        r++);
        const o = {
            includeMetadataChanges: i.includeMetadataChanges
        };
        if (co(t[r])) {
            const i = t[r];
            t[r] = null === (e = i.next) || void 0 === e ? void 0 : e.bind(i), t[r + 1] = null === (n = i.error) || void 0 === n ? void 0 : n.bind(i), 
            t[r + 2] = null === (s = i.complete) || void 0 === s ? void 0 : s.bind(i);
        } else q("DocumentReference.onSnapshot", "function", r, t[r]), U("DocumentReference.onSnapshot", "function", r + 1, t[r + 1]), 
        U("DocumentReference.onSnapshot", "function", r + 2, t[r + 2]);
        const u = {
            next: e => {
                t[r] && t[r](this.ul(e));
            },
            error: t[r + 1],
            complete: t[r + 2]
        };
        return this.Bh.listen(Ln(this.ja.path), o, u);
    }
    get(t) {
        M("DocumentReference.get", arguments, 0, 1), Co("DocumentReference.get", t);
        const e = this.firestore.Uh();
        return t && "cache" === t.source ? e.Ah(this.ja).then((t => new Eo(this.firestore, this.ja, t, 
        /*fromCache=*/ !0, t instanceof $n && t.Je, this.Wa))) : e.Rh(this.ja, t).then((t => this.ul(t)));
    }
    withConverter(t) {
        return new mo(this.ja, this.firestore, t);
    }
    /**
     * Converts a ViewSnapshot that contains the current document to a
     * DocumentSnapshot.
     */    ul(t) {
        const e = t.docs.get(this.ja);
        return new Eo(this.firestore, this.ja, e, t.fromCache, t.hasPendingWrites, this.Wa);
    }
}

/**
 * Metadata about a snapshot, describing the state of the snapshot.
 */ class To {
    constructor(t, e) {
        this.hasPendingWrites = t, this.fromCache = e;
    }
    /**
     * Returns true if this `SnapshotMetadata` is equal to the provided one.
     *
     * @param other The `SnapshotMetadata` to compare against.
     * @return true if this `SnapshotMetadata` is equal to the provided one.
     */    isEqual(t) {
        return this.hasPendingWrites === t.hasPendingWrites && this.fromCache === t.fromCache;
    }
}

class Eo {
    constructor(t, e, n, s, i, r) {
        this.nl = t, this.ja = e, this.cl = n, this.al = s, this.hl = i, this.Wa = r;
    }
    data(t) {
        if (M("DocumentSnapshot.data", arguments, 0, 1), t = Do("DocumentSnapshot.data", t), 
        this.cl) {
            // We only want to use the converter and create a new DocumentSnapshot
            // if a converter has been provided.
            if (this.Wa) {
                const e = new Io(this.nl, this.ja, this.cl, this.al, this.hl, 
                /* converter= */ null);
                return this.Wa.fromFirestore(e, t);
            }
            return new ao(this.nl.Qa, this.nl.tl(), t.serverTimestamps || "none", (t => new mo(t, this.nl, /* converter= */ null)), (t => new at(t))).Dh(this.cl.rn());
        }
    }
    get(t, e) {
        if (M("DocumentSnapshot.get", arguments, 1, 2), e = Do("DocumentSnapshot.get", e), 
        this.cl) {
            const n = this.cl.data().field(eo("DocumentSnapshot.get", t, this.ja));
            if (null !== n) {
                return new ao(this.nl.Qa, this.nl.tl(), e.serverTimestamps || "none", (t => new mo(t, this.nl, this.Wa)), (t => new at(t))).Dh(n);
            }
        }
    }
    get id() {
        return this.ja.path._();
    }
    get ref() {
        return new mo(this.ja, this.nl, this.Wa);
    }
    get exists() {
        return null !== this.cl;
    }
    get metadata() {
        return new To(this.hl, this.al);
    }
    isEqual(t) {
        if (!(t instanceof Eo)) throw X("isEqual", "DocumentSnapshot", 1, t);
        return this.nl === t.nl && this.al === t.al && this.ja.isEqual(t.ja) && (null === this.cl ? null === t.cl : this.cl.isEqual(t.cl)) && this.Wa === t.Wa;
    }
}

class Io extends Eo {
    data(t) {
        return super.data(t);
    }
}

function Ao(t, e, n, s, i, r, o) {
    let u;
    if (i.V()) {
        if ("array-contains" /* ARRAY_CONTAINS */ === r || "array-contains-any" /* ARRAY_CONTAINS_ANY */ === r) throw new E(T.INVALID_ARGUMENT, `Invalid Query. You can't perform '${r}' queries on FieldPath.documentId().`);
        if ("in" /* IN */ === r || "not-in" /* NOT_IN */ === r) {
            Po(o, r);
            const e = [];
            for (const n of o) e.push(yo(s, t, n));
            u = {
                arrayValue: {
                    values: e
                }
            };
        } else u = yo(s, t, o);
    } else "in" /* IN */ !== r && "not-in" /* NOT_IN */ !== r && "array-contains-any" /* ARRAY_CONTAINS_ANY */ !== r || Po(o, r), 
    u = Yr(n, e, o, 
    /* allowArrays= */ "in" /* IN */ === r || "not-in" /* NOT_IN */ === r);
    const c = ts.create(i, r, u);
    return function(t, e) {
        if (e.hn()) {
            const n = Bn(t);
            if (null !== n && !n.isEqual(e.field)) throw new E(T.INVALID_ARGUMENT, `Invalid query. All where filters with an inequality (<, <=, >, or >=) must be on the same field. But you have inequality filters on '${n.toString()}' and '${e.field.toString()}'`);
            const s = Un(t);
            null !== s && go(t, e.field, s);
        }
        const n = function(t, e) {
            for (const n of t.filters) if (e.indexOf(n.op) >= 0) return n.op;
            return null;
        }(t, 
        /**
 * Given an operator, returns the set of operators that cannot be used with it.
 *
 * Operators in a query must adhere to the following set of rules:
 * 1. Only one array operator is allowed.
 * 2. Only one disjunctive operator is allowed.
 * 3. NOT_EQUAL cannot be used with another NOT_EQUAL operator.
 * 4. NOT_IN cannot be used with array, disjunctive, or NOT_EQUAL operators.
 *
 * Array operators: ARRAY_CONTAINS, ARRAY_CONTAINS_ANY
 * Disjunctive operators: IN, ARRAY_CONTAINS_ANY, NOT_IN
 */
        function(t) {
            switch (t) {
              case "!=" /* NOT_EQUAL */ :
                return [ "!=" /* NOT_EQUAL */ , "not-in" /* NOT_IN */ ];

              case "array-contains" /* ARRAY_CONTAINS */ :
                return [ "array-contains" /* ARRAY_CONTAINS */ , "array-contains-any" /* ARRAY_CONTAINS_ANY */ , "not-in" /* NOT_IN */ ];

              case "in" /* IN */ :
                return [ "array-contains-any" /* ARRAY_CONTAINS_ANY */ , "in" /* IN */ , "not-in" /* NOT_IN */ ];

              case "array-contains-any" /* ARRAY_CONTAINS_ANY */ :
                return [ "array-contains" /* ARRAY_CONTAINS */ , "array-contains-any" /* ARRAY_CONTAINS_ANY */ , "in" /* IN */ , "not-in" /* NOT_IN */ ];

              case "not-in" /* NOT_IN */ :
                return [ "array-contains" /* ARRAY_CONTAINS */ , "array-contains-any" /* ARRAY_CONTAINS_ANY */ , "in" /* IN */ , "not-in" /* NOT_IN */ , "!=" /* NOT_EQUAL */ ];

              default:
                return [];
            }
        }(e.op));
        if (null !== n) 
        // Special case when it's a duplicate op to give a slightly clearer error message.
        throw n === e.op ? new E(T.INVALID_ARGUMENT, `Invalid query. You cannot use more than one '${e.op.toString()}' filter.`) : new E(T.INVALID_ARGUMENT, `Invalid query. You cannot use '${e.op.toString()}' filters with '${n.toString()}' filters.`);
    }(t, c), c;
}

function Ro(t, e, n) {
    if (null !== t.startAt) throw new E(T.INVALID_ARGUMENT, "Invalid query. You must not call startAt() or startAfter() before calling orderBy().");
    if (null !== t.endAt) throw new E(T.INVALID_ARGUMENT, "Invalid query. You must not call endAt() or endBefore() before calling orderBy().");
    const s = new ds(e, n);
    return function(t, e) {
        if (null === Un(t)) {
            // This is the first order by. It must match any inequality.
            const n = Bn(t);
            null !== n && go(t, n, e.field);
        }
    }(t, s), s;
}

/**
 * Create a Bound from a query and a document.
 *
 * Note that the Bound will always include the key of the document
 * and so only the provided document will compare equal to the returned
 * position.
 *
 * Will throw if the document does not contain all fields of the order by
 * of the query or if any of the fields in the order by are an uncommitted
 * server timestamp.
 */
/**
 * Parses the given documentIdValue into a ReferenceValue, throwing
 * appropriate errors if the value is anything other than a DocumentReference
 * or String, or if the string is malformed.
 */
function yo(t, e, n) {
    if ("string" == typeof n) {
        if ("" === n) throw new E(T.INVALID_ARGUMENT, "Invalid query. When querying with FieldPath.documentId(), you must provide a valid document ID, but it was an empty string.");
        if (!Qn(e) && -1 !== n.indexOf("/")) throw new E(T.INVALID_ARGUMENT, `Invalid query. When querying a collection by FieldPath.documentId(), you must provide a plain document ID, but '${n}' contains a '/' character.`);
        const s = e.path.child(F.P(n));
        if (!x.N(s)) throw new E(T.INVALID_ARGUMENT, `Invalid query. When querying a collection group by FieldPath.documentId(), the value provided must result in a valid document path, but '${s}' is not because it has an odd number of segments (${s.length}).`);
        return me(t, new x(s));
    }
    if (n instanceof Ur) return me(t, n.ja);
    throw new E(T.INVALID_ARGUMENT, "Invalid query. When querying with FieldPath.documentId(), you must provide a valid string or a DocumentReference, but it was: " + H(n) + ".");
}

/**
 * Validates that the value passed into a disjunctive filter satisfies all
 * array requirements.
 */ function Po(t, e) {
    if (!Array.isArray(t) || 0 === t.length) throw new E(T.INVALID_ARGUMENT, `Invalid Query. A non-empty array is required for '${e.toString()}' filters.`);
    if (t.length > 10) throw new E(T.INVALID_ARGUMENT, `Invalid Query. '${e.toString()}' filters support a maximum of 10 elements in the value array.`);
    if ("in" /* IN */ === e || "array-contains-any" /* ARRAY_CONTAINS_ANY */ === e) {
        if (t.indexOf(null) >= 0) throw new E(T.INVALID_ARGUMENT, `Invalid Query. '${e.toString()}' filters cannot contain 'null' in the value array.`);
        if (t.filter((t => Number.isNaN(t))).length > 0) throw new E(T.INVALID_ARGUMENT, `Invalid Query. '${e.toString()}' filters cannot contain 'NaN' in the value array.`);
    }
}

function go(t, e, n) {
    if (!n.isEqual(e)) throw new E(T.INVALID_ARGUMENT, `Invalid query. You have a where filter with an inequality (<, <=, >, or >=) on field '${e.toString()}' and so you must also use '${e.toString()}' as your first orderBy(), but your first orderBy() is on field '${n.toString()}' instead.`);
}

function po(t) {
    if (qn(t) && 0 === t.on.length) throw new E(T.UNIMPLEMENTED, "limitToLast() queries require specifying at least one orderBy() clause");
}

class Vo {
    constructor(t, e, n) {
        this.ll = t, this.firestore = e, this.Wa = n;
    }
    where(t, e, n) {
        O("Query.where", arguments, 3), Y("Query.where", 3, n);
        // Enumerated from the WhereFilterOp type in index.d.ts.
        const s = G("Query.where", [ "<" /* LESS_THAN */ , "<=" /* LESS_THAN_OR_EQUAL */ , "==" /* EQUAL */ , "!=" /* NOT_EQUAL */ , ">=" /* GREATER_THAN_OR_EQUAL */ , ">" /* GREATER_THAN */ , "array-contains" /* ARRAY_CONTAINS */ , "in" /* IN */ , "array-contains-any" /* ARRAY_CONTAINS_ANY */ , "not-in" /* NOT_IN */ ], 2, e), i = eo("Query.where", t), r = Ao(this.ll, "Query.where", this.firestore.zh, this.firestore.Qa, i, s, n);
        return new Vo(function(t, e) {
            const n = t.filters.concat([ e ]);
            return new On(t.path, t.collectionGroup, t.on.slice(), n, t.limit, t.un, t.startAt, t.endAt);
        }(this.ll, r), this.firestore, this.Wa);
    }
    orderBy(t, e) {
        let n;
        if (M("Query.orderBy", arguments, 1, 2), U("Query.orderBy", "non-empty string", 2, e), 
        void 0 === e || "asc" === e) n = "asc" /* ASCENDING */; else {
            if ("desc" !== e) throw new E(T.INVALID_ARGUMENT, `Function Query.orderBy() has unknown direction '${e}', expected 'asc' or 'desc'.`);
            n = "desc" /* DESCENDING */;
        }
        const s = eo("Query.orderBy", t), i = Ro(this.ll, s, n);
        return new Vo(function(t, e) {
            // TODO(dimond): validate that orderBy does not list the same key twice.
            const n = t.on.concat([ e ]);
            return new On(t.path, t.collectionGroup, n, t.filters.slice(), t.limit, t.un, t.startAt, t.endAt);
        }(this.ll, i), this.firestore, this.Wa);
    }
    limit(t) {
        return O("Query.limit", arguments, 1), q("Query.limit", "number", 1, t), Z("Query.limit", 1, t), 
        new Vo(Gn(this.ll, t, "F" /* First */), this.firestore, this.Wa);
    }
    limitToLast(t) {
        return O("Query.limitToLast", arguments, 1), q("Query.limitToLast", "number", 1, t), 
        Z("Query.limitToLast", 1, t), new Vo(Gn(this.ll, t, "L" /* Last */), this.firestore, this.Wa);
    }
    startAt(t, ...e) {
        L("Query.startAt", arguments, 1);
        const n = this._l("Query.startAt", t, e, 
        /*before=*/ !0);
        return new Vo(zn(this.ll, n), this.firestore, this.Wa);
    }
    startAfter(t, ...e) {
        L("Query.startAfter", arguments, 1);
        const n = this._l("Query.startAfter", t, e, 
        /*before=*/ !1);
        return new Vo(zn(this.ll, n), this.firestore, this.Wa);
    }
    endBefore(t, ...e) {
        L("Query.endBefore", arguments, 1);
        const n = this._l("Query.endBefore", t, e, 
        /*before=*/ !0);
        return new Vo(Kn(this.ll, n), this.firestore, this.Wa);
    }
    endAt(t, ...e) {
        L("Query.endAt", arguments, 1);
        const n = this._l("Query.endAt", t, e, 
        /*before=*/ !1);
        return new Vo(Kn(this.ll, n), this.firestore, this.Wa);
    }
    isEqual(t) {
        if (!(t instanceof Vo)) throw X("isEqual", "Query", 1, t);
        return this.firestore === t.firestore && Hn(this.ll, t.ll) && this.Wa === t.Wa;
    }
    withConverter(t) {
        return new Vo(this.ll, this.firestore, t);
    }
    /** Helper function to create a bound from a document or fields */    _l(t, e, n, s) {
        if (Y(t, 1, e), e instanceof Eo) return O(t, [ e, ...n ], 1), function(t, e, n, s, i) {
            if (!s) throw new E(T.NOT_FOUND, "Can't use a DocumentSnapshot that doesn't exist for " + n + "().");
            const r = [];
            // Because people expect to continue/end a query at the exact document
            // provided, we need to use the implicit sort order rather than the explicit
            // sort order, because it's guaranteed to contain the document key. That way
            // the position becomes unambiguous and the query continues/ends exactly at
            // the provided document. Without the key (by using the explicit sort
            // orders), multiple documents could match the position, yielding duplicate
            // results.
                        for (const n of jn(t)) if (n.field.V()) r.push(me(e, s.key)); else {
                const t = s.field(n.field);
                if (ne(t)) throw new E(T.INVALID_ARGUMENT, 'Invalid query. You are trying to start or end a query using a document for which the field "' + n.field + '" is an uncommitted server timestamp. (Since the value of this field is unknown, you cannot start/end a query with it.)');
                if (null === t) {
                    const t = n.field.R();
                    throw new E(T.INVALID_ARGUMENT, `Invalid query. You are trying to start or end a query using a document for which the field '${t}' (used as the orderBy) does not exist.`);
                }
                r.push(t);
            }
            return new hs(r, i);
        }
        /**
 * Converts a list of field values to a Bound for the given query.
 */ (this.ll, this.firestore.Qa, t, e.cl, s);
        {
            const i = [ e ].concat(n);
            return function(t, e, n, s, i, r) {
                // Use explicit order by's because it has to match the query the user made
                const o = t.on;
                if (i.length > o.length) throw new E(T.INVALID_ARGUMENT, `Too many arguments provided to ${s}(). The number of arguments must be less than or equal to the number of orderBy() clauses`);
                const u = [];
                for (let r = 0; r < i.length; r++) {
                    const c = i[r];
                    if (o[r].field.V()) {
                        if ("string" != typeof c) throw new E(T.INVALID_ARGUMENT, `Invalid query. Expected a string for document ID in ${s}(), but got a ${typeof c}`);
                        if (!Qn(t) && -1 !== c.indexOf("/")) throw new E(T.INVALID_ARGUMENT, `Invalid query. When querying a collection and ordering by FieldPath.documentId(), the value passed to ${s}() must be a plain document ID, but '${c}' contains a slash.`);
                        const n = t.path.child(F.P(c));
                        if (!x.N(n)) throw new E(T.INVALID_ARGUMENT, `Invalid query. When querying a collection group and ordering by FieldPath.documentId(), the value passed to ${s}() must result in a valid document path, but '${n}' is not because it contains an odd number of segments.`);
                        const i = new x(n);
                        u.push(me(e, i));
                    } else {
                        const t = Yr(n, s, c);
                        u.push(t);
                    }
                }
                return new hs(u, r);
            }(this.ll, this.firestore.Qa, this.firestore.zh, t, i, s);
        }
    }
    onSnapshot(...t) {
        var e, n, s;
        M("Query.onSnapshot", arguments, 1, 4);
        let i = {}, r = 0;
        if ("object" != typeof t[r] || co(t[r]) || (i = t[r], J("Query.onSnapshot", i, [ "includeMetadataChanges" ]), 
        Q("Query.onSnapshot", "boolean", "includeMetadataChanges", i.includeMetadataChanges), 
        r++), co(t[r])) {
            const i = t[r];
            t[r] = null === (e = i.next) || void 0 === e ? void 0 : e.bind(i), t[r + 1] = null === (n = i.error) || void 0 === n ? void 0 : n.bind(i), 
            t[r + 2] = null === (s = i.complete) || void 0 === s ? void 0 : s.bind(i);
        } else q("Query.onSnapshot", "function", r, t[r]), U("Query.onSnapshot", "function", r + 1, t[r + 1]), 
        U("Query.onSnapshot", "function", r + 2, t[r + 2]);
        const o = {
            next: e => {
                t[r] && t[r](new vo(this.firestore, this.ll, e, this.Wa));
            },
            error: t[r + 1],
            complete: t[r + 2]
        };
        po(this.ll);
        return this.firestore.Uh().listen(this.ll, i, o);
    }
    get(t) {
        M("Query.get", arguments, 0, 1), Co("Query.get", t), po(this.ll);
        const e = this.firestore.Uh();
        return (t && "cache" === t.source ? e.yh(this.ll) : e.Ph(this.ll, t)).then((t => new vo(this.firestore, this.ll, t, this.Wa)));
    }
}

class vo {
    constructor(t, e, n, s) {
        this.nl = t, this.fl = e, this.dl = n, this.Wa = s, this.wl = null, this.ml = null, 
        this.metadata = new To(n.hasPendingWrites, n.fromCache);
    }
    get docs() {
        const t = [];
        return this.forEach((e => t.push(e))), t;
    }
    get empty() {
        return this.dl.docs.m();
    }
    get size() {
        return this.dl.docs.size;
    }
    forEach(t, e) {
        M("QuerySnapshot.forEach", arguments, 1, 2), q("QuerySnapshot.forEach", "function", 1, t), 
        this.dl.docs.forEach((n => {
            t.call(e, this.Tl(n, this.metadata.fromCache, this.dl.jt.has(n.key)));
        }));
    }
    get query() {
        return new Vo(this.fl, this.nl, this.Wa);
    }
    docChanges(t) {
        t && (J("QuerySnapshot.docChanges", t, [ "includeMetadataChanges" ]), Q("QuerySnapshot.docChanges", "boolean", "includeMetadataChanges", t.includeMetadataChanges));
        const e = !(!t || !t.includeMetadataChanges);
        if (e && this.dl.Gt) throw new E(T.INVALID_ARGUMENT, "To include metadata changes with your document changes, you must also pass { includeMetadataChanges:true } to onSnapshot().");
        return this.wl && this.ml === e || (this.wl = 
        /**
 * Calculates the array of DocumentChanges for a given ViewSnapshot.
 *
 * Exported for testing.
 *
 * @param snapshot The ViewSnapshot that represents the expected state.
 * @param includeMetadataChanges Whether to include metadata changes.
 * @param converter A factory function that returns a QueryDocumentSnapshot.
 * @return An object that matches the DocumentChange API.
 */
        function(t, e, n) {
            if (t.Qt.m()) {
                // Special case the first snapshot because index calculation is easy and
                // fast
                let e, s = 0;
                return t.docChanges.map((i => {
                    const r = n(i.doc, t.fromCache, t.jt.has(i.doc.key));
                    return e = i.doc, {
                        type: "added",
                        doc: r,
                        oldIndex: -1,
                        newIndex: s++
                    };
                }));
            }
            {
                // A DocumentSet that is updated incrementally as changes are applied to use
                // to lookup the index of a document.
                let s = t.Qt;
                return t.docChanges.filter((t => e || 3 /* Metadata */ !== t.type)).map((e => {
                    const i = n(e.doc, t.fromCache, t.jt.has(e.doc.key));
                    let r = -1, o = -1;
                    return 0 /* Added */ !== e.type && (r = s.indexOf(e.doc.key), s = s.delete(e.doc.key)), 
                    1 /* Removed */ !== e.type && (s = s.add(e.doc), o = s.indexOf(e.doc.key)), {
                        type: No(e.type),
                        doc: i,
                        oldIndex: r,
                        newIndex: o
                    };
                }));
            }
        }(this.dl, e, this.Tl.bind(this)), this.ml = e), this.wl;
    }
    /** Check the equality. The call can be very expensive. */    isEqual(t) {
        if (!(t instanceof vo)) throw X("isEqual", "QuerySnapshot", 1, t);
        return this.nl === t.nl && Hn(this.fl, t.fl) && this.dl.isEqual(t.dl) && this.Wa === t.Wa;
    }
    Tl(t, e, n) {
        return new Io(this.nl, t.key, t, e, n, this.Wa);
    }
}

class bo extends Vo {
    constructor(t, e, n) {
        if (super(Ln(t), e, n), this.El = t, t.length % 2 != 1) throw new E(T.INVALID_ARGUMENT, `Invalid collection reference. Collection references must have an odd number of segments, but ${t.R()} has ${t.length}`);
    }
    get id() {
        return this.ll.path._();
    }
    get parent() {
        const t = this.ll.path.h();
        return t.m() ? null : new mo(new x(t), this.firestore, 
        /* converter= */ null);
    }
    get path() {
        return this.ll.path.R();
    }
    doc(t) {
        M("CollectionReference.doc", arguments, 0, 1), 
        // We allow omission of 'pathString' but explicitly prohibit passing in both
        // 'undefined' and 'null'.
        0 === arguments.length && (t = st.k()), q("CollectionReference.doc", "non-empty string", 1, t);
        const e = F.P(t);
        return mo.Zh(this.ll.path.child(e), this.firestore, this.Wa);
    }
    add(t) {
        O("CollectionReference.add", arguments, 1);
        const e = this.Wa ? this.Wa.toFirestore(t) : t;
        q("CollectionReference.add", "object", 1, e);
        const n = this.doc();
        // Call set() with the converted value directly to avoid calling toFirestore() a second time.
                return new mo(n.ja, this.firestore, null).set(e).then((() => n));
    }
    withConverter(t) {
        return new bo(this.El, this.firestore, t);
    }
}

function So(t, e) {
    if (void 0 === e) return {
        merge: !1
    };
    if (J(t, e, [ "merge", "mergeFields" ]), Q(t, "boolean", "merge", e.merge), j(t, "mergeFields", "a string or a FieldPath", e.mergeFields, (t => "string" == typeof t || t instanceof Sr)), 
    void 0 !== e.mergeFields && void 0 !== e.merge) throw new E(T.INVALID_ARGUMENT, `Invalid options passed to function ${t}(): You cannot specify both "merge" and "mergeFields".`);
    return e;
}

function Do(t, e) {
    return void 0 === e ? {} : (J(t, e, [ "serverTimestamps" ]), W(t, 0, "serverTimestamps", e.serverTimestamps, [ "estimate", "previous", "none" ]), 
    e);
}

function Co(t, e) {
    U(t, "object", 1, e), e && (J(t, e, [ "source" ]), W(t, 0, "source", e.source, [ "default", "server", "cache" ]));
}

function Fo(t, e, n) {
    if (e instanceof Ur) {
        if (e.firestore !== n) throw new E(T.INVALID_ARGUMENT, "Provided document reference is from a different Firestore instance.");
        return e;
    }
    throw X(t, "DocumentReference", 1, e);
}

function No(t) {
    switch (t) {
      case 0 /* Added */ :
        return "added";

      case 2 /* Modified */ :
      case 3 /* Metadata */ :
        return "modified";

      case 1 /* Removed */ :
        return "removed";

      default:
        return p();
    }
}

/**
 * Converts custom model object of type T into DocumentData by applying the
 * converter if it exists.
 *
 * This function is used when converting user objects to DocumentData
 * because we want to provide the user with a more specific error message if
 * their set() or fails due to invalid data originating from a toFirestore()
 * call.
 */ function $o(t, e, n) {
    let s;
    // Cast to `any` in order to satisfy the union type constraint on
    // toFirestore().
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    return s = t ? n && (n.merge || n.mergeFields) ? t.toFirestore(e, n) : t.toFirestore(e) : e, 
    s;
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
class xo extends Mr {
    static serverTimestamp() {
        k("FieldValue.serverTimestamp", arguments);
        const t = new $r("serverTimestamp");
        return t.Fa = "FieldValue.serverTimestamp", new xo(t);
    }
    static delete() {
        k("FieldValue.delete", arguments);
        const t = new Fr("deleteField");
        return t.Fa = "FieldValue.delete", new xo(t);
    }
    static arrayUnion(...t) {
        L("FieldValue.arrayUnion", arguments, 1);
        const e = 
        /**
 * Returns a special value that can be used with {@link setDoc()} or {@link
 * updateDoc()} that tells the server to union the given elements with any array
 * value that already exists on the server. Each specified element that doesn't
 * already exist in the array will be added to the end. If the field being
 * modified is not already an array it will be overwritten with an array
 * containing exactly the specified elements.
 *
 * @param elements The elements to union into the array.
 * @return The `FieldValue` sentinel for use in a call to `setDoc()` or
 * `updateDoc()`.
 */
        function(...t) {
            // NOTE: We don't actually parse the data until it's used in set() or
            // update() since we'd need the Firestore instance to do this.
            return L("arrayUnion()", arguments, 1), new xr("arrayUnion", t);
        }
        /**
 * Returns a special value that can be used with {@link setDoc()} or {@link
 * updateDoc()} that tells the server to remove the given elements from any
 * array value that already exists on the server. All instances of each element
 * specified will be removed from the array. If the field being modified is not
 * already an array it will be overwritten with an empty array.
 *
 * @param elements The elements to remove from the array.
 * @return The `FieldValue` sentinel for use in a call to `setDoc()` or
 * `updateDoc()`
 */ (...t);
        return e.Fa = "FieldValue.arrayUnion", new xo(e);
    }
    static arrayRemove(...t) {
        L("FieldValue.arrayRemove", arguments, 1);
        const e = function(...t) {
            // NOTE: We don't actually parse the data until it's used in set() or
            // update() since we'd need the Firestore instance to do this.
            return L("arrayRemove()", arguments, 1), new kr("arrayRemove", t);
        }
        /**
 * Returns a special value that can be used with {@link setDoc()} or {@link
 * updateDoc()} that tells the server to increment the field's current value by
 * the given value.
 *
 * If either the operand or the current field value uses floating point
 * precision, all arithmetic follows IEEE 754 semantics. If both values are
 * integers, values outside of JavaScript's safe number range
 * (`Number.MIN_SAFE_INTEGER` to `Number.MAX_SAFE_INTEGER`) are also subject to
 * precision loss. Furthermore, once processed by the Firestore backend, all
 * integer operations are capped between -2^63 and 2^63-1.
 *
 * If the current field value is not of type `number`, or if the field does not
 * yet exist, the transformation sets the field to the given value.
 *
 * @param n The value to increment by.
 * @return The `FieldValue` sentinel for use in a call to `setDoc()` or
 * `updateDoc()`
 */ (...t);
        return e.Fa = "FieldValue.arrayRemove", new xo(e);
    }
    static increment(t) {
        q("FieldValue.increment", "number", 1, t), O("FieldValue.increment", arguments, 1);
        const e = function(t) {
            return new Or("increment", t);
        }(t);
        return e.Fa = "FieldValue.increment", new xo(e);
    }
    isEqual(t) {
        return this.Ba.isEqual(t.Ba);
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ const ko = {
    Firestore: _o,
    GeoPoint: Lr,
    Timestamp: ft,
    Blob: at,
    Transaction: fo,
    WriteBatch: wo,
    DocumentReference: mo,
    DocumentSnapshot: Eo,
    Query: Vo,
    QueryDocumentSnapshot: Io,
    QuerySnapshot: vo,
    CollectionReference: bo,
    FieldPath: Sr,
    FieldValue: xo,
    setLogLevel: _o.setLogLevel,
    CACHE_SIZE_UNLIMITED: ho
};

/**
 * Configures Firestore as part of the Firebase SDK by calling registerService.
 *
 * @param firebase The FirebaseNamespace to register Firestore with
 * @param firestoreFactory A factory function that returns a new Firestore
 *    instance.
 */
/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Registers the memory-only Firestore build for ReactNative with the components
 * framework.
 */
function Oo(t) {
    !function(t, e) {
        t.INTERNAL.registerComponent(new w("firestore", (t => {
            const n = t.getProvider("app").getImmediate();
            return e(n, t.getProvider("auth-internal"));
        }), "PUBLIC" /* PUBLIC */).setServiceProps(Object.assign({}, ko)));
    }(t, ((t, e) => new _o(t, e, new pr, new Vr))), t.registerVersion("@firebase/firestore", "1.18.0", "rn");
}

Oo(t);

export { Oo as __PRIVATE_registerFirestore };
//# sourceMappingURL=index.memory.rn.esm2017.js.map
;