"use strict";

Object.defineProperty(exports, "__esModule", {
    value: !0
});

var t = require("tslib"), e = require("@firebase/app"), n = require("@firebase/logger"), r = require("@firebase/util"), i = require("@firebase/webchannel-wrapper"), o = require("@firebase/component");

function s(t) {
    return t && "object" == typeof t && "default" in t ? t : {
        default: t
    };
}

var u =  s(e), a = {
    // Causes are copied from:
    // https://github.com/grpc/grpc/blob/bceec94ea4fc5f0085d81235d8e1c06798dc341a/include/grpc%2B%2B/impl/codegen/status_code_enum.h
    /** Not an error; returned on success. */
    OK: "ok",
    /** The operation was cancelled (typically by the caller). */
    CANCELLED: "cancelled",
    /** Unknown error or an error from a different error domain. */
    UNKNOWN: "unknown",
    /**
     * Client specified an invalid argument. Note that this differs from
     * FAILED_PRECONDITION. INVALID_ARGUMENT indicates arguments that are
     * problematic regardless of the state of the system (e.g., a malformed file
     * name).
     */
    INVALID_ARGUMENT: "invalid-argument",
    /**
     * Deadline expired before operation could complete. For operations that
     * change the state of the system, this error may be returned even if the
     * operation has completed successfully. For example, a successful response
     * from a server could have been delayed long enough for the deadline to
     * expire.
     */
    DEADLINE_EXCEEDED: "deadline-exceeded",
    /** Some requested entity (e.g., file or directory) was not found. */
    NOT_FOUND: "not-found",
    /**
     * Some entity that we attempted to create (e.g., file or directory) already
     * exists.
     */
    ALREADY_EXISTS: "already-exists",
    /**
     * The caller does not have permission to execute the specified operation.
     * PERMISSION_DENIED must not be used for rejections caused by exhausting
     * some resource (use RESOURCE_EXHAUSTED instead for those errors).
     * PERMISSION_DENIED must not be used if the caller can not be identified
     * (use UNAUTHENTICATED instead for those errors).
     */
    PERMISSION_DENIED: "permission-denied",
    /**
     * The request does not have valid authentication credentials for the
     * operation.
     */
    UNAUTHENTICATED: "unauthenticated",
    /**
     * Some resource has been exhausted, perhaps a per-user quota, or perhaps the
     * entire file system is out of space.
     */
    RESOURCE_EXHAUSTED: "resource-exhausted",
    /**
     * Operation was rejected because the system is not in a state required for
     * the operation's execution. For example, directory to be deleted may be
     * non-empty, an rmdir operation is applied to a non-directory, etc.
     *
     * A litmus test that may help a service implementor in deciding
     * between FAILED_PRECONDITION, ABORTED, and UNAVAILABLE:
     *  (a) Use UNAVAILABLE if the client can retry just the failing call.
     *  (b) Use ABORTED if the client should retry at a higher-level
     *      (e.g., restarting a read-modify-write sequence).
     *  (c) Use FAILED_PRECONDITION if the client should not retry until
     *      the system state has been explicitly fixed. E.g., if an "rmdir"
     *      fails because the directory is non-empty, FAILED_PRECONDITION
     *      should be returned since the client should not retry unless
     *      they have first fixed up the directory by deleting files from it.
     *  (d) Use FAILED_PRECONDITION if the client performs conditional
     *      REST Get/Update/Delete on a resource and the resource on the
     *      server does not match the condition. E.g., conflicting
     *      read-modify-write on the same resource.
     */
    FAILED_PRECONDITION: "failed-precondition",
    /**
     * The operation was aborted, typically due to a concurrency issue like
     * sequencer check failures, transaction aborts, etc.
     *
     * See litmus test above for deciding between FAILED_PRECONDITION, ABORTED,
     * and UNAVAILABLE.
     */
    ABORTED: "aborted",
    /**
     * Operation was attempted past the valid range. E.g., seeking or reading
     * past end of file.
     *
     * Unlike INVALID_ARGUMENT, this error indicates a problem that may be fixed
     * if the system state changes. For example, a 32-bit file system will
     * generate INVALID_ARGUMENT if asked to read at an offset that is not in the
     * range [0,2^32-1], but it will generate OUT_OF_RANGE if asked to read from
     * an offset past the current file size.
     *
     * There is a fair bit of overlap between FAILED_PRECONDITION and
     * OUT_OF_RANGE. We recommend using OUT_OF_RANGE (the more specific error)
     * when it applies so that callers who are iterating through a space can
     * easily look for an OUT_OF_RANGE error to detect when they are done.
     */
    OUT_OF_RANGE: "out-of-range",
    /** Operation is not implemented or not supported/enabled in this service. */
    UNIMPLEMENTED: "unimplemented",
    /**
     * Internal errors. Means some invariants expected by underlying System has
     * been broken. If you see one of these errors, Something is very broken.
     */
    INTERNAL: "internal",
    /**
     * The service is currently unavailable. This is a most likely a transient
     * condition and may be corrected by retrying with a backoff.
     *
     * See litmus test above for deciding between FAILED_PRECONDITION, ABORTED,
     * and UNAVAILABLE.
     */
    UNAVAILABLE: "unavailable",
    /** Unrecoverable data loss or corruption. */
    DATA_LOSS: "data-loss"
}, c = /** @class */ function(e) {
    function n(t, n) {
        var r = this;
        return (r = e.call(this, n) || this).code = t, r.message = n, r.name = "FirebaseError", 
        // HACK: We write a toString property directly because Error is not a real
        // class and so inheritance does not work correctly. We could alternatively
        // do the same "back-door inheritance" trick that FirebaseError does.
        r.toString = function() {
            return r.name + ": [code=" + r.code + "]: " + r.message;
        }, r;
    }
    return t.__extends(n, e), n;
}(Error), h = new n.Logger("@firebase/firestore");

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** Converts a Base64 encoded string to a binary string. */
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Helper methods are needed because variables can't be exported as read/write
function f() {
    return h.logLevel;
}

/**
 * Sets the verbosity of Cloud Firestore logs (debug, error, or silent).
 *
 * @param logLevel
 *   The verbosity you set for activity and error logging. Can be any of
 *   the following values:
 *
 *   <ul>
 *     <li>`debug` for the most verbose logging level, primarily for
 *     debugging.</li>
 *     <li>`error` to log errors only.</li>
 *     <li><code>`silent` to turn off logging.</li>
 *   </ul>
 */ function l(e) {
    for (var r = [], i = 1; i < arguments.length; i++) r[i - 1] = arguments[i];
    if (h.logLevel <= n.LogLevel.DEBUG) {
        var o = r.map(v);
        h.debug.apply(h, t.__spreadArrays([ "Firestore (7.24.0): " + e ], o));
    }
}

function p(e) {
    for (var r = [], i = 1; i < arguments.length; i++) r[i - 1] = arguments[i];
    if (h.logLevel <= n.LogLevel.ERROR) {
        var o = r.map(v);
        h.error.apply(h, t.__spreadArrays([ "Firestore (7.24.0): " + e ], o));
    }
}

function d(e) {
    for (var r = [], i = 1; i < arguments.length; i++) r[i - 1] = arguments[i];
    if (h.logLevel <= n.LogLevel.WARN) {
        var o = r.map(v);
        h.warn.apply(h, t.__spreadArrays([ "Firestore (7.24.0): " + e ], o));
    }
}

/**
 * Converts an additional log parameter to a string representation.
 */ function v(t) {
    if ("string" == typeof t) return t;
    try {
        return e = t, JSON.stringify(e);
    } catch (e) {
        // Converting to JSON failed, just log the object directly
        return t;
    }
    /**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
    /** Formats an object as a JSON string, suitable for logging. */    var e;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Unconditionally fails, throwing an Error with the given message.
 * Messages are stripped in production builds.
 *
 * Returns `never` and can be used in expressions:
 * @example
 * let futureVar = fail('not implemented yet');
 */ function y(t) {
    void 0 === t && (t = "Unexpected state");
    // Log the failure in addition to throw an exception, just in case the
    // exception is swallowed.
        var e = "FIRESTORE (7.24.0) INTERNAL ASSERTION FAILED: " + t;
    // NOTE: We don't use FirestoreError here because these are internal failures
    // that cannot be handled by the user. (Also it would create a circular
    // dependency between the error and assert modules which doesn't work.)
        throw p(e), new Error(e)
    /**
 * Fails if the given assertion condition is false, throwing an Error with the
 * given message if it did.
 *
 * Messages are stripped in production builds.
 */;
}

function g(t, e) {
    t || y();
}

/**
 * Casts `obj` to `T`. In non-production builds, verifies that `obj` is an
 * instance of `T` before casting.
 */ function m(t, 
// eslint-disable-next-line @typescript-eslint/no-explicit-any
e) {
    return t;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ function w(t) {
    var e = 0;
    for (var n in t) Object.prototype.hasOwnProperty.call(t, n) && e++;
    return e;
}

function b(t, e) {
    for (var n in t) Object.prototype.hasOwnProperty.call(t, n) && e(n, t[n]);
}

function E(t) {
    for (var e in t) if (Object.prototype.hasOwnProperty.call(t, e)) return !1;
    return !0;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Path represents an ordered sequence of string segments.
 */ var _ = /** @class */ function() {
    function t(t, e, n) {
        void 0 === e ? e = 0 : e > t.length && y(), void 0 === n ? n = t.length - e : n > t.length - e && y(), 
        this.segments = t, this.offset = e, this.t = n;
    }
    return Object.defineProperty(t.prototype, "length", {
        get: function() {
            return this.t;
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.isEqual = function(e) {
        return 0 === t.i(this, e);
    }, t.prototype.child = function(e) {
        var n = this.segments.slice(this.offset, this.limit());
        return e instanceof t ? e.forEach((function(t) {
            n.push(t);
        })) : n.push(e), this.o(n);
    }, 
    /** The index of one past the last segment of the path. */ t.prototype.limit = function() {
        return this.offset + this.length;
    }, t.prototype.u = function(t) {
        return t = void 0 === t ? 1 : t, this.o(this.segments, this.offset + t, this.length - t);
    }, t.prototype.h = function() {
        return this.o(this.segments, this.offset, this.length - 1);
    }, t.prototype.l = function() {
        return this.segments[this.offset];
    }, t.prototype._ = function() {
        return this.get(this.length - 1);
    }, t.prototype.get = function(t) {
        return this.segments[this.offset + t];
    }, t.prototype.m = function() {
        return 0 === this.length;
    }, t.prototype.T = function(t) {
        if (t.length < this.length) return !1;
        for (var e = 0; e < this.length; e++) if (this.get(e) !== t.get(e)) return !1;
        return !0;
    }, t.prototype.I = function(t) {
        if (this.length + 1 !== t.length) return !1;
        for (var e = 0; e < this.length; e++) if (this.get(e) !== t.get(e)) return !1;
        return !0;
    }, t.prototype.forEach = function(t) {
        for (var e = this.offset, n = this.limit(); e < n; e++) t(this.segments[e]);
    }, t.prototype.A = function() {
        return this.segments.slice(this.offset, this.limit());
    }, t.i = function(t, e) {
        for (var n = Math.min(t.length, e.length), r = 0; r < n; r++) {
            var i = t.get(r), o = e.get(r);
            if (i < o) return -1;
            if (i > o) return 1;
        }
        return t.length < e.length ? -1 : t.length > e.length ? 1 : 0;
    }, t;
}(), I = /** @class */ function(e) {
    function n() {
        return null !== e && e.apply(this, arguments) || this;
    }
    return t.__extends(n, e), n.prototype.o = function(t, e, r) {
        return new n(t, e, r);
    }, n.prototype.R = function() {
        // NOTE: The client is ignorant of any path segments containing escape
        // sequences (e.g. __id123__) and just passes them through raw (they exist
        // for legacy reasons and should not be used frequently).
        return this.A().join("/");
    }, n.prototype.toString = function() {
        return this.R();
    }, 
    /**
     * Creates a resource path from the given slash-delimited string. If multiple
     * arguments are provided, all components are combined. Leading and trailing
     * slashes from all components are ignored.
     */
    n.P = function() {
        for (var t = [], e = 0; e < arguments.length; e++) t[e] = arguments[e];
        // NOTE: The client is ignorant of any path segments containing escape
        // sequences (e.g. __id123__) and just passes them through raw (they exist
        // for legacy reasons and should not be used frequently).
                for (var r = [], i = 0, o = t; i < o.length; i++) {
            var s = o[i];
            if (s.indexOf("//") >= 0) throw new c(a.INVALID_ARGUMENT, "Invalid segment (" + s + "). Paths must not contain // in them.");
            // Strip leading and traling slashed.
                        r.push.apply(r, s.split("/").filter((function(t) {
                return t.length > 0;
            })));
        }
        return new n(r);
    }, n.g = function() {
        return new n([]);
    }, n;
}(_), A = /^[_a-zA-Z][_a-zA-Z0-9]*$/, N = /** @class */ function(e) {
    function n() {
        return null !== e && e.apply(this, arguments) || this;
    }
    return t.__extends(n, e), n.prototype.o = function(t, e, r) {
        return new n(t, e, r);
    }, 
    /**
     * Returns true if the string could be used as a segment in a field path
     * without escaping.
     */
    n.p = function(t) {
        return A.test(t);
    }, n.prototype.R = function() {
        return this.A().map((function(t) {
            return t = t.replace("\\", "\\\\").replace("`", "\\`"), n.p(t) || (t = "`" + t + "`"), 
            t;
        })).join(".");
    }, n.prototype.toString = function() {
        return this.R();
    }, 
    /**
     * Returns true if this field references the key of a document.
     */
    n.prototype.V = function() {
        return 1 === this.length && "__name__" === this.get(0);
    }, 
    /**
     * The field designating the key of a document.
     */
    n.v = function() {
        return new n([ "__name__" ]);
    }, 
    /**
     * Parses a field string from the given server-formatted string.
     *
     * - Splitting the empty string is not allowed (for now at least).
     * - Empty segments within the string (e.g. if there are two consecutive
     *   separators) are not allowed.
     *
     * TODO(b/37244157): we should make this more strict. Right now, it allows
     * non-identifier path components, even if they aren't escaped.
     */
    n.S = function(t) {
        for (var e = [], r = "", i = 0, o = function() {
            if (0 === r.length) throw new c(a.INVALID_ARGUMENT, "Invalid field path (" + t + "). Paths must not be empty, begin with '.', end with '.', or contain '..'");
            e.push(r), r = "";
        }, s = !1; i < t.length; ) {
            var u = t[i];
            if ("\\" === u) {
                if (i + 1 === t.length) throw new c(a.INVALID_ARGUMENT, "Path has trailing escape character: " + t);
                var h = t[i + 1];
                if ("\\" !== h && "." !== h && "`" !== h) throw new c(a.INVALID_ARGUMENT, "Path has invalid escape sequence: " + t);
                r += h, i += 2;
            } else "`" === u ? (s = !s, i++) : "." !== u || s ? (r += u, i++) : (o(), i++);
        }
        if (o(), s) throw new c(a.INVALID_ARGUMENT, "Unterminated ` in path: " + t);
        return new n(e);
    }, n.g = function() {
        return new n([]);
    }, n;
}(_), T = /** @class */ function() {
    function t(t) {
        this.path = t;
    }
    return t.D = function(e) {
        return new t(I.P(e));
    }, t.C = function(e) {
        return new t(I.P(e).u(5));
    }, 
    /** Returns true if the document is in the specified collectionId. */ t.prototype.F = function(t) {
        return this.path.length >= 2 && this.path.get(this.path.length - 2) === t;
    }, t.prototype.isEqual = function(t) {
        return null !== t && 0 === I.i(this.path, t.path);
    }, t.prototype.toString = function() {
        return this.path.toString();
    }, t.i = function(t, e) {
        return I.i(t.path, e.path);
    }, t.N = function(t) {
        return t.length % 2 == 0;
    }, 
    /**
     * Creates and returns a new document key with the given segments.
     *
     * @param segments The segments of the path to the document
     * @return A new instance of DocumentKey
     */
    t.$ = function(e) {
        return new t(new I(e.slice()));
    }, t;
}();

/**
 * A slash-separated path for navigating resources (documents and collections)
 * within Firestore.
 */
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Validates that no arguments were passed in the invocation of functionName.
 *
 * Forward the magic "arguments" variable as second parameter on which the
 * parameter validation is performed:
 * validateNoArgs('myFunction', arguments);
 */
function D(t, e) {
    if (0 !== e.length) throw new c(a.INVALID_ARGUMENT, "Function " + t + "() does not support arguments, but was called with " + W(e.length, "argument") + ".");
}

/**
 * Validates the invocation of functionName has the exact number of arguments.
 *
 * Forward the magic "arguments" variable as second parameter on which the
 * parameter validation is performed:
 * validateExactNumberOfArgs('myFunction', arguments, 2);
 */ function V(t, e, n) {
    if (e.length !== n) throw new c(a.INVALID_ARGUMENT, "Function " + t + "() requires " + W(n, "argument") + ", but was called with " + W(e.length, "argument") + ".");
}

/**
 * Validates the invocation of functionName has at least the provided number of
 * arguments (but can have many more).
 *
 * Forward the magic "arguments" variable as second parameter on which the
 * parameter validation is performed:
 * validateAtLeastNumberOfArgs('myFunction', arguments, 2);
 */ function R(t, e, n) {
    if (e.length < n) throw new c(a.INVALID_ARGUMENT, "Function " + t + "() requires at least " + W(n, "argument") + ", but was called with " + W(e.length, "argument") + ".");
}

/**
 * Validates the invocation of functionName has number of arguments between
 * the values provided.
 *
 * Forward the magic "arguments" variable as second parameter on which the
 * parameter validation is performed:
 * validateBetweenNumberOfArgs('myFunction', arguments, 2, 3);
 */ function L(t, e, n, r) {
    if (e.length < n || e.length > r) throw new c(a.INVALID_ARGUMENT, "Function " + t + "() requires between " + n + " and " + r + " arguments, but was called with " + W(e.length, "argument") + ".");
}

/**
 * Validates the provided argument is an array and has as least the expected
 * number of elements.
 */
/**
 * Validates the provided positional argument has the native JavaScript type
 * using typeof checks.
 */ function U(t, e, n, r) {
    C(t, e, z(n) + " argument", r);
}

/**
 * Validates the provided argument has the native JavaScript type using
 * typeof checks or is undefined.
 */ function O(t, e, n, r) {
    void 0 !== r && U(t, e, n, r);
}

/**
 * Validates the provided named option has the native JavaScript type using
 * typeof checks.
 */ function S(t, e, n, r) {
    C(t, e, n + " option", r);
}

/**
 * Validates the provided named option has the native JavaScript type using
 * typeof checks or is undefined.
 */ function k(t, e, n, r) {
    void 0 !== r && S(t, e, n, r);
}

/**
 * Validates that two boolean options are not set at the same time.
 */
/**
 * Validates that the provided named option equals one of the expected values.
 */
/**
 * Validates that the provided named option equals one of the expected values or
 * is undefined.
 */
function j(t, e, n, r, i) {
    void 0 !== r && function(t, e, n, r, i) {
        for (var o = [], s = 0, u = i; s < u.length; s++) {
            var h = u[s];
            if (h === r) return;
            o.push(x(h));
        }
        var f = x(r);
        throw new c(a.INVALID_ARGUMENT, "Invalid value " + f + " provided to function " + t + '() for option "' + n + '". Acceptable values: ' + o.join(", "));
    }(t, 0, n, r, i);
}

/**
 * Validates that the provided argument is a valid enum.
 *
 * @param functionName Function making the validation call.
 * @param enums Array containing all possible values for the enum.
 * @param position Position of the argument in `functionName`.
 * @param argument Argument to validate.
 * @return The value as T if the argument can be converted.
 */ function P(t, e, n, r) {
    if (!e.some((function(t) {
        return t === r;
    }))) throw new c(a.INVALID_ARGUMENT, "Invalid value " + x(r) + " provided to function " + t + "() for its " + z(n) + " argument. Acceptable values: " + e.join(", "));
    return r;
}

/** Helper to validate the type of a provided input. */ function C(t, e, n, r) {
    if (!("object" === e ? M(r) : "non-empty string" === e ? "string" == typeof r && "" !== r : typeof r === e)) {
        var i = x(r);
        throw new c(a.INVALID_ARGUMENT, "Function " + t + "() requires its " + n + " to be of type " + e + ", but it was: " + i);
    }
}

/**
 * Returns true if it's a non-null object without a custom prototype
 * (i.e. excludes Array, Date, etc.).
 */ function M(t) {
    return "object" == typeof t && null !== t && (Object.getPrototypeOf(t) === Object.prototype || null === Object.getPrototypeOf(t));
}

/** Returns a string describing the type / value of the provided input. */ function x(t) {
    if (void 0 === t) return "undefined";
    if (null === t) return "null";
    if ("string" == typeof t) return t.length > 20 && (t = t.substring(0, 20) + "..."), 
    JSON.stringify(t);
    if ("number" == typeof t || "boolean" == typeof t) return "" + t;
    if ("object" == typeof t) {
        if (t instanceof Array) return "an array";
        var e = 
        /** Hacky method to try to get the constructor name for an object. */
        function(t) {
            if (t.constructor) {
                var e = /function\s+([^\s(]+)\s*\(/.exec(t.constructor.toString());
                if (e && e.length > 1) return e[1];
            }
            return null;
        }(t);
        return e ? "a custom " + e + " object" : "an object";
    }
    return "function" == typeof t ? "a function" : y();
}

function q(t, e, n) {
    if (void 0 === n) throw new c(a.INVALID_ARGUMENT, "Function " + t + "() requires a valid " + z(e) + " argument, but it was undefined.");
}

/**
 * Validates the provided positional argument is an object, and its keys and
 * values match the expected keys and types provided in optionTypes.
 */ function F(t, e, n) {
    b(e, (function(e, r) {
        if (n.indexOf(e) < 0) throw new c(a.INVALID_ARGUMENT, "Unknown option '" + e + "' passed to function " + t + "(). Available options: " + n.join(", "));
    }));
}

/**
 * Helper method to throw an error that the provided argument did not pass
 * an instanceof check.
 */ function B(t, e, n, r) {
    var i = x(r);
    return new c(a.INVALID_ARGUMENT, "Function " + t + "() requires its " + z(n) + " argument to be a " + e + ", but it was: " + i);
}

function G(t, e, n) {
    if (n <= 0) throw new c(a.INVALID_ARGUMENT, "Function " + t + "() requires its " + z(e) + " argument to be a positive number, but it was: " + n + ".");
}

/** Converts a number to its english word representation */ function z(t) {
    switch (t) {
      case 1:
        return "first";

      case 2:
        return "second";

      case 3:
        return "third";

      default:
        return t + "th";
    }
}

/**
 * Formats the given word as plural conditionally given the preceding number.
 */ function W(t, e) {
    return t + " " + e + (1 === t ? "" : "s");
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Generates `nBytes` of random bytes.
 *
 * If `nBytes < 0` , an error will be thrown.
 */ function Q(t) {
    // Polyfills for IE and WebWorker by using `self` and `msCrypto` when `crypto` is not available.
    var e = 
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    "undefined" != typeof self && (self.crypto || self.msCrypto), n = new Uint8Array(t);
    if (e && "function" == typeof e.getRandomValues) e.getRandomValues(n); else 
    // Falls back to Math.random
    for (var r = 0; r < t; r++) n[r] = Math.floor(256 * Math.random());
    return n;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ var K = /** @class */ function() {
    function t() {}
    return t.k = function() {
        for (
        // Alphanumeric characters
        var t = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", e = Math.floor(256 / t.length) * t.length, n = ""
        // The largest byte value that is a multiple of `char.length`.
        ; n.length < 20; ) for (var r = Q(40), i = 0; i < r.length; ++i) 
        // Only accept values that are [0, maxMultiple), this ensures they can
        // be evenly mapped to indices of `chars` via a modulo operation.
        n.length < 20 && r[i] < e && (n += t.charAt(r[i] % t.length));
        return n;
    }, t;
}();

function X(t, e) {
    return t < e ? -1 : t > e ? 1 : 0;
}

/** Helper to compare arrays using isEqual(). */ function H(t, e, n) {
    return t.length === e.length && t.every((function(t, r) {
        return n(t, e[r]);
    }));
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Immutable class that represents a "proto" byte string.
 *
 * Proto byte strings can either be Base64-encoded strings or Uint8Arrays when
 * sent on the wire. This class abstracts away this differentiation by holding
 * the proto byte string in a common class that must be converted into a string
 * before being sent as a proto.
 */ var Y = /** @class */ function() {
    function t(t) {
        this.O = t;
    }
    return t.fromBase64String = function(e) {
        return new t(atob(e));
    }, t.fromUint8Array = function(e) {
        return new t(
        /**
 * Helper function to convert an Uint8array to a binary string.
 */
        function(t) {
            for (var e = "", n = 0; n < t.length; ++n) e += String.fromCharCode(t[n]);
            return e;
        }(e));
    }, t.prototype.toBase64 = function() {
        return t = this.O, btoa(t);
        /** Converts a binary string to a Base64 encoded string. */        var t;
        /** True if and only if the Base64 conversion functions are available. */    }, 
    t.prototype.toUint8Array = function() {
        return function(t) {
            for (var e = new Uint8Array(t.length), n = 0; n < t.length; n++) e[n] = t.charCodeAt(n);
            return e;
        }(this.O);
    }, t.prototype.L = function() {
        return 2 * this.O.length;
    }, t.prototype.M = function(t) {
        return X(this.O, t.O);
    }, t.prototype.isEqual = function(t) {
        return this.O === t.O;
    }, t;
}();

Y.q = new Y("");

var J = /** @class */ function() {
    function t(t) {
        this.U = t;
    }
    /**
     * Creates a new `Bytes` object from the given Base64 string, converting it to
     * bytes.
     *
     * @param base64 The Base64 string used to create the `Bytes` object.
     */    return t.fromBase64String = function(e) {
        try {
            return new t(Y.fromBase64String(e));
        } catch (e) {
            throw new c(a.INVALID_ARGUMENT, "Failed to construct Bytes from Base64 string: " + e);
        }
    }, 
    /**
     * Creates a new `Bytes` object from the given Uint8Array.
     *
     * @param array The Uint8Array used to create the `Bytes` object.
     */
    t.fromUint8Array = function(e) {
        return new t(Y.fromUint8Array(e));
    }, 
    /**
     * Returns the underlying bytes as a Base64-encoded string.
     *
     * @return The Base64-encoded string created from the `Bytes` object.
     */
    t.prototype.toBase64 = function() {
        return this.U.toBase64();
    }, 
    /**
     * Returns the underlying bytes in a new `Uint8Array`.
     *
     * @return The Uint8Array created from the `Bytes` object.
     */
    t.prototype.toUint8Array = function() {
        return this.U.toUint8Array();
    }, 
    /**
     * Returns a string representation of the `Bytes` object.
     *
     * @return A string representation of the `Bytes` object.
     */
    t.prototype.toString = function() {
        return "Bytes(base64: " + this.toBase64() + ")";
    }, 
    /**
     * Returns true if this `Bytes` object is equal to the provided one.
     *
     * @param other The `Bytes` object to compare against.
     * @return true if this `Bytes` object is equal to the provided one.
     */
    t.prototype.isEqual = function(t) {
        return this.U.isEqual(t.U);
    }, t;
}();

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** Helper function to assert Uint8Array is available at runtime. */ function $() {
    if ("undefined" == typeof Uint8Array) throw new c(a.UNIMPLEMENTED, "Uint8Arrays are not available in this environment.");
}

/** Helper function to assert Base64 functions are available at runtime. */ function Z() {
    if ("undefined" == typeof atob) throw new c(a.UNIMPLEMENTED, "Blobs are unavailable in Firestore in this environment.");
}

/**
 * Immutable class holding a blob (binary data).
 *
 * This class is directly exposed in the public API. It extends the Bytes class
 * of the firestore-exp API to support `instanceof Bytes` checks during user
 * data conversion.
 *
 * Note that while you can't hide the constructor in JavaScript code, we are
 * using the hack above to make sure no-one outside this module can call it.
 */ var tt = /** @class */ function(e) {
    function n() {
        return null !== e && e.apply(this, arguments) || this;
    }
    return t.__extends(n, e), n.fromBase64String = function(t) {
        V("Blob.fromBase64String", arguments, 1), U("Blob.fromBase64String", "string", 1, t), 
        Z();
        try {
            return new n(Y.fromBase64String(t));
        } catch (t) {
            throw new c(a.INVALID_ARGUMENT, "Failed to construct Blob from Base64 string: " + t);
        }
    }, n.fromUint8Array = function(t) {
        if (V("Blob.fromUint8Array", arguments, 1), $(), !(t instanceof Uint8Array)) throw B("Blob.fromUint8Array", "Uint8Array", 1, t);
        return new n(Y.fromUint8Array(t));
    }, n.prototype.toBase64 = function() {
        return V("Blob.toBase64", arguments, 0), Z(), e.prototype.toBase64.call(this);
    }, n.prototype.toUint8Array = function() {
        return V("Blob.toUint8Array", arguments, 0), $(), e.prototype.toUint8Array.call(this);
    }, n.prototype.toString = function() {
        return "Blob(base64: " + this.toBase64() + ")";
    }, n;
}(J), et = 
/**
     * Constructs a DatabaseInfo using the provided host, databaseId and
     * persistenceKey.
     *
     * @param databaseId The database to use.
     * @param persistenceKey A unique identifier for this Firestore's local
     * storage (used in conjunction with the databaseId).
     * @param host The Firestore backend host to connect to.
     * @param ssl Whether to use SSL when connecting.
     * @param forceLongPolling Whether to use the forceLongPolling option
     * when using WebChannel as the network transport.
     * @param autoDetectLongPolling Whether to use the detectBufferingProxy
     * option when using WebChannel as the network transport.
     */
function(t, e, n, r, i, o) {
    this.B = t, this.persistenceKey = e, this.host = n, this.ssl = r, this.forceLongPolling = i, 
    this.j = o;
}, nt = /** @class */ function() {
    function t(t, e) {
        this.projectId = t, this.database = e || "(default)";
    }
    return Object.defineProperty(t.prototype, "W", {
        get: function() {
            return "(default)" === this.database;
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.isEqual = function(e) {
        return e instanceof t && e.projectId === this.projectId && e.database === this.database;
    }, t.prototype.M = function(t) {
        return X(this.projectId, t.projectId) || X(this.database, t.database);
    }, t;
}(), rt = /** @class */ function() {
    function t(t, e) {
        this.G = t, this.K = e, 
        /**
             * The inner map for a key -> value pair. Due to the possibility of
             * collisions we keep a list of entries that we do a linear search through
             * to find an actual match. Note that collisions should be rare, so we still
             * expect near constant time lookups in practice.
             */
        this.H = {}
        /** Get a value for this key, or undefined if it does not exist. */;
    }
    return t.prototype.get = function(t) {
        var e = this.G(t), n = this.H[e];
        if (void 0 !== n) for (var r = 0, i = n; r < i.length; r++) {
            var o = i[r], s = o[0], u = o[1];
            if (this.K(s, t)) return u;
        }
    }, t.prototype.has = function(t) {
        return void 0 !== this.get(t);
    }, 
    /** Put this key and value in the map. */ t.prototype.set = function(t, e) {
        var n = this.G(t), r = this.H[n];
        if (void 0 !== r) {
            for (var i = 0; i < r.length; i++) if (this.K(r[i][0], t)) return void (r[i] = [ t, e ]);
            r.push([ t, e ]);
        } else this.H[n] = [ [ t, e ] ];
    }, 
    /**
     * Remove this key from the map. Returns a boolean if anything was deleted.
     */
    t.prototype.delete = function(t) {
        var e = this.G(t), n = this.H[e];
        if (void 0 === n) return !1;
        for (var r = 0; r < n.length; r++) if (this.K(n[r][0], t)) return 1 === n.length ? delete this.H[e] : n.splice(r, 1), 
        !0;
        return !1;
    }, t.prototype.forEach = function(t) {
        b(this.H, (function(e, n) {
            for (var r = 0, i = n; r < i.length; r++) {
                var o = i[r], s = o[0], u = o[1];
                t(s, u);
            }
        }));
    }, t.prototype.m = function() {
        return E(this.H);
    }, t;
}(), it = /** @class */ function() {
    /**
     * Creates a new timestamp.
     *
     * @param seconds The number of seconds of UTC time since Unix epoch
     *     1970-01-01T00:00:00Z. Must be from 0001-01-01T00:00:00Z to
     *     9999-12-31T23:59:59Z inclusive.
     * @param nanoseconds The non-negative fractions of a second at nanosecond
     *     resolution. Negative second values with fractions must still have
     *     non-negative nanoseconds values that count forward in time. Must be
     *     from 0 to 999,999,999 inclusive.
     */
    function t(t, e) {
        if (this.seconds = t, this.nanoseconds = e, e < 0) throw new c(a.INVALID_ARGUMENT, "Timestamp nanoseconds out of range: " + e);
        if (e >= 1e9) throw new c(a.INVALID_ARGUMENT, "Timestamp nanoseconds out of range: " + e);
        if (t < -62135596800) throw new c(a.INVALID_ARGUMENT, "Timestamp seconds out of range: " + t);
        // This will break in the year 10,000.
                if (t >= 253402300800) throw new c(a.INVALID_ARGUMENT, "Timestamp seconds out of range: " + t);
    }
    /**
     * Creates a new timestamp with the current date, with millisecond precision.
     *
     * @return a new timestamp representing the current date.
     */    return t.now = function() {
        return t.fromMillis(Date.now());
    }, 
    /**
     * Creates a new timestamp from the given date.
     *
     * @param date The date to initialize the `Timestamp` from.
     * @return A new `Timestamp` representing the same point in time as the given
     *     date.
     */
    t.fromDate = function(e) {
        return t.fromMillis(e.getTime());
    }, 
    /**
     * Creates a new timestamp from the given number of milliseconds.
     *
     * @param milliseconds Number of milliseconds since Unix epoch
     *     1970-01-01T00:00:00Z.
     * @return A new `Timestamp` representing the same point in time as the given
     *     number of milliseconds.
     */
    t.fromMillis = function(e) {
        var n = Math.floor(e / 1e3);
        return new t(n, 1e6 * (e - 1e3 * n));
    }, 
    /**
     * Converts a `Timestamp` to a JavaScript `Date` object. This conversion causes
     * a loss of precision since `Date` objects only support millisecond precision.
     *
     * @return JavaScript `Date` object representing the same point in time as
     *     this `Timestamp`, with millisecond precision.
     */
    t.prototype.toDate = function() {
        return new Date(this.toMillis());
    }, 
    /**
     * Converts a `Timestamp` to a numeric timestamp (in milliseconds since
     * epoch). This operation causes a loss of precision.
     *
     * @return The point in time corresponding to this timestamp, represented as
     *     the number of milliseconds since Unix epoch 1970-01-01T00:00:00Z.
     */
    t.prototype.toMillis = function() {
        return 1e3 * this.seconds + this.nanoseconds / 1e6;
    }, t.prototype.Y = function(t) {
        return this.seconds === t.seconds ? X(this.nanoseconds, t.nanoseconds) : X(this.seconds, t.seconds);
    }, 
    /**
     * Returns true if this `Timestamp` is equal to the provided one.
     *
     * @param other The `Timestamp` to compare against.
     * @return true if this `Timestamp` is equal to the provided one.
     */
    t.prototype.isEqual = function(t) {
        return t.seconds === this.seconds && t.nanoseconds === this.nanoseconds;
    }, t.prototype.toString = function() {
        return "Timestamp(seconds=" + this.seconds + ", nanoseconds=" + this.nanoseconds + ")";
    }, t.prototype.toJSON = function() {
        return {
            seconds: this.seconds,
            nanoseconds: this.nanoseconds
        };
    }, 
    /**
     * Converts this object to a primitive string, which allows Timestamp objects to be compared
     * using the `>`, `<=`, `>=` and `>` operators.
     */
    t.prototype.valueOf = function() {
        // This method returns a string of the form <seconds>.<nanoseconds> where <seconds> is
        // translated to have a non-negative value and both <seconds> and <nanoseconds> are left-padded
        // with zeroes to be a consistent length. Strings with this format then have a lexiographical
        // ordering that matches the expected ordering. The <seconds> translation is done to avoid
        // having a leading negative sign (i.e. a leading '-' character) in its string representation,
        // which would affect its lexiographical ordering.
        var t = this.seconds - -62135596800;
        // Note: Up to 12 decimal digits are required to represent all valid 'seconds' values.
                return String(t).padStart(12, "0") + "." + String(this.nanoseconds).padStart(9, "0");
    }, t;
}(), ot = /** @class */ function() {
    function t(t) {
        this.timestamp = t;
    }
    return t.J = function(e) {
        return new t(e);
    }, t.min = function() {
        return new t(new it(0, 0));
    }, t.prototype.M = function(t) {
        return this.timestamp.Y(t.timestamp);
    }, t.prototype.isEqual = function(t) {
        return this.timestamp.isEqual(t.timestamp);
    }, 
    /** Returns a number representation of the version for use in spec tests. */ t.prototype.X = function() {
        // Convert to microseconds.
        return 1e6 * this.timestamp.seconds + this.timestamp.nanoseconds / 1e3;
    }, t.prototype.toString = function() {
        return "SnapshotVersion(" + this.timestamp.toString() + ")";
    }, t.prototype.Z = function() {
        return this.timestamp;
    }, t;
}();

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Returns whether a variable is either undefined or null.
 */
function st(t) {
    return null == t;
}

/** Returns whether the value represents -0. */ function ut(t) {
    // Detect if the value is -0.0. Based on polyfill from
    // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/is
    return 0 === t && 1 / t == -1 / 0;
}

/**
 * Returns whether a value is an integer and in the safe integer range
 * @param value The value to test for being an integer and in the safe range
 */
/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Visible for testing
var at = function(t, e, n, r, i, o, s) {
    void 0 === e && (e = null), void 0 === n && (n = []), void 0 === r && (r = []), 
    void 0 === i && (i = null), void 0 === o && (o = null), void 0 === s && (s = null), 
    this.path = t, this.collectionGroup = e, this.orderBy = n, this.filters = r, this.limit = i, 
    this.startAt = o, this.endAt = s, this.tt = null;
};

/**
 * Initializes a Target with a path and optional additional query constraints.
 * Path must currently be empty if this is a collection group query.
 *
 * NOTE: you should always construct `Target` from `Query.toTarget` instead of
 * using this factory method, because `Query` provides an implicit `orderBy`
 * property.
 */ function ct(t, e, n, r, i, o, s) {
    return void 0 === e && (e = null), void 0 === n && (n = []), void 0 === r && (r = []), 
    void 0 === i && (i = null), void 0 === o && (o = null), void 0 === s && (s = null), 
    new at(t, e, n, r, i, o, s);
}

function ht(t) {
    var e = m(t);
    if (null === e.tt) {
        var n = e.path.R();
        null !== e.collectionGroup && (n += "|cg:" + e.collectionGroup), n += "|f:", n += e.filters.map((function(t) {
            return function(t) {
                // TODO(b/29183165): Technically, this won't be unique if two values have
                // the same description, such as the int 3 and the string "3". So we should
                // add the types in here somehow, too.
                return t.field.R() + t.op.toString() + ee(t.value);
            }(t);
        })).join(","), n += "|ob:", n += e.orderBy.map((function(t) {
            return (e = t).field.R() + e.dir;
            var e;
        })).join(","), st(e.limit) || (n += "|l:", n += e.limit), e.startAt && (n += "|lb:", 
        n += Hn(e.startAt)), e.endAt && (n += "|ub:", n += Hn(e.endAt)), e.tt = n;
    }
    return e.tt;
}

function ft(t, e) {
    if (t.limit !== e.limit) return !1;
    if (t.orderBy.length !== e.orderBy.length) return !1;
    for (var n = 0; n < t.orderBy.length; n++) if (!tr(t.orderBy[n], e.orderBy[n])) return !1;
    if (t.filters.length !== e.filters.length) return !1;
    for (var r = 0; r < t.filters.length; r++) if (i = t.filters[r], o = e.filters[r], 
    i.op !== o.op || !i.field.isEqual(o.field) || !Jt(i.value, o.value)) return !1;
    var i, o;
    return t.collectionGroup === e.collectionGroup && !!t.path.isEqual(e.path) && !!Jn(t.startAt, e.startAt) && Jn(t.endAt, e.endAt);
}

function lt(t) {
    return T.N(t.path) && null === t.collectionGroup && 0 === t.filters.length;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * An immutable set of metadata that the local store tracks for each target.
 */ var pt, dt, vt = /** @class */ function() {
    function t(
    /** The target being listened to. */
    t, 
    /**
     * The target ID to which the target corresponds; Assigned by the
     * LocalStore for user listens and by the SyncEngine for limbo watches.
     */
    e, 
    /** The purpose of the target. */
    n, 
    /**
     * The sequence number of the last transaction during which this target data
     * was modified.
     */
    r, 
    /** The latest snapshot version seen for this target. */
    i
    /**
     * The maximum snapshot version at which the associated view
     * contained no limbo documents.
     */ , o
    /**
     * An opaque, server-assigned token that allows watching a target to be
     * resumed after disconnecting without retransmitting all the data that
     * matches the target. The resume token essentially identifies a point in
     * time from which the server should resume sending results.
     */ , s) {
        void 0 === i && (i = ot.min()), void 0 === o && (o = ot.min()), void 0 === s && (s = Y.q), 
        this.target = t, this.targetId = e, this.et = n, this.sequenceNumber = r, this.nt = i, 
        this.lastLimboFreeSnapshotVersion = o, this.resumeToken = s;
    }
    /** Creates a new target data instance with an updated sequence number. */    return t.prototype.st = function(e) {
        return new t(this.target, this.targetId, this.et, e, this.nt, this.lastLimboFreeSnapshotVersion, this.resumeToken);
    }, 
    /**
     * Creates a new target data instance with an updated resume token and
     * snapshot version.
     */
    t.prototype.it = function(e, n) {
        return new t(this.target, this.targetId, this.et, this.sequenceNumber, n, this.lastLimboFreeSnapshotVersion, e);
    }, 
    /**
     * Creates a new target data instance with an updated last limbo free
     * snapshot version number.
     */
    t.prototype.rt = function(e) {
        return new t(this.target, this.targetId, this.et, this.sequenceNumber, this.nt, e, this.resumeToken);
    }, t;
}(), yt = 
// TODO(b/33078163): just use simplest form of existence filter for now
function(t) {
    this.count = t;
};

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Determines whether an error code represents a permanent error when received
 * in response to a non-write operation.
 *
 * See isPermanentWriteError for classifying write errors.
 */
function gt(t) {
    switch (t) {
      case a.OK:
        return y();

      case a.CANCELLED:
      case a.UNKNOWN:
      case a.DEADLINE_EXCEEDED:
      case a.RESOURCE_EXHAUSTED:
      case a.INTERNAL:
      case a.UNAVAILABLE:
 // Unauthenticated means something went wrong with our token and we need
        // to retry with new credentials which will happen automatically.
              case a.UNAUTHENTICATED:
        return !1;

      case a.INVALID_ARGUMENT:
      case a.NOT_FOUND:
      case a.ALREADY_EXISTS:
      case a.PERMISSION_DENIED:
      case a.FAILED_PRECONDITION:
 // Aborted might be retried in some scenarios, but that is dependant on
        // the context and should handled individually by the calling code.
        // See https://cloud.google.com/apis/design/errors.
              case a.ABORTED:
      case a.OUT_OF_RANGE:
      case a.UNIMPLEMENTED:
      case a.DATA_LOSS:
        return !0;

      default:
        return y();
    }
}

/**
 * Determines whether an error code represents a permanent error when received
 * in response to a write operation.
 *
 * Write operations must be handled specially because as of b/119437764, ABORTED
 * errors on the write stream should be retried too (even though ABORTED errors
 * are not generally retryable).
 *
 * Note that during the initial handshake on the write stream an ABORTED error
 * signals that we should discard our stream token (i.e. it is permanent). This
 * means a handshake error should be classified with isPermanentError, above.
 */
/**
 * Maps an error Code from GRPC status code number, like 0, 1, or 14. These
 * are not the same as HTTP status codes.
 *
 * @returns The Code equivalent to the given GRPC status code. Fails if there
 *     is no match.
 */ function mt(t) {
    if (void 0 === t) 
    // This shouldn't normally happen, but in certain error cases (like trying
    // to send invalid proto messages) we may get an error with no GRPC code.
    return p("GRPC error has no .code"), a.UNKNOWN;
    switch (t) {
      case pt.OK:
        return a.OK;

      case pt.CANCELLED:
        return a.CANCELLED;

      case pt.UNKNOWN:
        return a.UNKNOWN;

      case pt.DEADLINE_EXCEEDED:
        return a.DEADLINE_EXCEEDED;

      case pt.RESOURCE_EXHAUSTED:
        return a.RESOURCE_EXHAUSTED;

      case pt.INTERNAL:
        return a.INTERNAL;

      case pt.UNAVAILABLE:
        return a.UNAVAILABLE;

      case pt.UNAUTHENTICATED:
        return a.UNAUTHENTICATED;

      case pt.INVALID_ARGUMENT:
        return a.INVALID_ARGUMENT;

      case pt.NOT_FOUND:
        return a.NOT_FOUND;

      case pt.ALREADY_EXISTS:
        return a.ALREADY_EXISTS;

      case pt.PERMISSION_DENIED:
        return a.PERMISSION_DENIED;

      case pt.FAILED_PRECONDITION:
        return a.FAILED_PRECONDITION;

      case pt.ABORTED:
        return a.ABORTED;

      case pt.OUT_OF_RANGE:
        return a.OUT_OF_RANGE;

      case pt.UNIMPLEMENTED:
        return a.UNIMPLEMENTED;

      case pt.DATA_LOSS:
        return a.DATA_LOSS;

      default:
        return y();
    }
}

/**
 * Converts an HTTP response's error status to the equivalent error code.
 *
 * @param status An HTTP error response status ("FAILED_PRECONDITION",
 * "UNKNOWN", etc.)
 * @returns The equivalent Code. Non-matching responses are mapped to
 *     Code.UNKNOWN.
 */ (dt = pt || (pt = {}))[dt.OK = 0] = "OK", dt[dt.CANCELLED = 1] = "CANCELLED", 
dt[dt.UNKNOWN = 2] = "UNKNOWN", dt[dt.INVALID_ARGUMENT = 3] = "INVALID_ARGUMENT", 
dt[dt.DEADLINE_EXCEEDED = 4] = "DEADLINE_EXCEEDED", dt[dt.NOT_FOUND = 5] = "NOT_FOUND", 
dt[dt.ALREADY_EXISTS = 6] = "ALREADY_EXISTS", dt[dt.PERMISSION_DENIED = 7] = "PERMISSION_DENIED", 
dt[dt.UNAUTHENTICATED = 16] = "UNAUTHENTICATED", dt[dt.RESOURCE_EXHAUSTED = 8] = "RESOURCE_EXHAUSTED", 
dt[dt.FAILED_PRECONDITION = 9] = "FAILED_PRECONDITION", dt[dt.ABORTED = 10] = "ABORTED", 
dt[dt.OUT_OF_RANGE = 11] = "OUT_OF_RANGE", dt[dt.UNIMPLEMENTED = 12] = "UNIMPLEMENTED", 
dt[dt.INTERNAL = 13] = "INTERNAL", dt[dt.UNAVAILABLE = 14] = "UNAVAILABLE", dt[dt.DATA_LOSS = 15] = "DATA_LOSS";

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// An immutable sorted map implementation, based on a Left-leaning Red-Black
// tree.
var wt = /** @class */ function() {
    function t(t, e) {
        this.i = t, this.root = e || Et.EMPTY;
    }
    // Returns a copy of the map, with the specified key/value added or replaced.
        return t.prototype.ot = function(e, n) {
        return new t(this.i, this.root.ot(e, n, this.i).copy(null, null, Et.ut, null, null));
    }, 
    // Returns a copy of the map, with the specified key removed.
    t.prototype.remove = function(e) {
        return new t(this.i, this.root.remove(e, this.i).copy(null, null, Et.ut, null, null));
    }, 
    // Returns the value of the node with the given key, or null.
    t.prototype.get = function(t) {
        for (var e = this.root; !e.m(); ) {
            var n = this.i(t, e.key);
            if (0 === n) return e.value;
            n < 0 ? e = e.left : n > 0 && (e = e.right);
        }
        return null;
    }, 
    // Returns the index of the element in this sorted map, or -1 if it doesn't
    // exist.
    t.prototype.indexOf = function(t) {
        for (
        // Number of nodes that were pruned when descending right
        var e = 0, n = this.root; !n.m(); ) {
            var r = this.i(t, n.key);
            if (0 === r) return e + n.left.size;
            r < 0 ? n = n.left : (
            // Count all nodes left of the node plus the node itself
            e += n.left.size + 1, n = n.right);
        }
        // Node not found
                return -1;
    }, t.prototype.m = function() {
        return this.root.m();
    }, Object.defineProperty(t.prototype, "size", {
        // Returns the total number of nodes in the map.
        get: function() {
            return this.root.size;
        },
        enumerable: !1,
        configurable: !0
    }), 
    // Returns the minimum key in the map.
    t.prototype.ct = function() {
        return this.root.ct();
    }, 
    // Returns the maximum key in the map.
    t.prototype.at = function() {
        return this.root.at();
    }, 
    // Traverses the map in key order and calls the specified action function
    // for each key/value pair. If action returns true, traversal is aborted.
    // Returns the first truthy value returned by action, or the last falsey
    // value returned by action.
    t.prototype.ht = function(t) {
        return this.root.ht(t);
    }, t.prototype.forEach = function(t) {
        this.ht((function(e, n) {
            return t(e, n), !1;
        }));
    }, t.prototype.toString = function() {
        var t = [];
        return this.ht((function(e, n) {
            return t.push(e + ":" + n), !1;
        })), "{" + t.join(", ") + "}";
    }, 
    // Traverses the map in reverse key order and calls the specified action
    // function for each key/value pair. If action returns true, traversal is
    // aborted.
    // Returns the first truthy value returned by action, or the last falsey
    // value returned by action.
    t.prototype.lt = function(t) {
        return this.root.lt(t);
    }, 
    // Returns an iterator over the SortedMap.
    t.prototype._t = function() {
        return new bt(this.root, null, this.i, !1);
    }, t.prototype.ft = function(t) {
        return new bt(this.root, t, this.i, !1);
    }, t.prototype.dt = function() {
        return new bt(this.root, null, this.i, !0);
    }, t.prototype.wt = function(t) {
        return new bt(this.root, t, this.i, !0);
    }, t;
}(), bt = /** @class */ function() {
    function t(t, e, n, r) {
        this.Tt = r, this.Et = [];
        for (var i = 1; !t.m(); ) if (i = e ? n(t.key, e) : 1, 
        // flip the comparison if we're going in reverse
        r && (i *= -1), i < 0) 
        // This node is less than our start key. ignore it
        t = this.Tt ? t.left : t.right; else {
            if (0 === i) {
                // This node is exactly equal to our start key. Push it on the stack,
                // but stop iterating;
                this.Et.push(t);
                break;
            }
            // This node is greater than our start key, add it to the stack and move
            // to the next one
                        this.Et.push(t), t = this.Tt ? t.right : t.left;
        }
    }
    return t.prototype.It = function() {
        var t = this.Et.pop(), e = {
            key: t.key,
            value: t.value
        };
        if (this.Tt) for (t = t.left; !t.m(); ) this.Et.push(t), t = t.right; else for (t = t.right; !t.m(); ) this.Et.push(t), 
        t = t.left;
        return e;
    }, t.prototype.At = function() {
        return this.Et.length > 0;
    }, t.prototype.Rt = function() {
        if (0 === this.Et.length) return null;
        var t = this.Et[this.Et.length - 1];
        return {
            key: t.key,
            value: t.value
        };
    }, t;
}(), Et = /** @class */ function() {
    function t(e, n, r, i, o) {
        this.key = e, this.value = n, this.color = null != r ? r : t.RED, this.left = null != i ? i : t.EMPTY, 
        this.right = null != o ? o : t.EMPTY, this.size = this.left.size + 1 + this.right.size;
    }
    // Returns a copy of the current node, optionally replacing pieces of it.
        return t.prototype.copy = function(e, n, r, i, o) {
        return new t(null != e ? e : this.key, null != n ? n : this.value, null != r ? r : this.color, null != i ? i : this.left, null != o ? o : this.right);
    }, t.prototype.m = function() {
        return !1;
    }, 
    // Traverses the tree in key order and calls the specified action function
    // for each node. If action returns true, traversal is aborted.
    // Returns the first truthy value returned by action, or the last falsey
    // value returned by action.
    t.prototype.ht = function(t) {
        return this.left.ht(t) || t(this.key, this.value) || this.right.ht(t);
    }, 
    // Traverses the tree in reverse key order and calls the specified action
    // function for each node. If action returns true, traversal is aborted.
    // Returns the first truthy value returned by action, or the last falsey
    // value returned by action.
    t.prototype.lt = function(t) {
        return this.right.lt(t) || t(this.key, this.value) || this.left.lt(t);
    }, 
    // Returns the minimum node in the tree.
    t.prototype.min = function() {
        return this.left.m() ? this : this.left.min();
    }, 
    // Returns the maximum key in the tree.
    t.prototype.ct = function() {
        return this.min().key;
    }, 
    // Returns the maximum key in the tree.
    t.prototype.at = function() {
        return this.right.m() ? this.key : this.right.at();
    }, 
    // Returns new tree, with the key/value added.
    t.prototype.ot = function(t, e, n) {
        var r = this, i = n(t, r.key);
        return (r = i < 0 ? r.copy(null, null, null, r.left.ot(t, e, n), null) : 0 === i ? r.copy(null, e, null, null, null) : r.copy(null, null, null, null, r.right.ot(t, e, n))).yt();
    }, t.prototype.Pt = function() {
        if (this.left.m()) return t.EMPTY;
        var e = this;
        return e.left.gt() || e.left.left.gt() || (e = e.Vt()), (e = e.copy(null, null, null, e.left.Pt(), null)).yt();
    }, 
    // Returns new tree, with the specified item removed.
    t.prototype.remove = function(e, n) {
        var r, i = this;
        if (n(e, i.key) < 0) i.left.m() || i.left.gt() || i.left.left.gt() || (i = i.Vt()), 
        i = i.copy(null, null, null, i.left.remove(e, n), null); else {
            if (i.left.gt() && (i = i.vt()), i.right.m() || i.right.gt() || i.right.left.gt() || (i = i.bt()), 
            0 === n(e, i.key)) {
                if (i.right.m()) return t.EMPTY;
                r = i.right.min(), i = i.copy(r.key, r.value, null, null, i.right.Pt());
            }
            i = i.copy(null, null, null, null, i.right.remove(e, n));
        }
        return i.yt();
    }, t.prototype.gt = function() {
        return this.color;
    }, 
    // Returns new tree after performing any needed rotations.
    t.prototype.yt = function() {
        var t = this;
        return t.right.gt() && !t.left.gt() && (t = t.St()), t.left.gt() && t.left.left.gt() && (t = t.vt()), 
        t.left.gt() && t.right.gt() && (t = t.Dt()), t;
    }, t.prototype.Vt = function() {
        var t = this.Dt();
        return t.right.left.gt() && (t = (t = (t = t.copy(null, null, null, null, t.right.vt())).St()).Dt()), 
        t;
    }, t.prototype.bt = function() {
        var t = this.Dt();
        return t.left.left.gt() && (t = (t = t.vt()).Dt()), t;
    }, t.prototype.St = function() {
        var e = this.copy(null, null, t.RED, null, this.right.left);
        return this.right.copy(null, null, this.color, e, null);
    }, t.prototype.vt = function() {
        var e = this.copy(null, null, t.RED, this.left.right, null);
        return this.left.copy(null, null, this.color, null, e);
    }, t.prototype.Dt = function() {
        var t = this.left.copy(null, null, !this.left.color, null, null), e = this.right.copy(null, null, !this.right.color, null, null);
        return this.copy(null, null, !this.color, t, e);
    }, 
    // For testing.
    t.prototype.Ct = function() {
        var t = this.Ft();
        return Math.pow(2, t) <= this.size + 1;
    }, 
    // In a balanced RB tree, the black-depth (number of black nodes) from root to
    // leaves is equal on both sides.  This function verifies that or asserts.
    t.prototype.Ft = function() {
        if (this.gt() && this.left.gt()) throw y();
        if (this.right.gt()) throw y();
        var t = this.left.Ft();
        if (t !== this.right.Ft()) throw y();
        return t + (this.gt() ? 0 : 1);
    }, t;
}();

// end SortedMap
// An iterator over an LLRBNode.
// end LLRBNode
// Empty node is shared between all LLRB trees.
// eslint-disable-next-line @typescript-eslint/no-explicit-any
Et.EMPTY = null, Et.RED = !0, Et.ut = !1, 
// end LLRBEmptyNode
Et.EMPTY = new (/** @class */ function() {
    function t() {
        this.size = 0;
    }
    return Object.defineProperty(t.prototype, "key", {
        get: function() {
            throw y();
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "value", {
        get: function() {
            throw y();
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "color", {
        get: function() {
            throw y();
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "left", {
        get: function() {
            throw y();
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "right", {
        get: function() {
            throw y();
        },
        enumerable: !1,
        configurable: !0
    }), 
    // Returns a copy of the current node.
    t.prototype.copy = function(t, e, n, r, i) {
        return this;
    }, 
    // Returns a copy of the tree, with the specified key/value added.
    t.prototype.ot = function(t, e, n) {
        return new Et(t, e);
    }, 
    // Returns a copy of the tree, with the specified key removed.
    t.prototype.remove = function(t, e) {
        return this;
    }, t.prototype.m = function() {
        return !0;
    }, t.prototype.ht = function(t) {
        return !1;
    }, t.prototype.lt = function(t) {
        return !1;
    }, t.prototype.ct = function() {
        return null;
    }, t.prototype.at = function() {
        return null;
    }, t.prototype.gt = function() {
        return !1;
    }, 
    // For testing.
    t.prototype.Ct = function() {
        return !0;
    }, t.prototype.Ft = function() {
        return 0;
    }, t;
}());

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * SortedSet is an immutable (copy-on-write) collection that holds elements
 * in order specified by the provided comparator.
 *
 * NOTE: if provided comparator returns 0 for two elements, we consider them to
 * be equal!
 */
var _t = /** @class */ function() {
    function t(t) {
        this.i = t, this.data = new wt(this.i);
    }
    return t.prototype.has = function(t) {
        return null !== this.data.get(t);
    }, t.prototype.first = function() {
        return this.data.ct();
    }, t.prototype.last = function() {
        return this.data.at();
    }, Object.defineProperty(t.prototype, "size", {
        get: function() {
            return this.data.size;
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.indexOf = function(t) {
        return this.data.indexOf(t);
    }, 
    /** Iterates elements in order defined by "comparator" */ t.prototype.forEach = function(t) {
        this.data.ht((function(e, n) {
            return t(e), !1;
        }));
    }, 
    /** Iterates over `elem`s such that: range[0] <= elem < range[1]. */ t.prototype.Nt = function(t, e) {
        for (var n = this.data.ft(t[0]); n.At(); ) {
            var r = n.It();
            if (this.i(r.key, t[1]) >= 0) return;
            e(r.key);
        }
    }, 
    /**
     * Iterates over `elem`s such that: start <= elem until false is returned.
     */
    t.prototype.$t = function(t, e) {
        var n;
        for (n = void 0 !== e ? this.data.ft(e) : this.data._t(); n.At(); ) if (!t(n.It().key)) return;
    }, 
    /** Finds the least element greater than or equal to `elem`. */ t.prototype.xt = function(t) {
        var e = this.data.ft(t);
        return e.At() ? e.It().key : null;
    }, t.prototype._t = function() {
        return new It(this.data._t());
    }, t.prototype.ft = function(t) {
        return new It(this.data.ft(t));
    }, 
    /** Inserts or updates an element */ t.prototype.add = function(t) {
        return this.copy(this.data.remove(t).ot(t, !0));
    }, 
    /** Deletes an element */ t.prototype.delete = function(t) {
        return this.has(t) ? this.copy(this.data.remove(t)) : this;
    }, t.prototype.m = function() {
        return this.data.m();
    }, t.prototype.kt = function(t) {
        var e = this;
        // Make sure `result` always refers to the larger one of the two sets.
                return e.size < t.size && (e = t, t = this), t.forEach((function(t) {
            e = e.add(t);
        })), e;
    }, t.prototype.isEqual = function(e) {
        if (!(e instanceof t)) return !1;
        if (this.size !== e.size) return !1;
        for (var n = this.data._t(), r = e.data._t(); n.At(); ) {
            var i = n.It().key, o = r.It().key;
            if (0 !== this.i(i, o)) return !1;
        }
        return !0;
    }, t.prototype.A = function() {
        var t = [];
        return this.forEach((function(e) {
            t.push(e);
        })), t;
    }, t.prototype.toString = function() {
        var t = [];
        return this.forEach((function(e) {
            return t.push(e);
        })), "SortedSet(" + t.toString() + ")";
    }, t.prototype.copy = function(e) {
        var n = new t(this.i);
        return n.data = e, n;
    }, t;
}(), It = /** @class */ function() {
    function t(t) {
        this.Ot = t;
    }
    return t.prototype.It = function() {
        return this.Ot.It().key;
    }, t.prototype.At = function() {
        return this.Ot.At();
    }, t;
}(), At = new wt(T.i);

function Nt() {
    return At;
}

function Tt() {
    return Nt();
}

var Dt = new wt(T.i);

function Vt() {
    return Dt;
}

var Rt = new wt(T.i), Lt = new _t(T.i);

function Ut() {
    for (var t = [], e = 0; e < arguments.length; e++) t[e] = arguments[e];
    for (var n = Lt, r = 0, i = t; r < i.length; r++) {
        var o = i[r];
        n = n.add(o);
    }
    return n;
}

var Ot = new _t(X);

function St() {
    return Ot;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * DocumentSet is an immutable (copy-on-write) collection that holds documents
 * in order specified by the provided comparator. We always add a document key
 * comparator on top of what is provided to guarantee document equality based on
 * the key.
 */ var kt = /** @class */ function() {
    /** The default ordering is by key if the comparator is omitted */
    function t(t) {
        // We are adding document key comparator to the end as it's the only
        // guaranteed unique property of a document.
        this.i = t ? function(e, n) {
            return t(e, n) || T.i(e.key, n.key);
        } : function(t, e) {
            return T.i(t.key, e.key);
        }, this.Lt = Vt(), this.Mt = new wt(this.i)
        /**
     * Returns an empty copy of the existing DocumentSet, using the same
     * comparator.
     */;
    }
    return t.qt = function(e) {
        return new t(e.i);
    }, t.prototype.has = function(t) {
        return null != this.Lt.get(t);
    }, t.prototype.get = function(t) {
        return this.Lt.get(t);
    }, t.prototype.first = function() {
        return this.Mt.ct();
    }, t.prototype.last = function() {
        return this.Mt.at();
    }, t.prototype.m = function() {
        return this.Mt.m();
    }, 
    /**
     * Returns the index of the provided key in the document set, or -1 if the
     * document key is not present in the set;
     */
    t.prototype.indexOf = function(t) {
        var e = this.Lt.get(t);
        return e ? this.Mt.indexOf(e) : -1;
    }, Object.defineProperty(t.prototype, "size", {
        get: function() {
            return this.Mt.size;
        },
        enumerable: !1,
        configurable: !0
    }), 
    /** Iterates documents in order defined by "comparator" */ t.prototype.forEach = function(t) {
        this.Mt.ht((function(e, n) {
            return t(e), !1;
        }));
    }, 
    /** Inserts or updates a document with the same key */ t.prototype.add = function(t) {
        // First remove the element if we have it.
        var e = this.delete(t.key);
        return e.copy(e.Lt.ot(t.key, t), e.Mt.ot(t, null));
    }, 
    /** Deletes a document with a given key */ t.prototype.delete = function(t) {
        var e = this.get(t);
        return e ? this.copy(this.Lt.remove(t), this.Mt.remove(e)) : this;
    }, t.prototype.isEqual = function(e) {
        if (!(e instanceof t)) return !1;
        if (this.size !== e.size) return !1;
        for (var n = this.Mt._t(), r = e.Mt._t(); n.At(); ) {
            var i = n.It().key, o = r.It().key;
            if (!i.isEqual(o)) return !1;
        }
        return !0;
    }, t.prototype.toString = function() {
        var t = [];
        return this.forEach((function(e) {
            t.push(e.toString());
        })), 0 === t.length ? "DocumentSet ()" : "DocumentSet (\n  " + t.join("  \n") + "\n)";
    }, t.prototype.copy = function(e, n) {
        var r = new t;
        return r.i = this.i, r.Lt = e, r.Mt = n, r;
    }, t;
}(), jt = /** @class */ function() {
    function t() {
        this.Ut = new wt(T.i);
    }
    return t.prototype.track = function(t) {
        var e = t.doc.key, n = this.Ut.get(e);
        n ? 
        // Merge the new change with the existing change.
        0 /* Added */ !== t.type && 3 /* Metadata */ === n.type ? this.Ut = this.Ut.ot(e, t) : 3 /* Metadata */ === t.type && 1 /* Removed */ !== n.type ? this.Ut = this.Ut.ot(e, {
            type: n.type,
            doc: t.doc
        }) : 2 /* Modified */ === t.type && 2 /* Modified */ === n.type ? this.Ut = this.Ut.ot(e, {
            type: 2 /* Modified */ ,
            doc: t.doc
        }) : 2 /* Modified */ === t.type && 0 /* Added */ === n.type ? this.Ut = this.Ut.ot(e, {
            type: 0 /* Added */ ,
            doc: t.doc
        }) : 1 /* Removed */ === t.type && 0 /* Added */ === n.type ? this.Ut = this.Ut.remove(e) : 1 /* Removed */ === t.type && 2 /* Modified */ === n.type ? this.Ut = this.Ut.ot(e, {
            type: 1 /* Removed */ ,
            doc: n.doc
        }) : 0 /* Added */ === t.type && 1 /* Removed */ === n.type ? this.Ut = this.Ut.ot(e, {
            type: 2 /* Modified */ ,
            doc: t.doc
        }) : 
        // This includes these cases, which don't make sense:
        // Added->Added
        // Removed->Removed
        // Modified->Added
        // Removed->Modified
        // Metadata->Added
        // Removed->Metadata
        y() : this.Ut = this.Ut.ot(e, t);
    }, t.prototype.Bt = function() {
        var t = [];
        return this.Ut.ht((function(e, n) {
            t.push(n);
        })), t;
    }, t;
}(), Pt = /** @class */ function() {
    function t(t, e, n, r, i, o, s, u) {
        this.query = t, this.docs = e, this.Qt = n, this.docChanges = r, this.jt = i, this.fromCache = o, 
        this.Wt = s, this.Gt = u
        /** Returns a view snapshot as if all documents in the snapshot were added. */;
    }
    return t.zt = function(e, n, r, i) {
        var o = [];
        return n.forEach((function(t) {
            o.push({
                type: 0 /* Added */ ,
                doc: t
            });
        })), new t(e, n, kt.qt(n), o, r, i, 
        /* syncStateChanged= */ !0, 
        /* excludesMetadataChanges= */ !1);
    }, Object.defineProperty(t.prototype, "hasPendingWrites", {
        get: function() {
            return !this.jt.m();
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.isEqual = function(t) {
        if (!(this.fromCache === t.fromCache && this.Wt === t.Wt && this.jt.isEqual(t.jt) && kn(this.query, t.query) && this.docs.isEqual(t.docs) && this.Qt.isEqual(t.Qt))) return !1;
        var e = this.docChanges, n = t.docChanges;
        if (e.length !== n.length) return !1;
        for (var r = 0; r < e.length; r++) if (e[r].type !== n[r].type || !e[r].doc.isEqual(n[r].doc)) return !1;
        return !0;
    }, t;
}(), Ct = /** @class */ function() {
    function t(
    /**
     * The snapshot version this event brings us up to, or MIN if not set.
     */
    t, 
    /**
     * A map from target to changes to the target. See TargetChange.
     */
    e, 
    /**
     * A set of targets that is known to be inconsistent. Listens for these
     * targets should be re-established without resume tokens.
     */
    n, 
    /**
     * A set of which documents have changed or been deleted, along with the
     * doc's new values (if not deleted).
     */
    r, 
    /**
     * A set of which document updates are due only to limbo resolution targets.
     */
    i) {
        this.nt = t, this.Kt = e, this.Ht = n, this.Yt = r, this.Jt = i;
    }
    /**
     * HACK: Views require RemoteEvents in order to determine whether the view is
     * CURRENT, but secondary tabs don't receive remote events. So this method is
     * used to create a synthesized RemoteEvent that can be used to apply a
     * CURRENT status change to a View, for queries executed in a different tab.
     */
    // PORTING NOTE: Multi-tab only
        return t.Xt = function(e, n) {
        var r = new Map;
        return r.set(e, Mt.Zt(e, n)), new t(ot.min(), r, St(), Nt(), Ut());
    }, t;
}(), Mt = /** @class */ function() {
    function t(
    /**
     * An opaque, server-assigned token that allows watching a query to be resumed
     * after disconnecting without retransmitting all the data that matches the
     * query. The resume token essentially identifies a point in time from which
     * the server should resume sending results.
     */
    t, 
    /**
     * The "current" (synced) status of this target. Note that "current"
     * has special meaning in the RPC protocol that implies that a target is
     * both up-to-date and consistent with the rest of the watch stream.
     */
    e, 
    /**
     * The set of documents that were newly assigned to this target as part of
     * this remote event.
     */
    n, 
    /**
     * The set of documents that were already assigned to this target but received
     * an update during this remote event.
     */
    r, 
    /**
     * The set of documents that were removed from this target as part of this
     * remote event.
     */
    i) {
        this.resumeToken = t, this.te = e, this.ee = n, this.ne = r, this.se = i
        /**
     * This method is used to create a synthesized TargetChanges that can be used to
     * apply a CURRENT status change to a View (for queries executed in a different
     * tab) or for new queries (to raise snapshots with correct CURRENT status).
     */;
    }
    return t.Zt = function(e, n) {
        return new t(Y.q, n, Ut(), Ut(), Ut());
    }, t;
}(), xt = function(
/** The new document applies to all of these targets. */
t, 
/** The new document is removed from all of these targets. */
e, 
/** The key of the document for this change. */
n, 
/**
     * The new document or NoDocument if it was deleted. Is null if the
     * document went out of view without the server sending a new document.
     */
r) {
    this.ie = t, this.removedTargetIds = e, this.key = n, this.re = r;
}, qt = function(t, e) {
    this.targetId = t, this.oe = e;
}, Ft = function(
/** What kind of change occurred to the watch target. */
t, 
/** The target IDs that were added/removed/set. */
e, 
/**
     * An opaque, server-assigned token that allows watching a target to be
     * resumed after disconnecting without retransmitting all the data that
     * matches the target. The resume token essentially identifies a point in
     * time from which the server should resume sending results.
     */
n
/** An RPC error indicating why the watch failed. */ , r) {
    void 0 === n && (n = Y.q), void 0 === r && (r = null), this.state = t, this.targetIds = e, 
    this.resumeToken = n, this.cause = r;
}, Bt = /** @class */ function() {
    function t() {
        /**
         * The number of pending responses (adds or removes) that we are waiting on.
         * We only consider targets active that have no pending responses.
         */
        this.ue = 0, 
        /**
             * Keeps track of the document changes since the last raised snapshot.
             *
             * These changes are continuously updated as we receive document updates and
             * always reflect the current set of changes against the last issued snapshot.
             */
        this.ce = Wt(), 
        /** See public getters for explanations of these fields. */
        this.ae = Y.q, this.he = !1, 
        /**
             * Whether this target state should be included in the next snapshot. We
             * initialize to true so that newly-added targets are included in the next
             * RemoteEvent.
             */
        this.le = !0;
    }
    return Object.defineProperty(t.prototype, "te", {
        /**
         * Whether this target has been marked 'current'.
         *
         * 'Current' has special meaning in the RPC protocol: It implies that the
         * Watch backend has sent us all changes up to the point at which the target
         * was added and that the target is consistent with the rest of the watch
         * stream.
         */
        get: function() {
            return this.he;
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "resumeToken", {
        /** The last resume token sent to us for this target. */ get: function() {
            return this.ae;
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "_e", {
        /** Whether this target has pending target adds or target removes. */ get: function() {
            return 0 !== this.ue;
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "fe", {
        /** Whether we have modified any state that should trigger a snapshot. */ get: function() {
            return this.le;
        },
        enumerable: !1,
        configurable: !0
    }), 
    /**
     * Applies the resume token to the TargetChange, but only when it has a new
     * value. Empty resumeTokens are discarded.
     */
    t.prototype.de = function(t) {
        t.L() > 0 && (this.le = !0, this.ae = t);
    }, 
    /**
     * Creates a target change from the current set of changes.
     *
     * To reset the document changes after raising this snapshot, call
     * `clearPendingChanges()`.
     */
    t.prototype.we = function() {
        var t = Ut(), e = Ut(), n = Ut();
        return this.ce.forEach((function(r, i) {
            switch (i) {
              case 0 /* Added */ :
                t = t.add(r);
                break;

              case 2 /* Modified */ :
                e = e.add(r);
                break;

              case 1 /* Removed */ :
                n = n.add(r);
                break;

              default:
                y();
            }
        })), new Mt(this.ae, this.he, t, e, n);
    }, 
    /**
     * Resets the document changes and sets `hasPendingChanges` to false.
     */
    t.prototype.me = function() {
        this.le = !1, this.ce = Wt();
    }, t.prototype.Te = function(t, e) {
        this.le = !0, this.ce = this.ce.ot(t, e);
    }, t.prototype.Ee = function(t) {
        this.le = !0, this.ce = this.ce.remove(t);
    }, t.prototype.Ie = function() {
        this.ue += 1;
    }, t.prototype.Ae = function() {
        this.ue -= 1;
    }, t.prototype.Re = function() {
        this.le = !0, this.he = !0;
    }, t;
}(), Gt = /** @class */ function() {
    function t(t) {
        this.ye = t, 
        /** The internal state of all tracked targets. */
        this.Pe = new Map, 
        /** Keeps track of the documents to update since the last raised snapshot. */
        this.ge = Nt(), 
        /** A mapping of document keys to their set of target IDs. */
        this.pe = zt(), 
        /**
             * A list of targets with existence filter mismatches. These targets are
             * known to be inconsistent and their listens needs to be re-established by
             * RemoteStore.
             */
        this.Ve = new _t(X)
        /**
     * Processes and adds the DocumentWatchChange to the current set of changes.
     */;
    }
    return t.prototype.ve = function(t) {
        for (var e = 0, n = t.ie; e < n.length; e++) {
            var r = n[e];
            t.re instanceof wn ? this.be(r, t.re) : t.re instanceof bn && this.Se(r, t.key, t.re);
        }
        for (var i = 0, o = t.removedTargetIds; i < o.length; i++) {
            var s = o[i];
            this.Se(s, t.key, t.re);
        }
    }, 
    /** Processes and adds the WatchTargetChange to the current set of changes. */ t.prototype.De = function(t) {
        var e = this;
        this.Ce(t, (function(n) {
            var r = e.Fe(n);
            switch (t.state) {
              case 0 /* NoChange */ :
                e.Ne(n) && r.de(t.resumeToken);
                break;

              case 1 /* Added */ :
                // We need to decrement the number of pending acks needed from watch
                // for this targetId.
                r.Ae(), r._e || 
                // We have a freshly added target, so we need to reset any state
                // that we had previously. This can happen e.g. when remove and add
                // back a target for existence filter mismatches.
                r.me(), r.de(t.resumeToken);
                break;

              case 2 /* Removed */ :
                // We need to keep track of removed targets to we can post-filter and
                // remove any target changes.
                // We need to decrement the number of pending acks needed from watch
                // for this targetId.
                r.Ae(), r._e || e.removeTarget(n);
                break;

              case 3 /* Current */ :
                e.Ne(n) && (r.Re(), r.de(t.resumeToken));
                break;

              case 4 /* Reset */ :
                e.Ne(n) && (
                // Reset the target and synthesizes removes for all existing
                // documents. The backend will re-add any documents that still
                // match the target before it sends the next global snapshot.
                e.$e(n), r.de(t.resumeToken));
                break;

              default:
                y();
            }
        }));
    }, 
    /**
     * Iterates over all targetIds that the watch change applies to: either the
     * targetIds explicitly listed in the change or the targetIds of all currently
     * active targets.
     */
    t.prototype.Ce = function(t, e) {
        var n = this;
        t.targetIds.length > 0 ? t.targetIds.forEach(e) : this.Pe.forEach((function(t, r) {
            n.Ne(r) && e(r);
        }));
    }, 
    /**
     * Handles existence filters and synthesizes deletes for filter mismatches.
     * Targets that are invalidated by filter mismatches are added to
     * `pendingTargetResets`.
     */
    t.prototype.xe = function(t) {
        var e = t.targetId, n = t.oe.count, r = this.ke(e);
        if (r) {
            var i = r.target;
            if (lt(i)) if (0 === n) {
                // The existence filter told us the document does not exist. We deduce
                // that this document does not exist and apply a deleted document to
                // our updates. Without applying this deleted document there might be
                // another query that will raise this document as part of a snapshot
                // until it is resolved, essentially exposing inconsistency between
                // queries.
                var o = new T(i.path);
                this.Se(e, o, new bn(o, ot.min()));
            } else g(1 === n); else this.Oe(e) !== n && (
            // Existence filter mismatch: We reset the mapping and raise a new
            // snapshot with `isFromCache:true`.
            this.$e(e), this.Ve = this.Ve.add(e));
        }
    }, 
    /**
     * Converts the currently accumulated state into a remote event at the
     * provided snapshot version. Resets the accumulated changes before returning.
     */
    t.prototype.Le = function(t) {
        var e = this, n = new Map;
        this.Pe.forEach((function(r, i) {
            var o = e.ke(i);
            if (o) {
                if (r.te && lt(o.target)) {
                    // Document queries for document that don't exist can produce an empty
                    // result set. To update our local cache, we synthesize a document
                    // delete if we have not previously received the document. This
                    // resolves the limbo state of the document, removing it from
                    // limboDocumentRefs.
                    // TODO(dimond): Ideally we would have an explicit lookup target
                    // instead resulting in an explicit delete message and we could
                    // remove this special logic.
                    var s = new T(o.target.path);
                    null !== e.ge.get(s) || e.Me(i, s) || e.Se(i, s, new bn(s, t));
                }
                r.fe && (n.set(i, r.we()), r.me());
            }
        }));
        var r = Ut();
        // We extract the set of limbo-only document updates as the GC logic
        // special-cases documents that do not appear in the target cache.
        // TODO(gsoltis): Expand on this comment once GC is available in the JS
        // client.
                this.pe.forEach((function(t, n) {
            var i = !0;
            n.$t((function(t) {
                var n = e.ke(t);
                return !n || 2 /* LimboResolution */ === n.et || (i = !1, !1);
            })), i && (r = r.add(t));
        }));
        var i = new Ct(t, n, this.Ve, this.ge, r);
        return this.ge = Nt(), this.pe = zt(), this.Ve = new _t(X), i;
    }, 
    /**
     * Adds the provided document to the internal list of document updates and
     * its document key to the given target's mapping.
     */
    // Visible for testing.
    t.prototype.be = function(t, e) {
        if (this.Ne(t)) {
            var n = this.Me(t, e.key) ? 2 /* Modified */ : 0 /* Added */;
            this.Fe(t).Te(e.key, n), this.ge = this.ge.ot(e.key, e), this.pe = this.pe.ot(e.key, this.qe(e.key).add(t));
        }
    }, 
    /**
     * Removes the provided document from the target mapping. If the
     * document no longer matches the target, but the document's state is still
     * known (e.g. we know that the document was deleted or we received the change
     * that caused the filter mismatch), the new document can be provided
     * to update the remote document cache.
     */
    // Visible for testing.
    t.prototype.Se = function(t, e, n) {
        if (this.Ne(t)) {
            var r = this.Fe(t);
            this.Me(t, e) ? r.Te(e, 1 /* Removed */) : 
            // The document may have entered and left the target before we raised a
            // snapshot, so we can just ignore the change.
            r.Ee(e), this.pe = this.pe.ot(e, this.qe(e).delete(t)), n && (this.ge = this.ge.ot(e, n));
        }
    }, t.prototype.removeTarget = function(t) {
        this.Pe.delete(t);
    }, 
    /**
     * Returns the current count of documents in the target. This includes both
     * the number of documents that the LocalStore considers to be part of the
     * target as well as any accumulated changes.
     */
    t.prototype.Oe = function(t) {
        var e = this.Fe(t).we();
        return this.ye.Ue(t).size + e.ee.size - e.se.size;
    }, 
    /**
     * Increment the number of acks needed from watch before we can consider the
     * server to be 'in-sync' with the client's active targets.
     */
    t.prototype.Ie = function(t) {
        this.Fe(t).Ie();
    }, t.prototype.Fe = function(t) {
        var e = this.Pe.get(t);
        return e || (e = new Bt, this.Pe.set(t, e)), e;
    }, t.prototype.qe = function(t) {
        var e = this.pe.get(t);
        return e || (e = new _t(X), this.pe = this.pe.ot(t, e)), e;
    }, 
    /**
     * Verifies that the user is still interested in this target (by calling
     * `getTargetDataForTarget()`) and that we are not waiting for pending ADDs
     * from watch.
     */
    t.prototype.Ne = function(t) {
        var e = null !== this.ke(t);
        return e || l("WatchChangeAggregator", "Detected inactive target", t), e;
    }, 
    /**
     * Returns the TargetData for an active target (i.e. a target that the user
     * is still interested in that has no outstanding target change requests).
     */
    t.prototype.ke = function(t) {
        var e = this.Pe.get(t);
        return e && e._e ? null : this.ye.Be(t);
    }, 
    /**
     * Resets the state of a Watch target to its initial state (e.g. sets
     * 'current' to false, clears the resume token and removes its target mapping
     * from all documents).
     */
    t.prototype.$e = function(t) {
        var e = this;
        this.Pe.set(t, new Bt), this.ye.Ue(t).forEach((function(n) {
            e.Se(t, n, /*updatedDocument=*/ null);
        }));
    }, 
    /**
     * Returns whether the LocalStore considers the document to be part of the
     * specified target.
     */
    t.prototype.Me = function(t, e) {
        return this.ye.Ue(t).has(e);
    }, t;
}();

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * DocumentChangeSet keeps track of a set of changes to docs in a query, merging
 * duplicate events for the same doc.
 */ function zt() {
    return new wt(T.i);
}

function Wt() {
    return new wt(T.i);
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Represents a locally-applied ServerTimestamp.
 *
 * Server Timestamps are backed by MapValues that contain an internal field
 * `__type__` with a value of `server_timestamp`. The previous value and local
 * write time are stored in its `__previous_value__` and `__local_write_time__`
 * fields respectively.
 *
 * Notes:
 * - ServerTimestampValue instances are created as the result of applying a
 *   TransformMutation (see TransformMutation.applyTo()). They can only exist in
 *   the local view of a document. Therefore they do not need to be parsed or
 *   serialized.
 * - When evaluated locally (e.g. for snapshot.data()), they by default
 *   evaluate to `null`. This behavior can be configured by passing custom
 *   FieldValueOptions to value().
 * - With respect to other ServerTimestampValues, they sort by their
 *   localWriteTime.
 */ function Qt(t) {
    var e, n;
    return "server_timestamp" === (null === (n = ((null === (e = null == t ? void 0 : t.mapValue) || void 0 === e ? void 0 : e.fields) || {}).__type__) || void 0 === n ? void 0 : n.stringValue);
}

/**
 * Creates a new ServerTimestamp proto value (using the internal format).
 */
/**
 * Returns the value of the field before this ServerTimestamp was set.
 *
 * Preserving the previous values allows the user to display the last resoled
 * value until the backend responds with the timestamp.
 */ function Kt(t) {
    var e = t.mapValue.fields.__previous_value__;
    return Qt(e) ? Kt(e) : e;
}

/**
 * Returns the local time at which this timestamp was first set.
 */ function Xt(t) {
    var e = re(t.mapValue.fields.__local_write_time__.timestampValue);
    return new it(e.seconds, e.nanos);
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// A RegExp matching ISO 8601 UTC timestamps with optional fraction.
var Ht = new RegExp(/^\d{4}-\d\d-\d\dT\d\d:\d\d:\d\d(?:\.(\d+))?Z$/);

/** Extracts the backend's type order for the provided value. */ function Yt(t) {
    return "nullValue" in t ? 0 /* NullValue */ : "booleanValue" in t ? 1 /* BooleanValue */ : "integerValue" in t || "doubleValue" in t ? 2 /* NumberValue */ : "timestampValue" in t ? 3 /* TimestampValue */ : "stringValue" in t ? 5 /* StringValue */ : "bytesValue" in t ? 6 /* BlobValue */ : "referenceValue" in t ? 7 /* RefValue */ : "geoPointValue" in t ? 8 /* GeoPointValue */ : "arrayValue" in t ? 9 /* ArrayValue */ : "mapValue" in t ? Qt(t) ? 4 /* ServerTimestampValue */ : 10 /* ObjectValue */ : y();
}

/** Tests `left` and `right` for equality based on the backend semantics. */ function Jt(t, e) {
    var n = Yt(t);
    if (n !== Yt(e)) return !1;
    switch (n) {
      case 0 /* NullValue */ :
        return !0;

      case 1 /* BooleanValue */ :
        return t.booleanValue === e.booleanValue;

      case 4 /* ServerTimestampValue */ :
        return Xt(t).isEqual(Xt(e));

      case 3 /* TimestampValue */ :
        return function(t, e) {
            if ("string" == typeof t.timestampValue && "string" == typeof e.timestampValue && t.timestampValue.length === e.timestampValue.length) 
            // Use string equality for ISO 8601 timestamps
            return t.timestampValue === e.timestampValue;
            var n = re(t.timestampValue), r = re(e.timestampValue);
            return n.seconds === r.seconds && n.nanos === r.nanos;
        }(t, e);

      case 5 /* StringValue */ :
        return t.stringValue === e.stringValue;

      case 6 /* BlobValue */ :
        return function(t, e) {
            return oe(t.bytesValue).isEqual(oe(e.bytesValue));
        }(t, e);

      case 7 /* RefValue */ :
        return t.referenceValue === e.referenceValue;

      case 8 /* GeoPointValue */ :
        return function(t, e) {
            return ie(t.geoPointValue.latitude) === ie(e.geoPointValue.latitude) && ie(t.geoPointValue.longitude) === ie(e.geoPointValue.longitude);
        }(t, e);

      case 2 /* NumberValue */ :
        return function(t, e) {
            if ("integerValue" in t && "integerValue" in e) return ie(t.integerValue) === ie(e.integerValue);
            if ("doubleValue" in t && "doubleValue" in e) {
                var n = ie(t.doubleValue), r = ie(e.doubleValue);
                return n === r ? ut(n) === ut(r) : isNaN(n) && isNaN(r);
            }
            return !1;
        }(t, e);

      case 9 /* ArrayValue */ :
        return H(t.arrayValue.values || [], e.arrayValue.values || [], Jt);

      case 10 /* ObjectValue */ :
        return function(t, e) {
            var n = t.mapValue.fields || {}, r = e.mapValue.fields || {};
            if (w(n) !== w(r)) return !1;
            for (var i in n) if (n.hasOwnProperty(i) && (void 0 === r[i] || !Jt(n[i], r[i]))) return !1;
            return !0;
        }(t, e);

      default:
        return y();
    }
}

function $t(t, e) {
    return void 0 !== (t.values || []).find((function(t) {
        return Jt(t, e);
    }));
}

function Zt(t, e) {
    var n = Yt(t), r = Yt(e);
    if (n !== r) return X(n, r);
    switch (n) {
      case 0 /* NullValue */ :
        return 0;

      case 1 /* BooleanValue */ :
        return X(t.booleanValue, e.booleanValue);

      case 2 /* NumberValue */ :
        return function(t, e) {
            var n = ie(t.integerValue || t.doubleValue), r = ie(e.integerValue || e.doubleValue);
            return n < r ? -1 : n > r ? 1 : n === r ? 0 : 
            // one or both are NaN.
            isNaN(n) ? isNaN(r) ? 0 : -1 : 1;
        }(t, e);

      case 3 /* TimestampValue */ :
        return te(t.timestampValue, e.timestampValue);

      case 4 /* ServerTimestampValue */ :
        return te(Xt(t), Xt(e));

      case 5 /* StringValue */ :
        return X(t.stringValue, e.stringValue);

      case 6 /* BlobValue */ :
        return function(t, e) {
            var n = oe(t), r = oe(e);
            return n.M(r);
        }(t.bytesValue, e.bytesValue);

      case 7 /* RefValue */ :
        return function(t, e) {
            for (var n = t.split("/"), r = e.split("/"), i = 0; i < n.length && i < r.length; i++) {
                var o = X(n[i], r[i]);
                if (0 !== o) return o;
            }
            return X(n.length, r.length);
        }(t.referenceValue, e.referenceValue);

      case 8 /* GeoPointValue */ :
        return function(t, e) {
            var n = X(ie(t.latitude), ie(e.latitude));
            return 0 !== n ? n : X(ie(t.longitude), ie(e.longitude));
        }(t.geoPointValue, e.geoPointValue);

      case 9 /* ArrayValue */ :
        return function(t, e) {
            for (var n = t.values || [], r = e.values || [], i = 0; i < n.length && i < r.length; ++i) {
                var o = Zt(n[i], r[i]);
                if (o) return o;
            }
            return X(n.length, r.length);
        }(t.arrayValue, e.arrayValue);

      case 10 /* ObjectValue */ :
        return function(t, e) {
            var n = t.fields || {}, r = Object.keys(n), i = e.fields || {}, o = Object.keys(i);
            // Even though MapValues are likely sorted correctly based on their insertion
            // order (e.g. when received from the backend), local modifications can bring
            // elements out of order. We need to re-sort the elements to ensure that
            // canonical IDs are independent of insertion order.
                        r.sort(), o.sort();
            for (var s = 0; s < r.length && s < o.length; ++s) {
                var u = X(r[s], o[s]);
                if (0 !== u) return u;
                var a = Zt(n[r[s]], i[o[s]]);
                if (0 !== a) return a;
            }
            return X(r.length, o.length);
        }(t.mapValue, e.mapValue);

      default:
        throw y();
    }
}

function te(t, e) {
    if ("string" == typeof t && "string" == typeof e && t.length === e.length) return X(t, e);
    var n = re(t), r = re(e), i = X(n.seconds, r.seconds);
    return 0 !== i ? i : X(n.nanos, r.nanos);
}

function ee(t) {
    return ne(t);
}

function ne(t) {
    return "nullValue" in t ? "null" : "booleanValue" in t ? "" + t.booleanValue : "integerValue" in t ? "" + t.integerValue : "doubleValue" in t ? "" + t.doubleValue : "timestampValue" in t ? function(t) {
        var e = re(t);
        return "time(" + e.seconds + "," + e.nanos + ")";
    }(t.timestampValue) : "stringValue" in t ? t.stringValue : "bytesValue" in t ? oe(t.bytesValue).toBase64() : "referenceValue" in t ? (n = t.referenceValue, 
    T.C(n).toString()) : "geoPointValue" in t ? "geo(" + (e = t.geoPointValue).latitude + "," + e.longitude + ")" : "arrayValue" in t ? function(t) {
        for (var e = "[", n = !0, r = 0, i = t.values || []; r < i.length; r++) {
            n ? n = !1 : e += ",", e += ne(i[r]);
        }
        return e + "]";
    }(t.arrayValue) : "mapValue" in t ? function(t) {
        for (
        // Iteration order in JavaScript is not guaranteed. To ensure that we generate
        // matching canonical IDs for identical maps, we need to sort the keys.
        var e = "{", n = !0, r = 0, i = Object.keys(t.fields || {}).sort(); r < i.length; r++) {
            var o = i[r];
            n ? n = !1 : e += ",", e += o + ":" + ne(t.fields[o]);
        }
        return e + "}";
    }(t.mapValue) : y();
    var e, n;
}

function re(t) {
    // The json interface (for the browser) will return an iso timestamp string,
    // while the proto js library (for node) will return a
    // google.protobuf.Timestamp instance.
    if (g(!!t), "string" == typeof t) {
        // The date string can have higher precision (nanos) than the Date class
        // (millis), so we do some custom parsing here.
        // Parse the nanos right out of the string.
        var e = 0, n = Ht.exec(t);
        if (g(!!n), n[1]) {
            // Pad the fraction out to 9 digits (nanos).
            var r = n[1];
            r = (r + "000000000").substr(0, 9), e = Number(r);
        }
        // Parse the date to get the seconds.
                var i = new Date(t);
        return {
            seconds: Math.floor(i.getTime() / 1e3),
            nanos: e
        };
    }
    return {
        seconds: ie(t.seconds),
        nanos: ie(t.nanos)
    };
}

/**
 * Converts the possible Proto types for numbers into a JavaScript number.
 * Returns 0 if the value is not numeric.
 */ function ie(t) {
    // TODO(bjornick): Handle int64 greater than 53 bits.
    return "number" == typeof t ? t : "string" == typeof t ? Number(t) : 0;
}

/** Converts the possible Proto types for Blobs into a ByteString. */ function oe(t) {
    return "string" == typeof t ? Y.fromBase64String(t) : Y.fromUint8Array(t);
}

/** Returns a reference value for the provided database and key. */ function se(t, e) {
    return {
        referenceValue: "projects/" + t.projectId + "/databases/" + t.database + "/documents/" + e.path.R()
    };
}

/** Returns true if `value` is an IntegerValue . */ function ue(t) {
    return !!t && "integerValue" in t;
}

/** Returns true if `value` is a DoubleValue. */
/** Returns true if `value` is an ArrayValue. */ function ae(t) {
    return !!t && "arrayValue" in t;
}

/** Returns true if `value` is a NullValue. */ function ce(t) {
    return !!t && "nullValue" in t;
}

/** Returns true if `value` is NaN. */ function he(t) {
    return !!t && "doubleValue" in t && isNaN(Number(t.doubleValue));
}

/** Returns true if `value` is a MapValue. */ function fe(t) {
    return !!t && "mapValue" in t;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ var le = {
    asc: "ASCENDING",
    desc: "DESCENDING"
}, pe = {
    "<": "LESS_THAN",
    "<=": "LESS_THAN_OR_EQUAL",
    ">": "GREATER_THAN",
    ">=": "GREATER_THAN_OR_EQUAL",
    "==": "EQUAL",
    "!=": "NOT_EQUAL",
    "array-contains": "ARRAY_CONTAINS",
    in: "IN",
    "not-in": "NOT_IN",
    "array-contains-any": "ARRAY_CONTAINS_ANY"
}, de = function(t, e) {
    this.B = t, this.Qe = e;
};

/**
 * This class generates JsonObject values for the Datastore API suitable for
 * sending to either GRPC stub methods or via the JSON/HTTP REST API.
 *
 * The serializer supports both Protobuf.js and Proto3 JSON formats. By
 * setting `useProto3Json` to true, the serializer will use the Proto3 JSON
 * format.
 *
 * For a description of the Proto3 JSON format check
 * https://developers.google.com/protocol-buffers/docs/proto3#json
 *
 * TODO(klimt): We can remove the databaseId argument if we keep the full
 * resource name in documents.
 */
/**
 * Returns an IntegerValue for `value`.
 */
function ve(t) {
    return {
        integerValue: "" + t
    };
}

/**
 * Returns an DoubleValue for `value` that is encoded based the serializer's
 * `useProto3Json` setting.
 */ function ye(t, e) {
    if (t.Qe) {
        if (isNaN(e)) return {
            doubleValue: "NaN"
        };
        if (e === 1 / 0) return {
            doubleValue: "Infinity"
        };
        if (e === -1 / 0) return {
            doubleValue: "-Infinity"
        };
    }
    return {
        doubleValue: ut(e) ? "-0" : e
    };
}

/**
 * Returns a value for a number that's appropriate to put into a proto.
 * The return value is an IntegerValue if it can safely represent the value,
 * otherwise a DoubleValue is returned.
 */ function ge(t, e) {
    return function(t) {
        return "number" == typeof t && Number.isInteger(t) && !ut(t) && t <= Number.MAX_SAFE_INTEGER && t >= Number.MIN_SAFE_INTEGER;
    }(e) ? ve(e) : ye(t, e);
}

/**
 * Returns a value for a Date that's appropriate to put into a proto.
 */ function me(t, e) {
    return t.Qe ? new Date(1e3 * e.seconds).toISOString().replace(/\.\d*/, "").replace("Z", "") + "." + ("000000000" + e.nanoseconds).slice(-9) + "Z" : {
        seconds: "" + e.seconds,
        nanos: e.nanoseconds
    };
}

/**
 * Returns a value for bytes that's appropriate to put in a proto.
 *
 * Visible for testing.
 */ function we(t, e) {
    return t.Qe ? e.toBase64() : e.toUint8Array();
}

/**
 * Returns a ByteString based on the proto string value.
 */ function be(t, e) {
    return me(t, e.Z());
}

function Ee(t) {
    return g(!!t), ot.J(function(t) {
        var e = re(t);
        return new it(e.seconds, e.nanos);
    }(t));
}

function _e(t, e) {
    return function(t) {
        return new I([ "projects", t.projectId, "databases", t.database ]);
    }(t).child("documents").child(e).R();
}

function Ie(t, e) {
    return _e(t.B, e.path);
}

function Ae(t, e) {
    var n, r = function(t) {
        var e = I.P(t);
        return g(Pe(e)), e;
    }(e);
    return g(r.get(1) === t.B.projectId), g(!r.get(3) && !t.B.database || r.get(3) === t.B.database), 
    new T((g((n = r).length > 4 && "documents" === n.get(4)), n.u(5)));
}

function Ne(t, e) {
    return _e(t.B, e);
}

function Te(t) {
    return new I([ "projects", t.B.projectId, "databases", t.B.database ]).R();
}

function De(t, e, n) {
    return {
        name: Ie(t, e),
        fields: n.proto.mapValue.fields
    };
}

function Ve(t, e) {
    var n;
    if (e instanceof un) n = {
        update: De(t, e.key, e.value)
    }; else if (e instanceof pn) n = {
        delete: Ie(t, e.key)
    }; else if (e instanceof an) n = {
        update: De(t, e.key, e.data),
        updateMask: je(e.je)
    }; else if (e instanceof hn) n = {
        transform: {
            document: Ie(t, e.key),
            fieldTransforms: e.fieldTransforms.map((function(t) {
                return function(t, e) {
                    var n = e.transform;
                    if (n instanceof Fe) return {
                        fieldPath: e.field.R(),
                        setToServerValue: "REQUEST_TIME"
                    };
                    if (n instanceof Be) return {
                        fieldPath: e.field.R(),
                        appendMissingElements: {
                            values: n.elements
                        }
                    };
                    if (n instanceof ze) return {
                        fieldPath: e.field.R(),
                        removeAllFromArray: {
                            values: n.elements
                        }
                    };
                    if (n instanceof Qe) return {
                        fieldPath: e.field.R(),
                        increment: n.We
                    };
                    throw y();
                }(0, t);
            }))
        }
    }; else {
        if (!(e instanceof dn)) return y();
        n = {
            verify: Ie(t, e.key)
        };
    }
    return e.ze.Ge || (n.currentDocument = function(t, e) {
        return void 0 !== e.updateTime ? {
            updateTime: be(t, e.updateTime)
        } : void 0 !== e.exists ? {
            exists: e.exists
        } : y();
    }(t, e.ze)), n;
}

function Re(t, e) {
    return {
        documents: [ Ne(t, e.path) ]
    };
}

function Le(t, e) {
    // Dissect the path into parent, collectionId, and optional key filter.
    var n = {
        structuredQuery: {}
    }, r = e.path;
    null !== e.collectionGroup ? (n.parent = Ne(t, r), n.structuredQuery.from = [ {
        collectionId: e.collectionGroup,
        allDescendants: !0
    } ]) : (n.parent = Ne(t, r.h()), n.structuredQuery.from = [ {
        collectionId: r._()
    } ]);
    var i = function(t) {
        if (0 !== t.length) {
            var e = t.map((function(t) {
                // visible for testing
                return function(t) {
                    if ("==" /* EQUAL */ === t.op) {
                        if (he(t.value)) return {
                            unaryFilter: {
                                field: ke(t.field),
                                op: "IS_NAN"
                            }
                        };
                        if (ce(t.value)) return {
                            unaryFilter: {
                                field: ke(t.field),
                                op: "IS_NULL"
                            }
                        };
                    } else if ("!=" /* NOT_EQUAL */ === t.op) {
                        if (he(t.value)) return {
                            unaryFilter: {
                                field: ke(t.field),
                                op: "IS_NOT_NAN"
                            }
                        };
                        if (ce(t.value)) return {
                            unaryFilter: {
                                field: ke(t.field),
                                op: "IS_NOT_NULL"
                            }
                        };
                    }
                    return {
                        fieldFilter: {
                            field: ke(t.field),
                            op: Se(t.op),
                            value: t.value
                        }
                    };
                }(t);
            }));
            return 1 === e.length ? e[0] : {
                compositeFilter: {
                    op: "AND",
                    filters: e
                }
            };
        }
    }(e.filters);
    i && (n.structuredQuery.where = i);
    var o = function(t) {
        if (0 !== t.length) return t.map((function(t) {
            // visible for testing
            return function(t) {
                return {
                    field: ke(t.field),
                    direction: Oe(t.dir)
                };
            }(t);
        }));
    }(e.orderBy);
    o && (n.structuredQuery.orderBy = o);
    var s = function(t, e) {
        return t.Qe || st(e) ? e : {
            value: e
        };
    }(t, e.limit);
    return null !== s && (n.structuredQuery.limit = s), e.startAt && (n.structuredQuery.startAt = Ue(e.startAt)), 
    e.endAt && (n.structuredQuery.endAt = Ue(e.endAt)), n;
}

function Ue(t) {
    return {
        before: t.before,
        values: t.position
    };
}

// visible for testing
function Oe(t) {
    return le[t];
}

// visible for testing
function Se(t) {
    return pe[t];
}

function ke(t) {
    return {
        fieldPath: t.R()
    };
}

function je(t) {
    var e = [];
    return t.fields.forEach((function(t) {
        return e.push(t.R());
    })), {
        fieldPaths: e
    };
}

function Pe(t) {
    // Resource names have at least 4 components (project ID, database ID)
    return t.length >= 4 && "projects" === t.get(0) && "databases" === t.get(2);
}

/**
 * @license
 * Copyright 2018 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** Represents a transform within a TransformMutation. */ var Ce = function() {
    // Make sure that the structural type of `TransformOperation` is unique.
    // See https://github.com/microsoft/TypeScript/issues/5451
    this.Ke = void 0;
};

/**
 * Computes the local transform result against the provided `previousValue`,
 * optionally using the provided localWriteTime.
 */ function Me(t, e, n) {
    return t instanceof Fe ? function(t, e) {
        var n = {
            fields: {
                __type__: {
                    stringValue: "server_timestamp"
                },
                __local_write_time__: {
                    timestampValue: {
                        seconds: t.seconds,
                        nanos: t.nanoseconds
                    }
                }
            }
        };
        return e && (n.fields.__previous_value__ = e), {
            mapValue: n
        };
    }(n, e) : t instanceof Be ? Ge(t, e) : t instanceof ze ? We(t, e) : function(t, e) {
        // PORTING NOTE: Since JavaScript's integer arithmetic is limited to 53 bit
        // precision and resolves overflows by reducing precision, we do not
        // manually cap overflows at 2^63.
        var n = qe(t, e), r = Ke(n) + Ke(t.We);
        return ue(n) && ue(t.We) ? ve(r) : ye(t.serializer, r);
    }(t, e);
}

/**
 * Computes a final transform result after the transform has been acknowledged
 * by the server, potentially using the server-provided transformResult.
 */ function xe(t, e, n) {
    // The server just sends null as the transform result for array operations,
    // so we have to calculate a result the same as we do for local
    // applications.
    return t instanceof Be ? Ge(t, e) : t instanceof ze ? We(t, e) : n;
}

/**
 * If this transform operation is not idempotent, returns the base value to
 * persist for this transform. If a base value is returned, the transform
 * operation is always applied to this base value, even if document has
 * already been updated.
 *
 * Base values provide consistent behavior for non-idempotent transforms and
 * allow us to return the same latency-compensated value even if the backend
 * has already applied the transform operation. The base value is null for
 * idempotent transforms, as they can be re-played even if the backend has
 * already applied them.
 *
 * @return a base value to store along with the mutation, or null for
 * idempotent transforms.
 */ function qe(t, e) {
    return t instanceof Qe ? ue(n = e) || function(t) {
        return !!t && "doubleValue" in t;
    }(n) ? e : {
        integerValue: 0
    } : null;
    var n;
}

/** Transforms a value into a server-generated timestamp. */ var Fe = /** @class */ function(e) {
    function n() {
        return null !== e && e.apply(this, arguments) || this;
    }
    return t.__extends(n, e), n;
}(Ce), Be = /** @class */ function(e) {
    function n(t) {
        var n = this;
        return (n = e.call(this) || this).elements = t, n;
    }
    return t.__extends(n, e), n;
}(Ce);

/** Transforms an array value via a union operation. */ function Ge(t, e) {
    for (var n = Xe(e), r = function(t) {
        n.some((function(e) {
            return Jt(e, t);
        })) || n.push(t);
    }, i = 0, o = t.elements; i < o.length; i++) {
        r(o[i]);
    }
    return {
        arrayValue: {
            values: n
        }
    };
}

/** Transforms an array value via a remove operation. */ var ze = /** @class */ function(e) {
    function n(t) {
        var n = this;
        return (n = e.call(this) || this).elements = t, n;
    }
    return t.__extends(n, e), n;
}(Ce);

function We(t, e) {
    for (var n = Xe(e), r = function(t) {
        n = n.filter((function(e) {
            return !Jt(e, t);
        }));
    }, i = 0, o = t.elements; i < o.length; i++) {
        r(o[i]);
    }
    return {
        arrayValue: {
            values: n
        }
    };
}

/**
 * Implements the backend semantics for locally computed NUMERIC_ADD (increment)
 * transforms. Converts all field values to integers or doubles, but unlike the
 * backend does not cap integer values at 2^63. Instead, JavaScript number
 * arithmetic is used and precision loss can occur for values greater than 2^53.
 */ var Qe = /** @class */ function(e) {
    function n(t, n) {
        var r = this;
        return (r = e.call(this) || this).serializer = t, r.We = n, r;
    }
    return t.__extends(n, e), n;
}(Ce);

function Ke(t) {
    return ie(t.integerValue || t.doubleValue);
}

function Xe(t) {
    return ae(t) && t.arrayValue.values ? t.arrayValue.values.slice() : [];
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Provides a set of fields that can be used to partially patch a document.
 * FieldMask is used in conjunction with ObjectValue.
 * Examples:
 *   foo - Overwrites foo entirely with the provided value. If foo is not
 *         present in the companion ObjectValue, the field is deleted.
 *   foo.bar - Overwrites only the field bar of the object foo.
 *             If foo is not an object, foo is replaced with an object
 *             containing foo
 */ var He = /** @class */ function() {
    function t(t) {
        this.fields = t, 
        // TODO(dimond): validation of FieldMask
        // Sort the field mask to support `FieldMask.isEqual()` and assert below.
        t.sort(N.i)
        /**
     * Verifies that `fieldPath` is included by at least one field in this field
     * mask.
     *
     * This is an O(n) operation, where `n` is the size of the field mask.
     */;
    }
    return t.prototype.He = function(t) {
        for (var e = 0, n = this.fields; e < n.length; e++) {
            if (n[e].T(t)) return !0;
        }
        return !1;
    }, t.prototype.isEqual = function(t) {
        return H(this.fields, t.fields, (function(t, e) {
            return t.isEqual(e);
        }));
    }, t;
}(), Ye = function(t, e) {
    this.field = t, this.transform = e;
};

/** A field path and the TransformOperation to perform upon it. */
/** The result of successfully applying a mutation to the backend. */ var Je = function(
/**
     * The version at which the mutation was committed:
     *
     * - For most operations, this is the updateTime in the WriteResult.
     * - For deletes, the commitTime of the WriteResponse (because deletes are
     *   not stored and have no updateTime).
     *
     * Note that these versions can be different: No-op writes will not change
     * the updateTime even though the commitTime advances.
     */
t, 
/**
     * The resulting fields returned from the backend after a
     * TransformMutation has been committed. Contains one FieldValue for each
     * FieldTransform that was in the mutation.
     *
     * Will be null if the mutation was not a TransformMutation.
     */
e) {
    this.version = t, this.transformResults = e;
}, $e = /** @class */ function() {
    function t(t, e) {
        this.updateTime = t, this.exists = e
        /** Creates a new empty Precondition. */;
    }
    return t.Ye = function() {
        return new t;
    }, 
    /** Creates a new Precondition with an exists flag. */ t.exists = function(e) {
        return new t(void 0, e);
    }, 
    /** Creates a new Precondition based on a version a document exists at. */ t.updateTime = function(e) {
        return new t(e);
    }, Object.defineProperty(t.prototype, "Ge", {
        /** Returns whether this Precondition is empty. */ get: function() {
            return void 0 === this.updateTime && void 0 === this.exists;
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.isEqual = function(t) {
        return this.exists === t.exists && (this.updateTime ? !!t.updateTime && this.updateTime.isEqual(t.updateTime) : !t.updateTime);
    }, t;
}();

/**
 * Encodes a precondition for a mutation. This follows the model that the
 * backend accepts with the special case of an explicit "empty" precondition
 * (meaning no precondition).
 */
/**
 * Returns true if the preconditions is valid for the given document
 * (or null if no document is available).
 */
function Ze(t, e) {
    return void 0 !== t.updateTime ? e instanceof wn && e.version.isEqual(t.updateTime) : void 0 === t.exists || t.exists === e instanceof wn;
}

/**
 * A mutation describes a self-contained change to a document. Mutations can
 * create, replace, delete, and update subsets of documents.
 *
 * Mutations not only act on the value of the document but also its version.
 *
 * For local mutations (mutations that haven't been committed yet), we preserve
 * the existing version for Set, Patch, and Transform mutations. For Delete
 * mutations, we reset the version to 0.
 *
 * Here's the expected transition table.
 *
 * MUTATION           APPLIED TO            RESULTS IN
 *
 * SetMutation        Document(v3)          Document(v3)
 * SetMutation        NoDocument(v3)        Document(v0)
 * SetMutation        null                  Document(v0)
 * PatchMutation      Document(v3)          Document(v3)
 * PatchMutation      NoDocument(v3)        NoDocument(v3)
 * PatchMutation      null                  null
 * TransformMutation  Document(v3)          Document(v3)
 * TransformMutation  NoDocument(v3)        NoDocument(v3)
 * TransformMutation  null                  null
 * DeleteMutation     Document(v3)          NoDocument(v0)
 * DeleteMutation     NoDocument(v3)        NoDocument(v0)
 * DeleteMutation     null                  NoDocument(v0)
 *
 * For acknowledged mutations, we use the updateTime of the WriteResponse as
 * the resulting version for Set, Patch, and Transform mutations. As deletes
 * have no explicit update time, we use the commitTime of the WriteResponse for
 * Delete mutations.
 *
 * If a mutation is acknowledged by the backend but fails the precondition check
 * locally, we return an `UnknownDocument` and rely on Watch to send us the
 * updated version.
 *
 * Note that TransformMutations don't create Documents (in the case of being
 * applied to a NoDocument), even though they would on the backend. This is
 * because the client always combines the TransformMutation with a SetMutation
 * or PatchMutation and we only want to apply the transform if the prior
 * mutation resulted in a Document (always true for a SetMutation, but not
 * necessarily for a PatchMutation).
 *
 * ## Subclassing Notes
 *
 * Subclasses of Mutation need to implement applyToRemoteDocument() and
 * applyToLocalView() to implement the actual behavior of applying the mutation
 * to some source document.
 */ var tn = function() {};

/**
 * Applies this mutation to the given MaybeDocument or null for the purposes
 * of computing a new remote document. If the input document doesn't match the
 * expected state (e.g. it is null or outdated), an `UnknownDocument` can be
 * returned.
 *
 * @param mutation The mutation to apply.
 * @param maybeDoc The document to mutate. The input document can be null if
 *     the client has no knowledge of the pre-mutation state of the document.
 * @param mutationResult The result of applying the mutation from the backend.
 * @return The mutated document. The returned document may be an
 *     UnknownDocument if the mutation could not be applied to the locally
 *     cached base document.
 */ function en(t, e, n) {
    return t instanceof un ? function(t, e, n) {
        // Unlike applySetMutationToLocalView, if we're applying a mutation to a
        // remote document the server has accepted the mutation so the precondition
        // must have held.
        return new wn(t.key, n.version, t.value, {
            hasCommittedMutations: !0
        });
    }(t, 0, n) : t instanceof an ? function(t, e, n) {
        if (!Ze(t.ze, e)) 
        // Since the mutation was not rejected, we know that the  precondition
        // matched on the backend. We therefore must not have the expected version
        // of the document in our cache and return an UnknownDocument with the
        // known updateTime.
        return new En(t.key, n.version);
        var r = cn(t, e);
        return new wn(t.key, n.version, r, {
            hasCommittedMutations: !0
        });
    }(t, e, n) : t instanceof hn ? function(t, e, n) {
        if (g(null != n.transformResults), !Ze(t.ze, e)) 
        // Since the mutation was not rejected, we know that the  precondition
        // matched on the backend. We therefore must not have the expected version
        // of the document in our cache and return an UnknownDocument with the
        // known updateTime.
        return new En(t.key, n.version);
        var r = fn(t, e), i = 
        /**
 * Creates a list of "transform results" (a transform result is a field value
 * representing the result of applying a transform) for use after a
 * TransformMutation has been acknowledged by the server.
 *
 * @param fieldTransforms The field transforms to apply the result to.
 * @param baseDoc The document prior to applying this mutation batch.
 * @param serverTransformResults The transform results received by the server.
 * @return The transform results list.
 */
        function(t, e, n) {
            var r = [];
            g(t.length === n.length);
            for (var i = 0; i < n.length; i++) {
                var o = t[i], s = o.transform, u = null;
                e instanceof wn && (u = e.field(o.field)), r.push(xe(s, u, n[i]));
            }
            return r;
        }(t.fieldTransforms, e, n.transformResults), o = n.version, s = ln(t, r.data(), i);
        return new wn(t.key, o, s, {
            hasCommittedMutations: !0
        });
    }(t, e, n) : function(t, e, n) {
        // Unlike applyToLocalView, if we're applying a mutation to a remote
        // document the server has accepted the mutation so the precondition must
        // have held.
        return new bn(t.key, n.version, {
            hasCommittedMutations: !0
        });
    }(t, 0, n);
}

/**
 * Applies this mutation to the given MaybeDocument or null for the purposes
 * of computing the new local view of a document. Both the input and returned
 * documents can be null.
 *
 * @param mutation The mutation to apply.
 * @param maybeDoc The document to mutate. The input document can be null if
 *     the client has no knowledge of the pre-mutation state of the document.
 * @param baseDoc The state of the document prior to this mutation batch. The
 *     input document can be null if the client has no knowledge of the
 *     pre-mutation state of the document.
 * @param localWriteTime A timestamp indicating the local write time of the
 *     batch this mutation is a part of.
 * @return The mutated document. The returned document may be null, but only
 *     if maybeDoc was null and the mutation would not create a new document.
 */ function nn(t, e, n, r) {
    return t instanceof un ? function(t, e) {
        if (!Ze(t.ze, e)) return e;
        var n = sn(e);
        return new wn(t.key, n, t.value, {
            Je: !0
        });
    }(t, e) : t instanceof an ? function(t, e) {
        if (!Ze(t.ze, e)) return e;
        var n = sn(e), r = cn(t, e);
        return new wn(t.key, n, r, {
            Je: !0
        });
    }(t, e) : t instanceof hn ? function(t, e, n, r) {
        if (!Ze(t.ze, e)) return e;
        var i = fn(t, e), o = function(t, e, n, r) {
            for (var i = [], o = 0, s = t; o < s.length; o++) {
                var u = s[o], a = u.transform, c = null;
                n instanceof wn && (c = n.field(u.field)), null === c && r instanceof wn && (
                // If the current document does not contain a value for the mutated
                // field, use the value that existed before applying this mutation
                // batch. This solves an edge case where a PatchMutation clears the
                // values in a nested map before the TransformMutation is applied.
                c = r.field(u.field)), i.push(Me(a, c, e));
            }
            return i;
        }(t.fieldTransforms, n, e, r), s = ln(t, i.data(), o);
        return new wn(t.key, i.version, s, {
            Je: !0
        });
    }(t, e, r, n) : function(t, e) {
        return Ze(t.ze, e) ? new bn(t.key, ot.min()) : e;
    }(t, e);
}

/**
 * If this mutation is not idempotent, returns the base value to persist with
 * this mutation. If a base value is returned, the mutation is always applied
 * to this base value, even if document has already been updated.
 *
 * The base value is a sparse object that consists of only the document
 * fields for which this mutation contains a non-idempotent transformation
 * (e.g. a numeric increment). The provided value guarantees consistent
 * behavior for non-idempotent transforms and allow us to return the same
 * latency-compensated value even if the backend has already applied the
 * mutation. The base value is null for idempotent mutations, as they can be
 * re-played even if the backend has already applied them.
 *
 * @return a base value to store along with the mutation, or null for
 * idempotent mutations.
 */ function rn(t, e) {
    return t instanceof hn ? function(t, e) {
        for (var n = null, r = 0, i = t.fieldTransforms; r < i.length; r++) {
            var o = i[r], s = e instanceof wn ? e.field(o.field) : void 0, u = qe(o.transform, s || null);
            null != u && (n = null == n ? (new yn).set(o.field, u) : n.set(o.field, u));
        }
        return n ? n.Xe() : null;
    }(t, e) : null;
}

function on(t, e) {
    return t.type === e.type && !!t.key.isEqual(e.key) && !!t.ze.isEqual(e.ze) && (0 /* Set */ === t.type ? t.value.isEqual(e.value) : 1 /* Patch */ === t.type ? t.data.isEqual(e.data) && t.je.isEqual(e.je) : 2 /* Transform */ !== t.type || H(t.fieldTransforms, t.fieldTransforms, (function(t, e) {
        return function(t, e) {
            return t.field.isEqual(e.field) && function(t, e) {
                return t instanceof Be && e instanceof Be || t instanceof ze && e instanceof ze ? H(t.elements, e.elements, Jt) : t instanceof Qe && e instanceof Qe ? Jt(t.We, e.We) : t instanceof Fe && e instanceof Fe;
            }(t.transform, e.transform);
        }(t, e);
    })));
}

/**
 * Returns the version from the given document for use as the result of a
 * mutation. Mutations are defined to return the version of the base document
 * only if it is an existing document. Deleted and unknown documents have a
 * post-mutation version of SnapshotVersion.min().
 */ function sn(t) {
    return t instanceof wn ? t.version : ot.min();
}

/**
 * A mutation that creates or replaces the document at the given key with the
 * object value contents.
 */ var un = /** @class */ function(e) {
    function n(t, n, r) {
        var i = this;
        return (i = e.call(this) || this).key = t, i.value = n, i.ze = r, i.type = 0 /* Set */ , 
        i;
    }
    return t.__extends(n, e), n;
}(tn), an = /** @class */ function(e) {
    function n(t, n, r, i) {
        var o = this;
        return (o = e.call(this) || this).key = t, o.data = n, o.je = r, o.ze = i, o.type = 1 /* Patch */ , 
        o;
    }
    return t.__extends(n, e), n;
}(tn);

function cn(t, e) {
    return function(t, e) {
        var n = new yn(e);
        return t.je.fields.forEach((function(e) {
            if (!e.m()) {
                var r = t.data.field(e);
                null !== r ? n.set(e, r) : n.delete(e);
            }
        })), n.Xe();
    }(t, e instanceof wn ? e.data() : vn.empty());
}

var hn = /** @class */ function(e) {
    function n(t, n) {
        var r = this;
        return (r = e.call(this) || this).key = t, r.fieldTransforms = n, r.type = 2 /* Transform */ , 
        // NOTE: We set a precondition of exists: true as a safety-check, since we
        // always combine TransformMutations with a SetMutation or PatchMutation which
        // (if successful) should end up with an existing document.
        r.ze = $e.exists(!0), r;
    }
    return t.__extends(n, e), n;
}(tn);

function fn(t, e) {
    return e;
}

function ln(t, e, n) {
    for (var r = new yn(e), i = 0; i < t.fieldTransforms.length; i++) {
        var o = t.fieldTransforms[i];
        r.set(o.field, n[i]);
    }
    return r.Xe();
}

/** A mutation that deletes the document at the given key. */ var pn = /** @class */ function(e) {
    function n(t, n) {
        var r = this;
        return (r = e.call(this) || this).key = t, r.ze = n, r.type = 3 /* Delete */ , r;
    }
    return t.__extends(n, e), n;
}(tn), dn = /** @class */ function(e) {
    function n(t, n) {
        var r = this;
        return (r = e.call(this) || this).key = t, r.ze = n, r.type = 4 /* Verify */ , r;
    }
    return t.__extends(n, e), n;
}(tn), vn = /** @class */ function() {
    function t(t) {
        this.proto = t;
    }
    return t.empty = function() {
        return new t({
            mapValue: {}
        });
    }, 
    /**
     * Returns the value at the given path or null.
     *
     * @param path the path to search
     * @return The value at the path or if there it doesn't exist.
     */
    t.prototype.field = function(t) {
        if (t.m()) return this.proto;
        for (var e = this.proto, n = 0; n < t.length - 1; ++n) {
            if (!e.mapValue.fields) return null;
            if (!fe(e = e.mapValue.fields[t.get(n)])) return null;
        }
        return (e = (e.mapValue.fields || {})[t._()]) || null;
    }, t.prototype.isEqual = function(t) {
        return Jt(this.proto, t.proto);
    }, t;
}(), yn = /** @class */ function() {
    /**
     * @param baseObject The object to mutate.
     */
    function t(t) {
        void 0 === t && (t = vn.empty()), this.Ze = t, 
        /** A map that contains the accumulated changes in this builder. */
        this.tn = new Map;
    }
    /**
     * Sets the field to the provided value.
     *
     * @param path The field path to set.
     * @param value The value to set.
     * @return The current Builder instance.
     */    return t.prototype.set = function(t, e) {
        return this.en(t, e), this;
    }, 
    /**
     * Removes the field at the specified path. If there is no field at the
     * specified path, nothing is changed.
     *
     * @param path The field path to remove.
     * @return The current Builder instance.
     */
    t.prototype.delete = function(t) {
        return this.en(t, null), this;
    }, 
    /**
     * Adds `value` to the overlay map at `path`. Creates nested map entries if
     * needed.
     */
    t.prototype.en = function(t, e) {
        for (var n = this.tn, r = 0; r < t.length - 1; ++r) {
            var i = t.get(r), o = n.get(i);
            o instanceof Map ? 
            // Re-use a previously created map
            n = o : o && 10 /* ObjectValue */ === Yt(o) ? (
            // Convert the existing Protobuf MapValue into a map
            o = new Map(Object.entries(o.mapValue.fields || {})), n.set(i, o), n = o) : (
            // Create an empty map to represent the current nesting level
            o = new Map, n.set(i, o), n = o);
        }
        n.set(t._(), e);
    }, 
    /** Returns an ObjectValue with all mutations applied. */ t.prototype.Xe = function() {
        var t = this.nn(N.g(), this.tn);
        return null != t ? new vn(t) : this.Ze;
    }, 
    /**
     * Applies any overlays from `currentOverlays` that exist at `currentPath`
     * and returns the merged data at `currentPath` (or null if there were no
     * changes).
     *
     * @param currentPath The path at the current nesting level. Can be set to
     * FieldValue.emptyPath() to represent the root.
     * @param currentOverlays The overlays at the current nesting level in the
     * same format as `overlayMap`.
     * @return The merged data at `currentPath` or null if no modifications
     * were applied.
     */
    t.prototype.nn = function(t, e) {
        var n = this, r = !1, i = this.Ze.field(t), o = fe(i) ? // If there is already data at the current path, base our
        Object.assign({}, i.mapValue.fields) : {};
        return e.forEach((function(e, i) {
            if (e instanceof Map) {
                var s = n.nn(t.child(i), e);
                null != s && (o[i] = s, r = !0);
            } else null !== e ? (o[i] = e, r = !0) : o.hasOwnProperty(i) && (delete o[i], r = !0);
        })), r ? {
            mapValue: {
                fields: o
            }
        } : null;
    }, t;
}();

/**
 * Returns a FieldMask built from all fields in a MapValue.
 */
function gn(t) {
    var e = [];
    return b(t.fields || {}, (function(t, n) {
        var r = new N([ t ]);
        if (fe(n)) {
            var i = gn(n.mapValue).fields;
            if (0 === i.length) 
            // Preserve the empty map by adding it to the FieldMask.
            e.push(r); else 
            // For nested and non-empty ObjectValues, add the FieldPath of the
            // leaf nodes.
            for (var o = 0, s = i; o < s.length; o++) {
                var u = s[o];
                e.push(r.child(u));
            }
        } else 
        // For nested and non-empty ObjectValues, add the FieldPath of the leaf
        // nodes.
        e.push(r);
    })), new He(e)
    /**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
    /**
 * The result of a lookup for a given path may be an existing document or a
 * marker that this document does not exist at a given version.
 */;
}

var mn = function(t, e) {
    this.key = t, this.version = e;
}, wn = /** @class */ function(e) {
    function n(t, n, r, i) {
        var o = this;
        return (o = e.call(this, t, n) || this).sn = r, o.Je = !!i.Je, o.hasCommittedMutations = !!i.hasCommittedMutations, 
        o;
    }
    return t.__extends(n, e), n.prototype.field = function(t) {
        return this.sn.field(t);
    }, n.prototype.data = function() {
        return this.sn;
    }, n.prototype.rn = function() {
        return this.sn.proto;
    }, n.prototype.isEqual = function(t) {
        return t instanceof n && this.key.isEqual(t.key) && this.version.isEqual(t.version) && this.Je === t.Je && this.hasCommittedMutations === t.hasCommittedMutations && this.sn.isEqual(t.sn);
    }, n.prototype.toString = function() {
        return "Document(" + this.key + ", " + this.version + ", " + this.sn.toString() + ", {hasLocalMutations: " + this.Je + "}), {hasCommittedMutations: " + this.hasCommittedMutations + "})";
    }, Object.defineProperty(n.prototype, "hasPendingWrites", {
        get: function() {
            return this.Je || this.hasCommittedMutations;
        },
        enumerable: !1,
        configurable: !0
    }), n;
}(mn), bn = /** @class */ function(e) {
    function n(t, n, r) {
        var i = this;
        return (i = e.call(this, t, n) || this).hasCommittedMutations = !(!r || !r.hasCommittedMutations), 
        i;
    }
    return t.__extends(n, e), n.prototype.toString = function() {
        return "NoDocument(" + this.key + ", " + this.version + ")";
    }, Object.defineProperty(n.prototype, "hasPendingWrites", {
        get: function() {
            return this.hasCommittedMutations;
        },
        enumerable: !1,
        configurable: !0
    }), n.prototype.isEqual = function(t) {
        return t instanceof n && t.hasCommittedMutations === this.hasCommittedMutations && t.version.isEqual(this.version) && t.key.isEqual(this.key);
    }, n;
}(mn), En = /** @class */ function(e) {
    function n() {
        return null !== e && e.apply(this, arguments) || this;
    }
    return t.__extends(n, e), n.prototype.toString = function() {
        return "UnknownDocument(" + this.key + ", " + this.version + ")";
    }, Object.defineProperty(n.prototype, "hasPendingWrites", {
        get: function() {
            return !0;
        },
        enumerable: !1,
        configurable: !0
    }), n.prototype.isEqual = function(t) {
        return t instanceof n && t.version.isEqual(this.version) && t.key.isEqual(this.key);
    }, n;
}(mn), _n = 
/**
     * Initializes a Query with a path and optional additional query constraints.
     * Path must currently be empty if this is a collection group query.
     */
function(t, e, n, r, i, o /* First */ , s, u) {
    void 0 === e && (e = null), void 0 === n && (n = []), void 0 === r && (r = []), 
    void 0 === i && (i = null), void 0 === o && (o = "F"), void 0 === s && (s = null), 
    void 0 === u && (u = null), this.path = t, this.collectionGroup = e, this.on = n, 
    this.filters = r, this.limit = i, this.un = o, this.startAt = s, this.endAt = u, 
    this.cn = null, 
    // The corresponding `Target` of this `Query` instance.
    this.an = null, this.startAt, this.endAt;
};

/**
 * Represents a document in Firestore with a key, version, data and whether the
 * data has local mutations applied to it.
 */
/** Creates a new Query for a query that matches all documents at `path` */ function In(t) {
    return new _n(t);
}

/**
 * Helper to convert a collection group query into a collection query at a
 * specific path. This is used when executing collection group queries, since
 * we have to split the query into a set of collection queries at multiple
 * paths.
 */ function An(t) {
    return !st(t.limit) && "F" /* First */ === t.un;
}

function Nn(t) {
    return !st(t.limit) && "L" /* Last */ === t.un;
}

function Tn(t) {
    return t.on.length > 0 ? t.on[0].field : null;
}

function Dn(t) {
    for (var e = 0, n = t.filters; e < n.length; e++) {
        var r = n[e];
        if (r.hn()) return r.field;
    }
    return null;
}

/**
 * Checks if any of the provided Operators are included in the query and
 * returns the first one that is, or null if none are.
 */
/**
 * Returns whether the query matches a collection group rather than a specific
 * collection.
 */ function Vn(t) {
    return null !== t.collectionGroup;
}

/**
 * Returns the implicit order by constraint that is used to execute the Query,
 * which can be different from the order by constraints the user provided (e.g.
 * the SDK and backend always orders by `__name__`).
 */ function Rn(t) {
    var e = m(t);
    if (null === e.cn) {
        e.cn = [];
        var n = Dn(e), r = Tn(e);
        if (null !== n && null === r) 
        // In order to implicitly add key ordering, we must also add the
        // inequality filter field for it to be a valid query.
        // Note that the default inequality field and key ordering is ascending.
        n.V() || e.cn.push(new $n(n)), e.cn.push(new $n(N.v(), "asc" /* ASCENDING */)); else {
            for (var i = !1, o = 0, s = e.on; o < s.length; o++) {
                var u = s[o];
                e.cn.push(u), u.field.V() && (i = !0);
            }
            if (!i) {
                // The order of the implicit key ordering always matches the last
                // explicit order by
                var a = e.on.length > 0 ? e.on[e.on.length - 1].dir : "asc" /* ASCENDING */;
                e.cn.push(new $n(N.v(), a));
            }
        }
    }
    return e.cn;
}

/**
 * Converts this `Query` instance to it's corresponding `Target` representation.
 */ function Ln(t) {
    var e = m(t);
    if (!e.an) if ("F" /* First */ === e.un) e.an = ct(e.path, e.collectionGroup, Rn(e), e.filters, e.limit, e.startAt, e.endAt); else {
        for (
        // Flip the orderBy directions since we want the last results
        var n = [], r = 0, i = Rn(e); r < i.length; r++) {
            var o = i[r], s = "desc" /* DESCENDING */ === o.dir ? "asc" /* ASCENDING */ : "desc" /* DESCENDING */;
            n.push(new $n(o.field, s));
        }
        // We need to swap the cursors to match the now-flipped query ordering.
                var u = e.endAt ? new Xn(e.endAt.position, !e.endAt.before) : null, a = e.startAt ? new Xn(e.startAt.position, !e.startAt.before) : null;
        // Now return as a LimitType.First query.
                e.an = ct(e.path, e.collectionGroup, n, e.filters, e.limit, u, a);
    }
    return e.an;
}

function Un(t, e, n) {
    return new _n(t.path, t.collectionGroup, t.on.slice(), t.filters.slice(), e, n, t.startAt, t.endAt);
}

function On(t, e) {
    return new _n(t.path, t.collectionGroup, t.on.slice(), t.filters.slice(), t.limit, t.un, e, t.endAt);
}

function Sn(t, e) {
    return new _n(t.path, t.collectionGroup, t.on.slice(), t.filters.slice(), t.limit, t.un, t.startAt, e);
}

function kn(t, e) {
    return ft(Ln(t), Ln(e)) && t.un === e.un;
}

// TODO(b/29183165): This is used to get a unique string from a query to, for
// example, use as a dictionary key, but the implementation is subject to
// collisions. Make it collision-free.
function jn(t) {
    return ht(Ln(t)) + "|lt:" + t.un;
}

function Pn(t) {
    return "Query(target=" + function(t) {
        var e = t.path.R();
        return null !== t.collectionGroup && (e += " collectionGroup=" + t.collectionGroup), 
        t.filters.length > 0 && (e += ", filters: [" + t.filters.map((function(t) {
            return (e = t).field.R() + " " + e.op + " " + ee(e.value);
            /** Returns a debug description for `filter`. */            var e;
            /** Filter that matches on key fields (i.e. '__name__'). */        })).join(", ") + "]"), 
        st(t.limit) || (e += ", limit: " + t.limit), t.orderBy.length > 0 && (e += ", orderBy: [" + t.orderBy.map((function(t) {
            return (e = t).field.R() + " (" + e.dir + ")";
            var e;
        })).join(", ") + "]"), t.startAt && (e += ", startAt: " + Hn(t.startAt)), t.endAt && (e += ", endAt: " + Hn(t.endAt)), 
        "Target(" + e + ")";
    }(Ln(t)) + "; limitType=" + t.un + ")";
}

/** Returns whether `doc` matches the constraints of `query`. */ function Cn(t, e) {
    return function(t, e) {
        var n = e.key.path;
        return null !== t.collectionGroup ? e.key.F(t.collectionGroup) && t.path.T(n) : T.N(t.path) ? t.path.isEqual(n) : t.path.I(n);
    }(t, e) && function(t, e) {
        for (var n = 0, r = t.on; n < r.length; n++) {
            var i = r[n];
            // order by key always matches
                        if (!i.field.V() && null === e.field(i.field)) return !1;
        }
        return !0;
    }(t, e) && function(t, e) {
        for (var n = 0, r = t.filters; n < r.length; n++) {
            if (!r[n].matches(e)) return !1;
        }
        return !0;
    }(t, e) && function(t, e) {
        return !(t.startAt && !Yn(t.startAt, Rn(t), e)) && (!t.endAt || !Yn(t.endAt, Rn(t), e));
    }(t, e);
}

function Mn(t) {
    return function(e, n) {
        for (var r = !1, i = 0, o = Rn(t); i < o.length; i++) {
            var s = o[i], u = Zn(s, e, n);
            if (0 !== u) return u;
            r = r || s.field.V();
        }
        return 0;
    };
}

var xn = /** @class */ function(e) {
    function n(t, n, r) {
        var i = this;
        return (i = e.call(this) || this).field = t, i.op = n, i.value = r, i;
    }
    /**
     * Creates a filter based on the provided arguments.
     */    return t.__extends(n, e), n.create = function(t, e, r) {
        if (t.V()) return "in" /* IN */ === e || "not-in" /* NOT_IN */ === e ? this.ln(t, e, r) : new qn(t, e, r);
        if (ce(r)) {
            if ("==" /* EQUAL */ !== e && "!=" /* NOT_EQUAL */ !== e) throw new c(a.INVALID_ARGUMENT, "Invalid query. Null only supports '==' and '!=' comparisons.");
            return new n(t, e, r);
        }
        if (he(r)) {
            if ("==" /* EQUAL */ !== e && "!=" /* NOT_EQUAL */ !== e) throw new c(a.INVALID_ARGUMENT, "Invalid query. NaN only supports '==' and '!=' comparisons.");
            return new n(t, e, r);
        }
        return "array-contains" /* ARRAY_CONTAINS */ === e ? new zn(t, r) : "in" /* IN */ === e ? new Wn(t, r) : "not-in" /* NOT_IN */ === e ? new Qn(t, r) : "array-contains-any" /* ARRAY_CONTAINS_ANY */ === e ? new Kn(t, r) : new n(t, e, r);
    }, n.ln = function(t, e, n) {
        return "in" /* IN */ === e ? new Fn(t, n) : new Bn(t, n);
    }, n.prototype.matches = function(t) {
        var e = t.field(this.field);
        // Types do not have to match in NOT_EQUAL filters.
                return "!=" /* NOT_EQUAL */ === this.op ? null !== e && this._n(Zt(e, this.value)) : null !== e && Yt(this.value) === Yt(e) && this._n(Zt(e, this.value));
        // Only compare types with matching backend order (such as double and int).
        }, n.prototype._n = function(t) {
        switch (this.op) {
          case "<" /* LESS_THAN */ :
            return t < 0;

          case "<=" /* LESS_THAN_OR_EQUAL */ :
            return t <= 0;

          case "==" /* EQUAL */ :
            return 0 === t;

          case "!=" /* NOT_EQUAL */ :
            return 0 !== t;

          case ">" /* GREATER_THAN */ :
            return t > 0;

          case ">=" /* GREATER_THAN_OR_EQUAL */ :
            return t >= 0;

          default:
            return y();
        }
    }, n.prototype.hn = function() {
        return [ "<" /* LESS_THAN */ , "<=" /* LESS_THAN_OR_EQUAL */ , ">" /* GREATER_THAN */ , ">=" /* GREATER_THAN_OR_EQUAL */ , "!=" /* NOT_EQUAL */ , "not-in" /* NOT_IN */ ].indexOf(this.op) >= 0;
    }, n;
}((function() {}));

var qn = /** @class */ function(e) {
    function n(t, n, r) {
        var i = this;
        return (i = e.call(this, t, n, r) || this).key = T.C(r.referenceValue), i;
    }
    return t.__extends(n, e), n.prototype.matches = function(t) {
        var e = T.i(t.key, this.key);
        return this._n(e);
    }, n;
}(xn), Fn = /** @class */ function(e) {
    function n(t, n) {
        var r = this;
        return (r = e.call(this, t, "in" /* IN */ , n) || this).keys = Gn("in" /* IN */ , n), 
        r;
    }
    return t.__extends(n, e), n.prototype.matches = function(t) {
        return this.keys.some((function(e) {
            return e.isEqual(t.key);
        }));
    }, n;
}(xn), Bn = /** @class */ function(e) {
    function n(t, n) {
        var r = this;
        return (r = e.call(this, t, "not-in" /* NOT_IN */ , n) || this).keys = Gn("not-in" /* NOT_IN */ , n), 
        r;
    }
    return t.__extends(n, e), n.prototype.matches = function(t) {
        return !this.keys.some((function(e) {
            return e.isEqual(t.key);
        }));
    }, n;
}(xn);

/** Filter that matches on key fields within an array. */ function Gn(t, e) {
    var n;
    return ((null === (n = e.arrayValue) || void 0 === n ? void 0 : n.values) || []).map((function(t) {
        return T.C(t.referenceValue);
    }));
}

/** A Filter that implements the array-contains operator. */ var zn = /** @class */ function(e) {
    function n(t, n) {
        return e.call(this, t, "array-contains" /* ARRAY_CONTAINS */ , n) || this;
    }
    return t.__extends(n, e), n.prototype.matches = function(t) {
        var e = t.field(this.field);
        return ae(e) && $t(e.arrayValue, this.value);
    }, n;
}(xn), Wn = /** @class */ function(e) {
    function n(t, n) {
        return e.call(this, t, "in" /* IN */ , n) || this;
    }
    return t.__extends(n, e), n.prototype.matches = function(t) {
        var e = t.field(this.field);
        return null !== e && $t(this.value.arrayValue, e);
    }, n;
}(xn), Qn = /** @class */ function(e) {
    function n(t, n) {
        return e.call(this, t, "not-in" /* NOT_IN */ , n) || this;
    }
    return t.__extends(n, e), n.prototype.matches = function(t) {
        if ($t(this.value.arrayValue, {
            nullValue: "NULL_VALUE"
        })) return !1;
        var e = t.field(this.field);
        return null !== e && !$t(this.value.arrayValue, e);
    }, n;
}(xn), Kn = /** @class */ function(e) {
    function n(t, n) {
        return e.call(this, t, "array-contains-any" /* ARRAY_CONTAINS_ANY */ , n) || this;
    }
    return t.__extends(n, e), n.prototype.matches = function(t) {
        var e = this, n = t.field(this.field);
        return !(!ae(n) || !n.arrayValue.values) && n.arrayValue.values.some((function(t) {
            return $t(e.value.arrayValue, t);
        }));
    }, n;
}(xn), Xn = function(t, e) {
    this.position = t, this.before = e;
};

/** A Filter that implements the IN operator. */ function Hn(t) {
    // TODO(b/29183165): Make this collision robust.
    return (t.before ? "b" : "a") + ":" + t.position.map((function(t) {
        return ee(t);
    })).join(",");
}

/**
 * Returns true if a document sorts before a bound using the provided sort
 * order.
 */ function Yn(t, e, n) {
    for (var r = 0, i = 0; i < t.position.length; i++) {
        var o = e[i], s = t.position[i];
        if (r = o.field.V() ? T.i(T.C(s.referenceValue), n.key) : Zt(s, n.field(o.field)), 
        "desc" /* DESCENDING */ === o.dir && (r *= -1), 0 !== r) break;
    }
    return t.before ? r <= 0 : r < 0;
}

function Jn(t, e) {
    if (null === t) return null === e;
    if (null === e) return !1;
    if (t.before !== e.before || t.position.length !== e.position.length) return !1;
    for (var n = 0; n < t.position.length; n++) if (!Jt(t.position[n], e.position[n])) return !1;
    return !0;
}

/**
 * An ordering on a field, in some Direction. Direction defaults to ASCENDING.
 */ var $n = function(t, e /* ASCENDING */) {
    void 0 === e && (e = "asc"), this.field = t, this.dir = e;
};

function Zn(t, e, n) {
    var r = t.field.V() ? T.i(e.key, n.key) : function(t, e, n) {
        var r = e.field(t), i = n.field(t);
        return null !== r && null !== i ? Zt(r, i) : y();
    }(t.field, e, n);
    switch (t.dir) {
      case "asc" /* ASCENDING */ :
        return r;

      case "desc" /* DESCENDING */ :
        return -1 * r;

      default:
        return y();
    }
}

function tr(t, e) {
    return t.dir === e.dir && t.field.isEqual(e.field);
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ var er = function() {
    var t = this;
    this.promise = new Promise((function(e, n) {
        t.resolve = e, t.reject = n;
    }));
}, nr = /** @class */ function() {
    function t(
    /**
     * The AsyncQueue to run backoff operations on.
     */
    t, 
    /**
     * The ID to use when scheduling backoff operations on the AsyncQueue.
     */
    e, 
    /**
     * The initial delay (used as the base delay on the first retry attempt).
     * Note that jitter will still be applied, so the actual delay could be as
     * little as 0.5*initialDelayMs.
     */
    n
    /**
     * The multiplier to use to determine the extended base delay after each
     * attempt.
     */ , r
    /**
     * The maximum base delay after which no further backoff is performed.
     * Note that jitter will still be applied, so the actual delay could be as
     * much as 1.5*maxDelayMs.
     */ , i) {
        void 0 === n && (n = 1e3), void 0 === r && (r = 1.5), void 0 === i && (i = 6e4), 
        this.fn = t, this.dn = e, this.wn = n, this.mn = r, this.Tn = i, this.En = 0, this.In = null, 
        /** The last backoff attempt, as epoch milliseconds. */
        this.An = Date.now(), this.reset();
    }
    /**
     * Resets the backoff delay.
     *
     * The very next backoffAndWait() will have no delay. If it is called again
     * (i.e. due to an error), initialDelayMs (plus jitter) will be used, and
     * subsequent ones will increase according to the backoffFactor.
     */    return t.prototype.reset = function() {
        this.En = 0;
    }, 
    /**
     * Resets the backoff delay to the maximum delay (e.g. for use after a
     * RESOURCE_EXHAUSTED error).
     */
    t.prototype.Rn = function() {
        this.En = this.Tn;
    }, 
    /**
     * Returns a promise that resolves after currentDelayMs, and increases the
     * delay for any subsequent attempts. If there was a pending backoff operation
     * already, it will be canceled.
     */
    t.prototype.yn = function(t) {
        var e = this;
        // Cancel any pending backoff operation.
                this.cancel();
        // First schedule using the current base (which may be 0 and should be
        // honored as such).
        var n = Math.floor(this.En + this.Pn()), r = Math.max(0, Date.now() - this.An), i = Math.max(0, n - r);
        // Guard against lastAttemptTime being in the future due to a clock change.
                i > 0 && l("ExponentialBackoff", "Backing off for " + i + " ms (base delay: " + this.En + " ms, delay with jitter: " + n + " ms, last attempt: " + r + " ms ago)"), 
        this.In = this.fn.gn(this.dn, i, (function() {
            return e.An = Date.now(), t();
        })), 
        // Apply backoff factor to determine next delay and ensure it is within
        // bounds.
        this.En *= this.mn, this.En < this.wn && (this.En = this.wn), this.En > this.Tn && (this.En = this.Tn);
    }, t.prototype.pn = function() {
        null !== this.In && (this.In.Vn(), this.In = null);
    }, t.prototype.cancel = function() {
        null !== this.In && (this.In.cancel(), this.In = null);
    }, 
    /** Returns a random value in the range [-currentBaseMs/2, currentBaseMs/2] */ t.prototype.Pn = function() {
        return (Math.random() - .5) * this.En;
    }, t;
}(), rr = /** @class */ function() {
    function t(t) {
        var e = this;
        // NOTE: next/catchCallback will always point to our own wrapper functions,
        // not the user's raw next() or catch() callbacks.
                this.vn = null, this.bn = null, 
        // When the operation resolves, we'll set result or error and mark isDone.
        this.result = void 0, this.error = void 0, this.Sn = !1, 
        // Set to true when .then() or .catch() are called and prevents additional
        // chaining.
        this.Dn = !1, t((function(t) {
            e.Sn = !0, e.result = t, e.vn && 
            // value should be defined unless T is Void, but we can't express
            // that in the type system.
            e.vn(t);
        }), (function(t) {
            e.Sn = !0, e.error = t, e.bn && e.bn(t);
        }));
    }
    return t.prototype.catch = function(t) {
        return this.next(void 0, t);
    }, t.prototype.next = function(e, n) {
        var r = this;
        return this.Dn && y(), this.Dn = !0, this.Sn ? this.error ? this.Cn(n, this.error) : this.Fn(e, this.result) : new t((function(t, i) {
            r.vn = function(n) {
                r.Fn(e, n).next(t, i);
            }, r.bn = function(e) {
                r.Cn(n, e).next(t, i);
            };
        }));
    }, t.prototype.Nn = function() {
        var t = this;
        return new Promise((function(e, n) {
            t.next(e, n);
        }));
    }, t.prototype.$n = function(e) {
        try {
            var n = e();
            return n instanceof t ? n : t.resolve(n);
        } catch (e) {
            return t.reject(e);
        }
    }, t.prototype.Fn = function(e, n) {
        return e ? this.$n((function() {
            return e(n);
        })) : t.resolve(n);
    }, t.prototype.Cn = function(e, n) {
        return e ? this.$n((function() {
            return e(n);
        })) : t.reject(n);
    }, t.resolve = function(e) {
        return new t((function(t, n) {
            t(e);
        }));
    }, t.reject = function(e) {
        return new t((function(t, n) {
            n(e);
        }));
    }, t.xn = function(
    // Accept all Promise types in waitFor().
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    e) {
        return new t((function(t, n) {
            var r = 0, i = 0, o = !1;
            e.forEach((function(e) {
                ++r, e.next((function() {
                    ++i, o && i === r && t();
                }), (function(t) {
                    return n(t);
                }));
            })), o = !0, i === r && t();
        }));
    }, 
    /**
     * Given an array of predicate functions that asynchronously evaluate to a
     * boolean, implements a short-circuiting `or` between the results. Predicates
     * will be evaluated until one of them returns `true`, then stop. The final
     * result will be whether any of them returned `true`.
     */
    t.kn = function(e) {
        for (var n = t.resolve(!1), r = function(e) {
            n = n.next((function(n) {
                return n ? t.resolve(n) : e();
            }));
        }, i = 0, o = e; i < o.length; i++) {
            r(o[i]);
        }
        return n;
    }, t.forEach = function(t, e) {
        var n = this, r = [];
        return t.forEach((function(t, i) {
            r.push(e.call(n, t, i));
        })), this.xn(r);
    }, t;
}();

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A helper for running delayed tasks following an exponential backoff curve
 * between attempts.
 *
 * Each delay is made up of a "base" delay which follows the exponential
 * backoff curve, and a +/- 50% "jitter" that is calculated and added to the
 * base delay. This prevents clients from accidentally synchronizing their
 * delays causing spikes of load to the backend.
 */
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** Verifies whether `e` is an IndexedDbTransactionError. */ function ir(t) {
    // Use name equality, as instanceof checks on errors don't work with errors
    // that wrap other errors.
    return "IndexedDbTransactionError" === t.name;
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** The Platform's 'document' implementation or null if not available. */ function or() {
    // `document` is not always available, e.g. in ReactNative and WebWorkers.
    // eslint-disable-next-line no-restricted-globals
    return "undefined" != typeof document ? document : null;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Represents an operation scheduled to be run in the future on an AsyncQueue.
 *
 * It is created via DelayedOperation.createAndSchedule().
 *
 * Supports cancellation (via cancel()) and early execution (via skipDelay()).
 *
 * Note: We implement `PromiseLike` instead of `Promise`, as the `Promise` type
 * in newer versions of TypeScript defines `finally`, which is not available in
 * IE.
 */ var sr = /** @class */ function() {
    function t(t, e, n, r, i) {
        this.On = t, this.dn = e, this.Ln = n, this.op = r, this.Mn = i, this.qn = new er, 
        this.then = this.qn.promise.then.bind(this.qn.promise), 
        // It's normal for the deferred promise to be canceled (due to cancellation)
        // and so we attach a dummy catch callback to avoid
        // 'UnhandledPromiseRejectionWarning' log spam.
        this.qn.promise.catch((function(t) {}))
        /**
     * Creates and returns a DelayedOperation that has been scheduled to be
     * executed on the provided asyncQueue after the provided delayMs.
     *
     * @param asyncQueue The queue to schedule the operation on.
     * @param id A Timer ID identifying the type of operation this is.
     * @param delayMs The delay (ms) before the operation should be scheduled.
     * @param op The operation to run.
     * @param removalCallback A callback to be called synchronously once the
     *   operation is executed or canceled, notifying the AsyncQueue to remove it
     *   from its delayedOperations list.
     *   PORTING NOTE: This exists to prevent making removeDelayedOperation() and
     *   the DelayedOperation class public.
     */;
    }
    return t.Un = function(e, n, r, i, o) {
        var s = new t(e, n, Date.now() + r, i, o);
        return s.start(r), s;
    }, 
    /**
     * Starts the timer. This is called immediately after construction by
     * createAndSchedule().
     */
    t.prototype.start = function(t) {
        var e = this;
        this.Bn = setTimeout((function() {
            return e.Qn();
        }), t);
    }, 
    /**
     * Queues the operation to run immediately (if it hasn't already been run or
     * canceled).
     */
    t.prototype.Vn = function() {
        return this.Qn();
    }, 
    /**
     * Cancels the operation if it hasn't already been executed or canceled. The
     * promise will be rejected.
     *
     * As long as the operation has not yet been run, calling cancel() provides a
     * guarantee that the operation will not be run.
     */
    t.prototype.cancel = function(t) {
        null !== this.Bn && (this.clearTimeout(), this.qn.reject(new c(a.CANCELLED, "Operation cancelled" + (t ? ": " + t : ""))));
    }, t.prototype.Qn = function() {
        var t = this;
        this.On.jn((function() {
            return null !== t.Bn ? (t.clearTimeout(), t.op().then((function(e) {
                return t.qn.resolve(e);
            }))) : Promise.resolve();
        }));
    }, t.prototype.clearTimeout = function() {
        null !== this.Bn && (this.Mn(this), clearTimeout(this.Bn), this.Bn = null);
    }, t;
}(), ur = /** @class */ function() {
    function e() {
        var t = this;
        // The last promise in the queue.
                this.Wn = Promise.resolve(), 
        // A list of retryable operations. Retryable operations are run in order and
        // retried with backoff.
        this.Gn = [], 
        // Is this AsyncQueue being shut down? Once it is set to true, it will not
        // be changed again.
        this.zn = !1, 
        // Operations scheduled to be queued in the future. Operations are
        // automatically removed after they are run or canceled.
        this.Kn = [], 
        // visible for testing
        this.Hn = null, 
        // Flag set while there's an outstanding AsyncQueue operation, used for
        // assertion sanity-checks.
        this.Yn = !1, 
        // List of TimerIds to fast-forward delays for.
        this.Jn = [], 
        // Backoff timer used to schedule retries for retryable operations
        this.Xn = new nr(this, "async_queue_retry" /* AsyncQueueRetry */), 
        // Visibility handler that triggers an immediate retry of all retryable
        // operations. Meant to speed up recovery when we regain file system access
        // after page comes into foreground.
        this.Zn = function() {
            var e = or();
            e && l("AsyncQueue", "Visibility state changed to  ", e.visibilityState), t.Xn.pn();
        };
        var e = or();
        e && "function" == typeof e.addEventListener && e.addEventListener("visibilitychange", this.Zn);
    }
    return Object.defineProperty(e.prototype, "ts", {
        // Is this AsyncQueue being shut down? If true, this instance will not enqueue
        // any new operations, Promises from enqueue requests will not resolve.
        get: function() {
            return this.zn;
        },
        enumerable: !1,
        configurable: !0
    }), 
    /**
     * Adds a new operation to the queue without waiting for it to complete (i.e.
     * we ignore the Promise result).
     */
    e.prototype.jn = function(t) {
        // eslint-disable-next-line @typescript-eslint/no-floating-promises
        this.enqueue(t);
    }, 
    /**
     * Regardless if the queue has initialized shutdown, adds a new operation to the
     * queue without waiting for it to complete (i.e. we ignore the Promise result).
     */
    e.prototype.es = function(t) {
        this.ns(), 
        // eslint-disable-next-line @typescript-eslint/no-floating-promises
        this.ss(t);
    }, 
    /**
     * Initialize the shutdown of this queue. Once this method is called, the
     * only possible way to request running an operation is through
     * `enqueueEvenWhileRestricted()`.
     */
    e.prototype.rs = function() {
        if (!this.zn) {
            this.zn = !0;
            var t = or();
            t && "function" == typeof t.removeEventListener && t.removeEventListener("visibilitychange", this.Zn);
        }
    }, 
    /**
     * Adds a new operation to the queue. Returns a promise that will be resolved
     * when the promise returned by the new operation is (with its value).
     */
    e.prototype.enqueue = function(t) {
        return this.ns(), this.zn ? new Promise((function(t) {})) : this.ss(t);
    }, 
    /**
     * Enqueue a retryable operation.
     *
     * A retryable operation is rescheduled with backoff if it fails with a
     * IndexedDbTransactionError (the error type used by SimpleDb). All
     * retryable operations are executed in order and only run if all prior
     * operations were retried successfully.
     */
    e.prototype.os = function(t) {
        var e = this;
        this.jn((function() {
            return e.Gn.push(t), e.us();
        }));
    }, 
    /**
     * Runs the next operation from the retryable queue. If the operation fails,
     * reschedules with backoff.
     */
    e.prototype.us = function() {
        return t.__awaiter(this, void 0, void 0, (function() {
            var e, n = this;
            return t.__generator(this, (function(t) {
                switch (t.label) {
                  case 0:
                    if (0 === this.Gn.length) return [ 3 /*break*/ , 5 ];
                    t.label = 1;

                  case 1:
                    return t.trys.push([ 1, 3, , 4 ]), [ 4 /*yield*/ , this.Gn[0]() ];

                  case 2:
                    return t.sent(), this.Gn.shift(), this.Xn.reset(), [ 3 /*break*/ , 4 ];

                  case 3:
                    if (!ir(e = t.sent())) throw e;
                    // Failure will be handled by AsyncQueue
                                        return l("AsyncQueue", "Operation failed with retryable error: " + e), 
                    [ 3 /*break*/ , 4 ];

                  case 4:
                    this.Gn.length > 0 && 
                    // If there are additional operations, we re-schedule `retryNextOp()`.
                    // This is necessary to run retryable operations that failed during
                    // their initial attempt since we don't know whether they are already
                    // enqueued. If, for example, `op1`, `op2`, `op3` are enqueued and `op1`
                    // needs to  be re-run, we will run `op1`, `op1`, `op2` using the
                    // already enqueued calls to `retryNextOp()`. `op3()` will then run in the
                    // call scheduled here.
                    // Since `backoffAndRun()` cancels an existing backoff and schedules a
                    // new backoff on every call, there is only ever a single additional
                    // operation in the queue.
                    this.Xn.yn((function() {
                        return n.us();
                    })), t.label = 5;

                  case 5:
                    return [ 2 /*return*/ ];
                }
            }));
        }));
    }, e.prototype.ss = function(t) {
        var e = this, n = this.Wn.then((function() {
            return e.Yn = !0, t().catch((function(t) {
                // Re-throw the error so that this.tail becomes a rejected Promise and
                // all further attempts to chain (via .then) will just short-circuit
                // and return the rejected Promise.
                throw e.Hn = t, e.Yn = !1, p("INTERNAL UNHANDLED ERROR: ", 
                /**
 * Chrome includes Error.message in Error.stack. Other browsers do not.
 * This returns expected output of message + stack when available.
 * @param error Error or FirestoreError
 */
                function(t) {
                    var e = t.message || "";
                    return t.stack && (e = t.stack.includes(t.message) ? t.stack : t.message + "\n" + t.stack), 
                    e;
                }(t)), t;
            })).then((function(t) {
                return e.Yn = !1, t;
            }));
        }));
        return this.Wn = n, n;
    }, 
    /**
     * Schedules an operation to be queued on the AsyncQueue once the specified
     * `delayMs` has elapsed. The returned DelayedOperation can be used to cancel
     * or fast-forward the operation prior to its running.
     */
    e.prototype.gn = function(t, e, n) {
        var r = this;
        this.ns(), 
        // Fast-forward delays for timerIds that have been overriden.
        this.Jn.indexOf(t) > -1 && (e = 0);
        var i = sr.Un(this, t, e, n, (function(t) {
            return r.cs(t);
        }));
        return this.Kn.push(i), i;
    }, e.prototype.ns = function() {
        this.Hn && y();
    }, 
    /**
     * Verifies there's an operation currently in-progress on the AsyncQueue.
     * Unfortunately we can't verify that the running code is in the promise chain
     * of that operation, so this isn't a foolproof check, but it should be enough
     * to catch some bugs.
     */
    e.prototype.hs = function() {}, 
    /**
     * Waits until all currently queued tasks are finished executing. Delayed
     * operations are not run.
     */
    e.prototype.ls = function() {
        return t.__awaiter(this, void 0, void 0, (function() {
            var e;
            return t.__generator(this, (function(t) {
                switch (t.label) {
                  case 0:
                    return [ 4 /*yield*/ , e = this.Wn ];

                  case 1:
                    t.sent(), t.label = 2;

                  case 2:
                    if (e !== this.Wn) return [ 3 /*break*/ , 0 ];
                    t.label = 3;

                  case 3:
                    return [ 2 /*return*/ ];
                }
            }));
        }));
    }, 
    /**
     * For Tests: Determine if a delayed operation with a particular TimerId
     * exists.
     */
    e.prototype._s = function(t) {
        for (var e = 0, n = this.Kn; e < n.length; e++) {
            if (n[e].dn === t) return !0;
        }
        return !1;
    }, 
    /**
     * For Tests: Runs some or all delayed operations early.
     *
     * @param lastTimerId Delayed operations up to and including this TimerId will
     *  be drained. Pass TimerId.All to run all delayed operations.
     * @returns a Promise that resolves once all operations have been run.
     */
    e.prototype.fs = function(t) {
        var e = this;
        // Note that draining may generate more delayed ops, so we do that first.
                return this.ls().then((function() {
            // Run ops in the same order they'd run if they ran naturally.
            e.Kn.sort((function(t, e) {
                return t.Ln - e.Ln;
            }));
            for (var n = 0, r = e.Kn; n < r.length; n++) {
                var i = r[n];
                if (i.Vn(), "all" /* All */ !== t && i.dn === t) break;
            }
            return e.ls();
        }));
    }, 
    /**
     * For Tests: Skip all subsequent delays for a timer id.
     */
    e.prototype.ds = function(t) {
        this.Jn.push(t);
    }, 
    /** Called once a DelayedOperation is run or canceled. */ e.prototype.cs = function(t) {
        // NOTE: indexOf / slice are O(n), but delayedOperations is expected to be small.
        var e = this.Kn.indexOf(t);
        this.Kn.splice(e, 1);
    }, e;
}();

/**
 * Returns a FirestoreError that can be surfaced to the user if the provided
 * error is an IndexedDbTransactionError. Re-throws the error otherwise.
 */
function ar(t, e) {
    if (p("AsyncQueue", e + ": " + t), ir(t)) return new c(a.UNAVAILABLE, e + ": " + t);
    throw t;
}

var cr = function() {
    this.ws = void 0, this.listeners = [];
}, hr = function() {
    this.Ts = new rt((function(t) {
        return jn(t);
    }), kn), this.onlineState = "Unknown" /* Unknown */ , this.Es = new Set;
};

function fr(e, n) {
    return t.__awaiter(this, void 0, void 0, (function() {
        var r, i, o, s, u, a, c;
        return t.__generator(this, (function(t) {
            switch (t.label) {
              case 0:
                if (r = m(e), i = n.query, o = !1, (s = r.Ts.get(i)) || (o = !0, s = new cr), !o) return [ 3 /*break*/ , 4 ];
                t.label = 1;

              case 1:
                return t.trys.push([ 1, 3, , 4 ]), u = s, [ 4 /*yield*/ , r.Is(i) ];

              case 2:
                return u.ws = t.sent(), [ 3 /*break*/ , 4 ];

              case 3:
                return a = t.sent(), c = ar(a, "Initialization of query '" + Pn(n.query) + "' failed"), 
                [ 2 /*return*/ , void n.onError(c) ];

              case 4:
                return r.Ts.set(i, s), s.listeners.push(n), 
                // Run global snapshot listeners if a consistent snapshot has been emitted.
                n.As(r.onlineState), s.ws && n.Rs(s.ws) && vr(r), [ 2 /*return*/ ];
            }
        }));
    }));
}

function lr(e, n) {
    return t.__awaiter(this, void 0, void 0, (function() {
        var r, i, o, s, u;
        return t.__generator(this, (function(t) {
            return r = m(e), i = n.query, o = !1, (s = r.Ts.get(i)) && (u = s.listeners.indexOf(n)) >= 0 && (s.listeners.splice(u, 1), 
            o = 0 === s.listeners.length), o ? [ 2 /*return*/ , (r.Ts.delete(i), r.ys(i)) ] : [ 2 /*return*/ ];
        }));
    }));
}

function pr(t, e) {
    for (var n = m(t), r = !1, i = 0, o = e; i < o.length; i++) {
        var s = o[i], u = s.query, a = n.Ts.get(u);
        if (a) {
            for (var c = 0, h = a.listeners; c < h.length; c++) {
                h[c].Rs(s) && (r = !0);
            }
            a.ws = s;
        }
    }
    r && vr(n);
}

function dr(t, e, n) {
    var r = m(t), i = r.Ts.get(e);
    if (i) for (var o = 0, s = i.listeners; o < s.length; o++) {
        s[o].onError(n);
    }
    // Remove all listeners. NOTE: We don't need to call syncEngine.unlisten()
    // after an error.
        r.Ts.delete(e);
}

// Call all global snapshot listeners that have been set.
function vr(t) {
    t.Es.forEach((function(t) {
        t.next();
    }));
}

/**
 * QueryListener takes a series of internal view snapshots and determines
 * when to raise the event.
 *
 * It uses an Observer to dispatch events.
 */ var yr = /** @class */ function() {
    function t(t, e, n) {
        this.query = t, this.Ps = e, 
        /**
             * Initial snapshots (e.g. from cache) may not be propagated to the wrapped
             * observer. This flag is set to true once we've actually raised an event.
             */
        this.gs = !1, this.ps = null, this.onlineState = "Unknown" /* Unknown */ , this.options = n || {}
        /**
     * Applies the new ViewSnapshot to this listener, raising a user-facing event
     * if applicable (depending on what changed, whether the user has opted into
     * metadata-only changes, etc.). Returns true if a user-facing event was
     * indeed raised.
     */;
    }
    return t.prototype.Rs = function(t) {
        if (!this.options.includeMetadataChanges) {
            for (
            // Remove the metadata only changes.
            var e = [], n = 0, r = t.docChanges; n < r.length; n++) {
                var i = r[n];
                3 /* Metadata */ !== i.type && e.push(i);
            }
            t = new Pt(t.query, t.docs, t.Qt, e, t.jt, t.fromCache, t.Wt, 
            /* excludesMetadataChanges= */ !0);
        }
        var o = !1;
        return this.gs ? this.Vs(t) && (this.Ps.next(t), o = !0) : this.vs(t, this.onlineState) && (this.bs(t), 
        o = !0), this.ps = t, o;
    }, t.prototype.onError = function(t) {
        this.Ps.error(t);
    }, 
    /** Returns whether a snapshot was raised. */ t.prototype.As = function(t) {
        this.onlineState = t;
        var e = !1;
        return this.ps && !this.gs && this.vs(this.ps, t) && (this.bs(this.ps), e = !0), 
        e;
    }, t.prototype.vs = function(t, e) {
        // Always raise the first event when we're synced
        if (!t.fromCache) return !0;
        // NOTE: We consider OnlineState.Unknown as online (it should become Offline
        // or Online if we wait long enough).
                var n = "Offline" /* Offline */ !== e;
        // Don't raise the event if we're online, aren't synced yet (checked
        // above) and are waiting for a sync.
                return !(this.options.Ss && n || t.docs.m() && "Offline" /* Offline */ !== e);
        // Raise data from cache if we have any documents or we are offline
        }, t.prototype.Vs = function(t) {
        // We don't need to handle includeDocumentMetadataChanges here because
        // the Metadata only changes have already been stripped out if needed.
        // At this point the only changes we will see are the ones we should
        // propagate.
        if (t.docChanges.length > 0) return !0;
        var e = this.ps && this.ps.hasPendingWrites !== t.hasPendingWrites;
        return !(!t.Wt && !e) && !0 === this.options.includeMetadataChanges;
        // Generally we should have hit one of the cases above, but it's possible
        // to get here if there were only metadata docChanges and they got
        // stripped out.
        }, t.prototype.bs = function(t) {
        t = Pt.zt(t.query, t.docs, t.jt, t.fromCache), this.gs = !0, this.Ps.next(t);
    }, t;
}(), gr = /** @class */ function() {
    function t(t) {
        this.uid = t;
    }
    return t.prototype.Ds = function() {
        return null != this.uid;
    }, 
    /**
     * Returns a key representing this user, suitable for inclusion in a
     * dictionary.
     */
    t.prototype.Cs = function() {
        return this.Ds() ? "uid:" + this.uid : "anonymous-user";
    }, t.prototype.isEqual = function(t) {
        return t.uid === this.uid;
    }, t;
}();

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Simple wrapper around a nullable UID. Mostly exists to make code more
 * readable.
 */
/** A user with a null UID. */ gr.UNAUTHENTICATED = new gr(null), 
// TODO(mikelehen): Look into getting a proper uid-equivalent for
// non-FirebaseAuth providers.
gr.Fs = new gr("google-credentials-uid"), gr.Ns = new gr("first-party-uid");

/**
 * @license
 * Copyright 2018 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * `ListenSequence` is a monotonic sequence. It is initialized with a minimum value to
 * exceed. All subsequent calls to next will return increasing values. If provided with a
 * `SequenceNumberSyncer`, it will additionally bump its next value when told of a new value, as
 * well as write out sequence numbers that it produces via `next()`.
 */
var mr = /** @class */ function() {
    function t(t, e) {
        var n = this;
        this.previousValue = t, e && (e.$s = function(t) {
            return n.xs(t);
        }, this.ks = function(t) {
            return e.Os(t);
        });
    }
    return t.prototype.xs = function(t) {
        return this.previousValue = Math.max(t, this.previousValue), this.previousValue;
    }, t.prototype.next = function() {
        var t = ++this.previousValue;
        return this.ks && this.ks(t), t;
    }, t;
}();

mr.Ls = -1;

/**
 * @license
 * Copyright 2018 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Metadata state of the local client. Unlike `RemoteClientState`, this class is
 * mutable and keeps track of all pending mutations, which allows us to
 * update the range of pending mutation batch IDs as new mutations are added or
 * removed.
 *
 * The data in `LocalClientState` is not read from WebStorage and instead
 * updated via its instance methods. The updated state can be serialized via
 * `toWebStorageJSON()`.
 */
// Visible for testing.
var wr = /** @class */ function() {
    function t() {
        this.activeTargetIds = St();
    }
    return t.prototype.Ms = function(t) {
        this.activeTargetIds = this.activeTargetIds.add(t);
    }, t.prototype.qs = function(t) {
        this.activeTargetIds = this.activeTargetIds.delete(t);
    }, 
    /**
     * Converts this entry into a JSON-encoded format we can use for WebStorage.
     * Does not encode `clientId` as it is part of the key in WebStorage.
     */
    t.prototype.Us = function() {
        var t = {
            activeTargetIds: this.activeTargetIds.A(),
            updateTimeMs: Date.now()
        };
        return JSON.stringify(t);
    }, t;
}(), br = /** @class */ function() {
    function t() {
        this.Bs = new wr, this.Qs = {}, this.js = null, this.$s = null;
    }
    return t.prototype.Ws = function(t) {
        // No op.
    }, t.prototype.Gs = function(t, e, n) {
        // No op.
    }, t.prototype.zs = function(t) {
        return this.Bs.Ms(t), this.Qs[t] || "not-current";
    }, t.prototype.Ks = function(t, e, n) {
        this.Qs[t] = e;
    }, t.prototype.Hs = function(t) {
        this.Bs.qs(t);
    }, t.prototype.Ys = function(t) {
        return this.Bs.activeTargetIds.has(t);
    }, t.prototype.Js = function(t) {
        delete this.Qs[t];
    }, t.prototype.Xs = function() {
        return this.Bs.activeTargetIds;
    }, t.prototype.Zs = function(t) {
        return this.Bs.activeTargetIds.has(t);
    }, t.prototype.start = function() {
        return this.Bs = new wr, Promise.resolve();
    }, t.prototype.ti = function(t, e, n) {
        // No op.
    }, t.prototype.ei = function(t) {
        // No op.
    }, t.prototype.ni = function() {}, t.prototype.Os = function(t) {}, t;
}(), Er = /** @class */ function() {
    /**
     * @param batchId The unique ID of this mutation batch.
     * @param localWriteTime The original write time of this mutation.
     * @param baseMutations Mutations that are used to populate the base
     * values when this mutation is applied locally. This can be used to locally
     * overwrite values that are persisted in the remote document cache. Base
     * mutations are never sent to the backend.
     * @param mutations The user-provided mutations in this mutation batch.
     * User-provided mutations are applied both locally and remotely on the
     * backend.
     */
    function t(t, e, n, r) {
        this.batchId = t, this.si = e, this.baseMutations = n, this.mutations = r
        /**
     * Applies all the mutations in this MutationBatch to the specified document
     * to create a new remote document
     *
     * @param docKey The key of the document to apply mutations to.
     * @param maybeDoc The document to apply mutations to.
     * @param batchResult The result of applying the MutationBatch to the
     * backend.
     */;
    }
    return t.prototype.ii = function(t, e, n) {
        for (var r = n.ri, i = 0; i < this.mutations.length; i++) {
            var o = this.mutations[i];
            o.key.isEqual(t) && (e = en(o, e, r[i]));
        }
        return e;
    }, 
    /**
     * Computes the local view of a document given all the mutations in this
     * batch.
     *
     * @param docKey The key of the document to apply mutations to.
     * @param maybeDoc The document to apply mutations to.
     */
    t.prototype.oi = function(t, e) {
        // First, apply the base state. This allows us to apply non-idempotent
        // transform against a consistent set of values.
        for (var n = 0, r = this.baseMutations; n < r.length; n++) {
            var i = r[n];
            i.key.isEqual(t) && (e = nn(i, e, e, this.si));
        }
        // Second, apply all user-provided mutations.
        for (var o = e, s = 0, u = this.mutations; s < u.length; s++) {
            var a = u[s];
            a.key.isEqual(t) && (e = nn(a, e, o, this.si));
        }
        return e;
    }, 
    /**
     * Computes the local view for all provided documents given the mutations in
     * this batch.
     */
    t.prototype.ui = function(t) {
        var e = this, n = t;
        // TODO(mrschmidt): This implementation is O(n^2). If we apply the mutations
        // directly (as done in `applyToLocalView()`), we can reduce the complexity
        // to O(n).
                return this.mutations.forEach((function(r) {
            var i = e.oi(r.key, t.get(r.key));
            i && (n = n.ot(r.key, i));
        })), n;
    }, t.prototype.keys = function() {
        return this.mutations.reduce((function(t, e) {
            return t.add(e.key);
        }), Ut());
    }, t.prototype.isEqual = function(t) {
        return this.batchId === t.batchId && H(this.mutations, t.mutations, (function(t, e) {
            return on(t, e);
        })) && H(this.baseMutations, t.baseMutations, (function(t, e) {
            return on(t, e);
        }));
    }, t;
}(), _r = /** @class */ function() {
    function t(t, e, n, 
    /**
     * A pre-computed mapping from each mutated document to the resulting
     * version.
     */
    r) {
        this.batch = t, this.ci = e, this.ri = n, this.ai = r
        /**
     * Creates a new MutationBatchResult for the given batch and results. There
     * must be one result for each mutation in the batch. This static factory
     * caches a document=>version mapping (docVersions).
     */;
    }
    return t.from = function(e, n, r) {
        g(e.mutations.length === r.length);
        for (var i = Rt, o = e.mutations, s = 0; s < o.length; s++) i = i.ot(o[s].key, r[s].version);
        return new t(e, n, r, i);
    }, t;
}(), Ir = /** @class */ function() {
    function t(t, e, n) {
        this.hi = t, this.li = e, this._i = n
        /**
     * Get the local view of the document identified by `key`.
     *
     * @return Local view of the document or null if we don't have any cached
     * state for it.
     */;
    }
    return t.prototype.fi = function(t, e) {
        var n = this;
        return this.li.di(t, e).next((function(r) {
            return n.wi(t, e, r);
        }));
    }, 
    /** Internal version of `getDocument` that allows reusing batches. */ t.prototype.wi = function(t, e, n) {
        return this.hi.mi(t, e).next((function(t) {
            for (var r = 0, i = n; r < i.length; r++) {
                t = i[r].oi(e, t);
            }
            return t;
        }));
    }, 
    // Returns the view of the given `docs` as they would appear after applying
    // all mutations in the given `batches`.
    t.prototype.Ti = function(t, e, n) {
        var r = Tt();
        return e.forEach((function(t, e) {
            for (var i = 0, o = n; i < o.length; i++) {
                e = o[i].oi(t, e);
            }
            r = r.ot(t, e);
        })), r;
    }, 
    /**
     * Gets the local view of the documents identified by `keys`.
     *
     * If we don't have cached state for a document in `keys`, a NoDocument will
     * be stored for that key in the resulting set.
     */
    t.prototype.Ei = function(t, e) {
        var n = this;
        return this.hi.getEntries(t, e).next((function(e) {
            return n.Ii(t, e);
        }));
    }, 
    /**
     * Similar to `getDocuments`, but creates the local view from the given
     * `baseDocs` without retrieving documents from the local store.
     */
    t.prototype.Ii = function(t, e) {
        var n = this;
        return this.li.Ai(t, e).next((function(r) {
            var i = n.Ti(t, e, r), o = Nt();
            return i.forEach((function(t, e) {
                // TODO(http://b/32275378): Don't conflate missing / deleted.
                e || (e = new bn(t, ot.min())), o = o.ot(t, e);
            })), o;
        }));
    }, 
    /**
     * Performs a query against the local view of all documents.
     *
     * @param transaction The persistence transaction.
     * @param query The query to match documents against.
     * @param sinceReadTime If not set to SnapshotVersion.min(), return only
     *     documents that have been read since this snapshot version (exclusive).
     */
    t.prototype.Ri = function(t, e, n) {
        /**
 * Returns whether the query matches a single document by path (rather than a
 * collection).
 */
        return function(t) {
            return T.N(t.path) && null === t.collectionGroup && 0 === t.filters.length;
        }(e) ? this.yi(t, e.path) : Vn(e) ? this.Pi(t, e, n) : this.gi(t, e, n);
    }, t.prototype.yi = function(t, e) {
        // Just do a simple document lookup.
        return this.fi(t, new T(e)).next((function(t) {
            var e = Vt();
            return t instanceof wn && (e = e.ot(t.key, t)), e;
        }));
    }, t.prototype.Pi = function(t, e, n) {
        var r = this, i = e.collectionGroup, o = Vt();
        return this._i.pi(t, i).next((function(s) {
            return rr.forEach(s, (function(s) {
                var u = function(t, e) {
                    return new _n(e, 
                    /*collectionGroup=*/ null, t.on.slice(), t.filters.slice(), t.limit, t.un, t.startAt, t.endAt);
                }(e, s.child(i));
                return r.gi(t, u, n).next((function(t) {
                    t.forEach((function(t, e) {
                        o = o.ot(t, e);
                    }));
                }));
            })).next((function() {
                return o;
            }));
        }));
    }, t.prototype.gi = function(t, e, n) {
        var r, i, o = this;
        // Query the remote documents and overlay mutations.
                return this.hi.Ri(t, e, n).next((function(n) {
            return r = n, o.li.Vi(t, e);
        })).next((function(e) {
            return i = e, o.vi(t, i, r).next((function(t) {
                r = t;
                for (var e = 0, n = i; e < n.length; e++) for (var o = n[e], s = 0, u = o.mutations; s < u.length; s++) {
                    var a = u[s], c = a.key, h = r.get(c), f = nn(a, h, h, o.si);
                    r = f instanceof wn ? r.ot(c, f) : r.remove(c);
                }
            }));
        })).next((function() {
            // Finally, filter out any documents that don't actually match
            // the query.
            return r.forEach((function(t, n) {
                Cn(e, n) || (r = r.remove(t));
            })), r;
        }));
    }, t.prototype.vi = function(t, e, n) {
        for (var r = Ut(), i = 0, o = e; i < o.length; i++) for (var s = 0, u = o[i].mutations; s < u.length; s++) {
            var a = u[s];
            a instanceof an && null === n.get(a.key) && (r = r.add(a.key));
        }
        var c = n;
        return this.hi.getEntries(t, r).next((function(t) {
            return t.forEach((function(t, e) {
                null !== e && e instanceof wn && (c = c.ot(t, e));
            })), c;
        }));
    }, t;
}(), Ar = /** @class */ function() {
    function t(t, e, n, r) {
        this.targetId = t, this.fromCache = e, this.bi = n, this.Si = r;
    }
    return t.Di = function(e, n) {
        for (var r = Ut(), i = Ut(), o = 0, s = n.docChanges; o < s.length; o++) {
            var u = s[o];
            switch (u.type) {
              case 0 /* Added */ :
                r = r.add(u.doc.key);
                break;

              case 1 /* Removed */ :
                i = i.add(u.doc.key);
                // do nothing
                        }
        }
        return new t(e, n.fromCache, r, i);
    }, t;
}(), Nr = /** @class */ function() {
    function t(
    // When we attempt to collect, we will only do so if the cache size is greater than this
    // threshold. Passing `COLLECTION_DISABLED` here will cause collection to always be skipped.
    t, 
    // The percentage of sequence numbers that we will attempt to collect
    e, 
    // A cap on the total number of sequence numbers that will be collected. This prevents
    // us from collecting a huge number of sequence numbers if the cache has grown very large.
    n) {
        this.Ci = t, this.Fi = e, this.Ni = n;
    }
    return t.$i = function(e) {
        return new t(e, t.xi, t.ki);
    }, t;
}();

/**
 * `MemorySharedClientState` is a simple implementation of SharedClientState for
 * clients using memory persistence. The state in this class remains fully
 * isolated and no synchronization is performed.
 */ Nr.Oi = -1, Nr.Li = 1048576, Nr.Mi = 41943040, Nr.xi = 10, Nr.ki = 1e3, Nr.qi = new Nr(Nr.Mi, Nr.xi, Nr.ki), 
Nr.Ui = new Nr(Nr.Oi, 0, 0);

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * An in-memory implementation of IndexManager.
 */
var Tr = /** @class */ function() {
    function t() {
        this.Bi = new Dr;
    }
    return t.prototype.Qi = function(t, e) {
        return this.Bi.add(e), rr.resolve();
    }, t.prototype.pi = function(t, e) {
        return rr.resolve(this.Bi.getEntries(e));
    }, t;
}(), Dr = /** @class */ function() {
    function t() {
        this.index = {};
    }
    // Returns false if the entry already existed.
        return t.prototype.add = function(t) {
        var e = t._(), n = t.h(), r = this.index[e] || new _t(I.i), i = !r.has(n);
        return this.index[e] = r.add(n), i;
    }, t.prototype.has = function(t) {
        var e = t._(), n = t.h(), r = this.index[e];
        return r && r.has(n);
    }, t.prototype.getEntries = function(t) {
        return (this.index[t] || new _t(I.i)).A();
    }, t;
}(), Vr = /** @class */ function() {
    function t(t) {
        this.ji = t;
    }
    return t.prototype.next = function() {
        return this.ji += 2, this.ji;
    }, t.Wi = function() {
        // The target cache generator must return '2' in its first call to `next()`
        // as there is no differentiation in the protocol layer between an unset
        // number and the number '0'. If we were to sent a target with target ID
        // '0', the backend would consider it unset and replace it with its own ID.
        return new t(0);
    }, t.Gi = function() {
        // Sync engine assigns target IDs for limbo document detection.
        return new t(-1);
    }, t;
}(), Rr = /** @class */ function() {
    function t(
    /** Manages our in-memory or durable persistence. */
    t, e, n) {
        this.persistence = t, this.zi = e, 
        /**
             * Maps a targetID to data about its target.
             *
             * PORTING NOTE: We are using an immutable data structure on Web to make re-runs
             * of `applyRemoteEvent()` idempotent.
             */
        this.Ki = new wt(X), 
        /** Maps a target to its targetID. */
        // TODO(wuandy): Evaluate if TargetId can be part of Target.
        this.Hi = new rt((function(t) {
            return ht(t);
        }), ft), 
        /**
             * The read time of the last entry processed by `getNewDocumentChanges()`.
             *
             * PORTING NOTE: This is only used for multi-tab synchronization.
             */
        this.Yi = ot.min(), this.li = t.Ji(n), this.Xi = t.Zi(), this.tr = t.er(), this.nr = new Ir(this.Xi, this.li, this.persistence.sr()), 
        this.zi.ir(this.nr);
    }
    return t.prototype.rr = function(t) {
        var e = this;
        return this.persistence.runTransaction("Collect garbage", "readwrite-primary", (function(n) {
            return t.ur(n, e.Ki);
        }));
    }, t;
}();

/**
 * Internal implementation of the collection-parent index exposed by MemoryIndexManager.
 * Also used for in-memory caching by IndexedDbIndexManager and initial index population
 * in indexeddb_schema.ts
 */
/**
 * Acknowledges the given batch.
 *
 * On the happy path when a batch is acknowledged, the local store will
 *
 *  + remove the batch from the mutation queue;
 *  + apply the changes to the remote document cache;
 *  + recalculate the latency compensated view implied by those changes (there
 *    may be mutations in the queue that affect the documents but haven't been
 *    acknowledged yet); and
 *  + give the changed documents back the sync engine
 *
 * @returns The resulting (modified) documents.
 */
function Lr(t, e) {
    var n = m(t);
    return n.persistence.runTransaction("Acknowledge batch", "readwrite-primary", (function(t) {
        var r = e.batch.keys(), i = n.Xi.cr({
            ar: !0
        });
        return function(t, e, n, r) {
            var i = n.batch, o = i.keys(), s = rr.resolve();
            return o.forEach((function(t) {
                s = s.next((function() {
                    return r.mi(e, t);
                })).next((function(e) {
                    var o = e, s = n.ai.get(t);
                    g(null !== s), (!o || o.version.M(s) < 0) && ((o = i.ii(t, o, n)) && 
                    // We use the commitVersion as the readTime rather than the
                    // document's updateTime since the updateTime is not advanced
                    // for updates that do not modify the underlying document.
                    r.hr(o, n.ci));
                }));
            })), s.next((function() {
                return t.li.lr(e, i);
            }));
        }(n, t, e, i).next((function() {
            return i.apply(t);
        })).next((function() {
            return n.li._r(t);
        })).next((function() {
            return n.nr.Ei(t, r);
        }));
    }));
}

/**
 * Removes mutations from the MutationQueue for the specified batch;
 * LocalDocuments will be recalculated.
 *
 * @returns The resulting modified documents.
 */
/**
 * Returns the last consistent snapshot processed (used by the RemoteStore to
 * determine whether to buffer incoming snapshots from the backend).
 */ function Ur(t) {
    var e = m(t);
    return e.persistence.runTransaction("Get last remote snapshot version", "readonly", (function(t) {
        return e.tr.dr(t);
    }));
}

/**
 * Updates the "ground-state" (remote) documents. We assume that the remote
 * event reflects any write batches that have been acknowledged or rejected
 * (i.e. we do not re-apply local mutations to updates from this event).
 *
 * LocalDocuments are re-calculated if there are remaining mutations in the
 * queue.
 */ function Or(t, e) {
    var n = m(t), r = e.nt, i = n.Ki;
    return n.persistence.runTransaction("Apply remote event", "readwrite-primary", (function(t) {
        var o = n.Xi.cr({
            ar: !0
        });
        // Reset newTargetDataByTargetMap in case this transaction gets re-run.
                i = n.Ki;
        var s = [];
        e.Kt.forEach((function(e, o) {
            var u = i.get(o);
            if (u) {
                // Only update the remote keys if the target is still active. This
                // ensures that we can persist the updated target data along with
                // the updated assignment.
                s.push(n.tr.wr(t, e.se, o).next((function() {
                    return n.tr.mr(t, e.ee, o);
                })));
                var a = e.resumeToken;
                // Update the resume token if the change includes one.
                                if (a.L() > 0) {
                    var c = u.it(a, r).st(t.Tr);
                    i = i.ot(o, c), 
                    // Update the target data if there are target changes (or if
                    // sufficient time has passed since the last update).
                    /**
     * Returns true if the newTargetData should be persisted during an update of
     * an active target. TargetData should always be persisted when a target is
     * being released and should not call this function.
     *
     * While the target is active, TargetData updates can be omitted when nothing
     * about the target has changed except metadata like the resume token or
     * snapshot version. Occasionally it's worth the extra write to prevent these
     * values from getting too stale after a crash, but this doesn't have to be
     * too frequent.
     */
                    function(t, e, n) {
                        // Always persist target data if we don't already have a resume token.
                        return g(e.resumeToken.L() > 0), 0 === t.resumeToken.L() || (
                        // Don't allow resume token changes to be buffered indefinitely. This
                        // allows us to be reasonably up-to-date after a crash and avoids needing
                        // to loop over all active queries on shutdown. Especially in the browser
                        // we may not get time to do anything interesting while the current tab is
                        // closing.
                        e.nt.X() - t.nt.X() >= 3e8 || n.ee.size + n.ne.size + n.se.size > 0);
                    }(u, c, e) && s.push(n.tr.Er(t, c));
                }
            }
        }));
        var u = Nt(), a = Ut();
        // HACK: The only reason we allow a null snapshot version is so that we
        // can synthesize remote events when we get permission denied errors while
        // trying to resolve the state of a locally cached document that is in
        // limbo.
                if (e.Yt.forEach((function(t, e) {
            a = a.add(t);
        })), 
        // Each loop iteration only affects its "own" doc, so it's safe to get all the remote
        // documents in advance in a single call.
        s.push(o.getEntries(t, a).next((function(i) {
            e.Yt.forEach((function(a, c) {
                var h = i.get(a);
                // Note: The order of the steps below is important, since we want
                // to ensure that rejected limbo resolutions (which fabricate
                // NoDocuments with SnapshotVersion.min()) never add documents to
                // cache.
                                c instanceof bn && c.version.isEqual(ot.min()) ? (
                // NoDocuments with SnapshotVersion.min() are used in manufactured
                // events. We remove these documents from cache since we lost
                // access.
                o.Ir(a, r), u = u.ot(a, c)) : null == h || c.version.M(h.version) > 0 || 0 === c.version.M(h.version) && h.hasPendingWrites ? (o.hr(c, r), 
                u = u.ot(a, c)) : l("LocalStore", "Ignoring outdated watch update for ", a, ". Current version:", h.version, " Watch version:", c.version), 
                e.Jt.has(a) && s.push(n.persistence.Rr.Ar(t, a));
            }));
        }))), !r.isEqual(ot.min())) {
            var c = n.tr.dr(t).next((function(e) {
                return n.tr.yr(t, t.Tr, r);
            }));
            s.push(c);
        }
        return rr.xn(s).next((function() {
            return o.apply(t);
        })).next((function() {
            return n.nr.Ii(t, u);
        }));
    })).then((function(t) {
        return n.Ki = i, t;
    }));
}

/**
 * Gets the mutation batch after the passed in batchId in the mutation queue
 * or null if empty.
 * @param afterBatchId If provided, the batch to search after.
 * @returns The next mutation or null if there wasn't one.
 */ function Sr(t, e) {
    var n = m(t);
    return n.persistence.runTransaction("Get next mutation batch", "readonly", (function(t) {
        return void 0 === e && (e = -1), n.li.Pr(t, e);
    }));
}

/**
 * Reads the current value of a Document with a given key or null if not
 * found - used for testing.
 */
/**
 * Unpins all the documents associated with the given target. If
 * `keepPersistedTargetData` is set to false and Eager GC enabled, the method
 * directly removes the associated target data from the target cache.
 *
 * Releasing a non-existing `Target` is a no-op.
 */
// PORTING NOTE: `keepPersistedTargetData` is multi-tab only.
function kr(e, n, r) {
    return t.__awaiter(this, void 0, void 0, (function() {
        var i, o, s, u;
        return t.__generator(this, (function(t) {
            switch (t.label) {
              case 0:
                i = m(e), o = i.Ki.get(n), s = r ? "readwrite" : "readwrite-primary", t.label = 1;

              case 1:
                return t.trys.push([ 1, 4, , 5 ]), r ? [ 3 /*break*/ , 3 ] : [ 4 /*yield*/ , i.persistence.runTransaction("Release target", s, (function(t) {
                    return i.persistence.Rr.removeTarget(t, o);
                })) ];

              case 2:
                t.sent(), t.label = 3;

              case 3:
                return [ 3 /*break*/ , 5 ];

              case 4:
                if (!ir(u = t.sent())) throw u;
                // All `releaseTarget` does is record the final metadata state for the
                // target, but we've been recording this periodically during target
                // activity. If we lose this write this could cause a very slight
                // difference in the order of target deletion during GC, but we
                // don't define exact LRU semantics so this is acceptable.
                                return l("LocalStore", "Failed to update sequence numbers for target " + n + ": " + u), 
                [ 3 /*break*/ , 5 ];

              case 5:
                return i.Ki = i.Ki.remove(n), i.Hi.delete(o.target), [ 2 /*return*/ ];
            }
        }));
    }));
}

/**
 * Runs the specified query against the local store and returns the results,
 * potentially taking advantage of query data from previous executions (such
 * as the set of remote keys).
 *
 * @param usePreviousResults Whether results from previous executions can
 * be used to optimize this query execution.
 */ function jr(t, e, n) {
    var r = m(t), i = ot.min(), o = Ut();
    return r.persistence.runTransaction("Execute query", "readonly", (function(t) {
        /**
     * Returns the TargetData as seen by the LocalStore, including updates that may
     * have not yet been persisted to the TargetCache.
     */
        // Visible for testing.
        return function(t, e, n) {
            var r = m(t), i = r.Hi.get(n);
            return void 0 !== i ? rr.resolve(r.Ki.get(i)) : r.tr.gr(e, n);
        }(r, t, Ln(e)).next((function(e) {
            if (e) return i = e.lastLimboFreeSnapshotVersion, r.tr.pr(t, e.targetId).next((function(t) {
                o = t;
            }));
        })).next((function() {
            return r.zi.Ri(t, e, n ? i : ot.min(), n ? o : Ut());
        })).next((function(t) {
            return {
                documents: t,
                Vr: o
            };
        }));
    }));
}

function Pr(e) {
    return t.__awaiter(this, void 0, void 0, (function() {
        return t.__generator(this, (function(t) {
            if (e.code !== a.FAILED_PRECONDITION || "The current tab is not in the required state to perform this operation. It might be necessary to refresh the browser tab." !== e.message) throw e;
            return l("LocalStore", "Unexpectedly lost primary lease"), [ 2 /*return*/ ];
        }));
    }));
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A collection of references to a document from some kind of numbered entity
 * (either a target ID or batch ID). As references are added to or removed from
 * the set corresponding events are emitted to a registered garbage collector.
 *
 * Each reference is represented by a DocumentReference object. Each of them
 * contains enough information to uniquely identify the reference. They are all
 * stored primarily in a set sorted by key. A document is considered garbage if
 * there's no references in that set (this can be efficiently checked thanks to
 * sorting by key).
 *
 * ReferenceSet also keeps a secondary set that contains references sorted by
 * IDs. This one is used to efficiently implement removal of all references by
 * some target ID.
 */ var Cr = /** @class */ function() {
    function t() {
        // A set of outstanding references to a document sorted by key.
        this.vr = new _t(Mr.br), 
        // A set of outstanding references to a document sorted by target id.
        this.Sr = new _t(Mr.Dr)
        /** Returns true if the reference set contains no references. */;
    }
    return t.prototype.m = function() {
        return this.vr.m();
    }, 
    /** Adds a reference to the given document key for the given ID. */ t.prototype.Cr = function(t, e) {
        var n = new Mr(t, e);
        this.vr = this.vr.add(n), this.Sr = this.Sr.add(n);
    }, 
    /** Add references to the given document keys for the given ID. */ t.prototype.Fr = function(t, e) {
        var n = this;
        t.forEach((function(t) {
            return n.Cr(t, e);
        }));
    }, 
    /**
     * Removes a reference to the given document key for the given
     * ID.
     */
    t.prototype.Nr = function(t, e) {
        this.$r(new Mr(t, e));
    }, t.prototype.kr = function(t, e) {
        var n = this;
        t.forEach((function(t) {
            return n.Nr(t, e);
        }));
    }, 
    /**
     * Clears all references with a given ID. Calls removeRef() for each key
     * removed.
     */
    t.prototype.Or = function(t) {
        var e = this, n = new T(new I([])), r = new Mr(n, t), i = new Mr(n, t + 1), o = [];
        return this.Sr.Nt([ r, i ], (function(t) {
            e.$r(t), o.push(t.key);
        })), o;
    }, t.prototype.Lr = function() {
        var t = this;
        this.vr.forEach((function(e) {
            return t.$r(e);
        }));
    }, t.prototype.$r = function(t) {
        this.vr = this.vr.delete(t), this.Sr = this.Sr.delete(t);
    }, t.prototype.Mr = function(t) {
        var e = new T(new I([])), n = new Mr(e, t), r = new Mr(e, t + 1), i = Ut();
        return this.Sr.Nt([ n, r ], (function(t) {
            i = i.add(t.key);
        })), i;
    }, t.prototype.qr = function(t) {
        var e = new Mr(t, 0), n = this.vr.xt(e);
        return null !== n && t.isEqual(n.key);
    }, t;
}(), Mr = /** @class */ function() {
    function t(t, e) {
        this.key = t, this.Ur = e
        /** Compare by key then by ID */;
    }
    return t.br = function(t, e) {
        return T.i(t.key, e.key) || X(t.Ur, e.Ur);
    }, 
    /** Compare by ID then by key */ t.Dr = function(t, e) {
        return X(t.Ur, e.Ur) || T.i(t.key, e.key);
    }, t;
}(), xr = function(t, e) {
    this.user = e, this.type = "OAuth", this.Br = {}, 
    // Set the headers using Object Literal notation to avoid minification
    this.Br.Authorization = "Bearer " + t;
}, qr = /** @class */ function() {
    function t() {
        /**
         * Stores the listener registered with setChangeListener()
         * This isn't actually necessary since the UID never changes, but we use this
         * to verify the listen contract is adhered to in tests.
         */
        this.Qr = null;
    }
    return t.prototype.getToken = function() {
        return Promise.resolve(null);
    }, t.prototype.jr = function() {}, t.prototype.Wr = function(t) {
        this.Qr = t, 
        // Fire with initial user.
        t(gr.UNAUTHENTICATED);
    }, t.prototype.Gr = function() {
        this.Qr = null;
    }, t;
}(), Fr = /** @class */ function() {
    function t(t) {
        var e = this;
        /**
         * The auth token listener registered with FirebaseApp, retained here so we
         * can unregister it.
         */        this.zr = null, 
        /** Tracks the current User. */
        this.currentUser = gr.UNAUTHENTICATED, this.Kr = !1, 
        /**
             * Counter used to detect if the token changed while a getToken request was
             * outstanding.
             */
        this.Hr = 0, 
        /** The listener registered with setChangeListener(). */
        this.Qr = null, this.forceRefresh = !1, this.zr = function() {
            e.Hr++, e.currentUser = e.Yr(), e.Kr = !0, e.Qr && e.Qr(e.currentUser);
        }, this.Hr = 0, this.auth = t.getImmediate({
            optional: !0
        }), this.auth ? this.auth.addAuthTokenListener(this.zr) : (
        // if auth is not available, invoke tokenListener once with null token
        this.zr(null), t.get().then((function(t) {
            e.auth = t, e.zr && 
            // tokenListener can be removed by removeChangeListener()
            e.auth.addAuthTokenListener(e.zr);
        }), (function() {})));
    }
    return t.prototype.getToken = function() {
        var t = this, e = this.Hr, n = this.forceRefresh;
        // Take note of the current value of the tokenCounter so that this method
        // can fail (with an ABORTED error) if there is a token change while the
        // request is outstanding.
                return this.forceRefresh = !1, this.auth ? this.auth.getToken(n).then((function(n) {
            // Cancel the request since the token changed while the request was
            // outstanding so the response is potentially for a previous user (which
            // user, we can't be sure).
            return t.Hr !== e ? (l("FirebaseCredentialsProvider", "getToken aborted due to token change."), 
            t.getToken()) : n ? (g("string" == typeof n.accessToken), new xr(n.accessToken, t.currentUser)) : null;
        })) : Promise.resolve(null);
    }, t.prototype.jr = function() {
        this.forceRefresh = !0;
    }, t.prototype.Wr = function(t) {
        this.Qr = t, 
        // Fire the initial event
        this.Kr && t(this.currentUser);
    }, t.prototype.Gr = function() {
        this.auth && this.auth.removeAuthTokenListener(this.zr), this.zr = null, this.Qr = null;
    }, 
    // Auth.getUid() can return null even with a user logged in. It is because
    // getUid() is synchronous, but the auth code populating Uid is asynchronous.
    // This method should only be called in the AuthTokenListener callback
    // to guarantee to get the actual user.
    t.prototype.Yr = function() {
        var t = this.auth && this.auth.getUid();
        return g(null === t || "string" == typeof t), new gr(t);
    }, t;
}(), Br = /** @class */ function() {
    function t(t, e) {
        this.Jr = t, this.Xr = e, this.type = "FirstParty", this.user = gr.Ns;
    }
    return Object.defineProperty(t.prototype, "Br", {
        get: function() {
            var t = {
                "X-Goog-AuthUser": this.Xr
            }, e = this.Jr.auth.getAuthHeaderValueForFirstParty([]);
            // Use array notation to prevent minification
                        return e && (t.Authorization = e), t;
        },
        enumerable: !1,
        configurable: !0
    }), t;
}(), Gr = /** @class */ function() {
    function t(t, e) {
        this.Jr = t, this.Xr = e;
    }
    return t.prototype.getToken = function() {
        return Promise.resolve(new Br(this.Jr, this.Xr));
    }, t.prototype.Wr = function(t) {
        // Fire with initial uid.
        t(gr.Ns);
    }, t.prototype.Gr = function() {}, t.prototype.jr = function() {}, t;
}(), zr = /** @class */ function() {
    function e(t, e, n, r, i, o) {
        this.fn = t, this.Zr = n, this.eo = r, this.no = i, this.listener = o, this.state = 0 /* Initial */ , 
        /**
             * A close count that's incremented every time the stream is closed; used by
             * getCloseGuardedDispatcher() to invalidate callbacks that happen after
             * close.
             */
        this.so = 0, this.io = null, this.stream = null, this.Xn = new nr(t, e)
        /**
     * Returns true if start() has been called and no error has occurred. True
     * indicates the stream is open or in the process of opening (which
     * encompasses respecting backoff, getting auth tokens, and starting the
     * actual RPC). Use isOpen() to determine if the stream is open and ready for
     * outbound requests.
     */;
    }
    return e.prototype.ro = function() {
        return 1 /* Starting */ === this.state || 2 /* Open */ === this.state || 4 /* Backoff */ === this.state;
    }, 
    /**
     * Returns true if the underlying RPC is open (the onOpen() listener has been
     * called) and the stream is ready for outbound requests.
     */
    e.prototype.oo = function() {
        return 2 /* Open */ === this.state;
    }, 
    /**
     * Starts the RPC. Only allowed if isStarted() returns false. The stream is
     * not immediately ready for use: onOpen() will be invoked when the RPC is
     * ready for outbound requests, at which point isOpen() will return true.
     *
     * When start returns, isStarted() will return true.
     */
    e.prototype.start = function() {
        3 /* Error */ !== this.state ? this.auth() : this.uo();
    }, 
    /**
     * Stops the RPC. This call is idempotent and allowed regardless of the
     * current isStarted() state.
     *
     * When stop returns, isStarted() and isOpen() will both return false.
     */
    e.prototype.stop = function() {
        return t.__awaiter(this, void 0, void 0, (function() {
            return t.__generator(this, (function(t) {
                switch (t.label) {
                  case 0:
                    return this.ro() ? [ 4 /*yield*/ , this.close(0 /* Initial */) ] : [ 3 /*break*/ , 2 ];

                  case 1:
                    t.sent(), t.label = 2;

                  case 2:
                    return [ 2 /*return*/ ];
                }
            }));
        }));
    }, 
    /**
     * After an error the stream will usually back off on the next attempt to
     * start it. If the error warrants an immediate restart of the stream, the
     * sender can use this to indicate that the receiver should not back off.
     *
     * Each error will call the onClose() listener. That function can decide to
     * inhibit backoff if required.
     */
    e.prototype.co = function() {
        this.state = 0 /* Initial */ , this.Xn.reset();
    }, 
    /**
     * Marks this stream as idle. If no further actions are performed on the
     * stream for one minute, the stream will automatically close itself and
     * notify the stream's onClose() handler with Status.OK. The stream will then
     * be in a !isStarted() state, requiring the caller to start the stream again
     * before further use.
     *
     * Only streams that are in state 'Open' can be marked idle, as all other
     * states imply pending network operations.
     */
    e.prototype.ao = function() {
        var t = this;
        // Starts the idle time if we are in state 'Open' and are not yet already
        // running a timer (in which case the previous idle timeout still applies).
                this.oo() && null === this.io && (this.io = this.fn.gn(this.Zr, 6e4, (function() {
            return t.ho();
        })));
    }, 
    /** Sends a message to the underlying stream. */ e.prototype.lo = function(t) {
        this._o(), this.stream.send(t);
    }, 
    /** Called by the idle timer when the stream should close due to inactivity. */ e.prototype.ho = function() {
        return t.__awaiter(this, void 0, void 0, (function() {
            return t.__generator(this, (function(t) {
                return this.oo() ? [ 2 /*return*/ , this.close(0 /* Initial */) ] : [ 2 /*return*/ ];
            }));
        }));
    }, 
    /** Marks the stream as active again. */ e.prototype._o = function() {
        this.io && (this.io.cancel(), this.io = null);
    }, 
    /**
     * Closes the stream and cleans up as necessary:
     *
     * * closes the underlying GRPC stream;
     * * calls the onClose handler with the given 'error';
     * * sets internal stream state to 'finalState';
     * * adjusts the backoff timer based on the error
     *
     * A new stream can be opened by calling start().
     *
     * @param finalState the intended state of the stream after closing.
     * @param error the error the connection was closed with.
     */
    e.prototype.close = function(e, n) {
        return t.__awaiter(this, void 0, void 0, (function() {
            return t.__generator(this, (function(t) {
                switch (t.label) {
                  case 0:
                    // Notify the listener that the stream closed.
                    // Cancel any outstanding timers (they're guaranteed not to execute).
                    return this._o(), this.Xn.cancel(), 
                    // Invalidates any stream-related callbacks (e.g. from auth or the
                    // underlying stream), guaranteeing they won't execute.
                    this.so++, 3 /* Error */ !== e ? 
                    // If this is an intentional close ensure we don't delay our next connection attempt.
                    this.Xn.reset() : n && n.code === a.RESOURCE_EXHAUSTED ? (
                    // Log the error. (Probably either 'quota exceeded' or 'max queue length reached'.)
                    p(n.toString()), p("Using maximum backoff delay to prevent overloading the backend."), 
                    this.Xn.Rn()) : n && n.code === a.UNAUTHENTICATED && 
                    // "unauthenticated" error means the token was rejected. Try force refreshing it in case it
                    // just expired.
                    this.no.jr(), 
                    // Clean up the underlying stream because we are no longer interested in events.
                    null !== this.stream && (this.fo(), this.stream.close(), this.stream = null), 
                    // This state must be assigned before calling onClose() to allow the callback to
                    // inhibit backoff or otherwise manipulate the state in its non-started state.
                    this.state = e, [ 4 /*yield*/ , this.listener.do(n) ];

                  case 1:
                    // Cancel any outstanding timers (they're guaranteed not to execute).
                    // Notify the listener that the stream closed.
                    return t.sent(), [ 2 /*return*/ ];
                }
            }));
        }));
    }, 
    /**
     * Can be overridden to perform additional cleanup before the stream is closed.
     * Calling super.tearDown() is not required.
     */
    e.prototype.fo = function() {}, e.prototype.auth = function() {
        var t = this;
        this.state = 1 /* Starting */;
        var e = this.wo(this.so), n = this.so;
        // TODO(mikelehen): Just use dispatchIfNotClosed, but see TODO below.
                this.no.getToken().then((function(e) {
            // Stream can be stopped while waiting for authentication.
            // TODO(mikelehen): We really should just use dispatchIfNotClosed
            // and let this dispatch onto the queue, but that opened a spec test can
            // of worms that I don't want to deal with in this PR.
            t.so === n && 
            // Normally we'd have to schedule the callback on the AsyncQueue.
            // However, the following calls are safe to be called outside the
            // AsyncQueue since they don't chain asynchronous calls
            t.mo(e);
        }), (function(n) {
            e((function() {
                var e = new c(a.UNKNOWN, "Fetching auth token failed: " + n.message);
                return t.To(e);
            }));
        }));
    }, e.prototype.mo = function(t) {
        var e = this, n = this.wo(this.so);
        this.stream = this.Eo(t), this.stream.Io((function() {
            n((function() {
                return e.state = 2 /* Open */ , e.listener.Io();
            }));
        })), this.stream.do((function(t) {
            n((function() {
                return e.To(t);
            }));
        })), this.stream.onMessage((function(t) {
            n((function() {
                return e.onMessage(t);
            }));
        }));
    }, e.prototype.uo = function() {
        var e = this;
        this.state = 4 /* Backoff */ , this.Xn.yn((function() {
            return t.__awaiter(e, void 0, void 0, (function() {
                return t.__generator(this, (function(t) {
                    return this.state = 0 /* Initial */ , this.start(), [ 2 /*return*/ ];
                }));
            }));
        }));
    }, 
    // Visible for tests
    e.prototype.To = function(t) {
        // In theory the stream could close cleanly, however, in our current model
        // we never expect this to happen because if we stop a stream ourselves,
        // this callback will never be called. To prevent cases where we retry
        // without a backoff accidentally, we set the stream to error in all cases.
        return l("PersistentStream", "close with error: " + t), this.stream = null, this.close(3 /* Error */ , t);
    }, 
    /**
     * Returns a "dispatcher" function that dispatches operations onto the
     * AsyncQueue but only runs them if closeCount remains unchanged. This allows
     * us to turn auth / stream callbacks into no-ops if the stream is closed /
     * re-opened, etc.
     */
    e.prototype.wo = function(t) {
        var e = this;
        return function(n) {
            e.fn.jn((function() {
                return e.so === t ? n() : (l("PersistentStream", "stream callback skipped by getCloseGuardedDispatcher."), 
                Promise.resolve());
            }));
        };
    }, e;
}(), Wr = /** @class */ function(e) {
    function n(t, n, r, i, o) {
        var s = this;
        return (s = e.call(this, t, "listen_stream_connection_backoff" /* ListenStreamConnectionBackoff */ , "listen_stream_idle" /* ListenStreamIdle */ , n, r, o) || this).serializer = i, 
        s;
    }
    return t.__extends(n, e), n.prototype.Eo = function(t) {
        return this.eo.Ao("Listen", t);
    }, n.prototype.onMessage = function(t) {
        // A successful response means the stream is healthy
        this.Xn.reset();
        var e = function(t, e) {
            var n;
            if ("targetChange" in e) {
                e.targetChange;
                // proto3 default value is unset in JSON (undefined), so use 'NO_CHANGE'
                // if unset
                var r = function(t) {
                    return "NO_CHANGE" === t ? 0 /* NoChange */ : "ADD" === t ? 1 /* Added */ : "REMOVE" === t ? 2 /* Removed */ : "CURRENT" === t ? 3 /* Current */ : "RESET" === t ? 4 /* Reset */ : y();
                }(e.targetChange.targetChangeType || "NO_CHANGE"), i = e.targetChange.targetIds || [], o = function(t, e) {
                    return t.Qe ? (g(void 0 === e || "string" == typeof e), Y.fromBase64String(e || "")) : (g(void 0 === e || e instanceof Uint8Array), 
                    Y.fromUint8Array(e || new Uint8Array));
                }(t, e.targetChange.resumeToken), s = e.targetChange.cause, u = s && function(t) {
                    var e = void 0 === t.code ? a.UNKNOWN : mt(t.code);
                    return new c(e, t.message || "");
                }(s);
                n = new Ft(r, i, o, u || null);
            } else if ("documentChange" in e) {
                e.documentChange;
                var h = e.documentChange;
                h.document, h.document.name, h.document.updateTime;
                var f = Ae(t, h.document.name), l = Ee(h.document.updateTime), p = new vn({
                    mapValue: {
                        fields: h.document.fields
                    }
                }), d = new wn(f, l, p, {}), v = h.targetIds || [], m = h.removedTargetIds || [];
                n = new xt(v, m, d.key, d);
            } else if ("documentDelete" in e) {
                e.documentDelete;
                var w = e.documentDelete;
                w.document;
                var b = Ae(t, w.document), E = w.readTime ? Ee(w.readTime) : ot.min(), _ = new bn(b, E), I = w.removedTargetIds || [];
                n = new xt([], I, _.key, _);
            } else if ("documentRemove" in e) {
                e.documentRemove;
                var A = e.documentRemove;
                A.document;
                var N = Ae(t, A.document), T = A.removedTargetIds || [];
                n = new xt([], T, N, null);
            } else {
                if (!("filter" in e)) return y();
                e.filter;
                var D = e.filter;
                D.targetId;
                var V = D.count || 0, R = new yt(V), L = D.targetId;
                n = new qt(L, R);
            }
            return n;
        }(this.serializer, t), n = function(t) {
            // We have only reached a consistent snapshot for the entire stream if there
            // is a read_time set and it applies to all targets (i.e. the list of
            // targets is empty). The backend is guaranteed to send such responses.
            if (!("targetChange" in t)) return ot.min();
            var e = t.targetChange;
            return e.targetIds && e.targetIds.length ? ot.min() : e.readTime ? Ee(e.readTime) : ot.min();
        }(t);
        return this.listener.Ro(e, n);
    }, 
    /**
     * Registers interest in the results of the given target. If the target
     * includes a resumeToken it will be included in the request. Results that
     * affect the target will be streamed back as WatchChange messages that
     * reference the targetId.
     */
    n.prototype.yo = function(t) {
        var e = {};
        e.database = Te(this.serializer), e.addTarget = function(t, e) {
            var n, r = e.target;
            return (n = lt(r) ? {
                documents: Re(t, r)
            } : {
                query: Le(t, r)
            }).targetId = e.targetId, e.resumeToken.L() > 0 && (n.resumeToken = we(t, e.resumeToken)), 
            n;
        }(this.serializer, t);
        var n = function(t, e) {
            var n = function(t, e) {
                switch (e) {
                  case 0 /* Listen */ :
                    return null;

                  case 1 /* ExistenceFilterMismatch */ :
                    return "existence-filter-mismatch";

                  case 2 /* LimboResolution */ :
                    return "limbo-document";

                  default:
                    return y();
                }
            }(0, e.et);
            return null == n ? null : {
                "goog-listen-tags": n
            };
        }(this.serializer, t);
        n && (e.labels = n), this.lo(e);
    }, 
    /**
     * Unregisters interest in the results of the target associated with the
     * given targetId.
     */
    n.prototype.Po = function(t) {
        var e = {};
        e.database = Te(this.serializer), e.removeTarget = t, this.lo(e);
    }, n;
}(zr), Qr = /** @class */ function(e) {
    function n(t, n, r, i, o) {
        var s = this;
        return (s = e.call(this, t, "write_stream_connection_backoff" /* WriteStreamConnectionBackoff */ , "write_stream_idle" /* WriteStreamIdle */ , n, r, o) || this).serializer = i, 
        s.po = !1, s;
    }
    return t.__extends(n, e), Object.defineProperty(n.prototype, "Vo", {
        /**
         * Tracks whether or not a handshake has been successfully exchanged and
         * the stream is ready to accept mutations.
         */
        get: function() {
            return this.po;
        },
        enumerable: !1,
        configurable: !0
    }), 
    // Override of PersistentStream.start
    n.prototype.start = function() {
        this.po = !1, this.lastStreamToken = void 0, e.prototype.start.call(this);
    }, n.prototype.fo = function() {
        this.po && this.vo([]);
    }, n.prototype.Eo = function(t) {
        return this.eo.Ao("Write", t);
    }, n.prototype.onMessage = function(t) {
        if (
        // Always capture the last stream token.
        g(!!t.streamToken), this.lastStreamToken = t.streamToken, this.po) {
            // A successful first write response means the stream is healthy,
            // Note, that we could consider a successful handshake healthy, however,
            // the write itself might be causing an error we want to back off from.
            this.Xn.reset();
            var e = function(t, e) {
                return t && t.length > 0 ? (g(void 0 !== e), t.map((function(t) {
                    return function(t, e) {
                        // NOTE: Deletes don't have an updateTime.
                        var n = t.updateTime ? Ee(t.updateTime) : Ee(e);
                        n.isEqual(ot.min()) && (
                        // The Firestore Emulator currently returns an update time of 0 for
                        // deletes of non-existing documents (rather than null). This breaks the
                        // test "get deleted doc while offline with source=cache" as NoDocuments
                        // with version 0 are filtered by IndexedDb's RemoteDocumentCache.
                        // TODO(#2149): Remove this when Emulator is fixed
                        n = Ee(e));
                        var r = null;
                        return t.transformResults && t.transformResults.length > 0 && (r = t.transformResults), 
                        new Je(n, r);
                    }(t, e);
                }))) : [];
            }(t.writeResults, t.commitTime), n = Ee(t.commitTime);
            return this.listener.bo(n, e);
        }
        // The first response is always the handshake response
                return g(!t.writeResults || 0 === t.writeResults.length), this.po = !0, 
        this.listener.So();
    }, 
    /**
     * Sends an initial streamToken to the server, performing the handshake
     * required to make the StreamingWrite RPC work. Subsequent
     * calls should wait until onHandshakeComplete was called.
     */
    n.prototype.Do = function() {
        // TODO(dimond): Support stream resumption. We intentionally do not set the
        // stream token on the handshake, ignoring any stream token we might have.
        var t = {};
        t.database = Te(this.serializer), this.lo(t);
    }, 
    /** Sends a group of mutations to the Firestore backend to apply. */ n.prototype.vo = function(t) {
        var e = this, n = {
            streamToken: this.lastStreamToken,
            writes: t.map((function(t) {
                return Ve(e.serializer, t);
            }))
        };
        this.lo(n);
    }, n;
}(zr), Kr = /** @class */ function(e) {
    function n(t, n, r) {
        var i = this;
        return (i = e.call(this) || this).credentials = t, i.eo = n, i.serializer = r, i.Co = !1, 
        i;
    }
    return t.__extends(n, e), n.prototype.Fo = function() {
        if (this.Co) throw new c(a.FAILED_PRECONDITION, "The client has already been terminated.");
    }, 
    /** Gets an auth token and invokes the provided RPC. */ n.prototype.No = function(t, e, n) {
        var r = this;
        return this.Fo(), this.credentials.getToken().then((function(i) {
            return r.eo.No(t, e, n, i);
        })).catch((function(t) {
            throw t.code === a.UNAUTHENTICATED && r.credentials.jr(), t;
        }));
    }, 
    /** Gets an auth token and invokes the provided RPC with streamed results. */ n.prototype.$o = function(t, e, n) {
        var r = this;
        return this.Fo(), this.credentials.getToken().then((function(i) {
            return r.eo.$o(t, e, n, i);
        })).catch((function(t) {
            throw t.code === a.UNAUTHENTICATED && r.credentials.jr(), t;
        }));
    }, n.prototype.terminate = function() {
        this.Co = !1;
    }, n;
}((function() {})), Xr = /** @class */ function() {
    function t(t, e) {
        this.On = t, this.js = e, 
        /** The current OnlineState. */
        this.state = "Unknown" /* Unknown */ , 
        /**
             * A count of consecutive failures to open the stream. If it reaches the
             * maximum defined by MAX_WATCH_STREAM_FAILURES, we'll set the OnlineState to
             * Offline.
             */
        this.xo = 0, 
        /**
             * A timer that elapses after ONLINE_STATE_TIMEOUT_MS, at which point we
             * transition from OnlineState.Unknown to OnlineState.Offline without waiting
             * for the stream to actually fail (MAX_WATCH_STREAM_FAILURES times).
             */
        this.ko = null, 
        /**
             * Whether the client should log a warning message if it fails to connect to
             * the backend (initially true, cleared after a successful stream, or if we've
             * logged the message already).
             */
        this.Oo = !0
        /**
     * Called by RemoteStore when a watch stream is started (including on each
     * backoff attempt).
     *
     * If this is the first attempt, it sets the OnlineState to Unknown and starts
     * the onlineStateTimer.
     */;
    }
    return t.prototype.Lo = function() {
        var t = this;
        0 === this.xo && (this.Mo("Unknown" /* Unknown */), this.ko = this.On.gn("online_state_timeout" /* OnlineStateTimeout */ , 1e4, (function() {
            return t.ko = null, t.qo("Backend didn't respond within 10 seconds."), t.Mo("Offline" /* Offline */), 
            Promise.resolve();
        })));
    }, 
    /**
     * Updates our OnlineState as appropriate after the watch stream reports a
     * failure. The first failure moves us to the 'Unknown' state. We then may
     * allow multiple failures (based on MAX_WATCH_STREAM_FAILURES) before we
     * actually transition to the 'Offline' state.
     */
    t.prototype.Uo = function(t) {
        "Online" /* Online */ === this.state ? this.Mo("Unknown" /* Unknown */) : (this.xo++, 
        this.xo >= 1 && (this.Bo(), this.qo("Connection failed 1 times. Most recent error: " + t.toString()), 
        this.Mo("Offline" /* Offline */)));
    }, 
    /**
     * Explicitly sets the OnlineState to the specified state.
     *
     * Note that this resets our timers / failure counters, etc. used by our
     * Offline heuristics, so must not be used in place of
     * handleWatchStreamStart() and handleWatchStreamFailure().
     */
    t.prototype.set = function(t) {
        this.Bo(), this.xo = 0, "Online" /* Online */ === t && (
        // We've connected to watch at least once. Don't warn the developer
        // about being offline going forward.
        this.Oo = !1), this.Mo(t);
    }, t.prototype.Mo = function(t) {
        t !== this.state && (this.state = t, this.js(t));
    }, t.prototype.qo = function(t) {
        var e = "Could not reach Cloud Firestore backend. " + t + "\nThis typically indicates that your device does not have a healthy Internet connection at the moment. The client will operate in offline mode until it is able to successfully connect to the backend.";
        this.Oo ? (p(e), this.Oo = !1) : l("OnlineStateTracker", e);
    }, t.prototype.Bo = function() {
        null !== this.ko && (this.ko.cancel(), this.ko = null);
    }, t;
}(), Hr = function(
/**
     * The local store, used to fill the write pipeline with outbound mutations.
     */
e, 
/** The client-side proxy for interacting with the backend. */
n, r, i, o) {
    var s = this;
    this.Qo = e, this.jo = n, this.On = r, this.Wo = {}, 
    /**
             * A list of up to MAX_PENDING_WRITES writes that we have fetched from the
             * LocalStore via fillWritePipeline() and have or will send to the write
             * stream.
             *
             * Whenever writePipeline.length > 0 the RemoteStore will attempt to start or
             * restart the write stream. When the stream is established the writes in the
             * pipeline will be sent in order.
             *
             * Writes remain in writePipeline until they are acknowledged by the backend
             * and thus will automatically be re-sent if the stream is interrupted /
             * restarted before they're acknowledged.
             *
             * Write responses from the backend are linked to their originating request
             * purely based on order, and so we can just shift() writes from the front of
             * the writePipeline as we receive responses.
             */
    this.Go = [], 
    /**
             * A mapping of watched targets that the client cares about tracking and the
             * user has explicitly called a 'listen' for this target.
             *
             * These targets may or may not have been sent to or acknowledged by the
             * server. On re-establishing the listen stream, these targets should be sent
             * to the server. The targets removed with unlistens are removed eagerly
             * without waiting for confirmation from the listen stream.
             */
    this.zo = new Map, 
    /**
             * A set of reasons for why the RemoteStore may be offline. If empty, the
             * RemoteStore may start its network connections.
             */
    this.Ko = new Set, 
    /**
             * Event handlers that get called when the network is disabled or enabled.
             *
             * PORTING NOTE: These functions are used on the Web client to create the
             * underlying streams (to support tree-shakeable streams). On Android and iOS,
             * the streams are created during construction of RemoteStore.
             */
    this.Ho = [], this.Yo = o, this.Yo.Jo((function(e) {
        r.jn((function() {
            return t.__awaiter(s, void 0, void 0, (function() {
                return t.__generator(this, (function(e) {
                    switch (e.label) {
                      case 0:
                        return oi(this) ? (l("RemoteStore", "Restarting streams for network reachability change."), 
                        [ 4 /*yield*/ , function(e) {
                            return t.__awaiter(this, void 0, void 0, (function() {
                                var n;
                                return t.__generator(this, (function(t) {
                                    switch (t.label) {
                                      case 0:
                                        return (n = m(e)).Ko.add(4 /* ConnectivityChange */), [ 4 /*yield*/ , Jr(n) ];

                                      case 1:
                                        return t.sent(), n.Xo.set("Unknown" /* Unknown */), n.Ko.delete(4 /* ConnectivityChange */), 
                                        [ 4 /*yield*/ , Yr(n) ];

                                      case 2:
                                        return t.sent(), [ 2 /*return*/ ];
                                    }
                                }));
                            }));
                        }(this) ]) : [ 3 /*break*/ , 2 ];

                      case 1:
                        e.sent(), e.label = 2;

                      case 2:
                        return [ 2 /*return*/ ];
                    }
                }));
            }));
        }));
    })), this.Xo = new Xr(r, i);
};

function Yr(e) {
    return t.__awaiter(this, void 0, void 0, (function() {
        var n, r;
        return t.__generator(this, (function(t) {
            switch (t.label) {
              case 0:
                if (!oi(e)) return [ 3 /*break*/ , 4 ];
                n = 0, r = e.Ho, t.label = 1;

              case 1:
                return n < r.length ? [ 4 /*yield*/ , (0, r[n])(/* enabled= */ !0) ] : [ 3 /*break*/ , 4 ];

              case 2:
                t.sent(), t.label = 3;

              case 3:
                return n++, [ 3 /*break*/ , 1 ];

              case 4:
                return [ 2 /*return*/ ];
            }
        }));
    }));
}

/**
 * Temporarily disables the network. The network can be re-enabled using
 * enableNetwork().
 */ function Jr(e) {
    return t.__awaiter(this, void 0, void 0, (function() {
        var n, r;
        return t.__generator(this, (function(t) {
            switch (t.label) {
              case 0:
                n = 0, r = e.Ho, t.label = 1;

              case 1:
                return n < r.length ? [ 4 /*yield*/ , (0, r[n])(/* enabled= */ !1) ] : [ 3 /*break*/ , 4 ];

              case 2:
                t.sent(), t.label = 3;

              case 3:
                return n++, [ 3 /*break*/ , 1 ];

              case 4:
                return [ 2 /*return*/ ];
            }
        }));
    }));
}

function $r(e) {
    return t.__awaiter(this, void 0, void 0, (function() {
        var n;
        return t.__generator(this, (function(t) {
            switch (t.label) {
              case 0:
                return n = m(e), l("RemoteStore", "RemoteStore shutting down."), n.Ko.add(5 /* Shutdown */), 
                [ 4 /*yield*/ , Jr(n) ];

              case 1:
                return t.sent(), n.Yo.ni(), 
                // Set the OnlineState to Unknown (rather than Offline) to avoid potentially
                // triggering spurious listener events with cached data, etc.
                n.Xo.set("Unknown" /* Unknown */), [ 2 /*return*/ ];
            }
        }));
    }));
}

/**
 * Starts new listen for the given target. Uses resume token if provided. It
 * is a no-op if the target of given `TargetData` is already being listened to.
 */ function Zr(t, e) {
    var n = m(t);
    n.zo.has(e.targetId) || (
    // Mark this as something the client is currently listening for.
    n.zo.set(e.targetId, e), ii(n) ? 
    // The listen will be sent in onWatchStreamOpen
    ri(n) : wi(n).oo() && ei(n, e));
}

/**
 * Removes the listen from server. It is a no-op if the given target id is
 * not being listened to.
 */ function ti(t, e) {
    var n = m(t), r = wi(n);
    n.zo.delete(e), r.oo() && ni(n, e), 0 === n.zo.size && (r.oo() ? r.ao() : oi(n) && 
    // Revert to OnlineState.Unknown if the watch stream is not open and we
    // have no listeners, since without any listens to send we cannot
    // confirm if the stream is healthy and upgrade to OnlineState.Online.
    n.Xo.set("Unknown" /* Unknown */));
}

/**
 * We need to increment the the expected number of pending responses we're due
 * from watch so we wait for the ack to process any messages from this target.
 */ function ei(t, e) {
    t.Zo.Ie(e.targetId), wi(t).yo(e)
    /**
 * We need to increment the expected number of pending responses we're due
 * from watch so we wait for the removal on the server before we process any
 * messages from this target.
 */;
}

function ni(t, e) {
    t.Zo.Ie(e), wi(t).Po(e);
}

function ri(t) {
    t.Zo = new Gt({
        Ue: function(e) {
            return t.Wo.Ue(e);
        },
        Be: function(e) {
            return t.zo.get(e) || null;
        }
    }), wi(t).start(), t.Xo.Lo()
    /**
 * Returns whether the watch stream should be started because it's necessary
 * and has not yet been started.
 */;
}

function ii(t) {
    return oi(t) && !wi(t).ro() && t.zo.size > 0;
}

function oi(t) {
    return 0 === m(t).Ko.size;
}

function si(t) {
    t.Zo = void 0;
}

function ui(e) {
    return t.__awaiter(this, void 0, void 0, (function() {
        return t.__generator(this, (function(t) {
            return e.zo.forEach((function(t, n) {
                ei(e, t);
            })), [ 2 /*return*/ ];
        }));
    }));
}

function ai(e, n) {
    return t.__awaiter(this, void 0, void 0, (function() {
        return t.__generator(this, (function(t) {
            return si(e), 
            // If we still need the watch stream, retry the connection.
            ii(e) ? (e.Xo.Uo(n), ri(e)) : 
            // No need to restart watch stream because there are no active targets.
            // The online state is set to unknown because there is no active attempt
            // at establishing a connection
            e.Xo.set("Unknown" /* Unknown */), [ 2 /*return*/ ];
        }));
    }));
}

function ci(e, n, r) {
    return t.__awaiter(this, void 0, void 0, (function() {
        var i, o, s;
        return t.__generator(this, (function(u) {
            switch (u.label) {
              case 0:
                if (e.Xo.set("Online" /* Online */), !(n instanceof Ft && 2 /* Removed */ === n.state && n.cause)) 
                // Mark the client as online since we got a message from the server
                return [ 3 /*break*/ , 6 ];
                u.label = 1;

              case 1:
                return u.trys.push([ 1, 3, , 5 ]), [ 4 /*yield*/ , 
                /** Handles an error on a target */
                function(e, n) {
                    return t.__awaiter(this, void 0, void 0, (function() {
                        var r, i, o, s;
                        return t.__generator(this, (function(t) {
                            switch (t.label) {
                              case 0:
                                r = n.cause, i = 0, o = n.targetIds, t.label = 1;

                              case 1:
                                return i < o.length ? (s = o[i], e.zo.has(s) ? [ 4 /*yield*/ , e.Wo.tu(s, r) ] : [ 3 /*break*/ , 3 ]) : [ 3 /*break*/ , 5 ];

                              case 2:
                                t.sent(), e.zo.delete(s), e.Zo.removeTarget(s), t.label = 3;

                              case 3:
                                t.label = 4;

                              case 4:
                                return i++, [ 3 /*break*/ , 1 ];

                              case 5:
                                return [ 2 /*return*/ ];
                            }
                        }));
                    }));
                }(e, n) ];

              case 2:
                return u.sent(), [ 3 /*break*/ , 5 ];

              case 3:
                return i = u.sent(), l("RemoteStore", "Failed to remove targets %s: %s ", n.targetIds.join(","), i), 
                [ 4 /*yield*/ , hi(e, i) ];

              case 4:
                return u.sent(), [ 3 /*break*/ , 5 ];

              case 5:
                return [ 3 /*break*/ , 13 ];

              case 6:
                if (n instanceof xt ? e.Zo.ve(n) : n instanceof qt ? e.Zo.xe(n) : e.Zo.De(n), r.isEqual(ot.min())) return [ 3 /*break*/ , 13 ];
                u.label = 7;

              case 7:
                return u.trys.push([ 7, 11, , 13 ]), [ 4 /*yield*/ , Ur(e.Qo) ];

              case 8:
                return o = u.sent(), r.M(o) >= 0 ? [ 4 /*yield*/ , 
                /**
                 * Takes a batch of changes from the Datastore, repackages them as a
                 * RemoteEvent, and passes that on to the listener, which is typically the
                 * SyncEngine.
                 */
                function(t, e) {
                    var n = t.Zo.Le(e);
                    // Update in-memory resume tokens. LocalStore will update the
                    // persistent view of these when applying the completed RemoteEvent.
                                        return n.Kt.forEach((function(n, r) {
                        if (n.resumeToken.L() > 0) {
                            var i = t.zo.get(r);
                            // A watched target might have been removed already.
                                                        i && t.zo.set(r, i.it(n.resumeToken, e));
                        }
                    })), 
                    // Re-establish listens for the targets that have been invalidated by
                    // existence filter mismatches.
                    n.Ht.forEach((function(e) {
                        var n = t.zo.get(e);
                        if (n) {
                            // Clear the resume token for the target, since we're in a known mismatch
                            // state.
                            t.zo.set(e, n.it(Y.q, n.nt)), 
                            // Cause a hard reset by unwatching and rewatching immediately, but
                            // deliberately don't send a resume token so that we get a full update.
                            ni(t, e);
                            // Mark the target we send as being on behalf of an existence filter
                            // mismatch, but don't actually retain that in listenTargets. This ensures
                            // that we flag the first re-listen this way without impacting future
                            // listens of this target (that might happen e.g. on reconnect).
                            var r = new vt(n.target, e, 1 /* ExistenceFilterMismatch */ , n.sequenceNumber);
                            ei(t, r);
                        }
                    })), t.Wo.eu(n);
                }(e, r) ] : [ 3 /*break*/ , 10 ];

                // We have received a target change with a global snapshot if the snapshot
                // version is not equal to SnapshotVersion.min().
                              case 9:
                // We have received a target change with a global snapshot if the snapshot
                // version is not equal to SnapshotVersion.min().
                u.sent(), u.label = 10;

              case 10:
                return [ 3 /*break*/ , 13 ];

              case 11:
                return l("RemoteStore", "Failed to raise snapshot:", s = u.sent()), [ 4 /*yield*/ , hi(e, s) ];

              case 12:
                return u.sent(), [ 3 /*break*/ , 13 ];

              case 13:
                return [ 2 /*return*/ ];
            }
        }));
    }));
}

/**
 * Recovery logic for IndexedDB errors that takes the network offline until
 * `op` succeeds. Retries are scheduled with backoff using
 * `enqueueRetryable()`. If `op()` is not provided, IndexedDB access is
 * validated via a generic operation.
 *
 * The returned Promise is resolved once the network is disabled and before
 * any retry attempt.
 */ function hi(e, n, r) {
    return t.__awaiter(this, void 0, void 0, (function() {
        var i = this;
        return t.__generator(this, (function(o) {
            switch (o.label) {
              case 0:
                if (!ir(n)) throw n;
                // Disable network and raise offline snapshots
                return e.Ko.add(1 /* IndexedDbFailed */), [ 4 /*yield*/ , Jr(e) ];

              case 1:
                // Disable network and raise offline snapshots
                return o.sent(), e.Xo.set("Offline" /* Offline */), r || (
                // Use a simple read operation to determine if IndexedDB recovered.
                // Ideally, we would expose a health check directly on SimpleDb, but
                // RemoteStore only has access to persistence through LocalStore.
                r = function() {
                    return Ur(e.Qo);
                }), 
                // Probe IndexedDB periodically and re-enable network
                e.On.os((function() {
                    return t.__awaiter(i, void 0, void 0, (function() {
                        return t.__generator(this, (function(t) {
                            switch (t.label) {
                              case 0:
                                return l("RemoteStore", "Retrying IndexedDB access"), [ 4 /*yield*/ , r() ];

                              case 1:
                                return t.sent(), e.Ko.delete(1 /* IndexedDbFailed */), [ 4 /*yield*/ , Yr(e) ];

                              case 2:
                                return t.sent(), [ 2 /*return*/ ];
                            }
                        }));
                    }));
                })), [ 2 /*return*/ ];
            }
        }));
    }));
}

/**
 * Executes `op`. If `op` fails, takes the network offline until `op`
 * succeeds. Returns after the first attempt.
 */ function fi(t, e) {
    return e().catch((function(n) {
        return hi(t, n, e);
    }));
}

function li(e) {
    return t.__awaiter(this, void 0, void 0, (function() {
        var n, r, i, o, s;
        return t.__generator(this, (function(t) {
            switch (t.label) {
              case 0:
                n = m(e), r = bi(n), i = n.Go.length > 0 ? n.Go[n.Go.length - 1].batchId : -1, t.label = 1;

              case 1:
                if (!
                /**
 * Returns true if we can add to the write pipeline (i.e. the network is
 * enabled and the write pipeline is not full).
 */
                function(t) {
                    return oi(t) && t.Go.length < 10;
                }
                /**
 * Queues additional writes to be sent to the write stream, sending them
 * immediately if the write stream is established.
 */ (n)) return [ 3 /*break*/ , 7 ];
                t.label = 2;

              case 2:
                return t.trys.push([ 2, 4, , 6 ]), [ 4 /*yield*/ , Sr(n.Qo, i) ];

              case 3:
                return null === (o = t.sent()) ? (0 === n.Go.length && r.ao(), [ 3 /*break*/ , 7 ]) : (i = o.batchId, 
                function(t, e) {
                    t.Go.push(e);
                    var n = bi(t);
                    n.oo() && n.Vo && n.vo(e.mutations);
                }(n, o), [ 3 /*break*/ , 6 ]);

              case 4:
                return s = t.sent(), [ 4 /*yield*/ , hi(n, s) ];

              case 5:
                return t.sent(), [ 3 /*break*/ , 6 ];

              case 6:
                return [ 3 /*break*/ , 1 ];

              case 7:
                return pi(n) && di(n), [ 2 /*return*/ ];
            }
        }));
    }));
}

function pi(t) {
    return oi(t) && !bi(t).ro() && t.Go.length > 0;
}

function di(t) {
    bi(t).start();
}

function vi(e) {
    return t.__awaiter(this, void 0, void 0, (function() {
        return t.__generator(this, (function(t) {
            return bi(e).Do(), [ 2 /*return*/ ];
        }));
    }));
}

function yi(e) {
    return t.__awaiter(this, void 0, void 0, (function() {
        var n, r, i, o;
        return t.__generator(this, (function(t) {
            // Send the write pipeline now that the stream is established.
            for (n = bi(e), r = 0, i = e.Go; r < i.length; r++) o = i[r], n.vo(o.mutations);
            return [ 2 /*return*/ ];
        }));
    }));
}

function gi(e, n, r) {
    return t.__awaiter(this, void 0, void 0, (function() {
        var i, o;
        return t.__generator(this, (function(t) {
            switch (t.label) {
              case 0:
                return i = e.Go.shift(), o = _r.from(i, n, r), [ 4 /*yield*/ , fi(e, (function() {
                    return e.Wo.nu(o);
                })) ];

              case 1:
                // It's possible that with the completion of this mutation another
                // slot has freed up.
                return t.sent(), [ 4 /*yield*/ , li(e) ];

              case 2:
                // It's possible that with the completion of this mutation another
                // slot has freed up.
                return t.sent(), [ 2 /*return*/ ];
            }
        }));
    }));
}

function mi(e, n) {
    return t.__awaiter(this, void 0, void 0, (function() {
        return t.__generator(this, (function(r) {
            switch (r.label) {
              case 0:
                return n && bi(e).Vo ? [ 4 /*yield*/ , function(e, n) {
                    return t.__awaiter(this, void 0, void 0, (function() {
                        var r, i;
                        return t.__generator(this, (function(t) {
                            switch (t.label) {
                              case 0:
                                return gt(i = n.code) && i !== a.ABORTED ? (r = e.Go.shift(), 
                                // In this case it's also unlikely that the server itself is melting
                                // down -- this was just a bad request so inhibit backoff on the next
                                // restart.
                                bi(e).co(), [ 4 /*yield*/ , fi(e, (function() {
                                    return e.Wo.su(r.batchId, n);
                                })) ]) : [ 3 /*break*/ , 3 ];

                              case 1:
                                // It's possible that with the completion of this mutation
                                // another slot has freed up.
                                return t.sent(), [ 4 /*yield*/ , li(e) ];

                              case 2:
                                // In this case it's also unlikely that the server itself is melting
                                // down -- this was just a bad request so inhibit backoff on the next
                                // restart.
                                // It's possible that with the completion of this mutation
                                // another slot has freed up.
                                t.sent(), t.label = 3;

                              case 3:
                                return [ 2 /*return*/ ];
                            }
                        }));
                    }));
                }(e, n) ] : [ 3 /*break*/ , 2 ];

                // This error affects the actual write.
                              case 1:
                // This error affects the actual write.
                r.sent(), r.label = 2;

              case 2:
                // If the write stream closed after the write handshake completes, a write
                // operation failed and we fail the pending operation.
                // The write stream might have been started by refilling the write
                // pipeline for failed writes
                return pi(e) && di(e), [ 2 /*return*/ ];
            }
        }));
    }));
}

/**
 * If not yet initialized, registers the WatchStream and its network state
 * callback with `remoteStoreImpl`. Returns the existing stream if one is
 * already available.
 *
 * PORTING NOTE: On iOS and Android, the WatchStream gets registered on startup.
 * This is not done on Web to allow it to be tree-shaken.
 */ function wi(e) {
    var n = this;
    return e.iu || (
    // Create stream (but note that it is not started yet).
    e.iu = function(t, e, n) {
        var r = m(t);
        return r.Fo(), new Wr(e, r.eo, r.credentials, r.serializer, n);
    }(e.jo, e.On, {
        Io: ui.bind(null, e),
        do: ai.bind(null, e),
        Ro: ci.bind(null, e)
    }), e.Ho.push((function(r) {
        return t.__awaiter(n, void 0, void 0, (function() {
            return t.__generator(this, (function(t) {
                switch (t.label) {
                  case 0:
                    return r ? (e.iu.co(), ii(e) ? ri(e) : e.Xo.set("Unknown" /* Unknown */), [ 3 /*break*/ , 3 ]) : [ 3 /*break*/ , 1 ];

                  case 1:
                    return [ 4 /*yield*/ , e.iu.stop() ];

                  case 2:
                    t.sent(), si(e), t.label = 3;

                  case 3:
                    return [ 2 /*return*/ ];
                }
            }));
        }));
    }))), e.iu
    /**
 * If not yet initialized, registers the WriteStream and its network state
 * callback with `remoteStoreImpl`. Returns the existing stream if one is
 * already available.
 *
 * PORTING NOTE: On iOS and Android, the WriteStream gets registered on startup.
 * This is not done on Web to allow it to be tree-shaken.
 */;
}

function bi(e) {
    var n = this;
    return e.ru || (
    // Create stream (but note that it is not started yet).
    e.ru = function(t, e, n) {
        var r = m(t);
        return r.Fo(), new Qr(e, r.eo, r.credentials, r.serializer, n);
    }(e.jo, e.On, {
        Io: vi.bind(null, e),
        do: mi.bind(null, e),
        So: yi.bind(null, e),
        bo: gi.bind(null, e)
    }), e.Ho.push((function(r) {
        return t.__awaiter(n, void 0, void 0, (function() {
            return t.__generator(this, (function(t) {
                switch (t.label) {
                  case 0:
                    return r ? (e.ru.co(), [ 4 /*yield*/ , li(e) ]) : [ 3 /*break*/ , 2 ];

                  case 1:
                    // This will start the write stream if necessary.
                    return t.sent(), [ 3 /*break*/ , 4 ];

                  case 2:
                    return [ 4 /*yield*/ , e.ru.stop() ];

                  case 3:
                    t.sent(), e.Go.length > 0 && (l("RemoteStore", "Stopping write stream with " + e.Go.length + " pending writes"), 
                    e.Go = []), t.label = 4;

                  case 4:
                    return [ 2 /*return*/ ];
                }
            }));
        }));
    }))), e.ru
    /**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */;
}

var Ei = function(t) {
    this.key = t;
}, _i = function(t) {
    this.key = t;
}, Ii = /** @class */ function() {
    function t(t, 
    /** Documents included in the remote target */
    e) {
        this.query = t, this.ou = e, this.uu = null, 
        /**
             * A flag whether the view is current with the backend. A view is considered
             * current after it has seen the current flag from the backend and did not
             * lose consistency within the watch stream (e.g. because of an existence
             * filter mismatch).
             */
        this.te = !1, 
        /** Documents in the view but not in the remote target */
        this.cu = Ut(), 
        /** Document Keys that have local changes */
        this.jt = Ut(), this.au = Mn(t), this.hu = new kt(this.au);
    }
    return Object.defineProperty(t.prototype, "lu", {
        /**
         * The set of remote documents that the server has told us belongs to the target associated with
         * this view.
         */
        get: function() {
            return this.ou;
        },
        enumerable: !1,
        configurable: !0
    }), 
    /**
     * Iterates over a set of doc changes, applies the query limit, and computes
     * what the new results should be, what the changes were, and whether we may
     * need to go back to the local cache for more results. Does not make any
     * changes to the view.
     * @param docChanges The doc changes to apply to this view.
     * @param previousChanges If this is being called with a refill, then start
     *        with this set of docs and changes instead of the current view.
     * @return a new set of docs, changes, and refill flag.
     */
    t.prototype._u = function(t, e) {
        var n = this, r = e ? e.fu : new jt, i = e ? e.hu : this.hu, o = e ? e.jt : this.jt, s = i, u = !1, a = An(this.query) && i.size === this.query.limit ? i.last() : null, c = Nn(this.query) && i.size === this.query.limit ? i.first() : null;
        // Drop documents out to meet limit/limitToLast requirement.
        if (t.ht((function(t, e) {
            var h = i.get(t), f = e instanceof wn ? e : null;
            f && (f = Cn(n.query, f) ? f : null);
            var l = !!h && n.jt.has(h.key), p = !!f && (f.Je || 
            // We only consider committed mutations for documents that were
            // mutated during the lifetime of the view.
            n.jt.has(f.key) && f.hasCommittedMutations), d = !1;
            // Calculate change
            h && f ? h.data().isEqual(f.data()) ? l !== p && (r.track({
                type: 3 /* Metadata */ ,
                doc: f
            }), d = !0) : n.du(h, f) || (r.track({
                type: 2 /* Modified */ ,
                doc: f
            }), d = !0, (a && n.au(f, a) > 0 || c && n.au(f, c) < 0) && (
            // This doc moved from inside the limit to outside the limit.
            // That means there may be some other doc in the local cache
            // that should be included instead.
            u = !0)) : !h && f ? (r.track({
                type: 0 /* Added */ ,
                doc: f
            }), d = !0) : h && !f && (r.track({
                type: 1 /* Removed */ ,
                doc: h
            }), d = !0, (a || c) && (
            // A doc was removed from a full limit query. We'll need to
            // requery from the local cache to see if we know about some other
            // doc that should be in the results.
            u = !0)), d && (f ? (s = s.add(f), o = p ? o.add(t) : o.delete(t)) : (s = s.delete(t), 
            o = o.delete(t)));
        })), An(this.query) || Nn(this.query)) for (;s.size > this.query.limit; ) {
            var h = An(this.query) ? s.last() : s.first();
            s = s.delete(h.key), o = o.delete(h.key), r.track({
                type: 1 /* Removed */ ,
                doc: h
            });
        }
        return {
            hu: s,
            fu: r,
            wu: u,
            jt: o
        };
    }, t.prototype.du = function(t, e) {
        // We suppress the initial change event for documents that were modified as
        // part of a write acknowledgment (e.g. when the value of a server transform
        // is applied) as Watch will send us the same document again.
        // By suppressing the event, we only raise two user visible events (one with
        // `hasPendingWrites` and the final state of the document) instead of three
        // (one with `hasPendingWrites`, the modified document with
        // `hasPendingWrites` and the final state of the document).
        return t.Je && e.hasCommittedMutations && !e.Je;
    }, 
    /**
     * Updates the view with the given ViewDocumentChanges and optionally updates
     * limbo docs and sync state from the provided target change.
     * @param docChanges The set of changes to make to the view's docs.
     * @param updateLimboDocuments Whether to update limbo documents based on this
     *        change.
     * @param targetChange A target change to apply for computing limbo docs and
     *        sync state.
     * @return A new ViewChange with the given docs, changes, and sync state.
     */
    // PORTING NOTE: The iOS/Android clients always compute limbo document changes.
    t.prototype.mu = function(t, e, n) {
        var r = this, i = this.hu;
        this.hu = t.hu, this.jt = t.jt;
        // Sort changes based on type and query comparator
        var o = t.fu.Bt();
        o.sort((function(t, e) {
            return function(t, e) {
                var n = function(t) {
                    switch (t) {
                      case 0 /* Added */ :
                        return 1;

                      case 2 /* Modified */ :
                      case 3 /* Metadata */ :
                        // A metadata change is converted to a modified change at the public
                        // api layer.  Since we sort by document key and then change type,
                        // metadata and modified changes must be sorted equivalently.
                        return 2;

                      case 1 /* Removed */ :
                        return 0;

                      default:
                        return y();
                    }
                };
                return n(t) - n(e);
            }(t.type, e.type) || r.au(t.doc, e.doc);
        })), this.Tu(n);
        var s = e ? this.Eu() : [], u = 0 === this.cu.size && this.te ? 1 /* Synced */ : 0 /* Local */ , a = u !== this.uu;
        return this.uu = u, 0 !== o.length || a ? {
            snapshot: new Pt(this.query, t.hu, i, o, t.jt, 0 /* Local */ === u, a, 
            /* excludesMetadataChanges= */ !1),
            Iu: s
        } : {
            Iu: s
        };
        // no changes
        }, 
    /**
     * Applies an OnlineState change to the view, potentially generating a
     * ViewChange if the view's syncState changes as a result.
     */
    t.prototype.As = function(t) {
        return this.te && "Offline" /* Offline */ === t ? (
        // If we're offline, set `current` to false and then call applyChanges()
        // to refresh our syncState and generate a ViewChange as appropriate. We
        // are guaranteed to get a new TargetChange that sets `current` back to
        // true once the client is back online.
        this.te = !1, this.mu({
            hu: this.hu,
            fu: new jt,
            jt: this.jt,
            wu: !1
        }, 
        /* updateLimboDocuments= */ !1)) : {
            Iu: []
        };
    }, 
    /**
     * Returns whether the doc for the given key should be in limbo.
     */
    t.prototype.Au = function(t) {
        // If the remote end says it's part of this query, it's not in limbo.
        return !this.ou.has(t) && 
        // The local store doesn't think it's a result, so it shouldn't be in limbo.
        !!this.hu.has(t) && !this.hu.get(t).Je;
    }, 
    /**
     * Updates syncedDocuments, current, and limbo docs based on the given change.
     * Returns the list of changes to which docs are in limbo.
     */
    t.prototype.Tu = function(t) {
        var e = this;
        t && (t.ee.forEach((function(t) {
            return e.ou = e.ou.add(t);
        })), t.ne.forEach((function(t) {})), t.se.forEach((function(t) {
            return e.ou = e.ou.delete(t);
        })), this.te = t.te);
    }, t.prototype.Eu = function() {
        var t = this;
        // We can only determine limbo documents when we're in-sync with the server.
                if (!this.te) return [];
        // TODO(klimt): Do this incrementally so that it's not quadratic when
        // updating many documents.
                var e = this.cu;
        this.cu = Ut(), this.hu.forEach((function(e) {
            t.Au(e.key) && (t.cu = t.cu.add(e.key));
        }));
        // Diff the new limbo docs with the old limbo docs.
        var n = [];
        return e.forEach((function(e) {
            t.cu.has(e) || n.push(new _i(e));
        })), this.cu.forEach((function(t) {
            e.has(t) || n.push(new Ei(t));
        })), n;
    }, 
    /**
     * Update the in-memory state of the current view with the state read from
     * persistence.
     *
     * We update the query view whenever a client's primary status changes:
     * - When a client transitions from primary to secondary, it can miss
     *   LocalStorage updates and its query views may temporarily not be
     *   synchronized with the state on disk.
     * - For secondary to primary transitions, the client needs to update the list
     *   of `syncedDocuments` since secondary clients update their query views
     *   based purely on synthesized RemoteEvents.
     *
     * @param queryResult.documents - The documents that match the query according
     * to the LocalStore.
     * @param queryResult.remoteKeys - The keys of the documents that match the
     * query according to the backend.
     *
     * @return The ViewChange that resulted from this synchronization.
     */
    // PORTING NOTE: Multi-tab only.
    t.prototype.Ru = function(t) {
        this.ou = t.Vr, this.cu = Ut();
        var e = this._u(t.documents);
        return this.mu(e, /*updateLimboDocuments=*/ !0);
    }, 
    /**
     * Returns a view snapshot as if this query was just listened to. Contains
     * a document add for every existing document and the `fromCache` and
     * `hasPendingWrites` status of the already established view.
     */
    // PORTING NOTE: Multi-tab only.
    t.prototype.yu = function() {
        return Pt.zt(this.query, this.hu, this.jt, 0 /* Local */ === this.uu);
    }, t;
}(), Ai = function(
/**
     * The query itself.
     */
t, 
/**
     * The target number created by the client that is used in the watch
     * stream to identify this query.
     */
e, 
/**
     * The view is responsible for computing the final merged truth of what
     * docs are in the query. It gets notified of local and remote changes,
     * and applies the query filters and limits to determine the most correct
     * possible results.
     */
n) {
    this.query = t, this.targetId = e, this.view = n;
}, Ni = function(t) {
    this.key = t, 
    /**
             * Set to true once we've received a document. This is used in
             * getRemoteKeysForTarget() and ultimately used by WatchChangeAggregator to
             * decide whether it needs to manufacture a delete event for the target once
             * the target is CURRENT.
             */
    this.Pu = !1;
}, Ti = /** @class */ function() {
    function t(t, e, n, 
    // PORTING NOTE: Manages state synchronization in multi-tab environments.
    r, i, o) {
        this.Qo = t, this.gu = e, this.pu = n, this.Vu = r, this.currentUser = i, this.vu = o, 
        this.bu = {}, this.Su = new rt((function(t) {
            return jn(t);
        }), kn), this.Du = new Map, 
        /**
             * The keys of documents that are in limbo for which we haven't yet started a
             * limbo resolution query.
             */
        this.Cu = [], 
        /**
             * Keeps track of the target ID for each document that is in limbo with an
             * active target.
             */
        this.Fu = new wt(T.i), 
        /**
             * Keeps track of the information about an active limbo resolution for each
             * active target ID that was started for the purpose of limbo resolution.
             */
        this.Nu = new Map, this.$u = new Cr, 
        /** Stores user completion handlers, indexed by User and BatchId. */
        this.xu = {}, 
        /** Stores user callbacks waiting for all pending writes to be acknowledged. */
        this.ku = new Map, this.Ou = Vr.Gi(), this.onlineState = "Unknown" /* Unknown */ , 
        // The primary state is set to `true` or `false` immediately after Firestore
        // startup. In the interim, a client should only be considered primary if
        // `isPrimary` is true.
        this.Lu = void 0;
    }
    return Object.defineProperty(t.prototype, "Mu", {
        get: function() {
            return !0 === this.Lu;
        },
        enumerable: !1,
        configurable: !0
    }), t;
}();

/**
 * Initiates the new listen, resolves promise when listen enqueued to the
 * server. All the subsequent view snapshots or errors are sent to the
 * subscribed handlers. Returns the initial snapshot.
 */
function Di(e, n) {
    return t.__awaiter(this, void 0, void 0, (function() {
        var r, i, o, s, u, a;
        return t.__generator(this, (function(c) {
            switch (c.label) {
              case 0:
                return r = function(t) {
                    var e = m(t);
                    return e.gu.Wo.eu = Li.bind(null, e), e.gu.Wo.Ue = zi.bind(null, e), e.gu.Wo.tu = Oi.bind(null, e), 
                    e.bu.Ro = pr.bind(null, e.pu), e.bu.qu = dr.bind(null, e.pu), e;
                }(e), (s = r.Su.get(n)) ? (
                // PORTING NOTE: With Multi-Tab Web, it is possible that a query view
                // already exists when EventManager calls us for the first time. This
                // happens when the primary tab is already listening to this query on
                // behalf of another tab and the user of the primary also starts listening
                // to the query. EventManager will not have an assigned target ID in this
                // case and calls `listen` to obtain this ID.
                i = s.targetId, r.Vu.zs(i), o = s.view.yu(), [ 3 /*break*/ , 4 ]) : [ 3 /*break*/ , 1 ];

              case 1:
                return [ 4 /*yield*/ , 
                /**
             * Assigns the given target an internal ID so that its results can be pinned so
             * they don't get GC'd. A target must be allocated in the local store before
             * the store can be used to manage its view.
             *
             * Allocating an already allocated `Target` will return the existing `TargetData`
             * for that `Target`.
             */
                function(t, e) {
                    var n = m(t);
                    return n.persistence.runTransaction("Allocate target", "readwrite", (function(t) {
                        var r;
                        return n.tr.gr(t, e).next((function(i) {
                            return i ? (
                            // This target has been listened to previously, so reuse the
                            // previous targetID.
                            // TODO(mcg): freshen last accessed date?
                            r = i, rr.resolve(r)) : n.tr.Uu(t).next((function(i) {
                                return r = new vt(e, i, 0 /* Listen */ , t.Tr), n.tr.Bu(t, r).next((function() {
                                    return r;
                                }));
                            }));
                        }));
                    })).then((function(t) {
                        // If Multi-Tab is enabled, the existing target data may be newer than
                        // the in-memory data
                        var r = n.Ki.get(t.targetId);
                        return (null === r || t.nt.M(r.nt) > 0) && (n.Ki = n.Ki.ot(t.targetId, t), n.Hi.set(e, t.targetId)), 
                        t;
                    }));
                }(r.Qo, Ln(n)) ];

              case 2:
                return u = c.sent(), a = r.Vu.zs(u.targetId), i = u.targetId, [ 4 /*yield*/ , 
                /**
                 * Registers a view for a previously unknown query and computes its initial
                 * snapshot.
                 */
                function(e, n, r, i) {
                    return t.__awaiter(this, void 0, void 0, (function() {
                        var o, s, u, a, c, h;
                        return t.__generator(this, (function(f) {
                            switch (f.label) {
                              case 0:
                                // PORTING NOTE: On Web only, we inject the code that registers new Limbo
                                // targets based on view changes. This allows us to only depend on Limbo
                                // changes when user code includes queries.
                                return e.Qu = function(n, r, i) {
                                    return function(e, n, r, i) {
                                        return t.__awaiter(this, void 0, void 0, (function() {
                                            var o, s, u;
                                            return t.__generator(this, (function(t) {
                                                switch (t.label) {
                                                  case 0:
                                                    return o = n.view._u(r), o.wu ? [ 4 /*yield*/ , jr(e.Qo, n.query, 
                                                    /* usePreviousResults= */ !1).then((function(t) {
                                                        var e = t.documents;
                                                        return n.view._u(e, o);
                                                    })) ] : [ 3 /*break*/ , 2 ];

                                                  case 1:
                                                    // The query has a limit and some docs were removed, so we need
                                                    // to re-run the query against the local store to make sure we
                                                    // didn't lose any good docs that had been past the limit.
                                                    o = t.sent(), t.label = 2;

                                                  case 2:
                                                    return s = i && i.Kt.get(n.targetId), u = n.view.mu(o, 
                                                    /* updateLimboDocuments= */ e.Mu, s), [ 2 /*return*/ , (xi(e, n.targetId, u.Iu), 
                                                    u.snapshot) ];
                                                }
                                            }));
                                        }));
                                    }(e, n, r, i);
                                }, [ 4 /*yield*/ , jr(e.Qo, n, 
                                /* usePreviousResults= */ !0) ];

                              case 1:
                                return o = f.sent(), s = new Ii(n, o.Vr), u = s._u(o.documents), a = Mt.Zt(r, i && "Offline" /* Offline */ !== e.onlineState), 
                                c = s.mu(u, 
                                /* updateLimboDocuments= */ e.Mu, a), xi(e, r, c.Iu), h = new Ai(n, r, s), e.Su.set(n, h), 
                                e.Du.has(r) ? e.Du.get(r).push(n) : e.Du.set(r, [ n ]), [ 2 /*return*/ , c.snapshot ];
                            }
                        }));
                    }));
                }(r, n, i, "current" === a) ];

              case 3:
                o = c.sent(), r.Mu && Zr(r.gu, u), c.label = 4;

              case 4:
                return [ 2 /*return*/ , o ];
            }
        }));
    }));
}

function Vi(e, n) {
    return t.__awaiter(this, void 0, void 0, (function() {
        var r, i, o;
        return t.__generator(this, (function(t) {
            switch (t.label) {
              case 0:
                return r = m(e), i = r.Su.get(n), (o = r.Du.get(i.targetId)).length > 1 ? [ 2 /*return*/ , (r.Du.set(i.targetId, o.filter((function(t) {
                    return !kn(t, n);
                }))), void r.Su.delete(n)) ] : r.Mu ? (
                // We need to remove the local query target first to allow us to verify
                // whether any other client is still interested in this target.
                r.Vu.Hs(i.targetId), r.Vu.Zs(i.targetId) ? [ 3 /*break*/ , 2 ] : [ 4 /*yield*/ , kr(r.Qo, i.targetId, 
                /*keepPersistedTargetData=*/ !1).then((function() {
                    r.Vu.Js(i.targetId), ti(r.gu, i.targetId), Ci(r, i.targetId);
                })).catch(Pr) ]) : [ 3 /*break*/ , 3 ];

              case 1:
                t.sent(), t.label = 2;

              case 2:
                return [ 3 /*break*/ , 5 ];

              case 3:
                return Ci(r, i.targetId), [ 4 /*yield*/ , kr(r.Qo, i.targetId, 
                /*keepPersistedTargetData=*/ !0) ];

              case 4:
                t.sent(), t.label = 5;

              case 5:
                return [ 2 /*return*/ ];
            }
        }));
    }));
}

/**
 * Initiates the write of local mutation batch which involves adding the
 * writes to the mutation queue, notifying the remote store about new
 * mutations and raising events for any changes this write caused.
 *
 * The promise returned by this call is resolved when the above steps
 * have completed, *not* when the write was acked by the backend. The
 * userCallback is resolved once the write was acked/rejected by the
 * backend (or failed locally for any other reason).
 */ function Ri(e, n, r) {
    return t.__awaiter(this, void 0, void 0, (function() {
        var i, o, s, u;
        return t.__generator(this, (function(t) {
            switch (t.label) {
              case 0:
                i = function(t) {
                    var e = m(t);
                    return e.gu.Wo.nu = Si.bind(null, e), e.gu.Wo.su = ki.bind(null, e), e;
                }(e), t.label = 1;

              case 1:
                return t.trys.push([ 1, 5, , 6 ]), [ 4 /*yield*/ , 
                /* Accepts locally generated Mutations and commit them to storage. */
                function(t, e) {
                    var n, r = m(t), i = it.now(), o = e.reduce((function(t, e) {
                        return t.add(e.key);
                    }), Ut());
                    return r.persistence.runTransaction("Locally write mutations", "readwrite", (function(t) {
                        return r.nr.Ei(t, o).next((function(o) {
                            n = o;
                            for (
                            // For non-idempotent mutations (such as `FieldValue.increment()`),
                            // we record the base state in a separate patch mutation. This is
                            // later used to guarantee consistent values and prevents flicker
                            // even if the backend sends us an update that already includes our
                            // transform.
                            var s = [], u = 0, a = e; u < a.length; u++) {
                                var c = a[u], h = rn(c, n.get(c.key));
                                null != h && 
                                // NOTE: The base state should only be applied if there's some
                                // existing document to override, so use a Precondition of
                                // exists=true
                                s.push(new an(c.key, h, gn(h.proto.mapValue), $e.exists(!0)));
                            }
                            return r.li.ju(t, i, s, e);
                        }));
                    })).then((function(t) {
                        var e = t.ui(n);
                        return {
                            batchId: t.batchId,
                            Wu: e
                        };
                    }));
                }(i.Qo, n) ];

              case 2:
                return o = t.sent(), i.Vu.Ws(o.batchId), function(t, e, n) {
                    var r = t.xu[t.currentUser.Cs()];
                    r || (r = new wt(X)), r = r.ot(e, n), t.xu[t.currentUser.Cs()] = r;
                }(i, o.batchId, r), [ 4 /*yield*/ , Bi(i, o.Wu) ];

              case 3:
                return t.sent(), [ 4 /*yield*/ , li(i.gu) ];

              case 4:
                return t.sent(), [ 3 /*break*/ , 6 ];

              case 5:
                return s = t.sent(), u = ar(s, "Failed to persist write"), r.reject(u), [ 3 /*break*/ , 6 ];

              case 6:
                return [ 2 /*return*/ ];
            }
        }));
    }));
}

/**
 * Applies one remote event to the sync engine, notifying any views of the
 * changes, and releasing any pending mutation batches that would become
 * visible because of the snapshot version the remote event contains.
 */ function Li(e, n) {
    return t.__awaiter(this, void 0, void 0, (function() {
        var r, i;
        return t.__generator(this, (function(t) {
            switch (t.label) {
              case 0:
                r = m(e), t.label = 1;

              case 1:
                return t.trys.push([ 1, 4, , 6 ]), [ 4 /*yield*/ , Or(r.Qo, n) ];

              case 2:
                return i = t.sent(), 
                // Update `receivedDocument` as appropriate for any limbo targets.
                n.Kt.forEach((function(t, e) {
                    var n = r.Nu.get(e);
                    n && (
                    // Since this is a limbo resolution lookup, it's for a single document
                    // and it could be added, modified, or removed, but not a combination.
                    g(t.ee.size + t.ne.size + t.se.size <= 1), t.ee.size > 0 ? n.Pu = !0 : t.ne.size > 0 ? g(n.Pu) : t.se.size > 0 && (g(n.Pu), 
                    n.Pu = !1));
                })), [ 4 /*yield*/ , Bi(r, i, n) ];

              case 3:
                // Update `receivedDocument` as appropriate for any limbo targets.
                return t.sent(), [ 3 /*break*/ , 6 ];

              case 4:
                return [ 4 /*yield*/ , Pr(t.sent()) ];

              case 5:
                return t.sent(), [ 3 /*break*/ , 6 ];

              case 6:
                return [ 2 /*return*/ ];
            }
        }));
    }));
}

/**
 * Applies an OnlineState change to the sync engine and notifies any views of
 * the change.
 */ function Ui(t, e, n) {
    var r = m(t);
    // If we are the secondary client, we explicitly ignore the remote store's
    // online state (the local client may go offline, even though the primary
    // tab remains online) and only apply the primary tab's online state from
    // SharedClientState.
        if (r.Mu && 0 /* RemoteStore */ === n || !r.Mu && 1 /* SharedClientState */ === n) {
        var i = [];
        r.Su.forEach((function(t, n) {
            var r = n.view.As(e);
            r.snapshot && i.push(r.snapshot);
        })), function(t, e) {
            var n = m(t);
            n.onlineState = e;
            var r = !1;
            n.Ts.forEach((function(t, n) {
                for (var i = 0, o = n.listeners; i < o.length; i++) {
                    // Run global snapshot listeners if a consistent snapshot has been emitted.
                    o[i].As(e) && (r = !0);
                }
            })), r && vr(n);
        }(r.pu, e), i.length && r.bu.Ro(i), r.onlineState = e, r.Mu && r.Vu.ei(e);
    }
}

/**
 * Rejects the listen for the given targetID. This can be triggered by the
 * backend for any active target.
 *
 * @param syncEngine The sync engine implementation.
 * @param targetId The targetID corresponds to one previously initiated by the
 * user as part of TargetData passed to listen() on RemoteStore.
 * @param err A description of the condition that has forced the rejection.
 * Nearly always this will be an indication that the user is no longer
 * authorized to see the data matching the target.
 */ function Oi(e, n, r) {
    return t.__awaiter(this, void 0, void 0, (function() {
        var i, o, s, u, a, c;
        return t.__generator(this, (function(t) {
            switch (t.label) {
              case 0:
                // PORTING NOTE: Multi-tab only.
                return (i = m(e)).Vu.Ks(n, "rejected", r), o = i.Nu.get(n), (s = o && o.key) ? (u = (u = new wt(T.i)).ot(s, new bn(s, ot.min())), 
                a = Ut().add(s), c = new Ct(ot.min(), 
                /* targetChanges= */ new Map, 
                /* targetMismatches= */ new _t(X), u, a), [ 4 /*yield*/ , Li(i, c) ]) : [ 3 /*break*/ , 2 ];

              case 1:
                return t.sent(), 
                // Since this query failed, we won't want to manually unlisten to it.
                // We only remove it from bookkeeping after we successfully applied the
                // RemoteEvent. If `applyRemoteEvent()` throws, we want to re-listen to
                // this query when the RemoteStore restarts the Watch stream, which should
                // re-trigger the target failure.
                i.Fu = i.Fu.remove(s), i.Nu.delete(n), Fi(i), [ 3 /*break*/ , 4 ];

              case 2:
                return [ 4 /*yield*/ , kr(i.Qo, n, 
                /* keepPersistedTargetData */ !1).then((function() {
                    return Ci(i, n, r);
                })).catch(Pr) ];

              case 3:
                t.sent(), t.label = 4;

              case 4:
                return [ 2 /*return*/ ];
            }
        }));
    }));
}

function Si(e, n) {
    return t.__awaiter(this, void 0, void 0, (function() {
        var r, i, o;
        return t.__generator(this, (function(t) {
            switch (t.label) {
              case 0:
                r = m(e), i = n.batch.batchId, t.label = 1;

              case 1:
                return t.trys.push([ 1, 4, , 6 ]), [ 4 /*yield*/ , Lr(r.Qo, n) ];

              case 2:
                return o = t.sent(), 
                // The local store may or may not be able to apply the write result and
                // raise events immediately (depending on whether the watcher is caught
                // up), so we raise user callbacks first so that they consistently happen
                // before listen events.
                Pi(r, i, /*error=*/ null), ji(r, i), r.Vu.Gs(i, "acknowledged"), [ 4 /*yield*/ , Bi(r, o) ];

              case 3:
                // The local store may or may not be able to apply the write result and
                // raise events immediately (depending on whether the watcher is caught
                // up), so we raise user callbacks first so that they consistently happen
                // before listen events.
                return t.sent(), [ 3 /*break*/ , 6 ];

              case 4:
                return [ 4 /*yield*/ , Pr(t.sent()) ];

              case 5:
                return t.sent(), [ 3 /*break*/ , 6 ];

              case 6:
                return [ 2 /*return*/ ];
            }
        }));
    }));
}

function ki(e, n, r) {
    return t.__awaiter(this, void 0, void 0, (function() {
        var i, o;
        return t.__generator(this, (function(t) {
            switch (t.label) {
              case 0:
                i = m(e), t.label = 1;

              case 1:
                return t.trys.push([ 1, 4, , 6 ]), [ 4 /*yield*/ , function(t, e) {
                    var n = m(t);
                    return n.persistence.runTransaction("Reject batch", "readwrite-primary", (function(t) {
                        var r;
                        return n.li.Gu(t, e).next((function(e) {
                            return g(null !== e), r = e.keys(), n.li.lr(t, e);
                        })).next((function() {
                            return n.li._r(t);
                        })).next((function() {
                            return n.nr.Ei(t, r);
                        }));
                    }));
                }(i.Qo, n) ];

              case 2:
                return o = t.sent(), 
                // The local store may or may not be able to apply the write result and
                // raise events immediately (depending on whether the watcher is caught up),
                // so we raise user callbacks first so that they consistently happen before
                // listen events.
                Pi(i, n, r), ji(i, n), i.Vu.Gs(n, "rejected", r), [ 4 /*yield*/ , Bi(i, o) ];

              case 3:
                // The local store may or may not be able to apply the write result and
                // raise events immediately (depending on whether the watcher is caught up),
                // so we raise user callbacks first so that they consistently happen before
                // listen events.
                return t.sent(), [ 3 /*break*/ , 6 ];

              case 4:
                return [ 4 /*yield*/ , Pr(t.sent()) ];

              case 5:
                return t.sent(), [ 3 /*break*/ , 6 ];

              case 6:
                return [ 2 /*return*/ ];
            }
        }));
    }));
}

/**
 * Registers a user callback that resolves when all pending mutations at the moment of calling
 * are acknowledged .
 */
/**
 * Triggers the callbacks that are waiting for this batch id to get acknowledged by server,
 * if there are any.
 */
function ji(t, e) {
    (t.ku.get(e) || []).forEach((function(t) {
        t.resolve();
    })), t.ku.delete(e)
    /** Reject all outstanding callbacks waiting for pending writes to complete. */;
}

function Pi(t, e, n) {
    var r = m(t), i = r.xu[r.currentUser.Cs()];
    // NOTE: Mutations restored from persistence won't have callbacks, so it's
    // okay for there to be no callback for this ID.
    if (i) {
        var o = i.get(e);
        o && (n ? o.reject(n) : o.resolve(), i = i.remove(e)), r.xu[r.currentUser.Cs()] = i;
    }
}

function Ci(t, e, n) {
    void 0 === n && (n = null), t.Vu.Hs(e);
    for (var r = 0, i = t.Du.get(e); r < i.length; r++) {
        var o = i[r];
        t.Su.delete(o), n && t.bu.qu(o, n);
    }
    t.Du.delete(e), t.Mu && t.$u.Or(e).forEach((function(e) {
        t.$u.qr(e) || 
        // We removed the last reference for this key
        Mi(t, e);
    }));
}

function Mi(t, e) {
    // It's possible that the target already got removed because the query failed. In that case,
    // the key won't exist in `limboTargetsByKey`. Only do the cleanup if we still have the target.
    var n = t.Fu.get(e);
    null !== n && (ti(t.gu, n), t.Fu = t.Fu.remove(e), t.Nu.delete(n), Fi(t));
}

function xi(t, e, n) {
    for (var r = 0, i = n; r < i.length; r++) {
        var o = i[r];
        o instanceof Ei ? (t.$u.Cr(o.key, e), qi(t, o)) : o instanceof _i ? (l("SyncEngine", "Document no longer in limbo: " + o.key), 
        t.$u.Nr(o.key, e), t.$u.qr(o.key) || 
        // We removed the last reference for this key
        Mi(t, o.key)) : y();
    }
}

function qi(t, e) {
    var n = e.key;
    t.Fu.get(n) || (l("SyncEngine", "New document in limbo: " + n), t.Cu.push(n), Fi(t));
}

/**
 * Starts listens for documents in limbo that are enqueued for resolution,
 * subject to a maximum number of concurrent resolutions.
 *
 * Without bounding the number of concurrent resolutions, the server can fail
 * with "resource exhausted" errors which can lead to pathological client
 * behavior as seen in https://github.com/firebase/firebase-js-sdk/issues/2683.
 */ function Fi(t) {
    for (;t.Cu.length > 0 && t.Fu.size < t.vu; ) {
        var e = t.Cu.shift(), n = t.Ou.next();
        t.Nu.set(n, new Ni(e)), t.Fu = t.Fu.ot(e, n), Zr(t.gu, new vt(Ln(In(e.path)), n, 2 /* LimboResolution */ , mr.Ls));
    }
}

function Bi(e, n, r) {
    return t.__awaiter(this, void 0, void 0, (function() {
        var i, o, s, u;
        return t.__generator(this, (function(a) {
            switch (a.label) {
              case 0:
                return i = m(e), o = [], s = [], u = [], i.Su.m() ? [ 3 /*break*/ , 3 ] : (i.Su.forEach((function(t, e) {
                    u.push(i.Qu(e, n, r).then((function(t) {
                        if (t) {
                            i.Mu && i.Vu.Ks(e.targetId, t.fromCache ? "not-current" : "current"), o.push(t);
                            var n = Ar.Di(e.targetId, t);
                            s.push(n);
                        }
                    })));
                })), [ 4 /*yield*/ , Promise.all(u) ]);

              case 1:
                return a.sent(), i.bu.Ro(o), [ 4 /*yield*/ , function(e, n) {
                    return t.__awaiter(this, void 0, void 0, (function() {
                        var r, i, o, s, u, a, c, h, f;
                        return t.__generator(this, (function(t) {
                            switch (t.label) {
                              case 0:
                                r = m(e), t.label = 1;

                              case 1:
                                return t.trys.push([ 1, 3, , 4 ]), [ 4 /*yield*/ , r.persistence.runTransaction("notifyLocalViewChanges", "readwrite", (function(t) {
                                    return rr.forEach(n, (function(e) {
                                        return rr.forEach(e.bi, (function(n) {
                                            return r.persistence.Rr.Cr(t, e.targetId, n);
                                        })).next((function() {
                                            return rr.forEach(e.Si, (function(n) {
                                                return r.persistence.Rr.Nr(t, e.targetId, n);
                                            }));
                                        }));
                                    }));
                                })) ];

                              case 2:
                                return t.sent(), [ 3 /*break*/ , 4 ];

                              case 3:
                                if (!ir(i = t.sent())) throw i;
                                // If `notifyLocalViewChanges` fails, we did not advance the sequence
                                // number for the documents that were included in this transaction.
                                // This might trigger them to be deleted earlier than they otherwise
                                // would have, but it should not invalidate the integrity of the data.
                                                                return l("LocalStore", "Failed to update sequence numbers: " + i), 
                                [ 3 /*break*/ , 4 ];

                              case 4:
                                for (o = 0, s = n; o < s.length; o++) u = s[o], a = u.targetId, u.fromCache || (c = r.Ki.get(a), 
                                h = c.nt, f = c.rt(h), 
                                // Advance the last limbo free snapshot version
                                r.Ki = r.Ki.ot(a, f));
                                return [ 2 /*return*/ ];
                            }
                        }));
                    }));
                }(i.Qo, s) ];

              case 2:
                a.sent(), a.label = 3;

              case 3:
                return [ 2 /*return*/ ];
            }
        }));
    }));
}

function Gi(e, n) {
    return t.__awaiter(this, void 0, void 0, (function() {
        var r, i;
        return t.__generator(this, (function(o) {
            switch (o.label) {
              case 0:
                return (r = m(e)).currentUser.isEqual(n) ? [ 3 /*break*/ , 3 ] : (l("SyncEngine", "User change. New user:", n.Cs()), 
                [ 4 /*yield*/ , 
                /**
                 * Tells the LocalStore that the currently authenticated user has changed.
                 *
                 * In response the local store switches the mutation queue to the new user and
                 * returns any resulting document changes.
                 */
                // PORTING NOTE: Android and iOS only return the documents affected by the
                // change.
                function(e, n) {
                    return t.__awaiter(this, void 0, void 0, (function() {
                        var r, i, o, s;
                        return t.__generator(this, (function(t) {
                            switch (t.label) {
                              case 0:
                                return r = m(e), i = r.li, o = r.nr, [ 4 /*yield*/ , r.persistence.runTransaction("Handle user change", "readonly", (function(t) {
                                    // Swap out the mutation queue, grabbing the pending mutation batches
                                    // before and after.
                                    var e;
                                    return r.li.Ku(t).next((function(s) {
                                        return e = s, i = r.persistence.Ji(n), 
                                        // Recreate our LocalDocumentsView using the new
                                        // MutationQueue.
                                        o = new Ir(r.Xi, i, r.persistence.sr()), i.Ku(t);
                                    })).next((function(n) {
                                        for (var r = [], i = [], s = Ut(), u = 0, a = e
                                        // Union the old/new changed keys.
                                        ; u < a.length; u++) {
                                            var c = a[u];
                                            r.push(c.batchId);
                                            for (var h = 0, f = c.mutations; h < f.length; h++) {
                                                var l = f[h];
                                                s = s.add(l.key);
                                            }
                                        }
                                        for (var p = 0, d = n; p < d.length; p++) {
                                            var v = d[p];
                                            i.push(v.batchId);
                                            for (var y = 0, g = v.mutations; y < g.length; y++) {
                                                var m = g[y];
                                                s = s.add(m.key);
                                            }
                                        }
                                        // Return the set of all (potentially) changed documents and the list
                                        // of mutation batch IDs that were affected by change.
                                                                                return o.Ei(t, s).next((function(t) {
                                            return {
                                                Hu: t,
                                                Yu: r,
                                                Ju: i
                                            };
                                        }));
                                    }));
                                })) ];

                              case 1:
                                return s = t.sent(), [ 2 /*return*/ , (r.li = i, r.nr = o, r.zi.ir(r.nr), s) ];
                            }
                        }));
                    }));
                }(r.Qo, n) ]);

              case 1:
                return i = o.sent(), r.currentUser = n, 
                // Fails tasks waiting for pending writes requested by previous user.
                function(t, e) {
                    t.ku.forEach((function(t) {
                        t.forEach((function(t) {
                            t.reject(new c(a.CANCELLED, "'waitForPendingWrites' promise is rejected due to a user change."));
                        }));
                    })), t.ku.clear();
                }(r), 
                // TODO(b/114226417): Consider calling this only in the primary tab.
                r.Vu.ti(n, i.Yu, i.Ju), [ 4 /*yield*/ , Bi(r, i.Hu) ];

              case 2:
                o.sent(), o.label = 3;

              case 3:
                return [ 2 /*return*/ ];
            }
        }));
    }));
}

function zi(t, e) {
    var n = m(t), r = n.Nu.get(e);
    if (r && r.Pu) return Ut().add(r.key);
    var i = Ut(), o = n.Du.get(e);
    if (!o) return i;
    for (var s = 0, u = o; s < u.length; s++) {
        var a = u[s], c = n.Su.get(a);
        i = i.kt(c.view.lu);
    }
    return i;
}

var Wi = /** @class */ function() {
    function t() {}
    return t.prototype.ir = function(t) {
        this.Xu = t;
    }, t.prototype.Ri = function(t, e, r, i) {
        var o = this;
        // Queries that match all documents don't benefit from using
        // IndexFreeQueries. It is more efficient to scan all documents in a
        // collection, rather than to perform individual lookups.
                return function(t) {
            return 0 === t.filters.length && null === t.limit && null == t.startAt && null == t.endAt && (0 === t.on.length || 1 === t.on.length && t.on[0].field.V());
        }(e) || r.isEqual(ot.min()) ? this.Zu(t, e) : this.Xu.Ei(t, i).next((function(s) {
            var u = o.tc(e, s);
            return (An(e) || Nn(e)) && o.wu(e.un, u, i, r) ? o.Zu(t, e) : (f() <= n.LogLevel.DEBUG && l("IndexFreeQueryEngine", "Re-using previous result from %s to execute query: %s", r.toString(), Pn(e)), 
            o.Xu.Ri(t, e, r).next((function(t) {
                // We merge `previousResults` into `updateResults`, since
                // `updateResults` is already a DocumentMap. If a document is
                // contained in both lists, then its contents are the same.
                return u.forEach((function(e) {
                    t = t.ot(e.key, e);
                })), t;
            })));
        }));
        // Queries that have never seen a snapshot without limbo free documents
        // should also be run as a full collection scan.
        }, 
    /** Applies the query filter and sorting to the provided documents.  */ t.prototype.tc = function(t, e) {
        // Sort the documents and re-apply the query filter since previously
        // matching documents do not necessarily still match the query.
        var n = new _t(Mn(t));
        return e.forEach((function(e, r) {
            r instanceof wn && Cn(t, r) && (n = n.add(r));
        })), n;
    }, 
    /**
     * Determines if a limit query needs to be refilled from cache, making it
     * ineligible for index-free execution.
     *
     * @param sortedPreviousResults The documents that matched the query when it
     * was last synchronized, sorted by the query's comparator.
     * @param remoteKeys The document keys that matched the query at the last
     * snapshot.
     * @param limboFreeSnapshotVersion The version of the snapshot when the query
     * was last synchronized.
     */
    t.prototype.wu = function(t, e, n, r) {
        // The query needs to be refilled if a previously matching document no
        // longer matches.
        if (n.size !== e.size) return !0;
        // Limit queries are not eligible for index-free query execution if there is
        // a potential that an older document from cache now sorts before a document
        // that was previously part of the limit. This, however, can only happen if
        // the document at the edge of the limit goes out of limit.
        // If a document that is not the limit boundary sorts differently,
        // the boundary of the limit itself did not change and documents from cache
        // will continue to be "rejected" by this boundary. Therefore, we can ignore
        // any modifications that don't affect the last document.
                var i = "F" /* First */ === t ? e.last() : e.first();
        return !!i && (i.hasPendingWrites || i.version.M(r) > 0);
    }, t.prototype.Zu = function(t, e) {
        return f() <= n.LogLevel.DEBUG && l("IndexFreeQueryEngine", "Using full collection scan to execute query:", Pn(e)), 
        this.Xu.Ri(t, e, ot.min());
    }, t;
}(), Qi = /** @class */ function() {
    function t(t, e) {
        this._i = t, this.Rr = e, 
        /**
             * The set of all mutations that have been sent but not yet been applied to
             * the backend.
             */
        this.li = [], 
        /** Next value to use when assigning sequential IDs to each mutation batch. */
        this.ec = 1, 
        /** An ordered mapping between documents and the mutations batch IDs. */
        this.nc = new _t(Mr.br);
    }
    return t.prototype.sc = function(t) {
        return rr.resolve(0 === this.li.length);
    }, t.prototype.ju = function(t, e, n, r) {
        var i = this.ec;
        this.ec++, this.li.length > 0 && this.li[this.li.length - 1];
        var o = new Er(i, e, n, r);
        this.li.push(o);
        // Track references by document key and index collection parents.
        for (var s = 0, u = r; s < u.length; s++) {
            var a = u[s];
            this.nc = this.nc.add(new Mr(a.key, i)), this._i.Qi(t, a.key.path.h());
        }
        return rr.resolve(o);
    }, t.prototype.Gu = function(t, e) {
        return rr.resolve(this.ic(e));
    }, t.prototype.Pr = function(t, e) {
        var n = e + 1, r = this.rc(n), i = r < 0 ? 0 : r;
        // The requested batchId may still be out of range so normalize it to the
        // start of the queue.
                return rr.resolve(this.li.length > i ? this.li[i] : null);
    }, t.prototype.zu = function() {
        return rr.resolve(0 === this.li.length ? -1 : this.ec - 1);
    }, t.prototype.Ku = function(t) {
        return rr.resolve(this.li.slice());
    }, t.prototype.di = function(t, e) {
        var n = this, r = new Mr(e, 0), i = new Mr(e, Number.POSITIVE_INFINITY), o = [];
        return this.nc.Nt([ r, i ], (function(t) {
            var e = n.ic(t.Ur);
            o.push(e);
        })), rr.resolve(o);
    }, t.prototype.Ai = function(t, e) {
        var n = this, r = new _t(X);
        return e.forEach((function(t) {
            var e = new Mr(t, 0), i = new Mr(t, Number.POSITIVE_INFINITY);
            n.nc.Nt([ e, i ], (function(t) {
                r = r.add(t.Ur);
            }));
        })), rr.resolve(this.oc(r));
    }, t.prototype.Vi = function(t, e) {
        // Use the query path as a prefix for testing if a document matches the
        // query.
        var n = e.path, r = n.length + 1, i = n;
        // Construct a document reference for actually scanning the index. Unlike
        // the prefix the document key in this reference must have an even number of
        // segments. The empty segment can be used a suffix of the query path
        // because it precedes all other segments in an ordered traversal.
                T.N(i) || (i = i.child(""));
        var o = new Mr(new T(i), 0), s = new _t(X);
        // Find unique batchIDs referenced by all documents potentially matching the
        // query.
                return this.nc.$t((function(t) {
            var e = t.key.path;
            return !!n.T(e) && (
            // Rows with document keys more than one segment longer than the query
            // path can't be matches. For example, a query on 'rooms' can't match
            // the document /rooms/abc/messages/xyx.
            // TODO(mcg): we'll need a different scanner when we implement
            // ancestor queries.
            e.length === r && (s = s.add(t.Ur)), !0);
        }), o), rr.resolve(this.oc(s));
    }, t.prototype.oc = function(t) {
        var e = this, n = [];
        // Construct an array of matching batches, sorted by batchID to ensure that
        // multiple mutations affecting the same document key are applied in order.
                return t.forEach((function(t) {
            var r = e.ic(t);
            null !== r && n.push(r);
        })), n;
    }, t.prototype.lr = function(t, e) {
        var n = this;
        g(0 === this.uc(e.batchId, "removed")), this.li.shift();
        var r = this.nc;
        return rr.forEach(e.mutations, (function(i) {
            var o = new Mr(i.key, e.batchId);
            return r = r.delete(o), n.Rr.cc(t, i.key);
        })).next((function() {
            n.nc = r;
        }));
    }, t.prototype.ac = function(t) {
        // No-op since the memory mutation queue does not maintain a separate cache.
    }, t.prototype.qr = function(t, e) {
        var n = new Mr(e, 0), r = this.nc.xt(n);
        return rr.resolve(e.isEqual(r && r.key));
    }, t.prototype._r = function(t) {
        return this.li.length, rr.resolve();
    }, 
    /**
     * Finds the index of the given batchId in the mutation queue and asserts that
     * the resulting index is within the bounds of the queue.
     *
     * @param batchId The batchId to search for
     * @param action A description of what the caller is doing, phrased in passive
     * form (e.g. "acknowledged" in a routine that acknowledges batches).
     */
    t.prototype.uc = function(t, e) {
        return this.rc(t);
    }, 
    /**
     * Finds the index of the given batchId in the mutation queue. This operation
     * is O(1).
     *
     * @return The computed index of the batch with the given batchId, based on
     * the state of the queue. Note this index can be negative if the requested
     * batchId has already been remvoed from the queue or past the end of the
     * queue if the batchId is larger than the last added batch.
     */
    t.prototype.rc = function(t) {
        return 0 === this.li.length ? 0 : t - this.li[0].batchId;
        // Examine the front of the queue to figure out the difference between the
        // batchId and indexes in the array. Note that since the queue is ordered
        // by batchId, if the first batch has a larger batchId then the requested
        // batchId doesn't exist in the queue.
        }, 
    /**
     * A version of lookupMutationBatch that doesn't return a promise, this makes
     * other functions that uses this code easier to read and more efficent.
     */
    t.prototype.ic = function(t) {
        var e = this.rc(t);
        return e < 0 || e >= this.li.length ? null : this.li[e];
    }, t;
}(), Ki = /** @class */ function() {
    /**
     * @param sizer Used to assess the size of a document. For eager GC, this is expected to just
     * return 0 to avoid unnecessarily doing the work of calculating the size.
     */
    function t(t, e) {
        this._i = t, this.hc = e, 
        /** Underlying cache of documents and their read times. */
        this.docs = new wt(T.i), 
        /** Size of all cached documents. */
        this.size = 0
        /**
     * Adds the supplied entry to the cache and updates the cache size as appropriate.
     *
     * All calls of `addEntry`  are required to go through the RemoteDocumentChangeBuffer
     * returned by `newChangeBuffer()`.
     */;
    }
    return t.prototype.hr = function(t, e, n) {
        var r = e.key, i = this.docs.get(r), o = i ? i.size : 0, s = this.hc(e);
        return this.docs = this.docs.ot(r, {
            lc: e,
            size: s,
            readTime: n
        }), this.size += s - o, this._i.Qi(t, r.path.h());
    }, 
    /**
     * Removes the specified entry from the cache and updates the cache size as appropriate.
     *
     * All calls of `removeEntry` are required to go through the RemoteDocumentChangeBuffer
     * returned by `newChangeBuffer()`.
     */
    t.prototype.Ir = function(t) {
        var e = this.docs.get(t);
        e && (this.docs = this.docs.remove(t), this.size -= e.size);
    }, t.prototype.mi = function(t, e) {
        var n = this.docs.get(e);
        return rr.resolve(n ? n.lc : null);
    }, t.prototype.getEntries = function(t, e) {
        var n = this, r = Tt();
        return e.forEach((function(t) {
            var e = n.docs.get(t);
            r = r.ot(t, e ? e.lc : null);
        })), rr.resolve(r);
    }, t.prototype.Ri = function(t, e, n) {
        for (var r = Vt(), i = new T(e.path.child("")), o = this.docs.ft(i)
        // Documents are ordered by key, so we can use a prefix scan to narrow down
        // the documents we need to match the query against.
        ; o.At(); ) {
            var s = o.It(), u = s.key, a = s.value, c = a.lc, h = a.readTime;
            if (!e.path.T(u.path)) break;
            h.M(n) <= 0 || c instanceof wn && Cn(e, c) && (r = r.ot(c.key, c));
        }
        return rr.resolve(r);
    }, t.prototype._c = function(t, e) {
        return rr.forEach(this.docs, (function(t) {
            return e(t);
        }));
    }, t.prototype.cr = function(t) {
        // `trackRemovals` is ignores since the MemoryRemoteDocumentCache keeps
        // a separate changelog and does not need special handling for removals.
        return new Xi(this);
    }, t.prototype.fc = function(t) {
        return rr.resolve(this.size);
    }, t;
}(), Xi = /** @class */ function(e) {
    function n(t) {
        var n = this;
        return (n = e.call(this) || this).Ic = t, n;
    }
    return t.__extends(n, e), n.prototype.mu = function(t) {
        var e = this, n = [];
        return this.Wu.forEach((function(r, i) {
            i ? n.push(e.Ic.hr(t, i, e.readTime)) : e.Ic.Ir(r);
        })), rr.xn(n);
    }, n.prototype.Tc = function(t, e) {
        return this.Ic.mi(t, e);
    }, n.prototype.Ec = function(t, e) {
        return this.Ic.getEntries(t, e);
    }, n;
}(/** @class */ function() {
    function t() {
        // A mapping of document key to the new cache entry that should be written (or null if any
        // existing cache entry should be removed).
        this.Wu = new rt((function(t) {
            return t.toString();
        }), (function(t, e) {
            return t.isEqual(e);
        })), this.dc = !1;
    }
    return Object.defineProperty(t.prototype, "readTime", {
        get: function() {
            return this.wc;
        },
        set: function(t) {
            this.wc = t;
        },
        enumerable: !1,
        configurable: !0
    }), 
    /**
     * Buffers a `RemoteDocumentCache.addEntry()` call.
     *
     * You can only modify documents that have already been retrieved via
     * `getEntry()/getEntries()` (enforced via IndexedDbs `apply()`).
     */
    t.prototype.hr = function(t, e) {
        this.mc(), this.readTime = e, this.Wu.set(t.key, t);
    }, 
    /**
     * Buffers a `RemoteDocumentCache.removeEntry()` call.
     *
     * You can only remove documents that have already been retrieved via
     * `getEntry()/getEntries()` (enforced via IndexedDbs `apply()`).
     */
    t.prototype.Ir = function(t, e) {
        this.mc(), e && (this.readTime = e), this.Wu.set(t, null);
    }, 
    /**
     * Looks up an entry in the cache. The buffered changes will first be checked,
     * and if no buffered change applies, this will forward to
     * `RemoteDocumentCache.getEntry()`.
     *
     * @param transaction The transaction in which to perform any persistence
     *     operations.
     * @param documentKey The key of the entry to look up.
     * @return The cached Document or NoDocument entry, or null if we have nothing
     * cached.
     */
    t.prototype.mi = function(t, e) {
        this.mc();
        var n = this.Wu.get(e);
        return void 0 !== n ? rr.resolve(n) : this.Tc(t, e);
    }, 
    /**
     * Looks up several entries in the cache, forwarding to
     * `RemoteDocumentCache.getEntry()`.
     *
     * @param transaction The transaction in which to perform any persistence
     *     operations.
     * @param documentKeys The keys of the entries to look up.
     * @return A map of cached `Document`s or `NoDocument`s, indexed by key. If an
     *     entry cannot be found, the corresponding key will be mapped to a null
     *     value.
     */
    t.prototype.getEntries = function(t, e) {
        return this.Ec(t, e);
    }, 
    /**
     * Applies buffered changes to the underlying RemoteDocumentCache, using
     * the provided transaction.
     */
    t.prototype.apply = function(t) {
        return this.mc(), this.dc = !0, this.mu(t);
    }, 
    /** Helper to assert this.changes is not null  */ t.prototype.mc = function() {}, 
    t;
}()), Hi = /** @class */ function() {
    function t(t) {
        this.persistence = t, 
        /**
             * Maps a target to the data about that target
             */
        this.Ac = new rt((function(t) {
            return ht(t);
        }), ft), 
        /** The last received snapshot version. */
        this.lastRemoteSnapshotVersion = ot.min(), 
        /** The highest numbered target ID encountered. */
        this.highestTargetId = 0, 
        /** The highest sequence number encountered. */
        this.Rc = 0, 
        /**
             * A ordered bidirectional mapping between documents and the remote target
             * IDs.
             */
        this.yc = new Cr, this.targetCount = 0, this.Pc = Vr.Wi();
    }
    return t.prototype.Ce = function(t, e) {
        return this.Ac.forEach((function(t, n) {
            return e(n);
        })), rr.resolve();
    }, t.prototype.dr = function(t) {
        return rr.resolve(this.lastRemoteSnapshotVersion);
    }, t.prototype.gc = function(t) {
        return rr.resolve(this.Rc);
    }, t.prototype.Uu = function(t) {
        return this.highestTargetId = this.Pc.next(), rr.resolve(this.highestTargetId);
    }, t.prototype.yr = function(t, e, n) {
        return n && (this.lastRemoteSnapshotVersion = n), e > this.Rc && (this.Rc = e), 
        rr.resolve();
    }, t.prototype.Vc = function(t) {
        this.Ac.set(t.target, t);
        var e = t.targetId;
        e > this.highestTargetId && (this.Pc = new Vr(e), this.highestTargetId = e), t.sequenceNumber > this.Rc && (this.Rc = t.sequenceNumber);
    }, t.prototype.Bu = function(t, e) {
        return this.Vc(e), this.targetCount += 1, rr.resolve();
    }, t.prototype.Er = function(t, e) {
        return this.Vc(e), rr.resolve();
    }, t.prototype.vc = function(t, e) {
        return this.Ac.delete(e.target), this.yc.Or(e.targetId), this.targetCount -= 1, 
        rr.resolve();
    }, t.prototype.bc = function(t, e, n) {
        var r = this, i = 0, o = [];
        return this.Ac.forEach((function(s, u) {
            u.sequenceNumber <= e && null === n.get(u.targetId) && (r.Ac.delete(s), o.push(r.Sc(t, u.targetId)), 
            i++);
        })), rr.xn(o).next((function() {
            return i;
        }));
    }, t.prototype.Dc = function(t) {
        return rr.resolve(this.targetCount);
    }, t.prototype.gr = function(t, e) {
        var n = this.Ac.get(e) || null;
        return rr.resolve(n);
    }, t.prototype.mr = function(t, e, n) {
        return this.yc.Fr(e, n), rr.resolve();
    }, t.prototype.wr = function(t, e, n) {
        this.yc.kr(e, n);
        var r = this.persistence.Rr, i = [];
        return r && e.forEach((function(e) {
            i.push(r.cc(t, e));
        })), rr.xn(i);
    }, t.prototype.Sc = function(t, e) {
        return this.yc.Or(e), rr.resolve();
    }, t.prototype.pr = function(t, e) {
        var n = this.yc.Mr(e);
        return rr.resolve(n);
    }, t.prototype.qr = function(t, e) {
        return rr.resolve(this.yc.qr(e));
    }, t;
}(), Yi = /** @class */ function() {
    /**
     * The constructor accepts a factory for creating a reference delegate. This
     * allows both the delegate and this instance to have strong references to
     * each other without having nullable fields that would then need to be
     * checked or asserted on every access.
     */
    function t(t) {
        var e = this;
        this.Cc = {}, this.Fc = new mr(0), this.Nc = !1, this.Nc = !0, this.Rr = t(this), 
        this.tr = new Hi(this), this._i = new Tr, this.hi = function(t, n) {
            return new Ki(t, (function(t) {
                return e.Rr.$c(t);
            }));
        }(this._i);
    }
    return t.prototype.start = function() {
        return Promise.resolve();
    }, t.prototype.ni = function() {
        // No durable state to ensure is closed on shutdown.
        return this.Nc = !1, Promise.resolve();
    }, Object.defineProperty(t.prototype, "xc", {
        get: function() {
            return this.Nc;
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.kc = function() {
        // No op.
    }, t.prototype.Oc = function() {
        // No op.
    }, t.prototype.sr = function() {
        return this._i;
    }, t.prototype.Ji = function(t) {
        var e = this.Cc[t.Cs()];
        return e || (e = new Qi(this._i, this.Rr), this.Cc[t.Cs()] = e), e;
    }, t.prototype.er = function() {
        return this.tr;
    }, t.prototype.Zi = function() {
        return this.hi;
    }, t.prototype.runTransaction = function(t, e, n) {
        var r = this;
        l("MemoryPersistence", "Starting transaction:", t);
        var i = new Ji(this.Fc.next());
        return this.Rr.Lc(), n(i).next((function(t) {
            return r.Rr.Mc(i).next((function() {
                return t;
            }));
        })).Nn().then((function(t) {
            return i.qc(), t;
        }));
    }, t.prototype.Uc = function(t, e) {
        return rr.kn(Object.values(this.Cc).map((function(n) {
            return function() {
                return n.qr(t, e);
            };
        })));
    }, t;
}(), Ji = /** @class */ function(e) {
    function n(t) {
        var n = this;
        return (n = e.call(this) || this).Tr = t, n;
    }
    /**
     * A base class representing a persistence transaction, encapsulating both the
     * transaction's sequence numbers as well as a list of onCommitted listeners.
     *
     * When you call Persistence.runTransaction(), it will create a transaction and
     * pass it to your callback. You then pass it to any method that operates
     * on persistence.
     */
    return t.__extends(n, e), n;
}(/** @class */ function() {
    function t() {
        this.Bc = [];
    }
    return t.prototype.Qc = function(t) {
        this.Bc.push(t);
    }, t.prototype.qc = function() {
        this.Bc.forEach((function(t) {
            return t();
        }));
    }, t;
}()), $i = /** @class */ function() {
    function t(t) {
        this.persistence = t, 
        /** Tracks all documents that are active in Query views. */
        this.jc = new Cr, 
        /** The list of documents that are potentially GCed after each transaction. */
        this.Wc = null;
    }
    return t.Gc = function(e) {
        return new t(e);
    }, Object.defineProperty(t.prototype, "zc", {
        get: function() {
            if (this.Wc) return this.Wc;
            throw y();
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.Cr = function(t, e, n) {
        return this.jc.Cr(n, e), this.zc.delete(n.toString()), rr.resolve();
    }, t.prototype.Nr = function(t, e, n) {
        return this.jc.Nr(n, e), this.zc.add(n.toString()), rr.resolve();
    }, t.prototype.cc = function(t, e) {
        return this.zc.add(e.toString()), rr.resolve();
    }, t.prototype.removeTarget = function(t, e) {
        var n = this;
        this.jc.Or(e.targetId).forEach((function(t) {
            return n.zc.add(t.toString());
        }));
        var r = this.persistence.er();
        return r.pr(t, e.targetId).next((function(t) {
            t.forEach((function(t) {
                return n.zc.add(t.toString());
            }));
        })).next((function() {
            return r.vc(t, e);
        }));
    }, t.prototype.Lc = function() {
        this.Wc = new Set;
    }, t.prototype.Mc = function(t) {
        var e = this, n = this.persistence.Zi().cr();
        // Remove newly orphaned documents.
                return rr.forEach(this.zc, (function(r) {
            var i = T.D(r);
            return e.Kc(t, i).next((function(t) {
                t || n.Ir(i);
            }));
        })).next((function() {
            return e.Wc = null, n.apply(t);
        }));
    }, t.prototype.Ar = function(t, e) {
        var n = this;
        return this.Kc(t, e).next((function(t) {
            t ? n.zc.delete(e.toString()) : n.zc.add(e.toString());
        }));
    }, t.prototype.$c = function(t) {
        // For eager GC, we don't care about the document size, there are no size thresholds.
        return 0;
    }, t.prototype.Kc = function(t, e) {
        var n = this;
        return rr.kn([ function() {
            return rr.resolve(n.jc.qr(e));
        }, function() {
            return n.persistence.er().qr(t, e);
        }, function() {
            return n.persistence.Uc(t, e);
        } ]);
    }, t;
}(), Zi = /** @class */ function() {
    function t(t) {
        this.Hc = t.Hc, this.Yc = t.Yc;
    }
    return t.prototype.Io = function(t) {
        this.Jc = t;
    }, t.prototype.do = function(t) {
        this.Xc = t;
    }, t.prototype.onMessage = function(t) {
        this.Zc = t;
    }, t.prototype.close = function() {
        this.Yc();
    }, t.prototype.send = function(t) {
        this.Hc(t);
    }, t.prototype.ta = function() {
        this.Jc();
    }, t.prototype.ea = function(t) {
        this.Xc(t);
    }, t.prototype.na = function(t) {
        this.Zc(t);
    }, t;
}(), to = {
    BatchGetDocuments: "batchGet",
    Commit: "commit",
    RunQuery: "runQuery"
}, eo = /** @class */ function(e) {
    function n(t) {
        var n = this;
        return (n = e.call(this, t) || this).forceLongPolling = t.forceLongPolling, n.j = t.j, 
        n;
    }
    /**
     * Base class for all Rest-based connections to the backend (WebChannel and
     * HTTP).
     */
    return t.__extends(n, e), n.prototype.ca = function(t, e, n, r) {
        return new Promise((function(o, s) {
            var u = new i.XhrIo;
            u.listenOnce(i.EventType.COMPLETE, (function() {
                try {
                    switch (u.getLastErrorCode()) {
                      case i.ErrorCode.NO_ERROR:
                        var e = u.getResponseJson();
                        l("Connection", "XHR received:", JSON.stringify(e)), o(e);
                        break;

                      case i.ErrorCode.TIMEOUT:
                        l("Connection", 'RPC "' + t + '" timed out'), s(new c(a.DEADLINE_EXCEEDED, "Request time out"));
                        break;

                      case i.ErrorCode.HTTP_ERROR:
                        var n = u.getStatus();
                        if (l("Connection", 'RPC "' + t + '" failed with status:', n, "response text:", u.getResponseText()), 
                        n > 0) {
                            var r = u.getResponseJson().error;
                            if (r && r.status && r.message) {
                                var h = function(t) {
                                    var e = t.toLowerCase().replace("_", "-");
                                    return Object.values(a).indexOf(e) >= 0 ? e : a.UNKNOWN;
                                }(r.status);
                                s(new c(h, r.message));
                            } else s(new c(a.UNKNOWN, "Server responded with status " + u.getStatus()));
                        } else 
                        // If we received an HTTP_ERROR but there's no status code,
                        // it's most probably a connection issue
                        s(new c(a.UNAVAILABLE, "Connection failed."));
                        break;

                      default:
                        y();
                    }
                } finally {
                    l("Connection", 'RPC "' + t + '" completed.');
                }
            }));
            var h = JSON.stringify(r);
            u.send(e, "POST", h, n, 15);
        }));
    }, n.prototype.Ao = function(t, e) {
        var n = [ this.ia, "/", "google.firestore.v1.Firestore", "/", t, "/channel" ], o = i.createWebChannelTransport(), s = {
            // Required for backend stickiness, routing behavior is based on this
            // parameter.
            httpSessionIdParam: "gsessionid",
            initMessageHeaders: {},
            messageUrlParams: {
                // This param is used to improve routing and project isolation by the
                // backend and must be included in every request.
                database: "projects/" + this.B.projectId + "/databases/" + this.B.database
            },
            sendRawJson: !0,
            supportsCrossDomainXhr: !0,
            internalChannelParams: {
                // Override the default timeout (randomized between 10-20 seconds) since
                // a large write batch on a slow internet connection may take a long
                // time to send to the backend. Rather than have WebChannel impose a
                // tight timeout which could lead to infinite timeouts and retries, we
                // set it very large (5-10 minutes) and rely on the browser's builtin
                // timeouts to kick in if the request isn't working.
                forwardChannelRequestTimeoutMs: 6e5
            },
            forceLongPolling: this.forceLongPolling,
            detectBufferingProxy: this.j
        };
        this.ua(s.initMessageHeaders, e), 
        // Sending the custom headers we just added to request.initMessageHeaders
        // (Authorization, etc.) will trigger the browser to make a CORS preflight
        // request because the XHR will no longer meet the criteria for a "simple"
        // CORS request:
        // https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS#Simple_requests
        // Therefore to avoid the CORS preflight request (an extra network
        // roundtrip), we use the httpHeadersOverwriteParam option to specify that
        // the headers should instead be encoded into a special "$httpHeaders" query
        // parameter, which is recognized by the webchannel backend. This is
        // formally defined here:
        // https://github.com/google/closure-library/blob/b0e1815b13fb92a46d7c9b3c30de5d6a396a3245/closure/goog/net/rpc/httpcors.js#L32
        // TODO(b/145624756): There is a backend bug where $httpHeaders isn't respected if the request
        // doesn't have an Origin header. So we have to exclude a few browser environments that are
        // known to (sometimes) not include an Origin. See
        // https://github.com/firebase/firebase-js-sdk/issues/1491.
        r.isMobileCordova() || r.isReactNative() || r.isElectron() || r.isIE() || r.isUWP() || r.isBrowserExtension() || (s.httpHeadersOverwriteParam = "$httpHeaders");
        var u = n.join("");
        l("Connection", "Creating WebChannel: " + u, s);
        var h = o.createWebChannel(u, s), f = !1, p = !1, v = new Zi({
            Hc: function(t) {
                p ? l("Connection", "Not sending because WebChannel is closed:", t) : (f || (l("Connection", "Opening WebChannel transport."), 
                h.open(), f = !0), l("Connection", "WebChannel sending:", t), h.send(t));
            },
            Yc: function() {
                return h.close();
            }
        }), y = function(t, e) {
            // TODO(dimond): closure typing seems broken because WebChannel does
            // not implement goog.events.Listenable
            h.listen(t, (function(t) {
                try {
                    e(t);
                } catch (t) {
                    setTimeout((function() {
                        throw t;
                    }), 0);
                }
            }));
        };
        // WebChannel supports sending the first message with the handshake - saving
        // a network round trip. However, it will have to call send in the same
        // JS event loop as open. In order to enforce this, we delay actually
        // opening the WebChannel until send is called. Whether we have called
        // open is tracked with this variable.
                // Closure events are guarded and exceptions are swallowed, so catch any
        // exception and rethrow using a setTimeout so they become visible again.
        // Note that eventually this function could go away if we are confident
        // enough the code is exception free.
        return y(i.WebChannel.EventType.OPEN, (function() {
            p || l("Connection", "WebChannel transport opened.");
        })), y(i.WebChannel.EventType.CLOSE, (function() {
            p || (p = !0, l("Connection", "WebChannel transport closed"), v.ea());
        })), y(i.WebChannel.EventType.ERROR, (function(t) {
            p || (p = !0, d("Connection", "WebChannel transport errored:", t), v.ea(new c(a.UNAVAILABLE, "The operation could not be completed")));
        })), y(i.WebChannel.EventType.MESSAGE, (function(t) {
            var e;
            if (!p) {
                var n = t.data[0];
                g(!!n);
                // TODO(b/35143891): There is a bug in One Platform that caused errors
                // (and only errors) to be wrapped in an extra array. To be forward
                // compatible with the bug we need to check either condition. The latter
                // can be removed once the fix has been rolled out.
                // Use any because msgData.error is not typed.
                var r = n, i = r.error || (null === (e = r[0]) || void 0 === e ? void 0 : e.error);
                if (i) {
                    l("Connection", "WebChannel received error:", i);
                    // error.status will be a string like 'OK' or 'NOT_FOUND'.
                    var o = i.status, s = function(t) {
                        // lookup by string
                        // eslint-disable-next-line @typescript-eslint/no-explicit-any
                        var e = pt[t];
                        if (void 0 !== e) return mt(e);
                    }(o), u = i.message;
                    void 0 === s && (s = a.INTERNAL, u = "Unknown error status: " + o + " with message " + i.message), 
                    // Mark closed so no further events are propagated
                    p = !0, v.ea(new c(s, u)), h.close();
                } else l("Connection", "WebChannel received:", n), v.na(n);
            }
        })), setTimeout((function() {
            // Technically we could/should wait for the WebChannel opened event,
            // but because we want to send the first message with the WebChannel
            // handshake we pretend the channel opened here (asynchronously), and
            // then delay the actual open until the first message is sent.
            v.ta();
        }), 0), v;
    }, n;
}(/** @class */ function() {
    function t(t) {
        this.sa = t, this.B = t.B;
        var e = t.ssl ? "https" : "http";
        this.ia = e + "://" + t.host, this.ra = "projects/" + this.B.projectId + "/databases/" + this.B.database + "/documents";
    }
    return t.prototype.No = function(t, e, n, r) {
        var i = this.oa(t, e);
        l("RestConnection", "Sending: ", i, n);
        var o = {};
        return this.ua(o, r), this.ca(t, i, o, n).then((function(t) {
            return l("RestConnection", "Received: ", t), t;
        }), (function(e) {
            throw d("RestConnection", t + " failed with error: ", e, "url: ", i, "request:", n), 
            e;
        }));
    }, t.prototype.$o = function(t, e, n, r) {
        // The REST API automatically aggregates all of the streamed results, so we
        // can just use the normal invoke() method.
        return this.No(t, e, n, r);
    }, 
    /**
     * Modifies the headers for a request, adding any authorization token if
     * present and any additional headers for the request.
     */
    t.prototype.ua = function(t, e) {
        if (t["X-Goog-Api-Client"] = "gl-js/ fire/7.24.0", 
        // Content-Type: text/plain will avoid preflight requests which might
        // mess with CORS and redirects by proxies. If we add custom headers
        // we will need to change this code to potentially use the $httpOverwrite
        // parameter supported by ESF to avoid triggering preflight requests.
        t["Content-Type"] = "text/plain", e) for (var n in e.Br) e.Br.hasOwnProperty(n) && (t[n] = e.Br[n]);
    }, t.prototype.oa = function(t, e) {
        var n = to[t];
        return this.ia + "/v1/" + e + ":" + n;
    }, t;
}()), no = /** @class */ function() {
    function t() {
        var t = this;
        this.aa = function() {
            return t.ha();
        }, this.la = function() {
            return t._a();
        }, this.fa = [], this.da();
    }
    return t.prototype.Jo = function(t) {
        this.fa.push(t);
    }, t.prototype.ni = function() {
        window.removeEventListener("online", this.aa), window.removeEventListener("offline", this.la);
    }, t.prototype.da = function() {
        window.addEventListener("online", this.aa), window.addEventListener("offline", this.la);
    }, t.prototype.ha = function() {
        l("ConnectivityMonitor", "Network connectivity changed: AVAILABLE");
        for (var t = 0, e = this.fa; t < e.length; t++) {
            (0, e[t])(0 /* AVAILABLE */);
        }
    }, t.prototype._a = function() {
        l("ConnectivityMonitor", "Network connectivity changed: UNAVAILABLE");
        for (var t = 0, e = this.fa; t < e.length; t++) {
            (0, e[t])(1 /* UNAVAILABLE */);
        }
    }, 
    // TODO(chenbrian): Consider passing in window either into this component or
    // here for testing via FakeWindow.
    /** Checks that all used attributes of window are available. */
    t.wa = function() {
        return "undefined" != typeof window && void 0 !== window.addEventListener && void 0 !== window.removeEventListener;
    }, t;
}(), ro = /** @class */ function() {
    function t() {}
    return t.prototype.Jo = function(t) {
        // No-op.
    }, t.prototype.ni = function() {
        // No-op.
    }, t;
}();

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** Initializes the WebChannelConnection for the browser. */
/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
function io(t) {
    return new de(t, /* useProto3Json= */ !0);
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ var oo = "You are using the memory-only build of Firestore. Persistence support is only available via the @firebase/firestore bundle or the firebase-firestore.js build.", so = /** @class */ function() {
    function e() {}
    return e.prototype.initialize = function(e) {
        return t.__awaiter(this, void 0, void 0, (function() {
            return t.__generator(this, (function(t) {
                switch (t.label) {
                  case 0:
                    return this.Vu = this.ma(e), this.persistence = this.Ta(e), [ 4 /*yield*/ , this.persistence.start() ];

                  case 1:
                    return t.sent(), this.Ea = this.Ia(e), this.Qo = this.Aa(e), [ 2 /*return*/ ];
                }
            }));
        }));
    }, e.prototype.Ia = function(t) {
        return null;
    }, e.prototype.Aa = function(t) {
        /** Manages our in-memory or durable persistence. */
        return e = this.persistence, n = new Wi, r = t.Ra, new Rr(e, n, r);
        var e, n, r;
    }, e.prototype.Ta = function(t) {
        if (t.persistenceSettings.ya) throw new c(a.FAILED_PRECONDITION, oo);
        return new Yi($i.Gc);
    }, e.prototype.ma = function(t) {
        return new br;
    }, e.prototype.terminate = function() {
        return t.__awaiter(this, void 0, void 0, (function() {
            return t.__generator(this, (function(t) {
                switch (t.label) {
                  case 0:
                    return this.Ea && this.Ea.stop(), [ 4 /*yield*/ , this.Vu.ni() ];

                  case 1:
                    return t.sent(), [ 4 /*yield*/ , this.persistence.ni() ];

                  case 2:
                    return t.sent(), [ 2 /*return*/ ];
                }
            }));
        }));
    }, e.prototype.clearPersistence = function(t, e) {
        throw new c(a.FAILED_PRECONDITION, oo);
    }, e;
}(), uo = /** @class */ function() {
    function e() {}
    return e.prototype.initialize = function(e, n) {
        return t.__awaiter(this, void 0, void 0, (function() {
            var r = this;
            return t.__generator(this, (function(i) {
                switch (i.label) {
                  case 0:
                    return this.Qo ? [ 3 /*break*/ , 2 ] : (this.Qo = e.Qo, this.Vu = e.Vu, this.jo = this.Pa(n), 
                    this.gu = this.ga(n), this.pu = this.pa(n), this.Va = this.va(n), this.Vu.js = function(t) {
                        return Ui(r.Va, t, 1 /* SharedClientState */);
                    }, this.gu.Wo.ba = Gi.bind(null, this.Va), [ 4 /*yield*/ , 
                    /**
                     * Toggles the network state when the client gains or loses its primary lease.
                     */
                    function(e, n) {
                        return t.__awaiter(this, void 0, void 0, (function() {
                            var r, i;
                            return t.__generator(this, (function(t) {
                                switch (t.label) {
                                  case 0:
                                    return r = m(e), n ? (r.Ko.delete(2 /* IsSecondary */), [ 4 /*yield*/ , Yr(r) ]) : [ 3 /*break*/ , 2 ];

                                  case 1:
                                    return t.sent(), [ 3 /*break*/ , 5 ];

                                  case 2:
                                    return (i = n) ? [ 3 /*break*/ , 4 ] : (r.Ko.add(2 /* IsSecondary */), [ 4 /*yield*/ , Jr(r) ]);

                                  case 3:
                                    t.sent(), i = r.Xo.set("Unknown" /* Unknown */), t.label = 4;

                                  case 4:
                                    i, t.label = 5;

                                  case 5:
                                    return [ 2 /*return*/ ];
                                }
                            }));
                        }));
                    }(this.gu, this.Va.Mu) ]);

                  case 1:
                    i.sent(), i.label = 2;

                  case 2:
                    return [ 2 /*return*/ ];
                }
            }));
        }));
    }, e.prototype.pa = function(t) {
        return new hr;
    }, e.prototype.Pa = function(t) {
        var e, n = io(t.sa.B), r = (e = t.sa, new eo(e));
        /** Return the Platform-specific connectivity monitor. */ return function(t, e, n) {
            return new Kr(t, e, n);
        }(t.credentials, r, n);
    }, e.prototype.ga = function(t) {
        var e, n, r, i, o, s = this;
        return e = this.Qo, n = this.jo, r = t.On, i = function(t) {
            return Ui(s.Va, t, 0 /* RemoteStore */);
        }, o = no.wa() ? new no : new ro, new Hr(e, n, r, i, o);
    }, e.prototype.va = function(t) {
        return function(t, e, n, 
        // PORTING NOTE: Manages state synchronization in multi-tab environments.
        r, i, o, s) {
            var u = new Ti(t, e, n, r, i, o);
            return s && (u.Lu = !0), u;
        }(this.Qo, this.gu, this.pu, this.Vu, t.Ra, t.vu, !t.persistenceSettings.ya || !t.persistenceSettings.synchronizeTabs);
    }, e.prototype.terminate = function() {
        return $r(this.gu);
    }, e;
}(), ao = /** @class */ function() {
    function t(t) {
        this.observer = t, 
        /**
             * When set to true, will not raise future events. Necessary to deal with
             * async detachment of listener.
             */
        this.muted = !1;
    }
    return t.prototype.next = function(t) {
        this.observer.next && this.Sa(this.observer.next, t);
    }, t.prototype.error = function(t) {
        this.observer.error ? this.Sa(this.observer.error, t) : console.error("Uncaught Error in snapshot listener:", t);
    }, t.prototype.Da = function() {
        this.muted = !0;
    }, t.prototype.Sa = function(t, e) {
        var n = this;
        this.muted || setTimeout((function() {
            n.muted || t(e);
        }), 0);
    }, t;
}(), co = function(t) {
    !function(t, e, n, r) {
        if (!(e instanceof Array) || e.length < 1) throw new c(a.INVALID_ARGUMENT, "Function FieldPath() requires its fieldNames argument to be an array with at least " + W(1, "element") + ".");
    }(0, t);
    for (var e = 0; e < t.length; ++e) if (U("FieldPath", "string", e, t[e]), 0 === t[e].length) throw new c(a.INVALID_ARGUMENT, "Invalid field name at argument $(i + 1). Field names must not be empty.");
    this.Ca = new N(t);
}, ho = /** @class */ function(e) {
    /**
     * Creates a FieldPath from the provided field names. If more than one field
     * name is provided, the path will point to a nested field in a document.
     *
     * @param fieldNames A list of field names.
     */
    function n() {
        for (var t = [], n = 0; n < arguments.length; n++) t[n] = arguments[n];
        return e.call(this, t) || this;
    }
    return t.__extends(n, e), n.documentId = function() {
        /**
         * Internal Note: The backend doesn't technically support querying by
         * document ID. Instead it queries by the entire document name (full path
         * included), but in the cases we currently support documentId(), the net
         * effect is the same.
         */
        return new n(N.v().R());
    }, n.prototype.isEqual = function(t) {
        if (!(t instanceof n)) throw B("isEqual", "FieldPath", 1, t);
        return this.Ca.isEqual(t.Ca);
    }, n;
}(co), fo = new RegExp("[~\\*/\\[\\]]"), lo = 
/**
     * @param _methodName The public API endpoint that returns this class.
     */
function(t) {
    this.Fa = t;
}, po = /** @class */ function(e) {
    function n() {
        return null !== e && e.apply(this, arguments) || this;
    }
    return t.__extends(n, e), n.prototype.Na = function(t) {
        if (2 /* MergeSet */ !== t.$a) throw 1 /* Update */ === t.$a ? t.xa(this.Fa + "() can only appear at the top level of your update data") : t.xa(this.Fa + "() cannot be used with set() unless you pass {merge:true}");
        // No transform to add for a delete, but we need to add it to our
        // fieldMask so it gets deleted.
                return t.je.push(t.path), null;
    }, n.prototype.isEqual = function(t) {
        return t instanceof n;
    }, n;
}(lo);

/**
 * Provides all components needed for Firestore with in-memory persistence.
 * Uses EagerGC garbage collection.
 */
/**
 * Creates a child context for parsing SerializableFieldValues.
 *
 * This is different than calling `ParseContext.contextWith` because it keeps
 * the fieldTransforms and fieldMask separate.
 *
 * The created context has its `dataSource` set to `UserDataSource.Argument`.
 * Although these values are used with writes, any elements in these FieldValues
 * are not considered writes since they cannot contain any FieldValue sentinels,
 * etc.
 *
 * @param fieldValue The sentinel FieldValue for which to create a child
 *     context.
 * @param context The parent context.
 * @param arrayElement Whether or not the FieldValue has an array.
 */
function vo(t, e, n) {
    return new Do({
        $a: 3 /* Argument */ ,
        ka: e.settings.ka,
        methodName: t.Fa,
        Oa: n
    }, e.B, e.serializer, e.ignoreUndefinedProperties);
}

var yo = /** @class */ function(e) {
    function n() {
        return null !== e && e.apply(this, arguments) || this;
    }
    return t.__extends(n, e), n.prototype.Na = function(t) {
        return new Ye(t.path, new Fe);
    }, n.prototype.isEqual = function(t) {
        return t instanceof n;
    }, n;
}(lo), go = /** @class */ function(e) {
    function n(t, n) {
        var r = this;
        return (r = e.call(this, t) || this).La = n, r;
    }
    return t.__extends(n, e), n.prototype.Na = function(t) {
        var e = vo(this, t, 
        /*array=*/ !0), n = this.La.map((function(t) {
            return So(t, e);
        })), r = new Be(n);
        return new Ye(t.path, r);
    }, n.prototype.isEqual = function(t) {
        // TODO(mrschmidt): Implement isEquals
        return this === t;
    }, n;
}(lo), mo = /** @class */ function(e) {
    function n(t, n) {
        var r = this;
        return (r = e.call(this, t) || this).La = n, r;
    }
    return t.__extends(n, e), n.prototype.Na = function(t) {
        var e = vo(this, t, 
        /*array=*/ !0), n = this.La.map((function(t) {
            return So(t, e);
        })), r = new ze(n);
        return new Ye(t.path, r);
    }, n.prototype.isEqual = function(t) {
        // TODO(mrschmidt): Implement isEquals
        return this === t;
    }, n;
}(lo), wo = /** @class */ function(e) {
    function n(t, n) {
        var r = this;
        return (r = e.call(this, t) || this).Ma = n, r;
    }
    return t.__extends(n, e), n.prototype.Na = function(t) {
        var e = new Qe(t.serializer, ge(t.serializer, this.Ma));
        return new Ye(t.path, e);
    }, n.prototype.isEqual = function(t) {
        // TODO(mrschmidt): Implement isEquals
        return this === t;
    }, n;
}(lo), bo = /** @class */ function() {
    /**
     * Creates a new immutable `GeoPoint` object with the provided latitude and
     * longitude values.
     * @param latitude The latitude as number between -90 and 90.
     * @param longitude The longitude as number between -180 and 180.
     */
    function t(t, e) {
        if (V("GeoPoint", arguments, 2), U("GeoPoint", "number", 1, t), U("GeoPoint", "number", 2, e), 
        !isFinite(t) || t < -90 || t > 90) throw new c(a.INVALID_ARGUMENT, "Latitude must be a number between -90 and 90, but was: " + t);
        if (!isFinite(e) || e < -180 || e > 180) throw new c(a.INVALID_ARGUMENT, "Longitude must be a number between -180 and 180, but was: " + e);
        this.qa = t, this.Ua = e;
    }
    return Object.defineProperty(t.prototype, "latitude", {
        /**
         * The latitude of this `GeoPoint` instance.
         */
        get: function() {
            return this.qa;
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "longitude", {
        /**
         * The longitude of this `GeoPoint` instance.
         */
        get: function() {
            return this.Ua;
        },
        enumerable: !1,
        configurable: !0
    }), 
    /**
     * Returns true if this `GeoPoint` is equal to the provided one.
     *
     * @param other The `GeoPoint` to compare against.
     * @return true if this `GeoPoint` is equal to the provided one.
     */
    t.prototype.isEqual = function(t) {
        return this.qa === t.qa && this.Ua === t.Ua;
    }, t.prototype.toJSON = function() {
        return {
            latitude: this.qa,
            longitude: this.Ua
        };
    }, 
    /**
     * Actually private to JS consumers of our API, so this function is prefixed
     * with an underscore.
     */
    t.prototype.Y = function(t) {
        return X(this.qa, t.qa) || X(this.Ua, t.Ua);
    }, t;
}(), Eo = function(t) {
    this.Ba = t;
}, _o = /^__.*__$/, Io = function(t, e, n) {
    this.Qa = t, this.ja = e, this.Wa = n;
}, Ao = /** @class */ function() {
    function t(t, e, n) {
        this.data = t, this.je = e, this.fieldTransforms = n;
    }
    return t.prototype.Ga = function(t, e) {
        var n = [];
        return null !== this.je ? n.push(new an(t, this.data, this.je, e)) : n.push(new un(t, this.data, e)), 
        this.fieldTransforms.length > 0 && n.push(new hn(t, this.fieldTransforms)), n;
    }, t;
}(), No = /** @class */ function() {
    function t(t, e, n) {
        this.data = t, this.je = e, this.fieldTransforms = n;
    }
    return t.prototype.Ga = function(t, e) {
        var n = [ new an(t, this.data, this.je, e) ];
        return this.fieldTransforms.length > 0 && n.push(new hn(t, this.fieldTransforms)), 
        n;
    }, t;
}();

function To(t) {
    switch (t) {
      case 0 /* Set */ :
 // fall through
              case 2 /* MergeSet */ :
 // fall through
              case 1 /* Update */ :
        return !0;

      case 3 /* Argument */ :
      case 4 /* ArrayArgument */ :
        return !1;

      default:
        throw y();
    }
}

/** A "context" object passed around while parsing user data. */ var Do = /** @class */ function() {
    /**
     * Initializes a ParseContext with the given source and path.
     *
     * @param settings The settings for the parser.
     * @param databaseId The database ID of the Firestore instance.
     * @param serializer The serializer to use to generate the Value proto.
     * @param ignoreUndefinedProperties Whether to ignore undefined properties
     * rather than throw.
     * @param fieldTransforms A mutable list of field transforms encountered while
     *     parsing the data.
     * @param fieldMask A mutable list of field paths encountered while parsing
     *     the data.
     *
     * TODO(b/34871131): We don't support array paths right now, so path can be
     * null to indicate the context represents any location within an array (in
     * which case certain features will not work and errors will be somewhat
     * compromised).
     */
    function t(t, e, n, r, i, o) {
        this.settings = t, this.B = e, this.serializer = n, this.ignoreUndefinedProperties = r, 
        // Minor hack: If fieldTransforms is undefined, we assume this is an
        // external call and we need to validate the entire path.
        void 0 === i && this.za(), this.fieldTransforms = i || [], this.je = o || [];
    }
    return Object.defineProperty(t.prototype, "path", {
        get: function() {
            return this.settings.path;
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "$a", {
        get: function() {
            return this.settings.$a;
        },
        enumerable: !1,
        configurable: !0
    }), 
    /** Returns a new context with the specified settings overwritten. */ t.prototype.Ka = function(e) {
        return new t(Object.assign(Object.assign({}, this.settings), e), this.B, this.serializer, this.ignoreUndefinedProperties, this.fieldTransforms, this.je);
    }, t.prototype.Ha = function(t) {
        var e, n = null === (e = this.path) || void 0 === e ? void 0 : e.child(t), r = this.Ka({
            path: n,
            Oa: !1
        });
        return r.Ya(t), r;
    }, t.prototype.Ja = function(t) {
        var e, n = null === (e = this.path) || void 0 === e ? void 0 : e.child(t), r = this.Ka({
            path: n,
            Oa: !1
        });
        return r.za(), r;
    }, t.prototype.Xa = function(t) {
        // TODO(b/34871131): We don't support array paths right now; so make path
        // undefined.
        return this.Ka({
            path: void 0,
            Oa: !0
        });
    }, t.prototype.xa = function(t) {
        return xo(t, this.settings.methodName, this.settings.Za || !1, this.path, this.settings.ka);
    }, 
    /** Returns 'true' if 'fieldPath' was traversed when creating this context. */ t.prototype.contains = function(t) {
        return void 0 !== this.je.find((function(e) {
            return t.T(e);
        })) || void 0 !== this.fieldTransforms.find((function(e) {
            return t.T(e.field);
        }));
    }, t.prototype.za = function() {
        // TODO(b/34871131): Remove null check once we have proper paths for fields
        // within arrays.
        if (this.path) for (var t = 0; t < this.path.length; t++) this.Ya(this.path.get(t));
    }, t.prototype.Ya = function(t) {
        if (0 === t.length) throw this.xa("Document fields must not be empty");
        if (To(this.$a) && _o.test(t)) throw this.xa('Document fields cannot begin and end with "__"');
    }, t;
}(), Vo = /** @class */ function() {
    function t(t, e, n) {
        this.B = t, this.ignoreUndefinedProperties = e, this.serializer = n || io(t)
        /** Creates a new top-level parse context. */;
    }
    return t.prototype.th = function(t, e, n, r) {
        return void 0 === r && (r = !1), new Do({
            $a: t,
            methodName: e,
            ka: n,
            path: N.g(),
            Oa: !1,
            Za: r
        }, this.B, this.serializer, this.ignoreUndefinedProperties);
    }, t;
}();

/**
 * Helper for parsing raw user input (provided via the API) into internal model
 * classes.
 */
/** Parse document data from a set() call. */ function Ro(t, e, n, r, i, o) {
    void 0 === o && (o = {});
    var s = t.th(o.merge || o.mergeFields ? 2 /* MergeSet */ : 0 /* Set */ , e, n, i);
    Po("Data must be an object, but it was:", s, r);
    var u, h, f = ko(r, s);
    if (o.merge) u = new He(s.je), h = s.fieldTransforms; else if (o.mergeFields) {
        for (var l = [], p = 0, d = o.mergeFields; p < d.length; p++) {
            var v = d[p], g = void 0;
            if (v instanceof co) g = v.Ca; else {
                if ("string" != typeof v) throw y();
                g = Mo(e, v, n);
            }
            if (!s.contains(g)) throw new c(a.INVALID_ARGUMENT, "Field '" + g + "' is specified in your field mask but missing from your input data.");
            qo(l, g) || l.push(g);
        }
        u = new He(l), h = s.fieldTransforms.filter((function(t) {
            return u.He(t.field);
        }));
    } else u = null, h = s.fieldTransforms;
    return new Ao(new vn(f), u, h);
}

/** Parse update data from an update() call. */ function Lo(t, e, n, r) {
    var i = t.th(1 /* Update */ , e, n);
    Po("Data must be an object, but it was:", i, r);
    var o = [], s = new yn;
    b(r, (function(t, r) {
        var u = Mo(e, t, n), a = i.Ja(u);
        if (r instanceof po || r instanceof Eo && r.Ba instanceof po) 
        // Add it to the field mask, but don't add anything to updateData.
        o.push(u); else {
            var c = So(r, a);
            null != c && (o.push(u), s.set(u, c));
        }
    }));
    var u = new He(o);
    return new No(s.Xe(), u, i.fieldTransforms);
}

/** Parse update data from a list of field/value arguments. */ function Uo(t, e, n, r, i, o) {
    var s = t.th(1 /* Update */ , e, n), u = [ Co(e, r, n) ], h = [ i ];
    if (o.length % 2 != 0) throw new c(a.INVALID_ARGUMENT, "Function " + e + "() needs to be called with an even number of arguments that alternate between field names and values.");
    for (var f = 0; f < o.length; f += 2) u.push(Co(e, o[f])), h.push(o[f + 1]);
    // We iterate in reverse order to pick the last value for a field if the
    // user specified the field multiple times.
    for (var l = [], p = new yn, d = u.length - 1; d >= 0; --d) if (!qo(l, u[d])) {
        var v = u[d], y = h[d], g = s.Ja(v);
        if (y instanceof po || y instanceof Eo && y.Ba instanceof po) 
        // Add it to the field mask, but don't add anything to updateData.
        l.push(v); else {
            var m = So(y, g);
            null != m && (l.push(v), p.set(v, m));
        }
    }
    var w = new He(l);
    return new No(p.Xe(), w, s.fieldTransforms);
}

/**
 * Parse a "query value" (e.g. value in a where filter or a value in a cursor
 * bound).
 *
 * @param allowArrays Whether the query value is an array that may directly
 * contain additional arrays (e.g. the operand of an `in` query).
 */ function Oo(t, e, n, r) {
    return void 0 === r && (r = !1), So(n, t.th(r ? 4 /* ArrayArgument */ : 3 /* Argument */ , e));
}

/**
 * Parses user data to Protobuf Values.
 *
 * @param input Data to be parsed.
 * @param context A context object representing the current path being parsed,
 * the source of the data being parsed, etc.
 * @return The parsed value, or null if the value was a FieldValue sentinel
 * that should not be included in the resulting parsed data.
 */ function So(t, e) {
    if (
    // Unwrap the API type from the Compat SDK. This will return the API type
    // from firestore-exp.
    t instanceof Eo && (t = t.Ba), jo(t)) return Po("Unsupported field value:", e, t), 
    ko(t, e);
    if (t instanceof lo) 
    // FieldValues usually parse into transforms (except FieldValue.delete())
    // in which case we do not want to include this field in our parsed data
    // (as doing so will overwrite the field directly prior to the transform
    // trying to transform it). So we don't add this location to
    // context.fieldMask and we return null as our parsing result.
    /**
     * "Parses" the provided FieldValueImpl, adding any necessary transforms to
     * context.fieldTransforms.
     */
    return function(t, e) {
        // Sentinels are only supported with writes, and not within arrays.
        if (!To(e.$a)) throw e.xa(t.Fa + "() can only be used with update() and set()");
        if (!e.path) throw e.xa(t.Fa + "() is not currently supported inside arrays");
        var n = t.Na(e);
        n && e.fieldTransforms.push(n);
    }(t, e), null;
    if (
    // If context.path is null we are inside an array and we don't support
    // field mask paths more granular than the top-level array.
    e.path && e.je.push(e.path), t instanceof Array) {
        // TODO(b/34871131): Include the path containing the array in the error
        // message.
        // In the case of IN queries, the parsed data is an array (representing
        // the set of values to be included for the IN query) that may directly
        // contain additional arrays (each representing an individual field
        // value), so we disable this validation.
        if (e.settings.Oa && 4 /* ArrayArgument */ !== e.$a) throw e.xa("Nested arrays are not supported");
        return function(t, e) {
            for (var n = [], r = 0, i = 0, o = t; i < o.length; i++) {
                var s = So(o[i], e.Xa(r));
                null == s && (
                // Just include nulls in the array for fields being replaced with a
                // sentinel.
                s = {
                    nullValue: "NULL_VALUE"
                }), n.push(s), r++;
            }
            return {
                arrayValue: {
                    values: n
                }
            };
        }(t, e);
    }
    return function(t, e) {
        if (null === t) return {
            nullValue: "NULL_VALUE"
        };
        if ("number" == typeof t) return ge(e.serializer, t);
        if ("boolean" == typeof t) return {
            booleanValue: t
        };
        if ("string" == typeof t) return {
            stringValue: t
        };
        if (t instanceof Date) {
            var n = it.fromDate(t);
            return {
                timestampValue: me(e.serializer, n)
            };
        }
        if (t instanceof it) {
            // Firestore backend truncates precision down to microseconds. To ensure
            // offline mode works the same with regards to truncation, perform the
            // truncation immediately without waiting for the backend to do that.
            var r = new it(t.seconds, 1e3 * Math.floor(t.nanoseconds / 1e3));
            return {
                timestampValue: me(e.serializer, r)
            };
        }
        if (t instanceof bo) return {
            geoPointValue: {
                latitude: t.latitude,
                longitude: t.longitude
            }
        };
        if (t instanceof J) return {
            bytesValue: we(e.serializer, t.U)
        };
        if (t instanceof Io) {
            var i = e.B, o = t.Qa;
            if (!o.isEqual(i)) throw e.xa("Document reference is for database " + o.projectId + "/" + o.database + " but should be for database " + i.projectId + "/" + i.database);
            return {
                referenceValue: _e(t.Qa || e.B, t.ja.path)
            };
        }
        if (void 0 === t && e.ignoreUndefinedProperties) return null;
        throw e.xa("Unsupported field value: " + x(t));
    }(t, e);
}

function ko(t, e) {
    var n = {};
    return E(t) ? 
    // If we encounter an empty object, we explicitly add it to the update
    // mask to ensure that the server creates a map entry.
    e.path && e.path.length > 0 && e.je.push(e.path) : b(t, (function(t, r) {
        var i = So(r, e.Ha(t));
        null != i && (n[t] = i);
    })), {
        mapValue: {
            fields: n
        }
    };
}

function jo(t) {
    return !("object" != typeof t || null === t || t instanceof Array || t instanceof Date || t instanceof it || t instanceof bo || t instanceof J || t instanceof Io || t instanceof lo);
}

function Po(t, e, n) {
    if (!jo(n) || !M(n)) {
        var r = x(n);
        throw "an object" === r ? e.xa(t + " a custom object") : e.xa(t + " " + r);
    }
}

/**
 * Helper that calls fromDotSeparatedString() but wraps any error thrown.
 */ function Co(t, e, n) {
    if (e instanceof co) return e.Ca;
    if ("string" == typeof e) return Mo(t, e);
    throw xo("Field path arguments must be of type string or FieldPath.", t, 
    /* hasConverter= */ !1, 
    /* path= */ void 0, n);
}

/**
 * Wraps fromDotSeparatedString with an error message about the method that
 * was thrown.
 * @param methodName The publicly visible method name
 * @param path The dot-separated string form of a field path which will be split
 * on dots.
 * @param targetDoc The document against which the field path will be evaluated.
 */ function Mo(e, n, r) {
    try {
        return function(e) {
            if (e.search(fo) >= 0) throw new c(a.INVALID_ARGUMENT, "Invalid field path (" + e + "). Paths must not contain '~', '*', '/', '[', or ']'");
            try {
                return new (ho.bind.apply(ho, t.__spreadArrays([ void 0 ], e.split("."))));
            } catch (t) {
                throw new c(a.INVALID_ARGUMENT, "Invalid field path (" + e + "). Paths must not be empty, begin with '.', end with '.', or contain '..'");
            }
        }(n).Ca;
    } catch (n) {
        throw xo((i = n) instanceof Error ? i.message : i.toString(), e, 
        /* hasConverter= */ !1, 
        /* path= */ void 0, r);
    }
    /**
 * Extracts the message from a caught exception, which should be an Error object
 * though JS doesn't guarantee that.
 */    var i;
    /** Checks `haystack` if FieldPath `needle` is present. Runs in O(n). */}

function xo(t, e, n, r, i) {
    var o = r && !r.m(), s = void 0 !== i, u = "Function " + e + "() called with invalid data";
    n && (u += " (via `toFirestore()`)");
    var h = "";
    return (o || s) && (h += " (found", o && (h += " in field " + r), s && (h += " in document " + i), 
    h += ")"), new c(a.INVALID_ARGUMENT, (u += ". ") + t + h);
}

function qo(t, e) {
    return t.some((function(t) {
        return t.isEqual(e);
    }));
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Internal transaction object responsible for accumulating the mutations to
 * perform and the base versions for any documents read.
 */ var Fo = /** @class */ function() {
    function e(t) {
        this.jo = t, 
        // The version of each document that was read during this transaction.
        this.eh = new Map, this.mutations = [], this.nh = !1, 
        /**
             * A deferred usage error that occurred previously in this transaction that
             * will cause the transaction to fail once it actually commits.
             */
        this.sh = null, 
        /**
             * Set of documents that have been written in the transaction.
             *
             * When there's more than one write to the same key in a transaction, any
             * writes after the first are handled differently.
             */
        this.ih = new Set;
    }
    return e.prototype.rh = function(e) {
        return t.__awaiter(this, void 0, void 0, (function() {
            var n, r = this;
            return t.__generator(this, (function(i) {
                switch (i.label) {
                  case 0:
                    if (this.oh(), this.mutations.length > 0) throw new c(a.INVALID_ARGUMENT, "Firestore transactions require all reads to be executed before all writes.");
                    return [ 4 /*yield*/ , function(e, n) {
                        return t.__awaiter(this, void 0, void 0, (function() {
                            var r, i, o, s, u, a;
                            return t.__generator(this, (function(t) {
                                switch (t.label) {
                                  case 0:
                                    return r = m(e), i = Te(r.serializer) + "/documents", o = {
                                        documents: n.map((function(t) {
                                            return Ie(r.serializer, t);
                                        }))
                                    }, [ 4 /*yield*/ , r.$o("BatchGetDocuments", i, o) ];

                                  case 1:
                                    return s = t.sent(), u = new Map, s.forEach((function(t) {
                                        var e = function(t, e) {
                                            return "found" in e ? function(t, e) {
                                                g(!!e.found), e.found.name, e.found.updateTime;
                                                var n = Ae(t, e.found.name), r = Ee(e.found.updateTime), i = new vn({
                                                    mapValue: {
                                                        fields: e.found.fields
                                                    }
                                                });
                                                return new wn(n, r, i, {});
                                            }(t, e) : "missing" in e ? function(t, e) {
                                                g(!!e.missing), g(!!e.readTime);
                                                var n = Ae(t, e.missing), r = Ee(e.readTime);
                                                return new bn(n, r);
                                            }(t, e) : y();
                                        }(r.serializer, t);
                                        u.set(e.key.toString(), e);
                                    })), a = [], [ 2 /*return*/ , (n.forEach((function(t) {
                                        var e = u.get(t.toString());
                                        g(!!e), a.push(e);
                                    })), a) ];
                                }
                            }));
                        }));
                    }(this.jo, e) ];

                  case 1:
                    return [ 2 /*return*/ , ((n = i.sent()).forEach((function(t) {
                        t instanceof bn || t instanceof wn ? r.uh(t) : y();
                    })), n) ];
                }
            }));
        }));
    }, e.prototype.set = function(t, e) {
        this.write(e.Ga(t, this.ze(t))), this.ih.add(t.toString());
    }, e.prototype.update = function(t, e) {
        try {
            this.write(e.Ga(t, this.ah(t)));
        } catch (t) {
            this.sh = t;
        }
        this.ih.add(t.toString());
    }, e.prototype.delete = function(t) {
        this.write([ new pn(t, this.ze(t)) ]), this.ih.add(t.toString());
    }, e.prototype.commit = function() {
        return t.__awaiter(this, void 0, void 0, (function() {
            var e, n = this;
            return t.__generator(this, (function(r) {
                switch (r.label) {
                  case 0:
                    if (this.oh(), this.sh) throw this.sh;
                    return e = this.eh, 
                    // For each mutation, note that the doc was written.
                    this.mutations.forEach((function(t) {
                        e.delete(t.key.toString());
                    })), 
                    // For each document that was read but not written to, we want to perform
                    // a `verify` operation.
                    e.forEach((function(t, e) {
                        var r = T.D(e);
                        n.mutations.push(new dn(r, n.ze(r)));
                    })), [ 4 /*yield*/ , function(e, n) {
                        return t.__awaiter(this, void 0, void 0, (function() {
                            var r, i, o;
                            return t.__generator(this, (function(t) {
                                switch (t.label) {
                                  case 0:
                                    return r = m(e), i = Te(r.serializer) + "/documents", o = {
                                        writes: n.map((function(t) {
                                            return Ve(r.serializer, t);
                                        }))
                                    }, [ 4 /*yield*/ , r.No("Commit", i, o) ];

                                  case 1:
                                    return t.sent(), [ 2 /*return*/ ];
                                }
                            }));
                        }));
                    }(this.jo, this.mutations) ];

                  case 1:
                    // For each mutation, note that the doc was written.
                    return r.sent(), this.nh = !0, [ 2 /*return*/ ];
                }
            }));
        }));
    }, e.prototype.uh = function(t) {
        var e;
        if (t instanceof wn) e = t.version; else {
            if (!(t instanceof bn)) throw y();
            // For deleted docs, we must use baseVersion 0 when we overwrite them.
                        e = ot.min();
        }
        var n = this.eh.get(t.key.toString());
        if (n) {
            if (!e.isEqual(n)) 
            // This transaction will fail no matter what.
            throw new c(a.ABORTED, "Document version changed between two reads.");
        } else this.eh.set(t.key.toString(), e);
    }, 
    /**
     * Returns the version of this document when it was read in this transaction,
     * as a precondition, or no precondition if it was not read.
     */
    e.prototype.ze = function(t) {
        var e = this.eh.get(t.toString());
        return !this.ih.has(t.toString()) && e ? $e.updateTime(e) : $e.Ye();
    }, 
    /**
     * Returns the precondition for a document if the operation is an update.
     */
    e.prototype.ah = function(t) {
        var e = this.eh.get(t.toString());
        // The first time a document is written, we want to take into account the
        // read time and existence
                if (!this.ih.has(t.toString()) && e) {
            if (e.isEqual(ot.min())) 
            // The document doesn't exist, so fail the transaction.
            // This has to be validated locally because you can't send a
            // precondition that a document does not exist without changing the
            // semantics of the backend write to be an insert. This is the reverse
            // of what we want, since we want to assert that the document doesn't
            // exist but then send the update and have it fail. Since we can't
            // express that to the backend, we have to validate locally.
            // Note: this can change once we can send separate verify writes in the
            // transaction.
            throw new c(a.INVALID_ARGUMENT, "Can't update a document that doesn't exist.");
            // Document exists, base precondition on document update time.
                        return $e.updateTime(e);
        }
        // Document was not read, so we just use the preconditions for a blind
        // update.
                return $e.exists(!0);
    }, e.prototype.write = function(t) {
        this.oh(), this.mutations = this.mutations.concat(t);
    }, e.prototype.oh = function() {}, e;
}(), Bo = /** @class */ function() {
    function e(t, e, n, r) {
        this.On = t, this.jo = e, this.updateFunction = n, this.qn = r, this.hh = 5, this.Xn = new nr(this.On, "transaction_retry" /* TransactionRetry */)
        /** Runs the transaction and sets the result on deferred. */;
    }
    return e.prototype.run = function() {
        this.lh();
    }, e.prototype.lh = function() {
        var e = this;
        this.Xn.yn((function() {
            return t.__awaiter(e, void 0, void 0, (function() {
                var e, n, r = this;
                return t.__generator(this, (function(t) {
                    return e = new Fo(this.jo), (n = this._h(e)) && n.then((function(t) {
                        r.On.jn((function() {
                            return e.commit().then((function() {
                                r.qn.resolve(t);
                            })).catch((function(t) {
                                r.fh(t);
                            }));
                        }));
                    })).catch((function(t) {
                        r.fh(t);
                    })), [ 2 /*return*/ ];
                }));
            }));
        }));
    }, e.prototype._h = function(t) {
        try {
            var e = this.updateFunction(t);
            return !st(e) && e.catch && e.then ? e : (this.qn.reject(Error("Transaction callback must return a Promise")), 
            null);
        } catch (t) {
            // Do not retry errors thrown by user provided updateFunction.
            return this.qn.reject(t), null;
        }
    }, e.prototype.fh = function(t) {
        var e = this;
        this.hh > 0 && this.dh(t) ? (this.hh -= 1, this.On.jn((function() {
            return e.lh(), Promise.resolve();
        }))) : this.qn.reject(t);
    }, e.prototype.dh = function(t) {
        if ("FirebaseError" === t.name) {
            // In transactions, the backend will fail outdated reads with FAILED_PRECONDITION and
            // non-matching document versions with ABORTED. These errors should be retried.
            var e = t.code;
            return "aborted" === e || "failed-precondition" === e || !gt(e);
        }
        return !1;
    }, e;
}(), Go = /** @class */ function() {
    function e(t, 
    /**
     * Asynchronous queue responsible for all of our internal processing. When
     * we get incoming work from the user (via public API) or the network
     * (incoming GRPC messages), we should always schedule onto this queue.
     * This ensures all of our work is properly serialized (e.g. we don't
     * start processing a new operation while the previous one is waiting for
     * an async I/O to complete).
     */
    e) {
        this.credentials = t, this.On = e, this.clientId = K.k(), 
        // We defer our initialization until we get the current user from
        // setChangeListener(). We block the async queue until we got the initial
        // user and the initialization is completed. This will prevent any scheduled
        // work from happening before initialization is completed.
        // If initializationDone resolved then the FirestoreClient is in a usable
        // state.
        this.wh = new er
        /**
     * Starts up the FirestoreClient, returning only whether or not enabling
     * persistence succeeded.
     *
     * The intent here is to "do the right thing" as far as users are concerned.
     * Namely, in cases where offline persistence is requested and possible,
     * enable it, but otherwise fall back to persistence disabled. For the most
     * part we expect this to succeed one way or the other so we don't expect our
     * users to actually wait on the firestore.enablePersistence Promise since
     * they generally won't care.
     *
     * Of course some users actually do care about whether or not persistence
     * was successfully enabled, so the Promise returned from this method
     * indicates this outcome.
     *
     * This presents a problem though: even before enablePersistence resolves or
     * rejects, users may have made calls to e.g. firestore.collection() which
     * means that the FirestoreClient in there will be available and will be
     * enqueuing actions on the async queue.
     *
     * Meanwhile any failure of an operation on the async queue causes it to
     * panic and reject any further work, on the premise that unhandled errors
     * are fatal.
     *
     * Consequently the fallback is handled internally here in start, and if the
     * fallback succeeds we signal success to the async queue even though the
     * start() itself signals failure.
     *
     * @param databaseInfo The connection information for the current instance.
     * @param offlineComponentProvider Provider that returns all components
     * required for memory-only or IndexedDB persistence.
     * @param onlineComponentProvider Provider that returns all components
     * required for online support.
     * @param persistenceSettings Settings object to configure offline
     *     persistence.
     * @returns A deferred result indicating the user-visible result of enabling
     *     offline persistence. This method will reject this if IndexedDB fails to
     *     start for any reason. If usePersistence is false this is
     *     unconditionally resolved.
     */;
    }
    return e.prototype.start = function(e, n, r, i) {
        var o = this;
        this.mh(), this.sa = e;
        // If usePersistence is true, certain classes of errors while starting are
        // recoverable but only by falling back to persistence disabled.
        // If there's an error in the first case but not in recovery we cannot
        // reject the promise blocking the async queue because this will cause the
        // async queue to panic.
        var s = new er, u = !1;
        // Return only the result of enabling persistence. Note that this does not
        // need to await the completion of initializationDone because the result of
        // this method should not reflect any other kind of failure to start.
        return this.credentials.Wr((function(e) {
            if (!u) return u = !0, l("FirestoreClient", "Initializing. user=", e.uid), o.Th(n, r, i, e, s).then(o.wh.resolve, o.wh.reject);
            o.On.os((function() {
                return function(e, n) {
                    return t.__awaiter(this, void 0, void 0, (function() {
                        var r, i;
                        return t.__generator(this, (function(t) {
                            switch (t.label) {
                              case 0:
                                return (r = m(e)).On.hs(), l("RemoteStore", "RemoteStore received new credentials"), 
                                i = oi(r), 
                                // Tear down and re-create our network streams. This will ensure we get a
                                // fresh auth token for the new user and re-fill the write pipeline with
                                // new mutations from the LocalStore (since mutations are per-user).
                                r.Ko.add(3 /* CredentialChange */), [ 4 /*yield*/ , Jr(r) ];

                              case 1:
                                return t.sent(), i && 
                                // Don't set the network status to Unknown if we are offline.
                                r.Xo.set("Unknown" /* Unknown */), [ 4 /*yield*/ , r.Wo.ba(n) ];

                              case 2:
                                return t.sent(), r.Ko.delete(3 /* CredentialChange */), [ 4 /*yield*/ , Yr(r) ];

                              case 3:
                                // Tear down and re-create our network streams. This will ensure we get a
                                // fresh auth token for the new user and re-fill the write pipeline with
                                // new mutations from the LocalStore (since mutations are per-user).
                                return t.sent(), [ 2 /*return*/ ];
                            }
                        }));
                    }));
                }(o.gu, e);
            }));
        })), 
        // Block the async queue until initialization is done
        this.On.jn((function() {
            return o.wh.promise;
        })), s.promise;
    }, 
    /** Enables the network connection and requeues all pending operations. */ e.prototype.enableNetwork = function() {
        var t = this;
        return this.mh(), this.On.enqueue((function() {
            return t.persistence.Oc(!0), function(t) {
                var e = m(t);
                return e.Ko.delete(0 /* UserDisabled */), Yr(e);
            }(t.gu);
        }));
    }, 
    /**
     * Initializes persistent storage, attempting to use IndexedDB if
     * usePersistence is true or memory-only if false.
     *
     * If IndexedDB fails because it's already open in another tab or because the
     * platform can't possibly support our implementation then this method rejects
     * the persistenceResult and falls back on memory-only persistence.
     *
     * @param offlineComponentProvider Provider that returns all components
     * required for memory-only or IndexedDB persistence.
     * @param onlineComponentProvider Provider that returns all components
     * required for online support.
     * @param persistenceSettings Settings object to configure offline persistence
     * @param user The initial user
     * @param persistenceResult A deferred result indicating the user-visible
     *     result of enabling offline persistence. This method will reject this if
     *     IndexedDB fails to start for any reason. If usePersistence is false
     *     this is unconditionally resolved.
     * @returns a Promise indicating whether or not initialization should
     *     continue, i.e. that one of the persistence implementations actually
     *     succeeded.
     */
    e.prototype.Th = function(e, n, r, i, o) {
        return t.__awaiter(this, void 0, void 0, (function() {
            var s, u, a = this;
            return t.__generator(this, (function(c) {
                switch (c.label) {
                  case 0:
                    return c.trys.push([ 0, 3, , 4 ]), s = {
                        On: this.On,
                        sa: this.sa,
                        clientId: this.clientId,
                        credentials: this.credentials,
                        Ra: i,
                        vu: 100,
                        persistenceSettings: r
                    }, [ 4 /*yield*/ , e.initialize(s) ];

                  case 1:
                    return c.sent(), [ 4 /*yield*/ , n.initialize(e, s) ];

                  case 2:
                    return c.sent(), this.persistence = e.persistence, this.Vu = e.Vu, this.Qo = e.Qo, 
                    this.Ea = e.Ea, this.jo = n.jo, this.gu = n.gu, this.Va = n.Va, this.Eh = n.pu, 
                    this.Eh.Is = Di.bind(null, this.Va), this.Eh.ys = Vi.bind(null, this.Va), 
                    // When a user calls clearPersistence() in one client, all other clients
                    // need to be terminated to allow the delete to succeed.
                    this.persistence.kc((function() {
                        return t.__awaiter(a, void 0, void 0, (function() {
                            return t.__generator(this, (function(t) {
                                switch (t.label) {
                                  case 0:
                                    return [ 4 /*yield*/ , this.terminate() ];

                                  case 1:
                                    return t.sent(), [ 2 /*return*/ ];
                                }
                            }));
                        }));
                    })), o.resolve(), [ 3 /*break*/ , 4 ];

                  case 3:
                    // An unknown failure on the first stage shuts everything down.
                    if (u = c.sent(), 
                    // Regardless of whether or not the retry succeeds, from an user
                    // perspective, offline persistence has failed.
                    o.reject(u), !this.Ih(u)) throw u;
                    return [ 2 /*return*/ , (console.warn("Error enabling offline persistence. Falling back to persistence disabled: " + u), 
                    this.Th(new so, new uo, {
                        ya: !1
                    }, i, o)) ];

                  case 4:
                    return [ 2 /*return*/ ];
                }
            }));
        }));
    }, 
    /**
     * Decides whether the provided error allows us to gracefully disable
     * persistence (as opposed to crashing the client).
     */
    e.prototype.Ih = function(t) {
        return "FirebaseError" === t.name ? t.code === a.FAILED_PRECONDITION || t.code === a.UNIMPLEMENTED : !("undefined" != typeof DOMException && t instanceof DOMException) || 
        // When the browser is out of quota we could get either quota exceeded
        // or an aborted error depending on whether the error happened during
        // schema migration.
        22 === t.code || 20 === t.code || 
        // Firefox Private Browsing mode disables IndexedDb and returns
        // INVALID_STATE for any usage.
        11 === t.code;
    }, 
    /**
     * Checks that the client has not been terminated. Ensures that other methods on
     * this class cannot be called after the client is terminated.
     */
    e.prototype.mh = function() {
        if (this.On.ts) throw new c(a.FAILED_PRECONDITION, "The client has already been terminated.");
    }, 
    /** Disables the network connection. Pending operations will not complete. */ e.prototype.disableNetwork = function() {
        var e = this;
        return this.mh(), this.On.enqueue((function() {
            return e.persistence.Oc(!1), function(e) {
                return t.__awaiter(this, void 0, void 0, (function() {
                    var n;
                    return t.__generator(this, (function(t) {
                        switch (t.label) {
                          case 0:
                            return (n = m(e)).Ko.add(0 /* UserDisabled */), [ 4 /*yield*/ , Jr(n) ];

                          case 1:
                            return t.sent(), 
                            // Set the OnlineState to Offline so get()s return from cache, etc.
                            n.Xo.set("Offline" /* Offline */), [ 2 /*return*/ ];
                        }
                    }));
                }));
            }(e.gu);
        }));
    }, e.prototype.terminate = function() {
        var e = this;
        this.On.rs();
        var n = new er;
        return this.On.es((function() {
            return t.__awaiter(e, void 0, void 0, (function() {
                var e, r;
                return t.__generator(this, (function(t) {
                    switch (t.label) {
                      case 0:
                        return t.trys.push([ 0, 4, , 5 ]), 
                        // PORTING NOTE: LocalStore does not need an explicit shutdown on web.
                        this.Ea && this.Ea.stop(), [ 4 /*yield*/ , $r(this.gu) ];

                      case 1:
                        return t.sent(), [ 4 /*yield*/ , this.Vu.ni() ];

                      case 2:
                        return t.sent(), [ 4 /*yield*/ , this.persistence.ni() ];

                      case 3:
                        // PORTING NOTE: LocalStore does not need an explicit shutdown on web.
                        return t.sent(), 
                        // `removeChangeListener` must be called after shutting down the
                        // RemoteStore as it will prevent the RemoteStore from retrieving
                        // auth tokens.
                        this.credentials.Gr(), n.resolve(), [ 3 /*break*/ , 5 ];

                      case 4:
                        return e = t.sent(), r = ar(e, "Failed to shutdown persistence"), n.reject(r), [ 3 /*break*/ , 5 ];

                      case 5:
                        return [ 2 /*return*/ ];
                    }
                }));
            }));
        })), n.promise;
    }, 
    /**
     * Returns a Promise that resolves when all writes that were pending at the time this
     * method was called received server acknowledgement. An acknowledgement can be either acceptance
     * or rejection.
     */
    e.prototype.waitForPendingWrites = function() {
        var e = this;
        this.mh();
        var n = new er;
        return this.On.jn((function() {
            return function(e, n) {
                return t.__awaiter(this, void 0, void 0, (function() {
                    var r, i, o, s, u;
                    return t.__generator(this, (function(t) {
                        switch (t.label) {
                          case 0:
                            oi((r = m(e)).gu) || l("SyncEngine", "The network is disabled. The task returned by 'awaitPendingWrites()' will not complete until the network is enabled."), 
                            t.label = 1;

                          case 1:
                            return t.trys.push([ 1, 3, , 4 ]), [ 4 /*yield*/ , function(t) {
                                var e = m(t);
                                return e.persistence.runTransaction("Get highest unacknowledged batch id", "readonly", (function(t) {
                                    return e.li.zu(t);
                                }));
                            }(r.Qo) ];

                          case 2:
                            return -1 === (i = t.sent()) ? [ 2 /*return*/ , void n.resolve() ] : ((o = r.ku.get(i) || []).push(n), 
                            r.ku.set(i, o), [ 3 /*break*/ , 4 ]);

                          case 3:
                            return s = t.sent(), u = ar(s, "Initialization of waitForPendingWrites() operation failed"), 
                            n.reject(u), [ 3 /*break*/ , 4 ];

                          case 4:
                            return [ 2 /*return*/ ];
                        }
                    }));
                }));
            }(e.Va, n);
        })), n.promise;
    }, e.prototype.listen = function(t, e, n) {
        var r = this;
        this.mh();
        var i = new ao(n), o = new yr(t, i, e);
        return this.On.jn((function() {
            return fr(r.Eh, o);
        })), function() {
            i.Da(), r.On.jn((function() {
                return lr(r.Eh, o);
            }));
        };
    }, e.prototype.Ah = function(e) {
        return t.__awaiter(this, void 0, void 0, (function() {
            var n, r = this;
            return t.__generator(this, (function(i) {
                switch (i.label) {
                  case 0:
                    return this.mh(), [ 4 /*yield*/ , this.wh.promise ];

                  case 1:
                    return i.sent(), n = new er, [ 2 /*return*/ , (this.On.jn((function() {
                        return function(e, n, r) {
                            return t.__awaiter(this, void 0, void 0, (function() {
                                var i, o, s;
                                return t.__generator(this, (function(t) {
                                    switch (t.label) {
                                      case 0:
                                        return t.trys.push([ 0, 2, , 3 ]), [ 4 /*yield*/ , function(t, e) {
                                            var n = m(t);
                                            return n.persistence.runTransaction("read document", "readonly", (function(t) {
                                                return n.nr.fi(t, e);
                                            }));
                                        }(e, n) ];

                                      case 1:
                                        return (i = t.sent()) instanceof wn ? r.resolve(i) : i instanceof bn ? r.resolve(null) : r.reject(new c(a.UNAVAILABLE, "Failed to get document from cache. (However, this document may exist on the server. Run again without setting 'source' in the GetOptions to attempt to retrieve the document from the server.)")), 
                                        [ 3 /*break*/ , 3 ];

                                      case 2:
                                        return o = t.sent(), s = ar(o, "Failed to get document '" + n + " from cache"), 
                                        r.reject(s), [ 3 /*break*/ , 3 ];

                                      case 3:
                                        return [ 2 /*return*/ ];
                                    }
                                }));
                            }));
                        }(r.Qo, e, n);
                    })), n.promise) ];
                }
            }));
        }));
    }, e.prototype.Rh = function(e, n) {
        return void 0 === n && (n = {}), t.__awaiter(this, void 0, void 0, (function() {
            var r, i = this;
            return t.__generator(this, (function(t) {
                switch (t.label) {
                  case 0:
                    return this.mh(), [ 4 /*yield*/ , this.wh.promise ];

                  case 1:
                    return t.sent(), r = new er, [ 2 /*return*/ , (this.On.jn((function() {
                        return function(t, e, n, r, i) {
                            var o = new ao({
                                next: function(o) {
                                    // Remove query first before passing event to user to avoid
                                    // user actions affecting the now stale query.
                                    e.jn((function() {
                                        return lr(t, s);
                                    }));
                                    var u = o.docs.has(n);
                                    !u && o.fromCache ? 
                                    // TODO(dimond): If we're online and the document doesn't
                                    // exist then we resolve with a doc.exists set to false. If
                                    // we're offline however, we reject the Promise in this
                                    // case. Two options: 1) Cache the negative response from
                                    // the server so we can deliver that even when you're
                                    // offline 2) Actually reject the Promise in the online case
                                    // if the document doesn't exist.
                                    i.reject(new c(a.UNAVAILABLE, "Failed to get document because the client is offline.")) : u && o.fromCache && r && "server" === r.source ? i.reject(new c(a.UNAVAILABLE, 'Failed to get document from server. (However, this document does exist in the local cache. Run again without setting source to "server" to retrieve the cached document.)')) : i.resolve(o);
                                },
                                error: function(t) {
                                    return i.reject(t);
                                }
                            }), s = new yr(In(n.path), o, {
                                includeMetadataChanges: !0,
                                Ss: !0
                            });
                            return fr(t, s);
                        }(i.Eh, i.On, e, n, r);
                    })), r.promise) ];
                }
            }));
        }));
    }, e.prototype.yh = function(e) {
        return t.__awaiter(this, void 0, void 0, (function() {
            var n, r = this;
            return t.__generator(this, (function(i) {
                switch (i.label) {
                  case 0:
                    return this.mh(), [ 4 /*yield*/ , this.wh.promise ];

                  case 1:
                    return i.sent(), n = new er, [ 2 /*return*/ , (this.On.jn((function() {
                        return function(e, n, r) {
                            return t.__awaiter(this, void 0, void 0, (function() {
                                var i, o, s, u, a, c;
                                return t.__generator(this, (function(t) {
                                    switch (t.label) {
                                      case 0:
                                        return t.trys.push([ 0, 2, , 3 ]), [ 4 /*yield*/ , jr(e, n, 
                                        /* usePreviousResults= */ !0) ];

                                      case 1:
                                        return i = t.sent(), o = new Ii(n, i.Vr), s = o._u(i.documents), u = o.mu(s, 
                                        /* updateLimboDocuments= */ !1), r.resolve(u.snapshot), [ 3 /*break*/ , 3 ];

                                      case 2:
                                        return a = t.sent(), c = ar(a, "Failed to execute query '" + n + " against cache"), 
                                        r.reject(c), [ 3 /*break*/ , 3 ];

                                      case 3:
                                        return [ 2 /*return*/ ];
                                    }
                                }));
                            }));
                        }(r.Qo, e, n);
                    })), n.promise) ];
                }
            }));
        }));
    }, e.prototype.Ph = function(e, n) {
        return void 0 === n && (n = {}), t.__awaiter(this, void 0, void 0, (function() {
            var r, i = this;
            return t.__generator(this, (function(t) {
                switch (t.label) {
                  case 0:
                    return this.mh(), [ 4 /*yield*/ , this.wh.promise ];

                  case 1:
                    return t.sent(), r = new er, [ 2 /*return*/ , (this.On.jn((function() {
                        return function(t, e, n, r, i) {
                            var o = new ao({
                                next: function(n) {
                                    // Remove query first before passing event to user to avoid
                                    // user actions affecting the now stale query.
                                    e.jn((function() {
                                        return lr(t, s);
                                    })), n.fromCache && "server" === r.source ? i.reject(new c(a.UNAVAILABLE, 'Failed to get documents from server. (However, these documents may exist in the local cache. Run again without setting source to "server" to retrieve the cached documents.)')) : i.resolve(n);
                                },
                                error: function(t) {
                                    return i.reject(t);
                                }
                            }), s = new yr(n, o, {
                                includeMetadataChanges: !0,
                                Ss: !0
                            });
                            return fr(t, s);
                        }(i.Eh, i.On, e, n, r);
                    })), r.promise) ];
                }
            }));
        }));
    }, e.prototype.write = function(t) {
        var e = this;
        this.mh();
        var n = new er;
        return this.On.jn((function() {
            return Ri(e.Va, t, n);
        })), n.promise;
    }, e.prototype.B = function() {
        return this.sa.B;
    }, e.prototype.gh = function(e) {
        var n = this;
        this.mh();
        var r = new ao(e);
        return this.On.jn((function() {
            return t.__awaiter(n, void 0, void 0, (function() {
                return t.__generator(this, (function(t) {
                    return [ 2 /*return*/ , function(t, e) {
                        m(t).Es.add(e), 
                        // Immediately fire an initial event, indicating all existing listeners
                        // are in-sync.
                        e.next();
                    }(this.Eh, r) ];
                }));
            }));
        })), function() {
            r.Da(), n.On.jn((function() {
                return t.__awaiter(n, void 0, void 0, (function() {
                    return t.__generator(this, (function(t) {
                        return [ 2 /*return*/ , function(t, e) {
                            m(t).Es.delete(e);
                        }(this.Eh, r) ];
                    }));
                }));
            }));
        };
    }, Object.defineProperty(e.prototype, "ph", {
        get: function() {
            // Technically, the asyncQueue is still running, but only accepting operations
            // related to termination or supposed to be run after termination. It is effectively
            // terminated to the eyes of users.
            return this.On.ts;
        },
        enumerable: !1,
        configurable: !0
    }), 
    /**
     * Takes an updateFunction in which a set of reads and writes can be performed
     * atomically. In the updateFunction, the client can read and write values
     * using the supplied transaction object. After the updateFunction, all
     * changes will be committed. If a retryable error occurs (ex: some other
     * client has changed any of the data referenced), then the updateFunction
     * will be called again after a backoff. If the updateFunction still fails
     * after all retries, then the transaction will be rejected.
     *
     * The transaction object passed to the updateFunction contains methods for
     * accessing documents and collections. Unlike other datastore access, data
     * accessed with the transaction will not reflect local changes that have not
     * been committed. For this reason, it is required that all reads are
     * performed before any writes. Transactions must be performed while online.
     */
    e.prototype.transaction = function(t) {
        var e = this;
        this.mh();
        var n = new er;
        return this.On.jn((function() {
            return new Bo(e.On, e.jo, t, n).run(), Promise.resolve();
        })), n.promise;
    }, e;
}();

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * TransactionRunner encapsulates the logic needed to run and retry transactions
 * with backoff.
 */ function zo(t) {
    /**
 * Returns true if obj is an object and contains at least one of the specified
 * methods.
 */
    return function(t, e) {
        if ("object" != typeof t || null === t) return !1;
        for (var n = t, r = 0, i = [ "next", "error", "complete" ]; r < i.length; r++) {
            var o = i[r];
            if (o in n && "function" == typeof n[o]) return !0;
        }
        return !1;
    }(t);
}

var Wo = /** @class */ function() {
    function t(t, e, n, r, i) {
        this.B = t, this.timestampsInSnapshots = e, this.Vh = n, this.bh = r, this.Sh = i;
    }
    return t.prototype.Dh = function(t) {
        switch (Yt(t)) {
          case 0 /* NullValue */ :
            return null;

          case 1 /* BooleanValue */ :
            return t.booleanValue;

          case 2 /* NumberValue */ :
            return ie(t.integerValue || t.doubleValue);

          case 3 /* TimestampValue */ :
            return this.Ch(t.timestampValue);

          case 4 /* ServerTimestampValue */ :
            return this.Fh(t);

          case 5 /* StringValue */ :
            return t.stringValue;

          case 6 /* BlobValue */ :
            return this.Sh(oe(t.bytesValue));

          case 7 /* RefValue */ :
            return this.Nh(t.referenceValue);

          case 8 /* GeoPointValue */ :
            return this.$h(t.geoPointValue);

          case 9 /* ArrayValue */ :
            return this.xh(t.arrayValue);

          case 10 /* ObjectValue */ :
            return this.kh(t.mapValue);

          default:
            throw y();
        }
    }, t.prototype.kh = function(t) {
        var e = this, n = {};
        return b(t.fields || {}, (function(t, r) {
            n[t] = e.Dh(r);
        })), n;
    }, t.prototype.$h = function(t) {
        return new bo(ie(t.latitude), ie(t.longitude));
    }, t.prototype.xh = function(t) {
        var e = this;
        return (t.values || []).map((function(t) {
            return e.Dh(t);
        }));
    }, t.prototype.Fh = function(t) {
        switch (this.Vh) {
          case "previous":
            var e = Kt(t);
            return null == e ? null : this.Dh(e);

          case "estimate":
            return this.Ch(Xt(t));

          default:
            return null;
        }
    }, t.prototype.Ch = function(t) {
        var e = re(t), n = new it(e.seconds, e.nanos);
        return this.timestampsInSnapshots ? n : n.toDate();
    }, t.prototype.Nh = function(t) {
        var e = I.P(t);
        g(Pe(e));
        var n = new nt(e.get(1), e.get(3)), r = new T(e.u(5));
        return n.isEqual(this.B) || 
        // TODO(b/64130202): Somehow support foreign references.
        p("Document " + r + " contains a document reference within a different database (" + n.projectId + "/" + n.database + ") which is not supported. It will be treated as a reference in the current database (" + this.B.projectId + "/" + this.B.database + ") instead."), 
        this.bh(r);
    }, t;
}(), Qo = Nr.Oi, Ko = /** @class */ function() {
    function t(t) {
        var e, n, r, i, o;
        if (void 0 === t.host) {
            if (void 0 !== t.ssl) throw new c(a.INVALID_ARGUMENT, "Can't provide ssl option if host option is not set");
            this.host = "firestore.googleapis.com", this.ssl = !0;
        } else S("settings", "non-empty string", "host", t.host), this.host = t.host, k("settings", "boolean", "ssl", t.ssl), 
        this.ssl = null === (e = t.ssl) || void 0 === e || e;
        if (F("settings", t, [ "host", "ssl", "credentials", "timestampsInSnapshots", "cacheSizeBytes", "experimentalForceLongPolling", "experimentalAutoDetectLongPolling", "ignoreUndefinedProperties" ]), 
        k("settings", "object", "credentials", t.credentials), this.credentials = t.credentials, 
        k("settings", "boolean", "timestampsInSnapshots", t.timestampsInSnapshots), k("settings", "boolean", "ignoreUndefinedProperties", t.ignoreUndefinedProperties), 
        // Nobody should set timestampsInSnapshots anymore, but the error depends on
        // whether they set it to true or false...
        !0 === t.timestampsInSnapshots ? p("The setting 'timestampsInSnapshots: true' is no longer required and should be removed.") : !1 === t.timestampsInSnapshots && p("Support for 'timestampsInSnapshots: false' will be removed soon. You must update your code to handle Timestamp objects."), 
        this.timestampsInSnapshots = null === (n = t.timestampsInSnapshots) || void 0 === n || n, 
        this.ignoreUndefinedProperties = null !== (r = t.ignoreUndefinedProperties) && void 0 !== r && r, 
        k("settings", "number", "cacheSizeBytes", t.cacheSizeBytes), void 0 === t.cacheSizeBytes) this.cacheSizeBytes = Nr.Mi; else {
            if (t.cacheSizeBytes !== Qo && t.cacheSizeBytes < Nr.Li) throw new c(a.INVALID_ARGUMENT, "cacheSizeBytes must be at least " + Nr.Li);
            this.cacheSizeBytes = t.cacheSizeBytes;
        }
        k("settings", "boolean", "experimentalForceLongPolling", t.experimentalForceLongPolling), 
        this.experimentalForceLongPolling = null !== (i = t.experimentalForceLongPolling) && void 0 !== i && i, 
        k("settings", "boolean", "experimentalAutoDetectLongPolling", t.experimentalAutoDetectLongPolling), 
        this.experimentalAutoDetectLongPolling = null !== (o = t.experimentalAutoDetectLongPolling) && void 0 !== o && o, 
        function(t, e, n, r) {
            if (!0 === e && !0 === r) throw new c(a.INVALID_ARGUMENT, "experimentalForceLongPolling and experimentalAutoDetectLongPolling cannot be used together.");
        }(0, t.experimentalForceLongPolling, 0, t.experimentalAutoDetectLongPolling);
    }
    return t.prototype.isEqual = function(t) {
        return this.host === t.host && this.ssl === t.ssl && this.timestampsInSnapshots === t.timestampsInSnapshots && this.credentials === t.credentials && this.cacheSizeBytes === t.cacheSizeBytes && this.experimentalForceLongPolling === t.experimentalForceLongPolling && this.experimentalAutoDetectLongPolling === t.experimentalAutoDetectLongPolling && this.ignoreUndefinedProperties === t.ignoreUndefinedProperties;
    }, t;
}(), Xo = /** @class */ function() {
    // Note: We are using `MemoryComponentProvider` as a default
    // ComponentProvider to ensure backwards compatibility with the format
    // expected by the console build.
    function e(n, r, i, o) {
        var s = this;
        if (void 0 === i && (i = new so), void 0 === o && (o = new uo), this.Oh = i, this.Lh = o, 
        this.Mh = null, 
        // Public for use in tests.
        // TODO(mikelehen): Use modularized initialization instead.
        this.qh = new ur, this.INTERNAL = {
            delete: function() {
                return t.__awaiter(s, void 0, void 0, (function() {
                    return t.__generator(this, (function(t) {
                        switch (t.label) {
                          case 0:
                            // The client must be initalized to ensure that all subsequent API usage
                            // throws an exception.
                            return this.Uh(), [ 4 /*yield*/ , this.Bh.terminate() ];

                          case 1:
                            // The client must be initalized to ensure that all subsequent API usage
                            // throws an exception.
                            return t.sent(), [ 2 /*return*/ ];
                        }
                    }));
                }));
            }
        }, "object" == typeof n.options) {
            // This is very likely a Firebase app object
            // TODO(b/34177605): Can we somehow use instanceof?
            var u = n;
            this.Mh = u, this.Qa = e.Qh(u), this.jh = u.name, this.Wh = new Fr(r);
        } else {
            var h = n;
            if (!h.projectId) throw new c(a.INVALID_ARGUMENT, "Must provide projectId");
            this.Qa = new nt(h.projectId, h.database), 
            // Use a default persistenceKey that lines up with FirebaseApp.
            this.jh = "[DEFAULT]", this.Wh = new qr;
        }
        this.Gh = new Ko({});
    }
    return Object.defineProperty(e.prototype, "zh", {
        get: function() {
            return this.Kh || (
            // Lazy initialize UserDataReader once the settings are frozen
            this.Kh = new Vo(this.Qa, this.Gh.ignoreUndefinedProperties)), this.Kh;
        },
        enumerable: !1,
        configurable: !0
    }), e.prototype.settings = function(t) {
        V("Firestore.settings", arguments, 1), U("Firestore.settings", "object", 1, t), 
        t.merge && 
        // Remove the property from the settings once the merge is completed
        delete (t = Object.assign(Object.assign({}, this.Gh), t)).merge;
        var e = new Ko(t);
        if (this.Bh && !this.Gh.isEqual(e)) throw new c(a.FAILED_PRECONDITION, "Firestore has already been started and its settings can no longer be changed. You can only call settings() before calling any other methods on a Firestore object.");
        this.Gh = e, void 0 !== e.credentials && (this.Wh = function(t) {
            if (!t) return new qr;
            switch (t.type) {
              case "gapi":
                var e = t.client;
                // Make sure this really is a Gapi client.
                                return g(!("object" != typeof e || null === e || !e.auth || !e.auth.getAuthHeaderValueForFirstParty)), 
                new Gr(e, t.sessionIndex || "0");

              case "provider":
                return t.client;

              default:
                throw new c(a.INVALID_ARGUMENT, "makeCredentialsProvider failed due to invalid credential type");
            }
        }(e.credentials));
    }, e.prototype.enableNetwork = function() {
        return this.Uh(), this.Bh.enableNetwork();
    }, e.prototype.disableNetwork = function() {
        return this.Uh(), this.Bh.disableNetwork();
    }, e.prototype.enablePersistence = function(t) {
        var e, n;
        if (this.Bh) throw new c(a.FAILED_PRECONDITION, "Firestore has already been started and persistence can no longer be enabled. You can only call enablePersistence() before calling any other methods on a Firestore object.");
        var r = !1, i = !1;
        if (t && (void 0 !== t.experimentalTabSynchronization && p("The 'experimentalTabSynchronization' setting will be removed. Use 'synchronizeTabs' instead."), 
        r = null !== (n = null !== (e = t.synchronizeTabs) && void 0 !== e ? e : t.experimentalTabSynchronization) && void 0 !== n && n, 
        i = !!t.experimentalForceOwningTab && t.experimentalForceOwningTab, r && i)) throw new c(a.INVALID_ARGUMENT, "The 'experimentalForceOwningTab' setting cannot be used with 'synchronizeTabs'.");
        return this.Hh(this.Oh, this.Lh, {
            ya: !0,
            cacheSizeBytes: this.Gh.cacheSizeBytes,
            synchronizeTabs: r,
            Yh: i
        });
    }, e.prototype.clearPersistence = function() {
        return t.__awaiter(this, void 0, void 0, (function() {
            var e, n = this;
            return t.__generator(this, (function(r) {
                if (void 0 !== this.Bh && !this.Bh.ph) throw new c(a.FAILED_PRECONDITION, "Persistence can only be cleared before a Firestore instance is initialized or after it is terminated.");
                return e = new er, [ 2 /*return*/ , (this.qh.es((function() {
                    return t.__awaiter(n, void 0, void 0, (function() {
                        var n;
                        return t.__generator(this, (function(t) {
                            switch (t.label) {
                              case 0:
                                return t.trys.push([ 0, 2, , 3 ]), [ 4 /*yield*/ , this.Oh.clearPersistence(this.Qa, this.jh) ];

                              case 1:
                                return t.sent(), e.resolve(), [ 3 /*break*/ , 3 ];

                              case 2:
                                return n = t.sent(), e.reject(n), [ 3 /*break*/ , 3 ];

                              case 3:
                                return [ 2 /*return*/ ];
                            }
                        }));
                    }));
                })), e.promise) ];
            }));
        }));
    }, e.prototype.terminate = function() {
        return this.app._removeServiceInstance("firestore"), this.INTERNAL.delete();
    }, Object.defineProperty(e.prototype, "Jh", {
        get: function() {
            return this.Uh(), this.Bh.ph;
        },
        enumerable: !1,
        configurable: !0
    }), e.prototype.waitForPendingWrites = function() {
        return this.Uh(), this.Bh.waitForPendingWrites();
    }, e.prototype.onSnapshotsInSync = function(t) {
        if (this.Uh(), zo(t)) return this.Bh.gh(t);
        U("Firestore.onSnapshotsInSync", "function", 1, t);
        var e = {
            next: t
        };
        return this.Bh.gh(e);
    }, e.prototype.Uh = function() {
        return this.Bh || 
        // Kick off starting the client but don't actually wait for it.
        // eslint-disable-next-line @typescript-eslint/no-floating-promises
        this.Hh(new so, new uo, {
            ya: !1
        }), this.Bh;
    }, e.prototype.Xh = function() {
        return new et(this.Qa, this.jh, this.Gh.host, this.Gh.ssl, this.Gh.experimentalForceLongPolling, this.Gh.experimentalAutoDetectLongPolling);
    }, e.prototype.Hh = function(t, e, n) {
        var r = this.Xh();
        return this.Bh = new Go(this.Wh, this.qh), this.Bh.start(r, t, e, n);
    }, e.Qh = function(t) {
        if (e = t.options, "projectId", !Object.prototype.hasOwnProperty.call(e, "projectId")) throw new c(a.INVALID_ARGUMENT, '"projectId" not provided in firebase.initializeApp.');
        var e, n = t.options.projectId;
        if (!n || "string" != typeof n) throw new c(a.INVALID_ARGUMENT, "projectId must be a string in FirebaseApp.options");
        return new nt(n);
    }, Object.defineProperty(e.prototype, "app", {
        get: function() {
            if (!this.Mh) throw new c(a.FAILED_PRECONDITION, "Firestore was not initialized using the Firebase SDK. 'app' is not available");
            return this.Mh;
        },
        enumerable: !1,
        configurable: !0
    }), e.prototype.collection = function(t) {
        return V("Firestore.collection", arguments, 1), U("Firestore.collection", "non-empty string", 1, t), 
        this.Uh(), new cs(I.P(t), this, 
        /* converter= */ null);
    }, e.prototype.doc = function(t) {
        return V("Firestore.doc", arguments, 1), U("Firestore.doc", "non-empty string", 1, t), 
        this.Uh(), Jo.Zh(I.P(t), this, 
        /* converter= */ null);
    }, e.prototype.collectionGroup = function(t) {
        if (V("Firestore.collectionGroup", arguments, 1), U("Firestore.collectionGroup", "non-empty string", 1, t), 
        t.indexOf("/") >= 0) throw new c(a.INVALID_ARGUMENT, "Invalid collection ID '" + t + "' passed to function Firestore.collectionGroup(). Collection IDs must not contain '/'.");
        return this.Uh(), new us(
        /**
 * Creates a new Query for a collection group query that matches all documents
 * within the provided collection group.
 */
        function(t) {
            return new _n(I.g(), t);
        }(t), this, 
        /* converter= */ null);
    }, e.prototype.runTransaction = function(t) {
        var e = this;
        return V("Firestore.runTransaction", arguments, 1), U("Firestore.runTransaction", "function", 1, t), 
        this.Uh().transaction((function(n) {
            return t(new Ho(e, n));
        }));
    }, e.prototype.batch = function() {
        return this.Uh(), new Yo(this);
    }, Object.defineProperty(e, "logLevel", {
        get: function() {
            switch (f()) {
              case n.LogLevel.DEBUG:
                return "debug";

              case n.LogLevel.ERROR:
                return "error";

              case n.LogLevel.SILENT:
                return "silent";

              case n.LogLevel.WARN:
                return "warn";

              case n.LogLevel.INFO:
                return "info";

              case n.LogLevel.VERBOSE:
                return "verbose";

              default:
                // The default log level is error
                return "error";
            }
        },
        enumerable: !1,
        configurable: !0
    }), e.setLogLevel = function(t) {
        var e;
        V("Firestore.setLogLevel", arguments, 1), P("setLogLevel", [ "debug", "error", "silent", "warn", "info", "verbose" ], 1, t), 
        e = t, h.setLogLevel(e);
    }, 
    // Note: this is not a property because the minifier can't work correctly with
    // the way TypeScript compiler outputs properties.
    e.prototype.tl = function() {
        return this.Gh.timestampsInSnapshots;
    }, 
    // Visible for testing.
    e.prototype.el = function() {
        return this.Gh;
    }, e;
}(), Ho = /** @class */ function() {
    function t(t, e) {
        this.nl = t, this.sl = e;
    }
    return t.prototype.get = function(t) {
        var e = this;
        V("Transaction.get", arguments, 1);
        var n = ps("Transaction.get", t, this.nl);
        return this.sl.rh([ n.ja ]).then((function(t) {
            if (!t || 1 !== t.length) return y();
            var r = t[0];
            if (r instanceof bn) return new Zo(e.nl, n.ja, null, 
            /* fromCache= */ !1, 
            /* hasPendingWrites= */ !1, n.Wa);
            if (r instanceof wn) return new Zo(e.nl, n.ja, r, 
            /* fromCache= */ !1, 
            /* hasPendingWrites= */ !1, n.Wa);
            throw y();
        }));
    }, t.prototype.set = function(t, e, n) {
        L("Transaction.set", arguments, 2, 3);
        var r = ps("Transaction.set", t, this.nl);
        n = hs("Transaction.set", n);
        var i = vs(r.Wa, e, n), o = Ro(this.nl.zh, "Transaction.set", r.ja, i, null !== r.Wa, n);
        return this.sl.set(r.ja, o), this;
    }, t.prototype.update = function(t, e, n) {
        for (var r, i, o = [], s = 3; s < arguments.length; s++) o[s - 3] = arguments[s];
        return "string" == typeof e || e instanceof ho ? (R("Transaction.update", arguments, 3), 
        r = ps("Transaction.update", t, this.nl), i = Uo(this.nl.zh, "Transaction.update", r.ja, e, n, o)) : (V("Transaction.update", arguments, 2), 
        r = ps("Transaction.update", t, this.nl), i = Lo(this.nl.zh, "Transaction.update", r.ja, e)), 
        this.sl.update(r.ja, i), this;
    }, t.prototype.delete = function(t) {
        V("Transaction.delete", arguments, 1);
        var e = ps("Transaction.delete", t, this.nl);
        return this.sl.delete(e.ja), this;
    }, t;
}(), Yo = /** @class */ function() {
    function t(t) {
        this.nl = t, this.il = [], this.rl = !1;
    }
    return t.prototype.set = function(t, e, n) {
        L("WriteBatch.set", arguments, 2, 3), this.ol();
        var r = ps("WriteBatch.set", t, this.nl);
        n = hs("WriteBatch.set", n);
        var i = vs(r.Wa, e, n), o = Ro(this.nl.zh, "WriteBatch.set", r.ja, i, null !== r.Wa, n);
        return this.il = this.il.concat(o.Ga(r.ja, $e.Ye())), this;
    }, t.prototype.update = function(t, e, n) {
        for (var r, i, o = [], s = 3; s < arguments.length; s++) o[s - 3] = arguments[s];
        return this.ol(), "string" == typeof e || e instanceof ho ? (R("WriteBatch.update", arguments, 3), 
        r = ps("WriteBatch.update", t, this.nl), i = Uo(this.nl.zh, "WriteBatch.update", r.ja, e, n, o)) : (V("WriteBatch.update", arguments, 2), 
        r = ps("WriteBatch.update", t, this.nl), i = Lo(this.nl.zh, "WriteBatch.update", r.ja, e)), 
        this.il = this.il.concat(i.Ga(r.ja, $e.exists(!0))), this;
    }, t.prototype.delete = function(t) {
        V("WriteBatch.delete", arguments, 1), this.ol();
        var e = ps("WriteBatch.delete", t, this.nl);
        return this.il = this.il.concat(new pn(e.ja, $e.Ye())), this;
    }, t.prototype.commit = function() {
        return this.ol(), this.rl = !0, this.il.length > 0 ? this.nl.Uh().write(this.il) : Promise.resolve();
    }, t.prototype.ol = function() {
        if (this.rl) throw new c(a.FAILED_PRECONDITION, "A write batch can no longer be used after commit() has been called.");
    }, t;
}(), Jo = /** @class */ function(e) {
    function n(t, n, r) {
        var i = this;
        return (i = e.call(this, n.Qa, t, r) || this).ja = t, i.firestore = n, i.Wa = r, 
        i.Bh = i.firestore.Uh(), i;
    }
    return t.__extends(n, e), n.Zh = function(t, e, r) {
        if (t.length % 2 != 0) throw new c(a.INVALID_ARGUMENT, "Invalid document reference. Document references must have an even number of segments, but " + t.R() + " has " + t.length);
        return new n(new T(t), e, r);
    }, Object.defineProperty(n.prototype, "id", {
        get: function() {
            return this.ja.path._();
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(n.prototype, "parent", {
        get: function() {
            return new cs(this.ja.path.h(), this.firestore, this.Wa);
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(n.prototype, "path", {
        get: function() {
            return this.ja.path.R();
        },
        enumerable: !1,
        configurable: !0
    }), n.prototype.collection = function(t) {
        if (V("DocumentReference.collection", arguments, 1), U("DocumentReference.collection", "non-empty string", 1, t), 
        !t) throw new c(a.INVALID_ARGUMENT, "Must provide a non-empty collection name to collection()");
        var e = I.P(t);
        return new cs(this.ja.path.child(e), this.firestore, 
        /* converter= */ null);
    }, n.prototype.isEqual = function(t) {
        if (!(t instanceof n)) throw B("isEqual", "DocumentReference", 1, t);
        return this.firestore === t.firestore && this.ja.isEqual(t.ja) && this.Wa === t.Wa;
    }, n.prototype.set = function(t, e) {
        L("DocumentReference.set", arguments, 1, 2), e = hs("DocumentReference.set", e);
        var n = vs(this.Wa, t, e), r = Ro(this.firestore.zh, "DocumentReference.set", this.ja, n, null !== this.Wa, e);
        return this.Bh.write(r.Ga(this.ja, $e.Ye()));
    }, n.prototype.update = function(t, e) {
        for (var n, r = [], i = 2; i < arguments.length; i++) r[i - 2] = arguments[i];
        return "string" == typeof t || t instanceof ho ? (R("DocumentReference.update", arguments, 2), 
        n = Uo(this.firestore.zh, "DocumentReference.update", this.ja, t, e, r)) : (V("DocumentReference.update", arguments, 1), 
        n = Lo(this.firestore.zh, "DocumentReference.update", this.ja, t)), this.Bh.write(n.Ga(this.ja, $e.exists(!0)));
    }, n.prototype.delete = function() {
        return V("DocumentReference.delete", arguments, 0), this.Bh.write([ new pn(this.ja, $e.Ye()) ]);
    }, n.prototype.onSnapshot = function() {
        for (var t, e, n, r = this, i = [], o = 0; o < arguments.length; o++) i[o] = arguments[o];
        L("DocumentReference.onSnapshot", arguments, 1, 4);
        var s = {
            includeMetadataChanges: !1
        }, u = 0;
        "object" != typeof i[u] || zo(i[u]) || (F("DocumentReference.onSnapshot", s = i[u], [ "includeMetadataChanges" ]), 
        k("DocumentReference.onSnapshot", "boolean", "includeMetadataChanges", s.includeMetadataChanges), 
        u++);
        var a = {
            includeMetadataChanges: s.includeMetadataChanges
        };
        if (zo(i[u])) {
            var c = i[u];
            i[u] = null === (t = c.next) || void 0 === t ? void 0 : t.bind(c), i[u + 1] = null === (e = c.error) || void 0 === e ? void 0 : e.bind(c), 
            i[u + 2] = null === (n = c.complete) || void 0 === n ? void 0 : n.bind(c);
        } else U("DocumentReference.onSnapshot", "function", u, i[u]), O("DocumentReference.onSnapshot", "function", u + 1, i[u + 1]), 
        O("DocumentReference.onSnapshot", "function", u + 2, i[u + 2]);
        var h = {
            next: function(t) {
                i[u] && i[u](r.ul(t));
            },
            error: i[u + 1],
            complete: i[u + 2]
        };
        return this.Bh.listen(In(this.ja.path), a, h);
    }, n.prototype.get = function(t) {
        var e = this;
        L("DocumentReference.get", arguments, 0, 1), ls("DocumentReference.get", t);
        var n = this.firestore.Uh();
        return t && "cache" === t.source ? n.Ah(this.ja).then((function(t) {
            return new Zo(e.firestore, e.ja, t, 
            /*fromCache=*/ !0, t instanceof wn && t.Je, e.Wa);
        })) : n.Rh(this.ja, t).then((function(t) {
            return e.ul(t);
        }));
    }, n.prototype.withConverter = function(t) {
        return new n(this.ja, this.firestore, t);
    }, 
    /**
     * Converts a ViewSnapshot that contains the current document to a
     * DocumentSnapshot.
     */
    n.prototype.ul = function(t) {
        var e = t.docs.get(this.ja);
        return new Zo(this.firestore, this.ja, e, t.fromCache, t.hasPendingWrites, this.Wa);
    }, n;
}(Io), $o = /** @class */ function() {
    function t(t, e) {
        this.hasPendingWrites = t, this.fromCache = e
        /**
     * Returns true if this `SnapshotMetadata` is equal to the provided one.
     *
     * @param other The `SnapshotMetadata` to compare against.
     * @return true if this `SnapshotMetadata` is equal to the provided one.
     */;
    }
    return t.prototype.isEqual = function(t) {
        return this.hasPendingWrites === t.hasPendingWrites && this.fromCache === t.fromCache;
    }, t;
}(), Zo = /** @class */ function() {
    function t(t, e, n, r, i, o) {
        this.nl = t, this.ja = e, this.cl = n, this.al = r, this.hl = i, this.Wa = o;
    }
    return t.prototype.data = function(t) {
        var e = this;
        if (L("DocumentSnapshot.data", arguments, 0, 1), t = fs("DocumentSnapshot.data", t), 
        this.cl) {
            // We only want to use the converter and create a new DocumentSnapshot
            // if a converter has been provided.
            if (this.Wa) {
                var n = new ts(this.nl, this.ja, this.cl, this.al, this.hl, 
                /* converter= */ null);
                return this.Wa.fromFirestore(n, t);
            }
            return new Wo(this.nl.Qa, this.nl.tl(), t.serverTimestamps || "none", (function(t) {
                return new Jo(t, e.nl, /* converter= */ null);
            }), (function(t) {
                return new tt(t);
            })).Dh(this.cl.rn());
        }
    }, t.prototype.get = function(t, e) {
        var n = this;
        if (L("DocumentSnapshot.get", arguments, 1, 2), e = fs("DocumentSnapshot.get", e), 
        this.cl) {
            var r = this.cl.data().field(Co("DocumentSnapshot.get", t, this.ja));
            if (null !== r) return new Wo(this.nl.Qa, this.nl.tl(), e.serverTimestamps || "none", (function(t) {
                return new Jo(t, n.nl, n.Wa);
            }), (function(t) {
                return new tt(t);
            })).Dh(r);
        }
    }, Object.defineProperty(t.prototype, "id", {
        get: function() {
            return this.ja.path._();
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "ref", {
        get: function() {
            return new Jo(this.ja, this.nl, this.Wa);
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "exists", {
        get: function() {
            return null !== this.cl;
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "metadata", {
        get: function() {
            return new $o(this.hl, this.al);
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.isEqual = function(e) {
        if (!(e instanceof t)) throw B("isEqual", "DocumentSnapshot", 1, e);
        return this.nl === e.nl && this.al === e.al && this.ja.isEqual(e.ja) && (null === this.cl ? null === e.cl : this.cl.isEqual(e.cl)) && this.Wa === e.Wa;
    }, t;
}(), ts = /** @class */ function(e) {
    function n() {
        return null !== e && e.apply(this, arguments) || this;
    }
    return t.__extends(n, e), n.prototype.data = function(t) {
        return e.prototype.data.call(this, t);
    }, n;
}(Zo);

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// settings() defaults:
function es(t, e, n, r, i, o, s) {
    var u;
    if (i.V()) {
        if ("array-contains" /* ARRAY_CONTAINS */ === o || "array-contains-any" /* ARRAY_CONTAINS_ANY */ === o) throw new c(a.INVALID_ARGUMENT, "Invalid Query. You can't perform '" + o + "' queries on FieldPath.documentId().");
        if ("in" /* IN */ === o || "not-in" /* NOT_IN */ === o) {
            is(s, o);
            for (var h = [], f = 0, l = s; f < l.length; f++) {
                var p = l[f];
                h.push(rs(r, t, p));
            }
            u = {
                arrayValue: {
                    values: h
                }
            };
        } else u = rs(r, t, s);
    } else "in" /* IN */ !== o && "not-in" /* NOT_IN */ !== o && "array-contains-any" /* ARRAY_CONTAINS_ANY */ !== o || is(s, o), 
    u = Oo(n, e, s, 
    /* allowArrays= */ "in" /* IN */ === o || "not-in" /* NOT_IN */ === o);
    var d = xn.create(i, o, u);
    return function(t, e) {
        if (e.hn()) {
            var n = Dn(t);
            if (null !== n && !n.isEqual(e.field)) throw new c(a.INVALID_ARGUMENT, "Invalid query. All where filters with an inequality (<, <=, >, or >=) must be on the same field. But you have inequality filters on '" + n.toString() + "' and '" + e.field.toString() + "'");
            var r = Tn(t);
            null !== r && os(t, e.field, r);
        }
        var i = function(t, e) {
            for (var n = 0, r = t.filters; n < r.length; n++) {
                var i = r[n];
                if (e.indexOf(i.op) >= 0) return i.op;
            }
            return null;
        }(t, 
        /**
 * Given an operator, returns the set of operators that cannot be used with it.
 *
 * Operators in a query must adhere to the following set of rules:
 * 1. Only one array operator is allowed.
 * 2. Only one disjunctive operator is allowed.
 * 3. NOT_EQUAL cannot be used with another NOT_EQUAL operator.
 * 4. NOT_IN cannot be used with array, disjunctive, or NOT_EQUAL operators.
 *
 * Array operators: ARRAY_CONTAINS, ARRAY_CONTAINS_ANY
 * Disjunctive operators: IN, ARRAY_CONTAINS_ANY, NOT_IN
 */
        function(t) {
            switch (t) {
              case "!=" /* NOT_EQUAL */ :
                return [ "!=" /* NOT_EQUAL */ , "not-in" /* NOT_IN */ ];

              case "array-contains" /* ARRAY_CONTAINS */ :
                return [ "array-contains" /* ARRAY_CONTAINS */ , "array-contains-any" /* ARRAY_CONTAINS_ANY */ , "not-in" /* NOT_IN */ ];

              case "in" /* IN */ :
                return [ "array-contains-any" /* ARRAY_CONTAINS_ANY */ , "in" /* IN */ , "not-in" /* NOT_IN */ ];

              case "array-contains-any" /* ARRAY_CONTAINS_ANY */ :
                return [ "array-contains" /* ARRAY_CONTAINS */ , "array-contains-any" /* ARRAY_CONTAINS_ANY */ , "in" /* IN */ , "not-in" /* NOT_IN */ ];

              case "not-in" /* NOT_IN */ :
                return [ "array-contains" /* ARRAY_CONTAINS */ , "array-contains-any" /* ARRAY_CONTAINS_ANY */ , "in" /* IN */ , "not-in" /* NOT_IN */ , "!=" /* NOT_EQUAL */ ];

              default:
                return [];
            }
        }(e.op));
        if (null !== i) 
        // Special case when it's a duplicate op to give a slightly clearer error message.
        throw i === e.op ? new c(a.INVALID_ARGUMENT, "Invalid query. You cannot use more than one '" + e.op.toString() + "' filter.") : new c(a.INVALID_ARGUMENT, "Invalid query. You cannot use '" + e.op.toString() + "' filters with '" + i.toString() + "' filters.");
    }(t, d), d;
}

function ns(t, e, n) {
    if (null !== t.startAt) throw new c(a.INVALID_ARGUMENT, "Invalid query. You must not call startAt() or startAfter() before calling orderBy().");
    if (null !== t.endAt) throw new c(a.INVALID_ARGUMENT, "Invalid query. You must not call endAt() or endBefore() before calling orderBy().");
    var r = new $n(e, n);
    return function(t, e) {
        if (null === Tn(t)) {
            // This is the first order by. It must match any inequality.
            var n = Dn(t);
            null !== n && os(t, n, e.field);
        }
    }(t, r), r
    /**
 * Create a Bound from a query and a document.
 *
 * Note that the Bound will always include the key of the document
 * and so only the provided document will compare equal to the returned
 * position.
 *
 * Will throw if the document does not contain all fields of the order by
 * of the query or if any of the fields in the order by are an uncommitted
 * server timestamp.
 */
    /**
 * Parses the given documentIdValue into a ReferenceValue, throwing
 * appropriate errors if the value is anything other than a DocumentReference
 * or String, or if the string is malformed.
 */;
}

function rs(t, e, n) {
    if ("string" == typeof n) {
        if ("" === n) throw new c(a.INVALID_ARGUMENT, "Invalid query. When querying with FieldPath.documentId(), you must provide a valid document ID, but it was an empty string.");
        if (!Vn(e) && -1 !== n.indexOf("/")) throw new c(a.INVALID_ARGUMENT, "Invalid query. When querying a collection by FieldPath.documentId(), you must provide a plain document ID, but '" + n + "' contains a '/' character.");
        var r = e.path.child(I.P(n));
        if (!T.N(r)) throw new c(a.INVALID_ARGUMENT, "Invalid query. When querying a collection group by FieldPath.documentId(), the value provided must result in a valid document path, but '" + r + "' is not because it has an odd number of segments (" + r.length + ").");
        return se(t, new T(r));
    }
    if (n instanceof Io) return se(t, n.ja);
    throw new c(a.INVALID_ARGUMENT, "Invalid query. When querying with FieldPath.documentId(), you must provide a valid string or a DocumentReference, but it was: " + x(n) + ".");
}

/**
 * Validates that the value passed into a disjunctive filter satisfies all
 * array requirements.
 */ function is(t, e) {
    if (!Array.isArray(t) || 0 === t.length) throw new c(a.INVALID_ARGUMENT, "Invalid Query. A non-empty array is required for '" + e.toString() + "' filters.");
    if (t.length > 10) throw new c(a.INVALID_ARGUMENT, "Invalid Query. '" + e.toString() + "' filters support a maximum of 10 elements in the value array.");
    if ("in" /* IN */ === e || "array-contains-any" /* ARRAY_CONTAINS_ANY */ === e) {
        if (t.indexOf(null) >= 0) throw new c(a.INVALID_ARGUMENT, "Invalid Query. '" + e.toString() + "' filters cannot contain 'null' in the value array.");
        if (t.filter((function(t) {
            return Number.isNaN(t);
        })).length > 0) throw new c(a.INVALID_ARGUMENT, "Invalid Query. '" + e.toString() + "' filters cannot contain 'NaN' in the value array.");
    }
}

function os(t, e, n) {
    if (!n.isEqual(e)) throw new c(a.INVALID_ARGUMENT, "Invalid query. You have a where filter with an inequality (<, <=, >, or >=) on field '" + e.toString() + "' and so you must also use '" + e.toString() + "' as your first orderBy(), but your first orderBy() is on field '" + n.toString() + "' instead.");
}

function ss(t) {
    if (Nn(t) && 0 === t.on.length) throw new c(a.UNIMPLEMENTED, "limitToLast() queries require specifying at least one orderBy() clause");
}

var us = /** @class */ function() {
    function e(t, e, n) {
        this.ll = t, this.firestore = e, this.Wa = n;
    }
    return e.prototype.where = function(t, n, r) {
        V("Query.where", arguments, 3), q("Query.where", 3, r);
        // Enumerated from the WhereFilterOp type in index.d.ts.
        var i = P("Query.where", [ "<" /* LESS_THAN */ , "<=" /* LESS_THAN_OR_EQUAL */ , "==" /* EQUAL */ , "!=" /* NOT_EQUAL */ , ">=" /* GREATER_THAN_OR_EQUAL */ , ">" /* GREATER_THAN */ , "array-contains" /* ARRAY_CONTAINS */ , "in" /* IN */ , "array-contains-any" /* ARRAY_CONTAINS_ANY */ , "not-in" /* NOT_IN */ ], 2, n), o = Co("Query.where", t), s = es(this.ll, "Query.where", this.firestore.zh, this.firestore.Qa, o, i, r);
        return new e(function(t, e) {
            var n = t.filters.concat([ e ]);
            return new _n(t.path, t.collectionGroup, t.on.slice(), n, t.limit, t.un, t.startAt, t.endAt);
        }(this.ll, s), this.firestore, this.Wa);
    }, e.prototype.orderBy = function(t, n) {
        var r;
        if (L("Query.orderBy", arguments, 1, 2), O("Query.orderBy", "non-empty string", 2, n), 
        void 0 === n || "asc" === n) r = "asc" /* ASCENDING */; else {
            if ("desc" !== n) throw new c(a.INVALID_ARGUMENT, "Function Query.orderBy() has unknown direction '" + n + "', expected 'asc' or 'desc'.");
            r = "desc" /* DESCENDING */;
        }
        var i = Co("Query.orderBy", t), o = ns(this.ll, i, r);
        return new e(function(t, e) {
            // TODO(dimond): validate that orderBy does not list the same key twice.
            var n = t.on.concat([ e ]);
            return new _n(t.path, t.collectionGroup, n, t.filters.slice(), t.limit, t.un, t.startAt, t.endAt);
        }(this.ll, o), this.firestore, this.Wa);
    }, e.prototype.limit = function(t) {
        return V("Query.limit", arguments, 1), U("Query.limit", "number", 1, t), G("Query.limit", 1, t), 
        new e(Un(this.ll, t, "F" /* First */), this.firestore, this.Wa);
    }, e.prototype.limitToLast = function(t) {
        return V("Query.limitToLast", arguments, 1), U("Query.limitToLast", "number", 1, t), 
        G("Query.limitToLast", 1, t), new e(Un(this.ll, t, "L" /* Last */), this.firestore, this.Wa);
    }, e.prototype.startAt = function(t) {
        for (var n = [], r = 1; r < arguments.length; r++) n[r - 1] = arguments[r];
        R("Query.startAt", arguments, 1);
        var i = this._l("Query.startAt", t, n, 
        /*before=*/ !0);
        return new e(On(this.ll, i), this.firestore, this.Wa);
    }, e.prototype.startAfter = function(t) {
        for (var n = [], r = 1; r < arguments.length; r++) n[r - 1] = arguments[r];
        R("Query.startAfter", arguments, 1);
        var i = this._l("Query.startAfter", t, n, 
        /*before=*/ !1);
        return new e(On(this.ll, i), this.firestore, this.Wa);
    }, e.prototype.endBefore = function(t) {
        for (var n = [], r = 1; r < arguments.length; r++) n[r - 1] = arguments[r];
        R("Query.endBefore", arguments, 1);
        var i = this._l("Query.endBefore", t, n, 
        /*before=*/ !0);
        return new e(Sn(this.ll, i), this.firestore, this.Wa);
    }, e.prototype.endAt = function(t) {
        for (var n = [], r = 1; r < arguments.length; r++) n[r - 1] = arguments[r];
        R("Query.endAt", arguments, 1);
        var i = this._l("Query.endAt", t, n, 
        /*before=*/ !1);
        return new e(Sn(this.ll, i), this.firestore, this.Wa);
    }, e.prototype.isEqual = function(t) {
        if (!(t instanceof e)) throw B("isEqual", "Query", 1, t);
        return this.firestore === t.firestore && kn(this.ll, t.ll) && this.Wa === t.Wa;
    }, e.prototype.withConverter = function(t) {
        return new e(this.ll, this.firestore, t);
    }, 
    /** Helper function to create a bound from a document or fields */ e.prototype._l = function(e, n, r, i) {
        if (q(e, 1, n), n instanceof Zo) return V(e, t.__spreadArrays([ n ], r), 1), function(t, e, n, r, i) {
            if (!r) throw new c(a.NOT_FOUND, "Can't use a DocumentSnapshot that doesn't exist for " + n + "().");
            // Because people expect to continue/end a query at the exact document
            // provided, we need to use the implicit sort order rather than the explicit
            // sort order, because it's guaranteed to contain the document key. That way
            // the position becomes unambiguous and the query continues/ends exactly at
            // the provided document. Without the key (by using the explicit sort
            // orders), multiple documents could match the position, yielding duplicate
            // results.
            for (var o = [], s = 0, u = Rn(t); s < u.length; s++) {
                var h = u[s];
                if (h.field.V()) o.push(se(e, r.key)); else {
                    var f = r.field(h.field);
                    if (Qt(f)) throw new c(a.INVALID_ARGUMENT, 'Invalid query. You are trying to start or end a query using a document for which the field "' + h.field + '" is an uncommitted server timestamp. (Since the value of this field is unknown, you cannot start/end a query with it.)');
                    if (null === f) {
                        var l = h.field.R();
                        throw new c(a.INVALID_ARGUMENT, "Invalid query. You are trying to start or end a query using a document for which the field '" + l + "' (used as the orderBy) does not exist.");
                    }
                    o.push(f);
                }
            }
            return new Xn(o, i);
        }(this.ll, this.firestore.Qa, e, n.cl, i);
        var o = [ n ].concat(r);
        return function(t, e, n, r, i, o) {
            // Use explicit order by's because it has to match the query the user made
            var s = t.on;
            if (i.length > s.length) throw new c(a.INVALID_ARGUMENT, "Too many arguments provided to " + r + "(). The number of arguments must be less than or equal to the number of orderBy() clauses");
            for (var u = [], h = 0; h < i.length; h++) {
                var f = i[h];
                if (s[h].field.V()) {
                    if ("string" != typeof f) throw new c(a.INVALID_ARGUMENT, "Invalid query. Expected a string for document ID in " + r + "(), but got a " + typeof f);
                    if (!Vn(t) && -1 !== f.indexOf("/")) throw new c(a.INVALID_ARGUMENT, "Invalid query. When querying a collection and ordering by FieldPath.documentId(), the value passed to " + r + "() must be a plain document ID, but '" + f + "' contains a slash.");
                    var l = t.path.child(I.P(f));
                    if (!T.N(l)) throw new c(a.INVALID_ARGUMENT, "Invalid query. When querying a collection group and ordering by FieldPath.documentId(), the value passed to " + r + "() must result in a valid document path, but '" + l + "' is not because it contains an odd number of segments.");
                    var p = new T(l);
                    u.push(se(e, p));
                } else {
                    var d = Oo(n, r, f);
                    u.push(d);
                }
            }
            return new Xn(u, o);
        }(this.ll, this.firestore.Qa, this.firestore.zh, e, o, i);
    }, e.prototype.onSnapshot = function() {
        for (var t, e, n, r = this, i = [], o = 0; o < arguments.length; o++) i[o] = arguments[o];
        L("Query.onSnapshot", arguments, 1, 4);
        var s = {}, u = 0;
        if ("object" != typeof i[u] || zo(i[u]) || (F("Query.onSnapshot", s = i[u], [ "includeMetadataChanges" ]), 
        k("Query.onSnapshot", "boolean", "includeMetadataChanges", s.includeMetadataChanges), 
        u++), zo(i[u])) {
            var a = i[u];
            i[u] = null === (t = a.next) || void 0 === t ? void 0 : t.bind(a), i[u + 1] = null === (e = a.error) || void 0 === e ? void 0 : e.bind(a), 
            i[u + 2] = null === (n = a.complete) || void 0 === n ? void 0 : n.bind(a);
        } else U("Query.onSnapshot", "function", u, i[u]), O("Query.onSnapshot", "function", u + 1, i[u + 1]), 
        O("Query.onSnapshot", "function", u + 2, i[u + 2]);
        var c = {
            next: function(t) {
                i[u] && i[u](new as(r.firestore, r.ll, t, r.Wa));
            },
            error: i[u + 1],
            complete: i[u + 2]
        };
        return ss(this.ll), this.firestore.Uh().listen(this.ll, s, c);
    }, e.prototype.get = function(t) {
        var e = this;
        L("Query.get", arguments, 0, 1), ls("Query.get", t), ss(this.ll);
        var n = this.firestore.Uh();
        return (t && "cache" === t.source ? n.yh(this.ll) : n.Ph(this.ll, t)).then((function(t) {
            return new as(e.firestore, e.ll, t, e.Wa);
        }));
    }, e;
}(), as = /** @class */ function() {
    function t(t, e, n, r) {
        this.nl = t, this.fl = e, this.dl = n, this.Wa = r, this.wl = null, this.ml = null, 
        this.metadata = new $o(n.hasPendingWrites, n.fromCache);
    }
    return Object.defineProperty(t.prototype, "docs", {
        get: function() {
            var t = [];
            return this.forEach((function(e) {
                return t.push(e);
            })), t;
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "empty", {
        get: function() {
            return this.dl.docs.m();
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "size", {
        get: function() {
            return this.dl.docs.size;
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.forEach = function(t, e) {
        var n = this;
        L("QuerySnapshot.forEach", arguments, 1, 2), U("QuerySnapshot.forEach", "function", 1, t), 
        this.dl.docs.forEach((function(r) {
            t.call(e, n.Tl(r, n.metadata.fromCache, n.dl.jt.has(r.key)));
        }));
    }, Object.defineProperty(t.prototype, "query", {
        get: function() {
            return new us(this.fl, this.nl, this.Wa);
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.docChanges = function(t) {
        t && (F("QuerySnapshot.docChanges", t, [ "includeMetadataChanges" ]), k("QuerySnapshot.docChanges", "boolean", "includeMetadataChanges", t.includeMetadataChanges));
        var e = !(!t || !t.includeMetadataChanges);
        if (e && this.dl.Gt) throw new c(a.INVALID_ARGUMENT, "To include metadata changes with your document changes, you must also pass { includeMetadataChanges:true } to onSnapshot().");
        return this.wl && this.ml === e || (this.wl = 
        /**
     * Calculates the array of DocumentChanges for a given ViewSnapshot.
     *
     * Exported for testing.
     *
     * @param snapshot The ViewSnapshot that represents the expected state.
     * @param includeMetadataChanges Whether to include metadata changes.
     * @param converter A factory function that returns a QueryDocumentSnapshot.
     * @return An object that matches the DocumentChange API.
     */
        function(t, e, n) {
            if (t.Qt.m()) {
                // Special case the first snapshot because index calculation is easy and
                // fast
                var r = 0;
                return t.docChanges.map((function(e) {
                    var i = n(e.doc, t.fromCache, t.jt.has(e.doc.key));
                    return e.doc, {
                        type: "added",
                        doc: i,
                        oldIndex: -1,
                        newIndex: r++
                    };
                }));
            }
            // A DocumentSet that is updated incrementally as changes are applied to use
            // to lookup the index of a document.
            var i = t.Qt;
            return t.docChanges.filter((function(t) {
                return e || 3 /* Metadata */ !== t.type;
            })).map((function(e) {
                var r = n(e.doc, t.fromCache, t.jt.has(e.doc.key)), o = -1, s = -1;
                return 0 /* Added */ !== e.type && (o = i.indexOf(e.doc.key), i = i.delete(e.doc.key)), 
                1 /* Removed */ !== e.type && (s = (i = i.add(e.doc)).indexOf(e.doc.key)), {
                    type: ds(e.type),
                    doc: r,
                    oldIndex: o,
                    newIndex: s
                };
            }));
        }(this.dl, e, this.Tl.bind(this)), this.ml = e), this.wl;
    }, 
    /** Check the equality. The call can be very expensive. */ t.prototype.isEqual = function(e) {
        if (!(e instanceof t)) throw B("isEqual", "QuerySnapshot", 1, e);
        return this.nl === e.nl && kn(this.fl, e.fl) && this.dl.isEqual(e.dl) && this.Wa === e.Wa;
    }, t.prototype.Tl = function(t, e, n) {
        return new ts(this.nl, t.key, t, e, n, this.Wa);
    }, t;
}(), cs = /** @class */ function(e) {
    function n(t, n, r) {
        var i = this;
        if ((i = e.call(this, In(t), n, r) || this).El = t, t.length % 2 != 1) throw new c(a.INVALID_ARGUMENT, "Invalid collection reference. Collection references must have an odd number of segments, but " + t.R() + " has " + t.length);
        return i;
    }
    return t.__extends(n, e), Object.defineProperty(n.prototype, "id", {
        get: function() {
            return this.ll.path._();
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(n.prototype, "parent", {
        get: function() {
            var t = this.ll.path.h();
            return t.m() ? null : new Jo(new T(t), this.firestore, 
            /* converter= */ null);
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(n.prototype, "path", {
        get: function() {
            return this.ll.path.R();
        },
        enumerable: !1,
        configurable: !0
    }), n.prototype.doc = function(t) {
        L("CollectionReference.doc", arguments, 0, 1), 
        // We allow omission of 'pathString' but explicitly prohibit passing in both
        // 'undefined' and 'null'.
        0 === arguments.length && (t = K.k()), U("CollectionReference.doc", "non-empty string", 1, t);
        var e = I.P(t);
        return Jo.Zh(this.ll.path.child(e), this.firestore, this.Wa);
    }, n.prototype.add = function(t) {
        V("CollectionReference.add", arguments, 1);
        var e = this.Wa ? this.Wa.toFirestore(t) : t;
        U("CollectionReference.add", "object", 1, e);
        var n = this.doc();
        // Call set() with the converted value directly to avoid calling toFirestore() a second time.
                return new Jo(n.ja, this.firestore, null).set(e).then((function() {
            return n;
        }));
    }, n.prototype.withConverter = function(t) {
        return new n(this.El, this.firestore, t);
    }, n;
}(us);

function hs(t, e) {
    if (void 0 === e) return {
        merge: !1
    };
    if (F(t, e, [ "merge", "mergeFields" ]), k(t, "boolean", "merge", e.merge), function(t, e, n, r, i) {
        void 0 !== r && function(t, e, n, r, i) {
            if (!(r instanceof Array)) throw new c(a.INVALID_ARGUMENT, "Function " + t + "() requires its " + e + " option to be an array, but it was: " + x(r));
            for (var o = 0; o < r.length; ++o) if (!i(r[o])) throw new c(a.INVALID_ARGUMENT, "Function " + t + "() requires all " + e + " elements to be " + n + ", but the value at index " + o + " was: " + x(r[o]));
        }(t, e, n, r, i);
    }(t, "mergeFields", "a string or a FieldPath", e.mergeFields, (function(t) {
        return "string" == typeof t || t instanceof ho;
    })), void 0 !== e.mergeFields && void 0 !== e.merge) throw new c(a.INVALID_ARGUMENT, "Invalid options passed to function " + t + '(): You cannot specify both "merge" and "mergeFields".');
    return e;
}

function fs(t, e) {
    return void 0 === e ? {} : (F(t, e, [ "serverTimestamps" ]), j(t, 0, "serverTimestamps", e.serverTimestamps, [ "estimate", "previous", "none" ]), 
    e);
}

function ls(t, e) {
    O(t, "object", 1, e), e && (F(t, e, [ "source" ]), j(t, 0, "source", e.source, [ "default", "server", "cache" ]));
}

function ps(t, e, n) {
    if (e instanceof Io) {
        if (e.firestore !== n) throw new c(a.INVALID_ARGUMENT, "Provided document reference is from a different Firestore instance.");
        return e;
    }
    throw B(t, "DocumentReference", 1, e);
}

function ds(t) {
    switch (t) {
      case 0 /* Added */ :
        return "added";

      case 2 /* Modified */ :
      case 3 /* Metadata */ :
        return "modified";

      case 1 /* Removed */ :
        return "removed";

      default:
        return y();
    }
}

/**
 * Converts custom model object of type T into DocumentData by applying the
 * converter if it exists.
 *
 * This function is used when converting user objects to DocumentData
 * because we want to provide the user with a more specific error message if
 * their set() or fails due to invalid data originating from a toFirestore()
 * call.
 */ function vs(t, e, n) {
    // Cast to `any` in order to satisfy the union type constraint on
    // toFirestore().
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    return t ? n && (n.merge || n.mergeFields) ? t.toFirestore(e, n) : t.toFirestore(e) : e;
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ var ys = /** @class */ function(e) {
    function n() {
        return null !== e && e.apply(this, arguments) || this;
    }
    return t.__extends(n, e), n.serverTimestamp = function() {
        D("FieldValue.serverTimestamp", arguments);
        var t = new yo("serverTimestamp");
        return t.Fa = "FieldValue.serverTimestamp", new n(t);
    }, n.delete = function() {
        D("FieldValue.delete", arguments);
        var t = new po("deleteField");
        return t.Fa = "FieldValue.delete", new n(t);
    }, n.arrayUnion = function() {
        for (var t = [], e = 0; e < arguments.length; e++) t[e] = arguments[e];
        R("FieldValue.arrayUnion", arguments, 1);
        var r = 
        /**
 * Returns a special value that can be used with {@link setDoc()} or {@link
 * updateDoc()} that tells the server to union the given elements with any array
 * value that already exists on the server. Each specified element that doesn't
 * already exist in the array will be added to the end. If the field being
 * modified is not already an array it will be overwritten with an array
 * containing exactly the specified elements.
 *
 * @param elements The elements to union into the array.
 * @return The `FieldValue` sentinel for use in a call to `setDoc()` or
 * `updateDoc()`.
 */
        function() {
            for (var t = [], e = 0; e < arguments.length; e++) t[e] = arguments[e];
            // NOTE: We don't actually parse the data until it's used in set() or
            // update() since we'd need the Firestore instance to do this.
                        return R("arrayUnion()", arguments, 1), new go("arrayUnion", t);
        }.apply(void 0, t);
        return r.Fa = "FieldValue.arrayUnion", new n(r);
    }, n.arrayRemove = function() {
        for (var t = [], e = 0; e < arguments.length; e++) t[e] = arguments[e];
        R("FieldValue.arrayRemove", arguments, 1);
        var r = function() {
            for (var t = [], e = 0; e < arguments.length; e++) t[e] = arguments[e];
            // NOTE: We don't actually parse the data until it's used in set() or
            // update() since we'd need the Firestore instance to do this.
                        return R("arrayRemove()", arguments, 1), new mo("arrayRemove", t);
        }.apply(void 0, t);
        return r.Fa = "FieldValue.arrayRemove", new n(r);
    }, n.increment = function(t) {
        U("FieldValue.increment", "number", 1, t), V("FieldValue.increment", arguments, 1);
        var e = function(t) {
            return new wo("increment", t);
        }(t);
        return e.Fa = "FieldValue.increment", new n(e);
    }, n.prototype.isEqual = function(t) {
        return this.Ba.isEqual(t.Ba);
    }, n;
}(Eo), gs = {
    Firestore: Xo,
    GeoPoint: bo,
    Timestamp: it,
    Blob: tt,
    Transaction: Ho,
    WriteBatch: Yo,
    DocumentReference: Jo,
    DocumentSnapshot: Zo,
    Query: us,
    QueryDocumentSnapshot: ts,
    QuerySnapshot: as,
    CollectionReference: cs,
    FieldPath: ho,
    FieldValue: ys,
    setLogLevel: Xo.setLogLevel,
    CACHE_SIZE_UNLIMITED: Qo
};

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Configures Firestore as part of the Firebase SDK by calling registerService.
 *
 * @param firebase The FirebaseNamespace to register Firestore with
 * @param firestoreFactory A factory function that returns a new Firestore
 *    instance.
 */
/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Registers the memory-only Firestore build with the components framework.
 */
function ms(t) {
    !function(t, e) {
        t.INTERNAL.registerComponent(new o.Component("firestore", (function(t) {
            return function(t, e) {
                return new Xo(t, e, new so, new uo);
            }(t.getProvider("app").getImmediate(), t.getProvider("auth-internal"));
        }), "PUBLIC" /* PUBLIC */).setServiceProps(Object.assign({}, gs)));
    }(t), t.registerVersion("@firebase/firestore", "1.18.0");
}

ms(u.default), exports.__PRIVATE_registerFirestore = ms;
//# sourceMappingURL=index.memory.cjs.js.map
;