import t from "@firebase/app";

import { Logger as e, LogLevel as n } from "@firebase/logger";

import { getUA as s, isMobileCordova as i, isReactNative as r, isElectron as o, isIE as a, isUWP as c, isBrowserExtension as u } from "@firebase/util";

import { XhrIo as h, EventType as l, ErrorCode as _, createWebChannelTransport as f, WebChannel as d } from "@firebase/webchannel-wrapper";

import { Component as w } from "@firebase/component";

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** Converts a Base64 encoded string to a binary string. */
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const m = {
    // Causes are copied from:
    // https://github.com/grpc/grpc/blob/bceec94ea4fc5f0085d81235d8e1c06798dc341a/include/grpc%2B%2B/impl/codegen/status_code_enum.h
    /** Not an error; returned on success. */
    OK: "ok",
    /** The operation was cancelled (typically by the caller). */
    CANCELLED: "cancelled",
    /** Unknown error or an error from a different error domain. */
    UNKNOWN: "unknown",
    /**
     * Client specified an invalid argument. Note that this differs from
     * FAILED_PRECONDITION. INVALID_ARGUMENT indicates arguments that are
     * problematic regardless of the state of the system (e.g., a malformed file
     * name).
     */
    INVALID_ARGUMENT: "invalid-argument",
    /**
     * Deadline expired before operation could complete. For operations that
     * change the state of the system, this error may be returned even if the
     * operation has completed successfully. For example, a successful response
     * from a server could have been delayed long enough for the deadline to
     * expire.
     */
    DEADLINE_EXCEEDED: "deadline-exceeded",
    /** Some requested entity (e.g., file or directory) was not found. */
    NOT_FOUND: "not-found",
    /**
     * Some entity that we attempted to create (e.g., file or directory) already
     * exists.
     */
    ALREADY_EXISTS: "already-exists",
    /**
     * The caller does not have permission to execute the specified operation.
     * PERMISSION_DENIED must not be used for rejections caused by exhausting
     * some resource (use RESOURCE_EXHAUSTED instead for those errors).
     * PERMISSION_DENIED must not be used if the caller can not be identified
     * (use UNAUTHENTICATED instead for those errors).
     */
    PERMISSION_DENIED: "permission-denied",
    /**
     * The request does not have valid authentication credentials for the
     * operation.
     */
    UNAUTHENTICATED: "unauthenticated",
    /**
     * Some resource has been exhausted, perhaps a per-user quota, or perhaps the
     * entire file system is out of space.
     */
    RESOURCE_EXHAUSTED: "resource-exhausted",
    /**
     * Operation was rejected because the system is not in a state required for
     * the operation's execution. For example, directory to be deleted may be
     * non-empty, an rmdir operation is applied to a non-directory, etc.
     *
     * A litmus test that may help a service implementor in deciding
     * between FAILED_PRECONDITION, ABORTED, and UNAVAILABLE:
     *  (a) Use UNAVAILABLE if the client can retry just the failing call.
     *  (b) Use ABORTED if the client should retry at a higher-level
     *      (e.g., restarting a read-modify-write sequence).
     *  (c) Use FAILED_PRECONDITION if the client should not retry until
     *      the system state has been explicitly fixed. E.g., if an "rmdir"
     *      fails because the directory is non-empty, FAILED_PRECONDITION
     *      should be returned since the client should not retry unless
     *      they have first fixed up the directory by deleting files from it.
     *  (d) Use FAILED_PRECONDITION if the client performs conditional
     *      REST Get/Update/Delete on a resource and the resource on the
     *      server does not match the condition. E.g., conflicting
     *      read-modify-write on the same resource.
     */
    FAILED_PRECONDITION: "failed-precondition",
    /**
     * The operation was aborted, typically due to a concurrency issue like
     * sequencer check failures, transaction aborts, etc.
     *
     * See litmus test above for deciding between FAILED_PRECONDITION, ABORTED,
     * and UNAVAILABLE.
     */
    ABORTED: "aborted",
    /**
     * Operation was attempted past the valid range. E.g., seeking or reading
     * past end of file.
     *
     * Unlike INVALID_ARGUMENT, this error indicates a problem that may be fixed
     * if the system state changes. For example, a 32-bit file system will
     * generate INVALID_ARGUMENT if asked to read at an offset that is not in the
     * range [0,2^32-1], but it will generate OUT_OF_RANGE if asked to read from
     * an offset past the current file size.
     *
     * There is a fair bit of overlap between FAILED_PRECONDITION and
     * OUT_OF_RANGE. We recommend using OUT_OF_RANGE (the more specific error)
     * when it applies so that callers who are iterating through a space can
     * easily look for an OUT_OF_RANGE error to detect when they are done.
     */
    OUT_OF_RANGE: "out-of-range",
    /** Operation is not implemented or not supported/enabled in this service. */
    UNIMPLEMENTED: "unimplemented",
    /**
     * Internal errors. Means some invariants expected by underlying System has
     * been broken. If you see one of these errors, Something is very broken.
     */
    INTERNAL: "internal",
    /**
     * The service is currently unavailable. This is a most likely a transient
     * condition and may be corrected by retrying with a backoff.
     *
     * See litmus test above for deciding between FAILED_PRECONDITION, ABORTED,
     * and UNAVAILABLE.
     */
    UNAVAILABLE: "unavailable",
    /** Unrecoverable data loss or corruption. */
    DATA_LOSS: "data-loss"
};

/** An error returned by a Firestore operation. */ class T extends Error {
    constructor(t, e) {
        super(e), this.code = t, this.message = e, this.name = "FirebaseError", 
        // HACK: We write a toString property directly because Error is not a real
        // class and so inheritance does not work correctly. We could alternatively
        // do the same "back-door inheritance" trick that FirebaseError does.
        this.toString = () => `${this.name}: [code=${this.code}]: ${this.message}`;
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const E = new e("@firebase/firestore");

// Helper methods are needed because variables can't be exported as read/write
function I() {
    return E.logLevel;
}

/**
 * Sets the verbosity of Cloud Firestore logs (debug, error, or silent).
 *
 * @param logLevel
 *   The verbosity you set for activity and error logging. Can be any of
 *   the following values:
 *
 *   <ul>
 *     <li>`debug` for the most verbose logging level, primarily for
 *     debugging.</li>
 *     <li>`error` to log errors only.</li>
 *     <li><code>`silent` to turn off logging.</li>
 *   </ul>
 */ function A(t, ...e) {
    if (E.logLevel <= n.DEBUG) {
        const n = e.map(P);
        E.debug("Firestore (7.24.0): " + t, ...n);
    }
}

function R(t, ...e) {
    if (E.logLevel <= n.ERROR) {
        const n = e.map(P);
        E.error("Firestore (7.24.0): " + t, ...n);
    }
}

function g(t, ...e) {
    if (E.logLevel <= n.WARN) {
        const n = e.map(P);
        E.warn("Firestore (7.24.0): " + t, ...n);
    }
}

/**
 * Converts an additional log parameter to a string representation.
 */ function P(t) {
    if ("string" == typeof t) return t;
    try {
        return e = t, JSON.stringify(e);
    } catch (e) {
        // Converting to JSON failed, just log the object directly
        return t;
    }
    /**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
    /** Formats an object as a JSON string, suitable for logging. */
    var e;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Unconditionally fails, throwing an Error with the given message.
 * Messages are stripped in production builds.
 *
 * Returns `never` and can be used in expressions:
 * @example
 * let futureVar = fail('not implemented yet');
 */ function y(t = "Unexpected state") {
    // Log the failure in addition to throw an exception, just in case the
    // exception is swallowed.
    const e = "FIRESTORE (7.24.0) INTERNAL ASSERTION FAILED: " + t;
    // NOTE: We don't use FirestoreError here because these are internal failures
    // that cannot be handled by the user. (Also it would create a circular
    // dependency between the error and assert modules which doesn't work.)
    throw R(e), new Error(e);
}

/**
 * Fails if the given assertion condition is false, throwing an Error with the
 * given message if it did.
 *
 * Messages are stripped in production builds.
 */ function V(t, e) {
    t || y();
}

/**
 * Casts `obj` to `T`. In non-production builds, verifies that `obj` is an
 * instance of `T` before casting.
 */ function p(t, 
// eslint-disable-next-line @typescript-eslint/no-explicit-any
e) {
    return t;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ function b(t) {
    let e = 0;
    for (const n in t) Object.prototype.hasOwnProperty.call(t, n) && e++;
    return e;
}

function v(t, e) {
    for (const n in t) Object.prototype.hasOwnProperty.call(t, n) && e(n, t[n]);
}

function S(t) {
    for (const e in t) if (Object.prototype.hasOwnProperty.call(t, e)) return !1;
    return !0;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Path represents an ordered sequence of string segments.
 */
class D {
    constructor(t, e, n) {
        void 0 === e ? e = 0 : e > t.length && y(), void 0 === n ? n = t.length - e : n > t.length - e && y(), 
        this.segments = t, this.offset = e, this.t = n;
    }
    get length() {
        return this.t;
    }
    isEqual(t) {
        return 0 === D.i(this, t);
    }
    child(t) {
        const e = this.segments.slice(this.offset, this.limit());
        return t instanceof D ? t.forEach((t => {
            e.push(t);
        })) : e.push(t), this.o(e);
    }
    /** The index of one past the last segment of the path. */    limit() {
        return this.offset + this.length;
    }
    u(t) {
        return t = void 0 === t ? 1 : t, this.o(this.segments, this.offset + t, this.length - t);
    }
    h() {
        return this.o(this.segments, this.offset, this.length - 1);
    }
    l() {
        return this.segments[this.offset];
    }
    _() {
        return this.get(this.length - 1);
    }
    get(t) {
        return this.segments[this.offset + t];
    }
    m() {
        return 0 === this.length;
    }
    T(t) {
        if (t.length < this.length) return !1;
        for (let e = 0; e < this.length; e++) if (this.get(e) !== t.get(e)) return !1;
        return !0;
    }
    I(t) {
        if (this.length + 1 !== t.length) return !1;
        for (let e = 0; e < this.length; e++) if (this.get(e) !== t.get(e)) return !1;
        return !0;
    }
    forEach(t) {
        for (let e = this.offset, n = this.limit(); e < n; e++) t(this.segments[e]);
    }
    A() {
        return this.segments.slice(this.offset, this.limit());
    }
    static i(t, e) {
        const n = Math.min(t.length, e.length);
        for (let s = 0; s < n; s++) {
            const n = t.get(s), i = e.get(s);
            if (n < i) return -1;
            if (n > i) return 1;
        }
        return t.length < e.length ? -1 : t.length > e.length ? 1 : 0;
    }
}

/**
 * A slash-separated path for navigating resources (documents and collections)
 * within Firestore.
 */ class C extends D {
    o(t, e, n) {
        return new C(t, e, n);
    }
    R() {
        // NOTE: The client is ignorant of any path segments containing escape
        // sequences (e.g. __id123__) and just passes them through raw (they exist
        // for legacy reasons and should not be used frequently).
        return this.A().join("/");
    }
    toString() {
        return this.R();
    }
    /**
     * Creates a resource path from the given slash-delimited string. If multiple
     * arguments are provided, all components are combined. Leading and trailing
     * slashes from all components are ignored.
     */    static g(...t) {
        // NOTE: The client is ignorant of any path segments containing escape
        // sequences (e.g. __id123__) and just passes them through raw (they exist
        // for legacy reasons and should not be used frequently).
        const e = [];
        for (const n of t) {
            if (n.indexOf("//") >= 0) throw new T(m.INVALID_ARGUMENT, `Invalid segment (${n}). Paths must not contain // in them.`);
            // Strip leading and traling slashed.
                        e.push(...n.split("/").filter((t => t.length > 0)));
        }
        return new C(e);
    }
    static P() {
        return new C([]);
    }
}

const N = /^[_a-zA-Z][_a-zA-Z0-9]*$/;

/** A dot-separated path for navigating sub-objects within a document. */ class F extends D {
    o(t, e, n) {
        return new F(t, e, n);
    }
    /**
     * Returns true if the string could be used as a segment in a field path
     * without escaping.
     */    static V(t) {
        return N.test(t);
    }
    R() {
        return this.A().map((t => (t = t.replace("\\", "\\\\").replace("`", "\\`"), F.V(t) || (t = "`" + t + "`"), 
        t))).join(".");
    }
    toString() {
        return this.R();
    }
    /**
     * Returns true if this field references the key of a document.
     */    p() {
        return 1 === this.length && "__name__" === this.get(0);
    }
    /**
     * The field designating the key of a document.
     */    static v() {
        return new F([ "__name__" ]);
    }
    /**
     * Parses a field string from the given server-formatted string.
     *
     * - Splitting the empty string is not allowed (for now at least).
     * - Empty segments within the string (e.g. if there are two consecutive
     *   separators) are not allowed.
     *
     * TODO(b/37244157): we should make this more strict. Right now, it allows
     * non-identifier path components, even if they aren't escaped.
     */    static S(t) {
        const e = [];
        let n = "", s = 0;
        const i = () => {
            if (0 === n.length) throw new T(m.INVALID_ARGUMENT, `Invalid field path (${t}). Paths must not be empty, begin with '.', end with '.', or contain '..'`);
            e.push(n), n = "";
        };
        let r = !1;
        for (;s < t.length; ) {
            const e = t[s];
            if ("\\" === e) {
                if (s + 1 === t.length) throw new T(m.INVALID_ARGUMENT, "Path has trailing escape character: " + t);
                const e = t[s + 1];
                if ("\\" !== e && "." !== e && "`" !== e) throw new T(m.INVALID_ARGUMENT, "Path has invalid escape sequence: " + t);
                n += e, s += 2;
            } else "`" === e ? (r = !r, s++) : "." !== e || r ? (n += e, s++) : (i(), s++);
        }
        if (i(), r) throw new T(m.INVALID_ARGUMENT, "Unterminated ` in path: " + t);
        return new F(e);
    }
    static P() {
        return new F([]);
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ class x {
    constructor(t) {
        this.path = t;
    }
    static D(t) {
        return new x(C.g(t));
    }
    static C(t) {
        return new x(C.g(t).u(5));
    }
    /** Returns true if the document is in the specified collectionId. */    N(t) {
        return this.path.length >= 2 && this.path.get(this.path.length - 2) === t;
    }
    isEqual(t) {
        return null !== t && 0 === C.i(this.path, t.path);
    }
    toString() {
        return this.path.toString();
    }
    static i(t, e) {
        return C.i(t.path, e.path);
    }
    static F(t) {
        return t.length % 2 == 0;
    }
    /**
     * Creates and returns a new document key with the given segments.
     *
     * @param segments The segments of the path to the document
     * @return A new instance of DocumentKey
     */    static $(t) {
        return new x(new C(t.slice()));
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Validates that no arguments were passed in the invocation of functionName.
 *
 * Forward the magic "arguments" variable as second parameter on which the
 * parameter validation is performed:
 * validateNoArgs('myFunction', arguments);
 */ function $(t, e) {
    if (0 !== e.length) throw new T(m.INVALID_ARGUMENT, `Function ${t}() does not support arguments, but was called with ` + tt(e.length, "argument") + ".");
}

/**
 * Validates the invocation of functionName has the exact number of arguments.
 *
 * Forward the magic "arguments" variable as second parameter on which the
 * parameter validation is performed:
 * validateExactNumberOfArgs('myFunction', arguments, 2);
 */ function k(t, e, n) {
    if (e.length !== n) throw new T(m.INVALID_ARGUMENT, `Function ${t}() requires ` + tt(n, "argument") + ", but was called with " + tt(e.length, "argument") + ".");
}

/**
 * Validates the invocation of functionName has at least the provided number of
 * arguments (but can have many more).
 *
 * Forward the magic "arguments" variable as second parameter on which the
 * parameter validation is performed:
 * validateAtLeastNumberOfArgs('myFunction', arguments, 2);
 */ function M(t, e, n) {
    if (e.length < n) throw new T(m.INVALID_ARGUMENT, `Function ${t}() requires at least ` + tt(n, "argument") + ", but was called with " + tt(e.length, "argument") + ".");
}

/**
 * Validates the invocation of functionName has number of arguments between
 * the values provided.
 *
 * Forward the magic "arguments" variable as second parameter on which the
 * parameter validation is performed:
 * validateBetweenNumberOfArgs('myFunction', arguments, 2, 3);
 */ function O(t, e, n, s) {
    if (e.length < n || e.length > s) throw new T(m.INVALID_ARGUMENT, `Function ${t}() requires between ${n} and ` + s + " arguments, but was called with " + tt(e.length, "argument") + ".");
}

/**
 * Validates the provided argument is an array and has as least the expected
 * number of elements.
 */
/**
 * Validates the provided positional argument has the native JavaScript type
 * using typeof checks.
 */
function L(t, e, n, s) {
    K(t, e, Z(n) + " argument", s);
}

/**
 * Validates the provided argument has the native JavaScript type using
 * typeof checks or is undefined.
 */ function B(t, e, n, s) {
    void 0 !== s && L(t, e, n, s);
}

/**
 * Validates the provided named option has the native JavaScript type using
 * typeof checks.
 */ function q(t, e, n, s) {
    K(t, e, n + " option", s);
}

/**
 * Validates the provided named option has the native JavaScript type using
 * typeof checks or is undefined.
 */ function U(t, e, n, s) {
    void 0 !== s && q(t, e, n, s);
}

/**
 * Validates that two boolean options are not set at the same time.
 */ function Q(t, e, n, s, i) {
    void 0 !== s && function(t, e, n, s, i) {
        if (!(s instanceof Array)) throw new T(m.INVALID_ARGUMENT, `Function ${t}() requires its ${e} option to be an array, but it was: ` + z(s));
        for (let r = 0; r < s.length; ++r) if (!i(s[r])) throw new T(m.INVALID_ARGUMENT, `Function ${t}() requires all ${e} elements to be ${n}, but the value at index ${r} was: ` + z(s[r]));
    }(t, e, n, s, i);
}

/**
 * Validates that the provided named option equals one of the expected values.
 */
/**
 * Validates that the provided named option equals one of the expected values or
 * is undefined.
 */
function W(t, e, n, s, i) {
    void 0 !== s && function(t, e, n, s, i) {
        const r = [];
        for (const t of i) {
            if (t === s) return;
            r.push(z(t));
        }
        const o = z(s);
        throw new T(m.INVALID_ARGUMENT, `Invalid value ${o} provided to function ${t}() for option "${n}". Acceptable values: ${r.join(", ")}`);
    }(t, 0, n, s, i);
}

/**
 * Validates that the provided argument is a valid enum.
 *
 * @param functionName Function making the validation call.
 * @param enums Array containing all possible values for the enum.
 * @param position Position of the argument in `functionName`.
 * @param argument Argument to validate.
 * @return The value as T if the argument can be converted.
 */ function j(t, e, n, s) {
    if (!e.some((t => t === s))) throw new T(m.INVALID_ARGUMENT, `Invalid value ${z(s)} provided to function ${t}() for its ${Z(n)} argument. Acceptable values: ` + e.join(", "));
    return s;
}

/** Helper to validate the type of a provided input. */ function K(t, e, n, s) {
    let i = !1;
    if (i = "object" === e ? G(s) : "non-empty string" === e ? "string" == typeof s && "" !== s : typeof s === e, 
    !i) {
        const i = z(s);
        throw new T(m.INVALID_ARGUMENT, `Function ${t}() requires its ${n} to be of type ${e}, but it was: ${i}`);
    }
}

/**
 * Returns true if it's a non-null object without a custom prototype
 * (i.e. excludes Array, Date, etc.).
 */ function G(t) {
    return "object" == typeof t && null !== t && (Object.getPrototypeOf(t) === Object.prototype || null === Object.getPrototypeOf(t));
}

/** Returns a string describing the type / value of the provided input. */ function z(t) {
    if (void 0 === t) return "undefined";
    if (null === t) return "null";
    if ("string" == typeof t) return t.length > 20 && (t = t.substring(0, 20) + "..."), 
    JSON.stringify(t);
    if ("number" == typeof t || "boolean" == typeof t) return "" + t;
    if ("object" == typeof t) {
        if (t instanceof Array) return "an array";
        {
            const e = 
            /** Hacky method to try to get the constructor name for an object. */
            function(t) {
                if (t.constructor) {
                    const e = /function\s+([^\s(]+)\s*\(/.exec(t.constructor.toString());
                    if (e && e.length > 1) return e[1];
                }
                return null;
            }
            /** Validates the provided argument is defined. */ (t);
            return e ? `a custom ${e} object` : "an object";
        }
    }
    return "function" == typeof t ? "a function" : y();
}

function H(t, e, n) {
    if (void 0 === n) throw new T(m.INVALID_ARGUMENT, `Function ${t}() requires a valid ${Z(e)} argument, but it was undefined.`);
}

/**
 * Validates the provided positional argument is an object, and its keys and
 * values match the expected keys and types provided in optionTypes.
 */ function Y(t, e, n) {
    v(e, ((e, s) => {
        if (n.indexOf(e) < 0) throw new T(m.INVALID_ARGUMENT, `Unknown option '${e}' passed to function ${t}(). Available options: ` + n.join(", "));
    }));
}

/**
 * Helper method to throw an error that the provided argument did not pass
 * an instanceof check.
 */ function J(t, e, n, s) {
    const i = z(s);
    return new T(m.INVALID_ARGUMENT, `Function ${t}() requires its ${Z(n)} argument to be a ${e}, but it was: ${i}`);
}

function X(t, e, n) {
    if (n <= 0) throw new T(m.INVALID_ARGUMENT, `Function ${t}() requires its ${Z(e)} argument to be a positive number, but it was: ${n}.`);
}

/** Converts a number to its english word representation */ function Z(t) {
    switch (t) {
      case 1:
        return "first";

      case 2:
        return "second";

      case 3:
        return "third";

      default:
        return t + "th";
    }
}

/**
 * Formats the given word as plural conditionally given the preceding number.
 */ function tt(t, e) {
    return `${t} ${e}` + (1 === t ? "" : "s");
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Generates `nBytes` of random bytes.
 *
 * If `nBytes < 0` , an error will be thrown.
 */ function et(t) {
    // Polyfills for IE and WebWorker by using `self` and `msCrypto` when `crypto` is not available.
    const e = 
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    "undefined" != typeof self && (self.crypto || self.msCrypto), n = new Uint8Array(t);
    if (e && "function" == typeof e.getRandomValues) e.getRandomValues(n); else 
    // Falls back to Math.random
    for (let e = 0; e < t; e++) n[e] = Math.floor(256 * Math.random());
    return n;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ class nt {
    static k() {
        // Alphanumeric characters
        const t = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", e = Math.floor(256 / t.length) * t.length;
        // The largest byte value that is a multiple of `char.length`.
                let n = "";
        for (;n.length < 20; ) {
            const s = et(40);
            for (let i = 0; i < s.length; ++i) 
            // Only accept values that are [0, maxMultiple), this ensures they can
            // be evenly mapped to indices of `chars` via a modulo operation.
            n.length < 20 && s[i] < e && (n += t.charAt(s[i] % t.length));
        }
        return n;
    }
}

function st(t, e) {
    return t < e ? -1 : t > e ? 1 : 0;
}

/** Helper to compare arrays using isEqual(). */ function it(t, e, n) {
    return t.length === e.length && t.every(((t, s) => n(t, e[s])));
}

/**
 * Returns the immediate lexicographically-following string. This is useful to
 * construct an inclusive range for indexeddb iterators.
 */ function rt(t) {
    // Return the input string, with an additional NUL byte appended.
    return t + "\0";
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Immutable class that represents a "proto" byte string.
 *
 * Proto byte strings can either be Base64-encoded strings or Uint8Arrays when
 * sent on the wire. This class abstracts away this differentiation by holding
 * the proto byte string in a common class that must be converted into a string
 * before being sent as a proto.
 */ class ot {
    constructor(t) {
        this.M = t;
    }
    static fromBase64String(t) {
        const e = atob(t);
        return new ot(e);
    }
    static fromUint8Array(t) {
        const e = 
        /**
 * Helper function to convert an Uint8array to a binary string.
 */
        function(t) {
            let e = "";
            for (let n = 0; n < t.length; ++n) e += String.fromCharCode(t[n]);
            return e;
        }
        /**
 * Helper function to convert a binary string to an Uint8Array.
 */ (t);
        return new ot(e);
    }
    toBase64() {
        return t = this.M, btoa(t);
        /** Converts a binary string to a Base64 encoded string. */
        var t;
        /** True if and only if the Base64 conversion functions are available. */    }
    toUint8Array() {
        return function(t) {
            const e = new Uint8Array(t.length);
            for (let n = 0; n < t.length; n++) e[n] = t.charCodeAt(n);
            return e;
        }
        /**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
        /**
 * An immutable object representing an array of bytes.
 */ (this.M);
    }
    O() {
        return 2 * this.M.length;
    }
    L(t) {
        return st(this.M, t.M);
    }
    isEqual(t) {
        return this.M === t.M;
    }
}

ot.B = new ot("");

class at {
    constructor(t) {
        this.q = t;
    }
    /**
     * Creates a new `Bytes` object from the given Base64 string, converting it to
     * bytes.
     *
     * @param base64 The Base64 string used to create the `Bytes` object.
     */    static fromBase64String(t) {
        try {
            return new at(ot.fromBase64String(t));
        } catch (t) {
            throw new T(m.INVALID_ARGUMENT, "Failed to construct Bytes from Base64 string: " + t);
        }
    }
    /**
     * Creates a new `Bytes` object from the given Uint8Array.
     *
     * @param array The Uint8Array used to create the `Bytes` object.
     */    static fromUint8Array(t) {
        return new at(ot.fromUint8Array(t));
    }
    /**
     * Returns the underlying bytes as a Base64-encoded string.
     *
     * @return The Base64-encoded string created from the `Bytes` object.
     */    toBase64() {
        return this.q.toBase64();
    }
    /**
     * Returns the underlying bytes in a new `Uint8Array`.
     *
     * @return The Uint8Array created from the `Bytes` object.
     */    toUint8Array() {
        return this.q.toUint8Array();
    }
    /**
     * Returns a string representation of the `Bytes` object.
     *
     * @return A string representation of the `Bytes` object.
     */    toString() {
        return "Bytes(base64: " + this.toBase64() + ")";
    }
    /**
     * Returns true if this `Bytes` object is equal to the provided one.
     *
     * @param other The `Bytes` object to compare against.
     * @return true if this `Bytes` object is equal to the provided one.
     */    isEqual(t) {
        return this.q.isEqual(t.q);
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** Helper function to assert Uint8Array is available at runtime. */ function ct() {
    if ("undefined" == typeof Uint8Array) throw new T(m.UNIMPLEMENTED, "Uint8Arrays are not available in this environment.");
}

/** Helper function to assert Base64 functions are available at runtime. */ function ut() {
    if ("undefined" == typeof atob) throw new T(m.UNIMPLEMENTED, "Blobs are unavailable in Firestore in this environment.");
}

/**
 * Immutable class holding a blob (binary data).
 *
 * This class is directly exposed in the public API. It extends the Bytes class
 * of the firestore-exp API to support `instanceof Bytes` checks during user
 * data conversion.
 *
 * Note that while you can't hide the constructor in JavaScript code, we are
 * using the hack above to make sure no-one outside this module can call it.
 */ class ht extends at {
    static fromBase64String(t) {
        k("Blob.fromBase64String", arguments, 1), L("Blob.fromBase64String", "string", 1, t), 
        ut();
        try {
            return new ht(ot.fromBase64String(t));
        } catch (t) {
            throw new T(m.INVALID_ARGUMENT, "Failed to construct Blob from Base64 string: " + t);
        }
    }
    static fromUint8Array(t) {
        if (k("Blob.fromUint8Array", arguments, 1), ct(), !(t instanceof Uint8Array)) throw J("Blob.fromUint8Array", "Uint8Array", 1, t);
        return new ht(ot.fromUint8Array(t));
    }
    toBase64() {
        return k("Blob.toBase64", arguments, 0), ut(), super.toBase64();
    }
    toUint8Array() {
        return k("Blob.toUint8Array", arguments, 0), ct(), super.toUint8Array();
    }
    toString() {
        return "Blob(base64: " + this.toBase64() + ")";
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ class lt {
    /**
     * Constructs a DatabaseInfo using the provided host, databaseId and
     * persistenceKey.
     *
     * @param databaseId The database to use.
     * @param persistenceKey A unique identifier for this Firestore's local
     * storage (used in conjunction with the databaseId).
     * @param host The Firestore backend host to connect to.
     * @param ssl Whether to use SSL when connecting.
     * @param forceLongPolling Whether to use the forceLongPolling option
     * when using WebChannel as the network transport.
     * @param autoDetectLongPolling Whether to use the detectBufferingProxy
     * option when using WebChannel as the network transport.
     */
    constructor(t, e, n, s, i, r) {
        this.U = t, this.persistenceKey = e, this.host = n, this.ssl = s, this.forceLongPolling = i, 
        this.W = r;
    }
}

/** The default database name for a project. */
/** Represents the database ID a Firestore client is associated with. */
class _t {
    constructor(t, e) {
        this.projectId = t, this.database = e || "(default)";
    }
    get j() {
        return "(default)" === this.database;
    }
    isEqual(t) {
        return t instanceof _t && t.projectId === this.projectId && t.database === this.database;
    }
    L(t) {
        return st(this.projectId, t.projectId) || st(this.database, t.database);
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A map implementation that uses objects as keys. Objects must have an
 * associated equals function and must be immutable. Entries in the map are
 * stored together with the key being produced from the mapKeyFn. This map
 * automatically handles collisions of keys.
 */ class ft {
    constructor(t, e) {
        this.K = t, this.G = e, 
        /**
         * The inner map for a key -> value pair. Due to the possibility of
         * collisions we keep a list of entries that we do a linear search through
         * to find an actual match. Note that collisions should be rare, so we still
         * expect near constant time lookups in practice.
         */
        this.H = {};
    }
    /** Get a value for this key, or undefined if it does not exist. */    get(t) {
        const e = this.K(t), n = this.H[e];
        if (void 0 !== n) for (const [e, s] of n) if (this.G(e, t)) return s;
    }
    has(t) {
        return void 0 !== this.get(t);
    }
    /** Put this key and value in the map. */    set(t, e) {
        const n = this.K(t), s = this.H[n];
        if (void 0 !== s) {
            for (let n = 0; n < s.length; n++) if (this.G(s[n][0], t)) return void (s[n] = [ t, e ]);
            s.push([ t, e ]);
        } else this.H[n] = [ [ t, e ] ];
    }
    /**
     * Remove this key from the map. Returns a boolean if anything was deleted.
     */    delete(t) {
        const e = this.K(t), n = this.H[e];
        if (void 0 === n) return !1;
        for (let s = 0; s < n.length; s++) if (this.G(n[s][0], t)) return 1 === n.length ? delete this.H[e] : n.splice(s, 1), 
        !0;
        return !1;
    }
    forEach(t) {
        v(this.H, ((e, n) => {
            for (const [e, s] of n) t(e, s);
        }));
    }
    m() {
        return S(this.H);
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// The earlist date supported by Firestore timestamps (0001-01-01T00:00:00Z).
/**
 * A `Timestamp` represents a point in time independent of any time zone or
 * calendar, represented as seconds and fractions of seconds at nanosecond
 * resolution in UTC Epoch time.
 *
 * It is encoded using the Proleptic Gregorian Calendar which extends the
 * Gregorian calendar backwards to year one. It is encoded assuming all minutes
 * are 60 seconds long, i.e. leap seconds are "smeared" so that no leap second
 * table is needed for interpretation. Range is from 0001-01-01T00:00:00Z to
 * 9999-12-31T23:59:59.999999999Z.
 *
 * @see https://github.com/google/protobuf/blob/master/src/google/protobuf/timestamp.proto
 */
class dt {
    /**
     * Creates a new timestamp.
     *
     * @param seconds The number of seconds of UTC time since Unix epoch
     *     1970-01-01T00:00:00Z. Must be from 0001-01-01T00:00:00Z to
     *     9999-12-31T23:59:59Z inclusive.
     * @param nanoseconds The non-negative fractions of a second at nanosecond
     *     resolution. Negative second values with fractions must still have
     *     non-negative nanoseconds values that count forward in time. Must be
     *     from 0 to 999,999,999 inclusive.
     */
    constructor(t, e) {
        if (this.seconds = t, this.nanoseconds = e, e < 0) throw new T(m.INVALID_ARGUMENT, "Timestamp nanoseconds out of range: " + e);
        if (e >= 1e9) throw new T(m.INVALID_ARGUMENT, "Timestamp nanoseconds out of range: " + e);
        if (t < -62135596800) throw new T(m.INVALID_ARGUMENT, "Timestamp seconds out of range: " + t);
        // This will break in the year 10,000.
                if (t >= 253402300800) throw new T(m.INVALID_ARGUMENT, "Timestamp seconds out of range: " + t);
    }
    /**
     * Creates a new timestamp with the current date, with millisecond precision.
     *
     * @return a new timestamp representing the current date.
     */    static now() {
        return dt.fromMillis(Date.now());
    }
    /**
     * Creates a new timestamp from the given date.
     *
     * @param date The date to initialize the `Timestamp` from.
     * @return A new `Timestamp` representing the same point in time as the given
     *     date.
     */    static fromDate(t) {
        return dt.fromMillis(t.getTime());
    }
    /**
     * Creates a new timestamp from the given number of milliseconds.
     *
     * @param milliseconds Number of milliseconds since Unix epoch
     *     1970-01-01T00:00:00Z.
     * @return A new `Timestamp` representing the same point in time as the given
     *     number of milliseconds.
     */    static fromMillis(t) {
        const e = Math.floor(t / 1e3);
        return new dt(e, 1e6 * (t - 1e3 * e));
    }
    /**
     * Converts a `Timestamp` to a JavaScript `Date` object. This conversion causes
     * a loss of precision since `Date` objects only support millisecond precision.
     *
     * @return JavaScript `Date` object representing the same point in time as
     *     this `Timestamp`, with millisecond precision.
     */    toDate() {
        return new Date(this.toMillis());
    }
    /**
     * Converts a `Timestamp` to a numeric timestamp (in milliseconds since
     * epoch). This operation causes a loss of precision.
     *
     * @return The point in time corresponding to this timestamp, represented as
     *     the number of milliseconds since Unix epoch 1970-01-01T00:00:00Z.
     */    toMillis() {
        return 1e3 * this.seconds + this.nanoseconds / 1e6;
    }
    Y(t) {
        return this.seconds === t.seconds ? st(this.nanoseconds, t.nanoseconds) : st(this.seconds, t.seconds);
    }
    /**
     * Returns true if this `Timestamp` is equal to the provided one.
     *
     * @param other The `Timestamp` to compare against.
     * @return true if this `Timestamp` is equal to the provided one.
     */    isEqual(t) {
        return t.seconds === this.seconds && t.nanoseconds === this.nanoseconds;
    }
    toString() {
        return "Timestamp(seconds=" + this.seconds + ", nanoseconds=" + this.nanoseconds + ")";
    }
    toJSON() {
        return {
            seconds: this.seconds,
            nanoseconds: this.nanoseconds
        };
    }
    /**
     * Converts this object to a primitive string, which allows Timestamp objects to be compared
     * using the `>`, `<=`, `>=` and `>` operators.
     */    valueOf() {
        // This method returns a string of the form <seconds>.<nanoseconds> where <seconds> is
        // translated to have a non-negative value and both <seconds> and <nanoseconds> are left-padded
        // with zeroes to be a consistent length. Strings with this format then have a lexiographical
        // ordering that matches the expected ordering. The <seconds> translation is done to avoid
        // having a leading negative sign (i.e. a leading '-' character) in its string representation,
        // which would affect its lexiographical ordering.
        const t = this.seconds - -62135596800;
        // Note: Up to 12 decimal digits are required to represent all valid 'seconds' values.
                return String(t).padStart(12, "0") + "." + String(this.nanoseconds).padStart(9, "0");
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A version of a document in Firestore. This corresponds to the version
 * timestamp, such as update_time or read_time.
 */ class wt {
    constructor(t) {
        this.timestamp = t;
    }
    static J(t) {
        return new wt(t);
    }
    static min() {
        return new wt(new dt(0, 0));
    }
    L(t) {
        return this.timestamp.Y(t.timestamp);
    }
    isEqual(t) {
        return this.timestamp.isEqual(t.timestamp);
    }
    /** Returns a number representation of the version for use in spec tests. */    X() {
        // Convert to microseconds.
        return 1e6 * this.timestamp.seconds + this.timestamp.nanoseconds / 1e3;
    }
    toString() {
        return "SnapshotVersion(" + this.timestamp.toString() + ")";
    }
    Z() {
        return this.timestamp;
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Returns whether a variable is either undefined or null.
 */ function mt(t) {
    return null == t;
}

/** Returns whether the value represents -0. */ function Tt(t) {
    // Detect if the value is -0.0. Based on polyfill from
    // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/is
    return 0 === t && 1 / t == -1 / 0;
}

/**
 * Returns whether a value is an integer and in the safe integer range
 * @param value The value to test for being an integer and in the safe range
 */ function Et(t) {
    return "number" == typeof t && Number.isInteger(t) && !Tt(t) && t <= Number.MAX_SAFE_INTEGER && t >= Number.MIN_SAFE_INTEGER;
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Visible for testing
class It {
    constructor(t, e = null, n = [], s = [], i = null, r = null, o = null) {
        this.path = t, this.collectionGroup = e, this.orderBy = n, this.filters = s, this.limit = i, 
        this.startAt = r, this.endAt = o, this.tt = null;
    }
}

/**
 * Initializes a Target with a path and optional additional query constraints.
 * Path must currently be empty if this is a collection group query.
 *
 * NOTE: you should always construct `Target` from `Query.toTarget` instead of
 * using this factory method, because `Query` provides an implicit `orderBy`
 * property.
 */ function At(t, e = null, n = [], s = [], i = null, r = null, o = null) {
    return new It(t, e, n, s, i, r, o);
}

function Rt(t) {
    const e = p(t);
    if (null === e.tt) {
        let t = e.path.R();
        null !== e.collectionGroup && (t += "|cg:" + e.collectionGroup), t += "|f:", t += e.filters.map((t => ds(t))).join(","), 
        t += "|ob:", t += e.orderBy.map((t => {
            return (e = t).field.R() + e.dir;
            var e;
        })).join(","), mt(e.limit) || (t += "|l:", t += e.limit), e.startAt && (t += "|lb:", 
        t += ys(e.startAt)), e.endAt && (t += "|ub:", t += ys(e.endAt)), e.tt = t;
    }
    return e.tt;
}

function gt(t) {
    let e = t.path.R();
    return null !== t.collectionGroup && (e += " collectionGroup=" + t.collectionGroup), 
    t.filters.length > 0 && (e += `, filters: [${t.filters.map((t => {
        return `${(e = t).field.R()} ${e.op} ${fe(e.value)}`;
        /** Returns a debug description for `filter`. */
        var e;
        /** Filter that matches on key fields (i.e. '__name__'). */    })).join(", ")}]`), 
    mt(t.limit) || (e += ", limit: " + t.limit), t.orderBy.length > 0 && (e += `, orderBy: [${t.orderBy.map((t => {
        return `${(e = t).field.R()} (${e.dir})`;
        var e;
    })).join(", ")}]`), t.startAt && (e += ", startAt: " + ys(t.startAt)), t.endAt && (e += ", endAt: " + ys(t.endAt)), 
    `Target(${e})`;
}

function Pt(t, e) {
    if (t.limit !== e.limit) return !1;
    if (t.orderBy.length !== e.orderBy.length) return !1;
    for (let n = 0; n < t.orderBy.length; n++) if (!Ss(t.orderBy[n], e.orderBy[n])) return !1;
    if (t.filters.length !== e.filters.length) return !1;
    for (let i = 0; i < t.filters.length; i++) if (n = t.filters[i], s = e.filters[i], 
    n.op !== s.op || !n.field.isEqual(s.field) || !ue(n.value, s.value)) return !1;
    var n, s;
    return t.collectionGroup === e.collectionGroup && (!!t.path.isEqual(e.path) && (!!ps(t.startAt, e.startAt) && ps(t.endAt, e.endAt)));
}

function yt(t) {
    return x.F(t.path) && null === t.collectionGroup && 0 === t.filters.length;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * An immutable set of metadata that the local store tracks for each target.
 */ class Vt {
    constructor(
    /** The target being listened to. */
    t, 
    /**
     * The target ID to which the target corresponds; Assigned by the
     * LocalStore for user listens and by the SyncEngine for limbo watches.
     */
    e, 
    /** The purpose of the target. */
    n, 
    /**
     * The sequence number of the last transaction during which this target data
     * was modified.
     */
    s, 
    /** The latest snapshot version seen for this target. */
    i = wt.min()
    /**
     * The maximum snapshot version at which the associated view
     * contained no limbo documents.
     */ , r = wt.min()
    /**
     * An opaque, server-assigned token that allows watching a target to be
     * resumed after disconnecting without retransmitting all the data that
     * matches the target. The resume token essentially identifies a point in
     * time from which the server should resume sending results.
     */ , o = ot.B) {
        this.target = t, this.targetId = e, this.et = n, this.sequenceNumber = s, this.nt = i, 
        this.lastLimboFreeSnapshotVersion = r, this.resumeToken = o;
    }
    /** Creates a new target data instance with an updated sequence number. */    st(t) {
        return new Vt(this.target, this.targetId, this.et, t, this.nt, this.lastLimboFreeSnapshotVersion, this.resumeToken);
    }
    /**
     * Creates a new target data instance with an updated resume token and
     * snapshot version.
     */    it(t, e) {
        return new Vt(this.target, this.targetId, this.et, this.sequenceNumber, e, this.lastLimboFreeSnapshotVersion, t);
    }
    /**
     * Creates a new target data instance with an updated last limbo free
     * snapshot version number.
     */    rt(t) {
        return new Vt(this.target, this.targetId, this.et, this.sequenceNumber, this.nt, t, this.resumeToken);
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ class pt {
    // TODO(b/33078163): just use simplest form of existence filter for now
    constructor(t) {
        this.count = t;
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Error Codes describing the different ways GRPC can fail. These are copied
 * directly from GRPC's sources here:
 *
 * https://github.com/grpc/grpc/blob/bceec94ea4fc5f0085d81235d8e1c06798dc341a/include/grpc%2B%2B/impl/codegen/status_code_enum.h
 *
 * Important! The names of these identifiers matter because the string forms
 * are used for reverse lookups from the webchannel stream. Do NOT change the
 * names of these identifiers or change this into a const enum.
 */ var bt, vt;

/**
 * Determines whether an error code represents a permanent error when received
 * in response to a non-write operation.
 *
 * See isPermanentWriteError for classifying write errors.
 */
function St(t) {
    switch (t) {
      case m.OK:
        return y();

      case m.CANCELLED:
      case m.UNKNOWN:
      case m.DEADLINE_EXCEEDED:
      case m.RESOURCE_EXHAUSTED:
      case m.INTERNAL:
      case m.UNAVAILABLE:
 // Unauthenticated means something went wrong with our token and we need
        // to retry with new credentials which will happen automatically.
              case m.UNAUTHENTICATED:
        return !1;

      case m.INVALID_ARGUMENT:
      case m.NOT_FOUND:
      case m.ALREADY_EXISTS:
      case m.PERMISSION_DENIED:
      case m.FAILED_PRECONDITION:
 // Aborted might be retried in some scenarios, but that is dependant on
        // the context and should handled individually by the calling code.
        // See https://cloud.google.com/apis/design/errors.
              case m.ABORTED:
      case m.OUT_OF_RANGE:
      case m.UNIMPLEMENTED:
      case m.DATA_LOSS:
        return !0;

      default:
        return y();
    }
}

/**
 * Determines whether an error code represents a permanent error when received
 * in response to a write operation.
 *
 * Write operations must be handled specially because as of b/119437764, ABORTED
 * errors on the write stream should be retried too (even though ABORTED errors
 * are not generally retryable).
 *
 * Note that during the initial handshake on the write stream an ABORTED error
 * signals that we should discard our stream token (i.e. it is permanent). This
 * means a handshake error should be classified with isPermanentError, above.
 */
/**
 * Maps an error Code from GRPC status code number, like 0, 1, or 14. These
 * are not the same as HTTP status codes.
 *
 * @returns The Code equivalent to the given GRPC status code. Fails if there
 *     is no match.
 */
function Dt(t) {
    if (void 0 === t) 
    // This shouldn't normally happen, but in certain error cases (like trying
    // to send invalid proto messages) we may get an error with no GRPC code.
    return R("GRPC error has no .code"), m.UNKNOWN;
    switch (t) {
      case bt.OK:
        return m.OK;

      case bt.CANCELLED:
        return m.CANCELLED;

      case bt.UNKNOWN:
        return m.UNKNOWN;

      case bt.DEADLINE_EXCEEDED:
        return m.DEADLINE_EXCEEDED;

      case bt.RESOURCE_EXHAUSTED:
        return m.RESOURCE_EXHAUSTED;

      case bt.INTERNAL:
        return m.INTERNAL;

      case bt.UNAVAILABLE:
        return m.UNAVAILABLE;

      case bt.UNAUTHENTICATED:
        return m.UNAUTHENTICATED;

      case bt.INVALID_ARGUMENT:
        return m.INVALID_ARGUMENT;

      case bt.NOT_FOUND:
        return m.NOT_FOUND;

      case bt.ALREADY_EXISTS:
        return m.ALREADY_EXISTS;

      case bt.PERMISSION_DENIED:
        return m.PERMISSION_DENIED;

      case bt.FAILED_PRECONDITION:
        return m.FAILED_PRECONDITION;

      case bt.ABORTED:
        return m.ABORTED;

      case bt.OUT_OF_RANGE:
        return m.OUT_OF_RANGE;

      case bt.UNIMPLEMENTED:
        return m.UNIMPLEMENTED;

      case bt.DATA_LOSS:
        return m.DATA_LOSS;

      default:
        return y();
    }
}

/**
 * Converts an HTTP response's error status to the equivalent error code.
 *
 * @param status An HTTP error response status ("FAILED_PRECONDITION",
 * "UNKNOWN", etc.)
 * @returns The equivalent Code. Non-matching responses are mapped to
 *     Code.UNKNOWN.
 */ (vt = bt || (bt = {}))[vt.OK = 0] = "OK", vt[vt.CANCELLED = 1] = "CANCELLED", 
vt[vt.UNKNOWN = 2] = "UNKNOWN", vt[vt.INVALID_ARGUMENT = 3] = "INVALID_ARGUMENT", 
vt[vt.DEADLINE_EXCEEDED = 4] = "DEADLINE_EXCEEDED", vt[vt.NOT_FOUND = 5] = "NOT_FOUND", 
vt[vt.ALREADY_EXISTS = 6] = "ALREADY_EXISTS", vt[vt.PERMISSION_DENIED = 7] = "PERMISSION_DENIED", 
vt[vt.UNAUTHENTICATED = 16] = "UNAUTHENTICATED", vt[vt.RESOURCE_EXHAUSTED = 8] = "RESOURCE_EXHAUSTED", 
vt[vt.FAILED_PRECONDITION = 9] = "FAILED_PRECONDITION", vt[vt.ABORTED = 10] = "ABORTED", 
vt[vt.OUT_OF_RANGE = 11] = "OUT_OF_RANGE", vt[vt.UNIMPLEMENTED = 12] = "UNIMPLEMENTED", 
vt[vt.INTERNAL = 13] = "INTERNAL", vt[vt.UNAVAILABLE = 14] = "UNAVAILABLE", vt[vt.DATA_LOSS = 15] = "DATA_LOSS";

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// An immutable sorted map implementation, based on a Left-leaning Red-Black
// tree.
class Ct {
    constructor(t, e) {
        this.i = t, this.root = e || Ft.EMPTY;
    }
    // Returns a copy of the map, with the specified key/value added or replaced.
    ot(t, e) {
        return new Ct(this.i, this.root.ot(t, e, this.i).copy(null, null, Ft.at, null, null));
    }
    // Returns a copy of the map, with the specified key removed.
    remove(t) {
        return new Ct(this.i, this.root.remove(t, this.i).copy(null, null, Ft.at, null, null));
    }
    // Returns the value of the node with the given key, or null.
    get(t) {
        let e = this.root;
        for (;!e.m(); ) {
            const n = this.i(t, e.key);
            if (0 === n) return e.value;
            n < 0 ? e = e.left : n > 0 && (e = e.right);
        }
        return null;
    }
    // Returns the index of the element in this sorted map, or -1 if it doesn't
    // exist.
    indexOf(t) {
        // Number of nodes that were pruned when descending right
        let e = 0, n = this.root;
        for (;!n.m(); ) {
            const s = this.i(t, n.key);
            if (0 === s) return e + n.left.size;
            s < 0 ? n = n.left : (
            // Count all nodes left of the node plus the node itself
            e += n.left.size + 1, n = n.right);
        }
        // Node not found
                return -1;
    }
    m() {
        return this.root.m();
    }
    // Returns the total number of nodes in the map.
    get size() {
        return this.root.size;
    }
    // Returns the minimum key in the map.
    ct() {
        return this.root.ct();
    }
    // Returns the maximum key in the map.
    ut() {
        return this.root.ut();
    }
    // Traverses the map in key order and calls the specified action function
    // for each key/value pair. If action returns true, traversal is aborted.
    // Returns the first truthy value returned by action, or the last falsey
    // value returned by action.
    ht(t) {
        return this.root.ht(t);
    }
    forEach(t) {
        this.ht(((e, n) => (t(e, n), !1)));
    }
    toString() {
        const t = [];
        return this.ht(((e, n) => (t.push(`${e}:${n}`), !1))), `{${t.join(", ")}}`;
    }
    // Traverses the map in reverse key order and calls the specified action
    // function for each key/value pair. If action returns true, traversal is
    // aborted.
    // Returns the first truthy value returned by action, or the last falsey
    // value returned by action.
    lt(t) {
        return this.root.lt(t);
    }
    // Returns an iterator over the SortedMap.
    _t() {
        return new Nt(this.root, null, this.i, !1);
    }
    ft(t) {
        return new Nt(this.root, t, this.i, !1);
    }
    dt() {
        return new Nt(this.root, null, this.i, !0);
    }
    wt(t) {
        return new Nt(this.root, t, this.i, !0);
    }
}

 // end SortedMap
// An iterator over an LLRBNode.
class Nt {
    constructor(t, e, n, s) {
        this.Tt = s, this.Et = [];
        let i = 1;
        for (;!t.m(); ) if (i = e ? n(t.key, e) : 1, 
        // flip the comparison if we're going in reverse
        s && (i *= -1), i < 0) 
        // This node is less than our start key. ignore it
        t = this.Tt ? t.left : t.right; else {
            if (0 === i) {
                // This node is exactly equal to our start key. Push it on the stack,
                // but stop iterating;
                this.Et.push(t);
                break;
            }
            // This node is greater than our start key, add it to the stack and move
            // to the next one
            this.Et.push(t), t = this.Tt ? t.right : t.left;
        }
    }
    It() {
        let t = this.Et.pop();
        const e = {
            key: t.key,
            value: t.value
        };
        if (this.Tt) for (t = t.left; !t.m(); ) this.Et.push(t), t = t.right; else for (t = t.right; !t.m(); ) this.Et.push(t), 
        t = t.left;
        return e;
    }
    At() {
        return this.Et.length > 0;
    }
    Rt() {
        if (0 === this.Et.length) return null;
        const t = this.Et[this.Et.length - 1];
        return {
            key: t.key,
            value: t.value
        };
    }
}

 // end SortedMapIterator
// Represents a node in a Left-leaning Red-Black tree.
class Ft {
    constructor(t, e, n, s, i) {
        this.key = t, this.value = e, this.color = null != n ? n : Ft.RED, this.left = null != s ? s : Ft.EMPTY, 
        this.right = null != i ? i : Ft.EMPTY, this.size = this.left.size + 1 + this.right.size;
    }
    // Returns a copy of the current node, optionally replacing pieces of it.
    copy(t, e, n, s, i) {
        return new Ft(null != t ? t : this.key, null != e ? e : this.value, null != n ? n : this.color, null != s ? s : this.left, null != i ? i : this.right);
    }
    m() {
        return !1;
    }
    // Traverses the tree in key order and calls the specified action function
    // for each node. If action returns true, traversal is aborted.
    // Returns the first truthy value returned by action, or the last falsey
    // value returned by action.
    ht(t) {
        return this.left.ht(t) || t(this.key, this.value) || this.right.ht(t);
    }
    // Traverses the tree in reverse key order and calls the specified action
    // function for each node. If action returns true, traversal is aborted.
    // Returns the first truthy value returned by action, or the last falsey
    // value returned by action.
    lt(t) {
        return this.right.lt(t) || t(this.key, this.value) || this.left.lt(t);
    }
    // Returns the minimum node in the tree.
    min() {
        return this.left.m() ? this : this.left.min();
    }
    // Returns the maximum key in the tree.
    ct() {
        return this.min().key;
    }
    // Returns the maximum key in the tree.
    ut() {
        return this.right.m() ? this.key : this.right.ut();
    }
    // Returns new tree, with the key/value added.
    ot(t, e, n) {
        let s = this;
        const i = n(t, s.key);
        return s = i < 0 ? s.copy(null, null, null, s.left.ot(t, e, n), null) : 0 === i ? s.copy(null, e, null, null, null) : s.copy(null, null, null, null, s.right.ot(t, e, n)), 
        s.gt();
    }
    Pt() {
        if (this.left.m()) return Ft.EMPTY;
        let t = this;
        return t.left.yt() || t.left.left.yt() || (t = t.Vt()), t = t.copy(null, null, null, t.left.Pt(), null), 
        t.gt();
    }
    // Returns new tree, with the specified item removed.
    remove(t, e) {
        let n, s = this;
        if (e(t, s.key) < 0) s.left.m() || s.left.yt() || s.left.left.yt() || (s = s.Vt()), 
        s = s.copy(null, null, null, s.left.remove(t, e), null); else {
            if (s.left.yt() && (s = s.bt()), s.right.m() || s.right.yt() || s.right.left.yt() || (s = s.vt()), 
            0 === e(t, s.key)) {
                if (s.right.m()) return Ft.EMPTY;
                n = s.right.min(), s = s.copy(n.key, n.value, null, null, s.right.Pt());
            }
            s = s.copy(null, null, null, null, s.right.remove(t, e));
        }
        return s.gt();
    }
    yt() {
        return this.color;
    }
    // Returns new tree after performing any needed rotations.
    gt() {
        let t = this;
        return t.right.yt() && !t.left.yt() && (t = t.St()), t.left.yt() && t.left.left.yt() && (t = t.bt()), 
        t.left.yt() && t.right.yt() && (t = t.Dt()), t;
    }
    Vt() {
        let t = this.Dt();
        return t.right.left.yt() && (t = t.copy(null, null, null, null, t.right.bt()), t = t.St(), 
        t = t.Dt()), t;
    }
    vt() {
        let t = this.Dt();
        return t.left.left.yt() && (t = t.bt(), t = t.Dt()), t;
    }
    St() {
        const t = this.copy(null, null, Ft.RED, null, this.right.left);
        return this.right.copy(null, null, this.color, t, null);
    }
    bt() {
        const t = this.copy(null, null, Ft.RED, this.left.right, null);
        return this.left.copy(null, null, this.color, null, t);
    }
    Dt() {
        const t = this.left.copy(null, null, !this.left.color, null, null), e = this.right.copy(null, null, !this.right.color, null, null);
        return this.copy(null, null, !this.color, t, e);
    }
    // For testing.
    Ct() {
        const t = this.Nt();
        return Math.pow(2, t) <= this.size + 1;
    }
    // In a balanced RB tree, the black-depth (number of black nodes) from root to
    // leaves is equal on both sides.  This function verifies that or asserts.
    Nt() {
        if (this.yt() && this.left.yt()) throw y();
        if (this.right.yt()) throw y();
        const t = this.left.Nt();
        if (t !== this.right.Nt()) throw y();
        return t + (this.yt() ? 0 : 1);
    }
}

 // end LLRBNode
// Empty node is shared between all LLRB trees.
// eslint-disable-next-line @typescript-eslint/no-explicit-any
Ft.EMPTY = null, Ft.RED = !0, Ft.at = !1;

// end LLRBEmptyNode
Ft.EMPTY = new 
// Represents an empty node (a leaf node in the Red-Black Tree).
class {
    constructor() {
        this.size = 0;
    }
    get key() {
        throw y();
    }
    get value() {
        throw y();
    }
    get color() {
        throw y();
    }
    get left() {
        throw y();
    }
    get right() {
        throw y();
    }
    // Returns a copy of the current node.
    copy(t, e, n, s, i) {
        return this;
    }
    // Returns a copy of the tree, with the specified key/value added.
    ot(t, e, n) {
        return new Ft(t, e);
    }
    // Returns a copy of the tree, with the specified key removed.
    remove(t, e) {
        return this;
    }
    m() {
        return !0;
    }
    ht(t) {
        return !1;
    }
    lt(t) {
        return !1;
    }
    ct() {
        return null;
    }
    ut() {
        return null;
    }
    yt() {
        return !1;
    }
    // For testing.
    Ct() {
        return !0;
    }
    Nt() {
        return 0;
    }
};

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * SortedSet is an immutable (copy-on-write) collection that holds elements
 * in order specified by the provided comparator.
 *
 * NOTE: if provided comparator returns 0 for two elements, we consider them to
 * be equal!
 */
class xt {
    constructor(t) {
        this.i = t, this.data = new Ct(this.i);
    }
    has(t) {
        return null !== this.data.get(t);
    }
    first() {
        return this.data.ct();
    }
    last() {
        return this.data.ut();
    }
    get size() {
        return this.data.size;
    }
    indexOf(t) {
        return this.data.indexOf(t);
    }
    /** Iterates elements in order defined by "comparator" */    forEach(t) {
        this.data.ht(((e, n) => (t(e), !1)));
    }
    /** Iterates over `elem`s such that: range[0] <= elem < range[1]. */    Ft(t, e) {
        const n = this.data.ft(t[0]);
        for (;n.At(); ) {
            const s = n.It();
            if (this.i(s.key, t[1]) >= 0) return;
            e(s.key);
        }
    }
    /**
     * Iterates over `elem`s such that: start <= elem until false is returned.
     */    xt(t, e) {
        let n;
        for (n = void 0 !== e ? this.data.ft(e) : this.data._t(); n.At(); ) {
            if (!t(n.It().key)) return;
        }
    }
    /** Finds the least element greater than or equal to `elem`. */    $t(t) {
        const e = this.data.ft(t);
        return e.At() ? e.It().key : null;
    }
    _t() {
        return new $t(this.data._t());
    }
    ft(t) {
        return new $t(this.data.ft(t));
    }
    /** Inserts or updates an element */    add(t) {
        return this.copy(this.data.remove(t).ot(t, !0));
    }
    /** Deletes an element */    delete(t) {
        return this.has(t) ? this.copy(this.data.remove(t)) : this;
    }
    m() {
        return this.data.m();
    }
    kt(t) {
        let e = this;
        // Make sure `result` always refers to the larger one of the two sets.
                return e.size < t.size && (e = t, t = this), t.forEach((t => {
            e = e.add(t);
        })), e;
    }
    isEqual(t) {
        if (!(t instanceof xt)) return !1;
        if (this.size !== t.size) return !1;
        const e = this.data._t(), n = t.data._t();
        for (;e.At(); ) {
            const t = e.It().key, s = n.It().key;
            if (0 !== this.i(t, s)) return !1;
        }
        return !0;
    }
    A() {
        const t = [];
        return this.forEach((e => {
            t.push(e);
        })), t;
    }
    toString() {
        const t = [];
        return this.forEach((e => t.push(e))), "SortedSet(" + t.toString() + ")";
    }
    copy(t) {
        const e = new xt(this.i);
        return e.data = t, e;
    }
}

class $t {
    constructor(t) {
        this.Mt = t;
    }
    It() {
        return this.Mt.It().key;
    }
    At() {
        return this.Mt.At();
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ const kt = new Ct(x.i);

function Mt() {
    return kt;
}

function Ot() {
    return Mt();
}

const Lt = new Ct(x.i);

function Bt() {
    return Lt;
}

const qt = new Ct(x.i);

const Ut = new xt(x.i);

function Qt(...t) {
    let e = Ut;
    for (const n of t) e = e.add(n);
    return e;
}

const Wt = new xt(st);

function jt() {
    return Wt;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * DocumentSet is an immutable (copy-on-write) collection that holds documents
 * in order specified by the provided comparator. We always add a document key
 * comparator on top of what is provided to guarantee document equality based on
 * the key.
 */ class Kt {
    /** The default ordering is by key if the comparator is omitted */
    constructor(t) {
        // We are adding document key comparator to the end as it's the only
        // guaranteed unique property of a document.
        this.i = t ? (e, n) => t(e, n) || x.i(e.key, n.key) : (t, e) => x.i(t.key, e.key), 
        this.Ot = Bt(), this.Lt = new Ct(this.i);
    }
    /**
     * Returns an empty copy of the existing DocumentSet, using the same
     * comparator.
     */    static Bt(t) {
        return new Kt(t.i);
    }
    has(t) {
        return null != this.Ot.get(t);
    }
    get(t) {
        return this.Ot.get(t);
    }
    first() {
        return this.Lt.ct();
    }
    last() {
        return this.Lt.ut();
    }
    m() {
        return this.Lt.m();
    }
    /**
     * Returns the index of the provided key in the document set, or -1 if the
     * document key is not present in the set;
     */    indexOf(t) {
        const e = this.Ot.get(t);
        return e ? this.Lt.indexOf(e) : -1;
    }
    get size() {
        return this.Lt.size;
    }
    /** Iterates documents in order defined by "comparator" */    forEach(t) {
        this.Lt.ht(((e, n) => (t(e), !1)));
    }
    /** Inserts or updates a document with the same key */    add(t) {
        // First remove the element if we have it.
        const e = this.delete(t.key);
        return e.copy(e.Ot.ot(t.key, t), e.Lt.ot(t, null));
    }
    /** Deletes a document with a given key */    delete(t) {
        const e = this.get(t);
        return e ? this.copy(this.Ot.remove(t), this.Lt.remove(e)) : this;
    }
    isEqual(t) {
        if (!(t instanceof Kt)) return !1;
        if (this.size !== t.size) return !1;
        const e = this.Lt._t(), n = t.Lt._t();
        for (;e.At(); ) {
            const t = e.It().key, s = n.It().key;
            if (!t.isEqual(s)) return !1;
        }
        return !0;
    }
    toString() {
        const t = [];
        return this.forEach((e => {
            t.push(e.toString());
        })), 0 === t.length ? "DocumentSet ()" : "DocumentSet (\n  " + t.join("  \n") + "\n)";
    }
    copy(t, e) {
        const n = new Kt;
        return n.i = this.i, n.Ot = t, n.Lt = e, n;
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * DocumentChangeSet keeps track of a set of changes to docs in a query, merging
 * duplicate events for the same doc.
 */ class Gt {
    constructor() {
        this.qt = new Ct(x.i);
    }
    track(t) {
        const e = t.doc.key, n = this.qt.get(e);
        n ? 
        // Merge the new change with the existing change.
        0 /* Added */ !== t.type && 3 /* Metadata */ === n.type ? this.qt = this.qt.ot(e, t) : 3 /* Metadata */ === t.type && 1 /* Removed */ !== n.type ? this.qt = this.qt.ot(e, {
            type: n.type,
            doc: t.doc
        }) : 2 /* Modified */ === t.type && 2 /* Modified */ === n.type ? this.qt = this.qt.ot(e, {
            type: 2 /* Modified */ ,
            doc: t.doc
        }) : 2 /* Modified */ === t.type && 0 /* Added */ === n.type ? this.qt = this.qt.ot(e, {
            type: 0 /* Added */ ,
            doc: t.doc
        }) : 1 /* Removed */ === t.type && 0 /* Added */ === n.type ? this.qt = this.qt.remove(e) : 1 /* Removed */ === t.type && 2 /* Modified */ === n.type ? this.qt = this.qt.ot(e, {
            type: 1 /* Removed */ ,
            doc: n.doc
        }) : 0 /* Added */ === t.type && 1 /* Removed */ === n.type ? this.qt = this.qt.ot(e, {
            type: 2 /* Modified */ ,
            doc: t.doc
        }) : 
        // This includes these cases, which don't make sense:
        // Added->Added
        // Removed->Removed
        // Modified->Added
        // Removed->Modified
        // Metadata->Added
        // Removed->Metadata
        y() : this.qt = this.qt.ot(e, t);
    }
    Ut() {
        const t = [];
        return this.qt.ht(((e, n) => {
            t.push(n);
        })), t;
    }
}

class zt {
    constructor(t, e, n, s, i, r, o, a) {
        this.query = t, this.docs = e, this.Qt = n, this.docChanges = s, this.Wt = i, this.fromCache = r, 
        this.jt = o, this.Kt = a;
    }
    /** Returns a view snapshot as if all documents in the snapshot were added. */    static Gt(t, e, n, s) {
        const i = [];
        return e.forEach((t => {
            i.push({
                type: 0 /* Added */ ,
                doc: t
            });
        })), new zt(t, e, Kt.Bt(e), i, n, s, 
        /* syncStateChanged= */ !0, 
        /* excludesMetadataChanges= */ !1);
    }
    get hasPendingWrites() {
        return !this.Wt.m();
    }
    isEqual(t) {
        if (!(this.fromCache === t.fromCache && this.jt === t.jt && this.Wt.isEqual(t.Wt) && cs(this.query, t.query) && this.docs.isEqual(t.docs) && this.Qt.isEqual(t.Qt))) return !1;
        const e = this.docChanges, n = t.docChanges;
        if (e.length !== n.length) return !1;
        for (let t = 0; t < e.length; t++) if (e[t].type !== n[t].type || !e[t].doc.isEqual(n[t].doc)) return !1;
        return !0;
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * An event from the RemoteStore. It is split into targetChanges (changes to the
 * state or the set of documents in our watched targets) and documentUpdates
 * (changes to the actual documents).
 */ class Ht {
    constructor(
    /**
     * The snapshot version this event brings us up to, or MIN if not set.
     */
    t, 
    /**
     * A map from target to changes to the target. See TargetChange.
     */
    e, 
    /**
     * A set of targets that is known to be inconsistent. Listens for these
     * targets should be re-established without resume tokens.
     */
    n, 
    /**
     * A set of which documents have changed or been deleted, along with the
     * doc's new values (if not deleted).
     */
    s, 
    /**
     * A set of which document updates are due only to limbo resolution targets.
     */
    i) {
        this.nt = t, this.zt = e, this.Ht = n, this.Yt = s, this.Jt = i;
    }
    /**
     * HACK: Views require RemoteEvents in order to determine whether the view is
     * CURRENT, but secondary tabs don't receive remote events. So this method is
     * used to create a synthesized RemoteEvent that can be used to apply a
     * CURRENT status change to a View, for queries executed in a different tab.
     */
    // PORTING NOTE: Multi-tab only
    static Xt(t, e) {
        const n = new Map;
        return n.set(t, Yt.Zt(t, e)), new Ht(wt.min(), n, jt(), Mt(), Qt());
    }
}

/**
 * A TargetChange specifies the set of changes for a specific target as part of
 * a RemoteEvent. These changes track which documents are added, modified or
 * removed, as well as the target's resume token and whether the target is
 * marked CURRENT.
 * The actual changes *to* documents are not part of the TargetChange since
 * documents may be part of multiple targets.
 */ class Yt {
    constructor(
    /**
     * An opaque, server-assigned token that allows watching a query to be resumed
     * after disconnecting without retransmitting all the data that matches the
     * query. The resume token essentially identifies a point in time from which
     * the server should resume sending results.
     */
    t, 
    /**
     * The "current" (synced) status of this target. Note that "current"
     * has special meaning in the RPC protocol that implies that a target is
     * both up-to-date and consistent with the rest of the watch stream.
     */
    e, 
    /**
     * The set of documents that were newly assigned to this target as part of
     * this remote event.
     */
    n, 
    /**
     * The set of documents that were already assigned to this target but received
     * an update during this remote event.
     */
    s, 
    /**
     * The set of documents that were removed from this target as part of this
     * remote event.
     */
    i) {
        this.resumeToken = t, this.te = e, this.ee = n, this.ne = s, this.se = i;
    }
    /**
     * This method is used to create a synthesized TargetChanges that can be used to
     * apply a CURRENT status change to a View (for queries executed in a different
     * tab) or for new queries (to raise snapshots with correct CURRENT status).
     */    static Zt(t, e) {
        return new Yt(ot.B, e, Qt(), Qt(), Qt());
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Represents a changed document and a list of target ids to which this change
 * applies.
 *
 * If document has been deleted NoDocument will be provided.
 */ class Jt {
    constructor(
    /** The new document applies to all of these targets. */
    t, 
    /** The new document is removed from all of these targets. */
    e, 
    /** The key of the document for this change. */
    n, 
    /**
     * The new document or NoDocument if it was deleted. Is null if the
     * document went out of view without the server sending a new document.
     */
    s) {
        this.ie = t, this.removedTargetIds = e, this.key = n, this.re = s;
    }
}

class Xt {
    constructor(t, e) {
        this.targetId = t, this.oe = e;
    }
}

class Zt {
    constructor(
    /** What kind of change occurred to the watch target. */
    t, 
    /** The target IDs that were added/removed/set. */
    e, 
    /**
     * An opaque, server-assigned token that allows watching a target to be
     * resumed after disconnecting without retransmitting all the data that
     * matches the target. The resume token essentially identifies a point in
     * time from which the server should resume sending results.
     */
    n = ot.B
    /** An RPC error indicating why the watch failed. */ , s = null) {
        this.state = t, this.targetIds = e, this.resumeToken = n, this.cause = s;
    }
}

/** Tracks the internal state of a Watch target. */ class te {
    constructor() {
        /**
         * The number of pending responses (adds or removes) that we are waiting on.
         * We only consider targets active that have no pending responses.
         */
        this.ae = 0, 
        /**
         * Keeps track of the document changes since the last raised snapshot.
         *
         * These changes are continuously updated as we receive document updates and
         * always reflect the current set of changes against the last issued snapshot.
         */
        this.ce = se(), 
        /** See public getters for explanations of these fields. */
        this.ue = ot.B, this.he = !1, 
        /**
         * Whether this target state should be included in the next snapshot. We
         * initialize to true so that newly-added targets are included in the next
         * RemoteEvent.
         */
        this.le = !0;
    }
    /**
     * Whether this target has been marked 'current'.
     *
     * 'Current' has special meaning in the RPC protocol: It implies that the
     * Watch backend has sent us all changes up to the point at which the target
     * was added and that the target is consistent with the rest of the watch
     * stream.
     */    get te() {
        return this.he;
    }
    /** The last resume token sent to us for this target. */    get resumeToken() {
        return this.ue;
    }
    /** Whether this target has pending target adds or target removes. */    get _e() {
        return 0 !== this.ae;
    }
    /** Whether we have modified any state that should trigger a snapshot. */    get fe() {
        return this.le;
    }
    /**
     * Applies the resume token to the TargetChange, but only when it has a new
     * value. Empty resumeTokens are discarded.
     */    de(t) {
        t.O() > 0 && (this.le = !0, this.ue = t);
    }
    /**
     * Creates a target change from the current set of changes.
     *
     * To reset the document changes after raising this snapshot, call
     * `clearPendingChanges()`.
     */    we() {
        let t = Qt(), e = Qt(), n = Qt();
        return this.ce.forEach(((s, i) => {
            switch (i) {
              case 0 /* Added */ :
                t = t.add(s);
                break;

              case 2 /* Modified */ :
                e = e.add(s);
                break;

              case 1 /* Removed */ :
                n = n.add(s);
                break;

              default:
                y();
            }
        })), new Yt(this.ue, this.he, t, e, n);
    }
    /**
     * Resets the document changes and sets `hasPendingChanges` to false.
     */    me() {
        this.le = !1, this.ce = se();
    }
    Te(t, e) {
        this.le = !0, this.ce = this.ce.ot(t, e);
    }
    Ee(t) {
        this.le = !0, this.ce = this.ce.remove(t);
    }
    Ie() {
        this.ae += 1;
    }
    Ae() {
        this.ae -= 1;
    }
    Re() {
        this.le = !0, this.he = !0;
    }
}

/**
 * A helper class to accumulate watch changes into a RemoteEvent.
 */
class ee {
    constructor(t) {
        this.ge = t, 
        /** The internal state of all tracked targets. */
        this.Pe = new Map, 
        /** Keeps track of the documents to update since the last raised snapshot. */
        this.ye = Mt(), 
        /** A mapping of document keys to their set of target IDs. */
        this.Ve = ne(), 
        /**
         * A list of targets with existence filter mismatches. These targets are
         * known to be inconsistent and their listens needs to be re-established by
         * RemoteStore.
         */
        this.pe = new xt(st);
    }
    /**
     * Processes and adds the DocumentWatchChange to the current set of changes.
     */    be(t) {
        for (const e of t.ie) t.re instanceof Kn ? this.ve(e, t.re) : t.re instanceof Gn && this.Se(e, t.key, t.re);
        for (const e of t.removedTargetIds) this.Se(e, t.key, t.re);
    }
    /** Processes and adds the WatchTargetChange to the current set of changes. */    De(t) {
        this.Ce(t, (e => {
            const n = this.Ne(e);
            switch (t.state) {
              case 0 /* NoChange */ :
                this.Fe(e) && n.de(t.resumeToken);
                break;

              case 1 /* Added */ :
                // We need to decrement the number of pending acks needed from watch
                // for this targetId.
                n.Ae(), n._e || 
                // We have a freshly added target, so we need to reset any state
                // that we had previously. This can happen e.g. when remove and add
                // back a target for existence filter mismatches.
                n.me(), n.de(t.resumeToken);
                break;

              case 2 /* Removed */ :
                // We need to keep track of removed targets to we can post-filter and
                // remove any target changes.
                // We need to decrement the number of pending acks needed from watch
                // for this targetId.
                n.Ae(), n._e || this.removeTarget(e);
                break;

              case 3 /* Current */ :
                this.Fe(e) && (n.Re(), n.de(t.resumeToken));
                break;

              case 4 /* Reset */ :
                this.Fe(e) && (
                // Reset the target and synthesizes removes for all existing
                // documents. The backend will re-add any documents that still
                // match the target before it sends the next global snapshot.
                this.xe(e), n.de(t.resumeToken));
                break;

              default:
                y();
            }
        }));
    }
    /**
     * Iterates over all targetIds that the watch change applies to: either the
     * targetIds explicitly listed in the change or the targetIds of all currently
     * active targets.
     */    Ce(t, e) {
        t.targetIds.length > 0 ? t.targetIds.forEach(e) : this.Pe.forEach(((t, n) => {
            this.Fe(n) && e(n);
        }));
    }
    /**
     * Handles existence filters and synthesizes deletes for filter mismatches.
     * Targets that are invalidated by filter mismatches are added to
     * `pendingTargetResets`.
     */    $e(t) {
        const e = t.targetId, n = t.oe.count, s = this.ke(e);
        if (s) {
            const t = s.target;
            if (yt(t)) if (0 === n) {
                // The existence filter told us the document does not exist. We deduce
                // that this document does not exist and apply a deleted document to
                // our updates. Without applying this deleted document there might be
                // another query that will raise this document as part of a snapshot
                // until it is resolved, essentially exposing inconsistency between
                // queries.
                const n = new x(t.path);
                this.Se(e, n, new Gn(n, wt.min()));
            } else V(1 === n); else {
                this.Me(e) !== n && (
                // Existence filter mismatch: We reset the mapping and raise a new
                // snapshot with `isFromCache:true`.
                this.xe(e), this.pe = this.pe.add(e));
            }
        }
    }
    /**
     * Converts the currently accumulated state into a remote event at the
     * provided snapshot version. Resets the accumulated changes before returning.
     */    Oe(t) {
        const e = new Map;
        this.Pe.forEach(((n, s) => {
            const i = this.ke(s);
            if (i) {
                if (n.te && yt(i.target)) {
                    // Document queries for document that don't exist can produce an empty
                    // result set. To update our local cache, we synthesize a document
                    // delete if we have not previously received the document. This
                    // resolves the limbo state of the document, removing it from
                    // limboDocumentRefs.
                    // TODO(dimond): Ideally we would have an explicit lookup target
                    // instead resulting in an explicit delete message and we could
                    // remove this special logic.
                    const e = new x(i.target.path);
                    null !== this.ye.get(e) || this.Le(s, e) || this.Se(s, e, new Gn(e, t));
                }
                n.fe && (e.set(s, n.we()), n.me());
            }
        }));
        let n = Qt();
        // We extract the set of limbo-only document updates as the GC logic
        // special-cases documents that do not appear in the target cache.
        
        // TODO(gsoltis): Expand on this comment once GC is available in the JS
        // client.
                this.Ve.forEach(((t, e) => {
            let s = !0;
            e.xt((t => {
                const e = this.ke(t);
                return !e || 2 /* LimboResolution */ === e.et || (s = !1, !1);
            })), s && (n = n.add(t));
        }));
        const s = new Ht(t, e, this.pe, this.ye, n);
        return this.ye = Mt(), this.Ve = ne(), this.pe = new xt(st), s;
    }
    /**
     * Adds the provided document to the internal list of document updates and
     * its document key to the given target's mapping.
     */
    // Visible for testing.
    ve(t, e) {
        if (!this.Fe(t)) return;
        const n = this.Le(t, e.key) ? 2 /* Modified */ : 0 /* Added */;
        this.Ne(t).Te(e.key, n), this.ye = this.ye.ot(e.key, e), this.Ve = this.Ve.ot(e.key, this.Be(e.key).add(t));
    }
    /**
     * Removes the provided document from the target mapping. If the
     * document no longer matches the target, but the document's state is still
     * known (e.g. we know that the document was deleted or we received the change
     * that caused the filter mismatch), the new document can be provided
     * to update the remote document cache.
     */
    // Visible for testing.
    Se(t, e, n) {
        if (!this.Fe(t)) return;
        const s = this.Ne(t);
        this.Le(t, e) ? s.Te(e, 1 /* Removed */) : 
        // The document may have entered and left the target before we raised a
        // snapshot, so we can just ignore the change.
        s.Ee(e), this.Ve = this.Ve.ot(e, this.Be(e).delete(t)), n && (this.ye = this.ye.ot(e, n));
    }
    removeTarget(t) {
        this.Pe.delete(t);
    }
    /**
     * Returns the current count of documents in the target. This includes both
     * the number of documents that the LocalStore considers to be part of the
     * target as well as any accumulated changes.
     */    Me(t) {
        const e = this.Ne(t).we();
        return this.ge.qe(t).size + e.ee.size - e.se.size;
    }
    /**
     * Increment the number of acks needed from watch before we can consider the
     * server to be 'in-sync' with the client's active targets.
     */    Ie(t) {
        this.Ne(t).Ie();
    }
    Ne(t) {
        let e = this.Pe.get(t);
        return e || (e = new te, this.Pe.set(t, e)), e;
    }
    Be(t) {
        let e = this.Ve.get(t);
        return e || (e = new xt(st), this.Ve = this.Ve.ot(t, e)), e;
    }
    /**
     * Verifies that the user is still interested in this target (by calling
     * `getTargetDataForTarget()`) and that we are not waiting for pending ADDs
     * from watch.
     */    Fe(t) {
        const e = null !== this.ke(t);
        return e || A("WatchChangeAggregator", "Detected inactive target", t), e;
    }
    /**
     * Returns the TargetData for an active target (i.e. a target that the user
     * is still interested in that has no outstanding target change requests).
     */    ke(t) {
        const e = this.Pe.get(t);
        return e && e._e ? null : this.ge.Ue(t);
    }
    /**
     * Resets the state of a Watch target to its initial state (e.g. sets
     * 'current' to false, clears the resume token and removes its target mapping
     * from all documents).
     */    xe(t) {
        this.Pe.set(t, new te);
        this.ge.qe(t).forEach((e => {
            this.Se(t, e, /*updatedDocument=*/ null);
        }));
    }
    /**
     * Returns whether the LocalStore considers the document to be part of the
     * specified target.
     */    Le(t, e) {
        return this.ge.qe(t).has(e);
    }
}

function ne() {
    return new Ct(x.i);
}

function se() {
    return new Ct(x.i);
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Represents a locally-applied ServerTimestamp.
 *
 * Server Timestamps are backed by MapValues that contain an internal field
 * `__type__` with a value of `server_timestamp`. The previous value and local
 * write time are stored in its `__previous_value__` and `__local_write_time__`
 * fields respectively.
 *
 * Notes:
 * - ServerTimestampValue instances are created as the result of applying a
 *   TransformMutation (see TransformMutation.applyTo()). They can only exist in
 *   the local view of a document. Therefore they do not need to be parsed or
 *   serialized.
 * - When evaluated locally (e.g. for snapshot.data()), they by default
 *   evaluate to `null`. This behavior can be configured by passing custom
 *   FieldValueOptions to value().
 * - With respect to other ServerTimestampValues, they sort by their
 *   localWriteTime.
 */ function ie(t) {
    var e, n;
    return "server_timestamp" === (null === (n = ((null === (e = null == t ? void 0 : t.mapValue) || void 0 === e ? void 0 : e.fields) || {}).__type__) || void 0 === n ? void 0 : n.stringValue);
}

/**
 * Creates a new ServerTimestamp proto value (using the internal format).
 */
/**
 * Returns the value of the field before this ServerTimestamp was set.
 *
 * Preserving the previous values allows the user to display the last resoled
 * value until the backend responds with the timestamp.
 */
function re(t) {
    const e = t.mapValue.fields.__previous_value__;
    return ie(e) ? re(e) : e;
}

/**
 * Returns the local time at which this timestamp was first set.
 */ function oe(t) {
    const e = we(t.mapValue.fields.__local_write_time__.timestampValue);
    return new dt(e.seconds, e.nanos);
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// A RegExp matching ISO 8601 UTC timestamps with optional fraction.
const ae = new RegExp(/^\d{4}-\d\d-\d\dT\d\d:\d\d:\d\d(?:\.(\d+))?Z$/);

/** Extracts the backend's type order for the provided value. */ function ce(t) {
    return "nullValue" in t ? 0 /* NullValue */ : "booleanValue" in t ? 1 /* BooleanValue */ : "integerValue" in t || "doubleValue" in t ? 2 /* NumberValue */ : "timestampValue" in t ? 3 /* TimestampValue */ : "stringValue" in t ? 5 /* StringValue */ : "bytesValue" in t ? 6 /* BlobValue */ : "referenceValue" in t ? 7 /* RefValue */ : "geoPointValue" in t ? 8 /* GeoPointValue */ : "arrayValue" in t ? 9 /* ArrayValue */ : "mapValue" in t ? ie(t) ? 4 /* ServerTimestampValue */ : 10 /* ObjectValue */ : y();
}

/** Tests `left` and `right` for equality based on the backend semantics. */ function ue(t, e) {
    const n = ce(t);
    if (n !== ce(e)) return !1;
    switch (n) {
      case 0 /* NullValue */ :
        return !0;

      case 1 /* BooleanValue */ :
        return t.booleanValue === e.booleanValue;

      case 4 /* ServerTimestampValue */ :
        return oe(t).isEqual(oe(e));

      case 3 /* TimestampValue */ :
        return function(t, e) {
            if ("string" == typeof t.timestampValue && "string" == typeof e.timestampValue && t.timestampValue.length === e.timestampValue.length) 
            // Use string equality for ISO 8601 timestamps
            return t.timestampValue === e.timestampValue;
            const n = we(t.timestampValue), s = we(e.timestampValue);
            return n.seconds === s.seconds && n.nanos === s.nanos;
        }(t, e);

      case 5 /* StringValue */ :
        return t.stringValue === e.stringValue;

      case 6 /* BlobValue */ :
        return function(t, e) {
            return Te(t.bytesValue).isEqual(Te(e.bytesValue));
        }(t, e);

      case 7 /* RefValue */ :
        return t.referenceValue === e.referenceValue;

      case 8 /* GeoPointValue */ :
        return function(t, e) {
            return me(t.geoPointValue.latitude) === me(e.geoPointValue.latitude) && me(t.geoPointValue.longitude) === me(e.geoPointValue.longitude);
        }(t, e);

      case 2 /* NumberValue */ :
        return function(t, e) {
            if ("integerValue" in t && "integerValue" in e) return me(t.integerValue) === me(e.integerValue);
            if ("doubleValue" in t && "doubleValue" in e) {
                const n = me(t.doubleValue), s = me(e.doubleValue);
                return n === s ? Tt(n) === Tt(s) : isNaN(n) && isNaN(s);
            }
            return !1;
        }(t, e);

      case 9 /* ArrayValue */ :
        return it(t.arrayValue.values || [], e.arrayValue.values || [], ue);

      case 10 /* ObjectValue */ :
        return function(t, e) {
            const n = t.mapValue.fields || {}, s = e.mapValue.fields || {};
            if (b(n) !== b(s)) return !1;
            for (const t in n) if (n.hasOwnProperty(t) && (void 0 === s[t] || !ue(n[t], s[t]))) return !1;
            return !0;
        }
        /** Returns true if the ArrayValue contains the specified element. */ (t, e);

      default:
        return y();
    }
}

function he(t, e) {
    return void 0 !== (t.values || []).find((t => ue(t, e)));
}

function le(t, e) {
    const n = ce(t), s = ce(e);
    if (n !== s) return st(n, s);
    switch (n) {
      case 0 /* NullValue */ :
        return 0;

      case 1 /* BooleanValue */ :
        return st(t.booleanValue, e.booleanValue);

      case 2 /* NumberValue */ :
        return function(t, e) {
            const n = me(t.integerValue || t.doubleValue), s = me(e.integerValue || e.doubleValue);
            return n < s ? -1 : n > s ? 1 : n === s ? 0 : 
            // one or both are NaN.
            isNaN(n) ? isNaN(s) ? 0 : -1 : 1;
        }(t, e);

      case 3 /* TimestampValue */ :
        return _e(t.timestampValue, e.timestampValue);

      case 4 /* ServerTimestampValue */ :
        return _e(oe(t), oe(e));

      case 5 /* StringValue */ :
        return st(t.stringValue, e.stringValue);

      case 6 /* BlobValue */ :
        return function(t, e) {
            const n = Te(t), s = Te(e);
            return n.L(s);
        }(t.bytesValue, e.bytesValue);

      case 7 /* RefValue */ :
        return function(t, e) {
            const n = t.split("/"), s = e.split("/");
            for (let t = 0; t < n.length && t < s.length; t++) {
                const e = st(n[t], s[t]);
                if (0 !== e) return e;
            }
            return st(n.length, s.length);
        }(t.referenceValue, e.referenceValue);

      case 8 /* GeoPointValue */ :
        return function(t, e) {
            const n = st(me(t.latitude), me(e.latitude));
            if (0 !== n) return n;
            return st(me(t.longitude), me(e.longitude));
        }(t.geoPointValue, e.geoPointValue);

      case 9 /* ArrayValue */ :
        return function(t, e) {
            const n = t.values || [], s = e.values || [];
            for (let t = 0; t < n.length && t < s.length; ++t) {
                const e = le(n[t], s[t]);
                if (e) return e;
            }
            return st(n.length, s.length);
        }(t.arrayValue, e.arrayValue);

      case 10 /* ObjectValue */ :
        return function(t, e) {
            const n = t.fields || {}, s = Object.keys(n), i = e.fields || {}, r = Object.keys(i);
            // Even though MapValues are likely sorted correctly based on their insertion
            // order (e.g. when received from the backend), local modifications can bring
            // elements out of order. We need to re-sort the elements to ensure that
            // canonical IDs are independent of insertion order.
            s.sort(), r.sort();
            for (let t = 0; t < s.length && t < r.length; ++t) {
                const e = st(s[t], r[t]);
                if (0 !== e) return e;
                const o = le(n[s[t]], i[r[t]]);
                if (0 !== o) return o;
            }
            return st(s.length, r.length);
        }
        /**
 * Generates the canonical ID for the provided field value (as used in Target
 * serialization).
 */ (t.mapValue, e.mapValue);

      default:
        throw y();
    }
}

function _e(t, e) {
    if ("string" == typeof t && "string" == typeof e && t.length === e.length) return st(t, e);
    const n = we(t), s = we(e), i = st(n.seconds, s.seconds);
    return 0 !== i ? i : st(n.nanos, s.nanos);
}

function fe(t) {
    return de(t);
}

function de(t) {
    return "nullValue" in t ? "null" : "booleanValue" in t ? "" + t.booleanValue : "integerValue" in t ? "" + t.integerValue : "doubleValue" in t ? "" + t.doubleValue : "timestampValue" in t ? function(t) {
        const e = we(t);
        return `time(${e.seconds},${e.nanos})`;
    }(t.timestampValue) : "stringValue" in t ? t.stringValue : "bytesValue" in t ? Te(t.bytesValue).toBase64() : "referenceValue" in t ? (n = t.referenceValue, 
    x.C(n).toString()) : "geoPointValue" in t ? `geo(${(e = t.geoPointValue).latitude},${e.longitude})` : "arrayValue" in t ? function(t) {
        let e = "[", n = !0;
        for (const s of t.values || []) n ? n = !1 : e += ",", e += de(s);
        return e + "]";
    }
    /**
 * Converts the possible Proto values for a timestamp value into a "seconds and
 * nanos" representation.
 */ (t.arrayValue) : "mapValue" in t ? function(t) {
        // Iteration order in JavaScript is not guaranteed. To ensure that we generate
        // matching canonical IDs for identical maps, we need to sort the keys.
        const e = Object.keys(t.fields || {}).sort();
        let n = "{", s = !0;
        for (const i of e) s ? s = !1 : n += ",", n += `${i}:${de(t.fields[i])}`;
        return n + "}";
    }(t.mapValue) : y();
    var e, n;
}

function we(t) {
    // The json interface (for the browser) will return an iso timestamp string,
    // while the proto js library (for node) will return a
    // google.protobuf.Timestamp instance.
    if (V(!!t), "string" == typeof t) {
        // The date string can have higher precision (nanos) than the Date class
        // (millis), so we do some custom parsing here.
        // Parse the nanos right out of the string.
        let e = 0;
        const n = ae.exec(t);
        if (V(!!n), n[1]) {
            // Pad the fraction out to 9 digits (nanos).
            let t = n[1];
            t = (t + "000000000").substr(0, 9), e = Number(t);
        }
        // Parse the date to get the seconds.
                const s = new Date(t);
        return {
            seconds: Math.floor(s.getTime() / 1e3),
            nanos: e
        };
    }
    return {
        seconds: me(t.seconds),
        nanos: me(t.nanos)
    };
}

/**
 * Converts the possible Proto types for numbers into a JavaScript number.
 * Returns 0 if the value is not numeric.
 */ function me(t) {
    // TODO(bjornick): Handle int64 greater than 53 bits.
    return "number" == typeof t ? t : "string" == typeof t ? Number(t) : 0;
}

/** Converts the possible Proto types for Blobs into a ByteString. */ function Te(t) {
    return "string" == typeof t ? ot.fromBase64String(t) : ot.fromUint8Array(t);
}

/** Returns a reference value for the provided database and key. */ function Ee(t, e) {
    return {
        referenceValue: `projects/${t.projectId}/databases/${t.database}/documents/${e.path.R()}`
    };
}

/** Returns true if `value` is an IntegerValue . */ function Ie(t) {
    return !!t && "integerValue" in t;
}

/** Returns true if `value` is a DoubleValue. */
/** Returns true if `value` is an ArrayValue. */
function Ae(t) {
    return !!t && "arrayValue" in t;
}

/** Returns true if `value` is a NullValue. */ function Re(t) {
    return !!t && "nullValue" in t;
}

/** Returns true if `value` is NaN. */ function ge(t) {
    return !!t && "doubleValue" in t && isNaN(Number(t.doubleValue));
}

/** Returns true if `value` is a MapValue. */ function Pe(t) {
    return !!t && "mapValue" in t;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ const ye = (() => {
    const t = {
        asc: "ASCENDING",
        desc: "DESCENDING"
    };
    return t;
})(), Ve = (() => {
    const t = {
        "<": "LESS_THAN",
        "<=": "LESS_THAN_OR_EQUAL",
        ">": "GREATER_THAN",
        ">=": "GREATER_THAN_OR_EQUAL",
        "==": "EQUAL",
        "!=": "NOT_EQUAL",
        "array-contains": "ARRAY_CONTAINS",
        in: "IN",
        "not-in": "NOT_IN",
        "array-contains-any": "ARRAY_CONTAINS_ANY"
    };
    return t;
})();

/**
 * This class generates JsonObject values for the Datastore API suitable for
 * sending to either GRPC stub methods or via the JSON/HTTP REST API.
 *
 * The serializer supports both Protobuf.js and Proto3 JSON formats. By
 * setting `useProto3Json` to true, the serializer will use the Proto3 JSON
 * format.
 *
 * For a description of the Proto3 JSON format check
 * https://developers.google.com/protocol-buffers/docs/proto3#json
 *
 * TODO(klimt): We can remove the databaseId argument if we keep the full
 * resource name in documents.
 */
class pe {
    constructor(t, e) {
        this.U = t, this.Qe = e;
    }
}

/**
 * Returns an IntegerValue for `value`.
 */
function be(t) {
    return {
        integerValue: "" + t
    };
}

/**
 * Returns an DoubleValue for `value` that is encoded based the serializer's
 * `useProto3Json` setting.
 */ function ve(t, e) {
    if (t.Qe) {
        if (isNaN(e)) return {
            doubleValue: "NaN"
        };
        if (e === 1 / 0) return {
            doubleValue: "Infinity"
        };
        if (e === -1 / 0) return {
            doubleValue: "-Infinity"
        };
    }
    return {
        doubleValue: Tt(e) ? "-0" : e
    };
}

/**
 * Returns a value for a number that's appropriate to put into a proto.
 * The return value is an IntegerValue if it can safely represent the value,
 * otherwise a DoubleValue is returned.
 */ function Se(t, e) {
    return Et(e) ? be(e) : ve(t, e);
}

/**
 * Returns a value for a Date that's appropriate to put into a proto.
 */ function De(t, e) {
    if (t.Qe) {
        return `${new Date(1e3 * e.seconds).toISOString().replace(/\.\d*/, "").replace("Z", "")}.${("000000000" + e.nanoseconds).slice(-9)}Z`;
    }
    return {
        seconds: "" + e.seconds,
        nanos: e.nanoseconds
    };
}

/**
 * Returns a value for bytes that's appropriate to put in a proto.
 *
 * Visible for testing.
 */
function Ce(t, e) {
    return t.Qe ? e.toBase64() : e.toUint8Array();
}

/**
 * Returns a ByteString based on the proto string value.
 */ function Ne(t, e) {
    return De(t, e.Z());
}

function Fe(t) {
    return V(!!t), wt.J(function(t) {
        const e = we(t);
        return new dt(e.seconds, e.nanos);
    }(t));
}

function xe(t, e) {
    return function(t) {
        return new C([ "projects", t.projectId, "databases", t.database ]);
    }(t).child("documents").child(e).R();
}

function $e(t) {
    const e = C.g(t);
    return V(un(e)), e;
}

function ke(t, e) {
    return xe(t.U, e.path);
}

function Me(t, e) {
    const n = $e(e);
    return V(n.get(1) === t.U.projectId), V(!n.get(3) && !t.U.database || n.get(3) === t.U.database), 
    new x(qe(n));
}

function Oe(t, e) {
    return xe(t.U, e);
}

function Le(t) {
    const e = $e(t);
    // In v1beta1 queries for collections at the root did not have a trailing
    // "/documents". In v1 all resource paths contain "/documents". Preserve the
    // ability to read the v1beta1 form for compatibility with queries persisted
    // in the local target cache.
        return 4 === e.length ? C.P() : qe(e);
}

function Be(t) {
    return new C([ "projects", t.U.projectId, "databases", t.U.database ]).R();
}

function qe(t) {
    return V(t.length > 4 && "documents" === t.get(4)), t.u(5);
}

/** Creates a Document proto from key and fields (but no create/update time) */ function Ue(t, e, n) {
    return {
        name: ke(t, e),
        fields: n.proto.mapValue.fields
    };
}

function Qe(t, e) {
    return "found" in e ? function(t, e) {
        V(!!e.found), e.found.name, e.found.updateTime;
        const n = Me(t, e.found.name), s = Fe(e.found.updateTime), i = new Un({
            mapValue: {
                fields: e.found.fields
            }
        });
        return new Kn(n, s, i, {});
    }(t, e) : "missing" in e ? function(t, e) {
        V(!!e.missing), V(!!e.readTime);
        const n = Me(t, e.missing), s = Fe(e.readTime);
        return new Gn(n, s);
    }(t, e) : y();
}

function We(t, e) {
    let n;
    if ("targetChange" in e) {
        e.targetChange;
        // proto3 default value is unset in JSON (undefined), so use 'NO_CHANGE'
        // if unset
        const s = function(t) {
            return "NO_CHANGE" === t ? 0 /* NoChange */ : "ADD" === t ? 1 /* Added */ : "REMOVE" === t ? 2 /* Removed */ : "CURRENT" === t ? 3 /* Current */ : "RESET" === t ? 4 /* Reset */ : y();
        }(e.targetChange.targetChangeType || "NO_CHANGE"), i = e.targetChange.targetIds || [], r = function(t, e) {
            return t.Qe ? (V(void 0 === e || "string" == typeof e), ot.fromBase64String(e || "")) : (V(void 0 === e || e instanceof Uint8Array), 
            ot.fromUint8Array(e || new Uint8Array));
        }(t, e.targetChange.resumeToken), o = e.targetChange.cause, a = o && function(t) {
            const e = void 0 === t.code ? m.UNKNOWN : Dt(t.code);
            return new T(e, t.message || "");
        }
        /**
 * Returns a value for a number (or null) that's appropriate to put into
 * a google.protobuf.Int32Value proto.
 * DO NOT USE THIS FOR ANYTHING ELSE.
 * This method cheats. It's typed as returning "number" because that's what
 * our generated proto interfaces say Int32Value must be. But GRPC actually
 * expects a { value: <number> } struct.
 */ (o);
        n = new Zt(s, i, r, a || null);
    } else if ("documentChange" in e) {
        e.documentChange;
        const s = e.documentChange;
        s.document, s.document.name, s.document.updateTime;
        const i = Me(t, s.document.name), r = Fe(s.document.updateTime), o = new Un({
            mapValue: {
                fields: s.document.fields
            }
        }), a = new Kn(i, r, o, {}), c = s.targetIds || [], u = s.removedTargetIds || [];
        n = new Jt(c, u, a.key, a);
    } else if ("documentDelete" in e) {
        e.documentDelete;
        const s = e.documentDelete;
        s.document;
        const i = Me(t, s.document), r = s.readTime ? Fe(s.readTime) : wt.min(), o = new Gn(i, r), a = s.removedTargetIds || [];
        n = new Jt([], a, o.key, o);
    } else if ("documentRemove" in e) {
        e.documentRemove;
        const s = e.documentRemove;
        s.document;
        const i = Me(t, s.document), r = s.removedTargetIds || [];
        n = new Jt([], r, i, null);
    } else {
        if (!("filter" in e)) return y();
        {
            e.filter;
            const t = e.filter;
            t.targetId;
            const s = t.count || 0, i = new pt(s), r = t.targetId;
            n = new Xt(r, i);
        }
    }
    return n;
}

function je(t, e) {
    let n;
    if (e instanceof xn) n = {
        update: Ue(t, e.key, e.value)
    }; else if (e instanceof Bn) n = {
        delete: ke(t, e.key)
    }; else if (e instanceof $n) n = {
        update: Ue(t, e.key, e.data),
        updateMask: cn(e.We)
    }; else if (e instanceof Mn) n = {
        transform: {
            document: ke(t, e.key),
            fieldTransforms: e.fieldTransforms.map((t => function(t, e) {
                const n = e.transform;
                if (n instanceof dn) return {
                    fieldPath: e.field.R(),
                    setToServerValue: "REQUEST_TIME"
                };
                if (n instanceof wn) return {
                    fieldPath: e.field.R(),
                    appendMissingElements: {
                        values: n.elements
                    }
                };
                if (n instanceof Tn) return {
                    fieldPath: e.field.R(),
                    removeAllFromArray: {
                        values: n.elements
                    }
                };
                if (n instanceof In) return {
                    fieldPath: e.field.R(),
                    increment: n.je
                };
                throw y();
            }(0, t)))
        }
    }; else {
        if (!(e instanceof qn)) return y();
        n = {
            verify: ke(t, e.key)
        };
    }
    return e.Ge.Ke || (n.currentDocument = function(t, e) {
        return void 0 !== e.updateTime ? {
            updateTime: Ne(t, e.updateTime)
        } : void 0 !== e.exists ? {
            exists: e.exists
        } : y();
    }(t, e.Ge)), n;
}

function Ke(t, e) {
    const n = e.currentDocument ? function(t) {
        return void 0 !== t.updateTime ? pn.updateTime(Fe(t.updateTime)) : void 0 !== t.exists ? pn.exists(t.exists) : pn.ze();
    }(e.currentDocument) : pn.ze();
    if (e.update) {
        e.update.name;
        const s = Me(t, e.update.name), i = new Un({
            mapValue: {
                fields: e.update.fields
            }
        });
        if (e.updateMask) {
            const t = function(t) {
                const e = t.fieldPaths || [];
                return new gn(e.map((t => F.S(t))));
            }(e.updateMask);
            return new $n(s, i, t, n);
        }
        return new xn(s, i, n);
    }
    if (e.delete) {
        const s = Me(t, e.delete);
        return new Bn(s, n);
    }
    if (e.transform) {
        const s = Me(t, e.transform.document), i = e.transform.fieldTransforms.map((e => function(t, e) {
            let n = null;
            if ("setToServerValue" in e) V("REQUEST_TIME" === e.setToServerValue), n = new dn; else if ("appendMissingElements" in e) {
                const t = e.appendMissingElements.values || [];
                n = new wn(t);
            } else if ("removeAllFromArray" in e) {
                const t = e.removeAllFromArray.values || [];
                n = new Tn(t);
            } else "increment" in e ? n = new In(t, e.increment) : y();
            const s = F.S(e.fieldPath);
            return new Pn(s, n);
        }(t, e)));
        return V(!0 === n.exists), new Mn(s, i);
    }
    if (e.verify) {
        const s = Me(t, e.verify);
        return new qn(s, n);
    }
    return y();
}

function Ge(t, e) {
    return t && t.length > 0 ? (V(void 0 !== e), t.map((t => function(t, e) {
        // NOTE: Deletes don't have an updateTime.
        let n = t.updateTime ? Fe(t.updateTime) : Fe(e);
        n.isEqual(wt.min()) && (
        // The Firestore Emulator currently returns an update time of 0 for
        // deletes of non-existing documents (rather than null). This breaks the
        // test "get deleted doc while offline with source=cache" as NoDocuments
        // with version 0 are filtered by IndexedDb's RemoteDocumentCache.
        // TODO(#2149): Remove this when Emulator is fixed
        n = Fe(e));
        let s = null;
        return t.transformResults && t.transformResults.length > 0 && (s = t.transformResults), 
        new Vn(n, s);
    }(t, e)))) : [];
}

function ze(t, e) {
    return {
        documents: [ Oe(t, e.path) ]
    };
}

function He(t, e) {
    // Dissect the path into parent, collectionId, and optional key filter.
    const n = {
        structuredQuery: {}
    }, s = e.path;
    null !== e.collectionGroup ? (n.parent = Oe(t, s), n.structuredQuery.from = [ {
        collectionId: e.collectionGroup,
        allDescendants: !0
    } ]) : (n.parent = Oe(t, s.h()), n.structuredQuery.from = [ {
        collectionId: s._()
    } ]);
    const i = function(t) {
        if (0 === t.length) return;
        const e = t.map((t => 
        // visible for testing
        function(t) {
            if ("==" /* EQUAL */ === t.op) {
                if (ge(t.value)) return {
                    unaryFilter: {
                        field: sn(t.field),
                        op: "IS_NAN"
                    }
                };
                if (Re(t.value)) return {
                    unaryFilter: {
                        field: sn(t.field),
                        op: "IS_NULL"
                    }
                };
            } else if ("!=" /* NOT_EQUAL */ === t.op) {
                if (ge(t.value)) return {
                    unaryFilter: {
                        field: sn(t.field),
                        op: "IS_NOT_NAN"
                    }
                };
                if (Re(t.value)) return {
                    unaryFilter: {
                        field: sn(t.field),
                        op: "IS_NOT_NULL"
                    }
                };
            }
            return {
                fieldFilter: {
                    field: sn(t.field),
                    op: nn(t.op),
                    value: t.value
                }
            };
        }(t)));
        if (1 === e.length) return e[0];
        return {
            compositeFilter: {
                op: "AND",
                filters: e
            }
        };
    }(e.filters);
    i && (n.structuredQuery.where = i);
    const r = function(t) {
        if (0 === t.length) return;
        return t.map((t => 
        // visible for testing
        function(t) {
            return {
                field: sn(t.field),
                direction: en(t.dir)
            };
        }(t)));
    }(e.orderBy);
    r && (n.structuredQuery.orderBy = r);
    const o = function(t, e) {
        return t.Qe || mt(e) ? e : {
            value: e
        };
    }
    /**
 * Returns a number (or null) from a google.protobuf.Int32Value proto.
 */ (t, e.limit);
    return null !== o && (n.structuredQuery.limit = o), e.startAt && (n.structuredQuery.startAt = Ze(e.startAt)), 
    e.endAt && (n.structuredQuery.endAt = Ze(e.endAt)), n;
}

function Ye(t) {
    let e = Le(t.parent);
    const n = t.structuredQuery, s = n.from ? n.from.length : 0;
    let i = null;
    if (s > 0) {
        V(1 === s);
        const t = n.from[0];
        t.allDescendants ? i = t.collectionId : e = e.child(t.collectionId);
    }
    let r = [];
    n.where && (r = Xe(n.where));
    let o = [];
    n.orderBy && (o = n.orderBy.map((t => function(t) {
        return new bs(rn(t.field), 
        // visible for testing
        function(t) {
            switch (t) {
              case "ASCENDING":
                return "asc" /* ASCENDING */;

              case "DESCENDING":
                return "desc" /* DESCENDING */;

              default:
                return;
            }
        }
        // visible for testing
        (t.direction));
    }(t))));
    let a = null;
    n.limit && (a = function(t) {
        let e;
        return e = "object" == typeof t ? t.value : t, mt(e) ? null : e;
    }(n.limit));
    let c = null;
    n.startAt && (c = tn(n.startAt));
    let u = null;
    return n.endAt && (u = tn(n.endAt)), is(Yn(e, i, o, r, a, "F" /* First */ , c, u));
}

function Je(t, e) {
    const n = function(t, e) {
        switch (e) {
          case 0 /* Listen */ :
            return null;

          case 1 /* ExistenceFilterMismatch */ :
            return "existence-filter-mismatch";

          case 2 /* LimboResolution */ :
            return "limbo-document";

          default:
            return y();
        }
    }(0, e.et);
    return null == n ? null : {
        "goog-listen-tags": n
    };
}

function Xe(t) {
    return t ? void 0 !== t.unaryFilter ? [ an(t) ] : void 0 !== t.fieldFilter ? [ on(t) ] : void 0 !== t.compositeFilter ? t.compositeFilter.filters.map((t => Xe(t))).reduce(((t, e) => t.concat(e))) : y() : [];
}

function Ze(t) {
    return {
        before: t.before,
        values: t.position
    };
}

function tn(t) {
    const e = !!t.before, n = t.values || [];
    return new Ps(n, e);
}

// visible for testing
function en(t) {
    return ye[t];
}

function nn(t) {
    return Ve[t];
}

function sn(t) {
    return {
        fieldPath: t.R()
    };
}

function rn(t) {
    return F.S(t.fieldPath);
}

function on(t) {
    return fs.create(rn(t.fieldFilter.field), function(t) {
        switch (t) {
          case "EQUAL":
            return "==" /* EQUAL */;

          case "NOT_EQUAL":
            return "!=" /* NOT_EQUAL */;

          case "GREATER_THAN":
            return ">" /* GREATER_THAN */;

          case "GREATER_THAN_OR_EQUAL":
            return ">=" /* GREATER_THAN_OR_EQUAL */;

          case "LESS_THAN":
            return "<" /* LESS_THAN */;

          case "LESS_THAN_OR_EQUAL":
            return "<=" /* LESS_THAN_OR_EQUAL */;

          case "ARRAY_CONTAINS":
            return "array-contains" /* ARRAY_CONTAINS */;

          case "IN":
            return "in" /* IN */;

          case "NOT_IN":
            return "not-in" /* NOT_IN */;

          case "ARRAY_CONTAINS_ANY":
            return "array-contains-any" /* ARRAY_CONTAINS_ANY */;

          case "OPERATOR_UNSPECIFIED":
          default:
            return y();
        }
    }(t.fieldFilter.op), t.fieldFilter.value);
}

function an(t) {
    switch (t.unaryFilter.op) {
      case "IS_NAN":
        const e = rn(t.unaryFilter.field);
        return fs.create(e, "==" /* EQUAL */ , {
            doubleValue: NaN
        });

      case "IS_NULL":
        const n = rn(t.unaryFilter.field);
        return fs.create(n, "==" /* EQUAL */ , {
            nullValue: "NULL_VALUE"
        });

      case "IS_NOT_NAN":
        const s = rn(t.unaryFilter.field);
        return fs.create(s, "!=" /* NOT_EQUAL */ , {
            doubleValue: NaN
        });

      case "IS_NOT_NULL":
        const i = rn(t.unaryFilter.field);
        return fs.create(i, "!=" /* NOT_EQUAL */ , {
            nullValue: "NULL_VALUE"
        });

      case "OPERATOR_UNSPECIFIED":
      default:
        return y();
    }
}

function cn(t) {
    const e = [];
    return t.fields.forEach((t => e.push(t.R()))), {
        fieldPaths: e
    };
}

function un(t) {
    // Resource names have at least 4 components (project ID, database ID)
    return t.length >= 4 && "projects" === t.get(0) && "databases" === t.get(2);
}

/**
 * @license
 * Copyright 2018 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** Represents a transform within a TransformMutation. */ class hn {
    constructor() {
        // Make sure that the structural type of `TransformOperation` is unique.
        // See https://github.com/microsoft/TypeScript/issues/5451
        this.He = void 0;
    }
}

/**
 * Computes the local transform result against the provided `previousValue`,
 * optionally using the provided localWriteTime.
 */ function ln(t, e, n) {
    return t instanceof dn ? function(t, e) {
        const n = {
            fields: {
                __type__: {
                    stringValue: "server_timestamp"
                },
                __local_write_time__: {
                    timestampValue: {
                        seconds: t.seconds,
                        nanos: t.nanoseconds
                    }
                }
            }
        };
        return e && (n.fields.__previous_value__ = e), {
            mapValue: n
        };
    }(n, e) : t instanceof wn ? mn(t, e) : t instanceof Tn ? En(t, e) : function(t, e) {
        // PORTING NOTE: Since JavaScript's integer arithmetic is limited to 53 bit
        // precision and resolves overflows by reducing precision, we do not
        // manually cap overflows at 2^63.
        const n = fn(t, e), s = An(n) + An(t.je);
        return Ie(n) && Ie(t.je) ? be(s) : ve(t.serializer, s);
    }(t, e);
}

/**
 * Computes a final transform result after the transform has been acknowledged
 * by the server, potentially using the server-provided transformResult.
 */ function _n(t, e, n) {
    // The server just sends null as the transform result for array operations,
    // so we have to calculate a result the same as we do for local
    // applications.
    return t instanceof wn ? mn(t, e) : t instanceof Tn ? En(t, e) : n;
}

/**
 * If this transform operation is not idempotent, returns the base value to
 * persist for this transform. If a base value is returned, the transform
 * operation is always applied to this base value, even if document has
 * already been updated.
 *
 * Base values provide consistent behavior for non-idempotent transforms and
 * allow us to return the same latency-compensated value even if the backend
 * has already applied the transform operation. The base value is null for
 * idempotent transforms, as they can be re-played even if the backend has
 * already applied them.
 *
 * @return a base value to store along with the mutation, or null for
 * idempotent transforms.
 */ function fn(t, e) {
    return t instanceof In ? Ie(n = e) || function(t) {
        return !!t && "doubleValue" in t;
    }
    /** Returns true if `value` is either an IntegerValue or a DoubleValue. */ (n) ? e : {
        integerValue: 0
    } : null;
    var n;
}

/** Transforms a value into a server-generated timestamp. */
class dn extends hn {}

/** Transforms an array value via a union operation. */ class wn extends hn {
    constructor(t) {
        super(), this.elements = t;
    }
}

function mn(t, e) {
    const n = Rn(e);
    for (const e of t.elements) n.some((t => ue(t, e))) || n.push(e);
    return {
        arrayValue: {
            values: n
        }
    };
}

/** Transforms an array value via a remove operation. */ class Tn extends hn {
    constructor(t) {
        super(), this.elements = t;
    }
}

function En(t, e) {
    let n = Rn(e);
    for (const e of t.elements) n = n.filter((t => !ue(t, e)));
    return {
        arrayValue: {
            values: n
        }
    };
}

/**
 * Implements the backend semantics for locally computed NUMERIC_ADD (increment)
 * transforms. Converts all field values to integers or doubles, but unlike the
 * backend does not cap integer values at 2^63. Instead, JavaScript number
 * arithmetic is used and precision loss can occur for values greater than 2^53.
 */ class In extends hn {
    constructor(t, e) {
        super(), this.serializer = t, this.je = e;
    }
}

function An(t) {
    return me(t.integerValue || t.doubleValue);
}

function Rn(t) {
    return Ae(t) && t.arrayValue.values ? t.arrayValue.values.slice() : [];
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Provides a set of fields that can be used to partially patch a document.
 * FieldMask is used in conjunction with ObjectValue.
 * Examples:
 *   foo - Overwrites foo entirely with the provided value. If foo is not
 *         present in the companion ObjectValue, the field is deleted.
 *   foo.bar - Overwrites only the field bar of the object foo.
 *             If foo is not an object, foo is replaced with an object
 *             containing foo
 */ class gn {
    constructor(t) {
        this.fields = t, 
        // TODO(dimond): validation of FieldMask
        // Sort the field mask to support `FieldMask.isEqual()` and assert below.
        t.sort(F.i);
    }
    /**
     * Verifies that `fieldPath` is included by at least one field in this field
     * mask.
     *
     * This is an O(n) operation, where `n` is the size of the field mask.
     */    Ye(t) {
        for (const e of this.fields) if (e.T(t)) return !0;
        return !1;
    }
    isEqual(t) {
        return it(this.fields, t.fields, ((t, e) => t.isEqual(e)));
    }
}

/** A field path and the TransformOperation to perform upon it. */ class Pn {
    constructor(t, e) {
        this.field = t, this.transform = e;
    }
}

function yn(t, e) {
    return t.field.isEqual(e.field) && function(t, e) {
        return t instanceof wn && e instanceof wn || t instanceof Tn && e instanceof Tn ? it(t.elements, e.elements, ue) : t instanceof In && e instanceof In ? ue(t.je, e.je) : t instanceof dn && e instanceof dn;
    }(t.transform, e.transform);
}

/** The result of successfully applying a mutation to the backend. */ class Vn {
    constructor(
    /**
     * The version at which the mutation was committed:
     *
     * - For most operations, this is the updateTime in the WriteResult.
     * - For deletes, the commitTime of the WriteResponse (because deletes are
     *   not stored and have no updateTime).
     *
     * Note that these versions can be different: No-op writes will not change
     * the updateTime even though the commitTime advances.
     */
    t, 
    /**
     * The resulting fields returned from the backend after a
     * TransformMutation has been committed. Contains one FieldValue for each
     * FieldTransform that was in the mutation.
     *
     * Will be null if the mutation was not a TransformMutation.
     */
    e) {
        this.version = t, this.transformResults = e;
    }
}

/**
 * Encodes a precondition for a mutation. This follows the model that the
 * backend accepts with the special case of an explicit "empty" precondition
 * (meaning no precondition).
 */ class pn {
    constructor(t, e) {
        this.updateTime = t, this.exists = e;
    }
    /** Creates a new empty Precondition. */    static ze() {
        return new pn;
    }
    /** Creates a new Precondition with an exists flag. */    static exists(t) {
        return new pn(void 0, t);
    }
    /** Creates a new Precondition based on a version a document exists at. */    static updateTime(t) {
        return new pn(t);
    }
    /** Returns whether this Precondition is empty. */    get Ke() {
        return void 0 === this.updateTime && void 0 === this.exists;
    }
    isEqual(t) {
        return this.exists === t.exists && (this.updateTime ? !!t.updateTime && this.updateTime.isEqual(t.updateTime) : !t.updateTime);
    }
}

/**
 * Returns true if the preconditions is valid for the given document
 * (or null if no document is available).
 */ function bn(t, e) {
    return void 0 !== t.updateTime ? e instanceof Kn && e.version.isEqual(t.updateTime) : void 0 === t.exists || t.exists === e instanceof Kn;
}

/**
 * A mutation describes a self-contained change to a document. Mutations can
 * create, replace, delete, and update subsets of documents.
 *
 * Mutations not only act on the value of the document but also its version.
 *
 * For local mutations (mutations that haven't been committed yet), we preserve
 * the existing version for Set, Patch, and Transform mutations. For Delete
 * mutations, we reset the version to 0.
 *
 * Here's the expected transition table.
 *
 * MUTATION           APPLIED TO            RESULTS IN
 *
 * SetMutation        Document(v3)          Document(v3)
 * SetMutation        NoDocument(v3)        Document(v0)
 * SetMutation        null                  Document(v0)
 * PatchMutation      Document(v3)          Document(v3)
 * PatchMutation      NoDocument(v3)        NoDocument(v3)
 * PatchMutation      null                  null
 * TransformMutation  Document(v3)          Document(v3)
 * TransformMutation  NoDocument(v3)        NoDocument(v3)
 * TransformMutation  null                  null
 * DeleteMutation     Document(v3)          NoDocument(v0)
 * DeleteMutation     NoDocument(v3)        NoDocument(v0)
 * DeleteMutation     null                  NoDocument(v0)
 *
 * For acknowledged mutations, we use the updateTime of the WriteResponse as
 * the resulting version for Set, Patch, and Transform mutations. As deletes
 * have no explicit update time, we use the commitTime of the WriteResponse for
 * Delete mutations.
 *
 * If a mutation is acknowledged by the backend but fails the precondition check
 * locally, we return an `UnknownDocument` and rely on Watch to send us the
 * updated version.
 *
 * Note that TransformMutations don't create Documents (in the case of being
 * applied to a NoDocument), even though they would on the backend. This is
 * because the client always combines the TransformMutation with a SetMutation
 * or PatchMutation and we only want to apply the transform if the prior
 * mutation resulted in a Document (always true for a SetMutation, but not
 * necessarily for a PatchMutation).
 *
 * ## Subclassing Notes
 *
 * Subclasses of Mutation need to implement applyToRemoteDocument() and
 * applyToLocalView() to implement the actual behavior of applying the mutation
 * to some source document.
 */ class vn {}

/**
 * Applies this mutation to the given MaybeDocument or null for the purposes
 * of computing a new remote document. If the input document doesn't match the
 * expected state (e.g. it is null or outdated), an `UnknownDocument` can be
 * returned.
 *
 * @param mutation The mutation to apply.
 * @param maybeDoc The document to mutate. The input document can be null if
 *     the client has no knowledge of the pre-mutation state of the document.
 * @param mutationResult The result of applying the mutation from the backend.
 * @return The mutated document. The returned document may be an
 *     UnknownDocument if the mutation could not be applied to the locally
 *     cached base document.
 */ function Sn(t, e, n) {
    return t instanceof xn ? function(t, e, n) {
        // Unlike applySetMutationToLocalView, if we're applying a mutation to a
        // remote document the server has accepted the mutation so the precondition
        // must have held.
        return new Kn(t.key, n.version, t.value, {
            hasCommittedMutations: !0
        });
    }(t, 0, n) : t instanceof $n ? function(t, e, n) {
        if (!bn(t.Ge, e)) 
        // Since the mutation was not rejected, we know that the  precondition
        // matched on the backend. We therefore must not have the expected version
        // of the document in our cache and return an UnknownDocument with the
        // known updateTime.
        return new zn(t.key, n.version);
        const s = kn(t, e);
        return new Kn(t.key, n.version, s, {
            hasCommittedMutations: !0
        });
    }(t, e, n) : t instanceof Mn ? function(t, e, n) {
        if (V(null != n.transformResults), !bn(t.Ge, e)) 
        // Since the mutation was not rejected, we know that the  precondition
        // matched on the backend. We therefore must not have the expected version
        // of the document in our cache and return an UnknownDocument with the
        // known updateTime.
        return new zn(t.key, n.version);
        const s = On(t, e), i = 
        /**
 * Creates a list of "transform results" (a transform result is a field value
 * representing the result of applying a transform) for use after a
 * TransformMutation has been acknowledged by the server.
 *
 * @param fieldTransforms The field transforms to apply the result to.
 * @param baseDoc The document prior to applying this mutation batch.
 * @param serverTransformResults The transform results received by the server.
 * @return The transform results list.
 */
        function(t, e, n) {
            const s = [];
            V(t.length === n.length);
            for (let i = 0; i < n.length; i++) {
                const r = t[i], o = r.transform;
                let a = null;
                e instanceof Kn && (a = e.field(r.field)), s.push(_n(o, a, n[i]));
            }
            return s;
        }
        /**
 * Creates a list of "transform results" (a transform result is a field value
 * representing the result of applying a transform) for use when applying a
 * TransformMutation locally.
 *
 * @param fieldTransforms The field transforms to apply the result to.
 * @param localWriteTime The local time of the transform mutation (used to
 *     generate ServerTimestampValues).
 * @param maybeDoc The current state of the document after applying all
 *     previous mutations.
 * @param baseDoc The document prior to applying this mutation batch.
 * @return The transform results list.
 */ (t.fieldTransforms, e, n.transformResults), r = n.version, o = Ln(t, s.data(), i);
        return new Kn(t.key, r, o, {
            hasCommittedMutations: !0
        });
    }(t, e, n) : function(t, e, n) {
        // Unlike applyToLocalView, if we're applying a mutation to a remote
        // document the server has accepted the mutation so the precondition must
        // have held.
        return new Gn(t.key, n.version, {
            hasCommittedMutations: !0
        });
    }(t, 0, n);
}

/**
 * Applies this mutation to the given MaybeDocument or null for the purposes
 * of computing the new local view of a document. Both the input and returned
 * documents can be null.
 *
 * @param mutation The mutation to apply.
 * @param maybeDoc The document to mutate. The input document can be null if
 *     the client has no knowledge of the pre-mutation state of the document.
 * @param baseDoc The state of the document prior to this mutation batch. The
 *     input document can be null if the client has no knowledge of the
 *     pre-mutation state of the document.
 * @param localWriteTime A timestamp indicating the local write time of the
 *     batch this mutation is a part of.
 * @return The mutated document. The returned document may be null, but only
 *     if maybeDoc was null and the mutation would not create a new document.
 */ function Dn(t, e, n, s) {
    return t instanceof xn ? function(t, e) {
        if (!bn(t.Ge, e)) return e;
        const n = Fn(e);
        return new Kn(t.key, n, t.value, {
            Je: !0
        });
    }
    /**
 * A mutation that modifies fields of the document at the given key with the
 * given values. The values are applied through a field mask:
 *
 *  * When a field is in both the mask and the values, the corresponding field
 *    is updated.
 *  * When a field is in neither the mask nor the values, the corresponding
 *    field is unmodified.
 *  * When a field is in the mask but not in the values, the corresponding field
 *    is deleted.
 *  * When a field is not in the mask but is in the values, the values map is
 *    ignored.
 */ (t, e) : t instanceof $n ? function(t, e) {
        if (!bn(t.Ge, e)) return e;
        const n = Fn(e), s = kn(t, e);
        return new Kn(t.key, n, s, {
            Je: !0
        });
    }
    /**
 * Patches the data of document if available or creates a new document. Note
 * that this does not check whether or not the precondition of this patch
 * holds.
 */ (t, e) : t instanceof Mn ? function(t, e, n, s) {
        if (!bn(t.Ge, e)) return e;
        const i = On(t, e), r = function(t, e, n, s) {
            const i = [];
            for (const r of t) {
                const t = r.transform;
                let o = null;
                n instanceof Kn && (o = n.field(r.field)), null === o && s instanceof Kn && (
                // If the current document does not contain a value for the mutated
                // field, use the value that existed before applying this mutation
                // batch. This solves an edge case where a PatchMutation clears the
                // values in a nested map before the TransformMutation is applied.
                o = s.field(r.field)), i.push(ln(t, o, e));
            }
            return i;
        }(t.fieldTransforms, n, e, s), o = Ln(t, i.data(), r);
        return new Kn(t.key, i.version, o, {
            Je: !0
        });
    }(t, e, s, n) : function(t, e) {
        if (!bn(t.Ge, e)) return e;
        return new Gn(t.key, wt.min());
    }
    /**
 * A mutation that verifies the existence of the document at the given key with
 * the provided precondition.
 *
 * The `verify` operation is only used in Transactions, and this class serves
 * primarily to facilitate serialization into protos.
 */ (t, e);
}

/**
 * If this mutation is not idempotent, returns the base value to persist with
 * this mutation. If a base value is returned, the mutation is always applied
 * to this base value, even if document has already been updated.
 *
 * The base value is a sparse object that consists of only the document
 * fields for which this mutation contains a non-idempotent transformation
 * (e.g. a numeric increment). The provided value guarantees consistent
 * behavior for non-idempotent transforms and allow us to return the same
 * latency-compensated value even if the backend has already applied the
 * mutation. The base value is null for idempotent mutations, as they can be
 * re-played even if the backend has already applied them.
 *
 * @return a base value to store along with the mutation, or null for
 * idempotent mutations.
 */ function Cn(t, e) {
    return t instanceof Mn ? function(t, e) {
        let n = null;
        for (const s of t.fieldTransforms) {
            const t = e instanceof Kn ? e.field(s.field) : void 0, i = fn(s.transform, t || null);
            null != i && (n = null == n ? (new Qn).set(s.field, i) : n.set(s.field, i));
        }
        return n ? n.Xe() : null;
    }
    /**
 * Asserts that the given MaybeDocument is actually a Document and verifies
 * that it matches the key for this mutation. Since we only support
 * transformations with precondition exists this method is guaranteed to be
 * safe.
 */ (t, e) : null;
}

function Nn(t, e) {
    return t.type === e.type && (!!t.key.isEqual(e.key) && (!!t.Ge.isEqual(e.Ge) && (0 /* Set */ === t.type ? t.value.isEqual(e.value) : 1 /* Patch */ === t.type ? t.data.isEqual(e.data) && t.We.isEqual(e.We) : 2 /* Transform */ !== t.type || it(t.fieldTransforms, t.fieldTransforms, ((t, e) => yn(t, e))))));
}

/**
 * Returns the version from the given document for use as the result of a
 * mutation. Mutations are defined to return the version of the base document
 * only if it is an existing document. Deleted and unknown documents have a
 * post-mutation version of SnapshotVersion.min().
 */ function Fn(t) {
    return t instanceof Kn ? t.version : wt.min();
}

/**
 * A mutation that creates or replaces the document at the given key with the
 * object value contents.
 */ class xn extends vn {
    constructor(t, e, n) {
        super(), this.key = t, this.value = e, this.Ge = n, this.type = 0 /* Set */;
    }
}

class $n extends vn {
    constructor(t, e, n, s) {
        super(), this.key = t, this.data = e, this.We = n, this.Ge = s, this.type = 1 /* Patch */;
    }
}

function kn(t, e) {
    let n;
    return n = e instanceof Kn ? e.data() : Un.empty(), function(t, e) {
        const n = new Qn(e);
        return t.We.fields.forEach((e => {
            if (!e.m()) {
                const s = t.data.field(e);
                null !== s ? n.set(e, s) : n.delete(e);
            }
        })), n.Xe();
    }
    /**
 * A mutation that modifies specific fields of the document with transform
 * operations. Currently the only supported transform is a server timestamp, but
 * IP Address, increment(n), etc. could be supported in the future.
 *
 * It is somewhat similar to a PatchMutation in that it patches specific fields
 * and has no effect when applied to a null or NoDocument (see comment on
 * Mutation for rationale).
 */ (t, n);
}

class Mn extends vn {
    constructor(t, e) {
        super(), this.key = t, this.fieldTransforms = e, this.type = 2 /* Transform */ , 
        // NOTE: We set a precondition of exists: true as a safety-check, since we
        // always combine TransformMutations with a SetMutation or PatchMutation which
        // (if successful) should end up with an existing document.
        this.Ge = pn.exists(!0);
    }
}

function On(t, e) {
    return e;
}

function Ln(t, e, n) {
    const s = new Qn(e);
    for (let e = 0; e < t.fieldTransforms.length; e++) {
        const i = t.fieldTransforms[e];
        s.set(i.field, n[e]);
    }
    return s.Xe();
}

/** A mutation that deletes the document at the given key. */ class Bn extends vn {
    constructor(t, e) {
        super(), this.key = t, this.Ge = e, this.type = 3 /* Delete */;
    }
}

class qn extends vn {
    constructor(t, e) {
        super(), this.key = t, this.Ge = e, this.type = 4 /* Verify */;
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * An ObjectValue represents a MapValue in the Firestore Proto and offers the
 * ability to add and remove fields (via the ObjectValueBuilder).
 */ class Un {
    constructor(t) {
        this.proto = t;
    }
    static empty() {
        return new Un({
            mapValue: {}
        });
    }
    /**
     * Returns the value at the given path or null.
     *
     * @param path the path to search
     * @return The value at the path or if there it doesn't exist.
     */    field(t) {
        if (t.m()) return this.proto;
        {
            let e = this.proto;
            for (let n = 0; n < t.length - 1; ++n) {
                if (!e.mapValue.fields) return null;
                if (e = e.mapValue.fields[t.get(n)], !Pe(e)) return null;
            }
            return e = (e.mapValue.fields || {})[t._()], e || null;
        }
    }
    isEqual(t) {
        return ue(this.proto, t.proto);
    }
}

/**
 * An ObjectValueBuilder provides APIs to set and delete fields from an
 * ObjectValue.
 */ class Qn {
    /**
     * @param baseObject The object to mutate.
     */
    constructor(t = Un.empty()) {
        this.Ze = t, 
        /** A map that contains the accumulated changes in this builder. */
        this.tn = new Map;
    }
    /**
     * Sets the field to the provided value.
     *
     * @param path The field path to set.
     * @param value The value to set.
     * @return The current Builder instance.
     */    set(t, e) {
        return this.en(t, e), this;
    }
    /**
     * Removes the field at the specified path. If there is no field at the
     * specified path, nothing is changed.
     *
     * @param path The field path to remove.
     * @return The current Builder instance.
     */    delete(t) {
        return this.en(t, null), this;
    }
    /**
     * Adds `value` to the overlay map at `path`. Creates nested map entries if
     * needed.
     */    en(t, e) {
        let n = this.tn;
        for (let e = 0; e < t.length - 1; ++e) {
            const s = t.get(e);
            let i = n.get(s);
            i instanceof Map ? 
            // Re-use a previously created map
            n = i : i && 10 /* ObjectValue */ === ce(i) ? (
            // Convert the existing Protobuf MapValue into a map
            i = new Map(Object.entries(i.mapValue.fields || {})), n.set(s, i), n = i) : (
            // Create an empty map to represent the current nesting level
            i = new Map, n.set(s, i), n = i);
        }
        n.set(t._(), e);
    }
    /** Returns an ObjectValue with all mutations applied. */    Xe() {
        const t = this.nn(F.P(), this.tn);
        return null != t ? new Un(t) : this.Ze;
    }
    /**
     * Applies any overlays from `currentOverlays` that exist at `currentPath`
     * and returns the merged data at `currentPath` (or null if there were no
     * changes).
     *
     * @param currentPath The path at the current nesting level. Can be set to
     * FieldValue.emptyPath() to represent the root.
     * @param currentOverlays The overlays at the current nesting level in the
     * same format as `overlayMap`.
     * @return The merged data at `currentPath` or null if no modifications
     * were applied.
     */    nn(t, e) {
        let n = !1;
        const s = this.Ze.field(t), i = Pe(s) ? // If there is already data at the current path, base our
        Object.assign({}, s.mapValue.fields) : {};
        return e.forEach(((e, s) => {
            if (e instanceof Map) {
                const r = this.nn(t.child(s), e);
                null != r && (i[s] = r, n = !0);
            } else null !== e ? (i[s] = e, n = !0) : i.hasOwnProperty(s) && (delete i[s], n = !0);
        })), n ? {
            mapValue: {
                fields: i
            }
        } : null;
    }
}

/**
 * Returns a FieldMask built from all fields in a MapValue.
 */ function Wn(t) {
    const e = [];
    return v(t.fields || {}, ((t, n) => {
        const s = new F([ t ]);
        if (Pe(n)) {
            const t = Wn(n.mapValue).fields;
            if (0 === t.length) 
            // Preserve the empty map by adding it to the FieldMask.
            e.push(s); else 
            // For nested and non-empty ObjectValues, add the FieldPath of the
            // leaf nodes.
            for (const n of t) e.push(s.child(n));
        } else 
        // For nested and non-empty ObjectValues, add the FieldPath of the leaf
        // nodes.
        e.push(s);
    })), new gn(e);
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * The result of a lookup for a given path may be an existing document or a
 * marker that this document does not exist at a given version.
 */ class jn {
    constructor(t, e) {
        this.key = t, this.version = e;
    }
}

/**
 * Represents a document in Firestore with a key, version, data and whether the
 * data has local mutations applied to it.
 */ class Kn extends jn {
    constructor(t, e, n, s) {
        super(t, e), this.sn = n, this.Je = !!s.Je, this.hasCommittedMutations = !!s.hasCommittedMutations;
    }
    field(t) {
        return this.sn.field(t);
    }
    data() {
        return this.sn;
    }
    rn() {
        return this.sn.proto;
    }
    isEqual(t) {
        return t instanceof Kn && this.key.isEqual(t.key) && this.version.isEqual(t.version) && this.Je === t.Je && this.hasCommittedMutations === t.hasCommittedMutations && this.sn.isEqual(t.sn);
    }
    toString() {
        return `Document(${this.key}, ${this.version}, ${this.sn.toString()}, {hasLocalMutations: ${this.Je}}), {hasCommittedMutations: ${this.hasCommittedMutations}})`;
    }
    get hasPendingWrites() {
        return this.Je || this.hasCommittedMutations;
    }
}

/**
 * Compares the value for field `field` in the provided documents. Throws if
 * the field does not exist in both documents.
 */
/**
 * A class representing a deleted document.
 * Version is set to 0 if we don't point to any specific time, otherwise it
 * denotes time we know it didn't exist at.
 */
class Gn extends jn {
    constructor(t, e, n) {
        super(t, e), this.hasCommittedMutations = !(!n || !n.hasCommittedMutations);
    }
    toString() {
        return `NoDocument(${this.key}, ${this.version})`;
    }
    get hasPendingWrites() {
        return this.hasCommittedMutations;
    }
    isEqual(t) {
        return t instanceof Gn && t.hasCommittedMutations === this.hasCommittedMutations && t.version.isEqual(this.version) && t.key.isEqual(this.key);
    }
}

/**
 * A class representing an existing document whose data is unknown (e.g. a
 * document that was updated without a known base document).
 */ class zn extends jn {
    toString() {
        return `UnknownDocument(${this.key}, ${this.version})`;
    }
    get hasPendingWrites() {
        return !0;
    }
    isEqual(t) {
        return t instanceof zn && t.version.isEqual(this.version) && t.key.isEqual(this.key);
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Query encapsulates all the query attributes we support in the SDK. It can
 * be run against the LocalStore, as well as be converted to a `Target` to
 * query the RemoteStore results.
 *
 * Visible for testing.
 */ class Hn {
    /**
     * Initializes a Query with a path and optional additional query constraints.
     * Path must currently be empty if this is a collection group query.
     */
    constructor(t, e = null, n = [], s = [], i = null, r = "F" /* First */ , o = null, a = null) {
        this.path = t, this.collectionGroup = e, this.on = n, this.filters = s, this.limit = i, 
        this.an = r, this.startAt = o, this.endAt = a, this.cn = null, 
        // The corresponding `Target` of this `Query` instance.
        this.un = null, this.startAt, this.endAt;
    }
}

/** Creates a new Query instance with the options provided. */ function Yn(t, e, n, s, i, r, o, a) {
    return new Hn(t, e, n, s, i, r, o, a);
}

/** Creates a new Query for a query that matches all documents at `path` */ function Jn(t) {
    return new Hn(t);
}

/**
 * Helper to convert a collection group query into a collection query at a
 * specific path. This is used when executing collection group queries, since
 * we have to split the query into a set of collection queries at multiple
 * paths.
 */ function Xn(t) {
    return !mt(t.limit) && "F" /* First */ === t.an;
}

function Zn(t) {
    return !mt(t.limit) && "L" /* Last */ === t.an;
}

function ts(t) {
    return t.on.length > 0 ? t.on[0].field : null;
}

function es(t) {
    for (const e of t.filters) if (e.hn()) return e.field;
    return null;
}

/**
 * Checks if any of the provided Operators are included in the query and
 * returns the first one that is, or null if none are.
 */
/**
 * Returns whether the query matches a collection group rather than a specific
 * collection.
 */
function ns(t) {
    return null !== t.collectionGroup;
}

/**
 * Returns the implicit order by constraint that is used to execute the Query,
 * which can be different from the order by constraints the user provided (e.g.
 * the SDK and backend always orders by `__name__`).
 */ function ss(t) {
    const e = p(t);
    if (null === e.cn) {
        e.cn = [];
        const t = es(e), n = ts(e);
        if (null !== t && null === n) 
        // In order to implicitly add key ordering, we must also add the
        // inequality filter field for it to be a valid query.
        // Note that the default inequality field and key ordering is ascending.
        t.p() || e.cn.push(new bs(t)), e.cn.push(new bs(F.v(), "asc" /* ASCENDING */)); else {
            let t = !1;
            for (const n of e.on) e.cn.push(n), n.field.p() && (t = !0);
            if (!t) {
                // The order of the implicit key ordering always matches the last
                // explicit order by
                const t = e.on.length > 0 ? e.on[e.on.length - 1].dir : "asc" /* ASCENDING */;
                e.cn.push(new bs(F.v(), t));
            }
        }
    }
    return e.cn;
}

/**
 * Converts this `Query` instance to it's corresponding `Target` representation.
 */ function is(t) {
    const e = p(t);
    if (!e.un) if ("F" /* First */ === e.an) e.un = At(e.path, e.collectionGroup, ss(e), e.filters, e.limit, e.startAt, e.endAt); else {
        // Flip the orderBy directions since we want the last results
        const t = [];
        for (const n of ss(e)) {
            const e = "desc" /* DESCENDING */ === n.dir ? "asc" /* ASCENDING */ : "desc" /* DESCENDING */;
            t.push(new bs(n.field, e));
        }
        // We need to swap the cursors to match the now-flipped query ordering.
                const n = e.endAt ? new Ps(e.endAt.position, !e.endAt.before) : null, s = e.startAt ? new Ps(e.startAt.position, !e.startAt.before) : null;
        // Now return as a LimitType.First query.
        e.un = At(e.path, e.collectionGroup, t, e.filters, e.limit, n, s);
    }
    return e.un;
}

function rs(t, e, n) {
    return new Hn(t.path, t.collectionGroup, t.on.slice(), t.filters.slice(), e, n, t.startAt, t.endAt);
}

function os(t, e) {
    return new Hn(t.path, t.collectionGroup, t.on.slice(), t.filters.slice(), t.limit, t.an, e, t.endAt);
}

function as(t, e) {
    return new Hn(t.path, t.collectionGroup, t.on.slice(), t.filters.slice(), t.limit, t.an, t.startAt, e);
}

function cs(t, e) {
    return Pt(is(t), is(e)) && t.an === e.an;
}

// TODO(b/29183165): This is used to get a unique string from a query to, for
// example, use as a dictionary key, but the implementation is subject to
// collisions. Make it collision-free.
function us(t) {
    return `${Rt(is(t))}|lt:${t.an}`;
}

function hs(t) {
    return `Query(target=${gt(is(t))}; limitType=${t.an})`;
}

/** Returns whether `doc` matches the constraints of `query`. */ function ls(t, e) {
    return function(t, e) {
        const n = e.key.path;
        return null !== t.collectionGroup ? e.key.N(t.collectionGroup) && t.path.T(n) : x.F(t.path) ? t.path.isEqual(n) : t.path.I(n);
    }
    /**
 * A document must have a value for every ordering clause in order to show up
 * in the results.
 */ (t, e) && function(t, e) {
        for (const n of t.on) 
        // order by key always matches
        if (!n.field.p() && null === e.field(n.field)) return !1;
        return !0;
    }(t, e) && function(t, e) {
        for (const n of t.filters) if (!n.matches(e)) return !1;
        return !0;
    }
    /** Makes sure a document is within the bounds, if provided. */ (t, e) && function(t, e) {
        if (t.startAt && !Vs(t.startAt, ss(t), e)) return !1;
        if (t.endAt && Vs(t.endAt, ss(t), e)) return !1;
        return !0;
    }
    /**
 * Returns a new comparator function that can be used to compare two documents
 * based on the Query's ordering constraint.
 */ (t, e);
}

function _s(t) {
    return (e, n) => {
        let s = !1;
        for (const i of ss(t)) {
            const t = vs(i, e, n);
            if (0 !== t) return t;
            s = s || i.field.p();
        }
        return 0;
    };
}

class fs extends class {} {
    constructor(t, e, n) {
        super(), this.field = t, this.op = e, this.value = n;
    }
    /**
     * Creates a filter based on the provided arguments.
     */    static create(t, e, n) {
        if (t.p()) return "in" /* IN */ === e || "not-in" /* NOT_IN */ === e ? this.ln(t, e, n) : new ws(t, e, n);
        if (Re(n)) {
            if ("==" /* EQUAL */ !== e && "!=" /* NOT_EQUAL */ !== e) throw new T(m.INVALID_ARGUMENT, "Invalid query. Null only supports '==' and '!=' comparisons.");
            return new fs(t, e, n);
        }
        if (ge(n)) {
            if ("==" /* EQUAL */ !== e && "!=" /* NOT_EQUAL */ !== e) throw new T(m.INVALID_ARGUMENT, "Invalid query. NaN only supports '==' and '!=' comparisons.");
            return new fs(t, e, n);
        }
        return "array-contains" /* ARRAY_CONTAINS */ === e ? new Is(t, n) : "in" /* IN */ === e ? new As(t, n) : "not-in" /* NOT_IN */ === e ? new Rs(t, n) : "array-contains-any" /* ARRAY_CONTAINS_ANY */ === e ? new gs(t, n) : new fs(t, e, n);
    }
    static ln(t, e, n) {
        return "in" /* IN */ === e ? new ms(t, n) : new Ts(t, n);
    }
    matches(t) {
        const e = t.field(this.field);
        // Types do not have to match in NOT_EQUAL filters.
                return "!=" /* NOT_EQUAL */ === this.op ? null !== e && this._n(le(e, this.value)) : null !== e && ce(this.value) === ce(e) && this._n(le(e, this.value));
        // Only compare types with matching backend order (such as double and int).
        }
    _n(t) {
        switch (this.op) {
          case "<" /* LESS_THAN */ :
            return t < 0;

          case "<=" /* LESS_THAN_OR_EQUAL */ :
            return t <= 0;

          case "==" /* EQUAL */ :
            return 0 === t;

          case "!=" /* NOT_EQUAL */ :
            return 0 !== t;

          case ">" /* GREATER_THAN */ :
            return t > 0;

          case ">=" /* GREATER_THAN_OR_EQUAL */ :
            return t >= 0;

          default:
            return y();
        }
    }
    hn() {
        return [ "<" /* LESS_THAN */ , "<=" /* LESS_THAN_OR_EQUAL */ , ">" /* GREATER_THAN */ , ">=" /* GREATER_THAN_OR_EQUAL */ , "!=" /* NOT_EQUAL */ , "not-in" /* NOT_IN */ ].indexOf(this.op) >= 0;
    }
}

function ds(t) {
    // TODO(b/29183165): Technically, this won't be unique if two values have
    // the same description, such as the int 3 and the string "3". So we should
    // add the types in here somehow, too.
    return t.field.R() + t.op.toString() + fe(t.value);
}

class ws extends fs {
    constructor(t, e, n) {
        super(t, e, n), this.key = x.C(n.referenceValue);
    }
    matches(t) {
        const e = x.i(t.key, this.key);
        return this._n(e);
    }
}

/** Filter that matches on key fields within an array. */ class ms extends fs {
    constructor(t, e) {
        super(t, "in" /* IN */ , e), this.keys = Es("in" /* IN */ , e);
    }
    matches(t) {
        return this.keys.some((e => e.isEqual(t.key)));
    }
}

/** Filter that matches on key fields not present within an array. */ class Ts extends fs {
    constructor(t, e) {
        super(t, "not-in" /* NOT_IN */ , e), this.keys = Es("not-in" /* NOT_IN */ , e);
    }
    matches(t) {
        return !this.keys.some((e => e.isEqual(t.key)));
    }
}

function Es(t, e) {
    var n;
    return ((null === (n = e.arrayValue) || void 0 === n ? void 0 : n.values) || []).map((t => x.C(t.referenceValue)));
}

/** A Filter that implements the array-contains operator. */ class Is extends fs {
    constructor(t, e) {
        super(t, "array-contains" /* ARRAY_CONTAINS */ , e);
    }
    matches(t) {
        const e = t.field(this.field);
        return Ae(e) && he(e.arrayValue, this.value);
    }
}

/** A Filter that implements the IN operator. */ class As extends fs {
    constructor(t, e) {
        super(t, "in" /* IN */ , e);
    }
    matches(t) {
        const e = t.field(this.field);
        return null !== e && he(this.value.arrayValue, e);
    }
}

/** A Filter that implements the not-in operator. */ class Rs extends fs {
    constructor(t, e) {
        super(t, "not-in" /* NOT_IN */ , e);
    }
    matches(t) {
        if (he(this.value.arrayValue, {
            nullValue: "NULL_VALUE"
        })) return !1;
        const e = t.field(this.field);
        return null !== e && !he(this.value.arrayValue, e);
    }
}

/** A Filter that implements the array-contains-any operator. */ class gs extends fs {
    constructor(t, e) {
        super(t, "array-contains-any" /* ARRAY_CONTAINS_ANY */ , e);
    }
    matches(t) {
        const e = t.field(this.field);
        return !(!Ae(e) || !e.arrayValue.values) && e.arrayValue.values.some((t => he(this.value.arrayValue, t)));
    }
}

/**
 * Represents a bound of a query.
 *
 * The bound is specified with the given components representing a position and
 * whether it's just before or just after the position (relative to whatever the
 * query order is).
 *
 * The position represents a logical index position for a query. It's a prefix
 * of values for the (potentially implicit) order by clauses of a query.
 *
 * Bound provides a function to determine whether a document comes before or
 * after a bound. This is influenced by whether the position is just before or
 * just after the provided values.
 */ class Ps {
    constructor(t, e) {
        this.position = t, this.before = e;
    }
}

function ys(t) {
    // TODO(b/29183165): Make this collision robust.
    return `${t.before ? "b" : "a"}:${t.position.map((t => fe(t))).join(",")}`;
}

/**
 * Returns true if a document sorts before a bound using the provided sort
 * order.
 */ function Vs(t, e, n) {
    let s = 0;
    for (let i = 0; i < t.position.length; i++) {
        const r = e[i], o = t.position[i];
        if (r.field.p()) s = x.i(x.C(o.referenceValue), n.key); else {
            s = le(o, n.field(r.field));
        }
        if ("desc" /* DESCENDING */ === r.dir && (s *= -1), 0 !== s) break;
    }
    return t.before ? s <= 0 : s < 0;
}

function ps(t, e) {
    if (null === t) return null === e;
    if (null === e) return !1;
    if (t.before !== e.before || t.position.length !== e.position.length) return !1;
    for (let n = 0; n < t.position.length; n++) {
        if (!ue(t.position[n], e.position[n])) return !1;
    }
    return !0;
}

/**
 * An ordering on a field, in some Direction. Direction defaults to ASCENDING.
 */ class bs {
    constructor(t, e = "asc" /* ASCENDING */) {
        this.field = t, this.dir = e;
    }
}

function vs(t, e, n) {
    const s = t.field.p() ? x.i(e.key, n.key) : function(t, e, n) {
        const s = e.field(t), i = n.field(t);
        return null !== s && null !== i ? le(s, i) : y();
    }(t.field, e, n);
    switch (t.dir) {
      case "asc" /* ASCENDING */ :
        return s;

      case "desc" /* DESCENDING */ :
        return -1 * s;

      default:
        return y();
    }
}

function Ss(t, e) {
    return t.dir === e.dir && t.field.isEqual(e.field);
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ class Ds {
    constructor() {
        this.promise = new Promise(((t, e) => {
            this.resolve = t, this.reject = e;
        }));
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A helper for running delayed tasks following an exponential backoff curve
 * between attempts.
 *
 * Each delay is made up of a "base" delay which follows the exponential
 * backoff curve, and a +/- 50% "jitter" that is calculated and added to the
 * base delay. This prevents clients from accidentally synchronizing their
 * delays causing spikes of load to the backend.
 */
class Cs {
    constructor(
    /**
     * The AsyncQueue to run backoff operations on.
     */
    t, 
    /**
     * The ID to use when scheduling backoff operations on the AsyncQueue.
     */
    e, 
    /**
     * The initial delay (used as the base delay on the first retry attempt).
     * Note that jitter will still be applied, so the actual delay could be as
     * little as 0.5*initialDelayMs.
     */
    n = 1e3
    /**
     * The multiplier to use to determine the extended base delay after each
     * attempt.
     */ , s = 1.5
    /**
     * The maximum base delay after which no further backoff is performed.
     * Note that jitter will still be applied, so the actual delay could be as
     * much as 1.5*maxDelayMs.
     */ , i = 6e4) {
        this.fn = t, this.dn = e, this.wn = n, this.mn = s, this.Tn = i, this.En = 0, this.In = null, 
        /** The last backoff attempt, as epoch milliseconds. */
        this.An = Date.now(), this.reset();
    }
    /**
     * Resets the backoff delay.
     *
     * The very next backoffAndWait() will have no delay. If it is called again
     * (i.e. due to an error), initialDelayMs (plus jitter) will be used, and
     * subsequent ones will increase according to the backoffFactor.
     */    reset() {
        this.En = 0;
    }
    /**
     * Resets the backoff delay to the maximum delay (e.g. for use after a
     * RESOURCE_EXHAUSTED error).
     */    Rn() {
        this.En = this.Tn;
    }
    /**
     * Returns a promise that resolves after currentDelayMs, and increases the
     * delay for any subsequent attempts. If there was a pending backoff operation
     * already, it will be canceled.
     */    gn(t) {
        // Cancel any pending backoff operation.
        this.cancel();
        // First schedule using the current base (which may be 0 and should be
        // honored as such).
        const e = Math.floor(this.En + this.Pn()), n = Math.max(0, Date.now() - this.An), s = Math.max(0, e - n);
        // Guard against lastAttemptTime being in the future due to a clock change.
                s > 0 && A("ExponentialBackoff", `Backing off for ${s} ms (base delay: ${this.En} ms, delay with jitter: ${e} ms, last attempt: ${n} ms ago)`), 
        this.In = this.fn.yn(this.dn, s, (() => (this.An = Date.now(), t()))), 
        // Apply backoff factor to determine next delay and ensure it is within
        // bounds.
        this.En *= this.mn, this.En < this.wn && (this.En = this.wn), this.En > this.Tn && (this.En = this.Tn);
    }
    Vn() {
        null !== this.In && (this.In.pn(), this.In = null);
    }
    cancel() {
        null !== this.In && (this.In.cancel(), this.In = null);
    }
    /** Returns a random value in the range [-currentBaseMs/2, currentBaseMs/2] */    Pn() {
        return (Math.random() - .5) * this.En;
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * PersistencePromise<> is essentially a re-implementation of Promise<> except
 * it has a .next() method instead of .then() and .next() and .catch() callbacks
 * are executed synchronously when a PersistencePromise resolves rather than
 * asynchronously (Promise<> implementations use setImmediate() or similar).
 *
 * This is necessary to interoperate with IndexedDB which will automatically
 * commit transactions if control is returned to the event loop without
 * synchronously initiating another operation on the transaction.
 *
 * NOTE: .then() and .catch() only allow a single consumer, unlike normal
 * Promises.
 */ class Ns {
    constructor(t) {
        // NOTE: next/catchCallback will always point to our own wrapper functions,
        // not the user's raw next() or catch() callbacks.
        this.bn = null, this.vn = null, 
        // When the operation resolves, we'll set result or error and mark isDone.
        this.result = void 0, this.error = void 0, this.Sn = !1, 
        // Set to true when .then() or .catch() are called and prevents additional
        // chaining.
        this.Dn = !1, t((t => {
            this.Sn = !0, this.result = t, this.bn && 
            // value should be defined unless T is Void, but we can't express
            // that in the type system.
            this.bn(t);
        }), (t => {
            this.Sn = !0, this.error = t, this.vn && this.vn(t);
        }));
    }
    catch(t) {
        return this.next(void 0, t);
    }
    next(t, e) {
        return this.Dn && y(), this.Dn = !0, this.Sn ? this.error ? this.Cn(e, this.error) : this.Nn(t, this.result) : new Ns(((n, s) => {
            this.bn = e => {
                this.Nn(t, e).next(n, s);
            }, this.vn = t => {
                this.Cn(e, t).next(n, s);
            };
        }));
    }
    Fn() {
        return new Promise(((t, e) => {
            this.next(t, e);
        }));
    }
    xn(t) {
        try {
            const e = t();
            return e instanceof Ns ? e : Ns.resolve(e);
        } catch (t) {
            return Ns.reject(t);
        }
    }
    Nn(t, e) {
        return t ? this.xn((() => t(e))) : Ns.resolve(e);
    }
    Cn(t, e) {
        return t ? this.xn((() => t(e))) : Ns.reject(e);
    }
    static resolve(t) {
        return new Ns(((e, n) => {
            e(t);
        }));
    }
    static reject(t) {
        return new Ns(((e, n) => {
            n(t);
        }));
    }
    static $n(
    // Accept all Promise types in waitFor().
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    t) {
        return new Ns(((e, n) => {
            let s = 0, i = 0, r = !1;
            t.forEach((t => {
                ++s, t.next((() => {
                    ++i, r && i === s && e();
                }), (t => n(t)));
            })), r = !0, i === s && e();
        }));
    }
    /**
     * Given an array of predicate functions that asynchronously evaluate to a
     * boolean, implements a short-circuiting `or` between the results. Predicates
     * will be evaluated until one of them returns `true`, then stop. The final
     * result will be whether any of them returned `true`.
     */    static kn(t) {
        let e = Ns.resolve(!1);
        for (const n of t) e = e.next((t => t ? Ns.resolve(t) : n()));
        return e;
    }
    static forEach(t, e) {
        const n = [];
        return t.forEach(((t, s) => {
            n.push(e.call(this, t, s));
        })), this.$n(n);
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// References to `window` are guarded by SimpleDb.isAvailable()
/* eslint-disable no-restricted-globals */
/**
 * Provides a wrapper around IndexedDb with a simplified interface that uses
 * Promise-like return values to chain operations. Real promises cannot be used
 * since .then() continuations are executed asynchronously (e.g. via
 * .setImmediate), which would cause IndexedDB to end the transaction.
 * See PersistencePromise for more details.
 */
class Fs {
    /*
     * Creates a new SimpleDb wrapper for IndexedDb database `name`.
     *
     * Note that `version` must not be a downgrade. IndexedDB does not support
     * downgrading the schema version. We currently do not support any way to do
     * versioning outside of IndexedDB's versioning mechanism, as only
     * version-upgrade transactions are allowed to do things like create
     * objectstores.
     */
    constructor(t, e, n) {
        this.name = t, this.version = e, this.Mn = n;
        // NOTE: According to https://bugs.webkit.org/show_bug.cgi?id=197050, the
        // bug we're checking for should exist in iOS >= 12.2 and < 13, but for
        // whatever reason it's much harder to hit after 12.2 so we only proactively
        // log on 12.2.
        12.2 === Fs.On(s()) && R("Firestore persistence suffers from a bug in iOS 12.2 Safari that may cause your app to stop working. See https://stackoverflow.com/q/56496296/110915 for details and a potential workaround.");
    }
    /** Deletes the specified database. */    static delete(t) {
        return A("SimpleDb", "Removing database:", t), Ls(window.indexedDB.deleteDatabase(t)).Fn();
    }
    /** Returns true if IndexedDB is available in the current environment. */    static Ln() {
        if ("undefined" == typeof indexedDB) return !1;
        if (Fs.Bn()) return !0;
        // We extensively use indexed array values and compound keys,
        // which IE and Edge do not support. However, they still have indexedDB
        // defined on the window, so we need to check for them here and make sure
        // to return that persistence is not enabled for those browsers.
        // For tracking support of this feature, see here:
        // https://developer.microsoft.com/en-us/microsoft-edge/platform/status/indexeddbarraysandmultientrysupport/
        // Check the UA string to find out the browser.
                const t = s(), e = Fs.On(t), n = 0 < e && e < 10, i = Fs.qn(t), r = 0 < i && i < 4.5;
        // IE 10
        // ua = 'Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.2; Trident/6.0)';
        // IE 11
        // ua = 'Mozilla/5.0 (Windows NT 6.3; Trident/7.0; rv:11.0) like Gecko';
        // Edge
        // ua = 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML,
        // like Gecko) Chrome/39.0.2171.71 Safari/537.36 Edge/12.0';
        // iOS Safari: Disable for users running iOS version < 10.
                return !(t.indexOf("MSIE ") > 0 || t.indexOf("Trident/") > 0 || t.indexOf("Edge/") > 0 || n || r);
    }
    /**
     * Returns true if the backing IndexedDB store is the Node IndexedDBShim
     * (see https://github.com/axemclion/IndexedDBShim).
     */    static Bn() {
        var t;
        return "undefined" != typeof process && "YES" === (null === (t = process.env) || void 0 === t ? void 0 : t.Un);
    }
    /** Helper to get a typed SimpleDbStore from a transaction. */    static Qn(t, e) {
        return t.store(e);
    }
    // visible for testing
    /** Parse User Agent to determine iOS version. Returns -1 if not found. */
    static On(t) {
        const e = t.match(/i(?:phone|pad|pod) os ([\d_]+)/i), n = e ? e[1].split("_").slice(0, 2).join(".") : "-1";
        return Number(n);
    }
    // visible for testing
    /** Parse User Agent to determine Android version. Returns -1 if not found. */
    static qn(t) {
        const e = t.match(/Android ([\d.]+)/i), n = e ? e[1].split(".").slice(0, 2).join(".") : "-1";
        return Number(n);
    }
    /**
     * Opens the specified database, creating or upgrading it if necessary.
     */    async Wn(t) {
        return this.db || (A("SimpleDb", "Opening database:", this.name), this.db = await new Promise(((e, n) => {
            // TODO(mikelehen): Investigate browser compatibility.
            // https://developer.mozilla.org/en-US/docs/Web/API/IndexedDB_API/Using_IndexedDB
            // suggests IE9 and older WebKit browsers handle upgrade
            // differently. They expect setVersion, as described here:
            // https://developer.mozilla.org/en-US/docs/Web/API/IDBVersionChangeRequest/setVersion
            const s = indexedDB.open(this.name, this.version);
            s.onsuccess = t => {
                const n = t.target.result;
                e(n);
            }, s.onblocked = () => {
                n(new $s(t, "Cannot upgrade IndexedDB schema while another tab is open. Close all tabs that access Firestore and reload this page to proceed."));
            }, s.onerror = e => {
                const s = e.target.error;
                "VersionError" === s.name ? n(new T(m.FAILED_PRECONDITION, "A newer version of the Firestore SDK was previously used and so the persisted data is not compatible with the version of the SDK you are now using. The SDK will operate with persistence disabled. If you need persistence, please re-upgrade to a newer version of the SDK or else clear the persisted IndexedDB data for your app to start fresh.")) : n(new $s(t, s));
            }, s.onupgradeneeded = t => {
                A("SimpleDb", 'Database "' + this.name + '" requires upgrade from version:', t.oldVersion);
                const e = t.target.result;
                this.Mn.createOrUpgrade(e, s.transaction, t.oldVersion, this.version).next((() => {
                    A("SimpleDb", "Database upgrade to version " + this.version + " complete");
                }));
            };
        }))), this.jn && (this.db.onversionchange = t => this.jn(t)), this.db;
    }
    Kn(t) {
        this.jn = t, this.db && (this.db.onversionchange = e => t(e));
    }
    async runTransaction(t, e, n, s) {
        const i = "readonly" === e;
        let r = 0;
        for (;;) {
            ++r;
            try {
                this.db = await this.Wn(t);
                const e = Ms.open(this.db, t, i ? "readonly" : "readwrite", n), r = s(e).catch((t => (
                // Abort the transaction if there was an error.
                e.abort(t), Ns.reject(t)))).Fn();
                // As noted above, errors are propagated by aborting the transaction. So
                // we swallow any error here to avoid the browser logging it as unhandled.
                return r.catch((() => {})), 
                // Wait for the transaction to complete (i.e. IndexedDb's onsuccess event to
                // fire), but still return the original transactionFnResult back to the
                // caller.
                await e.Gn, r;
            } catch (t) {
                // TODO(schmidt-sebastian): We could probably be smarter about this and
                // not retry exceptions that are likely unrecoverable (such as quota
                // exceeded errors).
                // Note: We cannot use an instanceof check for FirestoreException, since the
                // exception is wrapped in a generic error by our async/await handling.
                const e = "FirebaseError" !== t.name && r < 3;
                if (A("SimpleDb", "Transaction failed with error:", t.message, "Retrying:", e), 
                this.close(), !e) return Promise.reject(t);
            }
        }
    }
    close() {
        this.db && this.db.close(), this.db = void 0;
    }
}

/**
 * A controller for iterating over a key range or index. It allows an iterate
 * callback to delete the currently-referenced object, or jump to a new key
 * within the key range or index.
 */ class xs {
    constructor(t) {
        this.zn = t, this.Hn = !1, this.Yn = null;
    }
    get Sn() {
        return this.Hn;
    }
    get Jn() {
        return this.Yn;
    }
    set cursor(t) {
        this.zn = t;
    }
    /**
     * This function can be called to stop iteration at any point.
     */    done() {
        this.Hn = !0;
    }
    /**
     * This function can be called to skip to that next key, which could be
     * an index or a primary key.
     */    Xn(t) {
        this.Yn = t;
    }
    /**
     * Delete the current cursor value from the object store.
     *
     * NOTE: You CANNOT do this with a keysOnly query.
     */    delete() {
        return Ls(this.zn.delete());
    }
}

/** An error that wraps exceptions that thrown during IndexedDB execution. */ class $s extends T {
    constructor(t, e) {
        super(m.UNAVAILABLE, `IndexedDB transaction '${t}' failed: ${e}`), this.name = "IndexedDbTransactionError";
    }
}

/** Verifies whether `e` is an IndexedDbTransactionError. */ function ks(t) {
    // Use name equality, as instanceof checks on errors don't work with errors
    // that wrap other errors.
    return "IndexedDbTransactionError" === t.name;
}

/**
 * Wraps an IDBTransaction and exposes a store() method to get a handle to a
 * specific object store.
 */ class Ms {
    constructor(t, e) {
        this.action = t, this.transaction = e, this.aborted = !1, 
        /**
         * A promise that resolves with the result of the IndexedDb transaction.
         */
        this.Zn = new Ds, this.transaction.oncomplete = () => {
            this.Zn.resolve();
        }, this.transaction.onabort = () => {
            e.error ? this.Zn.reject(new $s(t, e.error)) : this.Zn.resolve();
        }, this.transaction.onerror = e => {
            const n = qs(e.target.error);
            this.Zn.reject(new $s(t, n));
        };
    }
    static open(t, e, n, s) {
        try {
            return new Ms(e, t.transaction(s, n));
        } catch (t) {
            throw new $s(e, t);
        }
    }
    get Gn() {
        return this.Zn.promise;
    }
    abort(t) {
        t && this.Zn.reject(t), this.aborted || (A("SimpleDb", "Aborting transaction:", t ? t.message : "Client-initiated abort"), 
        this.aborted = !0, this.transaction.abort());
    }
    /**
     * Returns a SimpleDbStore<KeyType, ValueType> for the specified store. All
     * operations performed on the SimpleDbStore happen within the context of this
     * transaction and it cannot be used anymore once the transaction is
     * completed.
     *
     * Note that we can't actually enforce that the KeyType and ValueType are
     * correct, but they allow type safety through the rest of the consuming code.
     */    store(t) {
        const e = this.transaction.objectStore(t);
        return new Os(e);
    }
}

/**
 * A wrapper around an IDBObjectStore providing an API that:
 *
 * 1) Has generic KeyType / ValueType parameters to provide strongly-typed
 * methods for acting against the object store.
 * 2) Deals with IndexedDB's onsuccess / onerror event callbacks, making every
 * method return a PersistencePromise instead.
 * 3) Provides a higher-level API to avoid needing to do excessive wrapping of
 * intermediate IndexedDB types (IDBCursorWithValue, etc.)
 */ class Os {
    constructor(t) {
        this.store = t;
    }
    put(t, e) {
        let n;
        return void 0 !== e ? (A("SimpleDb", "PUT", this.store.name, t, e), n = this.store.put(e, t)) : (A("SimpleDb", "PUT", this.store.name, "<auto-key>", t), 
        n = this.store.put(t)), Ls(n);
    }
    /**
     * Adds a new value into an Object Store and returns the new key. Similar to
     * IndexedDb's `add()`, this method will fail on primary key collisions.
     *
     * @param value The object to write.
     * @return The key of the value to add.
     */    add(t) {
        A("SimpleDb", "ADD", this.store.name, t, t);
        return Ls(this.store.add(t));
    }
    /**
     * Gets the object with the specified key from the specified store, or null
     * if no object exists with the specified key.
     *
     * @key The key of the object to get.
     * @return The object with the specified key or null if no object exists.
     */    get(t) {
        // We're doing an unsafe cast to ValueType.
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        return Ls(this.store.get(t)).next((e => (
        // Normalize nonexistence to null.
        void 0 === e && (e = null), A("SimpleDb", "GET", this.store.name, t, e), e)));
    }
    delete(t) {
        A("SimpleDb", "DELETE", this.store.name, t);
        return Ls(this.store.delete(t));
    }
    /**
     * If we ever need more of the count variants, we can add overloads. For now,
     * all we need is to count everything in a store.
     *
     * Returns the number of rows in the store.
     */    count() {
        A("SimpleDb", "COUNT", this.store.name);
        return Ls(this.store.count());
    }
    ts(t, e) {
        const n = this.cursor(this.options(t, e)), s = [];
        return this.es(n, ((t, e) => {
            s.push(e);
        })).next((() => s));
    }
    ns(t, e) {
        A("SimpleDb", "DELETE ALL", this.store.name);
        const n = this.options(t, e);
        n.ss = !1;
        const s = this.cursor(n);
        return this.es(s, ((t, e, n) => n.delete()));
    }
    rs(t, e) {
        let n;
        e ? n = t : (n = {}, e = t);
        const s = this.cursor(n);
        return this.es(s, e);
    }
    /**
     * Iterates over a store, but waits for the given callback to complete for
     * each entry before iterating the next entry. This allows the callback to do
     * asynchronous work to determine if this iteration should continue.
     *
     * The provided callback should return `true` to continue iteration, and
     * `false` otherwise.
     */    os(t) {
        const e = this.cursor({});
        return new Ns(((n, s) => {
            e.onerror = t => {
                const e = qs(t.target.error);
                s(e);
            }, e.onsuccess = e => {
                const s = e.target.result;
                s ? t(s.primaryKey, s.value).next((t => {
                    t ? s.continue() : n();
                })) : n();
            };
        }));
    }
    es(t, e) {
        const n = [];
        return new Ns(((s, i) => {
            t.onerror = t => {
                i(t.target.error);
            }, t.onsuccess = t => {
                const i = t.target.result;
                if (!i) return void s();
                const r = new xs(i), o = e(i.primaryKey, i.value, r);
                if (o instanceof Ns) {
                    const t = o.catch((t => (r.done(), Ns.reject(t))));
                    n.push(t);
                }
                r.Sn ? s() : null === r.Jn ? i.continue() : i.continue(r.Jn);
            };
        })).next((() => Ns.$n(n)));
    }
    options(t, e) {
        let n = void 0;
        return void 0 !== t && ("string" == typeof t ? n = t : e = t), {
            index: n,
            range: e
        };
    }
    cursor(t) {
        let e = "next";
        if (t.reverse && (e = "prev"), t.index) {
            const n = this.store.index(t.index);
            return t.ss ? n.openKeyCursor(t.range, e) : n.openCursor(t.range, e);
        }
        return this.store.openCursor(t.range, e);
    }
}

/**
 * Wraps an IDBRequest in a PersistencePromise, using the onsuccess / onerror
 * handlers to resolve / reject the PersistencePromise as appropriate.
 */ function Ls(t) {
    return new Ns(((e, n) => {
        t.onsuccess = t => {
            const n = t.target.result;
            e(n);
        }, t.onerror = t => {
            const e = qs(t.target.error);
            n(e);
        };
    }));
}

// Guard so we only report the error once.
let Bs = !1;

function qs(t) {
    const e = Fs.On(s());
    if (e >= 12.2 && e < 13) {
        const e = "An internal error was encountered in the Indexed Database server";
        if (t.message.indexOf(e) >= 0) {
            // Wrap error in a more descriptive one.
            const t = new T("internal", `IOS_INDEXEDDB_BUG1: IndexedDb has thrown '${e}'. This is likely due to an unavoidable bug in iOS. See https://stackoverflow.com/q/56496296/110915 for details and a potential workaround.`);
            return Bs || (Bs = !0, 
            // Throw a global exception outside of this promise chain, for the user to
            // potentially catch.
            setTimeout((() => {
                throw t;
            }), 0)), t;
        }
    }
    return t;
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** The Platform's 'window' implementation or null if not available. */ function Us() {
    // `window` is not always available, e.g. in ReactNative and WebWorkers.
    // eslint-disable-next-line no-restricted-globals
    return "undefined" != typeof window ? window : null;
}

/** The Platform's 'document' implementation or null if not available. */ function Qs() {
    // `document` is not always available, e.g. in ReactNative and WebWorkers.
    // eslint-disable-next-line no-restricted-globals
    return "undefined" != typeof document ? document : null;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Represents an operation scheduled to be run in the future on an AsyncQueue.
 *
 * It is created via DelayedOperation.createAndSchedule().
 *
 * Supports cancellation (via cancel()) and early execution (via skipDelay()).
 *
 * Note: We implement `PromiseLike` instead of `Promise`, as the `Promise` type
 * in newer versions of TypeScript defines `finally`, which is not available in
 * IE.
 */
class Ws {
    constructor(t, e, n, s, i) {
        this.cs = t, this.dn = e, this.us = n, this.op = s, this.hs = i, this.ls = new Ds, 
        this.then = this.ls.promise.then.bind(this.ls.promise), 
        // It's normal for the deferred promise to be canceled (due to cancellation)
        // and so we attach a dummy catch callback to avoid
        // 'UnhandledPromiseRejectionWarning' log spam.
        this.ls.promise.catch((t => {}));
    }
    /**
     * Creates and returns a DelayedOperation that has been scheduled to be
     * executed on the provided asyncQueue after the provided delayMs.
     *
     * @param asyncQueue The queue to schedule the operation on.
     * @param id A Timer ID identifying the type of operation this is.
     * @param delayMs The delay (ms) before the operation should be scheduled.
     * @param op The operation to run.
     * @param removalCallback A callback to be called synchronously once the
     *   operation is executed or canceled, notifying the AsyncQueue to remove it
     *   from its delayedOperations list.
     *   PORTING NOTE: This exists to prevent making removeDelayedOperation() and
     *   the DelayedOperation class public.
     */    static _s(t, e, n, s, i) {
        const r = Date.now() + n, o = new Ws(t, e, r, s, i);
        return o.start(n), o;
    }
    /**
     * Starts the timer. This is called immediately after construction by
     * createAndSchedule().
     */    start(t) {
        this.fs = setTimeout((() => this.ds()), t);
    }
    /**
     * Queues the operation to run immediately (if it hasn't already been run or
     * canceled).
     */    pn() {
        return this.ds();
    }
    /**
     * Cancels the operation if it hasn't already been executed or canceled. The
     * promise will be rejected.
     *
     * As long as the operation has not yet been run, calling cancel() provides a
     * guarantee that the operation will not be run.
     */    cancel(t) {
        null !== this.fs && (this.clearTimeout(), this.ls.reject(new T(m.CANCELLED, "Operation cancelled" + (t ? ": " + t : ""))));
    }
    ds() {
        this.cs.ws((() => null !== this.fs ? (this.clearTimeout(), this.op().then((t => this.ls.resolve(t)))) : Promise.resolve()));
    }
    clearTimeout() {
        null !== this.fs && (this.hs(this), clearTimeout(this.fs), this.fs = null);
    }
}

class js {
    constructor() {
        // The last promise in the queue.
        this.Ts = Promise.resolve(), 
        // A list of retryable operations. Retryable operations are run in order and
        // retried with backoff.
        this.Es = [], 
        // Is this AsyncQueue being shut down? Once it is set to true, it will not
        // be changed again.
        this.Is = !1, 
        // Operations scheduled to be queued in the future. Operations are
        // automatically removed after they are run or canceled.
        this.As = [], 
        // visible for testing
        this.Rs = null, 
        // Flag set while there's an outstanding AsyncQueue operation, used for
        // assertion sanity-checks.
        this.gs = !1, 
        // List of TimerIds to fast-forward delays for.
        this.Ps = [], 
        // Backoff timer used to schedule retries for retryable operations
        this.ys = new Cs(this, "async_queue_retry" /* AsyncQueueRetry */), 
        // Visibility handler that triggers an immediate retry of all retryable
        // operations. Meant to speed up recovery when we regain file system access
        // after page comes into foreground.
        this.Vs = () => {
            const t = Qs();
            t && A("AsyncQueue", "Visibility state changed to  ", t.visibilityState), this.ys.Vn();
        };
        const t = Qs();
        t && "function" == typeof t.addEventListener && t.addEventListener("visibilitychange", this.Vs);
    }
    // Is this AsyncQueue being shut down? If true, this instance will not enqueue
    // any new operations, Promises from enqueue requests will not resolve.
    get ps() {
        return this.Is;
    }
    /**
     * Adds a new operation to the queue without waiting for it to complete (i.e.
     * we ignore the Promise result).
     */    ws(t) {
        // eslint-disable-next-line @typescript-eslint/no-floating-promises
        this.enqueue(t);
    }
    /**
     * Regardless if the queue has initialized shutdown, adds a new operation to the
     * queue without waiting for it to complete (i.e. we ignore the Promise result).
     */    bs(t) {
        this.vs(), 
        // eslint-disable-next-line @typescript-eslint/no-floating-promises
        this.Ss(t);
    }
    /**
     * Initialize the shutdown of this queue. Once this method is called, the
     * only possible way to request running an operation is through
     * `enqueueEvenWhileRestricted()`.
     */    Ds() {
        if (!this.Is) {
            this.Is = !0;
            const t = Qs();
            t && "function" == typeof t.removeEventListener && t.removeEventListener("visibilitychange", this.Vs);
        }
    }
    /**
     * Adds a new operation to the queue. Returns a promise that will be resolved
     * when the promise returned by the new operation is (with its value).
     */    enqueue(t) {
        return this.vs(), this.Is ? new Promise((t => {})) : this.Ss(t);
    }
    /**
     * Enqueue a retryable operation.
     *
     * A retryable operation is rescheduled with backoff if it fails with a
     * IndexedDbTransactionError (the error type used by SimpleDb). All
     * retryable operations are executed in order and only run if all prior
     * operations were retried successfully.
     */    Cs(t) {
        this.ws((() => (this.Es.push(t), this.Ns())));
    }
    /**
     * Runs the next operation from the retryable queue. If the operation fails,
     * reschedules with backoff.
     */    async Ns() {
        if (0 !== this.Es.length) {
            try {
                await this.Es[0](), this.Es.shift(), this.ys.reset();
            } catch (t) {
                if (!ks(t)) throw t;
 // Failure will be handled by AsyncQueue
                                A("AsyncQueue", "Operation failed with retryable error: " + t);
            }
            this.Es.length > 0 && 
            // If there are additional operations, we re-schedule `retryNextOp()`.
            // This is necessary to run retryable operations that failed during
            // their initial attempt since we don't know whether they are already
            // enqueued. If, for example, `op1`, `op2`, `op3` are enqueued and `op1`
            // needs to  be re-run, we will run `op1`, `op1`, `op2` using the
            // already enqueued calls to `retryNextOp()`. `op3()` will then run in the
            // call scheduled here.
            // Since `backoffAndRun()` cancels an existing backoff and schedules a
            // new backoff on every call, there is only ever a single additional
            // operation in the queue.
            this.ys.gn((() => this.Ns()));
        }
    }
    Ss(t) {
        const e = this.Ts.then((() => (this.gs = !0, t().catch((t => {
            this.Rs = t, this.gs = !1;
            // Re-throw the error so that this.tail becomes a rejected Promise and
            // all further attempts to chain (via .then) will just short-circuit
            // and return the rejected Promise.
            throw R("INTERNAL UNHANDLED ERROR: ", 
            /**
 * Chrome includes Error.message in Error.stack. Other browsers do not.
 * This returns expected output of message + stack when available.
 * @param error Error or FirestoreError
 */
            function(t) {
                let e = t.message || "";
                t.stack && (e = t.stack.includes(t.message) ? t.stack : t.message + "\n" + t.stack);
                return e;
            }
            /**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
            /**
 * Holds the listeners and the last received ViewSnapshot for a query being
 * tracked by EventManager.
 */ (t)), t;
        })).then((t => (this.gs = !1, t))))));
        return this.Ts = e, e;
    }
    /**
     * Schedules an operation to be queued on the AsyncQueue once the specified
     * `delayMs` has elapsed. The returned DelayedOperation can be used to cancel
     * or fast-forward the operation prior to its running.
     */    yn(t, e, n) {
        this.vs(), 
        // Fast-forward delays for timerIds that have been overriden.
        this.Ps.indexOf(t) > -1 && (e = 0);
        const s = Ws._s(this, t, e, n, (t => this.Fs(t)));
        return this.As.push(s), s;
    }
    vs() {
        this.Rs && y();
    }
    /**
     * Verifies there's an operation currently in-progress on the AsyncQueue.
     * Unfortunately we can't verify that the running code is in the promise chain
     * of that operation, so this isn't a foolproof check, but it should be enough
     * to catch some bugs.
     */    xs() {}
    /**
     * Waits until all currently queued tasks are finished executing. Delayed
     * operations are not run.
     */    async $s() {
        // Operations in the queue prior to draining may have enqueued additional
        // operations. Keep draining the queue until the tail is no longer advanced,
        // which indicates that no more new operations were enqueued and that all
        // operations were executed.
        let t;
        do {
            t = this.Ts, await t;
        } while (t !== this.Ts);
    }
    /**
     * For Tests: Determine if a delayed operation with a particular TimerId
     * exists.
     */    ks(t) {
        for (const e of this.As) if (e.dn === t) return !0;
        return !1;
    }
    /**
     * For Tests: Runs some or all delayed operations early.
     *
     * @param lastTimerId Delayed operations up to and including this TimerId will
     *  be drained. Pass TimerId.All to run all delayed operations.
     * @returns a Promise that resolves once all operations have been run.
     */    Ms(t) {
        // Note that draining may generate more delayed ops, so we do that first.
        return this.$s().then((() => {
            // Run ops in the same order they'd run if they ran naturally.
            this.As.sort(((t, e) => t.us - e.us));
            for (const e of this.As) if (e.pn(), "all" /* All */ !== t && e.dn === t) break;
            return this.$s();
        }));
    }
    /**
     * For Tests: Skip all subsequent delays for a timer id.
     */    Os(t) {
        this.Ps.push(t);
    }
    /** Called once a DelayedOperation is run or canceled. */    Fs(t) {
        // NOTE: indexOf / slice are O(n), but delayedOperations is expected to be small.
        const e = this.As.indexOf(t);
        this.As.splice(e, 1);
    }
}

/**
 * Returns a FirestoreError that can be surfaced to the user if the provided
 * error is an IndexedDbTransactionError. Re-throws the error otherwise.
 */ function Ks(t, e) {
    if (R("AsyncQueue", `${e}: ${t}`), ks(t)) return new T(m.UNAVAILABLE, `${e}: ${t}`);
    throw t;
}

class Gs {
    constructor() {
        this.Ls = void 0, this.listeners = [];
    }
}

class zs {
    constructor() {
        this.Bs = new ft((t => us(t)), cs), this.onlineState = "Unknown" /* Unknown */ , 
        this.qs = new Set;
    }
}

async function Hs(t, e) {
    const n = p(t), s = e.query;
    let i = !1, r = n.Bs.get(s);
    if (r || (i = !0, r = new Gs), i) try {
        r.Ls = await n.Us(s);
    } catch (t) {
        const n = Ks(t, `Initialization of query '${hs(e.query)}' failed`);
        return void e.onError(n);
    }
    n.Bs.set(s, r), r.listeners.push(e);
    // Run global snapshot listeners if a consistent snapshot has been emitted.
    e.Qs(n.onlineState);
    if (r.Ls) {
        e.Ws(r.Ls) && Zs(n);
    }
}

async function Ys(t, e) {
    const n = p(t), s = e.query;
    let i = !1;
    const r = n.Bs.get(s);
    if (r) {
        const t = r.listeners.indexOf(e);
        t >= 0 && (r.listeners.splice(t, 1), i = 0 === r.listeners.length);
    }
    if (i) return n.Bs.delete(s), n.js(s);
}

function Js(t, e) {
    const n = p(t);
    let s = !1;
    for (const t of e) {
        const e = t.query, i = n.Bs.get(e);
        if (i) {
            for (const e of i.listeners) e.Ws(t) && (s = !0);
            i.Ls = t;
        }
    }
    s && Zs(n);
}

function Xs(t, e, n) {
    const s = p(t), i = s.Bs.get(e);
    if (i) for (const t of i.listeners) t.onError(n);
    // Remove all listeners. NOTE: We don't need to call syncEngine.unlisten()
    // after an error.
        s.Bs.delete(e);
}

// Call all global snapshot listeners that have been set.
function Zs(t) {
    t.qs.forEach((t => {
        t.next();
    }));
}

/**
 * QueryListener takes a series of internal view snapshots and determines
 * when to raise the event.
 *
 * It uses an Observer to dispatch events.
 */ class ti {
    constructor(t, e, n) {
        this.query = t, this.Ks = e, 
        /**
         * Initial snapshots (e.g. from cache) may not be propagated to the wrapped
         * observer. This flag is set to true once we've actually raised an event.
         */
        this.Gs = !1, this.zs = null, this.onlineState = "Unknown" /* Unknown */ , this.options = n || {};
    }
    /**
     * Applies the new ViewSnapshot to this listener, raising a user-facing event
     * if applicable (depending on what changed, whether the user has opted into
     * metadata-only changes, etc.). Returns true if a user-facing event was
     * indeed raised.
     */    Ws(t) {
        if (!this.options.includeMetadataChanges) {
            // Remove the metadata only changes.
            const e = [];
            for (const n of t.docChanges) 3 /* Metadata */ !== n.type && e.push(n);
            t = new zt(t.query, t.docs, t.Qt, e, t.Wt, t.fromCache, t.jt, 
            /* excludesMetadataChanges= */ !0);
        }
        let e = !1;
        return this.Gs ? this.Hs(t) && (this.Ks.next(t), e = !0) : this.Ys(t, this.onlineState) && (this.Js(t), 
        e = !0), this.zs = t, e;
    }
    onError(t) {
        this.Ks.error(t);
    }
    /** Returns whether a snapshot was raised. */    Qs(t) {
        this.onlineState = t;
        let e = !1;
        return this.zs && !this.Gs && this.Ys(this.zs, t) && (this.Js(this.zs), e = !0), 
        e;
    }
    Ys(t, e) {
        // Always raise the first event when we're synced
        if (!t.fromCache) return !0;
        // NOTE: We consider OnlineState.Unknown as online (it should become Offline
        // or Online if we wait long enough).
                const n = "Offline" /* Offline */ !== e;
        // Don't raise the event if we're online, aren't synced yet (checked
        // above) and are waiting for a sync.
                return (!this.options.Xs || !n) && (!t.docs.m() || "Offline" /* Offline */ === e);
        // Raise data from cache if we have any documents or we are offline
        }
    Hs(t) {
        // We don't need to handle includeDocumentMetadataChanges here because
        // the Metadata only changes have already been stripped out if needed.
        // At this point the only changes we will see are the ones we should
        // propagate.
        if (t.docChanges.length > 0) return !0;
        const e = this.zs && this.zs.hasPendingWrites !== t.hasPendingWrites;
        return !(!t.jt && !e) && !0 === this.options.includeMetadataChanges;
        // Generally we should have hit one of the cases above, but it's possible
        // to get here if there were only metadata docChanges and they got
        // stripped out.
        }
    Js(t) {
        t = zt.Gt(t.query, t.docs, t.Wt, t.fromCache), this.Gs = !0, this.Ks.next(t);
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Simple wrapper around a nullable UID. Mostly exists to make code more
 * readable.
 */ class ei {
    constructor(t) {
        this.uid = t;
    }
    Zs() {
        return null != this.uid;
    }
    /**
     * Returns a key representing this user, suitable for inclusion in a
     * dictionary.
     */    ti() {
        return this.Zs() ? "uid:" + this.uid : "anonymous-user";
    }
    isEqual(t) {
        return t.uid === this.uid;
    }
}

/** A user with a null UID. */ ei.UNAUTHENTICATED = new ei(null), 
// TODO(mikelehen): Look into getting a proper uid-equivalent for
// non-FirebaseAuth providers.
ei.ei = new ei("google-credentials-uid"), ei.ni = new ei("first-party-uid");

/**
 * @license
 * Copyright 2018 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * `ListenSequence` is a monotonic sequence. It is initialized with a minimum value to
 * exceed. All subsequent calls to next will return increasing values. If provided with a
 * `SequenceNumberSyncer`, it will additionally bump its next value when told of a new value, as
 * well as write out sequence numbers that it produces via `next()`.
 */
class ni {
    constructor(t, e) {
        this.previousValue = t, e && (e.si = t => this.ii(t), this.ri = t => e.oi(t));
    }
    ii(t) {
        return this.previousValue = Math.max(t, this.previousValue), this.previousValue;
    }
    next() {
        const t = ++this.previousValue;
        return this.ri && this.ri(t), t;
    }
}

ni.ai = -1;

/** Assembles the key for a client state in WebStorage */
function si(t, e) {
    return `firestore_clients_${t}_${e}`;
}

// The format of the WebStorage key that stores the mutation state is:
//     firestore_mutations_<persistence_prefix>_<batch_id>
//     (for unauthenticated users)
// or: firestore_mutations_<persistence_prefix>_<batch_id>_<user_uid>

// 'user_uid' is last to avoid needing to escape '_' characters that it might
// contain.
/** Assembles the key for a mutation batch in WebStorage */
function ii(t, e, n) {
    let s = `firestore_mutations_${t}_${n}`;
    return e.Zs() && (s += "_" + e.uid), s;
}

// The format of the WebStorage key that stores a query target's metadata is:
//     firestore_targets_<persistence_prefix>_<target_id>
/** Assembles the key for a query state in WebStorage */
function ri(t, e) {
    return `firestore_targets_${t}_${e}`;
}

// The WebStorage prefix that stores the primary tab's online state. The
// format of the key is:
//     firestore_online_state_<persistence_prefix>
/**
 * Holds the state of a mutation batch, including its user ID, batch ID and
 * whether the batch is 'pending', 'acknowledged' or 'rejected'.
 */
// Visible for testing
class oi {
    constructor(t, e, n, s) {
        this.user = t, this.batchId = e, this.state = n, this.error = s;
    }
    /**
     * Parses a MutationMetadata from its JSON representation in WebStorage.
     * Logs a warning and returns null if the format of the data is not valid.
     */    static ci(t, e, n) {
        const s = JSON.parse(n);
        let i = "object" == typeof s && -1 !== [ "pending", "acknowledged", "rejected" ].indexOf(s.state) && (void 0 === s.error || "object" == typeof s.error), r = void 0;
        return i && s.error && (i = "string" == typeof s.error.message && "string" == typeof s.error.code, 
        i && (r = new T(s.error.code, s.error.message))), i ? new oi(t, e, s.state, r) : (R("SharedClientState", `Failed to parse mutation state for ID '${e}': ${n}`), 
        null);
    }
    ui() {
        const t = {
            state: this.state,
            updateTimeMs: Date.now()
        };
        return this.error && (t.error = {
            code: this.error.code,
            message: this.error.message
        }), JSON.stringify(t);
    }
}

/**
 * Holds the state of a query target, including its target ID and whether the
 * target is 'not-current', 'current' or 'rejected'.
 */
// Visible for testing
class ai {
    constructor(t, e, n) {
        this.targetId = t, this.state = e, this.error = n;
    }
    /**
     * Parses a QueryTargetMetadata from its JSON representation in WebStorage.
     * Logs a warning and returns null if the format of the data is not valid.
     */    static ci(t, e) {
        const n = JSON.parse(e);
        let s = "object" == typeof n && -1 !== [ "not-current", "current", "rejected" ].indexOf(n.state) && (void 0 === n.error || "object" == typeof n.error), i = void 0;
        return s && n.error && (s = "string" == typeof n.error.message && "string" == typeof n.error.code, 
        s && (i = new T(n.error.code, n.error.message))), s ? new ai(t, n.state, i) : (R("SharedClientState", `Failed to parse target state for ID '${t}': ${e}`), 
        null);
    }
    ui() {
        const t = {
            state: this.state,
            updateTimeMs: Date.now()
        };
        return this.error && (t.error = {
            code: this.error.code,
            message: this.error.message
        }), JSON.stringify(t);
    }
}

/**
 * This class represents the immutable ClientState for a client read from
 * WebStorage, containing the list of active query targets.
 */ class ci {
    constructor(t, e) {
        this.clientId = t, this.activeTargetIds = e;
    }
    /**
     * Parses a RemoteClientState from the JSON representation in WebStorage.
     * Logs a warning and returns null if the format of the data is not valid.
     */    static ci(t, e) {
        const n = JSON.parse(e);
        let s = "object" == typeof n && n.activeTargetIds instanceof Array, i = jt();
        for (let t = 0; s && t < n.activeTargetIds.length; ++t) s = Et(n.activeTargetIds[t]), 
        i = i.add(n.activeTargetIds[t]);
        return s ? new ci(t, i) : (R("SharedClientState", `Failed to parse client data for instance '${t}': ${e}`), 
        null);
    }
}

/**
 * This class represents the online state for all clients participating in
 * multi-tab. The online state is only written to by the primary client, and
 * used in secondary clients to update their query views.
 */ class ui {
    constructor(t, e) {
        this.clientId = t, this.onlineState = e;
    }
    /**
     * Parses a SharedOnlineState from its JSON representation in WebStorage.
     * Logs a warning and returns null if the format of the data is not valid.
     */    static ci(t) {
        const e = JSON.parse(t);
        return "object" == typeof e && -1 !== [ "Unknown", "Online", "Offline" ].indexOf(e.onlineState) && "string" == typeof e.clientId ? new ui(e.clientId, e.onlineState) : (R("SharedClientState", "Failed to parse online state: " + t), 
        null);
    }
}

/**
 * Metadata state of the local client. Unlike `RemoteClientState`, this class is
 * mutable and keeps track of all pending mutations, which allows us to
 * update the range of pending mutation batch IDs as new mutations are added or
 * removed.
 *
 * The data in `LocalClientState` is not read from WebStorage and instead
 * updated via its instance methods. The updated state can be serialized via
 * `toWebStorageJSON()`.
 */
// Visible for testing.
class hi {
    constructor() {
        this.activeTargetIds = jt();
    }
    hi(t) {
        this.activeTargetIds = this.activeTargetIds.add(t);
    }
    li(t) {
        this.activeTargetIds = this.activeTargetIds.delete(t);
    }
    /**
     * Converts this entry into a JSON-encoded format we can use for WebStorage.
     * Does not encode `clientId` as it is part of the key in WebStorage.
     */    ui() {
        const t = {
            activeTargetIds: this.activeTargetIds.A(),
            updateTimeMs: Date.now()
        };
        return JSON.stringify(t);
    }
}

/**
 * `WebStorageSharedClientState` uses WebStorage (window.localStorage) as the
 * backing store for the SharedClientState. It keeps track of all active
 * clients and supports modifications of the local client's data.
 */ class li {
    constructor(t, e, n, s, i) {
        this.window = t, this.fn = e, this.persistenceKey = n, this._i = s, this.fi = null, 
        this.di = null, this.si = null, this.wi = this.mi.bind(this), this.Ti = new Ct(st), 
        this.Ei = !1, 
        /**
         * Captures WebStorage events that occur before `start()` is called. These
         * events are replayed once `WebStorageSharedClientState` is started.
         */
        this.Ii = [];
        // Escape the special characters mentioned here:
        // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Regular_Expressions
        const r = n.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
        this.storage = this.window.localStorage, this.currentUser = i, this.Ai = si(this.persistenceKey, this._i), 
        this.Ri = 
        /** Assembles the key for the current sequence number. */
        function(t) {
            return "firestore_sequence_number_" + t;
        }
        /**
 * @license
 * Copyright 2018 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ (this.persistenceKey), this.Ti = this.Ti.ot(this._i, new hi), this.gi = new RegExp(`^firestore_clients_${r}_([^_]*)$`), 
        this.Pi = new RegExp(`^firestore_mutations_${r}_(\\d+)(?:_(.*))?$`), this.yi = new RegExp(`^firestore_targets_${r}_(\\d+)$`), 
        this.Vi = 
        /** Assembles the key for the online state of the primary tab. */
        function(t) {
            return "firestore_online_state_" + t;
        }
        // The WebStorage key prefix for the key that stores the last sequence number allocated. The key
        // looks like 'firestore_sequence_number_<persistence_prefix>'.
        (this.persistenceKey), 
        // Rather than adding the storage observer during start(), we add the
        // storage observer during initialization. This ensures that we collect
        // events before other components populate their initial state (during their
        // respective start() calls). Otherwise, we might for example miss a
        // mutation that is added after LocalStore's start() processed the existing
        // mutations but before we observe WebStorage events.
        this.window.addEventListener("storage", this.wi);
    }
    /** Returns 'true' if WebStorage is available in the current environment. */    static Ln(t) {
        return !(!t || !t.localStorage);
    }
    async start() {
        // Retrieve the list of existing clients to backfill the data in
        // SharedClientState.
        const t = await this.fi.pi();
        for (const e of t) {
            if (e === this._i) continue;
            const t = this.getItem(si(this.persistenceKey, e));
            if (t) {
                const n = ci.ci(e, t);
                n && (this.Ti = this.Ti.ot(n.clientId, n));
            }
        }
        this.bi();
        // Check if there is an existing online state and call the callback handler
        // if applicable.
        const e = this.storage.getItem(this.Vi);
        if (e) {
            const t = this.vi(e);
            t && this.Si(t);
        }
        for (const t of this.Ii) this.mi(t);
        this.Ii = [], 
        // Register a window unload hook to remove the client metadata entry from
        // WebStorage even if `shutdown()` was not called.
        this.window.addEventListener("unload", (() => this.Di())), this.Ei = !0;
    }
    oi(t) {
        this.setItem(this.Ri, JSON.stringify(t));
    }
    Ci() {
        return this.Ni(this.Ti);
    }
    Fi(t) {
        let e = !1;
        return this.Ti.forEach(((n, s) => {
            s.activeTargetIds.has(t) && (e = !0);
        })), e;
    }
    xi(t) {
        this.$i(t, "pending");
    }
    ki(t, e, n) {
        this.$i(t, e, n), 
        // Once a final mutation result is observed by other clients, they no longer
        // access the mutation's metadata entry. Since WebStorage replays events
        // in order, it is safe to delete the entry right after updating it.
        this.Mi(t);
    }
    Oi(t) {
        let e = "not-current";
        // Lookup an existing query state if the target ID was already registered
        // by another tab
                if (this.Fi(t)) {
            const n = this.storage.getItem(ri(this.persistenceKey, t));
            if (n) {
                const s = ai.ci(t, n);
                s && (e = s.state);
            }
        }
        return this.Li.hi(t), this.bi(), e;
    }
    Bi(t) {
        this.Li.li(t), this.bi();
    }
    qi(t) {
        return this.Li.activeTargetIds.has(t);
    }
    Ui(t) {
        this.removeItem(ri(this.persistenceKey, t));
    }
    Qi(t, e, n) {
        this.Wi(t, e, n);
    }
    ji(t, e, n) {
        e.forEach((t => {
            this.Mi(t);
        })), this.currentUser = t, n.forEach((t => {
            this.xi(t);
        }));
    }
    Ki(t) {
        this.Gi(t);
    }
    Di() {
        this.Ei && (this.window.removeEventListener("storage", this.wi), this.removeItem(this.Ai), 
        this.Ei = !1);
    }
    getItem(t) {
        const e = this.storage.getItem(t);
        return A("SharedClientState", "READ", t, e), e;
    }
    setItem(t, e) {
        A("SharedClientState", "SET", t, e), this.storage.setItem(t, e);
    }
    removeItem(t) {
        A("SharedClientState", "REMOVE", t), this.storage.removeItem(t);
    }
    mi(t) {
        // Note: The function is typed to take Event to be interface-compatible with
        // `Window.addEventListener`.
        const e = t;
        if (e.storageArea === this.storage) {
            if (A("SharedClientState", "EVENT", e.key, e.newValue), e.key === this.Ai) return void R("Received WebStorage notification for local change. Another client might have garbage-collected our state");
            this.fn.Cs((async () => {
                if (this.Ei) {
                    if (null !== e.key) if (this.gi.test(e.key)) {
                        if (null == e.newValue) {
                            const t = this.zi(e.key);
                            return this.Hi(t, null);
                        }
                        {
                            const t = this.Yi(e.key, e.newValue);
                            if (t) return this.Hi(t.clientId, t);
                        }
                    } else if (this.Pi.test(e.key)) {
                        if (null !== e.newValue) {
                            const t = this.Ji(e.key, e.newValue);
                            if (t) return this.Xi(t);
                        }
                    } else if (this.yi.test(e.key)) {
                        if (null !== e.newValue) {
                            const t = this.Zi(e.key, e.newValue);
                            if (t) return this.tr(t);
                        }
                    } else if (e.key === this.Vi) {
                        if (null !== e.newValue) {
                            const t = this.vi(e.newValue);
                            if (t) return this.Si(t);
                        }
                    } else if (e.key === this.Ri) {
                        const t = function(t) {
                            let e = ni.ai;
                            if (null != t) try {
                                const n = JSON.parse(t);
                                V("number" == typeof n), e = n;
                            } catch (t) {
                                R("SharedClientState", "Failed to read sequence number from WebStorage", t);
                            }
                            return e;
                        }
                        /**
 * `MemorySharedClientState` is a simple implementation of SharedClientState for
 * clients using memory persistence. The state in this class remains fully
 * isolated and no synchronization is performed.
 */ (e.newValue);
                        t !== ni.ai && this.si(t);
                    }
                } else this.Ii.push(e);
            }));
        }
    }
    get Li() {
        return this.Ti.get(this._i);
    }
    bi() {
        this.setItem(this.Ai, this.Li.ui());
    }
    $i(t, e, n) {
        const s = new oi(this.currentUser, t, e, n), i = ii(this.persistenceKey, this.currentUser, t);
        this.setItem(i, s.ui());
    }
    Mi(t) {
        const e = ii(this.persistenceKey, this.currentUser, t);
        this.removeItem(e);
    }
    Gi(t) {
        const e = {
            clientId: this._i,
            onlineState: t
        };
        this.storage.setItem(this.Vi, JSON.stringify(e));
    }
    Wi(t, e, n) {
        const s = ri(this.persistenceKey, t), i = new ai(t, e, n);
        this.setItem(s, i.ui());
    }
    /**
     * Parses a client state key in WebStorage. Returns null if the key does not
     * match the expected key format.
     */    zi(t) {
        const e = this.gi.exec(t);
        return e ? e[1] : null;
    }
    /**
     * Parses a client state in WebStorage. Returns 'null' if the value could not
     * be parsed.
     */    Yi(t, e) {
        const n = this.zi(t);
        return ci.ci(n, e);
    }
    /**
     * Parses a mutation batch state in WebStorage. Returns 'null' if the value
     * could not be parsed.
     */    Ji(t, e) {
        const n = this.Pi.exec(t), s = Number(n[1]), i = void 0 !== n[2] ? n[2] : null;
        return oi.ci(new ei(i), s, e);
    }
    /**
     * Parses a query target state from WebStorage. Returns 'null' if the value
     * could not be parsed.
     */    Zi(t, e) {
        const n = this.yi.exec(t), s = Number(n[1]);
        return ai.ci(s, e);
    }
    /**
     * Parses an online state from WebStorage. Returns 'null' if the value
     * could not be parsed.
     */    vi(t) {
        return ui.ci(t);
    }
    async Xi(t) {
        if (t.user.uid === this.currentUser.uid) return this.fi.er(t.batchId, t.state, t.error);
        A("SharedClientState", "Ignoring mutation for non-active user " + t.user.uid);
    }
    tr(t) {
        return this.fi.nr(t.targetId, t.state, t.error);
    }
    Hi(t, e) {
        const n = e ? this.Ti.ot(t, e) : this.Ti.remove(t), s = this.Ni(this.Ti), i = this.Ni(n), r = [], o = [];
        return i.forEach((t => {
            s.has(t) || r.push(t);
        })), s.forEach((t => {
            i.has(t) || o.push(t);
        })), this.fi.sr(r, o).then((() => {
            this.Ti = n;
        }));
    }
    Si(t) {
        // We check whether the client that wrote this online state is still active
        // by comparing its client ID to the list of clients kept active in
        // IndexedDb. If a client does not update their IndexedDb client state
        // within 5 seconds, it is considered inactive and we don't emit an online
        // state event.
        this.Ti.get(t.clientId) && this.di(t.onlineState);
    }
    Ni(t) {
        let e = jt();
        return t.forEach(((t, n) => {
            e = e.kt(n.activeTargetIds);
        })), e;
    }
}

class _i {
    constructor() {
        this.ir = new hi, this.rr = {}, this.di = null, this.si = null;
    }
    xi(t) {
        // No op.
    }
    ki(t, e, n) {
        // No op.
    }
    Oi(t) {
        return this.ir.hi(t), this.rr[t] || "not-current";
    }
    Qi(t, e, n) {
        this.rr[t] = e;
    }
    Bi(t) {
        this.ir.li(t);
    }
    qi(t) {
        return this.ir.activeTargetIds.has(t);
    }
    Ui(t) {
        delete this.rr[t];
    }
    Ci() {
        return this.ir.activeTargetIds;
    }
    Fi(t) {
        return this.ir.activeTargetIds.has(t);
    }
    start() {
        return this.ir = new hi, Promise.resolve();
    }
    ji(t, e, n) {
        // No op.
    }
    Ki(t) {
        // No op.
    }
    Di() {}
    oi(t) {}
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A batch of mutations that will be sent as one unit to the backend.
 */
class fi {
    /**
     * @param batchId The unique ID of this mutation batch.
     * @param localWriteTime The original write time of this mutation.
     * @param baseMutations Mutations that are used to populate the base
     * values when this mutation is applied locally. This can be used to locally
     * overwrite values that are persisted in the remote document cache. Base
     * mutations are never sent to the backend.
     * @param mutations The user-provided mutations in this mutation batch.
     * User-provided mutations are applied both locally and remotely on the
     * backend.
     */
    constructor(t, e, n, s) {
        this.batchId = t, this.ar = e, this.baseMutations = n, this.mutations = s;
    }
    /**
     * Applies all the mutations in this MutationBatch to the specified document
     * to create a new remote document
     *
     * @param docKey The key of the document to apply mutations to.
     * @param maybeDoc The document to apply mutations to.
     * @param batchResult The result of applying the MutationBatch to the
     * backend.
     */    cr(t, e, n) {
        const s = n.ur;
        for (let n = 0; n < this.mutations.length; n++) {
            const i = this.mutations[n];
            if (i.key.isEqual(t)) {
                e = Sn(i, e, s[n]);
            }
        }
        return e;
    }
    /**
     * Computes the local view of a document given all the mutations in this
     * batch.
     *
     * @param docKey The key of the document to apply mutations to.
     * @param maybeDoc The document to apply mutations to.
     */    hr(t, e) {
        // First, apply the base state. This allows us to apply non-idempotent
        // transform against a consistent set of values.
        for (const n of this.baseMutations) n.key.isEqual(t) && (e = Dn(n, e, e, this.ar));
        const n = e;
        // Second, apply all user-provided mutations.
                for (const s of this.mutations) s.key.isEqual(t) && (e = Dn(s, e, n, this.ar));
        return e;
    }
    /**
     * Computes the local view for all provided documents given the mutations in
     * this batch.
     */    lr(t) {
        // TODO(mrschmidt): This implementation is O(n^2). If we apply the mutations
        // directly (as done in `applyToLocalView()`), we can reduce the complexity
        // to O(n).
        let e = t;
        return this.mutations.forEach((n => {
            const s = this.hr(n.key, t.get(n.key));
            s && (e = e.ot(n.key, s));
        })), e;
    }
    keys() {
        return this.mutations.reduce(((t, e) => t.add(e.key)), Qt());
    }
    isEqual(t) {
        return this.batchId === t.batchId && it(this.mutations, t.mutations, ((t, e) => Nn(t, e))) && it(this.baseMutations, t.baseMutations, ((t, e) => Nn(t, e)));
    }
}

/** The result of applying a mutation batch to the backend. */ class di {
    constructor(t, e, n, 
    /**
     * A pre-computed mapping from each mutated document to the resulting
     * version.
     */
    s) {
        this.batch = t, this._r = e, this.ur = n, this.dr = s;
    }
    /**
     * Creates a new MutationBatchResult for the given batch and results. There
     * must be one result for each mutation in the batch. This static factory
     * caches a document=>version mapping (docVersions).
     */    static from(t, e, n) {
        V(t.mutations.length === n.length);
        let s = qt;
        const i = t.mutations;
        for (let t = 0; t < i.length; t++) s = s.ot(i[t].key, n[t].version);
        return new di(t, e, n, s);
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * An in-memory buffer of entries to be written to a RemoteDocumentCache.
 * It can be used to batch up a set of changes to be written to the cache, but
 * additionally supports reading entries back with the `getEntry()` method,
 * falling back to the underlying RemoteDocumentCache if no entry is
 * buffered.
 *
 * Entries added to the cache *must* be read first. This is to facilitate
 * calculating the size delta of the pending changes.
 *
 * PORTING NOTE: This class was implemented then removed from other platforms.
 * If byte-counting ends up being needed on the other platforms, consider
 * porting this class as part of that implementation work.
 */ class wi {
    constructor() {
        // A mapping of document key to the new cache entry that should be written (or null if any
        // existing cache entry should be removed).
        this.wr = new ft((t => t.toString()), ((t, e) => t.isEqual(e))), this.mr = !1;
    }
    set readTime(t) {
        this.Tr = t;
    }
    get readTime() {
        return this.Tr;
    }
    /**
     * Buffers a `RemoteDocumentCache.addEntry()` call.
     *
     * You can only modify documents that have already been retrieved via
     * `getEntry()/getEntries()` (enforced via IndexedDbs `apply()`).
     */    Er(t, e) {
        this.Ir(), this.readTime = e, this.wr.set(t.key, t);
    }
    /**
     * Buffers a `RemoteDocumentCache.removeEntry()` call.
     *
     * You can only remove documents that have already been retrieved via
     * `getEntry()/getEntries()` (enforced via IndexedDbs `apply()`).
     */    Ar(t, e) {
        this.Ir(), e && (this.readTime = e), this.wr.set(t, null);
    }
    /**
     * Looks up an entry in the cache. The buffered changes will first be checked,
     * and if no buffered change applies, this will forward to
     * `RemoteDocumentCache.getEntry()`.
     *
     * @param transaction The transaction in which to perform any persistence
     *     operations.
     * @param documentKey The key of the entry to look up.
     * @return The cached Document or NoDocument entry, or null if we have nothing
     * cached.
     */    Rr(t, e) {
        this.Ir();
        const n = this.wr.get(e);
        return void 0 !== n ? Ns.resolve(n) : this.gr(t, e);
    }
    /**
     * Looks up several entries in the cache, forwarding to
     * `RemoteDocumentCache.getEntry()`.
     *
     * @param transaction The transaction in which to perform any persistence
     *     operations.
     * @param documentKeys The keys of the entries to look up.
     * @return A map of cached `Document`s or `NoDocument`s, indexed by key. If an
     *     entry cannot be found, the corresponding key will be mapped to a null
     *     value.
     */    getEntries(t, e) {
        return this.Pr(t, e);
    }
    /**
     * Applies buffered changes to the underlying RemoteDocumentCache, using
     * the provided transaction.
     */    apply(t) {
        return this.Ir(), this.mr = !0, this.yr(t);
    }
    /** Helper to assert this.changes is not null  */    Ir() {}
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ const mi = "The current tab is not in the required state to perform this operation. It might be necessary to refresh the browser tab.";

/**
 * A base class representing a persistence transaction, encapsulating both the
 * transaction's sequence numbers as well as a list of onCommitted listeners.
 *
 * When you call Persistence.runTransaction(), it will create a transaction and
 * pass it to your callback. You then pass it to any method that operates
 * on persistence.
 */ class Ti {
    constructor() {
        this.Vr = [];
    }
    pr(t) {
        this.Vr.push(t);
    }
    br() {
        this.Vr.forEach((t => t()));
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A readonly view of the local state of all documents we're tracking (i.e. we
 * have a cached version in remoteDocumentCache or local mutations for the
 * document). The view is computed by applying the mutations in the
 * MutationQueue to the RemoteDocumentCache.
 */ class Ei {
    constructor(t, e, n) {
        this.vr = t, this.Sr = e, this.Dr = n;
    }
    /**
     * Get the local view of the document identified by `key`.
     *
     * @return Local view of the document or null if we don't have any cached
     * state for it.
     */    Cr(t, e) {
        return this.Sr.Nr(t, e).next((n => this.Fr(t, e, n)));
    }
    /** Internal version of `getDocument` that allows reusing batches. */    Fr(t, e, n) {
        return this.vr.Rr(t, e).next((t => {
            for (const s of n) t = s.hr(e, t);
            return t;
        }));
    }
    // Returns the view of the given `docs` as they would appear after applying
    // all mutations in the given `batches`.
    $r(t, e, n) {
        let s = Ot();
        return e.forEach(((t, e) => {
            for (const s of n) e = s.hr(t, e);
            s = s.ot(t, e);
        })), s;
    }
    /**
     * Gets the local view of the documents identified by `keys`.
     *
     * If we don't have cached state for a document in `keys`, a NoDocument will
     * be stored for that key in the resulting set.
     */    kr(t, e) {
        return this.vr.getEntries(t, e).next((e => this.Mr(t, e)));
    }
    /**
     * Similar to `getDocuments`, but creates the local view from the given
     * `baseDocs` without retrieving documents from the local store.
     */    Mr(t, e) {
        return this.Sr.Or(t, e).next((n => {
            const s = this.$r(t, e, n);
            let i = Mt();
            return s.forEach(((t, e) => {
                // TODO(http://b/32275378): Don't conflate missing / deleted.
                e || (e = new Gn(t, wt.min())), i = i.ot(t, e);
            })), i;
        }));
    }
    /**
     * Performs a query against the local view of all documents.
     *
     * @param transaction The persistence transaction.
     * @param query The query to match documents against.
     * @param sinceReadTime If not set to SnapshotVersion.min(), return only
     *     documents that have been read since this snapshot version (exclusive).
     */    Lr(t, e, n) {
        /**
 * Returns whether the query matches a single document by path (rather than a
 * collection).
 */
        return function(t) {
            return x.F(t.path) && null === t.collectionGroup && 0 === t.filters.length;
        }(e) ? this.Br(t, e.path) : ns(e) ? this.qr(t, e, n) : this.Ur(t, e, n);
    }
    Br(t, e) {
        // Just do a simple document lookup.
        return this.Cr(t, new x(e)).next((t => {
            let e = Bt();
            return t instanceof Kn && (e = e.ot(t.key, t)), e;
        }));
    }
    qr(t, e, n) {
        const s = e.collectionGroup;
        let i = Bt();
        return this.Dr.Qr(t, s).next((r => Ns.forEach(r, (r => {
            const o = function(t, e) {
                return new Hn(e, 
                /*collectionGroup=*/ null, t.on.slice(), t.filters.slice(), t.limit, t.an, t.startAt, t.endAt);
            }
            /**
 * Returns true if this query does not specify any query constraints that
 * could remove results.
 */ (e, r.child(s));
            return this.Ur(t, o, n).next((t => {
                t.forEach(((t, e) => {
                    i = i.ot(t, e);
                }));
            }));
        })).next((() => i))));
    }
    Ur(t, e, n) {
        // Query the remote documents and overlay mutations.
        let s, i;
        return this.vr.Lr(t, e, n).next((n => (s = n, this.Sr.Wr(t, e)))).next((e => (i = e, 
        this.jr(t, i, s).next((t => {
            s = t;
            for (const t of i) for (const e of t.mutations) {
                const n = e.key, i = s.get(n), r = Dn(e, i, i, t.ar);
                s = r instanceof Kn ? s.ot(n, r) : s.remove(n);
            }
        }))))).next((() => (
        // Finally, filter out any documents that don't actually match
        // the query.
        s.forEach(((t, n) => {
            ls(e, n) || (s = s.remove(t));
        })), s)));
    }
    jr(t, e, n) {
        let s = Qt();
        for (const t of e) for (const e of t.mutations) e instanceof $n && null === n.get(e.key) && (s = s.add(e.key));
        let i = n;
        return this.vr.getEntries(t, s).next((t => (t.forEach(((t, e) => {
            null !== e && e instanceof Kn && (i = i.ot(t, e));
        })), i)));
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A set of changes to what documents are currently in view and out of view for
 * a given query. These changes are sent to the LocalStore by the View (via
 * the SyncEngine) and are used to pin / unpin documents as appropriate.
 */ class Ii {
    constructor(t, e, n, s) {
        this.targetId = t, this.fromCache = e, this.Kr = n, this.Gr = s;
    }
    static zr(t, e) {
        let n = Qt(), s = Qt();
        for (const t of e.docChanges) switch (t.type) {
          case 0 /* Added */ :
            n = n.add(t.doc.key);
            break;

          case 1 /* Removed */ :
            s = s.add(t.doc.key);
 // do nothing
                }
        return new Ii(t, e.fromCache, n, s);
    }
}

/**
 * @license
 * Copyright 2018 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ function Ai([t, e], [n, s]) {
    const i = st(t, n);
    return 0 === i ? st(e, s) : i;
}

/**
 * Used to calculate the nth sequence number. Keeps a rolling buffer of the
 * lowest n values passed to `addElement`, and finally reports the largest of
 * them in `maxValue`.
 */ class Ri {
    constructor(t) {
        this.Hr = t, this.buffer = new xt(Ai), this.Yr = 0;
    }
    Jr() {
        return ++this.Yr;
    }
    Xr(t) {
        const e = [ t, this.Jr() ];
        if (this.buffer.size < this.Hr) this.buffer = this.buffer.add(e); else {
            const t = this.buffer.last();
            Ai(e, t) < 0 && (this.buffer = this.buffer.delete(t).add(e));
        }
    }
    get maxValue() {
        // Guaranteed to be non-empty. If we decide we are not collecting any
        // sequence numbers, nthSequenceNumber below short-circuits. If we have
        // decided that we are collecting n sequence numbers, it's because n is some
        // percentage of the existing sequence numbers. That means we should never
        // be in a situation where we are collecting sequence numbers but don't
        // actually have any.
        return this.buffer.last()[0];
    }
}

const gi = {
    Zr: !1,
    eo: 0,
    no: 0,
    so: 0
};

class Pi {
    constructor(
    // When we attempt to collect, we will only do so if the cache size is greater than this
    // threshold. Passing `COLLECTION_DISABLED` here will cause collection to always be skipped.
    t, 
    // The percentage of sequence numbers that we will attempt to collect
    e, 
    // A cap on the total number of sequence numbers that will be collected. This prevents
    // us from collecting a huge number of sequence numbers if the cache has grown very large.
    n) {
        this.io = t, this.ro = e, this.oo = n;
    }
    static ao(t) {
        return new Pi(t, Pi.co, Pi.uo);
    }
}

Pi.ho = -1, Pi.lo = 1048576, Pi._o = 41943040, Pi.co = 10, Pi.uo = 1e3, Pi.fo = new Pi(Pi._o, Pi.co, Pi.uo), 
Pi.do = new Pi(Pi.ho, 0, 0);

/**
 * This class is responsible for the scheduling of LRU garbage collection. It handles checking
 * whether or not GC is enabled, as well as which delay to use before the next run.
 */
class yi {
    constructor(t, e) {
        this.wo = t, this.cs = e, this.mo = !1, this.To = null;
    }
    start(t) {
        this.wo.params.io !== Pi.ho && this.Eo(t);
    }
    stop() {
        this.To && (this.To.cancel(), this.To = null);
    }
    get Ei() {
        return null !== this.To;
    }
    Eo(t) {
        const e = this.mo ? 3e5 : 6e4;
        A("LruGarbageCollector", `Garbage collection scheduled in ${e}ms`), this.To = this.cs.yn("lru_garbage_collection" /* LruGarbageCollection */ , e, (async () => {
            this.To = null, this.mo = !0;
            try {
                await t.Io(this.wo);
            } catch (t) {
                ks(t) ? A("LruGarbageCollector", "Ignoring IndexedDB error during garbage collection: ", t) : await Qr(t);
            }
            await this.Eo(t);
        }));
    }
}

/** Implements the steps for LRU garbage collection. */ class Vi {
    constructor(t, e) {
        this.Ao = t, this.params = e;
    }
    /** Given a percentile of target to collect, returns the number of targets to collect. */    Ro(t, e) {
        return this.Ao.Po(t).next((t => Math.floor(e / 100 * t)));
    }
    /** Returns the nth sequence number, counting in order from the smallest. */    yo(t, e) {
        if (0 === e) return Ns.resolve(ni.ai);
        const n = new Ri(e);
        return this.Ao.Ce(t, (t => n.Xr(t.sequenceNumber))).next((() => this.Ao.Vo(t, (t => n.Xr(t))))).next((() => n.maxValue));
    }
    /**
     * Removes targets with a sequence number equal to or less than the given upper bound, and removes
     * document associations with those targets.
     */    po(t, e, n) {
        return this.Ao.po(t, e, n);
    }
    /**
     * Removes documents that have a sequence number equal to or less than the upper bound and are not
     * otherwise pinned.
     */    bo(t, e) {
        return this.Ao.bo(t, e);
    }
    vo(t, e) {
        return this.params.io === Pi.ho ? (A("LruGarbageCollector", "Garbage collection skipped; disabled"), 
        Ns.resolve(gi)) : this.So(t).next((n => n < this.params.io ? (A("LruGarbageCollector", `Garbage collection skipped; Cache size ${n} is lower than threshold ` + this.params.io), 
        gi) : this.Do(t, e)));
    }
    So(t) {
        return this.Ao.So(t);
    }
    Do(t, e) {
        let s, i, r, o, a, c, u;
        const h = Date.now();
        return this.Ro(t, this.params.ro).next((e => (
        // Cap at the configured max
        e > this.params.oo ? (A("LruGarbageCollector", `Capping sequence numbers to collect down to the maximum of ${this.params.oo} from ` + e), 
        i = this.params.oo) : i = e, o = Date.now(), this.yo(t, i)))).next((n => (s = n, 
        a = Date.now(), this.po(t, s, e)))).next((e => (r = e, c = Date.now(), this.bo(t, s)))).next((t => {
            if (u = Date.now(), I() <= n.DEBUG) {
                A("LruGarbageCollector", `LRU Garbage Collection\n\tCounted targets in ${o - h}ms\n\tDetermined least recently used ${i} in ` + (a - o) + "ms\n" + `\tRemoved ${r} targets in ` + (c - a) + "ms\n" + `\tRemoved ${t} documents in ` + (u - c) + "ms\n" + `Total Duration: ${u - h}ms`);
            }
            return Ns.resolve({
                Zr: !0,
                eo: i,
                no: r,
                so: t
            });
        }));
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Encodes a resource path into a IndexedDb-compatible string form.
 */
function pi(t) {
    let e = "";
    for (let n = 0; n < t.length; n++) e.length > 0 && (e = vi(e)), e = bi(t.get(n), e);
    return vi(e);
}

/** Encodes a single segment of a resource path into the given result */ function bi(t, e) {
    let n = e;
    const s = t.length;
    for (let e = 0; e < s; e++) {
        const s = t.charAt(e);
        switch (s) {
          case "\0":
            n += "";
            break;

          case "":
            n += "";
            break;

          default:
            n += s;
        }
    }
    return n;
}

/** Encodes a path separator into the given result */ function vi(t) {
    return t + "";
}

/**
 * Decodes the given IndexedDb-compatible string form of a resource path into
 * a ResourcePath instance. Note that this method is not suitable for use with
 * decoding resource names from the server; those are One Platform format
 * strings.
 */ function Si(t) {
    // Event the empty path must encode as a path of at least length 2. A path
    // with exactly 2 must be the empty path.
    const e = t.length;
    if (V(e >= 2), 2 === e) return V("" === t.charAt(0) && "" === t.charAt(1)), C.P();
    // Escape characters cannot exist past the second-to-last position in the
    // source value.
        const n = e - 2, s = [];
    let i = "";
    for (let r = 0; r < e; ) {
        // The last two characters of a valid encoded path must be a separator, so
        // there must be an end to this segment.
        const e = t.indexOf("", r);
        (e < 0 || e > n) && y();
        switch (t.charAt(e + 1)) {
          case "":
            const n = t.substring(r, e);
            let o;
            0 === i.length ? 
            // Avoid copying for the common case of a segment that excludes \0
            // and \001
            o = n : (i += n, o = i, i = ""), s.push(o);
            break;

          case "":
            i += t.substring(r, e), i += "\0";
            break;

          case "":
            // The escape character can be used in the output to encode itself.
            i += t.substring(r, e + 1);
            break;

          default:
            y();
        }
        r = e + 2;
    }
    return new C(s);
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** Serializer for values stored in the LocalStore. */ class Di {
    constructor(t) {
        this.Co = t;
    }
}

/** Decodes a remote document from storage locally to a Document. */ function Ci(t, e) {
    if (e.document) return function(t, e, n) {
        const s = Me(t, e.name), i = Fe(e.updateTime), r = new Un({
            mapValue: {
                fields: e.fields
            }
        });
        return new Kn(s, i, r, {
            hasCommittedMutations: !!n
        });
    }(t.Co, e.document, !!e.hasCommittedMutations);
    if (e.noDocument) {
        const t = x.$(e.noDocument.path), n = ki(e.noDocument.readTime);
        return new Gn(t, n, {
            hasCommittedMutations: !!e.hasCommittedMutations
        });
    }
    if (e.unknownDocument) {
        const t = x.$(e.unknownDocument.path), n = ki(e.unknownDocument.version);
        return new zn(t, n);
    }
    return y();
}

/** Encodes a document for storage locally. */ function Ni(t, e, n) {
    const s = Fi(n), i = e.key.path.h().A();
    if (e instanceof Kn) {
        const n = function(t, e) {
            return {
                name: ke(t, e.key),
                fields: e.rn().mapValue.fields,
                updateTime: De(t, e.version.Z())
            };
        }(t.Co, e), r = e.hasCommittedMutations;
        return new cr(
        /* unknownDocument= */ null, 
        /* noDocument= */ null, n, r, s, i);
    }
    if (e instanceof Gn) {
        const t = e.key.path.A(), n = $i(e.version), r = e.hasCommittedMutations;
        return new cr(
        /* unknownDocument= */ null, new or(t, n), 
        /* document= */ null, r, s, i);
    }
    if (e instanceof zn) {
        const t = e.key.path.A(), n = $i(e.version);
        return new cr(new ar(t, n), 
        /* noDocument= */ null, 
        /* document= */ null, 
        /* hasCommittedMutations= */ !0, s, i);
    }
    return y();
}

function Fi(t) {
    const e = t.Z();
    return [ e.seconds, e.nanoseconds ];
}

function xi(t) {
    const e = new dt(t[0], t[1]);
    return wt.J(e);
}

function $i(t) {
    const e = t.Z();
    return new er(e.seconds, e.nanoseconds);
}

function ki(t) {
    const e = new dt(t.seconds, t.nanoseconds);
    return wt.J(e);
}

/** Encodes a batch of mutations into a DbMutationBatch for local storage. */
/** Decodes a DbMutationBatch into a MutationBatch */
function Mi(t, e) {
    const n = (e.baseMutations || []).map((e => Ke(t.Co, e))), s = e.mutations.map((e => Ke(t.Co, e))), i = dt.fromMillis(e.localWriteTimeMs);
    return new fi(e.batchId, i, n, s);
}

/** Decodes a DbTarget into TargetData */ function Oi(t) {
    const e = ki(t.readTime), n = void 0 !== t.lastLimboFreeSnapshotVersion ? ki(t.lastLimboFreeSnapshotVersion) : wt.min();
    let s;
    var i;
    return void 0 !== t.query.documents ? (V(1 === (i = t.query).documents.length), 
    s = is(Jn(Le(i.documents[0])))) : s = Ye(t.query), new Vt(s, t.targetId, 0 /* Listen */ , t.lastListenSequenceNumber, e, n, ot.fromBase64String(t.resumeToken));
}

/** Encodes TargetData into a DbTarget for storage locally. */ function Li(t, e) {
    const n = $i(e.nt), s = $i(e.lastLimboFreeSnapshotVersion);
    let i;
    i = yt(e.target) ? ze(t.Co, e.target) : He(t.Co, e.target);
    // We can't store the resumeToken as a ByteString in IndexedDb, so we
    // convert it to a base64 string for storage.
        const r = e.resumeToken.toBase64();
    // lastListenSequenceNumber is always 0 until we do real GC.
        return new hr(e.targetId, Rt(e.target), n, r, e.sequenceNumber, s, i);
}

/**
 * A helper function for figuring out what kind of query has been stored.
 */
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** A mutation queue for a specific user, backed by IndexedDB. */
class Bi {
    constructor(
    /**
     * The normalized userId (e.g. null UID => "" userId) used to store /
     * retrieve mutations.
     */
    t, e, n, s) {
        this.userId = t, this.serializer = e, this.Dr = n, this.No = s, 
        /**
         * Caches the document keys for pending mutation batches. If the mutation
         * has been removed from IndexedDb, the cached value may continue to
         * be used to retrieve the batch's document keys. To remove a cached value
         * locally, `removeCachedMutationKeys()` should be invoked either directly
         * or through `removeMutationBatches()`.
         *
         * With multi-tab, when the primary client acknowledges or rejects a mutation,
         * this cache is used by secondary clients to invalidate the local
         * view of the documents that were previously affected by the mutation.
         */
        // PORTING NOTE: Multi-tab only.
        this.Fo = {};
    }
    /**
     * Creates a new mutation queue for the given user.
     * @param user The user for which to create a mutation queue.
     * @param serializer The serializer to use when persisting to IndexedDb.
     */    static xo(t, e, n, s) {
        // TODO(mcg): Figure out what constraints there are on userIDs
        // In particular, are there any reserved characters? are empty ids allowed?
        // For the moment store these together in the same mutations table assuming
        // that empty userIDs aren't allowed.
        V("" !== t.uid);
        const i = t.Zs() ? t.uid : "";
        return new Bi(i, e, n, s);
    }
    $o(t) {
        let e = !0;
        const n = IDBKeyRange.bound([ this.userId, Number.NEGATIVE_INFINITY ], [ this.userId, Number.POSITIVE_INFINITY ]);
        return Qi(t).rs({
            index: ir.userMutationsIndex,
            range: n
        }, ((t, n, s) => {
            e = !1, s.done();
        })).next((() => e));
    }
    ko(t, e, n, s) {
        const i = Wi(t), r = Qi(t);
        // The IndexedDb implementation in Chrome (and Firefox) does not handle
        // compound indices that include auto-generated keys correctly. To ensure
        // that the index entry is added correctly in all browsers, we perform two
        // writes: The first write is used to retrieve the next auto-generated Batch
        // ID, and the second write populates the index and stores the actual
        // mutation batch.
        // See: https://bugs.chromium.org/p/chromium/issues/detail?id=701972
        // We write an empty object to obtain key
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        return r.add({}).next((o => {
            V("number" == typeof o);
            const a = new fi(o, e, n, s), c = function(t, e, n) {
                const s = n.baseMutations.map((e => je(t.Co, e))), i = n.mutations.map((e => je(t.Co, e)));
                return new ir(e, n.batchId, n.ar.toMillis(), s, i);
            }(this.serializer, this.userId, a), u = [];
            let h = new xt(((t, e) => st(t.R(), e.R())));
            for (const t of s) {
                const e = rr.key(this.userId, t.key.path, o);
                h = h.add(t.key.path.h()), u.push(r.put(c)), u.push(i.put(e, rr.PLACEHOLDER));
            }
            return h.forEach((e => {
                u.push(this.Dr.Mo(t, e));
            })), t.pr((() => {
                this.Fo[o] = a.keys();
            })), Ns.$n(u).next((() => a));
        }));
    }
    Oo(t, e) {
        return Qi(t).get(e).next((t => t ? (V(t.userId === this.userId), Mi(this.serializer, t)) : null));
    }
    /**
     * Returns the document keys for the mutation batch with the given batchId.
     * For primary clients, this method returns `null` after
     * `removeMutationBatches()` has been called. Secondary clients return a
     * cached result until `removeCachedMutationKeys()` is invoked.
     */
    // PORTING NOTE: Multi-tab only.
    Lo(t, e) {
        return this.Fo[e] ? Ns.resolve(this.Fo[e]) : this.Oo(t, e).next((t => {
            if (t) {
                const n = t.keys();
                return this.Fo[e] = n, n;
            }
            return null;
        }));
    }
    Bo(t, e) {
        const n = e + 1, s = IDBKeyRange.lowerBound([ this.userId, n ]);
        let i = null;
        return Qi(t).rs({
            index: ir.userMutationsIndex,
            range: s
        }, ((t, e, s) => {
            e.userId === this.userId && (V(e.batchId >= n), i = Mi(this.serializer, e)), s.done();
        })).next((() => i));
    }
    qo(t) {
        const e = IDBKeyRange.upperBound([ this.userId, Number.POSITIVE_INFINITY ]);
        let n = -1;
        return Qi(t).rs({
            index: ir.userMutationsIndex,
            range: e,
            reverse: !0
        }, ((t, e, s) => {
            n = e.batchId, s.done();
        })).next((() => n));
    }
    Uo(t) {
        const e = IDBKeyRange.bound([ this.userId, -1 ], [ this.userId, Number.POSITIVE_INFINITY ]);
        return Qi(t).ts(ir.userMutationsIndex, e).next((t => t.map((t => Mi(this.serializer, t)))));
    }
    Nr(t, e) {
        // Scan the document-mutation index starting with a prefix starting with
        // the given documentKey.
        const n = rr.prefixForPath(this.userId, e.path), s = IDBKeyRange.lowerBound(n), i = [];
        return Wi(t).rs({
            range: s
        }, ((n, s, r) => {
            const [o, a, c] = n, u = Si(a);
            // Only consider rows matching exactly the specific key of
            // interest. Note that because we order by path first, and we
            // order terminators before path separators, we'll encounter all
            // the index rows for documentKey contiguously. In particular, all
            // the rows for documentKey will occur before any rows for
            // documents nested in a subcollection beneath documentKey so we
            // can stop as soon as we hit any such row.
                        if (o === this.userId && e.path.isEqual(u)) 
            // Look up the mutation batch in the store.
            return Qi(t).get(c).next((t => {
                if (!t) throw y();
                V(t.userId === this.userId), i.push(Mi(this.serializer, t));
            }));
            r.done();
        })).next((() => i));
    }
    Or(t, e) {
        let n = new xt(st);
        const s = [];
        return e.forEach((e => {
            const i = rr.prefixForPath(this.userId, e.path), r = IDBKeyRange.lowerBound(i), o = Wi(t).rs({
                range: r
            }, ((t, s, i) => {
                const [r, o, a] = t, c = Si(o);
                // Only consider rows matching exactly the specific key of
                // interest. Note that because we order by path first, and we
                // order terminators before path separators, we'll encounter all
                // the index rows for documentKey contiguously. In particular, all
                // the rows for documentKey will occur before any rows for
                // documents nested in a subcollection beneath documentKey so we
                // can stop as soon as we hit any such row.
                                r === this.userId && e.path.isEqual(c) ? n = n.add(a) : i.done();
            }));
            s.push(o);
        })), Ns.$n(s).next((() => this.Qo(t, n)));
    }
    Wr(t, e) {
        const n = e.path, s = n.length + 1, i = rr.prefixForPath(this.userId, n), r = IDBKeyRange.lowerBound(i);
        // Collect up unique batchIDs encountered during a scan of the index. Use a
        // SortedSet to accumulate batch IDs so they can be traversed in order in a
        // scan of the main table.
        let o = new xt(st);
        return Wi(t).rs({
            range: r
        }, ((t, e, i) => {
            const [r, a, c] = t, u = Si(a);
            r === this.userId && n.T(u) ? 
            // Rows with document keys more than one segment longer than the
            // query path can't be matches. For example, a query on 'rooms'
            // can't match the document /rooms/abc/messages/xyx.
            // TODO(mcg): we'll need a different scanner when we implement
            // ancestor queries.
            u.length === s && (o = o.add(c)) : i.done();
        })).next((() => this.Qo(t, o)));
    }
    Qo(t, e) {
        const n = [], s = [];
        // TODO(rockwood): Implement this using iterate.
        return e.forEach((e => {
            s.push(Qi(t).get(e).next((t => {
                if (null === t) throw y();
                V(t.userId === this.userId), n.push(Mi(this.serializer, t));
            })));
        })), Ns.$n(s).next((() => n));
    }
    Wo(t, e) {
        return Ui(t.jo, this.userId, e).next((n => (t.pr((() => {
            this.Ko(e.batchId);
        })), Ns.forEach(n, (e => this.No.Go(t, e))))));
    }
    /**
     * Clears the cached keys for a mutation batch. This method should be
     * called by secondary clients after they process mutation updates.
     *
     * Note that this method does not have to be called from primary clients as
     * the corresponding cache entries are cleared when an acknowledged or
     * rejected batch is removed from the mutation queue.
     */
    // PORTING NOTE: Multi-tab only
    Ko(t) {
        delete this.Fo[t];
    }
    zo(t) {
        return this.$o(t).next((e => {
            if (!e) return Ns.resolve();
            // Verify that there are no entries in the documentMutations index if
            // the queue is empty.
                        const n = IDBKeyRange.lowerBound(rr.prefixForUser(this.userId)), s = [];
            return Wi(t).rs({
                range: n
            }, ((t, e, n) => {
                if (t[0] === this.userId) {
                    const e = Si(t[1]);
                    s.push(e);
                } else n.done();
            })).next((() => {
                V(0 === s.length);
            }));
        }));
    }
    Ho(t, e) {
        return qi(t, this.userId, e);
    }
    // PORTING NOTE: Multi-tab only (state is held in memory in other clients).
    /** Returns the mutation queue's metadata from IndexedDb. */
    Yo(t) {
        return ji(t).get(this.userId).next((t => t || new sr(this.userId, -1, 
        /*lastStreamToken=*/ "")));
    }
}

/**
 * @return true if the mutation queue for the given user contains a pending
 *         mutation for the given key.
 */ function qi(t, e, n) {
    const s = rr.prefixForPath(e, n.path), i = s[1], r = IDBKeyRange.lowerBound(s);
    let o = !1;
    return Wi(t).rs({
        range: r,
        ss: !0
    }, ((t, n, s) => {
        const [r, a, /*batchID*/ c] = t;
        r === e && a === i && (o = !0), s.done();
    })).next((() => o));
}

/** Returns true if any mutation queue contains the given document. */
/**
 * Delete a mutation batch and the associated document mutations.
 * @return A PersistencePromise of the document mutations that were removed.
 */
function Ui(t, e, n) {
    const s = t.store(ir.store), i = t.store(rr.store), r = [], o = IDBKeyRange.only(n.batchId);
    let a = 0;
    const c = s.rs({
        range: o
    }, ((t, e, n) => (a++, n.delete())));
    r.push(c.next((() => {
        V(1 === a);
    })));
    const u = [];
    for (const t of n.mutations) {
        const s = rr.key(e, t.key.path, n.batchId);
        r.push(i.delete(s)), u.push(t.key);
    }
    return Ns.$n(r).next((() => u));
}

/**
 * Helper to get a typed SimpleDbStore for the mutations object store.
 */ function Qi(t) {
    return pr.Qn(t, ir.store);
}

/**
 * Helper to get a typed SimpleDbStore for the mutationQueues object store.
 */ function Wi(t) {
    return pr.Qn(t, rr.store);
}

/**
 * Helper to get a typed SimpleDbStore for the mutationQueues object store.
 */ function ji(t) {
    return pr.Qn(t, sr.store);
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * The RemoteDocumentCache for IndexedDb. To construct, invoke
 * `newIndexedDbRemoteDocumentCache()`.
 */ class Ki {
    /**
     * @param serializer The document serializer.
     * @param indexManager The query indexes that need to be maintained.
     */
    constructor(t, e) {
        this.serializer = t, this.Dr = e;
    }
    /**
     * Adds the supplied entries to the cache.
     *
     * All calls of `addEntry` are required to go through the RemoteDocumentChangeBuffer
     * returned by `newChangeBuffer()` to ensure proper accounting of metadata.
     */    Er(t, e, n) {
        return Hi(t).put(Yi(e), n);
    }
    /**
     * Removes a document from the cache.
     *
     * All calls of `removeEntry`  are required to go through the RemoteDocumentChangeBuffer
     * returned by `newChangeBuffer()` to ensure proper accounting of metadata.
     */    Ar(t, e) {
        const n = Hi(t), s = Yi(e);
        return n.delete(s);
    }
    /**
     * Updates the current cache size.
     *
     * Callers to `addEntry()` and `removeEntry()` *must* call this afterwards to update the
     * cache's metadata.
     */    updateMetadata(t, e) {
        return this.getMetadata(t).next((n => (n.byteSize += e, this.Jo(t, n))));
    }
    Rr(t, e) {
        return Hi(t).get(Yi(e)).next((t => this.Xo(t)));
    }
    /**
     * Looks up an entry in the cache.
     *
     * @param documentKey The key of the entry to look up.
     * @return The cached MaybeDocument entry and its size, or null if we have nothing cached.
     */    Zo(t, e) {
        return Hi(t).get(Yi(e)).next((t => {
            const e = this.Xo(t);
            return e ? {
                ta: e,
                size: Ji(t)
            } : null;
        }));
    }
    getEntries(t, e) {
        let n = Ot();
        return this.ea(t, e, ((t, e) => {
            const s = this.Xo(e);
            n = n.ot(t, s);
        })).next((() => n));
    }
    /**
     * Looks up several entries in the cache.
     *
     * @param documentKeys The set of keys entries to look up.
     * @return A map of MaybeDocuments indexed by key (if a document cannot be
     *     found, the key will be mapped to null) and a map of sizes indexed by
     *     key (zero if the key cannot be found).
     */    na(t, e) {
        let n = Ot(), s = new Ct(x.i);
        return this.ea(t, e, ((t, e) => {
            const i = this.Xo(e);
            i ? (n = n.ot(t, i), s = s.ot(t, Ji(e))) : (n = n.ot(t, null), s = s.ot(t, 0));
        })).next((() => ({
            sa: n,
            ia: s
        })));
    }
    ea(t, e, n) {
        if (e.m()) return Ns.resolve();
        const s = IDBKeyRange.bound(e.first().path.A(), e.last().path.A()), i = e._t();
        let r = i.It();
        return Hi(t).rs({
            range: s
        }, ((t, e, s) => {
            const o = x.$(t);
            // Go through keys not found in cache.
                        for (;r && x.i(r, o) < 0; ) n(r, null), r = i.It();
            r && r.isEqual(o) && (
            // Key found in cache.
            n(r, e), r = i.At() ? i.It() : null), 
            // Skip to the next key (if there is one).
            r ? s.Xn(r.path.A()) : s.done();
        })).next((() => {
            // The rest of the keys are not in the cache. One case where `iterate`
            // above won't go through them is when the cache is empty.
            for (;r; ) n(r, null), r = i.At() ? i.It() : null;
        }));
    }
    Lr(t, e, n) {
        let s = Bt();
        const i = e.path.length + 1, r = {};
        if (n.isEqual(wt.min())) {
            // Documents are ordered by key, so we can use a prefix scan to narrow
            // down the documents we need to match the query against.
            const t = e.path.A();
            r.range = IDBKeyRange.lowerBound(t);
        } else {
            // Execute an index-free query and filter by read time. This is safe
            // since all document changes to queries that have a
            // lastLimboFreeSnapshotVersion (`sinceReadTime`) have a read time set.
            const t = e.path.A(), s = Fi(n);
            r.range = IDBKeyRange.lowerBound([ t, s ], 
            /* open= */ !0), r.index = cr.collectionReadTimeIndex;
        }
        return Hi(t).rs(r, ((t, n, r) => {
            // The query is actually returning any path that starts with the query
            // path prefix which may include documents in subcollections. For
            // example, a query on 'rooms' will return rooms/abc/messages/xyx but we
            // shouldn't match it. Fix this by discarding rows with document keys
            // more than one segment longer than the query path.
            if (t.length !== i) return;
            const o = Ci(this.serializer, n);
            e.path.T(o.key.path) ? o instanceof Kn && ls(e, o) && (s = s.ot(o.key, o)) : r.done();
        })).next((() => s));
    }
    ra(t) {
        return new Gi(this, !!t && t.oa);
    }
    aa(t) {
        return this.getMetadata(t).next((t => t.byteSize));
    }
    getMetadata(t) {
        return zi(t).get(ur.key).next((t => (V(!!t), t)));
    }
    Jo(t, e) {
        return zi(t).put(ur.key, e);
    }
    /**
     * Decodes `remoteDoc` and returns the document (or null, if the document
     * corresponds to the format used for sentinel deletes).
     */    Xo(t) {
        if (t) {
            const e = Ci(this.serializer, t);
            return e instanceof Gn && e.version.isEqual(wt.min()) ? null : e;
        }
        return null;
    }
}

/**
 * Creates a new IndexedDbRemoteDocumentCache.
 *
 * @param serializer The document serializer.
 * @param indexManager The query indexes that need to be maintained.
 */
/**
 * Handles the details of adding and updating documents in the IndexedDbRemoteDocumentCache.
 *
 * Unlike the MemoryRemoteDocumentChangeBuffer, the IndexedDb implementation computes the size
 * delta for all submitted changes. This avoids having to re-read all documents from IndexedDb
 * when we apply the changes.
 */
class Gi extends wi {
    /**
     * @param documentCache The IndexedDbRemoteDocumentCache to apply the changes to.
     * @param trackRemovals Whether to create sentinel deletes that can be tracked by
     * `getNewDocumentChanges()`.
     */
    constructor(t, e) {
        super(), this.ca = t, this.oa = e, 
        // A map of document sizes prior to applying the changes in this buffer.
        this.ua = new ft((t => t.toString()), ((t, e) => t.isEqual(e)));
    }
    yr(t) {
        const e = [];
        let n = 0, s = new xt(((t, e) => st(t.R(), e.R())));
        return this.wr.forEach(((i, r) => {
            const o = this.ua.get(i);
            if (r) {
                const a = Ni(this.ca.serializer, r, this.readTime);
                s = s.add(i.path.h());
                const c = Ji(a);
                n += c - o, e.push(this.ca.Er(t, i, a));
            } else if (n -= o, this.oa) {
                // In order to track removals, we store a "sentinel delete" in the
                // RemoteDocumentCache. This entry is represented by a NoDocument
                // with a version of 0 and ignored by `maybeDecodeDocument()` but
                // preserved in `getNewDocumentChanges()`.
                const n = Ni(this.ca.serializer, new Gn(i, wt.min()), this.readTime);
                e.push(this.ca.Er(t, i, n));
            } else e.push(this.ca.Ar(t, i));
        })), s.forEach((n => {
            e.push(this.ca.Dr.Mo(t, n));
        })), e.push(this.ca.updateMetadata(t, n)), Ns.$n(e);
    }
    gr(t, e) {
        // Record the size of everything we load from the cache so we can compute a delta later.
        return this.ca.Zo(t, e).next((t => null === t ? (this.ua.set(e, 0), null) : (this.ua.set(e, t.size), 
        t.ta)));
    }
    Pr(t, e) {
        // Record the size of everything we load from the cache so we can compute
        // a delta later.
        return this.ca.na(t, e).next((({sa: t, ia: e}) => (
        // Note: `getAllFromCache` returns two maps instead of a single map from
        // keys to `DocumentSizeEntry`s. This is to allow returning the
        // `NullableMaybeDocumentMap` directly, without a conversion.
        e.forEach(((t, e) => {
            this.ua.set(t, e);
        })), t)));
    }
}

function zi(t) {
    return pr.Qn(t, ur.store);
}

/**
 * Helper to get a typed SimpleDbStore for the remoteDocuments object store.
 */ function Hi(t) {
    return pr.Qn(t, cr.store);
}

function Yi(t) {
    return t.path.A();
}

/**
 * Retrusn an approximate size for the given document.
 */ function Ji(t) {
    let e;
    if (t.document) e = t.document; else if (t.unknownDocument) e = t.unknownDocument; else {
        if (!t.noDocument) throw y();
        e = t.noDocument;
    }
    return JSON.stringify(e).length;
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * An in-memory implementation of IndexManager.
 */ class Xi {
    constructor() {
        this.ha = new Zi;
    }
    Mo(t, e) {
        return this.ha.add(e), Ns.resolve();
    }
    Qr(t, e) {
        return Ns.resolve(this.ha.getEntries(e));
    }
}

/**
 * Internal implementation of the collection-parent index exposed by MemoryIndexManager.
 * Also used for in-memory caching by IndexedDbIndexManager and initial index population
 * in indexeddb_schema.ts
 */ class Zi {
    constructor() {
        this.index = {};
    }
    // Returns false if the entry already existed.
    add(t) {
        const e = t._(), n = t.h(), s = this.index[e] || new xt(C.i), i = !s.has(n);
        return this.index[e] = s.add(n), i;
    }
    has(t) {
        const e = t._(), n = t.h(), s = this.index[e];
        return s && s.has(n);
    }
    getEntries(t) {
        return (this.index[t] || new xt(C.i)).A();
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Schema Version for the Web client:
 * 1.  Initial version including Mutation Queue, Query Cache, and Remote
 *     Document Cache
 * 2.  Used to ensure a targetGlobal object exists and add targetCount to it. No
 *     longer required because migration 3 unconditionally clears it.
 * 3.  Dropped and re-created Query Cache to deal with cache corruption related
 *     to limbo resolution. Addresses
 *     https://github.com/firebase/firebase-ios-sdk/issues/1548
 * 4.  Multi-Tab Support.
 * 5.  Removal of held write acks.
 * 6.  Create document global for tracking document cache size.
 * 7.  Ensure every cached document has a sentinel row with a sequence number.
 * 8.  Add collection-parent index for Collection Group queries.
 * 9.  Change RemoteDocumentChanges store to be keyed by readTime rather than
 *     an auto-incrementing ID. This is required for Index-Free queries.
 * 10. Rewrite the canonical IDs to the explicit Protobuf-based format.
 */
/** Performs database creation and schema upgrades. */
class tr {
    constructor(t) {
        this.serializer = t;
    }
    /**
     * Performs database creation and schema upgrades.
     *
     * Note that in production, this method is only ever used to upgrade the schema
     * to SCHEMA_VERSION. Different values of toVersion are only used for testing
     * and local feature development.
     */    createOrUpgrade(t, e, n, s) {
        V(n < s && n >= 0 && s <= 10);
        const i = new Ms("createOrUpgrade", e);
        n < 1 && s >= 1 && (function(t) {
            t.createObjectStore(nr.store);
        }
        /**
 * An object to be stored in the 'mutationQueues' store in IndexedDb.
 *
 * Each user gets a single queue of MutationBatches to apply to the server.
 * DbMutationQueue tracks the metadata about the queue.
 */ (t), function(t) {
            t.createObjectStore(sr.store, {
                keyPath: sr.keyPath
            });
            t.createObjectStore(ir.store, {
                keyPath: ir.keyPath,
                autoIncrement: !0
            }).createIndex(ir.userMutationsIndex, ir.userMutationsKeyPath, {
                unique: !0
            }), t.createObjectStore(rr.store);
        }
        /**
 * Upgrade function to migrate the 'mutations' store from V1 to V3. Loads
 * and rewrites all data.
 */ (t), dr(t), function(t) {
            t.createObjectStore(cr.store);
        }
        /**
 * Represents the known absence of a document at a particular version.
 * Stored in IndexedDb as part of a DbRemoteDocument object.
 */ (t));
        // Migration 2 to populate the targetGlobal object no longer needed since
        // migration 3 unconditionally clears it.
                let r = Ns.resolve();
        return n < 3 && s >= 3 && (
        // Brand new clients don't need to drop and recreate--only clients that
        // potentially have corrupt data.
        0 !== n && (!function(t) {
            t.deleteObjectStore(lr.store), t.deleteObjectStore(hr.store), t.deleteObjectStore(_r.store);
        }(t), dr(t)), r = r.next((() => 
        /**
 * Creates the target global singleton row.
 *
 * @param {IDBTransaction} txn The version upgrade transaction for indexeddb
 */
        function(t) {
            const e = t.store(_r.store), n = new _r(
            /*highestTargetId=*/ 0, 
            /*lastListenSequenceNumber=*/ 0, wt.min().Z(), 
            /*targetCount=*/ 0);
            return e.put(_r.key, n);
        }
        /**
 * Creates indices on the RemoteDocuments store used for both multi-tab
 * and Index-Free queries.
 */ (i)))), n < 4 && s >= 4 && (0 !== n && (
        // Schema version 3 uses auto-generated keys to generate globally unique
        // mutation batch IDs (this was previously ensured internally by the
        // client). To migrate to the new schema, we have to read all mutations
        // and write them back out. We preserve the existing batch IDs to guarantee
        // consistency with other object stores. Any further mutation batch IDs will
        // be auto-generated.
        r = r.next((() => function(t, e) {
            return e.store(ir.store).ts().next((n => {
                t.deleteObjectStore(ir.store);
                t.createObjectStore(ir.store, {
                    keyPath: ir.keyPath,
                    autoIncrement: !0
                }).createIndex(ir.userMutationsIndex, ir.userMutationsKeyPath, {
                    unique: !0
                });
                const s = e.store(ir.store), i = n.map((t => s.put(t)));
                return Ns.$n(i);
            }));
        }
        /**
 * An object to be stored in the 'documentMutations' store in IndexedDb.
 *
 * A manually maintained index of all the mutation batches that affect a given
 * document key. The rows in this table are references based on the contents of
 * DbMutationBatch.mutations.
 */ (t, i)))), r = r.next((() => {
            !function(t) {
                t.createObjectStore(wr.store, {
                    keyPath: wr.keyPath
                });
            }
            // Visible for testing
            (t);
        }))), n < 5 && s >= 5 && (r = r.next((() => this.removeAcknowledgedMutations(i)))), 
        n < 6 && s >= 6 && (r = r.next((() => (function(t) {
            t.createObjectStore(ur.store);
        }
        /**
 * An object to be stored in the 'targets' store in IndexedDb.
 *
 * This is based on and should be kept in sync with the proto used in the iOS
 * client.
 *
 * Each query the client listens to against the server is tracked on disk so
 * that the query can be efficiently resumed on restart.
 */ (t), this.addDocumentGlobal(i))))), n < 7 && s >= 7 && (r = r.next((() => this.ensureSequenceNumbers(i)))), 
        n < 8 && s >= 8 && (r = r.next((() => this.createCollectionParentIndex(t, i)))), 
        n < 9 && s >= 9 && (r = r.next((() => {
            // Multi-Tab used to manage its own changelog, but this has been moved
            // to the DbRemoteDocument object store itself. Since the previous change
            // log only contained transient data, we can drop its object store.
            !function(t) {
                t.objectStoreNames.contains("remoteDocumentChanges") && t.deleteObjectStore("remoteDocumentChanges");
            }(t), function(t) {
                const e = t.objectStore(cr.store);
                e.createIndex(cr.readTimeIndex, cr.readTimeIndexPath, {
                    unique: !1
                }), e.createIndex(cr.collectionReadTimeIndex, cr.collectionReadTimeIndexPath, {
                    unique: !1
                });
            }
            /**
 * A record of the metadata state of each client.
 *
 * PORTING NOTE: This is used to synchronize multi-tab state and does not need
 * to be ported to iOS or Android.
 */ (e);
        }))), n < 10 && s >= 10 && (r = r.next((() => this.rewriteCanonicalIds(i)))), r;
    }
    addDocumentGlobal(t) {
        let e = 0;
        return t.store(cr.store).rs(((t, n) => {
            e += Ji(n);
        })).next((() => {
            const n = new ur(e);
            return t.store(ur.store).put(ur.key, n);
        }));
    }
    removeAcknowledgedMutations(t) {
        const e = t.store(sr.store), n = t.store(ir.store);
        return e.ts().next((e => Ns.forEach(e, (e => {
            const s = IDBKeyRange.bound([ e.userId, -1 ], [ e.userId, e.lastAcknowledgedBatchId ]);
            return n.ts(ir.userMutationsIndex, s).next((n => Ns.forEach(n, (n => {
                V(n.userId === e.userId);
                const s = Mi(this.serializer, n);
                return Ui(t, e.userId, s).next((() => {}));
            }))));
        }))));
    }
    /**
     * Ensures that every document in the remote document cache has a corresponding sentinel row
     * with a sequence number. Missing rows are given the most recently used sequence number.
     */    ensureSequenceNumbers(t) {
        const e = t.store(lr.store), n = t.store(cr.store);
        return t.store(_r.store).get(_r.key).next((t => {
            const s = [];
            return n.rs(((n, i) => {
                const r = new C(n), o = function(t) {
                    return [ 0, pi(t) ];
                }
                /**
 * Wrapper class to store timestamps (seconds and nanos) in IndexedDb objects.
 */ (r);
                s.push(e.get(o).next((n => n ? Ns.resolve() : (n => e.put(new lr(0, pi(n), t.highestListenSequenceNumber)))(r))));
            })).next((() => Ns.$n(s)));
        }));
    }
    createCollectionParentIndex(t, e) {
        // Create the index.
        t.createObjectStore(fr.store, {
            keyPath: fr.keyPath
        });
        const n = e.store(fr.store), s = new Zi, i = t => {
            if (s.add(t)) {
                const e = t._(), s = t.h();
                return n.put({
                    collectionId: e,
                    parent: pi(s)
                });
            }
        };
        // Helper to add an index entry iff we haven't already written it.
                // Index existing remote documents.
        return e.store(cr.store).rs({
            ss: !0
        }, ((t, e) => {
            const n = new C(t);
            return i(n.h());
        })).next((() => e.store(rr.store).rs({
            ss: !0
        }, (([t, e, n], s) => {
            const r = Si(e);
            return i(r.h());
        }))));
    }
    rewriteCanonicalIds(t) {
        const e = t.store(hr.store);
        return e.rs(((t, n) => {
            const s = Oi(n), i = Li(this.serializer, s);
            return e.put(i);
        }));
    }
}

class er {
    constructor(t, e) {
        this.seconds = t, this.nanoseconds = e;
    }
}

/**
 * A singleton object to be stored in the 'owner' store in IndexedDb.
 *
 * A given database can have a single primary tab assigned at a given time. That
 * tab must validate that it is still holding the primary lease before every
 * operation that requires locked access. The primary tab should regularly
 * write an updated timestamp to this lease to prevent other tabs from
 * "stealing" the primary lease
 */ class nr {
    constructor(t, 
    /** Whether to allow shared access from multiple tabs. */
    e, n) {
        this.ownerId = t, this.allowTabSynchronization = e, this.leaseTimestampMs = n;
    }
}

/**
 * Name of the IndexedDb object store.
 *
 * Note that the name 'owner' is chosen to ensure backwards compatibility with
 * older clients that only supported single locked access to the persistence
 * layer.
 */ nr.store = "owner", 
/**
 * The key string used for the single object that exists in the
 * DbPrimaryClient store.
 */
nr.key = "owner";

class sr {
    constructor(
    /**
     * The normalized user ID to which this queue belongs.
     */
    t, 
    /**
     * An identifier for the highest numbered batch that has been acknowledged
     * by the server. All MutationBatches in this queue with batchIds less
     * than or equal to this value are considered to have been acknowledged by
     * the server.
     *
     * NOTE: this is deprecated and no longer used by the code.
     */
    e, 
    /**
     * A stream token that was previously sent by the server.
     *
     * See StreamingWriteRequest in datastore.proto for more details about
     * usage.
     *
     * After sending this token, earlier tokens may not be used anymore so
     * only a single stream token is retained.
     *
     * NOTE: this is deprecated and no longer used by the code.
     */
    n) {
        this.userId = t, this.lastAcknowledgedBatchId = e, this.lastStreamToken = n;
    }
}

/** Name of the IndexedDb object store.  */ sr.store = "mutationQueues", 
/** Keys are automatically assigned via the userId property. */
sr.keyPath = "userId";

/**
 * An object to be stored in the 'mutations' store in IndexedDb.
 *
 * Represents a batch of user-level mutations intended to be sent to the server
 * in a single write. Each user-level batch gets a separate DbMutationBatch
 * with a new batchId.
 */
class ir {
    constructor(
    /**
     * The normalized user ID to which this batch belongs.
     */
    t, 
    /**
     * An identifier for this batch, allocated using an auto-generated key.
     */
    e, 
    /**
     * The local write time of the batch, stored as milliseconds since the
     * epoch.
     */
    n, 
    /**
     * A list of "mutations" that represent a partial base state from when this
     * write batch was initially created. During local application of the write
     * batch, these baseMutations are applied prior to the real writes in order
     * to override certain document fields from the remote document cache. This
     * is necessary in the case of non-idempotent writes (e.g. `increment()`
     * transforms) to make sure that the local view of the modified documents
     * doesn't flicker if the remote document cache receives the result of the
     * non-idempotent write before the write is removed from the queue.
     *
     * These mutations are never sent to the backend.
     */
    s, 
    /**
     * A list of mutations to apply. All mutations will be applied atomically.
     *
     * Mutations are serialized via toMutation().
     */
    i) {
        this.userId = t, this.batchId = e, this.localWriteTimeMs = n, this.baseMutations = s, 
        this.mutations = i;
    }
}

/** Name of the IndexedDb object store.  */ ir.store = "mutations", 
/** Keys are automatically assigned via the userId, batchId properties. */
ir.keyPath = "batchId", 
/** The index name for lookup of mutations by user. */
ir.userMutationsIndex = "userMutationsIndex", 
/** The user mutations index is keyed by [userId, batchId] pairs. */
ir.userMutationsKeyPath = [ "userId", "batchId" ];

class rr {
    constructor() {}
    /**
     * Creates a [userId] key for use in the DbDocumentMutations index to iterate
     * over all of a user's document mutations.
     */    static prefixForUser(t) {
        return [ t ];
    }
    /**
     * Creates a [userId, encodedPath] key for use in the DbDocumentMutations
     * index to iterate over all at document mutations for a given path or lower.
     */    static prefixForPath(t, e) {
        return [ t, pi(e) ];
    }
    /**
     * Creates a full index key of [userId, encodedPath, batchId] for inserting
     * and deleting into the DbDocumentMutations index.
     */    static key(t, e, n) {
        return [ t, pi(e), n ];
    }
}

rr.store = "documentMutations", 
/**
 * Because we store all the useful information for this store in the key,
 * there is no useful information to store as the value. The raw (unencoded)
 * path cannot be stored because IndexedDb doesn't store prototype
 * information.
 */
rr.PLACEHOLDER = new rr;

class or {
    constructor(t, e) {
        this.path = t, this.readTime = e;
    }
}

/**
 * Represents a document that is known to exist but whose data is unknown.
 * Stored in IndexedDb as part of a DbRemoteDocument object.
 */ class ar {
    constructor(t, e) {
        this.path = t, this.version = e;
    }
}

/**
 * An object to be stored in the 'remoteDocuments' store in IndexedDb.
 * It represents either:
 *
 * - A complete document.
 * - A "no document" representing a document that is known not to exist (at
 * some version).
 * - An "unknown document" representing a document that is known to exist (at
 * some version) but whose contents are unknown.
 *
 * Note: This is the persisted equivalent of a MaybeDocument and could perhaps
 * be made more general if necessary.
 */ class cr {
    // TODO: We are currently storing full document keys almost three times
    // (once as part of the primary key, once - partly - as `parentPath` and once
    // inside the encoded documents). During our next migration, we should
    // rewrite the primary key as parentPath + document ID which would allow us
    // to drop one value.
    constructor(
    /**
     * Set to an instance of DbUnknownDocument if the data for a document is
     * not known, but it is known that a document exists at the specified
     * version (e.g. it had a successful update applied to it)
     */
    t, 
    /**
     * Set to an instance of a DbNoDocument if it is known that no document
     * exists.
     */
    e, 
    /**
     * Set to an instance of a Document if there's a cached version of the
     * document.
     */
    n, 
    /**
     * Documents that were written to the remote document store based on
     * a write acknowledgment are marked with `hasCommittedMutations`. These
     * documents are potentially inconsistent with the backend's copy and use
     * the write's commit version as their document version.
     */
    s, 
    /**
     * When the document was read from the backend. Undefined for data written
     * prior to schema version 9.
     */
    i, 
    /**
     * The path of the collection this document is part of. Undefined for data
     * written prior to schema version 9.
     */
    r) {
        this.unknownDocument = t, this.noDocument = e, this.document = n, this.hasCommittedMutations = s, 
        this.readTime = i, this.parentPath = r;
    }
}

cr.store = "remoteDocuments", 
/**
 * An index that provides access to all entries sorted by read time (which
 * corresponds to the last modification time of each row).
 *
 * This index is used to provide a changelog for Multi-Tab.
 */
cr.readTimeIndex = "readTimeIndex", cr.readTimeIndexPath = "readTime", 
/**
 * An index that provides access to documents in a collection sorted by read
 * time.
 *
 * This index is used to allow the RemoteDocumentCache to fetch newly changed
 * documents in a collection.
 */
cr.collectionReadTimeIndex = "collectionReadTimeIndex", cr.collectionReadTimeIndexPath = [ "parentPath", "readTime" ];

/**
 * Contains a single entry that has metadata about the remote document cache.
 */
class ur {
    /**
     * @param byteSize Approximately the total size in bytes of all the documents in the document
     * cache.
     */
    constructor(t) {
        this.byteSize = t;
    }
}

ur.store = "remoteDocumentGlobal", ur.key = "remoteDocumentGlobalKey";

class hr {
    constructor(
    /**
     * An auto-generated sequential numeric identifier for the query.
     *
     * Queries are stored using their canonicalId as the key, but these
     * canonicalIds can be quite long so we additionally assign a unique
     * queryId which can be used by referenced data structures (e.g.
     * indexes) to minimize the on-disk cost.
     */
    t, 
    /**
     * The canonical string representing this query. This is not unique.
     */
    e, 
    /**
     * The last readTime received from the Watch Service for this query.
     *
     * This is the same value as TargetChange.read_time in the protos.
     */
    n, 
    /**
     * An opaque, server-assigned token that allows watching a query to be
     * resumed after disconnecting without retransmitting all the data
     * that matches the query. The resume token essentially identifies a
     * point in time from which the server should resume sending results.
     *
     * This is related to the snapshotVersion in that the resumeToken
     * effectively also encodes that value, but the resumeToken is opaque
     * and sometimes encodes additional information.
     *
     * A consequence of this is that the resumeToken should be used when
     * asking the server to reason about where this client is in the watch
     * stream, but the client should use the snapshotVersion for its own
     * purposes.
     *
     * This is the same value as TargetChange.resume_token in the protos.
     */
    s, 
    /**
     * A sequence number representing the last time this query was
     * listened to, used for garbage collection purposes.
     *
     * Conventionally this would be a timestamp value, but device-local
     * clocks are unreliable and they must be able to create new listens
     * even while disconnected. Instead this should be a monotonically
     * increasing number that's incremented on each listen call.
     *
     * This is different from the queryId since the queryId is an
     * immutable identifier assigned to the Query on first use while
     * lastListenSequenceNumber is updated every time the query is
     * listened to.
     */
    i, 
    /**
     * Denotes the maximum snapshot version at which the associated query view
     * contained no limbo documents.  Undefined for data written prior to
     * schema version 9.
     */
    r, 
    /**
     * The query for this target.
     *
     * Because canonical ids are not unique we must store the actual query. We
     * use the proto to have an object we can persist without having to
     * duplicate translation logic to and from a `Query` object.
     */
    o) {
        this.targetId = t, this.canonicalId = e, this.readTime = n, this.resumeToken = s, 
        this.lastListenSequenceNumber = i, this.lastLimboFreeSnapshotVersion = r, this.query = o;
    }
}

hr.store = "targets", 
/** Keys are automatically assigned via the targetId property. */
hr.keyPath = "targetId", 
/** The name of the queryTargets index. */
hr.queryTargetsIndexName = "queryTargetsIndex", 
/**
 * The index of all canonicalIds to the targets that they match. This is not
 * a unique mapping because canonicalId does not promise a unique name for all
 * possible queries, so we append the targetId to make the mapping unique.
 */
hr.queryTargetsKeyPath = [ "canonicalId", "targetId" ];

/**
 * An object representing an association between a target and a document, or a
 * sentinel row marking the last sequence number at which a document was used.
 * Each document cached must have a corresponding sentinel row before lru
 * garbage collection is enabled.
 *
 * The target associations and sentinel rows are co-located so that orphaned
 * documents and their sequence numbers can be identified efficiently via a scan
 * of this store.
 */
class lr {
    constructor(
    /**
     * The targetId identifying a target or 0 for a sentinel row.
     */
    t, 
    /**
     * The path to the document, as encoded in the key.
     */
    e, 
    /**
     * If this is a sentinel row, this should be the sequence number of the last
     * time the document specified by `path` was used. Otherwise, it should be
     * `undefined`.
     */
    n) {
        this.targetId = t, this.path = e, this.sequenceNumber = n;
    }
}

/** Name of the IndexedDb object store.  */ lr.store = "targetDocuments", 
/** Keys are automatically assigned via the targetId, path properties. */
lr.keyPath = [ "targetId", "path" ], 
/** The index name for the reverse index. */
lr.documentTargetsIndex = "documentTargetsIndex", 
/** We also need to create the reverse index for these properties. */
lr.documentTargetsKeyPath = [ "path", "targetId" ];

/**
 * A record of global state tracked across all Targets, tracked separately
 * to avoid the need for extra indexes.
 *
 * This should be kept in-sync with the proto used in the iOS client.
 */
class _r {
    constructor(
    /**
     * The highest numbered target id across all targets.
     *
     * See DbTarget.targetId.
     */
    t, 
    /**
     * The highest numbered lastListenSequenceNumber across all targets.
     *
     * See DbTarget.lastListenSequenceNumber.
     */
    e, 
    /**
     * A global snapshot version representing the last consistent snapshot we
     * received from the backend. This is monotonically increasing and any
     * snapshots received from the backend prior to this version (e.g. for
     * targets resumed with a resumeToken) should be suppressed (buffered)
     * until the backend has caught up to this snapshot version again. This
     * prevents our cache from ever going backwards in time.
     */
    n, 
    /**
     * The number of targets persisted.
     */
    s) {
        this.highestTargetId = t, this.highestListenSequenceNumber = e, this.lastRemoteSnapshotVersion = n, 
        this.targetCount = s;
    }
}

/**
 * The key string used for the single object that exists in the
 * DbTargetGlobal store.
 */ _r.key = "targetGlobalKey", _r.store = "targetGlobal";

/**
 * An object representing an association between a Collection id (e.g. 'messages')
 * to a parent path (e.g. '/chats/123') that contains it as a (sub)collection.
 * This is used to efficiently find all collections to query when performing
 * a Collection Group query.
 */
class fr {
    constructor(
    /**
     * The collectionId (e.g. 'messages')
     */
    t, 
    /**
     * The path to the parent (either a document location or an empty path for
     * a root-level collection).
     */
    e) {
        this.collectionId = t, this.parent = e;
    }
}

/** Name of the IndexedDb object store. */ function dr(t) {
    t.createObjectStore(lr.store, {
        keyPath: lr.keyPath
    }).createIndex(lr.documentTargetsIndex, lr.documentTargetsKeyPath, {
        unique: !0
    });
    // NOTE: This is unique only because the TargetId is the suffix.
    t.createObjectStore(hr.store, {
        keyPath: hr.keyPath
    }).createIndex(hr.queryTargetsIndexName, hr.queryTargetsKeyPath, {
        unique: !0
    }), t.createObjectStore(_r.store);
}

fr.store = "collectionParents", 
/** Keys are automatically assigned via the collectionId, parent properties. */
fr.keyPath = [ "collectionId", "parent" ];

class wr {
    constructor(
    // Note: Previous schema versions included a field
    // "lastProcessedDocumentChangeId". Don't use anymore.
    /** The auto-generated client id assigned at client startup. */
    t, 
    /** The last time this state was updated. */
    e, 
    /** Whether the client's network connection is enabled. */
    n, 
    /** Whether this client is running in a foreground tab. */
    s) {
        this.clientId = t, this.updateTimeMs = e, this.networkEnabled = n, this.inForeground = s;
    }
}

/** Name of the IndexedDb object store. */ wr.store = "clientMetadata", 
/** Keys are automatically assigned via the clientId properties. */
wr.keyPath = "clientId";

const mr = [ ...[ ...[ ...[ sr.store, ir.store, rr.store, cr.store, hr.store, nr.store, _r.store, lr.store ], wr.store ], ur.store ], fr.store ];

// V2 is no longer usable (see comment at top of file)
// Visible for testing
/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A persisted implementation of IndexManager.
 */
class Tr {
    constructor() {
        /**
         * An in-memory copy of the index entries we've already written since the SDK
         * launched. Used to avoid re-writing the same entry repeatedly.
         *
         * This is *NOT* a complete cache of what's in persistence and so can never be used to
         * satisfy reads.
         */
        this.la = new Zi;
    }
    /**
     * Adds a new entry to the collection parent index.
     *
     * Repeated calls for the same collectionPath should be avoided within a
     * transaction as IndexedDbIndexManager only caches writes once a transaction
     * has been committed.
     */    Mo(t, e) {
        if (!this.la.has(e)) {
            const n = e._(), s = e.h();
            t.pr((() => {
                // Add the collection to the in memory cache only if the transaction was
                // successfully committed.
                this.la.add(e);
            }));
            const i = {
                collectionId: n,
                parent: pi(s)
            };
            return Er(t).put(i);
        }
        return Ns.resolve();
    }
    Qr(t, e) {
        const n = [], s = IDBKeyRange.bound([ e, "" ], [ rt(e), "" ], 
        /*lowerOpen=*/ !1, 
        /*upperOpen=*/ !0);
        return Er(t).ts(s).next((t => {
            for (const s of t) {
                // This collectionId guard shouldn't be necessary (and isn't as long
                // as we're running in a real browser), but there's a bug in
                // indexeddbshim that breaks our range in our tests running in node:
                // https://github.com/axemclion/IndexedDBShim/issues/334
                if (s.collectionId !== e) break;
                n.push(Si(s.parent));
            }
            return n;
        }));
    }
}

/**
 * Helper to get a typed SimpleDbStore for the collectionParents
 * document store.
 */ function Er(t) {
    return pr.Qn(t, fr.store);
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** Offset to ensure non-overlapping target ids. */
/**
 * Generates monotonically increasing target IDs for sending targets to the
 * watch stream.
 *
 * The client constructs two generators, one for the target cache, and one for
 * for the sync engine (to generate limbo documents targets). These
 * generators produce non-overlapping IDs (by using even and odd IDs
 * respectively).
 *
 * By separating the target ID space, the query cache can generate target IDs
 * that persist across client restarts, while sync engine can independently
 * generate in-memory target IDs that are transient and can be reused after a
 * restart.
 */
class Ir {
    constructor(t) {
        this._a = t;
    }
    next() {
        return this._a += 2, this._a;
    }
    static fa() {
        // The target cache generator must return '2' in its first call to `next()`
        // as there is no differentiation in the protocol layer between an unset
        // number and the number '0'. If we were to sent a target with target ID
        // '0', the backend would consider it unset and replace it with its own ID.
        return new Ir(0);
    }
    static da() {
        // Sync engine assigns target IDs for limbo document detection.
        return new Ir(-1);
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ class Ar {
    constructor(t, e) {
        this.No = t, this.serializer = e;
    }
    // PORTING NOTE: We don't cache global metadata for the target cache, since
    // some of it (in particular `highestTargetId`) can be modified by secondary
    // tabs. We could perhaps be more granular (and e.g. still cache
    // `lastRemoteSnapshotVersion` in memory) but for simplicity we currently go
    // to IndexedDb whenever we need to read metadata. We can revisit if it turns
    // out to have a meaningful performance impact.
    wa(t) {
        return this.ma(t).next((e => {
            const n = new Ir(e.highestTargetId);
            return e.highestTargetId = n.next(), this.Ta(t, e).next((() => e.highestTargetId));
        }));
    }
    Ea(t) {
        return this.ma(t).next((t => wt.J(new dt(t.lastRemoteSnapshotVersion.seconds, t.lastRemoteSnapshotVersion.nanoseconds))));
    }
    Ia(t) {
        return this.ma(t).next((t => t.highestListenSequenceNumber));
    }
    Aa(t, e, n) {
        return this.ma(t).next((s => (s.highestListenSequenceNumber = e, n && (s.lastRemoteSnapshotVersion = n.Z()), 
        e > s.highestListenSequenceNumber && (s.highestListenSequenceNumber = e), this.Ta(t, s))));
    }
    Ra(t, e) {
        return this.ga(t, e).next((() => this.ma(t).next((n => (n.targetCount += 1, this.Pa(e, n), 
        this.Ta(t, n))))));
    }
    ya(t, e) {
        return this.ga(t, e);
    }
    Va(t, e) {
        return this.pa(t, e.targetId).next((() => Rr(t).delete(e.targetId))).next((() => this.ma(t))).next((e => (V(e.targetCount > 0), 
        e.targetCount -= 1, this.Ta(t, e))));
    }
    /**
     * Drops any targets with sequence number less than or equal to the upper bound, excepting those
     * present in `activeTargetIds`. Document associations for the removed targets are also removed.
     * Returns the number of targets removed.
     */    po(t, e, n) {
        let s = 0;
        const i = [];
        return Rr(t).rs(((r, o) => {
            const a = Oi(o);
            a.sequenceNumber <= e && null === n.get(a.targetId) && (s++, i.push(this.Va(t, a)));
        })).next((() => Ns.$n(i))).next((() => s));
    }
    /**
     * Call provided function with each `TargetData` that we have cached.
     */    Ce(t, e) {
        return Rr(t).rs(((t, n) => {
            const s = Oi(n);
            e(s);
        }));
    }
    ma(t) {
        return gr(t).get(_r.key).next((t => (V(null !== t), t)));
    }
    Ta(t, e) {
        return gr(t).put(_r.key, e);
    }
    ga(t, e) {
        return Rr(t).put(Li(this.serializer, e));
    }
    /**
     * In-place updates the provided metadata to account for values in the given
     * TargetData. Saving is done separately. Returns true if there were any
     * changes to the metadata.
     */    Pa(t, e) {
        let n = !1;
        return t.targetId > e.highestTargetId && (e.highestTargetId = t.targetId, n = !0), 
        t.sequenceNumber > e.highestListenSequenceNumber && (e.highestListenSequenceNumber = t.sequenceNumber, 
        n = !0), n;
    }
    ba(t) {
        return this.ma(t).next((t => t.targetCount));
    }
    va(t, e) {
        // Iterating by the canonicalId may yield more than one result because
        // canonicalId values are not required to be unique per target. This query
        // depends on the queryTargets index to be efficient.
        const n = Rt(e), s = IDBKeyRange.bound([ n, Number.NEGATIVE_INFINITY ], [ n, Number.POSITIVE_INFINITY ]);
        let i = null;
        return Rr(t).rs({
            range: s,
            index: hr.queryTargetsIndexName
        }, ((t, n, s) => {
            const r = Oi(n);
            // After finding a potential match, check that the target is
            // actually equal to the requested target.
                        Pt(e, r.target) && (i = r, s.done());
        })).next((() => i));
    }
    Sa(t, e, n) {
        // PORTING NOTE: The reverse index (documentsTargets) is maintained by
        // IndexedDb.
        const s = [], i = Pr(t);
        return e.forEach((e => {
            const r = pi(e.path);
            s.push(i.put(new lr(n, r))), s.push(this.No.Da(t, n, e));
        })), Ns.$n(s);
    }
    Ca(t, e, n) {
        // PORTING NOTE: The reverse index (documentsTargets) is maintained by
        // IndexedDb.
        const s = Pr(t);
        return Ns.forEach(e, (e => {
            const i = pi(e.path);
            return Ns.$n([ s.delete([ n, i ]), this.No.Na(t, n, e) ]);
        }));
    }
    pa(t, e) {
        const n = Pr(t), s = IDBKeyRange.bound([ e ], [ e + 1 ], 
        /*lowerOpen=*/ !1, 
        /*upperOpen=*/ !0);
        return n.delete(s);
    }
    Fa(t, e) {
        const n = IDBKeyRange.bound([ e ], [ e + 1 ], 
        /*lowerOpen=*/ !1, 
        /*upperOpen=*/ !0), s = Pr(t);
        let i = Qt();
        return s.rs({
            range: n,
            ss: !0
        }, ((t, e, n) => {
            const s = Si(t[1]), r = new x(s);
            i = i.add(r);
        })).next((() => i));
    }
    Ho(t, e) {
        const n = pi(e.path), s = IDBKeyRange.bound([ n ], [ rt(n) ], 
        /*lowerOpen=*/ !1, 
        /*upperOpen=*/ !0);
        let i = 0;
        return Pr(t).rs({
            index: lr.documentTargetsIndex,
            ss: !0,
            range: s
        }, (([t, e], n, s) => {
            // Having a sentinel row for a document does not count as containing that document;
            // For the target cache, containing the document means the document is part of some
            // target.
            0 !== t && (i++, s.done());
        })).next((() => i > 0));
    }
    /**
     * Looks up a TargetData entry by target ID.
     *
     * @param targetId The target ID of the TargetData entry to look up.
     * @return The cached TargetData entry, or null if the cache has no entry for
     * the target.
     */
    // PORTING NOTE: Multi-tab only.
    Ue(t, e) {
        return Rr(t).get(e).next((t => t ? Oi(t) : null));
    }
}

/**
 * Helper to get a typed SimpleDbStore for the queries object store.
 */ function Rr(t) {
    return pr.Qn(t, hr.store);
}

/**
 * Helper to get a typed SimpleDbStore for the target globals object store.
 */ function gr(t) {
    return pr.Qn(t, _r.store);
}

/**
 * Helper to get a typed SimpleDbStore for the document target object store.
 */ function Pr(t) {
    return pr.Qn(t, lr.store);
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ const yr = "Failed to obtain exclusive access to the persistence layer. To allow shared access, make sure to invoke `enablePersistence()` with `synchronizeTabs:true` in all tabs. If you are using `experimentalForceOwningTab:true`, make sure that only one tab has persistence enabled at any given time.";

/**
 * Oldest acceptable age in milliseconds for client metadata before the client
 * is considered inactive and its associated data is garbage collected.
 */ class Vr extends Ti {
    constructor(t, e) {
        super(), this.jo = t, this.xa = e;
    }
}

/**
 * An IndexedDB-backed instance of Persistence. Data is stored persistently
 * across sessions.
 *
 * On Web only, the Firestore SDKs support shared access to its persistence
 * layer. This allows multiple browser tabs to read and write to IndexedDb and
 * to synchronize state even without network connectivity. Shared access is
 * currently optional and not enabled unless all clients invoke
 * `enablePersistence()` with `{synchronizeTabs:true}`.
 *
 * In multi-tab mode, if multiple clients are active at the same time, the SDK
 * will designate one client as the “primary client”. An effort is made to pick
 * a visible, network-connected and active client, and this client is
 * responsible for letting other clients know about its presence. The primary
 * client writes a unique client-generated identifier (the client ID) to
 * IndexedDb’s “owner” store every 4 seconds. If the primary client fails to
 * update this entry, another client can acquire the lease and take over as
 * primary.
 *
 * Some persistence operations in the SDK are designated as primary-client only
 * operations. This includes the acknowledgment of mutations and all updates of
 * remote documents. The effects of these operations are written to persistence
 * and then broadcast to other tabs via LocalStorage (see
 * `WebStorageSharedClientState`), which then refresh their state from
 * persistence.
 *
 * Similarly, the primary client listens to notifications sent by secondary
 * clients to discover persistence changes written by secondary clients, such as
 * the addition of new mutations and query targets.
 *
 * If multi-tab is not enabled and another tab already obtained the primary
 * lease, IndexedDbPersistence enters a failed state and all subsequent
 * operations will automatically fail.
 *
 * Additionally, there is an optimization so that when a tab is closed, the
 * primary lease is released immediately (this is especially important to make
 * sure that a refreshed tab is able to immediately re-acquire the primary
 * lease). Unfortunately, IndexedDB cannot be reliably used in window.unload
 * since it is an asynchronous API. So in addition to attempting to give up the
 * lease, the leaseholder writes its client ID to a "zombiedClient" entry in
 * LocalStorage which acts as an indicator that another tab should go ahead and
 * take the primary lease immediately regardless of the current lease timestamp.
 *
 * TODO(b/114226234): Remove `synchronizeTabs` section when multi-tab is no
 * longer optional.
 */ class pr {
    constructor(
    /**
     * Whether to synchronize the in-memory state of multiple tabs and share
     * access to local persistence.
     */
    t, e, n, s, i, r, o, a, c, 
    /**
     * If set to true, forcefully obtains database access. Existing tabs will
     * no longer be able to access IndexedDB.
     */
    u) {
        if (this.allowTabSynchronization = t, this.persistenceKey = e, this.clientId = n, 
        this.fn = i, this.window = r, this.document = o, this.$a = c, this.ka = u, this.Ma = null, 
        this.Oa = !1, this.isPrimary = !1, this.networkEnabled = !0, 
        /** Our window.unload handler, if registered. */
        this.La = null, this.inForeground = !1, 
        /** Our 'visibilitychange' listener if registered. */
        this.Ba = null, 
        /** The client metadata refresh task. */
        this.qa = null, 
        /** The last time we garbage collected the client metadata object store. */
        this.Ua = Number.NEGATIVE_INFINITY, 
        /** A listener to notify on primary state changes. */
        this.Qa = t => Promise.resolve(), !pr.Ln()) throw new T(m.UNIMPLEMENTED, "This platform is either missing IndexedDB or is known to have an incomplete implementation. Offline persistence has been disabled.");
        this.No = new Sr(this, s), this.Wa = e + "main", this.serializer = new Di(a), this.ja = new Fs(this.Wa, 10, new tr(this.serializer)), 
        this.Ka = new Ar(this.No, this.serializer), this.Dr = new Tr, this.vr = function(t, e) {
            return new Ki(t, e);
        }
        /**
 * Returns the set of documents that have changed since the specified read
 * time.
 */
        // PORTING NOTE: This is only used for multi-tab synchronization.
        (this.serializer, this.Dr), this.window && this.window.localStorage ? this.Ga = this.window.localStorage : (this.Ga = null, 
        !1 === u && R("IndexedDbPersistence", "LocalStorage is unavailable. As a result, persistence may not work reliably. In particular enablePersistence() could fail immediately after refreshing the page."));
    }
    static Qn(t, e) {
        if (t instanceof Vr) return Fs.Qn(t.jo, e);
        throw y();
    }
    /**
     * Attempt to start IndexedDb persistence.
     *
     * @return {Promise<void>} Whether persistence was enabled.
     */    start() {
        // NOTE: This is expected to fail sometimes (in the case of another tab
        // already having the persistence lock), so it's the first thing we should
        // do.
        return this.za().then((() => {
            if (!this.isPrimary && !this.allowTabSynchronization) 
            // Fail `start()` if `synchronizeTabs` is disabled and we cannot
            // obtain the primary lease.
            throw new T(m.FAILED_PRECONDITION, yr);
            return this.Ha(), this.Ya(), this.Ja(), this.runTransaction("getHighestListenSequenceNumber", "readonly", (t => this.Ka.Ia(t)));
        })).then((t => {
            this.Ma = new ni(t, this.$a);
        })).then((() => {
            this.Oa = !0;
        })).catch((t => (this.ja && this.ja.close(), Promise.reject(t))));
    }
    /**
     * Registers a listener that gets called when the primary state of the
     * instance changes. Upon registering, this listener is invoked immediately
     * with the current primary state.
     *
     * PORTING NOTE: This is only used for Web multi-tab.
     */    Xa(t) {
        return this.Qa = async e => {
            if (this.Ei) return t(e);
        }, t(this.isPrimary);
    }
    /**
     * Registers a listener that gets called when the database receives a
     * version change event indicating that it has deleted.
     *
     * PORTING NOTE: This is only used for Web multi-tab.
     */    Za(t) {
        this.ja.Kn((async e => {
            // Check if an attempt is made to delete IndexedDB.
            null === e.newVersion && await t();
        }));
    }
    /**
     * Adjusts the current network state in the client's metadata, potentially
     * affecting the primary lease.
     *
     * PORTING NOTE: This is only used for Web multi-tab.
     */    tc(t) {
        this.networkEnabled !== t && (this.networkEnabled = t, 
        // Schedule a primary lease refresh for immediate execution. The eventual
        // lease update will be propagated via `primaryStateListener`.
        this.fn.ws((async () => {
            this.Ei && await this.za();
        })));
    }
    /**
     * Updates the client metadata in IndexedDb and attempts to either obtain or
     * extend the primary lease for the local client. Asynchronously notifies the
     * primary state listener if the client either newly obtained or released its
     * primary lease.
     */    za() {
        return this.runTransaction("updateClientMetadataAndTryBecomePrimary", "readwrite", (t => vr(t).put(new wr(this.clientId, Date.now(), this.networkEnabled, this.inForeground)).next((() => {
            if (this.isPrimary) return this.ec(t).next((t => {
                t || (this.isPrimary = !1, this.fn.Cs((() => this.Qa(!1))));
            }));
        })).next((() => this.nc(t))).next((e => this.isPrimary && !e ? this.sc(t).next((() => !1)) : !!e && this.ic(t).next((() => !0)))))).catch((t => {
            if (ks(t)) 
            // Proceed with the existing state. Any subsequent access to
            // IndexedDB will verify the lease.
            return A("IndexedDbPersistence", "Failed to extend owner lease: ", t), this.isPrimary;
            if (!this.allowTabSynchronization) throw t;
            return A("IndexedDbPersistence", "Releasing owner lease after error during lease refresh", t), 
            /* isPrimary= */ !1;
        })).then((t => {
            this.isPrimary !== t && this.fn.Cs((() => this.Qa(t))), this.isPrimary = t;
        }));
    }
    ec(t) {
        return br(t).get(nr.key).next((t => Ns.resolve(this.rc(t))));
    }
    oc(t) {
        return vr(t).delete(this.clientId);
    }
    /**
     * If the garbage collection threshold has passed, prunes the
     * RemoteDocumentChanges and the ClientMetadata store based on the last update
     * time of all clients.
     */    async ac() {
        if (this.isPrimary && !this.cc(this.Ua, 18e5)) {
            this.Ua = Date.now();
            const t = await this.runTransaction("maybeGarbageCollectMultiClientState", "readwrite-primary", (t => {
                const e = pr.Qn(t, wr.store);
                return e.ts().next((t => {
                    const n = this.uc(t, 18e5), s = t.filter((t => -1 === n.indexOf(t)));
                    // Delete metadata for clients that are no longer considered active.
                    return Ns.forEach(s, (t => e.delete(t.clientId))).next((() => s));
                }));
            })).catch((() => []));
            // Delete potential leftover entries that may continue to mark the
            // inactive clients as zombied in LocalStorage.
            // Ideally we'd delete the IndexedDb and LocalStorage zombie entries for
            // the client atomically, but we can't. So we opt to delete the IndexedDb
            // entries first to avoid potentially reviving a zombied client.
                        if (this.Ga) for (const e of t) this.Ga.removeItem(this.hc(e.clientId));
        }
    }
    /**
     * Schedules a recurring timer to update the client metadata and to either
     * extend or acquire the primary lease if the client is eligible.
     */    Ja() {
        this.qa = this.fn.yn("client_metadata_refresh" /* ClientMetadataRefresh */ , 4e3, (() => this.za().then((() => this.ac())).then((() => this.Ja()))));
    }
    /** Checks whether `client` is the local client. */    rc(t) {
        return !!t && t.ownerId === this.clientId;
    }
    /**
     * Evaluate the state of all active clients and determine whether the local
     * client is or can act as the holder of the primary lease. Returns whether
     * the client is eligible for the lease, but does not actually acquire it.
     * May return 'false' even if there is no active leaseholder and another
     * (foreground) client should become leaseholder instead.
     */    nc(t) {
        if (this.ka) return Ns.resolve(!0);
        return br(t).get(nr.key).next((e => {
            // A client is eligible for the primary lease if:
            // - its network is enabled and the client's tab is in the foreground.
            // - its network is enabled and no other client's tab is in the
            //   foreground.
            // - every clients network is disabled and the client's tab is in the
            //   foreground.
            // - every clients network is disabled and no other client's tab is in
            //   the foreground.
            // - the `forceOwningTab` setting was passed in.
            if (null !== e && this.cc(e.leaseTimestampMs, 5e3) && !this.lc(e.ownerId)) {
                if (this.rc(e) && this.networkEnabled) return !0;
                if (!this.rc(e)) {
                    if (!e.allowTabSynchronization) 
                    // Fail the `canActAsPrimary` check if the current leaseholder has
                    // not opted into multi-tab synchronization. If this happens at
                    // client startup, we reject the Promise returned by
                    // `enablePersistence()` and the user can continue to use Firestore
                    // with in-memory persistence.
                    // If this fails during a lease refresh, we will instead block the
                    // AsyncQueue from executing further operations. Note that this is
                    // acceptable since mixing & matching different `synchronizeTabs`
                    // settings is not supported.
                    // TODO(b/114226234): Remove this check when `synchronizeTabs` can
                    // no longer be turned off.
                    throw new T(m.FAILED_PRECONDITION, yr);
                    return !1;
                }
            }
            return !(!this.networkEnabled || !this.inForeground) || vr(t).ts().next((t => void 0 === this.uc(t, 5e3).find((t => {
                if (this.clientId !== t.clientId) {
                    const e = !this.networkEnabled && t.networkEnabled, n = !this.inForeground && t.inForeground, s = this.networkEnabled === t.networkEnabled;
                    if (e || n && s) return !0;
                }
                return !1;
            }))));
        })).next((t => (this.isPrimary !== t && A("IndexedDbPersistence", `Client ${t ? "is" : "is not"} eligible for a primary lease.`), 
        t)));
    }
    async Di() {
        // The shutdown() operations are idempotent and can be called even when
        // start() aborted (e.g. because it couldn't acquire the persistence lease).
        this.Oa = !1, this._c(), this.qa && (this.qa.cancel(), this.qa = null), this.fc(), 
        this.dc(), 
        // Use `SimpleDb.runTransaction` directly to avoid failing if another tab
        // has obtained the primary lease.
        await this.ja.runTransaction("shutdown", "readwrite", [ nr.store, wr.store ], (t => {
            const e = new Vr(t, ni.ai);
            return this.sc(e).next((() => this.oc(e)));
        })), this.ja.close(), 
        // Remove the entry marking the client as zombied from LocalStorage since
        // we successfully deleted its metadata from IndexedDb.
        this.wc();
    }
    /**
     * Returns clients that are not zombied and have an updateTime within the
     * provided threshold.
     */    uc(t, e) {
        return t.filter((t => this.cc(t.updateTimeMs, e) && !this.lc(t.clientId)));
    }
    /**
     * Returns the IDs of the clients that are currently active. If multi-tab
     * is not supported, returns an array that only contains the local client's
     * ID.
     *
     * PORTING NOTE: This is only used for Web multi-tab.
     */    pi() {
        return this.runTransaction("getActiveClients", "readonly", (t => vr(t).ts().next((t => this.uc(t, 18e5).map((t => t.clientId))))));
    }
    get Ei() {
        return this.Oa;
    }
    mc(t) {
        return Bi.xo(t, this.serializer, this.Dr, this.No);
    }
    Tc() {
        return this.Ka;
    }
    Ec() {
        return this.vr;
    }
    Ic() {
        return this.Dr;
    }
    runTransaction(t, e, n) {
        A("IndexedDbPersistence", "Starting transaction:", t);
        const s = "readonly" === e ? "readonly" : "readwrite";
        let i;
        // Do all transactions as readwrite against all object stores, since we
        // are the only reader/writer.
                return this.ja.runTransaction(t, s, mr, (s => (i = new Vr(s, this.Ma ? this.Ma.next() : ni.ai), 
        "readwrite-primary" === e ? this.ec(i).next((t => !!t || this.nc(i))).next((e => {
            if (!e) throw R(`Failed to obtain primary lease for action '${t}'.`), this.isPrimary = !1, 
            this.fn.Cs((() => this.Qa(!1))), new T(m.FAILED_PRECONDITION, mi);
            return n(i);
        })).next((t => this.ic(i).next((() => t)))) : this.Ac(i).next((() => n(i)))))).then((t => (i.br(), 
        t)));
    }
    /**
     * Verifies that the current tab is the primary leaseholder or alternatively
     * that the leaseholder has opted into multi-tab synchronization.
     */
    // TODO(b/114226234): Remove this check when `synchronizeTabs` can no longer
    // be turned off.
    Ac(t) {
        return br(t).get(nr.key).next((t => {
            if (null !== t && this.cc(t.leaseTimestampMs, 5e3) && !this.lc(t.ownerId) && !this.rc(t) && !(this.ka || this.allowTabSynchronization && t.allowTabSynchronization)) throw new T(m.FAILED_PRECONDITION, yr);
        }));
    }
    /**
     * Obtains or extends the new primary lease for the local client. This
     * method does not verify that the client is eligible for this lease.
     */    ic(t) {
        const e = new nr(this.clientId, this.allowTabSynchronization, Date.now());
        return br(t).put(nr.key, e);
    }
    static Ln() {
        return Fs.Ln();
    }
    /** Checks the primary lease and removes it if we are the current primary. */    sc(t) {
        const e = br(t);
        return e.get(nr.key).next((t => this.rc(t) ? (A("IndexedDbPersistence", "Releasing primary lease."), 
        e.delete(nr.key)) : Ns.resolve()));
    }
    /** Verifies that `updateTimeMs` is within `maxAgeMs`. */    cc(t, e) {
        const n = Date.now();
        return !(t < n - e) && (!(t > n) || (R(`Detected an update time that is in the future: ${t} > ${n}`), 
        !1));
    }
    Ha() {
        null !== this.document && "function" == typeof this.document.addEventListener && (this.Ba = () => {
            this.fn.ws((() => (this.inForeground = "visible" === this.document.visibilityState, 
            this.za())));
        }, this.document.addEventListener("visibilitychange", this.Ba), this.inForeground = "visible" === this.document.visibilityState);
    }
    fc() {
        this.Ba && (this.document.removeEventListener("visibilitychange", this.Ba), this.Ba = null);
    }
    /**
     * Attaches a window.unload handler that will synchronously write our
     * clientId to a "zombie client id" location in LocalStorage. This can be used
     * by tabs trying to acquire the primary lease to determine that the lease
     * is no longer valid even if the timestamp is recent. This is particularly
     * important for the refresh case (so the tab correctly re-acquires the
     * primary lease). LocalStorage is used for this rather than IndexedDb because
     * it is a synchronous API and so can be used reliably from  an unload
     * handler.
     */    Ya() {
        var t;
        "function" == typeof (null === (t = this.window) || void 0 === t ? void 0 : t.addEventListener) && (this.La = () => {
            // Note: In theory, this should be scheduled on the AsyncQueue since it
            // accesses internal state. We execute this code directly during shutdown
            // to make sure it gets a chance to run.
            this._c(), this.fn.ws((() => this.Di()));
        }, this.window.addEventListener("unload", this.La));
    }
    dc() {
        this.La && (this.window.removeEventListener("unload", this.La), this.La = null);
    }
    /**
     * Returns whether a client is "zombied" based on its LocalStorage entry.
     * Clients become zombied when their tab closes without running all of the
     * cleanup logic in `shutdown()`.
     */    lc(t) {
        var e;
        try {
            const n = null !== (null === (e = this.Ga) || void 0 === e ? void 0 : e.getItem(this.hc(t)));
            return A("IndexedDbPersistence", `Client '${t}' ${n ? "is" : "is not"} zombied in LocalStorage`), 
            n;
        } catch (t) {
            // Gracefully handle if LocalStorage isn't working.
            return R("IndexedDbPersistence", "Failed to get zombied client id.", t), !1;
        }
    }
    /**
     * Record client as zombied (a client that had its tab closed). Zombied
     * clients are ignored during primary tab selection.
     */    _c() {
        if (this.Ga) try {
            this.Ga.setItem(this.hc(this.clientId), String(Date.now()));
        } catch (t) {
            // Gracefully handle if LocalStorage isn't available / working.
            R("Failed to set zombie client id.", t);
        }
    }
    /** Removes the zombied client entry if it exists. */    wc() {
        if (this.Ga) try {
            this.Ga.removeItem(this.hc(this.clientId));
        } catch (t) {
            // Ignore
        }
    }
    hc(t) {
        return `firestore_zombie_${this.persistenceKey}_${t}`;
    }
}

/**
 * Helper to get a typed SimpleDbStore for the primary client object store.
 */ function br(t) {
    return pr.Qn(t, nr.store);
}

/**
 * Helper to get a typed SimpleDbStore for the client metadata object store.
 */ function vr(t) {
    return pr.Qn(t, wr.store);
}

/** Provides LRU functionality for IndexedDB persistence. */ class Sr {
    constructor(t, e) {
        this.db = t, this.wo = new Vi(this, e);
    }
    Po(t) {
        const e = this.Rc(t);
        return this.db.Tc().ba(t).next((t => e.next((e => t + e))));
    }
    Rc(t) {
        let e = 0;
        return this.Vo(t, (t => {
            e++;
        })).next((() => e));
    }
    Ce(t, e) {
        return this.db.Tc().Ce(t, e);
    }
    Vo(t, e) {
        return this.gc(t, ((t, n) => e(n)));
    }
    Da(t, e, n) {
        return Dr(t, n);
    }
    Na(t, e, n) {
        return Dr(t, n);
    }
    po(t, e, n) {
        return this.db.Tc().po(t, e, n);
    }
    Go(t, e) {
        return Dr(t, e);
    }
    /**
     * Returns true if anything would prevent this document from being garbage
     * collected, given that the document in question is not present in any
     * targets and has a sequence number less than or equal to the upper bound for
     * the collection run.
     */    Pc(t, e) {
        return function(t, e) {
            let n = !1;
            return ji(t).os((s => qi(t, s, e).next((t => (t && (n = !0), Ns.resolve(!t)))))).next((() => n));
        }(t, e);
    }
    bo(t, e) {
        const n = this.db.Ec().ra(), s = [];
        let i = 0;
        return this.gc(t, ((r, o) => {
            if (o <= e) {
                const e = this.Pc(t, r).next((e => {
                    if (!e) 
                    // Our size accounting requires us to read all documents before
                    // removing them.
                    return i++, n.Rr(t, r).next((() => (n.Ar(r), Pr(t).delete([ 0, pi(r.path) ]))));
                }));
                s.push(e);
            }
        })).next((() => Ns.$n(s))).next((() => n.apply(t))).next((() => i));
    }
    removeTarget(t, e) {
        const n = e.st(t.xa);
        return this.db.Tc().ya(t, n);
    }
    yc(t, e) {
        return Dr(t, e);
    }
    /**
     * Call provided function for each document in the cache that is 'orphaned'. Orphaned
     * means not a part of any target, so the only entry in the target-document index for
     * that document will be the sentinel row (targetId 0), which will also have the sequence
     * number for the last time the document was accessed.
     */    gc(t, e) {
        const n = Pr(t);
        let s, i = ni.ai;
        return n.rs({
            index: lr.documentTargetsIndex
        }, (([t, n], {path: r, sequenceNumber: o}) => {
            0 === t ? (
            // if nextToReport is valid, report it, this is a new key so the
            // last one must not be a member of any targets.
            i !== ni.ai && e(new x(Si(s)), i), 
            // set nextToReport to be this sequence number. It's the next one we
            // might report, if we don't find any targets for this document.
            // Note that the sequence number must be defined when the targetId
            // is 0.
            i = o, s = r) : 
            // set nextToReport to be invalid, we know we don't need to report
            // this one since we found a target for it.
            i = ni.ai;
        })).next((() => {
            // Since we report sequence numbers after getting to the next key, we
            // need to check if the last key we iterated over was an orphaned
            // document and report it.
            i !== ni.ai && e(new x(Si(s)), i);
        }));
    }
    So(t) {
        return this.db.Ec().aa(t);
    }
}

function Dr(t, e) {
    return Pr(t).put(
    /**
 * @return A value suitable for writing a sentinel row in the target-document
 * store.
 */
    function(t, e) {
        return new lr(0, pi(t.path), e);
    }(e, t.xa));
}

/**
 * Generates a string used as a prefix when storing data in IndexedDB and
 * LocalStorage.
 */ function Cr(t, e) {
    // Use two different prefix formats:
    //   * firestore / persistenceKey / projectID . databaseID / ...
    //   * firestore / persistenceKey / projectID / ...
    // projectIDs are DNS-compatible names and cannot contain dots
    // so there's no danger of collisions.
    let n = t.projectId;
    return t.j || (n += "." + t.database), "firestore/" + e + "/" + n + "/";
}

/**
 * Implements `LocalStore` interface.
 *
 * Note: some field defined in this class might have public access level, but
 * the class is not exported so they are only accessible from this module.
 * This is useful to implement optional features (like bundles) in free
 * functions, such that they are tree-shakeable.
 */
class Nr {
    constructor(
    /** Manages our in-memory or durable persistence. */
    t, e, n) {
        this.persistence = t, this.Vc = e, 
        /**
         * Maps a targetID to data about its target.
         *
         * PORTING NOTE: We are using an immutable data structure on Web to make re-runs
         * of `applyRemoteEvent()` idempotent.
         */
        this.bc = new Ct(st), 
        /** Maps a target to its targetID. */
        // TODO(wuandy): Evaluate if TargetId can be part of Target.
        this.vc = new ft((t => Rt(t)), Pt), 
        /**
         * The read time of the last entry processed by `getNewDocumentChanges()`.
         *
         * PORTING NOTE: This is only used for multi-tab synchronization.
         */
        this.Sc = wt.min(), this.Sr = t.mc(n), this.Dc = t.Ec(), this.Ka = t.Tc(), this.Cc = new Ei(this.Dc, this.Sr, this.persistence.Ic()), 
        this.Vc.Nc(this.Cc);
    }
    Io(t) {
        return this.persistence.runTransaction("Collect garbage", "readwrite-primary", (e => t.vo(e, this.bc)));
    }
}

/**
 * Acknowledges the given batch.
 *
 * On the happy path when a batch is acknowledged, the local store will
 *
 *  + remove the batch from the mutation queue;
 *  + apply the changes to the remote document cache;
 *  + recalculate the latency compensated view implied by those changes (there
 *    may be mutations in the queue that affect the documents but haven't been
 *    acknowledged yet); and
 *  + give the changed documents back the sync engine
 *
 * @returns The resulting (modified) documents.
 */
function Fr(t, e) {
    const n = p(t);
    return n.persistence.runTransaction("Acknowledge batch", "readwrite-primary", (t => {
        const s = e.batch.keys(), i = n.Dc.ra({
            oa: !0
        });
        return function(t, e, n, s) {
            const i = n.batch, r = i.keys();
            let o = Ns.resolve();
            return r.forEach((t => {
                o = o.next((() => s.Rr(e, t))).next((e => {
                    let r = e;
                    const o = n.dr.get(t);
                    V(null !== o), (!r || r.version.L(o) < 0) && (r = i.cr(t, r, n), r && 
                    // We use the commitVersion as the readTime rather than the
                    // document's updateTime since the updateTime is not advanced
                    // for updates that do not modify the underlying document.
                    s.Er(r, n._r));
                }));
            })), o.next((() => t.Sr.Wo(e, i)));
        }
        /** Returns the local view of the documents affected by a mutation batch. */
        // PORTING NOTE: Multi-Tab only.
        (n, t, e, i).next((() => i.apply(t))).next((() => n.Sr.zo(t))).next((() => n.Cc.kr(t, s)));
    }));
}

/**
 * Removes mutations from the MutationQueue for the specified batch;
 * LocalDocuments will be recalculated.
 *
 * @returns The resulting modified documents.
 */
/**
 * Returns the last consistent snapshot processed (used by the RemoteStore to
 * determine whether to buffer incoming snapshots from the backend).
 */
function xr(t) {
    const e = p(t);
    return e.persistence.runTransaction("Get last remote snapshot version", "readonly", (t => e.Ka.Ea(t)));
}

/**
 * Updates the "ground-state" (remote) documents. We assume that the remote
 * event reflects any write batches that have been acknowledged or rejected
 * (i.e. we do not re-apply local mutations to updates from this event).
 *
 * LocalDocuments are re-calculated if there are remaining mutations in the
 * queue.
 */ function $r(t, e) {
    const n = p(t), s = e.nt;
    let i = n.bc;
    return n.persistence.runTransaction("Apply remote event", "readwrite-primary", (t => {
        const r = n.Dc.ra({
            oa: !0
        });
        // Reset newTargetDataByTargetMap in case this transaction gets re-run.
                i = n.bc;
        const o = [];
        e.zt.forEach(((e, r) => {
            const a = i.get(r);
            if (!a) return;
            // Only update the remote keys if the target is still active. This
            // ensures that we can persist the updated target data along with
            // the updated assignment.
                        o.push(n.Ka.Ca(t, e.se, r).next((() => n.Ka.Sa(t, e.ee, r))));
            const c = e.resumeToken;
            // Update the resume token if the change includes one.
                        if (c.O() > 0) {
                const u = a.it(c, s).st(t.xa);
                i = i.ot(r, u), 
                // Update the target data if there are target changes (or if
                // sufficient time has passed since the last update).
                /**
 * Returns true if the newTargetData should be persisted during an update of
 * an active target. TargetData should always be persisted when a target is
 * being released and should not call this function.
 *
 * While the target is active, TargetData updates can be omitted when nothing
 * about the target has changed except metadata like the resume token or
 * snapshot version. Occasionally it's worth the extra write to prevent these
 * values from getting too stale after a crash, but this doesn't have to be
 * too frequent.
 */
                function(t, e, n) {
                    // Always persist target data if we don't already have a resume token.
                    if (V(e.resumeToken.O() > 0), 0 === t.resumeToken.O()) return !0;
                    // Don't allow resume token changes to be buffered indefinitely. This
                    // allows us to be reasonably up-to-date after a crash and avoids needing
                    // to loop over all active queries on shutdown. Especially in the browser
                    // we may not get time to do anything interesting while the current tab is
                    // closing.
                                        if (e.nt.X() - t.nt.X() >= 3e8) return !0;
                    // Otherwise if the only thing that has changed about a target is its resume
                    // token it's not worth persisting. Note that the RemoteStore keeps an
                    // in-memory view of the currently active targets which includes the current
                    // resume token, so stream failure or user changes will still use an
                    // up-to-date resume token regardless of what we do here.
                                        return n.ee.size + n.ne.size + n.se.size > 0;
                }
                /**
 * Notifies local store of the changed views to locally pin documents.
 */ (a, u, e) && o.push(n.Ka.ya(t, u));
            }
        }));
        let a = Mt(), c = Qt();
        // HACK: The only reason we allow a null snapshot version is so that we
        // can synthesize remote events when we get permission denied errors while
        // trying to resolve the state of a locally cached document that is in
        // limbo.
        if (e.Yt.forEach(((t, e) => {
            c = c.add(t);
        })), 
        // Each loop iteration only affects its "own" doc, so it's safe to get all the remote
        // documents in advance in a single call.
        o.push(r.getEntries(t, c).next((i => {
            e.Yt.forEach(((c, u) => {
                const h = i.get(c);
                // Note: The order of the steps below is important, since we want
                // to ensure that rejected limbo resolutions (which fabricate
                // NoDocuments with SnapshotVersion.min()) never add documents to
                // cache.
                                u instanceof Gn && u.version.isEqual(wt.min()) ? (
                // NoDocuments with SnapshotVersion.min() are used in manufactured
                // events. We remove these documents from cache since we lost
                // access.
                r.Ar(c, s), a = a.ot(c, u)) : null == h || u.version.L(h.version) > 0 || 0 === u.version.L(h.version) && h.hasPendingWrites ? (r.Er(u, s), 
                a = a.ot(c, u)) : A("LocalStore", "Ignoring outdated watch update for ", c, ". Current version:", h.version, " Watch version:", u.version), 
                e.Jt.has(c) && o.push(n.persistence.No.yc(t, c));
            }));
        }))), !s.isEqual(wt.min())) {
            const e = n.Ka.Ea(t).next((e => n.Ka.Aa(t, t.xa, s)));
            o.push(e);
        }
        return Ns.$n(o).next((() => r.apply(t))).next((() => n.Cc.Mr(t, a)));
    })).then((t => (n.bc = i, t)));
}

/**
 * Gets the mutation batch after the passed in batchId in the mutation queue
 * or null if empty.
 * @param afterBatchId If provided, the batch to search after.
 * @returns The next mutation or null if there wasn't one.
 */
function kr(t, e) {
    const n = p(t);
    return n.persistence.runTransaction("Get next mutation batch", "readonly", (t => (void 0 === e && (e = -1), 
    n.Sr.Bo(t, e))));
}

/**
 * Reads the current value of a Document with a given key or null if not
 * found - used for testing.
 */
/**
 * Assigns the given target an internal ID so that its results can be pinned so
 * they don't get GC'd. A target must be allocated in the local store before
 * the store can be used to manage its view.
 *
 * Allocating an already allocated `Target` will return the existing `TargetData`
 * for that `Target`.
 */
function Mr(t, e) {
    const n = p(t);
    return n.persistence.runTransaction("Allocate target", "readwrite", (t => {
        let s;
        return n.Ka.va(t, e).next((i => i ? (
        // This target has been listened to previously, so reuse the
        // previous targetID.
        // TODO(mcg): freshen last accessed date?
        s = i, Ns.resolve(s)) : n.Ka.wa(t).next((i => (s = new Vt(e, i, 0 /* Listen */ , t.xa), 
        n.Ka.Ra(t, s).next((() => s)))))));
    })).then((t => {
        // If Multi-Tab is enabled, the existing target data may be newer than
        // the in-memory data
        const s = n.bc.get(t.targetId);
        return (null === s || t.nt.L(s.nt) > 0) && (n.bc = n.bc.ot(t.targetId, t), n.vc.set(e, t.targetId)), 
        t;
    }));
}

/**
 * Returns the TargetData as seen by the LocalStore, including updates that may
 * have not yet been persisted to the TargetCache.
 */
// Visible for testing.
/**
 * Unpins all the documents associated with the given target. If
 * `keepPersistedTargetData` is set to false and Eager GC enabled, the method
 * directly removes the associated target data from the target cache.
 *
 * Releasing a non-existing `Target` is a no-op.
 */
// PORTING NOTE: `keepPersistedTargetData` is multi-tab only.
async function Or(t, e, n) {
    const s = p(t), i = s.bc.get(e), r = n ? "readwrite" : "readwrite-primary";
    try {
        n || await s.persistence.runTransaction("Release target", r, (t => s.persistence.No.removeTarget(t, i)));
    } catch (t) {
        if (!ks(t)) throw t;
        // All `releaseTarget` does is record the final metadata state for the
        // target, but we've been recording this periodically during target
        // activity. If we lose this write this could cause a very slight
        // difference in the order of target deletion during GC, but we
        // don't define exact LRU semantics so this is acceptable.
        A("LocalStore", `Failed to update sequence numbers for target ${e}: ${t}`);
    }
    s.bc = s.bc.remove(e), s.vc.delete(i.target);
}

/**
 * Runs the specified query against the local store and returns the results,
 * potentially taking advantage of query data from previous executions (such
 * as the set of remote keys).
 *
 * @param usePreviousResults Whether results from previous executions can
 * be used to optimize this query execution.
 */ function Lr(t, e, n) {
    const s = p(t);
    let i = wt.min(), r = Qt();
    return s.persistence.runTransaction("Execute query", "readonly", (t => function(t, e, n) {
        const s = p(t), i = s.vc.get(n);
        return void 0 !== i ? Ns.resolve(s.bc.get(i)) : s.Ka.va(e, n);
    }(s, t, is(e)).next((e => {
        if (e) return i = e.lastLimboFreeSnapshotVersion, s.Ka.Fa(t, e.targetId).next((t => {
            r = t;
        }));
    })).next((() => s.Vc.Lr(t, e, n ? i : wt.min(), n ? r : Qt()))).next((t => ({
        documents: t,
        Fc: r
    })))));
}

// PORTING NOTE: Multi-Tab only.
function Br(t, e) {
    const n = p(t), s = p(n.Ka), i = n.bc.get(e);
    return i ? Promise.resolve(i.target) : n.persistence.runTransaction("Get target data", "readonly", (t => s.Ue(t, e).next((t => t ? t.target : null))));
}

/**
 * Returns the set of documents that have been updated since the last call.
 * If this is the first call, returns the set of changes since client
 * initialization. Further invocations will return document that have changed
 * since the prior call.
 */
// PORTING NOTE: Multi-Tab only.
function qr(t) {
    const e = p(t);
    return e.persistence.runTransaction("Get new document changes", "readonly", (t => function(t, e, n) {
        const s = p(t);
        let i = Mt(), r = Fi(n);
        const o = Hi(e), a = IDBKeyRange.lowerBound(r, !0);
        return o.rs({
            index: cr.readTimeIndex,
            range: a
        }, ((t, e) => {
            // Unlike `getEntry()` and others, `getNewDocumentChanges()` parses
            // the documents directly since we want to keep sentinel deletes.
            const n = Ci(s.serializer, e);
            i = i.ot(n.key, n), r = e.readTime;
        })).next((() => ({
            xc: i,
            readTime: xi(r)
        })));
    }
    /**
 * Returns the read time of the most recently read document in the cache, or
 * SnapshotVersion.min() if not available.
 */
    // PORTING NOTE: This is only used for multi-tab synchronization.
    (e.Dc, t, e.Sc))).then((({xc: t, readTime: n}) => (e.Sc = n, t)));
}

/**
 * Reads the newest document change from persistence and moves the internal
 * synchronization marker forward so that calls to `getNewDocumentChanges()`
 * only return changes that happened after client initialization.
 */
// PORTING NOTE: Multi-Tab only.
async function Ur(t) {
    const e = p(t);
    return e.persistence.runTransaction("Synchronize last document change read time", "readonly", (t => function(t) {
        const e = Hi(t);
        // If there are no existing entries, we return SnapshotVersion.min().
                let n = wt.min();
        return e.rs({
            index: cr.readTimeIndex,
            reverse: !0
        }, ((t, e, s) => {
            e.readTime && (n = xi(e.readTime)), s.done();
        })).next((() => n));
    }(t))).then((t => {
        e.Sc = t;
    }));
}

/**
 * Verifies the error thrown by a LocalStore operation. If a LocalStore
 * operation fails because the primary lease has been taken by another client,
 * we ignore the error (the persistence layer will immediately call
 * `applyPrimaryLease` to propagate the primary state change). All other errors
 * are re-thrown.
 *
 * @param err An error returned by a LocalStore operation.
 * @return A Promise that resolves after we recovered, or the original error.
 */ async function Qr(t) {
    if (t.code !== m.FAILED_PRECONDITION || t.message !== mi) throw t;
    A("LocalStore", "Unexpectedly lost primary lease");
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A collection of references to a document from some kind of numbered entity
 * (either a target ID or batch ID). As references are added to or removed from
 * the set corresponding events are emitted to a registered garbage collector.
 *
 * Each reference is represented by a DocumentReference object. Each of them
 * contains enough information to uniquely identify the reference. They are all
 * stored primarily in a set sorted by key. A document is considered garbage if
 * there's no references in that set (this can be efficiently checked thanks to
 * sorting by key).
 *
 * ReferenceSet also keeps a secondary set that contains references sorted by
 * IDs. This one is used to efficiently implement removal of all references by
 * some target ID.
 */ class Wr {
    constructor() {
        // A set of outstanding references to a document sorted by key.
        this.$c = new xt(jr.kc), 
        // A set of outstanding references to a document sorted by target id.
        this.Mc = new xt(jr.Oc);
    }
    /** Returns true if the reference set contains no references. */    m() {
        return this.$c.m();
    }
    /** Adds a reference to the given document key for the given ID. */    Da(t, e) {
        const n = new jr(t, e);
        this.$c = this.$c.add(n), this.Mc = this.Mc.add(n);
    }
    /** Add references to the given document keys for the given ID. */    Lc(t, e) {
        t.forEach((t => this.Da(t, e)));
    }
    /**
     * Removes a reference to the given document key for the given
     * ID.
     */    Na(t, e) {
        this.Bc(new jr(t, e));
    }
    qc(t, e) {
        t.forEach((t => this.Na(t, e)));
    }
    /**
     * Clears all references with a given ID. Calls removeRef() for each key
     * removed.
     */    Uc(t) {
        const e = new x(new C([])), n = new jr(e, t), s = new jr(e, t + 1), i = [];
        return this.Mc.Ft([ n, s ], (t => {
            this.Bc(t), i.push(t.key);
        })), i;
    }
    Qc() {
        this.$c.forEach((t => this.Bc(t)));
    }
    Bc(t) {
        this.$c = this.$c.delete(t), this.Mc = this.Mc.delete(t);
    }
    Wc(t) {
        const e = new x(new C([])), n = new jr(e, t), s = new jr(e, t + 1);
        let i = Qt();
        return this.Mc.Ft([ n, s ], (t => {
            i = i.add(t.key);
        })), i;
    }
    Ho(t) {
        const e = new jr(t, 0), n = this.$c.$t(e);
        return null !== n && t.isEqual(n.key);
    }
}

class jr {
    constructor(t, e) {
        this.key = t, this.jc = e;
    }
    /** Compare by key then by ID */    static kc(t, e) {
        return x.i(t.key, e.key) || st(t.jc, e.jc);
    }
    /** Compare by ID then by key */    static Oc(t, e) {
        return st(t.jc, e.jc) || x.i(t.key, e.key);
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ class Kr {
    constructor(t, e) {
        this.user = e, this.type = "OAuth", this.Kc = {}, 
        // Set the headers using Object Literal notation to avoid minification
        this.Kc.Authorization = "Bearer " + t;
    }
}

/** A CredentialsProvider that always yields an empty token. */ class Gr {
    constructor() {
        /**
         * Stores the listener registered with setChangeListener()
         * This isn't actually necessary since the UID never changes, but we use this
         * to verify the listen contract is adhered to in tests.
         */
        this.Gc = null;
    }
    getToken() {
        return Promise.resolve(null);
    }
    zc() {}
    Hc(t) {
        this.Gc = t, 
        // Fire with initial user.
        t(ei.UNAUTHENTICATED);
    }
    Yc() {
        this.Gc = null;
    }
}

class zr {
    constructor(t) {
        /**
         * The auth token listener registered with FirebaseApp, retained here so we
         * can unregister it.
         */
        this.Jc = null, 
        /** Tracks the current User. */
        this.currentUser = ei.UNAUTHENTICATED, this.Xc = !1, 
        /**
         * Counter used to detect if the token changed while a getToken request was
         * outstanding.
         */
        this.Zc = 0, 
        /** The listener registered with setChangeListener(). */
        this.Gc = null, this.forceRefresh = !1, this.Jc = () => {
            this.Zc++, this.currentUser = this.tu(), this.Xc = !0, this.Gc && this.Gc(this.currentUser);
        }, this.Zc = 0, this.auth = t.getImmediate({
            optional: !0
        }), this.auth ? this.auth.addAuthTokenListener(this.Jc) : (
        // if auth is not available, invoke tokenListener once with null token
        this.Jc(null), t.get().then((t => {
            this.auth = t, this.Jc && 
            // tokenListener can be removed by removeChangeListener()
            this.auth.addAuthTokenListener(this.Jc);
        }), (() => {})));
    }
    getToken() {
        // Take note of the current value of the tokenCounter so that this method
        // can fail (with an ABORTED error) if there is a token change while the
        // request is outstanding.
        const t = this.Zc, e = this.forceRefresh;
        return this.forceRefresh = !1, this.auth ? this.auth.getToken(e).then((e => 
        // Cancel the request since the token changed while the request was
        // outstanding so the response is potentially for a previous user (which
        // user, we can't be sure).
        this.Zc !== t ? (A("FirebaseCredentialsProvider", "getToken aborted due to token change."), 
        this.getToken()) : e ? (V("string" == typeof e.accessToken), new Kr(e.accessToken, this.currentUser)) : null)) : Promise.resolve(null);
    }
    zc() {
        this.forceRefresh = !0;
    }
    Hc(t) {
        this.Gc = t, 
        // Fire the initial event
        this.Xc && t(this.currentUser);
    }
    Yc() {
        this.auth && this.auth.removeAuthTokenListener(this.Jc), this.Jc = null, this.Gc = null;
    }
    // Auth.getUid() can return null even with a user logged in. It is because
    // getUid() is synchronous, but the auth code populating Uid is asynchronous.
    // This method should only be called in the AuthTokenListener callback
    // to guarantee to get the actual user.
    tu() {
        const t = this.auth && this.auth.getUid();
        return V(null === t || "string" == typeof t), new ei(t);
    }
}

/*
 * FirstPartyToken provides a fresh token each time its value
 * is requested, because if the token is too old, requests will be rejected.
 * Technically this may no longer be necessary since the SDK should gracefully
 * recover from unauthenticated errors (see b/33147818 for context), but it's
 * safer to keep the implementation as-is.
 */ class Hr {
    constructor(t, e) {
        this.eu = t, this.nu = e, this.type = "FirstParty", this.user = ei.ni;
    }
    get Kc() {
        const t = {
            "X-Goog-AuthUser": this.nu
        }, e = this.eu.auth.getAuthHeaderValueForFirstParty([]);
        // Use array notation to prevent minification
                return e && (t.Authorization = e), t;
    }
}

/*
 * Provides user credentials required for the Firestore JavaScript SDK
 * to authenticate the user, using technique that is only available
 * to applications hosted by Google.
 */ class Yr {
    constructor(t, e) {
        this.eu = t, this.nu = e;
    }
    getToken() {
        return Promise.resolve(new Hr(this.eu, this.nu));
    }
    Hc(t) {
        // Fire with initial uid.
        t(ei.ni);
    }
    Yc() {}
    zc() {}
}

/**
 * Builds a CredentialsProvider depending on the type of
 * the credentials passed in.
 */
/**
 * A PersistentStream is an abstract base class that represents a streaming RPC
 * to the Firestore backend. It's built on top of the connections own support
 * for streaming RPCs, and adds several critical features for our clients:
 *
 *   - Exponential backoff on failure
 *   - Authentication via CredentialsProvider
 *   - Dispatching all callbacks into the shared worker queue
 *   - Closing idle streams after 60 seconds of inactivity
 *
 * Subclasses of PersistentStream implement serialization of models to and
 * from the JSON representation of the protocol buffers for a specific
 * streaming RPC.
 *
 * ## Starting and Stopping
 *
 * Streaming RPCs are stateful and need to be start()ed before messages can
 * be sent and received. The PersistentStream will call the onOpen() function
 * of the listener once the stream is ready to accept requests.
 *
 * Should a start() fail, PersistentStream will call the registered onClose()
 * listener with a FirestoreError indicating what went wrong.
 *
 * A PersistentStream can be started and stopped repeatedly.
 *
 * Generic types:
 *  SendType: The type of the outgoing message of the underlying
 *    connection stream
 *  ReceiveType: The type of the incoming message of the underlying
 *    connection stream
 *  ListenerType: The type of the listener that will be used for callbacks
 */
class Jr {
    constructor(t, e, n, s, i, r) {
        this.fn = t, this.su = n, this.iu = s, this.ru = i, this.listener = r, this.state = 0 /* Initial */ , 
        /**
         * A close count that's incremented every time the stream is closed; used by
         * getCloseGuardedDispatcher() to invalidate callbacks that happen after
         * close.
         */
        this.ou = 0, this.au = null, this.stream = null, this.ys = new Cs(t, e);
    }
    /**
     * Returns true if start() has been called and no error has occurred. True
     * indicates the stream is open or in the process of opening (which
     * encompasses respecting backoff, getting auth tokens, and starting the
     * actual RPC). Use isOpen() to determine if the stream is open and ready for
     * outbound requests.
     */    cu() {
        return 1 /* Starting */ === this.state || 2 /* Open */ === this.state || 4 /* Backoff */ === this.state;
    }
    /**
     * Returns true if the underlying RPC is open (the onOpen() listener has been
     * called) and the stream is ready for outbound requests.
     */    uu() {
        return 2 /* Open */ === this.state;
    }
    /**
     * Starts the RPC. Only allowed if isStarted() returns false. The stream is
     * not immediately ready for use: onOpen() will be invoked when the RPC is
     * ready for outbound requests, at which point isOpen() will return true.
     *
     * When start returns, isStarted() will return true.
     */    start() {
        3 /* Error */ !== this.state ? this.auth() : this.hu();
    }
    /**
     * Stops the RPC. This call is idempotent and allowed regardless of the
     * current isStarted() state.
     *
     * When stop returns, isStarted() and isOpen() will both return false.
     */    async stop() {
        this.cu() && await this.close(0 /* Initial */);
    }
    /**
     * After an error the stream will usually back off on the next attempt to
     * start it. If the error warrants an immediate restart of the stream, the
     * sender can use this to indicate that the receiver should not back off.
     *
     * Each error will call the onClose() listener. That function can decide to
     * inhibit backoff if required.
     */    lu() {
        this.state = 0 /* Initial */ , this.ys.reset();
    }
    /**
     * Marks this stream as idle. If no further actions are performed on the
     * stream for one minute, the stream will automatically close itself and
     * notify the stream's onClose() handler with Status.OK. The stream will then
     * be in a !isStarted() state, requiring the caller to start the stream again
     * before further use.
     *
     * Only streams that are in state 'Open' can be marked idle, as all other
     * states imply pending network operations.
     */    _u() {
        // Starts the idle time if we are in state 'Open' and are not yet already
        // running a timer (in which case the previous idle timeout still applies).
        this.uu() && null === this.au && (this.au = this.fn.yn(this.su, 6e4, (() => this.fu())));
    }
    /** Sends a message to the underlying stream. */    du(t) {
        this.wu(), this.stream.send(t);
    }
    /** Called by the idle timer when the stream should close due to inactivity. */    async fu() {
        if (this.uu()) 
        // When timing out an idle stream there's no reason to force the stream into backoff when
        // it restarts so set the stream state to Initial instead of Error.
        return this.close(0 /* Initial */);
    }
    /** Marks the stream as active again. */    wu() {
        this.au && (this.au.cancel(), this.au = null);
    }
    /**
     * Closes the stream and cleans up as necessary:
     *
     * * closes the underlying GRPC stream;
     * * calls the onClose handler with the given 'error';
     * * sets internal stream state to 'finalState';
     * * adjusts the backoff timer based on the error
     *
     * A new stream can be opened by calling start().
     *
     * @param finalState the intended state of the stream after closing.
     * @param error the error the connection was closed with.
     */    async close(t, e) {
        // Cancel any outstanding timers (they're guaranteed not to execute).
        this.wu(), this.ys.cancel(), 
        // Invalidates any stream-related callbacks (e.g. from auth or the
        // underlying stream), guaranteeing they won't execute.
        this.ou++, 3 /* Error */ !== t ? 
        // If this is an intentional close ensure we don't delay our next connection attempt.
        this.ys.reset() : e && e.code === m.RESOURCE_EXHAUSTED ? (
        // Log the error. (Probably either 'quota exceeded' or 'max queue length reached'.)
        R(e.toString()), R("Using maximum backoff delay to prevent overloading the backend."), 
        this.ys.Rn()) : e && e.code === m.UNAUTHENTICATED && 
        // "unauthenticated" error means the token was rejected. Try force refreshing it in case it
        // just expired.
        this.ru.zc(), 
        // Clean up the underlying stream because we are no longer interested in events.
        null !== this.stream && (this.mu(), this.stream.close(), this.stream = null), 
        // This state must be assigned before calling onClose() to allow the callback to
        // inhibit backoff or otherwise manipulate the state in its non-started state.
        this.state = t, 
        // Notify the listener that the stream closed.
        await this.listener.Tu(e);
    }
    /**
     * Can be overridden to perform additional cleanup before the stream is closed.
     * Calling super.tearDown() is not required.
     */    mu() {}
    auth() {
        this.state = 1 /* Starting */;
        const t = this.Eu(this.ou), e = this.ou;
        // TODO(mikelehen): Just use dispatchIfNotClosed, but see TODO below.
                this.ru.getToken().then((t => {
            // Stream can be stopped while waiting for authentication.
            // TODO(mikelehen): We really should just use dispatchIfNotClosed
            // and let this dispatch onto the queue, but that opened a spec test can
            // of worms that I don't want to deal with in this PR.
            this.ou === e && 
            // Normally we'd have to schedule the callback on the AsyncQueue.
            // However, the following calls are safe to be called outside the
            // AsyncQueue since they don't chain asynchronous calls
            this.Iu(t);
        }), (e => {
            t((() => {
                const t = new T(m.UNKNOWN, "Fetching auth token failed: " + e.message);
                return this.Au(t);
            }));
        }));
    }
    Iu(t) {
        const e = this.Eu(this.ou);
        this.stream = this.Ru(t), this.stream.gu((() => {
            e((() => (this.state = 2 /* Open */ , this.listener.gu())));
        })), this.stream.Tu((t => {
            e((() => this.Au(t)));
        })), this.stream.onMessage((t => {
            e((() => this.onMessage(t)));
        }));
    }
    hu() {
        this.state = 4 /* Backoff */ , this.ys.gn((async () => {
            this.state = 0 /* Initial */ , this.start();
        }));
    }
    // Visible for tests
    Au(t) {
        // In theory the stream could close cleanly, however, in our current model
        // we never expect this to happen because if we stop a stream ourselves,
        // this callback will never be called. To prevent cases where we retry
        // without a backoff accidentally, we set the stream to error in all cases.
        return A("PersistentStream", "close with error: " + t), this.stream = null, this.close(3 /* Error */ , t);
    }
    /**
     * Returns a "dispatcher" function that dispatches operations onto the
     * AsyncQueue but only runs them if closeCount remains unchanged. This allows
     * us to turn auth / stream callbacks into no-ops if the stream is closed /
     * re-opened, etc.
     */    Eu(t) {
        return e => {
            this.fn.ws((() => this.ou === t ? e() : (A("PersistentStream", "stream callback skipped by getCloseGuardedDispatcher."), 
            Promise.resolve())));
        };
    }
}

/**
 * A PersistentStream that implements the Listen RPC.
 *
 * Once the Listen stream has called the onOpen() listener, any number of
 * listen() and unlisten() calls can be made to control what changes will be
 * sent from the server for ListenResponses.
 */ class Xr extends Jr {
    constructor(t, e, n, s, i) {
        super(t, "listen_stream_connection_backoff" /* ListenStreamConnectionBackoff */ , "listen_stream_idle" /* ListenStreamIdle */ , e, n, i), 
        this.serializer = s;
    }
    Ru(t) {
        return this.iu.Pu("Listen", t);
    }
    onMessage(t) {
        // A successful response means the stream is healthy
        this.ys.reset();
        const e = We(this.serializer, t), n = function(t) {
            // We have only reached a consistent snapshot for the entire stream if there
            // is a read_time set and it applies to all targets (i.e. the list of
            // targets is empty). The backend is guaranteed to send such responses.
            if (!("targetChange" in t)) return wt.min();
            const e = t.targetChange;
            return e.targetIds && e.targetIds.length ? wt.min() : e.readTime ? Fe(e.readTime) : wt.min();
        }(t);
        return this.listener.yu(e, n);
    }
    /**
     * Registers interest in the results of the given target. If the target
     * includes a resumeToken it will be included in the request. Results that
     * affect the target will be streamed back as WatchChange messages that
     * reference the targetId.
     */    Vu(t) {
        const e = {};
        e.database = Be(this.serializer), e.addTarget = function(t, e) {
            let n;
            const s = e.target;
            return n = yt(s) ? {
                documents: ze(t, s)
            } : {
                query: He(t, s)
            }, n.targetId = e.targetId, e.resumeToken.O() > 0 && (n.resumeToken = Ce(t, e.resumeToken)), 
            n;
        }(this.serializer, t);
        const n = Je(this.serializer, t);
        n && (e.labels = n), this.du(e);
    }
    /**
     * Unregisters interest in the results of the target associated with the
     * given targetId.
     */    pu(t) {
        const e = {};
        e.database = Be(this.serializer), e.removeTarget = t, this.du(e);
    }
}

/**
 * A Stream that implements the Write RPC.
 *
 * The Write RPC requires the caller to maintain special streamToken
 * state in between calls, to help the server understand which responses the
 * client has processed by the time the next request is made. Every response
 * will contain a streamToken; this value must be passed to the next
 * request.
 *
 * After calling start() on this stream, the next request must be a handshake,
 * containing whatever streamToken is on hand. Once a response to this
 * request is received, all pending mutations may be submitted. When
 * submitting multiple batches of mutations at the same time, it's
 * okay to use the same streamToken for the calls to writeMutations.
 *
 * TODO(b/33271235): Use proto types
 */ class Zr extends Jr {
    constructor(t, e, n, s, i) {
        super(t, "write_stream_connection_backoff" /* WriteStreamConnectionBackoff */ , "write_stream_idle" /* WriteStreamIdle */ , e, n, i), 
        this.serializer = s, this.bu = !1;
    }
    /**
     * Tracks whether or not a handshake has been successfully exchanged and
     * the stream is ready to accept mutations.
     */    get vu() {
        return this.bu;
    }
    // Override of PersistentStream.start
    start() {
        this.bu = !1, this.lastStreamToken = void 0, super.start();
    }
    mu() {
        this.bu && this.Su([]);
    }
    Ru(t) {
        return this.iu.Pu("Write", t);
    }
    onMessage(t) {
        if (
        // Always capture the last stream token.
        V(!!t.streamToken), this.lastStreamToken = t.streamToken, this.bu) {
            // A successful first write response means the stream is healthy,
            // Note, that we could consider a successful handshake healthy, however,
            // the write itself might be causing an error we want to back off from.
            this.ys.reset();
            const e = Ge(t.writeResults, t.commitTime), n = Fe(t.commitTime);
            return this.listener.Du(n, e);
        }
        // The first response is always the handshake response
        return V(!t.writeResults || 0 === t.writeResults.length), this.bu = !0, this.listener.Cu();
    }
    /**
     * Sends an initial streamToken to the server, performing the handshake
     * required to make the StreamingWrite RPC work. Subsequent
     * calls should wait until onHandshakeComplete was called.
     */    Nu() {
        // TODO(dimond): Support stream resumption. We intentionally do not set the
        // stream token on the handshake, ignoring any stream token we might have.
        const t = {};
        t.database = Be(this.serializer), this.du(t);
    }
    /** Sends a group of mutations to the Firestore backend to apply. */    Su(t) {
        const e = {
            streamToken: this.lastStreamToken,
            writes: t.map((t => je(this.serializer, t)))
        };
        this.du(e);
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Datastore and its related methods are a wrapper around the external Google
 * Cloud Datastore grpc API, which provides an interface that is more convenient
 * for the rest of the client SDK architecture to consume.
 */
/**
 * An implementation of Datastore that exposes additional state for internal
 * consumption.
 */
class to extends class {} {
    constructor(t, e, n) {
        super(), this.credentials = t, this.iu = e, this.serializer = n, this.Fu = !1;
    }
    xu() {
        if (this.Fu) throw new T(m.FAILED_PRECONDITION, "The client has already been terminated.");
    }
    /** Gets an auth token and invokes the provided RPC. */    $u(t, e, n) {
        return this.xu(), this.credentials.getToken().then((s => this.iu.$u(t, e, n, s))).catch((t => {
            throw t.code === m.UNAUTHENTICATED && this.credentials.zc(), t;
        }));
    }
    /** Gets an auth token and invokes the provided RPC with streamed results. */    ku(t, e, n) {
        return this.xu(), this.credentials.getToken().then((s => this.iu.ku(t, e, n, s))).catch((t => {
            throw t.code === m.UNAUTHENTICATED && this.credentials.zc(), t;
        }));
    }
    terminate() {
        this.Fu = !1;
    }
}

// TODO(firestorexp): Make sure there is only one Datastore instance per
// firestore-exp client.
/**
 * A component used by the RemoteStore to track the OnlineState (that is,
 * whether or not the client as a whole should be considered to be online or
 * offline), implementing the appropriate heuristics.
 *
 * In particular, when the client is trying to connect to the backend, we
 * allow up to MAX_WATCH_STREAM_FAILURES within ONLINE_STATE_TIMEOUT_MS for
 * a connection to succeed. If we have too many failures or the timeout elapses,
 * then we set the OnlineState to Offline, and the client will behave as if
 * it is offline (get()s will return cached data, etc.).
 */
class eo {
    constructor(t, e) {
        this.cs = t, this.di = e, 
        /** The current OnlineState. */
        this.state = "Unknown" /* Unknown */ , 
        /**
         * A count of consecutive failures to open the stream. If it reaches the
         * maximum defined by MAX_WATCH_STREAM_FAILURES, we'll set the OnlineState to
         * Offline.
         */
        this.Mu = 0, 
        /**
         * A timer that elapses after ONLINE_STATE_TIMEOUT_MS, at which point we
         * transition from OnlineState.Unknown to OnlineState.Offline without waiting
         * for the stream to actually fail (MAX_WATCH_STREAM_FAILURES times).
         */
        this.Ou = null, 
        /**
         * Whether the client should log a warning message if it fails to connect to
         * the backend (initially true, cleared after a successful stream, or if we've
         * logged the message already).
         */
        this.Lu = !0;
    }
    /**
     * Called by RemoteStore when a watch stream is started (including on each
     * backoff attempt).
     *
     * If this is the first attempt, it sets the OnlineState to Unknown and starts
     * the onlineStateTimer.
     */    Bu() {
        0 === this.Mu && (this.qu("Unknown" /* Unknown */), this.Ou = this.cs.yn("online_state_timeout" /* OnlineStateTimeout */ , 1e4, (() => (this.Ou = null, 
        this.Uu("Backend didn't respond within 10 seconds."), this.qu("Offline" /* Offline */), 
        Promise.resolve()))));
    }
    /**
     * Updates our OnlineState as appropriate after the watch stream reports a
     * failure. The first failure moves us to the 'Unknown' state. We then may
     * allow multiple failures (based on MAX_WATCH_STREAM_FAILURES) before we
     * actually transition to the 'Offline' state.
     */    Qu(t) {
        "Online" /* Online */ === this.state ? this.qu("Unknown" /* Unknown */) : (this.Mu++, 
        this.Mu >= 1 && (this.Wu(), this.Uu("Connection failed 1 times. Most recent error: " + t.toString()), 
        this.qu("Offline" /* Offline */)));
    }
    /**
     * Explicitly sets the OnlineState to the specified state.
     *
     * Note that this resets our timers / failure counters, etc. used by our
     * Offline heuristics, so must not be used in place of
     * handleWatchStreamStart() and handleWatchStreamFailure().
     */    set(t) {
        this.Wu(), this.Mu = 0, "Online" /* Online */ === t && (
        // We've connected to watch at least once. Don't warn the developer
        // about being offline going forward.
        this.Lu = !1), this.qu(t);
    }
    qu(t) {
        t !== this.state && (this.state = t, this.di(t));
    }
    Uu(t) {
        const e = `Could not reach Cloud Firestore backend. ${t}\nThis typically indicates that your device does not have a healthy Internet connection at the moment. The client will operate in offline mode until it is able to successfully connect to the backend.`;
        this.Lu ? (R(e), this.Lu = !1) : A("OnlineStateTracker", e);
    }
    Wu() {
        null !== this.Ou && (this.Ou.cancel(), this.Ou = null);
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ class no {
    constructor(
    /**
     * The local store, used to fill the write pipeline with outbound mutations.
     */
    t, 
    /** The client-side proxy for interacting with the backend. */
    e, n, s, i) {
        this.ju = t, this.Ku = e, this.cs = n, this.Gu = {}, 
        /**
         * A list of up to MAX_PENDING_WRITES writes that we have fetched from the
         * LocalStore via fillWritePipeline() and have or will send to the write
         * stream.
         *
         * Whenever writePipeline.length > 0 the RemoteStore will attempt to start or
         * restart the write stream. When the stream is established the writes in the
         * pipeline will be sent in order.
         *
         * Writes remain in writePipeline until they are acknowledged by the backend
         * and thus will automatically be re-sent if the stream is interrupted /
         * restarted before they're acknowledged.
         *
         * Write responses from the backend are linked to their originating request
         * purely based on order, and so we can just shift() writes from the front of
         * the writePipeline as we receive responses.
         */
        this.zu = [], 
        /**
         * A mapping of watched targets that the client cares about tracking and the
         * user has explicitly called a 'listen' for this target.
         *
         * These targets may or may not have been sent to or acknowledged by the
         * server. On re-establishing the listen stream, these targets should be sent
         * to the server. The targets removed with unlistens are removed eagerly
         * without waiting for confirmation from the listen stream.
         */
        this.Hu = new Map, 
        /**
         * A set of reasons for why the RemoteStore may be offline. If empty, the
         * RemoteStore may start its network connections.
         */
        this.Yu = new Set, 
        /**
         * Event handlers that get called when the network is disabled or enabled.
         *
         * PORTING NOTE: These functions are used on the Web client to create the
         * underlying streams (to support tree-shakeable streams). On Android and iOS,
         * the streams are created during construction of RemoteStore.
         */
        this.Ju = [], this.Xu = i, this.Xu.Zu((t => {
            n.ws((async () => {
                // Porting Note: Unlike iOS, `restartNetwork()` is called even when the
                // network becomes unreachable as we don't have any other way to tear
                // down our streams.
                _o(this) && (A("RemoteStore", "Restarting streams for network reachability change."), 
                await async function(t) {
                    const e = p(t);
                    e.Yu.add(4 /* ConnectivityChange */), await io(e), e.th.set("Unknown" /* Unknown */), 
                    e.Yu.delete(4 /* ConnectivityChange */), await so(e);
                }(this));
            }));
        })), this.th = new eo(n, s);
    }
}

async function so(t) {
    if (_o(t)) for (const e of t.Ju) await e(/* enabled= */ !0);
}

/**
 * Temporarily disables the network. The network can be re-enabled using
 * enableNetwork().
 */ async function io(t) {
    for (const e of t.Ju) await e(/* enabled= */ !1);
}

async function ro(t) {
    const e = p(t);
    A("RemoteStore", "RemoteStore shutting down."), e.Yu.add(5 /* Shutdown */), await io(e), 
    e.Xu.Di(), 
    // Set the OnlineState to Unknown (rather than Offline) to avoid potentially
    // triggering spurious listener events with cached data, etc.
    e.th.set("Unknown" /* Unknown */);
}

/**
 * Starts new listen for the given target. Uses resume token if provided. It
 * is a no-op if the target of given `TargetData` is already being listened to.
 */ function oo(t, e) {
    const n = p(t);
    n.Hu.has(e.targetId) || (
    // Mark this as something the client is currently listening for.
    n.Hu.set(e.targetId, e), lo(n) ? 
    // The listen will be sent in onWatchStreamOpen
    ho(n) : Do(n).uu() && co(n, e));
}

/**
 * Removes the listen from server. It is a no-op if the given target id is
 * not being listened to.
 */ function ao(t, e) {
    const n = p(t), s = Do(n);
    n.Hu.delete(e), s.uu() && uo(n, e), 0 === n.Hu.size && (s.uu() ? s._u() : _o(n) && 
    // Revert to OnlineState.Unknown if the watch stream is not open and we
    // have no listeners, since without any listens to send we cannot
    // confirm if the stream is healthy and upgrade to OnlineState.Online.
    n.th.set("Unknown" /* Unknown */));
}

/**
 * We need to increment the the expected number of pending responses we're due
 * from watch so we wait for the ack to process any messages from this target.
 */ function co(t, e) {
    t.eh.Ie(e.targetId), Do(t).Vu(e);
}

/**
 * We need to increment the expected number of pending responses we're due
 * from watch so we wait for the removal on the server before we process any
 * messages from this target.
 */ function uo(t, e) {
    t.eh.Ie(e), Do(t).pu(e);
}

function ho(t) {
    t.eh = new ee({
        qe: e => t.Gu.qe(e),
        Ue: e => t.Hu.get(e) || null
    }), Do(t).start(), t.th.Bu();
}

/**
 * Returns whether the watch stream should be started because it's necessary
 * and has not yet been started.
 */ function lo(t) {
    return _o(t) && !Do(t).cu() && t.Hu.size > 0;
}

function _o(t) {
    return 0 === p(t).Yu.size;
}

function fo(t) {
    t.eh = void 0;
}

async function wo(t) {
    t.Hu.forEach(((e, n) => {
        co(t, e);
    }));
}

async function mo(t, e) {
    fo(t), 
    // If we still need the watch stream, retry the connection.
    lo(t) ? (t.th.Qu(e), ho(t)) : 
    // No need to restart watch stream because there are no active targets.
    // The online state is set to unknown because there is no active attempt
    // at establishing a connection
    t.th.set("Unknown" /* Unknown */);
}

async function To(t, e, n) {
    if (
    // Mark the client as online since we got a message from the server
    t.th.set("Online" /* Online */), e instanceof Zt && 2 /* Removed */ === e.state && e.cause) 
    // There was an error on a target, don't wait for a consistent snapshot
    // to raise events
    try {
        await 
        /** Handles an error on a target */
        async function(t, e) {
            const n = e.cause;
            for (const s of e.targetIds) 
            // A watched target might have been removed already.
            t.Hu.has(s) && (await t.Gu.nh(s, n), t.Hu.delete(s), t.eh.removeTarget(s));
        }
        /**
 * Attempts to fill our write pipeline with writes from the LocalStore.
 *
 * Called internally to bootstrap or refill the write pipeline and by
 * SyncEngine whenever there are new mutations to process.
 *
 * Starts the write stream if necessary.
 */ (t, e);
    } catch (n) {
        A("RemoteStore", "Failed to remove targets %s: %s ", e.targetIds.join(","), n), 
        await Eo(t, n);
    } else if (e instanceof Jt ? t.eh.be(e) : e instanceof Xt ? t.eh.$e(e) : t.eh.De(e), 
    !n.isEqual(wt.min())) try {
        const e = await xr(t.ju);
        n.L(e) >= 0 && 
        // We have received a target change with a global snapshot if the snapshot
        // version is not equal to SnapshotVersion.min().
        await 
        /**
 * Takes a batch of changes from the Datastore, repackages them as a
 * RemoteEvent, and passes that on to the listener, which is typically the
 * SyncEngine.
 */
        function(t, e) {
            const n = t.eh.Oe(e);
            // Update in-memory resume tokens. LocalStore will update the
            // persistent view of these when applying the completed RemoteEvent.
                        return n.zt.forEach(((n, s) => {
                if (n.resumeToken.O() > 0) {
                    const i = t.Hu.get(s);
                    // A watched target might have been removed already.
                                        i && t.Hu.set(s, i.it(n.resumeToken, e));
                }
            })), 
            // Re-establish listens for the targets that have been invalidated by
            // existence filter mismatches.
            n.Ht.forEach((e => {
                const n = t.Hu.get(e);
                if (!n) 
                // A watched target might have been removed already.
                return;
                // Clear the resume token for the target, since we're in a known mismatch
                // state.
                                t.Hu.set(e, n.it(ot.B, n.nt)), 
                // Cause a hard reset by unwatching and rewatching immediately, but
                // deliberately don't send a resume token so that we get a full update.
                uo(t, e);
                // Mark the target we send as being on behalf of an existence filter
                // mismatch, but don't actually retain that in listenTargets. This ensures
                // that we flag the first re-listen this way without impacting future
                // listens of this target (that might happen e.g. on reconnect).
                const s = new Vt(n.target, e, 1 /* ExistenceFilterMismatch */ , n.sequenceNumber);
                co(t, s);
            })), t.Gu.sh(n);
        }(t, n);
    } catch (e) {
        A("RemoteStore", "Failed to raise snapshot:", e), await Eo(t, e);
    }
}

/**
 * Recovery logic for IndexedDB errors that takes the network offline until
 * `op` succeeds. Retries are scheduled with backoff using
 * `enqueueRetryable()`. If `op()` is not provided, IndexedDB access is
 * validated via a generic operation.
 *
 * The returned Promise is resolved once the network is disabled and before
 * any retry attempt.
 */ async function Eo(t, e, n) {
    if (!ks(e)) throw e;
    t.Yu.add(1 /* IndexedDbFailed */), 
    // Disable network and raise offline snapshots
    await io(t), t.th.set("Offline" /* Offline */), n || (
    // Use a simple read operation to determine if IndexedDB recovered.
    // Ideally, we would expose a health check directly on SimpleDb, but
    // RemoteStore only has access to persistence through LocalStore.
    n = () => xr(t.ju)), 
    // Probe IndexedDB periodically and re-enable network
    t.cs.Cs((async () => {
        A("RemoteStore", "Retrying IndexedDB access"), await n(), t.Yu.delete(1 /* IndexedDbFailed */), 
        await so(t);
    }));
}

/**
 * Executes `op`. If `op` fails, takes the network offline until `op`
 * succeeds. Returns after the first attempt.
 */ function Io(t, e) {
    return e().catch((n => Eo(t, n, e)));
}

async function Ao(t) {
    const e = p(t), n = Co(e);
    let s = e.zu.length > 0 ? e.zu[e.zu.length - 1].batchId : -1;
    for (;Ro(e); ) try {
        const t = await kr(e.ju, s);
        if (null === t) {
            0 === e.zu.length && n._u();
            break;
        }
        s = t.batchId, go(e, t);
    } catch (t) {
        await Eo(e, t);
    }
    Po(e) && yo(e);
}

/**
 * Returns true if we can add to the write pipeline (i.e. the network is
 * enabled and the write pipeline is not full).
 */ function Ro(t) {
    return _o(t) && t.zu.length < 10;
}

/**
 * Queues additional writes to be sent to the write stream, sending them
 * immediately if the write stream is established.
 */ function go(t, e) {
    t.zu.push(e);
    const n = Co(t);
    n.uu() && n.vu && n.Su(e.mutations);
}

function Po(t) {
    return _o(t) && !Co(t).cu() && t.zu.length > 0;
}

function yo(t) {
    Co(t).start();
}

async function Vo(t) {
    Co(t).Nu();
}

async function po(t) {
    const e = Co(t);
    // Send the write pipeline now that the stream is established.
        for (const n of t.zu) e.Su(n.mutations);
}

async function bo(t, e, n) {
    const s = t.zu.shift(), i = di.from(s, e, n);
    await Io(t, (() => t.Gu.ih(i))), 
    // It's possible that with the completion of this mutation another
    // slot has freed up.
    await Ao(t);
}

async function vo(t, e) {
    // If the write stream closed after the write handshake completes, a write
    // operation failed and we fail the pending operation.
    e && Co(t).vu && 
    // This error affects the actual write.
    await async function(t, e) {
        // Only handle permanent errors here. If it's transient, just let the retry
        // logic kick in.
        if (n = e.code, St(n) && n !== m.ABORTED) {
            // This was a permanent error, the request itself was the problem
            // so it's not going to succeed if we resend it.
            const n = t.zu.shift();
            // In this case it's also unlikely that the server itself is melting
            // down -- this was just a bad request so inhibit backoff on the next
            // restart.
                        Co(t).lu(), await Io(t, (() => t.Gu.rh(n.batchId, e))), 
            // It's possible that with the completion of this mutation
            // another slot has freed up.
            await Ao(t);
        }
        var n;
        /**
 * Maps an error Code from a GRPC status identifier like 'NOT_FOUND'.
 *
 * @returns The Code equivalent to the given status string or undefined if
 *     there is no match.
 */    }(t, e), 
    // The write stream might have been started by refilling the write
    // pipeline for failed writes
    Po(t) && yo(t);
}

/**
 * Toggles the network state when the client gains or loses its primary lease.
 */
async function So(t, e) {
    const n = p(t);
    e ? (n.Yu.delete(2 /* IsSecondary */), await so(n)) : e || (n.Yu.add(2 /* IsSecondary */), 
    await io(n), n.th.set("Unknown" /* Unknown */));
}

/**
 * If not yet initialized, registers the WatchStream and its network state
 * callback with `remoteStoreImpl`. Returns the existing stream if one is
 * already available.
 *
 * PORTING NOTE: On iOS and Android, the WatchStream gets registered on startup.
 * This is not done on Web to allow it to be tree-shaken.
 */ function Do(t) {
    return t.oh || (
    // Create stream (but note that it is not started yet).
    t.oh = function(t, e, n) {
        const s = p(t);
        return s.xu(), new Xr(e, s.iu, s.credentials, s.serializer, n);
    }
    /**
 * @license
 * Copyright 2018 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ (t.Ku, t.cs, {
        gu: wo.bind(null, t),
        Tu: mo.bind(null, t),
        yu: To.bind(null, t)
    }), t.Ju.push((async e => {
        e ? (t.oh.lu(), lo(t) ? ho(t) : t.th.set("Unknown" /* Unknown */)) : (await t.oh.stop(), 
        fo(t));
    }))), t.oh;
}

/**
 * If not yet initialized, registers the WriteStream and its network state
 * callback with `remoteStoreImpl`. Returns the existing stream if one is
 * already available.
 *
 * PORTING NOTE: On iOS and Android, the WriteStream gets registered on startup.
 * This is not done on Web to allow it to be tree-shaken.
 */ function Co(t) {
    return t.ah || (
    // Create stream (but note that it is not started yet).
    t.ah = function(t, e, n) {
        const s = p(t);
        return s.xu(), new Zr(e, s.iu, s.credentials, s.serializer, n);
    }(t.Ku, t.cs, {
        gu: Vo.bind(null, t),
        Tu: vo.bind(null, t),
        Cu: po.bind(null, t),
        Du: bo.bind(null, t)
    }), t.Ju.push((async e => {
        e ? (t.ah.lu(), 
        // This will start the write stream if necessary.
        await Ao(t)) : (await t.ah.stop(), t.zu.length > 0 && (A("RemoteStore", `Stopping write stream with ${t.zu.length} pending writes`), 
        t.zu = []));
    }))), t.ah;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ class No {
    constructor(t) {
        this.key = t;
    }
}

class Fo {
    constructor(t) {
        this.key = t;
    }
}

/**
 * View is responsible for computing the final merged truth of what docs are in
 * a query. It gets notified of local and remote changes to docs, and applies
 * the query filters and limits to determine the most correct possible results.
 */ class xo {
    constructor(t, 
    /** Documents included in the remote target */
    e) {
        this.query = t, this.uh = e, this.hh = null, 
        /**
         * A flag whether the view is current with the backend. A view is considered
         * current after it has seen the current flag from the backend and did not
         * lose consistency within the watch stream (e.g. because of an existence
         * filter mismatch).
         */
        this.te = !1, 
        /** Documents in the view but not in the remote target */
        this.lh = Qt(), 
        /** Document Keys that have local changes */
        this.Wt = Qt(), this._h = _s(t), this.fh = new Kt(this._h);
    }
    /**
     * The set of remote documents that the server has told us belongs to the target associated with
     * this view.
     */    get dh() {
        return this.uh;
    }
    /**
     * Iterates over a set of doc changes, applies the query limit, and computes
     * what the new results should be, what the changes were, and whether we may
     * need to go back to the local cache for more results. Does not make any
     * changes to the view.
     * @param docChanges The doc changes to apply to this view.
     * @param previousChanges If this is being called with a refill, then start
     *        with this set of docs and changes instead of the current view.
     * @return a new set of docs, changes, and refill flag.
     */    wh(t, e) {
        const n = e ? e.mh : new Gt, s = e ? e.fh : this.fh;
        let i = e ? e.Wt : this.Wt, r = s, o = !1;
        // Track the last doc in a (full) limit. This is necessary, because some
        // update (a delete, or an update moving a doc past the old limit) might
        // mean there is some other document in the local cache that either should
        // come (1) between the old last limit doc and the new last document, in the
        // case of updates, or (2) after the new last document, in the case of
        // deletes. So we keep this doc at the old limit to compare the updates to.
        // Note that this should never get used in a refill (when previousChanges is
        // set), because there will only be adds -- no deletes or updates.
        const a = Xn(this.query) && s.size === this.query.limit ? s.last() : null, c = Zn(this.query) && s.size === this.query.limit ? s.first() : null;
        // Drop documents out to meet limit/limitToLast requirement.
        if (t.ht(((t, e) => {
            const u = s.get(t);
            let h = e instanceof Kn ? e : null;
            h && (h = ls(this.query, h) ? h : null);
            const l = !!u && this.Wt.has(u.key), _ = !!h && (h.Je || 
            // We only consider committed mutations for documents that were
            // mutated during the lifetime of the view.
            this.Wt.has(h.key) && h.hasCommittedMutations);
            let f = !1;
            // Calculate change
                        if (u && h) {
                u.data().isEqual(h.data()) ? l !== _ && (n.track({
                    type: 3 /* Metadata */ ,
                    doc: h
                }), f = !0) : this.Th(u, h) || (n.track({
                    type: 2 /* Modified */ ,
                    doc: h
                }), f = !0, (a && this._h(h, a) > 0 || c && this._h(h, c) < 0) && (
                // This doc moved from inside the limit to outside the limit.
                // That means there may be some other doc in the local cache
                // that should be included instead.
                o = !0));
            } else !u && h ? (n.track({
                type: 0 /* Added */ ,
                doc: h
            }), f = !0) : u && !h && (n.track({
                type: 1 /* Removed */ ,
                doc: u
            }), f = !0, (a || c) && (
            // A doc was removed from a full limit query. We'll need to
            // requery from the local cache to see if we know about some other
            // doc that should be in the results.
            o = !0));
            f && (h ? (r = r.add(h), i = _ ? i.add(t) : i.delete(t)) : (r = r.delete(t), i = i.delete(t)));
        })), Xn(this.query) || Zn(this.query)) for (;r.size > this.query.limit; ) {
            const t = Xn(this.query) ? r.last() : r.first();
            r = r.delete(t.key), i = i.delete(t.key), n.track({
                type: 1 /* Removed */ ,
                doc: t
            });
        }
        return {
            fh: r,
            mh: n,
            Eh: o,
            Wt: i
        };
    }
    Th(t, e) {
        // We suppress the initial change event for documents that were modified as
        // part of a write acknowledgment (e.g. when the value of a server transform
        // is applied) as Watch will send us the same document again.
        // By suppressing the event, we only raise two user visible events (one with
        // `hasPendingWrites` and the final state of the document) instead of three
        // (one with `hasPendingWrites`, the modified document with
        // `hasPendingWrites` and the final state of the document).
        return t.Je && e.hasCommittedMutations && !e.Je;
    }
    /**
     * Updates the view with the given ViewDocumentChanges and optionally updates
     * limbo docs and sync state from the provided target change.
     * @param docChanges The set of changes to make to the view's docs.
     * @param updateLimboDocuments Whether to update limbo documents based on this
     *        change.
     * @param targetChange A target change to apply for computing limbo docs and
     *        sync state.
     * @return A new ViewChange with the given docs, changes, and sync state.
     */
    // PORTING NOTE: The iOS/Android clients always compute limbo document changes.
    yr(t, e, n) {
        const s = this.fh;
        this.fh = t.fh, this.Wt = t.Wt;
        // Sort changes based on type and query comparator
        const i = t.mh.Ut();
        i.sort(((t, e) => function(t, e) {
            const n = t => {
                switch (t) {
                  case 0 /* Added */ :
                    return 1;

                  case 2 /* Modified */ :
                  case 3 /* Metadata */ :
                    // A metadata change is converted to a modified change at the public
                    // api layer.  Since we sort by document key and then change type,
                    // metadata and modified changes must be sorted equivalently.
                    return 2;

                  case 1 /* Removed */ :
                    return 0;

                  default:
                    return y();
                }
            };
            return n(t) - n(e);
        }
        /**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ (t.type, e.type) || this._h(t.doc, e.doc))), this.Ih(n);
        const r = e ? this.Ah() : [], o = 0 === this.lh.size && this.te ? 1 /* Synced */ : 0 /* Local */ , a = o !== this.hh;
        if (this.hh = o, 0 !== i.length || a) {
            return {
                snapshot: new zt(this.query, t.fh, s, i, t.Wt, 0 /* Local */ === o, a, 
                /* excludesMetadataChanges= */ !1),
                Rh: r
            };
        }
        // no changes
        return {
            Rh: r
        };
    }
    /**
     * Applies an OnlineState change to the view, potentially generating a
     * ViewChange if the view's syncState changes as a result.
     */    Qs(t) {
        return this.te && "Offline" /* Offline */ === t ? (
        // If we're offline, set `current` to false and then call applyChanges()
        // to refresh our syncState and generate a ViewChange as appropriate. We
        // are guaranteed to get a new TargetChange that sets `current` back to
        // true once the client is back online.
        this.te = !1, this.yr({
            fh: this.fh,
            mh: new Gt,
            Wt: this.Wt,
            Eh: !1
        }, 
        /* updateLimboDocuments= */ !1)) : {
            Rh: []
        };
    }
    /**
     * Returns whether the doc for the given key should be in limbo.
     */    gh(t) {
        // If the remote end says it's part of this query, it's not in limbo.
        return !this.uh.has(t) && (
        // The local store doesn't think it's a result, so it shouldn't be in limbo.
        !!this.fh.has(t) && !this.fh.get(t).Je);
    }
    /**
     * Updates syncedDocuments, current, and limbo docs based on the given change.
     * Returns the list of changes to which docs are in limbo.
     */    Ih(t) {
        t && (t.ee.forEach((t => this.uh = this.uh.add(t))), t.ne.forEach((t => {})), t.se.forEach((t => this.uh = this.uh.delete(t))), 
        this.te = t.te);
    }
    Ah() {
        // We can only determine limbo documents when we're in-sync with the server.
        if (!this.te) return [];
        // TODO(klimt): Do this incrementally so that it's not quadratic when
        // updating many documents.
                const t = this.lh;
        this.lh = Qt(), this.fh.forEach((t => {
            this.gh(t.key) && (this.lh = this.lh.add(t.key));
        }));
        // Diff the new limbo docs with the old limbo docs.
        const e = [];
        return t.forEach((t => {
            this.lh.has(t) || e.push(new Fo(t));
        })), this.lh.forEach((n => {
            t.has(n) || e.push(new No(n));
        })), e;
    }
    /**
     * Update the in-memory state of the current view with the state read from
     * persistence.
     *
     * We update the query view whenever a client's primary status changes:
     * - When a client transitions from primary to secondary, it can miss
     *   LocalStorage updates and its query views may temporarily not be
     *   synchronized with the state on disk.
     * - For secondary to primary transitions, the client needs to update the list
     *   of `syncedDocuments` since secondary clients update their query views
     *   based purely on synthesized RemoteEvents.
     *
     * @param queryResult.documents - The documents that match the query according
     * to the LocalStore.
     * @param queryResult.remoteKeys - The keys of the documents that match the
     * query according to the backend.
     *
     * @return The ViewChange that resulted from this synchronization.
     */
    // PORTING NOTE: Multi-tab only.
    Ph(t) {
        this.uh = t.Fc, this.lh = Qt();
        const e = this.wh(t.documents);
        return this.yr(e, /*updateLimboDocuments=*/ !0);
    }
    /**
     * Returns a view snapshot as if this query was just listened to. Contains
     * a document add for every existing document and the `fromCache` and
     * `hasPendingWrites` status of the already established view.
     */
    // PORTING NOTE: Multi-tab only.
    yh() {
        return zt.Gt(this.query, this.fh, this.Wt, 0 /* Local */ === this.hh);
    }
}

/**
 * QueryView contains all of the data that SyncEngine needs to keep track of for
 * a particular query.
 */
class $o {
    constructor(
    /**
     * The query itself.
     */
    t, 
    /**
     * The target number created by the client that is used in the watch
     * stream to identify this query.
     */
    e, 
    /**
     * The view is responsible for computing the final merged truth of what
     * docs are in the query. It gets notified of local and remote changes,
     * and applies the query filters and limits to determine the most correct
     * possible results.
     */
    n) {
        this.query = t, this.targetId = e, this.view = n;
    }
}

/** Tracks a limbo resolution. */ class ko {
    constructor(t) {
        this.key = t, 
        /**
         * Set to true once we've received a document. This is used in
         * getRemoteKeysForTarget() and ultimately used by WatchChangeAggregator to
         * decide whether it needs to manufacture a delete event for the target once
         * the target is CURRENT.
         */
        this.Vh = !1;
    }
}

/**
 * An implementation of `SyncEngine` coordinating with other parts of SDK.
 *
 * The parts of SyncEngine that act as a callback to RemoteStore need to be
 * registered individually. This is done in `syncEngineWrite()` and
 * `syncEngineListen()` (as well as `applyPrimaryState()`) as these methods
 * serve as entry points to RemoteStore's functionality.
 *
 * Note: some field defined in this class might have public access level, but
 * the class is not exported so they are only accessible from this module.
 * This is useful to implement optional features (like bundles) in free
 * functions, such that they are tree-shakeable.
 */ class Mo {
    constructor(t, e, n, 
    // PORTING NOTE: Manages state synchronization in multi-tab environments.
    s, i, r) {
        this.ju = t, this.ph = e, this.bh = n, this.Sh = s, this.currentUser = i, this.Dh = r, 
        this.Ch = {}, this.Nh = new ft((t => us(t)), cs), this.Fh = new Map, 
        /**
         * The keys of documents that are in limbo for which we haven't yet started a
         * limbo resolution query.
         */
        this.xh = [], 
        /**
         * Keeps track of the target ID for each document that is in limbo with an
         * active target.
         */
        this.$h = new Ct(x.i), 
        /**
         * Keeps track of the information about an active limbo resolution for each
         * active target ID that was started for the purpose of limbo resolution.
         */
        this.kh = new Map, this.Mh = new Wr, 
        /** Stores user completion handlers, indexed by User and BatchId. */
        this.Oh = {}, 
        /** Stores user callbacks waiting for all pending writes to be acknowledged. */
        this.Lh = new Map, this.Bh = Ir.da(), this.onlineState = "Unknown" /* Unknown */ , 
        // The primary state is set to `true` or `false` immediately after Firestore
        // startup. In the interim, a client should only be considered primary if
        // `isPrimary` is true.
        this.qh = void 0;
    }
    get Uh() {
        return !0 === this.qh;
    }
}

/**
 * Initiates the new listen, resolves promise when listen enqueued to the
 * server. All the subsequent view snapshots or errors are sent to the
 * subscribed handlers. Returns the initial snapshot.
 */
async function Oo(t, e) {
    const n = _a(t);
    let s, i;
    const r = n.Nh.get(e);
    if (r) 
    // PORTING NOTE: With Multi-Tab Web, it is possible that a query view
    // already exists when EventManager calls us for the first time. This
    // happens when the primary tab is already listening to this query on
    // behalf of another tab and the user of the primary also starts listening
    // to the query. EventManager will not have an assigned target ID in this
    // case and calls `listen` to obtain this ID.
    s = r.targetId, n.Sh.Oi(s), i = r.view.yh(); else {
        const t = await Mr(n.ju, is(e)), r = n.Sh.Oi(t.targetId);
        s = t.targetId, i = await Lo(n, e, s, "current" === r), n.Uh && oo(n.ph, t);
    }
    return i;
}

/**
 * Registers a view for a previously unknown query and computes its initial
 * snapshot.
 */ async function Lo(t, e, n, s) {
    // PORTING NOTE: On Web only, we inject the code that registers new Limbo
    // targets based on view changes. This allows us to only depend on Limbo
    // changes when user code includes queries.
    t.Qh = (e, n, s) => async function(t, e, n, s) {
        let i = e.view.wh(n);
        i.Eh && (
        // The query has a limit and some docs were removed, so we need
        // to re-run the query against the local store to make sure we
        // didn't lose any good docs that had been past the limit.
        i = await Lr(t.ju, e.query, 
        /* usePreviousResults= */ !1).then((({documents: t}) => e.view.wh(t, i))));
        const r = s && s.zt.get(e.targetId), o = e.view.yr(i, 
        /* updateLimboDocuments= */ t.Uh, r);
        return Xo(t, e.targetId, o.Rh), o.snapshot;
    }(t, e, n, s);
    const i = await Lr(t.ju, e, 
    /* usePreviousResults= */ !0), r = new xo(e, i.Fc), o = r.wh(i.documents), a = Yt.Zt(n, s && "Offline" /* Offline */ !== t.onlineState), c = r.yr(o, 
    /* updateLimboDocuments= */ t.Uh, a);
    Xo(t, n, c.Rh);
    const u = new $o(e, n, r);
    return t.Nh.set(e, u), t.Fh.has(n) ? t.Fh.get(n).push(e) : t.Fh.set(n, [ e ]), c.snapshot;
}

/** Stops listening to the query. */ async function Bo(t, e) {
    const n = p(t), s = n.Nh.get(e), i = n.Fh.get(s.targetId);
    if (i.length > 1) return n.Fh.set(s.targetId, i.filter((t => !cs(t, e)))), void n.Nh.delete(e);
    // No other queries are mapped to the target, clean up the query and the target.
        if (n.Uh) {
        // We need to remove the local query target first to allow us to verify
        // whether any other client is still interested in this target.
        n.Sh.Bi(s.targetId);
        n.Sh.Fi(s.targetId) || await Or(n.ju, s.targetId, 
        /*keepPersistedTargetData=*/ !1).then((() => {
            n.Sh.Ui(s.targetId), ao(n.ph, s.targetId), Yo(n, s.targetId);
        })).catch(Qr);
    } else Yo(n, s.targetId), await Or(n.ju, s.targetId, 
    /*keepPersistedTargetData=*/ !0);
}

/**
 * Initiates the write of local mutation batch which involves adding the
 * writes to the mutation queue, notifying the remote store about new
 * mutations and raising events for any changes this write caused.
 *
 * The promise returned by this call is resolved when the above steps
 * have completed, *not* when the write was acked by the backend. The
 * userCallback is resolved once the write was acked/rejected by the
 * backend (or failed locally for any other reason).
 */ async function qo(t, e, n) {
    const s = fa(t);
    try {
        const t = await 
        /* Accepts locally generated Mutations and commit them to storage. */
        function(t, e) {
            const n = p(t), s = dt.now(), i = e.reduce(((t, e) => t.add(e.key)), Qt());
            let r;
            return n.persistence.runTransaction("Locally write mutations", "readwrite", (t => n.Cc.kr(t, i).next((i => {
                r = i;
                // For non-idempotent mutations (such as `FieldValue.increment()`),
                // we record the base state in a separate patch mutation. This is
                // later used to guarantee consistent values and prevents flicker
                // even if the backend sends us an update that already includes our
                // transform.
                const o = [];
                for (const t of e) {
                    const e = Cn(t, r.get(t.key));
                    null != e && 
                    // NOTE: The base state should only be applied if there's some
                    // existing document to override, so use a Precondition of
                    // exists=true
                    o.push(new $n(t.key, e, Wn(e.proto.mapValue), pn.exists(!0)));
                }
                return n.Sr.ko(t, s, o, e);
            })))).then((t => {
                const e = t.lr(r);
                return {
                    batchId: t.batchId,
                    wr: e
                };
            }));
        }(s.ju, e);
        s.Sh.xi(t.batchId), function(t, e, n) {
            let s = t.Oh[t.currentUser.ti()];
            s || (s = new Ct(st));
            s = s.ot(e, n), t.Oh[t.currentUser.ti()] = s;
        }
        /**
 * Resolves or rejects the user callback for the given batch and then discards
 * it.
 */ (s, t.batchId, n), await ea(s, t.wr), await Ao(s.ph);
    } catch (t) {
        // If we can't persist the mutation, we reject the user callback and
        // don't send the mutation. The user can then retry the write.
        const e = Ks(t, "Failed to persist write");
        n.reject(e);
    }
}

/**
 * Applies one remote event to the sync engine, notifying any views of the
 * changes, and releasing any pending mutation batches that would become
 * visible because of the snapshot version the remote event contains.
 */ async function Uo(t, e) {
    const n = p(t);
    try {
        const t = await $r(n.ju, e);
        // Update `receivedDocument` as appropriate for any limbo targets.
                e.zt.forEach(((t, e) => {
            const s = n.kh.get(e);
            s && (
            // Since this is a limbo resolution lookup, it's for a single document
            // and it could be added, modified, or removed, but not a combination.
            V(t.ee.size + t.ne.size + t.se.size <= 1), t.ee.size > 0 ? s.Vh = !0 : t.ne.size > 0 ? V(s.Vh) : t.se.size > 0 && (V(s.Vh), 
            s.Vh = !1));
        })), await ea(n, t, e);
    } catch (t) {
        await Qr(t);
    }
}

/**
 * Applies an OnlineState change to the sync engine and notifies any views of
 * the change.
 */ function Qo(t, e, n) {
    const s = p(t);
    // If we are the secondary client, we explicitly ignore the remote store's
    // online state (the local client may go offline, even though the primary
    // tab remains online) and only apply the primary tab's online state from
    // SharedClientState.
        if (s.Uh && 0 /* RemoteStore */ === n || !s.Uh && 1 /* SharedClientState */ === n) {
        const t = [];
        s.Nh.forEach(((n, s) => {
            const i = s.view.Qs(e);
            i.snapshot && t.push(i.snapshot);
        })), function(t, e) {
            const n = p(t);
            n.onlineState = e;
            let s = !1;
            n.Bs.forEach(((t, n) => {
                for (const t of n.listeners) 
                // Run global snapshot listeners if a consistent snapshot has been emitted.
                t.Qs(e) && (s = !0);
            })), s && Zs(n);
        }(s.bh, e), t.length && s.Ch.yu(t), s.onlineState = e, s.Uh && s.Sh.Ki(e);
    }
}

/**
 * Rejects the listen for the given targetID. This can be triggered by the
 * backend for any active target.
 *
 * @param syncEngine The sync engine implementation.
 * @param targetId The targetID corresponds to one previously initiated by the
 * user as part of TargetData passed to listen() on RemoteStore.
 * @param err A description of the condition that has forced the rejection.
 * Nearly always this will be an indication that the user is no longer
 * authorized to see the data matching the target.
 */ async function Wo(t, e, n) {
    const s = p(t);
    // PORTING NOTE: Multi-tab only.
        s.Sh.Qi(e, "rejected", n);
    const i = s.kh.get(e), r = i && i.key;
    if (r) {
        // TODO(klimt): We really only should do the following on permission
        // denied errors, but we don't have the cause code here.
        // It's a limbo doc. Create a synthetic event saying it was deleted.
        // This is kind of a hack. Ideally, we would have a method in the local
        // store to purge a document. However, it would be tricky to keep all of
        // the local store's invariants with another method.
        let t = new Ct(x.i);
        t = t.ot(r, new Gn(r, wt.min()));
        const n = Qt().add(r), i = new Ht(wt.min(), 
        /* targetChanges= */ new Map, 
        /* targetMismatches= */ new xt(st), t, n);
        await Uo(s, i), 
        // Since this query failed, we won't want to manually unlisten to it.
        // We only remove it from bookkeeping after we successfully applied the
        // RemoteEvent. If `applyRemoteEvent()` throws, we want to re-listen to
        // this query when the RemoteStore restarts the Watch stream, which should
        // re-trigger the target failure.
        s.$h = s.$h.remove(r), s.kh.delete(e), ta(s);
    } else await Or(s.ju, e, 
    /* keepPersistedTargetData */ !1).then((() => Yo(s, e, n))).catch(Qr);
}

async function jo(t, e) {
    const n = p(t), s = e.batch.batchId;
    try {
        const t = await Fr(n.ju, e);
        // The local store may or may not be able to apply the write result and
        // raise events immediately (depending on whether the watcher is caught
        // up), so we raise user callbacks first so that they consistently happen
        // before listen events.
                Ho(n, s, /*error=*/ null), zo(n, s), n.Sh.ki(s, "acknowledged"), await ea(n, t);
    } catch (t) {
        await Qr(t);
    }
}

async function Ko(t, e, n) {
    const s = p(t);
    try {
        const t = await function(t, e) {
            const n = p(t);
            return n.persistence.runTransaction("Reject batch", "readwrite-primary", (t => {
                let s;
                return n.Sr.Oo(t, e).next((e => (V(null !== e), s = e.keys(), n.Sr.Wo(t, e)))).next((() => n.Sr.zo(t))).next((() => n.Cc.kr(t, s)));
            }));
        }
        /**
 * Returns the largest (latest) batch id in mutation queue that is pending
 * server response.
 *
 * Returns `BATCHID_UNKNOWN` if the queue is empty.
 */ (s.ju, e);
        // The local store may or may not be able to apply the write result and
        // raise events immediately (depending on whether the watcher is caught up),
        // so we raise user callbacks first so that they consistently happen before
        // listen events.
                Ho(s, e, n), zo(s, e), s.Sh.ki(e, "rejected", n), await ea(s, t);
    } catch (n) {
        await Qr(n);
    }
}

/**
 * Registers a user callback that resolves when all pending mutations at the moment of calling
 * are acknowledged .
 */ async function Go(t, e) {
    const n = p(t);
    _o(n.ph) || A("SyncEngine", "The network is disabled. The task returned by 'awaitPendingWrites()' will not complete until the network is enabled.");
    try {
        const t = await function(t) {
            const e = p(t);
            return e.persistence.runTransaction("Get highest unacknowledged batch id", "readonly", (t => e.Sr.qo(t)));
        }(n.ju);
        if (-1 === t) 
        // Trigger the callback right away if there is no pending writes at the moment.
        return void e.resolve();
        const s = n.Lh.get(t) || [];
        s.push(e), n.Lh.set(t, s);
    } catch (t) {
        const n = Ks(t, "Initialization of waitForPendingWrites() operation failed");
        e.reject(n);
    }
}

/**
 * Triggers the callbacks that are waiting for this batch id to get acknowledged by server,
 * if there are any.
 */ function zo(t, e) {
    (t.Lh.get(e) || []).forEach((t => {
        t.resolve();
    })), t.Lh.delete(e);
}

/** Reject all outstanding callbacks waiting for pending writes to complete. */ function Ho(t, e, n) {
    const s = p(t);
    let i = s.Oh[s.currentUser.ti()];
    // NOTE: Mutations restored from persistence won't have callbacks, so it's
    // okay for there to be no callback for this ID.
        if (i) {
        const t = i.get(e);
        t && (n ? t.reject(n) : t.resolve(), i = i.remove(e)), s.Oh[s.currentUser.ti()] = i;
    }
}

function Yo(t, e, n = null) {
    t.Sh.Bi(e);
    for (const s of t.Fh.get(e)) t.Nh.delete(s), n && t.Ch.Wh(s, n);
    if (t.Fh.delete(e), t.Uh) {
        t.Mh.Uc(e).forEach((e => {
            t.Mh.Ho(e) || 
            // We removed the last reference for this key
            Jo(t, e);
        }));
    }
}

function Jo(t, e) {
    // It's possible that the target already got removed because the query failed. In that case,
    // the key won't exist in `limboTargetsByKey`. Only do the cleanup if we still have the target.
    const n = t.$h.get(e);
    null !== n && (ao(t.ph, n), t.$h = t.$h.remove(e), t.kh.delete(n), ta(t));
}

function Xo(t, e, n) {
    for (const s of n) if (s instanceof No) t.Mh.Da(s.key, e), Zo(t, s); else if (s instanceof Fo) {
        A("SyncEngine", "Document no longer in limbo: " + s.key), t.Mh.Na(s.key, e);
        t.Mh.Ho(s.key) || 
        // We removed the last reference for this key
        Jo(t, s.key);
    } else y();
}

function Zo(t, e) {
    const n = e.key;
    t.$h.get(n) || (A("SyncEngine", "New document in limbo: " + n), t.xh.push(n), ta(t));
}

/**
 * Starts listens for documents in limbo that are enqueued for resolution,
 * subject to a maximum number of concurrent resolutions.
 *
 * Without bounding the number of concurrent resolutions, the server can fail
 * with "resource exhausted" errors which can lead to pathological client
 * behavior as seen in https://github.com/firebase/firebase-js-sdk/issues/2683.
 */ function ta(t) {
    for (;t.xh.length > 0 && t.$h.size < t.Dh; ) {
        const e = t.xh.shift(), n = t.Bh.next();
        t.kh.set(n, new ko(e)), t.$h = t.$h.ot(e, n), oo(t.ph, new Vt(is(Jn(e.path)), n, 2 /* LimboResolution */ , ni.ai));
    }
}

async function ea(t, e, n) {
    const s = p(t), i = [], r = [], o = [];
    s.Nh.m() || (s.Nh.forEach(((t, a) => {
        o.push(s.Qh(a, e, n).then((t => {
            if (t) {
                s.Uh && s.Sh.Qi(a.targetId, t.fromCache ? "not-current" : "current"), i.push(t);
                const e = Ii.zr(a.targetId, t);
                r.push(e);
            }
        })));
    })), await Promise.all(o), s.Ch.yu(i), await async function(t, e) {
        const n = p(t);
        try {
            await n.persistence.runTransaction("notifyLocalViewChanges", "readwrite", (t => Ns.forEach(e, (e => Ns.forEach(e.Kr, (s => n.persistence.No.Da(t, e.targetId, s))).next((() => Ns.forEach(e.Gr, (s => n.persistence.No.Na(t, e.targetId, s)))))))));
        } catch (t) {
            if (!ks(t)) throw t;
            // If `notifyLocalViewChanges` fails, we did not advance the sequence
            // number for the documents that were included in this transaction.
            // This might trigger them to be deleted earlier than they otherwise
            // would have, but it should not invalidate the integrity of the data.
            A("LocalStore", "Failed to update sequence numbers: " + t);
        }
        for (const t of e) {
            const e = t.targetId;
            if (!t.fromCache) {
                const t = n.bc.get(e), s = t.nt, i = t.rt(s);
                // Advance the last limbo free snapshot version
                                n.bc = n.bc.ot(e, i);
            }
        }
    }(s.ju, r));
}

async function na(t, e) {
    const n = p(t);
    if (!n.currentUser.isEqual(e)) {
        A("SyncEngine", "User change. New user:", e.ti());
        const t = await 
        /**
 * Tells the LocalStore that the currently authenticated user has changed.
 *
 * In response the local store switches the mutation queue to the new user and
 * returns any resulting document changes.
 */
        // PORTING NOTE: Android and iOS only return the documents affected by the
        // change.
        async function(t, e) {
            const n = p(t);
            let s = n.Sr, i = n.Cc;
            const r = await n.persistence.runTransaction("Handle user change", "readonly", (t => {
                // Swap out the mutation queue, grabbing the pending mutation batches
                // before and after.
                let r;
                return n.Sr.Uo(t).next((o => (r = o, s = n.persistence.mc(e), 
                // Recreate our LocalDocumentsView using the new
                // MutationQueue.
                i = new Ei(n.Dc, s, n.persistence.Ic()), s.Uo(t)))).next((e => {
                    const n = [], s = [];
                    // Union the old/new changed keys.
                    let o = Qt();
                    for (const t of r) {
                        n.push(t.batchId);
                        for (const e of t.mutations) o = o.add(e.key);
                    }
                    for (const t of e) {
                        s.push(t.batchId);
                        for (const e of t.mutations) o = o.add(e.key);
                    }
                    // Return the set of all (potentially) changed documents and the list
                    // of mutation batch IDs that were affected by change.
                                        return i.kr(t, o).next((t => ({
                        jh: t,
                        Kh: n,
                        Gh: s
                    })));
                }));
            }));
            return n.Sr = s, n.Cc = i, n.Vc.Nc(n.Cc), r;
        }(n.ju, e);
        n.currentUser = e, 
        // Fails tasks waiting for pending writes requested by previous user.
        function(t, e) {
            t.Lh.forEach((t => {
                t.forEach((t => {
                    t.reject(new T(m.CANCELLED, e));
                }));
            })), t.Lh.clear();
        }(n, "'waitForPendingWrites' promise is rejected due to a user change."), 
        // TODO(b/114226417): Consider calling this only in the primary tab.
        n.Sh.ji(e, t.Kh, t.Gh), await ea(n, t.jh);
    }
}

function sa(t, e) {
    const n = p(t), s = n.kh.get(e);
    if (s && s.Vh) return Qt().add(s.key);
    {
        let t = Qt();
        const s = n.Fh.get(e);
        if (!s) return t;
        for (const e of s) {
            const s = n.Nh.get(e);
            t = t.kt(s.view.dh);
        }
        return t;
    }
}

/**
 * Reconcile the list of synced documents in an existing view with those
 * from persistence.
 */ async function ia(t, e) {
    const n = p(t), s = await Lr(n.ju, e.query, 
    /* usePreviousResults= */ !0), i = e.view.Ph(s);
    return n.Uh && Xo(n, e.targetId, i.Rh), i;
}

/** Applies a mutation state to an existing batch.  */
// PORTING NOTE: Multi-Tab only.
async function ra(t, e, n, s) {
    const i = p(t), r = await function(t, e) {
        const n = p(t), s = p(n.Sr);
        return n.persistence.runTransaction("Lookup mutation documents", "readonly", (t => s.Lo(t, e).next((e => e ? n.Cc.kr(t, e) : Ns.resolve(null)))));
    }
    // PORTING NOTE: Multi-Tab only.
    (i.ju, e);
    null !== r ? ("pending" === n ? 
    // If we are the primary client, we need to send this write to the
    // backend. Secondary clients will ignore these writes since their remote
    // connection is disabled.
    await Ao(i.ph) : "acknowledged" === n || "rejected" === n ? (
    // NOTE: Both these methods are no-ops for batches that originated from
    // other clients.
    Ho(i, e, s || null), zo(i, e), function(t, e) {
        p(p(t).Sr).Ko(e);
    }
    // PORTING NOTE: Multi-Tab only.
    (i.ju, e)) : y(), await ea(i, r)) : 
    // A throttled tab may not have seen the mutation before it was completed
    // and removed from the mutation queue, in which case we won't have cached
    // the affected documents. In this case we can safely ignore the update
    // since that means we didn't apply the mutation locally at all (if we
    // had, we would have cached the affected documents), and so we will just
    // see any resulting document changes via normal remote document updates
    // as applicable.
    A("SyncEngine", "Cannot apply mutation batch with id: " + e);
}

/** Applies a query target change from a different tab. */
// PORTING NOTE: Multi-Tab only.
async function oa(t, e) {
    const n = p(t);
    if (_a(n), fa(n), !0 === e && !0 !== n.qh) {
        // Secondary tabs only maintain Views for their local listeners and the
        // Views internal state may not be 100% populated (in particular
        // secondary tabs don't track syncedDocuments, the set of documents the
        // server considers to be in the target). So when a secondary becomes
        // primary, we need to need to make sure that all views for all targets
        // match the state on disk.
        const t = n.Sh.Ci(), e = await aa(n, t.A());
        n.qh = !0, await So(n.ph, !0);
        for (const t of e) oo(n.ph, t);
    } else if (!1 === e && !1 !== n.qh) {
        const t = [];
        let e = Promise.resolve();
        n.Fh.forEach(((s, i) => {
            n.Sh.qi(i) ? t.push(i) : e = e.then((() => (Yo(n, i), Or(n.ju, i, 
            /*keepPersistedTargetData=*/ !0)))), ao(n.ph, i);
        })), await e, await aa(n, t), 
        // PORTING NOTE: Multi-Tab only.
        function(t) {
            const e = p(t);
            e.kh.forEach(((t, n) => {
                ao(e.ph, n);
            })), e.Mh.Qc(), e.kh = new Map, e.$h = new Ct(x.i);
        }
        /**
 * Reconcile the query views of the provided query targets with the state from
 * persistence. Raises snapshots for any changes that affect the local
 * client and returns the updated state of all target's query data.
 *
 * @param syncEngine The sync engine implementation
 * @param targets the list of targets with views that need to be recomputed
 * @param transitionToPrimary `true` iff the tab transitions from a secondary
 * tab to a primary tab
 */
        // PORTING NOTE: Multi-Tab only.
        (n), n.qh = !1, await So(n.ph, !1);
    }
}

async function aa(t, e, n) {
    const s = p(t), i = [], r = [];
    for (const t of e) {
        let e;
        const n = s.Fh.get(t);
        if (n && 0 !== n.length) {
            // For queries that have a local View, we fetch their current state
            // from LocalStore (as the resume token and the snapshot version
            // might have changed) and reconcile their views with the persisted
            // state (the list of syncedDocuments may have gotten out of sync).
            e = await Mr(s.ju, is(n[0]));
            for (const t of n) {
                const e = s.Nh.get(t), n = await ia(s, e);
                n.snapshot && r.push(n.snapshot);
            }
        } else {
            // For queries that never executed on this client, we need to
            // allocate the target in LocalStore and initialize a new View.
            const n = await Br(s.ju, t);
            e = await Mr(s.ju, n), await Lo(s, ca(n), t, 
            /*current=*/ !1);
        }
        i.push(e);
    }
    return s.Ch.yu(r), i;
}

/**
 * Creates a `Query` object from the specified `Target`. There is no way to
 * obtain the original `Query`, so we synthesize a `Query` from the `Target`
 * object.
 *
 * The synthesized result might be different from the original `Query`, but
 * since the synthesized `Query` should return the same results as the
 * original one (only the presentation of results might differ), the potential
 * difference will not cause issues.
 */
// PORTING NOTE: Multi-Tab only.
function ca(t) {
    return Yn(t.path, t.collectionGroup, t.orderBy, t.filters, t.limit, "F" /* First */ , t.startAt, t.endAt);
}

/** Returns the IDs of the clients that are currently active. */
// PORTING NOTE: Multi-Tab only.
function ua(t) {
    const e = p(t);
    return p(p(e.ju).persistence).pi();
}

/** Applies a query target change from a different tab. */
// PORTING NOTE: Multi-Tab only.
async function ha(t, e, n, s) {
    const i = p(t);
    if (i.qh) 
    // If we receive a target state notification via WebStorage, we are
    // either already secondary or another tab has taken the primary lease.
    A("SyncEngine", "Ignoring unexpected query state notification."); else if (i.Fh.has(e)) switch (n) {
      case "current":
      case "not-current":
        {
            const t = await qr(i.ju), s = Ht.Xt(e, "current" === n);
            await ea(i, t, s);
            break;
        }

      case "rejected":
        await Or(i.ju, e, 
        /* keepPersistedTargetData */ !0), Yo(i, e, s);
        break;

      default:
        y();
    }
}

/** Adds or removes Watch targets for queries from different tabs. */ async function la(t, e, n) {
    const s = _a(t);
    if (s.qh) {
        for (const t of e) {
            if (s.Fh.has(t)) {
                // A target might have been added in a previous attempt
                A("SyncEngine", "Adding an already active target " + t);
                continue;
            }
            const e = await Br(s.ju, t), n = await Mr(s.ju, e);
            await Lo(s, ca(e), n.targetId, 
            /*current=*/ !1), oo(s.ph, n);
        }
        for (const t of n) 
        // Check that the target is still active since the target might have been
        // removed if it has been rejected by the backend.
        s.Fh.has(t) && 
        // Release queries that are still active.
        await Or(s.ju, t, 
        /* keepPersistedTargetData */ !1).then((() => {
            ao(s.ph, t), Yo(s, t);
        })).catch(Qr);
    }
}

function _a(t) {
    const e = p(t);
    return e.ph.Gu.sh = Uo.bind(null, e), e.ph.Gu.qe = sa.bind(null, e), e.ph.Gu.nh = Wo.bind(null, e), 
    e.Ch.yu = Js.bind(null, e.bh), e.Ch.Wh = Xs.bind(null, e.bh), e;
}

function fa(t) {
    const e = p(t);
    return e.ph.Gu.ih = jo.bind(null, e), e.ph.Gu.rh = Ko.bind(null, e), e;
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// TOOD(b/140938512): Drop SimpleQueryEngine and rename IndexFreeQueryEngine.
/**
 * A query engine that takes advantage of the target document mapping in the
 * QueryCache. The IndexFreeQueryEngine optimizes query execution by only
 * reading the documents that previously matched a query plus any documents that were
 * edited after the query was last listened to.
 *
 * There are some cases where Index-Free queries are not guaranteed to produce
 * the same results as full collection scans. In these cases, the
 * IndexFreeQueryEngine falls back to full query processing. These cases are:
 *
 * - Limit queries where a document that matched the query previously no longer
 *   matches the query.
 *
 * - Limit queries where a document edit may cause the document to sort below
 *   another document that is in the local cache.
 *
 * - Queries that have never been CURRENT or free of Limbo documents.
 */ class da {
    Nc(t) {
        this.zh = t;
    }
    Lr(t, e, s, i) {
        // Queries that match all documents don't benefit from using
        // IndexFreeQueries. It is more efficient to scan all documents in a
        // collection, rather than to perform individual lookups.
        return function(t) {
            return 0 === t.filters.length && null === t.limit && null == t.startAt && null == t.endAt && (0 === t.on.length || 1 === t.on.length && t.on[0].field.p());
        }(e) || s.isEqual(wt.min()) ? this.Hh(t, e) : this.zh.kr(t, i).next((r => {
            const o = this.Yh(e, r);
            return (Xn(e) || Zn(e)) && this.Eh(e.an, o, i, s) ? this.Hh(t, e) : (I() <= n.DEBUG && A("IndexFreeQueryEngine", "Re-using previous result from %s to execute query: %s", s.toString(), hs(e)), 
            this.zh.Lr(t, e, s).next((t => (
            // We merge `previousResults` into `updateResults`, since
            // `updateResults` is already a DocumentMap. If a document is
            // contained in both lists, then its contents are the same.
            o.forEach((e => {
                t = t.ot(e.key, e);
            })), t))));
        }));
        // Queries that have never seen a snapshot without limbo free documents
        // should also be run as a full collection scan.
        }
    /** Applies the query filter and sorting to the provided documents.  */    Yh(t, e) {
        // Sort the documents and re-apply the query filter since previously
        // matching documents do not necessarily still match the query.
        let n = new xt(_s(t));
        return e.forEach(((e, s) => {
            s instanceof Kn && ls(t, s) && (n = n.add(s));
        })), n;
    }
    /**
     * Determines if a limit query needs to be refilled from cache, making it
     * ineligible for index-free execution.
     *
     * @param sortedPreviousResults The documents that matched the query when it
     * was last synchronized, sorted by the query's comparator.
     * @param remoteKeys The document keys that matched the query at the last
     * snapshot.
     * @param limboFreeSnapshotVersion The version of the snapshot when the query
     * was last synchronized.
     */    Eh(t, e, n, s) {
        // The query needs to be refilled if a previously matching document no
        // longer matches.
        if (n.size !== e.size) return !0;
        // Limit queries are not eligible for index-free query execution if there is
        // a potential that an older document from cache now sorts before a document
        // that was previously part of the limit. This, however, can only happen if
        // the document at the edge of the limit goes out of limit.
        // If a document that is not the limit boundary sorts differently,
        // the boundary of the limit itself did not change and documents from cache
        // will continue to be "rejected" by this boundary. Therefore, we can ignore
        // any modifications that don't affect the last document.
                const i = "F" /* First */ === t ? e.last() : e.first();
        return !!i && (i.hasPendingWrites || i.version.L(s) > 0);
    }
    Hh(t, e) {
        return I() <= n.DEBUG && A("IndexFreeQueryEngine", "Using full collection scan to execute query:", hs(e)), 
        this.zh.Lr(t, e, wt.min());
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ class wa {
    constructor(t, e) {
        this.Dr = t, this.No = e, 
        /**
         * The set of all mutations that have been sent but not yet been applied to
         * the backend.
         */
        this.Sr = [], 
        /** Next value to use when assigning sequential IDs to each mutation batch. */
        this.Jh = 1, 
        /** An ordered mapping between documents and the mutations batch IDs. */
        this.Xh = new xt(jr.kc);
    }
    $o(t) {
        return Ns.resolve(0 === this.Sr.length);
    }
    ko(t, e, n, s) {
        const i = this.Jh;
        if (this.Jh++, this.Sr.length > 0) {
            this.Sr[this.Sr.length - 1];
        }
        const r = new fi(i, e, n, s);
        this.Sr.push(r);
        // Track references by document key and index collection parents.
        for (const e of s) this.Xh = this.Xh.add(new jr(e.key, i)), this.Dr.Mo(t, e.key.path.h());
        return Ns.resolve(r);
    }
    Oo(t, e) {
        return Ns.resolve(this.Zh(e));
    }
    Bo(t, e) {
        const n = e + 1, s = this.tl(n), i = s < 0 ? 0 : s;
        // The requested batchId may still be out of range so normalize it to the
        // start of the queue.
                return Ns.resolve(this.Sr.length > i ? this.Sr[i] : null);
    }
    qo() {
        return Ns.resolve(0 === this.Sr.length ? -1 : this.Jh - 1);
    }
    Uo(t) {
        return Ns.resolve(this.Sr.slice());
    }
    Nr(t, e) {
        const n = new jr(e, 0), s = new jr(e, Number.POSITIVE_INFINITY), i = [];
        return this.Xh.Ft([ n, s ], (t => {
            const e = this.Zh(t.jc);
            i.push(e);
        })), Ns.resolve(i);
    }
    Or(t, e) {
        let n = new xt(st);
        return e.forEach((t => {
            const e = new jr(t, 0), s = new jr(t, Number.POSITIVE_INFINITY);
            this.Xh.Ft([ e, s ], (t => {
                n = n.add(t.jc);
            }));
        })), Ns.resolve(this.el(n));
    }
    Wr(t, e) {
        // Use the query path as a prefix for testing if a document matches the
        // query.
        const n = e.path, s = n.length + 1;
        // Construct a document reference for actually scanning the index. Unlike
        // the prefix the document key in this reference must have an even number of
        // segments. The empty segment can be used a suffix of the query path
        // because it precedes all other segments in an ordered traversal.
        let i = n;
        x.F(i) || (i = i.child(""));
        const r = new jr(new x(i), 0);
        // Find unique batchIDs referenced by all documents potentially matching the
        // query.
                let o = new xt(st);
        return this.Xh.xt((t => {
            const e = t.key.path;
            return !!n.T(e) && (
            // Rows with document keys more than one segment longer than the query
            // path can't be matches. For example, a query on 'rooms' can't match
            // the document /rooms/abc/messages/xyx.
            // TODO(mcg): we'll need a different scanner when we implement
            // ancestor queries.
            e.length === s && (o = o.add(t.jc)), !0);
        }), r), Ns.resolve(this.el(o));
    }
    el(t) {
        // Construct an array of matching batches, sorted by batchID to ensure that
        // multiple mutations affecting the same document key are applied in order.
        const e = [];
        return t.forEach((t => {
            const n = this.Zh(t);
            null !== n && e.push(n);
        })), e;
    }
    Wo(t, e) {
        V(0 === this.nl(e.batchId, "removed")), this.Sr.shift();
        let n = this.Xh;
        return Ns.forEach(e.mutations, (s => {
            const i = new jr(s.key, e.batchId);
            return n = n.delete(i), this.No.Go(t, s.key);
        })).next((() => {
            this.Xh = n;
        }));
    }
    Ko(t) {
        // No-op since the memory mutation queue does not maintain a separate cache.
    }
    Ho(t, e) {
        const n = new jr(e, 0), s = this.Xh.$t(n);
        return Ns.resolve(e.isEqual(s && s.key));
    }
    zo(t) {
        return this.Sr.length, Ns.resolve();
    }
    /**
     * Finds the index of the given batchId in the mutation queue and asserts that
     * the resulting index is within the bounds of the queue.
     *
     * @param batchId The batchId to search for
     * @param action A description of what the caller is doing, phrased in passive
     * form (e.g. "acknowledged" in a routine that acknowledges batches).
     */    nl(t, e) {
        return this.tl(t);
    }
    /**
     * Finds the index of the given batchId in the mutation queue. This operation
     * is O(1).
     *
     * @return The computed index of the batch with the given batchId, based on
     * the state of the queue. Note this index can be negative if the requested
     * batchId has already been remvoed from the queue or past the end of the
     * queue if the batchId is larger than the last added batch.
     */    tl(t) {
        if (0 === this.Sr.length) 
        // As an index this is past the end of the queue
        return 0;
        // Examine the front of the queue to figure out the difference between the
        // batchId and indexes in the array. Note that since the queue is ordered
        // by batchId, if the first batch has a larger batchId then the requested
        // batchId doesn't exist in the queue.
                return t - this.Sr[0].batchId;
    }
    /**
     * A version of lookupMutationBatch that doesn't return a promise, this makes
     * other functions that uses this code easier to read and more efficent.
     */    Zh(t) {
        const e = this.tl(t);
        if (e < 0 || e >= this.Sr.length) return null;
        return this.Sr[e];
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * The memory-only RemoteDocumentCache for IndexedDb. To construct, invoke
 * `newMemoryRemoteDocumentCache()`.
 */
class ma {
    /**
     * @param sizer Used to assess the size of a document. For eager GC, this is expected to just
     * return 0 to avoid unnecessarily doing the work of calculating the size.
     */
    constructor(t, e) {
        this.Dr = t, this.sl = e, 
        /** Underlying cache of documents and their read times. */
        this.docs = new Ct(x.i), 
        /** Size of all cached documents. */
        this.size = 0;
    }
    /**
     * Adds the supplied entry to the cache and updates the cache size as appropriate.
     *
     * All calls of `addEntry`  are required to go through the RemoteDocumentChangeBuffer
     * returned by `newChangeBuffer()`.
     */    Er(t, e, n) {
        const s = e.key, i = this.docs.get(s), r = i ? i.size : 0, o = this.sl(e);
        return this.docs = this.docs.ot(s, {
            ta: e,
            size: o,
            readTime: n
        }), this.size += o - r, this.Dr.Mo(t, s.path.h());
    }
    /**
     * Removes the specified entry from the cache and updates the cache size as appropriate.
     *
     * All calls of `removeEntry` are required to go through the RemoteDocumentChangeBuffer
     * returned by `newChangeBuffer()`.
     */    Ar(t) {
        const e = this.docs.get(t);
        e && (this.docs = this.docs.remove(t), this.size -= e.size);
    }
    Rr(t, e) {
        const n = this.docs.get(e);
        return Ns.resolve(n ? n.ta : null);
    }
    getEntries(t, e) {
        let n = Ot();
        return e.forEach((t => {
            const e = this.docs.get(t);
            n = n.ot(t, e ? e.ta : null);
        })), Ns.resolve(n);
    }
    Lr(t, e, n) {
        let s = Bt();
        // Documents are ordered by key, so we can use a prefix scan to narrow down
        // the documents we need to match the query against.
                const i = new x(e.path.child("")), r = this.docs.ft(i);
        for (;r.At(); ) {
            const {key: t, value: {ta: i, readTime: o}} = r.It();
            if (!e.path.T(t.path)) break;
            o.L(n) <= 0 || i instanceof Kn && ls(e, i) && (s = s.ot(i.key, i));
        }
        return Ns.resolve(s);
    }
    il(t, e) {
        return Ns.forEach(this.docs, (t => e(t)));
    }
    ra(t) {
        // `trackRemovals` is ignores since the MemoryRemoteDocumentCache keeps
        // a separate changelog and does not need special handling for removals.
        return new Ta(this);
    }
    aa(t) {
        return Ns.resolve(this.size);
    }
}

/**
 * Creates a new memory-only RemoteDocumentCache.
 *
 * @param indexManager A class that manages collection group indices.
 * @param sizer Used to assess the size of a document. For eager GC, this is expected to just
 * return 0 to avoid unnecessarily doing the work of calculating the size.
 */
/**
 * Handles the details of adding and updating documents in the MemoryRemoteDocumentCache.
 */
class Ta extends wi {
    constructor(t) {
        super(), this.ca = t;
    }
    yr(t) {
        const e = [];
        return this.wr.forEach(((n, s) => {
            s ? e.push(this.ca.Er(t, s, this.readTime)) : this.ca.Ar(n);
        })), Ns.$n(e);
    }
    gr(t, e) {
        return this.ca.Rr(t, e);
    }
    Pr(t, e) {
        return this.ca.getEntries(t, e);
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ class Ea {
    constructor(t) {
        this.persistence = t, 
        /**
         * Maps a target to the data about that target
         */
        this.rl = new ft((t => Rt(t)), Pt), 
        /** The last received snapshot version. */
        this.lastRemoteSnapshotVersion = wt.min(), 
        /** The highest numbered target ID encountered. */
        this.highestTargetId = 0, 
        /** The highest sequence number encountered. */
        this.ol = 0, 
        /**
         * A ordered bidirectional mapping between documents and the remote target
         * IDs.
         */
        this.al = new Wr, this.targetCount = 0, this.cl = Ir.fa();
    }
    Ce(t, e) {
        return this.rl.forEach(((t, n) => e(n))), Ns.resolve();
    }
    Ea(t) {
        return Ns.resolve(this.lastRemoteSnapshotVersion);
    }
    Ia(t) {
        return Ns.resolve(this.ol);
    }
    wa(t) {
        return this.highestTargetId = this.cl.next(), Ns.resolve(this.highestTargetId);
    }
    Aa(t, e, n) {
        return n && (this.lastRemoteSnapshotVersion = n), e > this.ol && (this.ol = e), 
        Ns.resolve();
    }
    ga(t) {
        this.rl.set(t.target, t);
        const e = t.targetId;
        e > this.highestTargetId && (this.cl = new Ir(e), this.highestTargetId = e), t.sequenceNumber > this.ol && (this.ol = t.sequenceNumber);
    }
    Ra(t, e) {
        return this.ga(e), this.targetCount += 1, Ns.resolve();
    }
    ya(t, e) {
        return this.ga(e), Ns.resolve();
    }
    Va(t, e) {
        return this.rl.delete(e.target), this.al.Uc(e.targetId), this.targetCount -= 1, 
        Ns.resolve();
    }
    po(t, e, n) {
        let s = 0;
        const i = [];
        return this.rl.forEach(((r, o) => {
            o.sequenceNumber <= e && null === n.get(o.targetId) && (this.rl.delete(r), i.push(this.pa(t, o.targetId)), 
            s++);
        })), Ns.$n(i).next((() => s));
    }
    ba(t) {
        return Ns.resolve(this.targetCount);
    }
    va(t, e) {
        const n = this.rl.get(e) || null;
        return Ns.resolve(n);
    }
    Sa(t, e, n) {
        return this.al.Lc(e, n), Ns.resolve();
    }
    Ca(t, e, n) {
        this.al.qc(e, n);
        const s = this.persistence.No, i = [];
        return s && e.forEach((e => {
            i.push(s.Go(t, e));
        })), Ns.$n(i);
    }
    pa(t, e) {
        return this.al.Uc(e), Ns.resolve();
    }
    Fa(t, e) {
        const n = this.al.Wc(e);
        return Ns.resolve(n);
    }
    Ho(t, e) {
        return Ns.resolve(this.al.Ho(e));
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A memory-backed instance of Persistence. Data is stored only in RAM and
 * not persisted across sessions.
 */
class Ia {
    /**
     * The constructor accepts a factory for creating a reference delegate. This
     * allows both the delegate and this instance to have strong references to
     * each other without having nullable fields that would then need to be
     * checked or asserted on every access.
     */
    constructor(t) {
        this.ul = {}, this.Ma = new ni(0), this.Oa = !1, this.Oa = !0, this.No = t(this), 
        this.Ka = new Ea(this);
        this.Dr = new Xi, this.vr = function(t, e) {
            return new ma(t, e);
        }(this.Dr, (t => this.No.hl(t)));
    }
    start() {
        return Promise.resolve();
    }
    Di() {
        // No durable state to ensure is closed on shutdown.
        return this.Oa = !1, Promise.resolve();
    }
    get Ei() {
        return this.Oa;
    }
    Za() {
        // No op.
    }
    tc() {
        // No op.
    }
    Ic() {
        return this.Dr;
    }
    mc(t) {
        let e = this.ul[t.ti()];
        return e || (e = new wa(this.Dr, this.No), this.ul[t.ti()] = e), e;
    }
    Tc() {
        return this.Ka;
    }
    Ec() {
        return this.vr;
    }
    runTransaction(t, e, n) {
        A("MemoryPersistence", "Starting transaction:", t);
        const s = new Aa(this.Ma.next());
        return this.No.ll(), n(s).next((t => this.No._l(s).next((() => t)))).Fn().then((t => (s.br(), 
        t)));
    }
    fl(t, e) {
        return Ns.kn(Object.values(this.ul).map((n => () => n.Ho(t, e))));
    }
}

/**
 * Memory persistence is not actually transactional, but future implementations
 * may have transaction-scoped state.
 */ class Aa extends Ti {
    constructor(t) {
        super(), this.xa = t;
    }
}

class Ra {
    constructor(t) {
        this.persistence = t, 
        /** Tracks all documents that are active in Query views. */
        this.dl = new Wr, 
        /** The list of documents that are potentially GCed after each transaction. */
        this.wl = null;
    }
    static ml(t) {
        return new Ra(t);
    }
    get Tl() {
        if (this.wl) return this.wl;
        throw y();
    }
    Da(t, e, n) {
        return this.dl.Da(n, e), this.Tl.delete(n.toString()), Ns.resolve();
    }
    Na(t, e, n) {
        return this.dl.Na(n, e), this.Tl.add(n.toString()), Ns.resolve();
    }
    Go(t, e) {
        return this.Tl.add(e.toString()), Ns.resolve();
    }
    removeTarget(t, e) {
        this.dl.Uc(e.targetId).forEach((t => this.Tl.add(t.toString())));
        const n = this.persistence.Tc();
        return n.Fa(t, e.targetId).next((t => {
            t.forEach((t => this.Tl.add(t.toString())));
        })).next((() => n.Va(t, e)));
    }
    ll() {
        this.wl = new Set;
    }
    _l(t) {
        // Remove newly orphaned documents.
        const e = this.persistence.Ec().ra();
        return Ns.forEach(this.Tl, (n => {
            const s = x.D(n);
            return this.El(t, s).next((t => {
                t || e.Ar(s);
            }));
        })).next((() => (this.wl = null, e.apply(t))));
    }
    yc(t, e) {
        return this.El(t, e).next((t => {
            t ? this.Tl.delete(e.toString()) : this.Tl.add(e.toString());
        }));
    }
    hl(t) {
        // For eager GC, we don't care about the document size, there are no size thresholds.
        return 0;
    }
    El(t, e) {
        return Ns.kn([ () => Ns.resolve(this.dl.Ho(e)), () => this.persistence.Tc().Ho(t, e), () => this.persistence.fl(t, e) ]);
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Provides a simple helper class that implements the Stream interface to
 * bridge to other implementations that are streams but do not implement the
 * interface. The stream callbacks are invoked with the callOn... methods.
 */ class ga {
    constructor(t) {
        this.Il = t.Il, this.Al = t.Al;
    }
    gu(t) {
        this.Rl = t;
    }
    Tu(t) {
        this.gl = t;
    }
    onMessage(t) {
        this.Pl = t;
    }
    close() {
        this.Al();
    }
    send(t) {
        this.Il(t);
    }
    yl() {
        this.Rl();
    }
    Vl(t) {
        this.gl(t);
    }
    pl(t) {
        this.Pl(t);
    }
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ const Pa = {
    BatchGetDocuments: "batchGet",
    Commit: "commit",
    RunQuery: "runQuery"
};

/**
 * Maps RPC names to the corresponding REST endpoint name.
 *
 * We use array notation to avoid mangling.
 */ class ya extends 
/**
 * Base class for all Rest-based connections to the backend (WebChannel and
 * HTTP).
 */
class {
    constructor(t) {
        this.bl = t, this.U = t.U;
        const e = t.ssl ? "https" : "http";
        this.vl = e + "://" + t.host, this.Sl = "projects/" + this.U.projectId + "/databases/" + this.U.database + "/documents";
    }
    $u(t, e, n, s) {
        const i = this.Dl(t, e);
        A("RestConnection", "Sending: ", i, n);
        const r = {};
        return this.Cl(r, s), this.Nl(t, i, r, n).then((t => (A("RestConnection", "Received: ", t), 
        t)), (e => {
            throw g("RestConnection", t + " failed with error: ", e, "url: ", i, "request:", n), 
            e;
        }));
    }
    ku(t, e, n, s) {
        // The REST API automatically aggregates all of the streamed results, so we
        // can just use the normal invoke() method.
        return this.$u(t, e, n, s);
    }
    /**
     * Modifies the headers for a request, adding any authorization token if
     * present and any additional headers for the request.
     */    Cl(t, e) {
        if (t["X-Goog-Api-Client"] = "gl-js/ fire/7.24.0", 
        // Content-Type: text/plain will avoid preflight requests which might
        // mess with CORS and redirects by proxies. If we add custom headers
        // we will need to change this code to potentially use the $httpOverwrite
        // parameter supported by ESF to avoid triggering preflight requests.
        t["Content-Type"] = "text/plain", e) for (const n in e.Kc) e.Kc.hasOwnProperty(n) && (t[n] = e.Kc[n]);
    }
    Dl(t, e) {
        const n = Pa[t];
        return `${this.vl}/v1/${e}:${n}`;
    }
}
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ {
    constructor(t) {
        super(t), this.forceLongPolling = t.forceLongPolling, this.W = t.W;
    }
    Nl(t, e, n, s) {
        return new Promise(((i, r) => {
            const o = new h;
            o.listenOnce(l.COMPLETE, (() => {
                try {
                    switch (o.getLastErrorCode()) {
                      case _.NO_ERROR:
                        const e = o.getResponseJson();
                        A("Connection", "XHR received:", JSON.stringify(e)), i(e);
                        break;

                      case _.TIMEOUT:
                        A("Connection", 'RPC "' + t + '" timed out'), r(new T(m.DEADLINE_EXCEEDED, "Request time out"));
                        break;

                      case _.HTTP_ERROR:
                        const n = o.getStatus();
                        if (A("Connection", 'RPC "' + t + '" failed with status:', n, "response text:", o.getResponseText()), 
                        n > 0) {
                            const t = o.getResponseJson().error;
                            if (t && t.status && t.message) {
                                const e = function(t) {
                                    const e = t.toLowerCase().replace("_", "-");
                                    return Object.values(m).indexOf(e) >= 0 ? e : m.UNKNOWN;
                                }(t.status);
                                r(new T(e, t.message));
                            } else r(new T(m.UNKNOWN, "Server responded with status " + o.getStatus()));
                        } else 
                        // If we received an HTTP_ERROR but there's no status code,
                        // it's most probably a connection issue
                        r(new T(m.UNAVAILABLE, "Connection failed."));
                        break;

                      default:
                        y();
                    }
                } finally {
                    A("Connection", 'RPC "' + t + '" completed.');
                }
            }));
            const a = JSON.stringify(s);
            o.send(e, "POST", a, n, 15);
        }));
    }
    Pu(t, e) {
        const n = [ this.vl, "/", "google.firestore.v1.Firestore", "/", t, "/channel" ], s = f(), h = {
            // Required for backend stickiness, routing behavior is based on this
            // parameter.
            httpSessionIdParam: "gsessionid",
            initMessageHeaders: {},
            messageUrlParams: {
                // This param is used to improve routing and project isolation by the
                // backend and must be included in every request.
                database: `projects/${this.U.projectId}/databases/${this.U.database}`
            },
            sendRawJson: !0,
            supportsCrossDomainXhr: !0,
            internalChannelParams: {
                // Override the default timeout (randomized between 10-20 seconds) since
                // a large write batch on a slow internet connection may take a long
                // time to send to the backend. Rather than have WebChannel impose a
                // tight timeout which could lead to infinite timeouts and retries, we
                // set it very large (5-10 minutes) and rely on the browser's builtin
                // timeouts to kick in if the request isn't working.
                forwardChannelRequestTimeoutMs: 6e5
            },
            forceLongPolling: this.forceLongPolling,
            detectBufferingProxy: this.W
        };
        this.Cl(h.initMessageHeaders, e), 
        // Sending the custom headers we just added to request.initMessageHeaders
        // (Authorization, etc.) will trigger the browser to make a CORS preflight
        // request because the XHR will no longer meet the criteria for a "simple"
        // CORS request:
        // https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS#Simple_requests
        // Therefore to avoid the CORS preflight request (an extra network
        // roundtrip), we use the httpHeadersOverwriteParam option to specify that
        // the headers should instead be encoded into a special "$httpHeaders" query
        // parameter, which is recognized by the webchannel backend. This is
        // formally defined here:
        // https://github.com/google/closure-library/blob/b0e1815b13fb92a46d7c9b3c30de5d6a396a3245/closure/goog/net/rpc/httpcors.js#L32
        // TODO(b/145624756): There is a backend bug where $httpHeaders isn't respected if the request
        // doesn't have an Origin header. So we have to exclude a few browser environments that are
        // known to (sometimes) not include an Origin. See
        // https://github.com/firebase/firebase-js-sdk/issues/1491.
        i() || r() || o() || a() || c() || u() || (h.httpHeadersOverwriteParam = "$httpHeaders");
        const l = n.join("");
        A("Connection", "Creating WebChannel: " + l, h);
        const _ = s.createWebChannel(l, h);
        // WebChannel supports sending the first message with the handshake - saving
        // a network round trip. However, it will have to call send in the same
        // JS event loop as open. In order to enforce this, we delay actually
        // opening the WebChannel until send is called. Whether we have called
        // open is tracked with this variable.
                let w = !1, E = !1;
        // A flag to determine whether the stream was closed (by us or through an
        // error/close event) to avoid delivering multiple close events or sending
        // on a closed stream
                const I = new ga({
            Il: t => {
                E ? A("Connection", "Not sending because WebChannel is closed:", t) : (w || (A("Connection", "Opening WebChannel transport."), 
                _.open(), w = !0), A("Connection", "WebChannel sending:", t), _.send(t));
            },
            Al: () => _.close()
        }), R = (t, e) => {
            // TODO(dimond): closure typing seems broken because WebChannel does
            // not implement goog.events.Listenable
            _.listen(t, (t => {
                try {
                    e(t);
                } catch (t) {
                    setTimeout((() => {
                        throw t;
                    }), 0);
                }
            }));
        };
        // Closure events are guarded and exceptions are swallowed, so catch any
        // exception and rethrow using a setTimeout so they become visible again.
        // Note that eventually this function could go away if we are confident
        // enough the code is exception free.
                return R(d.EventType.OPEN, (() => {
            E || A("Connection", "WebChannel transport opened.");
        })), R(d.EventType.CLOSE, (() => {
            E || (E = !0, A("Connection", "WebChannel transport closed"), I.Vl());
        })), R(d.EventType.ERROR, (t => {
            E || (E = !0, g("Connection", "WebChannel transport errored:", t), I.Vl(new T(m.UNAVAILABLE, "The operation could not be completed")));
        })), R(d.EventType.MESSAGE, (t => {
            var e;
            if (!E) {
                const n = t.data[0];
                V(!!n);
                // TODO(b/35143891): There is a bug in One Platform that caused errors
                // (and only errors) to be wrapped in an extra array. To be forward
                // compatible with the bug we need to check either condition. The latter
                // can be removed once the fix has been rolled out.
                // Use any because msgData.error is not typed.
                const s = n, i = s.error || (null === (e = s[0]) || void 0 === e ? void 0 : e.error);
                if (i) {
                    A("Connection", "WebChannel received error:", i);
                    // error.status will be a string like 'OK' or 'NOT_FOUND'.
                    const t = i.status;
                    let e = function(t) {
                        // lookup by string
                        // eslint-disable-next-line @typescript-eslint/no-explicit-any
                        const e = bt[t];
                        if (void 0 !== e) return Dt(e);
                    }(t), n = i.message;
                    void 0 === e && (e = m.INTERNAL, n = "Unknown error status: " + t + " with message " + i.message), 
                    // Mark closed so no further events are propagated
                    E = !0, I.Vl(new T(e, n)), _.close();
                } else A("Connection", "WebChannel received:", n), I.pl(n);
            }
        })), setTimeout((() => {
            // Technically we could/should wait for the WebChannel opened event,
            // but because we want to send the first message with the WebChannel
            // handshake we pretend the channel opened here (asynchronously), and
            // then delay the actual open until the first message is sent.
            I.yl();
        }), 0), I;
    }
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// References to `window` are guarded by BrowserConnectivityMonitor.isAvailable()
/* eslint-disable no-restricted-globals */
/**
 * Browser implementation of ConnectivityMonitor.
 */
class Va {
    constructor() {
        this.Fl = () => this.xl(), this.$l = () => this.kl(), this.Ml = [], this.Ol();
    }
    Zu(t) {
        this.Ml.push(t);
    }
    Di() {
        window.removeEventListener("online", this.Fl), window.removeEventListener("offline", this.$l);
    }
    Ol() {
        window.addEventListener("online", this.Fl), window.addEventListener("offline", this.$l);
    }
    xl() {
        A("ConnectivityMonitor", "Network connectivity changed: AVAILABLE");
        for (const t of this.Ml) t(0 /* AVAILABLE */);
    }
    kl() {
        A("ConnectivityMonitor", "Network connectivity changed: UNAVAILABLE");
        for (const t of this.Ml) t(1 /* UNAVAILABLE */);
    }
    // TODO(chenbrian): Consider passing in window either into this component or
    // here for testing via FakeWindow.
    /** Checks that all used attributes of window are available. */
    static Ln() {
        return "undefined" != typeof window && void 0 !== window.addEventListener && void 0 !== window.removeEventListener;
    }
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ class pa {
    Zu(t) {
        // No-op.
    }
    Di() {
        // No-op.
    }
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** Initializes the WebChannelConnection for the browser. */
/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
function ba(t) {
    return new pe(t, /* useProto3Json= */ !0);
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ const va = "You are using the memory-only build of Firestore. Persistence support is only available via the @firebase/firestore bundle or the firebase-firestore.js build.";

/**
 * Provides all components needed for Firestore with in-memory persistence.
 * Uses EagerGC garbage collection.
 */ class Sa {
    async initialize(t) {
        this.Sh = this.Ll(t), this.persistence = this.Bl(t), await this.persistence.start(), 
        this.ql = this.Ul(t), this.ju = this.Ql(t);
    }
    Ul(t) {
        return null;
    }
    Ql(t) {
        /** Manages our in-memory or durable persistence. */
        return e = this.persistence, n = new da, s = t.Wl, new Nr(e, n, s);
        var e, n, s;
    }
    Bl(t) {
        if (t.persistenceSettings.jl) throw new T(m.FAILED_PRECONDITION, va);
        return new Ia(Ra.ml);
    }
    Ll(t) {
        return new _i;
    }
    async terminate() {
        this.ql && this.ql.stop(), await this.Sh.Di(), await this.persistence.Di();
    }
    clearPersistence(t, e) {
        throw new T(m.FAILED_PRECONDITION, va);
    }
}

/**
 * Provides all components needed for Firestore with IndexedDB persistence.
 */ class Da extends Sa {
    constructor(t) {
        super(), this.Kl = t;
    }
    async initialize(t) {
        await super.initialize(t), await Ur(this.ju), await this.Kl.initialize(this, t), 
        // Enqueue writes from a previous session
        await fa(this.Kl.fi), await Ao(this.Kl.ph);
    }
    Ul(t) {
        const e = this.persistence.No.wo;
        return new yi(e, t.cs);
    }
    Bl(t) {
        const e = Cr(t.bl.U, t.bl.persistenceKey), n = ba(t.bl.U);
        return new pr(t.persistenceSettings.synchronizeTabs, e, t.clientId, Pi.ao(t.persistenceSettings.cacheSizeBytes), t.cs, Us(), Qs(), n, this.Sh, t.persistenceSettings.ka);
    }
    Ll(t) {
        return new _i;
    }
    clearPersistence(t, e) {
        return async function(t) {
            if (!Fs.Ln()) return Promise.resolve();
            const e = t + "main";
            await Fs.delete(e);
        }
        /**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ (Cr(t, e));
    }
}

/**
 * Provides all components needed for Firestore with multi-tab IndexedDB
 * persistence.
 *
 * In the legacy client, this provider is used to provide both multi-tab and
 * non-multi-tab persistence since we cannot tell at build time whether
 * `synchronizeTabs` will be enabled.
 */ class Ca extends Da {
    async initialize(t) {
        await super.initialize(t);
        const e = this.Kl.fi;
        this.Sh instanceof li && (this.Sh.fi = {
            er: ra.bind(null, e),
            nr: ha.bind(null, e),
            sr: la.bind(null, e),
            pi: ua.bind(null, e)
        }, await this.Sh.start()), 
        // NOTE: This will immediately call the listener, so we make sure to
        // set it after localStore / remoteStore are started.
        await this.persistence.Xa((async t => {
            await oa(this.Kl.fi, t), this.ql && (t && !this.ql.Ei ? this.ql.start(this.ju) : t || this.ql.stop());
        }));
    }
    Ll(t) {
        if (t.persistenceSettings.jl && t.persistenceSettings.synchronizeTabs) {
            const e = Us();
            if (!li.Ln(e)) throw new T(m.UNIMPLEMENTED, "IndexedDB persistence is only available on platforms that support LocalStorage.");
            const n = Cr(t.bl.U, t.bl.persistenceKey);
            return new li(e, t.cs, n, t.clientId, t.Wl);
        }
        return new _i;
    }
}

/**
 * Initializes and wires the components that are needed to interface with the
 * network.
 */ class Na {
    async initialize(t, e) {
        this.ju || (this.ju = t.ju, this.Sh = t.Sh, this.Ku = this.Gl(e), this.ph = this.zl(e), 
        this.bh = this.Hl(e), this.fi = this.Yl(e), this.Sh.di = t => Qo(this.fi, t, 1 /* SharedClientState */), 
        this.ph.Gu.Jl = na.bind(null, this.fi), await So(this.ph, this.fi.Uh));
    }
    Hl(t) {
        return new zs;
    }
    Gl(t) {
        const e = ba(t.bl.U), n = (s = t.bl, new ya(s));
        var s;
        /** Return the Platform-specific connectivity monitor. */        return function(t, e, n) {
            return new to(t, e, n);
        }(t.credentials, n, e);
    }
    zl(t) {
        return e = this.ju, n = this.Ku, s = t.cs, i = t => Qo(this.fi, t, 0 /* RemoteStore */), 
        r = Va.Ln() ? new Va : new pa, new no(e, n, s, i, r);
        var e, n, s, i, r;
        /** Re-enables the network. Idempotent. */    }
    Yl(t) {
        return function(t, e, n, 
        // PORTING NOTE: Manages state synchronization in multi-tab environments.
        s, i, r, o) {
            const a = new Mo(t, e, n, s, i, r);
            return o && (a.qh = !0), a;
        }(this.ju, this.ph, this.bh, this.Sh, t.Wl, t.Dh, !t.persistenceSettings.jl || !t.persistenceSettings.synchronizeTabs);
    }
    terminate() {
        return ro(this.ph);
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * A wrapper implementation of Observer<T> that will dispatch events
 * asynchronously. To allow immediate silencing, a mute call is added which
 * causes events scheduled to no longer be raised.
 */ class Fa {
    constructor(t) {
        this.observer = t, 
        /**
         * When set to true, will not raise future events. Necessary to deal with
         * async detachment of listener.
         */
        this.muted = !1;
    }
    next(t) {
        this.observer.next && this.Xl(this.observer.next, t);
    }
    error(t) {
        this.observer.error ? this.Xl(this.observer.error, t) : console.error("Uncaught Error in snapshot listener:", t);
    }
    Zl() {
        this.muted = !0;
    }
    Xl(t, e) {
        this.muted || setTimeout((() => {
            this.muted || t(e);
        }), 0);
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// The objects that are a part of this API are exposed to third-parties as
// compiled javascript so we want to flag our private members with a leading
// underscore to discourage their use.
/**
 * A field class base class that is shared by the lite, full and legacy SDK,
 * which supports shared code that deals with FieldPaths.
 */
// Use underscore prefix to hide this class from our Public API.
// eslint-disable-next-line @typescript-eslint/naming-convention
class xa {
    constructor(t) {
        !function(t, e, n, s) {
            if (!(e instanceof Array) || e.length < s) throw new T(m.INVALID_ARGUMENT, `Function ${t}() requires its ${n} argument to be an array with at least ` + tt(s, "element") + ".");
        }("FieldPath", t, "fieldNames", 1);
        for (let e = 0; e < t.length; ++e) if (L("FieldPath", "string", e, t[e]), 0 === t[e].length) throw new T(m.INVALID_ARGUMENT, "Invalid field name at argument $(i + 1). Field names must not be empty.");
        this.t_ = new F(t);
    }
}

/**
 * A `FieldPath` refers to a field in a document. The path may consist of a
 * single field name (referring to a top-level field in the document), or a list
 * of field names (referring to a nested field in the document).
 */ class $a extends xa {
    /**
     * Creates a FieldPath from the provided field names. If more than one field
     * name is provided, the path will point to a nested field in a document.
     *
     * @param fieldNames A list of field names.
     */
    constructor(...t) {
        super(t);
    }
    static documentId() {
        /**
         * Internal Note: The backend doesn't technically support querying by
         * document ID. Instead it queries by the entire document name (full path
         * included), but in the cases we currently support documentId(), the net
         * effect is the same.
         */
        return new $a(F.v().R());
    }
    isEqual(t) {
        if (!(t instanceof $a)) throw J("isEqual", "FieldPath", 1, t);
        return this.t_.isEqual(t.t_);
    }
}

/**
 * Matches any characters in a field path string that are reserved.
 */ const ka = new RegExp("[~\\*/\\[\\]]");

/**
 * Parses a field path string into a FieldPath, treating dots as separators.
 */
/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Sentinel values that can be used when writing document fields with `set()`
 * or `update()`.
 */
class Ma {
    /**
     * @param _methodName The public API endpoint that returns this class.
     */
    constructor(t) {
        this.e_ = t;
    }
}

/**
 * Returns a sentinel for use with {@link updateDoc()} or
 * {@link setDoc `setDoc({}, { merge: true })`} to mark a field for deletion.
 */
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
class Oa extends Ma {
    n_(t) {
        if (2 /* MergeSet */ !== t.s_) throw 1 /* Update */ === t.s_ ? t.i_(this.e_ + "() can only appear at the top level of your update data") : t.i_(this.e_ + "() cannot be used with set() unless you pass {merge:true}");
        // No transform to add for a delete, but we need to add it to our
        // fieldMask so it gets deleted.
        return t.We.push(t.path), null;
    }
    isEqual(t) {
        return t instanceof Oa;
    }
}

/**
 * Creates a child context for parsing SerializableFieldValues.
 *
 * This is different than calling `ParseContext.contextWith` because it keeps
 * the fieldTransforms and fieldMask separate.
 *
 * The created context has its `dataSource` set to `UserDataSource.Argument`.
 * Although these values are used with writes, any elements in these FieldValues
 * are not considered writes since they cannot contain any FieldValue sentinels,
 * etc.
 *
 * @param fieldValue The sentinel FieldValue for which to create a child
 *     context.
 * @param context The parent context.
 * @param arrayElement Whether or not the FieldValue has an array.
 */ function La(t, e, n) {
    return new Ja({
        s_: 3 /* Argument */ ,
        r_: e.settings.r_,
        methodName: t.e_,
        o_: n
    }, e.U, e.serializer, e.ignoreUndefinedProperties);
}

class Ba extends Ma {
    n_(t) {
        return new Pn(t.path, new dn);
    }
    isEqual(t) {
        return t instanceof Ba;
    }
}

class qa extends Ma {
    constructor(t, e) {
        super(t), this.a_ = e;
    }
    n_(t) {
        const e = La(this, t, 
        /*array=*/ !0), n = this.a_.map((t => sc(t, e))), s = new wn(n);
        return new Pn(t.path, s);
    }
    isEqual(t) {
        // TODO(mrschmidt): Implement isEquals
        return this === t;
    }
}

class Ua extends Ma {
    constructor(t, e) {
        super(t), this.a_ = e;
    }
    n_(t) {
        const e = La(this, t, 
        /*array=*/ !0), n = this.a_.map((t => sc(t, e))), s = new Tn(n);
        return new Pn(t.path, s);
    }
    isEqual(t) {
        // TODO(mrschmidt): Implement isEquals
        return this === t;
    }
}

class Qa extends Ma {
    constructor(t, e) {
        super(t), this.c_ = e;
    }
    n_(t) {
        const e = new In(t.serializer, Se(t.serializer, this.c_));
        return new Pn(t.path, e);
    }
    isEqual(t) {
        // TODO(mrschmidt): Implement isEquals
        return this === t;
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * An immutable object representing a geographic location in Firestore. The
 * location is represented as latitude/longitude pair.
 *
 * Latitude values are in the range of [-90, 90].
 * Longitude values are in the range of [-180, 180].
 */ class Wa {
    /**
     * Creates a new immutable `GeoPoint` object with the provided latitude and
     * longitude values.
     * @param latitude The latitude as number between -90 and 90.
     * @param longitude The longitude as number between -180 and 180.
     */
    constructor(t, e) {
        if (k("GeoPoint", arguments, 2), L("GeoPoint", "number", 1, t), L("GeoPoint", "number", 2, e), 
        !isFinite(t) || t < -90 || t > 90) throw new T(m.INVALID_ARGUMENT, "Latitude must be a number between -90 and 90, but was: " + t);
        if (!isFinite(e) || e < -180 || e > 180) throw new T(m.INVALID_ARGUMENT, "Longitude must be a number between -180 and 180, but was: " + e);
        this.u_ = t, this.h_ = e;
    }
    /**
     * The latitude of this `GeoPoint` instance.
     */    get latitude() {
        return this.u_;
    }
    /**
     * The longitude of this `GeoPoint` instance.
     */    get longitude() {
        return this.h_;
    }
    /**
     * Returns true if this `GeoPoint` is equal to the provided one.
     *
     * @param other The `GeoPoint` to compare against.
     * @return true if this `GeoPoint` is equal to the provided one.
     */    isEqual(t) {
        return this.u_ === t.u_ && this.h_ === t.h_;
    }
    toJSON() {
        return {
            latitude: this.u_,
            longitude: this.h_
        };
    }
    /**
     * Actually private to JS consumers of our API, so this function is prefixed
     * with an underscore.
     */    Y(t) {
        return st(this.u_, t.u_) || st(this.h_, t.h_);
    }
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A class implemented by all API types of the legacy Firestore API which
 * contains a reference to the API type in the firestore-exp API. All internal
 * code unwraps these references, which allows us to only use firestore-exp
 * types in the SDK.
 */ class ja {
    constructor(t) {
        this.l_ = t;
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ const Ka = /^__.*__$/;

/**
 * A reference to a document in a Firebase project.
 *
 * This class serves as a common base class for the public DocumentReferences
 * exposed in the lite, full and legacy SDK.
 */
// Use underscore prefix to hide this class from our Public API.
// eslint-disable-next-line @typescript-eslint/naming-convention
class Ga {
    constructor(t, e, n) {
        this.__ = t, this.f_ = e, this.d_ = n;
    }
}

/** The result of parsing document data (e.g. for a setData call). */ class za {
    constructor(t, e, n) {
        this.data = t, this.We = e, this.fieldTransforms = n;
    }
    w_(t, e) {
        const n = [];
        return null !== this.We ? n.push(new $n(t, this.data, this.We, e)) : n.push(new xn(t, this.data, e)), 
        this.fieldTransforms.length > 0 && n.push(new Mn(t, this.fieldTransforms)), n;
    }
}

/** The result of parsing "update" data (i.e. for an updateData call). */ class Ha {
    constructor(t, e, n) {
        this.data = t, this.We = e, this.fieldTransforms = n;
    }
    w_(t, e) {
        const n = [ new $n(t, this.data, this.We, e) ];
        return this.fieldTransforms.length > 0 && n.push(new Mn(t, this.fieldTransforms)), 
        n;
    }
}

function Ya(t) {
    switch (t) {
      case 0 /* Set */ :
 // fall through
              case 2 /* MergeSet */ :
 // fall through
              case 1 /* Update */ :
        return !0;

      case 3 /* Argument */ :
      case 4 /* ArrayArgument */ :
        return !1;

      default:
        throw y();
    }
}

/** A "context" object passed around while parsing user data. */ class Ja {
    /**
     * Initializes a ParseContext with the given source and path.
     *
     * @param settings The settings for the parser.
     * @param databaseId The database ID of the Firestore instance.
     * @param serializer The serializer to use to generate the Value proto.
     * @param ignoreUndefinedProperties Whether to ignore undefined properties
     * rather than throw.
     * @param fieldTransforms A mutable list of field transforms encountered while
     *     parsing the data.
     * @param fieldMask A mutable list of field paths encountered while parsing
     *     the data.
     *
     * TODO(b/34871131): We don't support array paths right now, so path can be
     * null to indicate the context represents any location within an array (in
     * which case certain features will not work and errors will be somewhat
     * compromised).
     */
    constructor(t, e, n, s, i, r) {
        this.settings = t, this.U = e, this.serializer = n, this.ignoreUndefinedProperties = s, 
        // Minor hack: If fieldTransforms is undefined, we assume this is an
        // external call and we need to validate the entire path.
        void 0 === i && this.m_(), this.fieldTransforms = i || [], this.We = r || [];
    }
    get path() {
        return this.settings.path;
    }
    get s_() {
        return this.settings.s_;
    }
    /** Returns a new context with the specified settings overwritten. */    T_(t) {
        return new Ja(Object.assign(Object.assign({}, this.settings), t), this.U, this.serializer, this.ignoreUndefinedProperties, this.fieldTransforms, this.We);
    }
    E_(t) {
        var e;
        const n = null === (e = this.path) || void 0 === e ? void 0 : e.child(t), s = this.T_({
            path: n,
            o_: !1
        });
        return s.I_(t), s;
    }
    A_(t) {
        var e;
        const n = null === (e = this.path) || void 0 === e ? void 0 : e.child(t), s = this.T_({
            path: n,
            o_: !1
        });
        return s.m_(), s;
    }
    R_(t) {
        // TODO(b/34871131): We don't support array paths right now; so make path
        // undefined.
        return this.T_({
            path: void 0,
            o_: !0
        });
    }
    i_(t) {
        return uc(t, this.settings.methodName, this.settings.g_ || !1, this.path, this.settings.r_);
    }
    /** Returns 'true' if 'fieldPath' was traversed when creating this context. */    contains(t) {
        return void 0 !== this.We.find((e => t.T(e))) || void 0 !== this.fieldTransforms.find((e => t.T(e.field)));
    }
    m_() {
        // TODO(b/34871131): Remove null check once we have proper paths for fields
        // within arrays.
        if (this.path) for (let t = 0; t < this.path.length; t++) this.I_(this.path.get(t));
    }
    I_(t) {
        if (0 === t.length) throw this.i_("Document fields must not be empty");
        if (Ya(this.s_) && Ka.test(t)) throw this.i_('Document fields cannot begin and end with "__"');
    }
}

/**
 * Helper for parsing raw user input (provided via the API) into internal model
 * classes.
 */ class Xa {
    constructor(t, e, n) {
        this.U = t, this.ignoreUndefinedProperties = e, this.serializer = n || ba(t);
    }
    /** Creates a new top-level parse context. */    P_(t, e, n, s = !1) {
        return new Ja({
            s_: t,
            methodName: e,
            r_: n,
            path: F.P(),
            o_: !1,
            g_: s
        }, this.U, this.serializer, this.ignoreUndefinedProperties);
    }
}

/** Parse document data from a set() call. */ function Za(t, e, n, s, i, r = {}) {
    const o = t.P_(r.merge || r.mergeFields ? 2 /* MergeSet */ : 0 /* Set */ , e, n, i);
    oc("Data must be an object, but it was:", o, s);
    const a = ic(s, o);
    let c, u;
    if (r.merge) c = new gn(o.We), u = o.fieldTransforms; else if (r.mergeFields) {
        const t = [];
        for (const s of r.mergeFields) {
            let i;
            if (s instanceof xa) i = s.t_; else {
                if ("string" != typeof s) throw y();
                i = cc(e, s, n);
            }
            if (!o.contains(i)) throw new T(m.INVALID_ARGUMENT, `Field '${i}' is specified in your field mask but missing from your input data.`);
            hc(t, i) || t.push(i);
        }
        c = new gn(t), u = o.fieldTransforms.filter((t => c.Ye(t.field)));
    } else c = null, u = o.fieldTransforms;
    return new za(new Un(a), c, u);
}

/** Parse update data from an update() call. */ function tc(t, e, n, s) {
    const i = t.P_(1 /* Update */ , e, n);
    oc("Data must be an object, but it was:", i, s);
    const r = [], o = new Qn;
    v(s, ((t, s) => {
        const a = cc(e, t, n), c = i.A_(a);
        if (s instanceof Oa || s instanceof ja && s.l_ instanceof Oa) 
        // Add it to the field mask, but don't add anything to updateData.
        r.push(a); else {
            const t = sc(s, c);
            null != t && (r.push(a), o.set(a, t));
        }
    }));
    const a = new gn(r);
    return new Ha(o.Xe(), a, i.fieldTransforms);
}

/** Parse update data from a list of field/value arguments. */ function ec(t, e, n, s, i, r) {
    const o = t.P_(1 /* Update */ , e, n), a = [ ac(e, s, n) ], c = [ i ];
    if (r.length % 2 != 0) throw new T(m.INVALID_ARGUMENT, `Function ${e}() needs to be called with an even number of arguments that alternate between field names and values.`);
    for (let t = 0; t < r.length; t += 2) a.push(ac(e, r[t])), c.push(r[t + 1]);
    const u = [], h = new Qn;
    // We iterate in reverse order to pick the last value for a field if the
    // user specified the field multiple times.
    for (let t = a.length - 1; t >= 0; --t) if (!hc(u, a[t])) {
        const e = a[t], n = c[t], s = o.A_(e);
        if (n instanceof Oa || n instanceof ja && n.l_ instanceof Oa) 
        // Add it to the field mask, but don't add anything to updateData.
        u.push(e); else {
            const t = sc(n, s);
            null != t && (u.push(e), h.set(e, t));
        }
    }
    const l = new gn(u);
    return new Ha(h.Xe(), l, o.fieldTransforms);
}

/**
 * Parse a "query value" (e.g. value in a where filter or a value in a cursor
 * bound).
 *
 * @param allowArrays Whether the query value is an array that may directly
 * contain additional arrays (e.g. the operand of an `in` query).
 */ function nc(t, e, n, s = !1) {
    return sc(n, t.P_(s ? 4 /* ArrayArgument */ : 3 /* Argument */ , e));
}

/**
 * Parses user data to Protobuf Values.
 *
 * @param input Data to be parsed.
 * @param context A context object representing the current path being parsed,
 * the source of the data being parsed, etc.
 * @return The parsed value, or null if the value was a FieldValue sentinel
 * that should not be included in the resulting parsed data.
 */ function sc(t, e) {
    if (
    // Unwrap the API type from the Compat SDK. This will return the API type
    // from firestore-exp.
    t instanceof ja && (t = t.l_), rc(t)) return oc("Unsupported field value:", e, t), 
    ic(t, e);
    if (t instanceof Ma) 
    // FieldValues usually parse into transforms (except FieldValue.delete())
    // in which case we do not want to include this field in our parsed data
    // (as doing so will overwrite the field directly prior to the transform
    // trying to transform it). So we don't add this location to
    // context.fieldMask and we return null as our parsing result.
    /**
 * "Parses" the provided FieldValueImpl, adding any necessary transforms to
 * context.fieldTransforms.
 */
    return function(t, e) {
        // Sentinels are only supported with writes, and not within arrays.
        if (!Ya(e.s_)) throw e.i_(t.e_ + "() can only be used with update() and set()");
        if (!e.path) throw e.i_(t.e_ + "() is not currently supported inside arrays");
        const n = t.n_(e);
        n && e.fieldTransforms.push(n);
    }
    /**
 * Helper to parse a scalar value (i.e. not an Object, Array, or FieldValue)
 *
 * @return The parsed value
 */ (t, e), null;
    if (
    // If context.path is null we are inside an array and we don't support
    // field mask paths more granular than the top-level array.
    e.path && e.We.push(e.path), t instanceof Array) {
        // TODO(b/34871131): Include the path containing the array in the error
        // message.
        // In the case of IN queries, the parsed data is an array (representing
        // the set of values to be included for the IN query) that may directly
        // contain additional arrays (each representing an individual field
        // value), so we disable this validation.
        if (e.settings.o_ && 4 /* ArrayArgument */ !== e.s_) throw e.i_("Nested arrays are not supported");
        return function(t, e) {
            const n = [];
            let s = 0;
            for (const i of t) {
                let t = sc(i, e.R_(s));
                null == t && (
                // Just include nulls in the array for fields being replaced with a
                // sentinel.
                t = {
                    nullValue: "NULL_VALUE"
                }), n.push(t), s++;
            }
            return {
                arrayValue: {
                    values: n
                }
            };
        }(t, e);
    }
    return function(t, e) {
        if (null === t) return {
            nullValue: "NULL_VALUE"
        };
        if ("number" == typeof t) return Se(e.serializer, t);
        if ("boolean" == typeof t) return {
            booleanValue: t
        };
        if ("string" == typeof t) return {
            stringValue: t
        };
        if (t instanceof Date) {
            const n = dt.fromDate(t);
            return {
                timestampValue: De(e.serializer, n)
            };
        }
        if (t instanceof dt) {
            // Firestore backend truncates precision down to microseconds. To ensure
            // offline mode works the same with regards to truncation, perform the
            // truncation immediately without waiting for the backend to do that.
            const n = new dt(t.seconds, 1e3 * Math.floor(t.nanoseconds / 1e3));
            return {
                timestampValue: De(e.serializer, n)
            };
        }
        if (t instanceof Wa) return {
            geoPointValue: {
                latitude: t.latitude,
                longitude: t.longitude
            }
        };
        if (t instanceof at) return {
            bytesValue: Ce(e.serializer, t.q)
        };
        if (t instanceof Ga) {
            const n = e.U, s = t.__;
            if (!s.isEqual(n)) throw e.i_(`Document reference is for database ${s.projectId}/${s.database} but should be for database ${n.projectId}/${n.database}`);
            return {
                referenceValue: xe(t.__ || e.U, t.f_.path)
            };
        }
        if (void 0 === t && e.ignoreUndefinedProperties) return null;
        throw e.i_("Unsupported field value: " + z(t));
    }
    /**
 * Checks whether an object looks like a JSON object that should be converted
 * into a struct. Normal class/prototype instances are considered to look like
 * JSON objects since they should be converted to a struct value. Arrays, Dates,
 * GeoPoints, etc. are not considered to look like JSON objects since they map
 * to specific FieldValue types other than ObjectValue.
 */ (t, e);
}

function ic(t, e) {
    const n = {};
    return S(t) ? 
    // If we encounter an empty object, we explicitly add it to the update
    // mask to ensure that the server creates a map entry.
    e.path && e.path.length > 0 && e.We.push(e.path) : v(t, ((t, s) => {
        const i = sc(s, e.E_(t));
        null != i && (n[t] = i);
    })), {
        mapValue: {
            fields: n
        }
    };
}

function rc(t) {
    return !("object" != typeof t || null === t || t instanceof Array || t instanceof Date || t instanceof dt || t instanceof Wa || t instanceof at || t instanceof Ga || t instanceof Ma);
}

function oc(t, e, n) {
    if (!rc(n) || !G(n)) {
        const s = z(n);
        throw "an object" === s ? e.i_(t + " a custom object") : e.i_(t + " " + s);
    }
}

/**
 * Helper that calls fromDotSeparatedString() but wraps any error thrown.
 */ function ac(t, e, n) {
    if (e instanceof xa) return e.t_;
    if ("string" == typeof e) return cc(t, e);
    throw uc("Field path arguments must be of type string or FieldPath.", t, 
    /* hasConverter= */ !1, 
    /* path= */ void 0, n);
}

/**
 * Wraps fromDotSeparatedString with an error message about the method that
 * was thrown.
 * @param methodName The publicly visible method name
 * @param path The dot-separated string form of a field path which will be split
 * on dots.
 * @param targetDoc The document against which the field path will be evaluated.
 */ function cc(t, e, n) {
    try {
        return function(t) {
            if (t.search(ka) >= 0) throw new T(m.INVALID_ARGUMENT, `Invalid field path (${t}). Paths must not contain '~', '*', '/', '[', or ']'`);
            try {
                return new $a(...t.split("."));
            } catch (e) {
                throw new T(m.INVALID_ARGUMENT, `Invalid field path (${t}). Paths must not be empty, begin with '.', end with '.', or contain '..'`);
            }
        }(e).t_;
    } catch (e) {
        throw uc((s = e) instanceof Error ? s.message : s.toString(), t, 
        /* hasConverter= */ !1, 
        /* path= */ void 0, n);
    }
    /**
 * Extracts the message from a caught exception, which should be an Error object
 * though JS doesn't guarantee that.
 */
    var s;
    /** Checks `haystack` if FieldPath `needle` is present. Runs in O(n). */}

function uc(t, e, n, s, i) {
    const r = s && !s.m(), o = void 0 !== i;
    let a = `Function ${e}() called with invalid data`;
    n && (a += " (via `toFirestore()`)"), a += ". ";
    let c = "";
    return (r || o) && (c += " (found", r && (c += " in field " + s), o && (c += " in document " + i), 
    c += ")"), new T(m.INVALID_ARGUMENT, a + t + c);
}

function hc(t, e) {
    return t.some((t => t.isEqual(e)));
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Internal transaction object responsible for accumulating the mutations to
 * perform and the base versions for any documents read.
 */ class lc {
    constructor(t) {
        this.Ku = t, 
        // The version of each document that was read during this transaction.
        this.y_ = new Map, this.mutations = [], this.V_ = !1, 
        /**
         * A deferred usage error that occurred previously in this transaction that
         * will cause the transaction to fail once it actually commits.
         */
        this.p_ = null, 
        /**
         * Set of documents that have been written in the transaction.
         *
         * When there's more than one write to the same key in a transaction, any
         * writes after the first are handled differently.
         */
        this.b_ = new Set;
    }
    async v_(t) {
        if (this.S_(), this.mutations.length > 0) throw new T(m.INVALID_ARGUMENT, "Firestore transactions require all reads to be executed before all writes.");
        const e = await async function(t, e) {
            const n = p(t), s = Be(n.serializer) + "/documents", i = {
                documents: e.map((t => ke(n.serializer, t)))
            }, r = await n.ku("BatchGetDocuments", s, i), o = new Map;
            r.forEach((t => {
                const e = Qe(n.serializer, t);
                o.set(e.key.toString(), e);
            }));
            const a = [];
            return e.forEach((t => {
                const e = o.get(t.toString());
                V(!!e), a.push(e);
            })), a;
        }(this.Ku, t);
        return e.forEach((t => {
            t instanceof Gn || t instanceof Kn ? this.D_(t) : y();
        })), e;
    }
    set(t, e) {
        this.write(e.w_(t, this.Ge(t))), this.b_.add(t.toString());
    }
    update(t, e) {
        try {
            this.write(e.w_(t, this.C_(t)));
        } catch (t) {
            this.p_ = t;
        }
        this.b_.add(t.toString());
    }
    delete(t) {
        this.write([ new Bn(t, this.Ge(t)) ]), this.b_.add(t.toString());
    }
    async commit() {
        if (this.S_(), this.p_) throw this.p_;
        const t = this.y_;
        // For each mutation, note that the doc was written.
                this.mutations.forEach((e => {
            t.delete(e.key.toString());
        })), 
        // For each document that was read but not written to, we want to perform
        // a `verify` operation.
        t.forEach(((t, e) => {
            const n = x.D(e);
            this.mutations.push(new qn(n, this.Ge(n)));
        })), await async function(t, e) {
            const n = p(t), s = Be(n.serializer) + "/documents", i = {
                writes: e.map((t => je(n.serializer, t)))
            };
            await n.$u("Commit", s, i);
        }(this.Ku, this.mutations), this.V_ = !0;
    }
    D_(t) {
        let e;
        if (t instanceof Kn) e = t.version; else {
            if (!(t instanceof Gn)) throw y();
            // For deleted docs, we must use baseVersion 0 when we overwrite them.
            e = wt.min();
        }
        const n = this.y_.get(t.key.toString());
        if (n) {
            if (!e.isEqual(n)) 
            // This transaction will fail no matter what.
            throw new T(m.ABORTED, "Document version changed between two reads.");
        } else this.y_.set(t.key.toString(), e);
    }
    /**
     * Returns the version of this document when it was read in this transaction,
     * as a precondition, or no precondition if it was not read.
     */    Ge(t) {
        const e = this.y_.get(t.toString());
        return !this.b_.has(t.toString()) && e ? pn.updateTime(e) : pn.ze();
    }
    /**
     * Returns the precondition for a document if the operation is an update.
     */    C_(t) {
        const e = this.y_.get(t.toString());
        // The first time a document is written, we want to take into account the
        // read time and existence
                if (!this.b_.has(t.toString()) && e) {
            if (e.isEqual(wt.min())) 
            // The document doesn't exist, so fail the transaction.
            // This has to be validated locally because you can't send a
            // precondition that a document does not exist without changing the
            // semantics of the backend write to be an insert. This is the reverse
            // of what we want, since we want to assert that the document doesn't
            // exist but then send the update and have it fail. Since we can't
            // express that to the backend, we have to validate locally.
            // Note: this can change once we can send separate verify writes in the
            // transaction.
            throw new T(m.INVALID_ARGUMENT, "Can't update a document that doesn't exist.");
            // Document exists, base precondition on document update time.
                        return pn.updateTime(e);
        }
        // Document was not read, so we just use the preconditions for a blind
        // update.
        return pn.exists(!0);
    }
    write(t) {
        this.S_(), this.mutations = this.mutations.concat(t);
    }
    S_() {}
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * TransactionRunner encapsulates the logic needed to run and retry transactions
 * with backoff.
 */
class _c {
    constructor(t, e, n, s) {
        this.cs = t, this.Ku = e, this.updateFunction = n, this.ls = s, this.N_ = 5, this.ys = new Cs(this.cs, "transaction_retry" /* TransactionRetry */);
    }
    /** Runs the transaction and sets the result on deferred. */    run() {
        this.F_();
    }
    F_() {
        this.ys.gn((async () => {
            const t = new lc(this.Ku), e = this.x_(t);
            e && e.then((e => {
                this.cs.ws((() => t.commit().then((() => {
                    this.ls.resolve(e);
                })).catch((t => {
                    this.k_(t);
                }))));
            })).catch((t => {
                this.k_(t);
            }));
        }));
    }
    x_(t) {
        try {
            const e = this.updateFunction(t);
            return !mt(e) && e.catch && e.then ? e : (this.ls.reject(Error("Transaction callback must return a Promise")), 
            null);
        } catch (t) {
            // Do not retry errors thrown by user provided updateFunction.
            return this.ls.reject(t), null;
        }
    }
    k_(t) {
        this.N_ > 0 && this.M_(t) ? (this.N_ -= 1, this.cs.ws((() => (this.F_(), Promise.resolve())))) : this.ls.reject(t);
    }
    M_(t) {
        if ("FirebaseError" === t.name) {
            // In transactions, the backend will fail outdated reads with FAILED_PRECONDITION and
            // non-matching document versions with ABORTED. These errors should be retried.
            const e = t.code;
            return "aborted" === e || "failed-precondition" === e || !St(e);
        }
        return !1;
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * FirestoreClient is a top-level class that constructs and owns all of the
 * pieces of the client SDK architecture. It is responsible for creating the
 * async queue that is shared by all of the other components in the system.
 */
class fc {
    constructor(t, 
    /**
     * Asynchronous queue responsible for all of our internal processing. When
     * we get incoming work from the user (via public API) or the network
     * (incoming GRPC messages), we should always schedule onto this queue.
     * This ensures all of our work is properly serialized (e.g. we don't
     * start processing a new operation while the previous one is waiting for
     * an async I/O to complete).
     */
    e) {
        this.credentials = t, this.cs = e, this.clientId = nt.k(), 
        // We defer our initialization until we get the current user from
        // setChangeListener(). We block the async queue until we got the initial
        // user and the initialization is completed. This will prevent any scheduled
        // work from happening before initialization is completed.
        // If initializationDone resolved then the FirestoreClient is in a usable
        // state.
        this.O_ = new Ds;
    }
    /**
     * Starts up the FirestoreClient, returning only whether or not enabling
     * persistence succeeded.
     *
     * The intent here is to "do the right thing" as far as users are concerned.
     * Namely, in cases where offline persistence is requested and possible,
     * enable it, but otherwise fall back to persistence disabled. For the most
     * part we expect this to succeed one way or the other so we don't expect our
     * users to actually wait on the firestore.enablePersistence Promise since
     * they generally won't care.
     *
     * Of course some users actually do care about whether or not persistence
     * was successfully enabled, so the Promise returned from this method
     * indicates this outcome.
     *
     * This presents a problem though: even before enablePersistence resolves or
     * rejects, users may have made calls to e.g. firestore.collection() which
     * means that the FirestoreClient in there will be available and will be
     * enqueuing actions on the async queue.
     *
     * Meanwhile any failure of an operation on the async queue causes it to
     * panic and reject any further work, on the premise that unhandled errors
     * are fatal.
     *
     * Consequently the fallback is handled internally here in start, and if the
     * fallback succeeds we signal success to the async queue even though the
     * start() itself signals failure.
     *
     * @param databaseInfo The connection information for the current instance.
     * @param offlineComponentProvider Provider that returns all components
     * required for memory-only or IndexedDB persistence.
     * @param onlineComponentProvider Provider that returns all components
     * required for online support.
     * @param persistenceSettings Settings object to configure offline
     *     persistence.
     * @returns A deferred result indicating the user-visible result of enabling
     *     offline persistence. This method will reject this if IndexedDB fails to
     *     start for any reason. If usePersistence is false this is
     *     unconditionally resolved.
     */    start(t, e, n, s) {
        this.L_(), this.bl = t;
        // If usePersistence is true, certain classes of errors while starting are
        // recoverable but only by falling back to persistence disabled.
        // If there's an error in the first case but not in recovery we cannot
        // reject the promise blocking the async queue because this will cause the
        // async queue to panic.
        const i = new Ds;
        let r = !1;
        // Return only the result of enabling persistence. Note that this does not
        // need to await the completion of initializationDone because the result of
        // this method should not reflect any other kind of failure to start.
        return this.credentials.Hc((t => {
            if (!r) return r = !0, A("FirestoreClient", "Initializing. user=", t.uid), this.B_(e, n, s, t, i).then(this.O_.resolve, this.O_.reject);
            this.cs.Cs((() => async function(t, e) {
                const n = p(t);
                n.cs.xs(), A("RemoteStore", "RemoteStore received new credentials");
                const s = _o(n);
                // Tear down and re-create our network streams. This will ensure we get a
                // fresh auth token for the new user and re-fill the write pipeline with
                // new mutations from the LocalStore (since mutations are per-user).
                                n.Yu.add(3 /* CredentialChange */), await io(n), s && 
                // Don't set the network status to Unknown if we are offline.
                n.th.set("Unknown" /* Unknown */), await n.Gu.Jl(e), n.Yu.delete(3 /* CredentialChange */), 
                await so(n);
            }(this.ph, t)));
        })), 
        // Block the async queue until initialization is done
        this.cs.ws((() => this.O_.promise)), i.promise;
    }
    /** Enables the network connection and requeues all pending operations. */    enableNetwork() {
        return this.L_(), this.cs.enqueue((() => (this.persistence.tc(!0), function(t) {
            const e = p(t);
            return e.Yu.delete(0 /* UserDisabled */), so(e);
        }(this.ph))));
    }
    /**
     * Initializes persistent storage, attempting to use IndexedDB if
     * usePersistence is true or memory-only if false.
     *
     * If IndexedDB fails because it's already open in another tab or because the
     * platform can't possibly support our implementation then this method rejects
     * the persistenceResult and falls back on memory-only persistence.
     *
     * @param offlineComponentProvider Provider that returns all components
     * required for memory-only or IndexedDB persistence.
     * @param onlineComponentProvider Provider that returns all components
     * required for online support.
     * @param persistenceSettings Settings object to configure offline persistence
     * @param user The initial user
     * @param persistenceResult A deferred result indicating the user-visible
     *     result of enabling offline persistence. This method will reject this if
     *     IndexedDB fails to start for any reason. If usePersistence is false
     *     this is unconditionally resolved.
     * @returns a Promise indicating whether or not initialization should
     *     continue, i.e. that one of the persistence implementations actually
     *     succeeded.
     */    async B_(t, e, n, s, i) {
        try {
            const r = {
                cs: this.cs,
                bl: this.bl,
                clientId: this.clientId,
                credentials: this.credentials,
                Wl: s,
                Dh: 100,
                persistenceSettings: n
            };
            await t.initialize(r), await e.initialize(t, r), this.persistence = t.persistence, 
            this.Sh = t.Sh, this.ju = t.ju, this.ql = t.ql, this.Ku = e.Ku, this.ph = e.ph, 
            this.fi = e.fi, this.q_ = e.bh, this.q_.Us = Oo.bind(null, this.fi), this.q_.js = Bo.bind(null, this.fi), 
            // When a user calls clearPersistence() in one client, all other clients
            // need to be terminated to allow the delete to succeed.
            this.persistence.Za((async () => {
                await this.terminate();
            })), i.resolve();
        } catch (t) {
            // An unknown failure on the first stage shuts everything down.
            if (
            // Regardless of whether or not the retry succeeds, from an user
            // perspective, offline persistence has failed.
            i.reject(t), !this.U_(t)) throw t;
            return console.warn("Error enabling offline persistence. Falling back to persistence disabled: " + t), 
            this.B_(new Sa, new Na, {
                jl: !1
            }, s, i);
        }
    }
    /**
     * Decides whether the provided error allows us to gracefully disable
     * persistence (as opposed to crashing the client).
     */    U_(t) {
        return "FirebaseError" === t.name ? t.code === m.FAILED_PRECONDITION || t.code === m.UNIMPLEMENTED : !("undefined" != typeof DOMException && t instanceof DOMException) || (
        // When the browser is out of quota we could get either quota exceeded
        // or an aborted error depending on whether the error happened during
        // schema migration.
        22 === t.code || 20 === t.code || 
        // Firefox Private Browsing mode disables IndexedDb and returns
        // INVALID_STATE for any usage.
        11 === t.code);
    }
    /**
     * Checks that the client has not been terminated. Ensures that other methods on
     * this class cannot be called after the client is terminated.
     */    L_() {
        if (this.cs.ps) throw new T(m.FAILED_PRECONDITION, "The client has already been terminated.");
    }
    /** Disables the network connection. Pending operations will not complete. */    disableNetwork() {
        return this.L_(), this.cs.enqueue((() => (this.persistence.tc(!1), async function(t) {
            const e = p(t);
            e.Yu.add(0 /* UserDisabled */), await io(e), 
            // Set the OnlineState to Offline so get()s return from cache, etc.
            e.th.set("Offline" /* Offline */);
        }(this.ph))));
    }
    terminate() {
        this.cs.Ds();
        const t = new Ds;
        return this.cs.bs((async () => {
            try {
                // PORTING NOTE: LocalStore does not need an explicit shutdown on web.
                this.ql && this.ql.stop(), await ro(this.ph), await this.Sh.Di(), await this.persistence.Di(), 
                // `removeChangeListener` must be called after shutting down the
                // RemoteStore as it will prevent the RemoteStore from retrieving
                // auth tokens.
                this.credentials.Yc(), t.resolve();
            } catch (e) {
                const n = Ks(e, "Failed to shutdown persistence");
                t.reject(n);
            }
        })), t.promise;
    }
    /**
     * Returns a Promise that resolves when all writes that were pending at the time this
     * method was called received server acknowledgement. An acknowledgement can be either acceptance
     * or rejection.
     */    waitForPendingWrites() {
        this.L_();
        const t = new Ds;
        return this.cs.ws((() => Go(this.fi, t))), t.promise;
    }
    listen(t, e, n) {
        this.L_();
        const s = new Fa(n), i = new ti(t, s, e);
        return this.cs.ws((() => Hs(this.q_, i))), () => {
            s.Zl(), this.cs.ws((() => Ys(this.q_, i)));
        };
    }
    async Q_(t) {
        this.L_(), await this.O_.promise;
        const e = new Ds;
        return this.cs.ws((() => async function(t, e, n) {
            try {
                const s = await function(t, e) {
                    const n = p(t);
                    return n.persistence.runTransaction("read document", "readonly", (t => n.Cc.Cr(t, e)));
                }(t, e);
                s instanceof Kn ? n.resolve(s) : s instanceof Gn ? n.resolve(null) : n.reject(new T(m.UNAVAILABLE, "Failed to get document from cache. (However, this document may exist on the server. Run again without setting 'source' in the GetOptions to attempt to retrieve the document from the server.)"));
            } catch (t) {
                const s = Ks(t, `Failed to get document '${e} from cache`);
                n.reject(s);
            }
        }
        /**
 * Retrieves a latency-compensated document from the backend via a
 * SnapshotListener.
 */ (this.ju, t, e))), e.promise;
    }
    async W_(t, e = {}) {
        this.L_(), await this.O_.promise;
        const n = new Ds;
        return this.cs.ws((() => function(t, e, n, s, i) {
            const r = new Fa({
                next: r => {
                    // Remove query first before passing event to user to avoid
                    // user actions affecting the now stale query.
                    e.ws((() => Ys(t, o)));
                    const a = r.docs.has(n);
                    !a && r.fromCache ? 
                    // TODO(dimond): If we're online and the document doesn't
                    // exist then we resolve with a doc.exists set to false. If
                    // we're offline however, we reject the Promise in this
                    // case. Two options: 1) Cache the negative response from
                    // the server so we can deliver that even when you're
                    // offline 2) Actually reject the Promise in the online case
                    // if the document doesn't exist.
                    i.reject(new T(m.UNAVAILABLE, "Failed to get document because the client is offline.")) : a && r.fromCache && s && "server" === s.source ? i.reject(new T(m.UNAVAILABLE, 'Failed to get document from server. (However, this document does exist in the local cache. Run again without setting source to "server" to retrieve the cached document.)')) : i.resolve(r);
                },
                error: t => i.reject(t)
            }), o = new ti(Jn(n.path), r, {
                includeMetadataChanges: !0,
                Xs: !0
            });
            return Hs(t, o);
        }(this.q_, this.cs, t, e, n))), n.promise;
    }
    async j_(t) {
        this.L_(), await this.O_.promise;
        const e = new Ds;
        return this.cs.ws((() => async function(t, e, n) {
            try {
                const s = await Lr(t, e, 
                /* usePreviousResults= */ !0), i = new xo(e, s.Fc), r = i.wh(s.documents), o = i.yr(r, 
                /* updateLimboDocuments= */ !1);
                n.resolve(o.snapshot);
            } catch (t) {
                const s = Ks(t, `Failed to execute query '${e} against cache`);
                n.reject(s);
            }
        }
        /**
 * Retrieves a latency-compensated query snapshot from the backend via a
 * SnapshotListener.
 */ (this.ju, t, e))), e.promise;
    }
    async K_(t, e = {}) {
        this.L_(), await this.O_.promise;
        const n = new Ds;
        return this.cs.ws((() => function(t, e, n, s, i) {
            const r = new Fa({
                next: n => {
                    // Remove query first before passing event to user to avoid
                    // user actions affecting the now stale query.
                    e.ws((() => Ys(t, o))), n.fromCache && "server" === s.source ? i.reject(new T(m.UNAVAILABLE, 'Failed to get documents from server. (However, these documents may exist in the local cache. Run again without setting source to "server" to retrieve the cached documents.)')) : i.resolve(n);
                },
                error: t => i.reject(t)
            }), o = new ti(n, r, {
                includeMetadataChanges: !0,
                Xs: !0
            });
            return Hs(t, o);
        }
        /**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ (this.q_, this.cs, t, e, n))), n.promise;
    }
    write(t) {
        this.L_();
        const e = new Ds;
        return this.cs.ws((() => qo(this.fi, t, e))), e.promise;
    }
    U() {
        return this.bl.U;
    }
    G_(t) {
        this.L_();
        const e = new Fa(t);
        return this.cs.ws((async () => function(t, e) {
            p(t).qs.add(e), 
            // Immediately fire an initial event, indicating all existing listeners
            // are in-sync.
            e.next();
        }(this.q_, e))), () => {
            e.Zl(), this.cs.ws((async () => function(t, e) {
                p(t).qs.delete(e);
            }(this.q_, e)));
        };
    }
    get z_() {
        // Technically, the asyncQueue is still running, but only accepting operations
        // related to termination or supposed to be run after termination. It is effectively
        // terminated to the eyes of users.
        return this.cs.ps;
    }
    /**
     * Takes an updateFunction in which a set of reads and writes can be performed
     * atomically. In the updateFunction, the client can read and write values
     * using the supplied transaction object. After the updateFunction, all
     * changes will be committed. If a retryable error occurs (ex: some other
     * client has changed any of the data referenced), then the updateFunction
     * will be called again after a backoff. If the updateFunction still fails
     * after all retries, then the transaction will be rejected.
     *
     * The transaction object passed to the updateFunction contains methods for
     * accessing documents and collections. Unlike other datastore access, data
     * accessed with the transaction will not reflect local changes that have not
     * been committed. For this reason, it is required that all reads are
     * performed before any writes. Transactions must be performed while online.
     */    transaction(t) {
        this.L_();
        const e = new Ds;
        return this.cs.ws((() => (new _c(this.cs, this.Ku, t, e).run(), Promise.resolve()))), 
        e.promise;
    }
}

function dc(t) {
    /**
 * Returns true if obj is an object and contains at least one of the specified
 * methods.
 */
    return function(t, e) {
        if ("object" != typeof t || null === t) return !1;
        const n = t;
        for (const t of e) if (t in n && "function" == typeof n[t]) return !0;
        return !1;
    }
    /**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
    /**
 * Converts Firestore's internal types to the JavaScript types that we expose
 * to the user.
 */ (t, [ "next", "error", "complete" ]);
}

class wc {
    constructor(t, e, n, s, i) {
        this.U = t, this.timestampsInSnapshots = e, this.H_ = n, this.Y_ = s, this.J_ = i;
    }
    X_(t) {
        switch (ce(t)) {
          case 0 /* NullValue */ :
            return null;

          case 1 /* BooleanValue */ :
            return t.booleanValue;

          case 2 /* NumberValue */ :
            return me(t.integerValue || t.doubleValue);

          case 3 /* TimestampValue */ :
            return this.Z_(t.timestampValue);

          case 4 /* ServerTimestampValue */ :
            return this.tf(t);

          case 5 /* StringValue */ :
            return t.stringValue;

          case 6 /* BlobValue */ :
            return this.J_(Te(t.bytesValue));

          case 7 /* RefValue */ :
            return this.ef(t.referenceValue);

          case 8 /* GeoPointValue */ :
            return this.nf(t.geoPointValue);

          case 9 /* ArrayValue */ :
            return this.sf(t.arrayValue);

          case 10 /* ObjectValue */ :
            return this.if(t.mapValue);

          default:
            throw y();
        }
    }
    if(t) {
        const e = {};
        return v(t.fields || {}, ((t, n) => {
            e[t] = this.X_(n);
        })), e;
    }
    nf(t) {
        return new Wa(me(t.latitude), me(t.longitude));
    }
    sf(t) {
        return (t.values || []).map((t => this.X_(t)));
    }
    tf(t) {
        switch (this.H_) {
          case "previous":
            const e = re(t);
            return null == e ? null : this.X_(e);

          case "estimate":
            return this.Z_(oe(t));

          default:
            return null;
        }
    }
    Z_(t) {
        const e = we(t), n = new dt(e.seconds, e.nanos);
        return this.timestampsInSnapshots ? n : n.toDate();
    }
    ef(t) {
        const e = C.g(t);
        V(un(e));
        const n = new _t(e.get(1), e.get(3)), s = new x(e.u(5));
        return n.isEqual(this.U) || 
        // TODO(b/64130202): Somehow support foreign references.
        R(`Document ${s} contains a document reference within a different database (${n.projectId}/${n.database}) which is not supported. It will be treated as a reference in the current database (${this.U.projectId}/${this.U.database}) instead.`), 
        this.Y_(s);
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// settings() defaults:
const mc = Pi.ho;

/**
 * A concrete type describing all the values that can be applied via a
 * user-supplied firestore.Settings object. This is a separate type so that
 * defaults can be supplied and the value can be checked for equality.
 */
class Tc {
    constructor(t) {
        var e, n, s, i, r;
        if (void 0 === t.host) {
            if (void 0 !== t.ssl) throw new T(m.INVALID_ARGUMENT, "Can't provide ssl option if host option is not set");
            this.host = "firestore.googleapis.com", this.ssl = true;
        } else q("settings", "non-empty string", "host", t.host), this.host = t.host, U("settings", "boolean", "ssl", t.ssl), 
        this.ssl = null === (e = t.ssl) || void 0 === e || e;
        if (Y("settings", t, [ "host", "ssl", "credentials", "timestampsInSnapshots", "cacheSizeBytes", "experimentalForceLongPolling", "experimentalAutoDetectLongPolling", "ignoreUndefinedProperties" ]), 
        U("settings", "object", "credentials", t.credentials), this.credentials = t.credentials, 
        U("settings", "boolean", "timestampsInSnapshots", t.timestampsInSnapshots), U("settings", "boolean", "ignoreUndefinedProperties", t.ignoreUndefinedProperties), 
        // Nobody should set timestampsInSnapshots anymore, but the error depends on
        // whether they set it to true or false...
        !0 === t.timestampsInSnapshots ? R("The setting 'timestampsInSnapshots: true' is no longer required and should be removed.") : !1 === t.timestampsInSnapshots && R("Support for 'timestampsInSnapshots: false' will be removed soon. You must update your code to handle Timestamp objects."), 
        this.timestampsInSnapshots = null === (n = t.timestampsInSnapshots) || void 0 === n || n, 
        this.ignoreUndefinedProperties = null !== (s = t.ignoreUndefinedProperties) && void 0 !== s && s, 
        U("settings", "number", "cacheSizeBytes", t.cacheSizeBytes), void 0 === t.cacheSizeBytes) this.cacheSizeBytes = Pi._o; else {
            if (t.cacheSizeBytes !== mc && t.cacheSizeBytes < Pi.lo) throw new T(m.INVALID_ARGUMENT, "cacheSizeBytes must be at least " + Pi.lo);
            this.cacheSizeBytes = t.cacheSizeBytes;
        }
        U("settings", "boolean", "experimentalForceLongPolling", t.experimentalForceLongPolling), 
        this.experimentalForceLongPolling = null !== (i = t.experimentalForceLongPolling) && void 0 !== i && i, 
        U("settings", "boolean", "experimentalAutoDetectLongPolling", t.experimentalAutoDetectLongPolling), 
        this.experimentalAutoDetectLongPolling = null !== (r = t.experimentalAutoDetectLongPolling) && void 0 !== r && r, 
        function(t, e, n, s) {
            if (!0 === e && !0 === s) throw new T(m.INVALID_ARGUMENT, `${t} and ${n} cannot be used together.`);
        }("experimentalForceLongPolling", t.experimentalForceLongPolling, "experimentalAutoDetectLongPolling", t.experimentalAutoDetectLongPolling);
    }
    isEqual(t) {
        return this.host === t.host && this.ssl === t.ssl && this.timestampsInSnapshots === t.timestampsInSnapshots && this.credentials === t.credentials && this.cacheSizeBytes === t.cacheSizeBytes && this.experimentalForceLongPolling === t.experimentalForceLongPolling && this.experimentalAutoDetectLongPolling === t.experimentalAutoDetectLongPolling && this.ignoreUndefinedProperties === t.ignoreUndefinedProperties;
    }
}

/**
 * The root reference to the database.
 */ class Ec {
    // Note: We are using `MemoryComponentProvider` as a default
    // ComponentProvider to ensure backwards compatibility with the format
    // expected by the console build.
    constructor(t, e, n = new Sa, s = new Na) {
        if (this.rf = n, this.af = s, this.cf = null, 
        // Public for use in tests.
        // TODO(mikelehen): Use modularized initialization instead.
        this.uf = new js, this.INTERNAL = {
            delete: async () => {
                // The client must be initalized to ensure that all subsequent API usage
                // throws an exception.
                this.hf(), await this.lf.terminate();
            }
        }, "object" == typeof t.options) {
            // This is very likely a Firebase app object
            // TODO(b/34177605): Can we somehow use instanceof?
            const n = t;
            this.cf = n, this.__ = Ec._f(n), this.ff = n.name, this.df = new zr(e);
        } else {
            const e = t;
            if (!e.projectId) throw new T(m.INVALID_ARGUMENT, "Must provide projectId");
            this.__ = new _t(e.projectId, e.database), 
            // Use a default persistenceKey that lines up with FirebaseApp.
            this.ff = "[DEFAULT]", this.df = new Gr;
        }
        this.wf = new Tc({});
    }
    get mf() {
        return this.Tf || (
        // Lazy initialize UserDataReader once the settings are frozen
        this.Tf = new Xa(this.__, this.wf.ignoreUndefinedProperties)), this.Tf;
    }
    settings(t) {
        k("Firestore.settings", arguments, 1), L("Firestore.settings", "object", 1, t), 
        t.merge && 
        // Remove the property from the settings once the merge is completed
        delete (t = Object.assign(Object.assign({}, this.wf), t)).merge;
        const e = new Tc(t);
        if (this.lf && !this.wf.isEqual(e)) throw new T(m.FAILED_PRECONDITION, "Firestore has already been started and its settings can no longer be changed. You can only call settings() before calling any other methods on a Firestore object.");
        this.wf = e, void 0 !== e.credentials && (this.df = function(t) {
            if (!t) return new Gr;
            switch (t.type) {
              case "gapi":
                const e = t.client;
                // Make sure this really is a Gapi client.
                                return V(!("object" != typeof e || null === e || !e.auth || !e.auth.getAuthHeaderValueForFirstParty)), 
                new Yr(e, t.sessionIndex || "0");

              case "provider":
                return t.client;

              default:
                throw new T(m.INVALID_ARGUMENT, "makeCredentialsProvider failed due to invalid credential type");
            }
        }
        /**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ (e.credentials));
    }
    enableNetwork() {
        return this.hf(), this.lf.enableNetwork();
    }
    disableNetwork() {
        return this.hf(), this.lf.disableNetwork();
    }
    enablePersistence(t) {
        var e, n;
        if (this.lf) throw new T(m.FAILED_PRECONDITION, "Firestore has already been started and persistence can no longer be enabled. You can only call enablePersistence() before calling any other methods on a Firestore object.");
        let s = !1, i = !1;
        if (t && (void 0 !== t.experimentalTabSynchronization && R("The 'experimentalTabSynchronization' setting will be removed. Use 'synchronizeTabs' instead."), 
        s = null !== (n = null !== (e = t.synchronizeTabs) && void 0 !== e ? e : t.experimentalTabSynchronization) && void 0 !== n && n, 
        i = !!t.experimentalForceOwningTab && t.experimentalForceOwningTab, s && i)) throw new T(m.INVALID_ARGUMENT, "The 'experimentalForceOwningTab' setting cannot be used with 'synchronizeTabs'.");
        return this.Ef(this.rf, this.af, {
            jl: !0,
            cacheSizeBytes: this.wf.cacheSizeBytes,
            synchronizeTabs: s,
            ka: i
        });
    }
    async clearPersistence() {
        if (void 0 !== this.lf && !this.lf.z_) throw new T(m.FAILED_PRECONDITION, "Persistence can only be cleared before a Firestore instance is initialized or after it is terminated.");
        const t = new Ds;
        return this.uf.bs((async () => {
            try {
                await this.rf.clearPersistence(this.__, this.ff), t.resolve();
            } catch (e) {
                t.reject(e);
            }
        })), t.promise;
    }
    terminate() {
        return this.app._removeServiceInstance("firestore"), this.INTERNAL.delete();
    }
    get If() {
        return this.hf(), this.lf.z_;
    }
    waitForPendingWrites() {
        return this.hf(), this.lf.waitForPendingWrites();
    }
    onSnapshotsInSync(t) {
        if (this.hf(), dc(t)) return this.lf.G_(t);
        {
            L("Firestore.onSnapshotsInSync", "function", 1, t);
            const e = {
                next: t
            };
            return this.lf.G_(e);
        }
    }
    hf() {
        return this.lf || 
        // Kick off starting the client but don't actually wait for it.
        // eslint-disable-next-line @typescript-eslint/no-floating-promises
        this.Ef(new Sa, new Na, {
            jl: !1
        }), this.lf;
    }
    Af() {
        return new lt(this.__, this.ff, this.wf.host, this.wf.ssl, this.wf.experimentalForceLongPolling, this.wf.experimentalAutoDetectLongPolling);
    }
    Ef(t, e, n) {
        const s = this.Af();
        return this.lf = new fc(this.df, this.uf), this.lf.start(s, t, e, n);
    }
    static _f(t) {
        if (e = t.options, n = "projectId", !Object.prototype.hasOwnProperty.call(e, n)) throw new T(m.INVALID_ARGUMENT, '"projectId" not provided in firebase.initializeApp.');
        var e, n;
        const s = t.options.projectId;
        if (!s || "string" != typeof s) throw new T(m.INVALID_ARGUMENT, "projectId must be a string in FirebaseApp.options");
        return new _t(s);
    }
    get app() {
        if (!this.cf) throw new T(m.FAILED_PRECONDITION, "Firestore was not initialized using the Firebase SDK. 'app' is not available");
        return this.cf;
    }
    collection(t) {
        return k("Firestore.collection", arguments, 1), L("Firestore.collection", "non-empty string", 1, t), 
        this.hf(), new Fc(C.g(t), this, 
        /* converter= */ null);
    }
    doc(t) {
        return k("Firestore.doc", arguments, 1), L("Firestore.doc", "non-empty string", 1, t), 
        this.hf(), Rc.Rf(C.g(t), this, 
        /* converter= */ null);
    }
    collectionGroup(t) {
        if (k("Firestore.collectionGroup", arguments, 1), L("Firestore.collectionGroup", "non-empty string", 1, t), 
        t.indexOf("/") >= 0) throw new T(m.INVALID_ARGUMENT, `Invalid collection ID '${t}' passed to function Firestore.collectionGroup(). Collection IDs must not contain '/'.`);
        return this.hf(), new Cc(
        /**
 * Creates a new Query for a collection group query that matches all documents
 * within the provided collection group.
 */
        function(t) {
            return new Hn(C.P(), t);
        }(t), this, 
        /* converter= */ null);
    }
    runTransaction(t) {
        return k("Firestore.runTransaction", arguments, 1), L("Firestore.runTransaction", "function", 1, t), 
        this.hf().transaction((e => t(new Ic(this, e))));
    }
    batch() {
        return this.hf(), new Ac(this);
    }
    static get logLevel() {
        switch (I()) {
          case n.DEBUG:
            return "debug";

          case n.ERROR:
            return "error";

          case n.SILENT:
            return "silent";

          case n.WARN:
            return "warn";

          case n.INFO:
            return "info";

          case n.VERBOSE:
            return "verbose";

          default:
            // The default log level is error
            return "error";
        }
    }
    static setLogLevel(t) {
        var e;
        k("Firestore.setLogLevel", arguments, 1), j("setLogLevel", [ "debug", "error", "silent", "warn", "info", "verbose" ], 1, t), 
        e = t, E.setLogLevel(e);
    }
    // Note: this is not a property because the minifier can't work correctly with
    // the way TypeScript compiler outputs properties.
    gf() {
        return this.wf.timestampsInSnapshots;
    }
    // Visible for testing.
    Pf() {
        return this.wf;
    }
}

/**
 * A reference to a transaction.
 */ class Ic {
    constructor(t, e) {
        this.yf = t, this.Vf = e;
    }
    get(t) {
        k("Transaction.get", arguments, 1);
        const e = Mc("Transaction.get", t, this.yf);
        return this.Vf.v_([ e.f_ ]).then((t => {
            if (!t || 1 !== t.length) return y();
            const n = t[0];
            if (n instanceof Gn) return new Pc(this.yf, e.f_, null, 
            /* fromCache= */ !1, 
            /* hasPendingWrites= */ !1, e.d_);
            if (n instanceof Kn) return new Pc(this.yf, e.f_, n, 
            /* fromCache= */ !1, 
            /* hasPendingWrites= */ !1, e.d_);
            throw y();
        }));
    }
    set(t, e, n) {
        O("Transaction.set", arguments, 2, 3);
        const s = Mc("Transaction.set", t, this.yf);
        n = xc("Transaction.set", n);
        const i = Lc(s.d_, e, n), r = Za(this.yf.mf, "Transaction.set", s.f_, i, null !== s.d_, n);
        return this.Vf.set(s.f_, r), this;
    }
    update(t, e, n, ...s) {
        let i, r;
        return "string" == typeof e || e instanceof $a ? (M("Transaction.update", arguments, 3), 
        i = Mc("Transaction.update", t, this.yf), r = ec(this.yf.mf, "Transaction.update", i.f_, e, n, s)) : (k("Transaction.update", arguments, 2), 
        i = Mc("Transaction.update", t, this.yf), r = tc(this.yf.mf, "Transaction.update", i.f_, e)), 
        this.Vf.update(i.f_, r), this;
    }
    delete(t) {
        k("Transaction.delete", arguments, 1);
        const e = Mc("Transaction.delete", t, this.yf);
        return this.Vf.delete(e.f_), this;
    }
}

class Ac {
    constructor(t) {
        this.yf = t, this.pf = [], this.bf = !1;
    }
    set(t, e, n) {
        O("WriteBatch.set", arguments, 2, 3), this.vf();
        const s = Mc("WriteBatch.set", t, this.yf);
        n = xc("WriteBatch.set", n);
        const i = Lc(s.d_, e, n), r = Za(this.yf.mf, "WriteBatch.set", s.f_, i, null !== s.d_, n);
        return this.pf = this.pf.concat(r.w_(s.f_, pn.ze())), this;
    }
    update(t, e, n, ...s) {
        let i, r;
        return this.vf(), "string" == typeof e || e instanceof $a ? (M("WriteBatch.update", arguments, 3), 
        i = Mc("WriteBatch.update", t, this.yf), r = ec(this.yf.mf, "WriteBatch.update", i.f_, e, n, s)) : (k("WriteBatch.update", arguments, 2), 
        i = Mc("WriteBatch.update", t, this.yf), r = tc(this.yf.mf, "WriteBatch.update", i.f_, e)), 
        this.pf = this.pf.concat(r.w_(i.f_, pn.exists(!0))), this;
    }
    delete(t) {
        k("WriteBatch.delete", arguments, 1), this.vf();
        const e = Mc("WriteBatch.delete", t, this.yf);
        return this.pf = this.pf.concat(new Bn(e.f_, pn.ze())), this;
    }
    commit() {
        return this.vf(), this.bf = !0, this.pf.length > 0 ? this.yf.hf().write(this.pf) : Promise.resolve();
    }
    vf() {
        if (this.bf) throw new T(m.FAILED_PRECONDITION, "A write batch can no longer be used after commit() has been called.");
    }
}

/**
 * A reference to a particular document in a collection in the database.
 */ class Rc extends Ga {
    constructor(t, e, n) {
        super(e.__, t, n), this.f_ = t, this.firestore = e, this.d_ = n, this.lf = this.firestore.hf();
    }
    static Rf(t, e, n) {
        if (t.length % 2 != 0) throw new T(m.INVALID_ARGUMENT, `Invalid document reference. Document references must have an even number of segments, but ${t.R()} has ${t.length}`);
        return new Rc(new x(t), e, n);
    }
    get id() {
        return this.f_.path._();
    }
    get parent() {
        return new Fc(this.f_.path.h(), this.firestore, this.d_);
    }
    get path() {
        return this.f_.path.R();
    }
    collection(t) {
        if (k("DocumentReference.collection", arguments, 1), L("DocumentReference.collection", "non-empty string", 1, t), 
        !t) throw new T(m.INVALID_ARGUMENT, "Must provide a non-empty collection name to collection()");
        const e = C.g(t);
        return new Fc(this.f_.path.child(e), this.firestore, 
        /* converter= */ null);
    }
    isEqual(t) {
        if (!(t instanceof Rc)) throw J("isEqual", "DocumentReference", 1, t);
        return this.firestore === t.firestore && this.f_.isEqual(t.f_) && this.d_ === t.d_;
    }
    set(t, e) {
        O("DocumentReference.set", arguments, 1, 2), e = xc("DocumentReference.set", e);
        const n = Lc(this.d_, t, e), s = Za(this.firestore.mf, "DocumentReference.set", this.f_, n, null !== this.d_, e);
        return this.lf.write(s.w_(this.f_, pn.ze()));
    }
    update(t, e, ...n) {
        let s;
        return "string" == typeof t || t instanceof $a ? (M("DocumentReference.update", arguments, 2), 
        s = ec(this.firestore.mf, "DocumentReference.update", this.f_, t, e, n)) : (k("DocumentReference.update", arguments, 1), 
        s = tc(this.firestore.mf, "DocumentReference.update", this.f_, t)), this.lf.write(s.w_(this.f_, pn.exists(!0)));
    }
    delete() {
        return k("DocumentReference.delete", arguments, 0), this.lf.write([ new Bn(this.f_, pn.ze()) ]);
    }
    onSnapshot(...t) {
        var e, n, s;
        O("DocumentReference.onSnapshot", arguments, 1, 4);
        let i = {
            includeMetadataChanges: !1
        }, r = 0;
        "object" != typeof t[r] || dc(t[r]) || (i = t[r], Y("DocumentReference.onSnapshot", i, [ "includeMetadataChanges" ]), 
        U("DocumentReference.onSnapshot", "boolean", "includeMetadataChanges", i.includeMetadataChanges), 
        r++);
        const o = {
            includeMetadataChanges: i.includeMetadataChanges
        };
        if (dc(t[r])) {
            const i = t[r];
            t[r] = null === (e = i.next) || void 0 === e ? void 0 : e.bind(i), t[r + 1] = null === (n = i.error) || void 0 === n ? void 0 : n.bind(i), 
            t[r + 2] = null === (s = i.complete) || void 0 === s ? void 0 : s.bind(i);
        } else L("DocumentReference.onSnapshot", "function", r, t[r]), B("DocumentReference.onSnapshot", "function", r + 1, t[r + 1]), 
        B("DocumentReference.onSnapshot", "function", r + 2, t[r + 2]);
        const a = {
            next: e => {
                t[r] && t[r](this.Sf(e));
            },
            error: t[r + 1],
            complete: t[r + 2]
        };
        return this.lf.listen(Jn(this.f_.path), o, a);
    }
    get(t) {
        O("DocumentReference.get", arguments, 0, 1), kc("DocumentReference.get", t);
        const e = this.firestore.hf();
        return t && "cache" === t.source ? e.Q_(this.f_).then((t => new Pc(this.firestore, this.f_, t, 
        /*fromCache=*/ !0, t instanceof Kn && t.Je, this.d_))) : e.W_(this.f_, t).then((t => this.Sf(t)));
    }
    withConverter(t) {
        return new Rc(this.f_, this.firestore, t);
    }
    /**
     * Converts a ViewSnapshot that contains the current document to a
     * DocumentSnapshot.
     */    Sf(t) {
        const e = t.docs.get(this.f_);
        return new Pc(this.firestore, this.f_, e, t.fromCache, t.hasPendingWrites, this.d_);
    }
}

/**
 * Metadata about a snapshot, describing the state of the snapshot.
 */ class gc {
    constructor(t, e) {
        this.hasPendingWrites = t, this.fromCache = e;
    }
    /**
     * Returns true if this `SnapshotMetadata` is equal to the provided one.
     *
     * @param other The `SnapshotMetadata` to compare against.
     * @return true if this `SnapshotMetadata` is equal to the provided one.
     */    isEqual(t) {
        return this.hasPendingWrites === t.hasPendingWrites && this.fromCache === t.fromCache;
    }
}

class Pc {
    constructor(t, e, n, s, i, r) {
        this.yf = t, this.f_ = e, this.Df = n, this.Cf = s, this.Nf = i, this.d_ = r;
    }
    data(t) {
        if (O("DocumentSnapshot.data", arguments, 0, 1), t = $c("DocumentSnapshot.data", t), 
        this.Df) {
            // We only want to use the converter and create a new DocumentSnapshot
            // if a converter has been provided.
            if (this.d_) {
                const e = new yc(this.yf, this.f_, this.Df, this.Cf, this.Nf, 
                /* converter= */ null);
                return this.d_.fromFirestore(e, t);
            }
            return new wc(this.yf.__, this.yf.gf(), t.serverTimestamps || "none", (t => new Rc(t, this.yf, /* converter= */ null)), (t => new ht(t))).X_(this.Df.rn());
        }
    }
    get(t, e) {
        if (O("DocumentSnapshot.get", arguments, 1, 2), e = $c("DocumentSnapshot.get", e), 
        this.Df) {
            const n = this.Df.data().field(ac("DocumentSnapshot.get", t, this.f_));
            if (null !== n) {
                return new wc(this.yf.__, this.yf.gf(), e.serverTimestamps || "none", (t => new Rc(t, this.yf, this.d_)), (t => new ht(t))).X_(n);
            }
        }
    }
    get id() {
        return this.f_.path._();
    }
    get ref() {
        return new Rc(this.f_, this.yf, this.d_);
    }
    get exists() {
        return null !== this.Df;
    }
    get metadata() {
        return new gc(this.Nf, this.Cf);
    }
    isEqual(t) {
        if (!(t instanceof Pc)) throw J("isEqual", "DocumentSnapshot", 1, t);
        return this.yf === t.yf && this.Cf === t.Cf && this.f_.isEqual(t.f_) && (null === this.Df ? null === t.Df : this.Df.isEqual(t.Df)) && this.d_ === t.d_;
    }
}

class yc extends Pc {
    data(t) {
        return super.data(t);
    }
}

function Vc(t, e, n, s, i, r, o) {
    let a;
    if (i.p()) {
        if ("array-contains" /* ARRAY_CONTAINS */ === r || "array-contains-any" /* ARRAY_CONTAINS_ANY */ === r) throw new T(m.INVALID_ARGUMENT, `Invalid Query. You can't perform '${r}' queries on FieldPath.documentId().`);
        if ("in" /* IN */ === r || "not-in" /* NOT_IN */ === r) {
            vc(o, r);
            const e = [];
            for (const n of o) e.push(bc(s, t, n));
            a = {
                arrayValue: {
                    values: e
                }
            };
        } else a = bc(s, t, o);
    } else "in" /* IN */ !== r && "not-in" /* NOT_IN */ !== r && "array-contains-any" /* ARRAY_CONTAINS_ANY */ !== r || vc(o, r), 
    a = nc(n, e, o, 
    /* allowArrays= */ "in" /* IN */ === r || "not-in" /* NOT_IN */ === r);
    const c = fs.create(i, r, a);
    return function(t, e) {
        if (e.hn()) {
            const n = es(t);
            if (null !== n && !n.isEqual(e.field)) throw new T(m.INVALID_ARGUMENT, `Invalid query. All where filters with an inequality (<, <=, >, or >=) must be on the same field. But you have inequality filters on '${n.toString()}' and '${e.field.toString()}'`);
            const s = ts(t);
            null !== s && Sc(t, e.field, s);
        }
        const n = function(t, e) {
            for (const n of t.filters) if (e.indexOf(n.op) >= 0) return n.op;
            return null;
        }(t, 
        /**
 * Given an operator, returns the set of operators that cannot be used with it.
 *
 * Operators in a query must adhere to the following set of rules:
 * 1. Only one array operator is allowed.
 * 2. Only one disjunctive operator is allowed.
 * 3. NOT_EQUAL cannot be used with another NOT_EQUAL operator.
 * 4. NOT_IN cannot be used with array, disjunctive, or NOT_EQUAL operators.
 *
 * Array operators: ARRAY_CONTAINS, ARRAY_CONTAINS_ANY
 * Disjunctive operators: IN, ARRAY_CONTAINS_ANY, NOT_IN
 */
        function(t) {
            switch (t) {
              case "!=" /* NOT_EQUAL */ :
                return [ "!=" /* NOT_EQUAL */ , "not-in" /* NOT_IN */ ];

              case "array-contains" /* ARRAY_CONTAINS */ :
                return [ "array-contains" /* ARRAY_CONTAINS */ , "array-contains-any" /* ARRAY_CONTAINS_ANY */ , "not-in" /* NOT_IN */ ];

              case "in" /* IN */ :
                return [ "array-contains-any" /* ARRAY_CONTAINS_ANY */ , "in" /* IN */ , "not-in" /* NOT_IN */ ];

              case "array-contains-any" /* ARRAY_CONTAINS_ANY */ :
                return [ "array-contains" /* ARRAY_CONTAINS */ , "array-contains-any" /* ARRAY_CONTAINS_ANY */ , "in" /* IN */ , "not-in" /* NOT_IN */ ];

              case "not-in" /* NOT_IN */ :
                return [ "array-contains" /* ARRAY_CONTAINS */ , "array-contains-any" /* ARRAY_CONTAINS_ANY */ , "in" /* IN */ , "not-in" /* NOT_IN */ , "!=" /* NOT_EQUAL */ ];

              default:
                return [];
            }
        }(e.op));
        if (null !== n) 
        // Special case when it's a duplicate op to give a slightly clearer error message.
        throw n === e.op ? new T(m.INVALID_ARGUMENT, `Invalid query. You cannot use more than one '${e.op.toString()}' filter.`) : new T(m.INVALID_ARGUMENT, `Invalid query. You cannot use '${e.op.toString()}' filters with '${n.toString()}' filters.`);
    }(t, c), c;
}

function pc(t, e, n) {
    if (null !== t.startAt) throw new T(m.INVALID_ARGUMENT, "Invalid query. You must not call startAt() or startAfter() before calling orderBy().");
    if (null !== t.endAt) throw new T(m.INVALID_ARGUMENT, "Invalid query. You must not call endAt() or endBefore() before calling orderBy().");
    const s = new bs(e, n);
    return function(t, e) {
        if (null === ts(t)) {
            // This is the first order by. It must match any inequality.
            const n = es(t);
            null !== n && Sc(t, n, e.field);
        }
    }(t, s), s;
}

/**
 * Create a Bound from a query and a document.
 *
 * Note that the Bound will always include the key of the document
 * and so only the provided document will compare equal to the returned
 * position.
 *
 * Will throw if the document does not contain all fields of the order by
 * of the query or if any of the fields in the order by are an uncommitted
 * server timestamp.
 */
/**
 * Parses the given documentIdValue into a ReferenceValue, throwing
 * appropriate errors if the value is anything other than a DocumentReference
 * or String, or if the string is malformed.
 */
function bc(t, e, n) {
    if ("string" == typeof n) {
        if ("" === n) throw new T(m.INVALID_ARGUMENT, "Invalid query. When querying with FieldPath.documentId(), you must provide a valid document ID, but it was an empty string.");
        if (!ns(e) && -1 !== n.indexOf("/")) throw new T(m.INVALID_ARGUMENT, `Invalid query. When querying a collection by FieldPath.documentId(), you must provide a plain document ID, but '${n}' contains a '/' character.`);
        const s = e.path.child(C.g(n));
        if (!x.F(s)) throw new T(m.INVALID_ARGUMENT, `Invalid query. When querying a collection group by FieldPath.documentId(), the value provided must result in a valid document path, but '${s}' is not because it has an odd number of segments (${s.length}).`);
        return Ee(t, new x(s));
    }
    if (n instanceof Ga) return Ee(t, n.f_);
    throw new T(m.INVALID_ARGUMENT, "Invalid query. When querying with FieldPath.documentId(), you must provide a valid string or a DocumentReference, but it was: " + z(n) + ".");
}

/**
 * Validates that the value passed into a disjunctive filter satisfies all
 * array requirements.
 */ function vc(t, e) {
    if (!Array.isArray(t) || 0 === t.length) throw new T(m.INVALID_ARGUMENT, `Invalid Query. A non-empty array is required for '${e.toString()}' filters.`);
    if (t.length > 10) throw new T(m.INVALID_ARGUMENT, `Invalid Query. '${e.toString()}' filters support a maximum of 10 elements in the value array.`);
    if ("in" /* IN */ === e || "array-contains-any" /* ARRAY_CONTAINS_ANY */ === e) {
        if (t.indexOf(null) >= 0) throw new T(m.INVALID_ARGUMENT, `Invalid Query. '${e.toString()}' filters cannot contain 'null' in the value array.`);
        if (t.filter((t => Number.isNaN(t))).length > 0) throw new T(m.INVALID_ARGUMENT, `Invalid Query. '${e.toString()}' filters cannot contain 'NaN' in the value array.`);
    }
}

function Sc(t, e, n) {
    if (!n.isEqual(e)) throw new T(m.INVALID_ARGUMENT, `Invalid query. You have a where filter with an inequality (<, <=, >, or >=) on field '${e.toString()}' and so you must also use '${e.toString()}' as your first orderBy(), but your first orderBy() is on field '${n.toString()}' instead.`);
}

function Dc(t) {
    if (Zn(t) && 0 === t.on.length) throw new T(m.UNIMPLEMENTED, "limitToLast() queries require specifying at least one orderBy() clause");
}

class Cc {
    constructor(t, e, n) {
        this.Ff = t, this.firestore = e, this.d_ = n;
    }
    where(t, e, n) {
        k("Query.where", arguments, 3), H("Query.where", 3, n);
        // Enumerated from the WhereFilterOp type in index.d.ts.
        const s = j("Query.where", [ "<" /* LESS_THAN */ , "<=" /* LESS_THAN_OR_EQUAL */ , "==" /* EQUAL */ , "!=" /* NOT_EQUAL */ , ">=" /* GREATER_THAN_OR_EQUAL */ , ">" /* GREATER_THAN */ , "array-contains" /* ARRAY_CONTAINS */ , "in" /* IN */ , "array-contains-any" /* ARRAY_CONTAINS_ANY */ , "not-in" /* NOT_IN */ ], 2, e), i = ac("Query.where", t), r = Vc(this.Ff, "Query.where", this.firestore.mf, this.firestore.__, i, s, n);
        return new Cc(function(t, e) {
            const n = t.filters.concat([ e ]);
            return new Hn(t.path, t.collectionGroup, t.on.slice(), n, t.limit, t.an, t.startAt, t.endAt);
        }(this.Ff, r), this.firestore, this.d_);
    }
    orderBy(t, e) {
        let n;
        if (O("Query.orderBy", arguments, 1, 2), B("Query.orderBy", "non-empty string", 2, e), 
        void 0 === e || "asc" === e) n = "asc" /* ASCENDING */; else {
            if ("desc" !== e) throw new T(m.INVALID_ARGUMENT, `Function Query.orderBy() has unknown direction '${e}', expected 'asc' or 'desc'.`);
            n = "desc" /* DESCENDING */;
        }
        const s = ac("Query.orderBy", t), i = pc(this.Ff, s, n);
        return new Cc(function(t, e) {
            // TODO(dimond): validate that orderBy does not list the same key twice.
            const n = t.on.concat([ e ]);
            return new Hn(t.path, t.collectionGroup, n, t.filters.slice(), t.limit, t.an, t.startAt, t.endAt);
        }(this.Ff, i), this.firestore, this.d_);
    }
    limit(t) {
        return k("Query.limit", arguments, 1), L("Query.limit", "number", 1, t), X("Query.limit", 1, t), 
        new Cc(rs(this.Ff, t, "F" /* First */), this.firestore, this.d_);
    }
    limitToLast(t) {
        return k("Query.limitToLast", arguments, 1), L("Query.limitToLast", "number", 1, t), 
        X("Query.limitToLast", 1, t), new Cc(rs(this.Ff, t, "L" /* Last */), this.firestore, this.d_);
    }
    startAt(t, ...e) {
        M("Query.startAt", arguments, 1);
        const n = this.xf("Query.startAt", t, e, 
        /*before=*/ !0);
        return new Cc(os(this.Ff, n), this.firestore, this.d_);
    }
    startAfter(t, ...e) {
        M("Query.startAfter", arguments, 1);
        const n = this.xf("Query.startAfter", t, e, 
        /*before=*/ !1);
        return new Cc(os(this.Ff, n), this.firestore, this.d_);
    }
    endBefore(t, ...e) {
        M("Query.endBefore", arguments, 1);
        const n = this.xf("Query.endBefore", t, e, 
        /*before=*/ !0);
        return new Cc(as(this.Ff, n), this.firestore, this.d_);
    }
    endAt(t, ...e) {
        M("Query.endAt", arguments, 1);
        const n = this.xf("Query.endAt", t, e, 
        /*before=*/ !1);
        return new Cc(as(this.Ff, n), this.firestore, this.d_);
    }
    isEqual(t) {
        if (!(t instanceof Cc)) throw J("isEqual", "Query", 1, t);
        return this.firestore === t.firestore && cs(this.Ff, t.Ff) && this.d_ === t.d_;
    }
    withConverter(t) {
        return new Cc(this.Ff, this.firestore, t);
    }
    /** Helper function to create a bound from a document or fields */    xf(t, e, n, s) {
        if (H(t, 1, e), e instanceof Pc) return k(t, [ e, ...n ], 1), function(t, e, n, s, i) {
            if (!s) throw new T(m.NOT_FOUND, "Can't use a DocumentSnapshot that doesn't exist for " + n + "().");
            const r = [];
            // Because people expect to continue/end a query at the exact document
            // provided, we need to use the implicit sort order rather than the explicit
            // sort order, because it's guaranteed to contain the document key. That way
            // the position becomes unambiguous and the query continues/ends exactly at
            // the provided document. Without the key (by using the explicit sort
            // orders), multiple documents could match the position, yielding duplicate
            // results.
                        for (const n of ss(t)) if (n.field.p()) r.push(Ee(e, s.key)); else {
                const t = s.field(n.field);
                if (ie(t)) throw new T(m.INVALID_ARGUMENT, 'Invalid query. You are trying to start or end a query using a document for which the field "' + n.field + '" is an uncommitted server timestamp. (Since the value of this field is unknown, you cannot start/end a query with it.)');
                if (null === t) {
                    const t = n.field.R();
                    throw new T(m.INVALID_ARGUMENT, `Invalid query. You are trying to start or end a query using a document for which the field '${t}' (used as the orderBy) does not exist.`);
                }
                r.push(t);
            }
            return new Ps(r, i);
        }
        /**
 * Converts a list of field values to a Bound for the given query.
 */ (this.Ff, this.firestore.__, t, e.Df, s);
        {
            const i = [ e ].concat(n);
            return function(t, e, n, s, i, r) {
                // Use explicit order by's because it has to match the query the user made
                const o = t.on;
                if (i.length > o.length) throw new T(m.INVALID_ARGUMENT, `Too many arguments provided to ${s}(). The number of arguments must be less than or equal to the number of orderBy() clauses`);
                const a = [];
                for (let r = 0; r < i.length; r++) {
                    const c = i[r];
                    if (o[r].field.p()) {
                        if ("string" != typeof c) throw new T(m.INVALID_ARGUMENT, `Invalid query. Expected a string for document ID in ${s}(), but got a ${typeof c}`);
                        if (!ns(t) && -1 !== c.indexOf("/")) throw new T(m.INVALID_ARGUMENT, `Invalid query. When querying a collection and ordering by FieldPath.documentId(), the value passed to ${s}() must be a plain document ID, but '${c}' contains a slash.`);
                        const n = t.path.child(C.g(c));
                        if (!x.F(n)) throw new T(m.INVALID_ARGUMENT, `Invalid query. When querying a collection group and ordering by FieldPath.documentId(), the value passed to ${s}() must result in a valid document path, but '${n}' is not because it contains an odd number of segments.`);
                        const i = new x(n);
                        a.push(Ee(e, i));
                    } else {
                        const t = nc(n, s, c);
                        a.push(t);
                    }
                }
                return new Ps(a, r);
            }(this.Ff, this.firestore.__, this.firestore.mf, t, i, s);
        }
    }
    onSnapshot(...t) {
        var e, n, s;
        O("Query.onSnapshot", arguments, 1, 4);
        let i = {}, r = 0;
        if ("object" != typeof t[r] || dc(t[r]) || (i = t[r], Y("Query.onSnapshot", i, [ "includeMetadataChanges" ]), 
        U("Query.onSnapshot", "boolean", "includeMetadataChanges", i.includeMetadataChanges), 
        r++), dc(t[r])) {
            const i = t[r];
            t[r] = null === (e = i.next) || void 0 === e ? void 0 : e.bind(i), t[r + 1] = null === (n = i.error) || void 0 === n ? void 0 : n.bind(i), 
            t[r + 2] = null === (s = i.complete) || void 0 === s ? void 0 : s.bind(i);
        } else L("Query.onSnapshot", "function", r, t[r]), B("Query.onSnapshot", "function", r + 1, t[r + 1]), 
        B("Query.onSnapshot", "function", r + 2, t[r + 2]);
        const o = {
            next: e => {
                t[r] && t[r](new Nc(this.firestore, this.Ff, e, this.d_));
            },
            error: t[r + 1],
            complete: t[r + 2]
        };
        Dc(this.Ff);
        return this.firestore.hf().listen(this.Ff, i, o);
    }
    get(t) {
        O("Query.get", arguments, 0, 1), kc("Query.get", t), Dc(this.Ff);
        const e = this.firestore.hf();
        return (t && "cache" === t.source ? e.j_(this.Ff) : e.K_(this.Ff, t)).then((t => new Nc(this.firestore, this.Ff, t, this.d_)));
    }
}

class Nc {
    constructor(t, e, n, s) {
        this.yf = t, this.$f = e, this.kf = n, this.d_ = s, this.Mf = null, this.Of = null, 
        this.metadata = new gc(n.hasPendingWrites, n.fromCache);
    }
    get docs() {
        const t = [];
        return this.forEach((e => t.push(e))), t;
    }
    get empty() {
        return this.kf.docs.m();
    }
    get size() {
        return this.kf.docs.size;
    }
    forEach(t, e) {
        O("QuerySnapshot.forEach", arguments, 1, 2), L("QuerySnapshot.forEach", "function", 1, t), 
        this.kf.docs.forEach((n => {
            t.call(e, this.Lf(n, this.metadata.fromCache, this.kf.Wt.has(n.key)));
        }));
    }
    get query() {
        return new Cc(this.$f, this.yf, this.d_);
    }
    docChanges(t) {
        t && (Y("QuerySnapshot.docChanges", t, [ "includeMetadataChanges" ]), U("QuerySnapshot.docChanges", "boolean", "includeMetadataChanges", t.includeMetadataChanges));
        const e = !(!t || !t.includeMetadataChanges);
        if (e && this.kf.Kt) throw new T(m.INVALID_ARGUMENT, "To include metadata changes with your document changes, you must also pass { includeMetadataChanges:true } to onSnapshot().");
        return this.Mf && this.Of === e || (this.Mf = 
        /**
 * Calculates the array of DocumentChanges for a given ViewSnapshot.
 *
 * Exported for testing.
 *
 * @param snapshot The ViewSnapshot that represents the expected state.
 * @param includeMetadataChanges Whether to include metadata changes.
 * @param converter A factory function that returns a QueryDocumentSnapshot.
 * @return An object that matches the DocumentChange API.
 */
        function(t, e, n) {
            if (t.Qt.m()) {
                // Special case the first snapshot because index calculation is easy and
                // fast
                let e, s = 0;
                return t.docChanges.map((i => {
                    const r = n(i.doc, t.fromCache, t.Wt.has(i.doc.key));
                    return e = i.doc, {
                        type: "added",
                        doc: r,
                        oldIndex: -1,
                        newIndex: s++
                    };
                }));
            }
            {
                // A DocumentSet that is updated incrementally as changes are applied to use
                // to lookup the index of a document.
                let s = t.Qt;
                return t.docChanges.filter((t => e || 3 /* Metadata */ !== t.type)).map((e => {
                    const i = n(e.doc, t.fromCache, t.Wt.has(e.doc.key));
                    let r = -1, o = -1;
                    return 0 /* Added */ !== e.type && (r = s.indexOf(e.doc.key), s = s.delete(e.doc.key)), 
                    1 /* Removed */ !== e.type && (s = s.add(e.doc), o = s.indexOf(e.doc.key)), {
                        type: Oc(e.type),
                        doc: i,
                        oldIndex: r,
                        newIndex: o
                    };
                }));
            }
        }(this.kf, e, this.Lf.bind(this)), this.Of = e), this.Mf;
    }
    /** Check the equality. The call can be very expensive. */    isEqual(t) {
        if (!(t instanceof Nc)) throw J("isEqual", "QuerySnapshot", 1, t);
        return this.yf === t.yf && cs(this.$f, t.$f) && this.kf.isEqual(t.kf) && this.d_ === t.d_;
    }
    Lf(t, e, n) {
        return new yc(this.yf, t.key, t, e, n, this.d_);
    }
}

class Fc extends Cc {
    constructor(t, e, n) {
        if (super(Jn(t), e, n), this.Bf = t, t.length % 2 != 1) throw new T(m.INVALID_ARGUMENT, `Invalid collection reference. Collection references must have an odd number of segments, but ${t.R()} has ${t.length}`);
    }
    get id() {
        return this.Ff.path._();
    }
    get parent() {
        const t = this.Ff.path.h();
        return t.m() ? null : new Rc(new x(t), this.firestore, 
        /* converter= */ null);
    }
    get path() {
        return this.Ff.path.R();
    }
    doc(t) {
        O("CollectionReference.doc", arguments, 0, 1), 
        // We allow omission of 'pathString' but explicitly prohibit passing in both
        // 'undefined' and 'null'.
        0 === arguments.length && (t = nt.k()), L("CollectionReference.doc", "non-empty string", 1, t);
        const e = C.g(t);
        return Rc.Rf(this.Ff.path.child(e), this.firestore, this.d_);
    }
    add(t) {
        k("CollectionReference.add", arguments, 1);
        const e = this.d_ ? this.d_.toFirestore(t) : t;
        L("CollectionReference.add", "object", 1, e);
        const n = this.doc();
        // Call set() with the converted value directly to avoid calling toFirestore() a second time.
                return new Rc(n.f_, this.firestore, null).set(e).then((() => n));
    }
    withConverter(t) {
        return new Fc(this.Bf, this.firestore, t);
    }
}

function xc(t, e) {
    if (void 0 === e) return {
        merge: !1
    };
    if (Y(t, e, [ "merge", "mergeFields" ]), U(t, "boolean", "merge", e.merge), Q(t, "mergeFields", "a string or a FieldPath", e.mergeFields, (t => "string" == typeof t || t instanceof $a)), 
    void 0 !== e.mergeFields && void 0 !== e.merge) throw new T(m.INVALID_ARGUMENT, `Invalid options passed to function ${t}(): You cannot specify both "merge" and "mergeFields".`);
    return e;
}

function $c(t, e) {
    return void 0 === e ? {} : (Y(t, e, [ "serverTimestamps" ]), W(t, 0, "serverTimestamps", e.serverTimestamps, [ "estimate", "previous", "none" ]), 
    e);
}

function kc(t, e) {
    B(t, "object", 1, e), e && (Y(t, e, [ "source" ]), W(t, 0, "source", e.source, [ "default", "server", "cache" ]));
}

function Mc(t, e, n) {
    if (e instanceof Ga) {
        if (e.firestore !== n) throw new T(m.INVALID_ARGUMENT, "Provided document reference is from a different Firestore instance.");
        return e;
    }
    throw J(t, "DocumentReference", 1, e);
}

function Oc(t) {
    switch (t) {
      case 0 /* Added */ :
        return "added";

      case 2 /* Modified */ :
      case 3 /* Metadata */ :
        return "modified";

      case 1 /* Removed */ :
        return "removed";

      default:
        return y();
    }
}

/**
 * Converts custom model object of type T into DocumentData by applying the
 * converter if it exists.
 *
 * This function is used when converting user objects to DocumentData
 * because we want to provide the user with a more specific error message if
 * their set() or fails due to invalid data originating from a toFirestore()
 * call.
 */ function Lc(t, e, n) {
    let s;
    // Cast to `any` in order to satisfy the union type constraint on
    // toFirestore().
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    return s = t ? n && (n.merge || n.mergeFields) ? t.toFirestore(e, n) : t.toFirestore(e) : e, 
    s;
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
class Bc extends ja {
    static serverTimestamp() {
        $("FieldValue.serverTimestamp", arguments);
        const t = new Ba("serverTimestamp");
        return t.e_ = "FieldValue.serverTimestamp", new Bc(t);
    }
    static delete() {
        $("FieldValue.delete", arguments);
        const t = new Oa("deleteField");
        return t.e_ = "FieldValue.delete", new Bc(t);
    }
    static arrayUnion(...t) {
        M("FieldValue.arrayUnion", arguments, 1);
        const e = 
        /**
 * Returns a special value that can be used with {@link setDoc()} or {@link
 * updateDoc()} that tells the server to union the given elements with any array
 * value that already exists on the server. Each specified element that doesn't
 * already exist in the array will be added to the end. If the field being
 * modified is not already an array it will be overwritten with an array
 * containing exactly the specified elements.
 *
 * @param elements The elements to union into the array.
 * @return The `FieldValue` sentinel for use in a call to `setDoc()` or
 * `updateDoc()`.
 */
        function(...t) {
            // NOTE: We don't actually parse the data until it's used in set() or
            // update() since we'd need the Firestore instance to do this.
            return M("arrayUnion()", arguments, 1), new qa("arrayUnion", t);
        }
        /**
 * Returns a special value that can be used with {@link setDoc()} or {@link
 * updateDoc()} that tells the server to remove the given elements from any
 * array value that already exists on the server. All instances of each element
 * specified will be removed from the array. If the field being modified is not
 * already an array it will be overwritten with an empty array.
 *
 * @param elements The elements to remove from the array.
 * @return The `FieldValue` sentinel for use in a call to `setDoc()` or
 * `updateDoc()`
 */ (...t);
        return e.e_ = "FieldValue.arrayUnion", new Bc(e);
    }
    static arrayRemove(...t) {
        M("FieldValue.arrayRemove", arguments, 1);
        const e = function(...t) {
            // NOTE: We don't actually parse the data until it's used in set() or
            // update() since we'd need the Firestore instance to do this.
            return M("arrayRemove()", arguments, 1), new Ua("arrayRemove", t);
        }
        /**
 * Returns a special value that can be used with {@link setDoc()} or {@link
 * updateDoc()} that tells the server to increment the field's current value by
 * the given value.
 *
 * If either the operand or the current field value uses floating point
 * precision, all arithmetic follows IEEE 754 semantics. If both values are
 * integers, values outside of JavaScript's safe number range
 * (`Number.MIN_SAFE_INTEGER` to `Number.MAX_SAFE_INTEGER`) are also subject to
 * precision loss. Furthermore, once processed by the Firestore backend, all
 * integer operations are capped between -2^63 and 2^63-1.
 *
 * If the current field value is not of type `number`, or if the field does not
 * yet exist, the transformation sets the field to the given value.
 *
 * @param n The value to increment by.
 * @return The `FieldValue` sentinel for use in a call to `setDoc()` or
 * `updateDoc()`
 */ (...t);
        return e.e_ = "FieldValue.arrayRemove", new Bc(e);
    }
    static increment(t) {
        L("FieldValue.increment", "number", 1, t), k("FieldValue.increment", arguments, 1);
        const e = function(t) {
            return new Qa("increment", t);
        }(t);
        return e.e_ = "FieldValue.increment", new Bc(e);
    }
    isEqual(t) {
        return this.l_.isEqual(t.l_);
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ const qc = {
    Firestore: Ec,
    GeoPoint: Wa,
    Timestamp: dt,
    Blob: ht,
    Transaction: Ic,
    WriteBatch: Ac,
    DocumentReference: Rc,
    DocumentSnapshot: Pc,
    Query: Cc,
    QueryDocumentSnapshot: yc,
    QuerySnapshot: Nc,
    CollectionReference: Fc,
    FieldPath: $a,
    FieldValue: Bc,
    setLogLevel: Ec.setLogLevel,
    CACHE_SIZE_UNLIMITED: mc
};

/**
 * Configures Firestore as part of the Firebase SDK by calling registerService.
 *
 * @param firebase The FirebaseNamespace to register Firestore with
 * @param firestoreFactory A factory function that returns a new Firestore
 *    instance.
 */
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Registers the main Firestore build with the components framework.
 * Persistence can be enabled via `firebase.firestore().enablePersistence()`.
 */
function Uc(t) {
    !function(t, e) {
        t.INTERNAL.registerComponent(new w("firestore", (t => {
            const n = t.getProvider("app").getImmediate();
            return e(n, t.getProvider("auth-internal"));
        }), "PUBLIC" /* PUBLIC */).setServiceProps(Object.assign({}, qc)));
    }(t, ((t, e) => {
        const n = new Na, s = new Ca(n);
        return new Ec(t, e, s, n);
    })), t.registerVersion("@firebase/firestore", "1.18.0");
}

Uc(t);

export { Uc as __PRIVATE_registerFirestore };
//# sourceMappingURL=index.esm2017.js.map
;