import { __extends as t, __awaiter as e, __generator as n, __spreadArrays as r } from "tslib";

import i from "@firebase/app";

import { Logger as o, LogLevel as s } from "@firebase/logger";

import { getUA as u, isMobileCordova as a, isReactNative as c, isElectron as h, isIE as f, isUWP as l, isBrowserExtension as p } from "@firebase/util";

import { XhrIo as d, EventType as v, ErrorCode as y, createWebChannelTransport as m, WebChannel as g } from "@firebase/webchannel-wrapper";

import { Component as w } from "@firebase/component";

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** Converts a Base64 encoded string to a binary string. */
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ var b = {
    // Causes are copied from:
    // https://github.com/grpc/grpc/blob/bceec94ea4fc5f0085d81235d8e1c06798dc341a/include/grpc%2B%2B/impl/codegen/status_code_enum.h
    /** Not an error; returned on success. */
    OK: "ok",
    /** The operation was cancelled (typically by the caller). */
    CANCELLED: "cancelled",
    /** Unknown error or an error from a different error domain. */
    UNKNOWN: "unknown",
    /**
     * Client specified an invalid argument. Note that this differs from
     * FAILED_PRECONDITION. INVALID_ARGUMENT indicates arguments that are
     * problematic regardless of the state of the system (e.g., a malformed file
     * name).
     */
    INVALID_ARGUMENT: "invalid-argument",
    /**
     * Deadline expired before operation could complete. For operations that
     * change the state of the system, this error may be returned even if the
     * operation has completed successfully. For example, a successful response
     * from a server could have been delayed long enough for the deadline to
     * expire.
     */
    DEADLINE_EXCEEDED: "deadline-exceeded",
    /** Some requested entity (e.g., file or directory) was not found. */
    NOT_FOUND: "not-found",
    /**
     * Some entity that we attempted to create (e.g., file or directory) already
     * exists.
     */
    ALREADY_EXISTS: "already-exists",
    /**
     * The caller does not have permission to execute the specified operation.
     * PERMISSION_DENIED must not be used for rejections caused by exhausting
     * some resource (use RESOURCE_EXHAUSTED instead for those errors).
     * PERMISSION_DENIED must not be used if the caller can not be identified
     * (use UNAUTHENTICATED instead for those errors).
     */
    PERMISSION_DENIED: "permission-denied",
    /**
     * The request does not have valid authentication credentials for the
     * operation.
     */
    UNAUTHENTICATED: "unauthenticated",
    /**
     * Some resource has been exhausted, perhaps a per-user quota, or perhaps the
     * entire file system is out of space.
     */
    RESOURCE_EXHAUSTED: "resource-exhausted",
    /**
     * Operation was rejected because the system is not in a state required for
     * the operation's execution. For example, directory to be deleted may be
     * non-empty, an rmdir operation is applied to a non-directory, etc.
     *
     * A litmus test that may help a service implementor in deciding
     * between FAILED_PRECONDITION, ABORTED, and UNAVAILABLE:
     *  (a) Use UNAVAILABLE if the client can retry just the failing call.
     *  (b) Use ABORTED if the client should retry at a higher-level
     *      (e.g., restarting a read-modify-write sequence).
     *  (c) Use FAILED_PRECONDITION if the client should not retry until
     *      the system state has been explicitly fixed. E.g., if an "rmdir"
     *      fails because the directory is non-empty, FAILED_PRECONDITION
     *      should be returned since the client should not retry unless
     *      they have first fixed up the directory by deleting files from it.
     *  (d) Use FAILED_PRECONDITION if the client performs conditional
     *      REST Get/Update/Delete on a resource and the resource on the
     *      server does not match the condition. E.g., conflicting
     *      read-modify-write on the same resource.
     */
    FAILED_PRECONDITION: "failed-precondition",
    /**
     * The operation was aborted, typically due to a concurrency issue like
     * sequencer check failures, transaction aborts, etc.
     *
     * See litmus test above for deciding between FAILED_PRECONDITION, ABORTED,
     * and UNAVAILABLE.
     */
    ABORTED: "aborted",
    /**
     * Operation was attempted past the valid range. E.g., seeking or reading
     * past end of file.
     *
     * Unlike INVALID_ARGUMENT, this error indicates a problem that may be fixed
     * if the system state changes. For example, a 32-bit file system will
     * generate INVALID_ARGUMENT if asked to read at an offset that is not in the
     * range [0,2^32-1], but it will generate OUT_OF_RANGE if asked to read from
     * an offset past the current file size.
     *
     * There is a fair bit of overlap between FAILED_PRECONDITION and
     * OUT_OF_RANGE. We recommend using OUT_OF_RANGE (the more specific error)
     * when it applies so that callers who are iterating through a space can
     * easily look for an OUT_OF_RANGE error to detect when they are done.
     */
    OUT_OF_RANGE: "out-of-range",
    /** Operation is not implemented or not supported/enabled in this service. */
    UNIMPLEMENTED: "unimplemented",
    /**
     * Internal errors. Means some invariants expected by underlying System has
     * been broken. If you see one of these errors, Something is very broken.
     */
    INTERNAL: "internal",
    /**
     * The service is currently unavailable. This is a most likely a transient
     * condition and may be corrected by retrying with a backoff.
     *
     * See litmus test above for deciding between FAILED_PRECONDITION, ABORTED,
     * and UNAVAILABLE.
     */
    UNAVAILABLE: "unavailable",
    /** Unrecoverable data loss or corruption. */
    DATA_LOSS: "data-loss"
}, I = /** @class */ function(e) {
    function n(t, n) {
        var r = this;
        return (r = e.call(this, n) || this).code = t, r.message = n, r.name = "FirebaseError", 
        // HACK: We write a toString property directly because Error is not a real
        // class and so inheritance does not work correctly. We could alternatively
        // do the same "back-door inheritance" trick that FirebaseError does.
        r.toString = function() {
            return r.name + ": [code=" + r.code + "]: " + r.message;
        }, r;
    }
    return t(n, e), n;
}(Error), E = new o("@firebase/firestore");

/** An error returned by a Firestore operation. */
// Helper methods are needed because variables can't be exported as read/write
function _() {
    return E.logLevel;
}

/**
 * Sets the verbosity of Cloud Firestore logs (debug, error, or silent).
 *
 * @param logLevel
 *   The verbosity you set for activity and error logging. Can be any of
 *   the following values:
 *
 *   <ul>
 *     <li>`debug` for the most verbose logging level, primarily for
 *     debugging.</li>
 *     <li>`error` to log errors only.</li>
 *     <li><code>`silent` to turn off logging.</li>
 *   </ul>
 */ function T(t) {
    for (var e = [], n = 1; n < arguments.length; n++) e[n - 1] = arguments[n];
    if (E.logLevel <= s.DEBUG) {
        var i = e.map(S);
        E.debug.apply(E, r([ "Firestore (7.24.0): " + t ], i));
    }
}

function N(t) {
    for (var e = [], n = 1; n < arguments.length; n++) e[n - 1] = arguments[n];
    if (E.logLevel <= s.ERROR) {
        var i = e.map(S);
        E.error.apply(E, r([ "Firestore (7.24.0): " + t ], i));
    }
}

function A(t) {
    for (var e = [], n = 1; n < arguments.length; n++) e[n - 1] = arguments[n];
    if (E.logLevel <= s.WARN) {
        var i = e.map(S);
        E.warn.apply(E, r([ "Firestore (7.24.0): " + t ], i));
    }
}

/**
 * Converts an additional log parameter to a string representation.
 */ function S(t) {
    if ("string" == typeof t) return t;
    try {
        return e = t, JSON.stringify(e);
    } catch (e) {
        // Converting to JSON failed, just log the object directly
        return t;
    }
    /**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
    /** Formats an object as a JSON string, suitable for logging. */    var e;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Unconditionally fails, throwing an Error with the given message.
 * Messages are stripped in production builds.
 *
 * Returns `never` and can be used in expressions:
 * @example
 * let futureVar = fail('not implemented yet');
 */ function D(t) {
    void 0 === t && (t = "Unexpected state");
    // Log the failure in addition to throw an exception, just in case the
    // exception is swallowed.
        var e = "FIRESTORE (7.24.0) INTERNAL ASSERTION FAILED: " + t;
    // NOTE: We don't use FirestoreError here because these are internal failures
    // that cannot be handled by the user. (Also it would create a circular
    // dependency between the error and assert modules which doesn't work.)
        throw N(e), new Error(e)
    /**
 * Fails if the given assertion condition is false, throwing an Error with the
 * given message if it did.
 *
 * Messages are stripped in production builds.
 */;
}

function k(t, e) {
    t || D();
}

/**
 * Casts `obj` to `T`. In non-production builds, verifies that `obj` is an
 * instance of `T` before casting.
 */ function x(t, 
// eslint-disable-next-line @typescript-eslint/no-explicit-any
e) {
    return t;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ function L(t) {
    var e = 0;
    for (var n in t) Object.prototype.hasOwnProperty.call(t, n) && e++;
    return e;
}

function R(t, e) {
    for (var n in t) Object.prototype.hasOwnProperty.call(t, n) && e(n, t[n]);
}

function O(t) {
    for (var e in t) if (Object.prototype.hasOwnProperty.call(t, e)) return !1;
    return !0;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Path represents an ordered sequence of string segments.
 */ var P = /** @class */ function() {
    function t(t, e, n) {
        void 0 === e ? e = 0 : e > t.length && D(), void 0 === n ? n = t.length - e : n > t.length - e && D(), 
        this.segments = t, this.offset = e, this.t = n;
    }
    return Object.defineProperty(t.prototype, "length", {
        get: function() {
            return this.t;
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.isEqual = function(e) {
        return 0 === t.i(this, e);
    }, t.prototype.child = function(e) {
        var n = this.segments.slice(this.offset, this.limit());
        return e instanceof t ? e.forEach((function(t) {
            n.push(t);
        })) : n.push(e), this.o(n);
    }, 
    /** The index of one past the last segment of the path. */ t.prototype.limit = function() {
        return this.offset + this.length;
    }, t.prototype.u = function(t) {
        return t = void 0 === t ? 1 : t, this.o(this.segments, this.offset + t, this.length - t);
    }, t.prototype.h = function() {
        return this.o(this.segments, this.offset, this.length - 1);
    }, t.prototype.l = function() {
        return this.segments[this.offset];
    }, t.prototype._ = function() {
        return this.get(this.length - 1);
    }, t.prototype.get = function(t) {
        return this.segments[this.offset + t];
    }, t.prototype.m = function() {
        return 0 === this.length;
    }, t.prototype.T = function(t) {
        if (t.length < this.length) return !1;
        for (var e = 0; e < this.length; e++) if (this.get(e) !== t.get(e)) return !1;
        return !0;
    }, t.prototype.I = function(t) {
        if (this.length + 1 !== t.length) return !1;
        for (var e = 0; e < this.length; e++) if (this.get(e) !== t.get(e)) return !1;
        return !0;
    }, t.prototype.forEach = function(t) {
        for (var e = this.offset, n = this.limit(); e < n; e++) t(this.segments[e]);
    }, t.prototype.A = function() {
        return this.segments.slice(this.offset, this.limit());
    }, t.i = function(t, e) {
        for (var n = Math.min(t.length, e.length), r = 0; r < n; r++) {
            var i = t.get(r), o = e.get(r);
            if (i < o) return -1;
            if (i > o) return 1;
        }
        return t.length < e.length ? -1 : t.length > e.length ? 1 : 0;
    }, t;
}(), V = /** @class */ function(e) {
    function n() {
        return null !== e && e.apply(this, arguments) || this;
    }
    return t(n, e), n.prototype.o = function(t, e, r) {
        return new n(t, e, r);
    }, n.prototype.R = function() {
        // NOTE: The client is ignorant of any path segments containing escape
        // sequences (e.g. __id123__) and just passes them through raw (they exist
        // for legacy reasons and should not be used frequently).
        return this.A().join("/");
    }, n.prototype.toString = function() {
        return this.R();
    }, 
    /**
     * Creates a resource path from the given slash-delimited string. If multiple
     * arguments are provided, all components are combined. Leading and trailing
     * slashes from all components are ignored.
     */
    n.g = function() {
        for (var t = [], e = 0; e < arguments.length; e++) t[e] = arguments[e];
        // NOTE: The client is ignorant of any path segments containing escape
        // sequences (e.g. __id123__) and just passes them through raw (they exist
        // for legacy reasons and should not be used frequently).
                for (var r = [], i = 0, o = t; i < o.length; i++) {
            var s = o[i];
            if (s.indexOf("//") >= 0) throw new I(b.INVALID_ARGUMENT, "Invalid segment (" + s + "). Paths must not contain // in them.");
            // Strip leading and traling slashed.
                        r.push.apply(r, s.split("/").filter((function(t) {
                return t.length > 0;
            })));
        }
        return new n(r);
    }, n.P = function() {
        return new n([]);
    }, n;
}(P), U = /^[_a-zA-Z][_a-zA-Z0-9]*$/, C = /** @class */ function(e) {
    function n() {
        return null !== e && e.apply(this, arguments) || this;
    }
    return t(n, e), n.prototype.o = function(t, e, r) {
        return new n(t, e, r);
    }, 
    /**
     * Returns true if the string could be used as a segment in a field path
     * without escaping.
     */
    n.V = function(t) {
        return U.test(t);
    }, n.prototype.R = function() {
        return this.A().map((function(t) {
            return t = t.replace("\\", "\\\\").replace("`", "\\`"), n.V(t) || (t = "`" + t + "`"), 
            t;
        })).join(".");
    }, n.prototype.toString = function() {
        return this.R();
    }, 
    /**
     * Returns true if this field references the key of a document.
     */
    n.prototype.p = function() {
        return 1 === this.length && "__name__" === this.get(0);
    }, 
    /**
     * The field designating the key of a document.
     */
    n.v = function() {
        return new n([ "__name__" ]);
    }, 
    /**
     * Parses a field string from the given server-formatted string.
     *
     * - Splitting the empty string is not allowed (for now at least).
     * - Empty segments within the string (e.g. if there are two consecutive
     *   separators) are not allowed.
     *
     * TODO(b/37244157): we should make this more strict. Right now, it allows
     * non-identifier path components, even if they aren't escaped.
     */
    n.S = function(t) {
        for (var e = [], r = "", i = 0, o = function() {
            if (0 === r.length) throw new I(b.INVALID_ARGUMENT, "Invalid field path (" + t + "). Paths must not be empty, begin with '.', end with '.', or contain '..'");
            e.push(r), r = "";
        }, s = !1; i < t.length; ) {
            var u = t[i];
            if ("\\" === u) {
                if (i + 1 === t.length) throw new I(b.INVALID_ARGUMENT, "Path has trailing escape character: " + t);
                var a = t[i + 1];
                if ("\\" !== a && "." !== a && "`" !== a) throw new I(b.INVALID_ARGUMENT, "Path has invalid escape sequence: " + t);
                r += a, i += 2;
            } else "`" === u ? (s = !s, i++) : "." !== u || s ? (r += u, i++) : (o(), i++);
        }
        if (o(), s) throw new I(b.INVALID_ARGUMENT, "Unterminated ` in path: " + t);
        return new n(e);
    }, n.P = function() {
        return new n([]);
    }, n;
}(P), F = /** @class */ function() {
    function t(t) {
        this.path = t;
    }
    return t.D = function(e) {
        return new t(V.g(e));
    }, t.C = function(e) {
        return new t(V.g(e).u(5));
    }, 
    /** Returns true if the document is in the specified collectionId. */ t.prototype.N = function(t) {
        return this.path.length >= 2 && this.path.get(this.path.length - 2) === t;
    }, t.prototype.isEqual = function(t) {
        return null !== t && 0 === V.i(this.path, t.path);
    }, t.prototype.toString = function() {
        return this.path.toString();
    }, t.i = function(t, e) {
        return V.i(t.path, e.path);
    }, t.F = function(t) {
        return t.length % 2 == 0;
    }, 
    /**
     * Creates and returns a new document key with the given segments.
     *
     * @param segments The segments of the path to the document
     * @return A new instance of DocumentKey
     */
    t.$ = function(e) {
        return new t(new V(e.slice()));
    }, t;
}();

/**
 * A slash-separated path for navigating resources (documents and collections)
 * within Firestore.
 */
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Validates that no arguments were passed in the invocation of functionName.
 *
 * Forward the magic "arguments" variable as second parameter on which the
 * parameter validation is performed:
 * validateNoArgs('myFunction', arguments);
 */
function M(t, e) {
    if (0 !== e.length) throw new I(b.INVALID_ARGUMENT, "Function " + t + "() does not support arguments, but was called with " + rt(e.length, "argument") + ".");
}

/**
 * Validates the invocation of functionName has the exact number of arguments.
 *
 * Forward the magic "arguments" variable as second parameter on which the
 * parameter validation is performed:
 * validateExactNumberOfArgs('myFunction', arguments, 2);
 */ function q(t, e, n) {
    if (e.length !== n) throw new I(b.INVALID_ARGUMENT, "Function " + t + "() requires " + rt(n, "argument") + ", but was called with " + rt(e.length, "argument") + ".");
}

/**
 * Validates the invocation of functionName has at least the provided number of
 * arguments (but can have many more).
 *
 * Forward the magic "arguments" variable as second parameter on which the
 * parameter validation is performed:
 * validateAtLeastNumberOfArgs('myFunction', arguments, 2);
 */ function j(t, e, n) {
    if (e.length < n) throw new I(b.INVALID_ARGUMENT, "Function " + t + "() requires at least " + rt(n, "argument") + ", but was called with " + rt(e.length, "argument") + ".");
}

/**
 * Validates the invocation of functionName has number of arguments between
 * the values provided.
 *
 * Forward the magic "arguments" variable as second parameter on which the
 * parameter validation is performed:
 * validateBetweenNumberOfArgs('myFunction', arguments, 2, 3);
 */ function G(t, e, n, r) {
    if (e.length < n || e.length > r) throw new I(b.INVALID_ARGUMENT, "Function " + t + "() requires between " + n + " and " + r + " arguments, but was called with " + rt(e.length, "argument") + ".");
}

/**
 * Validates the provided argument is an array and has as least the expected
 * number of elements.
 */
/**
 * Validates the provided positional argument has the native JavaScript type
 * using typeof checks.
 */ function z(t, e, n, r) {
    Y(t, e, nt(n) + " argument", r);
}

/**
 * Validates the provided argument has the native JavaScript type using
 * typeof checks or is undefined.
 */ function B(t, e, n, r) {
    void 0 !== r && z(t, e, n, r);
}

/**
 * Validates the provided named option has the native JavaScript type using
 * typeof checks.
 */ function K(t, e, n, r) {
    Y(t, e, n + " option", r);
}

/**
 * Validates the provided named option has the native JavaScript type using
 * typeof checks or is undefined.
 */ function W(t, e, n, r) {
    void 0 !== r && K(t, e, n, r);
}

/**
 * Validates that two boolean options are not set at the same time.
 */
/**
 * Validates that the provided named option equals one of the expected values.
 */
/**
 * Validates that the provided named option equals one of the expected values or
 * is undefined.
 */
function Q(t, e, n, r, i) {
    void 0 !== r && function(t, e, n, r, i) {
        for (var o = [], s = 0, u = i; s < u.length; s++) {
            var a = u[s];
            if (a === r) return;
            o.push(X(a));
        }
        var c = X(r);
        throw new I(b.INVALID_ARGUMENT, "Invalid value " + c + " provided to function " + t + '() for option "' + n + '". Acceptable values: ' + o.join(", "));
    }(t, 0, n, r, i);
}

/**
 * Validates that the provided argument is a valid enum.
 *
 * @param functionName Function making the validation call.
 * @param enums Array containing all possible values for the enum.
 * @param position Position of the argument in `functionName`.
 * @param argument Argument to validate.
 * @return The value as T if the argument can be converted.
 */ function H(t, e, n, r) {
    if (!e.some((function(t) {
        return t === r;
    }))) throw new I(b.INVALID_ARGUMENT, "Invalid value " + X(r) + " provided to function " + t + "() for its " + nt(n) + " argument. Acceptable values: " + e.join(", "));
    return r;
}

/** Helper to validate the type of a provided input. */ function Y(t, e, n, r) {
    if (!("object" === e ? $(r) : "non-empty string" === e ? "string" == typeof r && "" !== r : typeof r === e)) {
        var i = X(r);
        throw new I(b.INVALID_ARGUMENT, "Function " + t + "() requires its " + n + " to be of type " + e + ", but it was: " + i);
    }
}

/**
 * Returns true if it's a non-null object without a custom prototype
 * (i.e. excludes Array, Date, etc.).
 */ function $(t) {
    return "object" == typeof t && null !== t && (Object.getPrototypeOf(t) === Object.prototype || null === Object.getPrototypeOf(t));
}

/** Returns a string describing the type / value of the provided input. */ function X(t) {
    if (void 0 === t) return "undefined";
    if (null === t) return "null";
    if ("string" == typeof t) return t.length > 20 && (t = t.substring(0, 20) + "..."), 
    JSON.stringify(t);
    if ("number" == typeof t || "boolean" == typeof t) return "" + t;
    if ("object" == typeof t) {
        if (t instanceof Array) return "an array";
        var e = 
        /** Hacky method to try to get the constructor name for an object. */
        function(t) {
            if (t.constructor) {
                var e = /function\s+([^\s(]+)\s*\(/.exec(t.constructor.toString());
                if (e && e.length > 1) return e[1];
            }
            return null;
        }(t);
        return e ? "a custom " + e + " object" : "an object";
    }
    return "function" == typeof t ? "a function" : D();
}

function J(t, e, n) {
    if (void 0 === n) throw new I(b.INVALID_ARGUMENT, "Function " + t + "() requires a valid " + nt(e) + " argument, but it was undefined.");
}

/**
 * Validates the provided positional argument is an object, and its keys and
 * values match the expected keys and types provided in optionTypes.
 */ function Z(t, e, n) {
    R(e, (function(e, r) {
        if (n.indexOf(e) < 0) throw new I(b.INVALID_ARGUMENT, "Unknown option '" + e + "' passed to function " + t + "(). Available options: " + n.join(", "));
    }));
}

/**
 * Helper method to throw an error that the provided argument did not pass
 * an instanceof check.
 */ function tt(t, e, n, r) {
    var i = X(r);
    return new I(b.INVALID_ARGUMENT, "Function " + t + "() requires its " + nt(n) + " argument to be a " + e + ", but it was: " + i);
}

function et(t, e, n) {
    if (n <= 0) throw new I(b.INVALID_ARGUMENT, "Function " + t + "() requires its " + nt(e) + " argument to be a positive number, but it was: " + n + ".");
}

/** Converts a number to its english word representation */ function nt(t) {
    switch (t) {
      case 1:
        return "first";

      case 2:
        return "second";

      case 3:
        return "third";

      default:
        return t + "th";
    }
}

/**
 * Formats the given word as plural conditionally given the preceding number.
 */ function rt(t, e) {
    return t + " " + e + (1 === t ? "" : "s");
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Generates `nBytes` of random bytes.
 *
 * If `nBytes < 0` , an error will be thrown.
 */ function it(t) {
    // Polyfills for IE and WebWorker by using `self` and `msCrypto` when `crypto` is not available.
    var e = 
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    "undefined" != typeof self && (self.crypto || self.msCrypto), n = new Uint8Array(t);
    if (e && "function" == typeof e.getRandomValues) e.getRandomValues(n); else 
    // Falls back to Math.random
    for (var r = 0; r < t; r++) n[r] = Math.floor(256 * Math.random());
    return n;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ var ot = /** @class */ function() {
    function t() {}
    return t.k = function() {
        for (
        // Alphanumeric characters
        var t = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", e = Math.floor(256 / t.length) * t.length, n = ""
        // The largest byte value that is a multiple of `char.length`.
        ; n.length < 20; ) for (var r = it(40), i = 0; i < r.length; ++i) 
        // Only accept values that are [0, maxMultiple), this ensures they can
        // be evenly mapped to indices of `chars` via a modulo operation.
        n.length < 20 && r[i] < e && (n += t.charAt(r[i] % t.length));
        return n;
    }, t;
}();

function st(t, e) {
    return t < e ? -1 : t > e ? 1 : 0;
}

/** Helper to compare arrays using isEqual(). */ function ut(t, e, n) {
    return t.length === e.length && t.every((function(t, r) {
        return n(t, e[r]);
    }));
}

/**
 * Returns the immediate lexicographically-following string. This is useful to
 * construct an inclusive range for indexeddb iterators.
 */ function at(t) {
    // Return the input string, with an additional NUL byte appended.
    return t + "\0";
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Immutable class that represents a "proto" byte string.
 *
 * Proto byte strings can either be Base64-encoded strings or Uint8Arrays when
 * sent on the wire. This class abstracts away this differentiation by holding
 * the proto byte string in a common class that must be converted into a string
 * before being sent as a proto.
 */ var ct = /** @class */ function() {
    function t(t) {
        this.M = t;
    }
    return t.fromBase64String = function(e) {
        return new t(atob(e));
    }, t.fromUint8Array = function(e) {
        return new t(
        /**
 * Helper function to convert an Uint8array to a binary string.
 */
        function(t) {
            for (var e = "", n = 0; n < t.length; ++n) e += String.fromCharCode(t[n]);
            return e;
        }(e));
    }, t.prototype.toBase64 = function() {
        return t = this.M, btoa(t);
        /** Converts a binary string to a Base64 encoded string. */        var t;
        /** True if and only if the Base64 conversion functions are available. */    }, 
    t.prototype.toUint8Array = function() {
        return function(t) {
            for (var e = new Uint8Array(t.length), n = 0; n < t.length; n++) e[n] = t.charCodeAt(n);
            return e;
        }(this.M);
    }, t.prototype.O = function() {
        return 2 * this.M.length;
    }, t.prototype.L = function(t) {
        return st(this.M, t.M);
    }, t.prototype.isEqual = function(t) {
        return this.M === t.M;
    }, t;
}();

ct.B = new ct("");

var ht = /** @class */ function() {
    function t(t) {
        this.q = t;
    }
    /**
     * Creates a new `Bytes` object from the given Base64 string, converting it to
     * bytes.
     *
     * @param base64 The Base64 string used to create the `Bytes` object.
     */    return t.fromBase64String = function(e) {
        try {
            return new t(ct.fromBase64String(e));
        } catch (e) {
            throw new I(b.INVALID_ARGUMENT, "Failed to construct Bytes from Base64 string: " + e);
        }
    }, 
    /**
     * Creates a new `Bytes` object from the given Uint8Array.
     *
     * @param array The Uint8Array used to create the `Bytes` object.
     */
    t.fromUint8Array = function(e) {
        return new t(ct.fromUint8Array(e));
    }, 
    /**
     * Returns the underlying bytes as a Base64-encoded string.
     *
     * @return The Base64-encoded string created from the `Bytes` object.
     */
    t.prototype.toBase64 = function() {
        return this.q.toBase64();
    }, 
    /**
     * Returns the underlying bytes in a new `Uint8Array`.
     *
     * @return The Uint8Array created from the `Bytes` object.
     */
    t.prototype.toUint8Array = function() {
        return this.q.toUint8Array();
    }, 
    /**
     * Returns a string representation of the `Bytes` object.
     *
     * @return A string representation of the `Bytes` object.
     */
    t.prototype.toString = function() {
        return "Bytes(base64: " + this.toBase64() + ")";
    }, 
    /**
     * Returns true if this `Bytes` object is equal to the provided one.
     *
     * @param other The `Bytes` object to compare against.
     * @return true if this `Bytes` object is equal to the provided one.
     */
    t.prototype.isEqual = function(t) {
        return this.q.isEqual(t.q);
    }, t;
}();

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** Helper function to assert Uint8Array is available at runtime. */ function ft() {
    if ("undefined" == typeof Uint8Array) throw new I(b.UNIMPLEMENTED, "Uint8Arrays are not available in this environment.");
}

/** Helper function to assert Base64 functions are available at runtime. */ function lt() {
    if ("undefined" == typeof atob) throw new I(b.UNIMPLEMENTED, "Blobs are unavailable in Firestore in this environment.");
}

/**
 * Immutable class holding a blob (binary data).
 *
 * This class is directly exposed in the public API. It extends the Bytes class
 * of the firestore-exp API to support `instanceof Bytes` checks during user
 * data conversion.
 *
 * Note that while you can't hide the constructor in JavaScript code, we are
 * using the hack above to make sure no-one outside this module can call it.
 */ var pt = /** @class */ function(e) {
    function n() {
        return null !== e && e.apply(this, arguments) || this;
    }
    return t(n, e), n.fromBase64String = function(t) {
        q("Blob.fromBase64String", arguments, 1), z("Blob.fromBase64String", "string", 1, t), 
        lt();
        try {
            return new n(ct.fromBase64String(t));
        } catch (t) {
            throw new I(b.INVALID_ARGUMENT, "Failed to construct Blob from Base64 string: " + t);
        }
    }, n.fromUint8Array = function(t) {
        if (q("Blob.fromUint8Array", arguments, 1), ft(), !(t instanceof Uint8Array)) throw tt("Blob.fromUint8Array", "Uint8Array", 1, t);
        return new n(ct.fromUint8Array(t));
    }, n.prototype.toBase64 = function() {
        return q("Blob.toBase64", arguments, 0), lt(), e.prototype.toBase64.call(this);
    }, n.prototype.toUint8Array = function() {
        return q("Blob.toUint8Array", arguments, 0), ft(), e.prototype.toUint8Array.call(this);
    }, n.prototype.toString = function() {
        return "Blob(base64: " + this.toBase64() + ")";
    }, n;
}(ht), dt = 
/**
     * Constructs a DatabaseInfo using the provided host, databaseId and
     * persistenceKey.
     *
     * @param databaseId The database to use.
     * @param persistenceKey A unique identifier for this Firestore's local
     * storage (used in conjunction with the databaseId).
     * @param host The Firestore backend host to connect to.
     * @param ssl Whether to use SSL when connecting.
     * @param forceLongPolling Whether to use the forceLongPolling option
     * when using WebChannel as the network transport.
     * @param autoDetectLongPolling Whether to use the detectBufferingProxy
     * option when using WebChannel as the network transport.
     */
function(t, e, n, r, i, o) {
    this.U = t, this.persistenceKey = e, this.host = n, this.ssl = r, this.forceLongPolling = i, 
    this.W = o;
}, vt = /** @class */ function() {
    function t(t, e) {
        this.projectId = t, this.database = e || "(default)";
    }
    return Object.defineProperty(t.prototype, "j", {
        get: function() {
            return "(default)" === this.database;
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.isEqual = function(e) {
        return e instanceof t && e.projectId === this.projectId && e.database === this.database;
    }, t.prototype.L = function(t) {
        return st(this.projectId, t.projectId) || st(this.database, t.database);
    }, t;
}(), yt = /** @class */ function() {
    function t(t, e) {
        this.K = t, this.G = e, 
        /**
             * The inner map for a key -> value pair. Due to the possibility of
             * collisions we keep a list of entries that we do a linear search through
             * to find an actual match. Note that collisions should be rare, so we still
             * expect near constant time lookups in practice.
             */
        this.H = {}
        /** Get a value for this key, or undefined if it does not exist. */;
    }
    return t.prototype.get = function(t) {
        var e = this.K(t), n = this.H[e];
        if (void 0 !== n) for (var r = 0, i = n; r < i.length; r++) {
            var o = i[r], s = o[0], u = o[1];
            if (this.G(s, t)) return u;
        }
    }, t.prototype.has = function(t) {
        return void 0 !== this.get(t);
    }, 
    /** Put this key and value in the map. */ t.prototype.set = function(t, e) {
        var n = this.K(t), r = this.H[n];
        if (void 0 !== r) {
            for (var i = 0; i < r.length; i++) if (this.G(r[i][0], t)) return void (r[i] = [ t, e ]);
            r.push([ t, e ]);
        } else this.H[n] = [ [ t, e ] ];
    }, 
    /**
     * Remove this key from the map. Returns a boolean if anything was deleted.
     */
    t.prototype.delete = function(t) {
        var e = this.K(t), n = this.H[e];
        if (void 0 === n) return !1;
        for (var r = 0; r < n.length; r++) if (this.G(n[r][0], t)) return 1 === n.length ? delete this.H[e] : n.splice(r, 1), 
        !0;
        return !1;
    }, t.prototype.forEach = function(t) {
        R(this.H, (function(e, n) {
            for (var r = 0, i = n; r < i.length; r++) {
                var o = i[r], s = o[0], u = o[1];
                t(s, u);
            }
        }));
    }, t.prototype.m = function() {
        return O(this.H);
    }, t;
}(), mt = /** @class */ function() {
    /**
     * Creates a new timestamp.
     *
     * @param seconds The number of seconds of UTC time since Unix epoch
     *     1970-01-01T00:00:00Z. Must be from 0001-01-01T00:00:00Z to
     *     9999-12-31T23:59:59Z inclusive.
     * @param nanoseconds The non-negative fractions of a second at nanosecond
     *     resolution. Negative second values with fractions must still have
     *     non-negative nanoseconds values that count forward in time. Must be
     *     from 0 to 999,999,999 inclusive.
     */
    function t(t, e) {
        if (this.seconds = t, this.nanoseconds = e, e < 0) throw new I(b.INVALID_ARGUMENT, "Timestamp nanoseconds out of range: " + e);
        if (e >= 1e9) throw new I(b.INVALID_ARGUMENT, "Timestamp nanoseconds out of range: " + e);
        if (t < -62135596800) throw new I(b.INVALID_ARGUMENT, "Timestamp seconds out of range: " + t);
        // This will break in the year 10,000.
                if (t >= 253402300800) throw new I(b.INVALID_ARGUMENT, "Timestamp seconds out of range: " + t);
    }
    /**
     * Creates a new timestamp with the current date, with millisecond precision.
     *
     * @return a new timestamp representing the current date.
     */    return t.now = function() {
        return t.fromMillis(Date.now());
    }, 
    /**
     * Creates a new timestamp from the given date.
     *
     * @param date The date to initialize the `Timestamp` from.
     * @return A new `Timestamp` representing the same point in time as the given
     *     date.
     */
    t.fromDate = function(e) {
        return t.fromMillis(e.getTime());
    }, 
    /**
     * Creates a new timestamp from the given number of milliseconds.
     *
     * @param milliseconds Number of milliseconds since Unix epoch
     *     1970-01-01T00:00:00Z.
     * @return A new `Timestamp` representing the same point in time as the given
     *     number of milliseconds.
     */
    t.fromMillis = function(e) {
        var n = Math.floor(e / 1e3);
        return new t(n, 1e6 * (e - 1e3 * n));
    }, 
    /**
     * Converts a `Timestamp` to a JavaScript `Date` object. This conversion causes
     * a loss of precision since `Date` objects only support millisecond precision.
     *
     * @return JavaScript `Date` object representing the same point in time as
     *     this `Timestamp`, with millisecond precision.
     */
    t.prototype.toDate = function() {
        return new Date(this.toMillis());
    }, 
    /**
     * Converts a `Timestamp` to a numeric timestamp (in milliseconds since
     * epoch). This operation causes a loss of precision.
     *
     * @return The point in time corresponding to this timestamp, represented as
     *     the number of milliseconds since Unix epoch 1970-01-01T00:00:00Z.
     */
    t.prototype.toMillis = function() {
        return 1e3 * this.seconds + this.nanoseconds / 1e6;
    }, t.prototype.Y = function(t) {
        return this.seconds === t.seconds ? st(this.nanoseconds, t.nanoseconds) : st(this.seconds, t.seconds);
    }, 
    /**
     * Returns true if this `Timestamp` is equal to the provided one.
     *
     * @param other The `Timestamp` to compare against.
     * @return true if this `Timestamp` is equal to the provided one.
     */
    t.prototype.isEqual = function(t) {
        return t.seconds === this.seconds && t.nanoseconds === this.nanoseconds;
    }, t.prototype.toString = function() {
        return "Timestamp(seconds=" + this.seconds + ", nanoseconds=" + this.nanoseconds + ")";
    }, t.prototype.toJSON = function() {
        return {
            seconds: this.seconds,
            nanoseconds: this.nanoseconds
        };
    }, 
    /**
     * Converts this object to a primitive string, which allows Timestamp objects to be compared
     * using the `>`, `<=`, `>=` and `>` operators.
     */
    t.prototype.valueOf = function() {
        // This method returns a string of the form <seconds>.<nanoseconds> where <seconds> is
        // translated to have a non-negative value and both <seconds> and <nanoseconds> are left-padded
        // with zeroes to be a consistent length. Strings with this format then have a lexiographical
        // ordering that matches the expected ordering. The <seconds> translation is done to avoid
        // having a leading negative sign (i.e. a leading '-' character) in its string representation,
        // which would affect its lexiographical ordering.
        var t = this.seconds - -62135596800;
        // Note: Up to 12 decimal digits are required to represent all valid 'seconds' values.
                return String(t).padStart(12, "0") + "." + String(this.nanoseconds).padStart(9, "0");
    }, t;
}(), gt = /** @class */ function() {
    function t(t) {
        this.timestamp = t;
    }
    return t.J = function(e) {
        return new t(e);
    }, t.min = function() {
        return new t(new mt(0, 0));
    }, t.prototype.L = function(t) {
        return this.timestamp.Y(t.timestamp);
    }, t.prototype.isEqual = function(t) {
        return this.timestamp.isEqual(t.timestamp);
    }, 
    /** Returns a number representation of the version for use in spec tests. */ t.prototype.X = function() {
        // Convert to microseconds.
        return 1e6 * this.timestamp.seconds + this.timestamp.nanoseconds / 1e3;
    }, t.prototype.toString = function() {
        return "SnapshotVersion(" + this.timestamp.toString() + ")";
    }, t.prototype.Z = function() {
        return this.timestamp;
    }, t;
}();

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Returns whether a variable is either undefined or null.
 */
function wt(t) {
    return null == t;
}

/** Returns whether the value represents -0. */ function bt(t) {
    // Detect if the value is -0.0. Based on polyfill from
    // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/is
    return 0 === t && 1 / t == -1 / 0;
}

/**
 * Returns whether a value is an integer and in the safe integer range
 * @param value The value to test for being an integer and in the safe range
 */ function It(t) {
    return "number" == typeof t && Number.isInteger(t) && !bt(t) && t <= Number.MAX_SAFE_INTEGER && t >= Number.MIN_SAFE_INTEGER;
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Visible for testing
var Et = function(t, e, n, r, i, o, s) {
    void 0 === e && (e = null), void 0 === n && (n = []), void 0 === r && (r = []), 
    void 0 === i && (i = null), void 0 === o && (o = null), void 0 === s && (s = null), 
    this.path = t, this.collectionGroup = e, this.orderBy = n, this.filters = r, this.limit = i, 
    this.startAt = o, this.endAt = s, this.tt = null;
};

/**
 * Initializes a Target with a path and optional additional query constraints.
 * Path must currently be empty if this is a collection group query.
 *
 * NOTE: you should always construct `Target` from `Query.toTarget` instead of
 * using this factory method, because `Query` provides an implicit `orderBy`
 * property.
 */ function _t(t, e, n, r, i, o, s) {
    return void 0 === e && (e = null), void 0 === n && (n = []), void 0 === r && (r = []), 
    void 0 === i && (i = null), void 0 === o && (o = null), void 0 === s && (s = null), 
    new Et(t, e, n, r, i, o, s);
}

function Tt(t) {
    var e = x(t);
    if (null === e.tt) {
        var n = e.path.R();
        null !== e.collectionGroup && (n += "|cg:" + e.collectionGroup), n += "|f:", n += e.filters.map((function(t) {
            return function(t) {
                // TODO(b/29183165): Technically, this won't be unique if two values have
                // the same description, such as the int 3 and the string "3". So we should
                // add the types in here somehow, too.
                return t.field.R() + t.op.toString() + ve(t.value);
            }(t);
        })).join(","), n += "|ob:", n += e.orderBy.map((function(t) {
            return (e = t).field.R() + e.dir;
            var e;
        })).join(","), wt(e.limit) || (n += "|l:", n += e.limit), e.startAt && (n += "|lb:", 
        n += br(e.startAt)), e.endAt && (n += "|ub:", n += br(e.endAt)), e.tt = n;
    }
    return e.tt;
}

function Nt(t, e) {
    if (t.limit !== e.limit) return !1;
    if (t.orderBy.length !== e.orderBy.length) return !1;
    for (var n = 0; n < t.orderBy.length; n++) if (!Nr(t.orderBy[n], e.orderBy[n])) return !1;
    if (t.filters.length !== e.filters.length) return !1;
    for (var r = 0; r < t.filters.length; r++) if (i = t.filters[r], o = e.filters[r], 
    i.op !== o.op || !i.field.isEqual(o.field) || !fe(i.value, o.value)) return !1;
    var i, o;
    return t.collectionGroup === e.collectionGroup && !!t.path.isEqual(e.path) && !!Er(t.startAt, e.startAt) && Er(t.endAt, e.endAt);
}

function At(t) {
    return F.F(t.path) && null === t.collectionGroup && 0 === t.filters.length;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * An immutable set of metadata that the local store tracks for each target.
 */ var St, Dt, kt = /** @class */ function() {
    function t(
    /** The target being listened to. */
    t, 
    /**
     * The target ID to which the target corresponds; Assigned by the
     * LocalStore for user listens and by the SyncEngine for limbo watches.
     */
    e, 
    /** The purpose of the target. */
    n, 
    /**
     * The sequence number of the last transaction during which this target data
     * was modified.
     */
    r, 
    /** The latest snapshot version seen for this target. */
    i
    /**
     * The maximum snapshot version at which the associated view
     * contained no limbo documents.
     */ , o
    /**
     * An opaque, server-assigned token that allows watching a target to be
     * resumed after disconnecting without retransmitting all the data that
     * matches the target. The resume token essentially identifies a point in
     * time from which the server should resume sending results.
     */ , s) {
        void 0 === i && (i = gt.min()), void 0 === o && (o = gt.min()), void 0 === s && (s = ct.B), 
        this.target = t, this.targetId = e, this.et = n, this.sequenceNumber = r, this.nt = i, 
        this.lastLimboFreeSnapshotVersion = o, this.resumeToken = s;
    }
    /** Creates a new target data instance with an updated sequence number. */    return t.prototype.st = function(e) {
        return new t(this.target, this.targetId, this.et, e, this.nt, this.lastLimboFreeSnapshotVersion, this.resumeToken);
    }, 
    /**
     * Creates a new target data instance with an updated resume token and
     * snapshot version.
     */
    t.prototype.it = function(e, n) {
        return new t(this.target, this.targetId, this.et, this.sequenceNumber, n, this.lastLimboFreeSnapshotVersion, e);
    }, 
    /**
     * Creates a new target data instance with an updated last limbo free
     * snapshot version number.
     */
    t.prototype.rt = function(e) {
        return new t(this.target, this.targetId, this.et, this.sequenceNumber, this.nt, e, this.resumeToken);
    }, t;
}(), xt = 
// TODO(b/33078163): just use simplest form of existence filter for now
function(t) {
    this.count = t;
};

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Determines whether an error code represents a permanent error when received
 * in response to a non-write operation.
 *
 * See isPermanentWriteError for classifying write errors.
 */
function Lt(t) {
    switch (t) {
      case b.OK:
        return D();

      case b.CANCELLED:
      case b.UNKNOWN:
      case b.DEADLINE_EXCEEDED:
      case b.RESOURCE_EXHAUSTED:
      case b.INTERNAL:
      case b.UNAVAILABLE:
 // Unauthenticated means something went wrong with our token and we need
        // to retry with new credentials which will happen automatically.
              case b.UNAUTHENTICATED:
        return !1;

      case b.INVALID_ARGUMENT:
      case b.NOT_FOUND:
      case b.ALREADY_EXISTS:
      case b.PERMISSION_DENIED:
      case b.FAILED_PRECONDITION:
 // Aborted might be retried in some scenarios, but that is dependant on
        // the context and should handled individually by the calling code.
        // See https://cloud.google.com/apis/design/errors.
              case b.ABORTED:
      case b.OUT_OF_RANGE:
      case b.UNIMPLEMENTED:
      case b.DATA_LOSS:
        return !0;

      default:
        return D();
    }
}

/**
 * Determines whether an error code represents a permanent error when received
 * in response to a write operation.
 *
 * Write operations must be handled specially because as of b/119437764, ABORTED
 * errors on the write stream should be retried too (even though ABORTED errors
 * are not generally retryable).
 *
 * Note that during the initial handshake on the write stream an ABORTED error
 * signals that we should discard our stream token (i.e. it is permanent). This
 * means a handshake error should be classified with isPermanentError, above.
 */
/**
 * Maps an error Code from GRPC status code number, like 0, 1, or 14. These
 * are not the same as HTTP status codes.
 *
 * @returns The Code equivalent to the given GRPC status code. Fails if there
 *     is no match.
 */ function Rt(t) {
    if (void 0 === t) 
    // This shouldn't normally happen, but in certain error cases (like trying
    // to send invalid proto messages) we may get an error with no GRPC code.
    return N("GRPC error has no .code"), b.UNKNOWN;
    switch (t) {
      case St.OK:
        return b.OK;

      case St.CANCELLED:
        return b.CANCELLED;

      case St.UNKNOWN:
        return b.UNKNOWN;

      case St.DEADLINE_EXCEEDED:
        return b.DEADLINE_EXCEEDED;

      case St.RESOURCE_EXHAUSTED:
        return b.RESOURCE_EXHAUSTED;

      case St.INTERNAL:
        return b.INTERNAL;

      case St.UNAVAILABLE:
        return b.UNAVAILABLE;

      case St.UNAUTHENTICATED:
        return b.UNAUTHENTICATED;

      case St.INVALID_ARGUMENT:
        return b.INVALID_ARGUMENT;

      case St.NOT_FOUND:
        return b.NOT_FOUND;

      case St.ALREADY_EXISTS:
        return b.ALREADY_EXISTS;

      case St.PERMISSION_DENIED:
        return b.PERMISSION_DENIED;

      case St.FAILED_PRECONDITION:
        return b.FAILED_PRECONDITION;

      case St.ABORTED:
        return b.ABORTED;

      case St.OUT_OF_RANGE:
        return b.OUT_OF_RANGE;

      case St.UNIMPLEMENTED:
        return b.UNIMPLEMENTED;

      case St.DATA_LOSS:
        return b.DATA_LOSS;

      default:
        return D();
    }
}

/**
 * Converts an HTTP response's error status to the equivalent error code.
 *
 * @param status An HTTP error response status ("FAILED_PRECONDITION",
 * "UNKNOWN", etc.)
 * @returns The equivalent Code. Non-matching responses are mapped to
 *     Code.UNKNOWN.
 */ (Dt = St || (St = {}))[Dt.OK = 0] = "OK", Dt[Dt.CANCELLED = 1] = "CANCELLED", 
Dt[Dt.UNKNOWN = 2] = "UNKNOWN", Dt[Dt.INVALID_ARGUMENT = 3] = "INVALID_ARGUMENT", 
Dt[Dt.DEADLINE_EXCEEDED = 4] = "DEADLINE_EXCEEDED", Dt[Dt.NOT_FOUND = 5] = "NOT_FOUND", 
Dt[Dt.ALREADY_EXISTS = 6] = "ALREADY_EXISTS", Dt[Dt.PERMISSION_DENIED = 7] = "PERMISSION_DENIED", 
Dt[Dt.UNAUTHENTICATED = 16] = "UNAUTHENTICATED", Dt[Dt.RESOURCE_EXHAUSTED = 8] = "RESOURCE_EXHAUSTED", 
Dt[Dt.FAILED_PRECONDITION = 9] = "FAILED_PRECONDITION", Dt[Dt.ABORTED = 10] = "ABORTED", 
Dt[Dt.OUT_OF_RANGE = 11] = "OUT_OF_RANGE", Dt[Dt.UNIMPLEMENTED = 12] = "UNIMPLEMENTED", 
Dt[Dt.INTERNAL = 13] = "INTERNAL", Dt[Dt.UNAVAILABLE = 14] = "UNAVAILABLE", Dt[Dt.DATA_LOSS = 15] = "DATA_LOSS";

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// An immutable sorted map implementation, based on a Left-leaning Red-Black
// tree.
var Ot = /** @class */ function() {
    function t(t, e) {
        this.i = t, this.root = e || Vt.EMPTY;
    }
    // Returns a copy of the map, with the specified key/value added or replaced.
        return t.prototype.ot = function(e, n) {
        return new t(this.i, this.root.ot(e, n, this.i).copy(null, null, Vt.at, null, null));
    }, 
    // Returns a copy of the map, with the specified key removed.
    t.prototype.remove = function(e) {
        return new t(this.i, this.root.remove(e, this.i).copy(null, null, Vt.at, null, null));
    }, 
    // Returns the value of the node with the given key, or null.
    t.prototype.get = function(t) {
        for (var e = this.root; !e.m(); ) {
            var n = this.i(t, e.key);
            if (0 === n) return e.value;
            n < 0 ? e = e.left : n > 0 && (e = e.right);
        }
        return null;
    }, 
    // Returns the index of the element in this sorted map, or -1 if it doesn't
    // exist.
    t.prototype.indexOf = function(t) {
        for (
        // Number of nodes that were pruned when descending right
        var e = 0, n = this.root; !n.m(); ) {
            var r = this.i(t, n.key);
            if (0 === r) return e + n.left.size;
            r < 0 ? n = n.left : (
            // Count all nodes left of the node plus the node itself
            e += n.left.size + 1, n = n.right);
        }
        // Node not found
                return -1;
    }, t.prototype.m = function() {
        return this.root.m();
    }, Object.defineProperty(t.prototype, "size", {
        // Returns the total number of nodes in the map.
        get: function() {
            return this.root.size;
        },
        enumerable: !1,
        configurable: !0
    }), 
    // Returns the minimum key in the map.
    t.prototype.ct = function() {
        return this.root.ct();
    }, 
    // Returns the maximum key in the map.
    t.prototype.ut = function() {
        return this.root.ut();
    }, 
    // Traverses the map in key order and calls the specified action function
    // for each key/value pair. If action returns true, traversal is aborted.
    // Returns the first truthy value returned by action, or the last falsey
    // value returned by action.
    t.prototype.ht = function(t) {
        return this.root.ht(t);
    }, t.prototype.forEach = function(t) {
        this.ht((function(e, n) {
            return t(e, n), !1;
        }));
    }, t.prototype.toString = function() {
        var t = [];
        return this.ht((function(e, n) {
            return t.push(e + ":" + n), !1;
        })), "{" + t.join(", ") + "}";
    }, 
    // Traverses the map in reverse key order and calls the specified action
    // function for each key/value pair. If action returns true, traversal is
    // aborted.
    // Returns the first truthy value returned by action, or the last falsey
    // value returned by action.
    t.prototype.lt = function(t) {
        return this.root.lt(t);
    }, 
    // Returns an iterator over the SortedMap.
    t.prototype._t = function() {
        return new Pt(this.root, null, this.i, !1);
    }, t.prototype.ft = function(t) {
        return new Pt(this.root, t, this.i, !1);
    }, t.prototype.dt = function() {
        return new Pt(this.root, null, this.i, !0);
    }, t.prototype.wt = function(t) {
        return new Pt(this.root, t, this.i, !0);
    }, t;
}(), Pt = /** @class */ function() {
    function t(t, e, n, r) {
        this.Tt = r, this.Et = [];
        for (var i = 1; !t.m(); ) if (i = e ? n(t.key, e) : 1, 
        // flip the comparison if we're going in reverse
        r && (i *= -1), i < 0) 
        // This node is less than our start key. ignore it
        t = this.Tt ? t.left : t.right; else {
            if (0 === i) {
                // This node is exactly equal to our start key. Push it on the stack,
                // but stop iterating;
                this.Et.push(t);
                break;
            }
            // This node is greater than our start key, add it to the stack and move
            // to the next one
                        this.Et.push(t), t = this.Tt ? t.right : t.left;
        }
    }
    return t.prototype.It = function() {
        var t = this.Et.pop(), e = {
            key: t.key,
            value: t.value
        };
        if (this.Tt) for (t = t.left; !t.m(); ) this.Et.push(t), t = t.right; else for (t = t.right; !t.m(); ) this.Et.push(t), 
        t = t.left;
        return e;
    }, t.prototype.At = function() {
        return this.Et.length > 0;
    }, t.prototype.Rt = function() {
        if (0 === this.Et.length) return null;
        var t = this.Et[this.Et.length - 1];
        return {
            key: t.key,
            value: t.value
        };
    }, t;
}(), Vt = /** @class */ function() {
    function t(e, n, r, i, o) {
        this.key = e, this.value = n, this.color = null != r ? r : t.RED, this.left = null != i ? i : t.EMPTY, 
        this.right = null != o ? o : t.EMPTY, this.size = this.left.size + 1 + this.right.size;
    }
    // Returns a copy of the current node, optionally replacing pieces of it.
        return t.prototype.copy = function(e, n, r, i, o) {
        return new t(null != e ? e : this.key, null != n ? n : this.value, null != r ? r : this.color, null != i ? i : this.left, null != o ? o : this.right);
    }, t.prototype.m = function() {
        return !1;
    }, 
    // Traverses the tree in key order and calls the specified action function
    // for each node. If action returns true, traversal is aborted.
    // Returns the first truthy value returned by action, or the last falsey
    // value returned by action.
    t.prototype.ht = function(t) {
        return this.left.ht(t) || t(this.key, this.value) || this.right.ht(t);
    }, 
    // Traverses the tree in reverse key order and calls the specified action
    // function for each node. If action returns true, traversal is aborted.
    // Returns the first truthy value returned by action, or the last falsey
    // value returned by action.
    t.prototype.lt = function(t) {
        return this.right.lt(t) || t(this.key, this.value) || this.left.lt(t);
    }, 
    // Returns the minimum node in the tree.
    t.prototype.min = function() {
        return this.left.m() ? this : this.left.min();
    }, 
    // Returns the maximum key in the tree.
    t.prototype.ct = function() {
        return this.min().key;
    }, 
    // Returns the maximum key in the tree.
    t.prototype.ut = function() {
        return this.right.m() ? this.key : this.right.ut();
    }, 
    // Returns new tree, with the key/value added.
    t.prototype.ot = function(t, e, n) {
        var r = this, i = n(t, r.key);
        return (r = i < 0 ? r.copy(null, null, null, r.left.ot(t, e, n), null) : 0 === i ? r.copy(null, e, null, null, null) : r.copy(null, null, null, null, r.right.ot(t, e, n))).gt();
    }, t.prototype.Pt = function() {
        if (this.left.m()) return t.EMPTY;
        var e = this;
        return e.left.yt() || e.left.left.yt() || (e = e.Vt()), (e = e.copy(null, null, null, e.left.Pt(), null)).gt();
    }, 
    // Returns new tree, with the specified item removed.
    t.prototype.remove = function(e, n) {
        var r, i = this;
        if (n(e, i.key) < 0) i.left.m() || i.left.yt() || i.left.left.yt() || (i = i.Vt()), 
        i = i.copy(null, null, null, i.left.remove(e, n), null); else {
            if (i.left.yt() && (i = i.bt()), i.right.m() || i.right.yt() || i.right.left.yt() || (i = i.vt()), 
            0 === n(e, i.key)) {
                if (i.right.m()) return t.EMPTY;
                r = i.right.min(), i = i.copy(r.key, r.value, null, null, i.right.Pt());
            }
            i = i.copy(null, null, null, null, i.right.remove(e, n));
        }
        return i.gt();
    }, t.prototype.yt = function() {
        return this.color;
    }, 
    // Returns new tree after performing any needed rotations.
    t.prototype.gt = function() {
        var t = this;
        return t.right.yt() && !t.left.yt() && (t = t.St()), t.left.yt() && t.left.left.yt() && (t = t.bt()), 
        t.left.yt() && t.right.yt() && (t = t.Dt()), t;
    }, t.prototype.Vt = function() {
        var t = this.Dt();
        return t.right.left.yt() && (t = (t = (t = t.copy(null, null, null, null, t.right.bt())).St()).Dt()), 
        t;
    }, t.prototype.vt = function() {
        var t = this.Dt();
        return t.left.left.yt() && (t = (t = t.bt()).Dt()), t;
    }, t.prototype.St = function() {
        var e = this.copy(null, null, t.RED, null, this.right.left);
        return this.right.copy(null, null, this.color, e, null);
    }, t.prototype.bt = function() {
        var e = this.copy(null, null, t.RED, this.left.right, null);
        return this.left.copy(null, null, this.color, null, e);
    }, t.prototype.Dt = function() {
        var t = this.left.copy(null, null, !this.left.color, null, null), e = this.right.copy(null, null, !this.right.color, null, null);
        return this.copy(null, null, !this.color, t, e);
    }, 
    // For testing.
    t.prototype.Ct = function() {
        var t = this.Nt();
        return Math.pow(2, t) <= this.size + 1;
    }, 
    // In a balanced RB tree, the black-depth (number of black nodes) from root to
    // leaves is equal on both sides.  This function verifies that or asserts.
    t.prototype.Nt = function() {
        if (this.yt() && this.left.yt()) throw D();
        if (this.right.yt()) throw D();
        var t = this.left.Nt();
        if (t !== this.right.Nt()) throw D();
        return t + (this.yt() ? 0 : 1);
    }, t;
}();

// end SortedMap
// An iterator over an LLRBNode.
// end LLRBNode
// Empty node is shared between all LLRB trees.
// eslint-disable-next-line @typescript-eslint/no-explicit-any
Vt.EMPTY = null, Vt.RED = !0, Vt.at = !1, 
// end LLRBEmptyNode
Vt.EMPTY = new (/** @class */ function() {
    function t() {
        this.size = 0;
    }
    return Object.defineProperty(t.prototype, "key", {
        get: function() {
            throw D();
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "value", {
        get: function() {
            throw D();
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "color", {
        get: function() {
            throw D();
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "left", {
        get: function() {
            throw D();
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "right", {
        get: function() {
            throw D();
        },
        enumerable: !1,
        configurable: !0
    }), 
    // Returns a copy of the current node.
    t.prototype.copy = function(t, e, n, r, i) {
        return this;
    }, 
    // Returns a copy of the tree, with the specified key/value added.
    t.prototype.ot = function(t, e, n) {
        return new Vt(t, e);
    }, 
    // Returns a copy of the tree, with the specified key removed.
    t.prototype.remove = function(t, e) {
        return this;
    }, t.prototype.m = function() {
        return !0;
    }, t.prototype.ht = function(t) {
        return !1;
    }, t.prototype.lt = function(t) {
        return !1;
    }, t.prototype.ct = function() {
        return null;
    }, t.prototype.ut = function() {
        return null;
    }, t.prototype.yt = function() {
        return !1;
    }, 
    // For testing.
    t.prototype.Ct = function() {
        return !0;
    }, t.prototype.Nt = function() {
        return 0;
    }, t;
}());

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * SortedSet is an immutable (copy-on-write) collection that holds elements
 * in order specified by the provided comparator.
 *
 * NOTE: if provided comparator returns 0 for two elements, we consider them to
 * be equal!
 */
var Ut = /** @class */ function() {
    function t(t) {
        this.i = t, this.data = new Ot(this.i);
    }
    return t.prototype.has = function(t) {
        return null !== this.data.get(t);
    }, t.prototype.first = function() {
        return this.data.ct();
    }, t.prototype.last = function() {
        return this.data.ut();
    }, Object.defineProperty(t.prototype, "size", {
        get: function() {
            return this.data.size;
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.indexOf = function(t) {
        return this.data.indexOf(t);
    }, 
    /** Iterates elements in order defined by "comparator" */ t.prototype.forEach = function(t) {
        this.data.ht((function(e, n) {
            return t(e), !1;
        }));
    }, 
    /** Iterates over `elem`s such that: range[0] <= elem < range[1]. */ t.prototype.Ft = function(t, e) {
        for (var n = this.data.ft(t[0]); n.At(); ) {
            var r = n.It();
            if (this.i(r.key, t[1]) >= 0) return;
            e(r.key);
        }
    }, 
    /**
     * Iterates over `elem`s such that: start <= elem until false is returned.
     */
    t.prototype.xt = function(t, e) {
        var n;
        for (n = void 0 !== e ? this.data.ft(e) : this.data._t(); n.At(); ) if (!t(n.It().key)) return;
    }, 
    /** Finds the least element greater than or equal to `elem`. */ t.prototype.$t = function(t) {
        var e = this.data.ft(t);
        return e.At() ? e.It().key : null;
    }, t.prototype._t = function() {
        return new Ct(this.data._t());
    }, t.prototype.ft = function(t) {
        return new Ct(this.data.ft(t));
    }, 
    /** Inserts or updates an element */ t.prototype.add = function(t) {
        return this.copy(this.data.remove(t).ot(t, !0));
    }, 
    /** Deletes an element */ t.prototype.delete = function(t) {
        return this.has(t) ? this.copy(this.data.remove(t)) : this;
    }, t.prototype.m = function() {
        return this.data.m();
    }, t.prototype.kt = function(t) {
        var e = this;
        // Make sure `result` always refers to the larger one of the two sets.
                return e.size < t.size && (e = t, t = this), t.forEach((function(t) {
            e = e.add(t);
        })), e;
    }, t.prototype.isEqual = function(e) {
        if (!(e instanceof t)) return !1;
        if (this.size !== e.size) return !1;
        for (var n = this.data._t(), r = e.data._t(); n.At(); ) {
            var i = n.It().key, o = r.It().key;
            if (0 !== this.i(i, o)) return !1;
        }
        return !0;
    }, t.prototype.A = function() {
        var t = [];
        return this.forEach((function(e) {
            t.push(e);
        })), t;
    }, t.prototype.toString = function() {
        var t = [];
        return this.forEach((function(e) {
            return t.push(e);
        })), "SortedSet(" + t.toString() + ")";
    }, t.prototype.copy = function(e) {
        var n = new t(this.i);
        return n.data = e, n;
    }, t;
}(), Ct = /** @class */ function() {
    function t(t) {
        this.Mt = t;
    }
    return t.prototype.It = function() {
        return this.Mt.It().key;
    }, t.prototype.At = function() {
        return this.Mt.At();
    }, t;
}(), Ft = new Ot(F.i);

function Mt() {
    return Ft;
}

function qt() {
    return Mt();
}

var jt = new Ot(F.i);

function Gt() {
    return jt;
}

var zt = new Ot(F.i), Bt = new Ut(F.i);

function Kt() {
    for (var t = [], e = 0; e < arguments.length; e++) t[e] = arguments[e];
    for (var n = Bt, r = 0, i = t; r < i.length; r++) {
        var o = i[r];
        n = n.add(o);
    }
    return n;
}

var Wt = new Ut(st);

function Qt() {
    return Wt;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * DocumentSet is an immutable (copy-on-write) collection that holds documents
 * in order specified by the provided comparator. We always add a document key
 * comparator on top of what is provided to guarantee document equality based on
 * the key.
 */ var Ht = /** @class */ function() {
    /** The default ordering is by key if the comparator is omitted */
    function t(t) {
        // We are adding document key comparator to the end as it's the only
        // guaranteed unique property of a document.
        this.i = t ? function(e, n) {
            return t(e, n) || F.i(e.key, n.key);
        } : function(t, e) {
            return F.i(t.key, e.key);
        }, this.Ot = Gt(), this.Lt = new Ot(this.i)
        /**
     * Returns an empty copy of the existing DocumentSet, using the same
     * comparator.
     */;
    }
    return t.Bt = function(e) {
        return new t(e.i);
    }, t.prototype.has = function(t) {
        return null != this.Ot.get(t);
    }, t.prototype.get = function(t) {
        return this.Ot.get(t);
    }, t.prototype.first = function() {
        return this.Lt.ct();
    }, t.prototype.last = function() {
        return this.Lt.ut();
    }, t.prototype.m = function() {
        return this.Lt.m();
    }, 
    /**
     * Returns the index of the provided key in the document set, or -1 if the
     * document key is not present in the set;
     */
    t.prototype.indexOf = function(t) {
        var e = this.Ot.get(t);
        return e ? this.Lt.indexOf(e) : -1;
    }, Object.defineProperty(t.prototype, "size", {
        get: function() {
            return this.Lt.size;
        },
        enumerable: !1,
        configurable: !0
    }), 
    /** Iterates documents in order defined by "comparator" */ t.prototype.forEach = function(t) {
        this.Lt.ht((function(e, n) {
            return t(e), !1;
        }));
    }, 
    /** Inserts or updates a document with the same key */ t.prototype.add = function(t) {
        // First remove the element if we have it.
        var e = this.delete(t.key);
        return e.copy(e.Ot.ot(t.key, t), e.Lt.ot(t, null));
    }, 
    /** Deletes a document with a given key */ t.prototype.delete = function(t) {
        var e = this.get(t);
        return e ? this.copy(this.Ot.remove(t), this.Lt.remove(e)) : this;
    }, t.prototype.isEqual = function(e) {
        if (!(e instanceof t)) return !1;
        if (this.size !== e.size) return !1;
        for (var n = this.Lt._t(), r = e.Lt._t(); n.At(); ) {
            var i = n.It().key, o = r.It().key;
            if (!i.isEqual(o)) return !1;
        }
        return !0;
    }, t.prototype.toString = function() {
        var t = [];
        return this.forEach((function(e) {
            t.push(e.toString());
        })), 0 === t.length ? "DocumentSet ()" : "DocumentSet (\n  " + t.join("  \n") + "\n)";
    }, t.prototype.copy = function(e, n) {
        var r = new t;
        return r.i = this.i, r.Ot = e, r.Lt = n, r;
    }, t;
}(), Yt = /** @class */ function() {
    function t() {
        this.qt = new Ot(F.i);
    }
    return t.prototype.track = function(t) {
        var e = t.doc.key, n = this.qt.get(e);
        n ? 
        // Merge the new change with the existing change.
        0 /* Added */ !== t.type && 3 /* Metadata */ === n.type ? this.qt = this.qt.ot(e, t) : 3 /* Metadata */ === t.type && 1 /* Removed */ !== n.type ? this.qt = this.qt.ot(e, {
            type: n.type,
            doc: t.doc
        }) : 2 /* Modified */ === t.type && 2 /* Modified */ === n.type ? this.qt = this.qt.ot(e, {
            type: 2 /* Modified */ ,
            doc: t.doc
        }) : 2 /* Modified */ === t.type && 0 /* Added */ === n.type ? this.qt = this.qt.ot(e, {
            type: 0 /* Added */ ,
            doc: t.doc
        }) : 1 /* Removed */ === t.type && 0 /* Added */ === n.type ? this.qt = this.qt.remove(e) : 1 /* Removed */ === t.type && 2 /* Modified */ === n.type ? this.qt = this.qt.ot(e, {
            type: 1 /* Removed */ ,
            doc: n.doc
        }) : 0 /* Added */ === t.type && 1 /* Removed */ === n.type ? this.qt = this.qt.ot(e, {
            type: 2 /* Modified */ ,
            doc: t.doc
        }) : 
        // This includes these cases, which don't make sense:
        // Added->Added
        // Removed->Removed
        // Modified->Added
        // Removed->Modified
        // Metadata->Added
        // Removed->Metadata
        D() : this.qt = this.qt.ot(e, t);
    }, t.prototype.Ut = function() {
        var t = [];
        return this.qt.ht((function(e, n) {
            t.push(n);
        })), t;
    }, t;
}(), $t = /** @class */ function() {
    function t(t, e, n, r, i, o, s, u) {
        this.query = t, this.docs = e, this.Qt = n, this.docChanges = r, this.Wt = i, this.fromCache = o, 
        this.jt = s, this.Kt = u
        /** Returns a view snapshot as if all documents in the snapshot were added. */;
    }
    return t.Gt = function(e, n, r, i) {
        var o = [];
        return n.forEach((function(t) {
            o.push({
                type: 0 /* Added */ ,
                doc: t
            });
        })), new t(e, n, Ht.Bt(n), o, r, i, 
        /* syncStateChanged= */ !0, 
        /* excludesMetadataChanges= */ !1);
    }, Object.defineProperty(t.prototype, "hasPendingWrites", {
        get: function() {
            return !this.Wt.m();
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.isEqual = function(t) {
        if (!(this.fromCache === t.fromCache && this.jt === t.jt && this.Wt.isEqual(t.Wt) && or(this.query, t.query) && this.docs.isEqual(t.docs) && this.Qt.isEqual(t.Qt))) return !1;
        var e = this.docChanges, n = t.docChanges;
        if (e.length !== n.length) return !1;
        for (var r = 0; r < e.length; r++) if (e[r].type !== n[r].type || !e[r].doc.isEqual(n[r].doc)) return !1;
        return !0;
    }, t;
}(), Xt = /** @class */ function() {
    function t(
    /**
     * The snapshot version this event brings us up to, or MIN if not set.
     */
    t, 
    /**
     * A map from target to changes to the target. See TargetChange.
     */
    e, 
    /**
     * A set of targets that is known to be inconsistent. Listens for these
     * targets should be re-established without resume tokens.
     */
    n, 
    /**
     * A set of which documents have changed or been deleted, along with the
     * doc's new values (if not deleted).
     */
    r, 
    /**
     * A set of which document updates are due only to limbo resolution targets.
     */
    i) {
        this.nt = t, this.zt = e, this.Ht = n, this.Yt = r, this.Jt = i;
    }
    /**
     * HACK: Views require RemoteEvents in order to determine whether the view is
     * CURRENT, but secondary tabs don't receive remote events. So this method is
     * used to create a synthesized RemoteEvent that can be used to apply a
     * CURRENT status change to a View, for queries executed in a different tab.
     */
    // PORTING NOTE: Multi-tab only
        return t.Xt = function(e, n) {
        var r = new Map;
        return r.set(e, Jt.Zt(e, n)), new t(gt.min(), r, Qt(), Mt(), Kt());
    }, t;
}(), Jt = /** @class */ function() {
    function t(
    /**
     * An opaque, server-assigned token that allows watching a query to be resumed
     * after disconnecting without retransmitting all the data that matches the
     * query. The resume token essentially identifies a point in time from which
     * the server should resume sending results.
     */
    t, 
    /**
     * The "current" (synced) status of this target. Note that "current"
     * has special meaning in the RPC protocol that implies that a target is
     * both up-to-date and consistent with the rest of the watch stream.
     */
    e, 
    /**
     * The set of documents that were newly assigned to this target as part of
     * this remote event.
     */
    n, 
    /**
     * The set of documents that were already assigned to this target but received
     * an update during this remote event.
     */
    r, 
    /**
     * The set of documents that were removed from this target as part of this
     * remote event.
     */
    i) {
        this.resumeToken = t, this.te = e, this.ee = n, this.ne = r, this.se = i
        /**
     * This method is used to create a synthesized TargetChanges that can be used to
     * apply a CURRENT status change to a View (for queries executed in a different
     * tab) or for new queries (to raise snapshots with correct CURRENT status).
     */;
    }
    return t.Zt = function(e, n) {
        return new t(ct.B, n, Kt(), Kt(), Kt());
    }, t;
}(), Zt = function(
/** The new document applies to all of these targets. */
t, 
/** The new document is removed from all of these targets. */
e, 
/** The key of the document for this change. */
n, 
/**
     * The new document or NoDocument if it was deleted. Is null if the
     * document went out of view without the server sending a new document.
     */
r) {
    this.ie = t, this.removedTargetIds = e, this.key = n, this.re = r;
}, te = function(t, e) {
    this.targetId = t, this.oe = e;
}, ee = function(
/** What kind of change occurred to the watch target. */
t, 
/** The target IDs that were added/removed/set. */
e, 
/**
     * An opaque, server-assigned token that allows watching a target to be
     * resumed after disconnecting without retransmitting all the data that
     * matches the target. The resume token essentially identifies a point in
     * time from which the server should resume sending results.
     */
n
/** An RPC error indicating why the watch failed. */ , r) {
    void 0 === n && (n = ct.B), void 0 === r && (r = null), this.state = t, this.targetIds = e, 
    this.resumeToken = n, this.cause = r;
}, ne = /** @class */ function() {
    function t() {
        /**
         * The number of pending responses (adds or removes) that we are waiting on.
         * We only consider targets active that have no pending responses.
         */
        this.ae = 0, 
        /**
             * Keeps track of the document changes since the last raised snapshot.
             *
             * These changes are continuously updated as we receive document updates and
             * always reflect the current set of changes against the last issued snapshot.
             */
        this.ce = oe(), 
        /** See public getters for explanations of these fields. */
        this.ue = ct.B, this.he = !1, 
        /**
             * Whether this target state should be included in the next snapshot. We
             * initialize to true so that newly-added targets are included in the next
             * RemoteEvent.
             */
        this.le = !0;
    }
    return Object.defineProperty(t.prototype, "te", {
        /**
         * Whether this target has been marked 'current'.
         *
         * 'Current' has special meaning in the RPC protocol: It implies that the
         * Watch backend has sent us all changes up to the point at which the target
         * was added and that the target is consistent with the rest of the watch
         * stream.
         */
        get: function() {
            return this.he;
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "resumeToken", {
        /** The last resume token sent to us for this target. */ get: function() {
            return this.ue;
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "_e", {
        /** Whether this target has pending target adds or target removes. */ get: function() {
            return 0 !== this.ae;
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "fe", {
        /** Whether we have modified any state that should trigger a snapshot. */ get: function() {
            return this.le;
        },
        enumerable: !1,
        configurable: !0
    }), 
    /**
     * Applies the resume token to the TargetChange, but only when it has a new
     * value. Empty resumeTokens are discarded.
     */
    t.prototype.de = function(t) {
        t.O() > 0 && (this.le = !0, this.ue = t);
    }, 
    /**
     * Creates a target change from the current set of changes.
     *
     * To reset the document changes after raising this snapshot, call
     * `clearPendingChanges()`.
     */
    t.prototype.we = function() {
        var t = Kt(), e = Kt(), n = Kt();
        return this.ce.forEach((function(r, i) {
            switch (i) {
              case 0 /* Added */ :
                t = t.add(r);
                break;

              case 2 /* Modified */ :
                e = e.add(r);
                break;

              case 1 /* Removed */ :
                n = n.add(r);
                break;

              default:
                D();
            }
        })), new Jt(this.ue, this.he, t, e, n);
    }, 
    /**
     * Resets the document changes and sets `hasPendingChanges` to false.
     */
    t.prototype.me = function() {
        this.le = !1, this.ce = oe();
    }, t.prototype.Te = function(t, e) {
        this.le = !0, this.ce = this.ce.ot(t, e);
    }, t.prototype.Ee = function(t) {
        this.le = !0, this.ce = this.ce.remove(t);
    }, t.prototype.Ie = function() {
        this.ae += 1;
    }, t.prototype.Ae = function() {
        this.ae -= 1;
    }, t.prototype.Re = function() {
        this.le = !0, this.he = !0;
    }, t;
}(), re = /** @class */ function() {
    function t(t) {
        this.ge = t, 
        /** The internal state of all tracked targets. */
        this.Pe = new Map, 
        /** Keeps track of the documents to update since the last raised snapshot. */
        this.ye = Mt(), 
        /** A mapping of document keys to their set of target IDs. */
        this.Ve = ie(), 
        /**
             * A list of targets with existence filter mismatches. These targets are
             * known to be inconsistent and their listens needs to be re-established by
             * RemoteStore.
             */
        this.pe = new Ut(st)
        /**
     * Processes and adds the DocumentWatchChange to the current set of changes.
     */;
    }
    return t.prototype.be = function(t) {
        for (var e = 0, n = t.ie; e < n.length; e++) {
            var r = n[e];
            t.re instanceof zn ? this.ve(r, t.re) : t.re instanceof Bn && this.Se(r, t.key, t.re);
        }
        for (var i = 0, o = t.removedTargetIds; i < o.length; i++) {
            var s = o[i];
            this.Se(s, t.key, t.re);
        }
    }, 
    /** Processes and adds the WatchTargetChange to the current set of changes. */ t.prototype.De = function(t) {
        var e = this;
        this.Ce(t, (function(n) {
            var r = e.Ne(n);
            switch (t.state) {
              case 0 /* NoChange */ :
                e.Fe(n) && r.de(t.resumeToken);
                break;

              case 1 /* Added */ :
                // We need to decrement the number of pending acks needed from watch
                // for this targetId.
                r.Ae(), r._e || 
                // We have a freshly added target, so we need to reset any state
                // that we had previously. This can happen e.g. when remove and add
                // back a target for existence filter mismatches.
                r.me(), r.de(t.resumeToken);
                break;

              case 2 /* Removed */ :
                // We need to keep track of removed targets to we can post-filter and
                // remove any target changes.
                // We need to decrement the number of pending acks needed from watch
                // for this targetId.
                r.Ae(), r._e || e.removeTarget(n);
                break;

              case 3 /* Current */ :
                e.Fe(n) && (r.Re(), r.de(t.resumeToken));
                break;

              case 4 /* Reset */ :
                e.Fe(n) && (
                // Reset the target and synthesizes removes for all existing
                // documents. The backend will re-add any documents that still
                // match the target before it sends the next global snapshot.
                e.xe(n), r.de(t.resumeToken));
                break;

              default:
                D();
            }
        }));
    }, 
    /**
     * Iterates over all targetIds that the watch change applies to: either the
     * targetIds explicitly listed in the change or the targetIds of all currently
     * active targets.
     */
    t.prototype.Ce = function(t, e) {
        var n = this;
        t.targetIds.length > 0 ? t.targetIds.forEach(e) : this.Pe.forEach((function(t, r) {
            n.Fe(r) && e(r);
        }));
    }, 
    /**
     * Handles existence filters and synthesizes deletes for filter mismatches.
     * Targets that are invalidated by filter mismatches are added to
     * `pendingTargetResets`.
     */
    t.prototype.$e = function(t) {
        var e = t.targetId, n = t.oe.count, r = this.ke(e);
        if (r) {
            var i = r.target;
            if (At(i)) if (0 === n) {
                // The existence filter told us the document does not exist. We deduce
                // that this document does not exist and apply a deleted document to
                // our updates. Without applying this deleted document there might be
                // another query that will raise this document as part of a snapshot
                // until it is resolved, essentially exposing inconsistency between
                // queries.
                var o = new F(i.path);
                this.Se(e, o, new Bn(o, gt.min()));
            } else k(1 === n); else this.Me(e) !== n && (
            // Existence filter mismatch: We reset the mapping and raise a new
            // snapshot with `isFromCache:true`.
            this.xe(e), this.pe = this.pe.add(e));
        }
    }, 
    /**
     * Converts the currently accumulated state into a remote event at the
     * provided snapshot version. Resets the accumulated changes before returning.
     */
    t.prototype.Oe = function(t) {
        var e = this, n = new Map;
        this.Pe.forEach((function(r, i) {
            var o = e.ke(i);
            if (o) {
                if (r.te && At(o.target)) {
                    // Document queries for document that don't exist can produce an empty
                    // result set. To update our local cache, we synthesize a document
                    // delete if we have not previously received the document. This
                    // resolves the limbo state of the document, removing it from
                    // limboDocumentRefs.
                    // TODO(dimond): Ideally we would have an explicit lookup target
                    // instead resulting in an explicit delete message and we could
                    // remove this special logic.
                    var s = new F(o.target.path);
                    null !== e.ye.get(s) || e.Le(i, s) || e.Se(i, s, new Bn(s, t));
                }
                r.fe && (n.set(i, r.we()), r.me());
            }
        }));
        var r = Kt();
        // We extract the set of limbo-only document updates as the GC logic
        // special-cases documents that do not appear in the target cache.
        // TODO(gsoltis): Expand on this comment once GC is available in the JS
        // client.
                this.Ve.forEach((function(t, n) {
            var i = !0;
            n.xt((function(t) {
                var n = e.ke(t);
                return !n || 2 /* LimboResolution */ === n.et || (i = !1, !1);
            })), i && (r = r.add(t));
        }));
        var i = new Xt(t, n, this.pe, this.ye, r);
        return this.ye = Mt(), this.Ve = ie(), this.pe = new Ut(st), i;
    }, 
    /**
     * Adds the provided document to the internal list of document updates and
     * its document key to the given target's mapping.
     */
    // Visible for testing.
    t.prototype.ve = function(t, e) {
        if (this.Fe(t)) {
            var n = this.Le(t, e.key) ? 2 /* Modified */ : 0 /* Added */;
            this.Ne(t).Te(e.key, n), this.ye = this.ye.ot(e.key, e), this.Ve = this.Ve.ot(e.key, this.Be(e.key).add(t));
        }
    }, 
    /**
     * Removes the provided document from the target mapping. If the
     * document no longer matches the target, but the document's state is still
     * known (e.g. we know that the document was deleted or we received the change
     * that caused the filter mismatch), the new document can be provided
     * to update the remote document cache.
     */
    // Visible for testing.
    t.prototype.Se = function(t, e, n) {
        if (this.Fe(t)) {
            var r = this.Ne(t);
            this.Le(t, e) ? r.Te(e, 1 /* Removed */) : 
            // The document may have entered and left the target before we raised a
            // snapshot, so we can just ignore the change.
            r.Ee(e), this.Ve = this.Ve.ot(e, this.Be(e).delete(t)), n && (this.ye = this.ye.ot(e, n));
        }
    }, t.prototype.removeTarget = function(t) {
        this.Pe.delete(t);
    }, 
    /**
     * Returns the current count of documents in the target. This includes both
     * the number of documents that the LocalStore considers to be part of the
     * target as well as any accumulated changes.
     */
    t.prototype.Me = function(t) {
        var e = this.Ne(t).we();
        return this.ge.qe(t).size + e.ee.size - e.se.size;
    }, 
    /**
     * Increment the number of acks needed from watch before we can consider the
     * server to be 'in-sync' with the client's active targets.
     */
    t.prototype.Ie = function(t) {
        this.Ne(t).Ie();
    }, t.prototype.Ne = function(t) {
        var e = this.Pe.get(t);
        return e || (e = new ne, this.Pe.set(t, e)), e;
    }, t.prototype.Be = function(t) {
        var e = this.Ve.get(t);
        return e || (e = new Ut(st), this.Ve = this.Ve.ot(t, e)), e;
    }, 
    /**
     * Verifies that the user is still interested in this target (by calling
     * `getTargetDataForTarget()`) and that we are not waiting for pending ADDs
     * from watch.
     */
    t.prototype.Fe = function(t) {
        var e = null !== this.ke(t);
        return e || T("WatchChangeAggregator", "Detected inactive target", t), e;
    }, 
    /**
     * Returns the TargetData for an active target (i.e. a target that the user
     * is still interested in that has no outstanding target change requests).
     */
    t.prototype.ke = function(t) {
        var e = this.Pe.get(t);
        return e && e._e ? null : this.ge.Ue(t);
    }, 
    /**
     * Resets the state of a Watch target to its initial state (e.g. sets
     * 'current' to false, clears the resume token and removes its target mapping
     * from all documents).
     */
    t.prototype.xe = function(t) {
        var e = this;
        this.Pe.set(t, new ne), this.ge.qe(t).forEach((function(n) {
            e.Se(t, n, /*updatedDocument=*/ null);
        }));
    }, 
    /**
     * Returns whether the LocalStore considers the document to be part of the
     * specified target.
     */
    t.prototype.Le = function(t, e) {
        return this.ge.qe(t).has(e);
    }, t;
}();

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * DocumentChangeSet keeps track of a set of changes to docs in a query, merging
 * duplicate events for the same doc.
 */ function ie() {
    return new Ot(F.i);
}

function oe() {
    return new Ot(F.i);
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Represents a locally-applied ServerTimestamp.
 *
 * Server Timestamps are backed by MapValues that contain an internal field
 * `__type__` with a value of `server_timestamp`. The previous value and local
 * write time are stored in its `__previous_value__` and `__local_write_time__`
 * fields respectively.
 *
 * Notes:
 * - ServerTimestampValue instances are created as the result of applying a
 *   TransformMutation (see TransformMutation.applyTo()). They can only exist in
 *   the local view of a document. Therefore they do not need to be parsed or
 *   serialized.
 * - When evaluated locally (e.g. for snapshot.data()), they by default
 *   evaluate to `null`. This behavior can be configured by passing custom
 *   FieldValueOptions to value().
 * - With respect to other ServerTimestampValues, they sort by their
 *   localWriteTime.
 */ function se(t) {
    var e, n;
    return "server_timestamp" === (null === (n = ((null === (e = null == t ? void 0 : t.mapValue) || void 0 === e ? void 0 : e.fields) || {}).__type__) || void 0 === n ? void 0 : n.stringValue);
}

/**
 * Creates a new ServerTimestamp proto value (using the internal format).
 */
/**
 * Returns the value of the field before this ServerTimestamp was set.
 *
 * Preserving the previous values allows the user to display the last resoled
 * value until the backend responds with the timestamp.
 */ function ue(t) {
    var e = t.mapValue.fields.__previous_value__;
    return se(e) ? ue(e) : e;
}

/**
 * Returns the local time at which this timestamp was first set.
 */ function ae(t) {
    var e = me(t.mapValue.fields.__local_write_time__.timestampValue);
    return new mt(e.seconds, e.nanos);
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// A RegExp matching ISO 8601 UTC timestamps with optional fraction.
var ce = new RegExp(/^\d{4}-\d\d-\d\dT\d\d:\d\d:\d\d(?:\.(\d+))?Z$/);

/** Extracts the backend's type order for the provided value. */ function he(t) {
    return "nullValue" in t ? 0 /* NullValue */ : "booleanValue" in t ? 1 /* BooleanValue */ : "integerValue" in t || "doubleValue" in t ? 2 /* NumberValue */ : "timestampValue" in t ? 3 /* TimestampValue */ : "stringValue" in t ? 5 /* StringValue */ : "bytesValue" in t ? 6 /* BlobValue */ : "referenceValue" in t ? 7 /* RefValue */ : "geoPointValue" in t ? 8 /* GeoPointValue */ : "arrayValue" in t ? 9 /* ArrayValue */ : "mapValue" in t ? se(t) ? 4 /* ServerTimestampValue */ : 10 /* ObjectValue */ : D();
}

/** Tests `left` and `right` for equality based on the backend semantics. */ function fe(t, e) {
    var n = he(t);
    if (n !== he(e)) return !1;
    switch (n) {
      case 0 /* NullValue */ :
        return !0;

      case 1 /* BooleanValue */ :
        return t.booleanValue === e.booleanValue;

      case 4 /* ServerTimestampValue */ :
        return ae(t).isEqual(ae(e));

      case 3 /* TimestampValue */ :
        return function(t, e) {
            if ("string" == typeof t.timestampValue && "string" == typeof e.timestampValue && t.timestampValue.length === e.timestampValue.length) 
            // Use string equality for ISO 8601 timestamps
            return t.timestampValue === e.timestampValue;
            var n = me(t.timestampValue), r = me(e.timestampValue);
            return n.seconds === r.seconds && n.nanos === r.nanos;
        }(t, e);

      case 5 /* StringValue */ :
        return t.stringValue === e.stringValue;

      case 6 /* BlobValue */ :
        return function(t, e) {
            return we(t.bytesValue).isEqual(we(e.bytesValue));
        }(t, e);

      case 7 /* RefValue */ :
        return t.referenceValue === e.referenceValue;

      case 8 /* GeoPointValue */ :
        return function(t, e) {
            return ge(t.geoPointValue.latitude) === ge(e.geoPointValue.latitude) && ge(t.geoPointValue.longitude) === ge(e.geoPointValue.longitude);
        }(t, e);

      case 2 /* NumberValue */ :
        return function(t, e) {
            if ("integerValue" in t && "integerValue" in e) return ge(t.integerValue) === ge(e.integerValue);
            if ("doubleValue" in t && "doubleValue" in e) {
                var n = ge(t.doubleValue), r = ge(e.doubleValue);
                return n === r ? bt(n) === bt(r) : isNaN(n) && isNaN(r);
            }
            return !1;
        }(t, e);

      case 9 /* ArrayValue */ :
        return ut(t.arrayValue.values || [], e.arrayValue.values || [], fe);

      case 10 /* ObjectValue */ :
        return function(t, e) {
            var n = t.mapValue.fields || {}, r = e.mapValue.fields || {};
            if (L(n) !== L(r)) return !1;
            for (var i in n) if (n.hasOwnProperty(i) && (void 0 === r[i] || !fe(n[i], r[i]))) return !1;
            return !0;
        }(t, e);

      default:
        return D();
    }
}

function le(t, e) {
    return void 0 !== (t.values || []).find((function(t) {
        return fe(t, e);
    }));
}

function pe(t, e) {
    var n = he(t), r = he(e);
    if (n !== r) return st(n, r);
    switch (n) {
      case 0 /* NullValue */ :
        return 0;

      case 1 /* BooleanValue */ :
        return st(t.booleanValue, e.booleanValue);

      case 2 /* NumberValue */ :
        return function(t, e) {
            var n = ge(t.integerValue || t.doubleValue), r = ge(e.integerValue || e.doubleValue);
            return n < r ? -1 : n > r ? 1 : n === r ? 0 : 
            // one or both are NaN.
            isNaN(n) ? isNaN(r) ? 0 : -1 : 1;
        }(t, e);

      case 3 /* TimestampValue */ :
        return de(t.timestampValue, e.timestampValue);

      case 4 /* ServerTimestampValue */ :
        return de(ae(t), ae(e));

      case 5 /* StringValue */ :
        return st(t.stringValue, e.stringValue);

      case 6 /* BlobValue */ :
        return function(t, e) {
            var n = we(t), r = we(e);
            return n.L(r);
        }(t.bytesValue, e.bytesValue);

      case 7 /* RefValue */ :
        return function(t, e) {
            for (var n = t.split("/"), r = e.split("/"), i = 0; i < n.length && i < r.length; i++) {
                var o = st(n[i], r[i]);
                if (0 !== o) return o;
            }
            return st(n.length, r.length);
        }(t.referenceValue, e.referenceValue);

      case 8 /* GeoPointValue */ :
        return function(t, e) {
            var n = st(ge(t.latitude), ge(e.latitude));
            return 0 !== n ? n : st(ge(t.longitude), ge(e.longitude));
        }(t.geoPointValue, e.geoPointValue);

      case 9 /* ArrayValue */ :
        return function(t, e) {
            for (var n = t.values || [], r = e.values || [], i = 0; i < n.length && i < r.length; ++i) {
                var o = pe(n[i], r[i]);
                if (o) return o;
            }
            return st(n.length, r.length);
        }(t.arrayValue, e.arrayValue);

      case 10 /* ObjectValue */ :
        return function(t, e) {
            var n = t.fields || {}, r = Object.keys(n), i = e.fields || {}, o = Object.keys(i);
            // Even though MapValues are likely sorted correctly based on their insertion
            // order (e.g. when received from the backend), local modifications can bring
            // elements out of order. We need to re-sort the elements to ensure that
            // canonical IDs are independent of insertion order.
                        r.sort(), o.sort();
            for (var s = 0; s < r.length && s < o.length; ++s) {
                var u = st(r[s], o[s]);
                if (0 !== u) return u;
                var a = pe(n[r[s]], i[o[s]]);
                if (0 !== a) return a;
            }
            return st(r.length, o.length);
        }(t.mapValue, e.mapValue);

      default:
        throw D();
    }
}

function de(t, e) {
    if ("string" == typeof t && "string" == typeof e && t.length === e.length) return st(t, e);
    var n = me(t), r = me(e), i = st(n.seconds, r.seconds);
    return 0 !== i ? i : st(n.nanos, r.nanos);
}

function ve(t) {
    return ye(t);
}

function ye(t) {
    return "nullValue" in t ? "null" : "booleanValue" in t ? "" + t.booleanValue : "integerValue" in t ? "" + t.integerValue : "doubleValue" in t ? "" + t.doubleValue : "timestampValue" in t ? function(t) {
        var e = me(t);
        return "time(" + e.seconds + "," + e.nanos + ")";
    }(t.timestampValue) : "stringValue" in t ? t.stringValue : "bytesValue" in t ? we(t.bytesValue).toBase64() : "referenceValue" in t ? (n = t.referenceValue, 
    F.C(n).toString()) : "geoPointValue" in t ? "geo(" + (e = t.geoPointValue).latitude + "," + e.longitude + ")" : "arrayValue" in t ? function(t) {
        for (var e = "[", n = !0, r = 0, i = t.values || []; r < i.length; r++) {
            n ? n = !1 : e += ",", e += ye(i[r]);
        }
        return e + "]";
    }(t.arrayValue) : "mapValue" in t ? function(t) {
        for (
        // Iteration order in JavaScript is not guaranteed. To ensure that we generate
        // matching canonical IDs for identical maps, we need to sort the keys.
        var e = "{", n = !0, r = 0, i = Object.keys(t.fields || {}).sort(); r < i.length; r++) {
            var o = i[r];
            n ? n = !1 : e += ",", e += o + ":" + ye(t.fields[o]);
        }
        return e + "}";
    }(t.mapValue) : D();
    var e, n;
}

function me(t) {
    // The json interface (for the browser) will return an iso timestamp string,
    // while the proto js library (for node) will return a
    // google.protobuf.Timestamp instance.
    if (k(!!t), "string" == typeof t) {
        // The date string can have higher precision (nanos) than the Date class
        // (millis), so we do some custom parsing here.
        // Parse the nanos right out of the string.
        var e = 0, n = ce.exec(t);
        if (k(!!n), n[1]) {
            // Pad the fraction out to 9 digits (nanos).
            var r = n[1];
            r = (r + "000000000").substr(0, 9), e = Number(r);
        }
        // Parse the date to get the seconds.
                var i = new Date(t);
        return {
            seconds: Math.floor(i.getTime() / 1e3),
            nanos: e
        };
    }
    return {
        seconds: ge(t.seconds),
        nanos: ge(t.nanos)
    };
}

/**
 * Converts the possible Proto types for numbers into a JavaScript number.
 * Returns 0 if the value is not numeric.
 */ function ge(t) {
    // TODO(bjornick): Handle int64 greater than 53 bits.
    return "number" == typeof t ? t : "string" == typeof t ? Number(t) : 0;
}

/** Converts the possible Proto types for Blobs into a ByteString. */ function we(t) {
    return "string" == typeof t ? ct.fromBase64String(t) : ct.fromUint8Array(t);
}

/** Returns a reference value for the provided database and key. */ function be(t, e) {
    return {
        referenceValue: "projects/" + t.projectId + "/databases/" + t.database + "/documents/" + e.path.R()
    };
}

/** Returns true if `value` is an IntegerValue . */ function Ie(t) {
    return !!t && "integerValue" in t;
}

/** Returns true if `value` is a DoubleValue. */
/** Returns true if `value` is an ArrayValue. */ function Ee(t) {
    return !!t && "arrayValue" in t;
}

/** Returns true if `value` is a NullValue. */ function _e(t) {
    return !!t && "nullValue" in t;
}

/** Returns true if `value` is NaN. */ function Te(t) {
    return !!t && "doubleValue" in t && isNaN(Number(t.doubleValue));
}

/** Returns true if `value` is a MapValue. */ function Ne(t) {
    return !!t && "mapValue" in t;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ var Ae = {
    asc: "ASCENDING",
    desc: "DESCENDING"
}, Se = {
    "<": "LESS_THAN",
    "<=": "LESS_THAN_OR_EQUAL",
    ">": "GREATER_THAN",
    ">=": "GREATER_THAN_OR_EQUAL",
    "==": "EQUAL",
    "!=": "NOT_EQUAL",
    "array-contains": "ARRAY_CONTAINS",
    in: "IN",
    "not-in": "NOT_IN",
    "array-contains-any": "ARRAY_CONTAINS_ANY"
}, De = function(t, e) {
    this.U = t, this.Qe = e;
};

/**
 * This class generates JsonObject values for the Datastore API suitable for
 * sending to either GRPC stub methods or via the JSON/HTTP REST API.
 *
 * The serializer supports both Protobuf.js and Proto3 JSON formats. By
 * setting `useProto3Json` to true, the serializer will use the Proto3 JSON
 * format.
 *
 * For a description of the Proto3 JSON format check
 * https://developers.google.com/protocol-buffers/docs/proto3#json
 *
 * TODO(klimt): We can remove the databaseId argument if we keep the full
 * resource name in documents.
 */
/**
 * Returns an IntegerValue for `value`.
 */
function ke(t) {
    return {
        integerValue: "" + t
    };
}

/**
 * Returns an DoubleValue for `value` that is encoded based the serializer's
 * `useProto3Json` setting.
 */ function xe(t, e) {
    if (t.Qe) {
        if (isNaN(e)) return {
            doubleValue: "NaN"
        };
        if (e === 1 / 0) return {
            doubleValue: "Infinity"
        };
        if (e === -1 / 0) return {
            doubleValue: "-Infinity"
        };
    }
    return {
        doubleValue: bt(e) ? "-0" : e
    };
}

/**
 * Returns a value for a number that's appropriate to put into a proto.
 * The return value is an IntegerValue if it can safely represent the value,
 * otherwise a DoubleValue is returned.
 */ function Le(t, e) {
    return It(e) ? ke(e) : xe(t, e);
}

/**
 * Returns a value for a Date that's appropriate to put into a proto.
 */ function Re(t, e) {
    return t.Qe ? new Date(1e3 * e.seconds).toISOString().replace(/\.\d*/, "").replace("Z", "") + "." + ("000000000" + e.nanoseconds).slice(-9) + "Z" : {
        seconds: "" + e.seconds,
        nanos: e.nanoseconds
    };
}

/**
 * Returns a value for bytes that's appropriate to put in a proto.
 *
 * Visible for testing.
 */ function Oe(t, e) {
    return t.Qe ? e.toBase64() : e.toUint8Array();
}

/**
 * Returns a ByteString based on the proto string value.
 */ function Pe(t, e) {
    return Re(t, e.Z());
}

function Ve(t) {
    return k(!!t), gt.J(function(t) {
        var e = me(t);
        return new mt(e.seconds, e.nanos);
    }(t));
}

function Ue(t, e) {
    return function(t) {
        return new V([ "projects", t.projectId, "databases", t.database ]);
    }(t).child("documents").child(e).R();
}

function Ce(t) {
    var e = V.g(t);
    return k(un(e)), e;
}

function Fe(t, e) {
    return Ue(t.U, e.path);
}

function Me(t, e) {
    var n = Ce(e);
    return k(n.get(1) === t.U.projectId), k(!n.get(3) && !t.U.database || n.get(3) === t.U.database), 
    new F(ze(n));
}

function qe(t, e) {
    return Ue(t.U, e);
}

function je(t) {
    var e = Ce(t);
    // In v1beta1 queries for collections at the root did not have a trailing
    // "/documents". In v1 all resource paths contain "/documents". Preserve the
    // ability to read the v1beta1 form for compatibility with queries persisted
    // in the local target cache.
        return 4 === e.length ? V.P() : ze(e);
}

function Ge(t) {
    return new V([ "projects", t.U.projectId, "databases", t.U.database ]).R();
}

function ze(t) {
    return k(t.length > 4 && "documents" === t.get(4)), t.u(5)
    /** Creates a Document proto from key and fields (but no create/update time) */;
}

function Be(t, e, n) {
    return {
        name: Fe(t, e),
        fields: n.proto.mapValue.fields
    };
}

function Ke(t, e) {
    var n;
    if (e instanceof Ln) n = {
        update: Be(t, e.key, e.value)
    }; else if (e instanceof Cn) n = {
        delete: Fe(t, e.key)
    }; else if (e instanceof Rn) n = {
        update: Be(t, e.key, e.data),
        updateMask: sn(e.We)
    }; else if (e instanceof Pn) n = {
        transform: {
            document: Fe(t, e.key),
            fieldTransforms: e.fieldTransforms.map((function(t) {
                return function(t, e) {
                    var n = e.transform;
                    if (n instanceof ln) return {
                        fieldPath: e.field.R(),
                        setToServerValue: "REQUEST_TIME"
                    };
                    if (n instanceof pn) return {
                        fieldPath: e.field.R(),
                        appendMissingElements: {
                            values: n.elements
                        }
                    };
                    if (n instanceof vn) return {
                        fieldPath: e.field.R(),
                        removeAllFromArray: {
                            values: n.elements
                        }
                    };
                    if (n instanceof mn) return {
                        fieldPath: e.field.R(),
                        increment: n.je
                    };
                    throw D();
                }(0, t);
            }))
        }
    }; else {
        if (!(e instanceof Fn)) return D();
        n = {
            verify: Fe(t, e.key)
        };
    }
    return e.Ge.Ke || (n.currentDocument = function(t, e) {
        return void 0 !== e.updateTime ? {
            updateTime: Pe(t, e.updateTime)
        } : void 0 !== e.exists ? {
            exists: e.exists
        } : D();
    }(t, e.Ge)), n;
}

function We(t, e) {
    var n = e.currentDocument ? function(t) {
        return void 0 !== t.updateTime ? _n.updateTime(Ve(t.updateTime)) : void 0 !== t.exists ? _n.exists(t.exists) : _n.ze();
    }(e.currentDocument) : _n.ze();
    if (e.update) {
        e.update.name;
        var r = Me(t, e.update.name), i = new Mn({
            mapValue: {
                fields: e.update.fields
            }
        });
        if (e.updateMask) {
            var o = function(t) {
                var e = t.fieldPaths || [];
                return new bn(e.map((function(t) {
                    return C.S(t);
                })));
            }(e.updateMask);
            return new Rn(r, i, o, n);
        }
        return new Ln(r, i, n);
    }
    if (e.delete) {
        var s = Me(t, e.delete);
        return new Cn(s, n);
    }
    if (e.transform) {
        var u = Me(t, e.transform.document), a = e.transform.fieldTransforms.map((function(e) {
            return function(t, e) {
                var n = null;
                if ("setToServerValue" in e) k("REQUEST_TIME" === e.setToServerValue), n = new ln; else if ("appendMissingElements" in e) {
                    var r = e.appendMissingElements.values || [];
                    n = new pn(r);
                } else if ("removeAllFromArray" in e) {
                    var i = e.removeAllFromArray.values || [];
                    n = new vn(i);
                } else "increment" in e ? n = new mn(t, e.increment) : D();
                var o = C.S(e.fieldPath);
                return new In(o, n);
            }(t, e);
        }));
        return k(!0 === n.exists), new Pn(u, a);
    }
    if (e.verify) {
        var c = Me(t, e.verify);
        return new Fn(c, n);
    }
    return D();
}

function Qe(t, e) {
    return {
        documents: [ qe(t, e.path) ]
    };
}

function He(t, e) {
    // Dissect the path into parent, collectionId, and optional key filter.
    var n = {
        structuredQuery: {}
    }, r = e.path;
    null !== e.collectionGroup ? (n.parent = qe(t, r), n.structuredQuery.from = [ {
        collectionId: e.collectionGroup,
        allDescendants: !0
    } ]) : (n.parent = qe(t, r.h()), n.structuredQuery.from = [ {
        collectionId: r._()
    } ]);
    var i = function(t) {
        if (0 !== t.length) {
            var e = t.map((function(t) {
                // visible for testing
                return function(t) {
                    if ("==" /* EQUAL */ === t.op) {
                        if (Te(t.value)) return {
                            unaryFilter: {
                                field: en(t.field),
                                op: "IS_NAN"
                            }
                        };
                        if (_e(t.value)) return {
                            unaryFilter: {
                                field: en(t.field),
                                op: "IS_NULL"
                            }
                        };
                    } else if ("!=" /* NOT_EQUAL */ === t.op) {
                        if (Te(t.value)) return {
                            unaryFilter: {
                                field: en(t.field),
                                op: "IS_NOT_NAN"
                            }
                        };
                        if (_e(t.value)) return {
                            unaryFilter: {
                                field: en(t.field),
                                op: "IS_NOT_NULL"
                            }
                        };
                    }
                    return {
                        fieldFilter: {
                            field: en(t.field),
                            op: tn(t.op),
                            value: t.value
                        }
                    };
                }(t);
            }));
            return 1 === e.length ? e[0] : {
                compositeFilter: {
                    op: "AND",
                    filters: e
                }
            };
        }
    }(e.filters);
    i && (n.structuredQuery.where = i);
    var o = function(t) {
        if (0 !== t.length) return t.map((function(t) {
            // visible for testing
            return function(t) {
                return {
                    field: en(t.field),
                    direction: Ze(t.dir)
                };
            }(t);
        }));
    }(e.orderBy);
    o && (n.structuredQuery.orderBy = o);
    var s = function(t, e) {
        return t.Qe || wt(e) ? e : {
            value: e
        };
    }(t, e.limit);
    return null !== s && (n.structuredQuery.limit = s), e.startAt && (n.structuredQuery.startAt = Xe(e.startAt)), 
    e.endAt && (n.structuredQuery.endAt = Xe(e.endAt)), n;
}

function Ye(t) {
    var e = je(t.parent), n = t.structuredQuery, r = n.from ? n.from.length : 0, i = null;
    if (r > 0) {
        k(1 === r);
        var o = n.from[0];
        o.allDescendants ? i = o.collectionId : e = e.child(o.collectionId);
    }
    var s = [];
    n.where && (s = $e(n.where));
    var u = [];
    n.orderBy && (u = n.orderBy.map((function(t) {
        return function(t) {
            return new _r(nn(t.field), 
            // visible for testing
            function(t) {
                switch (t) {
                  case "ASCENDING":
                    return "asc" /* ASCENDING */;

                  case "DESCENDING":
                    return "desc" /* DESCENDING */;

                  default:
                    return;
                }
            }(t.direction));
        }(t);
    })));
    var a = null;
    n.limit && (a = function(t) {
        var e;
        return wt(e = "object" == typeof t ? t.value : t) ? null : e;
    }(n.limit));
    var c = null;
    n.startAt && (c = Je(n.startAt));
    var h = null;
    return n.endAt && (h = Je(n.endAt)), er(Qn(e, i, u, s, a, "F" /* First */ , c, h));
}

function $e(t) {
    return t ? void 0 !== t.unaryFilter ? [ on(t) ] : void 0 !== t.fieldFilter ? [ rn(t) ] : void 0 !== t.compositeFilter ? t.compositeFilter.filters.map((function(t) {
        return $e(t);
    })).reduce((function(t, e) {
        return t.concat(e);
    })) : D() : [];
}

function Xe(t) {
    return {
        before: t.before,
        values: t.position
    };
}

function Je(t) {
    var e = !!t.before, n = t.values || [];
    return new wr(n, e);
}

// visible for testing
function Ze(t) {
    return Ae[t];
}

function tn(t) {
    return Se[t];
}

function en(t) {
    return {
        fieldPath: t.R()
    };
}

function nn(t) {
    return C.S(t.fieldPath);
}

function rn(t) {
    return hr.create(nn(t.fieldFilter.field), function(t) {
        switch (t) {
          case "EQUAL":
            return "==" /* EQUAL */;

          case "NOT_EQUAL":
            return "!=" /* NOT_EQUAL */;

          case "GREATER_THAN":
            return ">" /* GREATER_THAN */;

          case "GREATER_THAN_OR_EQUAL":
            return ">=" /* GREATER_THAN_OR_EQUAL */;

          case "LESS_THAN":
            return "<" /* LESS_THAN */;

          case "LESS_THAN_OR_EQUAL":
            return "<=" /* LESS_THAN_OR_EQUAL */;

          case "ARRAY_CONTAINS":
            return "array-contains" /* ARRAY_CONTAINS */;

          case "IN":
            return "in" /* IN */;

          case "NOT_IN":
            return "not-in" /* NOT_IN */;

          case "ARRAY_CONTAINS_ANY":
            return "array-contains-any" /* ARRAY_CONTAINS_ANY */;

          case "OPERATOR_UNSPECIFIED":
          default:
            return D();
        }
    }(t.fieldFilter.op), t.fieldFilter.value);
}

function on(t) {
    switch (t.unaryFilter.op) {
      case "IS_NAN":
        var e = nn(t.unaryFilter.field);
        return hr.create(e, "==" /* EQUAL */ , {
            doubleValue: NaN
        });

      case "IS_NULL":
        var n = nn(t.unaryFilter.field);
        return hr.create(n, "==" /* EQUAL */ , {
            nullValue: "NULL_VALUE"
        });

      case "IS_NOT_NAN":
        var r = nn(t.unaryFilter.field);
        return hr.create(r, "!=" /* NOT_EQUAL */ , {
            doubleValue: NaN
        });

      case "IS_NOT_NULL":
        var i = nn(t.unaryFilter.field);
        return hr.create(i, "!=" /* NOT_EQUAL */ , {
            nullValue: "NULL_VALUE"
        });

      case "OPERATOR_UNSPECIFIED":
      default:
        return D();
    }
}

function sn(t) {
    var e = [];
    return t.fields.forEach((function(t) {
        return e.push(t.R());
    })), {
        fieldPaths: e
    };
}

function un(t) {
    // Resource names have at least 4 components (project ID, database ID)
    return t.length >= 4 && "projects" === t.get(0) && "databases" === t.get(2);
}

/**
 * @license
 * Copyright 2018 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** Represents a transform within a TransformMutation. */ var an = function() {
    // Make sure that the structural type of `TransformOperation` is unique.
    // See https://github.com/microsoft/TypeScript/issues/5451
    this.He = void 0;
};

/**
 * Computes the local transform result against the provided `previousValue`,
 * optionally using the provided localWriteTime.
 */ function cn(t, e, n) {
    return t instanceof ln ? function(t, e) {
        var n = {
            fields: {
                __type__: {
                    stringValue: "server_timestamp"
                },
                __local_write_time__: {
                    timestampValue: {
                        seconds: t.seconds,
                        nanos: t.nanoseconds
                    }
                }
            }
        };
        return e && (n.fields.__previous_value__ = e), {
            mapValue: n
        };
    }(n, e) : t instanceof pn ? dn(t, e) : t instanceof vn ? yn(t, e) : function(t, e) {
        // PORTING NOTE: Since JavaScript's integer arithmetic is limited to 53 bit
        // precision and resolves overflows by reducing precision, we do not
        // manually cap overflows at 2^63.
        var n = fn(t, e), r = gn(n) + gn(t.je);
        return Ie(n) && Ie(t.je) ? ke(r) : xe(t.serializer, r);
    }(t, e);
}

/**
 * Computes a final transform result after the transform has been acknowledged
 * by the server, potentially using the server-provided transformResult.
 */ function hn(t, e, n) {
    // The server just sends null as the transform result for array operations,
    // so we have to calculate a result the same as we do for local
    // applications.
    return t instanceof pn ? dn(t, e) : t instanceof vn ? yn(t, e) : n;
}

/**
 * If this transform operation is not idempotent, returns the base value to
 * persist for this transform. If a base value is returned, the transform
 * operation is always applied to this base value, even if document has
 * already been updated.
 *
 * Base values provide consistent behavior for non-idempotent transforms and
 * allow us to return the same latency-compensated value even if the backend
 * has already applied the transform operation. The base value is null for
 * idempotent transforms, as they can be re-played even if the backend has
 * already applied them.
 *
 * @return a base value to store along with the mutation, or null for
 * idempotent transforms.
 */ function fn(t, e) {
    return t instanceof mn ? Ie(n = e) || function(t) {
        return !!t && "doubleValue" in t;
    }(n) ? e : {
        integerValue: 0
    } : null;
    var n;
}

/** Transforms a value into a server-generated timestamp. */ var ln = /** @class */ function(e) {
    function n() {
        return null !== e && e.apply(this, arguments) || this;
    }
    return t(n, e), n;
}(an), pn = /** @class */ function(e) {
    function n(t) {
        var n = this;
        return (n = e.call(this) || this).elements = t, n;
    }
    return t(n, e), n;
}(an);

/** Transforms an array value via a union operation. */ function dn(t, e) {
    for (var n = wn(e), r = function(t) {
        n.some((function(e) {
            return fe(e, t);
        })) || n.push(t);
    }, i = 0, o = t.elements; i < o.length; i++) {
        r(o[i]);
    }
    return {
        arrayValue: {
            values: n
        }
    };
}

/** Transforms an array value via a remove operation. */ var vn = /** @class */ function(e) {
    function n(t) {
        var n = this;
        return (n = e.call(this) || this).elements = t, n;
    }
    return t(n, e), n;
}(an);

function yn(t, e) {
    for (var n = wn(e), r = function(t) {
        n = n.filter((function(e) {
            return !fe(e, t);
        }));
    }, i = 0, o = t.elements; i < o.length; i++) {
        r(o[i]);
    }
    return {
        arrayValue: {
            values: n
        }
    };
}

/**
 * Implements the backend semantics for locally computed NUMERIC_ADD (increment)
 * transforms. Converts all field values to integers or doubles, but unlike the
 * backend does not cap integer values at 2^63. Instead, JavaScript number
 * arithmetic is used and precision loss can occur for values greater than 2^53.
 */ var mn = /** @class */ function(e) {
    function n(t, n) {
        var r = this;
        return (r = e.call(this) || this).serializer = t, r.je = n, r;
    }
    return t(n, e), n;
}(an);

function gn(t) {
    return ge(t.integerValue || t.doubleValue);
}

function wn(t) {
    return Ee(t) && t.arrayValue.values ? t.arrayValue.values.slice() : [];
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Provides a set of fields that can be used to partially patch a document.
 * FieldMask is used in conjunction with ObjectValue.
 * Examples:
 *   foo - Overwrites foo entirely with the provided value. If foo is not
 *         present in the companion ObjectValue, the field is deleted.
 *   foo.bar - Overwrites only the field bar of the object foo.
 *             If foo is not an object, foo is replaced with an object
 *             containing foo
 */ var bn = /** @class */ function() {
    function t(t) {
        this.fields = t, 
        // TODO(dimond): validation of FieldMask
        // Sort the field mask to support `FieldMask.isEqual()` and assert below.
        t.sort(C.i)
        /**
     * Verifies that `fieldPath` is included by at least one field in this field
     * mask.
     *
     * This is an O(n) operation, where `n` is the size of the field mask.
     */;
    }
    return t.prototype.Ye = function(t) {
        for (var e = 0, n = this.fields; e < n.length; e++) {
            if (n[e].T(t)) return !0;
        }
        return !1;
    }, t.prototype.isEqual = function(t) {
        return ut(this.fields, t.fields, (function(t, e) {
            return t.isEqual(e);
        }));
    }, t;
}(), In = function(t, e) {
    this.field = t, this.transform = e;
};

/** A field path and the TransformOperation to perform upon it. */
/** The result of successfully applying a mutation to the backend. */ var En = function(
/**
     * The version at which the mutation was committed:
     *
     * - For most operations, this is the updateTime in the WriteResult.
     * - For deletes, the commitTime of the WriteResponse (because deletes are
     *   not stored and have no updateTime).
     *
     * Note that these versions can be different: No-op writes will not change
     * the updateTime even though the commitTime advances.
     */
t, 
/**
     * The resulting fields returned from the backend after a
     * TransformMutation has been committed. Contains one FieldValue for each
     * FieldTransform that was in the mutation.
     *
     * Will be null if the mutation was not a TransformMutation.
     */
e) {
    this.version = t, this.transformResults = e;
}, _n = /** @class */ function() {
    function t(t, e) {
        this.updateTime = t, this.exists = e
        /** Creates a new empty Precondition. */;
    }
    return t.ze = function() {
        return new t;
    }, 
    /** Creates a new Precondition with an exists flag. */ t.exists = function(e) {
        return new t(void 0, e);
    }, 
    /** Creates a new Precondition based on a version a document exists at. */ t.updateTime = function(e) {
        return new t(e);
    }, Object.defineProperty(t.prototype, "Ke", {
        /** Returns whether this Precondition is empty. */ get: function() {
            return void 0 === this.updateTime && void 0 === this.exists;
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.isEqual = function(t) {
        return this.exists === t.exists && (this.updateTime ? !!t.updateTime && this.updateTime.isEqual(t.updateTime) : !t.updateTime);
    }, t;
}();

/**
 * Encodes a precondition for a mutation. This follows the model that the
 * backend accepts with the special case of an explicit "empty" precondition
 * (meaning no precondition).
 */
/**
 * Returns true if the preconditions is valid for the given document
 * (or null if no document is available).
 */
function Tn(t, e) {
    return void 0 !== t.updateTime ? e instanceof zn && e.version.isEqual(t.updateTime) : void 0 === t.exists || t.exists === e instanceof zn;
}

/**
 * A mutation describes a self-contained change to a document. Mutations can
 * create, replace, delete, and update subsets of documents.
 *
 * Mutations not only act on the value of the document but also its version.
 *
 * For local mutations (mutations that haven't been committed yet), we preserve
 * the existing version for Set, Patch, and Transform mutations. For Delete
 * mutations, we reset the version to 0.
 *
 * Here's the expected transition table.
 *
 * MUTATION           APPLIED TO            RESULTS IN
 *
 * SetMutation        Document(v3)          Document(v3)
 * SetMutation        NoDocument(v3)        Document(v0)
 * SetMutation        null                  Document(v0)
 * PatchMutation      Document(v3)          Document(v3)
 * PatchMutation      NoDocument(v3)        NoDocument(v3)
 * PatchMutation      null                  null
 * TransformMutation  Document(v3)          Document(v3)
 * TransformMutation  NoDocument(v3)        NoDocument(v3)
 * TransformMutation  null                  null
 * DeleteMutation     Document(v3)          NoDocument(v0)
 * DeleteMutation     NoDocument(v3)        NoDocument(v0)
 * DeleteMutation     null                  NoDocument(v0)
 *
 * For acknowledged mutations, we use the updateTime of the WriteResponse as
 * the resulting version for Set, Patch, and Transform mutations. As deletes
 * have no explicit update time, we use the commitTime of the WriteResponse for
 * Delete mutations.
 *
 * If a mutation is acknowledged by the backend but fails the precondition check
 * locally, we return an `UnknownDocument` and rely on Watch to send us the
 * updated version.
 *
 * Note that TransformMutations don't create Documents (in the case of being
 * applied to a NoDocument), even though they would on the backend. This is
 * because the client always combines the TransformMutation with a SetMutation
 * or PatchMutation and we only want to apply the transform if the prior
 * mutation resulted in a Document (always true for a SetMutation, but not
 * necessarily for a PatchMutation).
 *
 * ## Subclassing Notes
 *
 * Subclasses of Mutation need to implement applyToRemoteDocument() and
 * applyToLocalView() to implement the actual behavior of applying the mutation
 * to some source document.
 */ var Nn = function() {};

/**
 * Applies this mutation to the given MaybeDocument or null for the purposes
 * of computing a new remote document. If the input document doesn't match the
 * expected state (e.g. it is null or outdated), an `UnknownDocument` can be
 * returned.
 *
 * @param mutation The mutation to apply.
 * @param maybeDoc The document to mutate. The input document can be null if
 *     the client has no knowledge of the pre-mutation state of the document.
 * @param mutationResult The result of applying the mutation from the backend.
 * @return The mutated document. The returned document may be an
 *     UnknownDocument if the mutation could not be applied to the locally
 *     cached base document.
 */ function An(t, e, n) {
    return t instanceof Ln ? function(t, e, n) {
        // Unlike applySetMutationToLocalView, if we're applying a mutation to a
        // remote document the server has accepted the mutation so the precondition
        // must have held.
        return new zn(t.key, n.version, t.value, {
            hasCommittedMutations: !0
        });
    }(t, 0, n) : t instanceof Rn ? function(t, e, n) {
        if (!Tn(t.Ge, e)) 
        // Since the mutation was not rejected, we know that the  precondition
        // matched on the backend. We therefore must not have the expected version
        // of the document in our cache and return an UnknownDocument with the
        // known updateTime.
        return new Kn(t.key, n.version);
        var r = On(t, e);
        return new zn(t.key, n.version, r, {
            hasCommittedMutations: !0
        });
    }(t, e, n) : t instanceof Pn ? function(t, e, n) {
        if (k(null != n.transformResults), !Tn(t.Ge, e)) 
        // Since the mutation was not rejected, we know that the  precondition
        // matched on the backend. We therefore must not have the expected version
        // of the document in our cache and return an UnknownDocument with the
        // known updateTime.
        return new Kn(t.key, n.version);
        var r = Vn(t, e), i = 
        /**
 * Creates a list of "transform results" (a transform result is a field value
 * representing the result of applying a transform) for use after a
 * TransformMutation has been acknowledged by the server.
 *
 * @param fieldTransforms The field transforms to apply the result to.
 * @param baseDoc The document prior to applying this mutation batch.
 * @param serverTransformResults The transform results received by the server.
 * @return The transform results list.
 */
        function(t, e, n) {
            var r = [];
            k(t.length === n.length);
            for (var i = 0; i < n.length; i++) {
                var o = t[i], s = o.transform, u = null;
                e instanceof zn && (u = e.field(o.field)), r.push(hn(s, u, n[i]));
            }
            return r;
        }(t.fieldTransforms, e, n.transformResults), o = n.version, s = Un(t, r.data(), i);
        return new zn(t.key, o, s, {
            hasCommittedMutations: !0
        });
    }(t, e, n) : function(t, e, n) {
        // Unlike applyToLocalView, if we're applying a mutation to a remote
        // document the server has accepted the mutation so the precondition must
        // have held.
        return new Bn(t.key, n.version, {
            hasCommittedMutations: !0
        });
    }(t, 0, n);
}

/**
 * Applies this mutation to the given MaybeDocument or null for the purposes
 * of computing the new local view of a document. Both the input and returned
 * documents can be null.
 *
 * @param mutation The mutation to apply.
 * @param maybeDoc The document to mutate. The input document can be null if
 *     the client has no knowledge of the pre-mutation state of the document.
 * @param baseDoc The state of the document prior to this mutation batch. The
 *     input document can be null if the client has no knowledge of the
 *     pre-mutation state of the document.
 * @param localWriteTime A timestamp indicating the local write time of the
 *     batch this mutation is a part of.
 * @return The mutated document. The returned document may be null, but only
 *     if maybeDoc was null and the mutation would not create a new document.
 */ function Sn(t, e, n, r) {
    return t instanceof Ln ? function(t, e) {
        if (!Tn(t.Ge, e)) return e;
        var n = xn(e);
        return new zn(t.key, n, t.value, {
            Je: !0
        });
    }(t, e) : t instanceof Rn ? function(t, e) {
        if (!Tn(t.Ge, e)) return e;
        var n = xn(e), r = On(t, e);
        return new zn(t.key, n, r, {
            Je: !0
        });
    }(t, e) : t instanceof Pn ? function(t, e, n, r) {
        if (!Tn(t.Ge, e)) return e;
        var i = Vn(t, e), o = function(t, e, n, r) {
            for (var i = [], o = 0, s = t; o < s.length; o++) {
                var u = s[o], a = u.transform, c = null;
                n instanceof zn && (c = n.field(u.field)), null === c && r instanceof zn && (
                // If the current document does not contain a value for the mutated
                // field, use the value that existed before applying this mutation
                // batch. This solves an edge case where a PatchMutation clears the
                // values in a nested map before the TransformMutation is applied.
                c = r.field(u.field)), i.push(cn(a, c, e));
            }
            return i;
        }(t.fieldTransforms, n, e, r), s = Un(t, i.data(), o);
        return new zn(t.key, i.version, s, {
            Je: !0
        });
    }(t, e, r, n) : function(t, e) {
        return Tn(t.Ge, e) ? new Bn(t.key, gt.min()) : e;
    }(t, e);
}

/**
 * If this mutation is not idempotent, returns the base value to persist with
 * this mutation. If a base value is returned, the mutation is always applied
 * to this base value, even if document has already been updated.
 *
 * The base value is a sparse object that consists of only the document
 * fields for which this mutation contains a non-idempotent transformation
 * (e.g. a numeric increment). The provided value guarantees consistent
 * behavior for non-idempotent transforms and allow us to return the same
 * latency-compensated value even if the backend has already applied the
 * mutation. The base value is null for idempotent mutations, as they can be
 * re-played even if the backend has already applied them.
 *
 * @return a base value to store along with the mutation, or null for
 * idempotent mutations.
 */ function Dn(t, e) {
    return t instanceof Pn ? function(t, e) {
        for (var n = null, r = 0, i = t.fieldTransforms; r < i.length; r++) {
            var o = i[r], s = e instanceof zn ? e.field(o.field) : void 0, u = fn(o.transform, s || null);
            null != u && (n = null == n ? (new qn).set(o.field, u) : n.set(o.field, u));
        }
        return n ? n.Xe() : null;
    }(t, e) : null;
}

function kn(t, e) {
    return t.type === e.type && !!t.key.isEqual(e.key) && !!t.Ge.isEqual(e.Ge) && (0 /* Set */ === t.type ? t.value.isEqual(e.value) : 1 /* Patch */ === t.type ? t.data.isEqual(e.data) && t.We.isEqual(e.We) : 2 /* Transform */ !== t.type || ut(t.fieldTransforms, t.fieldTransforms, (function(t, e) {
        return function(t, e) {
            return t.field.isEqual(e.field) && function(t, e) {
                return t instanceof pn && e instanceof pn || t instanceof vn && e instanceof vn ? ut(t.elements, e.elements, fe) : t instanceof mn && e instanceof mn ? fe(t.je, e.je) : t instanceof ln && e instanceof ln;
            }(t.transform, e.transform);
        }(t, e);
    })));
}

/**
 * Returns the version from the given document for use as the result of a
 * mutation. Mutations are defined to return the version of the base document
 * only if it is an existing document. Deleted and unknown documents have a
 * post-mutation version of SnapshotVersion.min().
 */ function xn(t) {
    return t instanceof zn ? t.version : gt.min();
}

/**
 * A mutation that creates or replaces the document at the given key with the
 * object value contents.
 */ var Ln = /** @class */ function(e) {
    function n(t, n, r) {
        var i = this;
        return (i = e.call(this) || this).key = t, i.value = n, i.Ge = r, i.type = 0 /* Set */ , 
        i;
    }
    return t(n, e), n;
}(Nn), Rn = /** @class */ function(e) {
    function n(t, n, r, i) {
        var o = this;
        return (o = e.call(this) || this).key = t, o.data = n, o.We = r, o.Ge = i, o.type = 1 /* Patch */ , 
        o;
    }
    return t(n, e), n;
}(Nn);

function On(t, e) {
    return function(t, e) {
        var n = new qn(e);
        return t.We.fields.forEach((function(e) {
            if (!e.m()) {
                var r = t.data.field(e);
                null !== r ? n.set(e, r) : n.delete(e);
            }
        })), n.Xe();
    }(t, e instanceof zn ? e.data() : Mn.empty());
}

var Pn = /** @class */ function(e) {
    function n(t, n) {
        var r = this;
        return (r = e.call(this) || this).key = t, r.fieldTransforms = n, r.type = 2 /* Transform */ , 
        // NOTE: We set a precondition of exists: true as a safety-check, since we
        // always combine TransformMutations with a SetMutation or PatchMutation which
        // (if successful) should end up with an existing document.
        r.Ge = _n.exists(!0), r;
    }
    return t(n, e), n;
}(Nn);

function Vn(t, e) {
    return e;
}

function Un(t, e, n) {
    for (var r = new qn(e), i = 0; i < t.fieldTransforms.length; i++) {
        var o = t.fieldTransforms[i];
        r.set(o.field, n[i]);
    }
    return r.Xe();
}

/** A mutation that deletes the document at the given key. */ var Cn = /** @class */ function(e) {
    function n(t, n) {
        var r = this;
        return (r = e.call(this) || this).key = t, r.Ge = n, r.type = 3 /* Delete */ , r;
    }
    return t(n, e), n;
}(Nn), Fn = /** @class */ function(e) {
    function n(t, n) {
        var r = this;
        return (r = e.call(this) || this).key = t, r.Ge = n, r.type = 4 /* Verify */ , r;
    }
    return t(n, e), n;
}(Nn), Mn = /** @class */ function() {
    function t(t) {
        this.proto = t;
    }
    return t.empty = function() {
        return new t({
            mapValue: {}
        });
    }, 
    /**
     * Returns the value at the given path or null.
     *
     * @param path the path to search
     * @return The value at the path or if there it doesn't exist.
     */
    t.prototype.field = function(t) {
        if (t.m()) return this.proto;
        for (var e = this.proto, n = 0; n < t.length - 1; ++n) {
            if (!e.mapValue.fields) return null;
            if (!Ne(e = e.mapValue.fields[t.get(n)])) return null;
        }
        return (e = (e.mapValue.fields || {})[t._()]) || null;
    }, t.prototype.isEqual = function(t) {
        return fe(this.proto, t.proto);
    }, t;
}(), qn = /** @class */ function() {
    /**
     * @param baseObject The object to mutate.
     */
    function t(t) {
        void 0 === t && (t = Mn.empty()), this.Ze = t, 
        /** A map that contains the accumulated changes in this builder. */
        this.tn = new Map;
    }
    /**
     * Sets the field to the provided value.
     *
     * @param path The field path to set.
     * @param value The value to set.
     * @return The current Builder instance.
     */    return t.prototype.set = function(t, e) {
        return this.en(t, e), this;
    }, 
    /**
     * Removes the field at the specified path. If there is no field at the
     * specified path, nothing is changed.
     *
     * @param path The field path to remove.
     * @return The current Builder instance.
     */
    t.prototype.delete = function(t) {
        return this.en(t, null), this;
    }, 
    /**
     * Adds `value` to the overlay map at `path`. Creates nested map entries if
     * needed.
     */
    t.prototype.en = function(t, e) {
        for (var n = this.tn, r = 0; r < t.length - 1; ++r) {
            var i = t.get(r), o = n.get(i);
            o instanceof Map ? 
            // Re-use a previously created map
            n = o : o && 10 /* ObjectValue */ === he(o) ? (
            // Convert the existing Protobuf MapValue into a map
            o = new Map(Object.entries(o.mapValue.fields || {})), n.set(i, o), n = o) : (
            // Create an empty map to represent the current nesting level
            o = new Map, n.set(i, o), n = o);
        }
        n.set(t._(), e);
    }, 
    /** Returns an ObjectValue with all mutations applied. */ t.prototype.Xe = function() {
        var t = this.nn(C.P(), this.tn);
        return null != t ? new Mn(t) : this.Ze;
    }, 
    /**
     * Applies any overlays from `currentOverlays` that exist at `currentPath`
     * and returns the merged data at `currentPath` (or null if there were no
     * changes).
     *
     * @param currentPath The path at the current nesting level. Can be set to
     * FieldValue.emptyPath() to represent the root.
     * @param currentOverlays The overlays at the current nesting level in the
     * same format as `overlayMap`.
     * @return The merged data at `currentPath` or null if no modifications
     * were applied.
     */
    t.prototype.nn = function(t, e) {
        var n = this, r = !1, i = this.Ze.field(t), o = Ne(i) ? // If there is already data at the current path, base our
        Object.assign({}, i.mapValue.fields) : {};
        return e.forEach((function(e, i) {
            if (e instanceof Map) {
                var s = n.nn(t.child(i), e);
                null != s && (o[i] = s, r = !0);
            } else null !== e ? (o[i] = e, r = !0) : o.hasOwnProperty(i) && (delete o[i], r = !0);
        })), r ? {
            mapValue: {
                fields: o
            }
        } : null;
    }, t;
}();

/**
 * Returns a FieldMask built from all fields in a MapValue.
 */
function jn(t) {
    var e = [];
    return R(t.fields || {}, (function(t, n) {
        var r = new C([ t ]);
        if (Ne(n)) {
            var i = jn(n.mapValue).fields;
            if (0 === i.length) 
            // Preserve the empty map by adding it to the FieldMask.
            e.push(r); else 
            // For nested and non-empty ObjectValues, add the FieldPath of the
            // leaf nodes.
            for (var o = 0, s = i; o < s.length; o++) {
                var u = s[o];
                e.push(r.child(u));
            }
        } else 
        // For nested and non-empty ObjectValues, add the FieldPath of the leaf
        // nodes.
        e.push(r);
    })), new bn(e)
    /**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
    /**
 * The result of a lookup for a given path may be an existing document or a
 * marker that this document does not exist at a given version.
 */;
}

var Gn = function(t, e) {
    this.key = t, this.version = e;
}, zn = /** @class */ function(e) {
    function n(t, n, r, i) {
        var o = this;
        return (o = e.call(this, t, n) || this).sn = r, o.Je = !!i.Je, o.hasCommittedMutations = !!i.hasCommittedMutations, 
        o;
    }
    return t(n, e), n.prototype.field = function(t) {
        return this.sn.field(t);
    }, n.prototype.data = function() {
        return this.sn;
    }, n.prototype.rn = function() {
        return this.sn.proto;
    }, n.prototype.isEqual = function(t) {
        return t instanceof n && this.key.isEqual(t.key) && this.version.isEqual(t.version) && this.Je === t.Je && this.hasCommittedMutations === t.hasCommittedMutations && this.sn.isEqual(t.sn);
    }, n.prototype.toString = function() {
        return "Document(" + this.key + ", " + this.version + ", " + this.sn.toString() + ", {hasLocalMutations: " + this.Je + "}), {hasCommittedMutations: " + this.hasCommittedMutations + "})";
    }, Object.defineProperty(n.prototype, "hasPendingWrites", {
        get: function() {
            return this.Je || this.hasCommittedMutations;
        },
        enumerable: !1,
        configurable: !0
    }), n;
}(Gn), Bn = /** @class */ function(e) {
    function n(t, n, r) {
        var i = this;
        return (i = e.call(this, t, n) || this).hasCommittedMutations = !(!r || !r.hasCommittedMutations), 
        i;
    }
    return t(n, e), n.prototype.toString = function() {
        return "NoDocument(" + this.key + ", " + this.version + ")";
    }, Object.defineProperty(n.prototype, "hasPendingWrites", {
        get: function() {
            return this.hasCommittedMutations;
        },
        enumerable: !1,
        configurable: !0
    }), n.prototype.isEqual = function(t) {
        return t instanceof n && t.hasCommittedMutations === this.hasCommittedMutations && t.version.isEqual(this.version) && t.key.isEqual(this.key);
    }, n;
}(Gn), Kn = /** @class */ function(e) {
    function n() {
        return null !== e && e.apply(this, arguments) || this;
    }
    return t(n, e), n.prototype.toString = function() {
        return "UnknownDocument(" + this.key + ", " + this.version + ")";
    }, Object.defineProperty(n.prototype, "hasPendingWrites", {
        get: function() {
            return !0;
        },
        enumerable: !1,
        configurable: !0
    }), n.prototype.isEqual = function(t) {
        return t instanceof n && t.version.isEqual(this.version) && t.key.isEqual(this.key);
    }, n;
}(Gn), Wn = 
/**
     * Initializes a Query with a path and optional additional query constraints.
     * Path must currently be empty if this is a collection group query.
     */
function(t, e, n, r, i, o /* First */ , s, u) {
    void 0 === e && (e = null), void 0 === n && (n = []), void 0 === r && (r = []), 
    void 0 === i && (i = null), void 0 === o && (o = "F"), void 0 === s && (s = null), 
    void 0 === u && (u = null), this.path = t, this.collectionGroup = e, this.on = n, 
    this.filters = r, this.limit = i, this.an = o, this.startAt = s, this.endAt = u, 
    this.cn = null, 
    // The corresponding `Target` of this `Query` instance.
    this.un = null, this.startAt, this.endAt;
};

/**
 * Represents a document in Firestore with a key, version, data and whether the
 * data has local mutations applied to it.
 */
/** Creates a new Query instance with the options provided. */ function Qn(t, e, n, r, i, o, s, u) {
    return new Wn(t, e, n, r, i, o, s, u);
}

/** Creates a new Query for a query that matches all documents at `path` */ function Hn(t) {
    return new Wn(t);
}

/**
 * Helper to convert a collection group query into a collection query at a
 * specific path. This is used when executing collection group queries, since
 * we have to split the query into a set of collection queries at multiple
 * paths.
 */ function Yn(t) {
    return !wt(t.limit) && "F" /* First */ === t.an;
}

function $n(t) {
    return !wt(t.limit) && "L" /* Last */ === t.an;
}

function Xn(t) {
    return t.on.length > 0 ? t.on[0].field : null;
}

function Jn(t) {
    for (var e = 0, n = t.filters; e < n.length; e++) {
        var r = n[e];
        if (r.hn()) return r.field;
    }
    return null;
}

/**
 * Checks if any of the provided Operators are included in the query and
 * returns the first one that is, or null if none are.
 */
/**
 * Returns whether the query matches a collection group rather than a specific
 * collection.
 */ function Zn(t) {
    return null !== t.collectionGroup;
}

/**
 * Returns the implicit order by constraint that is used to execute the Query,
 * which can be different from the order by constraints the user provided (e.g.
 * the SDK and backend always orders by `__name__`).
 */ function tr(t) {
    var e = x(t);
    if (null === e.cn) {
        e.cn = [];
        var n = Jn(e), r = Xn(e);
        if (null !== n && null === r) 
        // In order to implicitly add key ordering, we must also add the
        // inequality filter field for it to be a valid query.
        // Note that the default inequality field and key ordering is ascending.
        n.p() || e.cn.push(new _r(n)), e.cn.push(new _r(C.v(), "asc" /* ASCENDING */)); else {
            for (var i = !1, o = 0, s = e.on; o < s.length; o++) {
                var u = s[o];
                e.cn.push(u), u.field.p() && (i = !0);
            }
            if (!i) {
                // The order of the implicit key ordering always matches the last
                // explicit order by
                var a = e.on.length > 0 ? e.on[e.on.length - 1].dir : "asc" /* ASCENDING */;
                e.cn.push(new _r(C.v(), a));
            }
        }
    }
    return e.cn;
}

/**
 * Converts this `Query` instance to it's corresponding `Target` representation.
 */ function er(t) {
    var e = x(t);
    if (!e.un) if ("F" /* First */ === e.an) e.un = _t(e.path, e.collectionGroup, tr(e), e.filters, e.limit, e.startAt, e.endAt); else {
        for (
        // Flip the orderBy directions since we want the last results
        var n = [], r = 0, i = tr(e); r < i.length; r++) {
            var o = i[r], s = "desc" /* DESCENDING */ === o.dir ? "asc" /* ASCENDING */ : "desc" /* DESCENDING */;
            n.push(new _r(o.field, s));
        }
        // We need to swap the cursors to match the now-flipped query ordering.
                var u = e.endAt ? new wr(e.endAt.position, !e.endAt.before) : null, a = e.startAt ? new wr(e.startAt.position, !e.startAt.before) : null;
        // Now return as a LimitType.First query.
                e.un = _t(e.path, e.collectionGroup, n, e.filters, e.limit, u, a);
    }
    return e.un;
}

function nr(t, e, n) {
    return new Wn(t.path, t.collectionGroup, t.on.slice(), t.filters.slice(), e, n, t.startAt, t.endAt);
}

function rr(t, e) {
    return new Wn(t.path, t.collectionGroup, t.on.slice(), t.filters.slice(), t.limit, t.an, e, t.endAt);
}

function ir(t, e) {
    return new Wn(t.path, t.collectionGroup, t.on.slice(), t.filters.slice(), t.limit, t.an, t.startAt, e);
}

function or(t, e) {
    return Nt(er(t), er(e)) && t.an === e.an;
}

// TODO(b/29183165): This is used to get a unique string from a query to, for
// example, use as a dictionary key, but the implementation is subject to
// collisions. Make it collision-free.
function sr(t) {
    return Tt(er(t)) + "|lt:" + t.an;
}

function ur(t) {
    return "Query(target=" + function(t) {
        var e = t.path.R();
        return null !== t.collectionGroup && (e += " collectionGroup=" + t.collectionGroup), 
        t.filters.length > 0 && (e += ", filters: [" + t.filters.map((function(t) {
            return (e = t).field.R() + " " + e.op + " " + ve(e.value);
            /** Returns a debug description for `filter`. */            var e;
            /** Filter that matches on key fields (i.e. '__name__'). */        })).join(", ") + "]"), 
        wt(t.limit) || (e += ", limit: " + t.limit), t.orderBy.length > 0 && (e += ", orderBy: [" + t.orderBy.map((function(t) {
            return (e = t).field.R() + " (" + e.dir + ")";
            var e;
        })).join(", ") + "]"), t.startAt && (e += ", startAt: " + br(t.startAt)), t.endAt && (e += ", endAt: " + br(t.endAt)), 
        "Target(" + e + ")";
    }(er(t)) + "; limitType=" + t.an + ")";
}

/** Returns whether `doc` matches the constraints of `query`. */ function ar(t, e) {
    return function(t, e) {
        var n = e.key.path;
        return null !== t.collectionGroup ? e.key.N(t.collectionGroup) && t.path.T(n) : F.F(t.path) ? t.path.isEqual(n) : t.path.I(n);
    }(t, e) && function(t, e) {
        for (var n = 0, r = t.on; n < r.length; n++) {
            var i = r[n];
            // order by key always matches
                        if (!i.field.p() && null === e.field(i.field)) return !1;
        }
        return !0;
    }(t, e) && function(t, e) {
        for (var n = 0, r = t.filters; n < r.length; n++) {
            if (!r[n].matches(e)) return !1;
        }
        return !0;
    }(t, e) && function(t, e) {
        return !(t.startAt && !Ir(t.startAt, tr(t), e)) && (!t.endAt || !Ir(t.endAt, tr(t), e));
    }(t, e);
}

function cr(t) {
    return function(e, n) {
        for (var r = !1, i = 0, o = tr(t); i < o.length; i++) {
            var s = o[i], u = Tr(s, e, n);
            if (0 !== u) return u;
            r = r || s.field.p();
        }
        return 0;
    };
}

var hr = /** @class */ function(e) {
    function n(t, n, r) {
        var i = this;
        return (i = e.call(this) || this).field = t, i.op = n, i.value = r, i;
    }
    /**
     * Creates a filter based on the provided arguments.
     */    return t(n, e), n.create = function(t, e, r) {
        if (t.p()) return "in" /* IN */ === e || "not-in" /* NOT_IN */ === e ? this.ln(t, e, r) : new fr(t, e, r);
        if (_e(r)) {
            if ("==" /* EQUAL */ !== e && "!=" /* NOT_EQUAL */ !== e) throw new I(b.INVALID_ARGUMENT, "Invalid query. Null only supports '==' and '!=' comparisons.");
            return new n(t, e, r);
        }
        if (Te(r)) {
            if ("==" /* EQUAL */ !== e && "!=" /* NOT_EQUAL */ !== e) throw new I(b.INVALID_ARGUMENT, "Invalid query. NaN only supports '==' and '!=' comparisons.");
            return new n(t, e, r);
        }
        return "array-contains" /* ARRAY_CONTAINS */ === e ? new vr(t, r) : "in" /* IN */ === e ? new yr(t, r) : "not-in" /* NOT_IN */ === e ? new mr(t, r) : "array-contains-any" /* ARRAY_CONTAINS_ANY */ === e ? new gr(t, r) : new n(t, e, r);
    }, n.ln = function(t, e, n) {
        return "in" /* IN */ === e ? new lr(t, n) : new pr(t, n);
    }, n.prototype.matches = function(t) {
        var e = t.field(this.field);
        // Types do not have to match in NOT_EQUAL filters.
                return "!=" /* NOT_EQUAL */ === this.op ? null !== e && this._n(pe(e, this.value)) : null !== e && he(this.value) === he(e) && this._n(pe(e, this.value));
        // Only compare types with matching backend order (such as double and int).
        }, n.prototype._n = function(t) {
        switch (this.op) {
          case "<" /* LESS_THAN */ :
            return t < 0;

          case "<=" /* LESS_THAN_OR_EQUAL */ :
            return t <= 0;

          case "==" /* EQUAL */ :
            return 0 === t;

          case "!=" /* NOT_EQUAL */ :
            return 0 !== t;

          case ">" /* GREATER_THAN */ :
            return t > 0;

          case ">=" /* GREATER_THAN_OR_EQUAL */ :
            return t >= 0;

          default:
            return D();
        }
    }, n.prototype.hn = function() {
        return [ "<" /* LESS_THAN */ , "<=" /* LESS_THAN_OR_EQUAL */ , ">" /* GREATER_THAN */ , ">=" /* GREATER_THAN_OR_EQUAL */ , "!=" /* NOT_EQUAL */ , "not-in" /* NOT_IN */ ].indexOf(this.op) >= 0;
    }, n;
}((function() {}));

var fr = /** @class */ function(e) {
    function n(t, n, r) {
        var i = this;
        return (i = e.call(this, t, n, r) || this).key = F.C(r.referenceValue), i;
    }
    return t(n, e), n.prototype.matches = function(t) {
        var e = F.i(t.key, this.key);
        return this._n(e);
    }, n;
}(hr), lr = /** @class */ function(e) {
    function n(t, n) {
        var r = this;
        return (r = e.call(this, t, "in" /* IN */ , n) || this).keys = dr("in" /* IN */ , n), 
        r;
    }
    return t(n, e), n.prototype.matches = function(t) {
        return this.keys.some((function(e) {
            return e.isEqual(t.key);
        }));
    }, n;
}(hr), pr = /** @class */ function(e) {
    function n(t, n) {
        var r = this;
        return (r = e.call(this, t, "not-in" /* NOT_IN */ , n) || this).keys = dr("not-in" /* NOT_IN */ , n), 
        r;
    }
    return t(n, e), n.prototype.matches = function(t) {
        return !this.keys.some((function(e) {
            return e.isEqual(t.key);
        }));
    }, n;
}(hr);

/** Filter that matches on key fields within an array. */ function dr(t, e) {
    var n;
    return ((null === (n = e.arrayValue) || void 0 === n ? void 0 : n.values) || []).map((function(t) {
        return F.C(t.referenceValue);
    }));
}

/** A Filter that implements the array-contains operator. */ var vr = /** @class */ function(e) {
    function n(t, n) {
        return e.call(this, t, "array-contains" /* ARRAY_CONTAINS */ , n) || this;
    }
    return t(n, e), n.prototype.matches = function(t) {
        var e = t.field(this.field);
        return Ee(e) && le(e.arrayValue, this.value);
    }, n;
}(hr), yr = /** @class */ function(e) {
    function n(t, n) {
        return e.call(this, t, "in" /* IN */ , n) || this;
    }
    return t(n, e), n.prototype.matches = function(t) {
        var e = t.field(this.field);
        return null !== e && le(this.value.arrayValue, e);
    }, n;
}(hr), mr = /** @class */ function(e) {
    function n(t, n) {
        return e.call(this, t, "not-in" /* NOT_IN */ , n) || this;
    }
    return t(n, e), n.prototype.matches = function(t) {
        if (le(this.value.arrayValue, {
            nullValue: "NULL_VALUE"
        })) return !1;
        var e = t.field(this.field);
        return null !== e && !le(this.value.arrayValue, e);
    }, n;
}(hr), gr = /** @class */ function(e) {
    function n(t, n) {
        return e.call(this, t, "array-contains-any" /* ARRAY_CONTAINS_ANY */ , n) || this;
    }
    return t(n, e), n.prototype.matches = function(t) {
        var e = this, n = t.field(this.field);
        return !(!Ee(n) || !n.arrayValue.values) && n.arrayValue.values.some((function(t) {
            return le(e.value.arrayValue, t);
        }));
    }, n;
}(hr), wr = function(t, e) {
    this.position = t, this.before = e;
};

/** A Filter that implements the IN operator. */ function br(t) {
    // TODO(b/29183165): Make this collision robust.
    return (t.before ? "b" : "a") + ":" + t.position.map((function(t) {
        return ve(t);
    })).join(",");
}

/**
 * Returns true if a document sorts before a bound using the provided sort
 * order.
 */ function Ir(t, e, n) {
    for (var r = 0, i = 0; i < t.position.length; i++) {
        var o = e[i], s = t.position[i];
        if (r = o.field.p() ? F.i(F.C(s.referenceValue), n.key) : pe(s, n.field(o.field)), 
        "desc" /* DESCENDING */ === o.dir && (r *= -1), 0 !== r) break;
    }
    return t.before ? r <= 0 : r < 0;
}

function Er(t, e) {
    if (null === t) return null === e;
    if (null === e) return !1;
    if (t.before !== e.before || t.position.length !== e.position.length) return !1;
    for (var n = 0; n < t.position.length; n++) if (!fe(t.position[n], e.position[n])) return !1;
    return !0;
}

/**
 * An ordering on a field, in some Direction. Direction defaults to ASCENDING.
 */ var _r = function(t, e /* ASCENDING */) {
    void 0 === e && (e = "asc"), this.field = t, this.dir = e;
};

function Tr(t, e, n) {
    var r = t.field.p() ? F.i(e.key, n.key) : function(t, e, n) {
        var r = e.field(t), i = n.field(t);
        return null !== r && null !== i ? pe(r, i) : D();
    }(t.field, e, n);
    switch (t.dir) {
      case "asc" /* ASCENDING */ :
        return r;

      case "desc" /* DESCENDING */ :
        return -1 * r;

      default:
        return D();
    }
}

function Nr(t, e) {
    return t.dir === e.dir && t.field.isEqual(e.field);
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ var Ar = function() {
    var t = this;
    this.promise = new Promise((function(e, n) {
        t.resolve = e, t.reject = n;
    }));
}, Sr = /** @class */ function() {
    function t(
    /**
     * The AsyncQueue to run backoff operations on.
     */
    t, 
    /**
     * The ID to use when scheduling backoff operations on the AsyncQueue.
     */
    e, 
    /**
     * The initial delay (used as the base delay on the first retry attempt).
     * Note that jitter will still be applied, so the actual delay could be as
     * little as 0.5*initialDelayMs.
     */
    n
    /**
     * The multiplier to use to determine the extended base delay after each
     * attempt.
     */ , r
    /**
     * The maximum base delay after which no further backoff is performed.
     * Note that jitter will still be applied, so the actual delay could be as
     * much as 1.5*maxDelayMs.
     */ , i) {
        void 0 === n && (n = 1e3), void 0 === r && (r = 1.5), void 0 === i && (i = 6e4), 
        this.fn = t, this.dn = e, this.wn = n, this.mn = r, this.Tn = i, this.En = 0, this.In = null, 
        /** The last backoff attempt, as epoch milliseconds. */
        this.An = Date.now(), this.reset();
    }
    /**
     * Resets the backoff delay.
     *
     * The very next backoffAndWait() will have no delay. If it is called again
     * (i.e. due to an error), initialDelayMs (plus jitter) will be used, and
     * subsequent ones will increase according to the backoffFactor.
     */    return t.prototype.reset = function() {
        this.En = 0;
    }, 
    /**
     * Resets the backoff delay to the maximum delay (e.g. for use after a
     * RESOURCE_EXHAUSTED error).
     */
    t.prototype.Rn = function() {
        this.En = this.Tn;
    }, 
    /**
     * Returns a promise that resolves after currentDelayMs, and increases the
     * delay for any subsequent attempts. If there was a pending backoff operation
     * already, it will be canceled.
     */
    t.prototype.gn = function(t) {
        var e = this;
        // Cancel any pending backoff operation.
                this.cancel();
        // First schedule using the current base (which may be 0 and should be
        // honored as such).
        var n = Math.floor(this.En + this.Pn()), r = Math.max(0, Date.now() - this.An), i = Math.max(0, n - r);
        // Guard against lastAttemptTime being in the future due to a clock change.
                i > 0 && T("ExponentialBackoff", "Backing off for " + i + " ms (base delay: " + this.En + " ms, delay with jitter: " + n + " ms, last attempt: " + r + " ms ago)"), 
        this.In = this.fn.yn(this.dn, i, (function() {
            return e.An = Date.now(), t();
        })), 
        // Apply backoff factor to determine next delay and ensure it is within
        // bounds.
        this.En *= this.mn, this.En < this.wn && (this.En = this.wn), this.En > this.Tn && (this.En = this.Tn);
    }, t.prototype.Vn = function() {
        null !== this.In && (this.In.pn(), this.In = null);
    }, t.prototype.cancel = function() {
        null !== this.In && (this.In.cancel(), this.In = null);
    }, 
    /** Returns a random value in the range [-currentBaseMs/2, currentBaseMs/2] */ t.prototype.Pn = function() {
        return (Math.random() - .5) * this.En;
    }, t;
}(), Dr = /** @class */ function() {
    function t(t) {
        var e = this;
        // NOTE: next/catchCallback will always point to our own wrapper functions,
        // not the user's raw next() or catch() callbacks.
                this.bn = null, this.vn = null, 
        // When the operation resolves, we'll set result or error and mark isDone.
        this.result = void 0, this.error = void 0, this.Sn = !1, 
        // Set to true when .then() or .catch() are called and prevents additional
        // chaining.
        this.Dn = !1, t((function(t) {
            e.Sn = !0, e.result = t, e.bn && 
            // value should be defined unless T is Void, but we can't express
            // that in the type system.
            e.bn(t);
        }), (function(t) {
            e.Sn = !0, e.error = t, e.vn && e.vn(t);
        }));
    }
    return t.prototype.catch = function(t) {
        return this.next(void 0, t);
    }, t.prototype.next = function(e, n) {
        var r = this;
        return this.Dn && D(), this.Dn = !0, this.Sn ? this.error ? this.Cn(n, this.error) : this.Nn(e, this.result) : new t((function(t, i) {
            r.bn = function(n) {
                r.Nn(e, n).next(t, i);
            }, r.vn = function(e) {
                r.Cn(n, e).next(t, i);
            };
        }));
    }, t.prototype.Fn = function() {
        var t = this;
        return new Promise((function(e, n) {
            t.next(e, n);
        }));
    }, t.prototype.xn = function(e) {
        try {
            var n = e();
            return n instanceof t ? n : t.resolve(n);
        } catch (e) {
            return t.reject(e);
        }
    }, t.prototype.Nn = function(e, n) {
        return e ? this.xn((function() {
            return e(n);
        })) : t.resolve(n);
    }, t.prototype.Cn = function(e, n) {
        return e ? this.xn((function() {
            return e(n);
        })) : t.reject(n);
    }, t.resolve = function(e) {
        return new t((function(t, n) {
            t(e);
        }));
    }, t.reject = function(e) {
        return new t((function(t, n) {
            n(e);
        }));
    }, t.$n = function(
    // Accept all Promise types in waitFor().
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    e) {
        return new t((function(t, n) {
            var r = 0, i = 0, o = !1;
            e.forEach((function(e) {
                ++r, e.next((function() {
                    ++i, o && i === r && t();
                }), (function(t) {
                    return n(t);
                }));
            })), o = !0, i === r && t();
        }));
    }, 
    /**
     * Given an array of predicate functions that asynchronously evaluate to a
     * boolean, implements a short-circuiting `or` between the results. Predicates
     * will be evaluated until one of them returns `true`, then stop. The final
     * result will be whether any of them returned `true`.
     */
    t.kn = function(e) {
        for (var n = t.resolve(!1), r = function(e) {
            n = n.next((function(n) {
                return n ? t.resolve(n) : e();
            }));
        }, i = 0, o = e; i < o.length; i++) {
            r(o[i]);
        }
        return n;
    }, t.forEach = function(t, e) {
        var n = this, r = [];
        return t.forEach((function(t, i) {
            r.push(e.call(n, t, i));
        })), this.$n(r);
    }, t;
}(), kr = /** @class */ function() {
    /*
     * Creates a new SimpleDb wrapper for IndexedDb database `name`.
     *
     * Note that `version` must not be a downgrade. IndexedDB does not support
     * downgrading the schema version. We currently do not support any way to do
     * versioning outside of IndexedDB's versioning mechanism, as only
     * version-upgrade transactions are allowed to do things like create
     * objectstores.
     */
    function t(e, n, r) {
        this.name = e, this.version = n, this.Mn = r, 
        // NOTE: According to https://bugs.webkit.org/show_bug.cgi?id=197050, the
        // bug we're checking for should exist in iOS >= 12.2 and < 13, but for
        // whatever reason it's much harder to hit after 12.2 so we only proactively
        // log on 12.2.
        12.2 === t.On(u()) && N("Firestore persistence suffers from a bug in iOS 12.2 Safari that may cause your app to stop working. See https://stackoverflow.com/q/56496296/110915 for details and a potential workaround.");
    }
    /** Deletes the specified database. */    return t.delete = function(t) {
        return T("SimpleDb", "Removing database:", t), Vr(window.indexedDB.deleteDatabase(t)).Fn();
    }, 
    /** Returns true if IndexedDB is available in the current environment. */ t.Ln = function() {
        if ("undefined" == typeof indexedDB) return !1;
        if (t.Bn()) return !0;
        // We extensively use indexed array values and compound keys,
        // which IE and Edge do not support. However, they still have indexedDB
        // defined on the window, so we need to check for them here and make sure
        // to return that persistence is not enabled for those browsers.
        // For tracking support of this feature, see here:
        // https://developer.microsoft.com/en-us/microsoft-edge/platform/status/indexeddbarraysandmultientrysupport/
        // Check the UA string to find out the browser.
                var e = u(), n = t.On(e), r = 0 < n && n < 10, i = t.qn(e), o = 0 < i && i < 4.5;
        // IE 10
        // ua = 'Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.2; Trident/6.0)';
        // IE 11
        // ua = 'Mozilla/5.0 (Windows NT 6.3; Trident/7.0; rv:11.0) like Gecko';
        // Edge
        // ua = 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML,
        // like Gecko) Chrome/39.0.2171.71 Safari/537.36 Edge/12.0';
        // iOS Safari: Disable for users running iOS version < 10.
                return !(e.indexOf("MSIE ") > 0 || e.indexOf("Trident/") > 0 || e.indexOf("Edge/") > 0 || r || o);
    }, 
    /**
     * Returns true if the backing IndexedDB store is the Node IndexedDBShim
     * (see https://github.com/axemclion/IndexedDBShim).
     */
    t.Bn = function() {
        var t;
        return "undefined" != typeof process && "YES" === (null === (t = process.env) || void 0 === t ? void 0 : t.Un);
    }, 
    /** Helper to get a typed SimpleDbStore from a transaction. */ t.Qn = function(t, e) {
        return t.store(e);
    }, 
    // visible for testing
    /** Parse User Agent to determine iOS version. Returns -1 if not found. */
    t.On = function(t) {
        var e = t.match(/i(?:phone|pad|pod) os ([\d_]+)/i), n = e ? e[1].split("_").slice(0, 2).join(".") : "-1";
        return Number(n);
    }, 
    // visible for testing
    /** Parse User Agent to determine Android version. Returns -1 if not found. */
    t.qn = function(t) {
        var e = t.match(/Android ([\d.]+)/i), n = e ? e[1].split(".").slice(0, 2).join(".") : "-1";
        return Number(n);
    }, 
    /**
     * Opens the specified database, creating or upgrading it if necessary.
     */
    t.prototype.Wn = function(t) {
        return e(this, void 0, void 0, (function() {
            var e, r = this;
            return n(this, (function(n) {
                switch (n.label) {
                  case 0:
                    return this.db ? [ 3 /*break*/ , 2 ] : (T("SimpleDb", "Opening database:", this.name), 
                    e = this, [ 4 /*yield*/ , new Promise((function(e, n) {
                        // TODO(mikelehen): Investigate browser compatibility.
                        // https://developer.mozilla.org/en-US/docs/Web/API/IndexedDB_API/Using_IndexedDB
                        // suggests IE9 and older WebKit browsers handle upgrade
                        // differently. They expect setVersion, as described here:
                        // https://developer.mozilla.org/en-US/docs/Web/API/IDBVersionChangeRequest/setVersion
                        var i = indexedDB.open(r.name, r.version);
                        i.onsuccess = function(t) {
                            var n = t.target.result;
                            e(n);
                        }, i.onblocked = function() {
                            n(new Lr(t, "Cannot upgrade IndexedDB schema while another tab is open. Close all tabs that access Firestore and reload this page to proceed."));
                        }, i.onerror = function(e) {
                            var r = e.target.error;
                            "VersionError" === r.name ? n(new I(b.FAILED_PRECONDITION, "A newer version of the Firestore SDK was previously used and so the persisted data is not compatible with the version of the SDK you are now using. The SDK will operate with persistence disabled. If you need persistence, please re-upgrade to a newer version of the SDK or else clear the persisted IndexedDB data for your app to start fresh.")) : n(new Lr(t, r));
                        }, i.onupgradeneeded = function(t) {
                            T("SimpleDb", 'Database "' + r.name + '" requires upgrade from version:', t.oldVersion);
                            var e = t.target.result;
                            r.Mn.createOrUpgrade(e, i.transaction, t.oldVersion, r.version).next((function() {
                                T("SimpleDb", "Database upgrade to version " + r.version + " complete");
                            }));
                        };
                    })) ]);

                  case 1:
                    e.db = n.sent(), n.label = 2;

                  case 2:
                    return [ 2 /*return*/ , (this.jn && (this.db.onversionchange = function(t) {
                        return r.jn(t);
                    }), this.db) ];
                }
            }));
        }));
    }, t.prototype.Kn = function(t) {
        this.jn = t, this.db && (this.db.onversionchange = function(e) {
            return t(e);
        });
    }, t.prototype.runTransaction = function(t, r, i, o) {
        return e(this, void 0, void 0, (function() {
            var e, s, u, a, c;
            return n(this, (function(h) {
                switch (h.label) {
                  case 0:
                    e = "readonly" === r, s = 0, u = function() {
                        var r, u, c, h, f;
                        return n(this, (function(n) {
                            switch (n.label) {
                              case 0:
                                ++s, n.label = 1;

                              case 1:
                                return n.trys.push([ 1, 4, , 5 ]), [ 4 /*yield*/ , a.Wn(t) ];

                              case 2:
                                // Wait for the transaction to complete (i.e. IndexedDb's onsuccess event to
                                // fire), but still return the original transactionFnResult back to the
                                // caller.
                                return a.db = n.sent(), r = Or.open(a.db, t, e ? "readonly" : "readwrite", i), u = o(r).catch((function(t) {
                                    // Abort the transaction if there was an error.
                                    return r.abort(t), Dr.reject(t);
                                })).Fn(), c = {}, u.catch((function() {})), [ 4 /*yield*/ , r.Gn ];

                              case 3:
                                return [ 2 /*return*/ , (c.value = (
                                // Wait for the transaction to complete (i.e. IndexedDb's onsuccess event to
                                // fire), but still return the original transactionFnResult back to the
                                // caller.
                                n.sent(), u), c) ];

                              case 4:
                                return h = n.sent(), f = "FirebaseError" !== h.name && s < 3, T("SimpleDb", "Transaction failed with error:", h.message, "Retrying:", f), 
                                a.close(), f ? [ 3 /*break*/ , 5 ] : [ 2 /*return*/ , {
                                    value: Promise.reject(h)
                                } ];

                              case 5:
                                return [ 2 /*return*/ ];
                            }
                        }));
                    }, a = this, h.label = 1;

                  case 1:
                    return [ 5 /*yield**/ , u() ];

                  case 2:
                    if ("object" == typeof (c = h.sent())) return [ 2 /*return*/ , c.value ];
                    h.label = 3;

                  case 3:
                    return [ 3 /*break*/ , 1 ];

                  case 4:
                    return [ 2 /*return*/ ];
                }
            }));
        }));
    }, t.prototype.close = function() {
        this.db && this.db.close(), this.db = void 0;
    }, t;
}(), xr = /** @class */ function() {
    function t(t) {
        this.zn = t, this.Hn = !1, this.Yn = null;
    }
    return Object.defineProperty(t.prototype, "Sn", {
        get: function() {
            return this.Hn;
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "Jn", {
        get: function() {
            return this.Yn;
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "cursor", {
        set: function(t) {
            this.zn = t;
        },
        enumerable: !1,
        configurable: !0
    }), 
    /**
     * This function can be called to stop iteration at any point.
     */
    t.prototype.done = function() {
        this.Hn = !0;
    }, 
    /**
     * This function can be called to skip to that next key, which could be
     * an index or a primary key.
     */
    t.prototype.Xn = function(t) {
        this.Yn = t;
    }, 
    /**
     * Delete the current cursor value from the object store.
     *
     * NOTE: You CANNOT do this with a keysOnly query.
     */
    t.prototype.delete = function() {
        return Vr(this.zn.delete());
    }, t;
}(), Lr = /** @class */ function(e) {
    function n(t, n) {
        var r = this;
        return (r = e.call(this, b.UNAVAILABLE, "IndexedDB transaction '" + t + "' failed: " + n) || this).name = "IndexedDbTransactionError", 
        r;
    }
    return t(n, e), n;
}(I);

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A helper for running delayed tasks following an exponential backoff curve
 * between attempts.
 *
 * Each delay is made up of a "base" delay which follows the exponential
 * backoff curve, and a +/- 50% "jitter" that is calculated and added to the
 * base delay. This prevents clients from accidentally synchronizing their
 * delays causing spikes of load to the backend.
 */
/** Verifies whether `e` is an IndexedDbTransactionError. */ function Rr(t) {
    // Use name equality, as instanceof checks on errors don't work with errors
    // that wrap other errors.
    return "IndexedDbTransactionError" === t.name;
}

/**
 * Wraps an IDBTransaction and exposes a store() method to get a handle to a
 * specific object store.
 */ var Or = /** @class */ function() {
    function t(t, e) {
        var n = this;
        this.action = t, this.transaction = e, this.aborted = !1, 
        /**
             * A promise that resolves with the result of the IndexedDb transaction.
             */
        this.Zn = new Ar, this.transaction.oncomplete = function() {
            n.Zn.resolve();
        }, this.transaction.onabort = function() {
            e.error ? n.Zn.reject(new Lr(t, e.error)) : n.Zn.resolve();
        }, this.transaction.onerror = function(e) {
            var r = Cr(e.target.error);
            n.Zn.reject(new Lr(t, r));
        };
    }
    return t.open = function(e, n, r, i) {
        try {
            return new t(n, e.transaction(i, r));
        } catch (e) {
            throw new Lr(n, e);
        }
    }, Object.defineProperty(t.prototype, "Gn", {
        get: function() {
            return this.Zn.promise;
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.abort = function(t) {
        t && this.Zn.reject(t), this.aborted || (T("SimpleDb", "Aborting transaction:", t ? t.message : "Client-initiated abort"), 
        this.aborted = !0, this.transaction.abort());
    }, 
    /**
     * Returns a SimpleDbStore<KeyType, ValueType> for the specified store. All
     * operations performed on the SimpleDbStore happen within the context of this
     * transaction and it cannot be used anymore once the transaction is
     * completed.
     *
     * Note that we can't actually enforce that the KeyType and ValueType are
     * correct, but they allow type safety through the rest of the consuming code.
     */
    t.prototype.store = function(t) {
        var e = this.transaction.objectStore(t);
        return new Pr(e);
    }, t;
}(), Pr = /** @class */ function() {
    function t(t) {
        this.store = t;
    }
    return t.prototype.put = function(t, e) {
        var n;
        return void 0 !== e ? (T("SimpleDb", "PUT", this.store.name, t, e), n = this.store.put(e, t)) : (T("SimpleDb", "PUT", this.store.name, "<auto-key>", t), 
        n = this.store.put(t)), Vr(n);
    }, 
    /**
     * Adds a new value into an Object Store and returns the new key. Similar to
     * IndexedDb's `add()`, this method will fail on primary key collisions.
     *
     * @param value The object to write.
     * @return The key of the value to add.
     */
    t.prototype.add = function(t) {
        return T("SimpleDb", "ADD", this.store.name, t, t), Vr(this.store.add(t));
    }, 
    /**
     * Gets the object with the specified key from the specified store, or null
     * if no object exists with the specified key.
     *
     * @key The key of the object to get.
     * @return The object with the specified key or null if no object exists.
     */
    t.prototype.get = function(t) {
        var e = this;
        // We're doing an unsafe cast to ValueType.
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
                return Vr(this.store.get(t)).next((function(n) {
            // Normalize nonexistence to null.
            return void 0 === n && (n = null), T("SimpleDb", "GET", e.store.name, t, n), n;
        }));
    }, t.prototype.delete = function(t) {
        return T("SimpleDb", "DELETE", this.store.name, t), Vr(this.store.delete(t));
    }, 
    /**
     * If we ever need more of the count variants, we can add overloads. For now,
     * all we need is to count everything in a store.
     *
     * Returns the number of rows in the store.
     */
    t.prototype.count = function() {
        return T("SimpleDb", "COUNT", this.store.name), Vr(this.store.count());
    }, t.prototype.ts = function(t, e) {
        var n = this.cursor(this.options(t, e)), r = [];
        return this.es(n, (function(t, e) {
            r.push(e);
        })).next((function() {
            return r;
        }));
    }, t.prototype.ns = function(t, e) {
        T("SimpleDb", "DELETE ALL", this.store.name);
        var n = this.options(t, e);
        n.ss = !1;
        var r = this.cursor(n);
        return this.es(r, (function(t, e, n) {
            return n.delete();
        }));
    }, t.prototype.rs = function(t, e) {
        var n;
        e ? n = t : (n = {}, e = t);
        var r = this.cursor(n);
        return this.es(r, e);
    }, 
    /**
     * Iterates over a store, but waits for the given callback to complete for
     * each entry before iterating the next entry. This allows the callback to do
     * asynchronous work to determine if this iteration should continue.
     *
     * The provided callback should return `true` to continue iteration, and
     * `false` otherwise.
     */
    t.prototype.os = function(t) {
        var e = this.cursor({});
        return new Dr((function(n, r) {
            e.onerror = function(t) {
                var e = Cr(t.target.error);
                r(e);
            }, e.onsuccess = function(e) {
                var r = e.target.result;
                r ? t(r.primaryKey, r.value).next((function(t) {
                    t ? r.continue() : n();
                })) : n();
            };
        }));
    }, t.prototype.es = function(t, e) {
        var n = [];
        return new Dr((function(r, i) {
            t.onerror = function(t) {
                i(t.target.error);
            }, t.onsuccess = function(t) {
                var i = t.target.result;
                if (i) {
                    var o = new xr(i), s = e(i.primaryKey, i.value, o);
                    if (s instanceof Dr) {
                        var u = s.catch((function(t) {
                            return o.done(), Dr.reject(t);
                        }));
                        n.push(u);
                    }
                    o.Sn ? r() : null === o.Jn ? i.continue() : i.continue(o.Jn);
                } else r();
            };
        })).next((function() {
            return Dr.$n(n);
        }));
    }, t.prototype.options = function(t, e) {
        var n = void 0;
        return void 0 !== t && ("string" == typeof t ? n = t : e = t), {
            index: n,
            range: e
        };
    }, t.prototype.cursor = function(t) {
        var e = "next";
        if (t.reverse && (e = "prev"), t.index) {
            var n = this.store.index(t.index);
            return t.ss ? n.openKeyCursor(t.range, e) : n.openCursor(t.range, e);
        }
        return this.store.openCursor(t.range, e);
    }, t;
}();

/**
 * A wrapper around an IDBObjectStore providing an API that:
 *
 * 1) Has generic KeyType / ValueType parameters to provide strongly-typed
 * methods for acting against the object store.
 * 2) Deals with IndexedDB's onsuccess / onerror event callbacks, making every
 * method return a PersistencePromise instead.
 * 3) Provides a higher-level API to avoid needing to do excessive wrapping of
 * intermediate IndexedDB types (IDBCursorWithValue, etc.)
 */
/**
 * Wraps an IDBRequest in a PersistencePromise, using the onsuccess / onerror
 * handlers to resolve / reject the PersistencePromise as appropriate.
 */
function Vr(t) {
    return new Dr((function(e, n) {
        t.onsuccess = function(t) {
            var n = t.target.result;
            e(n);
        }, t.onerror = function(t) {
            var e = Cr(t.target.error);
            n(e);
        };
    }));
}

// Guard so we only report the error once.
var Ur = !1;

function Cr(t) {
    var e = kr.On(u());
    if (e >= 12.2 && e < 13) {
        var n = "An internal error was encountered in the Indexed Database server";
        if (t.message.indexOf(n) >= 0) {
            // Wrap error in a more descriptive one.
            var r = new I("internal", "IOS_INDEXEDDB_BUG1: IndexedDb has thrown '" + n + "'. This is likely due to an unavoidable bug in iOS. See https://stackoverflow.com/q/56496296/110915 for details and a potential workaround.");
            return Ur || (Ur = !0, 
            // Throw a global exception outside of this promise chain, for the user to
            // potentially catch.
            setTimeout((function() {
                throw r;
            }), 0)), r;
        }
    }
    return t;
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** The Platform's 'window' implementation or null if not available. */ function Fr() {
    // `window` is not always available, e.g. in ReactNative and WebWorkers.
    // eslint-disable-next-line no-restricted-globals
    return "undefined" != typeof window ? window : null;
}

/** The Platform's 'document' implementation or null if not available. */ function Mr() {
    // `document` is not always available, e.g. in ReactNative and WebWorkers.
    // eslint-disable-next-line no-restricted-globals
    return "undefined" != typeof document ? document : null;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Represents an operation scheduled to be run in the future on an AsyncQueue.
 *
 * It is created via DelayedOperation.createAndSchedule().
 *
 * Supports cancellation (via cancel()) and early execution (via skipDelay()).
 *
 * Note: We implement `PromiseLike` instead of `Promise`, as the `Promise` type
 * in newer versions of TypeScript defines `finally`, which is not available in
 * IE.
 */ var qr = /** @class */ function() {
    function t(t, e, n, r, i) {
        this.cs = t, this.dn = e, this.us = n, this.op = r, this.hs = i, this.ls = new Ar, 
        this.then = this.ls.promise.then.bind(this.ls.promise), 
        // It's normal for the deferred promise to be canceled (due to cancellation)
        // and so we attach a dummy catch callback to avoid
        // 'UnhandledPromiseRejectionWarning' log spam.
        this.ls.promise.catch((function(t) {}))
        /**
     * Creates and returns a DelayedOperation that has been scheduled to be
     * executed on the provided asyncQueue after the provided delayMs.
     *
     * @param asyncQueue The queue to schedule the operation on.
     * @param id A Timer ID identifying the type of operation this is.
     * @param delayMs The delay (ms) before the operation should be scheduled.
     * @param op The operation to run.
     * @param removalCallback A callback to be called synchronously once the
     *   operation is executed or canceled, notifying the AsyncQueue to remove it
     *   from its delayedOperations list.
     *   PORTING NOTE: This exists to prevent making removeDelayedOperation() and
     *   the DelayedOperation class public.
     */;
    }
    return t._s = function(e, n, r, i, o) {
        var s = new t(e, n, Date.now() + r, i, o);
        return s.start(r), s;
    }, 
    /**
     * Starts the timer. This is called immediately after construction by
     * createAndSchedule().
     */
    t.prototype.start = function(t) {
        var e = this;
        this.fs = setTimeout((function() {
            return e.ds();
        }), t);
    }, 
    /**
     * Queues the operation to run immediately (if it hasn't already been run or
     * canceled).
     */
    t.prototype.pn = function() {
        return this.ds();
    }, 
    /**
     * Cancels the operation if it hasn't already been executed or canceled. The
     * promise will be rejected.
     *
     * As long as the operation has not yet been run, calling cancel() provides a
     * guarantee that the operation will not be run.
     */
    t.prototype.cancel = function(t) {
        null !== this.fs && (this.clearTimeout(), this.ls.reject(new I(b.CANCELLED, "Operation cancelled" + (t ? ": " + t : ""))));
    }, t.prototype.ds = function() {
        var t = this;
        this.cs.ws((function() {
            return null !== t.fs ? (t.clearTimeout(), t.op().then((function(e) {
                return t.ls.resolve(e);
            }))) : Promise.resolve();
        }));
    }, t.prototype.clearTimeout = function() {
        null !== this.fs && (this.hs(this), clearTimeout(this.fs), this.fs = null);
    }, t;
}(), jr = /** @class */ function() {
    function t() {
        var t = this;
        // The last promise in the queue.
                this.Ts = Promise.resolve(), 
        // A list of retryable operations. Retryable operations are run in order and
        // retried with backoff.
        this.Es = [], 
        // Is this AsyncQueue being shut down? Once it is set to true, it will not
        // be changed again.
        this.Is = !1, 
        // Operations scheduled to be queued in the future. Operations are
        // automatically removed after they are run or canceled.
        this.As = [], 
        // visible for testing
        this.Rs = null, 
        // Flag set while there's an outstanding AsyncQueue operation, used for
        // assertion sanity-checks.
        this.gs = !1, 
        // List of TimerIds to fast-forward delays for.
        this.Ps = [], 
        // Backoff timer used to schedule retries for retryable operations
        this.ys = new Sr(this, "async_queue_retry" /* AsyncQueueRetry */), 
        // Visibility handler that triggers an immediate retry of all retryable
        // operations. Meant to speed up recovery when we regain file system access
        // after page comes into foreground.
        this.Vs = function() {
            var e = Mr();
            e && T("AsyncQueue", "Visibility state changed to  ", e.visibilityState), t.ys.Vn();
        };
        var e = Mr();
        e && "function" == typeof e.addEventListener && e.addEventListener("visibilitychange", this.Vs);
    }
    return Object.defineProperty(t.prototype, "ps", {
        // Is this AsyncQueue being shut down? If true, this instance will not enqueue
        // any new operations, Promises from enqueue requests will not resolve.
        get: function() {
            return this.Is;
        },
        enumerable: !1,
        configurable: !0
    }), 
    /**
     * Adds a new operation to the queue without waiting for it to complete (i.e.
     * we ignore the Promise result).
     */
    t.prototype.ws = function(t) {
        // eslint-disable-next-line @typescript-eslint/no-floating-promises
        this.enqueue(t);
    }, 
    /**
     * Regardless if the queue has initialized shutdown, adds a new operation to the
     * queue without waiting for it to complete (i.e. we ignore the Promise result).
     */
    t.prototype.bs = function(t) {
        this.vs(), 
        // eslint-disable-next-line @typescript-eslint/no-floating-promises
        this.Ss(t);
    }, 
    /**
     * Initialize the shutdown of this queue. Once this method is called, the
     * only possible way to request running an operation is through
     * `enqueueEvenWhileRestricted()`.
     */
    t.prototype.Ds = function() {
        if (!this.Is) {
            this.Is = !0;
            var t = Mr();
            t && "function" == typeof t.removeEventListener && t.removeEventListener("visibilitychange", this.Vs);
        }
    }, 
    /**
     * Adds a new operation to the queue. Returns a promise that will be resolved
     * when the promise returned by the new operation is (with its value).
     */
    t.prototype.enqueue = function(t) {
        return this.vs(), this.Is ? new Promise((function(t) {})) : this.Ss(t);
    }, 
    /**
     * Enqueue a retryable operation.
     *
     * A retryable operation is rescheduled with backoff if it fails with a
     * IndexedDbTransactionError (the error type used by SimpleDb). All
     * retryable operations are executed in order and only run if all prior
     * operations were retried successfully.
     */
    t.prototype.Cs = function(t) {
        var e = this;
        this.ws((function() {
            return e.Es.push(t), e.Ns();
        }));
    }, 
    /**
     * Runs the next operation from the retryable queue. If the operation fails,
     * reschedules with backoff.
     */
    t.prototype.Ns = function() {
        return e(this, void 0, void 0, (function() {
            var t, e = this;
            return n(this, (function(n) {
                switch (n.label) {
                  case 0:
                    if (0 === this.Es.length) return [ 3 /*break*/ , 5 ];
                    n.label = 1;

                  case 1:
                    return n.trys.push([ 1, 3, , 4 ]), [ 4 /*yield*/ , this.Es[0]() ];

                  case 2:
                    return n.sent(), this.Es.shift(), this.ys.reset(), [ 3 /*break*/ , 4 ];

                  case 3:
                    if (!Rr(t = n.sent())) throw t;
                    // Failure will be handled by AsyncQueue
                                        return T("AsyncQueue", "Operation failed with retryable error: " + t), 
                    [ 3 /*break*/ , 4 ];

                  case 4:
                    this.Es.length > 0 && 
                    // If there are additional operations, we re-schedule `retryNextOp()`.
                    // This is necessary to run retryable operations that failed during
                    // their initial attempt since we don't know whether they are already
                    // enqueued. If, for example, `op1`, `op2`, `op3` are enqueued and `op1`
                    // needs to  be re-run, we will run `op1`, `op1`, `op2` using the
                    // already enqueued calls to `retryNextOp()`. `op3()` will then run in the
                    // call scheduled here.
                    // Since `backoffAndRun()` cancels an existing backoff and schedules a
                    // new backoff on every call, there is only ever a single additional
                    // operation in the queue.
                    this.ys.gn((function() {
                        return e.Ns();
                    })), n.label = 5;

                  case 5:
                    return [ 2 /*return*/ ];
                }
            }));
        }));
    }, t.prototype.Ss = function(t) {
        var e = this, n = this.Ts.then((function() {
            return e.gs = !0, t().catch((function(t) {
                // Re-throw the error so that this.tail becomes a rejected Promise and
                // all further attempts to chain (via .then) will just short-circuit
                // and return the rejected Promise.
                throw e.Rs = t, e.gs = !1, N("INTERNAL UNHANDLED ERROR: ", 
                /**
 * Chrome includes Error.message in Error.stack. Other browsers do not.
 * This returns expected output of message + stack when available.
 * @param error Error or FirestoreError
 */
                function(t) {
                    var e = t.message || "";
                    return t.stack && (e = t.stack.includes(t.message) ? t.stack : t.message + "\n" + t.stack), 
                    e;
                }(t)), t;
            })).then((function(t) {
                return e.gs = !1, t;
            }));
        }));
        return this.Ts = n, n;
    }, 
    /**
     * Schedules an operation to be queued on the AsyncQueue once the specified
     * `delayMs` has elapsed. The returned DelayedOperation can be used to cancel
     * or fast-forward the operation prior to its running.
     */
    t.prototype.yn = function(t, e, n) {
        var r = this;
        this.vs(), 
        // Fast-forward delays for timerIds that have been overriden.
        this.Ps.indexOf(t) > -1 && (e = 0);
        var i = qr._s(this, t, e, n, (function(t) {
            return r.Fs(t);
        }));
        return this.As.push(i), i;
    }, t.prototype.vs = function() {
        this.Rs && D();
    }, 
    /**
     * Verifies there's an operation currently in-progress on the AsyncQueue.
     * Unfortunately we can't verify that the running code is in the promise chain
     * of that operation, so this isn't a foolproof check, but it should be enough
     * to catch some bugs.
     */
    t.prototype.xs = function() {}, 
    /**
     * Waits until all currently queued tasks are finished executing. Delayed
     * operations are not run.
     */
    t.prototype.$s = function() {
        return e(this, void 0, void 0, (function() {
            var t;
            return n(this, (function(e) {
                switch (e.label) {
                  case 0:
                    return [ 4 /*yield*/ , t = this.Ts ];

                  case 1:
                    e.sent(), e.label = 2;

                  case 2:
                    if (t !== this.Ts) return [ 3 /*break*/ , 0 ];
                    e.label = 3;

                  case 3:
                    return [ 2 /*return*/ ];
                }
            }));
        }));
    }, 
    /**
     * For Tests: Determine if a delayed operation with a particular TimerId
     * exists.
     */
    t.prototype.ks = function(t) {
        for (var e = 0, n = this.As; e < n.length; e++) {
            if (n[e].dn === t) return !0;
        }
        return !1;
    }, 
    /**
     * For Tests: Runs some or all delayed operations early.
     *
     * @param lastTimerId Delayed operations up to and including this TimerId will
     *  be drained. Pass TimerId.All to run all delayed operations.
     * @returns a Promise that resolves once all operations have been run.
     */
    t.prototype.Ms = function(t) {
        var e = this;
        // Note that draining may generate more delayed ops, so we do that first.
                return this.$s().then((function() {
            // Run ops in the same order they'd run if they ran naturally.
            e.As.sort((function(t, e) {
                return t.us - e.us;
            }));
            for (var n = 0, r = e.As; n < r.length; n++) {
                var i = r[n];
                if (i.pn(), "all" /* All */ !== t && i.dn === t) break;
            }
            return e.$s();
        }));
    }, 
    /**
     * For Tests: Skip all subsequent delays for a timer id.
     */
    t.prototype.Os = function(t) {
        this.Ps.push(t);
    }, 
    /** Called once a DelayedOperation is run or canceled. */ t.prototype.Fs = function(t) {
        // NOTE: indexOf / slice are O(n), but delayedOperations is expected to be small.
        var e = this.As.indexOf(t);
        this.As.splice(e, 1);
    }, t;
}();

/**
 * Returns a FirestoreError that can be surfaced to the user if the provided
 * error is an IndexedDbTransactionError. Re-throws the error otherwise.
 */
function Gr(t, e) {
    if (N("AsyncQueue", e + ": " + t), Rr(t)) return new I(b.UNAVAILABLE, e + ": " + t);
    throw t;
}

var zr = function() {
    this.Ls = void 0, this.listeners = [];
}, Br = function() {
    this.Bs = new yt((function(t) {
        return sr(t);
    }), or), this.onlineState = "Unknown" /* Unknown */ , this.qs = new Set;
};

function Kr(t, r) {
    return e(this, void 0, void 0, (function() {
        var e, i, o, s, u, a, c;
        return n(this, (function(n) {
            switch (n.label) {
              case 0:
                if (e = x(t), i = r.query, o = !1, (s = e.Bs.get(i)) || (o = !0, s = new zr), !o) return [ 3 /*break*/ , 4 ];
                n.label = 1;

              case 1:
                return n.trys.push([ 1, 3, , 4 ]), u = s, [ 4 /*yield*/ , e.Us(i) ];

              case 2:
                return u.Ls = n.sent(), [ 3 /*break*/ , 4 ];

              case 3:
                return a = n.sent(), c = Gr(a, "Initialization of query '" + ur(r.query) + "' failed"), 
                [ 2 /*return*/ , void r.onError(c) ];

              case 4:
                return e.Bs.set(i, s), s.listeners.push(r), 
                // Run global snapshot listeners if a consistent snapshot has been emitted.
                r.Qs(e.onlineState), s.Ls && r.Ws(s.Ls) && Yr(e), [ 2 /*return*/ ];
            }
        }));
    }));
}

function Wr(t, r) {
    return e(this, void 0, void 0, (function() {
        var e, i, o, s, u;
        return n(this, (function(n) {
            return e = x(t), i = r.query, o = !1, (s = e.Bs.get(i)) && (u = s.listeners.indexOf(r)) >= 0 && (s.listeners.splice(u, 1), 
            o = 0 === s.listeners.length), o ? [ 2 /*return*/ , (e.Bs.delete(i), e.js(i)) ] : [ 2 /*return*/ ];
        }));
    }));
}

function Qr(t, e) {
    for (var n = x(t), r = !1, i = 0, o = e; i < o.length; i++) {
        var s = o[i], u = s.query, a = n.Bs.get(u);
        if (a) {
            for (var c = 0, h = a.listeners; c < h.length; c++) {
                h[c].Ws(s) && (r = !0);
            }
            a.Ls = s;
        }
    }
    r && Yr(n);
}

function Hr(t, e, n) {
    var r = x(t), i = r.Bs.get(e);
    if (i) for (var o = 0, s = i.listeners; o < s.length; o++) {
        s[o].onError(n);
    }
    // Remove all listeners. NOTE: We don't need to call syncEngine.unlisten()
    // after an error.
        r.Bs.delete(e);
}

// Call all global snapshot listeners that have been set.
function Yr(t) {
    t.qs.forEach((function(t) {
        t.next();
    }));
}

/**
 * QueryListener takes a series of internal view snapshots and determines
 * when to raise the event.
 *
 * It uses an Observer to dispatch events.
 */ var $r = /** @class */ function() {
    function t(t, e, n) {
        this.query = t, this.Ks = e, 
        /**
             * Initial snapshots (e.g. from cache) may not be propagated to the wrapped
             * observer. This flag is set to true once we've actually raised an event.
             */
        this.Gs = !1, this.zs = null, this.onlineState = "Unknown" /* Unknown */ , this.options = n || {}
        /**
     * Applies the new ViewSnapshot to this listener, raising a user-facing event
     * if applicable (depending on what changed, whether the user has opted into
     * metadata-only changes, etc.). Returns true if a user-facing event was
     * indeed raised.
     */;
    }
    return t.prototype.Ws = function(t) {
        if (!this.options.includeMetadataChanges) {
            for (
            // Remove the metadata only changes.
            var e = [], n = 0, r = t.docChanges; n < r.length; n++) {
                var i = r[n];
                3 /* Metadata */ !== i.type && e.push(i);
            }
            t = new $t(t.query, t.docs, t.Qt, e, t.Wt, t.fromCache, t.jt, 
            /* excludesMetadataChanges= */ !0);
        }
        var o = !1;
        return this.Gs ? this.Hs(t) && (this.Ks.next(t), o = !0) : this.Ys(t, this.onlineState) && (this.Js(t), 
        o = !0), this.zs = t, o;
    }, t.prototype.onError = function(t) {
        this.Ks.error(t);
    }, 
    /** Returns whether a snapshot was raised. */ t.prototype.Qs = function(t) {
        this.onlineState = t;
        var e = !1;
        return this.zs && !this.Gs && this.Ys(this.zs, t) && (this.Js(this.zs), e = !0), 
        e;
    }, t.prototype.Ys = function(t, e) {
        // Always raise the first event when we're synced
        if (!t.fromCache) return !0;
        // NOTE: We consider OnlineState.Unknown as online (it should become Offline
        // or Online if we wait long enough).
                var n = "Offline" /* Offline */ !== e;
        // Don't raise the event if we're online, aren't synced yet (checked
        // above) and are waiting for a sync.
                return !(this.options.Xs && n || t.docs.m() && "Offline" /* Offline */ !== e);
        // Raise data from cache if we have any documents or we are offline
        }, t.prototype.Hs = function(t) {
        // We don't need to handle includeDocumentMetadataChanges here because
        // the Metadata only changes have already been stripped out if needed.
        // At this point the only changes we will see are the ones we should
        // propagate.
        if (t.docChanges.length > 0) return !0;
        var e = this.zs && this.zs.hasPendingWrites !== t.hasPendingWrites;
        return !(!t.jt && !e) && !0 === this.options.includeMetadataChanges;
        // Generally we should have hit one of the cases above, but it's possible
        // to get here if there were only metadata docChanges and they got
        // stripped out.
        }, t.prototype.Js = function(t) {
        t = $t.Gt(t.query, t.docs, t.Wt, t.fromCache), this.Gs = !0, this.Ks.next(t);
    }, t;
}(), Xr = /** @class */ function() {
    function t(t) {
        this.uid = t;
    }
    return t.prototype.Zs = function() {
        return null != this.uid;
    }, 
    /**
     * Returns a key representing this user, suitable for inclusion in a
     * dictionary.
     */
    t.prototype.ti = function() {
        return this.Zs() ? "uid:" + this.uid : "anonymous-user";
    }, t.prototype.isEqual = function(t) {
        return t.uid === this.uid;
    }, t;
}();

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Simple wrapper around a nullable UID. Mostly exists to make code more
 * readable.
 */
/** A user with a null UID. */ Xr.UNAUTHENTICATED = new Xr(null), 
// TODO(mikelehen): Look into getting a proper uid-equivalent for
// non-FirebaseAuth providers.
Xr.ei = new Xr("google-credentials-uid"), Xr.ni = new Xr("first-party-uid");

/**
 * @license
 * Copyright 2018 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * `ListenSequence` is a monotonic sequence. It is initialized with a minimum value to
 * exceed. All subsequent calls to next will return increasing values. If provided with a
 * `SequenceNumberSyncer`, it will additionally bump its next value when told of a new value, as
 * well as write out sequence numbers that it produces via `next()`.
 */
var Jr = /** @class */ function() {
    function t(t, e) {
        var n = this;
        this.previousValue = t, e && (e.si = function(t) {
            return n.ii(t);
        }, this.ri = function(t) {
            return e.oi(t);
        });
    }
    return t.prototype.ii = function(t) {
        return this.previousValue = Math.max(t, this.previousValue), this.previousValue;
    }, t.prototype.next = function() {
        var t = ++this.previousValue;
        return this.ri && this.ri(t), t;
    }, t;
}();

/** Assembles the key for a client state in WebStorage */
function Zr(t, e) {
    return "firestore_clients_" + t + "_" + e;
}

// The format of the WebStorage key that stores the mutation state is:
//     firestore_mutations_<persistence_prefix>_<batch_id>
//     (for unauthenticated users)
// or: firestore_mutations_<persistence_prefix>_<batch_id>_<user_uid>
// 'user_uid' is last to avoid needing to escape '_' characters that it might
// contain.
/** Assembles the key for a mutation batch in WebStorage */ function ti(t, e, n) {
    var r = "firestore_mutations_" + t + "_" + n;
    return e.Zs() && (r += "_" + e.uid), r;
}

// The format of the WebStorage key that stores a query target's metadata is:
//     firestore_targets_<persistence_prefix>_<target_id>
/** Assembles the key for a query state in WebStorage */ function ei(t, e) {
    return "firestore_targets_" + t + "_" + e;
}

// The WebStorage prefix that stores the primary tab's online state. The
// format of the key is:
//     firestore_online_state_<persistence_prefix>
/**
 * Holds the state of a mutation batch, including its user ID, batch ID and
 * whether the batch is 'pending', 'acknowledged' or 'rejected'.
 */
// Visible for testing
Jr.ai = -1;

var ni = /** @class */ function() {
    function t(t, e, n, r) {
        this.user = t, this.batchId = e, this.state = n, this.error = r
        /**
     * Parses a MutationMetadata from its JSON representation in WebStorage.
     * Logs a warning and returns null if the format of the data is not valid.
     */;
    }
    return t.ci = function(e, n, r) {
        var i = JSON.parse(r), o = "object" == typeof i && -1 !== [ "pending", "acknowledged", "rejected" ].indexOf(i.state) && (void 0 === i.error || "object" == typeof i.error), s = void 0;
        return o && i.error && ((o = "string" == typeof i.error.message && "string" == typeof i.error.code) && (s = new I(i.error.code, i.error.message))), 
        o ? new t(e, n, i.state, s) : (N("SharedClientState", "Failed to parse mutation state for ID '" + n + "': " + r), 
        null);
    }, t.prototype.ui = function() {
        var t = {
            state: this.state,
            updateTimeMs: Date.now()
        };
        return this.error && (t.error = {
            code: this.error.code,
            message: this.error.message
        }), JSON.stringify(t);
    }, t;
}(), ri = /** @class */ function() {
    function t(t, e, n) {
        this.targetId = t, this.state = e, this.error = n
        /**
     * Parses a QueryTargetMetadata from its JSON representation in WebStorage.
     * Logs a warning and returns null if the format of the data is not valid.
     */;
    }
    return t.ci = function(e, n) {
        var r = JSON.parse(n), i = "object" == typeof r && -1 !== [ "not-current", "current", "rejected" ].indexOf(r.state) && (void 0 === r.error || "object" == typeof r.error), o = void 0;
        return i && r.error && ((i = "string" == typeof r.error.message && "string" == typeof r.error.code) && (o = new I(r.error.code, r.error.message))), 
        i ? new t(e, r.state, o) : (N("SharedClientState", "Failed to parse target state for ID '" + e + "': " + n), 
        null);
    }, t.prototype.ui = function() {
        var t = {
            state: this.state,
            updateTimeMs: Date.now()
        };
        return this.error && (t.error = {
            code: this.error.code,
            message: this.error.message
        }), JSON.stringify(t);
    }, t;
}(), ii = /** @class */ function() {
    function t(t, e) {
        this.clientId = t, this.activeTargetIds = e
        /**
     * Parses a RemoteClientState from the JSON representation in WebStorage.
     * Logs a warning and returns null if the format of the data is not valid.
     */;
    }
    return t.ci = function(e, n) {
        for (var r = JSON.parse(n), i = "object" == typeof r && r.activeTargetIds instanceof Array, o = Qt(), s = 0; i && s < r.activeTargetIds.length; ++s) i = It(r.activeTargetIds[s]), 
        o = o.add(r.activeTargetIds[s]);
        return i ? new t(e, o) : (N("SharedClientState", "Failed to parse client data for instance '" + e + "': " + n), 
        null);
    }, t;
}(), oi = /** @class */ function() {
    function t(t, e) {
        this.clientId = t, this.onlineState = e
        /**
     * Parses a SharedOnlineState from its JSON representation in WebStorage.
     * Logs a warning and returns null if the format of the data is not valid.
     */;
    }
    return t.ci = function(e) {
        var n = JSON.parse(e);
        return "object" == typeof n && -1 !== [ "Unknown", "Online", "Offline" ].indexOf(n.onlineState) && "string" == typeof n.clientId ? new t(n.clientId, n.onlineState) : (N("SharedClientState", "Failed to parse online state: " + e), 
        null);
    }, t;
}(), si = /** @class */ function() {
    function t() {
        this.activeTargetIds = Qt();
    }
    return t.prototype.hi = function(t) {
        this.activeTargetIds = this.activeTargetIds.add(t);
    }, t.prototype.li = function(t) {
        this.activeTargetIds = this.activeTargetIds.delete(t);
    }, 
    /**
     * Converts this entry into a JSON-encoded format we can use for WebStorage.
     * Does not encode `clientId` as it is part of the key in WebStorage.
     */
    t.prototype.ui = function() {
        var t = {
            activeTargetIds: this.activeTargetIds.A(),
            updateTimeMs: Date.now()
        };
        return JSON.stringify(t);
    }, t;
}(), ui = /** @class */ function() {
    function t(t, e, n, r, i) {
        this.window = t, this.fn = e, this.persistenceKey = n, this._i = r, this.fi = null, 
        this.di = null, this.si = null, this.wi = this.mi.bind(this), this.Ti = new Ot(st), 
        this.Ei = !1, 
        /**
             * Captures WebStorage events that occur before `start()` is called. These
             * events are replayed once `WebStorageSharedClientState` is started.
             */
        this.Ii = [];
        // Escape the special characters mentioned here:
        // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Regular_Expressions
        var o = n.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
        this.storage = this.window.localStorage, this.currentUser = i, this.Ai = Zr(this.persistenceKey, this._i), 
        this.Ri = 
        /** Assembles the key for the current sequence number. */
        function(t) {
            return "firestore_sequence_number_" + t;
        }(this.persistenceKey), this.Ti = this.Ti.ot(this._i, new si), this.gi = new RegExp("^firestore_clients_" + o + "_([^_]*)$"), 
        this.Pi = new RegExp("^firestore_mutations_" + o + "_(\\d+)(?:_(.*))?$"), this.yi = new RegExp("^firestore_targets_" + o + "_(\\d+)$"), 
        this.Vi = 
        /** Assembles the key for the online state of the primary tab. */
        function(t) {
            return "firestore_online_state_" + t;
        }(this.persistenceKey), 
        // Rather than adding the storage observer during start(), we add the
        // storage observer during initialization. This ensures that we collect
        // events before other components populate their initial state (during their
        // respective start() calls). Otherwise, we might for example miss a
        // mutation that is added after LocalStore's start() processed the existing
        // mutations but before we observe WebStorage events.
        this.window.addEventListener("storage", this.wi);
    }
    /** Returns 'true' if WebStorage is available in the current environment. */    return t.Ln = function(t) {
        return !(!t || !t.localStorage);
    }, t.prototype.start = function() {
        return e(this, void 0, void 0, (function() {
            var t, e, r, i, o, s, u, a, c, h, f, l = this;
            return n(this, (function(n) {
                switch (n.label) {
                  case 0:
                    return [ 4 /*yield*/ , this.fi.pi() ];

                  case 1:
                    for (t = n.sent(), e = 0, r = t; e < r.length; e++) (i = r[e]) !== this._i && (o = this.getItem(Zr(this.persistenceKey, i))) && (s = ii.ci(i, o)) && (this.Ti = this.Ti.ot(s.clientId, s));
                    for (this.bi(), (u = this.storage.getItem(this.Vi)) && (a = this.vi(u)) && this.Si(a), 
                    c = 0, h = this.Ii; c < h.length; c++) f = h[c], this.mi(f);
                    return this.Ii = [], 
                    // Register a window unload hook to remove the client metadata entry from
                    // WebStorage even if `shutdown()` was not called.
                    this.window.addEventListener("unload", (function() {
                        return l.Di();
                    })), this.Ei = !0, [ 2 /*return*/ ];
                }
            }));
        }));
    }, t.prototype.oi = function(t) {
        this.setItem(this.Ri, JSON.stringify(t));
    }, t.prototype.Ci = function() {
        return this.Ni(this.Ti);
    }, t.prototype.Fi = function(t) {
        var e = !1;
        return this.Ti.forEach((function(n, r) {
            r.activeTargetIds.has(t) && (e = !0);
        })), e;
    }, t.prototype.xi = function(t) {
        this.$i(t, "pending");
    }, t.prototype.ki = function(t, e, n) {
        this.$i(t, e, n), 
        // Once a final mutation result is observed by other clients, they no longer
        // access the mutation's metadata entry. Since WebStorage replays events
        // in order, it is safe to delete the entry right after updating it.
        this.Mi(t);
    }, t.prototype.Oi = function(t) {
        var e = "not-current";
        // Lookup an existing query state if the target ID was already registered
        // by another tab
                if (this.Fi(t)) {
            var n = this.storage.getItem(ei(this.persistenceKey, t));
            if (n) {
                var r = ri.ci(t, n);
                r && (e = r.state);
            }
        }
        return this.Li.hi(t), this.bi(), e;
    }, t.prototype.Bi = function(t) {
        this.Li.li(t), this.bi();
    }, t.prototype.qi = function(t) {
        return this.Li.activeTargetIds.has(t);
    }, t.prototype.Ui = function(t) {
        this.removeItem(ei(this.persistenceKey, t));
    }, t.prototype.Qi = function(t, e, n) {
        this.Wi(t, e, n);
    }, t.prototype.ji = function(t, e, n) {
        var r = this;
        e.forEach((function(t) {
            r.Mi(t);
        })), this.currentUser = t, n.forEach((function(t) {
            r.xi(t);
        }));
    }, t.prototype.Ki = function(t) {
        this.Gi(t);
    }, t.prototype.Di = function() {
        this.Ei && (this.window.removeEventListener("storage", this.wi), this.removeItem(this.Ai), 
        this.Ei = !1);
    }, t.prototype.getItem = function(t) {
        var e = this.storage.getItem(t);
        return T("SharedClientState", "READ", t, e), e;
    }, t.prototype.setItem = function(t, e) {
        T("SharedClientState", "SET", t, e), this.storage.setItem(t, e);
    }, t.prototype.removeItem = function(t) {
        T("SharedClientState", "REMOVE", t), this.storage.removeItem(t);
    }, t.prototype.mi = function(t) {
        var r = this, i = t;
        // Note: The function is typed to take Event to be interface-compatible with
        // `Window.addEventListener`.
                if (i.storageArea === this.storage) {
            if (T("SharedClientState", "EVENT", i.key, i.newValue), i.key === this.Ai) return void N("Received WebStorage notification for local change. Another client might have garbage-collected our state");
            this.fn.Cs((function() {
                return e(r, void 0, void 0, (function() {
                    var t, e, r, o, s, u;
                    return n(this, (function(n) {
                        if (this.Ei) {
                            if (null !== i.key) if (this.gi.test(i.key)) {
                                if (null == i.newValue) return t = this.zi(i.key), [ 2 /*return*/ , this.Hi(t, null) ];
                                if (e = this.Yi(i.key, i.newValue)) return [ 2 /*return*/ , this.Hi(e.clientId, e) ];
                            } else if (this.Pi.test(i.key)) {
                                if (null !== i.newValue && (r = this.Ji(i.key, i.newValue))) return [ 2 /*return*/ , this.Xi(r) ];
                            } else if (this.yi.test(i.key)) {
                                if (null !== i.newValue && (o = this.Zi(i.key, i.newValue))) return [ 2 /*return*/ , this.tr(o) ];
                            } else if (i.key === this.Vi) {
                                if (null !== i.newValue && (s = this.vi(i.newValue))) return [ 2 /*return*/ , this.Si(s) ];
                            } else i.key === this.Ri && (u = function(t) {
                                var e = Jr.ai;
                                if (null != t) try {
                                    var n = JSON.parse(t);
                                    k("number" == typeof n), e = n;
                                } catch (t) {
                                    N("SharedClientState", "Failed to read sequence number from WebStorage", t);
                                }
                                return e;
                            }(i.newValue)) !== Jr.ai && this.si(u);
                        } else this.Ii.push(i);
                        return [ 2 /*return*/ ];
                    }));
                }));
            }));
        }
    }, Object.defineProperty(t.prototype, "Li", {
        get: function() {
            return this.Ti.get(this._i);
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.bi = function() {
        this.setItem(this.Ai, this.Li.ui());
    }, t.prototype.$i = function(t, e, n) {
        var r = new ni(this.currentUser, t, e, n), i = ti(this.persistenceKey, this.currentUser, t);
        this.setItem(i, r.ui());
    }, t.prototype.Mi = function(t) {
        var e = ti(this.persistenceKey, this.currentUser, t);
        this.removeItem(e);
    }, t.prototype.Gi = function(t) {
        var e = {
            clientId: this._i,
            onlineState: t
        };
        this.storage.setItem(this.Vi, JSON.stringify(e));
    }, t.prototype.Wi = function(t, e, n) {
        var r = ei(this.persistenceKey, t), i = new ri(t, e, n);
        this.setItem(r, i.ui());
    }, 
    /**
     * Parses a client state key in WebStorage. Returns null if the key does not
     * match the expected key format.
     */
    t.prototype.zi = function(t) {
        var e = this.gi.exec(t);
        return e ? e[1] : null;
    }, 
    /**
     * Parses a client state in WebStorage. Returns 'null' if the value could not
     * be parsed.
     */
    t.prototype.Yi = function(t, e) {
        var n = this.zi(t);
        return ii.ci(n, e);
    }, 
    /**
     * Parses a mutation batch state in WebStorage. Returns 'null' if the value
     * could not be parsed.
     */
    t.prototype.Ji = function(t, e) {
        var n = this.Pi.exec(t), r = Number(n[1]), i = void 0 !== n[2] ? n[2] : null;
        return ni.ci(new Xr(i), r, e);
    }, 
    /**
     * Parses a query target state from WebStorage. Returns 'null' if the value
     * could not be parsed.
     */
    t.prototype.Zi = function(t, e) {
        var n = this.yi.exec(t), r = Number(n[1]);
        return ri.ci(r, e);
    }, 
    /**
     * Parses an online state from WebStorage. Returns 'null' if the value
     * could not be parsed.
     */
    t.prototype.vi = function(t) {
        return oi.ci(t);
    }, t.prototype.Xi = function(t) {
        return e(this, void 0, void 0, (function() {
            return n(this, (function(e) {
                return t.user.uid === this.currentUser.uid ? [ 2 /*return*/ , this.fi.er(t.batchId, t.state, t.error) ] : (T("SharedClientState", "Ignoring mutation for non-active user " + t.user.uid), 
                [ 2 /*return*/ ]);
            }));
        }));
    }, t.prototype.tr = function(t) {
        return this.fi.nr(t.targetId, t.state, t.error);
    }, t.prototype.Hi = function(t, e) {
        var n = this, r = e ? this.Ti.ot(t, e) : this.Ti.remove(t), i = this.Ni(this.Ti), o = this.Ni(r), s = [], u = [];
        return o.forEach((function(t) {
            i.has(t) || s.push(t);
        })), i.forEach((function(t) {
            o.has(t) || u.push(t);
        })), this.fi.sr(s, u).then((function() {
            n.Ti = r;
        }));
    }, t.prototype.Si = function(t) {
        // We check whether the client that wrote this online state is still active
        // by comparing its client ID to the list of clients kept active in
        // IndexedDb. If a client does not update their IndexedDb client state
        // within 5 seconds, it is considered inactive and we don't emit an online
        // state event.
        this.Ti.get(t.clientId) && this.di(t.onlineState);
    }, t.prototype.Ni = function(t) {
        var e = Qt();
        return t.forEach((function(t, n) {
            e = e.kt(n.activeTargetIds);
        })), e;
    }, t;
}(), ai = /** @class */ function() {
    function t() {
        this.ir = new si, this.rr = {}, this.di = null, this.si = null;
    }
    return t.prototype.xi = function(t) {
        // No op.
    }, t.prototype.ki = function(t, e, n) {
        // No op.
    }, t.prototype.Oi = function(t) {
        return this.ir.hi(t), this.rr[t] || "not-current";
    }, t.prototype.Qi = function(t, e, n) {
        this.rr[t] = e;
    }, t.prototype.Bi = function(t) {
        this.ir.li(t);
    }, t.prototype.qi = function(t) {
        return this.ir.activeTargetIds.has(t);
    }, t.prototype.Ui = function(t) {
        delete this.rr[t];
    }, t.prototype.Ci = function() {
        return this.ir.activeTargetIds;
    }, t.prototype.Fi = function(t) {
        return this.ir.activeTargetIds.has(t);
    }, t.prototype.start = function() {
        return this.ir = new si, Promise.resolve();
    }, t.prototype.ji = function(t, e, n) {
        // No op.
    }, t.prototype.Ki = function(t) {
        // No op.
    }, t.prototype.Di = function() {}, t.prototype.oi = function(t) {}, t;
}(), ci = /** @class */ function() {
    /**
     * @param batchId The unique ID of this mutation batch.
     * @param localWriteTime The original write time of this mutation.
     * @param baseMutations Mutations that are used to populate the base
     * values when this mutation is applied locally. This can be used to locally
     * overwrite values that are persisted in the remote document cache. Base
     * mutations are never sent to the backend.
     * @param mutations The user-provided mutations in this mutation batch.
     * User-provided mutations are applied both locally and remotely on the
     * backend.
     */
    function t(t, e, n, r) {
        this.batchId = t, this.ar = e, this.baseMutations = n, this.mutations = r
        /**
     * Applies all the mutations in this MutationBatch to the specified document
     * to create a new remote document
     *
     * @param docKey The key of the document to apply mutations to.
     * @param maybeDoc The document to apply mutations to.
     * @param batchResult The result of applying the MutationBatch to the
     * backend.
     */;
    }
    return t.prototype.cr = function(t, e, n) {
        for (var r = n.ur, i = 0; i < this.mutations.length; i++) {
            var o = this.mutations[i];
            o.key.isEqual(t) && (e = An(o, e, r[i]));
        }
        return e;
    }, 
    /**
     * Computes the local view of a document given all the mutations in this
     * batch.
     *
     * @param docKey The key of the document to apply mutations to.
     * @param maybeDoc The document to apply mutations to.
     */
    t.prototype.hr = function(t, e) {
        // First, apply the base state. This allows us to apply non-idempotent
        // transform against a consistent set of values.
        for (var n = 0, r = this.baseMutations; n < r.length; n++) {
            var i = r[n];
            i.key.isEqual(t) && (e = Sn(i, e, e, this.ar));
        }
        // Second, apply all user-provided mutations.
        for (var o = e, s = 0, u = this.mutations; s < u.length; s++) {
            var a = u[s];
            a.key.isEqual(t) && (e = Sn(a, e, o, this.ar));
        }
        return e;
    }, 
    /**
     * Computes the local view for all provided documents given the mutations in
     * this batch.
     */
    t.prototype.lr = function(t) {
        var e = this, n = t;
        // TODO(mrschmidt): This implementation is O(n^2). If we apply the mutations
        // directly (as done in `applyToLocalView()`), we can reduce the complexity
        // to O(n).
                return this.mutations.forEach((function(r) {
            var i = e.hr(r.key, t.get(r.key));
            i && (n = n.ot(r.key, i));
        })), n;
    }, t.prototype.keys = function() {
        return this.mutations.reduce((function(t, e) {
            return t.add(e.key);
        }), Kt());
    }, t.prototype.isEqual = function(t) {
        return this.batchId === t.batchId && ut(this.mutations, t.mutations, (function(t, e) {
            return kn(t, e);
        })) && ut(this.baseMutations, t.baseMutations, (function(t, e) {
            return kn(t, e);
        }));
    }, t;
}(), hi = /** @class */ function() {
    function t(t, e, n, 
    /**
     * A pre-computed mapping from each mutated document to the resulting
     * version.
     */
    r) {
        this.batch = t, this._r = e, this.ur = n, this.dr = r
        /**
     * Creates a new MutationBatchResult for the given batch and results. There
     * must be one result for each mutation in the batch. This static factory
     * caches a document=>version mapping (docVersions).
     */;
    }
    return t.from = function(e, n, r) {
        k(e.mutations.length === r.length);
        for (var i = zt, o = e.mutations, s = 0; s < o.length; s++) i = i.ot(o[s].key, r[s].version);
        return new t(e, n, r, i);
    }, t;
}(), fi = /** @class */ function() {
    function t() {
        // A mapping of document key to the new cache entry that should be written (or null if any
        // existing cache entry should be removed).
        this.wr = new yt((function(t) {
            return t.toString();
        }), (function(t, e) {
            return t.isEqual(e);
        })), this.mr = !1;
    }
    return Object.defineProperty(t.prototype, "readTime", {
        get: function() {
            return this.Tr;
        },
        set: function(t) {
            this.Tr = t;
        },
        enumerable: !1,
        configurable: !0
    }), 
    /**
     * Buffers a `RemoteDocumentCache.addEntry()` call.
     *
     * You can only modify documents that have already been retrieved via
     * `getEntry()/getEntries()` (enforced via IndexedDbs `apply()`).
     */
    t.prototype.Er = function(t, e) {
        this.Ir(), this.readTime = e, this.wr.set(t.key, t);
    }, 
    /**
     * Buffers a `RemoteDocumentCache.removeEntry()` call.
     *
     * You can only remove documents that have already been retrieved via
     * `getEntry()/getEntries()` (enforced via IndexedDbs `apply()`).
     */
    t.prototype.Ar = function(t, e) {
        this.Ir(), e && (this.readTime = e), this.wr.set(t, null);
    }, 
    /**
     * Looks up an entry in the cache. The buffered changes will first be checked,
     * and if no buffered change applies, this will forward to
     * `RemoteDocumentCache.getEntry()`.
     *
     * @param transaction The transaction in which to perform any persistence
     *     operations.
     * @param documentKey The key of the entry to look up.
     * @return The cached Document or NoDocument entry, or null if we have nothing
     * cached.
     */
    t.prototype.Rr = function(t, e) {
        this.Ir();
        var n = this.wr.get(e);
        return void 0 !== n ? Dr.resolve(n) : this.gr(t, e);
    }, 
    /**
     * Looks up several entries in the cache, forwarding to
     * `RemoteDocumentCache.getEntry()`.
     *
     * @param transaction The transaction in which to perform any persistence
     *     operations.
     * @param documentKeys The keys of the entries to look up.
     * @return A map of cached `Document`s or `NoDocument`s, indexed by key. If an
     *     entry cannot be found, the corresponding key will be mapped to a null
     *     value.
     */
    t.prototype.getEntries = function(t, e) {
        return this.Pr(t, e);
    }, 
    /**
     * Applies buffered changes to the underlying RemoteDocumentCache, using
     * the provided transaction.
     */
    t.prototype.apply = function(t) {
        return this.Ir(), this.mr = !0, this.yr(t);
    }, 
    /** Helper to assert this.changes is not null  */ t.prototype.Ir = function() {}, 
    t;
}(), li = "The current tab is not in the required state to perform this operation. It might be necessary to refresh the browser tab.", pi = /** @class */ function() {
    function t() {
        this.Vr = [];
    }
    return t.prototype.pr = function(t) {
        this.Vr.push(t);
    }, t.prototype.br = function() {
        this.Vr.forEach((function(t) {
            return t();
        }));
    }, t;
}(), di = /** @class */ function() {
    function t(t, e, n) {
        this.vr = t, this.Sr = e, this.Dr = n
        /**
     * Get the local view of the document identified by `key`.
     *
     * @return Local view of the document or null if we don't have any cached
     * state for it.
     */;
    }
    return t.prototype.Cr = function(t, e) {
        var n = this;
        return this.Sr.Nr(t, e).next((function(r) {
            return n.Fr(t, e, r);
        }));
    }, 
    /** Internal version of `getDocument` that allows reusing batches. */ t.prototype.Fr = function(t, e, n) {
        return this.vr.Rr(t, e).next((function(t) {
            for (var r = 0, i = n; r < i.length; r++) {
                t = i[r].hr(e, t);
            }
            return t;
        }));
    }, 
    // Returns the view of the given `docs` as they would appear after applying
    // all mutations in the given `batches`.
    t.prototype.$r = function(t, e, n) {
        var r = qt();
        return e.forEach((function(t, e) {
            for (var i = 0, o = n; i < o.length; i++) {
                e = o[i].hr(t, e);
            }
            r = r.ot(t, e);
        })), r;
    }, 
    /**
     * Gets the local view of the documents identified by `keys`.
     *
     * If we don't have cached state for a document in `keys`, a NoDocument will
     * be stored for that key in the resulting set.
     */
    t.prototype.kr = function(t, e) {
        var n = this;
        return this.vr.getEntries(t, e).next((function(e) {
            return n.Mr(t, e);
        }));
    }, 
    /**
     * Similar to `getDocuments`, but creates the local view from the given
     * `baseDocs` without retrieving documents from the local store.
     */
    t.prototype.Mr = function(t, e) {
        var n = this;
        return this.Sr.Or(t, e).next((function(r) {
            var i = n.$r(t, e, r), o = Mt();
            return i.forEach((function(t, e) {
                // TODO(http://b/32275378): Don't conflate missing / deleted.
                e || (e = new Bn(t, gt.min())), o = o.ot(t, e);
            })), o;
        }));
    }, 
    /**
     * Performs a query against the local view of all documents.
     *
     * @param transaction The persistence transaction.
     * @param query The query to match documents against.
     * @param sinceReadTime If not set to SnapshotVersion.min(), return only
     *     documents that have been read since this snapshot version (exclusive).
     */
    t.prototype.Lr = function(t, e, n) {
        /**
 * Returns whether the query matches a single document by path (rather than a
 * collection).
 */
        return function(t) {
            return F.F(t.path) && null === t.collectionGroup && 0 === t.filters.length;
        }(e) ? this.Br(t, e.path) : Zn(e) ? this.qr(t, e, n) : this.Ur(t, e, n);
    }, t.prototype.Br = function(t, e) {
        // Just do a simple document lookup.
        return this.Cr(t, new F(e)).next((function(t) {
            var e = Gt();
            return t instanceof zn && (e = e.ot(t.key, t)), e;
        }));
    }, t.prototype.qr = function(t, e, n) {
        var r = this, i = e.collectionGroup, o = Gt();
        return this.Dr.Qr(t, i).next((function(s) {
            return Dr.forEach(s, (function(s) {
                var u = function(t, e) {
                    return new Wn(e, 
                    /*collectionGroup=*/ null, t.on.slice(), t.filters.slice(), t.limit, t.an, t.startAt, t.endAt);
                }(e, s.child(i));
                return r.Ur(t, u, n).next((function(t) {
                    t.forEach((function(t, e) {
                        o = o.ot(t, e);
                    }));
                }));
            })).next((function() {
                return o;
            }));
        }));
    }, t.prototype.Ur = function(t, e, n) {
        var r, i, o = this;
        // Query the remote documents and overlay mutations.
                return this.vr.Lr(t, e, n).next((function(n) {
            return r = n, o.Sr.Wr(t, e);
        })).next((function(e) {
            return i = e, o.jr(t, i, r).next((function(t) {
                r = t;
                for (var e = 0, n = i; e < n.length; e++) for (var o = n[e], s = 0, u = o.mutations; s < u.length; s++) {
                    var a = u[s], c = a.key, h = r.get(c), f = Sn(a, h, h, o.ar);
                    r = f instanceof zn ? r.ot(c, f) : r.remove(c);
                }
            }));
        })).next((function() {
            // Finally, filter out any documents that don't actually match
            // the query.
            return r.forEach((function(t, n) {
                ar(e, n) || (r = r.remove(t));
            })), r;
        }));
    }, t.prototype.jr = function(t, e, n) {
        for (var r = Kt(), i = 0, o = e; i < o.length; i++) for (var s = 0, u = o[i].mutations; s < u.length; s++) {
            var a = u[s];
            a instanceof Rn && null === n.get(a.key) && (r = r.add(a.key));
        }
        var c = n;
        return this.vr.getEntries(t, r).next((function(t) {
            return t.forEach((function(t, e) {
                null !== e && e instanceof zn && (c = c.ot(t, e));
            })), c;
        }));
    }, t;
}(), vi = /** @class */ function() {
    function t(t, e, n, r) {
        this.targetId = t, this.fromCache = e, this.Kr = n, this.Gr = r;
    }
    return t.zr = function(e, n) {
        for (var r = Kt(), i = Kt(), o = 0, s = n.docChanges; o < s.length; o++) {
            var u = s[o];
            switch (u.type) {
              case 0 /* Added */ :
                r = r.add(u.doc.key);
                break;

              case 1 /* Removed */ :
                i = i.add(u.doc.key);
                // do nothing
                        }
        }
        return new t(e, n.fromCache, r, i);
    }, t;
}();

/**
 * Holds the state of a query target, including its target ID and whether the
 * target is 'not-current', 'current' or 'rejected'.
 */
// Visible for testing
/**
 * @license
 * Copyright 2018 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
function yi(t, e) {
    var n = t[0], r = t[1], i = e[0], o = e[1], s = st(n, i);
    return 0 === s ? st(r, o) : s;
}

/**
 * Used to calculate the nth sequence number. Keeps a rolling buffer of the
 * lowest n values passed to `addElement`, and finally reports the largest of
 * them in `maxValue`.
 */ var mi = /** @class */ function() {
    function t(t) {
        this.Hr = t, this.buffer = new Ut(yi), this.Yr = 0;
    }
    return t.prototype.Jr = function() {
        return ++this.Yr;
    }, t.prototype.Xr = function(t) {
        var e = [ t, this.Jr() ];
        if (this.buffer.size < this.Hr) this.buffer = this.buffer.add(e); else {
            var n = this.buffer.last();
            yi(e, n) < 0 && (this.buffer = this.buffer.delete(n).add(e));
        }
    }, Object.defineProperty(t.prototype, "maxValue", {
        get: function() {
            // Guaranteed to be non-empty. If we decide we are not collecting any
            // sequence numbers, nthSequenceNumber below short-circuits. If we have
            // decided that we are collecting n sequence numbers, it's because n is some
            // percentage of the existing sequence numbers. That means we should never
            // be in a situation where we are collecting sequence numbers but don't
            // actually have any.
            return this.buffer.last()[0];
        },
        enumerable: !1,
        configurable: !0
    }), t;
}(), gi = {
    Zr: !1,
    eo: 0,
    no: 0,
    so: 0
}, wi = /** @class */ function() {
    function t(
    // When we attempt to collect, we will only do so if the cache size is greater than this
    // threshold. Passing `COLLECTION_DISABLED` here will cause collection to always be skipped.
    t, 
    // The percentage of sequence numbers that we will attempt to collect
    e, 
    // A cap on the total number of sequence numbers that will be collected. This prevents
    // us from collecting a huge number of sequence numbers if the cache has grown very large.
    n) {
        this.io = t, this.ro = e, this.oo = n;
    }
    return t.ao = function(e) {
        return new t(e, t.co, t.uo);
    }, t;
}();

wi.ho = -1, wi.lo = 1048576, wi._o = 41943040, wi.co = 10, wi.uo = 1e3, wi.fo = new wi(wi._o, wi.co, wi.uo), 
wi.do = new wi(wi.ho, 0, 0);

/**
 * This class is responsible for the scheduling of LRU garbage collection. It handles checking
 * whether or not GC is enabled, as well as which delay to use before the next run.
 */
var bi = /** @class */ function() {
    function t(t, e) {
        this.wo = t, this.cs = e, this.mo = !1, this.To = null;
    }
    return t.prototype.start = function(t) {
        this.wo.params.io !== wi.ho && this.Eo(t);
    }, t.prototype.stop = function() {
        this.To && (this.To.cancel(), this.To = null);
    }, Object.defineProperty(t.prototype, "Ei", {
        get: function() {
            return null !== this.To;
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.Eo = function(t) {
        var r = this, i = this.mo ? 3e5 : 6e4;
        T("LruGarbageCollector", "Garbage collection scheduled in " + i + "ms"), this.To = this.cs.yn("lru_garbage_collection" /* LruGarbageCollection */ , i, (function() {
            return e(r, void 0, void 0, (function() {
                var e;
                return n(this, (function(n) {
                    switch (n.label) {
                      case 0:
                        this.To = null, this.mo = !0, n.label = 1;

                      case 1:
                        return n.trys.push([ 1, 3, , 7 ]), [ 4 /*yield*/ , t.Io(this.wo) ];

                      case 2:
                        return n.sent(), [ 3 /*break*/ , 7 ];

                      case 3:
                        return Rr(e = n.sent()) ? (T("LruGarbageCollector", "Ignoring IndexedDB error during garbage collection: ", e), 
                        [ 3 /*break*/ , 6 ]) : [ 3 /*break*/ , 4 ];

                      case 4:
                        return [ 4 /*yield*/ , qo(e) ];

                      case 5:
                        n.sent(), n.label = 6;

                      case 6:
                        return [ 3 /*break*/ , 7 ];

                      case 7:
                        return [ 4 /*yield*/ , this.Eo(t) ];

                      case 8:
                        return n.sent(), [ 2 /*return*/ ];
                    }
                }));
            }));
        }));
    }, t;
}(), Ii = /** @class */ function() {
    function t(t, e) {
        this.Ao = t, this.params = e
        /** Given a percentile of target to collect, returns the number of targets to collect. */;
    }
    return t.prototype.Ro = function(t, e) {
        return this.Ao.Po(t).next((function(t) {
            return Math.floor(e / 100 * t);
        }));
    }, 
    /** Returns the nth sequence number, counting in order from the smallest. */ t.prototype.yo = function(t, e) {
        var n = this;
        if (0 === e) return Dr.resolve(Jr.ai);
        var r = new mi(e);
        return this.Ao.Ce(t, (function(t) {
            return r.Xr(t.sequenceNumber);
        })).next((function() {
            return n.Ao.Vo(t, (function(t) {
                return r.Xr(t);
            }));
        })).next((function() {
            return r.maxValue;
        }));
    }, 
    /**
     * Removes targets with a sequence number equal to or less than the given upper bound, and removes
     * document associations with those targets.
     */
    t.prototype.po = function(t, e, n) {
        return this.Ao.po(t, e, n);
    }, 
    /**
     * Removes documents that have a sequence number equal to or less than the upper bound and are not
     * otherwise pinned.
     */
    t.prototype.bo = function(t, e) {
        return this.Ao.bo(t, e);
    }, t.prototype.vo = function(t, e) {
        var n = this;
        return this.params.io === wi.ho ? (T("LruGarbageCollector", "Garbage collection skipped; disabled"), 
        Dr.resolve(gi)) : this.So(t).next((function(r) {
            return r < n.params.io ? (T("LruGarbageCollector", "Garbage collection skipped; Cache size " + r + " is lower than threshold " + n.params.io), 
            gi) : n.Do(t, e);
        }));
    }, t.prototype.So = function(t) {
        return this.Ao.So(t);
    }, t.prototype.Do = function(t, e) {
        var n, r, i, o, u, a, c, h = this, f = Date.now();
        return this.Ro(t, this.params.ro).next((function(e) {
            // Cap at the configured max
            return e > h.params.oo ? (T("LruGarbageCollector", "Capping sequence numbers to collect down to the maximum of " + h.params.oo + " from " + e), 
            r = h.params.oo) : r = e, o = Date.now(), h.yo(t, r);
        })).next((function(r) {
            return n = r, u = Date.now(), h.po(t, n, e);
        })).next((function(e) {
            return i = e, a = Date.now(), h.bo(t, n);
        })).next((function(t) {
            return c = Date.now(), _() <= s.DEBUG && T("LruGarbageCollector", "LRU Garbage Collection\n\tCounted targets in " + (o - f) + "ms\n\tDetermined least recently used " + r + " in " + (u - o) + "ms\n\tRemoved " + i + " targets in " + (a - u) + "ms\n\tRemoved " + t + " documents in " + (c - a) + "ms\nTotal Duration: " + (c - f) + "ms"), 
            Dr.resolve({
                Zr: !0,
                eo: r,
                no: i,
                so: t
            });
        }));
    }, t;
}();

/** Implements the steps for LRU garbage collection. */
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Encodes a resource path into a IndexedDb-compatible string form.
 */
function Ei(t) {
    for (var e = "", n = 0; n < t.length; n++) e.length > 0 && (e = Ti(e)), e = _i(t.get(n), e);
    return Ti(e);
}

/** Encodes a single segment of a resource path into the given result */ function _i(t, e) {
    for (var n = e, r = t.length, i = 0; i < r; i++) {
        var o = t.charAt(i);
        switch (o) {
          case "\0":
            n += "";
            break;

          case "":
            n += "";
            break;

          default:
            n += o;
        }
    }
    return n;
}

/** Encodes a path separator into the given result */ function Ti(t) {
    return t + "";
}

/**
 * Decodes the given IndexedDb-compatible string form of a resource path into
 * a ResourcePath instance. Note that this method is not suitable for use with
 * decoding resource names from the server; those are One Platform format
 * strings.
 */ function Ni(t) {
    // Event the empty path must encode as a path of at least length 2. A path
    // with exactly 2 must be the empty path.
    var e = t.length;
    if (k(e >= 2), 2 === e) return k("" === t.charAt(0) && "" === t.charAt(1)), V.P();
    // Escape characters cannot exist past the second-to-last position in the
    // source value.
        for (var n = e - 2, r = [], i = "", o = 0; o < e; ) {
        // The last two characters of a valid encoded path must be a separator, so
        // there must be an end to this segment.
        var s = t.indexOf("", o);
        switch ((s < 0 || s > n) && D(), t.charAt(s + 1)) {
          case "":
            var u = t.substring(o, s), a = void 0;
            0 === i.length ? 
            // Avoid copying for the common case of a segment that excludes \0
            // and \001
            a = u : (a = i += u, i = ""), r.push(a);
            break;

          case "":
            i += t.substring(o, s), i += "\0";
            break;

          case "":
            // The escape character can be used in the output to encode itself.
            i += t.substring(o, s + 1);
            break;

          default:
            D();
        }
        o = s + 2;
    }
    return new V(r);
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** Serializer for values stored in the LocalStore. */ var Ai = function(t) {
    this.Co = t;
};

/** Decodes a remote document from storage locally to a Document. */ function Si(t, e) {
    if (e.document) return function(t, e, n) {
        var r = Me(t, e.name), i = Ve(e.updateTime), o = new Mn({
            mapValue: {
                fields: e.fields
            }
        });
        return new zn(r, i, o, {
            hasCommittedMutations: !!n
        });
    }(t.Co, e.document, !!e.hasCommittedMutations);
    if (e.noDocument) {
        var n = F.$(e.noDocument.path), r = Ri(e.noDocument.readTime);
        return new Bn(n, r, {
            hasCommittedMutations: !!e.hasCommittedMutations
        });
    }
    if (e.unknownDocument) {
        var i = F.$(e.unknownDocument.path), o = Ri(e.unknownDocument.version);
        return new Kn(i, o);
    }
    return D();
}

/** Encodes a document for storage locally. */ function Di(t, e, n) {
    var r = ki(n), i = e.key.path.h().A();
    if (e instanceof zn) {
        var o = function(t, e) {
            return {
                name: Fe(t, e.key),
                fields: e.rn().mapValue.fields,
                updateTime: Re(t, e.version.Z())
            };
        }(t.Co, e), s = e.hasCommittedMutations;
        return new io(
        /* unknownDocument= */ null, 
        /* noDocument= */ null, o, s, r, i);
    }
    if (e instanceof Bn) {
        var u = e.key.path.A(), a = Li(e.version), c = e.hasCommittedMutations;
        return new io(
        /* unknownDocument= */ null, new no(u, a), 
        /* document= */ null, c, r, i);
    }
    if (e instanceof Kn) {
        var h = e.key.path.A(), f = Li(e.version);
        return new io(new ro(h, f), 
        /* noDocument= */ null, 
        /* document= */ null, 
        /* hasCommittedMutations= */ !0, r, i);
    }
    return D();
}

function ki(t) {
    var e = t.Z();
    return [ e.seconds, e.nanoseconds ];
}

function xi(t) {
    var e = new mt(t[0], t[1]);
    return gt.J(e);
}

function Li(t) {
    var e = t.Z();
    return new Xi(e.seconds, e.nanoseconds);
}

function Ri(t) {
    var e = new mt(t.seconds, t.nanoseconds);
    return gt.J(e);
}

/** Encodes a batch of mutations into a DbMutationBatch for local storage. */
/** Decodes a DbMutationBatch into a MutationBatch */ function Oi(t, e) {
    var n = (e.baseMutations || []).map((function(e) {
        return We(t.Co, e);
    })), r = e.mutations.map((function(e) {
        return We(t.Co, e);
    })), i = mt.fromMillis(e.localWriteTimeMs);
    return new ci(e.batchId, i, n, r);
}

/** Decodes a DbTarget into TargetData */ function Pi(t) {
    var e, n, r = Ri(t.readTime), i = void 0 !== t.lastLimboFreeSnapshotVersion ? Ri(t.lastLimboFreeSnapshotVersion) : gt.min();
    return void 0 !== t.query.documents ? (k(1 === (n = t.query).documents.length), 
    e = er(Hn(je(n.documents[0])))) : e = Ye(t.query), new kt(e, t.targetId, 0 /* Listen */ , t.lastListenSequenceNumber, r, i, ct.fromBase64String(t.resumeToken))
    /** Encodes TargetData into a DbTarget for storage locally. */;
}

function Vi(t, e) {
    var n, r = Li(e.nt), i = Li(e.lastLimboFreeSnapshotVersion);
    n = At(e.target) ? Qe(t.Co, e.target) : He(t.Co, e.target);
    // We can't store the resumeToken as a ByteString in IndexedDb, so we
    // convert it to a base64 string for storage.
    var o = e.resumeToken.toBase64();
    // lastListenSequenceNumber is always 0 until we do real GC.
        return new so(e.targetId, Tt(e.target), r, o, e.sequenceNumber, i, n);
}

/**
 * A helper function for figuring out what kind of query has been stored.
 */
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** A mutation queue for a specific user, backed by IndexedDB. */ var Ui = /** @class */ function() {
    function t(
    /**
     * The normalized userId (e.g. null UID => "" userId) used to store /
     * retrieve mutations.
     */
    t, e, n, r) {
        this.userId = t, this.serializer = e, this.Dr = n, this.No = r, 
        /**
             * Caches the document keys for pending mutation batches. If the mutation
             * has been removed from IndexedDb, the cached value may continue to
             * be used to retrieve the batch's document keys. To remove a cached value
             * locally, `removeCachedMutationKeys()` should be invoked either directly
             * or through `removeMutationBatches()`.
             *
             * With multi-tab, when the primary client acknowledges or rejects a mutation,
             * this cache is used by secondary clients to invalidate the local
             * view of the documents that were previously affected by the mutation.
             */
        // PORTING NOTE: Multi-tab only.
        this.Fo = {}
        /**
     * Creates a new mutation queue for the given user.
     * @param user The user for which to create a mutation queue.
     * @param serializer The serializer to use when persisting to IndexedDb.
     */;
    }
    return t.xo = function(e, n, r, i) {
        // TODO(mcg): Figure out what constraints there are on userIDs
        // In particular, are there any reserved characters? are empty ids allowed?
        // For the moment store these together in the same mutations table assuming
        // that empty userIDs aren't allowed.
        return k("" !== e.uid), new t(e.Zs() ? e.uid : "", n, r, i);
    }, t.prototype.$o = function(t) {
        var e = !0, n = IDBKeyRange.bound([ this.userId, Number.NEGATIVE_INFINITY ], [ this.userId, Number.POSITIVE_INFINITY ]);
        return Mi(t).rs({
            index: to.userMutationsIndex,
            range: n
        }, (function(t, n, r) {
            e = !1, r.done();
        })).next((function() {
            return e;
        }));
    }, t.prototype.ko = function(t, e, n, r) {
        var i = this, o = qi(t), s = Mi(t);
        // The IndexedDb implementation in Chrome (and Firefox) does not handle
        // compound indices that include auto-generated keys correctly. To ensure
        // that the index entry is added correctly in all browsers, we perform two
        // writes: The first write is used to retrieve the next auto-generated Batch
        // ID, and the second write populates the index and stores the actual
        // mutation batch.
        // See: https://bugs.chromium.org/p/chromium/issues/detail?id=701972
        // We write an empty object to obtain key
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        return s.add({}).next((function(u) {
            k("number" == typeof u);
            for (var a = new ci(u, e, n, r), c = function(t, e, n) {
                var r = n.baseMutations.map((function(e) {
                    return Ke(t.Co, e);
                })), i = n.mutations.map((function(e) {
                    return Ke(t.Co, e);
                }));
                return new to(e, n.batchId, n.ar.toMillis(), r, i);
            }(i.serializer, i.userId, a), h = [], f = new Ut((function(t, e) {
                return st(t.R(), e.R());
            })), l = 0, p = r; l < p.length; l++) {
                var d = p[l], v = eo.key(i.userId, d.key.path, u);
                f = f.add(d.key.path.h()), h.push(s.put(c)), h.push(o.put(v, eo.PLACEHOLDER));
            }
            return f.forEach((function(e) {
                h.push(i.Dr.Mo(t, e));
            })), t.pr((function() {
                i.Fo[u] = a.keys();
            })), Dr.$n(h).next((function() {
                return a;
            }));
        }));
    }, t.prototype.Oo = function(t, e) {
        var n = this;
        return Mi(t).get(e).next((function(t) {
            return t ? (k(t.userId === n.userId), Oi(n.serializer, t)) : null;
        }));
    }, 
    /**
     * Returns the document keys for the mutation batch with the given batchId.
     * For primary clients, this method returns `null` after
     * `removeMutationBatches()` has been called. Secondary clients return a
     * cached result until `removeCachedMutationKeys()` is invoked.
     */
    // PORTING NOTE: Multi-tab only.
    t.prototype.Lo = function(t, e) {
        var n = this;
        return this.Fo[e] ? Dr.resolve(this.Fo[e]) : this.Oo(t, e).next((function(t) {
            if (t) {
                var r = t.keys();
                return n.Fo[e] = r, r;
            }
            return null;
        }));
    }, t.prototype.Bo = function(t, e) {
        var n = this, r = e + 1, i = IDBKeyRange.lowerBound([ this.userId, r ]), o = null;
        return Mi(t).rs({
            index: to.userMutationsIndex,
            range: i
        }, (function(t, e, i) {
            e.userId === n.userId && (k(e.batchId >= r), o = Oi(n.serializer, e)), i.done();
        })).next((function() {
            return o;
        }));
    }, t.prototype.qo = function(t) {
        var e = IDBKeyRange.upperBound([ this.userId, Number.POSITIVE_INFINITY ]), n = -1;
        return Mi(t).rs({
            index: to.userMutationsIndex,
            range: e,
            reverse: !0
        }, (function(t, e, r) {
            n = e.batchId, r.done();
        })).next((function() {
            return n;
        }));
    }, t.prototype.Uo = function(t) {
        var e = this, n = IDBKeyRange.bound([ this.userId, -1 ], [ this.userId, Number.POSITIVE_INFINITY ]);
        return Mi(t).ts(to.userMutationsIndex, n).next((function(t) {
            return t.map((function(t) {
                return Oi(e.serializer, t);
            }));
        }));
    }, t.prototype.Nr = function(t, e) {
        var n = this, r = eo.prefixForPath(this.userId, e.path), i = IDBKeyRange.lowerBound(r), o = [];
        // Scan the document-mutation index starting with a prefix starting with
        // the given documentKey.
                return qi(t).rs({
            range: i
        }, (function(r, i, s) {
            var u = r[0], a = r[1], c = r[2], h = Ni(a);
            // Only consider rows matching exactly the specific key of
            // interest. Note that because we order by path first, and we
            // order terminators before path separators, we'll encounter all
            // the index rows for documentKey contiguously. In particular, all
            // the rows for documentKey will occur before any rows for
            // documents nested in a subcollection beneath documentKey so we
            // can stop as soon as we hit any such row.
                        if (u === n.userId && e.path.isEqual(h)) 
            // Look up the mutation batch in the store.
            return Mi(t).get(c).next((function(t) {
                if (!t) throw D();
                k(t.userId === n.userId), o.push(Oi(n.serializer, t));
            }));
            s.done();
        })).next((function() {
            return o;
        }));
    }, t.prototype.Or = function(t, e) {
        var n = this, r = new Ut(st), i = [];
        return e.forEach((function(e) {
            var o = eo.prefixForPath(n.userId, e.path), s = IDBKeyRange.lowerBound(o), u = qi(t).rs({
                range: s
            }, (function(t, i, o) {
                var s = t[0], u = t[1], a = t[2], c = Ni(u);
                // Only consider rows matching exactly the specific key of
                // interest. Note that because we order by path first, and we
                // order terminators before path separators, we'll encounter all
                // the index rows for documentKey contiguously. In particular, all
                // the rows for documentKey will occur before any rows for
                // documents nested in a subcollection beneath documentKey so we
                // can stop as soon as we hit any such row.
                                s === n.userId && e.path.isEqual(c) ? r = r.add(a) : o.done();
            }));
            i.push(u);
        })), Dr.$n(i).next((function() {
            return n.Qo(t, r);
        }));
    }, t.prototype.Wr = function(t, e) {
        var n = this, r = e.path, i = r.length + 1, o = eo.prefixForPath(this.userId, r), s = IDBKeyRange.lowerBound(o), u = new Ut(st);
        return qi(t).rs({
            range: s
        }, (function(t, e, o) {
            var s = t[0], a = t[1], c = t[2], h = Ni(a);
            s === n.userId && r.T(h) ? 
            // Rows with document keys more than one segment longer than the
            // query path can't be matches. For example, a query on 'rooms'
            // can't match the document /rooms/abc/messages/xyx.
            // TODO(mcg): we'll need a different scanner when we implement
            // ancestor queries.
            h.length === i && (u = u.add(c)) : o.done();
        })).next((function() {
            return n.Qo(t, u);
        }));
    }, t.prototype.Qo = function(t, e) {
        var n = this, r = [], i = [];
        // TODO(rockwood): Implement this using iterate.
        return e.forEach((function(e) {
            i.push(Mi(t).get(e).next((function(t) {
                if (null === t) throw D();
                k(t.userId === n.userId), r.push(Oi(n.serializer, t));
            })));
        })), Dr.$n(i).next((function() {
            return r;
        }));
    }, t.prototype.Wo = function(t, e) {
        var n = this;
        return Fi(t.jo, this.userId, e).next((function(r) {
            return t.pr((function() {
                n.Ko(e.batchId);
            })), Dr.forEach(r, (function(e) {
                return n.No.Go(t, e);
            }));
        }));
    }, 
    /**
     * Clears the cached keys for a mutation batch. This method should be
     * called by secondary clients after they process mutation updates.
     *
     * Note that this method does not have to be called from primary clients as
     * the corresponding cache entries are cleared when an acknowledged or
     * rejected batch is removed from the mutation queue.
     */
    // PORTING NOTE: Multi-tab only
    t.prototype.Ko = function(t) {
        delete this.Fo[t];
    }, t.prototype.zo = function(t) {
        var e = this;
        return this.$o(t).next((function(n) {
            if (!n) return Dr.resolve();
            // Verify that there are no entries in the documentMutations index if
            // the queue is empty.
                        var r = IDBKeyRange.lowerBound(eo.prefixForUser(e.userId)), i = [];
            return qi(t).rs({
                range: r
            }, (function(t, n, r) {
                if (t[0] === e.userId) {
                    var o = Ni(t[1]);
                    i.push(o);
                } else r.done();
            })).next((function() {
                k(0 === i.length);
            }));
        }));
    }, t.prototype.Ho = function(t, e) {
        return Ci(t, this.userId, e);
    }, 
    // PORTING NOTE: Multi-tab only (state is held in memory in other clients).
    /** Returns the mutation queue's metadata from IndexedDb. */
    t.prototype.Yo = function(t) {
        var e = this;
        return ji(t).get(this.userId).next((function(t) {
            return t || new Zi(e.userId, -1, 
            /*lastStreamToken=*/ "");
        }));
    }, t;
}();

/**
 * @return true if the mutation queue for the given user contains a pending
 *         mutation for the given key.
 */ function Ci(t, e, n) {
    var r = eo.prefixForPath(e, n.path), i = r[1], o = IDBKeyRange.lowerBound(r), s = !1;
    return qi(t).rs({
        range: o,
        ss: !0
    }, (function(t, n, r) {
        var o = t[0], u = t[1];
        t[2];
        o === e && u === i && (s = !0), r.done();
    })).next((function() {
        return s;
    }));
}

/** Returns true if any mutation queue contains the given document. */
/**
 * Delete a mutation batch and the associated document mutations.
 * @return A PersistencePromise of the document mutations that were removed.
 */ function Fi(t, e, n) {
    var r = t.store(to.store), i = t.store(eo.store), o = [], s = IDBKeyRange.only(n.batchId), u = 0, a = r.rs({
        range: s
    }, (function(t, e, n) {
        return u++, n.delete();
    }));
    o.push(a.next((function() {
        k(1 === u);
    })));
    for (var c = [], h = 0, f = n.mutations; h < f.length; h++) {
        var l = f[h], p = eo.key(e, l.key.path, n.batchId);
        o.push(i.delete(p)), c.push(l.key);
    }
    return Dr.$n(o).next((function() {
        return c;
    }));
}

/**
 * Helper to get a typed SimpleDbStore for the mutations object store.
 */ function Mi(t) {
    return _o.Qn(t, to.store);
}

/**
 * Helper to get a typed SimpleDbStore for the mutationQueues object store.
 */ function qi(t) {
    return _o.Qn(t, eo.store);
}

/**
 * Helper to get a typed SimpleDbStore for the mutationQueues object store.
 */ function ji(t) {
    return _o.Qn(t, Zi.store);
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * The RemoteDocumentCache for IndexedDb. To construct, invoke
 * `newIndexedDbRemoteDocumentCache()`.
 */ var Gi = /** @class */ function() {
    /**
     * @param serializer The document serializer.
     * @param indexManager The query indexes that need to be maintained.
     */
    function t(t, e) {
        this.serializer = t, this.Dr = e
        /**
     * Adds the supplied entries to the cache.
     *
     * All calls of `addEntry` are required to go through the RemoteDocumentChangeBuffer
     * returned by `newChangeBuffer()` to ensure proper accounting of metadata.
     */;
    }
    return t.prototype.Er = function(t, e, n) {
        return Ki(t).put(Wi(e), n);
    }, 
    /**
     * Removes a document from the cache.
     *
     * All calls of `removeEntry`  are required to go through the RemoteDocumentChangeBuffer
     * returned by `newChangeBuffer()` to ensure proper accounting of metadata.
     */
    t.prototype.Ar = function(t, e) {
        var n = Ki(t), r = Wi(e);
        return n.delete(r);
    }, 
    /**
     * Updates the current cache size.
     *
     * Callers to `addEntry()` and `removeEntry()` *must* call this afterwards to update the
     * cache's metadata.
     */
    t.prototype.updateMetadata = function(t, e) {
        var n = this;
        return this.getMetadata(t).next((function(r) {
            return r.byteSize += e, n.Jo(t, r);
        }));
    }, t.prototype.Rr = function(t, e) {
        var n = this;
        return Ki(t).get(Wi(e)).next((function(t) {
            return n.Xo(t);
        }));
    }, 
    /**
     * Looks up an entry in the cache.
     *
     * @param documentKey The key of the entry to look up.
     * @return The cached MaybeDocument entry and its size, or null if we have nothing cached.
     */
    t.prototype.Zo = function(t, e) {
        var n = this;
        return Ki(t).get(Wi(e)).next((function(t) {
            var e = n.Xo(t);
            return e ? {
                ta: e,
                size: Qi(t)
            } : null;
        }));
    }, t.prototype.getEntries = function(t, e) {
        var n = this, r = qt();
        return this.ea(t, e, (function(t, e) {
            var i = n.Xo(e);
            r = r.ot(t, i);
        })).next((function() {
            return r;
        }));
    }, 
    /**
     * Looks up several entries in the cache.
     *
     * @param documentKeys The set of keys entries to look up.
     * @return A map of MaybeDocuments indexed by key (if a document cannot be
     *     found, the key will be mapped to null) and a map of sizes indexed by
     *     key (zero if the key cannot be found).
     */
    t.prototype.na = function(t, e) {
        var n = this, r = qt(), i = new Ot(F.i);
        return this.ea(t, e, (function(t, e) {
            var o = n.Xo(e);
            o ? (r = r.ot(t, o), i = i.ot(t, Qi(e))) : (r = r.ot(t, null), i = i.ot(t, 0));
        })).next((function() {
            return {
                sa: r,
                ia: i
            };
        }));
    }, t.prototype.ea = function(t, e, n) {
        if (e.m()) return Dr.resolve();
        var r = IDBKeyRange.bound(e.first().path.A(), e.last().path.A()), i = e._t(), o = i.It();
        return Ki(t).rs({
            range: r
        }, (function(t, e, r) {
            // Go through keys not found in cache.
            for (var s = F.$(t); o && F.i(o, s) < 0; ) n(o, null), o = i.It();
            o && o.isEqual(s) && (
            // Key found in cache.
            n(o, e), o = i.At() ? i.It() : null), 
            // Skip to the next key (if there is one).
            o ? r.Xn(o.path.A()) : r.done();
        })).next((function() {
            // The rest of the keys are not in the cache. One case where `iterate`
            // above won't go through them is when the cache is empty.
            for (;o; ) n(o, null), o = i.At() ? i.It() : null;
        }));
    }, t.prototype.Lr = function(t, e, n) {
        var r = this, i = Gt(), o = e.path.length + 1, s = {};
        if (n.isEqual(gt.min())) {
            // Documents are ordered by key, so we can use a prefix scan to narrow
            // down the documents we need to match the query against.
            var u = e.path.A();
            s.range = IDBKeyRange.lowerBound(u);
        } else {
            // Execute an index-free query and filter by read time. This is safe
            // since all document changes to queries that have a
            // lastLimboFreeSnapshotVersion (`sinceReadTime`) have a read time set.
            var a = e.path.A(), c = ki(n);
            s.range = IDBKeyRange.lowerBound([ a, c ], 
            /* open= */ !0), s.index = io.collectionReadTimeIndex;
        }
        return Ki(t).rs(s, (function(t, n, s) {
            // The query is actually returning any path that starts with the query
            // path prefix which may include documents in subcollections. For
            // example, a query on 'rooms' will return rooms/abc/messages/xyx but we
            // shouldn't match it. Fix this by discarding rows with document keys
            // more than one segment longer than the query path.
            if (t.length === o) {
                var u = Si(r.serializer, n);
                e.path.T(u.key.path) ? u instanceof zn && ar(e, u) && (i = i.ot(u.key, u)) : s.done();
            }
        })).next((function() {
            return i;
        }));
    }, t.prototype.ra = function(t) {
        return new zi(this, !!t && t.oa);
    }, t.prototype.aa = function(t) {
        return this.getMetadata(t).next((function(t) {
            return t.byteSize;
        }));
    }, t.prototype.getMetadata = function(t) {
        return Bi(t).get(oo.key).next((function(t) {
            return k(!!t), t;
        }));
    }, t.prototype.Jo = function(t, e) {
        return Bi(t).put(oo.key, e);
    }, 
    /**
     * Decodes `remoteDoc` and returns the document (or null, if the document
     * corresponds to the format used for sentinel deletes).
     */
    t.prototype.Xo = function(t) {
        if (t) {
            var e = Si(this.serializer, t);
            return e instanceof Bn && e.version.isEqual(gt.min()) ? null : e;
        }
        return null;
    }, t;
}(), zi = /** @class */ function(e) {
    /**
     * @param documentCache The IndexedDbRemoteDocumentCache to apply the changes to.
     * @param trackRemovals Whether to create sentinel deletes that can be tracked by
     * `getNewDocumentChanges()`.
     */
    function n(t, n) {
        var r = this;
        return (r = e.call(this) || this).ca = t, r.oa = n, 
        // A map of document sizes prior to applying the changes in this buffer.
        r.ua = new yt((function(t) {
            return t.toString();
        }), (function(t, e) {
            return t.isEqual(e);
        })), r;
    }
    return t(n, e), n.prototype.yr = function(t) {
        var e = this, n = [], r = 0, i = new Ut((function(t, e) {
            return st(t.R(), e.R());
        }));
        return this.wr.forEach((function(o, s) {
            var u = e.ua.get(o);
            if (s) {
                var a = Di(e.ca.serializer, s, e.readTime);
                i = i.add(o.path.h());
                var c = Qi(a);
                r += c - u, n.push(e.ca.Er(t, o, a));
            } else if (r -= u, e.oa) {
                // In order to track removals, we store a "sentinel delete" in the
                // RemoteDocumentCache. This entry is represented by a NoDocument
                // with a version of 0 and ignored by `maybeDecodeDocument()` but
                // preserved in `getNewDocumentChanges()`.
                var h = Di(e.ca.serializer, new Bn(o, gt.min()), e.readTime);
                n.push(e.ca.Er(t, o, h));
            } else n.push(e.ca.Ar(t, o));
        })), i.forEach((function(r) {
            n.push(e.ca.Dr.Mo(t, r));
        })), n.push(this.ca.updateMetadata(t, r)), Dr.$n(n);
    }, n.prototype.gr = function(t, e) {
        var n = this;
        // Record the size of everything we load from the cache so we can compute a delta later.
                return this.ca.Zo(t, e).next((function(t) {
            return null === t ? (n.ua.set(e, 0), null) : (n.ua.set(e, t.size), t.ta);
        }));
    }, n.prototype.Pr = function(t, e) {
        var n = this;
        // Record the size of everything we load from the cache so we can compute
        // a delta later.
                return this.ca.na(t, e).next((function(t) {
            var e = t.sa;
            // Note: `getAllFromCache` returns two maps instead of a single map from
            // keys to `DocumentSizeEntry`s. This is to allow returning the
            // `NullableMaybeDocumentMap` directly, without a conversion.
            return t.ia.forEach((function(t, e) {
                n.ua.set(t, e);
            })), e;
        }));
    }, n;
}(fi);

/**
 * Creates a new IndexedDbRemoteDocumentCache.
 *
 * @param serializer The document serializer.
 * @param indexManager The query indexes that need to be maintained.
 */
/**
 * Handles the details of adding and updating documents in the IndexedDbRemoteDocumentCache.
 *
 * Unlike the MemoryRemoteDocumentChangeBuffer, the IndexedDb implementation computes the size
 * delta for all submitted changes. This avoids having to re-read all documents from IndexedDb
 * when we apply the changes.
 */ function Bi(t) {
    return _o.Qn(t, oo.store);
}

/**
 * Helper to get a typed SimpleDbStore for the remoteDocuments object store.
 */ function Ki(t) {
    return _o.Qn(t, io.store);
}

function Wi(t) {
    return t.path.A();
}

/**
 * Retrusn an approximate size for the given document.
 */ function Qi(t) {
    var e;
    if (t.document) e = t.document; else if (t.unknownDocument) e = t.unknownDocument; else {
        if (!t.noDocument) throw D();
        e = t.noDocument;
    }
    return JSON.stringify(e).length;
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * An in-memory implementation of IndexManager.
 */ var Hi = /** @class */ function() {
    function t() {
        this.ha = new Yi;
    }
    return t.prototype.Mo = function(t, e) {
        return this.ha.add(e), Dr.resolve();
    }, t.prototype.Qr = function(t, e) {
        return Dr.resolve(this.ha.getEntries(e));
    }, t;
}(), Yi = /** @class */ function() {
    function t() {
        this.index = {};
    }
    // Returns false if the entry already existed.
        return t.prototype.add = function(t) {
        var e = t._(), n = t.h(), r = this.index[e] || new Ut(V.i), i = !r.has(n);
        return this.index[e] = r.add(n), i;
    }, t.prototype.has = function(t) {
        var e = t._(), n = t.h(), r = this.index[e];
        return r && r.has(n);
    }, t.prototype.getEntries = function(t) {
        return (this.index[t] || new Ut(V.i)).A();
    }, t;
}(), $i = /** @class */ function() {
    function t(t) {
        this.serializer = t;
    }
    /**
     * Performs database creation and schema upgrades.
     *
     * Note that in production, this method is only ever used to upgrade the schema
     * to SCHEMA_VERSION. Different values of toVersion are only used for testing
     * and local feature development.
     */    return t.prototype.createOrUpgrade = function(t, e, n, r) {
        var i = this;
        k(n < r && n >= 0 && r <= 10);
        var o = new Or("createOrUpgrade", e);
        n < 1 && r >= 1 && (function(t) {
            t.createObjectStore(Ji.store);
        }(t), function(t) {
            t.createObjectStore(Zi.store, {
                keyPath: Zi.keyPath
            }), t.createObjectStore(to.store, {
                keyPath: to.keyPath,
                autoIncrement: !0
            }).createIndex(to.userMutationsIndex, to.userMutationsKeyPath, {
                unique: !0
            }), t.createObjectStore(eo.store);
        }(t), ho(t), function(t) {
            t.createObjectStore(io.store);
        }(t));
        // Migration 2 to populate the targetGlobal object no longer needed since
        // migration 3 unconditionally clears it.
        var s = Dr.resolve();
        return n < 3 && r >= 3 && (
        // Brand new clients don't need to drop and recreate--only clients that
        // potentially have corrupt data.
        0 !== n && (function(t) {
            t.deleteObjectStore(uo.store), t.deleteObjectStore(so.store), t.deleteObjectStore(ao.store);
        }(t), ho(t)), s = s.next((function() {
            /**
     * Creates the target global singleton row.
     *
     * @param {IDBTransaction} txn The version upgrade transaction for indexeddb
     */
            return function(t) {
                var e = t.store(ao.store), n = new ao(
                /*highestTargetId=*/ 0, 
                /*lastListenSequenceNumber=*/ 0, gt.min().Z(), 
                /*targetCount=*/ 0);
                return e.put(ao.key, n);
            }(o);
        }))), n < 4 && r >= 4 && (0 !== n && (
        // Schema version 3 uses auto-generated keys to generate globally unique
        // mutation batch IDs (this was previously ensured internally by the
        // client). To migrate to the new schema, we have to read all mutations
        // and write them back out. We preserve the existing batch IDs to guarantee
        // consistency with other object stores. Any further mutation batch IDs will
        // be auto-generated.
        s = s.next((function() {
            return function(t, e) {
                return e.store(to.store).ts().next((function(n) {
                    t.deleteObjectStore(to.store), t.createObjectStore(to.store, {
                        keyPath: to.keyPath,
                        autoIncrement: !0
                    }).createIndex(to.userMutationsIndex, to.userMutationsKeyPath, {
                        unique: !0
                    });
                    var r = e.store(to.store), i = n.map((function(t) {
                        return r.put(t);
                    }));
                    return Dr.$n(i);
                }));
            }(t, o);
        }))), s = s.next((function() {
            !function(t) {
                t.createObjectStore(fo.store, {
                    keyPath: fo.keyPath
                });
            }(t);
        }))), n < 5 && r >= 5 && (s = s.next((function() {
            return i.removeAcknowledgedMutations(o);
        }))), n < 6 && r >= 6 && (s = s.next((function() {
            return function(t) {
                t.createObjectStore(oo.store);
            }(t), i.addDocumentGlobal(o);
        }))), n < 7 && r >= 7 && (s = s.next((function() {
            return i.ensureSequenceNumbers(o);
        }))), n < 8 && r >= 8 && (s = s.next((function() {
            return i.createCollectionParentIndex(t, o);
        }))), n < 9 && r >= 9 && (s = s.next((function() {
            // Multi-Tab used to manage its own changelog, but this has been moved
            // to the DbRemoteDocument object store itself. Since the previous change
            // log only contained transient data, we can drop its object store.
            !function(t) {
                t.objectStoreNames.contains("remoteDocumentChanges") && t.deleteObjectStore("remoteDocumentChanges");
            }(t), function(t) {
                var e = t.objectStore(io.store);
                e.createIndex(io.readTimeIndex, io.readTimeIndexPath, {
                    unique: !1
                }), e.createIndex(io.collectionReadTimeIndex, io.collectionReadTimeIndexPath, {
                    unique: !1
                });
            }(e);
        }))), n < 10 && r >= 10 && (s = s.next((function() {
            return i.rewriteCanonicalIds(o);
        }))), s;
    }, t.prototype.addDocumentGlobal = function(t) {
        var e = 0;
        return t.store(io.store).rs((function(t, n) {
            e += Qi(n);
        })).next((function() {
            var n = new oo(e);
            return t.store(oo.store).put(oo.key, n);
        }));
    }, t.prototype.removeAcknowledgedMutations = function(t) {
        var e = this, n = t.store(Zi.store), r = t.store(to.store);
        return n.ts().next((function(n) {
            return Dr.forEach(n, (function(n) {
                var i = IDBKeyRange.bound([ n.userId, -1 ], [ n.userId, n.lastAcknowledgedBatchId ]);
                return r.ts(to.userMutationsIndex, i).next((function(r) {
                    return Dr.forEach(r, (function(r) {
                        k(r.userId === n.userId);
                        var i = Oi(e.serializer, r);
                        return Fi(t, n.userId, i).next((function() {}));
                    }));
                }));
            }));
        }));
    }, 
    /**
     * Ensures that every document in the remote document cache has a corresponding sentinel row
     * with a sequence number. Missing rows are given the most recently used sequence number.
     */
    t.prototype.ensureSequenceNumbers = function(t) {
        var e = t.store(uo.store), n = t.store(io.store);
        return t.store(ao.store).get(ao.key).next((function(t) {
            var r = [];
            return n.rs((function(n, i) {
                var o = new V(n), s = function(t) {
                    return [ 0, Ei(t) ];
                }(o);
                r.push(e.get(s).next((function(n) {
                    return n ? Dr.resolve() : function(n) {
                        return e.put(new uo(0, Ei(n), t.highestListenSequenceNumber));
                    }(o);
                })));
            })).next((function() {
                return Dr.$n(r);
            }));
        }));
    }, t.prototype.createCollectionParentIndex = function(t, e) {
        // Create the index.
        t.createObjectStore(co.store, {
            keyPath: co.keyPath
        });
        var n = e.store(co.store), r = new Yi, i = function(t) {
            if (r.add(t)) {
                var e = t._(), i = t.h();
                return n.put({
                    collectionId: e,
                    parent: Ei(i)
                });
            }
        };
        // Helper to add an index entry iff we haven't already written it.
        // Index existing remote documents.
                return e.store(io.store).rs({
            ss: !0
        }, (function(t, e) {
            var n = new V(t);
            return i(n.h());
        })).next((function() {
            return e.store(eo.store).rs({
                ss: !0
            }, (function(t, e) {
                t[0];
                var n = t[1], r = (t[2], Ni(n));
                return i(r.h());
            }));
        }));
    }, t.prototype.rewriteCanonicalIds = function(t) {
        var e = this, n = t.store(so.store);
        return n.rs((function(t, r) {
            var i = Pi(r), o = Vi(e.serializer, i);
            return n.put(o);
        }));
    }, t;
}(), Xi = function(t, e) {
    this.seconds = t, this.nanoseconds = e;
}, Ji = function(t, 
/** Whether to allow shared access from multiple tabs. */
e, n) {
    this.ownerId = t, this.allowTabSynchronization = e, this.leaseTimestampMs = n;
};

/**
 * Internal implementation of the collection-parent index exposed by MemoryIndexManager.
 * Also used for in-memory caching by IndexedDbIndexManager and initial index population
 * in indexeddb_schema.ts
 */
/**
 * Name of the IndexedDb object store.
 *
 * Note that the name 'owner' is chosen to ensure backwards compatibility with
 * older clients that only supported single locked access to the persistence
 * layer.
 */
Ji.store = "owner", 
/**
     * The key string used for the single object that exists in the
     * DbPrimaryClient store.
     */
Ji.key = "owner";

var Zi = function(
/**
     * The normalized user ID to which this queue belongs.
     */
t, 
/**
     * An identifier for the highest numbered batch that has been acknowledged
     * by the server. All MutationBatches in this queue with batchIds less
     * than or equal to this value are considered to have been acknowledged by
     * the server.
     *
     * NOTE: this is deprecated and no longer used by the code.
     */
e, 
/**
     * A stream token that was previously sent by the server.
     *
     * See StreamingWriteRequest in datastore.proto for more details about
     * usage.
     *
     * After sending this token, earlier tokens may not be used anymore so
     * only a single stream token is retained.
     *
     * NOTE: this is deprecated and no longer used by the code.
     */
n) {
    this.userId = t, this.lastAcknowledgedBatchId = e, this.lastStreamToken = n;
};

/** Name of the IndexedDb object store.  */ Zi.store = "mutationQueues", 
/** Keys are automatically assigned via the userId property. */
Zi.keyPath = "userId";

/**
 * An object to be stored in the 'mutations' store in IndexedDb.
 *
 * Represents a batch of user-level mutations intended to be sent to the server
 * in a single write. Each user-level batch gets a separate DbMutationBatch
 * with a new batchId.
 */
var to = function(
/**
     * The normalized user ID to which this batch belongs.
     */
t, 
/**
     * An identifier for this batch, allocated using an auto-generated key.
     */
e, 
/**
     * The local write time of the batch, stored as milliseconds since the
     * epoch.
     */
n, 
/**
     * A list of "mutations" that represent a partial base state from when this
     * write batch was initially created. During local application of the write
     * batch, these baseMutations are applied prior to the real writes in order
     * to override certain document fields from the remote document cache. This
     * is necessary in the case of non-idempotent writes (e.g. `increment()`
     * transforms) to make sure that the local view of the modified documents
     * doesn't flicker if the remote document cache receives the result of the
     * non-idempotent write before the write is removed from the queue.
     *
     * These mutations are never sent to the backend.
     */
r, 
/**
     * A list of mutations to apply. All mutations will be applied atomically.
     *
     * Mutations are serialized via toMutation().
     */
i) {
    this.userId = t, this.batchId = e, this.localWriteTimeMs = n, this.baseMutations = r, 
    this.mutations = i;
};

/** Name of the IndexedDb object store.  */ to.store = "mutations", 
/** Keys are automatically assigned via the userId, batchId properties. */
to.keyPath = "batchId", 
/** The index name for lookup of mutations by user. */
to.userMutationsIndex = "userMutationsIndex", 
/** The user mutations index is keyed by [userId, batchId] pairs. */
to.userMutationsKeyPath = [ "userId", "batchId" ];

var eo = /** @class */ function() {
    function t() {}
    /**
     * Creates a [userId] key for use in the DbDocumentMutations index to iterate
     * over all of a user's document mutations.
     */    return t.prefixForUser = function(t) {
        return [ t ];
    }, 
    /**
     * Creates a [userId, encodedPath] key for use in the DbDocumentMutations
     * index to iterate over all at document mutations for a given path or lower.
     */
    t.prefixForPath = function(t, e) {
        return [ t, Ei(e) ];
    }, 
    /**
     * Creates a full index key of [userId, encodedPath, batchId] for inserting
     * and deleting into the DbDocumentMutations index.
     */
    t.key = function(t, e, n) {
        return [ t, Ei(e), n ];
    }, t;
}();

eo.store = "documentMutations", 
/**
     * Because we store all the useful information for this store in the key,
     * there is no useful information to store as the value. The raw (unencoded)
     * path cannot be stored because IndexedDb doesn't store prototype
     * information.
     */
eo.PLACEHOLDER = new eo;

var no = function(t, e) {
    this.path = t, this.readTime = e;
}, ro = function(t, e) {
    this.path = t, this.version = e;
}, io = 
// TODO: We are currently storing full document keys almost three times
// (once as part of the primary key, once - partly - as `parentPath` and once
// inside the encoded documents). During our next migration, we should
// rewrite the primary key as parentPath + document ID which would allow us
// to drop one value.
function(
/**
     * Set to an instance of DbUnknownDocument if the data for a document is
     * not known, but it is known that a document exists at the specified
     * version (e.g. it had a successful update applied to it)
     */
t, 
/**
     * Set to an instance of a DbNoDocument if it is known that no document
     * exists.
     */
e, 
/**
     * Set to an instance of a Document if there's a cached version of the
     * document.
     */
n, 
/**
     * Documents that were written to the remote document store based on
     * a write acknowledgment are marked with `hasCommittedMutations`. These
     * documents are potentially inconsistent with the backend's copy and use
     * the write's commit version as their document version.
     */
r, 
/**
     * When the document was read from the backend. Undefined for data written
     * prior to schema version 9.
     */
i, 
/**
     * The path of the collection this document is part of. Undefined for data
     * written prior to schema version 9.
     */
o) {
    this.unknownDocument = t, this.noDocument = e, this.document = n, this.hasCommittedMutations = r, 
    this.readTime = i, this.parentPath = o;
};

/**
 * Represents a document that is known to exist but whose data is unknown.
 * Stored in IndexedDb as part of a DbRemoteDocument object.
 */ io.store = "remoteDocuments", 
/**
     * An index that provides access to all entries sorted by read time (which
     * corresponds to the last modification time of each row).
     *
     * This index is used to provide a changelog for Multi-Tab.
     */
io.readTimeIndex = "readTimeIndex", io.readTimeIndexPath = "readTime", 
/**
     * An index that provides access to documents in a collection sorted by read
     * time.
     *
     * This index is used to allow the RemoteDocumentCache to fetch newly changed
     * documents in a collection.
     */
io.collectionReadTimeIndex = "collectionReadTimeIndex", io.collectionReadTimeIndexPath = [ "parentPath", "readTime" ];

/**
 * Contains a single entry that has metadata about the remote document cache.
 */
var oo = 
/**
     * @param byteSize Approximately the total size in bytes of all the documents in the document
     * cache.
     */
function(t) {
    this.byteSize = t;
};

oo.store = "remoteDocumentGlobal", oo.key = "remoteDocumentGlobalKey";

var so = function(
/**
     * An auto-generated sequential numeric identifier for the query.
     *
     * Queries are stored using their canonicalId as the key, but these
     * canonicalIds can be quite long so we additionally assign a unique
     * queryId which can be used by referenced data structures (e.g.
     * indexes) to minimize the on-disk cost.
     */
t, 
/**
     * The canonical string representing this query. This is not unique.
     */
e, 
/**
     * The last readTime received from the Watch Service for this query.
     *
     * This is the same value as TargetChange.read_time in the protos.
     */
n, 
/**
     * An opaque, server-assigned token that allows watching a query to be
     * resumed after disconnecting without retransmitting all the data
     * that matches the query. The resume token essentially identifies a
     * point in time from which the server should resume sending results.
     *
     * This is related to the snapshotVersion in that the resumeToken
     * effectively also encodes that value, but the resumeToken is opaque
     * and sometimes encodes additional information.
     *
     * A consequence of this is that the resumeToken should be used when
     * asking the server to reason about where this client is in the watch
     * stream, but the client should use the snapshotVersion for its own
     * purposes.
     *
     * This is the same value as TargetChange.resume_token in the protos.
     */
r, 
/**
     * A sequence number representing the last time this query was
     * listened to, used for garbage collection purposes.
     *
     * Conventionally this would be a timestamp value, but device-local
     * clocks are unreliable and they must be able to create new listens
     * even while disconnected. Instead this should be a monotonically
     * increasing number that's incremented on each listen call.
     *
     * This is different from the queryId since the queryId is an
     * immutable identifier assigned to the Query on first use while
     * lastListenSequenceNumber is updated every time the query is
     * listened to.
     */
i, 
/**
     * Denotes the maximum snapshot version at which the associated query view
     * contained no limbo documents.  Undefined for data written prior to
     * schema version 9.
     */
o, 
/**
     * The query for this target.
     *
     * Because canonical ids are not unique we must store the actual query. We
     * use the proto to have an object we can persist without having to
     * duplicate translation logic to and from a `Query` object.
     */
s) {
    this.targetId = t, this.canonicalId = e, this.readTime = n, this.resumeToken = r, 
    this.lastListenSequenceNumber = i, this.lastLimboFreeSnapshotVersion = o, this.query = s;
};

so.store = "targets", 
/** Keys are automatically assigned via the targetId property. */
so.keyPath = "targetId", 
/** The name of the queryTargets index. */
so.queryTargetsIndexName = "queryTargetsIndex", 
/**
     * The index of all canonicalIds to the targets that they match. This is not
     * a unique mapping because canonicalId does not promise a unique name for all
     * possible queries, so we append the targetId to make the mapping unique.
     */
so.queryTargetsKeyPath = [ "canonicalId", "targetId" ];

/**
 * An object representing an association between a target and a document, or a
 * sentinel row marking the last sequence number at which a document was used.
 * Each document cached must have a corresponding sentinel row before lru
 * garbage collection is enabled.
 *
 * The target associations and sentinel rows are co-located so that orphaned
 * documents and their sequence numbers can be identified efficiently via a scan
 * of this store.
 */
var uo = function(
/**
     * The targetId identifying a target or 0 for a sentinel row.
     */
t, 
/**
     * The path to the document, as encoded in the key.
     */
e, 
/**
     * If this is a sentinel row, this should be the sequence number of the last
     * time the document specified by `path` was used. Otherwise, it should be
     * `undefined`.
     */
n) {
    this.targetId = t, this.path = e, this.sequenceNumber = n;
};

/** Name of the IndexedDb object store.  */ uo.store = "targetDocuments", 
/** Keys are automatically assigned via the targetId, path properties. */
uo.keyPath = [ "targetId", "path" ], 
/** The index name for the reverse index. */
uo.documentTargetsIndex = "documentTargetsIndex", 
/** We also need to create the reverse index for these properties. */
uo.documentTargetsKeyPath = [ "path", "targetId" ];

/**
 * A record of global state tracked across all Targets, tracked separately
 * to avoid the need for extra indexes.
 *
 * This should be kept in-sync with the proto used in the iOS client.
 */
var ao = function(
/**
     * The highest numbered target id across all targets.
     *
     * See DbTarget.targetId.
     */
t, 
/**
     * The highest numbered lastListenSequenceNumber across all targets.
     *
     * See DbTarget.lastListenSequenceNumber.
     */
e, 
/**
     * A global snapshot version representing the last consistent snapshot we
     * received from the backend. This is monotonically increasing and any
     * snapshots received from the backend prior to this version (e.g. for
     * targets resumed with a resumeToken) should be suppressed (buffered)
     * until the backend has caught up to this snapshot version again. This
     * prevents our cache from ever going backwards in time.
     */
n, 
/**
     * The number of targets persisted.
     */
r) {
    this.highestTargetId = t, this.highestListenSequenceNumber = e, this.lastRemoteSnapshotVersion = n, 
    this.targetCount = r;
};

/**
 * The key string used for the single object that exists in the
 * DbTargetGlobal store.
 */ ao.key = "targetGlobalKey", ao.store = "targetGlobal";

/**
 * An object representing an association between a Collection id (e.g. 'messages')
 * to a parent path (e.g. '/chats/123') that contains it as a (sub)collection.
 * This is used to efficiently find all collections to query when performing
 * a Collection Group query.
 */
var co = function(
/**
     * The collectionId (e.g. 'messages')
     */
t, 
/**
     * The path to the parent (either a document location or an empty path for
     * a root-level collection).
     */
e) {
    this.collectionId = t, this.parent = e;
};

/** Name of the IndexedDb object store. */ function ho(t) {
    t.createObjectStore(uo.store, {
        keyPath: uo.keyPath
    }).createIndex(uo.documentTargetsIndex, uo.documentTargetsKeyPath, {
        unique: !0
    }), 
    // NOTE: This is unique only because the TargetId is the suffix.
    t.createObjectStore(so.store, {
        keyPath: so.keyPath
    }).createIndex(so.queryTargetsIndexName, so.queryTargetsKeyPath, {
        unique: !0
    }), t.createObjectStore(ao.store);
}

co.store = "collectionParents", 
/** Keys are automatically assigned via the collectionId, parent properties. */
co.keyPath = [ "collectionId", "parent" ];

var fo = function(
// Note: Previous schema versions included a field
// "lastProcessedDocumentChangeId". Don't use anymore.
/** The auto-generated client id assigned at client startup. */
t, 
/** The last time this state was updated. */
e, 
/** Whether the client's network connection is enabled. */
n, 
/** Whether this client is running in a foreground tab. */
r) {
    this.clientId = t, this.updateTimeMs = e, this.networkEnabled = n, this.inForeground = r;
};

/** Name of the IndexedDb object store. */ fo.store = "clientMetadata", 
/** Keys are automatically assigned via the clientId properties. */
fo.keyPath = "clientId";

var lo = r(r(r([ Zi.store, to.store, eo.store, io.store, so.store, Ji.store, ao.store, uo.store ], [ fo.store ]), [ oo.store ]), [ co.store ]), po = /** @class */ function() {
    function t() {
        /**
         * An in-memory copy of the index entries we've already written since the SDK
         * launched. Used to avoid re-writing the same entry repeatedly.
         *
         * This is *NOT* a complete cache of what's in persistence and so can never be used to
         * satisfy reads.
         */
        this.la = new Yi;
    }
    /**
     * Adds a new entry to the collection parent index.
     *
     * Repeated calls for the same collectionPath should be avoided within a
     * transaction as IndexedDbIndexManager only caches writes once a transaction
     * has been committed.
     */    return t.prototype.Mo = function(t, e) {
        var n = this;
        if (!this.la.has(e)) {
            var r = e._(), i = e.h();
            t.pr((function() {
                // Add the collection to the in memory cache only if the transaction was
                // successfully committed.
                n.la.add(e);
            }));
            var o = {
                collectionId: r,
                parent: Ei(i)
            };
            return vo(t).put(o);
        }
        return Dr.resolve();
    }, t.prototype.Qr = function(t, e) {
        var n = [], r = IDBKeyRange.bound([ e, "" ], [ at(e), "" ], 
        /*lowerOpen=*/ !1, 
        /*upperOpen=*/ !0);
        return vo(t).ts(r).next((function(t) {
            for (var r = 0, i = t; r < i.length; r++) {
                var o = i[r];
                // This collectionId guard shouldn't be necessary (and isn't as long
                // as we're running in a real browser), but there's a bug in
                // indexeddbshim that breaks our range in our tests running in node:
                // https://github.com/axemclion/IndexedDBShim/issues/334
                                if (o.collectionId !== e) break;
                n.push(Ni(o.parent));
            }
            return n;
        }));
    }, t;
}();

// V2 is no longer usable (see comment at top of file)
// Visible for testing
/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A persisted implementation of IndexManager.
 */
/**
 * Helper to get a typed SimpleDbStore for the collectionParents
 * document store.
 */
function vo(t) {
    return _o.Qn(t, co.store);
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** Offset to ensure non-overlapping target ids. */
/**
 * Generates monotonically increasing target IDs for sending targets to the
 * watch stream.
 *
 * The client constructs two generators, one for the target cache, and one for
 * for the sync engine (to generate limbo documents targets). These
 * generators produce non-overlapping IDs (by using even and odd IDs
 * respectively).
 *
 * By separating the target ID space, the query cache can generate target IDs
 * that persist across client restarts, while sync engine can independently
 * generate in-memory target IDs that are transient and can be reused after a
 * restart.
 */ var yo = /** @class */ function() {
    function t(t) {
        this._a = t;
    }
    return t.prototype.next = function() {
        return this._a += 2, this._a;
    }, t.fa = function() {
        // The target cache generator must return '2' in its first call to `next()`
        // as there is no differentiation in the protocol layer between an unset
        // number and the number '0'. If we were to sent a target with target ID
        // '0', the backend would consider it unset and replace it with its own ID.
        return new t(0);
    }, t.da = function() {
        // Sync engine assigns target IDs for limbo document detection.
        return new t(-1);
    }, t;
}(), mo = /** @class */ function() {
    function t(t, e) {
        this.No = t, this.serializer = e;
    }
    // PORTING NOTE: We don't cache global metadata for the target cache, since
    // some of it (in particular `highestTargetId`) can be modified by secondary
    // tabs. We could perhaps be more granular (and e.g. still cache
    // `lastRemoteSnapshotVersion` in memory) but for simplicity we currently go
    // to IndexedDb whenever we need to read metadata. We can revisit if it turns
    // out to have a meaningful performance impact.
        return t.prototype.wa = function(t) {
        var e = this;
        return this.ma(t).next((function(n) {
            var r = new yo(n.highestTargetId);
            return n.highestTargetId = r.next(), e.Ta(t, n).next((function() {
                return n.highestTargetId;
            }));
        }));
    }, t.prototype.Ea = function(t) {
        return this.ma(t).next((function(t) {
            return gt.J(new mt(t.lastRemoteSnapshotVersion.seconds, t.lastRemoteSnapshotVersion.nanoseconds));
        }));
    }, t.prototype.Ia = function(t) {
        return this.ma(t).next((function(t) {
            return t.highestListenSequenceNumber;
        }));
    }, t.prototype.Aa = function(t, e, n) {
        var r = this;
        return this.ma(t).next((function(i) {
            return i.highestListenSequenceNumber = e, n && (i.lastRemoteSnapshotVersion = n.Z()), 
            e > i.highestListenSequenceNumber && (i.highestListenSequenceNumber = e), r.Ta(t, i);
        }));
    }, t.prototype.Ra = function(t, e) {
        var n = this;
        return this.ga(t, e).next((function() {
            return n.ma(t).next((function(r) {
                return r.targetCount += 1, n.Pa(e, r), n.Ta(t, r);
            }));
        }));
    }, t.prototype.ya = function(t, e) {
        return this.ga(t, e);
    }, t.prototype.Va = function(t, e) {
        var n = this;
        return this.pa(t, e.targetId).next((function() {
            return go(t).delete(e.targetId);
        })).next((function() {
            return n.ma(t);
        })).next((function(e) {
            return k(e.targetCount > 0), e.targetCount -= 1, n.Ta(t, e);
        }));
    }, 
    /**
     * Drops any targets with sequence number less than or equal to the upper bound, excepting those
     * present in `activeTargetIds`. Document associations for the removed targets are also removed.
     * Returns the number of targets removed.
     */
    t.prototype.po = function(t, e, n) {
        var r = this, i = 0, o = [];
        return go(t).rs((function(s, u) {
            var a = Pi(u);
            a.sequenceNumber <= e && null === n.get(a.targetId) && (i++, o.push(r.Va(t, a)));
        })).next((function() {
            return Dr.$n(o);
        })).next((function() {
            return i;
        }));
    }, 
    /**
     * Call provided function with each `TargetData` that we have cached.
     */
    t.prototype.Ce = function(t, e) {
        return go(t).rs((function(t, n) {
            var r = Pi(n);
            e(r);
        }));
    }, t.prototype.ma = function(t) {
        return wo(t).get(ao.key).next((function(t) {
            return k(null !== t), t;
        }));
    }, t.prototype.Ta = function(t, e) {
        return wo(t).put(ao.key, e);
    }, t.prototype.ga = function(t, e) {
        return go(t).put(Vi(this.serializer, e));
    }, 
    /**
     * In-place updates the provided metadata to account for values in the given
     * TargetData. Saving is done separately. Returns true if there were any
     * changes to the metadata.
     */
    t.prototype.Pa = function(t, e) {
        var n = !1;
        return t.targetId > e.highestTargetId && (e.highestTargetId = t.targetId, n = !0), 
        t.sequenceNumber > e.highestListenSequenceNumber && (e.highestListenSequenceNumber = t.sequenceNumber, 
        n = !0), n;
    }, t.prototype.ba = function(t) {
        return this.ma(t).next((function(t) {
            return t.targetCount;
        }));
    }, t.prototype.va = function(t, e) {
        // Iterating by the canonicalId may yield more than one result because
        // canonicalId values are not required to be unique per target. This query
        // depends on the queryTargets index to be efficient.
        var n = Tt(e), r = IDBKeyRange.bound([ n, Number.NEGATIVE_INFINITY ], [ n, Number.POSITIVE_INFINITY ]), i = null;
        return go(t).rs({
            range: r,
            index: so.queryTargetsIndexName
        }, (function(t, n, r) {
            var o = Pi(n);
            // After finding a potential match, check that the target is
            // actually equal to the requested target.
                        Nt(e, o.target) && (i = o, r.done());
        })).next((function() {
            return i;
        }));
    }, t.prototype.Sa = function(t, e, n) {
        var r = this, i = [], o = bo(t);
        // PORTING NOTE: The reverse index (documentsTargets) is maintained by
        // IndexedDb.
                return e.forEach((function(e) {
            var s = Ei(e.path);
            i.push(o.put(new uo(n, s))), i.push(r.No.Da(t, n, e));
        })), Dr.$n(i);
    }, t.prototype.Ca = function(t, e, n) {
        var r = this, i = bo(t);
        // PORTING NOTE: The reverse index (documentsTargets) is maintained by
        // IndexedDb.
                return Dr.forEach(e, (function(e) {
            var o = Ei(e.path);
            return Dr.$n([ i.delete([ n, o ]), r.No.Na(t, n, e) ]);
        }));
    }, t.prototype.pa = function(t, e) {
        var n = bo(t), r = IDBKeyRange.bound([ e ], [ e + 1 ], 
        /*lowerOpen=*/ !1, 
        /*upperOpen=*/ !0);
        return n.delete(r);
    }, t.prototype.Fa = function(t, e) {
        var n = IDBKeyRange.bound([ e ], [ e + 1 ], 
        /*lowerOpen=*/ !1, 
        /*upperOpen=*/ !0), r = bo(t), i = Kt();
        return r.rs({
            range: n,
            ss: !0
        }, (function(t, e, n) {
            var r = Ni(t[1]), o = new F(r);
            i = i.add(o);
        })).next((function() {
            return i;
        }));
    }, t.prototype.Ho = function(t, e) {
        var n = Ei(e.path), r = IDBKeyRange.bound([ n ], [ at(n) ], 
        /*lowerOpen=*/ !1, 
        /*upperOpen=*/ !0), i = 0;
        return bo(t).rs({
            index: uo.documentTargetsIndex,
            ss: !0,
            range: r
        }, (function(t, e, n) {
            var r = t[0];
            // Having a sentinel row for a document does not count as containing that document;
            // For the target cache, containing the document means the document is part of some
            // target.
                        t[1];
            0 !== r && (i++, n.done());
        })).next((function() {
            return i > 0;
        }));
    }, 
    /**
     * Looks up a TargetData entry by target ID.
     *
     * @param targetId The target ID of the TargetData entry to look up.
     * @return The cached TargetData entry, or null if the cache has no entry for
     * the target.
     */
    // PORTING NOTE: Multi-tab only.
    t.prototype.Ue = function(t, e) {
        return go(t).get(e).next((function(t) {
            return t ? Pi(t) : null;
        }));
    }, t;
}();

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Helper to get a typed SimpleDbStore for the queries object store.
 */
function go(t) {
    return _o.Qn(t, so.store);
}

/**
 * Helper to get a typed SimpleDbStore for the target globals object store.
 */ function wo(t) {
    return _o.Qn(t, ao.store);
}

/**
 * Helper to get a typed SimpleDbStore for the document target object store.
 */ function bo(t) {
    return _o.Qn(t, uo.store);
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ var Io = "Failed to obtain exclusive access to the persistence layer. To allow shared access, make sure to invoke `enablePersistence()` with `synchronizeTabs:true` in all tabs. If you are using `experimentalForceOwningTab:true`, make sure that only one tab has persistence enabled at any given time.", Eo = /** @class */ function(e) {
    function n(t, n) {
        var r = this;
        return (r = e.call(this) || this).jo = t, r.xa = n, r;
    }
    return t(n, e), n;
}(pi), _o = /** @class */ function() {
    function t(
    /**
     * Whether to synchronize the in-memory state of multiple tabs and share
     * access to local persistence.
     */
    e, n, r, i, o, s, u, a, c, 
    /**
     * If set to true, forcefully obtains database access. Existing tabs will
     * no longer be able to access IndexedDB.
     */
    h) {
        if (this.allowTabSynchronization = e, this.persistenceKey = n, this.clientId = r, 
        this.fn = o, this.window = s, this.document = u, this.$a = c, this.ka = h, this.Ma = null, 
        this.Oa = !1, this.isPrimary = !1, this.networkEnabled = !0, 
        /** Our window.unload handler, if registered. */
        this.La = null, this.inForeground = !1, 
        /** Our 'visibilitychange' listener if registered. */
        this.Ba = null, 
        /** The client metadata refresh task. */
        this.qa = null, 
        /** The last time we garbage collected the client metadata object store. */
        this.Ua = Number.NEGATIVE_INFINITY, 
        /** A listener to notify on primary state changes. */
        this.Qa = function(t) {
            return Promise.resolve();
        }, !t.Ln()) throw new I(b.UNIMPLEMENTED, "This platform is either missing IndexedDB or is known to have an incomplete implementation. Offline persistence has been disabled.");
        this.No = new Ao(this, i), this.Wa = n + "main", this.serializer = new Ai(a), this.ja = new kr(this.Wa, 10, new $i(this.serializer)), 
        this.Ka = new mo(this.No, this.serializer), this.Dr = new po, this.vr = function(t, e) {
            return new Gi(t, e);
        }(this.serializer, this.Dr), this.window && this.window.localStorage ? this.Ga = this.window.localStorage : (this.Ga = null, 
        !1 === h && N("IndexedDbPersistence", "LocalStorage is unavailable. As a result, persistence may not work reliably. In particular enablePersistence() could fail immediately after refreshing the page."));
    }
    return t.Qn = function(t, e) {
        if (t instanceof Eo) return kr.Qn(t.jo, e);
        throw D();
    }, 
    /**
     * Attempt to start IndexedDb persistence.
     *
     * @return {Promise<void>} Whether persistence was enabled.
     */
    t.prototype.start = function() {
        var t = this;
        // NOTE: This is expected to fail sometimes (in the case of another tab
        // already having the persistence lock), so it's the first thing we should
        // do.
                return this.za().then((function() {
            if (!t.isPrimary && !t.allowTabSynchronization) 
            // Fail `start()` if `synchronizeTabs` is disabled and we cannot
            // obtain the primary lease.
            throw new I(b.FAILED_PRECONDITION, Io);
            return t.Ha(), t.Ya(), t.Ja(), t.runTransaction("getHighestListenSequenceNumber", "readonly", (function(e) {
                return t.Ka.Ia(e);
            }));
        })).then((function(e) {
            t.Ma = new Jr(e, t.$a);
        })).then((function() {
            t.Oa = !0;
        })).catch((function(e) {
            return t.ja && t.ja.close(), Promise.reject(e);
        }));
    }, 
    /**
     * Registers a listener that gets called when the primary state of the
     * instance changes. Upon registering, this listener is invoked immediately
     * with the current primary state.
     *
     * PORTING NOTE: This is only used for Web multi-tab.
     */
    t.prototype.Xa = function(t) {
        var r = this;
        return this.Qa = function(i) {
            return e(r, void 0, void 0, (function() {
                return n(this, (function(e) {
                    return this.Ei ? [ 2 /*return*/ , t(i) ] : [ 2 /*return*/ ];
                }));
            }));
        }, t(this.isPrimary);
    }, 
    /**
     * Registers a listener that gets called when the database receives a
     * version change event indicating that it has deleted.
     *
     * PORTING NOTE: This is only used for Web multi-tab.
     */
    t.prototype.Za = function(t) {
        var r = this;
        this.ja.Kn((function(i) {
            return e(r, void 0, void 0, (function() {
                return n(this, (function(e) {
                    switch (e.label) {
                      case 0:
                        return null === i.newVersion ? [ 4 /*yield*/ , t() ] : [ 3 /*break*/ , 2 ];

                      case 1:
                        e.sent(), e.label = 2;

                      case 2:
                        return [ 2 /*return*/ ];
                    }
                }));
            }));
        }));
    }, 
    /**
     * Adjusts the current network state in the client's metadata, potentially
     * affecting the primary lease.
     *
     * PORTING NOTE: This is only used for Web multi-tab.
     */
    t.prototype.tc = function(t) {
        var r = this;
        this.networkEnabled !== t && (this.networkEnabled = t, 
        // Schedule a primary lease refresh for immediate execution. The eventual
        // lease update will be propagated via `primaryStateListener`.
        this.fn.ws((function() {
            return e(r, void 0, void 0, (function() {
                return n(this, (function(t) {
                    switch (t.label) {
                      case 0:
                        return this.Ei ? [ 4 /*yield*/ , this.za() ] : [ 3 /*break*/ , 2 ];

                      case 1:
                        t.sent(), t.label = 2;

                      case 2:
                        return [ 2 /*return*/ ];
                    }
                }));
            }));
        })));
    }, 
    /**
     * Updates the client metadata in IndexedDb and attempts to either obtain or
     * extend the primary lease for the local client. Asynchronously notifies the
     * primary state listener if the client either newly obtained or released its
     * primary lease.
     */
    t.prototype.za = function() {
        var t = this;
        return this.runTransaction("updateClientMetadataAndTryBecomePrimary", "readwrite", (function(e) {
            return No(e).put(new fo(t.clientId, Date.now(), t.networkEnabled, t.inForeground)).next((function() {
                if (t.isPrimary) return t.ec(e).next((function(e) {
                    e || (t.isPrimary = !1, t.fn.Cs((function() {
                        return t.Qa(!1);
                    })));
                }));
            })).next((function() {
                return t.nc(e);
            })).next((function(n) {
                return t.isPrimary && !n ? t.sc(e).next((function() {
                    return !1;
                })) : !!n && t.ic(e).next((function() {
                    return !0;
                }));
            }));
        })).catch((function(e) {
            if (Rr(e)) 
            // Proceed with the existing state. Any subsequent access to
            // IndexedDB will verify the lease.
            return T("IndexedDbPersistence", "Failed to extend owner lease: ", e), t.isPrimary;
            if (!t.allowTabSynchronization) throw e;
            return T("IndexedDbPersistence", "Releasing owner lease after error during lease refresh", e), 
            /* isPrimary= */ !1;
        })).then((function(e) {
            t.isPrimary !== e && t.fn.Cs((function() {
                return t.Qa(e);
            })), t.isPrimary = e;
        }));
    }, t.prototype.ec = function(t) {
        var e = this;
        return To(t).get(Ji.key).next((function(t) {
            return Dr.resolve(e.rc(t));
        }));
    }, t.prototype.oc = function(t) {
        return No(t).delete(this.clientId);
    }, 
    /**
     * If the garbage collection threshold has passed, prunes the
     * RemoteDocumentChanges and the ClientMetadata store based on the last update
     * time of all clients.
     */
    t.prototype.ac = function() {
        return e(this, void 0, void 0, (function() {
            var e, r, i, o, s = this;
            return n(this, (function(n) {
                switch (n.label) {
                  case 0:
                    return !this.isPrimary || this.cc(this.Ua, 18e5) ? [ 3 /*break*/ , 2 ] : (this.Ua = Date.now(), 
                    [ 4 /*yield*/ , this.runTransaction("maybeGarbageCollectMultiClientState", "readwrite-primary", (function(e) {
                        var n = t.Qn(e, fo.store);
                        return n.ts().next((function(t) {
                            var e = s.uc(t, 18e5), r = t.filter((function(t) {
                                return -1 === e.indexOf(t);
                            }));
                            // Delete metadata for clients that are no longer considered active.
                                                        return Dr.forEach(r, (function(t) {
                                return n.delete(t.clientId);
                            })).next((function() {
                                return r;
                            }));
                        }));
                    })).catch((function() {
                        return [];
                    })) ]);

                  case 1:
                    // Delete potential leftover entries that may continue to mark the
                    // inactive clients as zombied in LocalStorage.
                    // Ideally we'd delete the IndexedDb and LocalStorage zombie entries for
                    // the client atomically, but we can't. So we opt to delete the IndexedDb
                    // entries first to avoid potentially reviving a zombied client.
                    if (e = n.sent(), this.Ga) for (r = 0, i = e; r < i.length; r++) o = i[r], this.Ga.removeItem(this.hc(o.clientId));
                    n.label = 2;

                  case 2:
                    return [ 2 /*return*/ ];
                }
            }));
        }));
    }, 
    /**
     * Schedules a recurring timer to update the client metadata and to either
     * extend or acquire the primary lease if the client is eligible.
     */
    t.prototype.Ja = function() {
        var t = this;
        this.qa = this.fn.yn("client_metadata_refresh" /* ClientMetadataRefresh */ , 4e3, (function() {
            return t.za().then((function() {
                return t.ac();
            })).then((function() {
                return t.Ja();
            }));
        }));
    }, 
    /** Checks whether `client` is the local client. */ t.prototype.rc = function(t) {
        return !!t && t.ownerId === this.clientId;
    }, 
    /**
     * Evaluate the state of all active clients and determine whether the local
     * client is or can act as the holder of the primary lease. Returns whether
     * the client is eligible for the lease, but does not actually acquire it.
     * May return 'false' even if there is no active leaseholder and another
     * (foreground) client should become leaseholder instead.
     */
    t.prototype.nc = function(t) {
        var e = this;
        return this.ka ? Dr.resolve(!0) : To(t).get(Ji.key).next((function(n) {
            // A client is eligible for the primary lease if:
            // - its network is enabled and the client's tab is in the foreground.
            // - its network is enabled and no other client's tab is in the
            //   foreground.
            // - every clients network is disabled and the client's tab is in the
            //   foreground.
            // - every clients network is disabled and no other client's tab is in
            //   the foreground.
            // - the `forceOwningTab` setting was passed in.
            if (null !== n && e.cc(n.leaseTimestampMs, 5e3) && !e.lc(n.ownerId)) {
                if (e.rc(n) && e.networkEnabled) return !0;
                if (!e.rc(n)) {
                    if (!n.allowTabSynchronization) 
                    // Fail the `canActAsPrimary` check if the current leaseholder has
                    // not opted into multi-tab synchronization. If this happens at
                    // client startup, we reject the Promise returned by
                    // `enablePersistence()` and the user can continue to use Firestore
                    // with in-memory persistence.
                    // If this fails during a lease refresh, we will instead block the
                    // AsyncQueue from executing further operations. Note that this is
                    // acceptable since mixing & matching different `synchronizeTabs`
                    // settings is not supported.
                    // TODO(b/114226234): Remove this check when `synchronizeTabs` can
                    // no longer be turned off.
                    throw new I(b.FAILED_PRECONDITION, Io);
                    return !1;
                }
            }
            return !(!e.networkEnabled || !e.inForeground) || No(t).ts().next((function(t) {
                return void 0 === e.uc(t, 5e3).find((function(t) {
                    if (e.clientId !== t.clientId) {
                        var n = !e.networkEnabled && t.networkEnabled, r = !e.inForeground && t.inForeground, i = e.networkEnabled === t.networkEnabled;
                        if (n || r && i) return !0;
                    }
                    return !1;
                }));
            }));
        })).next((function(t) {
            return e.isPrimary !== t && T("IndexedDbPersistence", "Client " + (t ? "is" : "is not") + " eligible for a primary lease."), 
            t;
        }));
    }, t.prototype.Di = function() {
        return e(this, void 0, void 0, (function() {
            var t = this;
            return n(this, (function(e) {
                switch (e.label) {
                  case 0:
                    // Use `SimpleDb.runTransaction` directly to avoid failing if another tab
                    // has obtained the primary lease.
                    // The shutdown() operations are idempotent and can be called even when
                    // start() aborted (e.g. because it couldn't acquire the persistence lease).
                    return this.Oa = !1, this._c(), this.qa && (this.qa.cancel(), this.qa = null), this.fc(), 
                    this.dc(), [ 4 /*yield*/ , this.ja.runTransaction("shutdown", "readwrite", [ Ji.store, fo.store ], (function(e) {
                        var n = new Eo(e, Jr.ai);
                        return t.sc(n).next((function() {
                            return t.oc(n);
                        }));
                    })) ];

                  case 1:
                    // The shutdown() operations are idempotent and can be called even when
                    // start() aborted (e.g. because it couldn't acquire the persistence lease).
                    // Use `SimpleDb.runTransaction` directly to avoid failing if another tab
                    // has obtained the primary lease.
                    return e.sent(), this.ja.close(), 
                    // Remove the entry marking the client as zombied from LocalStorage since
                    // we successfully deleted its metadata from IndexedDb.
                    this.wc(), [ 2 /*return*/ ];
                }
            }));
        }));
    }, 
    /**
     * Returns clients that are not zombied and have an updateTime within the
     * provided threshold.
     */
    t.prototype.uc = function(t, e) {
        var n = this;
        return t.filter((function(t) {
            return n.cc(t.updateTimeMs, e) && !n.lc(t.clientId);
        }));
    }, 
    /**
     * Returns the IDs of the clients that are currently active. If multi-tab
     * is not supported, returns an array that only contains the local client's
     * ID.
     *
     * PORTING NOTE: This is only used for Web multi-tab.
     */
    t.prototype.pi = function() {
        var t = this;
        return this.runTransaction("getActiveClients", "readonly", (function(e) {
            return No(e).ts().next((function(e) {
                return t.uc(e, 18e5).map((function(t) {
                    return t.clientId;
                }));
            }));
        }));
    }, Object.defineProperty(t.prototype, "Ei", {
        get: function() {
            return this.Oa;
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.mc = function(t) {
        return Ui.xo(t, this.serializer, this.Dr, this.No);
    }, t.prototype.Tc = function() {
        return this.Ka;
    }, t.prototype.Ec = function() {
        return this.vr;
    }, t.prototype.Ic = function() {
        return this.Dr;
    }, t.prototype.runTransaction = function(t, e, n) {
        var r = this;
        T("IndexedDbPersistence", "Starting transaction:", t);
        var i, o = "readonly" === e ? "readonly" : "readwrite";
        // Do all transactions as readwrite against all object stores, since we
        // are the only reader/writer.
        return this.ja.runTransaction(t, o, lo, (function(o) {
            return i = new Eo(o, r.Ma ? r.Ma.next() : Jr.ai), "readwrite-primary" === e ? r.ec(i).next((function(t) {
                return !!t || r.nc(i);
            })).next((function(e) {
                if (!e) throw N("Failed to obtain primary lease for action '" + t + "'."), r.isPrimary = !1, 
                r.fn.Cs((function() {
                    return r.Qa(!1);
                })), new I(b.FAILED_PRECONDITION, li);
                return n(i);
            })).next((function(t) {
                return r.ic(i).next((function() {
                    return t;
                }));
            })) : r.Ac(i).next((function() {
                return n(i);
            }));
        })).then((function(t) {
            return i.br(), t;
        }));
    }, 
    /**
     * Verifies that the current tab is the primary leaseholder or alternatively
     * that the leaseholder has opted into multi-tab synchronization.
     */
    // TODO(b/114226234): Remove this check when `synchronizeTabs` can no longer
    // be turned off.
    t.prototype.Ac = function(t) {
        var e = this;
        return To(t).get(Ji.key).next((function(t) {
            if (null !== t && e.cc(t.leaseTimestampMs, 5e3) && !e.lc(t.ownerId) && !e.rc(t) && !(e.ka || e.allowTabSynchronization && t.allowTabSynchronization)) throw new I(b.FAILED_PRECONDITION, Io);
        }));
    }, 
    /**
     * Obtains or extends the new primary lease for the local client. This
     * method does not verify that the client is eligible for this lease.
     */
    t.prototype.ic = function(t) {
        var e = new Ji(this.clientId, this.allowTabSynchronization, Date.now());
        return To(t).put(Ji.key, e);
    }, t.Ln = function() {
        return kr.Ln();
    }, 
    /** Checks the primary lease and removes it if we are the current primary. */ t.prototype.sc = function(t) {
        var e = this, n = To(t);
        return n.get(Ji.key).next((function(t) {
            return e.rc(t) ? (T("IndexedDbPersistence", "Releasing primary lease."), n.delete(Ji.key)) : Dr.resolve();
        }));
    }, 
    /** Verifies that `updateTimeMs` is within `maxAgeMs`. */ t.prototype.cc = function(t, e) {
        var n = Date.now();
        return !(t < n - e || t > n && (N("Detected an update time that is in the future: " + t + " > " + n), 
        1));
    }, t.prototype.Ha = function() {
        var t = this;
        null !== this.document && "function" == typeof this.document.addEventListener && (this.Ba = function() {
            t.fn.ws((function() {
                return t.inForeground = "visible" === t.document.visibilityState, t.za();
            }));
        }, this.document.addEventListener("visibilitychange", this.Ba), this.inForeground = "visible" === this.document.visibilityState);
    }, t.prototype.fc = function() {
        this.Ba && (this.document.removeEventListener("visibilitychange", this.Ba), this.Ba = null);
    }, 
    /**
     * Attaches a window.unload handler that will synchronously write our
     * clientId to a "zombie client id" location in LocalStorage. This can be used
     * by tabs trying to acquire the primary lease to determine that the lease
     * is no longer valid even if the timestamp is recent. This is particularly
     * important for the refresh case (so the tab correctly re-acquires the
     * primary lease). LocalStorage is used for this rather than IndexedDb because
     * it is a synchronous API and so can be used reliably from  an unload
     * handler.
     */
    t.prototype.Ya = function() {
        var t, e = this;
        "function" == typeof (null === (t = this.window) || void 0 === t ? void 0 : t.addEventListener) && (this.La = function() {
            // Note: In theory, this should be scheduled on the AsyncQueue since it
            // accesses internal state. We execute this code directly during shutdown
            // to make sure it gets a chance to run.
            e._c(), e.fn.ws((function() {
                return e.Di();
            }));
        }, this.window.addEventListener("unload", this.La));
    }, t.prototype.dc = function() {
        this.La && (this.window.removeEventListener("unload", this.La), this.La = null);
    }, 
    /**
     * Returns whether a client is "zombied" based on its LocalStorage entry.
     * Clients become zombied when their tab closes without running all of the
     * cleanup logic in `shutdown()`.
     */
    t.prototype.lc = function(t) {
        var e;
        try {
            var n = null !== (null === (e = this.Ga) || void 0 === e ? void 0 : e.getItem(this.hc(t)));
            return T("IndexedDbPersistence", "Client '" + t + "' " + (n ? "is" : "is not") + " zombied in LocalStorage"), 
            n;
        } catch (t) {
            // Gracefully handle if LocalStorage isn't working.
            return N("IndexedDbPersistence", "Failed to get zombied client id.", t), !1;
        }
    }, 
    /**
     * Record client as zombied (a client that had its tab closed). Zombied
     * clients are ignored during primary tab selection.
     */
    t.prototype._c = function() {
        if (this.Ga) try {
            this.Ga.setItem(this.hc(this.clientId), String(Date.now()));
        } catch (t) {
            // Gracefully handle if LocalStorage isn't available / working.
            N("Failed to set zombie client id.", t);
        }
    }, 
    /** Removes the zombied client entry if it exists. */ t.prototype.wc = function() {
        if (this.Ga) try {
            this.Ga.removeItem(this.hc(this.clientId));
        } catch (t) {
            // Ignore
        }
    }, t.prototype.hc = function(t) {
        return "firestore_zombie_" + this.persistenceKey + "_" + t;
    }, t;
}();

/**
 * Oldest acceptable age in milliseconds for client metadata before the client
 * is considered inactive and its associated data is garbage collected.
 */
/**
 * Helper to get a typed SimpleDbStore for the primary client object store.
 */
function To(t) {
    return _o.Qn(t, Ji.store);
}

/**
 * Helper to get a typed SimpleDbStore for the client metadata object store.
 */ function No(t) {
    return _o.Qn(t, fo.store);
}

/** Provides LRU functionality for IndexedDB persistence. */ var Ao = /** @class */ function() {
    function t(t, e) {
        this.db = t, this.wo = new Ii(this, e);
    }
    return t.prototype.Po = function(t) {
        var e = this.Rc(t);
        return this.db.Tc().ba(t).next((function(t) {
            return e.next((function(e) {
                return t + e;
            }));
        }));
    }, t.prototype.Rc = function(t) {
        var e = 0;
        return this.Vo(t, (function(t) {
            e++;
        })).next((function() {
            return e;
        }));
    }, t.prototype.Ce = function(t, e) {
        return this.db.Tc().Ce(t, e);
    }, t.prototype.Vo = function(t, e) {
        return this.gc(t, (function(t, n) {
            return e(n);
        }));
    }, t.prototype.Da = function(t, e, n) {
        return So(t, n);
    }, t.prototype.Na = function(t, e, n) {
        return So(t, n);
    }, t.prototype.po = function(t, e, n) {
        return this.db.Tc().po(t, e, n);
    }, t.prototype.Go = function(t, e) {
        return So(t, e);
    }, 
    /**
     * Returns true if anything would prevent this document from being garbage
     * collected, given that the document in question is not present in any
     * targets and has a sequence number less than or equal to the upper bound for
     * the collection run.
     */
    t.prototype.Pc = function(t, e) {
        return function(t, e) {
            var n = !1;
            return ji(t).os((function(r) {
                return Ci(t, r, e).next((function(t) {
                    return t && (n = !0), Dr.resolve(!t);
                }));
            })).next((function() {
                return n;
            }));
        }(t, e);
    }, t.prototype.bo = function(t, e) {
        var n = this, r = this.db.Ec().ra(), i = [], o = 0;
        return this.gc(t, (function(s, u) {
            if (u <= e) {
                var a = n.Pc(t, s).next((function(e) {
                    if (!e) 
                    // Our size accounting requires us to read all documents before
                    // removing them.
                    return o++, r.Rr(t, s).next((function() {
                        return r.Ar(s), bo(t).delete([ 0, Ei(s.path) ]);
                    }));
                }));
                i.push(a);
            }
        })).next((function() {
            return Dr.$n(i);
        })).next((function() {
            return r.apply(t);
        })).next((function() {
            return o;
        }));
    }, t.prototype.removeTarget = function(t, e) {
        var n = e.st(t.xa);
        return this.db.Tc().ya(t, n);
    }, t.prototype.yc = function(t, e) {
        return So(t, e);
    }, 
    /**
     * Call provided function for each document in the cache that is 'orphaned'. Orphaned
     * means not a part of any target, so the only entry in the target-document index for
     * that document will be the sentinel row (targetId 0), which will also have the sequence
     * number for the last time the document was accessed.
     */
    t.prototype.gc = function(t, e) {
        var n, r = bo(t), i = Jr.ai;
        return r.rs({
            index: uo.documentTargetsIndex
        }, (function(t, r) {
            var o = t[0], s = (t[1], r.path), u = r.sequenceNumber;
            0 === o ? (
            // if nextToReport is valid, report it, this is a new key so the
            // last one must not be a member of any targets.
            i !== Jr.ai && e(new F(Ni(n)), i), 
            // set nextToReport to be this sequence number. It's the next one we
            // might report, if we don't find any targets for this document.
            // Note that the sequence number must be defined when the targetId
            // is 0.
            i = u, n = s) : 
            // set nextToReport to be invalid, we know we don't need to report
            // this one since we found a target for it.
            i = Jr.ai;
        })).next((function() {
            // Since we report sequence numbers after getting to the next key, we
            // need to check if the last key we iterated over was an orphaned
            // document and report it.
            i !== Jr.ai && e(new F(Ni(n)), i);
        }));
    }, t.prototype.So = function(t) {
        return this.db.Ec().aa(t);
    }, t;
}();

function So(t, e) {
    return bo(t).put(
    /**
 * @return A value suitable for writing a sentinel row in the target-document
 * store.
 */
    function(t, e) {
        return new uo(0, Ei(t.path), e);
    }(e, t.xa));
}

/**
 * Generates a string used as a prefix when storing data in IndexedDB and
 * LocalStorage.
 */ function Do(t, e) {
    // Use two different prefix formats:
    //   * firestore / persistenceKey / projectID . databaseID / ...
    //   * firestore / persistenceKey / projectID / ...
    // projectIDs are DNS-compatible names and cannot contain dots
    // so there's no danger of collisions.
    var n = t.projectId;
    return t.j || (n += "." + t.database), "firestore/" + e + "/" + n + "/"
    /**
 * Implements `LocalStore` interface.
 *
 * Note: some field defined in this class might have public access level, but
 * the class is not exported so they are only accessible from this module.
 * This is useful to implement optional features (like bundles) in free
 * functions, such that they are tree-shakeable.
 */;
}

var ko = /** @class */ function() {
    function t(
    /** Manages our in-memory or durable persistence. */
    t, e, n) {
        this.persistence = t, this.Vc = e, 
        /**
             * Maps a targetID to data about its target.
             *
             * PORTING NOTE: We are using an immutable data structure on Web to make re-runs
             * of `applyRemoteEvent()` idempotent.
             */
        this.bc = new Ot(st), 
        /** Maps a target to its targetID. */
        // TODO(wuandy): Evaluate if TargetId can be part of Target.
        this.vc = new yt((function(t) {
            return Tt(t);
        }), Nt), 
        /**
             * The read time of the last entry processed by `getNewDocumentChanges()`.
             *
             * PORTING NOTE: This is only used for multi-tab synchronization.
             */
        this.Sc = gt.min(), this.Sr = t.mc(n), this.Dc = t.Ec(), this.Ka = t.Tc(), this.Cc = new di(this.Dc, this.Sr, this.persistence.Ic()), 
        this.Vc.Nc(this.Cc);
    }
    return t.prototype.Io = function(t) {
        var e = this;
        return this.persistence.runTransaction("Collect garbage", "readwrite-primary", (function(n) {
            return t.vo(n, e.bc);
        }));
    }, t;
}();

/**
 * Acknowledges the given batch.
 *
 * On the happy path when a batch is acknowledged, the local store will
 *
 *  + remove the batch from the mutation queue;
 *  + apply the changes to the remote document cache;
 *  + recalculate the latency compensated view implied by those changes (there
 *    may be mutations in the queue that affect the documents but haven't been
 *    acknowledged yet); and
 *  + give the changed documents back the sync engine
 *
 * @returns The resulting (modified) documents.
 */ function xo(t, e) {
    var n = x(t);
    return n.persistence.runTransaction("Acknowledge batch", "readwrite-primary", (function(t) {
        var r = e.batch.keys(), i = n.Dc.ra({
            oa: !0
        });
        return function(t, e, n, r) {
            var i = n.batch, o = i.keys(), s = Dr.resolve();
            return o.forEach((function(t) {
                s = s.next((function() {
                    return r.Rr(e, t);
                })).next((function(e) {
                    var o = e, s = n.dr.get(t);
                    k(null !== s), (!o || o.version.L(s) < 0) && ((o = i.cr(t, o, n)) && 
                    // We use the commitVersion as the readTime rather than the
                    // document's updateTime since the updateTime is not advanced
                    // for updates that do not modify the underlying document.
                    r.Er(o, n._r));
                }));
            })), s.next((function() {
                return t.Sr.Wo(e, i);
            }));
        }(n, t, e, i).next((function() {
            return i.apply(t);
        })).next((function() {
            return n.Sr.zo(t);
        })).next((function() {
            return n.Cc.kr(t, r);
        }));
    }));
}

/**
 * Removes mutations from the MutationQueue for the specified batch;
 * LocalDocuments will be recalculated.
 *
 * @returns The resulting modified documents.
 */
/**
 * Returns the last consistent snapshot processed (used by the RemoteStore to
 * determine whether to buffer incoming snapshots from the backend).
 */ function Lo(t) {
    var e = x(t);
    return e.persistence.runTransaction("Get last remote snapshot version", "readonly", (function(t) {
        return e.Ka.Ea(t);
    }));
}

/**
 * Updates the "ground-state" (remote) documents. We assume that the remote
 * event reflects any write batches that have been acknowledged or rejected
 * (i.e. we do not re-apply local mutations to updates from this event).
 *
 * LocalDocuments are re-calculated if there are remaining mutations in the
 * queue.
 */ function Ro(t, e) {
    var n = x(t), r = e.nt, i = n.bc;
    return n.persistence.runTransaction("Apply remote event", "readwrite-primary", (function(t) {
        var o = n.Dc.ra({
            oa: !0
        });
        // Reset newTargetDataByTargetMap in case this transaction gets re-run.
                i = n.bc;
        var s = [];
        e.zt.forEach((function(e, o) {
            var u = i.get(o);
            if (u) {
                // Only update the remote keys if the target is still active. This
                // ensures that we can persist the updated target data along with
                // the updated assignment.
                s.push(n.Ka.Ca(t, e.se, o).next((function() {
                    return n.Ka.Sa(t, e.ee, o);
                })));
                var a = e.resumeToken;
                // Update the resume token if the change includes one.
                                if (a.O() > 0) {
                    var c = u.it(a, r).st(t.xa);
                    i = i.ot(o, c), 
                    // Update the target data if there are target changes (or if
                    // sufficient time has passed since the last update).
                    /**
     * Returns true if the newTargetData should be persisted during an update of
     * an active target. TargetData should always be persisted when a target is
     * being released and should not call this function.
     *
     * While the target is active, TargetData updates can be omitted when nothing
     * about the target has changed except metadata like the resume token or
     * snapshot version. Occasionally it's worth the extra write to prevent these
     * values from getting too stale after a crash, but this doesn't have to be
     * too frequent.
     */
                    function(t, e, n) {
                        // Always persist target data if we don't already have a resume token.
                        return k(e.resumeToken.O() > 0), 0 === t.resumeToken.O() || (
                        // Don't allow resume token changes to be buffered indefinitely. This
                        // allows us to be reasonably up-to-date after a crash and avoids needing
                        // to loop over all active queries on shutdown. Especially in the browser
                        // we may not get time to do anything interesting while the current tab is
                        // closing.
                        e.nt.X() - t.nt.X() >= 3e8 || n.ee.size + n.ne.size + n.se.size > 0);
                    }(u, c, e) && s.push(n.Ka.ya(t, c));
                }
            }
        }));
        var u = Mt(), a = Kt();
        // HACK: The only reason we allow a null snapshot version is so that we
        // can synthesize remote events when we get permission denied errors while
        // trying to resolve the state of a locally cached document that is in
        // limbo.
                if (e.Yt.forEach((function(t, e) {
            a = a.add(t);
        })), 
        // Each loop iteration only affects its "own" doc, so it's safe to get all the remote
        // documents in advance in a single call.
        s.push(o.getEntries(t, a).next((function(i) {
            e.Yt.forEach((function(a, c) {
                var h = i.get(a);
                // Note: The order of the steps below is important, since we want
                // to ensure that rejected limbo resolutions (which fabricate
                // NoDocuments with SnapshotVersion.min()) never add documents to
                // cache.
                                c instanceof Bn && c.version.isEqual(gt.min()) ? (
                // NoDocuments with SnapshotVersion.min() are used in manufactured
                // events. We remove these documents from cache since we lost
                // access.
                o.Ar(a, r), u = u.ot(a, c)) : null == h || c.version.L(h.version) > 0 || 0 === c.version.L(h.version) && h.hasPendingWrites ? (o.Er(c, r), 
                u = u.ot(a, c)) : T("LocalStore", "Ignoring outdated watch update for ", a, ". Current version:", h.version, " Watch version:", c.version), 
                e.Jt.has(a) && s.push(n.persistence.No.yc(t, a));
            }));
        }))), !r.isEqual(gt.min())) {
            var c = n.Ka.Ea(t).next((function(e) {
                return n.Ka.Aa(t, t.xa, r);
            }));
            s.push(c);
        }
        return Dr.$n(s).next((function() {
            return o.apply(t);
        })).next((function() {
            return n.Cc.Mr(t, u);
        }));
    })).then((function(t) {
        return n.bc = i, t;
    }));
}

/**
 * Gets the mutation batch after the passed in batchId in the mutation queue
 * or null if empty.
 * @param afterBatchId If provided, the batch to search after.
 * @returns The next mutation or null if there wasn't one.
 */ function Oo(t, e) {
    var n = x(t);
    return n.persistence.runTransaction("Get next mutation batch", "readonly", (function(t) {
        return void 0 === e && (e = -1), n.Sr.Bo(t, e);
    }));
}

/**
 * Reads the current value of a Document with a given key or null if not
 * found - used for testing.
 */
/**
 * Assigns the given target an internal ID so that its results can be pinned so
 * they don't get GC'd. A target must be allocated in the local store before
 * the store can be used to manage its view.
 *
 * Allocating an already allocated `Target` will return the existing `TargetData`
 * for that `Target`.
 */ function Po(t, e) {
    var n = x(t);
    return n.persistence.runTransaction("Allocate target", "readwrite", (function(t) {
        var r;
        return n.Ka.va(t, e).next((function(i) {
            return i ? (
            // This target has been listened to previously, so reuse the
            // previous targetID.
            // TODO(mcg): freshen last accessed date?
            r = i, Dr.resolve(r)) : n.Ka.wa(t).next((function(i) {
                return r = new kt(e, i, 0 /* Listen */ , t.xa), n.Ka.Ra(t, r).next((function() {
                    return r;
                }));
            }));
        }));
    })).then((function(t) {
        // If Multi-Tab is enabled, the existing target data may be newer than
        // the in-memory data
        var r = n.bc.get(t.targetId);
        return (null === r || t.nt.L(r.nt) > 0) && (n.bc = n.bc.ot(t.targetId, t), n.vc.set(e, t.targetId)), 
        t;
    }));
}

/**
 * Returns the TargetData as seen by the LocalStore, including updates that may
 * have not yet been persisted to the TargetCache.
 */
// Visible for testing.
/**
 * Unpins all the documents associated with the given target. If
 * `keepPersistedTargetData` is set to false and Eager GC enabled, the method
 * directly removes the associated target data from the target cache.
 *
 * Releasing a non-existing `Target` is a no-op.
 */
// PORTING NOTE: `keepPersistedTargetData` is multi-tab only.
function Vo(t, r, i) {
    return e(this, void 0, void 0, (function() {
        var e, o, s, u;
        return n(this, (function(n) {
            switch (n.label) {
              case 0:
                e = x(t), o = e.bc.get(r), s = i ? "readwrite" : "readwrite-primary", n.label = 1;

              case 1:
                return n.trys.push([ 1, 4, , 5 ]), i ? [ 3 /*break*/ , 3 ] : [ 4 /*yield*/ , e.persistence.runTransaction("Release target", s, (function(t) {
                    return e.persistence.No.removeTarget(t, o);
                })) ];

              case 2:
                n.sent(), n.label = 3;

              case 3:
                return [ 3 /*break*/ , 5 ];

              case 4:
                if (!Rr(u = n.sent())) throw u;
                // All `releaseTarget` does is record the final metadata state for the
                // target, but we've been recording this periodically during target
                // activity. If we lose this write this could cause a very slight
                // difference in the order of target deletion during GC, but we
                // don't define exact LRU semantics so this is acceptable.
                                return T("LocalStore", "Failed to update sequence numbers for target " + r + ": " + u), 
                [ 3 /*break*/ , 5 ];

              case 5:
                return e.bc = e.bc.remove(r), e.vc.delete(o.target), [ 2 /*return*/ ];
            }
        }));
    }));
}

/**
 * Runs the specified query against the local store and returns the results,
 * potentially taking advantage of query data from previous executions (such
 * as the set of remote keys).
 *
 * @param usePreviousResults Whether results from previous executions can
 * be used to optimize this query execution.
 */ function Uo(t, e, n) {
    var r = x(t), i = gt.min(), o = Kt();
    return r.persistence.runTransaction("Execute query", "readonly", (function(t) {
        return function(t, e, n) {
            var r = x(t), i = r.vc.get(n);
            return void 0 !== i ? Dr.resolve(r.bc.get(i)) : r.Ka.va(e, n);
        }(r, t, er(e)).next((function(e) {
            if (e) return i = e.lastLimboFreeSnapshotVersion, r.Ka.Fa(t, e.targetId).next((function(t) {
                o = t;
            }));
        })).next((function() {
            return r.Vc.Lr(t, e, n ? i : gt.min(), n ? o : Kt());
        })).next((function(t) {
            return {
                documents: t,
                Fc: o
            };
        }));
    }));
}

// PORTING NOTE: Multi-Tab only.
function Co(t, e) {
    var n = x(t), r = x(n.Ka), i = n.bc.get(e);
    return i ? Promise.resolve(i.target) : n.persistence.runTransaction("Get target data", "readonly", (function(t) {
        return r.Ue(t, e).next((function(t) {
            return t ? t.target : null;
        }));
    }));
}

/**
 * Returns the set of documents that have been updated since the last call.
 * If this is the first call, returns the set of changes since client
 * initialization. Further invocations will return document that have changed
 * since the prior call.
 */
// PORTING NOTE: Multi-Tab only.
function Fo(t) {
    var e = x(t);
    return e.persistence.runTransaction("Get new document changes", "readonly", (function(t) {
        return function(t, e, n) {
            var r = x(t), i = Mt(), o = ki(n), s = Ki(e), u = IDBKeyRange.lowerBound(o, !0);
            return s.rs({
                index: io.readTimeIndex,
                range: u
            }, (function(t, e) {
                // Unlike `getEntry()` and others, `getNewDocumentChanges()` parses
                // the documents directly since we want to keep sentinel deletes.
                var n = Si(r.serializer, e);
                i = i.ot(n.key, n), o = e.readTime;
            })).next((function() {
                return {
                    xc: i,
                    readTime: xi(o)
                };
            }));
        }(e.Dc, t, e.Sc);
    })).then((function(t) {
        var n = t.xc, r = t.readTime;
        return e.Sc = r, n;
    }));
}

/**
 * Reads the newest document change from persistence and moves the internal
 * synchronization marker forward so that calls to `getNewDocumentChanges()`
 * only return changes that happened after client initialization.
 */
// PORTING NOTE: Multi-Tab only.
function Mo(t) {
    return e(this, void 0, void 0, (function() {
        var e;
        return n(this, (function(n) {
            return [ 2 /*return*/ , (e = x(t)).persistence.runTransaction("Synchronize last document change read time", "readonly", (function(t) {
                return function(t) {
                    var e = Ki(t), n = gt.min();
                    // If there are no existing entries, we return SnapshotVersion.min().
                                        return e.rs({
                        index: io.readTimeIndex,
                        reverse: !0
                    }, (function(t, e, r) {
                        e.readTime && (n = xi(e.readTime)), r.done();
                    })).next((function() {
                        return n;
                    }));
                }(t);
            })).then((function(t) {
                e.Sc = t;
            })) ];
        }));
    }));
}

/**
 * Verifies the error thrown by a LocalStore operation. If a LocalStore
 * operation fails because the primary lease has been taken by another client,
 * we ignore the error (the persistence layer will immediately call
 * `applyPrimaryLease` to propagate the primary state change). All other errors
 * are re-thrown.
 *
 * @param err An error returned by a LocalStore operation.
 * @return A Promise that resolves after we recovered, or the original error.
 */ function qo(t) {
    return e(this, void 0, void 0, (function() {
        return n(this, (function(e) {
            if (t.code !== b.FAILED_PRECONDITION || t.message !== li) throw t;
            return T("LocalStore", "Unexpectedly lost primary lease"), [ 2 /*return*/ ];
        }));
    }));
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A collection of references to a document from some kind of numbered entity
 * (either a target ID or batch ID). As references are added to or removed from
 * the set corresponding events are emitted to a registered garbage collector.
 *
 * Each reference is represented by a DocumentReference object. Each of them
 * contains enough information to uniquely identify the reference. They are all
 * stored primarily in a set sorted by key. A document is considered garbage if
 * there's no references in that set (this can be efficiently checked thanks to
 * sorting by key).
 *
 * ReferenceSet also keeps a secondary set that contains references sorted by
 * IDs. This one is used to efficiently implement removal of all references by
 * some target ID.
 */ var jo = /** @class */ function() {
    function t() {
        // A set of outstanding references to a document sorted by key.
        this.$c = new Ut(Go.kc), 
        // A set of outstanding references to a document sorted by target id.
        this.Mc = new Ut(Go.Oc)
        /** Returns true if the reference set contains no references. */;
    }
    return t.prototype.m = function() {
        return this.$c.m();
    }, 
    /** Adds a reference to the given document key for the given ID. */ t.prototype.Da = function(t, e) {
        var n = new Go(t, e);
        this.$c = this.$c.add(n), this.Mc = this.Mc.add(n);
    }, 
    /** Add references to the given document keys for the given ID. */ t.prototype.Lc = function(t, e) {
        var n = this;
        t.forEach((function(t) {
            return n.Da(t, e);
        }));
    }, 
    /**
     * Removes a reference to the given document key for the given
     * ID.
     */
    t.prototype.Na = function(t, e) {
        this.Bc(new Go(t, e));
    }, t.prototype.qc = function(t, e) {
        var n = this;
        t.forEach((function(t) {
            return n.Na(t, e);
        }));
    }, 
    /**
     * Clears all references with a given ID. Calls removeRef() for each key
     * removed.
     */
    t.prototype.Uc = function(t) {
        var e = this, n = new F(new V([])), r = new Go(n, t), i = new Go(n, t + 1), o = [];
        return this.Mc.Ft([ r, i ], (function(t) {
            e.Bc(t), o.push(t.key);
        })), o;
    }, t.prototype.Qc = function() {
        var t = this;
        this.$c.forEach((function(e) {
            return t.Bc(e);
        }));
    }, t.prototype.Bc = function(t) {
        this.$c = this.$c.delete(t), this.Mc = this.Mc.delete(t);
    }, t.prototype.Wc = function(t) {
        var e = new F(new V([])), n = new Go(e, t), r = new Go(e, t + 1), i = Kt();
        return this.Mc.Ft([ n, r ], (function(t) {
            i = i.add(t.key);
        })), i;
    }, t.prototype.Ho = function(t) {
        var e = new Go(t, 0), n = this.$c.$t(e);
        return null !== n && t.isEqual(n.key);
    }, t;
}(), Go = /** @class */ function() {
    function t(t, e) {
        this.key = t, this.jc = e
        /** Compare by key then by ID */;
    }
    return t.kc = function(t, e) {
        return F.i(t.key, e.key) || st(t.jc, e.jc);
    }, 
    /** Compare by ID then by key */ t.Oc = function(t, e) {
        return st(t.jc, e.jc) || F.i(t.key, e.key);
    }, t;
}(), zo = function(t, e) {
    this.user = e, this.type = "OAuth", this.Kc = {}, 
    // Set the headers using Object Literal notation to avoid minification
    this.Kc.Authorization = "Bearer " + t;
}, Bo = /** @class */ function() {
    function t() {
        /**
         * Stores the listener registered with setChangeListener()
         * This isn't actually necessary since the UID never changes, but we use this
         * to verify the listen contract is adhered to in tests.
         */
        this.Gc = null;
    }
    return t.prototype.getToken = function() {
        return Promise.resolve(null);
    }, t.prototype.zc = function() {}, t.prototype.Hc = function(t) {
        this.Gc = t, 
        // Fire with initial user.
        t(Xr.UNAUTHENTICATED);
    }, t.prototype.Yc = function() {
        this.Gc = null;
    }, t;
}(), Ko = /** @class */ function() {
    function t(t) {
        var e = this;
        /**
         * The auth token listener registered with FirebaseApp, retained here so we
         * can unregister it.
         */        this.Jc = null, 
        /** Tracks the current User. */
        this.currentUser = Xr.UNAUTHENTICATED, this.Xc = !1, 
        /**
             * Counter used to detect if the token changed while a getToken request was
             * outstanding.
             */
        this.Zc = 0, 
        /** The listener registered with setChangeListener(). */
        this.Gc = null, this.forceRefresh = !1, this.Jc = function() {
            e.Zc++, e.currentUser = e.tu(), e.Xc = !0, e.Gc && e.Gc(e.currentUser);
        }, this.Zc = 0, this.auth = t.getImmediate({
            optional: !0
        }), this.auth ? this.auth.addAuthTokenListener(this.Jc) : (
        // if auth is not available, invoke tokenListener once with null token
        this.Jc(null), t.get().then((function(t) {
            e.auth = t, e.Jc && 
            // tokenListener can be removed by removeChangeListener()
            e.auth.addAuthTokenListener(e.Jc);
        }), (function() {})));
    }
    return t.prototype.getToken = function() {
        var t = this, e = this.Zc, n = this.forceRefresh;
        // Take note of the current value of the tokenCounter so that this method
        // can fail (with an ABORTED error) if there is a token change while the
        // request is outstanding.
                return this.forceRefresh = !1, this.auth ? this.auth.getToken(n).then((function(n) {
            // Cancel the request since the token changed while the request was
            // outstanding so the response is potentially for a previous user (which
            // user, we can't be sure).
            return t.Zc !== e ? (T("FirebaseCredentialsProvider", "getToken aborted due to token change."), 
            t.getToken()) : n ? (k("string" == typeof n.accessToken), new zo(n.accessToken, t.currentUser)) : null;
        })) : Promise.resolve(null);
    }, t.prototype.zc = function() {
        this.forceRefresh = !0;
    }, t.prototype.Hc = function(t) {
        this.Gc = t, 
        // Fire the initial event
        this.Xc && t(this.currentUser);
    }, t.prototype.Yc = function() {
        this.auth && this.auth.removeAuthTokenListener(this.Jc), this.Jc = null, this.Gc = null;
    }, 
    // Auth.getUid() can return null even with a user logged in. It is because
    // getUid() is synchronous, but the auth code populating Uid is asynchronous.
    // This method should only be called in the AuthTokenListener callback
    // to guarantee to get the actual user.
    t.prototype.tu = function() {
        var t = this.auth && this.auth.getUid();
        return k(null === t || "string" == typeof t), new Xr(t);
    }, t;
}(), Wo = /** @class */ function() {
    function t(t, e) {
        this.eu = t, this.nu = e, this.type = "FirstParty", this.user = Xr.ni;
    }
    return Object.defineProperty(t.prototype, "Kc", {
        get: function() {
            var t = {
                "X-Goog-AuthUser": this.nu
            }, e = this.eu.auth.getAuthHeaderValueForFirstParty([]);
            // Use array notation to prevent minification
                        return e && (t.Authorization = e), t;
        },
        enumerable: !1,
        configurable: !0
    }), t;
}(), Qo = /** @class */ function() {
    function t(t, e) {
        this.eu = t, this.nu = e;
    }
    return t.prototype.getToken = function() {
        return Promise.resolve(new Wo(this.eu, this.nu));
    }, t.prototype.Hc = function(t) {
        // Fire with initial uid.
        t(Xr.ni);
    }, t.prototype.Yc = function() {}, t.prototype.zc = function() {}, t;
}(), Ho = /** @class */ function() {
    function t(t, e, n, r, i, o) {
        this.fn = t, this.su = n, this.iu = r, this.ru = i, this.listener = o, this.state = 0 /* Initial */ , 
        /**
             * A close count that's incremented every time the stream is closed; used by
             * getCloseGuardedDispatcher() to invalidate callbacks that happen after
             * close.
             */
        this.ou = 0, this.au = null, this.stream = null, this.ys = new Sr(t, e)
        /**
     * Returns true if start() has been called and no error has occurred. True
     * indicates the stream is open or in the process of opening (which
     * encompasses respecting backoff, getting auth tokens, and starting the
     * actual RPC). Use isOpen() to determine if the stream is open and ready for
     * outbound requests.
     */;
    }
    return t.prototype.cu = function() {
        return 1 /* Starting */ === this.state || 2 /* Open */ === this.state || 4 /* Backoff */ === this.state;
    }, 
    /**
     * Returns true if the underlying RPC is open (the onOpen() listener has been
     * called) and the stream is ready for outbound requests.
     */
    t.prototype.uu = function() {
        return 2 /* Open */ === this.state;
    }, 
    /**
     * Starts the RPC. Only allowed if isStarted() returns false. The stream is
     * not immediately ready for use: onOpen() will be invoked when the RPC is
     * ready for outbound requests, at which point isOpen() will return true.
     *
     * When start returns, isStarted() will return true.
     */
    t.prototype.start = function() {
        3 /* Error */ !== this.state ? this.auth() : this.hu();
    }, 
    /**
     * Stops the RPC. This call is idempotent and allowed regardless of the
     * current isStarted() state.
     *
     * When stop returns, isStarted() and isOpen() will both return false.
     */
    t.prototype.stop = function() {
        return e(this, void 0, void 0, (function() {
            return n(this, (function(t) {
                switch (t.label) {
                  case 0:
                    return this.cu() ? [ 4 /*yield*/ , this.close(0 /* Initial */) ] : [ 3 /*break*/ , 2 ];

                  case 1:
                    t.sent(), t.label = 2;

                  case 2:
                    return [ 2 /*return*/ ];
                }
            }));
        }));
    }, 
    /**
     * After an error the stream will usually back off on the next attempt to
     * start it. If the error warrants an immediate restart of the stream, the
     * sender can use this to indicate that the receiver should not back off.
     *
     * Each error will call the onClose() listener. That function can decide to
     * inhibit backoff if required.
     */
    t.prototype.lu = function() {
        this.state = 0 /* Initial */ , this.ys.reset();
    }, 
    /**
     * Marks this stream as idle. If no further actions are performed on the
     * stream for one minute, the stream will automatically close itself and
     * notify the stream's onClose() handler with Status.OK. The stream will then
     * be in a !isStarted() state, requiring the caller to start the stream again
     * before further use.
     *
     * Only streams that are in state 'Open' can be marked idle, as all other
     * states imply pending network operations.
     */
    t.prototype._u = function() {
        var t = this;
        // Starts the idle time if we are in state 'Open' and are not yet already
        // running a timer (in which case the previous idle timeout still applies).
                this.uu() && null === this.au && (this.au = this.fn.yn(this.su, 6e4, (function() {
            return t.fu();
        })));
    }, 
    /** Sends a message to the underlying stream. */ t.prototype.du = function(t) {
        this.wu(), this.stream.send(t);
    }, 
    /** Called by the idle timer when the stream should close due to inactivity. */ t.prototype.fu = function() {
        return e(this, void 0, void 0, (function() {
            return n(this, (function(t) {
                return this.uu() ? [ 2 /*return*/ , this.close(0 /* Initial */) ] : [ 2 /*return*/ ];
            }));
        }));
    }, 
    /** Marks the stream as active again. */ t.prototype.wu = function() {
        this.au && (this.au.cancel(), this.au = null);
    }, 
    /**
     * Closes the stream and cleans up as necessary:
     *
     * * closes the underlying GRPC stream;
     * * calls the onClose handler with the given 'error';
     * * sets internal stream state to 'finalState';
     * * adjusts the backoff timer based on the error
     *
     * A new stream can be opened by calling start().
     *
     * @param finalState the intended state of the stream after closing.
     * @param error the error the connection was closed with.
     */
    t.prototype.close = function(t, r) {
        return e(this, void 0, void 0, (function() {
            return n(this, (function(e) {
                switch (e.label) {
                  case 0:
                    // Notify the listener that the stream closed.
                    // Cancel any outstanding timers (they're guaranteed not to execute).
                    return this.wu(), this.ys.cancel(), 
                    // Invalidates any stream-related callbacks (e.g. from auth or the
                    // underlying stream), guaranteeing they won't execute.
                    this.ou++, 3 /* Error */ !== t ? 
                    // If this is an intentional close ensure we don't delay our next connection attempt.
                    this.ys.reset() : r && r.code === b.RESOURCE_EXHAUSTED ? (
                    // Log the error. (Probably either 'quota exceeded' or 'max queue length reached'.)
                    N(r.toString()), N("Using maximum backoff delay to prevent overloading the backend."), 
                    this.ys.Rn()) : r && r.code === b.UNAUTHENTICATED && 
                    // "unauthenticated" error means the token was rejected. Try force refreshing it in case it
                    // just expired.
                    this.ru.zc(), 
                    // Clean up the underlying stream because we are no longer interested in events.
                    null !== this.stream && (this.mu(), this.stream.close(), this.stream = null), 
                    // This state must be assigned before calling onClose() to allow the callback to
                    // inhibit backoff or otherwise manipulate the state in its non-started state.
                    this.state = t, [ 4 /*yield*/ , this.listener.Tu(r) ];

                  case 1:
                    // Cancel any outstanding timers (they're guaranteed not to execute).
                    // Notify the listener that the stream closed.
                    return e.sent(), [ 2 /*return*/ ];
                }
            }));
        }));
    }, 
    /**
     * Can be overridden to perform additional cleanup before the stream is closed.
     * Calling super.tearDown() is not required.
     */
    t.prototype.mu = function() {}, t.prototype.auth = function() {
        var t = this;
        this.state = 1 /* Starting */;
        var e = this.Eu(this.ou), n = this.ou;
        // TODO(mikelehen): Just use dispatchIfNotClosed, but see TODO below.
                this.ru.getToken().then((function(e) {
            // Stream can be stopped while waiting for authentication.
            // TODO(mikelehen): We really should just use dispatchIfNotClosed
            // and let this dispatch onto the queue, but that opened a spec test can
            // of worms that I don't want to deal with in this PR.
            t.ou === n && 
            // Normally we'd have to schedule the callback on the AsyncQueue.
            // However, the following calls are safe to be called outside the
            // AsyncQueue since they don't chain asynchronous calls
            t.Iu(e);
        }), (function(n) {
            e((function() {
                var e = new I(b.UNKNOWN, "Fetching auth token failed: " + n.message);
                return t.Au(e);
            }));
        }));
    }, t.prototype.Iu = function(t) {
        var e = this, n = this.Eu(this.ou);
        this.stream = this.Ru(t), this.stream.gu((function() {
            n((function() {
                return e.state = 2 /* Open */ , e.listener.gu();
            }));
        })), this.stream.Tu((function(t) {
            n((function() {
                return e.Au(t);
            }));
        })), this.stream.onMessage((function(t) {
            n((function() {
                return e.onMessage(t);
            }));
        }));
    }, t.prototype.hu = function() {
        var t = this;
        this.state = 4 /* Backoff */ , this.ys.gn((function() {
            return e(t, void 0, void 0, (function() {
                return n(this, (function(t) {
                    return this.state = 0 /* Initial */ , this.start(), [ 2 /*return*/ ];
                }));
            }));
        }));
    }, 
    // Visible for tests
    t.prototype.Au = function(t) {
        // In theory the stream could close cleanly, however, in our current model
        // we never expect this to happen because if we stop a stream ourselves,
        // this callback will never be called. To prevent cases where we retry
        // without a backoff accidentally, we set the stream to error in all cases.
        return T("PersistentStream", "close with error: " + t), this.stream = null, this.close(3 /* Error */ , t);
    }, 
    /**
     * Returns a "dispatcher" function that dispatches operations onto the
     * AsyncQueue but only runs them if closeCount remains unchanged. This allows
     * us to turn auth / stream callbacks into no-ops if the stream is closed /
     * re-opened, etc.
     */
    t.prototype.Eu = function(t) {
        var e = this;
        return function(n) {
            e.fn.ws((function() {
                return e.ou === t ? n() : (T("PersistentStream", "stream callback skipped by getCloseGuardedDispatcher."), 
                Promise.resolve());
            }));
        };
    }, t;
}(), Yo = /** @class */ function(e) {
    function n(t, n, r, i, o) {
        var s = this;
        return (s = e.call(this, t, "listen_stream_connection_backoff" /* ListenStreamConnectionBackoff */ , "listen_stream_idle" /* ListenStreamIdle */ , n, r, o) || this).serializer = i, 
        s;
    }
    return t(n, e), n.prototype.Ru = function(t) {
        return this.iu.Pu("Listen", t);
    }, n.prototype.onMessage = function(t) {
        // A successful response means the stream is healthy
        this.ys.reset();
        var e = function(t, e) {
            var n;
            if ("targetChange" in e) {
                e.targetChange;
                // proto3 default value is unset in JSON (undefined), so use 'NO_CHANGE'
                // if unset
                var r = function(t) {
                    return "NO_CHANGE" === t ? 0 /* NoChange */ : "ADD" === t ? 1 /* Added */ : "REMOVE" === t ? 2 /* Removed */ : "CURRENT" === t ? 3 /* Current */ : "RESET" === t ? 4 /* Reset */ : D();
                }(e.targetChange.targetChangeType || "NO_CHANGE"), i = e.targetChange.targetIds || [], o = function(t, e) {
                    return t.Qe ? (k(void 0 === e || "string" == typeof e), ct.fromBase64String(e || "")) : (k(void 0 === e || e instanceof Uint8Array), 
                    ct.fromUint8Array(e || new Uint8Array));
                }(t, e.targetChange.resumeToken), s = e.targetChange.cause, u = s && function(t) {
                    var e = void 0 === t.code ? b.UNKNOWN : Rt(t.code);
                    return new I(e, t.message || "");
                }(s);
                n = new ee(r, i, o, u || null);
            } else if ("documentChange" in e) {
                e.documentChange;
                var a = e.documentChange;
                a.document, a.document.name, a.document.updateTime;
                var c = Me(t, a.document.name), h = Ve(a.document.updateTime), f = new Mn({
                    mapValue: {
                        fields: a.document.fields
                    }
                }), l = new zn(c, h, f, {}), p = a.targetIds || [], d = a.removedTargetIds || [];
                n = new Zt(p, d, l.key, l);
            } else if ("documentDelete" in e) {
                e.documentDelete;
                var v = e.documentDelete;
                v.document;
                var y = Me(t, v.document), m = v.readTime ? Ve(v.readTime) : gt.min(), g = new Bn(y, m), w = v.removedTargetIds || [];
                n = new Zt([], w, g.key, g);
            } else if ("documentRemove" in e) {
                e.documentRemove;
                var E = e.documentRemove;
                E.document;
                var _ = Me(t, E.document), T = E.removedTargetIds || [];
                n = new Zt([], T, _, null);
            } else {
                if (!("filter" in e)) return D();
                e.filter;
                var N = e.filter;
                N.targetId;
                var A = N.count || 0, S = new xt(A), x = N.targetId;
                n = new te(x, S);
            }
            return n;
        }(this.serializer, t), n = function(t) {
            // We have only reached a consistent snapshot for the entire stream if there
            // is a read_time set and it applies to all targets (i.e. the list of
            // targets is empty). The backend is guaranteed to send such responses.
            if (!("targetChange" in t)) return gt.min();
            var e = t.targetChange;
            return e.targetIds && e.targetIds.length ? gt.min() : e.readTime ? Ve(e.readTime) : gt.min();
        }(t);
        return this.listener.yu(e, n);
    }, 
    /**
     * Registers interest in the results of the given target. If the target
     * includes a resumeToken it will be included in the request. Results that
     * affect the target will be streamed back as WatchChange messages that
     * reference the targetId.
     */
    n.prototype.Vu = function(t) {
        var e = {};
        e.database = Ge(this.serializer), e.addTarget = function(t, e) {
            var n, r = e.target;
            return (n = At(r) ? {
                documents: Qe(t, r)
            } : {
                query: He(t, r)
            }).targetId = e.targetId, e.resumeToken.O() > 0 && (n.resumeToken = Oe(t, e.resumeToken)), 
            n;
        }(this.serializer, t);
        var n = function(t, e) {
            var n = function(t, e) {
                switch (e) {
                  case 0 /* Listen */ :
                    return null;

                  case 1 /* ExistenceFilterMismatch */ :
                    return "existence-filter-mismatch";

                  case 2 /* LimboResolution */ :
                    return "limbo-document";

                  default:
                    return D();
                }
            }(0, e.et);
            return null == n ? null : {
                "goog-listen-tags": n
            };
        }(this.serializer, t);
        n && (e.labels = n), this.du(e);
    }, 
    /**
     * Unregisters interest in the results of the target associated with the
     * given targetId.
     */
    n.prototype.pu = function(t) {
        var e = {};
        e.database = Ge(this.serializer), e.removeTarget = t, this.du(e);
    }, n;
}(Ho), $o = /** @class */ function(e) {
    function n(t, n, r, i, o) {
        var s = this;
        return (s = e.call(this, t, "write_stream_connection_backoff" /* WriteStreamConnectionBackoff */ , "write_stream_idle" /* WriteStreamIdle */ , n, r, o) || this).serializer = i, 
        s.bu = !1, s;
    }
    return t(n, e), Object.defineProperty(n.prototype, "vu", {
        /**
         * Tracks whether or not a handshake has been successfully exchanged and
         * the stream is ready to accept mutations.
         */
        get: function() {
            return this.bu;
        },
        enumerable: !1,
        configurable: !0
    }), 
    // Override of PersistentStream.start
    n.prototype.start = function() {
        this.bu = !1, this.lastStreamToken = void 0, e.prototype.start.call(this);
    }, n.prototype.mu = function() {
        this.bu && this.Su([]);
    }, n.prototype.Ru = function(t) {
        return this.iu.Pu("Write", t);
    }, n.prototype.onMessage = function(t) {
        if (
        // Always capture the last stream token.
        k(!!t.streamToken), this.lastStreamToken = t.streamToken, this.bu) {
            // A successful first write response means the stream is healthy,
            // Note, that we could consider a successful handshake healthy, however,
            // the write itself might be causing an error we want to back off from.
            this.ys.reset();
            var e = function(t, e) {
                return t && t.length > 0 ? (k(void 0 !== e), t.map((function(t) {
                    return function(t, e) {
                        // NOTE: Deletes don't have an updateTime.
                        var n = t.updateTime ? Ve(t.updateTime) : Ve(e);
                        n.isEqual(gt.min()) && (
                        // The Firestore Emulator currently returns an update time of 0 for
                        // deletes of non-existing documents (rather than null). This breaks the
                        // test "get deleted doc while offline with source=cache" as NoDocuments
                        // with version 0 are filtered by IndexedDb's RemoteDocumentCache.
                        // TODO(#2149): Remove this when Emulator is fixed
                        n = Ve(e));
                        var r = null;
                        return t.transformResults && t.transformResults.length > 0 && (r = t.transformResults), 
                        new En(n, r);
                    }(t, e);
                }))) : [];
            }(t.writeResults, t.commitTime), n = Ve(t.commitTime);
            return this.listener.Du(n, e);
        }
        // The first response is always the handshake response
                return k(!t.writeResults || 0 === t.writeResults.length), this.bu = !0, 
        this.listener.Cu();
    }, 
    /**
     * Sends an initial streamToken to the server, performing the handshake
     * required to make the StreamingWrite RPC work. Subsequent
     * calls should wait until onHandshakeComplete was called.
     */
    n.prototype.Nu = function() {
        // TODO(dimond): Support stream resumption. We intentionally do not set the
        // stream token on the handshake, ignoring any stream token we might have.
        var t = {};
        t.database = Ge(this.serializer), this.du(t);
    }, 
    /** Sends a group of mutations to the Firestore backend to apply. */ n.prototype.Su = function(t) {
        var e = this, n = {
            streamToken: this.lastStreamToken,
            writes: t.map((function(t) {
                return Ke(e.serializer, t);
            }))
        };
        this.du(n);
    }, n;
}(Ho), Xo = /** @class */ function(e) {
    function n(t, n, r) {
        var i = this;
        return (i = e.call(this) || this).credentials = t, i.iu = n, i.serializer = r, i.Fu = !1, 
        i;
    }
    return t(n, e), n.prototype.xu = function() {
        if (this.Fu) throw new I(b.FAILED_PRECONDITION, "The client has already been terminated.");
    }, 
    /** Gets an auth token and invokes the provided RPC. */ n.prototype.$u = function(t, e, n) {
        var r = this;
        return this.xu(), this.credentials.getToken().then((function(i) {
            return r.iu.$u(t, e, n, i);
        })).catch((function(t) {
            throw t.code === b.UNAUTHENTICATED && r.credentials.zc(), t;
        }));
    }, 
    /** Gets an auth token and invokes the provided RPC with streamed results. */ n.prototype.ku = function(t, e, n) {
        var r = this;
        return this.xu(), this.credentials.getToken().then((function(i) {
            return r.iu.ku(t, e, n, i);
        })).catch((function(t) {
            throw t.code === b.UNAUTHENTICATED && r.credentials.zc(), t;
        }));
    }, n.prototype.terminate = function() {
        this.Fu = !1;
    }, n;
}((function() {})), Jo = /** @class */ function() {
    function t(t, e) {
        this.cs = t, this.di = e, 
        /** The current OnlineState. */
        this.state = "Unknown" /* Unknown */ , 
        /**
             * A count of consecutive failures to open the stream. If it reaches the
             * maximum defined by MAX_WATCH_STREAM_FAILURES, we'll set the OnlineState to
             * Offline.
             */
        this.Mu = 0, 
        /**
             * A timer that elapses after ONLINE_STATE_TIMEOUT_MS, at which point we
             * transition from OnlineState.Unknown to OnlineState.Offline without waiting
             * for the stream to actually fail (MAX_WATCH_STREAM_FAILURES times).
             */
        this.Ou = null, 
        /**
             * Whether the client should log a warning message if it fails to connect to
             * the backend (initially true, cleared after a successful stream, or if we've
             * logged the message already).
             */
        this.Lu = !0
        /**
     * Called by RemoteStore when a watch stream is started (including on each
     * backoff attempt).
     *
     * If this is the first attempt, it sets the OnlineState to Unknown and starts
     * the onlineStateTimer.
     */;
    }
    return t.prototype.Bu = function() {
        var t = this;
        0 === this.Mu && (this.qu("Unknown" /* Unknown */), this.Ou = this.cs.yn("online_state_timeout" /* OnlineStateTimeout */ , 1e4, (function() {
            return t.Ou = null, t.Uu("Backend didn't respond within 10 seconds."), t.qu("Offline" /* Offline */), 
            Promise.resolve();
        })));
    }, 
    /**
     * Updates our OnlineState as appropriate after the watch stream reports a
     * failure. The first failure moves us to the 'Unknown' state. We then may
     * allow multiple failures (based on MAX_WATCH_STREAM_FAILURES) before we
     * actually transition to the 'Offline' state.
     */
    t.prototype.Qu = function(t) {
        "Online" /* Online */ === this.state ? this.qu("Unknown" /* Unknown */) : (this.Mu++, 
        this.Mu >= 1 && (this.Wu(), this.Uu("Connection failed 1 times. Most recent error: " + t.toString()), 
        this.qu("Offline" /* Offline */)));
    }, 
    /**
     * Explicitly sets the OnlineState to the specified state.
     *
     * Note that this resets our timers / failure counters, etc. used by our
     * Offline heuristics, so must not be used in place of
     * handleWatchStreamStart() and handleWatchStreamFailure().
     */
    t.prototype.set = function(t) {
        this.Wu(), this.Mu = 0, "Online" /* Online */ === t && (
        // We've connected to watch at least once. Don't warn the developer
        // about being offline going forward.
        this.Lu = !1), this.qu(t);
    }, t.prototype.qu = function(t) {
        t !== this.state && (this.state = t, this.di(t));
    }, t.prototype.Uu = function(t) {
        var e = "Could not reach Cloud Firestore backend. " + t + "\nThis typically indicates that your device does not have a healthy Internet connection at the moment. The client will operate in offline mode until it is able to successfully connect to the backend.";
        this.Lu ? (N(e), this.Lu = !1) : T("OnlineStateTracker", e);
    }, t.prototype.Wu = function() {
        null !== this.Ou && (this.Ou.cancel(), this.Ou = null);
    }, t;
}(), Zo = function(
/**
     * The local store, used to fill the write pipeline with outbound mutations.
     */
t, 
/** The client-side proxy for interacting with the backend. */
r, i, o, s) {
    var u = this;
    this.ju = t, this.Ku = r, this.cs = i, this.Gu = {}, 
    /**
             * A list of up to MAX_PENDING_WRITES writes that we have fetched from the
             * LocalStore via fillWritePipeline() and have or will send to the write
             * stream.
             *
             * Whenever writePipeline.length > 0 the RemoteStore will attempt to start or
             * restart the write stream. When the stream is established the writes in the
             * pipeline will be sent in order.
             *
             * Writes remain in writePipeline until they are acknowledged by the backend
             * and thus will automatically be re-sent if the stream is interrupted /
             * restarted before they're acknowledged.
             *
             * Write responses from the backend are linked to their originating request
             * purely based on order, and so we can just shift() writes from the front of
             * the writePipeline as we receive responses.
             */
    this.zu = [], 
    /**
             * A mapping of watched targets that the client cares about tracking and the
             * user has explicitly called a 'listen' for this target.
             *
             * These targets may or may not have been sent to or acknowledged by the
             * server. On re-establishing the listen stream, these targets should be sent
             * to the server. The targets removed with unlistens are removed eagerly
             * without waiting for confirmation from the listen stream.
             */
    this.Hu = new Map, 
    /**
             * A set of reasons for why the RemoteStore may be offline. If empty, the
             * RemoteStore may start its network connections.
             */
    this.Yu = new Set, 
    /**
             * Event handlers that get called when the network is disabled or enabled.
             *
             * PORTING NOTE: These functions are used on the Web client to create the
             * underlying streams (to support tree-shakeable streams). On Android and iOS,
             * the streams are created during construction of RemoteStore.
             */
    this.Ju = [], this.Xu = s, this.Xu.Zu((function(t) {
        i.ws((function() {
            return e(u, void 0, void 0, (function() {
                return n(this, (function(t) {
                    switch (t.label) {
                      case 0:
                        return cs(this) ? (T("RemoteStore", "Restarting streams for network reachability change."), 
                        [ 4 /*yield*/ , function(t) {
                            return e(this, void 0, void 0, (function() {
                                var e;
                                return n(this, (function(n) {
                                    switch (n.label) {
                                      case 0:
                                        return (e = x(t)).Yu.add(4 /* ConnectivityChange */), [ 4 /*yield*/ , es(e) ];

                                      case 1:
                                        return n.sent(), e.th.set("Unknown" /* Unknown */), e.Yu.delete(4 /* ConnectivityChange */), 
                                        [ 4 /*yield*/ , ts(e) ];

                                      case 2:
                                        return n.sent(), [ 2 /*return*/ ];
                                    }
                                }));
                            }));
                        }(this) ]) : [ 3 /*break*/ , 2 ];

                      case 1:
                        t.sent(), t.label = 2;

                      case 2:
                        return [ 2 /*return*/ ];
                    }
                }));
            }));
        }));
    })), this.th = new Jo(i, o);
};

function ts(t) {
    return e(this, void 0, void 0, (function() {
        var e, r;
        return n(this, (function(n) {
            switch (n.label) {
              case 0:
                if (!cs(t)) return [ 3 /*break*/ , 4 ];
                e = 0, r = t.Ju, n.label = 1;

              case 1:
                return e < r.length ? [ 4 /*yield*/ , (0, r[e])(/* enabled= */ !0) ] : [ 3 /*break*/ , 4 ];

              case 2:
                n.sent(), n.label = 3;

              case 3:
                return e++, [ 3 /*break*/ , 1 ];

              case 4:
                return [ 2 /*return*/ ];
            }
        }));
    }));
}

/**
 * Temporarily disables the network. The network can be re-enabled using
 * enableNetwork().
 */ function es(t) {
    return e(this, void 0, void 0, (function() {
        var e, r;
        return n(this, (function(n) {
            switch (n.label) {
              case 0:
                e = 0, r = t.Ju, n.label = 1;

              case 1:
                return e < r.length ? [ 4 /*yield*/ , (0, r[e])(/* enabled= */ !1) ] : [ 3 /*break*/ , 4 ];

              case 2:
                n.sent(), n.label = 3;

              case 3:
                return e++, [ 3 /*break*/ , 1 ];

              case 4:
                return [ 2 /*return*/ ];
            }
        }));
    }));
}

function ns(t) {
    return e(this, void 0, void 0, (function() {
        var e;
        return n(this, (function(n) {
            switch (n.label) {
              case 0:
                return e = x(t), T("RemoteStore", "RemoteStore shutting down."), e.Yu.add(5 /* Shutdown */), 
                [ 4 /*yield*/ , es(e) ];

              case 1:
                return n.sent(), e.Xu.Di(), 
                // Set the OnlineState to Unknown (rather than Offline) to avoid potentially
                // triggering spurious listener events with cached data, etc.
                e.th.set("Unknown" /* Unknown */), [ 2 /*return*/ ];
            }
        }));
    }));
}

/**
 * Starts new listen for the given target. Uses resume token if provided. It
 * is a no-op if the target of given `TargetData` is already being listened to.
 */ function rs(t, e) {
    var n = x(t);
    n.Hu.has(e.targetId) || (
    // Mark this as something the client is currently listening for.
    n.Hu.set(e.targetId, e), as(n) ? 
    // The listen will be sent in onWatchStreamOpen
    us(n) : Ts(n).uu() && os(n, e));
}

/**
 * Removes the listen from server. It is a no-op if the given target id is
 * not being listened to.
 */ function is(t, e) {
    var n = x(t), r = Ts(n);
    n.Hu.delete(e), r.uu() && ss(n, e), 0 === n.Hu.size && (r.uu() ? r._u() : cs(n) && 
    // Revert to OnlineState.Unknown if the watch stream is not open and we
    // have no listeners, since without any listens to send we cannot
    // confirm if the stream is healthy and upgrade to OnlineState.Online.
    n.th.set("Unknown" /* Unknown */));
}

/**
 * We need to increment the the expected number of pending responses we're due
 * from watch so we wait for the ack to process any messages from this target.
 */ function os(t, e) {
    t.eh.Ie(e.targetId), Ts(t).Vu(e)
    /**
 * We need to increment the expected number of pending responses we're due
 * from watch so we wait for the removal on the server before we process any
 * messages from this target.
 */;
}

function ss(t, e) {
    t.eh.Ie(e), Ts(t).pu(e);
}

function us(t) {
    t.eh = new re({
        qe: function(e) {
            return t.Gu.qe(e);
        },
        Ue: function(e) {
            return t.Hu.get(e) || null;
        }
    }), Ts(t).start(), t.th.Bu()
    /**
 * Returns whether the watch stream should be started because it's necessary
 * and has not yet been started.
 */;
}

function as(t) {
    return cs(t) && !Ts(t).cu() && t.Hu.size > 0;
}

function cs(t) {
    return 0 === x(t).Yu.size;
}

function hs(t) {
    t.eh = void 0;
}

function fs(t) {
    return e(this, void 0, void 0, (function() {
        return n(this, (function(e) {
            return t.Hu.forEach((function(e, n) {
                os(t, e);
            })), [ 2 /*return*/ ];
        }));
    }));
}

function ls(t, r) {
    return e(this, void 0, void 0, (function() {
        return n(this, (function(e) {
            return hs(t), 
            // If we still need the watch stream, retry the connection.
            as(t) ? (t.th.Qu(r), us(t)) : 
            // No need to restart watch stream because there are no active targets.
            // The online state is set to unknown because there is no active attempt
            // at establishing a connection
            t.th.set("Unknown" /* Unknown */), [ 2 /*return*/ ];
        }));
    }));
}

function ps(t, r, i) {
    return e(this, void 0, void 0, (function() {
        var o, s, u;
        return n(this, (function(a) {
            switch (a.label) {
              case 0:
                if (t.th.set("Online" /* Online */), !(r instanceof ee && 2 /* Removed */ === r.state && r.cause)) 
                // Mark the client as online since we got a message from the server
                return [ 3 /*break*/ , 6 ];
                a.label = 1;

              case 1:
                return a.trys.push([ 1, 3, , 5 ]), [ 4 /*yield*/ , 
                /** Handles an error on a target */
                function(t, r) {
                    return e(this, void 0, void 0, (function() {
                        var e, i, o, s;
                        return n(this, (function(n) {
                            switch (n.label) {
                              case 0:
                                e = r.cause, i = 0, o = r.targetIds, n.label = 1;

                              case 1:
                                return i < o.length ? (s = o[i], t.Hu.has(s) ? [ 4 /*yield*/ , t.Gu.nh(s, e) ] : [ 3 /*break*/ , 3 ]) : [ 3 /*break*/ , 5 ];

                              case 2:
                                n.sent(), t.Hu.delete(s), t.eh.removeTarget(s), n.label = 3;

                              case 3:
                                n.label = 4;

                              case 4:
                                return i++, [ 3 /*break*/ , 1 ];

                              case 5:
                                return [ 2 /*return*/ ];
                            }
                        }));
                    }));
                }(t, r) ];

              case 2:
                return a.sent(), [ 3 /*break*/ , 5 ];

              case 3:
                return o = a.sent(), T("RemoteStore", "Failed to remove targets %s: %s ", r.targetIds.join(","), o), 
                [ 4 /*yield*/ , ds(t, o) ];

              case 4:
                return a.sent(), [ 3 /*break*/ , 5 ];

              case 5:
                return [ 3 /*break*/ , 13 ];

              case 6:
                if (r instanceof Zt ? t.eh.be(r) : r instanceof te ? t.eh.$e(r) : t.eh.De(r), i.isEqual(gt.min())) return [ 3 /*break*/ , 13 ];
                a.label = 7;

              case 7:
                return a.trys.push([ 7, 11, , 13 ]), [ 4 /*yield*/ , Lo(t.ju) ];

              case 8:
                return s = a.sent(), i.L(s) >= 0 ? [ 4 /*yield*/ , 
                /**
                 * Takes a batch of changes from the Datastore, repackages them as a
                 * RemoteEvent, and passes that on to the listener, which is typically the
                 * SyncEngine.
                 */
                function(t, e) {
                    var n = t.eh.Oe(e);
                    // Update in-memory resume tokens. LocalStore will update the
                    // persistent view of these when applying the completed RemoteEvent.
                                        return n.zt.forEach((function(n, r) {
                        if (n.resumeToken.O() > 0) {
                            var i = t.Hu.get(r);
                            // A watched target might have been removed already.
                                                        i && t.Hu.set(r, i.it(n.resumeToken, e));
                        }
                    })), 
                    // Re-establish listens for the targets that have been invalidated by
                    // existence filter mismatches.
                    n.Ht.forEach((function(e) {
                        var n = t.Hu.get(e);
                        if (n) {
                            // Clear the resume token for the target, since we're in a known mismatch
                            // state.
                            t.Hu.set(e, n.it(ct.B, n.nt)), 
                            // Cause a hard reset by unwatching and rewatching immediately, but
                            // deliberately don't send a resume token so that we get a full update.
                            ss(t, e);
                            // Mark the target we send as being on behalf of an existence filter
                            // mismatch, but don't actually retain that in listenTargets. This ensures
                            // that we flag the first re-listen this way without impacting future
                            // listens of this target (that might happen e.g. on reconnect).
                            var r = new kt(n.target, e, 1 /* ExistenceFilterMismatch */ , n.sequenceNumber);
                            os(t, r);
                        }
                    })), t.Gu.sh(n);
                }(t, i) ] : [ 3 /*break*/ , 10 ];

                // We have received a target change with a global snapshot if the snapshot
                // version is not equal to SnapshotVersion.min().
                              case 9:
                // We have received a target change with a global snapshot if the snapshot
                // version is not equal to SnapshotVersion.min().
                a.sent(), a.label = 10;

              case 10:
                return [ 3 /*break*/ , 13 ];

              case 11:
                return T("RemoteStore", "Failed to raise snapshot:", u = a.sent()), [ 4 /*yield*/ , ds(t, u) ];

              case 12:
                return a.sent(), [ 3 /*break*/ , 13 ];

              case 13:
                return [ 2 /*return*/ ];
            }
        }));
    }));
}

/**
 * Recovery logic for IndexedDB errors that takes the network offline until
 * `op` succeeds. Retries are scheduled with backoff using
 * `enqueueRetryable()`. If `op()` is not provided, IndexedDB access is
 * validated via a generic operation.
 *
 * The returned Promise is resolved once the network is disabled and before
 * any retry attempt.
 */ function ds(t, r, i) {
    return e(this, void 0, void 0, (function() {
        var o = this;
        return n(this, (function(s) {
            switch (s.label) {
              case 0:
                if (!Rr(r)) throw r;
                // Disable network and raise offline snapshots
                return t.Yu.add(1 /* IndexedDbFailed */), [ 4 /*yield*/ , es(t) ];

              case 1:
                // Disable network and raise offline snapshots
                return s.sent(), t.th.set("Offline" /* Offline */), i || (
                // Use a simple read operation to determine if IndexedDB recovered.
                // Ideally, we would expose a health check directly on SimpleDb, but
                // RemoteStore only has access to persistence through LocalStore.
                i = function() {
                    return Lo(t.ju);
                }), 
                // Probe IndexedDB periodically and re-enable network
                t.cs.Cs((function() {
                    return e(o, void 0, void 0, (function() {
                        return n(this, (function(e) {
                            switch (e.label) {
                              case 0:
                                return T("RemoteStore", "Retrying IndexedDB access"), [ 4 /*yield*/ , i() ];

                              case 1:
                                return e.sent(), t.Yu.delete(1 /* IndexedDbFailed */), [ 4 /*yield*/ , ts(t) ];

                              case 2:
                                return e.sent(), [ 2 /*return*/ ];
                            }
                        }));
                    }));
                })), [ 2 /*return*/ ];
            }
        }));
    }));
}

/**
 * Executes `op`. If `op` fails, takes the network offline until `op`
 * succeeds. Returns after the first attempt.
 */ function vs(t, e) {
    return e().catch((function(n) {
        return ds(t, n, e);
    }));
}

function ys(t) {
    return e(this, void 0, void 0, (function() {
        var e, r, i, o, s;
        return n(this, (function(n) {
            switch (n.label) {
              case 0:
                e = x(t), r = Ns(e), i = e.zu.length > 0 ? e.zu[e.zu.length - 1].batchId : -1, n.label = 1;

              case 1:
                if (!
                /**
 * Returns true if we can add to the write pipeline (i.e. the network is
 * enabled and the write pipeline is not full).
 */
                function(t) {
                    return cs(t) && t.zu.length < 10;
                }
                /**
 * Queues additional writes to be sent to the write stream, sending them
 * immediately if the write stream is established.
 */ (e)) return [ 3 /*break*/ , 7 ];
                n.label = 2;

              case 2:
                return n.trys.push([ 2, 4, , 6 ]), [ 4 /*yield*/ , Oo(e.ju, i) ];

              case 3:
                return null === (o = n.sent()) ? (0 === e.zu.length && r._u(), [ 3 /*break*/ , 7 ]) : (i = o.batchId, 
                function(t, e) {
                    t.zu.push(e);
                    var n = Ns(t);
                    n.uu() && n.vu && n.Su(e.mutations);
                }(e, o), [ 3 /*break*/ , 6 ]);

              case 4:
                return s = n.sent(), [ 4 /*yield*/ , ds(e, s) ];

              case 5:
                return n.sent(), [ 3 /*break*/ , 6 ];

              case 6:
                return [ 3 /*break*/ , 1 ];

              case 7:
                return ms(e) && gs(e), [ 2 /*return*/ ];
            }
        }));
    }));
}

function ms(t) {
    return cs(t) && !Ns(t).cu() && t.zu.length > 0;
}

function gs(t) {
    Ns(t).start();
}

function ws(t) {
    return e(this, void 0, void 0, (function() {
        return n(this, (function(e) {
            return Ns(t).Nu(), [ 2 /*return*/ ];
        }));
    }));
}

function bs(t) {
    return e(this, void 0, void 0, (function() {
        var e, r, i, o;
        return n(this, (function(n) {
            // Send the write pipeline now that the stream is established.
            for (e = Ns(t), r = 0, i = t.zu; r < i.length; r++) o = i[r], e.Su(o.mutations);
            return [ 2 /*return*/ ];
        }));
    }));
}

function Is(t, r, i) {
    return e(this, void 0, void 0, (function() {
        var e, o;
        return n(this, (function(n) {
            switch (n.label) {
              case 0:
                return e = t.zu.shift(), o = hi.from(e, r, i), [ 4 /*yield*/ , vs(t, (function() {
                    return t.Gu.ih(o);
                })) ];

              case 1:
                // It's possible that with the completion of this mutation another
                // slot has freed up.
                return n.sent(), [ 4 /*yield*/ , ys(t) ];

              case 2:
                // It's possible that with the completion of this mutation another
                // slot has freed up.
                return n.sent(), [ 2 /*return*/ ];
            }
        }));
    }));
}

function Es(t, r) {
    return e(this, void 0, void 0, (function() {
        return n(this, (function(i) {
            switch (i.label) {
              case 0:
                return r && Ns(t).vu ? [ 4 /*yield*/ , function(t, r) {
                    return e(this, void 0, void 0, (function() {
                        var e, i;
                        return n(this, (function(n) {
                            switch (n.label) {
                              case 0:
                                return Lt(i = r.code) && i !== b.ABORTED ? (e = t.zu.shift(), 
                                // In this case it's also unlikely that the server itself is melting
                                // down -- this was just a bad request so inhibit backoff on the next
                                // restart.
                                Ns(t).lu(), [ 4 /*yield*/ , vs(t, (function() {
                                    return t.Gu.rh(e.batchId, r);
                                })) ]) : [ 3 /*break*/ , 3 ];

                              case 1:
                                // It's possible that with the completion of this mutation
                                // another slot has freed up.
                                return n.sent(), [ 4 /*yield*/ , ys(t) ];

                              case 2:
                                // In this case it's also unlikely that the server itself is melting
                                // down -- this was just a bad request so inhibit backoff on the next
                                // restart.
                                // It's possible that with the completion of this mutation
                                // another slot has freed up.
                                n.sent(), n.label = 3;

                              case 3:
                                return [ 2 /*return*/ ];
                            }
                        }));
                    }));
                }(t, r) ] : [ 3 /*break*/ , 2 ];

                // This error affects the actual write.
                              case 1:
                // This error affects the actual write.
                i.sent(), i.label = 2;

              case 2:
                // If the write stream closed after the write handshake completes, a write
                // operation failed and we fail the pending operation.
                // The write stream might have been started by refilling the write
                // pipeline for failed writes
                return ms(t) && gs(t), [ 2 /*return*/ ];
            }
        }));
    }));
}

/**
 * Toggles the network state when the client gains or loses its primary lease.
 */ function _s(t, r) {
    return e(this, void 0, void 0, (function() {
        var e, i;
        return n(this, (function(n) {
            switch (n.label) {
              case 0:
                return e = x(t), r ? (e.Yu.delete(2 /* IsSecondary */), [ 4 /*yield*/ , ts(e) ]) : [ 3 /*break*/ , 2 ];

              case 1:
                return n.sent(), [ 3 /*break*/ , 5 ];

              case 2:
                return (i = r) ? [ 3 /*break*/ , 4 ] : (e.Yu.add(2 /* IsSecondary */), [ 4 /*yield*/ , es(e) ]);

              case 3:
                n.sent(), i = e.th.set("Unknown" /* Unknown */), n.label = 4;

              case 4:
                i, n.label = 5;

              case 5:
                return [ 2 /*return*/ ];
            }
        }));
    }));
}

/**
 * If not yet initialized, registers the WatchStream and its network state
 * callback with `remoteStoreImpl`. Returns the existing stream if one is
 * already available.
 *
 * PORTING NOTE: On iOS and Android, the WatchStream gets registered on startup.
 * This is not done on Web to allow it to be tree-shaken.
 */ function Ts(t) {
    var r = this;
    return t.oh || (
    // Create stream (but note that it is not started yet).
    t.oh = function(t, e, n) {
        var r = x(t);
        return r.xu(), new Yo(e, r.iu, r.credentials, r.serializer, n);
    }(t.Ku, t.cs, {
        gu: fs.bind(null, t),
        Tu: ls.bind(null, t),
        yu: ps.bind(null, t)
    }), t.Ju.push((function(i) {
        return e(r, void 0, void 0, (function() {
            return n(this, (function(e) {
                switch (e.label) {
                  case 0:
                    return i ? (t.oh.lu(), as(t) ? us(t) : t.th.set("Unknown" /* Unknown */), [ 3 /*break*/ , 3 ]) : [ 3 /*break*/ , 1 ];

                  case 1:
                    return [ 4 /*yield*/ , t.oh.stop() ];

                  case 2:
                    e.sent(), hs(t), e.label = 3;

                  case 3:
                    return [ 2 /*return*/ ];
                }
            }));
        }));
    }))), t.oh
    /**
 * If not yet initialized, registers the WriteStream and its network state
 * callback with `remoteStoreImpl`. Returns the existing stream if one is
 * already available.
 *
 * PORTING NOTE: On iOS and Android, the WriteStream gets registered on startup.
 * This is not done on Web to allow it to be tree-shaken.
 */;
}

function Ns(t) {
    var r = this;
    return t.ah || (
    // Create stream (but note that it is not started yet).
    t.ah = function(t, e, n) {
        var r = x(t);
        return r.xu(), new $o(e, r.iu, r.credentials, r.serializer, n);
    }(t.Ku, t.cs, {
        gu: ws.bind(null, t),
        Tu: Es.bind(null, t),
        Cu: bs.bind(null, t),
        Du: Is.bind(null, t)
    }), t.Ju.push((function(i) {
        return e(r, void 0, void 0, (function() {
            return n(this, (function(e) {
                switch (e.label) {
                  case 0:
                    return i ? (t.ah.lu(), [ 4 /*yield*/ , ys(t) ]) : [ 3 /*break*/ , 2 ];

                  case 1:
                    // This will start the write stream if necessary.
                    return e.sent(), [ 3 /*break*/ , 4 ];

                  case 2:
                    return [ 4 /*yield*/ , t.ah.stop() ];

                  case 3:
                    e.sent(), t.zu.length > 0 && (T("RemoteStore", "Stopping write stream with " + t.zu.length + " pending writes"), 
                    t.zu = []), e.label = 4;

                  case 4:
                    return [ 2 /*return*/ ];
                }
            }));
        }));
    }))), t.ah
    /**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */;
}

var As = function(t) {
    this.key = t;
}, Ss = function(t) {
    this.key = t;
}, Ds = /** @class */ function() {
    function t(t, 
    /** Documents included in the remote target */
    e) {
        this.query = t, this.uh = e, this.hh = null, 
        /**
             * A flag whether the view is current with the backend. A view is considered
             * current after it has seen the current flag from the backend and did not
             * lose consistency within the watch stream (e.g. because of an existence
             * filter mismatch).
             */
        this.te = !1, 
        /** Documents in the view but not in the remote target */
        this.lh = Kt(), 
        /** Document Keys that have local changes */
        this.Wt = Kt(), this._h = cr(t), this.fh = new Ht(this._h);
    }
    return Object.defineProperty(t.prototype, "dh", {
        /**
         * The set of remote documents that the server has told us belongs to the target associated with
         * this view.
         */
        get: function() {
            return this.uh;
        },
        enumerable: !1,
        configurable: !0
    }), 
    /**
     * Iterates over a set of doc changes, applies the query limit, and computes
     * what the new results should be, what the changes were, and whether we may
     * need to go back to the local cache for more results. Does not make any
     * changes to the view.
     * @param docChanges The doc changes to apply to this view.
     * @param previousChanges If this is being called with a refill, then start
     *        with this set of docs and changes instead of the current view.
     * @return a new set of docs, changes, and refill flag.
     */
    t.prototype.wh = function(t, e) {
        var n = this, r = e ? e.mh : new Yt, i = e ? e.fh : this.fh, o = e ? e.Wt : this.Wt, s = i, u = !1, a = Yn(this.query) && i.size === this.query.limit ? i.last() : null, c = $n(this.query) && i.size === this.query.limit ? i.first() : null;
        // Drop documents out to meet limit/limitToLast requirement.
        if (t.ht((function(t, e) {
            var h = i.get(t), f = e instanceof zn ? e : null;
            f && (f = ar(n.query, f) ? f : null);
            var l = !!h && n.Wt.has(h.key), p = !!f && (f.Je || 
            // We only consider committed mutations for documents that were
            // mutated during the lifetime of the view.
            n.Wt.has(f.key) && f.hasCommittedMutations), d = !1;
            // Calculate change
            h && f ? h.data().isEqual(f.data()) ? l !== p && (r.track({
                type: 3 /* Metadata */ ,
                doc: f
            }), d = !0) : n.Th(h, f) || (r.track({
                type: 2 /* Modified */ ,
                doc: f
            }), d = !0, (a && n._h(f, a) > 0 || c && n._h(f, c) < 0) && (
            // This doc moved from inside the limit to outside the limit.
            // That means there may be some other doc in the local cache
            // that should be included instead.
            u = !0)) : !h && f ? (r.track({
                type: 0 /* Added */ ,
                doc: f
            }), d = !0) : h && !f && (r.track({
                type: 1 /* Removed */ ,
                doc: h
            }), d = !0, (a || c) && (
            // A doc was removed from a full limit query. We'll need to
            // requery from the local cache to see if we know about some other
            // doc that should be in the results.
            u = !0)), d && (f ? (s = s.add(f), o = p ? o.add(t) : o.delete(t)) : (s = s.delete(t), 
            o = o.delete(t)));
        })), Yn(this.query) || $n(this.query)) for (;s.size > this.query.limit; ) {
            var h = Yn(this.query) ? s.last() : s.first();
            s = s.delete(h.key), o = o.delete(h.key), r.track({
                type: 1 /* Removed */ ,
                doc: h
            });
        }
        return {
            fh: s,
            mh: r,
            Eh: u,
            Wt: o
        };
    }, t.prototype.Th = function(t, e) {
        // We suppress the initial change event for documents that were modified as
        // part of a write acknowledgment (e.g. when the value of a server transform
        // is applied) as Watch will send us the same document again.
        // By suppressing the event, we only raise two user visible events (one with
        // `hasPendingWrites` and the final state of the document) instead of three
        // (one with `hasPendingWrites`, the modified document with
        // `hasPendingWrites` and the final state of the document).
        return t.Je && e.hasCommittedMutations && !e.Je;
    }, 
    /**
     * Updates the view with the given ViewDocumentChanges and optionally updates
     * limbo docs and sync state from the provided target change.
     * @param docChanges The set of changes to make to the view's docs.
     * @param updateLimboDocuments Whether to update limbo documents based on this
     *        change.
     * @param targetChange A target change to apply for computing limbo docs and
     *        sync state.
     * @return A new ViewChange with the given docs, changes, and sync state.
     */
    // PORTING NOTE: The iOS/Android clients always compute limbo document changes.
    t.prototype.yr = function(t, e, n) {
        var r = this, i = this.fh;
        this.fh = t.fh, this.Wt = t.Wt;
        // Sort changes based on type and query comparator
        var o = t.mh.Ut();
        o.sort((function(t, e) {
            return function(t, e) {
                var n = function(t) {
                    switch (t) {
                      case 0 /* Added */ :
                        return 1;

                      case 2 /* Modified */ :
                      case 3 /* Metadata */ :
                        // A metadata change is converted to a modified change at the public
                        // api layer.  Since we sort by document key and then change type,
                        // metadata and modified changes must be sorted equivalently.
                        return 2;

                      case 1 /* Removed */ :
                        return 0;

                      default:
                        return D();
                    }
                };
                return n(t) - n(e);
            }(t.type, e.type) || r._h(t.doc, e.doc);
        })), this.Ih(n);
        var s = e ? this.Ah() : [], u = 0 === this.lh.size && this.te ? 1 /* Synced */ : 0 /* Local */ , a = u !== this.hh;
        return this.hh = u, 0 !== o.length || a ? {
            snapshot: new $t(this.query, t.fh, i, o, t.Wt, 0 /* Local */ === u, a, 
            /* excludesMetadataChanges= */ !1),
            Rh: s
        } : {
            Rh: s
        };
        // no changes
        }, 
    /**
     * Applies an OnlineState change to the view, potentially generating a
     * ViewChange if the view's syncState changes as a result.
     */
    t.prototype.Qs = function(t) {
        return this.te && "Offline" /* Offline */ === t ? (
        // If we're offline, set `current` to false and then call applyChanges()
        // to refresh our syncState and generate a ViewChange as appropriate. We
        // are guaranteed to get a new TargetChange that sets `current` back to
        // true once the client is back online.
        this.te = !1, this.yr({
            fh: this.fh,
            mh: new Yt,
            Wt: this.Wt,
            Eh: !1
        }, 
        /* updateLimboDocuments= */ !1)) : {
            Rh: []
        };
    }, 
    /**
     * Returns whether the doc for the given key should be in limbo.
     */
    t.prototype.gh = function(t) {
        // If the remote end says it's part of this query, it's not in limbo.
        return !this.uh.has(t) && 
        // The local store doesn't think it's a result, so it shouldn't be in limbo.
        !!this.fh.has(t) && !this.fh.get(t).Je;
    }, 
    /**
     * Updates syncedDocuments, current, and limbo docs based on the given change.
     * Returns the list of changes to which docs are in limbo.
     */
    t.prototype.Ih = function(t) {
        var e = this;
        t && (t.ee.forEach((function(t) {
            return e.uh = e.uh.add(t);
        })), t.ne.forEach((function(t) {})), t.se.forEach((function(t) {
            return e.uh = e.uh.delete(t);
        })), this.te = t.te);
    }, t.prototype.Ah = function() {
        var t = this;
        // We can only determine limbo documents when we're in-sync with the server.
                if (!this.te) return [];
        // TODO(klimt): Do this incrementally so that it's not quadratic when
        // updating many documents.
                var e = this.lh;
        this.lh = Kt(), this.fh.forEach((function(e) {
            t.gh(e.key) && (t.lh = t.lh.add(e.key));
        }));
        // Diff the new limbo docs with the old limbo docs.
        var n = [];
        return e.forEach((function(e) {
            t.lh.has(e) || n.push(new Ss(e));
        })), this.lh.forEach((function(t) {
            e.has(t) || n.push(new As(t));
        })), n;
    }, 
    /**
     * Update the in-memory state of the current view with the state read from
     * persistence.
     *
     * We update the query view whenever a client's primary status changes:
     * - When a client transitions from primary to secondary, it can miss
     *   LocalStorage updates and its query views may temporarily not be
     *   synchronized with the state on disk.
     * - For secondary to primary transitions, the client needs to update the list
     *   of `syncedDocuments` since secondary clients update their query views
     *   based purely on synthesized RemoteEvents.
     *
     * @param queryResult.documents - The documents that match the query according
     * to the LocalStore.
     * @param queryResult.remoteKeys - The keys of the documents that match the
     * query according to the backend.
     *
     * @return The ViewChange that resulted from this synchronization.
     */
    // PORTING NOTE: Multi-tab only.
    t.prototype.Ph = function(t) {
        this.uh = t.Fc, this.lh = Kt();
        var e = this.wh(t.documents);
        return this.yr(e, /*updateLimboDocuments=*/ !0);
    }, 
    /**
     * Returns a view snapshot as if this query was just listened to. Contains
     * a document add for every existing document and the `fromCache` and
     * `hasPendingWrites` status of the already established view.
     */
    // PORTING NOTE: Multi-tab only.
    t.prototype.yh = function() {
        return $t.Gt(this.query, this.fh, this.Wt, 0 /* Local */ === this.hh);
    }, t;
}(), ks = function(
/**
     * The query itself.
     */
t, 
/**
     * The target number created by the client that is used in the watch
     * stream to identify this query.
     */
e, 
/**
     * The view is responsible for computing the final merged truth of what
     * docs are in the query. It gets notified of local and remote changes,
     * and applies the query filters and limits to determine the most correct
     * possible results.
     */
n) {
    this.query = t, this.targetId = e, this.view = n;
}, xs = function(t) {
    this.key = t, 
    /**
             * Set to true once we've received a document. This is used in
             * getRemoteKeysForTarget() and ultimately used by WatchChangeAggregator to
             * decide whether it needs to manufacture a delete event for the target once
             * the target is CURRENT.
             */
    this.Vh = !1;
}, Ls = /** @class */ function() {
    function t(t, e, n, 
    // PORTING NOTE: Manages state synchronization in multi-tab environments.
    r, i, o) {
        this.ju = t, this.ph = e, this.bh = n, this.Sh = r, this.currentUser = i, this.Dh = o, 
        this.Ch = {}, this.Nh = new yt((function(t) {
            return sr(t);
        }), or), this.Fh = new Map, 
        /**
             * The keys of documents that are in limbo for which we haven't yet started a
             * limbo resolution query.
             */
        this.xh = [], 
        /**
             * Keeps track of the target ID for each document that is in limbo with an
             * active target.
             */
        this.$h = new Ot(F.i), 
        /**
             * Keeps track of the information about an active limbo resolution for each
             * active target ID that was started for the purpose of limbo resolution.
             */
        this.kh = new Map, this.Mh = new jo, 
        /** Stores user completion handlers, indexed by User and BatchId. */
        this.Oh = {}, 
        /** Stores user callbacks waiting for all pending writes to be acknowledged. */
        this.Lh = new Map, this.Bh = yo.da(), this.onlineState = "Unknown" /* Unknown */ , 
        // The primary state is set to `true` or `false` immediately after Firestore
        // startup. In the interim, a client should only be considered primary if
        // `isPrimary` is true.
        this.qh = void 0;
    }
    return Object.defineProperty(t.prototype, "Uh", {
        get: function() {
            return !0 === this.qh;
        },
        enumerable: !1,
        configurable: !0
    }), t;
}();

/**
 * Initiates the new listen, resolves promise when listen enqueued to the
 * server. All the subsequent view snapshots or errors are sent to the
 * subscribed handlers. Returns the initial snapshot.
 */
function Rs(t, r) {
    return e(this, void 0, void 0, (function() {
        var e, i, o, s, u, a;
        return n(this, (function(n) {
            switch (n.label) {
              case 0:
                return e = iu(t), (s = e.Nh.get(r)) ? (
                // PORTING NOTE: With Multi-Tab Web, it is possible that a query view
                // already exists when EventManager calls us for the first time. This
                // happens when the primary tab is already listening to this query on
                // behalf of another tab and the user of the primary also starts listening
                // to the query. EventManager will not have an assigned target ID in this
                // case and calls `listen` to obtain this ID.
                i = s.targetId, e.Sh.Oi(i), o = s.view.yh(), [ 3 /*break*/ , 4 ]) : [ 3 /*break*/ , 1 ];

              case 1:
                return [ 4 /*yield*/ , Po(e.ju, er(r)) ];

              case 2:
                return u = n.sent(), a = e.Sh.Oi(u.targetId), i = u.targetId, [ 4 /*yield*/ , Os(e, r, i, "current" === a) ];

              case 3:
                o = n.sent(), e.Uh && rs(e.ph, u), n.label = 4;

              case 4:
                return [ 2 /*return*/ , o ];
            }
        }));
    }));
}

/**
 * Registers a view for a previously unknown query and computes its initial
 * snapshot.
 */ function Os(t, r, i, o) {
    return e(this, void 0, void 0, (function() {
        var s, u, a, c, h, f;
        return n(this, (function(l) {
            switch (l.label) {
              case 0:
                // PORTING NOTE: On Web only, we inject the code that registers new Limbo
                // targets based on view changes. This allows us to only depend on Limbo
                // changes when user code includes queries.
                return t.Qh = function(r, i, o) {
                    return function(t, r, i, o) {
                        return e(this, void 0, void 0, (function() {
                            var e, s, u;
                            return n(this, (function(n) {
                                switch (n.label) {
                                  case 0:
                                    return e = r.view.wh(i), e.Eh ? [ 4 /*yield*/ , Uo(t.ju, r.query, 
                                    /* usePreviousResults= */ !1).then((function(t) {
                                        var n = t.documents;
                                        return r.view.wh(n, e);
                                    })) ] : [ 3 /*break*/ , 2 ];

                                  case 1:
                                    // The query has a limit and some docs were removed, so we need
                                    // to re-run the query against the local store to make sure we
                                    // didn't lose any good docs that had been past the limit.
                                    e = n.sent(), n.label = 2;

                                  case 2:
                                    return s = o && o.zt.get(r.targetId), u = r.view.yr(e, 
                                    /* updateLimboDocuments= */ t.Uh, s), [ 2 /*return*/ , (Bs(t, r.targetId, u.Rh), 
                                    u.snapshot) ];
                                }
                            }));
                        }));
                    }(t, r, i, o);
                }, [ 4 /*yield*/ , Uo(t.ju, r, 
                /* usePreviousResults= */ !0) ];

              case 1:
                return s = l.sent(), u = new Ds(r, s.Fc), a = u.wh(s.documents), c = Jt.Zt(i, o && "Offline" /* Offline */ !== t.onlineState), 
                h = u.yr(a, 
                /* updateLimboDocuments= */ t.Uh, c), Bs(t, i, h.Rh), f = new ks(r, i, u), [ 2 /*return*/ , (t.Nh.set(r, f), 
                t.Fh.has(i) ? t.Fh.get(i).push(r) : t.Fh.set(i, [ r ]), h.snapshot) ];
            }
        }));
    }));
}

/** Stops listening to the query. */ function Ps(t, r) {
    return e(this, void 0, void 0, (function() {
        var e, i, o;
        return n(this, (function(n) {
            switch (n.label) {
              case 0:
                return e = x(t), i = e.Nh.get(r), (o = e.Fh.get(i.targetId)).length > 1 ? [ 2 /*return*/ , (e.Fh.set(i.targetId, o.filter((function(t) {
                    return !or(t, r);
                }))), void e.Nh.delete(r)) ] : e.Uh ? (
                // We need to remove the local query target first to allow us to verify
                // whether any other client is still interested in this target.
                e.Sh.Bi(i.targetId), e.Sh.Fi(i.targetId) ? [ 3 /*break*/ , 2 ] : [ 4 /*yield*/ , Vo(e.ju, i.targetId, 
                /*keepPersistedTargetData=*/ !1).then((function() {
                    e.Sh.Ui(i.targetId), is(e.ph, i.targetId), Gs(e, i.targetId);
                })).catch(qo) ]) : [ 3 /*break*/ , 3 ];

              case 1:
                n.sent(), n.label = 2;

              case 2:
                return [ 3 /*break*/ , 5 ];

              case 3:
                return Gs(e, i.targetId), [ 4 /*yield*/ , Vo(e.ju, i.targetId, 
                /*keepPersistedTargetData=*/ !0) ];

              case 4:
                n.sent(), n.label = 5;

              case 5:
                return [ 2 /*return*/ ];
            }
        }));
    }));
}

/**
 * Initiates the write of local mutation batch which involves adding the
 * writes to the mutation queue, notifying the remote store about new
 * mutations and raising events for any changes this write caused.
 *
 * The promise returned by this call is resolved when the above steps
 * have completed, *not* when the write was acked by the backend. The
 * userCallback is resolved once the write was acked/rejected by the
 * backend (or failed locally for any other reason).
 */
/**
 * Applies one remote event to the sync engine, notifying any views of the
 * changes, and releasing any pending mutation batches that would become
 * visible because of the snapshot version the remote event contains.
 */
function Vs(t, r) {
    return e(this, void 0, void 0, (function() {
        var e, i;
        return n(this, (function(n) {
            switch (n.label) {
              case 0:
                e = x(t), n.label = 1;

              case 1:
                return n.trys.push([ 1, 4, , 6 ]), [ 4 /*yield*/ , Ro(e.ju, r) ];

              case 2:
                return i = n.sent(), 
                // Update `receivedDocument` as appropriate for any limbo targets.
                r.zt.forEach((function(t, n) {
                    var r = e.kh.get(n);
                    r && (
                    // Since this is a limbo resolution lookup, it's for a single document
                    // and it could be added, modified, or removed, but not a combination.
                    k(t.ee.size + t.ne.size + t.se.size <= 1), t.ee.size > 0 ? r.Vh = !0 : t.ne.size > 0 ? k(r.Vh) : t.se.size > 0 && (k(r.Vh), 
                    r.Vh = !1));
                })), [ 4 /*yield*/ , Qs(e, i, r) ];

              case 3:
                // Update `receivedDocument` as appropriate for any limbo targets.
                return n.sent(), [ 3 /*break*/ , 6 ];

              case 4:
                return [ 4 /*yield*/ , qo(n.sent()) ];

              case 5:
                return n.sent(), [ 3 /*break*/ , 6 ];

              case 6:
                return [ 2 /*return*/ ];
            }
        }));
    }));
}

/**
 * Applies an OnlineState change to the sync engine and notifies any views of
 * the change.
 */ function Us(t, e, n) {
    var r = x(t);
    // If we are the secondary client, we explicitly ignore the remote store's
    // online state (the local client may go offline, even though the primary
    // tab remains online) and only apply the primary tab's online state from
    // SharedClientState.
        if (r.Uh && 0 /* RemoteStore */ === n || !r.Uh && 1 /* SharedClientState */ === n) {
        var i = [];
        r.Nh.forEach((function(t, n) {
            var r = n.view.Qs(e);
            r.snapshot && i.push(r.snapshot);
        })), function(t, e) {
            var n = x(t);
            n.onlineState = e;
            var r = !1;
            n.Bs.forEach((function(t, n) {
                for (var i = 0, o = n.listeners; i < o.length; i++) {
                    // Run global snapshot listeners if a consistent snapshot has been emitted.
                    o[i].Qs(e) && (r = !0);
                }
            })), r && Yr(n);
        }(r.bh, e), i.length && r.Ch.yu(i), r.onlineState = e, r.Uh && r.Sh.Ki(e);
    }
}

/**
 * Rejects the listen for the given targetID. This can be triggered by the
 * backend for any active target.
 *
 * @param syncEngine The sync engine implementation.
 * @param targetId The targetID corresponds to one previously initiated by the
 * user as part of TargetData passed to listen() on RemoteStore.
 * @param err A description of the condition that has forced the rejection.
 * Nearly always this will be an indication that the user is no longer
 * authorized to see the data matching the target.
 */ function Cs(t, r, i) {
    return e(this, void 0, void 0, (function() {
        var e, o, s, u, a, c;
        return n(this, (function(n) {
            switch (n.label) {
              case 0:
                // PORTING NOTE: Multi-tab only.
                return (e = x(t)).Sh.Qi(r, "rejected", i), o = e.kh.get(r), (s = o && o.key) ? (u = (u = new Ot(F.i)).ot(s, new Bn(s, gt.min())), 
                a = Kt().add(s), c = new Xt(gt.min(), 
                /* targetChanges= */ new Map, 
                /* targetMismatches= */ new Ut(st), u, a), [ 4 /*yield*/ , Vs(e, c) ]) : [ 3 /*break*/ , 2 ];

              case 1:
                return n.sent(), 
                // Since this query failed, we won't want to manually unlisten to it.
                // We only remove it from bookkeeping after we successfully applied the
                // RemoteEvent. If `applyRemoteEvent()` throws, we want to re-listen to
                // this query when the RemoteStore restarts the Watch stream, which should
                // re-trigger the target failure.
                e.$h = e.$h.remove(s), e.kh.delete(r), Ws(e), [ 3 /*break*/ , 4 ];

              case 2:
                return [ 4 /*yield*/ , Vo(e.ju, r, 
                /* keepPersistedTargetData */ !1).then((function() {
                    return Gs(e, r, i);
                })).catch(qo) ];

              case 3:
                n.sent(), n.label = 4;

              case 4:
                return [ 2 /*return*/ ];
            }
        }));
    }));
}

function Fs(t, r) {
    return e(this, void 0, void 0, (function() {
        var e, i, o;
        return n(this, (function(n) {
            switch (n.label) {
              case 0:
                e = x(t), i = r.batch.batchId, n.label = 1;

              case 1:
                return n.trys.push([ 1, 4, , 6 ]), [ 4 /*yield*/ , xo(e.ju, r) ];

              case 2:
                return o = n.sent(), 
                // The local store may or may not be able to apply the write result and
                // raise events immediately (depending on whether the watcher is caught
                // up), so we raise user callbacks first so that they consistently happen
                // before listen events.
                js(e, i, /*error=*/ null), qs(e, i), e.Sh.ki(i, "acknowledged"), [ 4 /*yield*/ , Qs(e, o) ];

              case 3:
                // The local store may or may not be able to apply the write result and
                // raise events immediately (depending on whether the watcher is caught
                // up), so we raise user callbacks first so that they consistently happen
                // before listen events.
                return n.sent(), [ 3 /*break*/ , 6 ];

              case 4:
                return [ 4 /*yield*/ , qo(n.sent()) ];

              case 5:
                return n.sent(), [ 3 /*break*/ , 6 ];

              case 6:
                return [ 2 /*return*/ ];
            }
        }));
    }));
}

function Ms(t, r, i) {
    return e(this, void 0, void 0, (function() {
        var e, o;
        return n(this, (function(n) {
            switch (n.label) {
              case 0:
                e = x(t), n.label = 1;

              case 1:
                return n.trys.push([ 1, 4, , 6 ]), [ 4 /*yield*/ , function(t, e) {
                    var n = x(t);
                    return n.persistence.runTransaction("Reject batch", "readwrite-primary", (function(t) {
                        var r;
                        return n.Sr.Oo(t, e).next((function(e) {
                            return k(null !== e), r = e.keys(), n.Sr.Wo(t, e);
                        })).next((function() {
                            return n.Sr.zo(t);
                        })).next((function() {
                            return n.Cc.kr(t, r);
                        }));
                    }));
                }(e.ju, r) ];

              case 2:
                return o = n.sent(), 
                // The local store may or may not be able to apply the write result and
                // raise events immediately (depending on whether the watcher is caught up),
                // so we raise user callbacks first so that they consistently happen before
                // listen events.
                js(e, r, i), qs(e, r), e.Sh.ki(r, "rejected", i), [ 4 /*yield*/ , Qs(e, o) ];

              case 3:
                // The local store may or may not be able to apply the write result and
                // raise events immediately (depending on whether the watcher is caught up),
                // so we raise user callbacks first so that they consistently happen before
                // listen events.
                return n.sent(), [ 3 /*break*/ , 6 ];

              case 4:
                return [ 4 /*yield*/ , qo(n.sent()) ];

              case 5:
                return n.sent(), [ 3 /*break*/ , 6 ];

              case 6:
                return [ 2 /*return*/ ];
            }
        }));
    }));
}

/**
 * Registers a user callback that resolves when all pending mutations at the moment of calling
 * are acknowledged .
 */
/**
 * Triggers the callbacks that are waiting for this batch id to get acknowledged by server,
 * if there are any.
 */
function qs(t, e) {
    (t.Lh.get(e) || []).forEach((function(t) {
        t.resolve();
    })), t.Lh.delete(e)
    /** Reject all outstanding callbacks waiting for pending writes to complete. */;
}

function js(t, e, n) {
    var r = x(t), i = r.Oh[r.currentUser.ti()];
    // NOTE: Mutations restored from persistence won't have callbacks, so it's
    // okay for there to be no callback for this ID.
    if (i) {
        var o = i.get(e);
        o && (n ? o.reject(n) : o.resolve(), i = i.remove(e)), r.Oh[r.currentUser.ti()] = i;
    }
}

function Gs(t, e, n) {
    void 0 === n && (n = null), t.Sh.Bi(e);
    for (var r = 0, i = t.Fh.get(e); r < i.length; r++) {
        var o = i[r];
        t.Nh.delete(o), n && t.Ch.Wh(o, n);
    }
    t.Fh.delete(e), t.Uh && t.Mh.Uc(e).forEach((function(e) {
        t.Mh.Ho(e) || 
        // We removed the last reference for this key
        zs(t, e);
    }));
}

function zs(t, e) {
    // It's possible that the target already got removed because the query failed. In that case,
    // the key won't exist in `limboTargetsByKey`. Only do the cleanup if we still have the target.
    var n = t.$h.get(e);
    null !== n && (is(t.ph, n), t.$h = t.$h.remove(e), t.kh.delete(n), Ws(t));
}

function Bs(t, e, n) {
    for (var r = 0, i = n; r < i.length; r++) {
        var o = i[r];
        o instanceof As ? (t.Mh.Da(o.key, e), Ks(t, o)) : o instanceof Ss ? (T("SyncEngine", "Document no longer in limbo: " + o.key), 
        t.Mh.Na(o.key, e), t.Mh.Ho(o.key) || 
        // We removed the last reference for this key
        zs(t, o.key)) : D();
    }
}

function Ks(t, e) {
    var n = e.key;
    t.$h.get(n) || (T("SyncEngine", "New document in limbo: " + n), t.xh.push(n), Ws(t));
}

/**
 * Starts listens for documents in limbo that are enqueued for resolution,
 * subject to a maximum number of concurrent resolutions.
 *
 * Without bounding the number of concurrent resolutions, the server can fail
 * with "resource exhausted" errors which can lead to pathological client
 * behavior as seen in https://github.com/firebase/firebase-js-sdk/issues/2683.
 */ function Ws(t) {
    for (;t.xh.length > 0 && t.$h.size < t.Dh; ) {
        var e = t.xh.shift(), n = t.Bh.next();
        t.kh.set(n, new xs(e)), t.$h = t.$h.ot(e, n), rs(t.ph, new kt(er(Hn(e.path)), n, 2 /* LimboResolution */ , Jr.ai));
    }
}

function Qs(t, r, i) {
    return e(this, void 0, void 0, (function() {
        var o, s, u, a;
        return n(this, (function(c) {
            switch (c.label) {
              case 0:
                return o = x(t), s = [], u = [], a = [], o.Nh.m() ? [ 3 /*break*/ , 3 ] : (o.Nh.forEach((function(t, e) {
                    a.push(o.Qh(e, r, i).then((function(t) {
                        if (t) {
                            o.Uh && o.Sh.Qi(e.targetId, t.fromCache ? "not-current" : "current"), s.push(t);
                            var n = vi.zr(e.targetId, t);
                            u.push(n);
                        }
                    })));
                })), [ 4 /*yield*/ , Promise.all(a) ]);

              case 1:
                return c.sent(), o.Ch.yu(s), [ 4 /*yield*/ , function(t, r) {
                    return e(this, void 0, void 0, (function() {
                        var e, i, o, s, u, a, c, h, f;
                        return n(this, (function(n) {
                            switch (n.label) {
                              case 0:
                                e = x(t), n.label = 1;

                              case 1:
                                return n.trys.push([ 1, 3, , 4 ]), [ 4 /*yield*/ , e.persistence.runTransaction("notifyLocalViewChanges", "readwrite", (function(t) {
                                    return Dr.forEach(r, (function(n) {
                                        return Dr.forEach(n.Kr, (function(r) {
                                            return e.persistence.No.Da(t, n.targetId, r);
                                        })).next((function() {
                                            return Dr.forEach(n.Gr, (function(r) {
                                                return e.persistence.No.Na(t, n.targetId, r);
                                            }));
                                        }));
                                    }));
                                })) ];

                              case 2:
                                return n.sent(), [ 3 /*break*/ , 4 ];

                              case 3:
                                if (!Rr(i = n.sent())) throw i;
                                // If `notifyLocalViewChanges` fails, we did not advance the sequence
                                // number for the documents that were included in this transaction.
                                // This might trigger them to be deleted earlier than they otherwise
                                // would have, but it should not invalidate the integrity of the data.
                                                                return T("LocalStore", "Failed to update sequence numbers: " + i), 
                                [ 3 /*break*/ , 4 ];

                              case 4:
                                for (o = 0, s = r; o < s.length; o++) u = s[o], a = u.targetId, u.fromCache || (c = e.bc.get(a), 
                                h = c.nt, f = c.rt(h), 
                                // Advance the last limbo free snapshot version
                                e.bc = e.bc.ot(a, f));
                                return [ 2 /*return*/ ];
                            }
                        }));
                    }));
                }(o.ju, u) ];

              case 2:
                c.sent(), c.label = 3;

              case 3:
                return [ 2 /*return*/ ];
            }
        }));
    }));
}

function Hs(t, r) {
    return e(this, void 0, void 0, (function() {
        var i, o;
        return n(this, (function(s) {
            switch (s.label) {
              case 0:
                return (i = x(t)).currentUser.isEqual(r) ? [ 3 /*break*/ , 3 ] : (T("SyncEngine", "User change. New user:", r.ti()), 
                [ 4 /*yield*/ , 
                /**
                 * Tells the LocalStore that the currently authenticated user has changed.
                 *
                 * In response the local store switches the mutation queue to the new user and
                 * returns any resulting document changes.
                 */
                // PORTING NOTE: Android and iOS only return the documents affected by the
                // change.
                function(t, r) {
                    return e(this, void 0, void 0, (function() {
                        var e, i, o, s;
                        return n(this, (function(n) {
                            switch (n.label) {
                              case 0:
                                return e = x(t), i = e.Sr, o = e.Cc, [ 4 /*yield*/ , e.persistence.runTransaction("Handle user change", "readonly", (function(t) {
                                    // Swap out the mutation queue, grabbing the pending mutation batches
                                    // before and after.
                                    var n;
                                    return e.Sr.Uo(t).next((function(s) {
                                        return n = s, i = e.persistence.mc(r), 
                                        // Recreate our LocalDocumentsView using the new
                                        // MutationQueue.
                                        o = new di(e.Dc, i, e.persistence.Ic()), i.Uo(t);
                                    })).next((function(e) {
                                        for (var r = [], i = [], s = Kt(), u = 0, a = n
                                        // Union the old/new changed keys.
                                        ; u < a.length; u++) {
                                            var c = a[u];
                                            r.push(c.batchId);
                                            for (var h = 0, f = c.mutations; h < f.length; h++) {
                                                var l = f[h];
                                                s = s.add(l.key);
                                            }
                                        }
                                        for (var p = 0, d = e; p < d.length; p++) {
                                            var v = d[p];
                                            i.push(v.batchId);
                                            for (var y = 0, m = v.mutations; y < m.length; y++) {
                                                var g = m[y];
                                                s = s.add(g.key);
                                            }
                                        }
                                        // Return the set of all (potentially) changed documents and the list
                                        // of mutation batch IDs that were affected by change.
                                                                                return o.kr(t, s).next((function(t) {
                                            return {
                                                jh: t,
                                                Kh: r,
                                                Gh: i
                                            };
                                        }));
                                    }));
                                })) ];

                              case 1:
                                return s = n.sent(), [ 2 /*return*/ , (e.Sr = i, e.Cc = o, e.Vc.Nc(e.Cc), s) ];
                            }
                        }));
                    }));
                }(i.ju, r) ]);

              case 1:
                return o = s.sent(), i.currentUser = r, 
                // Fails tasks waiting for pending writes requested by previous user.
                function(t, e) {
                    t.Lh.forEach((function(t) {
                        t.forEach((function(t) {
                            t.reject(new I(b.CANCELLED, "'waitForPendingWrites' promise is rejected due to a user change."));
                        }));
                    })), t.Lh.clear();
                }(i), 
                // TODO(b/114226417): Consider calling this only in the primary tab.
                i.Sh.ji(r, o.Kh, o.Gh), [ 4 /*yield*/ , Qs(i, o.jh) ];

              case 2:
                s.sent(), s.label = 3;

              case 3:
                return [ 2 /*return*/ ];
            }
        }));
    }));
}

function Ys(t, e) {
    var n = x(t), r = n.kh.get(e);
    if (r && r.Vh) return Kt().add(r.key);
    var i = Kt(), o = n.Fh.get(e);
    if (!o) return i;
    for (var s = 0, u = o; s < u.length; s++) {
        var a = u[s], c = n.Nh.get(a);
        i = i.kt(c.view.dh);
    }
    return i;
}

/**
 * Reconcile the list of synced documents in an existing view with those
 * from persistence.
 */ function $s(t, r) {
    return e(this, void 0, void 0, (function() {
        var e, i, o;
        return n(this, (function(n) {
            switch (n.label) {
              case 0:
                return [ 4 /*yield*/ , Uo((e = x(t)).ju, r.query, 
                /* usePreviousResults= */ !0) ];

              case 1:
                return i = n.sent(), o = r.view.Ph(i), [ 2 /*return*/ , (e.Uh && Bs(e, r.targetId, o.Rh), 
                o) ];
            }
        }));
    }));
}

/** Applies a mutation state to an existing batch.  */
// PORTING NOTE: Multi-Tab only.
function Xs(t, r, i, o) {
    return e(this, void 0, void 0, (function() {
        var e, s;
        return n(this, (function(n) {
            switch (n.label) {
              case 0:
                return [ 4 /*yield*/ , function(t, e) {
                    var n = x(t), r = x(n.Sr);
                    return n.persistence.runTransaction("Lookup mutation documents", "readonly", (function(t) {
                        return r.Lo(t, e).next((function(e) {
                            return e ? n.Cc.kr(t, e) : Dr.resolve(null);
                        }));
                    }));
                }((e = x(t)).ju, r) ];

              case 1:
                return null === (s = n.sent()) ? [ 3 /*break*/ , 6 ] : "pending" !== i ? [ 3 /*break*/ , 3 ] : [ 4 /*yield*/ , ys(e.ph) ];

              case 2:
                // If we are the primary client, we need to send this write to the
                // backend. Secondary clients will ignore these writes since their remote
                // connection is disabled.
                return n.sent(), [ 3 /*break*/ , 4 ];

              case 3:
                "acknowledged" === i || "rejected" === i ? (
                // NOTE: Both these methods are no-ops for batches that originated from
                // other clients.
                js(e, r, o || null), qs(e, r), function(t, e) {
                    x(x(t).Sr).Ko(e);
                }(e.ju, r)) : D(), n.label = 4;

              case 4:
                return [ 4 /*yield*/ , Qs(e, s) ];

              case 5:
                return n.sent(), [ 3 /*break*/ , 7 ];

              case 6:
                // A throttled tab may not have seen the mutation before it was completed
                // and removed from the mutation queue, in which case we won't have cached
                // the affected documents. In this case we can safely ignore the update
                // since that means we didn't apply the mutation locally at all (if we
                // had, we would have cached the affected documents), and so we will just
                // see any resulting document changes via normal remote document updates
                // as applicable.
                T("SyncEngine", "Cannot apply mutation batch with id: " + r), n.label = 7;

              case 7:
                return [ 2 /*return*/ ];
            }
        }));
    }));
}

/** Applies a query target change from a different tab. */
// PORTING NOTE: Multi-Tab only.
function Js(t, r) {
    return e(this, void 0, void 0, (function() {
        var e, i, o, s, u, a, c, h;
        return n(this, (function(n) {
            switch (n.label) {
              case 0:
                return iu(e = x(t)), ou(e), !0 !== r || !0 === e.qh ? [ 3 /*break*/ , 3 ] : (i = e.Sh.Ci(), 
                [ 4 /*yield*/ , Zs(e, i.A()) ]);

              case 1:
                return o = n.sent(), e.qh = !0, [ 4 /*yield*/ , _s(e.ph, !0) ];

              case 2:
                for (n.sent(), s = 0, u = o; s < u.length; s++) a = u[s], rs(e.ph, a);
                return [ 3 /*break*/ , 7 ];

              case 3:
                return !1 !== r || !1 === e.qh ? [ 3 /*break*/ , 7 ] : (c = [], h = Promise.resolve(), 
                e.Fh.forEach((function(t, n) {
                    e.Sh.qi(n) ? c.push(n) : h = h.then((function() {
                        return Gs(e, n), Vo(e.ju, n, 
                        /*keepPersistedTargetData=*/ !0);
                    })), is(e.ph, n);
                })), [ 4 /*yield*/ , h ]);

              case 4:
                return n.sent(), [ 4 /*yield*/ , Zs(e, c) ];

              case 5:
                return n.sent(), 
                // PORTING NOTE: Multi-Tab only.
                function(t) {
                    var e = x(t);
                    e.kh.forEach((function(t, n) {
                        is(e.ph, n);
                    })), e.Mh.Qc(), e.kh = new Map, e.$h = new Ot(F.i);
                }(e), e.qh = !1, [ 4 /*yield*/ , _s(e.ph, !1) ];

              case 6:
                n.sent(), n.label = 7;

              case 7:
                return [ 2 /*return*/ ];
            }
        }));
    }));
}

function Zs(t, r, i) {
    return e(this, void 0, void 0, (function() {
        var e, i, o, s, u, a, c, h, f, l, p, d, v, y;
        return n(this, (function(n) {
            switch (n.label) {
              case 0:
                e = x(t), i = [], o = [], s = 0, u = r, n.label = 1;

              case 1:
                return s < u.length ? (a = u[s], c = void 0, (h = e.Fh.get(a)) && 0 !== h.length ? [ 4 /*yield*/ , Po(e.ju, er(h[0])) ] : [ 3 /*break*/ , 7 ]) : [ 3 /*break*/ , 13 ];

              case 2:
                // For queries that have a local View, we fetch their current state
                // from LocalStore (as the resume token and the snapshot version
                // might have changed) and reconcile their views with the persisted
                // state (the list of syncedDocuments may have gotten out of sync).
                c = n.sent(), f = 0, l = h, n.label = 3;

              case 3:
                return f < l.length ? (p = l[f], d = e.Nh.get(p), [ 4 /*yield*/ , $s(e, d) ]) : [ 3 /*break*/ , 6 ];

              case 4:
                (v = n.sent()).snapshot && o.push(v.snapshot), n.label = 5;

              case 5:
                return f++, [ 3 /*break*/ , 3 ];

              case 6:
                return [ 3 /*break*/ , 11 ];

              case 7:
                return [ 4 /*yield*/ , Co(e.ju, a) ];

              case 8:
                return y = n.sent(), [ 4 /*yield*/ , Po(e.ju, y) ];

              case 9:
                return c = n.sent(), [ 4 /*yield*/ , Os(e, tu(y), a, 
                /*current=*/ !1) ];

              case 10:
                n.sent(), n.label = 11;

              case 11:
                i.push(c), n.label = 12;

              case 12:
                return s++, [ 3 /*break*/ , 1 ];

              case 13:
                return [ 2 /*return*/ , (e.Ch.yu(o), i) ];
            }
        }));
    }));
}

/**
 * Creates a `Query` object from the specified `Target`. There is no way to
 * obtain the original `Query`, so we synthesize a `Query` from the `Target`
 * object.
 *
 * The synthesized result might be different from the original `Query`, but
 * since the synthesized `Query` should return the same results as the
 * original one (only the presentation of results might differ), the potential
 * difference will not cause issues.
 */
// PORTING NOTE: Multi-Tab only.
function tu(t) {
    return Qn(t.path, t.collectionGroup, t.orderBy, t.filters, t.limit, "F" /* First */ , t.startAt, t.endAt);
}

/** Returns the IDs of the clients that are currently active. */
// PORTING NOTE: Multi-Tab only.
function eu(t) {
    var e = x(t);
    return x(x(e.ju).persistence).pi();
}

/** Applies a query target change from a different tab. */
// PORTING NOTE: Multi-Tab only.
function nu(t, r, i, o) {
    return e(this, void 0, void 0, (function() {
        var e, s, u;
        return n(this, (function(n) {
            switch (n.label) {
              case 0:
                return (e = x(t)).qh ? (
                // If we receive a target state notification via WebStorage, we are
                // either already secondary or another tab has taken the primary lease.
                T("SyncEngine", "Ignoring unexpected query state notification."), [ 3 /*break*/ , 8 ]) : [ 3 /*break*/ , 1 ];

              case 1:
                if (!e.Fh.has(r)) return [ 3 /*break*/ , 8 ];
                switch (i) {
                  case "current":
                  case "not-current":
                    return [ 3 /*break*/ , 2 ];

                  case "rejected":
                    return [ 3 /*break*/ , 5 ];
                }
                return [ 3 /*break*/ , 7 ];

              case 2:
                return [ 4 /*yield*/ , Fo(e.ju) ];

              case 3:
                return s = n.sent(), u = Xt.Xt(r, "current" === i), [ 4 /*yield*/ , Qs(e, s, u) ];

              case 4:
                return n.sent(), [ 3 /*break*/ , 8 ];

              case 5:
                return [ 4 /*yield*/ , Vo(e.ju, r, 
                /* keepPersistedTargetData */ !0) ];

              case 6:
                return n.sent(), Gs(e, r, o), [ 3 /*break*/ , 8 ];

              case 7:
                D(), n.label = 8;

              case 8:
                return [ 2 /*return*/ ];
            }
        }));
    }));
}

/** Adds or removes Watch targets for queries from different tabs. */ function ru(t, r, i) {
    return e(this, void 0, void 0, (function() {
        var e, o, s, u, a, c, h, f, l, p;
        return n(this, (function(d) {
            switch (d.label) {
              case 0:
                if (!(e = iu(t)).qh) return [ 3 /*break*/ , 10 ];
                o = 0, s = r, d.label = 1;

              case 1:
                return o < s.length ? (u = s[o], e.Fh.has(u) ? (
                // A target might have been added in a previous attempt
                T("SyncEngine", "Adding an already active target " + u), [ 3 /*break*/ , 5 ]) : [ 4 /*yield*/ , Co(e.ju, u) ]) : [ 3 /*break*/ , 6 ];

              case 2:
                return a = d.sent(), [ 4 /*yield*/ , Po(e.ju, a) ];

              case 3:
                return c = d.sent(), [ 4 /*yield*/ , Os(e, tu(a), c.targetId, 
                /*current=*/ !1) ];

              case 4:
                d.sent(), rs(e.ph, c), d.label = 5;

              case 5:
                return o++, [ 3 /*break*/ , 1 ];

              case 6:
                h = function(t) {
                    return n(this, (function(n) {
                        switch (n.label) {
                          case 0:
                            return e.Fh.has(t) ? [ 4 /*yield*/ , Vo(e.ju, t, 
                            /* keepPersistedTargetData */ !1).then((function() {
                                is(e.ph, t), Gs(e, t);
                            })).catch(qo) ] : [ 3 /*break*/ , 2 ];

                            // Release queries that are still active.
                                                      case 1:
                            // Release queries that are still active.
                            n.sent(), n.label = 2;

                          case 2:
                            return [ 2 /*return*/ ];
                        }
                    }));
                }, f = 0, l = i, d.label = 7;

              case 7:
                return f < l.length ? (p = l[f], [ 5 /*yield**/ , h(p) ]) : [ 3 /*break*/ , 10 ];

              case 8:
                d.sent(), d.label = 9;

              case 9:
                return f++, [ 3 /*break*/ , 7 ];

              case 10:
                return [ 2 /*return*/ ];
            }
        }));
    }));
}

function iu(t) {
    var e = x(t);
    return e.ph.Gu.sh = Vs.bind(null, e), e.ph.Gu.qe = Ys.bind(null, e), e.ph.Gu.nh = Cs.bind(null, e), 
    e.Ch.yu = Qr.bind(null, e.bh), e.Ch.Wh = Hr.bind(null, e.bh), e;
}

function ou(t) {
    var e = x(t);
    return e.ph.Gu.ih = Fs.bind(null, e), e.ph.Gu.rh = Ms.bind(null, e), e;
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// TOOD(b/140938512): Drop SimpleQueryEngine and rename IndexFreeQueryEngine.
/**
 * A query engine that takes advantage of the target document mapping in the
 * QueryCache. The IndexFreeQueryEngine optimizes query execution by only
 * reading the documents that previously matched a query plus any documents that were
 * edited after the query was last listened to.
 *
 * There are some cases where Index-Free queries are not guaranteed to produce
 * the same results as full collection scans. In these cases, the
 * IndexFreeQueryEngine falls back to full query processing. These cases are:
 *
 * - Limit queries where a document that matched the query previously no longer
 *   matches the query.
 *
 * - Limit queries where a document edit may cause the document to sort below
 *   another document that is in the local cache.
 *
 * - Queries that have never been CURRENT or free of Limbo documents.
 */ var su = /** @class */ function() {
    function t() {}
    return t.prototype.Nc = function(t) {
        this.zh = t;
    }, t.prototype.Lr = function(t, e, n, r) {
        var i = this;
        // Queries that match all documents don't benefit from using
        // IndexFreeQueries. It is more efficient to scan all documents in a
        // collection, rather than to perform individual lookups.
                return function(t) {
            return 0 === t.filters.length && null === t.limit && null == t.startAt && null == t.endAt && (0 === t.on.length || 1 === t.on.length && t.on[0].field.p());
        }(e) || n.isEqual(gt.min()) ? this.Hh(t, e) : this.zh.kr(t, r).next((function(o) {
            var u = i.Yh(e, o);
            return (Yn(e) || $n(e)) && i.Eh(e.an, u, r, n) ? i.Hh(t, e) : (_() <= s.DEBUG && T("IndexFreeQueryEngine", "Re-using previous result from %s to execute query: %s", n.toString(), ur(e)), 
            i.zh.Lr(t, e, n).next((function(t) {
                // We merge `previousResults` into `updateResults`, since
                // `updateResults` is already a DocumentMap. If a document is
                // contained in both lists, then its contents are the same.
                return u.forEach((function(e) {
                    t = t.ot(e.key, e);
                })), t;
            })));
        }));
        // Queries that have never seen a snapshot without limbo free documents
        // should also be run as a full collection scan.
        }, 
    /** Applies the query filter and sorting to the provided documents.  */ t.prototype.Yh = function(t, e) {
        // Sort the documents and re-apply the query filter since previously
        // matching documents do not necessarily still match the query.
        var n = new Ut(cr(t));
        return e.forEach((function(e, r) {
            r instanceof zn && ar(t, r) && (n = n.add(r));
        })), n;
    }, 
    /**
     * Determines if a limit query needs to be refilled from cache, making it
     * ineligible for index-free execution.
     *
     * @param sortedPreviousResults The documents that matched the query when it
     * was last synchronized, sorted by the query's comparator.
     * @param remoteKeys The document keys that matched the query at the last
     * snapshot.
     * @param limboFreeSnapshotVersion The version of the snapshot when the query
     * was last synchronized.
     */
    t.prototype.Eh = function(t, e, n, r) {
        // The query needs to be refilled if a previously matching document no
        // longer matches.
        if (n.size !== e.size) return !0;
        // Limit queries are not eligible for index-free query execution if there is
        // a potential that an older document from cache now sorts before a document
        // that was previously part of the limit. This, however, can only happen if
        // the document at the edge of the limit goes out of limit.
        // If a document that is not the limit boundary sorts differently,
        // the boundary of the limit itself did not change and documents from cache
        // will continue to be "rejected" by this boundary. Therefore, we can ignore
        // any modifications that don't affect the last document.
                var i = "F" /* First */ === t ? e.last() : e.first();
        return !!i && (i.hasPendingWrites || i.version.L(r) > 0);
    }, t.prototype.Hh = function(t, e) {
        return _() <= s.DEBUG && T("IndexFreeQueryEngine", "Using full collection scan to execute query:", ur(e)), 
        this.zh.Lr(t, e, gt.min());
    }, t;
}(), uu = /** @class */ function() {
    function t(t, e) {
        this.Dr = t, this.No = e, 
        /**
             * The set of all mutations that have been sent but not yet been applied to
             * the backend.
             */
        this.Sr = [], 
        /** Next value to use when assigning sequential IDs to each mutation batch. */
        this.Jh = 1, 
        /** An ordered mapping between documents and the mutations batch IDs. */
        this.Xh = new Ut(Go.kc);
    }
    return t.prototype.$o = function(t) {
        return Dr.resolve(0 === this.Sr.length);
    }, t.prototype.ko = function(t, e, n, r) {
        var i = this.Jh;
        this.Jh++, this.Sr.length > 0 && this.Sr[this.Sr.length - 1];
        var o = new ci(i, e, n, r);
        this.Sr.push(o);
        // Track references by document key and index collection parents.
        for (var s = 0, u = r; s < u.length; s++) {
            var a = u[s];
            this.Xh = this.Xh.add(new Go(a.key, i)), this.Dr.Mo(t, a.key.path.h());
        }
        return Dr.resolve(o);
    }, t.prototype.Oo = function(t, e) {
        return Dr.resolve(this.Zh(e));
    }, t.prototype.Bo = function(t, e) {
        var n = e + 1, r = this.tl(n), i = r < 0 ? 0 : r;
        // The requested batchId may still be out of range so normalize it to the
        // start of the queue.
                return Dr.resolve(this.Sr.length > i ? this.Sr[i] : null);
    }, t.prototype.qo = function() {
        return Dr.resolve(0 === this.Sr.length ? -1 : this.Jh - 1);
    }, t.prototype.Uo = function(t) {
        return Dr.resolve(this.Sr.slice());
    }, t.prototype.Nr = function(t, e) {
        var n = this, r = new Go(e, 0), i = new Go(e, Number.POSITIVE_INFINITY), o = [];
        return this.Xh.Ft([ r, i ], (function(t) {
            var e = n.Zh(t.jc);
            o.push(e);
        })), Dr.resolve(o);
    }, t.prototype.Or = function(t, e) {
        var n = this, r = new Ut(st);
        return e.forEach((function(t) {
            var e = new Go(t, 0), i = new Go(t, Number.POSITIVE_INFINITY);
            n.Xh.Ft([ e, i ], (function(t) {
                r = r.add(t.jc);
            }));
        })), Dr.resolve(this.el(r));
    }, t.prototype.Wr = function(t, e) {
        // Use the query path as a prefix for testing if a document matches the
        // query.
        var n = e.path, r = n.length + 1, i = n;
        // Construct a document reference for actually scanning the index. Unlike
        // the prefix the document key in this reference must have an even number of
        // segments. The empty segment can be used a suffix of the query path
        // because it precedes all other segments in an ordered traversal.
                F.F(i) || (i = i.child(""));
        var o = new Go(new F(i), 0), s = new Ut(st);
        // Find unique batchIDs referenced by all documents potentially matching the
        // query.
                return this.Xh.xt((function(t) {
            var e = t.key.path;
            return !!n.T(e) && (
            // Rows with document keys more than one segment longer than the query
            // path can't be matches. For example, a query on 'rooms' can't match
            // the document /rooms/abc/messages/xyx.
            // TODO(mcg): we'll need a different scanner when we implement
            // ancestor queries.
            e.length === r && (s = s.add(t.jc)), !0);
        }), o), Dr.resolve(this.el(s));
    }, t.prototype.el = function(t) {
        var e = this, n = [];
        // Construct an array of matching batches, sorted by batchID to ensure that
        // multiple mutations affecting the same document key are applied in order.
                return t.forEach((function(t) {
            var r = e.Zh(t);
            null !== r && n.push(r);
        })), n;
    }, t.prototype.Wo = function(t, e) {
        var n = this;
        k(0 === this.nl(e.batchId, "removed")), this.Sr.shift();
        var r = this.Xh;
        return Dr.forEach(e.mutations, (function(i) {
            var o = new Go(i.key, e.batchId);
            return r = r.delete(o), n.No.Go(t, i.key);
        })).next((function() {
            n.Xh = r;
        }));
    }, t.prototype.Ko = function(t) {
        // No-op since the memory mutation queue does not maintain a separate cache.
    }, t.prototype.Ho = function(t, e) {
        var n = new Go(e, 0), r = this.Xh.$t(n);
        return Dr.resolve(e.isEqual(r && r.key));
    }, t.prototype.zo = function(t) {
        return this.Sr.length, Dr.resolve();
    }, 
    /**
     * Finds the index of the given batchId in the mutation queue and asserts that
     * the resulting index is within the bounds of the queue.
     *
     * @param batchId The batchId to search for
     * @param action A description of what the caller is doing, phrased in passive
     * form (e.g. "acknowledged" in a routine that acknowledges batches).
     */
    t.prototype.nl = function(t, e) {
        return this.tl(t);
    }, 
    /**
     * Finds the index of the given batchId in the mutation queue. This operation
     * is O(1).
     *
     * @return The computed index of the batch with the given batchId, based on
     * the state of the queue. Note this index can be negative if the requested
     * batchId has already been remvoed from the queue or past the end of the
     * queue if the batchId is larger than the last added batch.
     */
    t.prototype.tl = function(t) {
        return 0 === this.Sr.length ? 0 : t - this.Sr[0].batchId;
        // Examine the front of the queue to figure out the difference between the
        // batchId and indexes in the array. Note that since the queue is ordered
        // by batchId, if the first batch has a larger batchId then the requested
        // batchId doesn't exist in the queue.
        }, 
    /**
     * A version of lookupMutationBatch that doesn't return a promise, this makes
     * other functions that uses this code easier to read and more efficent.
     */
    t.prototype.Zh = function(t) {
        var e = this.tl(t);
        return e < 0 || e >= this.Sr.length ? null : this.Sr[e];
    }, t;
}(), au = /** @class */ function() {
    /**
     * @param sizer Used to assess the size of a document. For eager GC, this is expected to just
     * return 0 to avoid unnecessarily doing the work of calculating the size.
     */
    function t(t, e) {
        this.Dr = t, this.sl = e, 
        /** Underlying cache of documents and their read times. */
        this.docs = new Ot(F.i), 
        /** Size of all cached documents. */
        this.size = 0
        /**
     * Adds the supplied entry to the cache and updates the cache size as appropriate.
     *
     * All calls of `addEntry`  are required to go through the RemoteDocumentChangeBuffer
     * returned by `newChangeBuffer()`.
     */;
    }
    return t.prototype.Er = function(t, e, n) {
        var r = e.key, i = this.docs.get(r), o = i ? i.size : 0, s = this.sl(e);
        return this.docs = this.docs.ot(r, {
            ta: e,
            size: s,
            readTime: n
        }), this.size += s - o, this.Dr.Mo(t, r.path.h());
    }, 
    /**
     * Removes the specified entry from the cache and updates the cache size as appropriate.
     *
     * All calls of `removeEntry` are required to go through the RemoteDocumentChangeBuffer
     * returned by `newChangeBuffer()`.
     */
    t.prototype.Ar = function(t) {
        var e = this.docs.get(t);
        e && (this.docs = this.docs.remove(t), this.size -= e.size);
    }, t.prototype.Rr = function(t, e) {
        var n = this.docs.get(e);
        return Dr.resolve(n ? n.ta : null);
    }, t.prototype.getEntries = function(t, e) {
        var n = this, r = qt();
        return e.forEach((function(t) {
            var e = n.docs.get(t);
            r = r.ot(t, e ? e.ta : null);
        })), Dr.resolve(r);
    }, t.prototype.Lr = function(t, e, n) {
        for (var r = Gt(), i = new F(e.path.child("")), o = this.docs.ft(i)
        // Documents are ordered by key, so we can use a prefix scan to narrow down
        // the documents we need to match the query against.
        ; o.At(); ) {
            var s = o.It(), u = s.key, a = s.value, c = a.ta, h = a.readTime;
            if (!e.path.T(u.path)) break;
            h.L(n) <= 0 || c instanceof zn && ar(e, c) && (r = r.ot(c.key, c));
        }
        return Dr.resolve(r);
    }, t.prototype.il = function(t, e) {
        return Dr.forEach(this.docs, (function(t) {
            return e(t);
        }));
    }, t.prototype.ra = function(t) {
        // `trackRemovals` is ignores since the MemoryRemoteDocumentCache keeps
        // a separate changelog and does not need special handling for removals.
        return new cu(this);
    }, t.prototype.aa = function(t) {
        return Dr.resolve(this.size);
    }, t;
}(), cu = /** @class */ function(e) {
    function n(t) {
        var n = this;
        return (n = e.call(this) || this).ca = t, n;
    }
    return t(n, e), n.prototype.yr = function(t) {
        var e = this, n = [];
        return this.wr.forEach((function(r, i) {
            i ? n.push(e.ca.Er(t, i, e.readTime)) : e.ca.Ar(r);
        })), Dr.$n(n);
    }, n.prototype.gr = function(t, e) {
        return this.ca.Rr(t, e);
    }, n.prototype.Pr = function(t, e) {
        return this.ca.getEntries(t, e);
    }, n;
}(fi), hu = /** @class */ function() {
    function t(t) {
        this.persistence = t, 
        /**
             * Maps a target to the data about that target
             */
        this.rl = new yt((function(t) {
            return Tt(t);
        }), Nt), 
        /** The last received snapshot version. */
        this.lastRemoteSnapshotVersion = gt.min(), 
        /** The highest numbered target ID encountered. */
        this.highestTargetId = 0, 
        /** The highest sequence number encountered. */
        this.ol = 0, 
        /**
             * A ordered bidirectional mapping between documents and the remote target
             * IDs.
             */
        this.al = new jo, this.targetCount = 0, this.cl = yo.fa();
    }
    return t.prototype.Ce = function(t, e) {
        return this.rl.forEach((function(t, n) {
            return e(n);
        })), Dr.resolve();
    }, t.prototype.Ea = function(t) {
        return Dr.resolve(this.lastRemoteSnapshotVersion);
    }, t.prototype.Ia = function(t) {
        return Dr.resolve(this.ol);
    }, t.prototype.wa = function(t) {
        return this.highestTargetId = this.cl.next(), Dr.resolve(this.highestTargetId);
    }, t.prototype.Aa = function(t, e, n) {
        return n && (this.lastRemoteSnapshotVersion = n), e > this.ol && (this.ol = e), 
        Dr.resolve();
    }, t.prototype.ga = function(t) {
        this.rl.set(t.target, t);
        var e = t.targetId;
        e > this.highestTargetId && (this.cl = new yo(e), this.highestTargetId = e), t.sequenceNumber > this.ol && (this.ol = t.sequenceNumber);
    }, t.prototype.Ra = function(t, e) {
        return this.ga(e), this.targetCount += 1, Dr.resolve();
    }, t.prototype.ya = function(t, e) {
        return this.ga(e), Dr.resolve();
    }, t.prototype.Va = function(t, e) {
        return this.rl.delete(e.target), this.al.Uc(e.targetId), this.targetCount -= 1, 
        Dr.resolve();
    }, t.prototype.po = function(t, e, n) {
        var r = this, i = 0, o = [];
        return this.rl.forEach((function(s, u) {
            u.sequenceNumber <= e && null === n.get(u.targetId) && (r.rl.delete(s), o.push(r.pa(t, u.targetId)), 
            i++);
        })), Dr.$n(o).next((function() {
            return i;
        }));
    }, t.prototype.ba = function(t) {
        return Dr.resolve(this.targetCount);
    }, t.prototype.va = function(t, e) {
        var n = this.rl.get(e) || null;
        return Dr.resolve(n);
    }, t.prototype.Sa = function(t, e, n) {
        return this.al.Lc(e, n), Dr.resolve();
    }, t.prototype.Ca = function(t, e, n) {
        this.al.qc(e, n);
        var r = this.persistence.No, i = [];
        return r && e.forEach((function(e) {
            i.push(r.Go(t, e));
        })), Dr.$n(i);
    }, t.prototype.pa = function(t, e) {
        return this.al.Uc(e), Dr.resolve();
    }, t.prototype.Fa = function(t, e) {
        var n = this.al.Wc(e);
        return Dr.resolve(n);
    }, t.prototype.Ho = function(t, e) {
        return Dr.resolve(this.al.Ho(e));
    }, t;
}(), fu = /** @class */ function() {
    /**
     * The constructor accepts a factory for creating a reference delegate. This
     * allows both the delegate and this instance to have strong references to
     * each other without having nullable fields that would then need to be
     * checked or asserted on every access.
     */
    function t(t) {
        var e = this;
        this.ul = {}, this.Ma = new Jr(0), this.Oa = !1, this.Oa = !0, this.No = t(this), 
        this.Ka = new hu(this), this.Dr = new Hi, this.vr = function(t, n) {
            return new au(t, (function(t) {
                return e.No.hl(t);
            }));
        }(this.Dr);
    }
    return t.prototype.start = function() {
        return Promise.resolve();
    }, t.prototype.Di = function() {
        // No durable state to ensure is closed on shutdown.
        return this.Oa = !1, Promise.resolve();
    }, Object.defineProperty(t.prototype, "Ei", {
        get: function() {
            return this.Oa;
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.Za = function() {
        // No op.
    }, t.prototype.tc = function() {
        // No op.
    }, t.prototype.Ic = function() {
        return this.Dr;
    }, t.prototype.mc = function(t) {
        var e = this.ul[t.ti()];
        return e || (e = new uu(this.Dr, this.No), this.ul[t.ti()] = e), e;
    }, t.prototype.Tc = function() {
        return this.Ka;
    }, t.prototype.Ec = function() {
        return this.vr;
    }, t.prototype.runTransaction = function(t, e, n) {
        var r = this;
        T("MemoryPersistence", "Starting transaction:", t);
        var i = new lu(this.Ma.next());
        return this.No.ll(), n(i).next((function(t) {
            return r.No._l(i).next((function() {
                return t;
            }));
        })).Fn().then((function(t) {
            return i.br(), t;
        }));
    }, t.prototype.fl = function(t, e) {
        return Dr.kn(Object.values(this.ul).map((function(n) {
            return function() {
                return n.Ho(t, e);
            };
        })));
    }, t;
}(), lu = /** @class */ function(e) {
    function n(t) {
        var n = this;
        return (n = e.call(this) || this).xa = t, n;
    }
    return t(n, e), n;
}(pi), pu = /** @class */ function() {
    function t(t) {
        this.persistence = t, 
        /** Tracks all documents that are active in Query views. */
        this.dl = new jo, 
        /** The list of documents that are potentially GCed after each transaction. */
        this.wl = null;
    }
    return t.ml = function(e) {
        return new t(e);
    }, Object.defineProperty(t.prototype, "Tl", {
        get: function() {
            if (this.wl) return this.wl;
            throw D();
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.Da = function(t, e, n) {
        return this.dl.Da(n, e), this.Tl.delete(n.toString()), Dr.resolve();
    }, t.prototype.Na = function(t, e, n) {
        return this.dl.Na(n, e), this.Tl.add(n.toString()), Dr.resolve();
    }, t.prototype.Go = function(t, e) {
        return this.Tl.add(e.toString()), Dr.resolve();
    }, t.prototype.removeTarget = function(t, e) {
        var n = this;
        this.dl.Uc(e.targetId).forEach((function(t) {
            return n.Tl.add(t.toString());
        }));
        var r = this.persistence.Tc();
        return r.Fa(t, e.targetId).next((function(t) {
            t.forEach((function(t) {
                return n.Tl.add(t.toString());
            }));
        })).next((function() {
            return r.Va(t, e);
        }));
    }, t.prototype.ll = function() {
        this.wl = new Set;
    }, t.prototype._l = function(t) {
        var e = this, n = this.persistence.Ec().ra();
        // Remove newly orphaned documents.
                return Dr.forEach(this.Tl, (function(r) {
            var i = F.D(r);
            return e.El(t, i).next((function(t) {
                t || n.Ar(i);
            }));
        })).next((function() {
            return e.wl = null, n.apply(t);
        }));
    }, t.prototype.yc = function(t, e) {
        var n = this;
        return this.El(t, e).next((function(t) {
            t ? n.Tl.delete(e.toString()) : n.Tl.add(e.toString());
        }));
    }, t.prototype.hl = function(t) {
        // For eager GC, we don't care about the document size, there are no size thresholds.
        return 0;
    }, t.prototype.El = function(t, e) {
        var n = this;
        return Dr.kn([ function() {
            return Dr.resolve(n.dl.Ho(e));
        }, function() {
            return n.persistence.Tc().Ho(t, e);
        }, function() {
            return n.persistence.fl(t, e);
        } ]);
    }, t;
}(), du = /** @class */ function() {
    function t(t) {
        this.Il = t.Il, this.Al = t.Al;
    }
    return t.prototype.gu = function(t) {
        this.Rl = t;
    }, t.prototype.Tu = function(t) {
        this.gl = t;
    }, t.prototype.onMessage = function(t) {
        this.Pl = t;
    }, t.prototype.close = function() {
        this.Al();
    }, t.prototype.send = function(t) {
        this.Il(t);
    }, t.prototype.yl = function() {
        this.Rl();
    }, t.prototype.Vl = function(t) {
        this.gl(t);
    }, t.prototype.pl = function(t) {
        this.Pl(t);
    }, t;
}(), vu = {
    BatchGetDocuments: "batchGet",
    Commit: "commit",
    RunQuery: "runQuery"
}, yu = /** @class */ function(e) {
    function n(t) {
        var n = this;
        return (n = e.call(this, t) || this).forceLongPolling = t.forceLongPolling, n.W = t.W, 
        n;
    }
    /**
     * Base class for all Rest-based connections to the backend (WebChannel and
     * HTTP).
     */
    return t(n, e), n.prototype.Nl = function(t, e, n, r) {
        return new Promise((function(i, o) {
            var s = new d;
            s.listenOnce(v.COMPLETE, (function() {
                try {
                    switch (s.getLastErrorCode()) {
                      case y.NO_ERROR:
                        var e = s.getResponseJson();
                        T("Connection", "XHR received:", JSON.stringify(e)), i(e);
                        break;

                      case y.TIMEOUT:
                        T("Connection", 'RPC "' + t + '" timed out'), o(new I(b.DEADLINE_EXCEEDED, "Request time out"));
                        break;

                      case y.HTTP_ERROR:
                        var n = s.getStatus();
                        if (T("Connection", 'RPC "' + t + '" failed with status:', n, "response text:", s.getResponseText()), 
                        n > 0) {
                            var r = s.getResponseJson().error;
                            if (r && r.status && r.message) {
                                var u = function(t) {
                                    var e = t.toLowerCase().replace("_", "-");
                                    return Object.values(b).indexOf(e) >= 0 ? e : b.UNKNOWN;
                                }(r.status);
                                o(new I(u, r.message));
                            } else o(new I(b.UNKNOWN, "Server responded with status " + s.getStatus()));
                        } else 
                        // If we received an HTTP_ERROR but there's no status code,
                        // it's most probably a connection issue
                        o(new I(b.UNAVAILABLE, "Connection failed."));
                        break;

                      default:
                        D();
                    }
                } finally {
                    T("Connection", 'RPC "' + t + '" completed.');
                }
            }));
            var u = JSON.stringify(r);
            s.send(e, "POST", u, n, 15);
        }));
    }, n.prototype.Pu = function(t, e) {
        var n = [ this.vl, "/", "google.firestore.v1.Firestore", "/", t, "/channel" ], r = m(), i = {
            // Required for backend stickiness, routing behavior is based on this
            // parameter.
            httpSessionIdParam: "gsessionid",
            initMessageHeaders: {},
            messageUrlParams: {
                // This param is used to improve routing and project isolation by the
                // backend and must be included in every request.
                database: "projects/" + this.U.projectId + "/databases/" + this.U.database
            },
            sendRawJson: !0,
            supportsCrossDomainXhr: !0,
            internalChannelParams: {
                // Override the default timeout (randomized between 10-20 seconds) since
                // a large write batch on a slow internet connection may take a long
                // time to send to the backend. Rather than have WebChannel impose a
                // tight timeout which could lead to infinite timeouts and retries, we
                // set it very large (5-10 minutes) and rely on the browser's builtin
                // timeouts to kick in if the request isn't working.
                forwardChannelRequestTimeoutMs: 6e5
            },
            forceLongPolling: this.forceLongPolling,
            detectBufferingProxy: this.W
        };
        this.Cl(i.initMessageHeaders, e), 
        // Sending the custom headers we just added to request.initMessageHeaders
        // (Authorization, etc.) will trigger the browser to make a CORS preflight
        // request because the XHR will no longer meet the criteria for a "simple"
        // CORS request:
        // https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS#Simple_requests
        // Therefore to avoid the CORS preflight request (an extra network
        // roundtrip), we use the httpHeadersOverwriteParam option to specify that
        // the headers should instead be encoded into a special "$httpHeaders" query
        // parameter, which is recognized by the webchannel backend. This is
        // formally defined here:
        // https://github.com/google/closure-library/blob/b0e1815b13fb92a46d7c9b3c30de5d6a396a3245/closure/goog/net/rpc/httpcors.js#L32
        // TODO(b/145624756): There is a backend bug where $httpHeaders isn't respected if the request
        // doesn't have an Origin header. So we have to exclude a few browser environments that are
        // known to (sometimes) not include an Origin. See
        // https://github.com/firebase/firebase-js-sdk/issues/1491.
        a() || c() || h() || f() || l() || p() || (i.httpHeadersOverwriteParam = "$httpHeaders");
        var o = n.join("");
        T("Connection", "Creating WebChannel: " + o, i);
        var s = r.createWebChannel(o, i), u = !1, d = !1, v = new du({
            Il: function(t) {
                d ? T("Connection", "Not sending because WebChannel is closed:", t) : (u || (T("Connection", "Opening WebChannel transport."), 
                s.open(), u = !0), T("Connection", "WebChannel sending:", t), s.send(t));
            },
            Al: function() {
                return s.close();
            }
        }), y = function(t, e) {
            // TODO(dimond): closure typing seems broken because WebChannel does
            // not implement goog.events.Listenable
            s.listen(t, (function(t) {
                try {
                    e(t);
                } catch (t) {
                    setTimeout((function() {
                        throw t;
                    }), 0);
                }
            }));
        };
        // WebChannel supports sending the first message with the handshake - saving
        // a network round trip. However, it will have to call send in the same
        // JS event loop as open. In order to enforce this, we delay actually
        // opening the WebChannel until send is called. Whether we have called
        // open is tracked with this variable.
                // Closure events are guarded and exceptions are swallowed, so catch any
        // exception and rethrow using a setTimeout so they become visible again.
        // Note that eventually this function could go away if we are confident
        // enough the code is exception free.
        return y(g.EventType.OPEN, (function() {
            d || T("Connection", "WebChannel transport opened.");
        })), y(g.EventType.CLOSE, (function() {
            d || (d = !0, T("Connection", "WebChannel transport closed"), v.Vl());
        })), y(g.EventType.ERROR, (function(t) {
            d || (d = !0, A("Connection", "WebChannel transport errored:", t), v.Vl(new I(b.UNAVAILABLE, "The operation could not be completed")));
        })), y(g.EventType.MESSAGE, (function(t) {
            var e;
            if (!d) {
                var n = t.data[0];
                k(!!n);
                // TODO(b/35143891): There is a bug in One Platform that caused errors
                // (and only errors) to be wrapped in an extra array. To be forward
                // compatible with the bug we need to check either condition. The latter
                // can be removed once the fix has been rolled out.
                // Use any because msgData.error is not typed.
                var r = n, i = r.error || (null === (e = r[0]) || void 0 === e ? void 0 : e.error);
                if (i) {
                    T("Connection", "WebChannel received error:", i);
                    // error.status will be a string like 'OK' or 'NOT_FOUND'.
                    var o = i.status, u = function(t) {
                        // lookup by string
                        // eslint-disable-next-line @typescript-eslint/no-explicit-any
                        var e = St[t];
                        if (void 0 !== e) return Rt(e);
                    }(o), a = i.message;
                    void 0 === u && (u = b.INTERNAL, a = "Unknown error status: " + o + " with message " + i.message), 
                    // Mark closed so no further events are propagated
                    d = !0, v.Vl(new I(u, a)), s.close();
                } else T("Connection", "WebChannel received:", n), v.pl(n);
            }
        })), setTimeout((function() {
            // Technically we could/should wait for the WebChannel opened event,
            // but because we want to send the first message with the WebChannel
            // handshake we pretend the channel opened here (asynchronously), and
            // then delay the actual open until the first message is sent.
            v.yl();
        }), 0), v;
    }, n;
}(/** @class */ function() {
    function t(t) {
        this.bl = t, this.U = t.U;
        var e = t.ssl ? "https" : "http";
        this.vl = e + "://" + t.host, this.Sl = "projects/" + this.U.projectId + "/databases/" + this.U.database + "/documents";
    }
    return t.prototype.$u = function(t, e, n, r) {
        var i = this.Dl(t, e);
        T("RestConnection", "Sending: ", i, n);
        var o = {};
        return this.Cl(o, r), this.Nl(t, i, o, n).then((function(t) {
            return T("RestConnection", "Received: ", t), t;
        }), (function(e) {
            throw A("RestConnection", t + " failed with error: ", e, "url: ", i, "request:", n), 
            e;
        }));
    }, t.prototype.ku = function(t, e, n, r) {
        // The REST API automatically aggregates all of the streamed results, so we
        // can just use the normal invoke() method.
        return this.$u(t, e, n, r);
    }, 
    /**
     * Modifies the headers for a request, adding any authorization token if
     * present and any additional headers for the request.
     */
    t.prototype.Cl = function(t, e) {
        if (t["X-Goog-Api-Client"] = "gl-js/ fire/7.24.0", 
        // Content-Type: text/plain will avoid preflight requests which might
        // mess with CORS and redirects by proxies. If we add custom headers
        // we will need to change this code to potentially use the $httpOverwrite
        // parameter supported by ESF to avoid triggering preflight requests.
        t["Content-Type"] = "text/plain", e) for (var n in e.Kc) e.Kc.hasOwnProperty(n) && (t[n] = e.Kc[n]);
    }, t.prototype.Dl = function(t, e) {
        var n = vu[t];
        return this.vl + "/v1/" + e + ":" + n;
    }, t;
}()), mu = /** @class */ function() {
    function t() {
        var t = this;
        this.Fl = function() {
            return t.xl();
        }, this.$l = function() {
            return t.kl();
        }, this.Ml = [], this.Ol();
    }
    return t.prototype.Zu = function(t) {
        this.Ml.push(t);
    }, t.prototype.Di = function() {
        window.removeEventListener("online", this.Fl), window.removeEventListener("offline", this.$l);
    }, t.prototype.Ol = function() {
        window.addEventListener("online", this.Fl), window.addEventListener("offline", this.$l);
    }, t.prototype.xl = function() {
        T("ConnectivityMonitor", "Network connectivity changed: AVAILABLE");
        for (var t = 0, e = this.Ml; t < e.length; t++) {
            (0, e[t])(0 /* AVAILABLE */);
        }
    }, t.prototype.kl = function() {
        T("ConnectivityMonitor", "Network connectivity changed: UNAVAILABLE");
        for (var t = 0, e = this.Ml; t < e.length; t++) {
            (0, e[t])(1 /* UNAVAILABLE */);
        }
    }, 
    // TODO(chenbrian): Consider passing in window either into this component or
    // here for testing via FakeWindow.
    /** Checks that all used attributes of window are available. */
    t.Ln = function() {
        return "undefined" != typeof window && void 0 !== window.addEventListener && void 0 !== window.removeEventListener;
    }, t;
}(), gu = /** @class */ function() {
    function t() {}
    return t.prototype.Zu = function(t) {
        // No-op.
    }, t.prototype.Di = function() {
        // No-op.
    }, t;
}();

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** Initializes the WebChannelConnection for the browser. */
/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
function wu(t) {
    return new De(t, /* useProto3Json= */ !0);
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ var bu = "You are using the memory-only build of Firestore. Persistence support is only available via the @firebase/firestore bundle or the firebase-firestore.js build.", Iu = /** @class */ function() {
    function t() {}
    return t.prototype.initialize = function(t) {
        return e(this, void 0, void 0, (function() {
            return n(this, (function(e) {
                switch (e.label) {
                  case 0:
                    return this.Sh = this.Ll(t), this.persistence = this.Bl(t), [ 4 /*yield*/ , this.persistence.start() ];

                  case 1:
                    return e.sent(), this.ql = this.Ul(t), this.ju = this.Ql(t), [ 2 /*return*/ ];
                }
            }));
        }));
    }, t.prototype.Ul = function(t) {
        return null;
    }, t.prototype.Ql = function(t) {
        /** Manages our in-memory or durable persistence. */
        return e = this.persistence, n = new su, r = t.Wl, new ko(e, n, r);
        var e, n, r;
    }, t.prototype.Bl = function(t) {
        if (t.persistenceSettings.jl) throw new I(b.FAILED_PRECONDITION, bu);
        return new fu(pu.ml);
    }, t.prototype.Ll = function(t) {
        return new ai;
    }, t.prototype.terminate = function() {
        return e(this, void 0, void 0, (function() {
            return n(this, (function(t) {
                switch (t.label) {
                  case 0:
                    return this.ql && this.ql.stop(), [ 4 /*yield*/ , this.Sh.Di() ];

                  case 1:
                    return t.sent(), [ 4 /*yield*/ , this.persistence.Di() ];

                  case 2:
                    return t.sent(), [ 2 /*return*/ ];
                }
            }));
        }));
    }, t.prototype.clearPersistence = function(t, e) {
        throw new I(b.FAILED_PRECONDITION, bu);
    }, t;
}(), Eu = /** @class */ function(r) {
    function i() {
        return null !== r && r.apply(this, arguments) || this;
    }
    return t(i, r), i.prototype.initialize = function(t) {
        return e(this, void 0, void 0, (function() {
            var i, o = this;
            return n(this, (function(s) {
                switch (s.label) {
                  case 0:
                    return [ 4 /*yield*/ , r.prototype.initialize.call(this, t) ];

                  case 1:
                    return s.sent(), i = this.Kl.fi, this.Sh instanceof ui ? (this.Sh.fi = {
                        er: Xs.bind(null, i),
                        nr: nu.bind(null, i),
                        sr: ru.bind(null, i),
                        pi: eu.bind(null, i)
                    }, [ 4 /*yield*/ , this.Sh.start() ]) : [ 3 /*break*/ , 3 ];

                  case 2:
                    s.sent(), s.label = 3;

                  case 3:
                    // NOTE: This will immediately call the listener, so we make sure to
                    // set it after localStore / remoteStore are started.
                    return [ 4 /*yield*/ , this.persistence.Xa((function(t) {
                        return e(o, void 0, void 0, (function() {
                            return n(this, (function(e) {
                                switch (e.label) {
                                  case 0:
                                    return [ 4 /*yield*/ , Js(this.Kl.fi, t) ];

                                  case 1:
                                    return e.sent(), this.ql && (t && !this.ql.Ei ? this.ql.start(this.ju) : t || this.ql.stop()), 
                                    [ 2 /*return*/ ];
                                }
                            }));
                        }));
                    })) ];

                  case 4:
                    // NOTE: This will immediately call the listener, so we make sure to
                    // set it after localStore / remoteStore are started.
                    return s.sent(), [ 2 /*return*/ ];
                }
            }));
        }));
    }, i.prototype.Ll = function(t) {
        if (t.persistenceSettings.jl && t.persistenceSettings.synchronizeTabs) {
            var e = Fr();
            if (!ui.Ln(e)) throw new I(b.UNIMPLEMENTED, "IndexedDB persistence is only available on platforms that support LocalStorage.");
            var n = Do(t.bl.U, t.bl.persistenceKey);
            return new ui(e, t.cs, n, t.clientId, t.Wl);
        }
        return new ai;
    }, i;
}(/** @class */ function(r) {
    function i(t) {
        var e = this;
        return (e = r.call(this) || this).Kl = t, e;
    }
    return t(i, r), i.prototype.initialize = function(t) {
        return e(this, void 0, void 0, (function() {
            return n(this, (function(e) {
                switch (e.label) {
                  case 0:
                    return [ 4 /*yield*/ , r.prototype.initialize.call(this, t) ];

                  case 1:
                    return e.sent(), [ 4 /*yield*/ , Mo(this.ju) ];

                  case 2:
                    return e.sent(), [ 4 /*yield*/ , this.Kl.initialize(this, t) ];

                  case 3:
                    // Enqueue writes from a previous session
                    return e.sent(), [ 4 /*yield*/ , ou(this.Kl.fi) ];

                  case 4:
                    // Enqueue writes from a previous session
                    return e.sent(), [ 4 /*yield*/ , ys(this.Kl.ph) ];

                  case 5:
                    return e.sent(), [ 2 /*return*/ ];
                }
            }));
        }));
    }, i.prototype.Ul = function(t) {
        var e = this.persistence.No.wo;
        return new bi(e, t.cs);
    }, i.prototype.Bl = function(t) {
        var e = Do(t.bl.U, t.bl.persistenceKey), n = wu(t.bl.U);
        return new _o(t.persistenceSettings.synchronizeTabs, e, t.clientId, wi.ao(t.persistenceSettings.cacheSizeBytes), t.cs, Fr(), Mr(), n, this.Sh, t.persistenceSettings.ka);
    }, i.prototype.Ll = function(t) {
        return new ai;
    }, i.prototype.clearPersistence = function(t, r) {
        return function(t) {
            return e(this, void 0, void 0, (function() {
                var e;
                return n(this, (function(n) {
                    switch (n.label) {
                      case 0:
                        return kr.Ln() ? (e = t + "main", [ 4 /*yield*/ , kr.delete(e) ]) : [ 2 /*return*/ , Promise.resolve() ];

                      case 1:
                        return n.sent(), [ 2 /*return*/ ];
                    }
                }));
            }));
        }(Do(t, r));
    }, i;
}(Iu)), _u = /** @class */ function() {
    function t() {}
    return t.prototype.initialize = function(t, r) {
        return e(this, void 0, void 0, (function() {
            var e = this;
            return n(this, (function(n) {
                switch (n.label) {
                  case 0:
                    return this.ju ? [ 3 /*break*/ , 2 ] : (this.ju = t.ju, this.Sh = t.Sh, this.Ku = this.Gl(r), 
                    this.ph = this.zl(r), this.bh = this.Hl(r), this.fi = this.Yl(r), this.Sh.di = function(t) {
                        return Us(e.fi, t, 1 /* SharedClientState */);
                    }, this.ph.Gu.Jl = Hs.bind(null, this.fi), [ 4 /*yield*/ , _s(this.ph, this.fi.Uh) ]);

                  case 1:
                    n.sent(), n.label = 2;

                  case 2:
                    return [ 2 /*return*/ ];
                }
            }));
        }));
    }, t.prototype.Hl = function(t) {
        return new Br;
    }, t.prototype.Gl = function(t) {
        var e, n = wu(t.bl.U), r = (e = t.bl, new yu(e));
        /** Return the Platform-specific connectivity monitor. */ return function(t, e, n) {
            return new Xo(t, e, n);
        }(t.credentials, r, n);
    }, t.prototype.zl = function(t) {
        var e, n, r, i, o, s = this;
        return e = this.ju, n = this.Ku, r = t.cs, i = function(t) {
            return Us(s.fi, t, 0 /* RemoteStore */);
        }, o = mu.Ln() ? new mu : new gu, new Zo(e, n, r, i, o);
    }, t.prototype.Yl = function(t) {
        return function(t, e, n, 
        // PORTING NOTE: Manages state synchronization in multi-tab environments.
        r, i, o, s) {
            var u = new Ls(t, e, n, r, i, o);
            return s && (u.qh = !0), u;
        }(this.ju, this.ph, this.bh, this.Sh, t.Wl, t.Dh, !t.persistenceSettings.jl || !t.persistenceSettings.synchronizeTabs);
    }, t.prototype.terminate = function() {
        return ns(this.ph);
    }, t;
}(), Tu = /** @class */ function() {
    function t(t) {
        this.observer = t, 
        /**
             * When set to true, will not raise future events. Necessary to deal with
             * async detachment of listener.
             */
        this.muted = !1;
    }
    return t.prototype.next = function(t) {
        this.observer.next && this.Xl(this.observer.next, t);
    }, t.prototype.error = function(t) {
        this.observer.error ? this.Xl(this.observer.error, t) : console.error("Uncaught Error in snapshot listener:", t);
    }, t.prototype.Zl = function() {
        this.muted = !0;
    }, t.prototype.Xl = function(t, e) {
        var n = this;
        this.muted || setTimeout((function() {
            n.muted || t(e);
        }), 0);
    }, t;
}(), Nu = function(t) {
    !function(t, e, n, r) {
        if (!(e instanceof Array) || e.length < 1) throw new I(b.INVALID_ARGUMENT, "Function FieldPath() requires its fieldNames argument to be an array with at least " + rt(1, "element") + ".");
    }(0, t);
    for (var e = 0; e < t.length; ++e) if (z("FieldPath", "string", e, t[e]), 0 === t[e].length) throw new I(b.INVALID_ARGUMENT, "Invalid field name at argument $(i + 1). Field names must not be empty.");
    this.t_ = new C(t);
}, Au = /** @class */ function(e) {
    /**
     * Creates a FieldPath from the provided field names. If more than one field
     * name is provided, the path will point to a nested field in a document.
     *
     * @param fieldNames A list of field names.
     */
    function n() {
        for (var t = [], n = 0; n < arguments.length; n++) t[n] = arguments[n];
        return e.call(this, t) || this;
    }
    return t(n, e), n.documentId = function() {
        /**
         * Internal Note: The backend doesn't technically support querying by
         * document ID. Instead it queries by the entire document name (full path
         * included), but in the cases we currently support documentId(), the net
         * effect is the same.
         */
        return new n(C.v().R());
    }, n.prototype.isEqual = function(t) {
        if (!(t instanceof n)) throw tt("isEqual", "FieldPath", 1, t);
        return this.t_.isEqual(t.t_);
    }, n;
}(Nu), Su = new RegExp("[~\\*/\\[\\]]"), Du = 
/**
     * @param _methodName The public API endpoint that returns this class.
     */
function(t) {
    this.e_ = t;
}, ku = /** @class */ function(e) {
    function n() {
        return null !== e && e.apply(this, arguments) || this;
    }
    return t(n, e), n.prototype.n_ = function(t) {
        if (2 /* MergeSet */ !== t.s_) throw 1 /* Update */ === t.s_ ? t.i_(this.e_ + "() can only appear at the top level of your update data") : t.i_(this.e_ + "() cannot be used with set() unless you pass {merge:true}");
        // No transform to add for a delete, but we need to add it to our
        // fieldMask so it gets deleted.
                return t.We.push(t.path), null;
    }, n.prototype.isEqual = function(t) {
        return t instanceof n;
    }, n;
}(Du);

/**
 * Provides all components needed for Firestore with in-memory persistence.
 * Uses EagerGC garbage collection.
 */
/**
 * Creates a child context for parsing SerializableFieldValues.
 *
 * This is different than calling `ParseContext.contextWith` because it keeps
 * the fieldTransforms and fieldMask separate.
 *
 * The created context has its `dataSource` set to `UserDataSource.Argument`.
 * Although these values are used with writes, any elements in these FieldValues
 * are not considered writes since they cannot contain any FieldValue sentinels,
 * etc.
 *
 * @param fieldValue The sentinel FieldValue for which to create a child
 *     context.
 * @param context The parent context.
 * @param arrayElement Whether or not the FieldValue has an array.
 */
function xu(t, e, n) {
    return new Gu({
        s_: 3 /* Argument */ ,
        r_: e.settings.r_,
        methodName: t.e_,
        o_: n
    }, e.U, e.serializer, e.ignoreUndefinedProperties);
}

var Lu = /** @class */ function(e) {
    function n() {
        return null !== e && e.apply(this, arguments) || this;
    }
    return t(n, e), n.prototype.n_ = function(t) {
        return new In(t.path, new ln);
    }, n.prototype.isEqual = function(t) {
        return t instanceof n;
    }, n;
}(Du), Ru = /** @class */ function(e) {
    function n(t, n) {
        var r = this;
        return (r = e.call(this, t) || this).a_ = n, r;
    }
    return t(n, e), n.prototype.n_ = function(t) {
        var e = xu(this, t, 
        /*array=*/ !0), n = this.a_.map((function(t) {
            return Hu(t, e);
        })), r = new pn(n);
        return new In(t.path, r);
    }, n.prototype.isEqual = function(t) {
        // TODO(mrschmidt): Implement isEquals
        return this === t;
    }, n;
}(Du), Ou = /** @class */ function(e) {
    function n(t, n) {
        var r = this;
        return (r = e.call(this, t) || this).a_ = n, r;
    }
    return t(n, e), n.prototype.n_ = function(t) {
        var e = xu(this, t, 
        /*array=*/ !0), n = this.a_.map((function(t) {
            return Hu(t, e);
        })), r = new vn(n);
        return new In(t.path, r);
    }, n.prototype.isEqual = function(t) {
        // TODO(mrschmidt): Implement isEquals
        return this === t;
    }, n;
}(Du), Pu = /** @class */ function(e) {
    function n(t, n) {
        var r = this;
        return (r = e.call(this, t) || this).c_ = n, r;
    }
    return t(n, e), n.prototype.n_ = function(t) {
        var e = new mn(t.serializer, Le(t.serializer, this.c_));
        return new In(t.path, e);
    }, n.prototype.isEqual = function(t) {
        // TODO(mrschmidt): Implement isEquals
        return this === t;
    }, n;
}(Du), Vu = /** @class */ function() {
    /**
     * Creates a new immutable `GeoPoint` object with the provided latitude and
     * longitude values.
     * @param latitude The latitude as number between -90 and 90.
     * @param longitude The longitude as number between -180 and 180.
     */
    function t(t, e) {
        if (q("GeoPoint", arguments, 2), z("GeoPoint", "number", 1, t), z("GeoPoint", "number", 2, e), 
        !isFinite(t) || t < -90 || t > 90) throw new I(b.INVALID_ARGUMENT, "Latitude must be a number between -90 and 90, but was: " + t);
        if (!isFinite(e) || e < -180 || e > 180) throw new I(b.INVALID_ARGUMENT, "Longitude must be a number between -180 and 180, but was: " + e);
        this.u_ = t, this.h_ = e;
    }
    return Object.defineProperty(t.prototype, "latitude", {
        /**
         * The latitude of this `GeoPoint` instance.
         */
        get: function() {
            return this.u_;
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "longitude", {
        /**
         * The longitude of this `GeoPoint` instance.
         */
        get: function() {
            return this.h_;
        },
        enumerable: !1,
        configurable: !0
    }), 
    /**
     * Returns true if this `GeoPoint` is equal to the provided one.
     *
     * @param other The `GeoPoint` to compare against.
     * @return true if this `GeoPoint` is equal to the provided one.
     */
    t.prototype.isEqual = function(t) {
        return this.u_ === t.u_ && this.h_ === t.h_;
    }, t.prototype.toJSON = function() {
        return {
            latitude: this.u_,
            longitude: this.h_
        };
    }, 
    /**
     * Actually private to JS consumers of our API, so this function is prefixed
     * with an underscore.
     */
    t.prototype.Y = function(t) {
        return st(this.u_, t.u_) || st(this.h_, t.h_);
    }, t;
}(), Uu = function(t) {
    this.l_ = t;
}, Cu = /^__.*__$/, Fu = function(t, e, n) {
    this.__ = t, this.f_ = e, this.d_ = n;
}, Mu = /** @class */ function() {
    function t(t, e, n) {
        this.data = t, this.We = e, this.fieldTransforms = n;
    }
    return t.prototype.w_ = function(t, e) {
        var n = [];
        return null !== this.We ? n.push(new Rn(t, this.data, this.We, e)) : n.push(new Ln(t, this.data, e)), 
        this.fieldTransforms.length > 0 && n.push(new Pn(t, this.fieldTransforms)), n;
    }, t;
}(), qu = /** @class */ function() {
    function t(t, e, n) {
        this.data = t, this.We = e, this.fieldTransforms = n;
    }
    return t.prototype.w_ = function(t, e) {
        var n = [ new Rn(t, this.data, this.We, e) ];
        return this.fieldTransforms.length > 0 && n.push(new Pn(t, this.fieldTransforms)), 
        n;
    }, t;
}();

function ju(t) {
    switch (t) {
      case 0 /* Set */ :
 // fall through
              case 2 /* MergeSet */ :
 // fall through
              case 1 /* Update */ :
        return !0;

      case 3 /* Argument */ :
      case 4 /* ArrayArgument */ :
        return !1;

      default:
        throw D();
    }
}

/** A "context" object passed around while parsing user data. */ var Gu = /** @class */ function() {
    /**
     * Initializes a ParseContext with the given source and path.
     *
     * @param settings The settings for the parser.
     * @param databaseId The database ID of the Firestore instance.
     * @param serializer The serializer to use to generate the Value proto.
     * @param ignoreUndefinedProperties Whether to ignore undefined properties
     * rather than throw.
     * @param fieldTransforms A mutable list of field transforms encountered while
     *     parsing the data.
     * @param fieldMask A mutable list of field paths encountered while parsing
     *     the data.
     *
     * TODO(b/34871131): We don't support array paths right now, so path can be
     * null to indicate the context represents any location within an array (in
     * which case certain features will not work and errors will be somewhat
     * compromised).
     */
    function t(t, e, n, r, i, o) {
        this.settings = t, this.U = e, this.serializer = n, this.ignoreUndefinedProperties = r, 
        // Minor hack: If fieldTransforms is undefined, we assume this is an
        // external call and we need to validate the entire path.
        void 0 === i && this.m_(), this.fieldTransforms = i || [], this.We = o || [];
    }
    return Object.defineProperty(t.prototype, "path", {
        get: function() {
            return this.settings.path;
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "s_", {
        get: function() {
            return this.settings.s_;
        },
        enumerable: !1,
        configurable: !0
    }), 
    /** Returns a new context with the specified settings overwritten. */ t.prototype.T_ = function(e) {
        return new t(Object.assign(Object.assign({}, this.settings), e), this.U, this.serializer, this.ignoreUndefinedProperties, this.fieldTransforms, this.We);
    }, t.prototype.E_ = function(t) {
        var e, n = null === (e = this.path) || void 0 === e ? void 0 : e.child(t), r = this.T_({
            path: n,
            o_: !1
        });
        return r.I_(t), r;
    }, t.prototype.A_ = function(t) {
        var e, n = null === (e = this.path) || void 0 === e ? void 0 : e.child(t), r = this.T_({
            path: n,
            o_: !1
        });
        return r.m_(), r;
    }, t.prototype.R_ = function(t) {
        // TODO(b/34871131): We don't support array paths right now; so make path
        // undefined.
        return this.T_({
            path: void 0,
            o_: !0
        });
    }, t.prototype.i_ = function(t) {
        return ta(t, this.settings.methodName, this.settings.g_ || !1, this.path, this.settings.r_);
    }, 
    /** Returns 'true' if 'fieldPath' was traversed when creating this context. */ t.prototype.contains = function(t) {
        return void 0 !== this.We.find((function(e) {
            return t.T(e);
        })) || void 0 !== this.fieldTransforms.find((function(e) {
            return t.T(e.field);
        }));
    }, t.prototype.m_ = function() {
        // TODO(b/34871131): Remove null check once we have proper paths for fields
        // within arrays.
        if (this.path) for (var t = 0; t < this.path.length; t++) this.I_(this.path.get(t));
    }, t.prototype.I_ = function(t) {
        if (0 === t.length) throw this.i_("Document fields must not be empty");
        if (ju(this.s_) && Cu.test(t)) throw this.i_('Document fields cannot begin and end with "__"');
    }, t;
}(), zu = /** @class */ function() {
    function t(t, e, n) {
        this.U = t, this.ignoreUndefinedProperties = e, this.serializer = n || wu(t)
        /** Creates a new top-level parse context. */;
    }
    return t.prototype.P_ = function(t, e, n, r) {
        return void 0 === r && (r = !1), new Gu({
            s_: t,
            methodName: e,
            r_: n,
            path: C.P(),
            o_: !1,
            g_: r
        }, this.U, this.serializer, this.ignoreUndefinedProperties);
    }, t;
}();

/**
 * Helper for parsing raw user input (provided via the API) into internal model
 * classes.
 */
/** Parse document data from a set() call. */ function Bu(t, e, n, r, i, o) {
    void 0 === o && (o = {});
    var s = t.P_(o.merge || o.mergeFields ? 2 /* MergeSet */ : 0 /* Set */ , e, n, i);
    Xu("Data must be an object, but it was:", s, r);
    var u, a, c = Yu(r, s);
    if (o.merge) u = new bn(s.We), a = s.fieldTransforms; else if (o.mergeFields) {
        for (var h = [], f = 0, l = o.mergeFields; f < l.length; f++) {
            var p = l[f], d = void 0;
            if (p instanceof Nu) d = p.t_; else {
                if ("string" != typeof p) throw D();
                d = Zu(e, p, n);
            }
            if (!s.contains(d)) throw new I(b.INVALID_ARGUMENT, "Field '" + d + "' is specified in your field mask but missing from your input data.");
            ea(h, d) || h.push(d);
        }
        u = new bn(h), a = s.fieldTransforms.filter((function(t) {
            return u.Ye(t.field);
        }));
    } else u = null, a = s.fieldTransforms;
    return new Mu(new Mn(c), u, a);
}

/** Parse update data from an update() call. */ function Ku(t, e, n, r) {
    var i = t.P_(1 /* Update */ , e, n);
    Xu("Data must be an object, but it was:", i, r);
    var o = [], s = new qn;
    R(r, (function(t, r) {
        var u = Zu(e, t, n), a = i.A_(u);
        if (r instanceof ku || r instanceof Uu && r.l_ instanceof ku) 
        // Add it to the field mask, but don't add anything to updateData.
        o.push(u); else {
            var c = Hu(r, a);
            null != c && (o.push(u), s.set(u, c));
        }
    }));
    var u = new bn(o);
    return new qu(s.Xe(), u, i.fieldTransforms);
}

/** Parse update data from a list of field/value arguments. */ function Wu(t, e, n, r, i, o) {
    var s = t.P_(1 /* Update */ , e, n), u = [ Ju(e, r, n) ], a = [ i ];
    if (o.length % 2 != 0) throw new I(b.INVALID_ARGUMENT, "Function " + e + "() needs to be called with an even number of arguments that alternate between field names and values.");
    for (var c = 0; c < o.length; c += 2) u.push(Ju(e, o[c])), a.push(o[c + 1]);
    // We iterate in reverse order to pick the last value for a field if the
    // user specified the field multiple times.
    for (var h = [], f = new qn, l = u.length - 1; l >= 0; --l) if (!ea(h, u[l])) {
        var p = u[l], d = a[l], v = s.A_(p);
        if (d instanceof ku || d instanceof Uu && d.l_ instanceof ku) 
        // Add it to the field mask, but don't add anything to updateData.
        h.push(p); else {
            var y = Hu(d, v);
            null != y && (h.push(p), f.set(p, y));
        }
    }
    var m = new bn(h);
    return new qu(f.Xe(), m, s.fieldTransforms);
}

/**
 * Parse a "query value" (e.g. value in a where filter or a value in a cursor
 * bound).
 *
 * @param allowArrays Whether the query value is an array that may directly
 * contain additional arrays (e.g. the operand of an `in` query).
 */ function Qu(t, e, n, r) {
    return void 0 === r && (r = !1), Hu(n, t.P_(r ? 4 /* ArrayArgument */ : 3 /* Argument */ , e));
}

/**
 * Parses user data to Protobuf Values.
 *
 * @param input Data to be parsed.
 * @param context A context object representing the current path being parsed,
 * the source of the data being parsed, etc.
 * @return The parsed value, or null if the value was a FieldValue sentinel
 * that should not be included in the resulting parsed data.
 */ function Hu(t, e) {
    if (
    // Unwrap the API type from the Compat SDK. This will return the API type
    // from firestore-exp.
    t instanceof Uu && (t = t.l_), $u(t)) return Xu("Unsupported field value:", e, t), 
    Yu(t, e);
    if (t instanceof Du) 
    // FieldValues usually parse into transforms (except FieldValue.delete())
    // in which case we do not want to include this field in our parsed data
    // (as doing so will overwrite the field directly prior to the transform
    // trying to transform it). So we don't add this location to
    // context.fieldMask and we return null as our parsing result.
    /**
     * "Parses" the provided FieldValueImpl, adding any necessary transforms to
     * context.fieldTransforms.
     */
    return function(t, e) {
        // Sentinels are only supported with writes, and not within arrays.
        if (!ju(e.s_)) throw e.i_(t.e_ + "() can only be used with update() and set()");
        if (!e.path) throw e.i_(t.e_ + "() is not currently supported inside arrays");
        var n = t.n_(e);
        n && e.fieldTransforms.push(n);
    }(t, e), null;
    if (
    // If context.path is null we are inside an array and we don't support
    // field mask paths more granular than the top-level array.
    e.path && e.We.push(e.path), t instanceof Array) {
        // TODO(b/34871131): Include the path containing the array in the error
        // message.
        // In the case of IN queries, the parsed data is an array (representing
        // the set of values to be included for the IN query) that may directly
        // contain additional arrays (each representing an individual field
        // value), so we disable this validation.
        if (e.settings.o_ && 4 /* ArrayArgument */ !== e.s_) throw e.i_("Nested arrays are not supported");
        return function(t, e) {
            for (var n = [], r = 0, i = 0, o = t; i < o.length; i++) {
                var s = Hu(o[i], e.R_(r));
                null == s && (
                // Just include nulls in the array for fields being replaced with a
                // sentinel.
                s = {
                    nullValue: "NULL_VALUE"
                }), n.push(s), r++;
            }
            return {
                arrayValue: {
                    values: n
                }
            };
        }(t, e);
    }
    return function(t, e) {
        if (null === t) return {
            nullValue: "NULL_VALUE"
        };
        if ("number" == typeof t) return Le(e.serializer, t);
        if ("boolean" == typeof t) return {
            booleanValue: t
        };
        if ("string" == typeof t) return {
            stringValue: t
        };
        if (t instanceof Date) {
            var n = mt.fromDate(t);
            return {
                timestampValue: Re(e.serializer, n)
            };
        }
        if (t instanceof mt) {
            // Firestore backend truncates precision down to microseconds. To ensure
            // offline mode works the same with regards to truncation, perform the
            // truncation immediately without waiting for the backend to do that.
            var r = new mt(t.seconds, 1e3 * Math.floor(t.nanoseconds / 1e3));
            return {
                timestampValue: Re(e.serializer, r)
            };
        }
        if (t instanceof Vu) return {
            geoPointValue: {
                latitude: t.latitude,
                longitude: t.longitude
            }
        };
        if (t instanceof ht) return {
            bytesValue: Oe(e.serializer, t.q)
        };
        if (t instanceof Fu) {
            var i = e.U, o = t.__;
            if (!o.isEqual(i)) throw e.i_("Document reference is for database " + o.projectId + "/" + o.database + " but should be for database " + i.projectId + "/" + i.database);
            return {
                referenceValue: Ue(t.__ || e.U, t.f_.path)
            };
        }
        if (void 0 === t && e.ignoreUndefinedProperties) return null;
        throw e.i_("Unsupported field value: " + X(t));
    }(t, e);
}

function Yu(t, e) {
    var n = {};
    return O(t) ? 
    // If we encounter an empty object, we explicitly add it to the update
    // mask to ensure that the server creates a map entry.
    e.path && e.path.length > 0 && e.We.push(e.path) : R(t, (function(t, r) {
        var i = Hu(r, e.E_(t));
        null != i && (n[t] = i);
    })), {
        mapValue: {
            fields: n
        }
    };
}

function $u(t) {
    return !("object" != typeof t || null === t || t instanceof Array || t instanceof Date || t instanceof mt || t instanceof Vu || t instanceof ht || t instanceof Fu || t instanceof Du);
}

function Xu(t, e, n) {
    if (!$u(n) || !$(n)) {
        var r = X(n);
        throw "an object" === r ? e.i_(t + " a custom object") : e.i_(t + " " + r);
    }
}

/**
 * Helper that calls fromDotSeparatedString() but wraps any error thrown.
 */ function Ju(t, e, n) {
    if (e instanceof Nu) return e.t_;
    if ("string" == typeof e) return Zu(t, e);
    throw ta("Field path arguments must be of type string or FieldPath.", t, 
    /* hasConverter= */ !1, 
    /* path= */ void 0, n);
}

/**
 * Wraps fromDotSeparatedString with an error message about the method that
 * was thrown.
 * @param methodName The publicly visible method name
 * @param path The dot-separated string form of a field path which will be split
 * on dots.
 * @param targetDoc The document against which the field path will be evaluated.
 */ function Zu(t, e, n) {
    try {
        return function(t) {
            if (t.search(Su) >= 0) throw new I(b.INVALID_ARGUMENT, "Invalid field path (" + t + "). Paths must not contain '~', '*', '/', '[', or ']'");
            try {
                return new (Au.bind.apply(Au, r([ void 0 ], t.split("."))));
            } catch (e) {
                throw new I(b.INVALID_ARGUMENT, "Invalid field path (" + t + "). Paths must not be empty, begin with '.', end with '.', or contain '..'");
            }
        }(e).t_;
    } catch (e) {
        throw ta((i = e) instanceof Error ? i.message : i.toString(), t, 
        /* hasConverter= */ !1, 
        /* path= */ void 0, n);
    }
    /**
 * Extracts the message from a caught exception, which should be an Error object
 * though JS doesn't guarantee that.
 */    var i;
    /** Checks `haystack` if FieldPath `needle` is present. Runs in O(n). */}

function ta(t, e, n, r, i) {
    var o = r && !r.m(), s = void 0 !== i, u = "Function " + e + "() called with invalid data";
    n && (u += " (via `toFirestore()`)");
    var a = "";
    return (o || s) && (a += " (found", o && (a += " in field " + r), s && (a += " in document " + i), 
    a += ")"), new I(b.INVALID_ARGUMENT, (u += ". ") + t + a);
}

function ea(t, e) {
    return t.some((function(t) {
        return t.isEqual(e);
    }));
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Internal transaction object responsible for accumulating the mutations to
 * perform and the base versions for any documents read.
 */ var na = /** @class */ function() {
    function t(t) {
        this.Ku = t, 
        // The version of each document that was read during this transaction.
        this.y_ = new Map, this.mutations = [], this.V_ = !1, 
        /**
             * A deferred usage error that occurred previously in this transaction that
             * will cause the transaction to fail once it actually commits.
             */
        this.p_ = null, 
        /**
             * Set of documents that have been written in the transaction.
             *
             * When there's more than one write to the same key in a transaction, any
             * writes after the first are handled differently.
             */
        this.b_ = new Set;
    }
    return t.prototype.v_ = function(t) {
        return e(this, void 0, void 0, (function() {
            var r, i = this;
            return n(this, (function(o) {
                switch (o.label) {
                  case 0:
                    if (this.S_(), this.mutations.length > 0) throw new I(b.INVALID_ARGUMENT, "Firestore transactions require all reads to be executed before all writes.");
                    return [ 4 /*yield*/ , function(t, r) {
                        return e(this, void 0, void 0, (function() {
                            var e, i, o, s, u, a;
                            return n(this, (function(n) {
                                switch (n.label) {
                                  case 0:
                                    return e = x(t), i = Ge(e.serializer) + "/documents", o = {
                                        documents: r.map((function(t) {
                                            return Fe(e.serializer, t);
                                        }))
                                    }, [ 4 /*yield*/ , e.ku("BatchGetDocuments", i, o) ];

                                  case 1:
                                    return s = n.sent(), u = new Map, s.forEach((function(t) {
                                        var n = function(t, e) {
                                            return "found" in e ? function(t, e) {
                                                k(!!e.found), e.found.name, e.found.updateTime;
                                                var n = Me(t, e.found.name), r = Ve(e.found.updateTime), i = new Mn({
                                                    mapValue: {
                                                        fields: e.found.fields
                                                    }
                                                });
                                                return new zn(n, r, i, {});
                                            }(t, e) : "missing" in e ? function(t, e) {
                                                k(!!e.missing), k(!!e.readTime);
                                                var n = Me(t, e.missing), r = Ve(e.readTime);
                                                return new Bn(n, r);
                                            }(t, e) : D();
                                        }(e.serializer, t);
                                        u.set(n.key.toString(), n);
                                    })), a = [], [ 2 /*return*/ , (r.forEach((function(t) {
                                        var e = u.get(t.toString());
                                        k(!!e), a.push(e);
                                    })), a) ];
                                }
                            }));
                        }));
                    }(this.Ku, t) ];

                  case 1:
                    return [ 2 /*return*/ , ((r = o.sent()).forEach((function(t) {
                        t instanceof Bn || t instanceof zn ? i.D_(t) : D();
                    })), r) ];
                }
            }));
        }));
    }, t.prototype.set = function(t, e) {
        this.write(e.w_(t, this.Ge(t))), this.b_.add(t.toString());
    }, t.prototype.update = function(t, e) {
        try {
            this.write(e.w_(t, this.C_(t)));
        } catch (t) {
            this.p_ = t;
        }
        this.b_.add(t.toString());
    }, t.prototype.delete = function(t) {
        this.write([ new Cn(t, this.Ge(t)) ]), this.b_.add(t.toString());
    }, t.prototype.commit = function() {
        return e(this, void 0, void 0, (function() {
            var t, r = this;
            return n(this, (function(i) {
                switch (i.label) {
                  case 0:
                    if (this.S_(), this.p_) throw this.p_;
                    return t = this.y_, 
                    // For each mutation, note that the doc was written.
                    this.mutations.forEach((function(e) {
                        t.delete(e.key.toString());
                    })), 
                    // For each document that was read but not written to, we want to perform
                    // a `verify` operation.
                    t.forEach((function(t, e) {
                        var n = F.D(e);
                        r.mutations.push(new Fn(n, r.Ge(n)));
                    })), [ 4 /*yield*/ , function(t, r) {
                        return e(this, void 0, void 0, (function() {
                            var e, i, o;
                            return n(this, (function(n) {
                                switch (n.label) {
                                  case 0:
                                    return e = x(t), i = Ge(e.serializer) + "/documents", o = {
                                        writes: r.map((function(t) {
                                            return Ke(e.serializer, t);
                                        }))
                                    }, [ 4 /*yield*/ , e.$u("Commit", i, o) ];

                                  case 1:
                                    return n.sent(), [ 2 /*return*/ ];
                                }
                            }));
                        }));
                    }(this.Ku, this.mutations) ];

                  case 1:
                    // For each mutation, note that the doc was written.
                    return i.sent(), this.V_ = !0, [ 2 /*return*/ ];
                }
            }));
        }));
    }, t.prototype.D_ = function(t) {
        var e;
        if (t instanceof zn) e = t.version; else {
            if (!(t instanceof Bn)) throw D();
            // For deleted docs, we must use baseVersion 0 when we overwrite them.
                        e = gt.min();
        }
        var n = this.y_.get(t.key.toString());
        if (n) {
            if (!e.isEqual(n)) 
            // This transaction will fail no matter what.
            throw new I(b.ABORTED, "Document version changed between two reads.");
        } else this.y_.set(t.key.toString(), e);
    }, 
    /**
     * Returns the version of this document when it was read in this transaction,
     * as a precondition, or no precondition if it was not read.
     */
    t.prototype.Ge = function(t) {
        var e = this.y_.get(t.toString());
        return !this.b_.has(t.toString()) && e ? _n.updateTime(e) : _n.ze();
    }, 
    /**
     * Returns the precondition for a document if the operation is an update.
     */
    t.prototype.C_ = function(t) {
        var e = this.y_.get(t.toString());
        // The first time a document is written, we want to take into account the
        // read time and existence
                if (!this.b_.has(t.toString()) && e) {
            if (e.isEqual(gt.min())) 
            // The document doesn't exist, so fail the transaction.
            // This has to be validated locally because you can't send a
            // precondition that a document does not exist without changing the
            // semantics of the backend write to be an insert. This is the reverse
            // of what we want, since we want to assert that the document doesn't
            // exist but then send the update and have it fail. Since we can't
            // express that to the backend, we have to validate locally.
            // Note: this can change once we can send separate verify writes in the
            // transaction.
            throw new I(b.INVALID_ARGUMENT, "Can't update a document that doesn't exist.");
            // Document exists, base precondition on document update time.
                        return _n.updateTime(e);
        }
        // Document was not read, so we just use the preconditions for a blind
        // update.
                return _n.exists(!0);
    }, t.prototype.write = function(t) {
        this.S_(), this.mutations = this.mutations.concat(t);
    }, t.prototype.S_ = function() {}, t;
}(), ra = /** @class */ function() {
    function t(t, e, n, r) {
        this.cs = t, this.Ku = e, this.updateFunction = n, this.ls = r, this.N_ = 5, this.ys = new Sr(this.cs, "transaction_retry" /* TransactionRetry */)
        /** Runs the transaction and sets the result on deferred. */;
    }
    return t.prototype.run = function() {
        this.F_();
    }, t.prototype.F_ = function() {
        var t = this;
        this.ys.gn((function() {
            return e(t, void 0, void 0, (function() {
                var t, e, r = this;
                return n(this, (function(n) {
                    return t = new na(this.Ku), (e = this.x_(t)) && e.then((function(e) {
                        r.cs.ws((function() {
                            return t.commit().then((function() {
                                r.ls.resolve(e);
                            })).catch((function(t) {
                                r.k_(t);
                            }));
                        }));
                    })).catch((function(t) {
                        r.k_(t);
                    })), [ 2 /*return*/ ];
                }));
            }));
        }));
    }, t.prototype.x_ = function(t) {
        try {
            var e = this.updateFunction(t);
            return !wt(e) && e.catch && e.then ? e : (this.ls.reject(Error("Transaction callback must return a Promise")), 
            null);
        } catch (t) {
            // Do not retry errors thrown by user provided updateFunction.
            return this.ls.reject(t), null;
        }
    }, t.prototype.k_ = function(t) {
        var e = this;
        this.N_ > 0 && this.M_(t) ? (this.N_ -= 1, this.cs.ws((function() {
            return e.F_(), Promise.resolve();
        }))) : this.ls.reject(t);
    }, t.prototype.M_ = function(t) {
        if ("FirebaseError" === t.name) {
            // In transactions, the backend will fail outdated reads with FAILED_PRECONDITION and
            // non-matching document versions with ABORTED. These errors should be retried.
            var e = t.code;
            return "aborted" === e || "failed-precondition" === e || !Lt(e);
        }
        return !1;
    }, t;
}(), ia = /** @class */ function() {
    function t(t, 
    /**
     * Asynchronous queue responsible for all of our internal processing. When
     * we get incoming work from the user (via public API) or the network
     * (incoming GRPC messages), we should always schedule onto this queue.
     * This ensures all of our work is properly serialized (e.g. we don't
     * start processing a new operation while the previous one is waiting for
     * an async I/O to complete).
     */
    e) {
        this.credentials = t, this.cs = e, this.clientId = ot.k(), 
        // We defer our initialization until we get the current user from
        // setChangeListener(). We block the async queue until we got the initial
        // user and the initialization is completed. This will prevent any scheduled
        // work from happening before initialization is completed.
        // If initializationDone resolved then the FirestoreClient is in a usable
        // state.
        this.O_ = new Ar
        /**
     * Starts up the FirestoreClient, returning only whether or not enabling
     * persistence succeeded.
     *
     * The intent here is to "do the right thing" as far as users are concerned.
     * Namely, in cases where offline persistence is requested and possible,
     * enable it, but otherwise fall back to persistence disabled. For the most
     * part we expect this to succeed one way or the other so we don't expect our
     * users to actually wait on the firestore.enablePersistence Promise since
     * they generally won't care.
     *
     * Of course some users actually do care about whether or not persistence
     * was successfully enabled, so the Promise returned from this method
     * indicates this outcome.
     *
     * This presents a problem though: even before enablePersistence resolves or
     * rejects, users may have made calls to e.g. firestore.collection() which
     * means that the FirestoreClient in there will be available and will be
     * enqueuing actions on the async queue.
     *
     * Meanwhile any failure of an operation on the async queue causes it to
     * panic and reject any further work, on the premise that unhandled errors
     * are fatal.
     *
     * Consequently the fallback is handled internally here in start, and if the
     * fallback succeeds we signal success to the async queue even though the
     * start() itself signals failure.
     *
     * @param databaseInfo The connection information for the current instance.
     * @param offlineComponentProvider Provider that returns all components
     * required for memory-only or IndexedDB persistence.
     * @param onlineComponentProvider Provider that returns all components
     * required for online support.
     * @param persistenceSettings Settings object to configure offline
     *     persistence.
     * @returns A deferred result indicating the user-visible result of enabling
     *     offline persistence. This method will reject this if IndexedDB fails to
     *     start for any reason. If usePersistence is false this is
     *     unconditionally resolved.
     */;
    }
    return t.prototype.start = function(t, r, i, o) {
        var s = this;
        this.L_(), this.bl = t;
        // If usePersistence is true, certain classes of errors while starting are
        // recoverable but only by falling back to persistence disabled.
        // If there's an error in the first case but not in recovery we cannot
        // reject the promise blocking the async queue because this will cause the
        // async queue to panic.
        var u = new Ar, a = !1;
        // Return only the result of enabling persistence. Note that this does not
        // need to await the completion of initializationDone because the result of
        // this method should not reflect any other kind of failure to start.
        return this.credentials.Hc((function(t) {
            if (!a) return a = !0, T("FirestoreClient", "Initializing. user=", t.uid), s.B_(r, i, o, t, u).then(s.O_.resolve, s.O_.reject);
            s.cs.Cs((function() {
                return function(t, r) {
                    return e(this, void 0, void 0, (function() {
                        var e, i;
                        return n(this, (function(n) {
                            switch (n.label) {
                              case 0:
                                return (e = x(t)).cs.xs(), T("RemoteStore", "RemoteStore received new credentials"), 
                                i = cs(e), 
                                // Tear down and re-create our network streams. This will ensure we get a
                                // fresh auth token for the new user and re-fill the write pipeline with
                                // new mutations from the LocalStore (since mutations are per-user).
                                e.Yu.add(3 /* CredentialChange */), [ 4 /*yield*/ , es(e) ];

                              case 1:
                                return n.sent(), i && 
                                // Don't set the network status to Unknown if we are offline.
                                e.th.set("Unknown" /* Unknown */), [ 4 /*yield*/ , e.Gu.Jl(r) ];

                              case 2:
                                return n.sent(), e.Yu.delete(3 /* CredentialChange */), [ 4 /*yield*/ , ts(e) ];

                              case 3:
                                // Tear down and re-create our network streams. This will ensure we get a
                                // fresh auth token for the new user and re-fill the write pipeline with
                                // new mutations from the LocalStore (since mutations are per-user).
                                return n.sent(), [ 2 /*return*/ ];
                            }
                        }));
                    }));
                }(s.ph, t);
            }));
        })), 
        // Block the async queue until initialization is done
        this.cs.ws((function() {
            return s.O_.promise;
        })), u.promise;
    }, 
    /** Enables the network connection and requeues all pending operations. */ t.prototype.enableNetwork = function() {
        var t = this;
        return this.L_(), this.cs.enqueue((function() {
            return t.persistence.tc(!0), function(t) {
                var e = x(t);
                return e.Yu.delete(0 /* UserDisabled */), ts(e);
            }(t.ph);
        }));
    }, 
    /**
     * Initializes persistent storage, attempting to use IndexedDB if
     * usePersistence is true or memory-only if false.
     *
     * If IndexedDB fails because it's already open in another tab or because the
     * platform can't possibly support our implementation then this method rejects
     * the persistenceResult and falls back on memory-only persistence.
     *
     * @param offlineComponentProvider Provider that returns all components
     * required for memory-only or IndexedDB persistence.
     * @param onlineComponentProvider Provider that returns all components
     * required for online support.
     * @param persistenceSettings Settings object to configure offline persistence
     * @param user The initial user
     * @param persistenceResult A deferred result indicating the user-visible
     *     result of enabling offline persistence. This method will reject this if
     *     IndexedDB fails to start for any reason. If usePersistence is false
     *     this is unconditionally resolved.
     * @returns a Promise indicating whether or not initialization should
     *     continue, i.e. that one of the persistence implementations actually
     *     succeeded.
     */
    t.prototype.B_ = function(t, r, i, o, s) {
        return e(this, void 0, void 0, (function() {
            var u, a, c = this;
            return n(this, (function(h) {
                switch (h.label) {
                  case 0:
                    return h.trys.push([ 0, 3, , 4 ]), u = {
                        cs: this.cs,
                        bl: this.bl,
                        clientId: this.clientId,
                        credentials: this.credentials,
                        Wl: o,
                        Dh: 100,
                        persistenceSettings: i
                    }, [ 4 /*yield*/ , t.initialize(u) ];

                  case 1:
                    return h.sent(), [ 4 /*yield*/ , r.initialize(t, u) ];

                  case 2:
                    return h.sent(), this.persistence = t.persistence, this.Sh = t.Sh, this.ju = t.ju, 
                    this.ql = t.ql, this.Ku = r.Ku, this.ph = r.ph, this.fi = r.fi, this.q_ = r.bh, 
                    this.q_.Us = Rs.bind(null, this.fi), this.q_.js = Ps.bind(null, this.fi), 
                    // When a user calls clearPersistence() in one client, all other clients
                    // need to be terminated to allow the delete to succeed.
                    this.persistence.Za((function() {
                        return e(c, void 0, void 0, (function() {
                            return n(this, (function(t) {
                                switch (t.label) {
                                  case 0:
                                    return [ 4 /*yield*/ , this.terminate() ];

                                  case 1:
                                    return t.sent(), [ 2 /*return*/ ];
                                }
                            }));
                        }));
                    })), s.resolve(), [ 3 /*break*/ , 4 ];

                  case 3:
                    // An unknown failure on the first stage shuts everything down.
                    if (a = h.sent(), 
                    // Regardless of whether or not the retry succeeds, from an user
                    // perspective, offline persistence has failed.
                    s.reject(a), !this.U_(a)) throw a;
                    return [ 2 /*return*/ , (console.warn("Error enabling offline persistence. Falling back to persistence disabled: " + a), 
                    this.B_(new Iu, new _u, {
                        jl: !1
                    }, o, s)) ];

                  case 4:
                    return [ 2 /*return*/ ];
                }
            }));
        }));
    }, 
    /**
     * Decides whether the provided error allows us to gracefully disable
     * persistence (as opposed to crashing the client).
     */
    t.prototype.U_ = function(t) {
        return "FirebaseError" === t.name ? t.code === b.FAILED_PRECONDITION || t.code === b.UNIMPLEMENTED : !("undefined" != typeof DOMException && t instanceof DOMException) || 
        // When the browser is out of quota we could get either quota exceeded
        // or an aborted error depending on whether the error happened during
        // schema migration.
        22 === t.code || 20 === t.code || 
        // Firefox Private Browsing mode disables IndexedDb and returns
        // INVALID_STATE for any usage.
        11 === t.code;
    }, 
    /**
     * Checks that the client has not been terminated. Ensures that other methods on
     * this class cannot be called after the client is terminated.
     */
    t.prototype.L_ = function() {
        if (this.cs.ps) throw new I(b.FAILED_PRECONDITION, "The client has already been terminated.");
    }, 
    /** Disables the network connection. Pending operations will not complete. */ t.prototype.disableNetwork = function() {
        var t = this;
        return this.L_(), this.cs.enqueue((function() {
            return t.persistence.tc(!1), function(t) {
                return e(this, void 0, void 0, (function() {
                    var e;
                    return n(this, (function(n) {
                        switch (n.label) {
                          case 0:
                            return (e = x(t)).Yu.add(0 /* UserDisabled */), [ 4 /*yield*/ , es(e) ];

                          case 1:
                            return n.sent(), 
                            // Set the OnlineState to Offline so get()s return from cache, etc.
                            e.th.set("Offline" /* Offline */), [ 2 /*return*/ ];
                        }
                    }));
                }));
            }(t.ph);
        }));
    }, t.prototype.terminate = function() {
        var t = this;
        this.cs.Ds();
        var r = new Ar;
        return this.cs.bs((function() {
            return e(t, void 0, void 0, (function() {
                var t, e;
                return n(this, (function(n) {
                    switch (n.label) {
                      case 0:
                        return n.trys.push([ 0, 4, , 5 ]), 
                        // PORTING NOTE: LocalStore does not need an explicit shutdown on web.
                        this.ql && this.ql.stop(), [ 4 /*yield*/ , ns(this.ph) ];

                      case 1:
                        return n.sent(), [ 4 /*yield*/ , this.Sh.Di() ];

                      case 2:
                        return n.sent(), [ 4 /*yield*/ , this.persistence.Di() ];

                      case 3:
                        // PORTING NOTE: LocalStore does not need an explicit shutdown on web.
                        return n.sent(), 
                        // `removeChangeListener` must be called after shutting down the
                        // RemoteStore as it will prevent the RemoteStore from retrieving
                        // auth tokens.
                        this.credentials.Yc(), r.resolve(), [ 3 /*break*/ , 5 ];

                      case 4:
                        return t = n.sent(), e = Gr(t, "Failed to shutdown persistence"), r.reject(e), [ 3 /*break*/ , 5 ];

                      case 5:
                        return [ 2 /*return*/ ];
                    }
                }));
            }));
        })), r.promise;
    }, 
    /**
     * Returns a Promise that resolves when all writes that were pending at the time this
     * method was called received server acknowledgement. An acknowledgement can be either acceptance
     * or rejection.
     */
    t.prototype.waitForPendingWrites = function() {
        var t = this;
        this.L_();
        var r = new Ar;
        return this.cs.ws((function() {
            return function(t, r) {
                return e(this, void 0, void 0, (function() {
                    var e, i, o, s, u;
                    return n(this, (function(n) {
                        switch (n.label) {
                          case 0:
                            cs((e = x(t)).ph) || T("SyncEngine", "The network is disabled. The task returned by 'awaitPendingWrites()' will not complete until the network is enabled."), 
                            n.label = 1;

                          case 1:
                            return n.trys.push([ 1, 3, , 4 ]), [ 4 /*yield*/ , function(t) {
                                var e = x(t);
                                return e.persistence.runTransaction("Get highest unacknowledged batch id", "readonly", (function(t) {
                                    return e.Sr.qo(t);
                                }));
                            }(e.ju) ];

                          case 2:
                            return -1 === (i = n.sent()) ? [ 2 /*return*/ , void r.resolve() ] : ((o = e.Lh.get(i) || []).push(r), 
                            e.Lh.set(i, o), [ 3 /*break*/ , 4 ]);

                          case 3:
                            return s = n.sent(), u = Gr(s, "Initialization of waitForPendingWrites() operation failed"), 
                            r.reject(u), [ 3 /*break*/ , 4 ];

                          case 4:
                            return [ 2 /*return*/ ];
                        }
                    }));
                }));
            }(t.fi, r);
        })), r.promise;
    }, t.prototype.listen = function(t, e, n) {
        var r = this;
        this.L_();
        var i = new Tu(n), o = new $r(t, i, e);
        return this.cs.ws((function() {
            return Kr(r.q_, o);
        })), function() {
            i.Zl(), r.cs.ws((function() {
                return Wr(r.q_, o);
            }));
        };
    }, t.prototype.Q_ = function(t) {
        return e(this, void 0, void 0, (function() {
            var r, i = this;
            return n(this, (function(o) {
                switch (o.label) {
                  case 0:
                    return this.L_(), [ 4 /*yield*/ , this.O_.promise ];

                  case 1:
                    return o.sent(), r = new Ar, [ 2 /*return*/ , (this.cs.ws((function() {
                        return function(t, r, i) {
                            return e(this, void 0, void 0, (function() {
                                var e, o, s;
                                return n(this, (function(n) {
                                    switch (n.label) {
                                      case 0:
                                        return n.trys.push([ 0, 2, , 3 ]), [ 4 /*yield*/ , function(t, e) {
                                            var n = x(t);
                                            return n.persistence.runTransaction("read document", "readonly", (function(t) {
                                                return n.Cc.Cr(t, e);
                                            }));
                                        }(t, r) ];

                                      case 1:
                                        return (e = n.sent()) instanceof zn ? i.resolve(e) : e instanceof Bn ? i.resolve(null) : i.reject(new I(b.UNAVAILABLE, "Failed to get document from cache. (However, this document may exist on the server. Run again without setting 'source' in the GetOptions to attempt to retrieve the document from the server.)")), 
                                        [ 3 /*break*/ , 3 ];

                                      case 2:
                                        return o = n.sent(), s = Gr(o, "Failed to get document '" + r + " from cache"), 
                                        i.reject(s), [ 3 /*break*/ , 3 ];

                                      case 3:
                                        return [ 2 /*return*/ ];
                                    }
                                }));
                            }));
                        }(i.ju, t, r);
                    })), r.promise) ];
                }
            }));
        }));
    }, t.prototype.W_ = function(t, r) {
        return void 0 === r && (r = {}), e(this, void 0, void 0, (function() {
            var e, i = this;
            return n(this, (function(n) {
                switch (n.label) {
                  case 0:
                    return this.L_(), [ 4 /*yield*/ , this.O_.promise ];

                  case 1:
                    return n.sent(), e = new Ar, [ 2 /*return*/ , (this.cs.ws((function() {
                        return function(t, e, n, r, i) {
                            var o = new Tu({
                                next: function(o) {
                                    // Remove query first before passing event to user to avoid
                                    // user actions affecting the now stale query.
                                    e.ws((function() {
                                        return Wr(t, s);
                                    }));
                                    var u = o.docs.has(n);
                                    !u && o.fromCache ? 
                                    // TODO(dimond): If we're online and the document doesn't
                                    // exist then we resolve with a doc.exists set to false. If
                                    // we're offline however, we reject the Promise in this
                                    // case. Two options: 1) Cache the negative response from
                                    // the server so we can deliver that even when you're
                                    // offline 2) Actually reject the Promise in the online case
                                    // if the document doesn't exist.
                                    i.reject(new I(b.UNAVAILABLE, "Failed to get document because the client is offline.")) : u && o.fromCache && r && "server" === r.source ? i.reject(new I(b.UNAVAILABLE, 'Failed to get document from server. (However, this document does exist in the local cache. Run again without setting source to "server" to retrieve the cached document.)')) : i.resolve(o);
                                },
                                error: function(t) {
                                    return i.reject(t);
                                }
                            }), s = new $r(Hn(n.path), o, {
                                includeMetadataChanges: !0,
                                Xs: !0
                            });
                            return Kr(t, s);
                        }(i.q_, i.cs, t, r, e);
                    })), e.promise) ];
                }
            }));
        }));
    }, t.prototype.j_ = function(t) {
        return e(this, void 0, void 0, (function() {
            var r, i = this;
            return n(this, (function(o) {
                switch (o.label) {
                  case 0:
                    return this.L_(), [ 4 /*yield*/ , this.O_.promise ];

                  case 1:
                    return o.sent(), r = new Ar, [ 2 /*return*/ , (this.cs.ws((function() {
                        return function(t, r, i) {
                            return e(this, void 0, void 0, (function() {
                                var e, o, s, u, a, c;
                                return n(this, (function(n) {
                                    switch (n.label) {
                                      case 0:
                                        return n.trys.push([ 0, 2, , 3 ]), [ 4 /*yield*/ , Uo(t, r, 
                                        /* usePreviousResults= */ !0) ];

                                      case 1:
                                        return e = n.sent(), o = new Ds(r, e.Fc), s = o.wh(e.documents), u = o.yr(s, 
                                        /* updateLimboDocuments= */ !1), i.resolve(u.snapshot), [ 3 /*break*/ , 3 ];

                                      case 2:
                                        return a = n.sent(), c = Gr(a, "Failed to execute query '" + r + " against cache"), 
                                        i.reject(c), [ 3 /*break*/ , 3 ];

                                      case 3:
                                        return [ 2 /*return*/ ];
                                    }
                                }));
                            }));
                        }(i.ju, t, r);
                    })), r.promise) ];
                }
            }));
        }));
    }, t.prototype.K_ = function(t, r) {
        return void 0 === r && (r = {}), e(this, void 0, void 0, (function() {
            var e, i = this;
            return n(this, (function(n) {
                switch (n.label) {
                  case 0:
                    return this.L_(), [ 4 /*yield*/ , this.O_.promise ];

                  case 1:
                    return n.sent(), e = new Ar, [ 2 /*return*/ , (this.cs.ws((function() {
                        return function(t, e, n, r, i) {
                            var o = new Tu({
                                next: function(n) {
                                    // Remove query first before passing event to user to avoid
                                    // user actions affecting the now stale query.
                                    e.ws((function() {
                                        return Wr(t, s);
                                    })), n.fromCache && "server" === r.source ? i.reject(new I(b.UNAVAILABLE, 'Failed to get documents from server. (However, these documents may exist in the local cache. Run again without setting source to "server" to retrieve the cached documents.)')) : i.resolve(n);
                                },
                                error: function(t) {
                                    return i.reject(t);
                                }
                            }), s = new $r(n, o, {
                                includeMetadataChanges: !0,
                                Xs: !0
                            });
                            return Kr(t, s);
                        }(i.q_, i.cs, t, r, e);
                    })), e.promise) ];
                }
            }));
        }));
    }, t.prototype.write = function(t) {
        var r = this;
        this.L_();
        var i = new Ar;
        return this.cs.ws((function() {
            return function(t, r, i) {
                return e(this, void 0, void 0, (function() {
                    var e, o, s, u;
                    return n(this, (function(n) {
                        switch (n.label) {
                          case 0:
                            e = ou(t), n.label = 1;

                          case 1:
                            return n.trys.push([ 1, 5, , 6 ]), [ 4 /*yield*/ , 
                            /* Accepts locally generated Mutations and commit them to storage. */
                            function(t, e) {
                                var n, r = x(t), i = mt.now(), o = e.reduce((function(t, e) {
                                    return t.add(e.key);
                                }), Kt());
                                return r.persistence.runTransaction("Locally write mutations", "readwrite", (function(t) {
                                    return r.Cc.kr(t, o).next((function(o) {
                                        n = o;
                                        for (
                                        // For non-idempotent mutations (such as `FieldValue.increment()`),
                                        // we record the base state in a separate patch mutation. This is
                                        // later used to guarantee consistent values and prevents flicker
                                        // even if the backend sends us an update that already includes our
                                        // transform.
                                        var s = [], u = 0, a = e; u < a.length; u++) {
                                            var c = a[u], h = Dn(c, n.get(c.key));
                                            null != h && 
                                            // NOTE: The base state should only be applied if there's some
                                            // existing document to override, so use a Precondition of
                                            // exists=true
                                            s.push(new Rn(c.key, h, jn(h.proto.mapValue), _n.exists(!0)));
                                        }
                                        return r.Sr.ko(t, i, s, e);
                                    }));
                                })).then((function(t) {
                                    var e = t.lr(n);
                                    return {
                                        batchId: t.batchId,
                                        wr: e
                                    };
                                }));
                            }(e.ju, r) ];

                          case 2:
                            return o = n.sent(), e.Sh.xi(o.batchId), function(t, e, n) {
                                var r = t.Oh[t.currentUser.ti()];
                                r || (r = new Ot(st)), r = r.ot(e, n), t.Oh[t.currentUser.ti()] = r;
                            }(e, o.batchId, i), [ 4 /*yield*/ , Qs(e, o.wr) ];

                          case 3:
                            return n.sent(), [ 4 /*yield*/ , ys(e.ph) ];

                          case 4:
                            return n.sent(), [ 3 /*break*/ , 6 ];

                          case 5:
                            return s = n.sent(), u = Gr(s, "Failed to persist write"), i.reject(u), [ 3 /*break*/ , 6 ];

                          case 6:
                            return [ 2 /*return*/ ];
                        }
                    }));
                }));
            }(r.fi, t, i);
        })), i.promise;
    }, t.prototype.U = function() {
        return this.bl.U;
    }, t.prototype.G_ = function(t) {
        var r = this;
        this.L_();
        var i = new Tu(t);
        return this.cs.ws((function() {
            return e(r, void 0, void 0, (function() {
                return n(this, (function(t) {
                    return [ 2 /*return*/ , function(t, e) {
                        x(t).qs.add(e), 
                        // Immediately fire an initial event, indicating all existing listeners
                        // are in-sync.
                        e.next();
                    }(this.q_, i) ];
                }));
            }));
        })), function() {
            i.Zl(), r.cs.ws((function() {
                return e(r, void 0, void 0, (function() {
                    return n(this, (function(t) {
                        return [ 2 /*return*/ , function(t, e) {
                            x(t).qs.delete(e);
                        }(this.q_, i) ];
                    }));
                }));
            }));
        };
    }, Object.defineProperty(t.prototype, "z_", {
        get: function() {
            // Technically, the asyncQueue is still running, but only accepting operations
            // related to termination or supposed to be run after termination. It is effectively
            // terminated to the eyes of users.
            return this.cs.ps;
        },
        enumerable: !1,
        configurable: !0
    }), 
    /**
     * Takes an updateFunction in which a set of reads and writes can be performed
     * atomically. In the updateFunction, the client can read and write values
     * using the supplied transaction object. After the updateFunction, all
     * changes will be committed. If a retryable error occurs (ex: some other
     * client has changed any of the data referenced), then the updateFunction
     * will be called again after a backoff. If the updateFunction still fails
     * after all retries, then the transaction will be rejected.
     *
     * The transaction object passed to the updateFunction contains methods for
     * accessing documents and collections. Unlike other datastore access, data
     * accessed with the transaction will not reflect local changes that have not
     * been committed. For this reason, it is required that all reads are
     * performed before any writes. Transactions must be performed while online.
     */
    t.prototype.transaction = function(t) {
        var e = this;
        this.L_();
        var n = new Ar;
        return this.cs.ws((function() {
            return new ra(e.cs, e.Ku, t, n).run(), Promise.resolve();
        })), n.promise;
    }, t;
}();

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * TransactionRunner encapsulates the logic needed to run and retry transactions
 * with backoff.
 */ function oa(t) {
    /**
 * Returns true if obj is an object and contains at least one of the specified
 * methods.
 */
    return function(t, e) {
        if ("object" != typeof t || null === t) return !1;
        for (var n = t, r = 0, i = [ "next", "error", "complete" ]; r < i.length; r++) {
            var o = i[r];
            if (o in n && "function" == typeof n[o]) return !0;
        }
        return !1;
    }(t);
}

var sa = /** @class */ function() {
    function t(t, e, n, r, i) {
        this.U = t, this.timestampsInSnapshots = e, this.H_ = n, this.Y_ = r, this.J_ = i;
    }
    return t.prototype.X_ = function(t) {
        switch (he(t)) {
          case 0 /* NullValue */ :
            return null;

          case 1 /* BooleanValue */ :
            return t.booleanValue;

          case 2 /* NumberValue */ :
            return ge(t.integerValue || t.doubleValue);

          case 3 /* TimestampValue */ :
            return this.Z_(t.timestampValue);

          case 4 /* ServerTimestampValue */ :
            return this.tf(t);

          case 5 /* StringValue */ :
            return t.stringValue;

          case 6 /* BlobValue */ :
            return this.J_(we(t.bytesValue));

          case 7 /* RefValue */ :
            return this.ef(t.referenceValue);

          case 8 /* GeoPointValue */ :
            return this.nf(t.geoPointValue);

          case 9 /* ArrayValue */ :
            return this.sf(t.arrayValue);

          case 10 /* ObjectValue */ :
            return this.if(t.mapValue);

          default:
            throw D();
        }
    }, t.prototype.if = function(t) {
        var e = this, n = {};
        return R(t.fields || {}, (function(t, r) {
            n[t] = e.X_(r);
        })), n;
    }, t.prototype.nf = function(t) {
        return new Vu(ge(t.latitude), ge(t.longitude));
    }, t.prototype.sf = function(t) {
        var e = this;
        return (t.values || []).map((function(t) {
            return e.X_(t);
        }));
    }, t.prototype.tf = function(t) {
        switch (this.H_) {
          case "previous":
            var e = ue(t);
            return null == e ? null : this.X_(e);

          case "estimate":
            return this.Z_(ae(t));

          default:
            return null;
        }
    }, t.prototype.Z_ = function(t) {
        var e = me(t), n = new mt(e.seconds, e.nanos);
        return this.timestampsInSnapshots ? n : n.toDate();
    }, t.prototype.ef = function(t) {
        var e = V.g(t);
        k(un(e));
        var n = new vt(e.get(1), e.get(3)), r = new F(e.u(5));
        return n.isEqual(this.U) || 
        // TODO(b/64130202): Somehow support foreign references.
        N("Document " + r + " contains a document reference within a different database (" + n.projectId + "/" + n.database + ") which is not supported. It will be treated as a reference in the current database (" + this.U.projectId + "/" + this.U.database + ") instead."), 
        this.Y_(r);
    }, t;
}(), ua = wi.ho, aa = /** @class */ function() {
    function t(t) {
        var e, n, r, i, o;
        if (void 0 === t.host) {
            if (void 0 !== t.ssl) throw new I(b.INVALID_ARGUMENT, "Can't provide ssl option if host option is not set");
            this.host = "firestore.googleapis.com", this.ssl = !0;
        } else K("settings", "non-empty string", "host", t.host), this.host = t.host, W("settings", "boolean", "ssl", t.ssl), 
        this.ssl = null === (e = t.ssl) || void 0 === e || e;
        if (Z("settings", t, [ "host", "ssl", "credentials", "timestampsInSnapshots", "cacheSizeBytes", "experimentalForceLongPolling", "experimentalAutoDetectLongPolling", "ignoreUndefinedProperties" ]), 
        W("settings", "object", "credentials", t.credentials), this.credentials = t.credentials, 
        W("settings", "boolean", "timestampsInSnapshots", t.timestampsInSnapshots), W("settings", "boolean", "ignoreUndefinedProperties", t.ignoreUndefinedProperties), 
        // Nobody should set timestampsInSnapshots anymore, but the error depends on
        // whether they set it to true or false...
        !0 === t.timestampsInSnapshots ? N("The setting 'timestampsInSnapshots: true' is no longer required and should be removed.") : !1 === t.timestampsInSnapshots && N("Support for 'timestampsInSnapshots: false' will be removed soon. You must update your code to handle Timestamp objects."), 
        this.timestampsInSnapshots = null === (n = t.timestampsInSnapshots) || void 0 === n || n, 
        this.ignoreUndefinedProperties = null !== (r = t.ignoreUndefinedProperties) && void 0 !== r && r, 
        W("settings", "number", "cacheSizeBytes", t.cacheSizeBytes), void 0 === t.cacheSizeBytes) this.cacheSizeBytes = wi._o; else {
            if (t.cacheSizeBytes !== ua && t.cacheSizeBytes < wi.lo) throw new I(b.INVALID_ARGUMENT, "cacheSizeBytes must be at least " + wi.lo);
            this.cacheSizeBytes = t.cacheSizeBytes;
        }
        W("settings", "boolean", "experimentalForceLongPolling", t.experimentalForceLongPolling), 
        this.experimentalForceLongPolling = null !== (i = t.experimentalForceLongPolling) && void 0 !== i && i, 
        W("settings", "boolean", "experimentalAutoDetectLongPolling", t.experimentalAutoDetectLongPolling), 
        this.experimentalAutoDetectLongPolling = null !== (o = t.experimentalAutoDetectLongPolling) && void 0 !== o && o, 
        function(t, e, n, r) {
            if (!0 === e && !0 === r) throw new I(b.INVALID_ARGUMENT, "experimentalForceLongPolling and experimentalAutoDetectLongPolling cannot be used together.");
        }(0, t.experimentalForceLongPolling, 0, t.experimentalAutoDetectLongPolling);
    }
    return t.prototype.isEqual = function(t) {
        return this.host === t.host && this.ssl === t.ssl && this.timestampsInSnapshots === t.timestampsInSnapshots && this.credentials === t.credentials && this.cacheSizeBytes === t.cacheSizeBytes && this.experimentalForceLongPolling === t.experimentalForceLongPolling && this.experimentalAutoDetectLongPolling === t.experimentalAutoDetectLongPolling && this.ignoreUndefinedProperties === t.ignoreUndefinedProperties;
    }, t;
}(), ca = /** @class */ function() {
    // Note: We are using `MemoryComponentProvider` as a default
    // ComponentProvider to ensure backwards compatibility with the format
    // expected by the console build.
    function t(r, i, o, s) {
        var u = this;
        if (void 0 === o && (o = new Iu), void 0 === s && (s = new _u), this.rf = o, this.af = s, 
        this.cf = null, 
        // Public for use in tests.
        // TODO(mikelehen): Use modularized initialization instead.
        this.uf = new jr, this.INTERNAL = {
            delete: function() {
                return e(u, void 0, void 0, (function() {
                    return n(this, (function(t) {
                        switch (t.label) {
                          case 0:
                            // The client must be initalized to ensure that all subsequent API usage
                            // throws an exception.
                            return this.hf(), [ 4 /*yield*/ , this.lf.terminate() ];

                          case 1:
                            // The client must be initalized to ensure that all subsequent API usage
                            // throws an exception.
                            return t.sent(), [ 2 /*return*/ ];
                        }
                    }));
                }));
            }
        }, "object" == typeof r.options) {
            // This is very likely a Firebase app object
            // TODO(b/34177605): Can we somehow use instanceof?
            var a = r;
            this.cf = a, this.__ = t._f(a), this.ff = a.name, this.df = new Ko(i);
        } else {
            var c = r;
            if (!c.projectId) throw new I(b.INVALID_ARGUMENT, "Must provide projectId");
            this.__ = new vt(c.projectId, c.database), 
            // Use a default persistenceKey that lines up with FirebaseApp.
            this.ff = "[DEFAULT]", this.df = new Bo;
        }
        this.wf = new aa({});
    }
    return Object.defineProperty(t.prototype, "mf", {
        get: function() {
            return this.Tf || (
            // Lazy initialize UserDataReader once the settings are frozen
            this.Tf = new zu(this.__, this.wf.ignoreUndefinedProperties)), this.Tf;
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.settings = function(t) {
        q("Firestore.settings", arguments, 1), z("Firestore.settings", "object", 1, t), 
        t.merge && 
        // Remove the property from the settings once the merge is completed
        delete (t = Object.assign(Object.assign({}, this.wf), t)).merge;
        var e = new aa(t);
        if (this.lf && !this.wf.isEqual(e)) throw new I(b.FAILED_PRECONDITION, "Firestore has already been started and its settings can no longer be changed. You can only call settings() before calling any other methods on a Firestore object.");
        this.wf = e, void 0 !== e.credentials && (this.df = function(t) {
            if (!t) return new Bo;
            switch (t.type) {
              case "gapi":
                var e = t.client;
                // Make sure this really is a Gapi client.
                                return k(!("object" != typeof e || null === e || !e.auth || !e.auth.getAuthHeaderValueForFirstParty)), 
                new Qo(e, t.sessionIndex || "0");

              case "provider":
                return t.client;

              default:
                throw new I(b.INVALID_ARGUMENT, "makeCredentialsProvider failed due to invalid credential type");
            }
        }(e.credentials));
    }, t.prototype.enableNetwork = function() {
        return this.hf(), this.lf.enableNetwork();
    }, t.prototype.disableNetwork = function() {
        return this.hf(), this.lf.disableNetwork();
    }, t.prototype.enablePersistence = function(t) {
        var e, n;
        if (this.lf) throw new I(b.FAILED_PRECONDITION, "Firestore has already been started and persistence can no longer be enabled. You can only call enablePersistence() before calling any other methods on a Firestore object.");
        var r = !1, i = !1;
        if (t && (void 0 !== t.experimentalTabSynchronization && N("The 'experimentalTabSynchronization' setting will be removed. Use 'synchronizeTabs' instead."), 
        r = null !== (n = null !== (e = t.synchronizeTabs) && void 0 !== e ? e : t.experimentalTabSynchronization) && void 0 !== n && n, 
        i = !!t.experimentalForceOwningTab && t.experimentalForceOwningTab, r && i)) throw new I(b.INVALID_ARGUMENT, "The 'experimentalForceOwningTab' setting cannot be used with 'synchronizeTabs'.");
        return this.Ef(this.rf, this.af, {
            jl: !0,
            cacheSizeBytes: this.wf.cacheSizeBytes,
            synchronizeTabs: r,
            ka: i
        });
    }, t.prototype.clearPersistence = function() {
        return e(this, void 0, void 0, (function() {
            var t, r = this;
            return n(this, (function(i) {
                if (void 0 !== this.lf && !this.lf.z_) throw new I(b.FAILED_PRECONDITION, "Persistence can only be cleared before a Firestore instance is initialized or after it is terminated.");
                return t = new Ar, [ 2 /*return*/ , (this.uf.bs((function() {
                    return e(r, void 0, void 0, (function() {
                        var e;
                        return n(this, (function(n) {
                            switch (n.label) {
                              case 0:
                                return n.trys.push([ 0, 2, , 3 ]), [ 4 /*yield*/ , this.rf.clearPersistence(this.__, this.ff) ];

                              case 1:
                                return n.sent(), t.resolve(), [ 3 /*break*/ , 3 ];

                              case 2:
                                return e = n.sent(), t.reject(e), [ 3 /*break*/ , 3 ];

                              case 3:
                                return [ 2 /*return*/ ];
                            }
                        }));
                    }));
                })), t.promise) ];
            }));
        }));
    }, t.prototype.terminate = function() {
        return this.app._removeServiceInstance("firestore"), this.INTERNAL.delete();
    }, Object.defineProperty(t.prototype, "If", {
        get: function() {
            return this.hf(), this.lf.z_;
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.waitForPendingWrites = function() {
        return this.hf(), this.lf.waitForPendingWrites();
    }, t.prototype.onSnapshotsInSync = function(t) {
        if (this.hf(), oa(t)) return this.lf.G_(t);
        z("Firestore.onSnapshotsInSync", "function", 1, t);
        var e = {
            next: t
        };
        return this.lf.G_(e);
    }, t.prototype.hf = function() {
        return this.lf || 
        // Kick off starting the client but don't actually wait for it.
        // eslint-disable-next-line @typescript-eslint/no-floating-promises
        this.Ef(new Iu, new _u, {
            jl: !1
        }), this.lf;
    }, t.prototype.Af = function() {
        return new dt(this.__, this.ff, this.wf.host, this.wf.ssl, this.wf.experimentalForceLongPolling, this.wf.experimentalAutoDetectLongPolling);
    }, t.prototype.Ef = function(t, e, n) {
        var r = this.Af();
        return this.lf = new ia(this.df, this.uf), this.lf.start(r, t, e, n);
    }, t._f = function(t) {
        if (e = t.options, "projectId", !Object.prototype.hasOwnProperty.call(e, "projectId")) throw new I(b.INVALID_ARGUMENT, '"projectId" not provided in firebase.initializeApp.');
        var e, n = t.options.projectId;
        if (!n || "string" != typeof n) throw new I(b.INVALID_ARGUMENT, "projectId must be a string in FirebaseApp.options");
        return new vt(n);
    }, Object.defineProperty(t.prototype, "app", {
        get: function() {
            if (!this.cf) throw new I(b.FAILED_PRECONDITION, "Firestore was not initialized using the Firebase SDK. 'app' is not available");
            return this.cf;
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.collection = function(t) {
        return q("Firestore.collection", arguments, 1), z("Firestore.collection", "non-empty string", 1, t), 
        this.hf(), new Ta(V.g(t), this, 
        /* converter= */ null);
    }, t.prototype.doc = function(t) {
        return q("Firestore.doc", arguments, 1), z("Firestore.doc", "non-empty string", 1, t), 
        this.hf(), la.Rf(V.g(t), this, 
        /* converter= */ null);
    }, t.prototype.collectionGroup = function(t) {
        if (q("Firestore.collectionGroup", arguments, 1), z("Firestore.collectionGroup", "non-empty string", 1, t), 
        t.indexOf("/") >= 0) throw new I(b.INVALID_ARGUMENT, "Invalid collection ID '" + t + "' passed to function Firestore.collectionGroup(). Collection IDs must not contain '/'.");
        return this.hf(), new Ea(
        /**
 * Creates a new Query for a collection group query that matches all documents
 * within the provided collection group.
 */
        function(t) {
            return new Wn(V.P(), t);
        }(t), this, 
        /* converter= */ null);
    }, t.prototype.runTransaction = function(t) {
        var e = this;
        return q("Firestore.runTransaction", arguments, 1), z("Firestore.runTransaction", "function", 1, t), 
        this.hf().transaction((function(n) {
            return t(new ha(e, n));
        }));
    }, t.prototype.batch = function() {
        return this.hf(), new fa(this);
    }, Object.defineProperty(t, "logLevel", {
        get: function() {
            switch (_()) {
              case s.DEBUG:
                return "debug";

              case s.ERROR:
                return "error";

              case s.SILENT:
                return "silent";

              case s.WARN:
                return "warn";

              case s.INFO:
                return "info";

              case s.VERBOSE:
                return "verbose";

              default:
                // The default log level is error
                return "error";
            }
        },
        enumerable: !1,
        configurable: !0
    }), t.setLogLevel = function(t) {
        var e;
        q("Firestore.setLogLevel", arguments, 1), H("setLogLevel", [ "debug", "error", "silent", "warn", "info", "verbose" ], 1, t), 
        e = t, E.setLogLevel(e);
    }, 
    // Note: this is not a property because the minifier can't work correctly with
    // the way TypeScript compiler outputs properties.
    t.prototype.gf = function() {
        return this.wf.timestampsInSnapshots;
    }, 
    // Visible for testing.
    t.prototype.Pf = function() {
        return this.wf;
    }, t;
}(), ha = /** @class */ function() {
    function t(t, e) {
        this.yf = t, this.Vf = e;
    }
    return t.prototype.get = function(t) {
        var e = this;
        q("Transaction.get", arguments, 1);
        var n = Da("Transaction.get", t, this.yf);
        return this.Vf.v_([ n.f_ ]).then((function(t) {
            if (!t || 1 !== t.length) return D();
            var r = t[0];
            if (r instanceof Bn) return new da(e.yf, n.f_, null, 
            /* fromCache= */ !1, 
            /* hasPendingWrites= */ !1, n.d_);
            if (r instanceof zn) return new da(e.yf, n.f_, r, 
            /* fromCache= */ !1, 
            /* hasPendingWrites= */ !1, n.d_);
            throw D();
        }));
    }, t.prototype.set = function(t, e, n) {
        G("Transaction.set", arguments, 2, 3);
        var r = Da("Transaction.set", t, this.yf);
        n = Na("Transaction.set", n);
        var i = xa(r.d_, e, n), o = Bu(this.yf.mf, "Transaction.set", r.f_, i, null !== r.d_, n);
        return this.Vf.set(r.f_, o), this;
    }, t.prototype.update = function(t, e, n) {
        for (var r, i, o = [], s = 3; s < arguments.length; s++) o[s - 3] = arguments[s];
        return "string" == typeof e || e instanceof Au ? (j("Transaction.update", arguments, 3), 
        r = Da("Transaction.update", t, this.yf), i = Wu(this.yf.mf, "Transaction.update", r.f_, e, n, o)) : (q("Transaction.update", arguments, 2), 
        r = Da("Transaction.update", t, this.yf), i = Ku(this.yf.mf, "Transaction.update", r.f_, e)), 
        this.Vf.update(r.f_, i), this;
    }, t.prototype.delete = function(t) {
        q("Transaction.delete", arguments, 1);
        var e = Da("Transaction.delete", t, this.yf);
        return this.Vf.delete(e.f_), this;
    }, t;
}(), fa = /** @class */ function() {
    function t(t) {
        this.yf = t, this.pf = [], this.bf = !1;
    }
    return t.prototype.set = function(t, e, n) {
        G("WriteBatch.set", arguments, 2, 3), this.vf();
        var r = Da("WriteBatch.set", t, this.yf);
        n = Na("WriteBatch.set", n);
        var i = xa(r.d_, e, n), o = Bu(this.yf.mf, "WriteBatch.set", r.f_, i, null !== r.d_, n);
        return this.pf = this.pf.concat(o.w_(r.f_, _n.ze())), this;
    }, t.prototype.update = function(t, e, n) {
        for (var r, i, o = [], s = 3; s < arguments.length; s++) o[s - 3] = arguments[s];
        return this.vf(), "string" == typeof e || e instanceof Au ? (j("WriteBatch.update", arguments, 3), 
        r = Da("WriteBatch.update", t, this.yf), i = Wu(this.yf.mf, "WriteBatch.update", r.f_, e, n, o)) : (q("WriteBatch.update", arguments, 2), 
        r = Da("WriteBatch.update", t, this.yf), i = Ku(this.yf.mf, "WriteBatch.update", r.f_, e)), 
        this.pf = this.pf.concat(i.w_(r.f_, _n.exists(!0))), this;
    }, t.prototype.delete = function(t) {
        q("WriteBatch.delete", arguments, 1), this.vf();
        var e = Da("WriteBatch.delete", t, this.yf);
        return this.pf = this.pf.concat(new Cn(e.f_, _n.ze())), this;
    }, t.prototype.commit = function() {
        return this.vf(), this.bf = !0, this.pf.length > 0 ? this.yf.hf().write(this.pf) : Promise.resolve();
    }, t.prototype.vf = function() {
        if (this.bf) throw new I(b.FAILED_PRECONDITION, "A write batch can no longer be used after commit() has been called.");
    }, t;
}(), la = /** @class */ function(e) {
    function n(t, n, r) {
        var i = this;
        return (i = e.call(this, n.__, t, r) || this).f_ = t, i.firestore = n, i.d_ = r, 
        i.lf = i.firestore.hf(), i;
    }
    return t(n, e), n.Rf = function(t, e, r) {
        if (t.length % 2 != 0) throw new I(b.INVALID_ARGUMENT, "Invalid document reference. Document references must have an even number of segments, but " + t.R() + " has " + t.length);
        return new n(new F(t), e, r);
    }, Object.defineProperty(n.prototype, "id", {
        get: function() {
            return this.f_.path._();
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(n.prototype, "parent", {
        get: function() {
            return new Ta(this.f_.path.h(), this.firestore, this.d_);
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(n.prototype, "path", {
        get: function() {
            return this.f_.path.R();
        },
        enumerable: !1,
        configurable: !0
    }), n.prototype.collection = function(t) {
        if (q("DocumentReference.collection", arguments, 1), z("DocumentReference.collection", "non-empty string", 1, t), 
        !t) throw new I(b.INVALID_ARGUMENT, "Must provide a non-empty collection name to collection()");
        var e = V.g(t);
        return new Ta(this.f_.path.child(e), this.firestore, 
        /* converter= */ null);
    }, n.prototype.isEqual = function(t) {
        if (!(t instanceof n)) throw tt("isEqual", "DocumentReference", 1, t);
        return this.firestore === t.firestore && this.f_.isEqual(t.f_) && this.d_ === t.d_;
    }, n.prototype.set = function(t, e) {
        G("DocumentReference.set", arguments, 1, 2), e = Na("DocumentReference.set", e);
        var n = xa(this.d_, t, e), r = Bu(this.firestore.mf, "DocumentReference.set", this.f_, n, null !== this.d_, e);
        return this.lf.write(r.w_(this.f_, _n.ze()));
    }, n.prototype.update = function(t, e) {
        for (var n, r = [], i = 2; i < arguments.length; i++) r[i - 2] = arguments[i];
        return "string" == typeof t || t instanceof Au ? (j("DocumentReference.update", arguments, 2), 
        n = Wu(this.firestore.mf, "DocumentReference.update", this.f_, t, e, r)) : (q("DocumentReference.update", arguments, 1), 
        n = Ku(this.firestore.mf, "DocumentReference.update", this.f_, t)), this.lf.write(n.w_(this.f_, _n.exists(!0)));
    }, n.prototype.delete = function() {
        return q("DocumentReference.delete", arguments, 0), this.lf.write([ new Cn(this.f_, _n.ze()) ]);
    }, n.prototype.onSnapshot = function() {
        for (var t, e, n, r = this, i = [], o = 0; o < arguments.length; o++) i[o] = arguments[o];
        G("DocumentReference.onSnapshot", arguments, 1, 4);
        var s = {
            includeMetadataChanges: !1
        }, u = 0;
        "object" != typeof i[u] || oa(i[u]) || (Z("DocumentReference.onSnapshot", s = i[u], [ "includeMetadataChanges" ]), 
        W("DocumentReference.onSnapshot", "boolean", "includeMetadataChanges", s.includeMetadataChanges), 
        u++);
        var a = {
            includeMetadataChanges: s.includeMetadataChanges
        };
        if (oa(i[u])) {
            var c = i[u];
            i[u] = null === (t = c.next) || void 0 === t ? void 0 : t.bind(c), i[u + 1] = null === (e = c.error) || void 0 === e ? void 0 : e.bind(c), 
            i[u + 2] = null === (n = c.complete) || void 0 === n ? void 0 : n.bind(c);
        } else z("DocumentReference.onSnapshot", "function", u, i[u]), B("DocumentReference.onSnapshot", "function", u + 1, i[u + 1]), 
        B("DocumentReference.onSnapshot", "function", u + 2, i[u + 2]);
        var h = {
            next: function(t) {
                i[u] && i[u](r.Sf(t));
            },
            error: i[u + 1],
            complete: i[u + 2]
        };
        return this.lf.listen(Hn(this.f_.path), a, h);
    }, n.prototype.get = function(t) {
        var e = this;
        G("DocumentReference.get", arguments, 0, 1), Sa("DocumentReference.get", t);
        var n = this.firestore.hf();
        return t && "cache" === t.source ? n.Q_(this.f_).then((function(t) {
            return new da(e.firestore, e.f_, t, 
            /*fromCache=*/ !0, t instanceof zn && t.Je, e.d_);
        })) : n.W_(this.f_, t).then((function(t) {
            return e.Sf(t);
        }));
    }, n.prototype.withConverter = function(t) {
        return new n(this.f_, this.firestore, t);
    }, 
    /**
     * Converts a ViewSnapshot that contains the current document to a
     * DocumentSnapshot.
     */
    n.prototype.Sf = function(t) {
        var e = t.docs.get(this.f_);
        return new da(this.firestore, this.f_, e, t.fromCache, t.hasPendingWrites, this.d_);
    }, n;
}(Fu), pa = /** @class */ function() {
    function t(t, e) {
        this.hasPendingWrites = t, this.fromCache = e
        /**
     * Returns true if this `SnapshotMetadata` is equal to the provided one.
     *
     * @param other The `SnapshotMetadata` to compare against.
     * @return true if this `SnapshotMetadata` is equal to the provided one.
     */;
    }
    return t.prototype.isEqual = function(t) {
        return this.hasPendingWrites === t.hasPendingWrites && this.fromCache === t.fromCache;
    }, t;
}(), da = /** @class */ function() {
    function t(t, e, n, r, i, o) {
        this.yf = t, this.f_ = e, this.Df = n, this.Cf = r, this.Nf = i, this.d_ = o;
    }
    return t.prototype.data = function(t) {
        var e = this;
        if (G("DocumentSnapshot.data", arguments, 0, 1), t = Aa("DocumentSnapshot.data", t), 
        this.Df) {
            // We only want to use the converter and create a new DocumentSnapshot
            // if a converter has been provided.
            if (this.d_) {
                var n = new va(this.yf, this.f_, this.Df, this.Cf, this.Nf, 
                /* converter= */ null);
                return this.d_.fromFirestore(n, t);
            }
            return new sa(this.yf.__, this.yf.gf(), t.serverTimestamps || "none", (function(t) {
                return new la(t, e.yf, /* converter= */ null);
            }), (function(t) {
                return new pt(t);
            })).X_(this.Df.rn());
        }
    }, t.prototype.get = function(t, e) {
        var n = this;
        if (G("DocumentSnapshot.get", arguments, 1, 2), e = Aa("DocumentSnapshot.get", e), 
        this.Df) {
            var r = this.Df.data().field(Ju("DocumentSnapshot.get", t, this.f_));
            if (null !== r) return new sa(this.yf.__, this.yf.gf(), e.serverTimestamps || "none", (function(t) {
                return new la(t, n.yf, n.d_);
            }), (function(t) {
                return new pt(t);
            })).X_(r);
        }
    }, Object.defineProperty(t.prototype, "id", {
        get: function() {
            return this.f_.path._();
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "ref", {
        get: function() {
            return new la(this.f_, this.yf, this.d_);
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "exists", {
        get: function() {
            return null !== this.Df;
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "metadata", {
        get: function() {
            return new pa(this.Nf, this.Cf);
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.isEqual = function(e) {
        if (!(e instanceof t)) throw tt("isEqual", "DocumentSnapshot", 1, e);
        return this.yf === e.yf && this.Cf === e.Cf && this.f_.isEqual(e.f_) && (null === this.Df ? null === e.Df : this.Df.isEqual(e.Df)) && this.d_ === e.d_;
    }, t;
}(), va = /** @class */ function(e) {
    function n() {
        return null !== e && e.apply(this, arguments) || this;
    }
    return t(n, e), n.prototype.data = function(t) {
        return e.prototype.data.call(this, t);
    }, n;
}(da);

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// settings() defaults:
function ya(t, e, n, r, i, o, s) {
    var u;
    if (i.p()) {
        if ("array-contains" /* ARRAY_CONTAINS */ === o || "array-contains-any" /* ARRAY_CONTAINS_ANY */ === o) throw new I(b.INVALID_ARGUMENT, "Invalid Query. You can't perform '" + o + "' queries on FieldPath.documentId().");
        if ("in" /* IN */ === o || "not-in" /* NOT_IN */ === o) {
            wa(s, o);
            for (var a = [], c = 0, h = s; c < h.length; c++) {
                var f = h[c];
                a.push(ga(r, t, f));
            }
            u = {
                arrayValue: {
                    values: a
                }
            };
        } else u = ga(r, t, s);
    } else "in" /* IN */ !== o && "not-in" /* NOT_IN */ !== o && "array-contains-any" /* ARRAY_CONTAINS_ANY */ !== o || wa(s, o), 
    u = Qu(n, e, s, 
    /* allowArrays= */ "in" /* IN */ === o || "not-in" /* NOT_IN */ === o);
    var l = hr.create(i, o, u);
    return function(t, e) {
        if (e.hn()) {
            var n = Jn(t);
            if (null !== n && !n.isEqual(e.field)) throw new I(b.INVALID_ARGUMENT, "Invalid query. All where filters with an inequality (<, <=, >, or >=) must be on the same field. But you have inequality filters on '" + n.toString() + "' and '" + e.field.toString() + "'");
            var r = Xn(t);
            null !== r && ba(t, e.field, r);
        }
        var i = function(t, e) {
            for (var n = 0, r = t.filters; n < r.length; n++) {
                var i = r[n];
                if (e.indexOf(i.op) >= 0) return i.op;
            }
            return null;
        }(t, 
        /**
 * Given an operator, returns the set of operators that cannot be used with it.
 *
 * Operators in a query must adhere to the following set of rules:
 * 1. Only one array operator is allowed.
 * 2. Only one disjunctive operator is allowed.
 * 3. NOT_EQUAL cannot be used with another NOT_EQUAL operator.
 * 4. NOT_IN cannot be used with array, disjunctive, or NOT_EQUAL operators.
 *
 * Array operators: ARRAY_CONTAINS, ARRAY_CONTAINS_ANY
 * Disjunctive operators: IN, ARRAY_CONTAINS_ANY, NOT_IN
 */
        function(t) {
            switch (t) {
              case "!=" /* NOT_EQUAL */ :
                return [ "!=" /* NOT_EQUAL */ , "not-in" /* NOT_IN */ ];

              case "array-contains" /* ARRAY_CONTAINS */ :
                return [ "array-contains" /* ARRAY_CONTAINS */ , "array-contains-any" /* ARRAY_CONTAINS_ANY */ , "not-in" /* NOT_IN */ ];

              case "in" /* IN */ :
                return [ "array-contains-any" /* ARRAY_CONTAINS_ANY */ , "in" /* IN */ , "not-in" /* NOT_IN */ ];

              case "array-contains-any" /* ARRAY_CONTAINS_ANY */ :
                return [ "array-contains" /* ARRAY_CONTAINS */ , "array-contains-any" /* ARRAY_CONTAINS_ANY */ , "in" /* IN */ , "not-in" /* NOT_IN */ ];

              case "not-in" /* NOT_IN */ :
                return [ "array-contains" /* ARRAY_CONTAINS */ , "array-contains-any" /* ARRAY_CONTAINS_ANY */ , "in" /* IN */ , "not-in" /* NOT_IN */ , "!=" /* NOT_EQUAL */ ];

              default:
                return [];
            }
        }(e.op));
        if (null !== i) 
        // Special case when it's a duplicate op to give a slightly clearer error message.
        throw i === e.op ? new I(b.INVALID_ARGUMENT, "Invalid query. You cannot use more than one '" + e.op.toString() + "' filter.") : new I(b.INVALID_ARGUMENT, "Invalid query. You cannot use '" + e.op.toString() + "' filters with '" + i.toString() + "' filters.");
    }(t, l), l;
}

function ma(t, e, n) {
    if (null !== t.startAt) throw new I(b.INVALID_ARGUMENT, "Invalid query. You must not call startAt() or startAfter() before calling orderBy().");
    if (null !== t.endAt) throw new I(b.INVALID_ARGUMENT, "Invalid query. You must not call endAt() or endBefore() before calling orderBy().");
    var r = new _r(e, n);
    return function(t, e) {
        if (null === Xn(t)) {
            // This is the first order by. It must match any inequality.
            var n = Jn(t);
            null !== n && ba(t, n, e.field);
        }
    }(t, r), r
    /**
 * Create a Bound from a query and a document.
 *
 * Note that the Bound will always include the key of the document
 * and so only the provided document will compare equal to the returned
 * position.
 *
 * Will throw if the document does not contain all fields of the order by
 * of the query or if any of the fields in the order by are an uncommitted
 * server timestamp.
 */
    /**
 * Parses the given documentIdValue into a ReferenceValue, throwing
 * appropriate errors if the value is anything other than a DocumentReference
 * or String, or if the string is malformed.
 */;
}

function ga(t, e, n) {
    if ("string" == typeof n) {
        if ("" === n) throw new I(b.INVALID_ARGUMENT, "Invalid query. When querying with FieldPath.documentId(), you must provide a valid document ID, but it was an empty string.");
        if (!Zn(e) && -1 !== n.indexOf("/")) throw new I(b.INVALID_ARGUMENT, "Invalid query. When querying a collection by FieldPath.documentId(), you must provide a plain document ID, but '" + n + "' contains a '/' character.");
        var r = e.path.child(V.g(n));
        if (!F.F(r)) throw new I(b.INVALID_ARGUMENT, "Invalid query. When querying a collection group by FieldPath.documentId(), the value provided must result in a valid document path, but '" + r + "' is not because it has an odd number of segments (" + r.length + ").");
        return be(t, new F(r));
    }
    if (n instanceof Fu) return be(t, n.f_);
    throw new I(b.INVALID_ARGUMENT, "Invalid query. When querying with FieldPath.documentId(), you must provide a valid string or a DocumentReference, but it was: " + X(n) + ".");
}

/**
 * Validates that the value passed into a disjunctive filter satisfies all
 * array requirements.
 */ function wa(t, e) {
    if (!Array.isArray(t) || 0 === t.length) throw new I(b.INVALID_ARGUMENT, "Invalid Query. A non-empty array is required for '" + e.toString() + "' filters.");
    if (t.length > 10) throw new I(b.INVALID_ARGUMENT, "Invalid Query. '" + e.toString() + "' filters support a maximum of 10 elements in the value array.");
    if ("in" /* IN */ === e || "array-contains-any" /* ARRAY_CONTAINS_ANY */ === e) {
        if (t.indexOf(null) >= 0) throw new I(b.INVALID_ARGUMENT, "Invalid Query. '" + e.toString() + "' filters cannot contain 'null' in the value array.");
        if (t.filter((function(t) {
            return Number.isNaN(t);
        })).length > 0) throw new I(b.INVALID_ARGUMENT, "Invalid Query. '" + e.toString() + "' filters cannot contain 'NaN' in the value array.");
    }
}

function ba(t, e, n) {
    if (!n.isEqual(e)) throw new I(b.INVALID_ARGUMENT, "Invalid query. You have a where filter with an inequality (<, <=, >, or >=) on field '" + e.toString() + "' and so you must also use '" + e.toString() + "' as your first orderBy(), but your first orderBy() is on field '" + n.toString() + "' instead.");
}

function Ia(t) {
    if ($n(t) && 0 === t.on.length) throw new I(b.UNIMPLEMENTED, "limitToLast() queries require specifying at least one orderBy() clause");
}

var Ea = /** @class */ function() {
    function t(t, e, n) {
        this.Ff = t, this.firestore = e, this.d_ = n;
    }
    return t.prototype.where = function(e, n, r) {
        q("Query.where", arguments, 3), J("Query.where", 3, r);
        // Enumerated from the WhereFilterOp type in index.d.ts.
        var i = H("Query.where", [ "<" /* LESS_THAN */ , "<=" /* LESS_THAN_OR_EQUAL */ , "==" /* EQUAL */ , "!=" /* NOT_EQUAL */ , ">=" /* GREATER_THAN_OR_EQUAL */ , ">" /* GREATER_THAN */ , "array-contains" /* ARRAY_CONTAINS */ , "in" /* IN */ , "array-contains-any" /* ARRAY_CONTAINS_ANY */ , "not-in" /* NOT_IN */ ], 2, n), o = Ju("Query.where", e), s = ya(this.Ff, "Query.where", this.firestore.mf, this.firestore.__, o, i, r);
        return new t(function(t, e) {
            var n = t.filters.concat([ e ]);
            return new Wn(t.path, t.collectionGroup, t.on.slice(), n, t.limit, t.an, t.startAt, t.endAt);
        }(this.Ff, s), this.firestore, this.d_);
    }, t.prototype.orderBy = function(e, n) {
        var r;
        if (G("Query.orderBy", arguments, 1, 2), B("Query.orderBy", "non-empty string", 2, n), 
        void 0 === n || "asc" === n) r = "asc" /* ASCENDING */; else {
            if ("desc" !== n) throw new I(b.INVALID_ARGUMENT, "Function Query.orderBy() has unknown direction '" + n + "', expected 'asc' or 'desc'.");
            r = "desc" /* DESCENDING */;
        }
        var i = Ju("Query.orderBy", e), o = ma(this.Ff, i, r);
        return new t(function(t, e) {
            // TODO(dimond): validate that orderBy does not list the same key twice.
            var n = t.on.concat([ e ]);
            return new Wn(t.path, t.collectionGroup, n, t.filters.slice(), t.limit, t.an, t.startAt, t.endAt);
        }(this.Ff, o), this.firestore, this.d_);
    }, t.prototype.limit = function(e) {
        return q("Query.limit", arguments, 1), z("Query.limit", "number", 1, e), et("Query.limit", 1, e), 
        new t(nr(this.Ff, e, "F" /* First */), this.firestore, this.d_);
    }, t.prototype.limitToLast = function(e) {
        return q("Query.limitToLast", arguments, 1), z("Query.limitToLast", "number", 1, e), 
        et("Query.limitToLast", 1, e), new t(nr(this.Ff, e, "L" /* Last */), this.firestore, this.d_);
    }, t.prototype.startAt = function(e) {
        for (var n = [], r = 1; r < arguments.length; r++) n[r - 1] = arguments[r];
        j("Query.startAt", arguments, 1);
        var i = this.xf("Query.startAt", e, n, 
        /*before=*/ !0);
        return new t(rr(this.Ff, i), this.firestore, this.d_);
    }, t.prototype.startAfter = function(e) {
        for (var n = [], r = 1; r < arguments.length; r++) n[r - 1] = arguments[r];
        j("Query.startAfter", arguments, 1);
        var i = this.xf("Query.startAfter", e, n, 
        /*before=*/ !1);
        return new t(rr(this.Ff, i), this.firestore, this.d_);
    }, t.prototype.endBefore = function(e) {
        for (var n = [], r = 1; r < arguments.length; r++) n[r - 1] = arguments[r];
        j("Query.endBefore", arguments, 1);
        var i = this.xf("Query.endBefore", e, n, 
        /*before=*/ !0);
        return new t(ir(this.Ff, i), this.firestore, this.d_);
    }, t.prototype.endAt = function(e) {
        for (var n = [], r = 1; r < arguments.length; r++) n[r - 1] = arguments[r];
        j("Query.endAt", arguments, 1);
        var i = this.xf("Query.endAt", e, n, 
        /*before=*/ !1);
        return new t(ir(this.Ff, i), this.firestore, this.d_);
    }, t.prototype.isEqual = function(e) {
        if (!(e instanceof t)) throw tt("isEqual", "Query", 1, e);
        return this.firestore === e.firestore && or(this.Ff, e.Ff) && this.d_ === e.d_;
    }, t.prototype.withConverter = function(e) {
        return new t(this.Ff, this.firestore, e);
    }, 
    /** Helper function to create a bound from a document or fields */ t.prototype.xf = function(t, e, n, i) {
        if (J(t, 1, e), e instanceof da) return q(t, r([ e ], n), 1), function(t, e, n, r, i) {
            if (!r) throw new I(b.NOT_FOUND, "Can't use a DocumentSnapshot that doesn't exist for " + n + "().");
            // Because people expect to continue/end a query at the exact document
            // provided, we need to use the implicit sort order rather than the explicit
            // sort order, because it's guaranteed to contain the document key. That way
            // the position becomes unambiguous and the query continues/ends exactly at
            // the provided document. Without the key (by using the explicit sort
            // orders), multiple documents could match the position, yielding duplicate
            // results.
            for (var o = [], s = 0, u = tr(t); s < u.length; s++) {
                var a = u[s];
                if (a.field.p()) o.push(be(e, r.key)); else {
                    var c = r.field(a.field);
                    if (se(c)) throw new I(b.INVALID_ARGUMENT, 'Invalid query. You are trying to start or end a query using a document for which the field "' + a.field + '" is an uncommitted server timestamp. (Since the value of this field is unknown, you cannot start/end a query with it.)');
                    if (null === c) {
                        var h = a.field.R();
                        throw new I(b.INVALID_ARGUMENT, "Invalid query. You are trying to start or end a query using a document for which the field '" + h + "' (used as the orderBy) does not exist.");
                    }
                    o.push(c);
                }
            }
            return new wr(o, i);
        }(this.Ff, this.firestore.__, t, e.Df, i);
        var o = [ e ].concat(n);
        return function(t, e, n, r, i, o) {
            // Use explicit order by's because it has to match the query the user made
            var s = t.on;
            if (i.length > s.length) throw new I(b.INVALID_ARGUMENT, "Too many arguments provided to " + r + "(). The number of arguments must be less than or equal to the number of orderBy() clauses");
            for (var u = [], a = 0; a < i.length; a++) {
                var c = i[a];
                if (s[a].field.p()) {
                    if ("string" != typeof c) throw new I(b.INVALID_ARGUMENT, "Invalid query. Expected a string for document ID in " + r + "(), but got a " + typeof c);
                    if (!Zn(t) && -1 !== c.indexOf("/")) throw new I(b.INVALID_ARGUMENT, "Invalid query. When querying a collection and ordering by FieldPath.documentId(), the value passed to " + r + "() must be a plain document ID, but '" + c + "' contains a slash.");
                    var h = t.path.child(V.g(c));
                    if (!F.F(h)) throw new I(b.INVALID_ARGUMENT, "Invalid query. When querying a collection group and ordering by FieldPath.documentId(), the value passed to " + r + "() must result in a valid document path, but '" + h + "' is not because it contains an odd number of segments.");
                    var f = new F(h);
                    u.push(be(e, f));
                } else {
                    var l = Qu(n, r, c);
                    u.push(l);
                }
            }
            return new wr(u, o);
        }(this.Ff, this.firestore.__, this.firestore.mf, t, o, i);
    }, t.prototype.onSnapshot = function() {
        for (var t, e, n, r = this, i = [], o = 0; o < arguments.length; o++) i[o] = arguments[o];
        G("Query.onSnapshot", arguments, 1, 4);
        var s = {}, u = 0;
        if ("object" != typeof i[u] || oa(i[u]) || (Z("Query.onSnapshot", s = i[u], [ "includeMetadataChanges" ]), 
        W("Query.onSnapshot", "boolean", "includeMetadataChanges", s.includeMetadataChanges), 
        u++), oa(i[u])) {
            var a = i[u];
            i[u] = null === (t = a.next) || void 0 === t ? void 0 : t.bind(a), i[u + 1] = null === (e = a.error) || void 0 === e ? void 0 : e.bind(a), 
            i[u + 2] = null === (n = a.complete) || void 0 === n ? void 0 : n.bind(a);
        } else z("Query.onSnapshot", "function", u, i[u]), B("Query.onSnapshot", "function", u + 1, i[u + 1]), 
        B("Query.onSnapshot", "function", u + 2, i[u + 2]);
        var c = {
            next: function(t) {
                i[u] && i[u](new _a(r.firestore, r.Ff, t, r.d_));
            },
            error: i[u + 1],
            complete: i[u + 2]
        };
        return Ia(this.Ff), this.firestore.hf().listen(this.Ff, s, c);
    }, t.prototype.get = function(t) {
        var e = this;
        G("Query.get", arguments, 0, 1), Sa("Query.get", t), Ia(this.Ff);
        var n = this.firestore.hf();
        return (t && "cache" === t.source ? n.j_(this.Ff) : n.K_(this.Ff, t)).then((function(t) {
            return new _a(e.firestore, e.Ff, t, e.d_);
        }));
    }, t;
}(), _a = /** @class */ function() {
    function t(t, e, n, r) {
        this.yf = t, this.$f = e, this.kf = n, this.d_ = r, this.Mf = null, this.Of = null, 
        this.metadata = new pa(n.hasPendingWrites, n.fromCache);
    }
    return Object.defineProperty(t.prototype, "docs", {
        get: function() {
            var t = [];
            return this.forEach((function(e) {
                return t.push(e);
            })), t;
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "empty", {
        get: function() {
            return this.kf.docs.m();
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "size", {
        get: function() {
            return this.kf.docs.size;
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.forEach = function(t, e) {
        var n = this;
        G("QuerySnapshot.forEach", arguments, 1, 2), z("QuerySnapshot.forEach", "function", 1, t), 
        this.kf.docs.forEach((function(r) {
            t.call(e, n.Lf(r, n.metadata.fromCache, n.kf.Wt.has(r.key)));
        }));
    }, Object.defineProperty(t.prototype, "query", {
        get: function() {
            return new Ea(this.$f, this.yf, this.d_);
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.docChanges = function(t) {
        t && (Z("QuerySnapshot.docChanges", t, [ "includeMetadataChanges" ]), W("QuerySnapshot.docChanges", "boolean", "includeMetadataChanges", t.includeMetadataChanges));
        var e = !(!t || !t.includeMetadataChanges);
        if (e && this.kf.Kt) throw new I(b.INVALID_ARGUMENT, "To include metadata changes with your document changes, you must also pass { includeMetadataChanges:true } to onSnapshot().");
        return this.Mf && this.Of === e || (this.Mf = 
        /**
     * Calculates the array of DocumentChanges for a given ViewSnapshot.
     *
     * Exported for testing.
     *
     * @param snapshot The ViewSnapshot that represents the expected state.
     * @param includeMetadataChanges Whether to include metadata changes.
     * @param converter A factory function that returns a QueryDocumentSnapshot.
     * @return An object that matches the DocumentChange API.
     */
        function(t, e, n) {
            if (t.Qt.m()) {
                // Special case the first snapshot because index calculation is easy and
                // fast
                var r = 0;
                return t.docChanges.map((function(e) {
                    var i = n(e.doc, t.fromCache, t.Wt.has(e.doc.key));
                    return e.doc, {
                        type: "added",
                        doc: i,
                        oldIndex: -1,
                        newIndex: r++
                    };
                }));
            }
            // A DocumentSet that is updated incrementally as changes are applied to use
            // to lookup the index of a document.
            var i = t.Qt;
            return t.docChanges.filter((function(t) {
                return e || 3 /* Metadata */ !== t.type;
            })).map((function(e) {
                var r = n(e.doc, t.fromCache, t.Wt.has(e.doc.key)), o = -1, s = -1;
                return 0 /* Added */ !== e.type && (o = i.indexOf(e.doc.key), i = i.delete(e.doc.key)), 
                1 /* Removed */ !== e.type && (s = (i = i.add(e.doc)).indexOf(e.doc.key)), {
                    type: ka(e.type),
                    doc: r,
                    oldIndex: o,
                    newIndex: s
                };
            }));
        }(this.kf, e, this.Lf.bind(this)), this.Of = e), this.Mf;
    }, 
    /** Check the equality. The call can be very expensive. */ t.prototype.isEqual = function(e) {
        if (!(e instanceof t)) throw tt("isEqual", "QuerySnapshot", 1, e);
        return this.yf === e.yf && or(this.$f, e.$f) && this.kf.isEqual(e.kf) && this.d_ === e.d_;
    }, t.prototype.Lf = function(t, e, n) {
        return new va(this.yf, t.key, t, e, n, this.d_);
    }, t;
}(), Ta = /** @class */ function(e) {
    function n(t, n, r) {
        var i = this;
        if ((i = e.call(this, Hn(t), n, r) || this).Bf = t, t.length % 2 != 1) throw new I(b.INVALID_ARGUMENT, "Invalid collection reference. Collection references must have an odd number of segments, but " + t.R() + " has " + t.length);
        return i;
    }
    return t(n, e), Object.defineProperty(n.prototype, "id", {
        get: function() {
            return this.Ff.path._();
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(n.prototype, "parent", {
        get: function() {
            var t = this.Ff.path.h();
            return t.m() ? null : new la(new F(t), this.firestore, 
            /* converter= */ null);
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(n.prototype, "path", {
        get: function() {
            return this.Ff.path.R();
        },
        enumerable: !1,
        configurable: !0
    }), n.prototype.doc = function(t) {
        G("CollectionReference.doc", arguments, 0, 1), 
        // We allow omission of 'pathString' but explicitly prohibit passing in both
        // 'undefined' and 'null'.
        0 === arguments.length && (t = ot.k()), z("CollectionReference.doc", "non-empty string", 1, t);
        var e = V.g(t);
        return la.Rf(this.Ff.path.child(e), this.firestore, this.d_);
    }, n.prototype.add = function(t) {
        q("CollectionReference.add", arguments, 1);
        var e = this.d_ ? this.d_.toFirestore(t) : t;
        z("CollectionReference.add", "object", 1, e);
        var n = this.doc();
        // Call set() with the converted value directly to avoid calling toFirestore() a second time.
                return new la(n.f_, this.firestore, null).set(e).then((function() {
            return n;
        }));
    }, n.prototype.withConverter = function(t) {
        return new n(this.Bf, this.firestore, t);
    }, n;
}(Ea);

function Na(t, e) {
    if (void 0 === e) return {
        merge: !1
    };
    if (Z(t, e, [ "merge", "mergeFields" ]), W(t, "boolean", "merge", e.merge), function(t, e, n, r, i) {
        void 0 !== r && function(t, e, n, r, i) {
            if (!(r instanceof Array)) throw new I(b.INVALID_ARGUMENT, "Function " + t + "() requires its " + e + " option to be an array, but it was: " + X(r));
            for (var o = 0; o < r.length; ++o) if (!i(r[o])) throw new I(b.INVALID_ARGUMENT, "Function " + t + "() requires all " + e + " elements to be " + n + ", but the value at index " + o + " was: " + X(r[o]));
        }(t, e, n, r, i);
    }(t, "mergeFields", "a string or a FieldPath", e.mergeFields, (function(t) {
        return "string" == typeof t || t instanceof Au;
    })), void 0 !== e.mergeFields && void 0 !== e.merge) throw new I(b.INVALID_ARGUMENT, "Invalid options passed to function " + t + '(): You cannot specify both "merge" and "mergeFields".');
    return e;
}

function Aa(t, e) {
    return void 0 === e ? {} : (Z(t, e, [ "serverTimestamps" ]), Q(t, 0, "serverTimestamps", e.serverTimestamps, [ "estimate", "previous", "none" ]), 
    e);
}

function Sa(t, e) {
    B(t, "object", 1, e), e && (Z(t, e, [ "source" ]), Q(t, 0, "source", e.source, [ "default", "server", "cache" ]));
}

function Da(t, e, n) {
    if (e instanceof Fu) {
        if (e.firestore !== n) throw new I(b.INVALID_ARGUMENT, "Provided document reference is from a different Firestore instance.");
        return e;
    }
    throw tt(t, "DocumentReference", 1, e);
}

function ka(t) {
    switch (t) {
      case 0 /* Added */ :
        return "added";

      case 2 /* Modified */ :
      case 3 /* Metadata */ :
        return "modified";

      case 1 /* Removed */ :
        return "removed";

      default:
        return D();
    }
}

/**
 * Converts custom model object of type T into DocumentData by applying the
 * converter if it exists.
 *
 * This function is used when converting user objects to DocumentData
 * because we want to provide the user with a more specific error message if
 * their set() or fails due to invalid data originating from a toFirestore()
 * call.
 */ function xa(t, e, n) {
    // Cast to `any` in order to satisfy the union type constraint on
    // toFirestore().
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    return t ? n && (n.merge || n.mergeFields) ? t.toFirestore(e, n) : t.toFirestore(e) : e;
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ var La = /** @class */ function(e) {
    function n() {
        return null !== e && e.apply(this, arguments) || this;
    }
    return t(n, e), n.serverTimestamp = function() {
        M("FieldValue.serverTimestamp", arguments);
        var t = new Lu("serverTimestamp");
        return t.e_ = "FieldValue.serverTimestamp", new n(t);
    }, n.delete = function() {
        M("FieldValue.delete", arguments);
        var t = new ku("deleteField");
        return t.e_ = "FieldValue.delete", new n(t);
    }, n.arrayUnion = function() {
        for (var t = [], e = 0; e < arguments.length; e++) t[e] = arguments[e];
        j("FieldValue.arrayUnion", arguments, 1);
        var r = 
        /**
 * Returns a special value that can be used with {@link setDoc()} or {@link
 * updateDoc()} that tells the server to union the given elements with any array
 * value that already exists on the server. Each specified element that doesn't
 * already exist in the array will be added to the end. If the field being
 * modified is not already an array it will be overwritten with an array
 * containing exactly the specified elements.
 *
 * @param elements The elements to union into the array.
 * @return The `FieldValue` sentinel for use in a call to `setDoc()` or
 * `updateDoc()`.
 */
        function() {
            for (var t = [], e = 0; e < arguments.length; e++) t[e] = arguments[e];
            // NOTE: We don't actually parse the data until it's used in set() or
            // update() since we'd need the Firestore instance to do this.
                        return j("arrayUnion()", arguments, 1), new Ru("arrayUnion", t);
        }.apply(void 0, t);
        return r.e_ = "FieldValue.arrayUnion", new n(r);
    }, n.arrayRemove = function() {
        for (var t = [], e = 0; e < arguments.length; e++) t[e] = arguments[e];
        j("FieldValue.arrayRemove", arguments, 1);
        var r = function() {
            for (var t = [], e = 0; e < arguments.length; e++) t[e] = arguments[e];
            // NOTE: We don't actually parse the data until it's used in set() or
            // update() since we'd need the Firestore instance to do this.
                        return j("arrayRemove()", arguments, 1), new Ou("arrayRemove", t);
        }.apply(void 0, t);
        return r.e_ = "FieldValue.arrayRemove", new n(r);
    }, n.increment = function(t) {
        z("FieldValue.increment", "number", 1, t), q("FieldValue.increment", arguments, 1);
        var e = function(t) {
            return new Pu("increment", t);
        }(t);
        return e.e_ = "FieldValue.increment", new n(e);
    }, n.prototype.isEqual = function(t) {
        return this.l_.isEqual(t.l_);
    }, n;
}(Uu), Ra = {
    Firestore: ca,
    GeoPoint: Vu,
    Timestamp: mt,
    Blob: pt,
    Transaction: ha,
    WriteBatch: fa,
    DocumentReference: la,
    DocumentSnapshot: da,
    Query: Ea,
    QueryDocumentSnapshot: va,
    QuerySnapshot: _a,
    CollectionReference: Ta,
    FieldPath: Au,
    FieldValue: La,
    setLogLevel: ca.setLogLevel,
    CACHE_SIZE_UNLIMITED: ua
};

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Configures Firestore as part of the Firebase SDK by calling registerService.
 *
 * @param firebase The FirebaseNamespace to register Firestore with
 * @param firestoreFactory A factory function that returns a new Firestore
 *    instance.
 */
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Registers the main Firestore build with the components framework.
 * Persistence can be enabled via `firebase.firestore().enablePersistence()`.
 */
function Oa(t) {
    !function(t, e) {
        t.INTERNAL.registerComponent(new w("firestore", (function(t) {
            return function(t, e) {
                var n = new _u, r = new Eu(n);
                return new ca(t, e, r, n);
            }(t.getProvider("app").getImmediate(), t.getProvider("auth-internal"));
        }), "PUBLIC" /* PUBLIC */).setServiceProps(Object.assign({}, Ra)));
    }(t), t.registerVersion("@firebase/firestore", "1.18.0");
}

Oa(i);

export { Oa as __PRIVATE_registerFirestore };
//# sourceMappingURL=index.esm.js.map
;