<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Question extends Model
{
    protected $fillable = [
        "name","unit_id"
    ];

    public function getDashNameAttribute()
    {
        $attribute =  trans('language.notSelected');
        if ($this->name)
            $attribute = $this->name;
        return $attribute;
    }
     public function getDashUnitAttribute()
    {
        $attribute =  trans('language.notSelected');
        if ($this->unit)
            $attribute = $this->unit->dash_name;
        return $attribute;
    }
    
     public function unit()
    {
        return $this->belongsTo('App\Unit', 'unit_id');
    }
}
