<?php

namespace App;

use App\ModulesConst\UserVerify;
use Illuminate\Database\Eloquent\Model;

class Order extends Model
{
    protected $fillable = [
        'trainee_id',
        'user_id',
        'course_id',
        'country_id',
        'name',
        'mobile',
        'email',
        'identity',
        'qualification_id',
        'other',
       'paid',
        'status',
    ];
    public function getDashStatusNameAttribute()
    {
        if ($this->paid == UserVerify::yes) {
            return trans("language.paid");
        } else {
            return trans("language.not_paid");
        }
    }
//course
    public function getDashCourseAttribute()
    {
        $attribute =  trans('language.notSelected');
        if ($this->course)
            $attribute = $this->course->name;
        return $attribute;
    }

    public function getDashbreifAttribute()
    {
        $attribute =  trans('language.notSelected');
        if ($this->course)
            $attribute = $this->course->breif;
        return $attribute;
    }

    public function getDashImageAttribute()
    {
        $attribute =  trans('language.notSelected');
        if ($this->course)
            $attribute = $this->course->image;
        return $attribute;
    }
    public function getDashmeetingAttribute()
    {
        $attribute =  trans('language.notSelected');
        if ($this->course)
            $attribute = $this->course->meeting;
        return $attribute;
    }  public function getDashhostIdAttribute()
    {
        $attribute =  trans('language.notSelected');
        if ($this->course)
            $attribute = $this->course->hostId;
        return $attribute;
    }

    public function getDashmeetingIdAttribute()
    {
        $attribute =  trans('language.notSelected');
        if ($this->course)
            $attribute = $this->course->meeting_id;

        return $attribute;
    }

    public function getDashmeetingpasswordAttribute()
    {
        $attribute =  trans('language.notSelected');
        if ($this->course)
            $attribute = $this->course->meeting_password;
        return $attribute;
    }




    public function getDashLinkAttribute()
    {
        $attribute =  trans('language.notSelected');
        if ($this->course)
            $attribute = $this->course->link;
        return $attribute;
    }

    public function getDashUserAttribute()
    {
        $attribute =  trans('language.notSelected');
        if ($this->user)
            $attribute = $this->user->name;
        return $attribute;
    } public function getDashMobileAttribute()
    {
        $attribute =  trans('language.notSelected');
        if ($this->user)
            $attribute = $this->user->mobile;
        return $attribute;
    }

    public function getDashMarkterAttribute()
    {
        $attribute =  "تم التسجيل من خلال الموقع";
        if ($this->markter)
            $attribute = $this->markter->name;
        return $attribute;
    }


    public function getDashCodeAttribute()
    {
        $attribute =  trans('language.notSelected');
        if ($this->country)
            $attribute = $this->country->code;
        return $attribute;
    }
    public function markter()
    {
        return $this->belongsTo('App\User', 'user_id');
    }
    public function user()
    {
        return $this->belongsTo('App\User', 'trainee_id');
    }

    public function course()
    {
        return $this->belongsTo('App\Course', 'course_id');
    }  public function country()
    {
        return $this->belongsTo('App\Country', 'country_id');
    }
}
