<?php

namespace App\Listeners;

use App\Events\MeetingCreationEvent;
use App\Mail\MeetingCreationEmail;
use App\Order;
use App\User;
use Illuminate\Support\Facades\Mail;

class MeetingCreationListener
{
    private array $mails = array();

    public function handle(MeetingCreationEvent $event)
    {
        $course = $event->course;
        $ids = Order::whereCourseId($course->id)->where('paid',1)->pluck('trainee_id')->toArray();
        //dd($ids);
        $this->mails =  User::whereIn('id', $ids)->pluck('email')->toArray();

       /* if ($email = $course->trainer->user->email)*/
            array_push($this->mails/*, $email*/);

        Mail::to($this->mails)->send(new MeetingCreationEmail($event->course, $event->meeting));
    }
}
