<?php

namespace App\Http\Controllers\Site\Search;

use App\Categories;
use App\City;
use App\Course;
use App\Distrct;
use App\ModulesConst\Paginate;
use App\Product;
use App\Regoin;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class IndexController extends Controller
{
    public function index(Request $request)
    {
        $request->validate([
            "keyword" => "",
        ]);
        $date = Carbon::now()->format('Y-m-d');
        $items = Course::where("end_date", '>=',$date)->where('active',1);


        if ($request->keyword) {
            $items = $items->where('name', 'LIKE', "%$request->keyword%");
        }

        $items = $items->orderBy("id", "desc")->paginate(9);
        return view("site.search.index", compact("items"));

    }

}
