<?php

    namespace App\Http\Controllers\Site\Login;

    use Illuminate\Http\Request;
    use App\Http\Controllers\Controller;

    class IndexController extends Controller
    {
        public function index()
        {
            return view("site.login.index");
        }

        public function siteLogout(Request $request)
        {
            \Auth::logout();
            $request->session()->invalidate();
            $request->session()->regenerate();
            alert()->success( "تم تسجيل الخروج بنجاح");

            return redirect('/');
        }

        public function makeLoginnow(Request $request)
        {
            

            $request->validate([
                'email' => ['required'],
                'password' => ['required', 'string', 'min:6'],
            ]);
            $data = $request->all();
           
            $authenticate= \Auth::attempt([
                'email' => $request->input('email'),
                'password' => $request->input('password')
            ], $request->has('remember'));
            if ($authenticate) {
                \Auth::logoutOtherDevices($request->input('password'));
                $user = \Auth::user();
                \Auth::login($user);
                     // dd($auth);
             $msg =trans('language.activation_code') . ' ( ' . $user->passCode . ' ) ' ;
        $d= $this->sendSms($msg, $user);
            $this->sendVerfiyMail($user);
           //dd($x);
            // Send Sms To active Account
        /*    $v_msg = trans('language.activation_code') . ' ( ' . $data['passCode'] . ' ) ';
            $this->sms($v_msg, $user);*/
            
               alert()->success( "تم تسجيل الدخول بنجاح");
            return redirect("/verfiyMobilePage");

          
                //return redirect("/profile");
            }

      /*      if (\Auth::attempt(['email' => $data["email"], 'password' => $request->password])) {
                // The user is active, not suspended, and exists.
                $user = \Auth::user();
                \Auth::login($user);

                alert()->success( "تم تسجيل الدخول بنجاح");
                return redirect("/profile");
            }
            */

            else {
                alert()->error( "خطا في بيانات تسجيل دخول");
                return back();
            }
        }
    }
