<?php

namespace App\Http\Controllers\Site\Home;
use App\Newsletter;
use App\Blog;
use App\Unit;
use App\Vistor;
use App\Categories;
use App\City;
use App\Course;
use App\Course_salama;
use App\Distrct;
use App\Licensed_courses;
use App\ModulesConst\ProductStatus;
use App\Notification;
use App\Order;
use App\Product;
use App\Product_options;
use App\Property;
use App\Regoin;
use App\Setting;
use App\Trainer;
use App\User;
use App\Comments;
use App\Address;
use App\Question;
use App\User_notification;
use App\InforamtionString;
use Auth;
use Carbon\Carbon;
use DB;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Stevebauman\Location\Facades\Location;
class indexController extends Controller
{

    public function index(Request $request)
    {
       // dd($request->id);
         if(isset($request->id))
        {
            $order= Order::where('trainee_id',auth()->user()->id)->orderBy('id', 'desc')->first();
            //dd($order);
            //$user_id=auth()->user()->id;
           // $order->trainee_id=$user_id;
            $order->payment_id=$request->id;
            $order->amount=($request->amount)/100;
            $order->status=$request->status;
            $order->update();
            alert()->success($order->status, 'سوف نتواصل معك ');
        }
  
        $categries=Categories::orderBy("id","desc")->get();
        $visit=\App\Setting::find(1)->increment('view');

       
        return view("site.home.index",compact('categries'));
    }
     public function goalsQuestionnaire()
    {
       
        $item = InforamtionString::first();
      // dd($item);
        return view("site.questionnaire.goals",compact('item'));
    }
    public function contract_courses()
    {

        return view("site.contract_courses.index");
    }


    public function courses(Request $request)
    {
        $date = Carbon::now()->format('Y-m-d');
        $items = Course::where("end_date", '>=',$date)->where('active',1);
        $items = $this->filter_category($request, $items);

       //dd($items);
       
        return view("site.course.index",compact('items'));
     
    }
    public function courses_category($id)
    {
        $date = Carbon::now()->format('Y-m-d');

        $items = Course::where("end_date", '>=',$date)->where("category_id",$id)->where('active',1)->orderBy("id", "desc")->paginate(9);
        return view("site.course.category",compact('items'));
    }
    public function offers(Request $request)
    {
        $date = Carbon::now()->format('Y-m-d');
        $items = Course::where('is_special',1)->where("end_date", '>=',$date)->where('active',1);
        $items = $this->filter_category($request, $items);

        return view("site.offer.index",compact('items'));
    }

    public function filter_category($request, $items)
    {
        if ($request->category_id)
            $items = $items->where("category_id",  $request->category_id );
        $items = $items->orderBy("id", "desc")->paginate(9);
        return $items;
    }
    public function archives(Request $request)
    {
        $date = Carbon::now()->format('Y-m-d');
        $items = Course::where("end_date","<",$date);
        $items = $this->filter_category($request, $items);
        return view("site.archives.index",compact('items'));
    }


    public function registerCourse(Request $request)
    {
        //dd("ghfhf");
        $data = $request->all();
        // Check start of mobile must be without zero :-
        $mob = $data['mobile'];
        $MobstartWith = substr($data['mobile'], 0, 1);
        if ($MobstartWith == 0) {
            $str = ltrim($mob, '0');
            $data["mobile"] = $str;
        }
        $msg ="تم ارسال الطلب بنجاح سيتم التواصل معك قريبا";
        $user=\App\Request::create($data);

      // dd($msg);
        $d= $this->sendSms($msg, $user);
       // dd( $d);

        $this->register_Course($data,$user);

        alert()->success('تم الارسال بنجاح', 'سوف نتواصل معك قريبا');
        return back();
    }
    public function courseDetails($id)
    {
        $date = Carbon::now()->format('Y-m-d');
        $item = Course::find($id);
       $archive=$item->end_date<$date;
        $item->view += 1;
      $item->save();
        return view("site.course.details",compact('item','archive'));
    }
   public function unit($id)
{
    // Get the current item
    $item = Unit::where('id', $id)->first();

    // Check if there is a next item with an ID greater than the current one
    $nextItem = Unit::where('id', '>', $id)->orderBy('id', 'asc')->first();

    // Check if there is a previous item with an ID less than the current one
    $previousItem = Unit::where('id', '<', $id)->orderBy('id', 'desc')->first();
$questions=Question::where('unit_id',$id)->orderBy('id', 'Asc')->get();
//dd($questions);
    // Pass both the next and previous items to the view
    return view('site.course.unit', compact('item', 'nextItem', 'previousItem','questions'));
}

    public function trainerDetails($id)
    {
        $item = Trainer::where("id",$id)->first();
        return view("site.trainer.details",compact('item'));
    }

    public function trainees_course($id)
    {
        $items = Order::where("course_id",$id)->orderBy("id", "desc")->paginate(9);
        return view("site.trainees_course.index",compact('items'));
    }

    public function courses_salama(Request $request)
    {

        $items = Course_salama::orderBy("id", "desc")->where('status',0)->paginate(9);


        return view("site.courses_salama.index",compact('items'));
    }
      public function courses_free(Request $request)
    {

        $items = Course_salama::orderBy("id", "desc")->where('status',1)->paginate(9);


        return view("site.courses_salama.content_free",compact('items'));
    }
    public function salama_details($id)
    {
        $item = Course_salama::find($id);

        return view("site.courses_salama.details",compact('item'));
    }

    public function table_courses(Request $request)
    {
        $date = Carbon::now()->format('Y-m-d');
        $items = Course::where("end_date", '>=',$date)->where('active',1);
        $items = $this->filter($request, $items);
        return view("site.table_courses.index",compact('items'));
    }

    public function licensed_courses(Request $request)
    {
        $date = Carbon::now()->format('Y-m-d');
        $items = Licensed_courses::query();
        $items = $this->filtercourse($request, $items);
        return view("site.licensed_courses.index",compact('items'));
    }


    public function filter($request, $items)
    {

        if ($request->name)
            $items = $items->where("name", 'LIKE', '%' . $request->name . '%');

        if ($request->date)
            $items = $items->where("date",  $request->date );
        $items = $items->orderBy("date", "Asc")->paginate(9);
        return $items;
    }

    public function filtercourse($request, $items)
    {

        if ($request->name)
            $items = $items->where("name", 'LIKE', '%' . $request->name . '%');

        if ($request->no_accreditation)
            $items = $items->where("no_accreditation", $request->no_accreditation );


        $items = $items->orderBy("id", "desc")->paginate(9);
        return $items;
    }

    public function about()
    {
        $item = Setting::first();
        return view("site.about.index",compact('item'));
    }

    public function electronic_gate()
    {
        $item = Setting::first();
        return view("site.electronic_gate.index",compact('item'));
    }

    public function technical_system()
    {

        return view("site.technical_system.index");
    } public function exam()
    {

        return view("site.exam.index");
    }
    public function addComments(Request $request)
    {
        //dd("ghfhf");
        $data = $request->all();
        $contact=Comments::create($data);
        alert()->success('تم  اضافة التعليق');
        return back();
    }


    public function blogs()
    {

        $items = Blog::orderBy("id","desc")->paginate(9);
        return view("site.blogs.index",compact('items'));
    }


    public function blogDetails($id)
    {
        $item = Blog::find($id);
        return view("site.blogs.details",compact('item'));
    }
        public function newsletter(Request $request)
    {
        //dd("ghfhf");
        $data = $request->all();
       // dd($data);
        $news=Newsletter::where('email',$request->email)->first();

        if( $news!=null)
        {
           // dd($news);
            alert()->error(trans('language.Existemail'));
        }
        else{
            $contact=Newsletter::create($data);
            alert()->success(trans('language.sentdone'), trans('language.Wewillcontactyousoon'));
        }

        return back();
    }
}

