<?php

namespace App\Http\Controllers\Admin\Zoom;

use App\Course;
use App\Events\MeetingCreationEvent;
use App\Http\Controllers\Controller;
use App\MeetingRoom;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\View\View;
use Auth;

class ZoomController extends Controller
{
    public function create(): View
    {
        $date = Carbon::now()->format('Y-m-d');
        $user=Auth::user()->id;
      if ($user==1)
      {
          $courses = Course::where("end_date", '>=',$date)->get();
      }
      else
      {
          $courses = Course::where("end_date", '>=',$date)->where('coordinator_id',$user)->get();
      }

        $rooms = MeetingRoom::all();
        return view('admin.zoom.create', compact('courses', 'rooms'));
    }

    public function generateMeeting(Request $request): View
    {
        $room = json_decode($request->get('room'));
   //   dd($room->host_id);
        $course = Course::with('trainer.user')->findOrFail($request->get('course_id'));
    // dd($course);
        $res = createZoomMeeting($room->host_id, $room->jwt, $request->all())['response'];
       // dd($res);

       
        event(new MeetingCreationEvent($course, $res));
       
        $course->meeting = 1;
        $course->hostId = $res->host_id;
        $course->meeting_id =$res->id;
        $course->meeting_password = $res->password ;
        $course->save();
//dd($course);
        return view('admin.zoom.details', $this->getMeetingDetails($course, $res));
    }

    private function getMeetingDetails($course, $res): array
    {
       // dd($res);
        return [
            'course_name' => $course->name,
            'meeting_id' => $res->id,
            'meeting_host_id' => $res->host_id,
            'meeting_topic' => $res->topic,
            'meeting_password' => $res->password,
            'meeting_url' => $res->join_url,
            'meeting_duration' => $res->duration,
            'meeting_start_time' => $res->start_time,
        ];

    }
}
