<?php

namespace App\Http\Controllers\Admin\Question;

use App\Question;
use App\Unit;
use App\Open_screen;
use App\Slider;
use App\Http\Traits\storeImage;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class IndexController extends Controller
{

    use storeImage;

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $items = Question::orderBy('id', 'desc')->paginate(10);
        return view('admin.Questions.index', compact('items'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.Questions.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->validate([
            'name' => 'required',
            'unit_id' => 'required',
        ]);

        Question::create($data);
        session()->flash('success', trans('language.done'));
        return redirect(url('/admin/Questions'));
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $item = Question::findOrFail($id);
        return view('admin.Questions.edit', compact('item'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $item = Question::findOrFail($id);
        $data = $request->validate([
            'name' => '',
              'unit_id' => '',
        ]);

        $item->update($data);
        session()->flash('success', trans('language.done'));
        return redirect(url('/admin/Questions'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Question::findOrFail($id)->delete();
        session()->flash('success', trans('language.done'));
        return redirect(url('/admin/Questions'));
    }
}
