<?php

namespace App\Http\Controllers\Admin\Email;
 use App\ModulesConst\UserTyps;
use App\User;
use App\Events\MeetingCreationEvent;
use App\Http\Controllers\Controller;
use App\MeetingRoom;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\View\View;
use Auth;
use App\Mail\sendEmail;
use Illuminate\Support\Facades\Mail;

class EmailController extends Controller
{
    public function create(): View
    {
       
        $users = User::where('user_type_id', UserTyps::user)->orderBy("id", "desc")->get();
        return view('admin.email.create', compact('users'));
    }

public function generateEmail(Request $request)
{
    $request->validate([
        'useremail' => 'required|email',
        'title' => 'required|string',
        'messageContent' => 'required|string',
    ]);

    $useremail = $request->input('useremail');
    $title = $request->input('title');
    $messageContent = $request->input('messageContent');

    Mail::to($useremail)->send(new sendEmail($title, $messageContent));

    return redirect()->back()->with('success', 'Email sent successfully!');
}

   
}
