<?php

namespace App\Http\Controllers\Admin\Courses_salama;
use App\Course_salama;
use Carbon\Carbon;
use Auth;
use App\Course;
use App\Http\Traits\storeImage;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class IndexController extends Controller
{


    use storeImage;

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $items = Course_salama::orderBy('id', 'desc')
        ->where('status',0)->paginate(10);
        return view('admin.courses_salama.index', compact('items'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.courses_salama.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->validate([
            'image' => 'required',
            'whatsapp' => 'required',
            'google_link' => 'required',
            'text' => '',
        ]);
        if ($request->image) {
            $data['image'] = $this->storeImage($request->image);
        }
        Course_salama::create($data);
        session()->flash('success', trans('language.done'));
        return redirect(url('/admin/courses_salama'));
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $item = Course_salama::findOrFail($id);
        return view('admin.courses_salama.edit', compact('item'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $item = Course_salama::findOrFail($id);
        $data = $request->validate([
            'image' => '',
            'whatsapp' => '',
            'google_link' => '',
            'text' => '',
        ]);
        if ($request->image) {
            $data['image'] = $this->storeImage($request->image);
        }
        $item->update($data);
        session()->flash('success', trans('language.done'));
        return redirect(url('/admin/courses_salama'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Course_salama::findOrFail($id)->delete();
        session()->flash('success', trans('language.done'));
        return redirect(url('/admin/courses_salama'));
    }
}
