<?php

namespace App\Http\Controllers\Admin\Course;

use App\Course;
use App\CourseImages;

use App\Http\Traits\storeImage;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class CoursesImagesController extends Controller
{ use storeImage;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index($id)
    {
        $items = CourseImages::where('course_id', $id)->orderBy('id', 'desc')->paginate(10);
        $course_id = $id;
       // dd($type);

        return view('admin.courses.images.index', compact('items','course_id'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($course_id)
    {
        $course = Course::findorfail($course_id);
        //dd( $product);
        return view('admin.courses.images.create',compact('course'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request,$course_id)
    {
        $data = $request->validate([
            'image' => 'required',

        ]);
        if ($data['image']) {
            $data['image'] = $this->storeImage($data['image']);
        }
        $data["course_id"] = $course_id;
        CourseImages::create($data);
        session()->flash('success', trans('language.done'));
        return redirect("admin/courses/$course_id/images");
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($course_id,$id)
    {
        $item = CourseImages::findOrFail($id);
        $item->delete();
        session()->flash('success', trans('language.done'));
        return redirect("admin/courses/$course_id/images");
    }
}
