<?php

namespace App\Http\Controllers\Admin\Blog;
use Carbon\Carbon;
use Auth;
use App\Blog;
use App\Http\Traits\storeImage;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class IndexController extends Controller
{

    use storeImage;

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {

        $items = Blog::query();

        $items = $this->filter($request, $items);
        return view('admin.blogs.index', compact('items'));
    }



    public function filter($request, $items)
    {

        if ($request->name)
            $items = $items->where("title_ar", 'LIKE', '%' . $request->title_ar . '%');
        $items = $items->orderBy("id", "desc")->paginate(10);
        //dd($items);

        return $items;
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.blogs.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->all();

        $course = Blog::create($data);

        session()->flash('success', trans('language.done'));
        return redirect(url('/admin/blogs'));
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $item = Blog::findOrFail($id);
        //dd($item);
        return view('admin.blogs.edit', compact('item'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $item = Blog::findOrFail($id);
        $data = $request->all();
        //dd($data);

        $item->update($data);

        session()->flash('success', trans('language.done'));
        return redirect(url('/admin/blogs'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Blog::findOrFail($id)->delete();
        session()->flash('success', trans('language.done'));
        return redirect(url('/admin/blogs'));
    }
}
