<?php

namespace App\Exports;

use App\User;
    use Maatwebsite\Excel\Concerns\FromCollection;
    use Maatwebsite\Excel\Concerns\WithHeadings;
    use Maatwebsite\Excel\Concerns\WithMapping;

class UsersExport implements FromCollection,  WithMapping, WithHeadings

{
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
        {
          
         $users=User::where('user_type_id',2)->orderBy("id", "desc")->get();
            return $users;

        }

        public function map($users): array
        {
            $data["name"] = $users->name;
            $data["mobile"] = $users->mobile;
            $data["email"] = $users->email;
            

            // mediator data :-
            return $data;
        }

        public function headings(): array
        {
            return [
                [
                    trans('language.client_name'),
                    trans('language.mobile'),
                    trans('language.email'),
                
                ],
            ];
        }
}
