<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class CourseImages extends Model
{
    protected $fillable = ["course_id", "image"];

    public function toArray()
    {
        $data['id'] = $this->id;
        $data['image'] = $this->serv_image;
        return $data;
    }

    function getServImageAttribute()
    {
        if ($this->image) {
            return ($this->image);
        } else {
            return asset('assets/admin/images/default.png');
        }
    }


    //dashboard
    public function  getDashImageAttribute()
    {
        $attribute = asset('assets/admin/images/favicon.png');
        if ($this->image)
            $attribute = $this->image;
        return $attribute;
    }

}
