<?php

namespace App;

use App\ModulesConst\UserVerify;
use Illuminate\Database\Eloquent\Model;

class Course extends Model
{
    protected $guarded=['id'];

      public function getDashdateAttribute()
    {
        $your_date = $this->date; // The Current Date
        $time = date("d-M-Y", strtotime($this->date));
        $months = [ "Jan",  "Feb", "Mar", "Apr", "May", "Jun", "Jul" , "Aug" , "Sep" , "Oct" , "Nov" , "Dec"];
        $months1 = ["يناير", "فبراير" , "مارس", "أبريل" , "مايو" , "يونيو" , "يوليو" ,"أغسطس","سبتمبر","أكتوبر","نوفمبر","ديسمبر"];




       return $time;
      //return str_replace($months, $en_month);
       //return str_replace($months, $months1, $time);
    }



    public function getDashConfirmAttribute()
    {
        if ($this->confirm == UserVerify::yes) {
            return trans("language.confirm_courses");
        } else {
            return trans("language.not_confirm_courses");
        }
    }
     public function getDashCityAttribute()
    {
        $attribute ="الرياض - المملكة العربية السعودية";
        if ($this->city)
            $attribute = $this->city;
        return $attribute;
    }
        public function getDashlangAttribute()
    {
        $attribute =" العربية";
        if ($this->lang)
            $attribute = $this->lang;
        return $attribute;
    }

    public function getDashYoutubeAttribute()
    {
        $attribute ="https://www.youtube.com/embed/QnoOuu_ouEc";
        if ($this->link_youtube)
            $attribute = $this->link_youtube;
        return $attribute;
    }
      public function getDashNameAttribute()
    {
        $attribute =  trans('language.notSelected');
        if ($this->name)
            $attribute = $this->name;
        return $attribute;
    }

    public function getTrainerNameAttribute()
    {
        $attribute =  trans('language.notSelected');
        if ($this->trainer)
            $attribute = $this->trainer->dash_name;
        return $attribute;
    }
    public function getTrainerImageiconAttribute()
    {
        $attribute = asset("/assets/site/images/logo.png");
        if ($this->trainer)
            $attribute = $this->trainer->DashImage;
        return $attribute;
    }
    public function getCurrentPositiontrainerAttribute()
    {
        $attribute =  trans('language.notSelected');
        if ($this->trainer)
            $attribute = $this->trainer->DashCurrentPosition;
        return $attribute;
    }
    public function category()
    {
        return $this->belongsTo('App\Category', 'category_id');
    }

    public function trainer()
    {
        return $this->belongsTo('App\Trainer', 'trainer_id');
    }
}
