<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class AdvertisementStatus extends Model
{
    protected $fillable = [
        'id',
        'name_en',
        'name_ar',
        'type',
    ];

    public function toArray()
    {
        $data['id'] = $this->id;
        $data['name'] = $this->Serv_name;
        return $data;
    }

    public function getServNameAttribute()
    {
        if (\request()->lang == "en")
            return $this->name_en;
        else
            return $this->name_ar;
    }

    public function getDashNameAttribute()
    {
        if (app()->getLocale() == "en")
            return $this->name_en;
        else
            return $this->name_ar;
    }
}
